package org.netbeans.modules.openoffice;



import java.io.IOException;	
import java.io.ObjectInput;	
import java.io.ObjectOutput;

import org.openide.options.SystemOption;	
import org.openide.util.HelpCtx;	
import org.openide.util.NbBundle;	
import org.openide.util.SharedClassObject;	


public class OOIDLGlobalSettings extends SystemOption {
    
    public OOIDLGlobalSettings() {
    }
    
    protected void initialize() {
        super.initialize();
    }
    
    public static OOIDLGlobalSettings getDefault() {
        return ( OOIDLGlobalSettings ) SharedClassObject.findObject( 
        OOIDLGlobalSettings.class );
    }
    
    public String displayName() {
        return "OpenOffice.org SDK global settings";
    }
    
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
    
    public String getSDKDirectory() {
        return ( String ) getProperty( NbBundle.getMessage( 
        OOIDLGlobalSettings.class,
        "PROP_sdk_directory") );
    }
    
    public void readExternal( ObjectInput objectinput )
    throws IOException, ClassNotFoundException {
        super.readExternal( objectinput );
        setSDKDirectory( ( String ) objectinput.readObject() );
        setOfficeDirectory( ( String ) objectinput.readObject() );
    }
    
    public void setSDKDirectory( String stringSDKDirectory ) {
        putProperty( NbBundle.getMessage( OOIDLGlobalSettings.class,
        "PROP_sdk_directory"), stringSDKDirectory, true );
    }
    
    public void writeExternal( ObjectOutput objectoutput )
    throws IOException {
        super.writeExternal( objectoutput );
        objectoutput.writeObject( getSDKDirectory() );
        objectoutput.writeObject( getOfficeDirectory() );
    }
    
    public String getOfficeDirectory() {
        return ( String ) getProperty(
        NbBundle.getMessage( OOIDLGlobalSettings.class,
        "PROP_office_directory") );
    }
    
    public void setOfficeDirectory(String stringOfficeDirectory) {
        putProperty( NbBundle.getMessage( OOIDLGlobalSettings.class,
        "PROP_office_directory"), stringOfficeDirectory, true );
    }
}
