/*
 * OperationPanel.java
 *
 * Created on August 15, 2002, 2:27 PM
 */

package org.netbeans.modules.openoffice.wizard.panels.idl;

import javax.swing.event.DocumentListener;
import javax.swing.event.ChangeListener;
import java.util.ResourceBundle;
import org.openide.DialogDescriptor;
import java.awt.event.ActionListener;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.Dialog;
import org.openide.TopManager;
import org.openide.src.MemberElement;
import org.openide.src.SourceException;
import org.netbeans.modules.openoffice.wizard.panels.idl.ParameterPanel.ElementCreator;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.openide.util.NbBundle;

/**
 *
 * @author  Bertram Nolte
 */
public class OperationPanel 
extends org.netbeans.modules.openoffice.wizard.panels.idl.BasePanel 
implements DocumentListener, ChangeListener, ElementCreator {
    
    private ParameterPanel parameterpanel;
    private Dialog dialog;
    private int newElementCount = 0;
    private ParameterElement[] parameterelements;
    private static ResourceBundle bundle = 
    NbBundle.getBundle(ParameterPanel.class);
    private static final MessageFormat METHOD_NAME_FORMAT = 
        new java.text.MessageFormat( 
        bundle.getString( "FMT_NewParameterName" ) );
    
    /** Creates new form OperationPanel */
    public OperationPanel() {
        initComponents();
        postInitComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jlabelName = new javax.swing.JLabel();
        jtextfieldName = new javax.swing.JTextField();
        jlabelReturnType = new javax.swing.JLabel();
        jtextfieldReturnType = new javax.swing.JTextField();
        jlabelParameter = new javax.swing.JLabel();
        jtextfieldParameter = new javax.swing.JTextField();
        jbuttonParameter = new javax.swing.JButton();
        jlabelExceptions = new javax.swing.JLabel();
        jtextfieldExceptions = new javax.swing.JTextField();
        jcheckboxOneWay = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(1, 1, 1, 1)));
        jlabelName.setText(ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("TXT_ModuleName"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(jlabelName, gridBagConstraints);

        jtextfieldName.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("TIP_OperationName"));
        jtextfieldName.setPreferredSize(new java.awt.Dimension(150, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 4, 1);
        add(jtextfieldName, gridBagConstraints);

        jlabelReturnType.setText("Return Type:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(jlabelReturnType, gridBagConstraints);

        jtextfieldReturnType.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("TIP_OperationRetType"));
        jtextfieldReturnType.setPreferredSize(new java.awt.Dimension(150, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(jtextfieldReturnType, gridBagConstraints);

        jlabelParameter.setText("Parameters:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(jlabelParameter, gridBagConstraints);

        jtextfieldParameter.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("TIP_OperationParams"));
        jtextfieldParameter.setPreferredSize(new java.awt.Dimension(150, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(jtextfieldParameter, gridBagConstraints);

        jbuttonParameter.setText("...");
        jbuttonParameter.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("TIP_OperationEditParameter"));
        jbuttonParameter.setVisible( false );
        jbuttonParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbuttonParameterActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(jbuttonParameter, gridBagConstraints);

        jlabelExceptions.setText("Exceptions:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(jlabelExceptions, gridBagConstraints);

        jtextfieldExceptions.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("TIP_OperationExceptions"));
        jtextfieldExceptions.setPreferredSize(new java.awt.Dimension(150, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(jtextfieldExceptions, gridBagConstraints);

        jcheckboxOneWay.setText("oneway");
        jcheckboxOneWay.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("TIP_OperationOneway"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(jcheckboxOneWay, gridBagConstraints);

    }//GEN-END:initComponents

    private void jbuttonParameterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbuttonParameterActionPerformed
        parameterpanel = new ParameterPanel( this );
        
        DialogDescriptor exdialogdescriptor = new DialogDescriptor(
        parameterpanel, ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_Customize"));
        exdialogdescriptor.setButtonListener( new ActionListener() {
            
            
            public void actionPerformed(ActionEvent actionevent) {
//                if(actionevent.getActionCommand().equals("OK"))
//                    ec.reInit(memberlistpanel);
                dialog.setVisible(false);
                dialog.dispose();
            }
            
        });
        
        dialog = TopManager.getDefault().createDialog(exdialogdescriptor);
        dialog.setVisible(true);
        // Add your handling code here:
    }//GEN-LAST:event_jbuttonParameterActionPerformed
    
    public void changedUpdate(javax.swing.event.DocumentEvent documentEvent) {
    }
    
    public void insertUpdate(javax.swing.event.DocumentEvent documentEvent) {
    }
    
    public void removeUpdate(javax.swing.event.DocumentEvent documentEvent) {
    }
    
    public void stateChanged(javax.swing.event.ChangeEvent changeEvent) {
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jlabelParameter;
    private javax.swing.JCheckBox jcheckboxOneWay;
    private javax.swing.JLabel jlabelName;
    private javax.swing.JLabel jlabelReturnType;
    private javax.swing.JLabel jlabelExceptions;
    private javax.swing.JTextField jtextfieldName;
    private javax.swing.JButton jbuttonParameter;
    private javax.swing.JTextField jtextfieldReturnType;
    private javax.swing.JTextField jtextfieldExceptions;
    private javax.swing.JTextField jtextfieldParameter;
    // End of variables declaration//GEN-END:variables
    
    private void postInitComponents() {
        jtextfieldName.getDocument().addDocumentListener( this );
        jtextfieldReturnType.getDocument().addDocumentListener( this );
        //        jtextfieldParameter.getDocument().addDocumentListener( this );
        
        jtextfieldExceptions.getDocument().addDocumentListener( this );
        jcheckboxOneWay.addChangeListener( this );
    }
    
    public String getName() {
        return jtextfieldName.getText().trim();
    }
    
    public void setName( String s ) {
        jtextfieldName.setText( s );
    }
    
    public String getReturnType() {
        return jtextfieldReturnType.getText().trim();
    }
    
    public void setReturnType( String s ) {
        jtextfieldReturnType.setText( s );
    }
    
    public String getParameters() {
        return jtextfieldParameter.getText().trim();
    }
    
    public void setParameters( String s ) {
        jtextfieldParameter.setText( s );
    }
    
    public String getExceptions() {
        return jtextfieldExceptions.getText().trim();
    }
    
    public void setExceptions( String s ) {
        jtextfieldExceptions.setText( s );
    }
    
    public boolean isOneway() {
        return jcheckboxOneWay.isSelected();
    }
    
    public void setOneway(boolean flag) {
        jcheckboxOneWay.setSelected( flag );
    }

    public ParameterElement createElement() throws SourceException {
        ParameterElement parameterelement = new ParameterElement();
        createName( parameterelement );
        return parameterelement;
    }
    
    public void deleteElement(ParameterElement el) throws SourceException {
    }
    
    public ParameterElement duplicateElement(ParameterElement template) throws SourceException {
        ParameterElement el;
//        try {
            el = (ParameterElement)template.clone();
            createName(el);
//        }
//        catch (java.lang.CloneNotSupportedException ex) {
//            System.err.println(ex);
//            el = (ParameterElement)createElement();
//        }
//        wizardData.getCustomizedClass().addField(el);
//        created = wizardData.getCustomizedClass().getField(el.getName());
        return el;
    }

    public boolean canDelete(ParameterElement el) {
        return !containsOriginal((ParameterElement)el);
    }

    private void createName(ParameterElement el) throws SourceException {
        String name = METHOD_NAME_FORMAT.format(
                new Object[] {
                    new Integer(newElementCount)
                });
        el.setName(name);
        newElementCount++;
    }

    private boolean containsOriginal(ParameterElement m) {
        ParameterElement[] me = parameterelements;
        for (int i = 0; i < me.length; i++) {
            if ( m.getName().equals( me[i].getName() ) )
                return true;
        }
        return false;
    }

    
}
