/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: compat.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 15:56:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef GCC
#pragma hdrstop
#endif

#include "compat.hxx"

#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif

#ifndef _DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif



SfxPointerServer::SfxPointerServer()
{
	pCache=0;
	pLast=aPointers+SFX_POINTER_SIZE;
	nObjectCount = 0;
}


SfxPointerServer::~SfxPointerServer()
{
}


SfxPointerServer* SfxPointerServer::GetServer()
{
	SfxPointerServer** ppSrv=(SfxPointerServer**)GetAppData(SHL_SFC);
	if(!*ppSrv)
	{
		*ppSrv=new SfxPointerServer();
		DBG_WARNING("SfxPointerServer alloziiert");
	}
	return *ppSrv;
}

void SfxPointerServer::ReleaseServer()
{
	SfxPointerServer** ppSrv=(SfxPointerServer**)GetAppData(SHL_SFC);
	*ppSrv=0;
	DBG_WARNING("SfxPointerServer released");
}




BOOL SfxPointerServer::HasPointer(const void *pObj)
{
	if(pCache==pObj)
		return 1;
	SfxPointerEntry *pEntry=aPointers;
	do
	{
		if(pEntry->pObject==pObj)
			return TRUE;
	}
	while(++pEntry<pLast);
	return FALSE;
}



void * SfxPointerServer::GetPointer(const void *pObj)

/*  [Beschreibung]

	Holt den dem Object gehoerenden Pointer aus dem Array
*/

{
	if(pCache==pObj) return pCachePtr;
	SfxPointerEntry *pEntry=aPointers+MakeHash(pObj);
	SfxPointerEntry* pHashed = pEntry;
	do
	{
		if( pEntry - aPointers == SFX_POINTER_SIZE )
			pEntry = aPointers;
		if(pEntry->pObject==pObj)
		{
			pCache=pObj;
			return pCachePtr=pEntry->pPointer;
		}
	}
	while( ++pEntry != pHashed );

	DBG_ERROR("SfxPointerSever Overflow");
	return 0;
}



void **SfxPointerServer::CreatePointer( const void *pObj)

/*  [Beschreibung]

	Gibt einen Pointer auf den fuer den pObj reservierte
	Impl Pointer zurueck.
*/

{
	DBG_ASSERT(this, "Statisches Object benutzt SfxPointerServer");
	nObjectCount++;
	SfxPointerEntry *pEntry=aPointers+MakeHash(pObj);
	SfxPointerEntry* pHashed = pEntry;
	do
	{
		if( pEntry - aPointers == SFX_POINTER_SIZE )
			pEntry = aPointers;
		if(!pEntry->pObject||pEntry->pObject==pObj)
			//Diesen auch nehmen, wenn der this Pointer zum 2. mal kommt.
			//Fuer Klassen ohne Destruktor.
		{
			pEntry->pObject=pObj;
			return &pEntry->pPointer;
		}
	}
	while( ++pEntry != pHashed );

	nObjectCount--;
	DBG_ERROR("SfxPointerSever Object nicht gefunden");
	return 0;
}



void SfxPointerServer::ReleasePointer(const void *pObj)

/*  [Beschreibung]

	Gibt den fuer pObj reservierten Pointer wieder frei.
*/


{
	SfxPointerEntry *pEntry=aPointers+MakeHash(pObj);
	SfxPointerEntry* pHashed = pEntry;
	do
	{
		if( pEntry - aPointers == SFX_POINTER_SIZE )
			pEntry = aPointers;
		if(pEntry->pObject==pObj)
		{
			pEntry->pObject=0;
			if(pCache==pObj)
				pCache=0;
			nObjectCount--;
			if(!nObjectCount)
			{
				delete this;
				ReleaseServer();
			}
			return;
		}
	}
	while( ++pEntry != pHashed );

	DBG_ERROR("SfxPointerServer Pointer schon released");
}
