<?php
/**
 * Finnish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2005  Jaakko Sarell and Matti
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Languages
 * @author Jaakko Sarell
 * @author Matti Valve
 * @version $Id: help_text.fi.php,v 1.2.2.41 2006/05/22 21:08:10 meliza Exp $
 */
if (preg_match("/help_text\...\.php$/", $_SERVER["SCRIPT_NAME"])>0) {
print "You cannot access a language file directly.";
exit;
}

$pgv_lang["utf8_ansi_help"]		= "~MUUNNA UTF-8 MERKISTÖSTÄ ANSI MERKISTÖÖN~<b /><br />Jotta sivut näkyisivät oikein internetissä PhpGedView käyttää UTF-8 merkistöä. Jotkut ohjelmat, kuten Family Tree Maker, eivät tue UTF-8-koodattujen GEDCOM-tiedostojen tuontia. Rastittamalla tämän valintaruudun muunnetaan tiedosto <b>UTF-8</b>-muodosta <b>ANSI</b>-muotoon (ISO-8859-1).</b><br /> Riippuu ohjelmasta, missä muodossa koneellesi lataama GEDCOM-tiedoston on oltava.</b>Tarkista ohjelman tiedoista, missä muodossa tiedoston on oltava.<br /><br />Huomaa, että jotta tietyt erikoismerkit pysyisivät muuttumattomina, tiedosto on ladattava  UTF-8-muodossa ja muunnettava ohjelmasi käyttämään muotoon jollakin muulla tavalla. Tiedustele asiaa ohjelman valmistajalta tai tekijältä.<br /><br />";
$pgv_lang["remove_tags_help"]	= "~POISTA RÄÄTÄLÖIDYT PHP-MERKITSIMET~<br /><br />Rastittamalla tämä vaihtoehto poistetaan kaikki räätälöidyt PHP-merkitsimet, jotka on lisätty tietueisiin.<br /><br />PhpGedView-ohjelman käyttämiä merkitsimiä ovat <b>_PGVU</b>, joka osoittaa, kuka käyttäjä teki muutoksia on-line-tilassa ja <b>_THUM</b>, joka kertoo PGV:lle, että kuvaa on käytettävä pienoiskuvana.<br /><br />Räätälöidyt merkitsimet saattavat aiheuttaa virheitä ladattuun GEDCOM-tiedostoon kun se viedään toiseen sukututkimusohjelmaan.<br /><br /> ";
$pgv_lang["download_zipped_help"]	= "~LATAA GEDCOM-TIEDOSTO ZIP-TIEDOSTONA~<br /><br />Kun rastitat tämän vaihtoehdon, GEDCOM-tiedoston kopio tiivistetään ZIP-muotoon ennen sen latautumista. Tämä vähentää huomattavasti tiedoston kokoa, mutta tarvitset soveltuvan purkuohjelman (esim. WinZip) purkaaksesi sen käyttökelpoiseen muotoon.<br /><br />Tämä on käyttökelpoinen vaihtoehto ladataksesi suuren GEDCOM-tiedoston. Suuren tiivistämättömän tiedoston sallittu latausaika saattaa ylittyä, mikä johtaa tiedoston epätäydelliseen latautumiseen. ZIP-vaihtoehto vähentää latausaikaa 75 %:lla.<br /><br />";
$pgv_lang["remember_me_help"]	= "~MUISTA MINUT~<br /><br />Rastittamalla tämän ruudun sisäkirjautumisen yhteydessä  sinun ei uudestaan tarvitse kirjautua järjestelmään vieraillessasi tällä sivulla seuraavan kerran. Tietokoneellesi asetetaan keksi, jonka selain lähettää palvelimelle kun avaat tämän sivuston seuraavan kerran.<br /><br />Kun palaat tälle sivulle voit katsoa yksityistietoja ja  käyttäjäsivuja, mutta jotta voisit editoida tai ylläpitää niitä, sinun on kirjauduttava normaalisti.<br /><br /><b>Älä rastita tätä ruutua kun käyt sivustolla yleiseltä tietokoneelta, koska silloin kuka tahansa voi mennä sivustolle tunnuksillasi</b>.";
$pgv_lang["edit_NCHI_help"]		= "~#factarray[NCHI]# OHJE~<br /><br /> Lisää tämän henkilön tai perheen lasten lukumäärä. Tämä on valinnainen kenttä.<br /><br /> ";
$pgv_lang["edit_TIME_help"]		= "~#factarray[TIME]# OHJE~<br /><br /> Lisää tämän tapahtuman aika. Hyväksyttävä muoto on HH:MM. Esimerkkejä: 04:50 13:00 20:30.<br /><br />";
$pgv_lang["edit_NOTE_help"]		= "~#factarray[NOTE]# OHJE~<br /><br /> Huomautukset ovat vapaata tekstiä ja ilmestyy sivun tieto-osioon.<br /><br />";
$pgv_lang["edit_CEME_help"]		= "~#factarray[CEME]# HELP~<br /><br /> Lisää hautausmaan tai muun viimeisen leposijan nimi, jossa tämä henkilö lepää.<br /><br />";
$pgv_lang["edit_ASSO_help"]		= "~#factarray[ASSO]# OHJE~<br /><br />Lisää läheisen GEDCOM ID-tunnus.<br /><br />";
$pgv_lang["edit_RELA_help"]		= "~#factarray[RELA]# OHJE~<br /><br />Valitse luettelosta läheisen suhteen laji. Valitsemalla Kummisetä merkitsee, että läheinen on kyseisen henkilön kummisetä.<br /><br />";
$pgv_lang["help_hourglass.php"]		= "~#pgv_lang[hourglass_chart]#~<br /><br />Tiimalasikaavio näyttää lähtöhenkilön esi- ja älkipolvet samassa kaaviossa. Se on tavallaan sekoitus esipolvi- ja jälkipolvikaaviosta.<br /><br />Lähtöhenkilö sijaitsee keskellä sivua siten, että jälkipolvet ovat vasemmalla ja esipolvet oikealla. Tässä näkymässä kukin sukupolvi on samalla tasolla sivulla alkaen vanhimmasta sukupolvesta ja päättyen nuorimpaan.<br /><br />";
$pgv_lang["help_familybook.php"]	= "~#pgv_lang[familybook_chart]#~<br /><br />Tämä kaavio on hyvin samantapainen kuin tiimalasikaavio. Se näyttää valitun juurihenkilön esivanhemmat ja jälkeläiset samassa kaaviossa. Se näyttää juurihenkilön jälkeläiset  samanlaisessa tiimalasimuodossa.<br /><br />Juurihenkilö sijaitsee sivun keskellä jälkeläiset vasemmalla ja esivanhemmat oikealla. Tässä näkymässä jokainen sukupolvi on tasattu sivun poikki alkaen varhaisimmasta sukupolvesta ja päättyen viimeismpään.<br /><br />Jokaisesta juurihenkilön jälkeläisestä tulee uuden tiimalasikaavion juurihenkilö samalle sivulle tulostettuna. Tämä toistuu kunnes haluttu määrä jälkipolvia on tulostettu.";
$pgv_lang["fambook_descent_help"]	= "~#pgv_lang[descent_steps]#~<br /><br />Tämä lukuarvo määrittää juurihenkilön jälkipolvien lukumäärän, joka tulostetaan tiimalasimuodossa.<br /><br />";
$pgv_lang["show_spouse_help"]		= "~#pgv_lang[show_spouses]#~<br /><br />Tässä kaaviossa ei oletusarvoisesti näytetä jälkipolvien puolisoita, koska se vaikeuttaa kaavion luettavuutta. Kytkemällä tämän vaihtoehdon päälle, näytetään puolisot kaaviossa.";
$pgv_lang["reorder_families_help"]	= "~#pgv_lang[reorder_families]#~<br /><br />Lähisukulaisten välilehdellä näytetään perheet siinä järjestyksessä missä ne ovat henkilön GEDCOM-tietueessa. Niitä ei ole järjestetty avioliitonsolmimispäivän mukaan koska  kyseiset päivät eivät ole aina tiedossa mutta järjestys on. <br /><br />Tämä vaihtoehto mahdollistaa perheiden järjestyksen muuttamisen lähisukulaiset-välilehdellä. Painikkeella saadaan perheet avioliitonsolmimisjärjestykseen.<br />";
$pgv_lang["import_marr_names_help"]	= "~#pgv_lang[import_marr_names]#~<br /><br />Mikäli haluat tuoda avionimet, PGV käy läpi kaikki naispuoleiset henkilöt GEDCOM-tiedostossa ja luo automaattisesti heille avionimialatietueen heidän GEDCOM-tietueeseensa. Sen jälkeen voi hake heitä joko tyttönimen tai avionimen perusteella.<br /><br />Tämä vaihtoehto mahdollistaa myös  avionimen näkymisen  henkilöluettelossa, mikäli \"<b>#pgv_lang[SHOW_MARRIED_NAMES]#</b>\"  kytketään päälle GEDCOM konfigurointiasetuksissa.<br /><br />";
$pgv_lang["firstname_alpha_help"]	= "~ETUNIMEN AAKKOSELLINEN INDEKSI~<br /><br />Valitsemaasi sukunimeä on enemmän kuin 500 henkilöä. Luettelo on jaettu etunimen ensimmäisen kirjaimen mukaisiin ryhmiin helpottamaan oikean henkilön löytymistä. Tämä indeksi toimii samoin kuin sukunimien aakkosellinen indeksi. Näpäytä kirjainta nähdäksesi kaikki sillä kirjaimella alkavat etunimet. Näpäytä<b>(tuntematon)</b> nähdäksesi henkilöt, joiden etunimi on tuntematon.<br /> Näpäyttämällä \"<b>KAIKKI</b>\" näytetään kaikki henkilöt, joilla on tämä sukunimi. Koska heitä on paljon, luettelon muodostuminen ja lataus saattaa kestää kauan.<br /><br />";
$pgv_lang["edit_TYPE_help"]		= "~#factarray[TYPE]#OHJE~<br /><br />#factarray[TYPE]#-kenttä sallii erikoistapahtuman määrittelyn. Se on tekstikenttä, johon voit kirjoittaa mitä tahansa kirjattavaa.<br /><br />";
$pgv_lang["edit_TEMP_help"]		= "~#factarray[TEMP]# OHJE~<br /><br />Myöhempien Aikojen Pyhien Jeesuksen Kristuksen Kirkon jäseniä koskeva. Tässä kentässä on temppeli, jossa aikuiskaste suoritettiin<br /><br />";
$pgv_lang["edit_STAT_help"]		= "~#factarray[STAT]#OHJE~<br /><br /> Tämä on vaihtoehtoinen tilakenttä jota käytetään yleensä LDS ???? kun ne ajetaan TempleReady-ohjelmalla.<br /><br />";
$pgv_lang["edit__PRIM_help"]	= "~#factarray[_PRIM]#OHJE~<br /><br />Käytä tätä kenttää osoittamaan, että tämä mediaobjekti on kyseisen henkilön ensisijainen tai korostettu objekti. Korostettua kuvaa käytetään henkilösivun kaavioiden yhteydessä.<br /><br />";
$pgv_lang["edit__THUM_help"]	= "~#factarray[_THUM]#OHJE~<br /><br />Tämä on erityinen PGV-kenttä jolla määritellään korostetun pienoiskuvan käyttämistä kaavioissa, vaikka pienoiskuvaa kyseiselle kuvalle ei ole olemassa.<br /><br />";
$pgv_lang["edit_TITL_help"]		= "~#factarray[TITL]#OHJE~<br /><br />Anna otsikko editoitavalle kohteellesi. Jos kyseessä on multimediakohde, anna kuvaava otsikko, jolla käyttäjä voi sen tunnistaa.<br /><br />";
$pgv_lang["edit_FILE_help"]		= "~#factarray[FILE]#OHJE~<br /><br />Tämä on multimediatietueen tärkein kenttä. Se kertoo, mitä tiedostoa on käytettävä. Vähimmillään on annettava tiedostonimi. Lisätietoa tiedoston sijainnista on hyvä olla riippuen asetuksista.<br /><br />Voit käyttää linkkiä \"#pgv_lang[find_media]#\" löytääksesi mediaobjekteja joita jo on ladattu palvelimelle.<br />#pgv_lang[readme_help]#<br /><br />";
$pgv_lang["edit_FORM_help"]		= "~#factarray[FORM]#OHJE~<br /><br />Tämä on valinnainen kenttä johon voi syöttää multimediaobjektin formaatin. Jotkut sukututkimusohjelmat saattavat tarkistaa kentän määritelläkseen kuinka mediaobjektia on käsiteltävä. Koska media ei aina ole siirrettävissä tietokonejärjestelmästä toiseen kovin hyvin, kentällä ei ole suurta merkitystä.<br /><br />";
$pgv_lang["generate_thumb_help"]	= "~PIENOISKUVIEN LUONTIOHJE~<br /><br />Olemme havainneet, että järjestelmäsi voi automaattisesti luoda pienoiskuvat tietyntyppisistä kuvatiedostoista. PHP saattaa tukea JPG-, GIF- ja PNG-kuvia. Järjestelmäsi tukee rastitettuja tiedostomuotoja.<br /><br />Näpäyttämällä tätä valintaruutua osoitat järjestelmälle, että olet lataamassa tämän tyyppisiä tiedostoja ja että haluat järjestelmän yrittävän automaattisesti luoda niistä pienoiskuvat. Älä rastita ruutua, jos haluat itse toimittaa pienoiskuvat.<br /><br />";
$pgv_lang["edit_add_NOTE_help"]	= "~#pgv_lang[add_note]#OHJE~<br /><br />Voit lisätä tähän osioon uuden editoitavaa tietoa koskevan huomautuksen. Huomautukset ovat tekstitietoa, joka näkyvät sivun yksityiskohtaisten tietojen osiossa.";
$pgv_lang["edit_add_SOUR_help"]	= "~#pgv_lang[add_source]#OHJE~<br /><br /> Tähän osioon voit lisätä uuden editoitavaa tietoa koskevan lähdeviittauksen. Lähdekenttään annetaan kyseisen lähteen ID-tunniste. Näpäytä linkkiä #pgv_lang[create_source]# mikäli sinun on lisättävä uusi lähde. Viittauskenttään lisäät sivunumeron tai muun tiedon, joka auttaa muita löytämään lähteessä olevan tiedon. Tekstikenttään kirjoitetaan tekstiosa lähteestä.<br /><br />";
$pgv_lang["edit_add_ASSO_help"]	= "~#pgv_lang[add_asso]#OHJE~<br /><br />#pgv_lang[add_asso]# linkittää sivuston tiedon ja siihen liittyvän läheisen henkilön keskenään. Tämä on yksi tapa tallentaa  tieto, että joku henkilö on esimerkiksi ollut jonkun kummisetä.<br /><br />";
$pgv_lang["edit_QUAY_help"]		= "~#factarray[QUAY]#OHJE~<br /><br />Tässä kentässä voidaan todeta jonkun tästä lähteestä löydetyn tiedon laatu tai luotettavuus. Useat sukututkimusohjelmat käyttävät numeroita tässä kentässä. 1. saattaa merkitä, että kyseessä on ensikäden tieto. 2. saattaa merkitä, että kyseessä on toisen käden tieto ja 3, että kyseessä on epäluotettava tieto.<br /><br />";
$pgv_lang["edit_PAGE_help"]		= "~#factarray[PAGE]#OHJE~<br /><br />Viittauskenttään lisäät sivunumeron tai muun tiedon, joka auttaa muita löytämään lähteessä olevan tiedon.<br /><br />";
$pgv_lang["edit_TEXT_help"]		= "~#factarray[TEXT]#OHJE~<br /><br />Tähän kenttään kirjoitetaan lähteen viittausteksti. Esimerkkinä voi olla lainaus tekstistä tai kuvaus viitteestä.<br /><br />";
$pgv_lang["edit_SOUR_help"]		= "~#factarray[SOUR]#OHJE~<br /><br />Tässä kentässä voit vaihtaa lähdetietuetta, johon tämä lähdeviittaus on yhdistetty. Tähän tulee lähteen ID-tunnus. Kentän viereen tulee nykyisen lähteen ID-tunnuksen  otsikko. Käytä linkkiä \"#pgv_lang[find_id]#\" hakeaksesi lähteen ID-tunnuksen. Poistaaksesi koko viittauksen, älä anna ID-tunnusta.<br /><br />";
$pgv_lang["edit_edit_raw_help"]	= "~#pgv_lang[edit_raw]#OHJE~<br /><br />Tällä sivulla voit editoida GEDCOM-raakadataa. Tätä sivua on käytettävä varoen ja se edellyttää, että ymmärrät GEDCOM 5.5 standardia.<br /><br />PGV sallii monta tapaa lisätä ja editoida tietoa, mutta saattaa esiintyä tilanteita jolloin on tarvetta käsitellä raakaa GEDCOM-rakennetta. Mikäli mahdollista tulisi aina käyttää olemassa olevia lomakkeita tiedon lisäämiseksi, mutta jos se ei käy  voi tätä lomaketta käyttää. Kun tämä lomake lähetetään, tarkistetaan GEDCOM-muodon oikeellisuus ja CHAN-tietue päivitetään.<br /><br />";
$pgv_lang["add_from_clipboard_help"]	= "~#pgv_lang[add_from_clipboard]#~<br />PGV sallii tietojen kopioinnin leikepöydälle. Voit kopioida jopa 5 tietoa leikepöydälle. Sitten voit alasvetovalikosta \"lisää uusi tieto\" voit valita jonkun tiedon leikepöydältä henkilön tietueeseen. Tämä helpottaa samanlaisen tiedon lisäämistä usealle henkilölle.<br /><br />";
$pgv_lang["edit_PLAC_help"]			= "~#factarray[PLAC]#OHJE~<br /><br />Paikat tulisi lisätä sukututkimuksen standardien mukaisesti. Sukututkimuksessa paikka määritellään alkaen kaikkein tarkimmasta määrittelystä ja siirtymällä sitten yhä yleisemmille tasoille. Eri tasot erotetaan toisistaan pilkulla. Sinun tulisi lisätä paikkatieto sellaisella tasolla, joka edustaa valtiovaltaa tai seurakuntaa, jossa ylläpidetään oleellista kyseistä paikkaa koskevaa tietoa.<br /><br />Esimerkiksi Salt Lake City lisätään muodossa \"Salt Lake City, Salt Lake, Utah, USA\". Tarkastellaanpa kutakin osaa erikseen. Ensimmäinen osa, \"Salt Lake City\", on kaupunki, jossa tapahtuma sattui. Joissakin maissa kaupunkien sisällä saattaa olla alueita, jotka on hyvä huomata. Nämä tulevat ennen kaupunkia. Seuraava osa, \"Salt Lake\" on piirikunta. \"Utah\" on osavaltio ja \"USA\" on valtio. On tärkeätä huomata kukin paikka, koska sukututkimustietoa pidetään kunkin tason/paikan virastoissa.<br /><br />Mikäli paikan taso on tuntematon, pilkkujen väliin jätetään välilyönti. Esimerkiksi jos ei tiedetä Salt Lake Cityn piirikuntaa, tieto syötettäisiin muodossa \"Salt Lake City, , Utah, USA\".<br /><br />Voit käyttää linkkiä \"#pgv_lang[find_place]#\" löytääksesi tällä sivustolla jo käytössä olevia paikkoja.<br /><br />";
$pgv_lang["edit_add_parent_help"]	= "~LISÄÄ UUSI ÄITI TAI ISÄ~<br /><br />Tällä sivulla voit lisätä henkilölle uuden äidin tai isän. Täytä uuden henkilön nimi, syntymäaika ja kuolinaika mikäli se on tiedossa. Mikäli joku tieto on tuntematon, jätä se tyhjäksi.<br /><br />Lisätäksesi muita tietoja, tallenna ensin muutokset, jotka lisäävät uuden henkilön. Näpäytä sen jälkeen henkilön nimeä päivitetyllä perhesivulla tai lähisukulaisvälilehdellä päästäksesi hänen henkilösivulleen. Henkilösivulla voi sitten lisätä muita tietoja.<br /><br />";
$pgv_lang["edit_add_spouse_help"]	= "~LISÄÄ UUSI AVIOMIES TAI -VAIMO~<br /><br />Tällä sivulla voit lisätä henkilölle uuden av(i)omiehen tai -vaimon. Täytä uuden henkilön nimi, syntymäaika ja kuolinaika mikäli se on tiedossa. Mikäli joku tieto on tuntematon, jätä se tyhjäksi.<br /><br />Lisätäksesi muita tietoja, talenna ensin muutokset, jotka lisäävät uuden henkilön. Näpäytä sen jälkeen henkilön nimeä päiviteyllä perhesivulla tai lähisukulaisvälilehdellä päästäksesi hänen henkilösivulleen. Henkilösivulla voi sitten lisätä muita tietoja.<br /><br />";
$pgv_lang["edit_death_help"] 	= "~#pgv_lang[death]#OHJE~<br /><br />Tässä voit ilmoittaa kuolintiedot. Lisää ensin henkilön kuolinpäivä sukututkimuksen mukaisessa standardimuodossa (1 JAN 2004). Näpäytä kalenteri-ikonia saadaksesi päivän valintaa koskevia ohjeita. Lisää sen jälkeen kuolinpaikka. Voit käyttää linkkiä \"Hae paikka\" linkittääksesi paikkaan, jonka joku muu on jo tallentanut.<br /><br />";
$pgv_lang["edit_birth_help"] 	= "~#pgv_lang[birth]#OHJE~<br /><br />Tässä voit ilmoittaa syntymätiedot. Lisää ensin henkilön syntymäpäivä sukututkimuksen mukaisessa standardimuodossa (1 JAN 2004). Näpäytä kalenteri-ikonia saadaksesi päivän valintaa koskevia ohjeita. Lisää sen jälkeen syntymäpaikka. Voit käyttää linkkiä \"Hae paikka\" linkittääksesi paikkaan, jonka joku muu on jo tallentanut.<br /><br />";
$pgv_lang["edit_sex_help"]		= "~#pgv_lang[sex]#OHJE~<br /><br />Valitse oikea sukupuoli alasvetovalikosta. Vaihtoehto \"Tuntematon\" osoittaa, että sukupuolta ei tiedetä.<br /><br />";
$pgv_lang["edit_name_help"]		= "~#pgv_lang[name]#OHJE~<br /><br />Tämä on tärkein kenttä henkilöä koskevassa tietueessa. Tämä kenttä täytetään automaattisesti, mutta se on olemassa jotta voit editoida tietoja omien toiveidesi mukaiseksi. Nimi tulee lisätä kenttään GEDCOM 5.5 standardin mukaisesti siten, että sukunimen kummallakin puolella on kauttaviiva \"/\". Esimerkiksi \"John Robert Finlay Jr.\" lisätään seuraavasti: \"John Robert /Finlay/ Jr.\".<br /><br />";
$pgv_lang["edit_suffix_help"]	= "~#pgv_lang[suffix]#OHJE~<br /><br /> Tähän kenttään lisätään henkilön nimen liite. Esimerkkejä ovat \"Vanh.\", \"Nuor.\", \"III\". Kenttä on valinnainen.<br /><br />";
$pgv_lang["edit_surname_help"]	= "~#pgv_lang[surname]#OHJE~<br /><br />Tähän kenttään lisätään henkilön sukunimi. Esimerkiksi \"John Robert Finlay\" nimestä sukunimi on \"Finlay\" ja lisätään tähän.<br /><br />";
$pgv_lang["edit_NICK_help"]		= "~#factarray[NICK]#OHJE~<br /><br />Tähän kenttään lisäät henkilön lempinimet. Toinen tapa lisätä lempinimet on lisätä henkilölle toinen nimi. Kenttä on valinnainen.<br /><br />";
$pgv_lang["edit_given_name_help"]	= "~#pgv_lang[given_name]#OHJE~<br /><br />Tähän kenttään lisätään henkilön etunimet. Esimerkiksi \"John Robert Finlay\" nimestä etunimet ovat \"John Robert\" ja lisätään tähän.<br /><br />";
$pgv_lang["edit_NPFX_help"]			= "~#factarray[NAME]# #factarray[NPFX]#OHJE~<br /><br />Tähän voit antaa nimen etuliitteen kuten \"Tri\", \"Maisteri\". Kenttä on valinnainen.<br /><br />";
$pgv_lang["edit_add_child_help"]	= "~#pgv_lang[add_child]#OHJE~<br /><br /><br />Tällä sivulla voit lisätä lapsen valittuun perheeseen. Lisää lapsen nimi sekä syntymä- ja kuolinaika mikäli se on tiedossa. Mikäli joku tieto on tuntematon, jätä se tyhjäksi.<br /><br />Lisätäksesi muita tietoja kuin syntymä- ja kuolinaika, tallenna ensin muutokset, jotka lisäävät uuden lapsen. Näpäytä sen jälkeen lapsen nimeä päivitetyllä perhesivulla tai lähisukulaisvälilehdellä päästäksesi lapsen henkilösivulle. Henkilösivulla voi sitten lisätä muita tietoja.<br /><br />";
$pgv_lang["review_changes_help"]	= "~HYVÄKSYMÄTTÖMÄT MUUTOKSET~<br /><br />Tällä alueella luetellaan kaikki tietueisiin tehdyt on-line muutokset, jotka täytyy tarkistaa ja hyväksyä tietokantaan.";
$pgv_lang["quick_update_name_help"] = "~PÄIVITÄ NIMI~<br /><br />Käytä kenttiä \"Päivitä nimi\" muuttaaksesi editoitavan henkilön nimeä. Kenttään \"Etunimet\" lisätään henkilön etunimet. Kenttään \"Sukunimi\" lisätään sukunimi. Mikäli haluat lisätä nimen \"John Robert Finlay\", lisätään etunimikenttään \"John Robert\" ja sukunimikenttään \"Finlay\".<br /><br />Näiden kenttien täyttäminen muuttaa nimet, ei lisää niitä.<br /><br /><i>Huomaa: älä käytä näitä nimenmuutoksia avioliiton solmimisen yhteydessä. Käytä sen sijaan alla olevaa vaihtoehtoa, jossa lisätään uusi aviomies.</i><br /><br />";
$pgv_lang["quick_update_fact_help"] = "~PÄIVITÄ TIETO~<br /><br />Käytä kenttää \"Päivitä tieto\" lisätäksesi editoitavaa henkilöä koskevaa uutta tai muuttaaksesi olemassa olevaa tietoa. Valitse ensin tietolaji alasvetovalikosta. Lisää sen jälkeen tietoa koskeva tapahtuma-aika sukututkimuksen mukaisessa standardimuodossa (1 JAN 2004). Näpäytä kalenteri-ikonia saadaksesi päivän valintaa koskevia ohjeita. Lisää sitten tietoa koskeva paikka. Voit käyttää linkkiä \"Hae paikka\" valitaksesi paikan, jonka joku muu on jo tallentanut.<br /><br />Mikäli lisäät tietoa tapauksesta, joka jo on olemassa, uusi tieto korvaa vanhan. Mikäli tietoa ei ennestään ollut, syntyy uusi tieto.<br /><br />";
$pgv_lang["quick_update_photo_help"] 	= "~PÄIVITÄ VALOKUVA~<br /><br />Käytä \"Päivitä valokuva\"-kenttää ladataksesi editoitavan henkilön valokuvan palvelimelle. Lisää \"Otsikko\"-kenttään kuvaava nimi, kuten \"John Finlay 2004\". Näpäytä sitten \"Selaa\"-painiketta hakeaksesi kuvan omalta koneeltasi. Mikäli henkilöstä on jo kuva, valintaruutu pyytää merkitsemään haluatko lisätä uuden vai korvata vanhan kuvan.<br /><br />";
$pgv_lang["quick_update_address_help"] 	= "~PÄIVITÄ OSOITE~<br /><br />Käytä kenttää \"Päivitä osoite\" päivittääksesi osoitteesi, puhelinnumerosi tai sähköpostiosoitteesi.<br /><br />Tämä korvaa mahdollisen vanhan tiedon.<br /><br />";
$pgv_lang["quick_update_spouse_help"] 	= "~LISÄÄ UUSI PUOLISO~<br /><br />Näillä kentillä voit lisätä editoitavalle henkilölle uuden puolison. Täytä uuden puolison nimi, syntymäaika ja avioitumisaika. Lisää päivä sukututkimuksen mukaisessa standardimuodossa (1 JAN 2004). Näpäytä kalenteri-ikonia saadaksesi päivän valintaa koskevia ohjeita. Voit käyttää linkkiä \"Hae paikka\" valitaksesi paikan, jonka joku muu on jo tallentanut.<br /><br />Näillä kentillä voi lisät vain <i>uuden</i> puolison. Ne eivät päivitä olemassa olevaa tietoa. Editoidaksesi jo olemassa olevan henkilön tietoja, sulje tämä ikkuna ja näpäytä hänen nimeään lähisukulaiset välilehdellä. Näpäytä sitten \"Editoi henkilöä\" editoidaksesi henkilön tietoja.<br /><br />";
$pgv_lang["quick_update_marriage_help"] = "~PÄIVITÄ AVIOLIITTO~<br /><br />Voit käyttää näitä kenttiä yhdessä niiden kenttien kanssa, joilla lisätään uusi puoliso kun haluat tallentaa uuden avioliiton. Muussa tapauksessa näiden kenttien täyttäminen muuttaa henkilön avioliittotietoja. Lisää päivä sukututkimuksen mukaisessa standardimuodossa (1 JAN 2004). Näpäytä kalenteri-ikonia saadaksesi päivän valintaa koskevia ohjeita. Voit käyttää linkkiä \"Hae paikka\" valitaksesi paikan, jonka joku muu on jo tallentanut.<br /><br />";
$pgv_lang["quick_update_child_help"] 	= "~LISÄÄ UUSI LAPSI~<br /><br />Näillä kentillä voit lisätä editoitavalle henkilölle uuden lapsen. Täytä uuden lapsen nimi ja sukupuoli. Sitten  syntymäaika ja paikka. Lisää päivä sukututkimuksen mukaisessa standardimuodossa (1 JAN 2004). Näpäytä kalenteri-ikonia saadaksesi päivän valintaa koskevia ohjeita. Voit käyttää linkkiä \"Hae paikka\" valitaksesi paikan, jonka joku muu on jo tallentanut.<br /><br />Näillä kentillä voi lisätä vain <i>uuden</i> lapsen. Ne eivät päivitä olemassa olevaa tietoa. Editoidaksesi jo olemassa olevan henkilön tietoja, sulje tämä ikkuna ja näpäytä hänen nimeään lähisukulaiset välilehdellä. Näpäytä sitten \"Editoi henkilöä\" editoidaksesi henkilön tietoja.<br /><br />";
$pgv_lang["index_top10_pageviews_help"]	= "~ENITEN KATSOTTUJEN ASIOIDEN ALUE~<br /><br />Tämä alue näyttää tämän sivuston 10 suosituinta henkilöä, perhettä tai lähdettä. Jotta tämä alue olisi näkyvissä, ylläpitäjän täytyy aktivoida osumalaskurit.";
$pgv_lang["useradmin_user_default_tab_help"]	= "~KÄYTTÄJÄN OLETUSVÄLILEHDEN ASETUS~<br /><br />Tämä asetus määrittää mikä välilehti aukeaa oletusarvoisesti ensimmäisenä katsoessa mitä tahansa henkilösivua tällä sivustolla. Mikäli käyttäjä saa editoida käyttäjätiliään, tämän asetuksen voi muuttaa myöhemmin.";
$pgv_lang["edituser_user_default_tab_help"]	= "~KÄYTTÄJÄN OLETUSVÄLILEHDEN ASETUS~<br /><br />Tämä asetus määrittää mikä välilehti aukeaa oletusarvoisesti ensimmäisenä katsoessa mitä tahansa henkilösivua tällä sivustolla.";
$pgv_lang["reorder_children_help"]		= "~JÄRJESTÄ LAPSET~<br /><br />Lapset näytetään siinä järjestyksessä, jossa he ovat perhetietueessa. On usein kysytty, miksi he eivät näy syntymäjärjestyksessä. Se johtuu siitä, että usein jonkun lapsen syntymäaika on tuntematon, mutta syntymäjärjestys tiedossa.<br /><br />Tällä valinnalla voit muuttaa lasten järjestystä perheen tietueessa GEDCOM-tiedostossa. Koska usein halutaan lajitella lapset syntymäajan perusteella, se voidaan tehdä automaattisesti painikkeen avulla.<br />";
$pgv_lang["rss_feed_help"]				= "~RSS-SYÖTEASETUKSET~<br /><br />PhpGedView-ohjelmassa oleva RSS-syöte mahdollistaa tervetuloasivun sisällön katsomisen RSS-lukijalla käymättä varsinaisella verkkosivulla. Normaalisti RSS tarjoaja avaa ponnahdusikkunan kertoen muutoksien tapahtuneen aloitussivulla. Tämä mahdollista PhpGedView-sivuston tarkkailun ilman, että tarvitsee käydä sivustolla katsomassa muutoksia. RSS syötealueella voit räätälöidä linkin syötteeseen ja määritellä syötetyypit (useimmat lukijat osaavat käsitellä useimpia tyyppejä, joten asetus voidaan jättää oletusarvoonsa) sekä määritellä minkä moduulin haluat syötteeseen. Syötteen kieli riippuu siitä kielestä, jolla katsot sivua valitessasi. Muodostettavt syötteet ovat RSS 0.92, RSS 1.0, RSS 2.0, ATOM, HTML ja JavaScript. Neljä ensimmäistä on tarkoitettu RSS-lukijalle, JavaScript ja HTML on tarkoitettu sallimaan syötteen sisällyttämisen  muille verkkosivuille. <br /> Huomaa, että suurempi versioluku RSS syötteellä ei tarkoita uudempaa versiota vaan erilaista tyyliä.";
$pgv_lang["upload_media_folder_help"]	= "~#pgv_lang[folder]#~<br /><br />GEDCOM-tiedostosi konfigurointi sallii #GLOBALS[MEDIA_DIRECTORY_LEVELS]# hakemistotasoa oletusarvoisen <b>#GLOBALS[MEDIA_DIRECTORY]#</b> lisäksi, mihin voidaan tallentaa palvelimelle ladattuja mediatiedostoja. Näin voit organisoida mediatiedostosi tarvitsematta huolehtia siitä, että jokaisella mediatiedosolla olisi ainutlaatuinen nimi.<br /><br />Tässä kentässä määrittelet sen hakemston palvelimessasi, johon mediatiedostot tallennetaan. Huomaa ero pienten ja suurten kirjasinten välillä.<br /><br />Mikäli tähän kirjoittamaasi hakemistoa ei ole olemassa, se luodaan automaattisesti. Mikäli lisäät enemmän hakemistoja kuin #GLOBALS[MEDIA_DIRECTORY_LEVELS]#, joka on asetettu GEDCOM-asetuksissasi, syötteesi katkaistaan vastaavasti.<br /><br />Pienoiskuvat ladataan tai luodaan samanlaiseen hakemistorakenteeseen alkaen hakmistosta <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />";
$pgv_lang["upload_media_file_help"]		= "~#pgv_lang[media_file]#~<br /><br />Tässä kentässä määrittelet palvelimelle ladattavaksi tarkoitettujen mediatiedostojen sijainnin ja nimen omalla koneellasi. Voit käyttää <b>Selaa</b>-painiketta etsiäksesi tiedostoa omalta koneeltasi.<br /><br />Ladatulla tiedostolla tulee olemaan sama nimi palvelimella ja se tallennetaan siihen hakemistoon, joka on määritelty <b>#pgv_lang[folder]#</b>-kentässä. Mikäli et näe tätä kenttää tai et voi muuttaa sitä, GEDCOM-asetuksesi ei salli lisää hakemistotasoja ylitse oletusarvon <b>#GLOBALS[MEDIA_DIRECTORY]#</b>, mihin mediatiedostoja normaalisti tallennetaan.<br /><br />Voit jättää tämän kentän tyhjäksi, mikäli haluat ladata vain pienoiskuvan ja haluat, että se on myös pääkuva.<br /><br />";
$pgv_lang["upload_thumbnail_file_help"]	= "~#pgv_lang[media_file]#~<br /><br />Tässä kentässä määrittelet palvelimelle ladattavaksi tarkoitettujen pienoiskuvien sijainnin ja nimen omalla koneellasi. Voit käyttää <b>Selaa</b>-painiketta etsiäksesi tiedostoa omalta koneeltasi.<br /><br />Kun tämä kenttä täytetään, <b>#pgv_lang[auto_thumbnail]#</b> valintaruutu ohitetaan.<br /><br />Mikäli <b>#pgv_lang[media_file]#</b>-kenttä on täytetty, pienoiskuvasi nimetään sen mukaisesti riippumatta pienoiskuvasi nimestä omalla koneellasi. Mikäli kenttä on tyhjä, ladattu pienoiskuva tallennetaan kahteen paikaan palvelimella. Toinen hakemsto on <b>#pgv_lang[folder]#</b>-kentässä mainittu ja toinen identtiseen hakemistorakenteeseen, jonka alku on <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />Mikäli et näe <b>#pgv_lang[folder]#</b>-kenttää tai et voi muuttaa sitä, GEDCOM-asetuksesi ei salli lisää hakemistotasoja ylitse oletusarvon <b>#GLOBALS[MEDIA_DIRECTORY]#</b>, mihin mediatiedostoja normaalisti tallennetaan.<br /><br />Voit jättää tämän kentän tyhjäksi, mikäli haluat ladata vain pienoiskuvan ja haluat, että se on myös pääkuva.<br /><br />";

//-- GENERAL
$pgv_lang["help_header"]				= "Lisätietoja:";
$pgv_lang["privacy_error_help"]			= "<b>YKSITYISTIETOJA></b><br /><br />Tähän viestiin on monta syytä: <br /><br /><b>1. Eläviä henkilöitä koskeva tieto on asetettu tilaan \"Yksityinen\"</b><br />Rekisteröitymättömät tai sisäänkirjautumattomat vierailijat voivat nähdä vain kuolleiden henkilöiden tietoja. Mikäli järjestelmän ylläpitäjä sallii, voit rekisteröityä näpäyttämällä \"Kirjaudu sisään\" nappia ja sitten  #pgv_lang[requestpassword]#-linkkiä.<br /><br /><b>2. Sinulla on käyttäjätunnus ja salasana...</b><br />Mutta unohdit kirjautua sisälle tai et ollut aktiivinen vähään aikaan ja istuntosi aika loppui.<br /><br /><b>3. Yksityisyyden vuoksi</b><br /> Henkilö on pyytänyt ylläpitäjää asettamaan hänet tilaan \"Yksityinen\" tai ei halua näkyä ollenkaan (Piilotettu).<br />Yksityisyys voidaan asettaa seuraaviin tiloihin: :<br />a) #pgv_lang[PRIV_USER]#<br />b) #pgv_lang[PRIV_NONE]#<br />c) #pgv_lang[PRIV_HIDE]#<br /><br /><b>4.\"Sukulinjan\" ulkopuolella. </b><br />Vaikka olet säännöllinen käyttäjä <b> ja</b> kirjautunut sisään, voit silti nähdä tämän viestin mikäli haluamasi henkilö ei ole sinulle riittävän läheistä sukua. <br /> Esimerkkejä: <br /> Mikäli sukulaisuussuhteen arvo on <b>1</b>, voit nähdä vain oman perheesi, isäsi, äitisi ja sisarustesi tiedot (mutta et sisarustesi puolisoiden tai lasten tietoja)<br /><br />Kun sukulaisuussuhde on <b>2</b>, voit nähdä myös sisarustesi puolisoiden ja lasten  tiedot (mutta et lasten puolisoiden ja heidän lastensa tietoja).<br />Mitä suurempi sukulaisuussuhteen arvo on, sen kaukaisempien sukulaisten tietoja saat nähdä.<br /><br />Mikäli sinulla on mielestäsi oikeus nähdä tiettyjä tietoja, ota yhteyttä järjestelmän ylläpitäjään seuraamalla yhteyslinkkejä näytöllä.";
$pgv_lang["more_help"]					= "<br />Mikäli haluat pika-avusteet varmista, että <b>#pgv_lang[show_context_help]#</b> (Ohje-valikossa) on päällä ja näpäytä <b>?</b> aiheen jälkeen.<br />";
$pgv_lang["more_config_help"]			= "<br /> <b>Lisää ohjeita</b><br />Lisää ohjeita on saatavilla lomakkeessa. Näpäytä <b>?</b> tekstin jälkeen.<br />";
$pgv_lang["start_admin_help"]			= "+++Ylläpitäjän lisäinfon alku+++";
$pgv_lang["end_admin_help"]				= "--- Ylläpitäjän lisäinfon loppu---";
$pgv_lang["multiple_help"]				= "<center>--- Tämä on yleistä useita sivuja koskeva lisäinfo ---</center>";
$pgv_lang["header_general_help"]		= "<div class=\"name_head\"><center><b>YLEISTÄ INFORMAATIOTA</b></center></div><br />";
$pgv_lang["best_display_help"]			= "~Näyttösi~<br /> PhpGedView on suunniteltu toimivaksi parhaiten näytön resoluutiolla 1024x768 pikseliä.<br />Sen tulisi olla vähimmäisresoluution, jotta kaikki näkyisi kunnolla.<br />Jos resoluutio on alhaisempi, (esim. 800x600 pikseliä) joudut vierittämään näyttöä vaakasuunnassa.<br />";
$pgv_lang["preview_help"]				= "~Tulostus~<br />Näpäyttämällä \"Tulostuksen esiakatselu\"-linkkiä poistuvat kaikki sellaiset yksityiskohdat, jotka häiritsisivät siistiä tulostusasua (valikot, ruudut, ylimääräiset linkit, pika-avusteiden kysymysmerkit jne.<br /><br />Tulostusnäkymän alareunassa on \"Tulostus\"-linkki. Näpäyttämällä sitä tulostusvalikko aukeaa. Tulostuksen jälkeen voit näpäyttää \"Takaisin\"-linkkiä ja näyttö palautuu normaalitilaan.<br /><br />Vihje: Vaikka tulostusnäkymästä puuttuu useita linkkejä, ovat jäljelle jääneet yhä näpäytettävissä.<br />";
$pgv_lang["readme_help"]				= "<center>Katso <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> saadaksesi lisätietoa.</center>";
$pgv_lang["is_user_help"]				= "---Tämä ohjeteksti on sama minkä vierailijat näkevät.---<br />---Säästääksemme tilaa, emme laatineet erillistä ylläpitäjälle suunnattua tekstiä tälle asialle.---";
$pgv_lang["edit_raw_gedcom_help"]		= "~EDITOI GEDCOM RAAKADATAA~<br /><br />Kun näpäytät tätä linkkiä, uusi, tätä ikkunaa koskeva GEDCOM raakadataa sisältävä ikkuna aukeaa.<br />Siinä voit editoida suoraan GEDCOM-dataa. Varmista, että syötät vain oikeamuotoista GEDCOM 5.5 dataa, koska aineiston oikeellisuutta ei tarkasteta.<br /> Muutettu tai lisätty data näkyy PhpGedView:ssä muutoksina jotka riittävillä oikeuksilla varustetun käyttäjän on hyväksyttävä.";
$pgv_lang["RESN_help"]					= "~TIETOJA KOSKEVIEN RAJOITUSTEN ASETTAMINEN~<br /><br />Paitsi yksityisyysasetuksia PhpGedView voi asettaa rajoituksia henkilöitä ja perheitä koskevien tietojen katselulle ja editoinnille. Kuka tahansa, jolla on editointioikeudet (elleivät aiemmin tehdyt yksityisyysasetukset ja muut asetukset sitä kiellä) voi määrätä rajoitukset. <br />Seuraavat arvot ovat käytössä:<br /><br /><b>#pgv_lang[none]#</b><br/>Sivuston ylläpitäjät, GEDCOM-ylläpitäjät ja käyttäjät, joilla on editointioikeudet, voivat muuttaa tietoja. Tietoa voi katsoa ylläpitäjän tekemien yksityisyysasetusten mukaan.<br /><br /><b>#pgv_lang[confidential]#</b><br />Vain sivuston ylläpitäjät, GEDCOM-ylläpitäjät voivat katsoa ja editoida tietoja. Kukaan muu  (kirjautunut tai kirjautumaton) ei tietoja näe.<br /><br /><b>#pgv_lang[private]#</b><br />Sivuston ylläpitäjät ja  GEDCOM-ylläpitäjät voivat katsoa ja editoida tietoja. Mikäli tieto koskee käyttäjää itseänsä, hän voi myös nähdä ja mikäli hänellä on oikeudet myös editoida niitä tietoja.<br /><br /><b>#pgv_lang[locked]#</b><br />Tällä ei ole vaikutusta tietojen näkymiseen. Vain sivuston ylläpitäjät ja  GEDCOM-ylläpitäjät voivat editoida tietoja. Mikäli tieto koskee käyttäjää itseänsä, hän voi editoida  tietoja mikäli hänellä on editointioikeudet.<br /><br /><br />";

//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]					= "~TERVETULOASIVU~<br /><br />Tämä sivu on tervetuloasivu. Siinä toivotetaan sinut tervetulleeksi valitulle <a href=\"#def_gedcom\">GEDCOM</a>-tiedostoon. Voit palata tälle sivulle valitsemalla \"Tervetuloa-sivu\" ylävalikosta. Mikäli tässä palvelussa on useita GEDCOM-tiedostoja, voit valita haluamasi alasvetovalikosta.<br /><b>Tämä ohjesivu sisältää seuraavat asiat:</b>(koska tämä on PhpGedView palvelun pääsivu)<ul><li><a href=\"#index_portal\">Tervetuloa-sivu</a><li><a href=\"#header\">Otsikkoalue</a><li><a href=\"#menu\">Valikot</a><li><a href=\"#header_general\">Yleistä tietoa</a><li><a href=\"#def\">Määritelmiä</a></ul><br />Versio #VERSION# tuo uuden ulkoasun <a href=\"#def_pgv\">PhpGedView</a>:lle. Valikoita, aloitussivua ja monia muita toimintoja on paranneltu ja/tai uudistettu.<br /><br />";

//-- Index-page Header
$pgv_lang["header_help"]				= "<div class=\"name_head\"><center><b>OTSIKKOALUE</b></center></div><br />Otsikko näkyy jokaisen sivun alussa.<br /> Otsikko sisältää joitakin käyttökelpoisia linkkejä, joita voit hyödyntää kaikkialla palvelussa.<br />Koska tällä palvelulla voi olla erilaisia ulkoasuja valitusta <a href=\"#def_theme\">Teemasta</a> riippuen, voi otsikon ulkoasu ja linkkien paikka vaihdella.<br /><br /><b>Voit löytää seuraavat linkit:</b><ul><li><a href=\"#header_search\">Hakukentt</a><li><a href=\"#header_lang_select\">Kielen valitsin</a><li><a href=\"#header_user_links\">Käyttäjän linkit</a><li><a href=\"#header_favorites\">Suosikit</a><li><a href=\"#header_theme\">Vaihda teema</a></ul>";
$pgv_lang["header_search_help"]			= "~Otsikkoalue: Hakukenttä~<br />Tämä hakukenttä on pieni mutta tehokas.<br /> PhpGedVieW voi etsiä melkein mitä tahansa. Kun näpäytät ' <b>></b>'-merkkiä tai <b>Hae</b>-painiketta pääset haun pääsivulle, josta löydät hakutulokset.<br /> Haun pääsivulla on lisäohjeita.<br />";
$pgv_lang["header_lang_select_help"]	= "~Otsikkoalue: Kielen valitsin~<br />Yksi PhpGedView:n tärkeimmistä ominaisuuksista on useamman kielen tuki. Kieli valitaan automaattisesti vierailijan selaimen asetusten perusteella.<br />Mikäli valinta ei tapahdu automaattisesti (johtuu todennäköisesti selaimen virheellisestä oletuskielen asetuksesta), voit vaihtaa kieltä <b>Kielivalitsimen</b> avulla.<br />Kielivalitsin voi näkyä kahdella tavalla:<br />1. Tavanomainen alasvetovalikko.<br />2. Värillinen kansallislippujono.<br />";
$pgv_lang["header_user_links_help"]		= "~Otsikkoalue: Käyttäjän linkit~<br />Käyttäjän linkit on pieni laatikko, jossa on tärkeitä linkkejä, jotka ovat samalla paikalla kaikkialla palvelussa (ellei käyttäjä vaihda teemaa).<br />Jos et ole kirjautunut palveluun, näkyy vain <b>Sisäänkirjautuminen</b>-linkki.<br />Kun olet kirjautunut näkyy: <b>Kirjautunut (käyttäjätunnuksesi)</b>. Näpäyttämällä linkkiä, pääset käyttäjätietoihisi.<br />Näpäytä <b>Uloskirjautuminen</b> kirjautuaksesi ulos.<br />Jos sinulla on ylläpito-oikeudet, näkyy myös <b>Hallinnointi</b>.<br />Näpäyttämällä sitä, pääset ylläpidon pääsivulle.<br />";
$pgv_lang["header_favorites_help"]		= "~Otsikkoalue: Suosikit~<br />Suosikit-alasvetovalikko näyttää suosikit, jotka olet valinnut henkilökohtaiseeen portaaliisi.<br />Se näyttää myös ylläpitäjän valitsemat suosikit.<br />Näpäyttämällä suosikkia pääset suoraan kyseisen henkilön henkilösivulle.<br />Lisää ohjeita suosikin lisäämiseksi löytyy omasta portaalistasi.<br />";
$pgv_lang["header_theme_help"]			= "~Otsikkoalue: Teemat~<br />Jos ylläpitäjä on aktivoinut Vaihda teemaa alasvetovalikon, voit valita siitä haluamasi näkymän. Kun valitset siitä teeman, näkymäsi muuttuu teeman mukaiseksi. Jos olet sisäänkirjautunut myös käyttäjäteemasi muuttuu.<br />";

//-- Index-page Menu
$pgv_lang["menu_help"]					= "<div class=\"name_head\"><center><b>VALIKOT</b></center></div><br />Sivujen otsikkoalueella ovat alasvetovalikot.<br />Siirtämällä   kursori valikkoikonin päälle, näkyviin tulee alavalikko mikäli sellainen on olemassa kyseiselle asialle.<br />Mikäli näpäytät päävalikkoikonia pääset alavalikon ensimmäiseen kohtaan.<br /><br /><b> Voit valita seuraavat asiat päävalikosta: </b><ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /><li><a href=\"#menu_myged\">Oma Gedview portaali</a><br /><li><a href=\"#menu_charts\">Kaaviot</a><br /><li><a href=\"#menu_lists\">Luettelot</a><br /><li><a href=\"#menu_annical\">Vuosipäiväkalenteri</a><br /><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /><li><a href=\"#menu_search\">Hae</a><br /><li><a href=\"#menu_help\">Ohje</a></ul><br />";
$pgv_lang["menu_famtree_help"]			= "~Tervetulosivun valikko~<br />Kaikki tämän palvelun GEDCOM-tiedostot on lueteltu tässä valikossa. Jokaisella GEDCOM-tiedostolla on oma räätälöity tervetulosivunsa, kuten tämä.<br />Mikäli tässä palvelussa on vain yksi GEDCOM-tiedosto, ei tervetulosivun ikonin alla ole alavalikkoa.<br />";
$pgv_lang["menu_myged_help"]			= "~OmaGedview-portaalivalikko~<br />Mikäli olet sisäänkirjautunut, tämä valikko saattaa sisältää seuraavat asiat:<dl><dt>OmaGedview-portaali</dt><dd> Tämä vie sinut omalle räätälöitävälle \"Aloitussivulle\".</dd><dt>Käyttäjätilini</dt><dd>Voit editoida omia henkilötietojasi tässä.</dd><dt>Omat esivanhempani</dt><dd>Mikäli olet valinnut lähtöhenkilön tässä GEDCOM:ssa, vie tämä kyseisen henkilön esivanhempien tauluun.</dd><dt>Oma sivuni</dt><dd>Tmä vie sinut omalle henkilökohtaiselle sivullesi, jolta löytyy kaikki tiedot itsestäsi ja perheestäsi.</dd></dl>";
$pgv_lang["menu_charts_help"]			= "~Kaaviot-valikko~ <br />Kaikki käytettävissä olevat kaaviot on lueteltu tässä valikossa:<dl><dt><a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a></dt><dd>Tämä vie tämän GEDCOM-tiedoston esipolvikaavioon.Kaavio alkaa tiedoston lähtöhenkilöstä. Jos olet kirjautunut sisään, lähtöhenkilö voit olla sinä itse tai joku määrittelemäsi henkilö.</dd><dt><a href=\"?help=help_descendancy.php\">#pgv_lang[descend_chart]#</a></dt><dd>Jälkipolvikaavio on enemmän tai vähemmän käänteinen esipolvikaaviolle näyttäen kaikki lähtöhenkilön jälkipolvet.</dd><dt><a href=\"?help=help_timeline.php\">#pgv_lang[timeline_chart]#</a></dt><dd>Tässä näet henkilöä koskevat tapahtumat aikajanalla.<br />On mielenkiintoista seurata kahden tai useamman henkilön tapahtumia samalla aikajanalla.</dd><dt><a href=\"?help=help_relationship.php\">#pgv_lang[relationship_chart]#</a></dt><dd>Tässä voit selvittää sukulaisuussuhteet jonkun henkilön ja itsesi tai jonkun muun välillä.</dd><dt><a href=\"?help=help_ancestry.php\">#pgv_lang[ancestry_chart]#</a></dt><dd>Hyvin samanlainen kuin <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, mutta siinä on enemmän yksityiskohtia ja vaihtoehtoiset <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a>-näkymät.</dd><dt><a href=\"?help=help_fanchart.php\">#pgv_lang[fan_chart]#</a></dt><dd>Hyvin samanlainen kuin <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, graafisemmalla tavalla.</dd></dl>";
$pgv_lang["menu_lists_help"]			= "~Luettelovalikko~<br />Seuraavat luettelot ovat käytettävissä tässä valikossa:<dl><dt><a href=\"?help=help_indilist.php\">#pgv_lang[individual_list]#</a></dt><dt><a href=\"?help=help_famlist.php\">#pgv_lang[family_list]#</a></dt><dd>Näistä luetteloista voit etsiä henkilöitä ja sukuja aakkosjärjestyksessä.<br />Ensimmäisessä saat luettelon henkilöistä, toisessa suvuista</dd><dt><a href=\"?help=help_sourcelist.php\">#pgv_lang[source_list]#</a></dt><dd>Tässä luettelossa on kaikki tämän GEDCOM-tiedoston tietolähteet.</dd><dt><a href=\"?help=help_placelist.php\">#pgv_lang[place_list]#</a></dt><dd>Täältä voit etsiä henkilöitä paikn mukaan. Siinä palautetaan kaksi saraketta. Henkilöt on luetteloitu vasemmanpuoleisessa ja suvut oikeanpuoleisessa sarakkeessa.</dd><dt><a href=\"?help=help_medialist.php\">#pgv_lang[media_list]#</a></dt><dd>Tämän valikon näet vain jos ylläpitäjä on sen aktivoinut.<br />Tämä näyttää linkit kaikkiin tämän GEDCOM-tiedoston multimediatiedostoihin.</dd></dl>";
$pgv_lang["menu_annical_help"]			= "~Vuosipäiväkalenterivalikko~<br />Vuosipäiväkalenteri näyttää tietyn päivämäärän, kuukauden tai vuoden tapahtumat.<dl><dt><a href=\"?help=day_month_help\">#pgv_lang[viewday]#</a></dt><dd>Klikkaamalla tätä näet kyseisen päivän tapahtumat.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewmonth]#</a></dt><dd>Klikkaamalla tätä näet kyseisen kuukauden tapahtumat.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewyear]#</a></dt><dd>Klikkaamalla ttä näet kyseisen vuoden kaikki tapahtumat.</dd></dl>";
$pgv_lang["menu_clip_help"]				= "~Sukupuun leikekorivalikko~<br />Tämä näkyy, mikäli ylläpitäjä on sen aktivoinut. <br />Leikekori tekee mahdolliseksi valita henkilöitä, sukuja ja lähteitä ja tallentaa ne leikkeinä leikekoriin jotta voit myöhemmin ladata ne koneellesi GEDCOM 5.5 muodossa.<br /><br />";
$pgv_lang["menu_search_help"]			= "~Hakuvalikko~<br />Klikkaamalla tätä pääset hakusivulle, joka on tehokkaampi kuin hakulinkki, joka joskus näkyy sivun otsikkoalueella. <br /><br />";
$pgv_lang["menu_help_help"]				= "~Ohjevalikko~<br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]		= "<div class=\"name_head\"><center><b>TERVETULOSIVU</b></center></div><br />";
$pgv_lang["index_portal_help"]			= "Tervetulosivu koostuu useista erillisistä alueista ja voidaan räätälöidä. Palveluissa, joissa on useampia GEDCOM-tiedostoja, voi  kullakin GEDCOM-tiedostolla olla oma erilainen tervetulosivu.</b><br /><br /><b>Riippuen siitä, miten ylläpitäjä on räätälöinyt sivuston voit nähdä seuraavat alueet tervetulosivulla:</b><ul><li><a href=\"#index_welcome\">Tervetuloa</a><li><a href=\"#index_login\">Sisäänkirjautuminen</a><li><a href=\"#index_events\">Tulevia tapahtumia</a><li><a href=\"#index_onthisday\">Historiallisia tapahtumia tänään</a><li><a href=\"#index_favorites\">GEDCOM suosikkeja</a><li><a href=\"#index_stats\">GEDCOM tilastotietoja</a><li><a href=\"#index_common_surnames\">Tavallisimmat sukunimet</a><li><a href=\"#index_media\">Satunnainen kuva</a><li><a href=\"#index_loggedin\">Kirjautuneet käyttäjät</a><li><a href=\"#gedcom_news\">GEDCOM uutisia</a><li><a href=\"#recent_changes\">Viimeiset muutokset</a></ul>";
$pgv_lang["index_welcome_help"]			= "~TERVETULOA LOHKO~<br />Tervetuloalohko näyttää:<br />Nykyisen GEDCOM-tiedoston, päivämäärän ja ajan ja (mikäli ylläpitäjä on sen käynnistänyt) <b>Osumalaskurin</b>.<br />Tämän osumalaskurin löydät vain tervetuloalohkosta ja henkilötietosivulta.<br />Laskuri laskee kuinka monta kertaa sivulla on käyty. Laskuri ei tarkista kävijän linkkiä, vaan jokainen käynti lasketaan uudeksi \"osumaksi\".<br />";
$pgv_lang["index_login_help"]			= "~SISÄÄNKIRJAUTUMISALUE~<br />Vaikka voit kirjautua järjestelmään melkein miltä tahansa sivulta, teet sen kuitenkin useinmiten ensimmäisellä sivulla, koska pääset käsiksi rajoitettuihin tietoihin vain sisäänkirjautuneena.<br />Voit kirjautua antamalla <b>käyttäjätunnuksen</b> ja <b>salasanan</b> ja näpäyttämällä \"Kirjaudu sisään\" painiketta.<br /><br />#pgv_lang[new_password_help]#<br />";
$pgv_lang["index_events_help"]			= "~TULEVAT TAPAHTUMAT ALUE~<br />Tämä alue näyttää tämän päivän ja tulevan kuukauden vuosipäivät, jotka on tallennettu GEDCOM-tiedostoon.<br />";
$pgv_lang["days_to_show_help"]			= "~#pgv_lang[days_to_show]#~<br /><br />Lisää näytettävien päivien lukumäärä. Lukumäärä ei voi olla suurempi kuin <b>#DAYS_TO_SHOW_LIMIT#</b>. Mikäli kirjoitat suuremman luvun, käytetään tätä raja-arvoa.<br /><br />Rajan asettaa ylläpito GEDCOM-asetuksissa, Näyttö- ja asetteluosiossa, Piiloita & näytä alaosiossa. ";
$pgv_lang["random_media_persons_or_all_help"] = "~#pgv_lang[random_media_persons_or_all]#~<br /><br />Tämä valinta määrittelee näytettävän mediatyypin.<br /><br />Valittaessa <b>#pgv_lang[random_media_persons]#</b>, vain henkilöihin liittyvä media näytetään. Yleensä se on henkilön valokuva. Valittaessa <b>#pgv_lang[random_media_events]#</b>, vain tietoihin tai tapahtumiin liittyvä media näytetään. Se voi olla esimerkiksi kuva todistuksesta. Valittaessa <b>#pgv_lang[all]#</b>, näytetään kaikenlainen media.";
$pgv_lang["basic_or_all_help"]			= "~#pgv_lang[basic_or_all]#~<br /><br />Tämä vaihtoehto sallii joidenkin päivättyjen tapahtumien poistamisen näkyvistä. Esimerkiksi #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]# jne. tulisi kaikki olla päivättyjä. <br /><br />Kun valitset <b>Kyllä</b>, vain syntymät, kuolemat ja avioliitot näytetään. Kun valitset <b>Ei</b>, kaikki tapahtumat näytetään.";
$pgv_lang["index_onthisday_help"]		= "~TÄNÄ PÄIVÄNÄ TAPAHTUI... ALUE~<br />Tämä alue toimii kuten \"tulevat tapahtumat\" alue sillä erotuksella, että siinä näet tämän päivän tapahtumat omassa historiassasi.<br />";
$pgv_lang["index_favorites_help"]		= "~GEDCOM SUOSIKIT-ALUE~<br />GEDCOM suosikit-alue on kuin Suosikkini OmaGedView portaalissa. Tässä tapauksessa vain palvelun ylläpitäjällä tai käyttäjällä, jolla on ylläpito-oikeudet, on oikeus lisätä, poistaa tai muuttaa suosikkeja.<br />GEDCOM-suosikkien merkitys on kiinnittää huomiota erityisen kiinnostavaan/viin henkilöön/henkilöihin.<br />Jokaisen sivun otsikkoalueella olevasta alasvetovalikosta pääsee käsiksi tämän GEDCOMin suosikkeihin.<br />Napauttamalla sitä, siirryt kyseisen henkilön sivulle.<br /><br />Tilan säästämiseksi näytetään vain rajoitetusti tietoja nimilokerossa. Lokeron oikealla reunalla on suurennuslasi, jota näpäyttämällä näytetään enemmän tietoa.<br />Näpäyttämällä nimeä, siirryt kyseisen henkilön henkilösivulle.<br />Oikealla reunalla on myös valikko, josta pääsee sivuille, joilla on enemmän tietoa tai kaavioita.<br />";
$pgv_lang["index_add_favorites_help"]	= "~LISÄÄ SUOSIKKI~<br />Tässä voit lisätä uuden suosikin suosikkiluetteloosi. Lisää joko henkilön, perheen tai lähteen ID-tunnus tai URL-osoite ja otsikko. Huomautuskenttä on vaihtoehtoinen ja siinä voi antaa kuvauksen suosikista. Kaikki, mikä on kirjoitettu huomautuskenttään näkyy Suosikit-alueella kohteen perässä. <br /><br />";
$pgv_lang["index_stats_help"]			= "~GEDCOM TILASTOTIETOJA ALUE~<br />Tällä alueella näet joitakin tilastotietoja tästä GEDCOM-tiedostosta.<br />Mikäli haluat enemmän tietoja, lähetä ilmoitus sivun lopussa olevaan kontaktiosoitteeseen.<br />";
$pgv_lang["index_common_names_help"]	= "~YLEISIMMÄT SUKUNIMET~<br />Tällä alueella näytetään tämän GEDCOM-tiedoston yleisimmät sukunimet. Ylläpitäjä asettaa näytettävien sukunimien lukumäärän.<br />(Nykyinen asetusarvo riippuu sukunimien vähimmäisesiintymismäärästä, ja on asetettu arvoksi #COMMON_NAMES_THRESHOLD# )<br /><br />Nimet toimivat linkkeinä. Näpäytä nimeä ja pääset #pgv_lang[individual_list]#-luetteloon, josta saat lisätietoa nimestä.<br />";
$pgv_lang["index_media_help"]			= "~SATUNNAINEN KUVA ALUE¨~ <br />Tällä alueella PhpGedView näyttää satunnaisesti valitsemansa mediatiedoston jokaisella käynnillä sivulla.<br />Näpäyttämällä kuvaa tai sen selitettä avautuu täysikokoinen kuva.<br />Näpäyttämällä nimeä, pääset kyseisen henkilön henkilösivulle.<br />";
$pgv_lang["index_loggedin_help"]		= "~KIRJAUTUNEET ALUE~<br />Tämä alue näyttää tällä hetkellä kirjautuneiden lukumäärän.<br />";
$pgv_lang["index_gedcom_news_help"]		= "~GEDCOM UUTISIA ALUE~<br />Uutisalue on kuin ilmoitustaulu tälle GEDCOMille.<br />Ylläpitäjä voi laittaa tänne tärkeitä ilmoituksia tai uutisia.<br /><br />Jos sinulla on jotakin mielenkiintoista näytettävää, ota yhteyttä ylläpitäjään, joka voi laittaa ilmoituksesi esille.";
$pgv_lang["index_gedcom_news_adm_help"]	= "GEDCOM uutisalue sallii <b>HTML-merkitsimien<b/> käytön.<br />Muista aina käyttää alku- ja lopumerkitsimiä.<br />Ylläpitäjän on syytä tuntea HTML-kieltä jonkin verran.<br /><br />Tämä ohjelma käyttää myös <b>tyylitiedostoja (CSS)</b>. Jokaiselle teemalle on oma tylitiedostonsa. Voit myös käyttää näiden tyylitiedostojen luokkia.<br /><br />Jos tarvitset lisätietoja: PhpGedView-sivustolla on esimerkkejä merkitsimien käytöstä uutisalueellasi.<br /><br />";
$pgv_lang["recent_changes_help"]		= "~VIIMEISIMMÄT MUUTOKSET ALUE~<br />Tälla alueella näytetään ne viimeisimmät mutokset GEDCOM-tiedostossa, jotka on tehty CHAN-merkitsimen mukaisesti.<br />";
$pgv_lang["gedcom_news_limit_help"]		= "Voit rajoittaa näytettävien uutisartikkelien lukumäärän ja näin rajoittaa GEDCOM uutisalueen korkeuden.<br /><br />Tämä valinta määrittää käytetäänkö mitään rajoituksia vai asetetaanko rajoitukset artikkelin iän tai artikkelien lukumäärän perusteella.<br /><br />";
$pgv_lang["gedcom_news_flag_help"]		= "Lisää raja-arvo tähän.<br /><br /> Mikäli rajoittavana tekijänä on ikä, kaikki tätä päivien lukumäärää vanhemmat artikkelit jäävät piiloon. Mikäli rajoittavan tekijänä on artikkelien lukumäärä, vain lukumäärän mukaiset uusimmat artikkelit näkyvät.<br /><br />Mikäli arvoiksi valitaan nollat, näytetään kaikki artikkelit.<br /><br />";
$pgv_lang["gedcom_news_archive_help"]	= "Rajoittaakseen uutisalueen korkeutta, ylläpitäjä on piiloittanut joitakin artikkeleita. Ne saa näkyville näpäyttämällä linkkiä <b>#pgv_lang[gedcom_news_archive]#</b>.<br /><br />";
$pgv_lang["index_htmlplus_help"]		= "~EDISTYNYT HTML-ALUE<br />Ylläpitäjä voi tässä lisätä tietoa indeksi- tai portaalisivulle. Sillä on sama tarkoitus kuin HTML-, uutis- ja GEDCOM-tilastoalueella, mutta ylläpitäjällä on enemmän vaikutusta sen ulkonäköön.<br /><br />";
$pgv_lang["index_htmlplus_title_help"]	= "Tämän tekstin tulee olla tyhjä tai hyvin lyhyt. Kun se on tyhjä, edistyksellinen HTML-alue näkyy indeksi- tai portaalisivulla tavallisena alueena aivan kuten HTML-alue. Kun siinä on tekstiä, edistyksellinen HTML-alue näyttää samalta kuin muut alueet täydellisenä sisältäen otsikkokentän, jossa on tässä lisäämäsi teksti.";
$pgv_lang["index_htmlplus_template_help"]	= "Auttaaksemme sina tämän alueen laatimisessa olemme luoneet useita vakiopohjia. Kun valitset jonkun näistä pohjista, tekstialueella on tekstiä, jonka voit muuttaa tarpeittesi mukaan.";
$pgv_lang["index_htmlplus_content_help"]	= "Poiketen HTML-, Uutis- ja GEDCOM tilastoalueesta voit täysin säätää tämän alueen ulkonäköä. Voit käyttää HTML-merkitsimiä ja alueella on käytössä aktiivisen teeman CSS tyylitiedostot. Viittauksia aktiiviseen sukututkimustietokantaan voidaan sisällyttää tekstiin.<br /><br />Tietokantaviittaukset tehdään tekstissä ympäröimällä avainsanat <b>&#35;</b> symboliparilla. Esimerkiksi <b>&#35;TOTAL_FAM&#35;</b> edustaa tietokannassa olevien perheiden lukumäärää. Joskus saatat haluat käyttää tietokantaviittausta tekstinä sen todellisen merkityksen sijaan. Siinä tapauksessa on merkit <b>&#35;</b> korvattava niitä vastaavilla symbolivastineilla. Esimerkiksi jos teksti sisältää <b>&&#35;35;TOTAL_FAM&amp&#35;35;</b> se tulostuu merkkijonona <b>&#35;TOTAL_FAM&#35;</b> eikä muodostu tietokantaviittaukseksi.<br /><br />Käytettvissä olevat avainsanat:<br /><table><tr valign=top><td><ul><li>COMMON_SURNAMES</li><li>TOTAL_INDI</li><li>TOTAL_FAM</li><li>TOTAL_SOUR</li><li>TOTAL_OTHER</li><li>TOTAL_SURNAMES</li><li>TOTAL_MALES</li><li>TOTAL_FEMALES</li><li>TOTAL_UNKNOWN_SEX</li><li>TOTAL_EVENTS</li><li>TOTAL_EVENTS_BIRTH</li><li>TOTAL_EVENTS_DEATH</li><li>TOTAL_EVENTS_MARRIAGE</li><li>TOTAL_EVENTS_OTHER</li><li>TOTAL_USERS</li><li>FIRST_EVENT</li><li>FIRST_EVENT_TYPE</li><li>FIRST_EVENT_NAME</li><li>FIRST_EVENT_YEAR</li><li>LAST_EVENT</li><li>LAST_EVENT_TYPE</li><li>LAST_EVENT_NAME</li><li>LAST_EVENT_YEAR</li><li>FIRST_BIRTH</li><li>FIRST_BIRTH_NAME</li><li>FIRST_BIRTH_YEAR</li></ul></td><td><ul><li>LAST_BIRTH</li><li>LAST_BIRTH_NAME</li><li>LAST_BIRTH_YEAR</li><li>LONG_LIFE</li><li>LONG_LIFE_NAME</li><li>LONG_LIFE_AGE</li><li>TOP10_OLDEST</li><li>AVG_LIFE</li><li>MOST_CHILD</li><li>MOST_CHILD_NAME</li><li>MOST_CHILD_TOTAL</li><li>TOP10_BIGFAM</li><li>AVG_CHILD</li><li>HIGHLIGHT</li><li>GEDCOM</li><li>GEDCOM_ID</li><li>GEDCOM_TITLE</li><li>CREATED_SOFTWARE</li><li>CREATED_VERSION</li><li>CREATED_DATE</li><li>GEDCOM_UPDATED</li><li>GEDCOM_CONTACT</li><li>WEBMASTER_CONTACT</li></ul></td></tr></table><br />";

//-- Index-Page Help
$pgv_lang["help_help"]					= "Olisi tietysti täydellistä tehdä ohjelma, joka on niin yksinkertainen, ettei se vaatisi selityksiä.<br />Se olisi yhtä helppoa kuin kirjan lukeminen.<br />Vaikka tämä ohjelma on varsin monimutkainen, ei sitä huomaa käyttöliittymässä. Melkein kaikkea voi käyttää ilman selityksiä.<br />Mutta koska meillä on paljon kävijöitä ja käyttäjiä, joilla ei ole paljoakaan kokemusta tietokoneista tai internetistä,tarjoamme apua tietyissä paikoissa.<br />Ohjevalikosta löytyvät seuraavat asiat";
$pgv_lang["help_page_help"]				= "<dl><dt><b>Tämän sivun ohje</b></dt><dd>Jokaiselle sivulle on oma \"Ohjesivu\".<br />Kun olet jollakin sivulla, voit näpäyttää tätä asiaa valikossa ja saat esille \"Sivuohjeen\", josta saat selville juuri tällä sivulla olevat asiat.<br />Sivuohje on useinmiten lyhyt.<br />Mikäli tarvitset lisäohjeita tai -tietoja jostakin asiasta tällä sivulla, käytettävissä on \"Pika-avusteet\" kolmantena vaihtoehtona.</dd></dl>";
$pgv_lang["help_content_help"]			= "<dl><dt><b>Ohjeen sisältö</b></dt><dd>Näpäyttämällä tätä, aukeaa ponnahdusikkuna, jossa on luettelo tärkeimmistä ohjeista.<br />Tähän luetteloon tulee lähiaikoina lisää kohtia, koska myös vähäisemmät ohjeet indeksoidaan.</dd></dl>";
$pgv_lang["help_faq_help"]			= "<dl><dt><b>FAQ-luettelo</b></dt><dd>#pgv_lang[text_faq_help]#</dd></dl>";
$pgv_lang["help_HS_help"]			= "<dl><dt><b>#pgv_lang[hs_title]#</b></dt><dd>#pgv_lang[hs_intro]#</dd></dl>";
$pgv_lang["help_qm_help"]				= "<dl><dt><b>Piilota / Näytä pika-avusteet</b></dt><dd>Tämä viimeinen valikkokohta on ehkä kätevin. Npäyttämällä tätä kytkeytyvät pika-avusteet päälle tai pois.<br />Mitä ovat pika-avusteet?<br />Kun ne ovat päällä, näkyy mahdollisesti joidenkin linkkien oikealla puolella kysymysmerkki, alasvetovalikko tai painike. Näpäyttämällä tätä <b>?</b>-ikonia ponnahtaa pieni ohjeikkuna, jossa on tietoa kyseisestä asiasta.<br />Näpäyttämällä \"Piilota pika-avusteet\", kaikki kysymysmerkit poistuvat näytöltä, kunnes taat näpäytät \"Näytä...\".</dd></dl>";

//-- Index-page Definitions
$pgv_lang["def_help"]					= "<div class=\"name_head\"><center><b>MÄÄRITELMIÄ</b></center></div><br />Eräitä ohjeteksteissä esiintyvien sanojen määritelmiä:<ul><li><a href=\"#def_gedcom\">GEDCOM</a><br /><li><a href=\"#def_gedcom_date\">Päivämäärä</a><li><a href=\"#def_pgv\">PhpGedView</a><li><a href=\"#def_portal\">Portaali</a><li><a href=\"#def_theme\">Teema</a></ul>";
$pgv_lang["def_portal_help"]			= "~Portaali~<br />Myös tällä sivustolla portaali on kuin ravintolan aula. Se on lähtöpaikka, mutta sieltä voit myös saada tärkeätä tietoa kuten selityksiä, valikoita jne..<br />";
$pgv_lang["def_gedcom_help"]			= "~GEDCOM tiedosto~<br />GEDCOM-tiedosto on tiedosto, joka sisältää kaikki sukua koskevat tiedot.<br />Kaikki asiatiedot, päivämäärät, tapahtumat, jne. on tallennettu GEDCOM-tiedostoon.<br />GEDCOM-tiedoston on seurattava tiukkoja sääntöjä, koska se on vaihtokelpoinen useiden ohjelmien kanssa riippumatta järjestelmästä ja/tai alustasta.<br />";
$pgv_lang["def_gedcom_date_help"]		= "~Päivämäärät GEDCOM-tiedostossa~<br />Koska formaattien GEDCOM-tiedostoissa tulee seurata kansainvälisiä sääntöjä, on myös päivämäärän merkitsemistavoista sovittu.<br /><br />Vaikka päivämääräkenttä GEDCOM-tiedostossa on vapaa tekstikenttä (tarkoittaen, että voit kirjoittaa ihan mitä tekstiä tahansa) tässä muutamia selityksiä oikean päivämäärän syöttämiseksi:<br />Täysi päivämäärä kirjoitetaan DD MMM YYYY kuten:<br />01 Jan 1801 tai 14 Dec 1950.<br />Jos sinulta puuttuu jokin osa päivämäärästä voit jättää sen pois ja kirjoittaa:<br />Mar 1801 tai 14 Dec.<br />Ellet ole varma tai päivämäärää ei ole vahvistettu, voit kirjoittaa:<br />abt Mar 1801 (abt = noin)<br />bef 20 Dec 1950 (bef = ennen)<br />aft 1949 (aft=jälkeen).<br />Kirjoita kyseiset päivämäärät ja lyhenteet englanniksi, koska silloin GEDCOM-tiedostot voi siirtää eri ohjelmille ja ohjelma osaa kääntää päivämäärät ja lyhenteet toivotulle kielelle.<br />Ohjelman tulee myös voida suorittaa laskutoimituksia päivämäärien avulla. Mikäli kirjoitat päivämäärän väärässä muodossa GEDCOM-tiedoston päivämääräkenttään, ohjelma ei pysty suorittamaan laskutoimitusta oikein.<br />";
$pgv_lang["def_pgv_help"]				= "~PhpGedView~<br />PhpGedView (tai PGV) on John Finlayn laatima ohjelma GEDCOM-tiedostojen katselemiseksi internetissä.<br />Kuten huomaat PGV ei vain näytä staattisia verkkosivuja, vaan on muuntuva ja voidaan räätälöidä monella tavoin.<br />John aloitti ohjelman kehittelyn itsekseen, mutta kokonainen kansainvälinen tiimi kehittäjiä ja kääntäjiä on liittynyt mukaan kehittämään ohjelmaa.<br />GEDCOM-tiedostoja voidaan nykyään katselemisen lisäksi myös muuttaa ja niihin voi tehdä lisäyksiä verkon välityksellä.<br />";
$pgv_lang["def_theme_help"]				= "~Teema~<br />Tällä sivustolla voi olla useampia ulkonäköjä, joita nimitetään Teemoiksi.<br />Palvelun ylläpitäjä valitsee käynnistyksessä käytettävän teeman.<br />Jokainen sivustolle tulija näkee sivuston samanlaisena (teemana). Mikäli ylläpitäjä on tehnyt sopivat asetukset, voi kirjautunut käyttäjä valita itselleen sopivan teeman, jonka käyttäjä aina sitten näkee  kirjauduttuaan sisään.<br />";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]		= "~#pgv_lang[upper_mygedview]#~<br /> Tämä on henkilökohtainen #pgv_lang[mgv]# sivusi.<br />Täältä voit helposti löytää linkit omiin tietoihisi, kuten <b>Käyttäjätilini</b>, Tietoni</b> (tämä on henkilökohtainen sivusi), <b>Esivanhempani</b>.<br />Lisäksi sinulla voi olla sellaiset alueet kuin <b>Viestit, Päiväkirja</b> ja monia muita. Tämän sivun asettelu on samanlainen kuin Tervetulosivulla.<br />Mutta kun Tervetulosivun asettelun määrää ylläpitäjä, voit itse määrittää, mitkä osat ja alueet tulevat tälle sivulle.<br /><br />Tämän sivun Tervetuloalueella on linkki sivun räätälöimiseen.<br /><br /><b>Voit valita seuraavista alueista haluamasi:</b></b><ul><li><a href=\"#mygedview_welcome\">Tervetuloa</a><li><a href=\"#mygedview_customize\">Muokkaa oma GedView</a><li><a href=\"#mygedview_message\">Viestit</a><li><a href=\"#mygedview_events\">Tulevat tapahtumat</a><li><a href=\"#mygedview_onthisday\">Tänä päivänä tapahtui...</a><li><a href=\"#mygedview_favorites\">Suosikkini</a><li><a href=\"#mygedview_stats\">GEDCOM tilastotietoa</a><li><a href=\"#mygedview_myjournal\">Päiväkirjani</a><li><a href=\"#mygedview_media\">Satunnainen kuva</a><li><a href=\"#mygedview_loggedin\">Sisäänkirjautuneet käyttäjät</a><li><a href=\"#mygedview_recent_changes\">Viimeiset muutokset</a></ul>";
$pgv_lang["mygedview_customize_help"]	= "~MUOKKAA #pgv_lang[upper_mygedview]#~<br />Tultuasi tänne ensimmäistä kertaa sinulla oli jo joitakin alueita käytettävissäsi tällä sivulla.<br />Voit halutessasi muokata (räätälöidä) tätä portaalia.<br />Näpäyttämällä tätä linkkiä avautuu lomake ponnahdusikkunaan. Siinä voit lisätä, poistaa ja liikutella alueita.<br />Lisäohjeita löytyy lomakkeella.<br />";
$pgv_lang["mygedview_message_help"]		= "~VIESTIT ALUE ~<br />Täältä löydät muiden käyttäjien tai ylläpitäjän lähettämät viestit.<br />Voit itsekin lähettää viestejä muille käyttäjille ja ylläpitäjälle.<br />PhpGedView sähköpostijärjestelmässä yksityisyytesi on suojattu eivätkä muut näe sähköpostiosoitettasi.<br /><br />Avataksesi viestin näpäytä viestin aihetta tai \"+\"-merkkiä sen vieressä. Voit poistaa useita viestejä rastittamalla niiden vieressä olevat ruudut ja näpäyttämällä \"Poista merkityt viestit\" painiketta.<br />";
$pgv_lang["mygedview_favorites_help"]	= "~SUOSIKKINI ALUE~<br />Suosikkini toimii kuten kirjanmerkki.<br />Jos sinulla on joku erityinen henkilö, jota haluat seurata, mene hänen henkilösivulleen ja valitse \"Lisää suosikkeihini\" suosikkien alasvetovalikosta.<br />Kyseinen henkilö on nyt saanut kirjanmerkin ja lisätty suosikkiluetteloosi.<br />Pääset nyt suoraan kyseisen henkilön henkilösivulle kaikilta palvelun sivuilta valitsemalla hänen nimensä otsikkoalueen \"Suosikit\" alasvetovalikosta.<br /><br />Tilan säästämiseksi alueella näkyy vain rajoitettu määrä tietoa. Nimilaatikon vieressä on suurennuslasi, jota näpäyttämällä saat enemmän tietoa. Oikealla puolella näkyy myös valikko, josta pääset enemmän tietoa sisältäville sivuille ja kaavioihin.<br />";
$pgv_lang["mygedview_myjournal_help"]	= "~PÄIVÄKIRJANI ALUE ~<br />Voit käyttää tätä päiväkirjaa muistiinpanojen (tai muistutusten) kirjoittamiseen omaan tarpeeseesi.<br />Muistiinpanot säilyvät seuraaviin käynteihisi sivustolla.<br /><br />Nämä muistiinpanot eivät näy muille.<br />";
$pgv_lang["mygedview_welcome_help"]		= "~TERVETULOA ALUE ~<dt>Tämä alue näyttää:</dt><dd>- Nykyisen GEDCOM-tiedoston</dd><dd>- Päivän ja ajan</dd><dd>- Linkit seuraaviin kohteisiin:</dd><dd> - - #pgv_lang[myuserdata]#</dd><dd>- - #pgv_lang[my_pedigree]# (katso huomautus)</dd><dd>- - #pgv_lang[my_indi]# (katso huomautus)</dd><dd>- - #pgv_lang[customize_page]#</dd><br /><b>Huomautus</b><br />Näet linkit  \"Tietoni\" ja \"Esivanhempani\" vain jos sinulla on tietue kyseisessä GEDCOM-tiedostossa.<br />Joten jos sinulla on tietue yhdessä GEDCOM-tiedostossa näet linkit  \"Tietoni\" ja \"Esivanhempani\", mutta jos tietueet puuttuvat toisesta GEDCOM-tiedostosta, ei kyseisiä linkkejä ole näkyvissä.<br />";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]			= "~ESIVANHEMPANI SIVU~<br /><br /><br />Useimmat käyttäjät ja vierailijat tietävät, mikä on esipolvitaulu, mutta tässä silti vähän tietoa esipolvitaulustamme:<br />Esipolvitaulu on luettelo kaikista lähtöhenkilön esivanhemmista.<br />Kun tulet tälle sivustolle, on lähtöhenkilö kaikkein vasemmanpuoleisin henkilö. (kun kirjaudut sisälle, voit valita oman lähtöhenkilösi). Kaikki esivanhemmat tarkoittavat isää, äitiä, heidän isiään ja äitejään jne.<br /><br />Tällä sivulla näet esivanhemmat kuvaajana. Sinun ei tarvitse selata tekstisivuja löytääksesi esivanhempasi. Kaikki henkilöt näytetään nimiruuduissa näytöllä.<br /><br />* NIMIRUUDUT ESIPOLVITAULUSSA<br />Mikäli esipolvitaulu on asetettu näyttämään yksityiskohtia, näkyvät henkilön nimi sekä syntymä- ja kuolinpäivä.<br />Kun näpäytät henkilön nimeä, avautuu henkilösivu.<br />Kun \"näytä yksityiskohdat\" on kytketty päälle, näkyy nimiruudussa esipolvi-ikoni ja suurennuslasi-ikoni.<br /><br />* ESIPOLVI-IKONI NIMIRUUDUSSA<br />Kun näpäytät tai osoitat  ikonia, avautuu pieni alavalikko.<br />Esi- tai jälkipolvitaulukon valinta vastaa päävalikon valintaa sillä erotuksella, että nyt lähtöhenkilö vaihtuu nimiruudussa olevaksi henkilöksi. Lisäksi näkyy \"Perhe puolisoineen\". Näet avio/avopuolison nimen sekä lasten nimet.<br />Kaikki nimet ovat näpäytettävissä.<br /><br />* SUURENNUSLASI NIMIRUUDUSSA<br />Sivuston asetuksista riippuen sinun on joko osoitettava tai näpäytettävä sitä.<br />Tämä suurentaa nimiruudun, jolloin siinä näkyy enemän tietoja.<br />Näet enemmän päivämääriä ja tapahtumia. Nimet ovat näpäytettävissä.<br /><br />* NUOLET<br />Kaikkein vasemmanpuoleisimman nimiruudun vasemmalla puolella tai oikeanpuolimmaisimman nimiruudun oikealla puolella voi olla nuoli.<br />Näpäyttämällä tätä näyttö \"siirtyy\" nuolen suuntaan.<br /><br />Lisäohjeita saa näpäyttämällä kysymysmerkkiä <b>?</b> ruudun tai linkin vieressä.";
$pgv_lang["show_full_help"]				= "~NÄYTÄ TAI PIILOTA YKSITYISKOHDAT~<br /><br />Tällä vaihtoehdolla voit joko näyttää tai piilottaa kaikki yksityiskohdat nimiruudussa.<br />Kun yksityiskohdat on piilotettu, näytölle mahtuu useampia ruutuja.<br /><br />Mikäli olet piilottanut yksityiskohdat, voit saada ne näkyviin, mikäli suurennuslasi on kytketty päälle normaalinäkymässä.<br />Se taas riippuu siitä, miten ylläpitäjä on konfiguroinut ohjelman.<br />Jos tavallisesti joudut näpäytämään suurennuslasia lähentääksesi kohdetta, voit myös paljastaa yksityiskohdat näpäyttämällä nimiruutua.<br />Mikäli lähennät kohdetta pelkästään osoittamalla suurennuslasia, homma toimii samalla tavoin osoittamalla \"yksinkertaista\" ruutua.<br />";
$pgv_lang["talloffset_help"]			= "~SIVUN SUUNTAUS~<br /><br />Tällä vaihtoehdolla määrität sivun suuntauksen.<br />Suuntauksen vaihtaminen saattaa kannattaa mikäli haluat tulostaa näytön tai näytön muoto on epätavallinen. Valitsemalla pystysivun saat korkeamman sukupuun jolloin 4 sukupolvea mahtuu samalle sivulle. Vaakasivulla saat aikaan leveämmän sukupuun.";
$pgv_lang["rootid_help"]				= "~UUSI LÄHTÖHENKILÖ~<br /><br />Mikäli haluat näyttää sukupuun, jossa on uusi lähtöhenkilö, voit tähän ruutuun kirjoittaa hänen ID-tunnuksensa.<br />Mikäli et tiedä henkilön ID-tunnusta, käytä <b>>Hae ID<</b> linkkiä.<br /><br /><b>ID-TUNNUS</b><br /> PhpGedView-ohjelmassa käytetty ID-tunnus ei ole sama kuin henkilötunnus!<br />ID-tunnus on luku, jota käytetään GEDCOM-tiedostossa ja jonka sukututkimusohjelma luo luodessaan GEDCOM-tiedoston!";
$pgv_lang["PEDIGREE_GENERATIONS_help"]	= "~SUKUPOLVIEN LUKUMÄÄRÄ~<br /><br />Tässä voit määrittää tällä sivulla näytettävien sukupolvien lukumäärän.<br />Sinulle sopiva lukumäärä riippuu näytön koosta ja näytetäänkö yksityiskohdat vai ei.<br />";

//-- LOGIN-page
$pgv_lang["login_page_help"]			= "~SISÄÄNKIRJAUTUMISSIVU~<br /><br />Tällä sivulla voit kirjautua järjestelmään, pyytää uutta salasanaa tai uutta käyttäjätiliä.<br />";
$pgv_lang["username_help"]				= "~KÄYTTÄJÄTUNNUS~<br /><br />Tähän ruutuun kirjoitat käyttäjätunnuksesi.<br />Huomaa ero isojen ja pienten kirjainten välillä!<br />";
$pgv_lang["password_help"]				= "~SALASANA~<br /><br />Tähän ruutuun kirjoitat salasanasi.<br />Huomaa ero isojen ja pienten kirjainten välillä!<br />";
$pgv_lang["login_buttons_help"]			= "~SISÄÄNKIRJAUTUMISPAINIKKEET~<br /><br />Tässä näkyy kaksi painiketta järjestelmään kirjautumiseksi.<br />Sivu jolle joudut riippuu näpäyttämästäsi painikkeesta sen jälkeen kun olet antanut käyttäjätunnuksen ja salasanan.<br /><br />* <b> #pgv_lang[login]# </b> painike<br />Jos näpäytät tätä painiketta, palaat sille sivulle, jolta lähdit<br />Siis jos näpäytit \" #pgv_lang[login]# \" kun olit esipolvisivulla palaat sille sivulle.<br /><br />* <b> #pgv_lang[admin]# </b> painike<br />Jos sinulla on ylläpito-oikeudet, voit näpäyttää tätä päästäksesi suoraan pääylläpitosivulle.";
$pgv_lang["login_buttons_aut_help"]		= "~AUTENTIKOINTITILA~<br /><br />SISÄÄNKIRJAUTUMISPAINIKKEET<br /><br />Tässä näkyy kaksi painiketta järjestelmään kirjautumiseksi.<br />Sivu jolle joudut riippuu näpäyttämästäsi painiketa sen jälkeen kun olet antanut käyttäjätunnuksen ja salasanan.<br /><br />* <b> #pgv_lang[login]# </b> painike<br />Jos näpäytät tätä painiketta, kirjaudut järjestelmään ja joudut suoraan omalle GedView-sivullesi, jossa muokkaat asetuksiasi, lisäät tai muokkaat suosikkejasi, luet ja lähetät viestejä jne.<br /><br /><b> #pgv_lang[admin]# </b> painike<br />Jos sinulla on ylläpito-oikeudet, voit näpäyttää tätä päästäksesi suoraan ylläpidon pääsivulle.";
$pgv_lang["new_password_help"]			= "~PYYDÄ UUSI SALASANA~<br />Jos olet unohtanut salasanasi, voit näpäyttää tätä linkkiä pyytääksesi uuden salasanan.<br />Pääset sivulle \"Unohtunut salasana\".";
$pgv_lang["new_user_help"]				= "~PYYDÄ UUSI KÄYTTÄJÄTILI~<br /><br />Mikäli vierailet tällä sivulla ja haluat käyttäjätilin, näpäytä tätä linkkiä.<br />Pääset \"rekisteröitymissivulle\".";
$pgv_lang["mygedview_login_help"]		= "Päästäksesi OmaGedView-portaaliin, sinun on rekisteröidyttävä järjestelmään.<br /><br />OmaGedView-portaalin avulla voit merkitä kirjanmerkillä suosikkihenkilösi, pitää käyttäjän päiväkirjaa, hallita viestejä, nähdä muut kirjautuneet käyttäjät sekä räätälöidä kokemuksiasi PhpGedView:ssä.<br /><br />Kirjoita käyttäjätunnus ja salasana ao. kenttiin kirjautuaksesi OmaGedView-järjestelmään.";
$pgv_lang["new_user_firstname_help"]	= "~#pgv_lang[firstname]#~<br /><br />Tähän kenttään kirjoitat etunimesi<br /><br />Meidän on tiedettävä etu- ja sukunimesi, jotta voimme päätellä voitko saada käyttäjätilin tähän palveluun ja mitä oikeuksia sinulle voi antaa. Nimet näkyvät muille kirjautuneille perheenjäsenille ja käyttäjille<br /><br />";
$pgv_lang["new_user_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br /> Tähän kenttään kirjoitat sukunimesi.<br /><br />Meidän on tiedettävä etu- ja sukunimesi, jotta voimme päätellä voitko saada käyttäjätilin tähän palveluun ja mitä oikeuksia sinulle voi antaa. Nimet näkyvät muille kirjautuneille perheenjäsenille ja käyttäjille<br /><br />";
$pgv_lang["register_info_01"]		= "~PYYDÄ UUSI KÄYTTÄJÄTILI~<br /><br />Tässä palvelussa yleisesti näytettävän tiedon määrä saattaa riippua sovellettavista turvallisuusmääräyksistä. Monet henkilöt eivät halua tietojaan näkyville internetissä. Henkilötietoja saatetaan käyttää roskapostin lähettämiseen tai henkilötietovarkauksiin. <br /><br />Tälle sivustolle pääsevät ne henkilöt, joilla on käyttäjätili. Kun ylläpitäjä on varmentanut ja hyväksynyt hakemuksesi, voit kirjautua sisään. <br /><br />Mikäli sukulaisuuden yksityisyysasetus on aktivoitu pääset käsiksi vain omien lähisukulaistesi tietoihin kirjauduttuasi järjestelmään. Ylläpitäjä saattaa myös antaa tietyille henkilöille luvan tietokannan editointiin niin, että he voivat muuttaa tai lisätä tietoja.<br /><br />Mikäli tarvitset enemmän tukea, käytä oheista linkkiä ottaaksesi yhteyttä ylläpitäjään.";
$pgv_lang["register_info_02"]		= "~PYYDÄ UUSI KÄYTTÄJÄTILI~<br /><br />Tässä palvelussa yleisesti näytettävän tiedon määrä saattaa riippua sovellettavista turvallisuusmääräyksistä. Monet henkilöt eivät halua tietojaan näkyville internetissä. Henkilötietoja saatetaan käyttää roskapostin lähettämiseen tai henkilötietovarkauksiin. <br /><br />Tälle sivustolle pääsevät vain ne henkilöt, joille on myönnetty <u>käytölupa</u>. Kun ylläpitäjä on varmentanut ja hyväksynyt hakemuksesi, voit kirjautua sisään ja katsoa yksityisiä tietoja.<br /><br />Mikäli sukulaisuuden yksityisyysasetus on aktivoitu pääset käsiksi vain omien lähisukulaistesi tietoihin kirjauduttuasi järjestelmään. Ylläpitäjä saattaa myös antaa tietyille henkilöille luvan tietokannan editointiin niin, että he voivat muuttaa tai lisätä tietoja.<br /><br />Mikäli tarvitset enemmän tukea, käytä oheista linkkiä ottaaksesi yhteyttä ylläpitäjään.";
$pgv_lang["register_info_03"]		= "~PYYDÄ UUSI KÄYTTÄJÄTILI~<br /><br />Tässä palvelussa yleisesti näytettävän tiedon määrä saattaa riippua sovellettavista turvallisuusmääräyksistä. Monet henkilöt eivät halua tietojaan näkyville internetissä. Henkilötietoja saatetaan käyttää roskapostin lähettämiseen tai henkilötietovarkauksiin. <br /><br />Tälle sivustolle pääsevät <u>vain perheenjäsenet</u>. Kun ylläpitäjä on varmentanut ja hyväksynyt hakemuksesi, voit kirjautua sisään ja katsoa yksityisiä tietoja.<br /><br />Mikäli sukulaisuuden yksityisyysasetus on aktivoitu pääset käsiksi vain omien lähisukulaistesi tietoihin kirjauduttuasi järjestelmään. Ylläpitäjä saattaa myös antaa tietyille henkilöille luvan tietokannan editointiin niin, että he voivat muuttaa tai lisätä tietoja.<br /><br />Mikäli tarvitset enemmän tukea, käytä oheista linkkiä ottaaksesi yhteyttä ylläpitäjään.";

//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~JÄLKIPOLVISIVU~<br /><br />Tämä sivu näyttää henkilön jälkeläiset.<br />Voit valita lähtöhenkilön jälkipolvikaavioon tällä sivulla, tai voit siirtyä tälle sivulle näpäyttämällä \"Jälkipolvet\"-kaaviota toisella sivulla.<br />Näpäytä ylös-nuolta liikkuaksesi ylöspäin pitkin sukupuuta. Näpäytä kaavioikonia henkilöruudussa tehdäksesi hänestä lähtöhenkilön sukupuussa.";
$pgv_lang["desc_rootid_help"]			= "~UUSI LÄHTÖHENKILÖ~<br /><br />Mikäli haluat nähdä uuden jälkipolvitaulun, jolla on uusi lähtöhenkilö, kirjoita tähän kenttään kyseisen henkilön ID.<br />Ellet tiedä sitä, käytä linkkiä \"hae ID\".";
$pgv_lang["desc_generations_help"]		= "~SUKUPOLVIEN LUKUMÄÄRÄ~<br /><br />Tässä voit antaa tällä sivulla näkyvien sukupolvien suurimman lukumäärän.<br />Lukumäärän suurentaminen lisää käsittelyaikaa.";
//-- show_full is used from pedigree

//-- Time line-page
$pgv_lang["help_timeline.php"]			= "~AIKAJANASIVU~<br /><br /> Tällä sivulla voit näyttää yhden tai useamman henkilön aikajanalla.<br />Tällä tavoin voit esimerkiksi visualisoida kahden tai useamman henkilön tilan tietyssä pisteessä aikajanalla.<br /><br />Mikäli näpäytit Aikajana-linkkiä toisella sivulla, tulet näkemään kyseisen henkilön aikajanalla.<br />Mikäli näpäytät Aikajana-linkkiä valikossa, joudut syöttämään aluksi jonkun henkilön ID-tunnuksen.";
$pgv_lang["add_person_help"]			= "~LISÄÄ HENKILÖ KAAVIOON~<br /><br /> Aikajanalla voi olla useampia henkilöitä.<br />Lisää tähän kenttään henkilön ID.<br />Ellet tiedä sitä, käytä linkkiä \"hae ID\".";
$pgv_lang["remove_person_help"]			= "~POISTA HENKILÖ KAAVIOSTA~<br /><br /> Näpäytä tätä linkkiä poistaaksesi henkilön aikajanalta.";
$pgv_lang["show_age_marker_help"]		= "~NÄYTÄ IKÄMERKITSIN~<br /><br /> Klikkaamalla tätä ruutua saat esille ikämerkitsimen, jota voit vetää aikajanaa pitkin.<br />Tämä on mukava työkalu tarkistaaksesi kyseisen henkilön iän tietyn tapahtuman aikoihin.<br />Kullekin henkilölle kaaviossa voit aktivoida tai sulkea oman ikämerkitsimen.";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~SUKULAISUUSSIVU~<br /><br /> Tällä sivulla saa näkyviin kahden henkilön sukulaisuussuhteen.<br />Ei vain verisukulaisuus vaan ihan mikä muukin sukulaisuussuhde saadaan esille.";
$pgv_lang["relationship_id_help"]		= "~HENKILÖIDEN 1 ja 2 ID~<br /><br />Mikäli olet siirtynyt tälle sivulle muualta näpäyttämällä esimerkiksi linkkiä \"Sukulaisuus minuun\", tulet tässä näkemään kyseisen kahden henkilön välisen sukulaisuussuhteen. <br />Muuten sinun tulee antaa kummankin henkilön ID selvittääksesi heidän välisensä sukulaisuussuhteen.<br />Ellet tiedä niitä, käytä linkkiä \"hae ID\".";
$pgv_lang["next_path_help"]				= "~HAE TOINEN REITTI~<br /><br />Voit näpäyttää tätä linkkiä nähdäksesi, onko kahden henkilön välillä muuta suukaukaisuussuhdetta<br />Edellinen/set reitit saa näkyviin näpäyttämällä kyseisen numeroidun reitin linkkiä.";
$pgv_lang["follow_spouse_help"]			= "~TARKISTA  SUKULAISUUS MYÖS AVIOLIITON KAUTTA- VALINTARUUTU~<br /><br />Kun valintaruutu on <b>rastittamatta</b>, sukulaisuussuhde tarkistetaan vain verisukulaisten välillä.<br />Mikäli se on rastitettu, tarkistetaan myös avioliiton kautta muodostunut sukulaisuussuhde. Rastittamalla ruutu löytyy luultavasti useampia sukulaisuussuhteita.";
$pgv_lang["line_up_generations_help"]	= "~ASETA SAMA SUKUPOLVI RIVIIN - VALINTARUUTU~<br /><br />Kun tämä valintaruutu on rastitettu, tulevat saman sukupolven henkilöt asettumaan samalle vaakasuoralle tällä sivulla. Mikäli ruutu ei ole rastitettu, tulee jokainen sukupolvi näkymään allekkain riippumatta siitä, onko kysessä vanhempien tai lasten välinen sukuaisuussuhde.";
$pgv_lang["oldest_top_help"]          	= "~NÄYTÄ VANHIN HUIPULLA - VALINTARUUTU~<br /><br /> Kun tämä valintaruutu on rastitettu, näkyy vanhin henkilö ylimpänä.<br />Rastittamaton ruutu näyttää nuorimman ylimpänä.<br /><br />Huom! Tämä vaihtoehto toimii vain, mikäli <i>#pgv_lang[line_up_generations]#</i> on rastitettu.";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]			= "~#pgv_lang[ancestry_chart]# sivu~<br /><br />Esipolvikaavio on hyvin samantapainen kuin <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, mutta siinä on enemmän yksityiskohtia ja vaihtoehtoisia <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a> näyttöjä.<br /><br />Jokainen esipolvi näytetään yhdessä ainutkertaisen numeron kanssa, joka on laskettu <i>Sosa-Stradonitz</i> järjestelmästä:<br />- parillinen luku miehille (lapsi*2)<br />- pariton luku naisille (aviomies+1) paitsi <big>1</big><br /><br />Esimerkki: <big>7</big> on  <big>6</big>:n aviovaimo, <big>3</big>:n äiti sekä <big>14</big>:n ja <big>15</big>:n tytär.";
$pgv_lang["box_width_help"]				= "~#pgv_lang[ancestry_chart]# laatikon leveys~<br /><br />Laatikon leveyden voit tässä muuttaa välillä 50 - 100%.<br />Normaali arvo on 100%: kukin laatikko on noin 270 pikseliä leveä.";
$pgv_lang["chart_style_help"]			= "~#pgv_lang[ancestry_chart]# tyyli~<br /><br /><dl><dt>#pgv_lang[ancestry_list]#</dt><dd> Pystysuora sukupuu, jossa on kutistettavat tai laajennettavat perheet.</dd><dt>#pgv_lang[ancestry_booklet]#</dt><dd>. Yksi perhe sivua kohti sisältäen vanhemmat, isovanhemmat ja kaikki kirjatut lapset.<br />Helppo tulostaa ja antaa sukulaisille.</dd></dl>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]			= "~#pgv_lang[fan_chart]# sivu~<br /><br />Viuhkakaavio on hyvin samanlainen kuin <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>,  mutta graafisempi.<br /><br />Lähtöhenkilö näytetään keskellä, hänen vanhempansa ensimmäisessä renkaassa, isovanhemmat seuraavassa jne...<br /><br />Syntymä- ja kuolinvuosi sijaitsevat nimen alla, jos ne ovat tiedossa.<br /><br />Näpäyttämällä henkilöä kaaviossa asettaa hänet keskelle. Keskellä olevan henkiln lähellä on nuoli, joka avaa ruudun, josta voi siirtyä lähtöhenkilön lapseen (tai sisarukseen) kuten <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>.";
$pgv_lang["fan_width_help"]				= "~#pgv_lang[fan_chart]# leveys~</b><br /><br />Tässä voit muuttaa viuhkakaavion leveyden välillä 50 - 300%. Normaali arvo on 100%: kaavio on noin 640 pikseliä leveä.";
$pgv_lang["fan_style_help"]				= "~#pgv_lang[fan_chart]# tyyli~<br /><br /><dl><dt>1/2</dt><dd>Puoliympyrän (180 astetta) muotoinen viuhkakaavio</dd><dt>3/4</dt><dd>Kolme-neljännesympyrän (270 astetta) muotoinen kaavio tai 'enkelin siipi'</dd><dt>4/4</dt><dd>Täysympyrän (360 astetta) muotoinen kaavio</dd></dl>";

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~HENKILÖLUETTELOSIVU~<br /><br />Tällä sivulla näytetään luettelo henkilöistä.<br /><br />Nimet näytetään sukunimi ensimmäisenä ja lajiteltuna aakkosjärjestyksessä.<br />Näkymä riippuu:<br /><b>1.</b>Kirjaimesta, jota näpäytit<br /><b>2.</b> Näpäytitkö \"Ohita\" tai \"Näytä\" sukunimiluettelo.<br /><br />Lisätietoa saat näpäyttämällä <b>?</b> kohteiden perässä.";
$pgv_lang["alpha_help"]					= "~AAKKOSLUETTELO~<br /><br />Näpäyttämällä kirjainta aakkosluettelossa  saat luettelon nimistä, jotka alkavat näpäyttämälläsi kirjaimella.<br />Luettelon toiseksi viimeisenä kohteena voi olla <b>(tuntematon).</b><br />Se näkyy mikäli GEDCOM-tiedostossa on henkilöitä, joiden nimeä ei ole lisätty kyseisen henkilön GEDCOM-tietueeseen tai jos nimi ei sisällä merkkejä tuetuista kielistä.<br />Siis tuntematon henkilö.<br /><br /><b>Huom!</b> Mikäli henkilön sukunimi on tallennettu GEDCOM-tietueeseen muodossa Nn, NN, Tuntematon tai N.N. niitä <b>ei</b> näytetä, jos näpäytät <b>Tuntematon</b>. Ne näkyvät näpäyttämällä <b>N</b> tai <b>T</b>. Tämä siksi, että ohjelma tarkistaa vain onko henkilön sukunimi olemassa hänen GEDCOM-tietueessaan.<br /><br />Aakkosluettelon lopussa on \"<b>KAIKKI</b>\", jota näpäytämällä näkyvät kaikki GEDCOM-tiedostossa olevat sukunimet.<br /><br /><b>Puuttuvat kirjaimet</b><br />Mikäli aakkosluettelosta puuttuu jokin kirjain, merkitsee se vain sitä, että kyseisellä kirjaimella alkavia sukunimiä ei ole tietokannassa.";
$pgv_lang["name_list_help"]				= "~NIMILUETTELO~<br /><br />Tämä ruutu näyttää joko sukunimiluettelon tai luettelon täydellisistä nimistä.<br />Kummassakin tapauksessa sukunimiluettelo alkaa sillä kirjaimella, jota näpäytit aakkosluettelossa, ellet näpäyttänyt \"KAIKKI\".<br /><br />Riippuen ruudun alla olevan linkin tilasta, näytetään joko sukunimiluettelo tai luettelo täydellisistä nimistä.";
$pgv_lang["skip_sublist_help"]			= "~OHITA SUKUNIMILUETTELO~<br /><br />Vakioasetuksena on pelkästään sukunimien näyttäminen näpäytettyäsi kirjainta aakkosluettelossa.<br />Mikäli näpäytätä tätä linkkiä sukunimiluettelo ohitetaan ja kaikki nimet näytetään kerrallaan.";

//-- Families-page
$pgv_lang["help_famlist.php"]			= "~PERHELUETTELO~<br /><br />Tällä sivulla näkyy luettelo perheistä.<br /><br />Ne on lueteltu sukunimen mukaan aakkosjärjestyksessä.<br />Näkymä riippuu: <br /><b>1.</b> Kirjaimesta, jota näpäytit <br /><b>2.</b> Näpäytitkö \"Ohita\" tai \"Näytä\" sukunimiluettelo.<br /><br /> Voit hakea sekä aviomiehen että aviovaimon sukunimen perusteella, kumpikin on luettelossa.<br /><br />Lisätietoa saat näpäyttämällä <b>?</b> kohteiden perässä.";
$pgv_lang["help_family.php"]			= "~PERHEITÄ KOSKEVIEN YKSITYISKOTAISTEN TIETOJEN SIVU~<br /><br />Tällä sivulla näkyy aiemmalla sivulla valitsemaasi perhettä koskevat yleiset tiedot.<br />Ylhäältä alaspäin mennessä näkyy henkilötietolaatikot seuraavasti:<br />Aviomies ja hänen vanhempansa, aviovaimo ja hänen vanhempansa, ja lapset.<br /><br />Henkilötietoruutujen asettelu ja sisältö ovat samanlaiset kuin esipolvi- ja jälkipolvisivuilla.<br />Vanhempien ruudun oikealla puolella voi olla nuoli, mikäli tiedostossa on enemmän esivanhempia. Näpäyttämällä tätä nuolta, siirryt yhtä sukupolvea ylemmäksi uudelle perhesivulle, missä vanhemmat ovat nyt aviomies ja aviovaimo.<br />Oikealla puolella nimiruudun <i>sisällä</i> voi olla suurennuslasi, jota näpäyttämällä saa lisätietoa henkilöstä. Npäyttämällä nimeä, siirryt kyseisen henkilön henkilösivulle. Oikealla puolella näkyy myös pieni valikko, joka johtaa enemmän tietoa ja kaavioita sisältäville sivuille.<br /><br />Perheen ryhmätieto näyttää kaikki tiedot tästä perheestä, kuten avioliitot, multimediakohteet ja muistiinpanot. Näpäyttämällä paikkaa avautuu paikkaluettelo, missä kaikki muut paikkaan kytketyt perheet ja henkilöt näytetään. Näpäyttämällä päivämäärää avautuu päiväkalenteri, jossa näkyy tämän päivän ja kuukauden kaikki tapahtumat menneisyydessä. Myös multimediakohdetta voi näpäyttää, jolloin aukeaa kohteen näyttävä ikkuna. Näpäyttämällä lähdelinkkiä näytetn yksityiskohdat lähdesivulla.<br /><br />Lasten nimiruudun alla on linkki \"Lisää lapsi perheeseen\".<br />Lapsen nimiruudun vieressä on \"perheen ryhmätieto\".<br />Mikäli sinulla on riittävät oikeudet, voit tässä muuttaa, lisätä ja poistaa tietoja.<br /><br />Näytön oikealla reunalla on kuvakkeita ja linkkejä, joista voi tehdä seuraavaa  (mikäli se on sallittu):<br /><b>Näytä GEDCOM tietue</b> jolloin tiedot näkyvät GEDCOM-muodossa,<br /><b>Lisää leikekoriin</b>, jolloin voit tallentaa tiedon leikekoriin myöhempää omaan sukututkimusohjelmaasi latausta varten,<br /><b>Näytä pariskuntaa aikajanalla</b>, joka vie aikajanasivulle näyttäen pariskunnan kaikki tiedot aikajanalla.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]				= "~LISÄÄ LAPSI PERHEESEEN~<br /><br />Näpäyttämällä tätä linkkiä, voi lisätä lapsen tähän perheeseen.<br />Tämä on yksinkertaista: näpäytä linkkiä ja täytä kentät ponnahdusikkunassa.<br />";
$pgv_lang["show_fam_gedcom_help"]		= "~NÄYTÄ GEDCOM-TIETUE~<br /><br />Näpäyttämällä tätä linkkiä, ponnahdusikkunaan ilmestyy tätä perhettä koskevat tiedot GEDCOM-muodossa.";
$pgv_lang["add_fam_clip_help"]			= "~LISÄÄ PERHE LEIKEKORIIN~<br /><br />Näpäyttämällä tätä linkkiä voit lisätä GEDCOM-muodossa olevat perheen tiedot leikekoriin. Seuraavalla sivulla voit valita mitkä tiedot tarkalleen haluat lisätä: vain vanhemmat vai vanhemmat ja/tai lapset ja/tai heidän kaikki perillisensä.";
$pgv_lang["show_fam_timeline_help"]		= "~NÄYTÄ PARISKUNTA AIKAJANALLA~<br /><br />Tästä linkistä pääset aikajanasivulle, jossa kaikki tiedot pariskunnasta näytetään aikajanalla.";
//-- same variables as individuals page

//-- Source list-page
$pgv_lang["help_sourcelist.php"]		= "~LÄHDELUETTELOSIVU~<br /><br />Tällä sivulla näytetään lähdeluettelo.<br />Poiketen henkilö- ja perhesivusta tässä ei ole aakkosluetteloa ylhäällä. Tämä siksi, koska lähde voi olla henkilö, jolla on etu- ja sukunimi tai julkinen tietokanta tai laitos jne. Siksi on vaikeata löytää lajittelujärjestys. Lähteiden nimet on lajiteltu aakkosjärjestyksessä siten kun ne on tallennettu GEDCOM tiedostossa.<br /><br /><b>LÄHTEET</b><br /> Ilman lähteitä ei tietokantaa voi muodostaa, koska kaikki sinne tallennettu tieto on lähde. Lähde voi olla henkilön sukulainen, laitos, julkinen tietokanta jne.<br />Lähde voidaan linkittää useaan henkilöön. Toisaalta henkilö voi myös olla linkitetty useaan lähteeseen. Jokaiselle tapahtumalle voi olla oma lähteensä, oli sitten kysessä syntymäaika, ammatti, avioliittoon vihkiminen, lapset jne.";
$pgv_lang["sourcelist_listbox_help"]	= "~LÄHDELUETTELO~<br /><br />Tässä ruudussa näet lähteiden nimet niinkuin ne on tallennettu GEDCOM-tiedostoon.<br />Ne näytetään aakkosjärjestyksessä.<br /><br />Näpäyttämällä lähteen nimeä, avautuu lähdesivu, jossa on luettelo kyseiseen lähteeseen liitetyistä henkilöistä tai/ja perheistä.";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~LÄHTEIDEN TIEDOT SIVU~<br /><br />Tällä sivulla näytetään lähdettä koskevat yksityiskohtaiset tiedot. Lähteet ovat erittäin tärkeitä sukututkijoille ja niiden avulla voit seurata toisen tutkijan käyttämää reittiä tiedon lähteille.<br />Tällä sivulla voi olla tietoa lähteen otsikosta, kirjoittajasta, julkaisusta ja sijainnista. Koska lähteitä on useita eri tyyppejä, tiedon määrä vaihtelee lähteittäin.<br /><br />Mikäli lähteeseen on kytketty multimediakohde (kuten skannattu asiakirja), voit katsoa sitä suuremmassa ikkunassa joko näpäyttämällä kohdetta tai sen vierellä olevaa nimeä.<br /><br />Lähteen tietojen jälkeen on luettelo kaikista henkilöistä ja perheistä jotka on linkitetty tähän lähteeseen. Tämä näyttää kaiken tiedon joka on satu tietystä lähteestä.<br /><br />Tällä sivulla on vielä yksi tai kaksi valikkokuvaketta, mikäli ylläpitäjä on ne kytkenyt päälle:<br /><b>Näytä GEDCOM-tietue</b>, joka näyttä tiedon GEDCOM-muodossa.<br /><b>Lisää leikekoriin</b>, jolloin voit tallentaa tiedon leikekoriin myöhempää omaan sukututkimusohjelmaasi latausta varten.<br /><br />Lisätietoa saat näpäyttämällä <b>?</b> kohteiden perässä.";
$pgv_lang["sources_listbox_help"]		= "~TÄHÄN LÄHTEESEEN LINKITETYT TIETUEET~<br /><br />Tässä ruudussa on lueteltu tähän lähteeseen linkitetyt henkilöt ja perheet.<br />Nimet näytetään aakkosjärjestyksessä.<br /><br />Näpäyttämällä nimeä, siirryt kyseisen henkilön tai perheen sivulle.";
$pgv_lang["show_source_gedcom_help"]	= "~NÄYTÄ GEDCOM-TIETUE~<br /><br />Näpäyttämällä tätä linkkiä näytetään ponnahdusikkunassa tiedot lähteestä GEDCOM-muodossa.";
$pgv_lang["add_source_clip_help"]		= "~LISÄÄ LÄHDE LEIKEKORIIN~<br /><br />Näpäyttämällä linkkiä lisätään leikekoriin tiedot lähteestä GEDCOM-muodossa.";
$pgv_lang["delete_source_help"]			= "~POISTA LÄHDE GEDCOM-TIEDOSTOSTA~<br /><br />Näpäyttämällä tätä vaihtoehtoa merkitset tämän lähteen poistettavaksi GEDCOM-tiedostosta.<br />Mitä se merkitsee?<br />Oletetaan, että sinulla on hyvä syy poistaa lähde. Näpäyttämällä linkkiä aukeaa ponnahdusikkuna, jossa kysytään oletko varma vai haluatko perua.<br /><br />Jos jatkat poistamista saattaa kestää jonkin aikaa ennenkuin uusi ponnahdusikkuna aukeaa ilmoittaen poistamisen tapahtuneen.<br /><br />Kun jatkat vierailuasi sivustolla havaitset, että lähde on edelleen näkyvissä ja käytettävissä kuten aiemmin.<br /><br />Tämä <b>ei</b> ole virhe. Ylläpitäjä saa viestin muutoksesta GEDCOM-tiedostossa ja että olet poistanut lähteen.<br />Ylläpitäjä hyväksyy tai hylkää muutokset. Vasta sen jälkeen tapahtumaa ei voi perua.<br />Ongelmatapauksissa ylläpitäjä ottaa sinuun yhteyttä.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]			= "~PAIKKAHIERARKIA~<br />(tai henkilöt paikkaa kohti)<br /><br />Tällä sivulla näytetään luettelo paikoista ja henkilöistä tai perheistä, jotka on kytketty paikkaan.<br /><br />Mikäli henkilön tai perheen ja jonkun tapahtuman välillä on yhteyttä tietyllä paikalla, ohjelma löytää sen.<br /><br />Tulos näytetään kahdessa sarakkeessa:<br />toinen henkilöille ja toinen perheille.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~PAIKKOJEN JÄRJESTYSFORMAATTI~<br /><br /><b>OLETUSJÄRJESTYS</b><br />Tämä tarkoittaa, että GEDCOM-tiedostossa ei ole erityistä paikkajärjestystä.<br />Siinä tapauksessa käytetään vakioformaattia.<br /><br />Mikäli GEDCOM-tiedostosta löytyy toinen formaatti, se näytetään (...) merkkien välissä rivin lopussa.";
$pgv_lang["ppp_match_one_help"]			= "~PAIKKOJEN JÄRJESTYSFORMAATTI~<br /><br /><b>GEDCOMJÄRJESTYS</b><br />Paikat oletetaan koodatuiksi siinä järjestysformaatissa joka on GEDCOM-tiedostossa.<br />Se ohittaa vakiojärjestyksen jota käytetään, kun GEDCOM-tiedostosta ei löydy formaatin kuvaus.";
$pgv_lang["ppp_numfound_help"]			= "~LÖYTYI PAIKKAKYTKENTÖJÄ~<br /><br />Tässä näytetään löydettyjen kytkentöjen lukumäärä.<br />Mikäli vielä näet luettelon paikkoja, merkitsee se että et ole vielä päätynyt alimmalle tasolle.<br />Voit valita haluatko katsoa kaikki paikkaan liitetyt tietueet vai haluatko tarkentaa hakua näpäyttämällä toista paikkaa.";
$pgv_lang["ppp_levels_help"]			= "~PAIKKATASOT~<br /><br />Tämä näyttää parhaillaan näkyvät tasot.<br />Luetteloruutu, jossa tasot näkyvät, on ylimmän vasemmanpuoleisen tason alaluettelo.<br /><br />ESIMERKKI:<br />(Oletus)järjestys on : #pgv_lang[default_form]#<br />Mikäli nykyinen taso on \"Ylin taso\", luettelossa näkyvät kaikki GEDCOM-tiedoston maat.<br />Mikäli nykyinen taso on \"USA, Ylin taso\", silloin ruudussa on lueteltu kaikki USA:n osavaltiot.<br />Jne.<br /><br />Näpäytä tasoa palataksesi yhden tai useamman tason verran takaisinpäin.";
$pgv_lang["ppp_placelist_help"]			= "~PAIKKAHIERARKIA~<br /><br />Tässä luettelossa näytetään valitsemasi paikan alapuolella olevat paikat. Ellet ole valinnut paikkaa, näytetään luettelo ylimmän tason paikoista (esim. läänit tai maat).<br />Luettelon nimet ovat näpäytettävissä.<br />Paikan näpäyttäminen toimii kuin suodatin ja pääset yhden askelen alaspäin luettelossa.";
$pgv_lang["ppp_placelist_help2"]		= "~PAIKKALUETTELO~<br /><br />Tässä luettelossa näytetään tähän asti löydetyt paikat.<br />Luettelon nimet ovat näpäytettävissä.<br />Paikan näpäyttäminen toimii kuin suodatin ja pääset yhden askelen alaspäin luettelossa.<br />Vain ollessasi ylimällä tasolla, nimiluetteloa ei näytetä. Kaikilla alemmilla tasoilla näytetään kaikkien niiden henkilöiden tai perheiden nimet, jotka liittyvät kyseiseen paikkaan.";
$pgv_lang["ppp_view_records_help"]		= "~KATSO KAIKKI TIETUEET~<br /><br /> Näpäyttämällä tätä linkkiä luetellaan kaikkien henkilöiden tai perheiden nimet, jotka ovat olleet tekemisissä kyseisen paikan kanssa. Kun olet paikkahierarkian lopussa, näytetään nimet automaattisesti.";
$pgv_lang["ppp_name_list_help"]			= "~NIMILUETTELO~<br /><br />Tämä ruutu näyttää täydellisen luettelon henkilöistä ja/tai perheistä, jotka liittyvät paikkaan.<br /><br />Nimet luettelossa ovat näpäytettävissä.<br /><br />Kun näpäytät nimeä, pääset kyseisen henkilön tai perheen sivulle.<br /><br />Voit myös vaihtaa valintaasi näpäyttämällä luettelon ylintä paikkaa.";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]			= "~MULTIMEDIAKOHDELUETTELO~<br /><br />Tällä sivulla luetellaan kaikki tässä GEDCOM-tiedotossa olevat multimediakohteet (MMK).<br /><br />Jokaisella kohteella on kohteen otsikko tai tiedostonimi, niiden henkilöiden tai perheiden nimet, jotka liittyvät siihen sekä kohteeseen liittyviä muita tietoja.<br /><br />Voit näpäyttää kohteen pienoiskuvaa tai nimeä tai otsikkoa, jolloin tiedoston muodosta riippuen (*.gif tai *.jpg) kuva aukeaa joko sisäiseen PGV katselimeen tai selaimeesi kytkettyyn katselimeen.<br /><br />Näpäyttämällä \"Katso\"-linkkiä henkilön tai perheen vieressä, vie ohjelma sinut kyseiselle henkilö- tai perhesivulle.";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]		= "~LATAA MEDIATIEDOSTO PALVELIMELLE~<br /><br />Tiedoston lataaminen palvelimelle on yksinkertainen toimenpide ja tässä onkin vain vähän lisätietoa.<br /><br /><b>Pienoiskuva</b><br />Pienoiskuvan tulisi olla noin 100 pikseliä leveä.<br />Tiedostonimen tulee olla sama kuin alkuperäiskuvalla.<br /><br /><b>Lataus serverille</b><br />Tiedostot ladataan automaattisesti hakemistoon <b>#GLOBALS[MEDIA_DIRECTORY]#</b> ja pienoiskuvat hakemistoon <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]			= "~VUOSIPÄIVÄKALENTERI~<br /><br /><ul><li><a href=\"#calendar_general\">Yleistä</a><li><a href=\"#calendar_day\">#pgv_lang[day]#</a><li><a href=\"#calendar_month\">#pgv_lang[month]#</a><li><a href=\"#calendar_year\">#pgv_lang[year]#</a><li><a href=\"#calendar_show\">#pgv_lang[show]# / #pgv_lang[showcal]#</a><li><a href=\"#calendar_sex\">#pgv_lang[sex]#</a><li><a href=\"#calendar_event\">Tapahtuma</a><li><a href=\"#calendar_button\">Valitse tila (painikkeet))</a><li><a href=\"#calendar_tip\">Tip</a></ul><br /><a name=\"calendar_general\"></a>Vuosipäiväkalenteri näyttää ne henkilöt tai perheet jotka on kytketty tiettyyn tapahtumaan tiettynä päivänä ja/tai kuukautena tai aikajaksona. Siinä on edistyksellinen suodatusjärjestelmä oikean päivämäärän,  aikajakson tai tapahtuman valitsemiseksi.<dl><dt><b>Näytä <a href=\"#calendar_day\">päivä</a></b></dt><dd> Tämä näyttää tapahtumat tiettynä päivänä vuosiluvusta riippumatta. Se palauttaa joko yksinkertaisen luettelon henkilöiden tai perheiden nimiä tai kaksisarakkeisen luettelon, jossa henkilöt ovat toisessa ja perheet toisessa sarakkeessa. </dd><dt><b>Näytä <a href=\"#calendar_month\">kuukausi</a></b></dt><dd><b>Kalenterissa</b> henkilöiden ja perheiden nimet näytetään päiväruuduissa. Kalenteri näytetään sellaisen kuin se oli sinä vuonna jonka syötit vuosiruutuun. Kaikki tapahtumat menneisyydestä ilmoittamaasi vuoteen saakka näytetään. Yhdessä valinnan \"<a href=\"#calendar_show\">#pgv_lang[recent_events]#</a>\" kanssa saadaan todenmukainen kuva siitä, millainen kalenteri oli esivanhemmillamme.</dd><dt><b>Näytä <a href=\"#calendar_year\">vuosi</a></b></dt><dd>Tämä valinta näyttää tapahtumat tiettynä vuotena tai vuosina. Se palauttaa joko yksinkertaisen luettelon henkilöiden tai perheiden nimiä tai kaksisarakkeisen luettelon, jossa henkilöt ovat toisessa ja perheet toisessa sarakkeessa.</dd></dl>  Kalenterivalikossa näytetään nyt valittu päivä ja kuukausi korostetulla värillä.<br /><br />Luettelossa tai kalenterissa näytettävät nimet ovat näpäytettävissä.<br />Nimen näpäyttäminen vie kyseiselle henkilö- tai perhesivulle, päivämäärän näpäyttäminen vie \"Tänä päivänä\"-tilaan, missä näytetään kaikki näpäytetyn päivämäärän päivän ja kuukauden tapahtumat.<br /><br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_day\"></a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_month\"></a>#pgv_lang[annivers_month_select_help]#<br /><br /><a href=\"#top\">#pgv_lang[UpArrow]#</a> <a name=\"calendar_year\"></a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_show\"> </a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_sex\"></a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_event\"></a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_button\"> </a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_tip\"> </a>#pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]	= "~PÄIVÄMÄÄRÄVALITSIN~<br /><br />\"Valitsintaulukon\" ylin rivi on <b>Päivävalitsin</b>.<br />Sillä valitset päivämäärän.<br />Tietyn päivän näpäyttämisen vaikutus riippuu siitä, oletko  \"päivätilassa\" vai \"kuukausitilassa\".<br /><br /><b>Päivätila</b>:<br />Kun näpäytätä päivää näyttö päivittyy ja kyseisen päivän luettelo näytetään.<br /><br /><b>Kuukausitila</b>:<br />Kun näytöllä on tietyn kuukauden kalenteri ja näpäytät tiettyä päivää näyttö päivittyy, mutta sama kuukausi on edelleen näkyvissä.<br />Syynä tähän on se, että voit vielä vaihtaa toiseen kuukauteen, vuoteen tai tapahtumaan ennenkuin näpäytät joko <b>#pgv_lang[viewday]#</b> tai <b>#pgv_lang[viewmonth]# painiketta</b>.<br /><br />Näpäyttämällä päivärivin lopussa olevaa <b>\"Pikalinkkiä\"</b>, jossa on tämän päivän päiväys, saat näkyviin luettelon tämän päivän tapahtumista riippumatta siitä, oletko \"Päivätilaassa\" vai \"Kuukausitilassa\".<br />";
$pgv_lang["annivers_month_select_help"]	= "~KUUKAUSIVALITSIN~<br /><br />\"Valitsintaulukon\" keskirivi on <b>Kuukausivalitsin</b><br />Sen avulla valitset kuukauden.<br /><br />Tietyn kuukauden näpäytyksen vaikutus riippuu siitä, oletko  \"päivätilassa\" vai \"kuukausitilassa\".<br /><br /><b>Päivätila</b>:<br />Kun näpäytätä kuukautta näyttö päivittyy ja kyseisen kuukauden päivät näytetään.<br />Kaikki muut asetukset kuten päivä, vuosi ja tapahtumat säilyvät ennallaan. <br /><br /><b>Kuukausitila</b>:<br />Kun ruudulla on kalenteri kuukausitilassa ja näpäytät kuukautta valitsimen kuukausirivillä, tulee näyttöön kyseinen kuukausi.<br /><br />Kuukausirivin lopussa on <b>\"Pikalinkki\"</b> nykyiseen kuukauteen.<br />Tätä näpäyttämällä näytetään nykyinen kuukausi riippumatta siitä, oletko \"päivätilassa\" vai \"kuukausitilassa\".";
$pgv_lang["annivers_year_select_help"]	= "~VUOSIKENTTÄ~<br /><br />Tätä kenttää käytetään vuoden muuttamiseksi kalenterissa \"kuukausitilassa\" tai luetteloa \"vuositilassa\".<br />Vuoden muuttaminen \"päivätilassa\" ei aiheuta muutoksia, koska kaikki vuoden tapahtumat näytetään.<dl><dt><b>Editykselliset ominaisuudet</b> <b>#pgv_lang[viewyear]#:lle:<br />Yli yksi vuosi</b></dt><dd>Voit hakea yli yhden vuoden tapahtumat syöttämällä vuosikenttään halutut vuodet:<br />- Esimerkki 1: <b>1992-5</b> kaikki tapahtumat vuodesta 1992 vuoteen 1995.<br />- Esimerkki 2: <b>1972-89</b> kaikki tapahtumat vuodesta 1972 vuoteen 1989.<br />- Esimerkki 3: <b>1610-759</b><br />kaikki tapahtumat vuodesta 1610 vuoteen 1759.<br />- Esimerkki 4: <b>1880-1905</b> kaikki tapahtumat vuodesta 1880 vuoteen 1905.<br />- Esimerkki 5: <b>880-1105</b> kaikki tapahtumat vuodesta 880 vuoteen 1105.<br /><br />Voit myös jättää pois vuoden viimeisen luvun saadaksesi tietyn vuosikymmenen kaikki tapahtumat.<br />Esimerkiksi <b>197</b> näyttää kaikki tapahtumat vuodesta 1970 vuoteen 1979.</dd><dt><br /><b>Lyhenteet</b></dt><dd>Joskus saattaa olla epäselvää, milloin tarkalleen joku tapahtuma sattui. Siinä tapauksessa voi käyttää merkintöjä \"jälkeen\", \"ennen\" ja \"noin\" päivämäärän yhteydessä. Päivämäärät tallennetaan GEDCOM-tiedostoon yhdessä merkinnän lyhenteen kanssa. \"Vuositilassa\" voit tehdä haun termillä myös ilman päivämäärää. Muutamia esimerkkejä tällaisista hauista:<br /><b>abt</b> 1800 (abt = noin)<br /><b>bet</b> 1950-1959 (bet = välissä) syötä: bet 1950 tai: 1950-59<br /><b>bef</b> 1950 (bef = ennen)<br /><b>aft</b> 1900 (aft = jälkeen)<br /><br /><b>Huomaa:</b> PhpGedView etsii täsmällistä merkkijonoa. Kun haet \"abt 1850\", päivämäärä, joka on tallennettu muodossa \"abt oct 1850\" <b>ei</b> löydy. - Voit syöttää myös pelkän lyhenteen ilman vuosilukua jolloin löytyy kaikki ne tapahtumat, joiden päiväyksessä kyseinen lyhenne esiintyy, luetellaan.</dd></dl>Uuden vuosiluvun lisääminen ei automaattisesti päivitä näyttöä.<br />Koska tämä kenttä ei ole linkki, sinun on näpäytettävä painiketa <b>#pgv_lang[viewmonth]#</b> tai <b>#pgv_lang[viewyear]#</b> ennen näytön päivittymistä.<br />";
$pgv_lang["annivers_show_help"]			= "~NÄYTÄ TAPAHTUMAT...~<br />Mikäli et ole kirjautunut järjestelmään, voit valita kahdesta vaihtoehdosta:<br /><br /><b>1. Kaikki henkilöt</b><br />Tällä vaihtoehdolla näytetään kaikki henkilöt ja perheet.<br /><br /><b>2. Viimeiset vuodet (100 vuotta)</b><br />Tällä vaihtoehdolla näytetään kaikki tapahtumat valittuna päivänä tai kuukautena, mutta ei yli 100 vuotta kauemmaksi.<br /><br />On myös olemassa kolmas vaihtoehto, mutta joko sinun on oltava sisäänkirjautunut tai ylläpitäjän on täytynyt asettaa järjestelmä näyttämään myös elävät henkilöt kaikille.<br /><br /><b>3. Elävät henkilöt</b><br />Kun tämä vaihtoehto on valittu, vain elävien henkilöiden tapahtumat näytetään.<br /><br />Näpäyttämällä vaihtoehtoa näyttö päivittyy ja valitsemasi tapahtumat näytetään.<br />Päivä-, kuukausi- ja vuosiasetus sekä päivätila tai kuukausitila jäävät ennalleen.<br />";
$pgv_lang["annivers_sex_help"]			= "~SUKUPUOLEN VALITSIN~<br />Kun olet kirjautunut järjestelmään (tai jos ylläpitäjä on estänyt yksityisyysasetuksen) voit valita kolmesta vaihtoehdosta:<dl><dt><b>1. Kaikki-kuvake</b></dt><dd>Tällä vaihtoehdolla (vakio) kaikkien henkilöiden tai perheiden tapahtumat näytetään.</dd><dt><b>2. Mies-kuvake</b></dt><dd>Vain miespuolisten henkilöiden tapahtumat näytetään. Perhetapahtumien miehet näytetään.</dd><dt><b>3. Nainen-kuvake</b></dt><dd>Vain naispuolisten henkilöiden tapahtumat näytetään. Perhetapahtumien naiset näytetään.</dd></dl>Vaihtoehdon näpäyttäminen päivittää näytön ja valitsemasi tapahtumat näytetään.<br />Päivä-, kuukausi- ja vuosiasetus sekä päivätila tai kuukausitila jäävät ennalleen.<br />";
$pgv_lang["annivers_event_help"]		= "~TAPAHTUMAVALITSIN~<br />Tässä voit valita näytetäänkö kaikki henkilöitä tai perheitä koskevat tapahtumat vai ainoastaan valitsemasi tapahtumat.<br /><br />Vaihtoehdon näpäyttäminen päivittää näytön ja valitsemasi tapahtumat näytetään.<br />Päivä-, kuukausi- ja vuosiasetus sekä päivätila tai kuukausitila jäävät ennalleen.<br />";
$pgv_lang["annivers_tip_help"]			= "~VIHJE~<br />Oletetaan, että sinulla on 25 tammikuuta 1875 syntynyt sukulainen.<br />Säädä päivävalitsin siihen päivään.<br />Kun nyt näpäytät jotain Näytä-painiketta, näytetään kyseistä päivää koskeva luettelo tai kalenteri.<br />Kaikki iät, vuosipäivät jne. lasketaan uudestaan taaksepäin siitä päivämäärästä lähtien, jonka olet asettanut päivävalitsimeen.<br />Näet siis kalenterin samoin kuin sukulaisesi olisi nähnyt kauan sitten.<br />";
$pgv_lang["day_month_help"]				= "~NÄYTÄ PÄIVÄ/NÄYTÄ KUUKAUSI/NÄYTÄ VUOSI PAINIKKEET~<br /><br /><b>Näytä päivä</b> painike näyttää luettelon valitun päivän tapahtumista. Kaikki vuodet käydään läpi, joten ainoastaan päivä ja kuukausi voidaan valita tässä. Vuosiluvun muuttaminen ei vaikuta.<br />Voit rajoittaa luetteloa valitsemalla \"Viimeiset vuodet\" tai mikäli mahdollista \"Elävät henkilöt\".<br />Henkilöiden ikä lasketaan voimassa olevasta vuodesta.<br /><br /><b>Näytä kuukausi</b> painike näyttää  valitusta kuukaudesta ja vuodesta kalenterikaavion. Tässä voit rajoittaa luetteloa näpäyttämällä \"Viimeiset vuodet\" tai \"Elävät henkilöt\".<br />Vlitsemalla vuoden menneisyydestä samanaikaisesti \"Viimeiset vuodet\" vaihtoehdon kanssa saat realistisen vaikutelman siitä, miltä kalenteri on näyttänyt esi-isiesi silmin. Kaikki ikävuodet kalenterissa näytetään suhteessa vuosikentässä olevaan vuosilukuun.<br /><br /><b>Näytä vuosi</b> painike näyttää valitun vuoden tapahtumat.<br />Voit taas rajoittaa luetteloa valitsemalla \"Viimeiset vuodet\" tai mikäli mahdollista \"Elävät henkilöt\".<br />Mukava ominaisuus on mahdollisuus valita näyttää useamman vuoden tapahtumat: Syötä jälkimmäisen vuoden viimeinen luku ensimmäisen perään erotettuna \"-\"-merkillä. (Esierkki: 1924-6 näyttää kaikki tapahtumat vuodesta 1924 vuoteen 1926 tai 1976-1984 kaikki tapahtumat vuodesta 1976 vuoteen 1984.)<br />- Voit myös syöttää vain vuosiluvun ensimmäiset numerot, jolloin näytetään kaikki vuodet, jotka alkavat sillä numerolla (Esim. 197 näyttää kaikki vuodet välillä 1970-1979)<br /><br /> Kun haluat <b>muuttaa vuosiluvun</b> sinun <b>on</b> painettava jotakin näistä kolmesta painikkeesta.</b><br /><br />Kaikki muut asetukset pysyvät ennallaan painettaessa jotakin näistä painikkeista.<br />";

//-- Clipping Cart-page
$pgv_lang["help_clippings.php"]			= "~Sukupuun leikekori~<br />Leikekori mahdollistaa \"leikkeiden\" tallentamisen tästä sukupuusta leikekoriin ja liittämään ne yhdeksi GEDCOM-tiedostoksi omalle koneelle lataamista varten.<br /><br />* Kuinka leike tehdään?<br />Tämä on helppoa. Aina kun näet näpäytettävissä olevan nimen (henkilön, perheen tai paikan) voit mennä kyseiselle sivulle. Siellä näet vaihtoehdon \"Lisää leikekoriin\".<br />Näpäyttämällä sitä linkkiä avautuu sivu, jossa on monta vaihtoehtoa ladata tiedosto.<br /><br />* Kuinka ladata tiedosto koneellesi?<br />Kun sinulla on haluamasi tiedot leikekorissa näpäytä \"Lataa nyt koneesta\"-linkkiä.<br />Seuraa sen jälkeen ohjeita ja linkkejä.";
$pgv_lang["clip_download_help"]			= "~LATAA LEIKKEET~<br /><br />Näpäyttämällä tätä linkkiä avautuu seuraava sivu.<br />Mikäli valittavana on useita vaihtoehtoja ladattaviksi kohteiksi GEDCOM-leikkeessä, ne näytetään tällä sivulla. Seuraa vain ohjeita.";
$pgv_lang["empty_cart_help"]			= "~TYHJENNÄ LEIKEKORI~<br /><br />Näpäyttämällä tätä, leikekorisi tyhjenee kokonaan.<br /><br />Mikäli et halua poistaa kaikkia henkilöitä, perheitä ja paikkoja leikekorista, voit poistaa ne yksitellen näpäyttämällä \"Poista\" linkkiä nimiruuduissa.";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]			= "~NÄYTÄ MUUTOKSET GEDCOM-TIEDOSTOSSA~<br /><br />Kun tämä viesti näytetään se merkitsee kahta asiaa:<br /><br />1. Joku on tehnyt muutoksia GEDCOM-tiedostoon.<br />Tietueita on lisätty, poistettu tai muutettu.<br /><br />2. Ylläpitäjä ei vielä ole hyväksynyt muutoksia.<br />Kun muutokset on hyväksytty (tai hylätty), et enää näe tätä viestiä.<br /><br /><br />Näpäyttämällä linkkiä, näet mitä muuoksia on tehty.<br />Jos huomaat, että muutos on virheellinen, ilmoita siitä ylläpitäjälle.";

//-- Search-page
$pgv_lang["help_search.php"]			= "~HAKUSIVU~<br /><br />Vaikka sivu on yksinkertaisen näköinen, sen taustalla on kaksi tehokasta hakumoottori..<br /><br />Useimmat sukututkimussivut sallivat haun vain (suku)nimen perusteella. Tällä sivustolla voit käytännössä hake mitä tahansa.<br /><br />Hakukenttä näytön vasemmalla laidalla on sama kuin otsikkoalueella.<br /><br />Mikäli etsin henkilöitä, jotka liittyvät tiettyyn vuosilukuun, kirjoita pelkästään vuosiluku. Ohjelma hakee kaikki siihen liittyvän.<br /><br />Haetko nimeä tai paikkaa?<br />Kirjoita vain nimi tai paikka tai osa siitä ja ohjelma hoitaa loput.<br /><br />SOUNDEX-menetelmä.<br />Oikealla puolella olevalla hakukentällä voit hakea henkilöiden nimiä tai paikkoja vaikka et tietäisikään niiden oikeata kirjoitusasua.<br /><br />Lisää tietoa näistä kahdesta hakukentästä saat näpäyttämällä <b>?</b> kenttien yläpuolella.<br /><br />";
$pgv_lang["search_enter_terms_help"]	= "~SYÖTÄ HAKUTERMIT~<br /><br />Tähän hakukenttään voit syöttää etu- ja sukunimiä, paikkoja, multimediaa, jne.<br /><br /><b>Jokerimerkit</b><br />Jokerimerkit sellaisin kuin ne tunnet (esim. *), eivät ole sallittuja, vaan ohjelma olettaa automaattisesti jokerimerkit.<br />Mitä se merkitsee?<br />Oletetaan, että kirjoitat hakukenttään \"<b>Kai</b>\".<br />Hakutulos voi olla (jos tieto on olemassa tietokannassa):<br /><b>Kai</b> Järvinen<br /><b>Kai</b>ja Saari<br />Siiri <b>Kai</b>nulainen<br />Joku, joka on syntynyt 01.01.1901 <b>Kai</b>rossa<br />Jne., jne..<br /><br /><b>Päivämäärät</b><br />Vuosiluvun syöttäminen hakukenttään palauttaa kaikki ne nimet, jotka jollain tavoin liittyvät kyseiseen vuoteen.<br />Mikäli syötät 1950, tuloksena saadaan kaikki sinä vuonna syntyneet, kuolleet, naimisiin menneet... mitä tahansa muita tapahtumia sinä vuonna.<br />Mikäli syötät \"4 Dec\", kaikki siihen päivään littyvät henkilöt kaikkina vuosina palautetaan.<br />Mutta myös henkilöt, jotka liittyvät päivämääriin 14. ja 24. joulukuuta luetellaan.<br />Kuten huomaat myös tässä tapauksessa oletetaan jokerimerkit, joten niitä ei tarvitse syöttää.<br /><br /><b>Oikea päivämäärämuoto</b><br />Ohjelma etsii tietoa sellaisen kuin se on syötetty GEDCOM-tiedostoon.<br />Jos siis haluat hakea tapahtumaa joulukuun 14., sinun on syötettävä:<br /><b>14 dec</b><br /> koska tieto syötetään tässä muodossa GEDCOM-tiedostoon..<br />Mikäli kirjoitat <b>dec 14</b> palautetaan henkilöt, jotka liittyvät tapahtumaan 08 <b>dec</b>ember 18<b>14</b>. Voit myös käyttää normaalimuotoja haussasi, jos ne ovat sinulle tuttuja. Mikäli esimerkiksi haluat luettelon kaikista henkilöistä joille on kytketty tapahtuma 1900-luvulla, voit syöttää 19[0-9][0-9]ja saat osuman kaikista henkilöistä vuosilta 1900-1999.<br /><br />Mikäli tarvitset enemmän tietoa hakujärjestelmästä, ota yhteyttä meihin niin laajennamme tätä ohjetiedostoa.";
$pgv_lang["soundex_search_help"]		= "~HAE TAVALLA, JOLLA KUVITTELET NIMEN KIRJOITETTAVAN (SOUNDEX)~<br /><br />Myös SOUNDEX nimihaku on varsin tehokas.<br />Aluksi lyhyt selostus SOUNDEXista:<br /><br />SOUNDEX järjestää yhteen nimet, jotka kuulostavat samanlaisilta mutta jotka kirjoitetaan eri tavalla. SOUNDEX-koodi alkaa nimen ensimmäisellä kirjaimella jota seuraa kolmenumeroinen koodi, joka edustaa kolmea ensimmäistä jäljellä olevaa konsonanttia. Nimiin, joissa ei ole riittävästi koodattavia kirjaimia, lisätään nollia.<br /><br />Eli:<br />mikäli etsit nimeä \"Smith\", voit saada tulokseksi:<br />Smith - Smid - Smit - Schmidt, Smyth, Smithe, Smithee, Schmitt, Smead, Sneed, Smoote jne.<br /><br />Sinun ei tarvitse vaivata päätäsi SOUNDEX-koodeilla.<br />Kirjoita vain etsimäsi nimi ja ohjelma tekee loput.<br /><br />SOUNDEX-systeemi on kätevä: tiedät nimen mutta et sen tarkkaa kirjoitusasua.<br />Joskus tietokantaan on saatettu syöttää väärin kirjoitettu nimi.<br />Käyttämäll SOUNDEXia saatat kuitenkin löytää nimen.<br /><br />Voit totutella SOUNDEXin käyttöön, koeta löytää tietty nimi mutta syötä se hakukenttään väärin kirjoitettuna.<br /><br />Tässä SOUNDEX-järjestelmässä millä tahansa nimellä voi aloittaa haun.<br />Voit hakea etunimen, sukunimen tai paikan nimen.<br />Syöttämällä Useampaan kuin yhteen kenttään syöttäminen toimii \"JA\" ehdon tavoin.<br /> Voit myös rajoittaa hakua syöttämällä vuosiluku tai vuosilukualue. Esimerkkeinä 1950 tai 19[5-7][0-9], mikä edustaa vuosilukuja 1950 - 1979.<br />Hakutuloksena ovat kaikki henkilöt, jotka esiintyvät tietyssä paikassa kyseisellä vuosilukualueella.";

//-- Individuals-page
$pgv_lang["help_individual.php"]		= "~HENKILÖSIVUT~<br /><br />Tällä sivulla näkyvät henkilöä koskevat yksityiskohtaiset tiedot.<br /><br />Mikäli käytettävissä on kuva, se näkyy ylhäällä vasemmalla.<br />Kuvan vierellä ovat henkilön nimet.<br />Nimiin voi liittyä huomautuksia ja lähteitä. Mikäli nimeen on liitetty huomautuksia tai lähteitä  ne näkyvät luettelona nimen alla. Myös henkilön lempinimi näytetään, jos sellainen on olemassa.<br /><br />Mikäli sinulla on editointioikeudet, \"Editoi\" ja \"Poista\" linkit näkyvät niiden nimien kohdalla.<br /><br />Tällä sivulla näkyvät myös välilehtilinkit \"Henkilön tietoja\", \"Lisätietoja\", \"Lähteitä\", \"Media\" ja \"Lähisukulaisia\". Näillä välilehdillä ovat kaikki GEDCOM-tiedostoon tallennetut tiedot.<br /><br />\"Henkilön tietoja\" välilehdellä ovat kaikki tiedot henkilöstä ja hänen avioliito(i)staan. Näpäyttämällä päivämäärää aukeaa kyseisen päivän vuosipäiväkalenteri, josta näkyvät tässä GEDCOM-tiedostossa olevat tapahtumat kyseisenä päivänä. Näpäyttämällä paikkaa avautuu paikkahierarkia, missä näytetään muut henkilöt, joihin liittyi tapahtumia kyseisellä paikkakunnalla. Avioliitto- ja muita perhetietoja varten näkyy puolison nimi, josta pääsee puolison tietoihin. Perhetietueeseen o myös linkki.<br /><br />\"Lisätietoja\"-välilehdellä on muita kyseiseen henkilöön liittyviä tietoja.<br /><br />\"Lähteitä\"-välilehdellä ovat kaikki kyseiseen henkilöön liittyvät yleiset lähteet. Näpäyttämällä lähdettä, avautuu yksityiskohtainen lähteeseen liittyvä sivu, jossa luetteloidaan myös muut kyseiseen lähteeseen liittyvät henkilöt.<br /><br />\"Media\"-välilehdellä luetteloidaan kaikki kyseiseen henkilöön liittyvät kuvat ja muu media. Näpäyttämällä pienoiskuvaa aukeaa täysikokoinen kuva.<br /><br />\"Lähisukulaisia\"-välilehdellä luetellaan henkilön vanhemmat ja sisarukset sekä aviopuolisot ja lapset. Henkilöt luetteloidaan samanlaisissa ruuduissa joita jo muissa kaavioissa olet ehkä nähnyt.<br /><br />Näytön oikealla laidalla on linkkiruutu.<br />Monet ruudun linkeistä ovat samat kuin valikoissa. Esimerkikisi näpäyttämällä \"Esipolvikaavio\"-linkkiä sivustalla olevassa linkkiruudussa avautuu kyseisen henkilön esipolvikaavio. Tämä eroaa valikkolinkistä siinä, että näpäyttämällä valikon \"Esipolvikaavio\"-linkkiä avautuu tämän GEDCOM-tiedoston oletusesipolvikaavio.<br /><br />Mikäli ylläpitäjä on sen mahdollistanut, näkyy linkkiruudussa myös \"Näytä GEDCOM tietue\". Tämä näyttää kyseisen henkilön tietueen GEDCOM-raakamuodossa.<br /><br />Mikäli ylläpitäjä on mahdollistanut leikekorin, löytyy myös linkki kyseisen henkilön GEDCOM-tietojen lisäämiseksi leikekoriin.<br /><br />\"Sukulaisuus minuun\" linkki näkyy vain, mikäli olet kirjautunut järjestelmään ja sinulla on ID-tunnus GEDCOM-tiedostossa. Tämä linkki vie esipolvikaavioon ja näyttää, miten olet sukua kyseiselle henkilölle.<br /><br /> Lisäohjeita löytyy näpäyttämällä <b>?</b> linkin vieressä.";
$pgv_lang["delete_person_help"]			= "~POISTA TÄMÄ HENKILÖ ~<br /><br /><br />Näpäyttämällä tätä merkitset tämän HENKILÖN poistettavaksi GEDCOM-tiedostosta.<br /><br />Mitä se merkitsee?<br />Olettaen, että sinulla on hyvä syy poistaa tämä henkilö GEDCOM-tiedostosta näpäytät tätä linkkiä, jolloin avautuu ponnahdusikkuna, jossa kysytään oletko varma tai peruuta.<br /><br />Mikäli jatkat poistamista saattaa kestää hetken, ennenkuin uusi ponnahdusikkuna ilmoittaa, että henkilö on poistettu.<br /><br />Kun jatkat vierailuasi sivustolla havaitset, että poistettu henkilö on vielä näkyvissä ja käytettävissä kuten ennenkin.<br /><br />Tämä <b>ei</b> ole virhe.<br />Ylläpitäjä saa viestin, että GEDCOM-tiedostoon on tehty muutos ja että poistit henkilön.<br />Ylläpitäjän on hyväksyttävä (tai hylättävä) muutos. Vasta sitten muutos on voimassa.<br />Tarvittaessa ylläpitäjä ottaa yhteyttä sinuun.";
$pgv_lang["delete_name_help"]			= "~MUUTA TAI PYYHI NIMI GEDCOM-TIEDOSTOSTA~<br /><br />Näpäytämällä tätä linkkiä avautuu ponnahdusikkuna, jossa voit muuttaa henkilön nimeä.<br />Se on helppoa: kirjoita muutokset ruutuihin, näpäytä painiketta ja sulje ponnahdusikkuna.<br /><br /><b>PYYHI NIMI</b> Näpäyttämällä tätä vaihtoehtoa merkitset nimen poistettavaksi GEDCOM-tiedostosta. Huomaa, että tämä on kokonaan eri asia kuin henkilön poistaminen. Vain nimi poistuu, ei henkilö.<br />Mikäli haluat poistaa lempinimen, muut nimet säilyvät.<br />Mikäli poistat ainoan nimen, henkilö jää jäljelle \"tuntemattomana\"<br />Henkilöä ei myöskään kytketä irti mistään linkistä sukulaisiinsa, paikkoihin, lähteisiin jne.<br />Kuinka tämä toimii?<br />Olettaen, että sinulla on hyvä syy poistaa tämä nimi GEDCOM-tiedostosta näpäytät tätä linkkiä, jolloin avautuu ponnahdusikkuna, jossa kysytään oletko varma tai peruuta.<br /><br />Mikäli jatkat poistamista saattaa kestää hetken, ennenkuin uusi ponnahdusikkuna ilmoittaa, että nimi on poistettu.<br /><br />Kun jatkat vierailuasi sivustolla havaitset, että poistettu nimi on vielä näkyvissä ja käytettävissä kuten ennenkin.<br /><br />Tämä <b>ei</b> ole virhe.<br />Ylläpitäjä saa viestin, että GEDCOM-tiedostoon on tehty muutos ja että poistit nimen.<br />Ylläpitäjän on hyväksyttävä (tai hylättävä) muutos. Vasta sitten muutos on voimassa.<br />Tarvittaessa ylläpitäjä ottaa yhteyttä sinuun.";
$pgv_lang["add_name_help"]				= "~LISÄÄ NIMI~<br /><br />Tämä linkki antaa sinun lisätä uuden nimen henkilölle. Josku henkilöt tunnetaan lempinimellä tai aliaksena. Tämä linkki mahdollistaa uuden nimen lisäämisen henkilölle muuttamatta vanhaa nimeä.";
$pgv_lang["add_sibling_help"]			= "~LISÄÄ SISARUS~<br /><br />Näpäyttämällä tätä linkkiä voit lisätä uuden lapsen tähän perheeseen.<br />\"Tämä perhe\" on tässä tapauksessa tämän näytön henkilön isä ja äiti.<br />Joten pidä mielessä, että olet lisäämässä siskon tai veljen kyseiselle henkilölle.<br />Sisaruksen lisääminen on helppoa: näpäytä linkkiä ja täytä ruudut avautuvassa ponnahdusikkunassa ja lopuksi näpäytä \"Tallenna\".<br /><br />Mikäli haluat lisätä henkilölle pojan tai tyttären, vieritä ruutua alaspäin ja näpäytä linkkiä \"Perhe puolisoineen\".";
$pgv_lang["add_son_daughter_help"]		= "~LISÄÄ POIKA TAI TYTÄR~<br /><br />Näpäyttämällä tätä linkkiä voit lisätä lapsen tähän perheeseen.\"Tämä perhe\" on tässä tapauksessa tämän näytön päähenkilön ja hänen puolisonsa.<br />Joten pidä mielessä, että olet lisäämässä pojan tai tyttären kyseiselle henkilölle.<br />Lapsen lisääminen on helppoa: näpäytä linkkiä ja täytä ruudut avautuvassa ponnahdusikkunassa ja lopuksi näpäytä \"Tallenna\".<br /><br />Mikäli haluat lisätä henkilölle veljen tai sisaren, vieritä ruutua alaspäin ja näpäytä linkkiä \"Perhe vanhempineen\".";
$pgv_lang["link_child_help"]			= "~LIITÄ TÄMÄ HENKILÖ LAPSEKSI OLEMASSA OLEVAAN PERHEESEEN ~<br /><br />Näpäyttämällä tätä linkkiä voit liittää hänet lapseksi olemassa olevaan perheeseen.<br /><br />Oletetaan, että tämän henkilön vanhemmat ovat tuntemattomia, mutta ilmeneekin, että vanhemmilla onkin tietue tässä GEDCOM-tiedostossa.<br /><br />Näpäytä linkkiä, lisää perheen ID-tunnus (mikäli et tiedä ID-tunnusta, voit etsiä sitä ponnahdusikkunassa) ja homma on hoidettu.";
$pgv_lang["link_husband_help"]			= "~LIITÄ TÄMÄ HENKILÖ AVIOMIEHEKSI OLEMASSA OLEVAAN PERHEESEEN ~<br /><br />Näpäyttämällä tätä linkkiä voit liittää hänet aviomieheksi olemassa olevaan perheeseen, jonka aviomies on tähän asti ollut tuntematon.<br /><br />Kyseinen henkilö korvaa näin tuntemattoman henkilön. Kaikki tapahtumat, avioliittotiedot ja lapset säilyttävät entiset kytkennät perheeseen.<br /><br />Näpäytä linkkiä, lisää perheen ID-tunnus (mikäli et tiedä ID-tunnusta, voit etsiä sitä ponnahdusikkunassa) ja homma on hoidettu. Tämä on edistyksellinen editointivaihtoehto, jota saa käyttää vain mikäli linkitettävä perhe on jo olemassa GEDCOM-tiedostossa. Mikäli haluat lisätä uuden perheen, käytä \"Lisää uusi vaimo\" linkkiä.";
$pgv_lang["add_husband_help"]			= "~LISÄÄ UUSI AVIOMIES~<br /><br />Näpäyttämällä tätä linkkiä voit lisätä \"uuden\" (miespuolisen) henkilön ja kytkeä hänet näytön päähenkilöön uutena aviomiehenä.<br /><br />Näpäytä linkkiä, täytä ponnahdusikkunassa mahdollisimman monta kenttää ja näpäytä lopuksi \"Tallenna\".";
$pgv_lang["link_new_husb_help"]			= "~#pgv_lang[link_new_husb]#~<br />Tämän avulla voit linkittää tiedostossa jo olevan henkilön uudeksi aviomieheksi tälle henkilölle. Näin luodaan uusi perhe valitsemasi aviomiehen kanssa. Voit myös määritellä avioliiton tälle uudelle perheelle.<br /><br />";
$pgv_lang["link_wife_help"]				= "~LIITÄ TÄMÄ HENKILÖ VAIMOKSI OLEMASSA OLEVAAN PERHEESEEN ~<br /><br />Näpäyttämällä tätä linkkiä voit liittää hänet vaimoksi olemassa olevaan perheeseen. Tämä on edistyksellinen editointivaihtoehto, jota saa käyttää vain mikäli linkitettävä perhe on jo olemassa GEDCOM-tiedostossa. Mikäli haluat lisätä uuden perheen, käytä \"Lisää uusi aviomies\" linkkiä.";
$pgv_lang["add_wife_help"]				= "~LISÄÄ UUSI VAIMO~<br /><br />Näpäyttämällä tätä linkkiä voit lisätä \"uuden\" (naispuolisen) henkilön ja kytkeä hänet näytön päähenkilöön uutena vaimona.<br /><br />Näpäytä linkkiä, täytä ponnahdusikkunassa mahdollisimman monta kenttää ja näpäytä lopuksi \"Tallenna\".";
$pgv_lang["link_new_wife_help"]			= "~#pgv_lang[link_new_wife]#~<br />Tämän avulla voit linkittää tiedostossa jo olevan henkilön uudeksi aviovaimoksi tälle henkilölle. Näin luodaan uusi perhe valitsemasi aviovaimon kanssa. Voit myös määritellä avioliiton tälle uudelle perheelle.<br /><br />";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~LISÄÄ UUSI ISÄ TAI ÄITI~<br /><br />GEDCOM-tiedostossa on tietenkin useita henkilöitä ilman  isää ja/tai äitiä koskevaa tietuetta. <br /><br />Siinä tapauksessa <b>Henkilötietosivulla</b> sen <b>Lähisukulaisia</b>-välilehdellä taulukossa <b>Perhe vanhempineen</b> on linkki/linkit lisätä <b>uusi</b> isä ja/tai äiti henkilölle.<br /><br /><b>HUOMAA:</b><br />Näillä linkeillä lisätään <b>uusi</b> isä ja/tai äiti. Mikäli isällä ja/tai äidillä jo on tietue tässä GEDCOM-tiedostossa, käytä linkkiä: <b>#pgv_lang[link_as]##pgv_lang[child]#</b>, joka löytyy Henkilötietosivulta, sivun viimeisen taulukon alapuolelta.";

//-- Add Facts
$pgv_lang["add_facts_help"]				= "~LISÄÄ UUSIA TIETOJA~<br /><br />Tässä voit lisätä tietoja henkilölle tai henkilöille.<br /><br />Valitse ensin tietolaji pudotusvalikosta ja näpäytä sitten\"Lisää\" painiketta.<br />Pudotusvalikossa ovat kaikki GEDCOM-tiedostoon lisättävissä olevat tietolajit.<br />";
$pgv_lang["add_custom_facts_help"]		= "~Lisää oma tieto~<br />Mikäli alasvetovalikosta ei löydy sopivaa tietolajia, voit lisätä <b>oman tiedon</b>.<br />Sen lisääminen on yhtä helppoa kuin valmiiksi luetteloidun tiedon. Ainoa ero on se, että sinun on nimettävä tietolaji. Se on tehtävä ylimpään kenttään: <b>#pgv_lang[type]#</b>";
$pgv_lang["add_note_help"]				= "~LISÄÄ UUSI LISÄTIETO~<br /><br />Tässä voit lisätä uuden lisätiedon koskien tätä/näitä hen-kilöä/henkilöitä.<br />Näpäytä linkkiä ja avautuvaan ponnahdusikkunaan voit kirjoittaa lisätiedot.<br />Kun olet valmis, näpäytä \"Lisää\" painiketta ja sulje ikkuna.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]			= "#pgv_lang[multiple_help]#<br />~LISÄÄ UUSI LÄHDEVIITTAUS~<br /><br />Näpäyttämällä tätä linkkiä voit lisätä uuden lähde<b>viittauksen</b> koskien tätä/näitä henkilöä/henkilöitä.<br />Avautuneessa ikkunassa voit hakea lähteen (Hae ID-tunnus) ja lisää \"viittaus\".<br /><br />Kokonaista lähdettä ei voi lisätä vaan se on valittava luettelosta.<br /><br />Mikäli haluamaasi lähdettä ei ole luettelossa, toimita  ylläpitäjälle tiedot ja hän lis uuden lähteen luetteloon.<br />Tulevaisuudessa voit sitten käyttää uutta lähdettä luettelossa.<br /><br />Seuraavassa ohjelmaversiossa on mahdollista itsekin lisätä uusi lähde.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]				= "~LISÄÄ UUSI MEDIA~<br /><br />Multimediatiedostojen lisääminen GEDCOM-tiedostoon on mukava ominaisuus.<br />Vaikka tämä ohjelma on hyvännäköinen jo ilman mediaa, sen saa vielä paremmaksi lisäämällä sukulaisiasi koskevia kuvia tai muuta multimediaa.<br /><br />Mitä sinun tulee tietää multimediasta.<br /><br />Kuten ehkä tiedät, multimediaformaatteja on lukemattomia. Vaikka PhpGedView pystyy käsittelemään niistä useimpia, on muutamia asioita otettava huomioon.<br /><ul><li><b>Formaatit</b><br />Kuvia voi editoida ja tallentaa monissa formaateissa.<br />Esimerkiksi .jpg, .png, .gif, .bmp jne. Mikäli sama kuva on tallennettu eri muotoihin, ne näkyisivät näytöllä samankokoisina, mutta niiden tiedostokoot eroavat toisistaan. Yleensä jpg-kuvat vaativat vähiten tilaa levyllä.</li><br /><br /><li><b>Kuvan koko</b></ br>Mitä suurempi kuva, sen suurempi kuvatiedoston koko. Kuvan tulisi mahtua näytölle ilman vieritystä. Kuvan suurin pituus tai leveys ei saisi ylittää kuvaruudun kokoa. Koska tämä ohjelma on optimoitu näyttresoluutiolle 1024*756 pistettä on kuvan koko suhteutettava sen mukaisesti.</li><br /><li><b>Resoluutio</b><br />Kuvan resoluutio ilmoitetaan dpi-arvona (pistettä/tuuma), mutta se koskee vain tulostettua kuvaa. Paperille painettussa kuvassa resoluutio voi olla 150-300 dpi tai suurempi ja kuvan fyysisten mittojen perusteella se skaalataan sopivan kokoiseksi. Mikäli et aio tulostaa kuvaasi, sen koko kannattaa jättää pieneksi</li><br /><br /><li><b>Värisyvyys</b></ br> Kolmas tapa pitää kuvatiedosto pienenä on vähentää värisävyjen määrää. Värisävyjen määrä voi olla mitä tahansa mustavalkoisen (kaksi sävyä) ja täysvärikuvan (16 miljoonaa sävyä) välillä. Mitä enemmän värisävyjä, sen suurempi tiedostokoko.</li></ul><b>Miksi on tärkeätä pitää tiedostokoko pienenä?</b> <br /><br /><ul><li>Ensiksikin: käytettävissä on rajoitettu tila verkossa. Mitä useampi suuri tiedosto, sen enemmän tilaa tarvitaan palvelimella. Mitä enemmän tilaa tarvitaan, sen kalliimmaksi se tulee.</li><br /><li>Latausaika. Suuret tiedostot vaativat pidemmän latausajan palvelimelta omalle koneelle. Kaikilla ei ole käytettävissä kaapeliyhteyttä, laajakaistayhteyttä tai DSL-yhteyttä.</li><br /><br /><li>Kaistanleveys. Mitä enemmän dataa on ladattava palvelimelta koneellesi tai päinvastoin, sen enemmän se maksaa. Tämä johtuu siitä, että palvelimen siirtokapasitetti on rajoitettu ja linkki on jaettava kaikkien palvelimella pyörivien ohjelmin välillä. PhpGedView on yksi ohjelma, joka jakaa kapasitettia muiden ohjelmien kanssa palvelimella. Kustannukset jaetaan yleensä ohjelmien välilä niiden käyttämän datasiirtomäärän suhteessa.</li></ul><b>Kuinka ladata multimediatiedostosi palvelimelle.</b><br />Se voidaan tehdä kahdella tavalla. Mikäli mediatiedostoja on paljon, ota yhteyttä ylläpitäjään parhaan tavan selvittämiseksi. Mikäli ylläpitäjä on sen sallinut, voit käyttää Lataa mediatiedostoja-lomaketta #pgv_lang[mgv]#-valikossa. Voit myös käyttää Lataa palvelimelle-optiota multimedialomakkeella.<br /><br />";
$pgv_lang["add_facts_general_help"]		= "~Yleistä tietoa asioiden lisäämisestä~<br />Kun olet lisännyt tiedon, lisätiedon, lähteen tai multimediatiedoston henkilö(i)lle, käyttäjän, jolle ylläpitäjä on antanut hyväksymisoikeudet, on hyväksyttävä lisäys.<br />Ennen hyväksymistä muutokset näkyvät sivuilla editoiville käyttäjille  erivärisen reunuksen ympäröimänä, mutta ei yleisölle. Vasta kun muutos on hyväksytty, reunus poistuu ja uusi tieto tulee kaikkien nähtäville.";

//-- Edit user
$pgv_lang["edituser_my_account_help"]	= "Tällä sivulla voit muuttaa asetuksiasi.<br /><br />Voit muuttaa käyttäjätunnustasi, nimeäsi, salasanaasi, kieltäsi, sähköpostiosoitettasi, sivuston teemaa ja ensisijaista yhteydenottotapaa.<br /><br />GEDCOM INDI tietueen ID-tunnusta et voi itse muuttaa.<br /><br />";
$pgv_lang["edituser_username_help"]		= "~#pgv_lang[username]#~<br /><br /> Tässä ruudussa voit muuttaa käyttäjätunnustasi.<br />Käyttäjätunnuksessa on <b>erotettava suuret ja pienet</b> kirjaimet. Jussi ei ole sama kuin JUSSI tai jussi.<br /><br />Voit vain käyttää aakkosia, numeroita, yhdysviivaa (-) ja alaviivaa (_).<br /><br />Älä käytä pisteitä, pilkkuja, välilyöntiä tai muita aakkosiin kuulumattomia merkkejä.";
$pgv_lang["edituser_firstname_help"]	= "~#pgv_lang[firstname]#~<br /><br />Tähän kenttään voit muuttaa etunimesi. Tämän nimet muut näyttäjät näkevät kun olet kirjautunut. <br /><br />Vaikka itse voit valita mitä tähän kirjoitat, sinun on ilmoitettava ylläpitäjälle muutoksesta. Saattaa herättää ihmetystä kun muut näkevät tuntemattoman henkilön linjoilla. Ylläpitäjä voi saada sen selville ilman ilmoitustasi, mutta olisi kohteliasta säästää hänet turhalta vaivalta.<br /><br />";
$pgv_lang["edituser_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br /> Tähän kenttään voit muuttaa sukunimesi. Tämän nimet muut näyttäjät näkevät kun olet kirjautunut. <br /><br />Vaikka itse voit valita mitä tähän kirjoitat, sinun on ilmoitettava ylläpitäjälle muutoksesta. Saattaa herättää ihmetystä kun muut näkevät tuntemattoman henkilön linjoilla. Ylläpitäjä voi saada sen selville ilman ilmoitustasi, mutta olisi kohteliasta säästää hänet turhalta vaivalta.<br /><br />";
$pgv_lang["edituser_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />Tämä on sisäinen (GEDCOM ID-tunnus), joka linkittää sinut omiin tietoihisi GEDCOM-tiedostossa.<br /><br />Et voi muuttaa tätä tunnusta.<br />Tämä on ylläpitäjän asettama linkki.<br />Mikäli mielestäsi ID-tunnus ei ole oikea, ota yhteyttä ylläpitäjään asian korjaamiseksi.<br />";
$pgv_lang["edituser_rootid_help"]		= "~#pgv_lang[rootid]#~<br /><br />Tämä on kaikkien kaavioittesi lähtöhenkilö.<br />Mikäli (esimerkiksi) näpäytät linkkiä esivanhempiin, lähtöhenkilö sijaitsee vasemmanpuoleisimmassa ruudussa.<br />Tämän lähtöhenkilön ei tietenkään tarvitse olla sinä itse. Voit aloittaa kenestä tahansa, jota sinulla on oikeus tarkastella.<br />Joissakin kaavioissa voit muuttaa lähtöhenkilöä, mutta se koskee nimenomaan juuri niitä sivuja.<br />";
$pgv_lang["edituser_password_help"]		= "~#pgv_lang[password]#~<br /><br /> Salasana kannattaa muuttaa  säännöllisin välein.<br />Pidä mielessäsi, että jokainen, joka tuntee käyttäjätunnuksesi ja salasanasi pääsee käsiksi tietoihisi.<br />Salasanan pituuden tulisi olla vähintään 6 merkkiä. Mitä pidempi sen parempi. Voit käyttää kaikkia aakkosia ja muita merkkejä, jotka ovat näppäimistössäsi.<br /><br /><b>Huomaa: Älä</b> käytä \" (kaksinkertaiset lainausmerkit) tai ' (yksikertaiset lainausmerkit). Niiden toimimisesta ei ole takeita.<br /><br /><b>Yhdistele suuria ja pieniä aakkosia, numeroita ja muita merkkejä.</b> Esimerkki: 5Z_q\$P4=r9.<br /><br />Kuten käyttäjätunnuksessa, myös salasanassa on <b>eroa suurten ja pienten</b> kirjainten välillä. Esimerkiksi \"Jo5hn\" ei ole sama kuin \"jo5hn\" tai \"JO5HN\".";
$pgv_lang["edituser_conf_password_help"] = "~#pgv_lang[confirm]#~<br /><br />Mikäli olet muuttanut salasanaasi, sinun on myös varmistettava se.<br />Tämä vain varmistukseksi, että et ole tehnyt kirjoitusvirhettä salasanakentässä.<br />Mikäli ohjelma havaitsee, että salasana ja sen varmistus eivät täsmää, saat tämän ilmoituksen: <b>#pgv_lang[password_mismatch]#</b>.<br /> Sekä salasana- että varmistuskenttä tyhjenevät ja saat kirjoittaa uudestaan kumpaankin kenttään.<br />";
$pgv_lang["edituser_change_lang_help"]	= "~#pgv_lang[change_lang]#~<br /><br /> Tässä voit määrittää tämän sivuston oletuskielen.<br />Ohjelma kykenee tunnistamaan selaimesi <b> oletuskilelen</b> joten useimmiten ohjelman kieliasetukseen ei tarvitse puuttua.<br />Jos kuitenkin selaimesi oletuskieli on englanti, mutta haluat <b>tällä sivustolla</b> käyttää suomea tai hepreaa, voit sen asettaa tässä.<br /><br />";
$pgv_lang["edituser_email_help"]		= "~#pgv_lang[emailadress]#~<br /><br />Oikea sähköpostiosoitteesi on meille tärkeä yhteydenpitoa varten.<br />Jos saat uuden sähköpostiosoitteen esimerkiksi vaihtaessasi palveluntarjoajaa, muista muuttaa se myös tässä.<br />Jos sinulla on useampia sähköpostiosoitteita ja haluat saada postia meiltä toiseen osoitteeseen, vaihda se tässä.<br />";
$pgv_lang["edituser_user_theme_help"]	= "~#pgv_lang[user_theme]#~<br /><br />Tällä sivustolla on useita teemoja.<br />Voit kutsu niitä myös sivuasetuksiksi. Jokaisessa teemassa näkyvät samat tiedot.<br />Ihan kuin sijoittaisit kuvan erilaiseen kehykseen ja ripustaisit sen eri huoneeseen. Kuva ei muutu, mutta tapa jolla sen näet muuttuu.<br />Sen kun kokeilet. Valitse toinen teema, katso sitä, katso toista ja pala siihen josta pidit eniten.<br />Joka kerta kirjautuessasi sivustolle ohjelma näyttää sinun valitsemasi teeman.<br />";
$pgv_lang["edituser_contact_meth_help"]	= "~#pgv_lang[user_contact_method]#~<br />Sähköpostijärjestelmämme ja joitakin muita yhteydenpitomenetelmiä<br />Sähköpostin lähettämismenetelmän asettaa ylläpitäjä. Sitä et voi muuttaa.<br /><b> Viestien vastaanottamismenetelmän</b> voit asettaa itse.<br />Tällä hetkellä voit valita yhden neljästä menetelmästä.";
$pgv_lang["mail_option1_help"]			= "Tällä vaihtoehdolla käytetään PhpGedView-ohjelman omaa sisäistä viestintäjärjestelmää eikä sähköposteja lähetetä.<br />Tällä tavoin saat vain <b>sisäisiä</b> viestejä muilta käyttäjiltä. Kun toinen käyttäjä lähettää sinulle viestin  tässä palvelussa, saat sen viestialueelle omalle OmaGedView-sivulle (ellet ole siirtänyt tätä aluetta sivultasi)<br />";
$pgv_lang["mail_option2_help"]			= "Tämä vaihtoehto on kuin #pgv_lang[messaging]#, mutta yhdellä lisäyksellä.<br />Kopio viestistä lähetetään myös käyttäjätilissäsi olevaan sähköpostiosoitteeseen.<br />Tämä viestintämenetelmä on oletusasetuksena.<br />";
$pgv_lang["mail_option3_help"]			= "Tällä vaihtoehdolla saat viestit vain sähköpostiosoitteeseesi.<br />Muut käyttäjät eivät saavuta sinua sisäisellä viestintäjärjestelmällä.<br />";
$pgv_lang["mail_option4_help"]			= "Tällä vaihtoehdolla et saa viestejä lainkaan.<br />";

//-- Add user
//$pgv_lang["help_adduser.php"]			= "#pgv_lang[sorry]#";

//-- Admin
$pgv_lang["admin_help"]					= "Tällä sivulla ovat linkit asetussivuille, ylläpitosivuille, dokumentointiin ja lokisivuille.<br /><br /><b>Järjestelmäaika</b>, joka sijaitsee heti sivun otsikon alla, näyttää sivustoa ylläpitävän palvelimen aikaa. Näytettävä aika on on palvelimen aika kun avasit tai päivitit sivun.<br /><br /><b>VAROITUS</b>Kun näet varoituksen järjestelmäajan alapuolella, merkitsee se sitä, että <b>config.php</b> on vielä muutettavissa! Kun olet konfiguroinut sivustosi, sinun tulisi <b>turvallisuussyistä</b> asettaa tämä tiedosto <b>vain luku-tilaan</b>. Tämä on tehtävä käsin, koska PhpGedView ei pysty sitä (vielä) automaattisesti tekemään.<br /><br />Linkkien \"Lue minut\", \"Käyttäjäopas\" ja \"Lokitiedosto\" lisäksi saa lisätietoa kyseisiltä sivuilta.";

//-- User Admin
$pgv_lang["useradmin_help"]				= "~KÄYTTÄJIEN YLLÄPITO~<br /><br />Tällä sivulla voit hallita nykyisiä käyttäjiä ja lisätä uusia.<br /><br /><b>Nykyiset käyttäjät</b><br />Tässä taulukossa näkyvät nykyiset käyttäjät, heidän tilansa ja oikeutensa.<br />Voit <b>poistaa</b> ja <b>editoida</b> käyttäjiä.<br /><br /><b>Lisää uusi käyttäjä</b><br />Tämä lomake on melkein sama kuin \"Oma käyttäjätilisi\".<br />Monille kohdille ei ylläpitäjälle ole tehty erillistä opastetekstiä. Niissä tapauksissa näet seuraavan viestin:";
$pgv_lang["useradmin_gedcomid_help"]	= "~GEDCOM INDI TIETUEEN ID-TUNNUS~<br /><br />Tämän GEDCOM-tietueen ID-tunnuksen asettaa ylläpitäjä.<br />Sillä tunnistetaan käyttäjä.<br />Sen avulla käyttäjä myös pääsee käsiksi esi- ja jälkipolvitauluihinsa.<br /><br />Jokaiselle GEDCOM-tiedostolle, jota käytät tässä ohjelmassa, voit asettaa käyttäjän GEDCOM-tietueen ID-tunnuksen.<br />Mikäli käyttäjällä ei ole tietuetta GEDCOM-tiedostossa, jätetään tekstikenttä tyhjäksi.";
$pgv_lang["useradmin_rootid_help"]		= "~ESIPOLVIKAAVION LÄHTÖHENKILÖ~<br /><br />Jokaiselle ohjelman GEDCOM-tiedostolle voit määritellä käyttäjän <b>lähtöhenkilön</b><br />Luultavasti henkilö haluaa käynnistää ohjelman omalla esipolvitaululla, mutta tämä ei ole pakko.<br /><br />Käyttäjä voi myös muuttaa tätä asetusta käyttäjätilissään.";
$pgv_lang["useradmin_can_admin_help"]	= "~KÄYTTÄJÄ VOI YLLÄPITÄÄ VALINTARUUTU~<br /><br />Mikäli tämä ruutu on rastitettu, käyttäjällä on samat oikeudet kuin sinulla tässä ohjelmassa.<dl><dt>Hän voi:</dt><dd>lisätä / poistaa / editoida käyttäjiä</dd><dd>lähettää viestejä kaikille käyttäjille kerralla</dd><dd>editoida tervetuloaviestejä</dd><dd>editoida ja configuroida kielitiedostoja</dd><dt>Lisäksi:</dt><dd>päivittää ohjelman</dd><dd>muuttaa asetuksia</dd><dd>ylläpitää GEDCOM-tiedostoja</dd><dd>muuttaa yksityisyysasetuksia</dd><dd>ja tehdä kaikkea muuta tässä mainitsematonta.</dt><dd>Mutta ei muuttaa sivuston asetuksia ohjelman ulkopuolella.</dd></dl>";
$pgv_lang["useradmin_sync_gedcom_help"]		= "~#pgv_lang[sync_gedcom]# VALINTARUUTU~<br /><br />Mikäli tämä ruutu on rastitettu ja käyttäjälle on osoitettu GEDCOM ID-tunnus, hänen käyttäjäasetuksensa synkronoituvat automaattisesti GEDCOM-tietojen kanssa. Eli jos käyttäjän GEDCOM-tietuetta editoidaan, tietyt tiedot kuten sähköpostiosoite ja nimi kopioituvat käyttäjän käyttäjätilitietoihin. Kun käyttäjätilitietoja editoidaan, kopioituvat tiedot vastaavasti GEDCOM-tietueeseen.";
$pgv_lang["useradmin_can_edit_help"]	= "~KÄYTTÄJÄN OIKEUDET~<br /><br />Käyttäjällä voi järjestelmän jokaiselle GEDCOM-tiedostolle olla tietyt pääsy- ja editointioikeudet.<br /><br />Asettamalla nämä <b>ei oikeuksia</b>-tilaan, merkitsee se, että käyttäjä ei pääse käsiksi tämän GEDCOM-tiedoston yksityisiin tietoihin. Asettamalla tämä tilaan <b>Lukuoikeus</b> merkitsee se, että käyttäjä ei voi editoida tai hyväksyä tietoja tietokantaan, mutta voi selata yksityistietoja.<br /><br />Asettamalla tämä tilaan <b>muuta</b> käyttäjä voi editoida tietoja, mutta käyttäjän, jolla on <b>hyväksymisoikeudet</b> on hyväksyttävä muutokset ennen kuin ne tallennetaan tietokantaan ja näytetään julkisesti.<br /><br />Asettamalla tämä tilaan <b>hyväksy</b> sallii käyttäjän tehdä muutokset ja hyväksyä muiden tekemät muutokset.<br /><br /><b>Ylläpito</b> antaa käyttäjälle oikeudet muuttaa tämän GEDCOM-tiedoston asetuksia ja yksityisyysmäärittelyjä.<br /><br />Järjestelmän ylläpitäjällä on automaattisesti <b>ylläpito</b>-okeudet.";
$pgv_lang["useradmin_verified_help"]	= "~KÄYTTÄJÄ VARMENSI ITSENSÄ~<br /><br /><b>Itserekisteröinti</b><br />Käyttäjä voi pyytää itselleen uutta käyttäjätiliä <b>itserekisteröinti</b>-modulilla.<br />Mikäli hän on näin toiminut hän saa sähköpostin, jossa on linkki pyynnön varmentamiseksi.<br />Mikäli hän jo on näin menetellyt on valintaruutu rastitettu ja voit jatkaa seuraavaan vaiheeseen: <b>Ylläpitäjä hyväksynyt käyttäjän</b><br />Mikäli käyttäjä ei ole varmentanut itseänsä, sinun tulee odottaa hyväksymisen kanssa.<br /><br /><b>Lisää käyttäjä manuaalisesti</b><br />Mikäli käytät lomaketta lisätäksesi käyttäjän manuaalisesti, tulevat valintaruudut olemaan jo rastitettuja.";
$pgv_lang["useradmin_verbyadmin_help"]	= "~YLLÄPITÄJÄN HYVÄKSYMÄ~<br /><br />Mikäli käyttäjä on käyttänyt itserekisteröintimodulia ja varmentanut itsensä, on sinun viimeisenä vaiheena hyväksyttävä pyyntö ennen kuin hänen käyttäjätilinsä on voimassa.<br /><br />Hyväksymisesi jälkeen käyttäjä saa sähköpostiviestin, että hänen käyttäjätilinsä on voimassa ja että hän voi kirjautua järjestelmään hakemuksen yhteydessä antamansa käyttäjätunnuksen ja salasanan avulla.";
$pgv_lang["useradmin_edit_user_help"]	= "~PÄIVITÄ KÄYTTÄJÄTILI~<br /><br />Tätä lomaketta ylläpitäjä käyttää päivittämään käyttäjän käyttäjätiliä.<br /><br />Lomake on melko samanlainen kuin lomake \"Lisää käyttäjä\" tai \"Oma käyttäjätilini\".";
$pgv_lang["useradmin_visibleonline_help"]	= "~NÄKYVISSÄ ON-LINE~<br /><br />Mikäli tämä ruutu on rastitettu, muut kirjautuneet voivat nähdä kun olet järjestelmässä ja voit nähdä milloin he ovat järjestelmässä. Mikäli et halua, että muut näkevät sinun olevan järjestelmässä, jätä ruutu rastittamatta. Myöskään sinä et silloin näe muita kirjautuneita.";
$pgv_lang["useradmin_editaccount_help"]	= "~MUUTA KÄYTTÄJÄTIETOJA~<br /><br />Mikäli tämä ruutu on rastitettu tämä käyttäjä voi muuttaa heidän käyttäjätietojaan. Mikäli ruutu ei ole rastitettu, he eivät voi muuttaa käyttäjätietojaan. Tällä tavoin voit luoda yhden käyttäjätunnuksen ja salasanan usealle käyttäjälle yhteisesti ja estää heitä muuttamasta käyttäjätietojaan.";
$pgv_lang["useradmin_relation_priv_help"]	= "~#pgv_lang[user_relationship_priv]#~<br /><br />Mikäli tämä ruutu on rastitettu, käyttäjä pääsee käsiksi tietoihin vain niistä elävistä henkilöistä , joille hän on sukua. Näkyvien sukulaisten sukulasuussuhteen laajuus riippu <i>#pgv_lang[user_path_length]#</i>-asetuksesta. Voit vaatia yksityisyysasetusta sukulaisuudelle kaikille käyttäjille aktivoimalla GEDCOM yksityisyysasetuksissa olevan globaalin vaihtoehdon.<br /><br />Tämä asetus vaatii, että käyttäjä on kytketty GEDCOM ID-tunnukseen, ennenkuin yksikään elossa oleva henkilö näkyy.<br /><br />";
$pgv_lang["useradmin_path_length_help"]	= "|~#pgv_lang[user_path_length]#~<br /><br />Mikäli <i>#pgv_lang[user_relationship_priv]#</i> on aktivoitu, tämä käyttäjä pääsee käsiksi vain niiden elävien henkilöiden tietoihin, jotka ovat tämän sukulaisuusporrastuksen sisällä.<br /><br />";
$pgv_lang["useradmin_auto_accept_help"]	= "~#pgv_lang[user_auto_accept]#~<br /><br />Rastittamalla tämän ruudun sallit järjestelmän automaattisesti hyväksyä kaikki käyttäjän tekemät muutokset. Käyttäjällä tulee myös olla hyväksytyt oikeudet GEDCOM-tiedostoon, jotta tämä asetus astuisi voimaan.<br /><br />";
$pgv_lang["help_managesites"] 			= "~SIVUSTOJEN YLLÄPTO~<br /><br />Tällä sivulla voit lisätä etäsivustoja ja estää IP-osoitteita.<br /><br />Etäsivuston voi lisätä antamalla sivuston nimi, URL, tietokantatunniste (valinnainen), käyttäjätunnus ja salasana etäpalveluun.<br /><br />IP-osoitteiden esto tehdään antamalla asianmukainen IP-osoitealue. Esimerkiksi 212.10.*.*. Ne etäsivustot, joilla on estolistan ilmoittamat IP-osoitteet, eivät pääse omalle sivustollesi. Voit estää myös yksittäisiä IP-osoitteita.";
$pgv_lang["help_remotesites"]			= "~Etäsivustojen lisäys~<br /><br />Lisätäksesi etäsivuston anna sen nimi, URL, tietokantatunnus (valinnainen) ja käyttäjätunnus ja salasana. Näpäytä Lisää-painiketta. Mikäli etäsivusto sallii kirjautumisen tuntemattomana, jätä käyttäjätunnus ja salasana tyhjäksi.";
$pgv_lang["help_banning"]				= "~IP-osoitteiden esto~<br /><br />Estääksesi etäsivuston pääsyn omaan palveluusi, anna tarkka IP-osoite tai IP-osoitealue, esimerkiksi 212.10.*.*. ja näpäytä Hyväksy painiketta.";
$pgv_lang["help_manual_search_engines"]	= "~Manuaalinen hakurobottimerkintä~<br /><br />PhpGedView toimittaa hakukoneille automaattisesti pieniä tiedostoja, joissa on vähemmän linkkejä. Tieto on rajoitettu henkilöön ja hänen omaan perheeseensä ilman tietoja isovanhemmista tai lapsenlapsista. Useat raportit ja palvelinta kuormittavat sivut kuten kalenterit ovat hakuroboteilta kielletty.<br /><br />Mikäli hakukonetta ei automaattisesti ole tunnistettu ja haluat toimittaa sille indeksoitavaa aineistoa, voit lisätä hakukoneen tähän. Mikäli et halua toimittaa sille tietoa, voit lisätä sen alapuolella olevaan kiellettyjen IP-osoitteiden luetteloon.<br /><br />Mikäli haluat nähdä mitä tietoja annetaan hakukoneelle indeksoitavaksi, lisää oma IP-osoitteesi tähän.<font color=red>VAROITUS:</font> Tämä sulkee sinut ylläpitäjän käyttöliittymästä ja sinun on poistettava IP-osoite kirjautumalla toiseen koneeseen tai käsin editoitava tiedostoa <i>/index/search_engines.php</i>.<br /><br />Mikäli haluat käsin merkitä etäsivuston hakurobotiksi, lisää IP-osoite tai IP-osoitealue (esim. 212.10.*.*) ja näpäytä \"Lähetä\"-painiketta. Useat suositut hakukoneet kuten Google ja Yahoo havaitaan automaattisesti.";
$pgv_lang["search_engine_landing_page"]		= "~Havaittu hakumoottori~<br /><br />PhpGedView tuottaa hakumoottoreille automaattisesti pienemmät datatiedostot vähemmin linkein. Tieto rajoittuu lähiomaisiin ilman tietoa isovanhemmista tai lapsenlapsista. Useat raportit ja palvelinta runsaasti kuormittavat sivut kuten kalenteri, ovat hakurobottien ulottumattomissa.<br /><br />Mikäli hakurobotit pyrkivät sellaisille sivuille  näytetään tämä sivu. Mikäli näet tämän tekstin ohjelma kuvittelee, että olet hakurobotti. Alla on lettelo niistä sivuista, joihin hakuroboteilla on pääsy, ja joilta on saatavissa pienempi datamäärä.<br /><br />Todelliset käyttäjät, jotka seuraavat hakumoottorien anatamia linkkejä tälle sivustolle, näkevät koko sivut ja kaiken siinä olevan tiedon eivätkä tätä sivua.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]		= "~GEDCOM-tiedoston LISÄÄMISEN JA LATAAMISEN VÄLINEN ERO~<dl><dt> GEDCOM-tiedostojen lataaminen</dt><dd>Tiedostojen lataaminen palvelimelle voi tapahtua on-line tilassa. <br />Voit ladata mistä tahansa paikasta tarvitsematta ftp-ohjelmaa. .</dd><dt>GEDCOM-tiedostojen lisääminen</dt><dd>Mikäli tiedosto on vielä olemassa GEDCOM-hakemistossasi, voit käyttää sitä ilman palvelimelle lataamista. <br />Joskus on tarve käyttää lisäämistä lataamisen sijaan joko tiedostokoon tai latausrajoitusten vuoksi.</dd></dl> Kummatkin toimenpiteet voi suorittaa neljässä vaiheessa. <br />Vain vaiheet 1 eroavat toisistaan.<br />";
$pgv_lang["gedcom_configfile_help"]		= "~GEDCOM ASETUSTIEDOSTO~<br /><br />Tämä on tiedosto, johon kaikki GEDCOM-tiedoston asetukset on tallennettu.<br /><br />GEDCOMin ylläpitosivun sarakkeessa \"asetustiedosto\" näkyy asetustiedoston nimi ja tiedostopolku.";
$pgv_lang["default_gedcom_help"]		= "~GEDCOM OLETUSTIEDOSTO~<br /><br />Mikäli sinulla on enemmän kuin yksi GEDCOM-tiedosto ohjelmassasi, voit tässä määrittää mikä niistä on <b>oletustiedosto</b><br /><br />Oletustiedosto on se GEDCOM-tiedosto, joka näkyy niille käyttäjille, jotka eivät ole kirjautuneet.<br /><br />Käyttäjät voivat ohittaa tämän määrittelyn muuttamalla asetusta käyttäjätilillään.<br />";
$pgv_lang["delete_gedcom_help"]			= "~POISTA GEDCOM-TIEDOSTO~<br /><br />PhpGedView tuo tietueita GEDCOM-tiedostosta. Kun näpäytät <b>poista</b>, ohjelma pyyhkii ne tietueet, jotka on tuotu GEDCOM-tiedostosta. <br />Varsinainen GEDCOM-tiedosto jää siihen hakemistoon, minne se on ladattu.<br /><br />Mikäli myöhemmin taas haluat käsitellä kyseistä GEDCOM-tiedostoa, sitä ei tarvitse enää ladata uudestaan palvelimelle vaan voit käyttää vaihtoehtoa <b>Lisää GEDCOM</b>.<br /><br />Näpäytettyäsi \"Poista\", sinun on <b>vahvistettava</b> se ponnahdusikkunassa.";
$pgv_lang["add_gedcom_help"]			= "~LISÄÄ GEDCOM~<br /><br />Kun käytät \"Lisää GEDCOM\" vaihtoehtoa oletetaan, että olet jo ladannut GEDCOM-tiedostosi palvelimelle <i>käyttäen erillistä ohjelmaa</i> kuten esimerkiksi <b>ftp-ohjemaa</b>. <br />Mikäli GEDCOM-tiedostosi ei vielä ole palvelimella, se on toimitettava sinne ennen kuin voit aloittaa lisäämisen.<br /><br />Saat toimintaohjeet vaihe vaiheelta.<br />";
$pgv_lang["add_new_gedcom_help"]		= " ~LUO UUSI GEDCOM~<br /><br />Voit luoda uuden GEDCOM-tiedoston alusta lähtien. <br /><br />Voit toteuttaa sen muutamassa vaiheessa. Vaihe 1 eroaa siitä, mihin olet tottunut lataamisessa ja lisäämisessä. Muut vaiheet ovat tuttuja.<dl><dt>Vaihe 1: Uuden GEDCOM-tiedoston nimeäminen</dt><dd>Syötä uuden GEDCOM-tiedoston nimi ilman tiedostopäätettä '.ged'. Uusi tiedosto luodaan siihen hakemistoon, joka ilmenee syöttökentän yläpuolella. <br />Näpäytä <b>Lisää</b></dd><dt>Vaihe 2: Konfigurointisivu</dt><dd>Tämän sivun tunnet jo GEDCOM-tiedoston konfiguroinnista. </dd><dt>Vaihe 3: Varmenna</dt><dd>Myös tämän sivun tunnet aiemmasta. Uusi GEDCOM-tiedosto tarkastetaan ja hyväksytään. </dd><dt>Vaihe 4: Tietueiden tuonti</dt><dd>Koska tuotavana on vain yksi tietue tämä suoritetaan hyvin nopeasti.</dd><dt>Valmiina luontiin</dt><dd>Nyt voit mennä esipolvikaavioon nähdäksesi uuden henkilön uudessa GEDCOM-tiedostossasi. Näpäytä henkilön nimeä ja aloita editointi. Sen jälkeen voit aloittaa uusien henkilöiden lisäämisen.</dd></dl>";
$pgv_lang["download_gedcom_help"]		= "~LATAA GEDCOM~<br /><br />Voit ladata GEDCOM-tiedoston sivustoltasi omalle koneellesi.<br /><br />\"Lataa GEDCOM\"-sivulla on mahdollista muuntaa tiedosto muodosta <b>UTF-8</b> muotoon <b>ANSI (ISO-8859-1)</b><br />Tarvitsemasi muoto riippuu ohjelmasta, jolla aiot käsitellä lataamaasi GEDCOM-tiedostoasi.<br />Tarkista ohjelmasi ohjeistuksesta jos et ole varma.";
$pgv_lang["edit_gedcoms_help"]			= "~GEDCOM YLLÄPITO~<br /><br />GEDCOM ylläpitosivu on se keskus, josta ylläpidetään <b>nykyiset</b> ja <b>uudet</b> GEDCOM-tiedostot.<br /><dl><b>NYKYISET GEDCOM-TIEDOSTOT</b><br /><dt>Taulukossa <b>nykyiset GEDCOM-tiedostot on seuravat vaihtoehdot:</dt> <dd>Poista GEDCOM </dd> <dd> Muuta GEDCOM </dd> <dl><dt>Muuta yksityisyttä</dt><dd>Muuta yksityisyyttä on myös osa tätä taulukkoa, koska jokaisella GEDCOM-tiedostolla on oma yksityisyysasetustiedostonsa. .</dd></dl><dd>Aseta oletus-GEDCOM</dd><dd>Tuo DEDCOM</dd><dd>Lataa GEDCOM</dd><dd>Kolmessa sarakkeessa ovat seuraavat tiedot:</dt><dd>GEDCOM-tiedosto</dd><dd>GEDCOM otsikko</dd><dd>Konfigurointitiedosto</dd></dl><dl><b>UUDET GEDCOM-TIEDOSTOT</b><dt>Tällä sivulla sijaitsevat seuraavat vaihtoehdot lisätä <b>uusi</b> ja/tai <b>olemassa oleva</b> GEDCOM-tiedosto järjestelmään. .</dt><dd>Lisää GEDCOM</dd><dd>Lataa GEDCOM </dd><dd>Luo uusi GEDCOM </dd></dl>#pgv_lang[more_help]#<br />";
$pgv_lang["edit_config_gedcom_help"]	= "~KONFIGUROI GEDCOM~<br /><br />Jokaisella tässä ohjelmassa käyttämälläsi GEDCOM-tiedostolla on oma <b>asetustiedosto</b>nsa.<br /><br />Tällä lomakkeella teet perusasetukset kuten esimerkiksi kieli, kalenterimuoto, sähköpostin asetukset, jne., jne.<br />";
$pgv_lang["import_gedcom_help"]			= "~TUO GEDCOM~<br /><br />Useimmissa tapauksissa GEDCOM-tiedoston tuonti on yksi askel proseduurissa kuten lisäys, lisää uusi tai lataa GEDCOM-tiedosto palvelimelle.<br /><br />Nänmä tapahtuvat loogisessa järjestyksessä ja on toteutettava kokonaan, jotta voit käsitellä GEDCOM-tiedostoa. <br />Mikäli et toteuttanut edellä kuvattuja vaiheita, näytetään <b>varoitus</b>, että GEDCOM-tiedosto ei vielä ole tuotu. Näpäytä siinä tapauksessa linkkiä tuodaksesi GEDCOM-tiedoston (uudelleen).<br /><br /><b>Tuonti</b><br /><br />GEDCOM-tiedoston asetukset eivät muutu, kun tuot GEDCOM-tiedoston uudestaan. <br />Olemassa oleva tieto kirjoitetaan yli.";
$pgv_lang["upload_gedcom_help"]			= "~LATAA GEDCOM PALVELIMELLE~<br /><br />Toisin kuin vaihtoehdossa \"Lisää GEDCOM\" palvelimella ei ennestään tarvitse olla GEDCOM-tiedostoa.<br /><br />Vaiheessa 1 valitset GEDCOM-tiedoston omalta konreeltasi. Syötä koko tiedostopolku tekstikenttään tai käytä sivun <b>Selaa</b>-painiketta.<br /><br />Lisää ohjeita löytyy proseduurin muilta sivuilta.<br />";
$pgv_lang["validate_gedcom_help"]		= "~VARMENNA GEDCOM~<br /><br />Palvelimelle lataamasi GEDCOM-tiedoston varmentaminen on kolmas vaihe proseduurissa, jolla ohjelma saadaan käsittelemään kyseistä GEDCOM-tiedostoa.<br /><br />Ohjelma tarkistaa, että seuraavat asiat ovat oikein: päivämäärämuoto, paikkamuoto, merkistö, ym. <br />Jotkut ohjelman havaitsemat virhellisyydet korjautuvat automaattisesti, esimerkkeinä MacIntsoh rivinpäätteet ja väärä paikkaformaatti. <br />Niissä tapauksissa ohjelma ilmoittaa muutoksista. <br />Muiden virheellisyyksien osalta ohjelma antaa varoituksen sekä korjausehdotuksen.<br /><br /><b>Lisätyökalut</b><br />Tällä hetkellä löytyy kaksi lisätyökalua: <br /><b>Vaihda henkilön ID-tunnus</b> ja <b>Lisää media</b>.<br />Viimeksi mainittu työkalu on käytettävissä vain <b>MySQL</b>-tilassa. Mikäli GEDCOM-tiedosto on <b>indeksi</b>-muodossa, tämä vaihtoehto on piilossa.<br /><br /><b> Lisäohjeita</b> löytyy lomakkeelta.#pgv_lang[more_help]#<br />";
$pgv_lang["convert_ansi2utf_help"]		= "~MUUNNA ANSI MUOTOON UTF-8~<br /><br />Varmistaakseen, että ohjelma käsittelee GEDCOM-tiedostoasi oikein, tiedostojen täytyy olla muodossa UTF-8.<br /><br />Useimmat kolmannen osapuolen sukututkimusohjelmat osaavat viedä GEDCOM-tiedoston UTF-8-muodossa. <br />Mikäli käyttämäsi ohjelma ei osaa sitä tehdä, PhpGedView osaa tehdä muunnoksen.<br /><br />Kun PhpGedView varmentaa ladatun (tai lisätyn) tiedoston, ohjelma havaitsee, mikäli se on ANSI-muodossa.";
$pgv_lang["detected_ansi2utf_help"]		= "~HAVAITTU ANSI-MUOTO~<br /><br />Nyt varmennettava GEDCOM-tiedosto on ANSI-muodossa.<br />Suositellaan, että merkistö muutetaan UTF-8 muotoon<br /><br  />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]			= "~HAVAITTU VÄÄRÄ PÄIVÄMÄÄRÄMUOTO~ <br /><b>PÄIVÄMÄÄRÄMUOTO MUUTETAAN</b><br /><br />PhpGedView-ohjelman ja <b>GEDCOM 5.5. standardin</b> mukaan voimassa oleva päivämäärämuoto on muotoa DD MMM YYY (esim. 01 JAN 2004).<br /><br />Mikäli ohjelma ilmoittaa GEDCOM-tiedoston varmennuksen jälkeen, että se on havainnut väärän päivämäärämuodon, se muuntaa sen standardin mukaiseen muotoon.<br /><br />Voit kuitenkin valita joko \"<b>päivä</b> ennen kuukautta\" (DD MMM YYYY) tai \"<b>kuukausi</b> ennen päivää\" (MMM DD YYYY). <br />Ensimmäistä vaihtoehtoa suositellaan kuitenkin.";
$pgv_lang["addmedia_tool_help"]			= "~LISÄÄ MEDIA TYÖKALU~ <br /><b>VAIN MySQL-tila</b><br /><br />Lisää media-työkalu on tehty niitä varten, joiden sukututkimusohjelma ei vie GEDCOM-tiedostoja medialinkkien kera. Family Tree Maker on näistä tunnetuin.<br /><br />Lisää media-työkalu sallii sinun pitävän luetteloa medialinkeistä GEDCOM-tiedoston ulkopuolella ja erillään normaaleista PhpGedView-tauluista. Koska tiedot pidetään erillisessä taulussa, tietoa on lisättävä vain kerran. Täm helpottaa ylläpitäjää käsittelemään sukututkimustietoja asiakasohjelmallaan, viedä uusi GEDCOM-tiedosto ja ajaa lisää media-työkalu tämän päälle osana tuontiprosessia, jotta samat medialinkit saadaan lisättyä joka kerta kun luodaan uusi GEDCOM-tiedosto.<br /><br />Käyttääksesi lisää mediatyökalua, luo ensin medialuettelo täyttämällä kentät ja näpäytä Lisää media-painiketta jokaisen lisättäväksi aiotun median kohdalla. \"#pgv_lang[gedcomid]#\"-kenttä sisältää sen GEDCOM-tietueen ID-tunnuksen, johon haluat lisätä median, esi, I100. Kenttään \"ulkoinen tiedosto\" kirjoita kuvatiedoston nimi. Kirjoita kenttään \"#pgv_lang[extension]#\" tiedoston tiedostopääte. Käytä kenttää \"#pgv_lang[highlighted]#\" kertoaksesi onko kyseessä tämän henkilön korostettu eli ensisijainen kuva. Ensimmäinen kuva joka on merkitty korostetuksi tulee näkymään kaavioissa ja korostettuna henkilösivulla henkilön nimen vieressä. Kenttään \"#pgv_lang[title]#\" kirjoitetaan kuvaa kuvaava otsikko. Kenttään \"#pgv_lang[order]#\" merkitään järjestys, jossa media esiintyy Media-välilehdellä. Kenttään \"#pgv_lang[gedcom_file]#\" kirjoitetaan sen GEDCOM-tiedoston nimi, jossa mediaa käytetään. Tällä tavoin voit käyttää työkalua useamman GEDCOM-tiedoston yhteydessä.<br /><br />Kun luettelo on valmis, näpäytä \"#pgv_lang[click_to_add_media]#\"-painiketta tallentaaksesi muutokset GEDCOM-tiedostossa. Seuraavan kerran päivittäessäsi GEDCOM-tiedostoasi sinun on vain ajettava lisää media-työkalu ja näpäytettävä tätä painiketta.<br /><br />";
$pgv_lang["change_indi2id_help"]		= "~MUUTA HEKILÖN ID-TUNNUS~<br /><br />Tämä työkalu laadittiin niille käyttäjille, jotka käyttävät sellaisia GEDCOM-ohjelmia, jotka käyttävät eri henkilön ID-tunnusta joka kerta kun GEDCOM-tiedosto eksportoidaan. Esimerkiksi ensimmäisellä vientikerralla henkilön ID-tunnus on I100, mutta seuraavalla kerralla saman henkilön ID on I234. Nämä muuttuvat tunnukset hankaloittavat PhpGedView-ohjelman ylläpitoa, koska henkilöihin viitataan ID-tunnuksen mukaan.<br /><br />Useimmat sukututkimusohjelmat käyttävät myös RIN ja REFN merkitsintä yksilöimään kunkin henkilön. Tämä työkalu korvaa kaikki GEDCOM-tiedoston ID-arvot toisella määrittelemäsi kentän arvolla. Voit valita joko RIN tai REFN kentän  korvaamaan ID-tunnuksen.<br /><br />";
$pgv_lang["edit_privacy_help"]			= "Tällä sivulla voit tehdä kaikki yksityisyysasetukset valittuun GEDCOM-tiedostoon (tai tiedostoihin, jos niitä on useampia).<br />Voit tarkistaa sivuotsikon alta oletko editoimassa oikeata yksityisyystiedostoa. <br />Se näyttää seuraavalta: (tiedostopolku/gedcomtiedososinimi_priv.php)<br /><br />Mikäli tarvitset lisää asetusarvoja, voit käsin tehdä muutokset yksityisyystiedostoon. Lisätietoa on PhpGedView verkkosivuilla.<br /><br />";
$pgv_lang["invalid_header_help"]		= "~VIRHEELLINEN GEDCOM-TIEDOSTON ALKU~<br />GEDCOM-tiedoston ensimmäisen rivin tulee olla HEAD 0. PhpGedView havaitsi, että tiedoston ensimmäinen rivi ei ole 0 HEAD. Kun näpäytät siivoa-painiketta, kaikki rivit enne ensimmäistä 0 HEAD riviä poistetaan GEDCOM-tiedostostasi.<br /><br />Tämä virhe merkitsee yleensä sitä, että se ohjelma, jolla yritit luoda GEDCOM-tiedoston ei tehnyt sitä kunnolla tai kyseessä ei ole GEDCOM-tiedosto.. Tarkista, että latasit oikean GEDCOM-tiedoston ja että se alkaa rivillä 0 HEAD ja päättyy riviin 0 TRLR.";
$pgv_lang["macfile_detected_help"]		= "~HAVAITTU MACINTOSH-TIEDOSTO~<br />PhpGedView havaitsi, että GEDCOM-tiedostosi on luotu MacIntosh-tietokoneella. MacIntosh-tiedostot käyttävät eri rivinloppua (r) kuin Unix (n) tai Windows (rn). PhpGedView-ohjelman funktiot edellyttävät, että GEDCOM-tiedostot ovat joko Unix- tai DOS-tieodstoja. Kun näpäytät siivoa-painiketta, tiedostosi muunnetaan DOS-muotoon.<br />";
$pgv_lang["cleanup_places_help"]		= "~SIIVOA PAIKAT~<br />PhpGedView havaitsi, että GEDCOM-tiedostosi käyttää paikkoja sellaisten merkitsimien kohdalla, joissa ei pitäisi olla paikkoja. Useat sukututkimusohjelmat, kuten Family Tree Maker, luo tällaisia GEDCOM-tiedostoja. PhpGedView toimii tällaisten tiedostojen kanssa, mutta paikkahierarkiaan ilmestyy vääriä paikkoja.<br /><br />Esimerkiksi GEDCOM-tiedostossasi voi olla seuraava koodi:<br />1 SSN<br />2 PLAC 123-45-6789<br />GEDCOM määrittelyn mukaan sen tulisi olla<br />1 SSN 123-45-6789<br />Jos valitset <b>kyllä</b>, PhpGedView havaitsee ja korjaa nämä koodausvirheet.<br />";
$pgv_lang["empty_lines_detected_help"]	= "~HAVAITTU TYHJIÄ RIVEJÄ~<br />PhpGedView havaitsi, että GEDCOM-tiedostossasi on tyhjiä rivejä. Nämä voivat aiheuttaa virheitä ja poistetaan, ennen GEDCOM-tiedoston tuontia.<br />";
$pgv_lang["skip_cleanup_help"]			= "~OHITA SIIVOUS~ <br />On suositeltavaa, että PGV saa siivota GEDCOM-tiedostosi ennen sen tuontia, muuten saattaa käydä niin, että jotkut funktiot eivät toimi kunnolla.<br /><br />Mutta jos välttämättä haluat, voit näpäyttää tätä painiketta ohittaaksesi siivousvaiheen ja jatkaa GEDCOM-tiedoston tuontia sellaisenaan.<br />";

//-- Edit Config
$pgv_lang["help_editconfig.php"]		= "~KONFIGUROI PHPGEDVIEW~<br /><br />Tällä sivulla sinun on tehtävä ohjelman yleisasetukset heti sen jälkeen kun olet asentanut PhpGedView-ohjelman palvelimellesi ja käytät sitä ensimmäistä kertaa.<br />#pgv_lang[review_readme]#<br /><br /> Koska nämä asetukset ovat <b>yleisasetuksia</b> ne koskevat koko ohjelmaa ja kaikkia GEDCOM-tiedostoja, joita käytät ohjelmassa.<br />Jokaiselle GEDCOM-tiedostolle voit tehdä omat asetukset.<br />Koska olet tällä asetussivulla, voit näpäyttää linkkiä ylläpidä GEDCOM-tiedostoja heti lomakkeen yläpuolella.<br />Kaikkialla ohjelmassa löydät tämän linkin  OmaGedView-ikonin valikosta.";

//-- merge records
$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />Tällä sivulla voit liittää toisiinsa kaksi GEDCOM-tietuetta samasta GEDCOM-tiedostosta. Tämä on hyödyllistä henkilöille, jotka ovat yhdistänet GEDCOM-tiedostoja ja joilla nyt on useita identtisiä henkilöitä, perheitä ja lähteitä.<br /><br />Sivulla on kolme vaihetta:<br /><ul><li><b>Vaiheessa 1</b> pyydetään syöttämään kaksi ID-tunnusta. Tunnusten täytyy olla samaa typpiä. (Et voi yhdistää henkilöä ja perhettä tai perhettä ja lähdettä). Kenttään \"yhdistä tähän\" syötä se ID-tunnus, jonka haluat olevan uuden tietueen yhdistämisen jälkeen. Kenttään \"yhdistä tästä\" syötetään sen tietueen ID, joka on tarkoitus yhdistää ja joka poistetaan tämän jälkeen.</li><li><b>Vaiheessa 2</b> pyydetään valitsemaan ne tiedot, jotka halutaan säilyttää yhdistettävistä tietueista. Näpäytä säilytettävien asioiden vieressä olevia valintaruutuja. </li><li><b>Vaiheessa 3</b> näytetään yhdistämisen tulos. Kuten kaikissa muissakin on-line muutoksissa muutoksen on hyväksyttävä ennen kuin ne astuvat voimaan.</li></ul><br />";

//-- report engine
$pgv_lang["help_reportengine.php"]		= "~RAPORIT~<br /><br />PGV:n raporttimoottori käyttää XML mallipohjia luomaan automaattisesti PDF-raportteja. Ensimmäisenä vaiheena on valittava raporttityyppi. Käytettävissä olevat raporttimallit luodaan \"reports\"-hakemistossa olevien raporttien perusteella. Kun olet valinnut raporttimallin, sinun on annettava tälle raportille spesifiset tiedot mistä henkilöstä tai perheestä lähdetään liikkeelle ja näytetäänkö valokuvat. Kun olet valmis ajamaan raportin, näpäytä painiketta \"#pgv_lang[download_report]#\" ladataksesi raportin kovalevyllesi.<br /><br />Voit luoda oman raporttimallin kopioimalla olemassa olevan mallipohjan ja tekemällä muutokset sen XML-koodiin. Lisätäksesi oman raportti, kopioi se \"reports\"-kansioon ja PGV havaitsee sen automaattisesti ja lisää sen \"Valitse raportti\" alasvetovalikkoon.";
$pgv_lang["def_pdf_format_help"]	= "~PDF-TIEDOSTOMUOTO~<br />PhpGedView raportointimoottori tuottaa ladattavia raportteja Adobe&reg; PDF-muodossa. GEDCOM 5.5.1 standardin määrittely, joka on mainittu muualla tässä Help-tiedostossa, on myös ladattavissa PDF-tiedostona. PDF on lyhenne sanoista <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat.<br /><br />PDF-tiedostoja ei voi katsoa tai tulostaa tietokoneesi standardiohjelmistolla. Mikäli sinulla jo on asennettuna koneellesi Acrobat Reader, sinun ei tarvitse päivittää sitä voidaksesi avata PhpGedView-ohjelman tuottamia PDF-raporttitiedostoja.<br /><br />Näiden tiedostojen lukemiseen ja tulostamiseen tarvittava Acrobat Reader on ladattavissa ilmaiseksi osoitteesta  <a href=\"http://www.adobe.com\" target=_blank><b>Adobe Systems Inc.</b></a>. Acrobat Reader on ladattavissa muiltakin sivustoilta, mutta suosittelemme luottamaan <u>vain</u> Adobe Systems Inc. sivustoa. <br /><br />Acrobat Reader on saatavilla useille eri käyttöjärjestelmille kuten Microsoft&reg; Windows ja Apple&reg; Macintosh, ja monella eri kielellä. Mikäli sinulla on Windows 95, käytä Acrobat Reader versiota 5.0.5, koska uudemmat versiot eivät toimi Windows 95 järjestelmässä.<br /><br />";
$pgv_lang["help_ahnentafel.xml"]	= "~#pgv_lang[ahnentafel_report]#~<br />Tämä on raportti valitusta henkilöstä ja hänen esivanhemmistaan tulostettuna vihkosen muotoon. Se alkaa ensimmäisestä henkilöstä ja jatkuu hänen vanhempiinsa, isovanhempiinsa jne. <br /><br />Huomaa, että ahnentafelraportti on saatavissa vain englanniksi tällä hetkellä.<br /><br />";
$pgv_lang["help_birthlist.xml"]	= "~#pgv_lang[birth_report]#~<br />Tässä raportissa voit luetella kaikki henkilöt, jotka ovat syntyneet tiettynä aikana tai tietyssä paikassa.<br /><br />";
$pgv_lang["help_relativelist.xml"]	= "~#pgv_lang[relatives_report]#~<br />Tämä raportti luetteloi kaikki tietyn henkilön sukulaiset. Voit valita mitkä henkilön sukulaisista näytetään raportissa.<ul><li><b>#pgv_lang[child-family]#</b> näyttää henkilön sekä hänen vanhempansa ja sisaruksensa.</li><li><b>#pgv_lang[spouse-family]#</b> näyttää henkilön sekä hänen puolisonsa ja lapsensa.</li><li><b>#pgv_lang[direct-ancestors]#</b> näyttää henkilön, hänen vanhempansa, isovanhempansa, isoisovanhempansa jatkuen sukupuuta ylöspäin suoraan ylenevässä polvessa.</li><li><b>#pgv_lang[ancestors]#</b>näyttää samat kuin </li><li><b>#pgv_lang[ancestors]#</b> ja lisäksi sedät, tädit, isosedät ja -tädit sekä serkut. Serkusten lapsia ei näytetä.</li><li><b>#pgv_lang[descendants]#</b> näyttää henkilön ja kaikki suoraan alenevassa polvessa olevat lapset, lapsenlapset, lapsenlapsenlapset jne.</li><li><b>#pgv_lang[all]#</b> yhdistää #pgv_lang[descendants]# ja #pgv_lang[ancestors]# yhteen raporttiin.</li></ul><br /><br />";
$pgv_lang["help_xml_reports"]	= "~Raporttimoottori~PhpGedView raporttimoottori käyttää XML-mallitiedostoja luomaan PDF-raportteja. Käytettävissä olevat raportit <b>#pgv_lang[select_report]#</b>-luettelossa muodostetaan raportti- XML-tiedostoista, jotka ovat \"report\"-hakemistossa. Voit laatia omia raportteja kopioimalla ja muokkaamalla mitä tahansa olemassa olevaa XML-mallitiedostoa. Tallenna muokkaamasi raportti \"reports\"-hakemistoon ja PhpGedView havaitsee sen automaattisesti ja asettaa sen käytettäväksi <b>#pgv_lang[select_report]#</b> alasvetovalikossa.<br /><br />";

//-- Help Contents
$pgv_lang["help_contents_head_help"]	= "<b>Ohjeen sisältö</b><br /><br />";
$pgv_lang["help_contents_gedcom_info"]	= "GEDCOM tieto";
$pgv_lang["help_contents_gedcom_places"] = "Paikat GEDCOM-tiedostossa";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	= "<b>OHJEEN SISÄLTÖ<br /><br />ADMINISTRATOR HELP ITEMS</b> added to the beginning of the list.<br /><br />";
$pgv_lang["ah2_help"]				= "_konfiguroi PhpGedView";
$pgv_lang["ah3_help"]				= "_GEDCOM: vertaa lisää - lataa palvelimelle ";
$pgv_lang["ah4_help"]				= "_GEDCOM: asetustiedosto";
$pgv_lang["ah5_help"]				= "_GEDCOM: oletus";
$pgv_lang["ah6_help"]				= "_GEDCOM: poista";
$pgv_lang["ah7_help"]				= "_GEDCOM: lisää";
$pgv_lang["ah8_help"]				= "_GEDCOM: luo uusi";
$pgv_lang["ah9_help"]				= "_GEDCOM: lataa omalle koneelle";
$pgv_lang["ah10_help"]				= "_GEDCOM: ylläpitosivu";
$pgv_lang["ah11_help"]				= "_GEDCOM: konfiguroi";
$pgv_lang["ah12_help"]				= "_GEDCOM: tuo";
$pgv_lang["ah13_help"]				= "_GEDCOM: lataa palvelimelle";
$pgv_lang["ah14_help"]				= "_GEDCOM: varmenna";
$pgv_lang["ah15_help"]				= "_GEDCOM: muunna ANSI-muodosta UTF-8-muotoon";
$pgv_lang["ah16_help"]				= "_GEDCOM: yksityisyysasetukset";
$pgv_lang["ah17_help"]				= "_GEDCOM: käyttäjien ylläpito";
$pgv_lang["ah18_help"]				= "_ylläpito";
$pgv_lang["ah19_help"]				= "_GEDCOM: mediatyökalu";
$pgv_lang["ah20_help"]				= "_GEDCOM: muuta henkilön ID-tunnus";
$pgv_lang["ah21_help"]				= "_kielitiedostot";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]				= "_Konfiguroi tuettuja kieliä";
$pgv_lang["ah24_help"]				= "_käyttäjätiedon muunnos (Indeksi -->> SQL)";
$pgv_lang["ah25_help"]				= "Käyttäjätietojen varmuuskopio";
$pgv_lang["ah26_help"]				= "_FAQ-luettelo: editoi";

//-- Find Media Help
$pgv_lang["manage_media_help"]		= "~#pgv_lang[manage_media]#~<br><br>Tämä on vaihe kaksi hallitaksesi ladattuja mediatiedostoja, mikäli sinulla on median oletushakemistolle alihakemistoja.<br /><br />Ylläpito-oikeuksilla sinun on mahdollista luoda hakemistorakenne, jolla mediatiedostot pysyvät järjestyksessä. Luomalla hakemistot tältä sivulta varmistetaan, että pienoiskuvahakemisto luodaan ja että kuhunkin hakemistoon luodaan sopiva index.php.<br><br>Voit siirtää tiedostoja hakemistopuussa käyttämällä linkkiä \"Siirrä hakemistoon -->\". Samalla myös pienoiskuva siirtyy pitäen hakemistorakenteen oikeana.<br /><br />Mikäli et ladannut pienoiskuvia palvelimelle tai unohdit rastittaa \"luo pienoiskuvat\" valintaruudun lataamisen yhteydessä voit luoda pienoiskuvat täällä. Tarkista \"Näytä pienoiskuvat\" ruutua ja mikäli pienoiskuvaa ei löydy, voit näpäyttää linkkiä \"Luo pienoiskuva\" sellaisen luomiseksi.<br><br>";
$pgv_lang["simple_filter_help"]		= "~#pgv_lang[filter]#~<br /><br />Yksinkertainen hakusuodatin, joka perustuu syötettyihin merkkeihin. Jokerimerkkejä ei hyväksytä.";
$pgv_lang["show_thumb_help"]		= "~#pgv_lang[show_thumbnail]#~<br><br>Pienoiskuvat näytetään, mikäli rastitat tämän valintaruudun.";
$pgv_lang["new_dir_help"]			= "~#pgv_lang[add_directory]#~<br><br>Ylläpito-oikeuksilla sinun on mahdollista luoda hakemistorakenne, jolla mediatiedostot pysyvät järjestyksessä. Luomalla hakemistot tältä sivulta varmistetaan, että pienoiskuvahakemisto luodaan ja että kuhunkin hakemistoon luodaan sopiva index.php.<br><br><br><br>Näpäytä tätä linkkiä nähdäksesi tekstikentän, johon voit syöttää luotavan hakemiston nimen.";
$pgv_lang["find_media_help"]		= "~#pgv_lang[find_media]#~<br><br>Tämä mahdollistaa haun tiedostojärjestelmästä löytääksesi mediatiedoston, johon haluat linkittää.";
$pgv_lang["add_media_linkid"]		= "~Link ID~<br /><br />Jokainen mediatiedosto on linkitettävä yhteen tai useampaan henkilöön, perheeseen tai lähteeseen tietokannassa.<br /><br />Tällaisen linkin luomiseksi voit lisätä tai hakea henkilön, perheen tai lähteen ID-tunnuksen samanaikaisesti luodessasi mediatiedoston. Voit myös luoda linkin myöhemmin editoimalla Ylläpidä mediaa-sivua tai lisäämällä mediatiedosto käyttäen Lisää media-linkkiä henkilö-, perhe- tai lädesivulla.<br /><br />";
$pgv_lang["upload_server_file_help"] = "~#pgv_lang[server_file]#~<br /><br />Palvelimelle ladattava mediatiedosto voidaan ja pitäisikin nimetä uudellen. Tämä siksi, että omalla tietokoneellasi tiedoston nimellä voi olla jokin merkitys sinulle, mutta vähemmän merkitystä vierailijoille. Ajattele tilannetta, jossa sinä ja joku muu yritätte kummatkin ladata eri tiedoston nimellä \vaari.jpg\.<br /><br />Tähän kenttään määrittelet uuden nimen lataamallesi tiedostolle. Antamasi nimeä käytetään myös pienoiskuvan nimeämisessä. Pienoiskuva joko ladataan erikseen tai luodaan automaattisesti. Älä lisää tiedostonimen tiedostomuototunnusta (.jpg, .gif, .pdf, .doc jne).<br /><br />Jätä tämä kenttä tyhjäksi, jos haluat säilyttää alkuperäisen nimen.<br /><br />";
$pgv_lang["upload_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />Ylläpitäjä on sallinut korkeintaan #GLOBALS[MEDIA_DIRECTORY_LEVELS]# hakemistotasoa oletusarvon <b>#GLOBALS[MEDIA_DIRECTORY]#</b> lisäksi. Tämä auttaa median järjestämisessä ja vähentää nimiristiriitojen syntymistä.<br /><br />Tässä kentässä määrittelet sen hakemiston, johon ladattava mediatiedosto tallennetaan. Vastaava pienoiskuvatiedosto, joka on ladattu erikseen tai luotu automaattisesti, tallennetaan samanlaiseen hakemistorakenteeseen alkaen hekemistosta <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> hakemiston  <b>#GLOBALS[MEDIA_DIRECTORY]#</b> asemasta. Kohdehakemiston <b>#GLOBALS[MEDIA_DIRECTORY]#</b> osaa nimestä ei tarvitse lisätä.<br /><br />Mikäli et ole varma tähän lisättävästä tekstistä, ota yhteyttä ylläpitäjään.<br /><br />";

//-- Alive in Year Help
$pgv_lang["alive_in_year_help"]		= "~#pgv_lang[alive_in_year]#~<br><b>Tämä näyttää syötettynä vuotena olevat elävät henkilöt.<br /><br />Mikäli henkilölle on annettu yksiselitteiset syntymä- ja kuolinajat, henkilö merkitään eläväksi, jos päivämäärä sattuu hänen elinajalleen.<br /><br />Mikäli käytettävissä ovat epätäydelliset tai epätarkat päivämäärät pätevät seuraavat säännöt ja henkilön tilaksi merkitään \"ehkä\":<br><br><ul><li>Mikäli löytyy syntymätieto mutta ei kuolintietoa henkilö oletetaan kuolleen 120 vuoden iässä.</li><li>Mikäli löytyy syntymätieto ja merkintä kuollut jälkeen:<br>&nbsp;&nbsp;Merkitään eläväksi ennen kuollut jälkeen <br>&nbsp;&nbsp; \"ehkä\" tämän jälkeen.</li><li>Mikäli löytyy syntymätieto ja kuollut ennen:<br>&nbsp;&nbsp;Merkitään kuolleeksi oletetun päivämäärän jälkeen.<br>&nbsp;&nbsp;<br>&nbsp;&nbsp;Muuten \"ehkä\".</li></ul>";
$pgv_lang["year_help"]				= "~#pgv_lang[alive_in_year]~<br><br>Lisää vuosiluku, josta haluat luettelon elävistä henkilöistä.";

//--Repository Help
$pgv_lang["help_repolist.php"]		= "~TIETOVARASTOLUETTELOSIVU~<br /><br /> Tällä sivulla näytetään luettelo tietovarastoista. <br />Tietovarastot ovat nimen mukaan järjestetty aakkosjärjestykseen kuten GEDCOM-tiedostossa.<br /><br /><b>TIETOVARASTOT</b><br />Ilman tietovarastoja ei tietokantaamme voi muodostaa. Kaikelle tietokannassa olevalle tiedolle on olemassa lähde ja tämä lähde pidetään tietovarastossa. Se voi olla henkilön henkilökohtainen arkisto, laitos, julkinen tietokanta, jne. Jotta pääsisimme käsiksi lähteeseen haluamme tietää missä se sijaitsee. Kaikki tarpeellinen tieto lähteen saavuttamiseksi pidetään tietovarastotietueessa. <br />Tietovarasto voidaan linkittää moneen lähteeseen.";
$pgv_lang["help_repo.php"]			= "~YKSITYISKOHTAISIA TIETOJA TIETOVARASTOSTA~<br /><br />Tällä sivulla näytetään yksityiskohtaisia tietoja tietovarastosta. Yhdessä lähteiden kanssa tietovarastot ovat sukututkijalle hyvin tärkeitä ja mahdollistavat toisen tutkijan käyttämiä reittejä tiedon löytämiseksi. <br />Tällä sivulla voidaan näyttää tietovaraston nimi, osoite,, sähköpostiosoite ja verkkosivun osoite.<br /><br />Tietovarastoa koskevien tietojen jälkeen on luettelo kaikista niistä lähteistä jotka on linkitetty tähän tietovarastoon. Tällä tavoin voidaan nähdä kaikki tieto joka on saatu tietystä tietovarastosta.<br /><br />Mikäli ylläpitäjä on asettanut käytettäväksi, sivulla näkyy yksi tai kaksi muuta valikkokuvaketta:<br /><b>Näytä GEDCOM-tietue</b> - näyttää tiedon GEDCOM-muodossa.<br /><b>Lisää leikekoriin</b> - tämä tieto voidaan tallentaa leikekoriin. Sieltä voit ladata tiedon omalle koneellesi ja tuoda sen omaan sukututkimusohjelmaasi.<br /><br />Lisäohjeita sivulta löytyy näpäyttämällä <b>?</b>";
$pgv_lang["delete_repo_help"]		= "~POISTA TIETOVARASTO GEDCOM-TIEDOSTOSTA~<br /><br />Näpäyttämällä tätä merkitset tämän tietovaraston poistetavaksi GEDCOM-tiedostosta.<br />Mitä se merkitsee? <br />Mikäli sinulla on hyvä syy poistaa tämä tietovarasto, näpäytä linkkiä, jolloin aukeaa ponnahdusikkuna jossa kysytään oletko varma vai haluatko perua.<br /><br />Mikäli jatkat tietovaraston poistamista saattaa kestä hetken, ennen kuin uudessa ponnahdusikkunassa ilmoitetaan, että tietovarasto on poistettu.<br /><br />Kun jatkat vierailuasi havaitset, että tietovarasto on edelleen näkyvissä ja käytettävissä entiseen tapaan.<br /><br />Tämä <b>ei ole virhe</b>.<br />Ylläpitäjä saa viestin, että GEDCOM-tiedostoon on tehty muutos ja että olet poistanut tietovaraston. <br />Ylläpitäjä voi hyväksyä (tai hylätä) muutoksen. Vasta sen jälkeen poistaminen todellisuudessa tapahtuu.<br />Mikäli asiassa on epäselvyyksiä, ylläpitäjä ottaa sinun yhteyttä.";
$pgv_lang["show_repo_gedcom_help"]	= "~NÄYTÄ GEDCOMTIETUE~<br /><br />Näpäyttämällä tätä linkkiä näytetään ponnahdusikkunassa tietovarastoa koskeva tieto sellaisen kuin se on tallennettu GEDCOM-tiedostooon.";
$pgv_lang["add_repository_clip_help"]	= "~LISÄÄ TIETOVARASTO LEIKEKORIIN~<br /><br />Näpäyttämällä tätä linkkiä voit lisätä tietovaraston leikekoriin sellaisen kuin se on tallennettu GEDCOM-tiedostoon.";
$pgv_lang["repolist_listbox_help"]		= "~TIETOVARASTOJEN LUETTELORUUTU~<br /><br />Tässä ruudussa näytetään tietovarastojen nimet sellaisina kuin ne on tallennettu GEDCOM-tiedostoon.<br /><br />Nimet ovat aakkosjärjestyksessä.<br /><br />Näpäyttämällä nimeä luettelossa, avautuu tietovarastosivu, jossa on lueteltu kyseiseen tietovarastoon linkitetyt lähteet.";
$pgv_lang["repos_listbox_help"]		= "~TÄHÄN TIETOVARASTOON LINKITETYT TIETUEET~<br /><br />Tässä ruudussa näytetään tähän tietovarastoon linkitettyjen lähteiden nimet. <br />Nimet ovat aakkosjärjestyksessä.<br /><br />Näpäyttämällä nimeä luettelossa avautuu kyseistä lähdettä koskeva sivu.";
$pgv_lang["block_move_up_help"]		= "~Muuta luettelon järjestystä~<br /><br />Käytä näitä painikkeita muuttaaksesi luettelon järjestystä. Alueet tulostetaan luettelon osoittamassa järjestyksessä.<br /><br />Korosta siirrettävää kohdetta ja näpäytä sitten painiketta siirtääksesi kohdetta ylös- tai alaspäin.<br /><br />";
$pgv_lang["block_move_right_help"]	= "~Siirrä luettelon kohteita~<br /><br />Käytä näitä painikkeita siirtääksesi luettelon kohteen toiseen luetteloon.<br /><br />Korosta siirrettävä kohde, ja näpäytä sitten painiketta siirtääksesi tai kopioidaksesi sen nuolen suuntaan. Käytä <b>&raquo;</b>- ja <b>&laquo;</b>-painikkeita siirtääksesi kohteen vasemmanpuoleisimmasta luettelosta oikeammanpuoleisimpaan tai päinvastoin. Käytä <b>></b>- ja <b><</b>-painikkeita siirtääksesi korostetun kohteen #pgv_lang[available_blocks]#-luettelon oikealla tai vasemmalla puolella olevaan luetteloon.<br /><br />Kohteet #pgv_lang[available_blocks]#-luettelossa eivät muutu  />#pgv_lang[move_right]#- ja #pgv_lang[move_left]#-painikkeiden näpäyttämisestä huolimatta, koska sama alue voi esiintyä samalla sivulla useamman kerran. HTML-alue on hyvä esimerkki siitä, miksi näin haluat menetellä.<br /><br";
$pgv_lang["block_default_index"]	= "~Oletusalueet #pgv_lang[welcome]#-sivulla#<br /><br />Kun tyhjennät luettelot #pgv_lang[main_section]# and #pgv_lang[right_section]#, tai kun näpäytät <b>#pgv_lang[reset_default_blocks]#</b>-painiketta, alue asettuu seuraavasti:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";
$pgv_lang["block_default_portal"]	= "~Oletusalueet #pgv_lang[mygedview]#-sivulla~<br /><br />Kun tyhjennät luettelot #pgv_lang[main_section]# ja #pgv_lang[right_section]#, tai näpäytät <b>#pgv_lang[reset_default_blocks]#</b>-painiketta, alue asettuu seuraavasti: <br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";
$pgv_lang["accesskey_viewing_advice_help"]	= "~#pgv_lang[accesskeys]#~<br />Näppäinkomennot auttavat niitä, joilla on vaikeuksia hiiren ja muiden osoitinlaitteiden kanssa. Näppäinkomennot eroavat toisistaan eri selaimissa.:<ul><li>Internet Explorer 5+: Pidä ALT-näppäin alhaalla samalla kun painat haluttua merkkiä ja paina sen jälkeen ENTER</li><li>Firefox ja Netscape 6+: Pidä ALT-näppäin alhaalla samalla kun painat haluttua merkkiä. Älä paina ENTER.</li><li>Opera: Pidä VAIHTO- ja ESC-näppäimiä alhaalla samalla kun painat haluttua merkkinäppäintä. Älä paina ENTER .</li><li>Internet Explorer 5+ Mac / Safari 1.2 Pidä CTRL-näppäin alhaalla samalla kun painat haluttua merkkiä. Älä paina ENTER.</li></ul><br />Seuraavat näppäinkomennot ovat käytettävissä: <ul><li>Kaikki sivut <ul><li><b>nolla</b> - Tietoa näppäinkomennoista</li><li><b>yksi</b> - #pgv_lang[welcome_page]#</li><li><b>#pgv_lang[accesskey_help_content]#</b> - #pgv_lang[help_contents]#</li><li><b>#pgv_lang[accesskey_help_current_page]#</b> - #pgv_lang[help_for_this_page]#</li><li><b>#pgv_lang[accesskey_contact]#</b> - Kontakti </li><li><b>#pgv_lang[accesskey_skip_to_content]#</b> - Hyppää sisältöön</li><li><b>#pgv_lang[accesskey_search]#</b> - #pgv_lang[search]# </li></ul></li><li>Henkilösivu<ul><li><b>#pgv_lang[accesskey_individual_details]#</b> - Näytä #pgv_lang[personal_facts]# tab</li><li><b>#pgv_lang[accesskey_individual_notes]#</b> - Näytä #pgv_lang[notes]# tab</li><li><b>#pgv_lang[accesskey_individual_sources]#</b> - Näytä #pgv_lang[ssourcess]# tab</li><li><b>#pgv_lang[accesskey_individual_media]#</b> - Näytä #pgv_lang[media]# tab</li><li><b>#pgv_lang[accesskey_individual_relatives]#</b> - Näytä #pgv_lang[relatives]# tab</li><li><b>#pgv_lang[accesskey_individual_research_log]#</b> - Näytä #pgv_lang[research_log]# tab</li><li><b>#pgv_lang[accesskey_individual_pedigree]#</b> - Näytä henkilön #pgv_lang[pedigree_chart]#</li><li><b>#pgv_lang[accesskey_individual_descendancy]#</b> - Näytä henkilön #pgv_lang[descend_chart]#</li><li><b>#pgv_lang[accesskey_individual_timeline]#</b> - Näytä henkilön #pgv_lang[timeline_chart]#</li><li><b>#pgv_lang[accesskey_individual_relation_to_me]#</b> - Näytä henkilön #pgv_lang[relationship_to_me]# kaavio</li><li><b>#pgv_lang[accesskey_individual_gedcom]#</b> - #pgv_lang[view_gedcom]#</li></ul></li></ul><br />";
$pgv_lang["help_faq.php"] 			= "~Yleisimmät kysymykset~<br />FAQ (Yleisimmät kysymykset) -sivu voi sisältää yleiskatsauksen tai luettelon kysymyksistä ja vastauksista tämän sukututkimussivuston käytöstä.<br /><br />FAQ-sivun käyttö on täysin ylläpitäjän hallinnassa. Ylläptäjä valvoo jokaisen asian sisältöä ja myös asioiden esitysjärjestystä sivulla.<br />";
$pgv_lang["text_faq_help"] 			= "FAQ (Tavallisimmat kysymykset) -sivu voi sisältää yleiskuvauksen tai luettelon kysymyksistä ja vastauksista tämän sukututkimussivuston käytöstä.<br /><br />Riippuu täysin ylläpitäjästä, miten FAQ-sivua käytetään. Ylläpitäjä valvoo jokaisen kohteen sisältöä ja myös niiden järjestystä sivulla.";
$pgv_lang["hs_title_help"] 			= "<center>~#pgv_lang[hs_title]#~</center><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]				= "Voit tehdä hakuja PhpGedView:n ohjejärjestelmästä. #pgv_lang[hs_title]#-ominaisuus tekee mahdolliseksi sen, että hakufunktioita voidaan kontrolloida monipuolisesti. Haun pitäisi onnistua helposti.  ";
$pgv_lang["hs_keyword_advice"] 		= "~#pgv_lang[hs_keyword]#~<br />Lisää sana tai ilmaisu, jonka haluat löytää.<br /><br />Haku ei erottele pieniä ja suuria kirjaimia. Se merkitsee, että jos haet sanaa <b>Henkilö</b>, hakutulokseksi voi tulla <b>Henkilö</b>, <b>henkilö</b> tai <b>HENKILÖ</b>. Haku antaa myös tulokseksi <b>Henkilöt</b> jne., koska haku etsii merkkijonoja eikä sanoja.<br /><br />Voit hakea useita sanoja kerrallaan. Kirjoita kaikki haettavat sanat peräkkäin välilyönnillä erotettuna kuten esimerkiksi <b>henkilö&nbsp;suku&nbsp;lapsi</b>. Kun kirjoitat enemmän kuin yhden sanan, kirjoittamasi asioiden merkitys selkeytyy #pgv_lang[hs_searchhow]#-kentässä.< /br>";
$pgv_lang["hs_searchin_advice"]		= "~#pgv_lang[hs_searchin]#~<br />Tässä valitset haun kohteen.<br /><br />Ylläpitäjä voi tehdä hakuja käyttäjän ohjeesta tai konfiguraatio-ohjeesta tai kummastakin. Tavallisilla käyttäjillä ei ole tätä mahdollisuutta, koska heillä ei ole pääsyä konfigurointiominaisuuksiin. Tavallinen käyttäjä voi kohdistaa haun vain käytäjäohjetiedostoon.<br /><br />Ohjetiedostot sisältävät ohjetekstin lisäksi tiettyjä merkkijonoja joita käytetään luomaan lomakkeita ja muuta aineistoa. Tällä vaihtoehdolla voit valita kohdistetaanko haku koko ohjetiedostoon vai ainoastaan ohjetekstiin.<br />";
$pgv_lang["hs_searchhow_advice"]	= "~#pgv_lang[hs_searchhow]#~<br />Selvennät sitä mitä olet tarkoittanut #pgv_lang[hs_keyword]#-kentässä tekemällä valinnan tässä esitetyistä vaihtoedoista.<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>Mikäli olet kirjoittanut <b>henkilö&nbsp;perhe&nbsp;lapsi</b>, tämä vaihtoehto hakee  ohjeen, joka sisältää minkä tahansa näistä sanoista. Sanojen järjestyksellä ei ole merkitystä. Haku tapahtuu periaatteella \"Hae tekstiä, joka sisältää sanan <b>henkilö</b> <u>tai</u> <b>perhe</b> <u>tai</u> <b>lapsi</b>\".</dd><br /><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>Mikäli olet kirjoittanut <b>henkilö&nbsp;perhe&nbsp;lapsi</b>, tämä vaihtoehto hakee  ohjeen, joka sisältää kaikki nämä sanat.Sanojen järjestyksellä ei ole merkitystä. Haku tapahtuu periaatteella \"Hae tekstiä, joka sisältää sanan <b>henkilö</b> <u>ja</u> <b>perhe</b> <u>ja</u> <b>lapsi</b>.\"</dd><br /><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>Mikäli olet kirjoittanut   <b>henkilö&nbsp;perhe&nbsp;lapsi</b>, tämä vaihtoehto hakee  ohjeen, joka sisältää kaikki nämä sanat tässä järjestyksessä. Haku tapahtuu periaatteella \"Hae tekstiä, joka sisältää sanat<b>henkilö&nbsp;perhe&nbsp;lapsi</b> juuri tässä järjestyksessä ilman mitään muita merkkejä tai sanoja niiden välissä.\" Et todennäköisesti löydä tällaista tekstiä mistään ohjetekstistä.<br /><br />Joitakin rajoituksia: Tietyt erikoismerkit, kuten <b>&quot; < ></b> jne. ovat ohjetekstissä symbolimuodossa eivätkä löydy, jos ne ovat hakusanojesi joukossa. Jotkut ohjetekstit sisältävät tietynlaisia välilyöntejä, joita edustavat <b>&nbsp;</b> etkä löydä merkkijonoja, jotka sisältävät tämän merkin.</dd></dl>";
$pgv_lang["register_gedcomid_help"]	= "~#pgv_lang[gedcomid]#~<br /><br />Jokaisella henkilöllä tietokannassa on oma yksilöllinen ID-tunnuksensa. Mikäli tiedät oman ID-tunnuksesi lisää se tähän. Mikäli et tiedä sitä tai et voinut löytää sitä yksityisyysasetusten vuoksi, toimita kommenttikenttään riittävästi tietoa itsestäsi jotta ylläpitäjä tunnistaa sinut voidakseen asettaa ID-tunnuksen.";
$pgv_lang["register_comments_help"]	= "~#pgv_lang[comments]#~<br /><br />Käytä tätä kenttää kertoaksesi ylläpitäjälle miksi haluat käyttäjätilin ja kuinka olet sukua tämän sivuston henkilöille. Voit lisätä tähän myös muita kommentteja, joita sinulla on ylläpitäjälle.";
$pgv_lang["context_help"]			= "Lisää ohjeita saa näpäyttämällä <b>?</b> kohteen vieressä sivulla.";
$pgv_lang["edit_URL_help"]			= "Lisää URL-osoite http:// mukaanlukien. Esimerkki URL-osoitteesta on  http://www.phpgedview.net/<br /><br />Jätä tämä kenttä tyhjäksi, mikäli et halua lisätä URL-osoitetta.";
$pgv_lang["edit_EMAIL_help"]		= "Lisää sähköpostiosoite. Esimerkki sähköpostiosoitteesta on nimi@hotmail.com. <br /><br />Jätä tämä kenttä tyhjäksi, mikäli et halua lisätä sähköpostiosoitetta.";
$pgv_lang["edit_FAX_help"]			= "Lisää telefaxnumero suuntanumeroineen. <br /><br />Jätä tämä kenttä tyhjäksi, mikäli et halua lisätä telefaxnumeroa.";
$pgv_lang["edit_PHON_help"]			= "Lisää puhelinnumero suuntanumeroineen. Esimerkiksi numero Yhdysvaltoihin on muotoa (801) 555-5555.<br /><br />Jätä tämä kenttä tyhjäksi, mikäli et halua lisätä puhelinnumeroa.";
$pgv_lang["edit_ADDR_help"]			= "Lisää osoite kenttään samalla tavoin kuin kirjoittaisit sen kirjekuoreen.<br /><br />Jätä kenttä tyhjäksi, mikäli et halua lisätä osoitetta.";
$pgv_lang["edit_GIVN_help"]			= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]			= "~Sukunimen etulite~<br /><br />Lisää tai valitse luettelosta sukunimeä edeltävä etuliite. Tällaisia ovat esimerkiksi <b>von</b> Braun, <b>van der</b> Kloot, <b>de</b> Graaf, jne.";
$pgv_lang["edit_SURN_help"]			= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit_NSFX_help"]			= "#pgv_lang[edit_suffix_help]#";
$pgv_lang["edit__MARNM_help"]		= "~#factarray[_MARNM]#~<br /><br />Lisää tämän henkilön avionimi käyttäen samoja muotosääntöjä kuin Nimi-kentässä. Tämä kenttä ei ole pakollinen.<br /><br />Esimerkiksi mikäli Mary Jane Brown avioitui John Whiten kanssa, voit lisätä (ilman lainausmerkkejä)<ul><li>Amerikkalainen tapa:&nbsp;&nbsp;\"Mary Jane Brown /White/\"</li><li>Eurooppalainen tapa:&nbsp;&nbsp;\"Mary Jane /White/\"</li><li>Vaihtoehtoinen eurooppalainen tapa:&nbsp;&nbsp;\"Mary Jane /White-Brown/\" tai \"Mary Jane /Brown-White/\"</li></ul>Tee näin vain mikäli Mary Jane Brown alkoi käyttäää uutta nimeä avioiduttuaan John Whiten kanssa. Joissakin paikoissa, kuten esimerkiksi Kanadan Quebecissä, on laitonta muuttaa nimeä tällä tavoin.<br /><br />Miehet saattavat myös vaihtaa nimeään avioliiton jälkeen käyttäen joko kaksoisnimeä tai joskus ottaen puolison sukunimen.";
$pgv_lang["edit_SEX_help"]			= "~Editoi #factarray[SEX]#~<br /><br />Käytä tätä kenttää määritelläksesi onko henkilö <b>#pgv_lang[male]#</b> vai <b>#pgv_lang[female]#</b>.Valitse <b>#pgv_lang[unknown]#</b> vain, mikäli et ole varma henkilön sukupuolesta.";
$pgv_lang["edit_NAME_help"]			= "~Editoi #factarray[NAME]#~<br /><br />Nimet tulee lisätä siten, että sukunimi on kauttaviivojen \"/\" välissä.<br /><br />Katso seuraavat esimerkit:<ul><li>Etunimi /Sukunimi/</li><li>Etunimi /Sukunimi/ Jr.</li><li>Etunimi /von Sukunimi/ jr.</li></ul>";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />Käytä tätä lomaketta lisätäksesi linkittämättömän henkilön.<br /><br />Kun lisäät linkittämättömän henkilön sukupuuhusi, henkilö ei linkity kehenkään ennenkuin luot linkin. Voit myöhemmin luoda linkin henkilöiden välille #pgv_lang[indi_info]#-sivun  #pgv_lang[relatives]#-välilehdellä.";
$pgv_lang["edit_ROMN_help"]			= "~ROMANISOIDUT NIMET~<br /><br />Useissa kulttuureissa on tavallista kirjoittaa perinteiset nimet perinteisin kirjasimin ja myös nimen romanisoituna versiona sellaisena kuin se kirjoitettaisiin ja äännettäisiin romaanisella kielellä kuten englanniksi. Mikäli haluat lisätä perinteisen nimen vakionimikenttiin, voit lisätä romanisoidun version niihin kyseisestä nimestä. Nimen romanisoidut versiot näkyvät myös luetteloissa ja kaavioissa.";
$pgv_lang["edit__HEB_help"]			= "~HEPREALAINEN NIMI~<br /><br />Monissa kulttuureissa on tapana kirjoittaa perinteinen nimi perinteisin kirjasimin ja myös romanisoidulla nimen versiolla siten kuin se kirjoitettaisiin tai lausuttaisiin latinalaisiin aakkosiin perustuvilla kielilla kuten englanniksi.<br /><br /><br />Mikäli haluat kirjoittaa nimen latinalaisin aakkosin nimen vakiokenttiin, voit tähän kirjoittaa saman nimen muilla kirjasimilla kuten kreikaksi, venäjäksi, hepreaksi, arabiaksi tai kiinaksi. Kummatkin kirjoitustavat näkyvät luetteloissa ja kaavioissa.<br /><br /><br />Vaikka tämän kentän nimi on \"Heprea\", siinä voi käyttää myös muita kirjasimia.<br /><br />";
$pgv_lang["link_person_id_help"]	= "~#pgv_lang[label_local_id]#~<br /><br />Tähän kenttään lisäät sen henkilön ID-tunnukset, johon linkittäydyt (esim I100)";
$pgv_lang["link_gedcom_id_help"]	= "~#pgv_lang[label_gedcom_id]#~<br /><br />Käytä tätä osiota valitaksesi  linkilinkitettävän henkilön sisältävän vaihtoehtoisen tietokannan tunnisteen.";
$pgv_lang["link_remote_site_help"]	= "~#pgv_lang[label_site]#~<br /><br />Tässä määrittelet ne parametrit, joita tarvitaan kytketymiseksi siihen etäsivustoon, jossa linkitettävä tieto on. Voit joko valita aiemmin käyttämiesi sivustoijen luettelosta tai kirjoittamalla  #pgv_lang[label_site_url2]# ja #pgv_lang[label_gedcom_id]# uutta varten.<br /><br /><b>#pgv_lang[label_site_url2]#</b>-kenttään kirjoitat URL-osoitteen päästäksesi verkkokuvaustiedostoon (WDSL), joka kertoo PhjGedView-ohjelmalle miten päästä käsiksi etäsivuston aineistoon. PhpGedView etäsivustolla URL WSDL-tiedosto näyttää seuraavalta: <u>http://www.etapalvelin.com/phpGedView/genservice.php?wsdl.</u><br /><br /><b>#pgv_lang[label_gedcom_id]#</b>-kenttää käytetään lisäämään vaihtoehtoinen tietokantatunnistin sitä vaativille etäsivustoille. PhpGedView-sivustoilla se on GEDCOM-tiedoston nimi.<br /><br /><i>Huomaa: Etäpalvelimien on käytettävä PhpGedView-ohjelman versiota 3.4 tai uudempaa; vanhemmilla versioilla ei ole tätä ominaisuutta.</i>";
$pgv_lang["link_remote_location_help"]	= "~#pgv_lang[label_location]#~<br /><br />Tällä vaihtoehdolla voit valita onko linkitettävän henkilön tiedot samalla sivustolla, mutta eri sukupuutietokannassa vai onko tieto eri sivustolla, johon pääsee käsiksi internetin välityksellä.<br /><br />Mikäli henkilön tiedot ovat samalla sivustolla, sinun on valittava tietokantatunnistin ja kirjoitettava henkilön ID-tunnus.<br /><br />Etäsivuston ollessa kyseessä, on kirjoitettava sen URL, tietokantatunnistin ja ja henkilön etä-ID-tunnus.";
$pgv_lang["link_remote_rel_help"]	= "~#pgv_lang[label_rel_to_current]#~<br /><br />Käytä tätä vaihtoehtoa valitaksesi sukulaisuussuhteen, joka on etäsivustolla olevan henkilön ja omalla sivustolla olevan henkilön välillä. Esimerkiksi valitsemalla <i>Isä</i> merkitsee, että etäsivustolla oleva henkilö on paikallisesti linkitettävän henkilön isä.";
$pgv_lang["link_remote_help"]       = "~#pgv_lang[link_remote]#~<br /><br />Käytä tätä lomaketta linkittämään henkilö toiseen henkilöön joko toiselta sivustolta tai toisesta sukupuutietokannasta, johon omalla PhpGedView-ohjelmallasi voit päästä.<br /><br />Lisätäksesi sellaisen linkin, sinun on ensin valittava sukulaisuustyyppi, sitten joko PhpGedView-ohjelman ennestään tuntema sivusto tai määriteltävä uusi ja sitten vielä lisättävä sen henkilön ID-tunnus, johon haluat tehdä linkin. PhpGedView lataa sitten tarvittavat tiedot etäsivustolta. Ladattavasta tiedosta <u>ei</u> tule osaa omaa tietokantaasi, vaan jää alkuperäiseen paikkaansa ja lisätään niille sivuille, joilla linkitetty henkilö näkyy.<br /><br />Lisätietoa saat sivun kunkin asian vierestä olevasta ohjelinkistä. Voit myös saada lisätetoa englanninkieliseltä neuvontasivustolta:<A href=\"http://www.phpgedview.net/pgvdocs/index.php/HowToRemoteLink\" target=\"_blank\">http://www.phpgedview.net/pgvdocs/index.php/HowToRemoteLink</A>.";
$pgv_lang["edit_ABBR_help"]			= "~OTSIKKOLYHENNE~<br /><br />Käytä tätä kenttää tallentaaksesi lyhenteen otsikosta. Tätä kenttää käytetään lähteiden otsikkokentän yhteydessä. PGV käyttää oletusarvoisesti ensin otsikkoa ja sitten otsikkolyhennettä.<br /><br />GEDCOM 5.5 määrittelyn perusteella, \"tätä kenttää käytetään antamaan lyhyt otsikko lähdetietueiden lajittelua, tallentamista ja etsimistä varten (s. 62).\" <br /><br />PhpGedView-ohjelmassa otsikkolyhenne on valinnainen, mutta se vaaditaan muissa sukututkimusohjelmissa.";
$pgv_lang["link_remote_rel_help"]	= "~#pgv_lang[label_rel_to_current]#~<br /><br />Käytä tätä vaihtoehtoa valitaksesi sukulaisuusuhteen, joka on etäpalvelimella olevan henkilön ja omalla palvelimella olevan henkilön välillä. Esimerkiksi valitsemalla <i>Isä</i> merkitsee, että etäpalvelimella oleva henkilö on paikallisesti linkitettävän henkilön isä.";
$pgv_lang["edit_add_unlinked_source_help"]	= "~#pgv_lang[add_unlinked_source]#~<br /><br />Käytä tätä linkkiä lisätäksesi uuden lähteen tietokantaan linkittämättä lähdettä toisen tietueen lähdeviitteeseen. Uusi lähde näkyy lähdeluettelossa mutta ei missään kaaviossa tai muuallakaan ohjelmassa ennenkuin se on linkitetty lähdeviitteeseen.";

?>