<?php
  /**************************************************************************\
  * phpGroupWare - Brewer common view screen                                 *
  * http://www.phpgroupware.org                                              *
  * Written by Miles Lott <milosch@phpgroupware.org>                         *
  * -----------------------------------------------                          *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: view.php,v 1.4 2001/09/11 13:08:52 milosch Exp $ */

	$GLOBALS['phpgw_info']['flags'] = array(
		'currentapp' => 'brewer',
		'noheader'   => True,
		'nonavbar'   => True
	);
	include('../header.inc.php');

	$id = $HTTP_GET_VARS['id'] ? $HTTP_GET_VARS['id'] : $HTTP_POST_VARS['id'];
	$type = $HTTP_GET_VARS['type'] ? $HTTP_GET_VARS['type'] : $HTTP_POST_VARS['type'];
	$edit = $HTTP_POST_VARS['edit'];
	$cancel = $HTTP_POST_VARS['cancel'];

	if (!$id && $type || $cancel)
	{
		$redir = $type .'s.php';
		if (file_exists(PHPGW_APP_ROOT . SEP . $type . 'es.php'))
		{
			$redir = $type .'es.php';
		}
		Header('Location: ' . $GLOBALS['phpgw']->link('/brewer/' . $redir));
	}
	elseif($edit)
	{
		Header('Location: ' . $GLOBALS['phpgw']->link('/brewer/edit.php',"type=$type&id=$id"));
	}

	$GLOBALS['phpgw']->template->set_file(array('form' => 'view_' . $type . '.tpl'));
	$GLOBALS['phpgw']->template->set_block('form','header','header');
	$GLOBALS['phpgw']->template->set_block('form','body','body');
	$GLOBALS['phpgw']->template->set_block('form','footer','footer');

	$hidden_vars =
		  '<input type="hidden" name="sort"   value="' . $sort   . '">' . "\n"
		. '<input type="hidden" name="order"  value="' . $order  . '">' . "\n"
		. '<input type="hidden" name="type"   value="' . $type   . '">' . "\n"
		. '<input type="hidden" name="query"  value="' . $query  . '">' . "\n"
		. '<input type="hidden" name="start"  value="' . $start  . '">' . "\n"
		. '<input type="hidden" name="filter" value="' . $filter . '">' . "\n"
		. '<input type="hidden" name="id"     value="' . $id     . '">' . "\n";

	$b = CreateObject('brewer.brew',$type);
	$tmp = $b->$type->get($id);
	$view = $tmp[$id];

	$GLOBALS['phpgw']->template->set_var('title',lang('View') . ' ' . lang(ucfirst($type)));
	$GLOBALS['phpgw']->template->set_var('action_url',$GLOBALS['phpgw']->link('/brewer/view.php'));
	$GLOBALS['phpgw']->template->set_var('lang_edit',lang('Edit'));
	$GLOBALS['phpgw']->template->set_var('lang_cancel',lang('Cancel'));
	$GLOBALS['phpgw']->template->set_var('hidden_vars',$hidden_vars);
	/* Themes and colors */
	$GLOBALS['phpgw']->template->set_var('th_bg',$GLOBALS['phpgw_info']['theme']['th_bg']);
	$GLOBALS['phpgw']->template->set_var('th_text',$GLOBALS['phpgw_info']['theme']['th_text']);
	$GLOBALS['phpgw']->template->set_var('row_on',$GLOBALS['phpgw_info']['theme']['row_on']);
	$GLOBALS['phpgw']->template->set_var('row_off',$GLOBALS['phpgw_info']['theme']['row_off']);

	$vars = $GLOBALS['phpgw']->template->get_undefined('body');
	while (list($null,$value) = each($vars))
	{
		$valarray = explode('_',$value);
		$type = $valarray[0];
		$new = $newval = '';

		while($chunk = next($valarray))
		{
			$new[] = $chunk;
		}
		$newval = implode(' ',$new);

		switch ($type)
		{
			case "lang":
				$GLOBALS['phpgw']->template->set_var($value,lang($newval));
				break;
			case "value":
				$newval = ereg_replace(' ','_',$newval);
				$GLOBALS['phpgw']->template->set_var($value,$view[$newval]);
				break;
			case "selected":
				$configs = array();
				$config  = '';
				$newvals = explode(' ',$newval);
				$setting = end($newvals);
				for ($i=0;$i<(count($newvals) - 1); $i++)
				{
					$configs[] = $newvals[$i];
				}
				$config = implode('_',$configs);
				if ($view[$config] == $setting)
				{
					$GLOBALS['phpgw']->template->set_var($value,' selected');
				}
				else
				{
					$GLOBALS['phpgw']->template->set_var($value,'');
				}
				break;
			case "hook":
				$newval = ereg_replace(' ','_',$newval);
				$GLOBALS['phpgw']->template->set_var($value,$newval($view));
				break;
			default:
				$GLOBALS['phpgw']->template->set_var($value,'');
				break;
		}
	}

	$GLOBALS['phpgw']->common->phpgw_header();
	echo parse_navbar();

	$GLOBALS['phpgw']->template->pfp('out','header');
	$GLOBALS['phpgw']->template->pfp('out','body');
	$GLOBALS['phpgw']->template->pfp('out','footer');

	$GLOBALS['phpgw']->common->phpgw_footer();
?>
