<?php
	/**************************************************************************\
	* phpGroupWare - Inventory                                                 *
	* http://www.phpgroupware.org                                              *
	* Written by Joseph Engo <jengo@phpgroupware.org>                          *
	*            Bettina Gille [ceb@phpgroupware.org]                          *
	* -----------------------------------------------                          *
	* This program is free software; you can redistribute it and/or modify it  *
	* under the terms of the GNU General Public License as published by the    *
	* Free Software Foundation; either version 2 of the License, or (at your   *
	* option) any later version.                                               *
	\**************************************************************************/
	/* $Id: editproduct.php,v 1.56 2001/07/03 14:44:51 bettina Exp $ */

	if (!$con)
	{
		Header('Location: ' . $HTTP_REFERER);
	}

	$phpgw_info['flags'] = array('currentapp' => 'inv',
					'enable_categories_class' => True); 

	include('../header.inc.php');

	if (!$submit)
	{
		$referer = $HTTP_REFERER;
	}

	$hidden_vars = '<input type="hidden" name="sort" value="' . $sort . '">' . "\n"
				. '<input type="hidden" name="order" value="' . $order . '">' . "\n"
				. '<input type="hidden" name="query" value="' . $query . '">' . "\n"
				. '<input type="hidden" name="start" value="' . $start . '">' . "\n"
				. '<input type="hidden" name="filter" value="' . $filter . '">' . "\n"
				. '<input type="hidden" name="referer" value="' . $referer . '">' . "\n"
				. '<input type="hidden" name="con" value="' . $con . '">' . "\n";

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$t->set_file(array('form' => 'product_form.tpl'));
	$t->set_block('form','add','addhandle');
	$t->set_block('form','edit','edithandle');

//	$c = CreateObject('phpgwapi.categories');
	$grants = $phpgw->acl->get_grants('inv');
    $inventory = CreateObject('inv.inventory');
	$grants[$phpgw_info['user']['account_id']] = PHPGW_ACL_READ + PHPGW_ACL_ADD + PHPGW_ACL_EDIT + PHPGW_ACL_DELETE;

	if ($submit)
	{
		$errorcount = 0;		

		if (!$category)
		{
			$error[$errorcount++] = lang('Please select a category for that product !');
		}

		if (!$error)
		{
			$id = addslashes($id);

			if (! $serial)
			{
				if ($id)
				{
					$phpgw->db->query("select count(*) from phpgw_inv_products where id='$id' AND category='$category' AND con !='$con'");
					$phpgw->db->next_record();

					if ($phpgw->db->f(0) != 0)
					{
						$error[$errorcount++] = lang('That ID has been used already !');
					}
				}

				if ($short_name)
				{
					$phpgw->db->query("select count(*) from phpgw_inv_products where name='$short_name' AND category='$category' AND con !='$con'");
					$phpgw->db->next_record();

					if ($phpgw->db->f(0) != 0)
					{
						$error[$errorcount++] = lang('That name has been used already !');
					}
				}
			}
			else
			{
				$serial  = addslashes($serial);
			}

			if (checkdate($pmonth,$pday,$pyear))
			{
				$pdate = mktime(2,0,0,$pmonth,$pday,$pyear);
			}
			else
			{
				if ($pmonth && $pday && $pyear)
				{
					$error[$errorcount++] = lang('You have entered an invalid purchase date !');
				}
			}

			if (checkdate($smonth,$sday,$syear))
			{
				$sdate = mktime(2,0,0,$smonth,$sday,$syear);
			}
			else
			{
				if ($smonth && $sday && $syear)
				{
					$error[$errorcount++] = lang('You have entered an invalid selling date !');
				}
			}

			if (! $error)
			{
				$short_name = addslashes($short_name);
				$descr = addslashes($descr);
				$product_note = addslashes($product_note);
				if ($url == 'http://')
				{
					$url = '';
				}
				$url = addslashes($url);
				if ($ftp == 'ftp://')
				{
					$ftp = '';
				}
				$ftp = addslashes($ftp);

				$phpgw->db->query("update phpgw_inv_products set id='$id', serial='$serial',name='$short_name', descr='$descr', category='$category',"
							. "status='$status',cost='$cost', price='$price', retail='$retail', stock='$stock', mstock='$mstock',"
							. "url='$url',ftp='$ftp',dist='$dist',pdate='$pdate',sdate='$sdate',bin='$bin',product_note='$product_note' where con='$con'");

			}
		}
	}

	if ($errorcount)
	{
		$t->set_var('message',$phpgw->common->error_list($error));
	}
	if (($submit) && (! $error) && (! $errorcount))
	{
		$t->set_var('message',lang('Product x x has been updated !',$id,$short_name));
	}
	if ((! $submit) && (! $error) && (! $errorcount))
	{
		$t->set_var('message','');
	}

	if (isset($phpgw_info['user']['preferences']['common']['currency']))
	{
		$currency = $phpgw_info['user']['preferences']['common']['currency'];
		$t->set_var('error','');
	}
	else
	{
		$t->set_var('error',lang('Please set your preferences for this application !'));
	}

	$t->set_var('lang_x',lang('#'));
	$t->set_var('lang_action',lang('Edit product'));
	$t->set_var('actionurl',$phpgw->link('/inv/editproduct.php'));
	$t->set_var('hidden_vars',$hidden_vars);
	$t->set_var('lang_id',lang('Product ID'));
	$t->set_var('lang_short_name',lang('Short Name'));
	$t->set_var('lang_note',lang('Note'));
	$t->set_var('lang_url',lang('WWW'));
	$t->set_var('lang_ftp',lang('FTP'));
	$t->set_var('lang_description',lang('Description'));
	$t->set_var('lang_purchase_date',lang('Purchase date'));
	$t->set_var('lang_selling_date',lang('Selling date'));
	$t->set_var('lang_category',lang('Category'));
	$t->set_var('lang_in_stock',lang('in Stock'));
	$t->set_var('lang_min_stock',lang('Min Stock'));
	$t->set_var('lang_cost',lang('Purchase price'));
	$t->set_var('lang_price',lang('Selling price'));
	$t->set_var('lang_retail',lang('Retail'));
	$t->set_var('lang_status',lang('Status'));
	$t->set_var('lang_serial',lang('Serial number'));
	$t->set_var('lang_select_dist',lang('Select distributor'));
	$t->set_var('lang_select_room',lang('Select Stock room'));
	$t->set_var('lang_distributor',lang('Distributor'));
	$t->set_var('lang_room',lang('Stock room'));
	$t->set_var('currency',$currency);  
	$t->set_var('lang_choose','');
	$t->set_var('choose','');

	$phpgw->db->query("select * from phpgw_inv_products where con='$con'");
	$phpgw->db->next_record();

	$category = $phpgw->db->f('category');
	$dist = $phpgw->db->f('dist');
	$price = $phpgw->db->f('price');
	$pdate = $phpgw->db->f('pdate');
	$sdate = $phpgw->db->f('sdate');
	$status = $phpgw->db->f('status');
	$bin = $phpgw->db->f('bin');

	$t->set_var('id',$phpgw->db->f('id'));
	$t->set_var('short_name',$phpgw->strip_html($phpgw->db->f('name')));
	$t->set_var('descr',$phpgw->strip_html($phpgw->db->f('descr')));
	$t->set_var('serial',$phpgw->strip_html($phpgw->db->f('serial')));
	$t->set_var('product_note',$phpgw->strip_html($phpgw->db->f('product_note')));

	$url = $phpgw->db->f('url');
	if (! ereg('http://',$url))
	{
		$url = 'http://'. $url;
	}
	$t->set_var('url',$phpgw->strip_html($url));
	$ftp = $phpgw->db->f('ftp');
	if (! ereg('ftp://',$ftp))
	{
		$ftp = 'ftp://'. $ftp;
	}
	$t->set_var('ftp',$phpgw->strip_html($ftp));

	$t->set_var('cost',$phpgw->db->f('cost'));
	$t->set_var('price',$phpgw->db->f('price'));
	$t->set_var('stock',$phpgw->db->f('stock'));
	$t->set_var('mstock',$phpgw->db->f('mstock'));

	$taxpercent = select_tax($category);
	$retail = round($price*(1+$taxpercent),2);
	$t->set_var('retail',sprintf("%01.2f",$retail));
	$t->set_var('status_list',select_status_list($status));
	$t->set_var('category_list',$phpgw->categories->formated_list('select','all',$category,'False'));
	$t->set_var('room_list',$inventory->select_room_list($bin));

	$d = CreateObject('phpgwapi.contacts');
	$t->set_var('dist_list',select_dist_list($dist));

	$sm = CreateObject('phpgwapi.sbox');

	if ($pdate != 0)
	{
		$pmonth = date('m',$pdate);
		$pday = date('d',$pdate);
		$pyear = date('Y',$pdate);
	}
	else
	{
		$pmonth = 0;
		$pday = 0;
		$pyear = 0;
	}

	$t->set_var('purchase_date_select',$phpgw->common->dateformatorder($sm->getYears('pyear',$pyear),$sm->getMonthText('pmonth',$pmonth),$sm->getDays('pday',$pday)));

	if ($sdate != 0)
	{
		$smonth = date('m',$sdate);
		$sday = date('d',$sdate);
		$syear = date('Y',$sdate);
	}
	else
	{
		$smonth = 0;
		$sday = 0;
		$syear = 0;
	}

	$t->set_var('selling_date_select',$phpgw->common->dateformatorder($sm->getYears('syear',$syear),$sm->getMonthText('smonth',$smonth),$sm->getDays('sday',$sday)));

	$t->set_var('lang_edit',lang('Edit'));

	$owner = $phpgw->categories->id2name($category,'owner');

	if ($inventory->check_perms($grants[$owner],PHPGW_ACL_DELETE) || $owner == $phpgw_info['user']['account_id'])
	{
		$t->set_var('delete','<form method="POST" action="' . $phpgw->link('/inv/deleteproduct.php','con=' . $con . '&start=' . $start . '&query=' . $query
							. '&sort=' . $sort . '&order=' . $order . '&filter=' . $filter . '&referer=' . $referer) . '"><input type="submit" value="' . lang('Delete') .'"></form>');
	}
	else
	{
		$t->set_var('delete','&nbsp;');
	}

	$t->set_var('done_action',$referer);
	$t->set_var('lang_done',lang('Done'));

	$t->set_var('edithandle','');
	$t->set_var('addhandle','');
	$t->pparse('out','form');
	$t->pparse('edithandle','edit');

	$phpgw->common->phpgw_footer();
?>
