#include "transcode_data.h"

static const unsigned char
to_EUC_KR_C2_offsets[64] = {
     20, 20, 20, 20, 20, 20, 20, 20,     20, 20, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20,     20, 20, 20, 20, 20, 20, 20, 20,
     20,  0, 20, 20,  1, 20, 20,  2,      3, 20,  4, 20, 20,  5, 20, 20,
      6,  7,  8,  9, 10, 20, 11, 12,     13, 14, 15, 20, 16, 17, 18, 19,
};

static const struct byte_lookup* const
to_EUC_KR_C2_infos[21] = {
          o2(0xA2,0xAE),      o2(0xA2,0xB4),
          o2(0xA1,0xD7),      o2(0xA1,0xA7),
          o2(0xA8,0xA3),      o2(0xA1,0xA9),
          o2(0xA1,0xC6),      o2(0xA1,0xBE),
          o2(0xA9,0xF7),      o2(0xA9,0xF8),
          o2(0xA2,0xA5),      o2(0xA2,0xD2),
          o2(0xA1,0xA4),      o2(0xA2,0xAC),
          o2(0xA9,0xF6),      o2(0xA8,0xAC),
          o2(0xA8,0xF9),      o2(0xA8,0xF6),
          o2(0xA8,0xFA),      o2(0xA2,0xAF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_C2 = {
    to_EUC_KR_C2_offsets,
    to_EUC_KR_C2_infos
};

static const unsigned char
to_EUC_KR_C3_offsets[64] = {
     11, 11, 11, 11, 11, 11,  0, 11,     11, 11, 11, 11, 11, 11, 11, 11,
      1, 11, 11, 11, 11, 11, 11,  2,      3, 11, 11, 11, 11, 11,  4,  5,
     11, 11, 11, 11, 11, 11,  6, 11,     11, 11, 11, 11, 11, 11, 11, 11,
      7, 11, 11, 11, 11, 11, 11,  8,      9, 11, 11, 11, 11, 11, 10, 11,
};

static const struct byte_lookup* const
to_EUC_KR_C3_infos[12] = {
          o2(0xA8,0xA1),      o2(0xA8,0xA2),
          o2(0xA1,0xBF),      o2(0xA8,0xAA),
          o2(0xA8,0xAD),      o2(0xA9,0xAC),
          o2(0xA9,0xA1),      o2(0xA9,0xA3),
          o2(0xA1,0xC0),      o2(0xA9,0xAA),
          o2(0xA9,0xAD),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_C3 = {
    to_EUC_KR_C3_offsets,
    to_EUC_KR_C3_infos
};

static const unsigned char
to_EUC_KR_C4_offsets[64] = {
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  0,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  1,  2,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  3,  4,  5,  8,  8,  8,  8,      6,  8,  8,  8,  8,  8,  8,  7,
};

static const struct byte_lookup* const
to_EUC_KR_C4_infos[9] = {
          o2(0xA9,0xA2),      o2(0xA8,0xA4),
          o2(0xA9,0xA4),      o2(0xA9,0xA5),
          o2(0xA8,0xA6),      o2(0xA9,0xA6),
          o2(0xA9,0xA7),      o2(0xA8,0xA8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_C4 = {
    to_EUC_KR_C4_offsets,
    to_EUC_KR_C4_infos
};

static const unsigned char
to_EUC_KR_C5_offsets[64] = {
      0,  1,  2, 10, 10, 10, 10, 10,     10,  3,  4,  5, 10, 10, 10, 10,
     10, 10,  6,  7, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10,  8,  9,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_C5_infos[11] = {
          o2(0xA9,0xA8),      o2(0xA8,0xA9),
          o2(0xA9,0xA9),      o2(0xA9,0xB0),
          o2(0xA8,0xAF),      o2(0xA9,0xAF),
          o2(0xA8,0xAB),      o2(0xA9,0xAB),
          o2(0xA8,0xAE),      o2(0xA9,0xAE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_C5 = {
    to_EUC_KR_C5_offsets,
    to_EUC_KR_C5_infos
};

static const unsigned char
to_EUC_KR_CB_offsets[64] = {
      7,  7,  7,  7,  7,  7,  7,  0,      7,  7,  7,  7,  7,  7,  7,  7,
      1,  7,  7,  7,  7,  7,  7,  7,      2,  3,  4,  5,  7,  6,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_CB_infos[8] = {
          o2(0xA2,0xA7),      o2(0xA2,0xB0),
          o2(0xA2,0xA8),      o2(0xA2,0xAB),
          o2(0xA2,0xAA),      o2(0xA2,0xAD),
          o2(0xA2,0xA9),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_CB = {
    to_EUC_KR_CB_offsets,
    to_EUC_KR_CB_infos
};

static const unsigned char
to_EUC_KR_CE_offsets[64] = {
     39, 39, 39, 39, 39, 39, 39, 39,     39, 39, 39, 39, 39, 39, 39, 39,
     39,  0,  1,  2,  3,  4,  5,  6,      7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 39, 17, 18, 19, 20, 21,     22, 23, 39, 39, 39, 39, 39, 39,
     39, 24, 25, 26, 27, 28, 29, 30,     31, 32, 33, 34, 35, 36, 37, 38,
};

static const struct byte_lookup* const
to_EUC_KR_CE_infos[40] = {
          o2(0xA5,0xC1),      o2(0xA5,0xC2),
          o2(0xA5,0xC3),      o2(0xA5,0xC4),
          o2(0xA5,0xC5),      o2(0xA5,0xC6),
          o2(0xA5,0xC7),      o2(0xA5,0xC8),
          o2(0xA5,0xC9),      o2(0xA5,0xCA),
          o2(0xA5,0xCB),      o2(0xA5,0xCC),
          o2(0xA5,0xCD),      o2(0xA5,0xCE),
          o2(0xA5,0xCF),      o2(0xA5,0xD0),
          o2(0xA5,0xD1),      o2(0xA5,0xD2),
          o2(0xA5,0xD3),      o2(0xA5,0xD4),
          o2(0xA5,0xD5),      o2(0xA5,0xD6),
          o2(0xA5,0xD7),      o2(0xA5,0xD8),
          o2(0xA5,0xE1),      o2(0xA5,0xE2),
          o2(0xA5,0xE3),      o2(0xA5,0xE4),
          o2(0xA5,0xE5),      o2(0xA5,0xE6),
          o2(0xA5,0xE7),      o2(0xA5,0xE8),
          o2(0xA5,0xE9),      o2(0xA5,0xEA),
          o2(0xA5,0xEB),      o2(0xA5,0xEC),
          o2(0xA5,0xED),      o2(0xA5,0xEE),
          o2(0xA5,0xEF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_CE = {
    to_EUC_KR_CE_offsets,
    to_EUC_KR_CE_infos
};

static const unsigned char
to_EUC_KR_CF_offsets[64] = {
      0,  1,  9,  2,  3,  4,  5,  6,      7,  8,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
};

static const struct byte_lookup* const
to_EUC_KR_CF_infos[10] = {
          o2(0xA5,0xF0),      o2(0xA5,0xF1),
          o2(0xA5,0xF2),      o2(0xA5,0xF3),
          o2(0xA5,0xF4),      o2(0xA5,0xF5),
          o2(0xA5,0xF6),      o2(0xA5,0xF7),
          o2(0xA5,0xF8),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_CF = {
    to_EUC_KR_CF_offsets,
    to_EUC_KR_CF_infos
};

static const unsigned char
to_EUC_KR_D0_offsets[64] = {
     49,  0, 49, 49, 49, 49, 49, 49,     49, 49, 49, 49, 49, 49, 49, 49,
      1,  2,  3,  4,  5,  6,  7,  8,      9, 10, 11, 12, 13, 14, 15, 16,
     17, 18, 19, 20, 21, 22, 23, 24,     25, 26, 27, 28, 29, 30, 31, 32,
     33, 34, 35, 36, 37, 38, 39, 40,     41, 42, 43, 44, 45, 46, 47, 48,
};

static const struct byte_lookup* const
to_EUC_KR_D0_infos[50] = {
          o2(0xAC,0xA7),      o2(0xAC,0xA1),
          o2(0xAC,0xA2),      o2(0xAC,0xA3),
          o2(0xAC,0xA4),      o2(0xAC,0xA5),
          o2(0xAC,0xA6),      o2(0xAC,0xA8),
          o2(0xAC,0xA9),      o2(0xAC,0xAA),
          o2(0xAC,0xAB),      o2(0xAC,0xAC),
          o2(0xAC,0xAD),      o2(0xAC,0xAE),
          o2(0xAC,0xAF),      o2(0xAC,0xB0),
          o2(0xAC,0xB1),      o2(0xAC,0xB2),
          o2(0xAC,0xB3),      o2(0xAC,0xB4),
          o2(0xAC,0xB5),      o2(0xAC,0xB6),
          o2(0xAC,0xB7),      o2(0xAC,0xB8),
          o2(0xAC,0xB9),      o2(0xAC,0xBA),
          o2(0xAC,0xBB),      o2(0xAC,0xBC),
          o2(0xAC,0xBD),      o2(0xAC,0xBE),
          o2(0xAC,0xBF),      o2(0xAC,0xC0),
          o2(0xAC,0xC1),      o2(0xAC,0xD1),
          o2(0xAC,0xD2),      o2(0xAC,0xD3),
          o2(0xAC,0xD4),      o2(0xAC,0xD5),
          o2(0xAC,0xD6),      o2(0xAC,0xD8),
          o2(0xAC,0xD9),      o2(0xAC,0xDA),
          o2(0xAC,0xDB),      o2(0xAC,0xDC),
          o2(0xAC,0xDD),      o2(0xAC,0xDE),
          o2(0xAC,0xDF),      o2(0xAC,0xE0),
          o2(0xAC,0xE1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_D0 = {
    to_EUC_KR_D0_offsets,
    to_EUC_KR_D0_infos
};

static const unsigned char
to_EUC_KR_D1_offsets[64] = {
      0,  1,  2,  3,  4,  5,  6,  7,      8,  9, 10, 11, 12, 13, 14, 15,
     17, 16, 17, 17, 17, 17, 17, 17,     17, 17, 17, 17, 17, 17, 17, 17,
     17, 17, 17, 17, 17, 17, 17, 17,     17, 17, 17, 17, 17, 17, 17, 17,
     17, 17, 17, 17, 17, 17, 17, 17,     17, 17, 17, 17, 17, 17, 17, 17,
};

static const struct byte_lookup* const
to_EUC_KR_D1_infos[18] = {
          o2(0xAC,0xE2),      o2(0xAC,0xE3),
          o2(0xAC,0xE4),      o2(0xAC,0xE5),
          o2(0xAC,0xE6),      o2(0xAC,0xE7),
          o2(0xAC,0xE8),      o2(0xAC,0xE9),
          o2(0xAC,0xEA),      o2(0xAC,0xEB),
          o2(0xAC,0xEC),      o2(0xAC,0xED),
          o2(0xAC,0xEE),      o2(0xAC,0xEF),
          o2(0xAC,0xF0),      o2(0xAC,0xF1),
          o2(0xAC,0xD7),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_D1 = {
    to_EUC_KR_D1_offsets,
    to_EUC_KR_D1_infos
};

static const unsigned char
to_EUC_KR_E2_00_offsets[64] = {
     13, 13, 13, 13, 13, 13, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13,  0, 13, 13,      1,  2, 13, 13,  3,  4, 13, 13,
      5,  6, 13, 13, 13,  7,  8, 13,     13, 13, 13, 13, 13, 13, 13, 13,
      9, 13, 10, 11, 13, 13, 13, 13,     13, 13, 13, 12, 13, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E2_00_infos[14] = {
          o2(0xA1,0xAA),      o2(0xA1,0xAE),
          o2(0xA1,0xAF),      o2(0xA1,0xB0),
          o2(0xA1,0xB1),      o2(0xA2,0xD3),
          o2(0xA2,0xD4),      o2(0xA1,0xA5),
          o2(0xA1,0xA6),      o2(0xA2,0xB6),
          o2(0xA1,0xC7),      o2(0xA1,0xC8),
          o2(0xA1,0xD8),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_00 = {
    to_EUC_KR_E2_00_offsets,
    to_EUC_KR_E2_00_infos
};

static const unsigned char
to_EUC_KR_E2_01_offsets[64] = {
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  0,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  1,
};

static const struct byte_lookup* const
to_EUC_KR_E2_01_infos[3] = {
          o2(0xA9,0xF9),      o2(0xA9,0xFA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_01 = {
    to_EUC_KR_E2_01_offsets,
    to_EUC_KR_E2_01_infos
};

static const unsigned char
to_EUC_KR_E2_02_offsets[64] = {
      4,  0,  1,  2,  3,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
};

static const struct byte_lookup* const
to_EUC_KR_E2_02_infos[5] = {
          o2(0xA9,0xFB),      o2(0xA9,0xFC),
          o2(0xA9,0xFD),      o2(0xA9,0xFE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_02 = {
    to_EUC_KR_E2_02_offsets,
    to_EUC_KR_E2_02_infos
};

static const unsigned char
to_EUC_KR_E2_04_offsets[64] = {
      8,  8,  8,  0,  8,  8,  8,  8,      8,  1,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  2,  8,  8,  3,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  4,  5,  8,  8,  8,  6,  8,      8,  8,  8,  7,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E2_04_infos[9] = {
          o2(0xA1,0xC9),      o2(0xA2,0xB5),
          o2(0xA7,0xA4),      o2(0xA2,0xE0),
          o2(0xA2,0xE5),      o2(0xA2,0xE2),
          o2(0xA7,0xD9),      o2(0xA1,0xCA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_04 = {
    to_EUC_KR_E2_04_offsets,
    to_EUC_KR_E2_04_infos
};

static const unsigned char
to_EUC_KR_E2_05_offsets[64] = {
     26, 26, 26, 26, 26, 26, 26, 26,     26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26,  0,  1, 26, 26, 26,     26, 26, 26,  2,  3,  4,  5, 26,
      6,  7,  8,  9, 10, 11, 12, 13,     14, 15, 26, 26, 26, 26, 26, 26,
     16, 17, 18, 19, 20, 21, 22, 23,     24, 25, 26, 26, 26, 26, 26, 26,
};

static const struct byte_lookup* const
to_EUC_KR_E2_05_infos[27] = {
          o2(0xA8,0xF7),      o2(0xA8,0xF8),
          o2(0xA8,0xFB),      o2(0xA8,0xFC),
          o2(0xA8,0xFD),      o2(0xA8,0xFE),
          o2(0xA5,0xB0),      o2(0xA5,0xB1),
          o2(0xA5,0xB2),      o2(0xA5,0xB3),
          o2(0xA5,0xB4),      o2(0xA5,0xB5),
          o2(0xA5,0xB6),      o2(0xA5,0xB7),
          o2(0xA5,0xB8),      o2(0xA5,0xB9),
          o2(0xA5,0xA1),      o2(0xA5,0xA2),
          o2(0xA5,0xA3),      o2(0xA5,0xA4),
          o2(0xA5,0xA5),      o2(0xA5,0xA6),
          o2(0xA5,0xA7),      o2(0xA5,0xA8),
          o2(0xA5,0xA9),      o2(0xA5,0xAA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_05 = {
    to_EUC_KR_E2_05_offsets,
    to_EUC_KR_E2_05_infos
};

static const unsigned char
to_EUC_KR_E2_06_offsets[64] = {
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
      0,  1,  2,  3,  4,  5,  6,  7,      8,  9, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E2_06_infos[11] = {
          o2(0xA1,0xE7),      o2(0xA1,0xE8),
          o2(0xA1,0xE6),      o2(0xA1,0xE9),
          o2(0xA1,0xEA),      o2(0xA2,0xD5),
          o2(0xA2,0xD8),      o2(0xA2,0xD6),
          o2(0xA2,0xD9),      o2(0xA2,0xD7),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_06 = {
    to_EUC_KR_E2_06_offsets,
    to_EUC_KR_E2_06_infos
};

static const unsigned char
to_EUC_KR_E2_07_offsets[64] = {
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  0,  2,  1,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
};

static const struct byte_lookup* const
to_EUC_KR_E2_07_infos[3] = {
          o2(0xA2,0xA1),      o2(0xA2,0xA2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_07 = {
    to_EUC_KR_E2_07_offsets,
    to_EUC_KR_E2_07_infos
};

static const unsigned char
to_EUC_KR_E2_08_offsets[64] = {
      0, 24,  1,  2, 24, 24, 24,  3,      4, 24, 24,  5, 24, 24, 24,  6,
     24,  7, 24, 24, 24, 24, 24, 24,     24, 24,  8, 24, 24,  9, 10, 24,
     11, 24, 24, 24, 24, 12, 24, 13,     14, 15, 16, 17, 18, 24, 19, 24,
     24, 24, 24, 24, 20, 21, 24, 24,     24, 24, 24, 24, 22, 23, 24, 24,
};

static const struct byte_lookup* const
to_EUC_KR_E2_08_infos[25] = {
          o2(0xA2,0xA3),      o2(0xA1,0xD3),
          o2(0xA2,0xA4),      o2(0xA1,0xD4),
          o2(0xA1,0xF4),      o2(0xA1,0xF5),
          o2(0xA2,0xB3),      o2(0xA2,0xB2),
          o2(0xA1,0xEE),      o2(0xA1,0xF0),
          o2(0xA1,0xC4),      o2(0xA1,0xD0),
          o2(0xA1,0xAB),      o2(0xA1,0xFC),
          o2(0xA1,0xFD),      o2(0xA1,0xFB),
          o2(0xA1,0xFA),      o2(0xA1,0xF2),
          o2(0xA1,0xF3),      o2(0xA2,0xB1),
          o2(0xA1,0xC5),      o2(0xA1,0xF1),
          o2(0xA1,0xAD),      o2(0xA1,0xEF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_08 = {
    to_EUC_KR_E2_08_offsets,
    to_EUC_KR_E2_08_infos
};

static const unsigned char
to_EUC_KR_E2_09_offsets[64] = {
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  0,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      1,  2,  7,  7,  3,  4,  7,  7,      7,  7,  5,  6,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_E2_09_infos[8] = {
          o2(0xA1,0xD6),      o2(0xA1,0xC1),
          o2(0xA1,0xD5),      o2(0xA1,0xC2),
          o2(0xA1,0xC3),      o2(0xA1,0xEC),
          o2(0xA1,0xED),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_09 = {
    to_EUC_KR_E2_09_offsets,
    to_EUC_KR_E2_09_infos
};

static const unsigned char
to_EUC_KR_E2_0A_offsets[64] = {
      6,  6,  0,  1,  6,  6,  2,  3,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  4,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  5,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_E2_0A_infos[7] = {
          o2(0xA1,0xF8),      o2(0xA1,0xF9),
          o2(0xA1,0xF6),      o2(0xA1,0xF7),
          o2(0xA2,0xC1),      o2(0xA1,0xD1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_0A = {
    to_EUC_KR_E2_0A_offsets,
    to_EUC_KR_E2_0A_infos
};

static const unsigned char
to_EUC_KR_E2_0C_offsets[64] = {
      1,  1,  1,  1,  1,  1,  1,  1,      1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  0,  1,  1,  1,  1,  1,      1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,      1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,      1,  1,  1,  1,  1,  1,  1,  1,
};

static const struct byte_lookup* const
to_EUC_KR_E2_0C_infos[2] = {
          o2(0xA1,0xD2),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_0C = {
    to_EUC_KR_E2_0C_offsets,
    to_EUC_KR_E2_0C_infos
};

static const unsigned char
to_EUC_KR_E2_11_offsets[64] = {
     27, 27, 27, 27, 27, 27, 27, 27,     27, 27, 27, 27, 27, 27, 27, 27,
     27, 27, 27, 27, 27, 27, 27, 27,     27, 27, 27, 27, 27, 27, 27, 27,
      0,  1,  2,  3,  4,  5,  6,  7,      8,  9, 10, 11, 12, 13, 14, 27,
     27, 27, 27, 27, 15, 16, 17, 18,     19, 20, 21, 22, 23, 24, 25, 26,
};

static const struct byte_lookup* const
to_EUC_KR_E2_11_infos[28] = {
          o2(0xA8,0xE7),      o2(0xA8,0xE8),
          o2(0xA8,0xE9),      o2(0xA8,0xEA),
          o2(0xA8,0xEB),      o2(0xA8,0xEC),
          o2(0xA8,0xED),      o2(0xA8,0xEE),
          o2(0xA8,0xEF),      o2(0xA8,0xF0),
          o2(0xA8,0xF1),      o2(0xA8,0xF2),
          o2(0xA8,0xF3),      o2(0xA8,0xF4),
          o2(0xA8,0xF5),      o2(0xA9,0xE7),
          o2(0xA9,0xE8),      o2(0xA9,0xE9),
          o2(0xA9,0xEA),      o2(0xA9,0xEB),
          o2(0xA9,0xEC),      o2(0xA9,0xED),
          o2(0xA9,0xEE),      o2(0xA9,0xEF),
          o2(0xA9,0xF0),      o2(0xA9,0xF1),
          o2(0xA9,0xF2),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_11 = {
    to_EUC_KR_E2_11_offsets,
    to_EUC_KR_E2_11_infos
};

static const unsigned char
to_EUC_KR_E2_12_offsets[64] = {
      0,  1,  2, 29, 29, 29, 29, 29,     29, 29, 29, 29, 29, 29, 29, 29,
     29, 29, 29, 29, 29, 29, 29, 29,     29, 29, 29, 29,  3,  4,  5,  6,
      7,  8,  9, 10, 11, 12, 13, 14,     15, 16, 17, 18, 19, 20, 21, 22,
     23, 24, 25, 26, 27, 28, 29, 29,     29, 29, 29, 29, 29, 29, 29, 29,
};

static const struct byte_lookup* const
to_EUC_KR_E2_12_infos[30] = {
          o2(0xA9,0xF3),      o2(0xA9,0xF4),
          o2(0xA9,0xF5),      o2(0xA9,0xCD),
          o2(0xA9,0xCE),      o2(0xA9,0xCF),
          o2(0xA9,0xD0),      o2(0xA9,0xD1),
          o2(0xA9,0xD2),      o2(0xA9,0xD3),
          o2(0xA9,0xD4),      o2(0xA9,0xD5),
          o2(0xA9,0xD6),      o2(0xA9,0xD7),
          o2(0xA9,0xD8),      o2(0xA9,0xD9),
          o2(0xA9,0xDA),      o2(0xA9,0xDB),
          o2(0xA9,0xDC),      o2(0xA9,0xDD),
          o2(0xA9,0xDE),      o2(0xA9,0xDF),
          o2(0xA9,0xE0),      o2(0xA9,0xE1),
          o2(0xA9,0xE2),      o2(0xA9,0xE3),
          o2(0xA9,0xE4),      o2(0xA9,0xE5),
          o2(0xA9,0xE6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_12 = {
    to_EUC_KR_E2_12_offsets,
    to_EUC_KR_E2_12_infos
};

static const unsigned char
to_EUC_KR_E2_13_offsets[64] = {
     26, 26, 26, 26, 26, 26, 26, 26,     26, 26, 26, 26, 26, 26, 26, 26,
      0,  1,  2,  3,  4,  5,  6,  7,      8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,     24, 25, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26,     26, 26, 26, 26, 26, 26, 26, 26,
};

static const struct byte_lookup* const
to_EUC_KR_E2_13_infos[27] = {
          o2(0xA8,0xCD),      o2(0xA8,0xCE),
          o2(0xA8,0xCF),      o2(0xA8,0xD0),
          o2(0xA8,0xD1),      o2(0xA8,0xD2),
          o2(0xA8,0xD3),      o2(0xA8,0xD4),
          o2(0xA8,0xD5),      o2(0xA8,0xD6),
          o2(0xA8,0xD7),      o2(0xA8,0xD8),
          o2(0xA8,0xD9),      o2(0xA8,0xDA),
          o2(0xA8,0xDB),      o2(0xA8,0xDC),
          o2(0xA8,0xDD),      o2(0xA8,0xDE),
          o2(0xA8,0xDF),      o2(0xA8,0xE0),
          o2(0xA8,0xE1),      o2(0xA8,0xE2),
          o2(0xA8,0xE3),      o2(0xA8,0xE4),
          o2(0xA8,0xE5),      o2(0xA8,0xE6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_13 = {
    to_EUC_KR_E2_13_offsets,
    to_EUC_KR_E2_13_infos
};

static const unsigned char
to_EUC_KR_E2_14_offsets[64] = {
      0,  1,  2,  3, 56, 56, 56, 56,     56, 56, 56, 56,  4,  5,  6,  7,
      8,  9, 10, 11, 12, 13, 14, 15,     16, 17, 18, 19, 20, 21, 22, 23,
     24, 25, 26, 27, 28, 29, 30, 31,     32, 33, 34, 35, 36, 37, 38, 39,
     40, 41, 42, 43, 44, 45, 46, 47,     48, 49, 50, 51, 52, 53, 54, 55,
};

static const struct byte_lookup* const
to_EUC_KR_E2_14_infos[57] = {
          o2(0xA6,0xA1),      o2(0xA6,0xAC),
          o2(0xA6,0xA2),      o2(0xA6,0xAD),
          o2(0xA6,0xA3),      o2(0xA6,0xC8),
          o2(0xA6,0xC7),      o2(0xA6,0xAE),
          o2(0xA6,0xA4),      o2(0xA6,0xC2),
          o2(0xA6,0xC1),      o2(0xA6,0xAF),
          o2(0xA6,0xA6),      o2(0xA6,0xC6),
          o2(0xA6,0xC5),      o2(0xA6,0xB1),
          o2(0xA6,0xA5),      o2(0xA6,0xC4),
          o2(0xA6,0xC3),      o2(0xA6,0xB0),
          o2(0xA6,0xA7),      o2(0xA6,0xBC),
          o2(0xA6,0xC9),      o2(0xA6,0xCA),
          o2(0xA6,0xB7),      o2(0xA6,0xCB),
          o2(0xA6,0xCC),      o2(0xA6,0xB2),
          o2(0xA6,0xA9),      o2(0xA6,0xBE),
          o2(0xA6,0xCD),      o2(0xA6,0xCE),
          o2(0xA6,0xB9),      o2(0xA6,0xCF),
          o2(0xA6,0xD0),      o2(0xA6,0xB4),
          o2(0xA6,0xA8),      o2(0xA6,0xD1),
          o2(0xA6,0xD2),      o2(0xA6,0xB8),
          o2(0xA6,0xBD),      o2(0xA6,0xD3),
          o2(0xA6,0xD4),      o2(0xA6,0xB3),
          o2(0xA6,0xAA),      o2(0xA6,0xD5),
          o2(0xA6,0xD6),      o2(0xA6,0xBA),
          o2(0xA6,0xBF),      o2(0xA6,0xD7),
          o2(0xA6,0xD8),      o2(0xA6,0xB5),
          o2(0xA6,0xAB),      o2(0xA6,0xD9),
          o2(0xA6,0xDA),      o2(0xA6,0xBB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_14 = {
    to_EUC_KR_E2_14_offsets,
    to_EUC_KR_E2_14_infos
};

static const unsigned char
to_EUC_KR_E2_15_offsets[64] = {
      0,  1,  2,  3,  4,  5,  6,  7,      8,  9, 10, 11, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_E2_15_infos[13] = {
          o2(0xA6,0xDB),      o2(0xA6,0xDC),
          o2(0xA6,0xC0),      o2(0xA6,0xDD),
          o2(0xA6,0xDE),      o2(0xA6,0xDF),
          o2(0xA6,0xE0),      o2(0xA6,0xE1),
          o2(0xA6,0xE2),      o2(0xA6,0xE3),
          o2(0xA6,0xE4),      o2(0xA6,0xB6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_15 = {
    to_EUC_KR_E2_15_offsets,
    to_EUC_KR_E2_15_infos
};

static const unsigned char
to_EUC_KR_E2_16_offsets[64] = {
     16, 16, 16, 16, 16, 16, 16, 16,     16, 16, 16, 16, 16, 16, 16, 16,
     16, 16,  0, 16, 16, 16, 16, 16,     16, 16, 16, 16, 16, 16, 16, 16,
      1,  2, 16,  3,  4,  5,  6,  7,      8,  9, 16, 16, 16, 16, 16, 16,
     16, 16, 10, 11, 16, 16, 12, 13,     16, 16, 16, 16, 14, 15, 16, 16,
};

static const struct byte_lookup* const
to_EUC_KR_E2_16_infos[17] = {
          o2(0xA2,0xC6),      o2(0xA1,0xE1),
          o2(0xA1,0xE0),      o2(0xA2,0xC3),
          o2(0xA2,0xC7),      o2(0xA2,0xC8),
          o2(0xA2,0xCB),      o2(0xA2,0xCA),
          o2(0xA2,0xC9),      o2(0xA2,0xCC),
          o2(0xA1,0xE3),      o2(0xA1,0xE2),
          o2(0xA2,0xBA),      o2(0xA2,0xB9),
          o2(0xA1,0xE5),      o2(0xA1,0xE4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_16 = {
    to_EUC_KR_E2_16_offsets,
    to_EUC_KR_E2_16_infos
};

static const unsigned char
to_EUC_KR_E2_17_offsets[64] = {
      0,  1, 10, 10, 10, 10,  2,  3,      4, 10, 10,  5, 10, 10,  6,  7,
      8,  9, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E2_17_infos[11] = {
          o2(0xA2,0xB8),      o2(0xA2,0xB7),
          o2(0xA1,0xDF),      o2(0xA1,0xDE),
          o2(0xA2,0xC2),      o2(0xA1,0xDB),
          o2(0xA1,0xDD),      o2(0xA1,0xDC),
          o2(0xA2,0xC4),      o2(0xA2,0xC5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_17 = {
    to_EUC_KR_E2_17_offsets,
    to_EUC_KR_E2_17_infos
};

static const unsigned char
to_EUC_KR_E2_18_offsets[64] = {
      6,  6,  6,  6,  6,  0,  1,  6,      6,  6,  6,  6,  6,  6,  2,  3,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  4,  6,  5,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_E2_18_infos[7] = {
          o2(0xA1,0xDA),      o2(0xA1,0xD9),
          o2(0xA2,0xCF),      o2(0xA2,0xCE),
          o2(0xA2,0xD0),      o2(0xA2,0xD1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_18 = {
    to_EUC_KR_E2_18_offsets,
    to_EUC_KR_E2_18_infos
};

static const unsigned char
to_EUC_KR_E2_19_offsets[64] = {
      0, 13,  1, 13, 13, 13, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
      2,  3, 13,  4,  5,  6, 13,  7,      8,  9, 10, 13, 11, 12, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E2_19_infos[14] = {
          o2(0xA1,0xCF),      o2(0xA1,0xCE),
          o2(0xA2,0xBC),      o2(0xA2,0xBD),
          o2(0xA2,0xC0),      o2(0xA2,0xBB),
          o2(0xA2,0xBE),      o2(0xA2,0xBF),
          o2(0xA2,0xCD),      o2(0xA2,0xDB),
          o2(0xA2,0xDC),      o2(0xA2,0xDD),
          o2(0xA2,0xDA),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2_19 = {
    to_EUC_KR_E2_19_offsets,
    to_EUC_KR_E2_19_infos
};

static const unsigned char
to_EUC_KR_E2_offsets[64] = {
      0,  1,  2, 20,  3,  4,  5,  6,      7,  8,  9, 20, 10, 20, 20, 20,
     20, 11, 12, 13, 14, 15, 16, 17,     18, 19, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20,     20, 20, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20,     20, 20, 20, 20, 20, 20, 20, 20,
};

static const struct byte_lookup* const
to_EUC_KR_E2_infos[21] = {
       &to_EUC_KR_E2_00,   &to_EUC_KR_E2_01,
       &to_EUC_KR_E2_02,   &to_EUC_KR_E2_04,
       &to_EUC_KR_E2_05,   &to_EUC_KR_E2_06,
       &to_EUC_KR_E2_07,   &to_EUC_KR_E2_08,
       &to_EUC_KR_E2_09,   &to_EUC_KR_E2_0A,
       &to_EUC_KR_E2_0C,   &to_EUC_KR_E2_11,
       &to_EUC_KR_E2_12,   &to_EUC_KR_E2_13,
       &to_EUC_KR_E2_14,   &to_EUC_KR_E2_15,
       &to_EUC_KR_E2_16,   &to_EUC_KR_E2_17,
       &to_EUC_KR_E2_18,   &to_EUC_KR_E2_19,
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E2 = {
    to_EUC_KR_E2_offsets,
    to_EUC_KR_E2_infos
};

static const unsigned char
to_EUC_KR_E3_00_offsets[64] = {
      0,  1,  2,  3, 17, 17, 17, 17,      4,  5,  6,  7,  8,  9, 10, 11,
     12, 13, 17, 14, 15, 16, 17, 17,     17, 17, 17, 17, 17, 17, 17, 17,
     17, 17, 17, 17, 17, 17, 17, 17,     17, 17, 17, 17, 17, 17, 17, 17,
     17, 17, 17, 17, 17, 17, 17, 17,     17, 17, 17, 17, 17, 17, 17, 17,
};

static const struct byte_lookup* const
to_EUC_KR_E3_00_infos[18] = {
          o2(0xA1,0xA1),      o2(0xA1,0xA2),
          o2(0xA1,0xA3),      o2(0xA1,0xA8),
          o2(0xA1,0xB4),      o2(0xA1,0xB5),
          o2(0xA1,0xB6),      o2(0xA1,0xB7),
          o2(0xA1,0xB8),      o2(0xA1,0xB9),
          o2(0xA1,0xBA),      o2(0xA1,0xBB),
          o2(0xA1,0xBC),      o2(0xA1,0xBD),
          o2(0xA1,0xEB),      o2(0xA1,0xB2),
          o2(0xA1,0xB3),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E3_00 = {
    to_EUC_KR_E3_00_offsets,
    to_EUC_KR_E3_00_infos
};

static const unsigned char
to_EUC_KR_E3_01_offsets[64] = {
     63,  0,  1,  2,  3,  4,  5,  6,      7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,     23, 24, 25, 26, 27, 28, 29, 30,
     31, 32, 33, 34, 35, 36, 37, 38,     39, 40, 41, 42, 43, 44, 45, 46,
     47, 48, 49, 50, 51, 52, 53, 54,     55, 56, 57, 58, 59, 60, 61, 62,
};

static const struct byte_lookup* const
to_EUC_KR_E3_01_infos[64] = {
          o2(0xAA,0xA1),      o2(0xAA,0xA2),
          o2(0xAA,0xA3),      o2(0xAA,0xA4),
          o2(0xAA,0xA5),      o2(0xAA,0xA6),
          o2(0xAA,0xA7),      o2(0xAA,0xA8),
          o2(0xAA,0xA9),      o2(0xAA,0xAA),
          o2(0xAA,0xAB),      o2(0xAA,0xAC),
          o2(0xAA,0xAD),      o2(0xAA,0xAE),
          o2(0xAA,0xAF),      o2(0xAA,0xB0),
          o2(0xAA,0xB1),      o2(0xAA,0xB2),
          o2(0xAA,0xB3),      o2(0xAA,0xB4),
          o2(0xAA,0xB5),      o2(0xAA,0xB6),
          o2(0xAA,0xB7),      o2(0xAA,0xB8),
          o2(0xAA,0xB9),      o2(0xAA,0xBA),
          o2(0xAA,0xBB),      o2(0xAA,0xBC),
          o2(0xAA,0xBD),      o2(0xAA,0xBE),
          o2(0xAA,0xBF),      o2(0xAA,0xC0),
          o2(0xAA,0xC1),      o2(0xAA,0xC2),
          o2(0xAA,0xC3),      o2(0xAA,0xC4),
          o2(0xAA,0xC5),      o2(0xAA,0xC6),
          o2(0xAA,0xC7),      o2(0xAA,0xC8),
          o2(0xAA,0xC9),      o2(0xAA,0xCA),
          o2(0xAA,0xCB),      o2(0xAA,0xCC),
          o2(0xAA,0xCD),      o2(0xAA,0xCE),
          o2(0xAA,0xCF),      o2(0xAA,0xD0),
          o2(0xAA,0xD1),      o2(0xAA,0xD2),
          o2(0xAA,0xD3),      o2(0xAA,0xD4),
          o2(0xAA,0xD5),      o2(0xAA,0xD6),
          o2(0xAA,0xD7),      o2(0xAA,0xD8),
          o2(0xAA,0xD9),      o2(0xAA,0xDA),
          o2(0xAA,0xDB),      o2(0xAA,0xDC),
          o2(0xAA,0xDD),      o2(0xAA,0xDE),
          o2(0xAA,0xDF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E3_01 = {
    to_EUC_KR_E3_01_offsets,
    to_EUC_KR_E3_01_infos
};

static const unsigned char
to_EUC_KR_E3_02_offsets[64] = {
      0,  1,  2,  3,  4,  5,  6,  7,      8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 51, 51, 51, 51,     51, 51, 51, 51, 51, 51, 51, 51,
     51, 20, 21, 22, 23, 24, 25, 26,     27, 28, 29, 30, 31, 32, 33, 34,
     35, 36, 37, 38, 39, 40, 41, 42,     43, 44, 45, 46, 47, 48, 49, 50,
};

static const struct byte_lookup* const
to_EUC_KR_E3_02_infos[52] = {
          o2(0xAA,0xE0),      o2(0xAA,0xE1),
          o2(0xAA,0xE2),      o2(0xAA,0xE3),
          o2(0xAA,0xE4),      o2(0xAA,0xE5),
          o2(0xAA,0xE6),      o2(0xAA,0xE7),
          o2(0xAA,0xE8),      o2(0xAA,0xE9),
          o2(0xAA,0xEA),      o2(0xAA,0xEB),
          o2(0xAA,0xEC),      o2(0xAA,0xED),
          o2(0xAA,0xEE),      o2(0xAA,0xEF),
          o2(0xAA,0xF0),      o2(0xAA,0xF1),
          o2(0xAA,0xF2),      o2(0xAA,0xF3),
          o2(0xAB,0xA1),      o2(0xAB,0xA2),
          o2(0xAB,0xA3),      o2(0xAB,0xA4),
          o2(0xAB,0xA5),      o2(0xAB,0xA6),
          o2(0xAB,0xA7),      o2(0xAB,0xA8),
          o2(0xAB,0xA9),      o2(0xAB,0xAA),
          o2(0xAB,0xAB),      o2(0xAB,0xAC),
          o2(0xAB,0xAD),      o2(0xAB,0xAE),
          o2(0xAB,0xAF),      o2(0xAB,0xB0),
          o2(0xAB,0xB1),      o2(0xAB,0xB2),
          o2(0xAB,0xB3),      o2(0xAB,0xB4),
          o2(0xAB,0xB5),      o2(0xAB,0xB6),
          o2(0xAB,0xB7),      o2(0xAB,0xB8),
          o2(0xAB,0xB9),      o2(0xAB,0xBA),
          o2(0xAB,0xBB),      o2(0xAB,0xBC),
          o2(0xAB,0xBD),      o2(0xAB,0xBE),
          o2(0xAB,0xBF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E3_02 = {
    to_EUC_KR_E3_02_offsets,
    to_EUC_KR_E3_02_infos
};

static const unsigned char
to_EUC_KR_E3_03_offsets[64] = {
      0,  1,  2,  3,  4,  5,  6,  7,      8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,     24, 25, 26, 27, 28, 29, 30, 31,
     32, 33, 34, 35, 36, 37, 38, 39,     40, 41, 42, 43, 44, 45, 46, 47,
     48, 49, 50, 51, 52, 53, 54, 55,     55, 55, 55, 55, 55, 55, 55, 55,
};

static const struct byte_lookup* const
to_EUC_KR_E3_03_infos[56] = {
          o2(0xAB,0xC0),      o2(0xAB,0xC1),
          o2(0xAB,0xC2),      o2(0xAB,0xC3),
          o2(0xAB,0xC4),      o2(0xAB,0xC5),
          o2(0xAB,0xC6),      o2(0xAB,0xC7),
          o2(0xAB,0xC8),      o2(0xAB,0xC9),
          o2(0xAB,0xCA),      o2(0xAB,0xCB),
          o2(0xAB,0xCC),      o2(0xAB,0xCD),
          o2(0xAB,0xCE),      o2(0xAB,0xCF),
          o2(0xAB,0xD0),      o2(0xAB,0xD1),
          o2(0xAB,0xD2),      o2(0xAB,0xD3),
          o2(0xAB,0xD4),      o2(0xAB,0xD5),
          o2(0xAB,0xD6),      o2(0xAB,0xD7),
          o2(0xAB,0xD8),      o2(0xAB,0xD9),
          o2(0xAB,0xDA),      o2(0xAB,0xDB),
          o2(0xAB,0xDC),      o2(0xAB,0xDD),
          o2(0xAB,0xDE),      o2(0xAB,0xDF),
          o2(0xAB,0xE0),      o2(0xAB,0xE1),
          o2(0xAB,0xE2),      o2(0xAB,0xE3),
          o2(0xAB,0xE4),      o2(0xAB,0xE5),
          o2(0xAB,0xE6),      o2(0xAB,0xE7),
          o2(0xAB,0xE8),      o2(0xAB,0xE9),
          o2(0xAB,0xEA),      o2(0xAB,0xEB),
          o2(0xAB,0xEC),      o2(0xAB,0xED),
          o2(0xAB,0xEE),      o2(0xAB,0xEF),
          o2(0xAB,0xF0),      o2(0xAB,0xF1),
          o2(0xAB,0xF2),      o2(0xAB,0xF3),
          o2(0xAB,0xF4),      o2(0xAB,0xF5),
          o2(0xAB,0xF6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E3_03 = {
    to_EUC_KR_E3_03_offsets,
    to_EUC_KR_E3_03_infos
};

static const unsigned char
to_EUC_KR_E3_04_offsets[64] = {
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
     15,  0,  1,  2,  3,  4,  5,  6,      7,  8,  9, 10, 11, 12, 13, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E3_04_infos[16] = {
          o2(0xA4,0xA1),      o2(0xA4,0xA2),
          o2(0xA4,0xA3),      o2(0xA4,0xA4),
          o2(0xA4,0xA5),      o2(0xA4,0xA6),
          o2(0xA4,0xA7),      o2(0xA4,0xA8),
          o2(0xA4,0xA9),      o2(0xA4,0xAA),
          o2(0xA4,0xAB),      o2(0xA4,0xAC),
          o2(0xA4,0xAD),      o2(0xA4,0xAE),
          o2(0xA4,0xAF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E3_04 = {
    to_EUC_KR_E3_04_offsets,
    to_EUC_KR_E3_04_infos
};

static const unsigned char
to_EUC_KR_E3_05_offsets[64] = {
      0,  1,  2,  3,  4,  5,  6,  7,      8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,     24, 25, 26, 27, 28, 29, 30, 31,
     32, 33, 34, 35, 36, 37, 38, 39,     40, 41, 42, 43, 44, 45, 46, 47,
     48, 49, 50, 51, 52, 53, 54, 55,     56, 57, 58, 59, 60, 61, 62, 63,
};

static const struct byte_lookup* const
to_EUC_KR_E3_05_infos[65] = {
          o2(0xA4,0xB0),      o2(0xA4,0xB1),
          o2(0xA4,0xB2),      o2(0xA4,0xB3),
          o2(0xA4,0xB4),      o2(0xA4,0xB5),
          o2(0xA4,0xB6),      o2(0xA4,0xB7),
          o2(0xA4,0xB8),      o2(0xA4,0xB9),
          o2(0xA4,0xBA),      o2(0xA4,0xBB),
          o2(0xA4,0xBC),      o2(0xA4,0xBD),
          o2(0xA4,0xBE),      o2(0xA4,0xBF),
          o2(0xA4,0xC0),      o2(0xA4,0xC1),
          o2(0xA4,0xC2),      o2(0xA4,0xC3),
          o2(0xA4,0xC4),      o2(0xA4,0xC5),
          o2(0xA4,0xC6),      o2(0xA4,0xC7),
          o2(0xA4,0xC8),      o2(0xA4,0xC9),
          o2(0xA4,0xCA),      o2(0xA4,0xCB),
          o2(0xA4,0xCC),      o2(0xA4,0xCD),
          o2(0xA4,0xCE),      o2(0xA4,0xCF),
          o2(0xA4,0xD0),      o2(0xA4,0xD1),
          o2(0xA4,0xD2),      o2(0xA4,0xD3),
          o2(0xA4,0xD4),      o2(0xA4,0xD5),
          o2(0xA4,0xD6),      o2(0xA4,0xD7),
          o2(0xA4,0xD8),      o2(0xA4,0xD9),
          o2(0xA4,0xDA),      o2(0xA4,0xDB),
          o2(0xA4,0xDC),      o2(0xA4,0xDD),
          o2(0xA4,0xDE),      o2(0xA4,0xDF),
          o2(0xA4,0xE0),      o2(0xA4,0xE1),
          o2(0xA4,0xE2),      o2(0xA4,0xE3),
          o2(0xA4,0xE4),      o2(0xA4,0xE5),
          o2(0xA4,0xE6),      o2(0xA4,0xE7),
          o2(0xA4,0xE8),      o2(0xA4,0xE9),
          o2(0xA4,0xEA),      o2(0xA4,0xEB),
          o2(0xA4,0xEC),      o2(0xA4,0xED),
          o2(0xA4,0xEE),      o2(0xA4,0xEF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E3_05 = {
    to_EUC_KR_E3_05_offsets,
    to_EUC_KR_E3_05_infos
};

static const unsigned char
to_EUC_KR_E3_06_offsets[64] = {
      0,  1,  2,  3,  4,  5,  6,  7,      8,  9, 10, 11, 12, 13, 14, 15,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
};

static const struct byte_lookup* const
to_EUC_KR_E3_06_infos[16] = {
          o2(0xA4,0xF0),      o2(0xA4,0xF1),
          o2(0xA4,0xF2),      o2(0xA4,0xF3),
          o2(0xA4,0xF4),      o2(0xA4,0xF5),
          o2(0xA4,0xF6),      o2(0xA4,0xF7),
          o2(0xA4,0xF8),      o2(0xA4,0xF9),
          o2(0xA4,0xFA),      o2(0xA4,0xFB),
          o2(0xA4,0xFC),      o2(0xA4,0xFD),
          o2(0xA4,0xFE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E3_06 = {
    to_EUC_KR_E3_06_offsets,
    to_EUC_KR_E3_06_infos
};

static const unsigned char
to_EUC_KR_E3_08_offsets[64] = {
      0,  1,  2,  3,  4,  5,  6,  7,      8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,     24, 25, 26, 27, 28, 29, 29, 29,
     29, 29, 29, 29, 29, 29, 29, 29,     29, 29, 29, 29, 29, 29, 29, 29,
     29, 29, 29, 29, 29, 29, 29, 29,     29, 29, 29, 29, 29, 29, 29, 29,
};

static const struct byte_lookup* const
to_EUC_KR_E3_08_infos[30] = {
          o2(0xA9,0xB1),      o2(0xA9,0xB2),
          o2(0xA9,0xB3),      o2(0xA9,0xB4),
          o2(0xA9,0xB5),      o2(0xA9,0xB6),
          o2(0xA9,0xB7),      o2(0xA9,0xB8),
          o2(0xA9,0xB9),      o2(0xA9,0xBA),
          o2(0xA9,0xBB),      o2(0xA9,0xBC),
          o2(0xA9,0xBD),      o2(0xA9,0xBE),
          o2(0xA9,0xBF),      o2(0xA9,0xC0),
          o2(0xA9,0xC1),      o2(0xA9,0xC2),
          o2(0xA9,0xC3),      o2(0xA9,0xC4),
          o2(0xA9,0xC5),      o2(0xA9,0xC6),
          o2(0xA9,0xC7),      o2(0xA9,0xC8),
          o2(0xA9,0xC9),      o2(0xA9,0xCA),
          o2(0xA9,0xCB),      o2(0xA9,0xCC),
          o2(0xA2,0xDF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E3_08 = {
    to_EUC_KR_E3_08_offsets,
    to_EUC_KR_E3_08_infos
};

static const unsigned char
to_EUC_KR_E3_09_offsets[64] = {
     29, 29, 29, 29, 29, 29, 29, 29,     29, 29, 29, 29, 29, 29, 29, 29,
     29, 29, 29, 29, 29, 29, 29, 29,     29, 29, 29, 29, 29, 29, 29, 29,
      0,  1,  2,  3,  4,  5,  6,  7,      8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,     24, 25, 26, 27, 29, 29, 29, 28,
};

static const struct byte_lookup* const
to_EUC_KR_E3_09_infos[30] = {
          o2(0xA8,0xB1),      o2(0xA8,0xB2),
          o2(0xA8,0xB3),      o2(0xA8,0xB4),
          o2(0xA8,0xB5),      o2(0xA8,0xB6),
          o2(0xA8,0xB7),      o2(0xA8,0xB8),
          o2(0xA8,0xB9),      o2(0xA8,0xBA),
          o2(0xA8,0xBB),      o2(0xA8,0xBC),
          o2(0xA8,0xBD),      o2(0xA8,0xBE),
          o2(0xA8,0xBF),      o2(0xA8,0xC0),
          o2(0xA8,0xC1),      o2(0xA8,0xC2),
          o2(0xA8,0xC3),      o2(0xA8,0xC4),
          o2(0xA8,0xC5),      o2(0xA8,0xC6),
          o2(0xA8,0xC7),      o2(0xA8,0xC8),
          o2(0xA8,0xC9),      o2(0xA8,0xCA),
          o2(0xA8,0xCB),      o2(0xA8,0xCC),
          o2(0xA2,0xDE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E3_09 = {
    to_EUC_KR_E3_09_offsets,
    to_EUC_KR_E3_09_infos
};

static const unsigned char
to_EUC_KR_E3_0E_offsets[64] = {
      0,  1,  2,  3,  4, 61, 61, 61,      5,  6,  7,  8,  9, 10, 11, 12,
     13, 14, 15, 16, 17, 18, 19, 20,     21, 22, 23, 24, 25, 26, 27, 28,
     29, 30, 31, 32, 33, 34, 35, 36,     37, 38, 39, 40, 41, 42, 43, 44,
     45, 46, 47, 48, 49, 50, 51, 52,     53, 54, 55, 56, 57, 58, 59, 60,
};

static const struct byte_lookup* const
to_EUC_KR_E3_0E_infos[62] = {
          o2(0xA7,0xC9),      o2(0xA7,0xCA),
          o2(0xA7,0xCB),      o2(0xA7,0xCC),
          o2(0xA7,0xCD),      o2(0xA7,0xBA),
          o2(0xA7,0xBB),      o2(0xA7,0xDC),
          o2(0xA7,0xDD),      o2(0xA7,0xDE),
          o2(0xA7,0xB6),      o2(0xA7,0xB7),
          o2(0xA7,0xB8),      o2(0xA7,0xD4),
          o2(0xA7,0xD5),      o2(0xA7,0xD6),
          o2(0xA7,0xD7),      o2(0xA7,0xD8),
          o2(0xA7,0xA1),      o2(0xA7,0xA2),
          o2(0xA7,0xA3),      o2(0xA7,0xA5),
          o2(0xA7,0xAB),      o2(0xA7,0xAC),
          o2(0xA7,0xAD),      o2(0xA7,0xAE),
          o2(0xA7,0xAF),      o2(0xA7,0xB0),
          o2(0xA7,0xB1),      o2(0xA7,0xB2),
          o2(0xA7,0xB3),      o2(0xA7,0xB4),
          o2(0xA7,0xA7),      o2(0xA7,0xA8),
          o2(0xA7,0xA9),      o2(0xA7,0xAA),
          o2(0xA7,0xBD),      o2(0xA7,0xBE),
          o2(0xA7,0xE5),      o2(0xA7,0xE6),
          o2(0xA7,0xE7),      o2(0xA7,0xE8),
          o2(0xA7,0xE1),      o2(0xA7,0xE2),
          o2(0xA7,0xE3),      o2(0xA7,0xBF),
          o2(0xA7,0xC0),      o2(0xA7,0xC1),
          o2(0xA7,0xC2),      o2(0xA7,0xC3),
          o2(0xA7,0xC4),      o2(0xA7,0xC5),
          o2(0xA7,0xC6),      o2(0xA7,0xC7),
          o2(0xA7,0xC8),      o2(0xA7,0xCE),
          o2(0xA7,0xCF),      o2(0xA7,0xD0),
          o2(0xA7,0xD1),      o2(0xA7,0xD2),
          o2(0xA7,0xD3),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E3_0E = {
    to_EUC_KR_E3_0E_offsets,
    to_EUC_KR_E3_0E_infos
};

static const unsigned char
to_EUC_KR_E3_0F_offsets[64] = {
      0,  1,  2,  3,  4,  5,  6,  7,      8,  9, 10, 19, 19, 19, 19, 11,
     12, 19, 19, 13, 19, 19, 14, 19,     15, 19, 19, 16, 17, 18, 19, 19,
     19, 19, 19, 19, 19, 19, 19, 19,     19, 19, 19, 19, 19, 19, 19, 19,
     19, 19, 19, 19, 19, 19, 19, 19,     19, 19, 19, 19, 19, 19, 19, 19,
};

static const struct byte_lookup* const
to_EUC_KR_E3_0F_infos[20] = {
          o2(0xA7,0xDA),      o2(0xA7,0xDB),
          o2(0xA2,0xE3),      o2(0xA7,0xEC),
          o2(0xA7,0xA6),      o2(0xA7,0xE0),
          o2(0xA7,0xEF),      o2(0xA2,0xE1),
          o2(0xA7,0xBC),      o2(0xA7,0xED),
          o2(0xA7,0xB5),      o2(0xA7,0xB9),
          o2(0xA7,0xEA),      o2(0xA7,0xEB),
          o2(0xA7,0xDF),      o2(0xA2,0xE4),
          o2(0xA7,0xE4),      o2(0xA7,0xEE),
          o2(0xA7,0xE9),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E3_0F = {
    to_EUC_KR_E3_0F_offsets,
    to_EUC_KR_E3_0F_infos
};

static const unsigned char
to_EUC_KR_E3_offsets[64] = {
      0,  1,  2,  3,  4,  5,  6, 11,      7,  8, 11, 11, 11, 11,  9, 10,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_E3_infos[12] = {
       &to_EUC_KR_E3_00,   &to_EUC_KR_E3_01,
       &to_EUC_KR_E3_02,   &to_EUC_KR_E3_03,
       &to_EUC_KR_E3_04,   &to_EUC_KR_E3_05,
       &to_EUC_KR_E3_06,   &to_EUC_KR_E3_08,
       &to_EUC_KR_E3_09,   &to_EUC_KR_E3_0E,
       &to_EUC_KR_E3_0F,              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E3 = {
    to_EUC_KR_E3_offsets,
    to_EUC_KR_E3_infos
};

static const unsigned char
to_EUC_KR_E4_38_offsets[64] = {
      0,  1, 21,  2, 21, 21, 21,  3,      4,  5,  6,  7, 21,  8, 21, 21,
     21,  9, 21, 21, 10, 11, 12, 21,     13, 14, 21, 21, 21, 21, 15, 21,
     21, 21, 21, 21, 21, 21, 21, 21,     21, 21, 21, 21, 21, 16, 21, 21,
     21, 21, 17, 21, 21, 21, 21, 21,     18, 19, 21, 20, 21, 21, 21, 21,
};

static const struct byte_lookup* const
to_EUC_KR_E4_38_infos[22] = {
          o2(0xEC,0xE9),      o2(0xEF,0xCB),
          o2(0xF6,0xD2),      o2(0xD8,0xB2),
          o2(0xED,0xDB),      o2(0xDF,0xB2),
          o2(0xDF,0xBE),      o2(0xF9,0xBB),
          o2(0xDC,0xF4),      o2(0xF5,0xE4),
          o2(0xF3,0xA6),      o2(0xDD,0xE0),
          o2(0xE1,0xA6),      o2(0xCE,0xF8),
          o2(0xDC,0xB0),      o2(0xE3,0xAA),
          o2(0xF1,0xE9),      o2(0xCD,0xFA),
          o2(0xFC,0xAF),      o2(0xD3,0xA1),
          o2(0xF1,0xAB),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E4_38 = {
    to_EUC_KR_E4_38_offsets,
    to_EUC_KR_E4_38_infos
};

static const unsigned char
to_EUC_KR_E4_39_offsets[64] = {
     19, 19,  0,  1, 19,  2, 19, 19,     19, 19, 19,  3, 19,  4,  5,  6,
     19, 19, 19, 19, 19, 19,  7, 19,      8,  9, 19, 19, 19, 10, 11, 12,
     19, 19, 19, 19, 19, 19, 19, 19,     19, 19, 19, 13, 19, 14, 19, 19,
     19, 19, 19, 15, 19, 19, 16, 17,     19, 19, 19, 19, 19, 19, 18, 19,
};

static const struct byte_lookup* const
to_EUC_KR_E4_39_infos[20] = {
          o2(0xE7,0xD1),      o2(0xD2,0xAC),
          o2(0xCE,0xF9),      o2(0xF1,0xFD),
          o2(0xDE,0xBF),      o2(0xFB,0xBA),
          o2(0xF9,0xB9),      o2(0xCE,0xD2),
          o2(0xE3,0xAB),      o2(0xEB,0xE0),
          o2(0xCE,0xFA),      o2(0xCB,0xF7),
          o2(0xE5,0xA5),      o2(0xCA,0xE1),
          o2(0xD4,0xCC),      o2(0xEA,0xE1),
          o2(0xDC,0xE3),      o2(0xDF,0xAD),
          o2(0xCB,0xEB),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E4_39 = {
    to_EUC_KR_E4_39_offsets,
    to_EUC_KR_E4_39_infos
};

static const unsigned char
to_EUC_KR_E4_3A_offsets[64] = {
     26, 26,  0, 26, 26, 26,  1, 26,      2, 26, 26,  3,  4, 26,  5, 26,
      6,  7,  8, 26,  9, 10, 26, 26,     11, 26, 26, 12, 26, 26, 13, 26,
     26, 14, 15, 26, 16, 17, 18, 26,     19, 26, 26, 20, 21, 22, 23, 26,
     26, 26, 26, 26, 26, 26, 24, 26,     26, 26, 25, 26, 26, 26, 26, 26,
};

static const struct byte_lookup* const
to_EUC_KR_E4_3A_infos[27] = {
          o2(0xD5,0xAF),      o2(0xD6,0xF5),
          o2(0xE5,0xF8),      o2(0xDE,0xC0),
          o2(0xEC,0xA3),      o2(0xE9,0xCD),
          o2(0xEA,0xA7),      o2(0xE9,0xF6),
          o2(0xFB,0xBB),      o2(0xE7,0xE9),
          o2(0xEF,0xCC),      o2(0xD0,0xE6),
          o2(0xDE,0xC1),      o2(0xE4,0xAC),
          o2(0xD8,0xCC),      o2(0xF9,0xF1),
          o2(0xCE,0xDF),      o2(0xFA,0xA4),
          o2(0xE6,0xB2),      o2(0xFA,0xFB),
          o2(0xFA,0xBD),      o2(0xCC,0xC8),
          o2(0xEF,0xCD),      o2(0xD5,0xD5),
          o2(0xD3,0xA2),      o2(0xEC,0xD1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E4_3A = {
    to_EUC_KR_E4_3A_offsets,
    to_EUC_KR_E4_3A_infos
};

static const unsigned char
to_EUC_KR_E4_3B_offsets[64] = {
      0,  1, 23, 23,  2, 23, 23,  3,     23, 23,  4,  5, 23,  6, 23, 23,
     23, 23, 23, 23,  7,  8,  9, 10,     11, 12, 23, 23, 23, 13, 23, 14,
     23, 23, 23, 15, 16, 17, 23, 23,     23, 23, 23, 23, 23, 23, 23, 23,
     18, 23, 19, 23, 23, 23, 20, 21,     23, 23, 23, 22, 23, 23, 23, 23,
};

static const struct byte_lookup* const
to_EUC_KR_E4_3B_infos[24] = {
          o2(0xE4,0xA7),      o2(0xEC,0xD2),
          o2(0xF6,0xB1),      o2(0xCE,0xFB),
          o2(0xD0,0xD1),      o2(0xCB,0xBF),
          o2(0xED,0xA4),      o2(0xED,0xA8),
          o2(0xDE,0xC2),      o2(0xF6,0xE2),
          o2(0xED,0xDC),      o2(0xDC,0xF5),
          o2(0xE0,0xB9),      o2(0xD4,0xCE),
          o2(0xF4,0xB5),      o2(0xD3,0xDB),
          o2(0xD6,0xB5),      o2(0xEC,0xA4),
          o2(0xE4,0xE6),      o2(0xF1,0xEA),
          o2(0xCB,0xEC),      o2(0xCB,0xC0),
          o2(0xEC,0xF2),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E4_3B = {
    to_EUC_KR_E4_3B_offsets,
    to_EUC_KR_E4_3B_infos
};

static const unsigned char
to_EUC_KR_E4_3C_offsets[64] = {
     16,  0, 16, 16, 16, 16, 16, 16,     16,  1,  2,  3, 16,  4,  5,  6,
      7,  8, 16, 16, 16, 16, 16, 16,     16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,     16, 16, 16, 16, 16, 16, 16,  9,
     16, 16, 16, 16, 10, 16, 11, 16,     12, 16, 13, 16, 14, 15, 16, 16,
};

static const struct byte_lookup* const
to_EUC_KR_E4_3C_infos[17] = {
          o2(0xD0,0xEA),      o2(0xF9,0xF2),
          o2(0xEC,0xA5),      o2(0xD0,0xDF),
          o2(0xE7,0xEA),      o2(0xD0,0xEB),
          o2(0xDC,0xD1),      o2(0xDB,0xE9),
          o2(0xFD,0xCC),      o2(0xDB,0xD7),
          o2(0xDA,0xE1),      o2(0xD6,0xB6),
          o2(0xE3,0xDF),      o2(0xDE,0xC3),
          o2(0xDE,0xC4),      o2(0xCA,0xA1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E4_3C = {
    to_EUC_KR_E4_3C_offsets,
    to_EUC_KR_E4_3C_infos
};

static const unsigned char
to_EUC_KR_E4_3D_offsets[64] = {
     22, 22, 22,  0, 22, 22,  1,  2,      3, 22, 22, 22, 22,  4,  5,  6,
      7,  8, 22, 22, 22,  9, 22, 22,     22, 10, 11, 12, 13, 22, 22, 22,
     22, 22, 22, 22, 22, 22, 22, 22,     22, 14, 22, 22, 22, 22, 22, 15,
     16, 22, 22, 17, 22, 22, 18, 22,     22, 22, 19, 22, 22, 22, 20, 21,
};

static const struct byte_lookup* const
to_EUC_KR_E4_3D_infos[23] = {
          o2(0xEE,0xEC),      o2(0xD3,0xA3),
          o2(0xEE,0xB7),      o2(0xF8,0xCF),
          o2(0xEA,0xC8),      o2(0xEE,0xB8),
          o2(0xF1,0xAC),      o2(0xF1,0xA5),
          o2(0xE9,0xCE),      o2(0xF9,0xBC),
          o2(0xE5,0xF9),      o2(0xEC,0xEA),
          o2(0xDD,0xD6),      o2(0xED,0xC2),
          o2(0xF8,0xA5),      o2(0xE5,0xBA),
          o2(0xDB,0xD8),      o2(0xCA,0xA2),
          o2(0xD1,0xCD),      o2(0xEE,0xED),
          o2(0xEC,0xEB),      o2(0xDE,0xC5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E4_3D = {
    to_EUC_KR_E4_3D_offsets,
    to_EUC_KR_E4_3D_infos
};

static const unsigned char
to_EUC_KR_E4_3E_offsets[64] = {
     19,  0, 19,  1,  2, 19,  3, 19,      4, 19,  5,  6, 19,  7, 19,  8,
     19,  9, 19, 19, 19, 19, 10, 19,     11, 19, 19, 12, 19, 13, 19, 19,
     19, 19, 19, 19, 19, 19, 19, 19,     19, 19, 19, 19, 19, 19, 14, 15,
     19, 19, 19, 19, 19, 16, 17, 19,     19, 19, 19, 19, 19, 19, 19, 18,
};

static const struct byte_lookup* const
to_EUC_KR_E4_3E_infos[20] = {
          o2(0xE3,0xE0),      o2(0xCA,0xC9),
          o2(0xF2,0xE9),      o2(0xD5,0xCE),
          o2(0xF6,0xB6),      o2(0xCE,0xC2),
          o2(0xD6,0xC7),      o2(0xE3,0xB4),
          o2(0xF1,0xAD),      o2(0xEA,0xE2),
          o2(0xD7,0xC2),      o2(0xF3,0xA7),
          o2(0xCD,0xEA),      o2(0xEB,0xEE),
          o2(0xD9,0xB2),      o2(0xFD,0xA5),
          o2(0xF6,0xD5),      o2(0xD5,0xE2),
          o2(0xF8,0xB5),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E4_3E = {
    to_EUC_KR_E4_3E_offsets,
    to_EUC_KR_E4_3E_infos
};

static const unsigned char
to_EUC_KR_E4_3F_offsets[64] = {
     22, 22,  0,  1,  2, 22, 22, 22,     22,  3,  4, 22, 22, 22,  5, 22,
     22,  6, 22,  7,  8, 22, 22,  9,     22, 22, 10, 22, 22, 11, 22, 12,
     13, 14, 22, 22, 22, 22, 22, 22,     22, 22, 22, 22, 22, 22, 15, 16,
     22, 17, 22, 18, 22, 19, 22, 22,     20, 22, 21, 22, 22, 22, 22, 22,
};

static const struct byte_lookup* const
to_EUC_KR_E4_3F_infos[23] = {
          o2(0xCC,0xF5),      o2(0xF5,0xB5),
          o2(0xE4,0xAD),      o2(0xE7,0xEB),
          o2(0xF1,0xD5),      o2(0xF0,0xBB),
          o2(0xE9,0xB5),      o2(0xCC,0xC9),
          o2(0xFA,0xD5),      o2(0xE1,0xD4),
          o2(0xD7,0xD6),      o2(0xDC,0xC1),
          o2(0xDE,0xC6),      o2(0xFA,0xEF),
          o2(0xE3,0xE1),      o2(0xE1,0xF3),
          o2(0xDC,0xF6),      o2(0xCE,0xFC),
          o2(0xDB,0xC4),      o2(0xF8,0xF1),
          o2(0xDC,0xE4),      o2(0xE5,0xEF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E4_3F = {
    to_EUC_KR_E4_3F_offsets,
    to_EUC_KR_E4_3F_infos
};

static const unsigned char
to_EUC_KR_E4_offsets[64] = {
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      0,  1,  2,  3,  4,  5,  6,  7,
};

static const struct byte_lookup* const
to_EUC_KR_E4_infos[9] = {
       &to_EUC_KR_E4_38,   &to_EUC_KR_E4_39,
       &to_EUC_KR_E4_3A,   &to_EUC_KR_E4_3B,
       &to_EUC_KR_E4_3C,   &to_EUC_KR_E4_3D,
       &to_EUC_KR_E4_3E,   &to_EUC_KR_E4_3F,
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E4 = {
    to_EUC_KR_E4_offsets,
    to_EUC_KR_E4_infos
};

static const unsigned char
to_EUC_KR_E5_00_offsets[64] = {
     24, 24,  0, 24, 24, 24,  1, 24,     24,  2, 24,  3, 24,  4, 24, 24,
     24,  5,  6, 24, 24, 24,  7, 24,     24,  8,  9, 24, 10, 24, 11, 12,
     24, 13, 24, 14, 15, 24, 16, 17,     18, 24, 19, 20, 21, 22, 24, 24,
     24, 24, 24, 24, 24, 24, 24, 24,     24, 24, 24, 23, 24, 24, 24, 24,
};

static const struct byte_lookup* const
to_EUC_KR_E5_00_infos[25] = {
          o2(0xDC,0xB1),      o2(0xD5,0xD6),
          o2(0xF3,0xDA),      o2(0xCB,0xC1),
          o2(0xDB,0xC3),      o2(0xD9,0xFA),
          o2(0xD3,0xEE),      o2(0xFA,0xB8),
          o2(0xFD,0xA6),      o2(0xEB,0xEF),
          o2(0xF4,0xA6),      o2(0xCC,0xCA),
          o2(0xF3,0xA8),      o2(0xF3,0xDB),
          o2(0xDB,0xA7),      o2(0xF6,0xB7),
          o2(0xCF,0xE6),      o2(0xF0,0xF2),
          o2(0xCB,0xDA),      o2(0xE7,0xD2),
          o2(0xD7,0xC3),      o2(0xF6,0xF0),
          o2(0xE8,0xDE),      o2(0xE5,0xA6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_00 = {
    to_EUC_KR_E5_00_offsets,
    to_EUC_KR_E5_00_infos
};

static const unsigned char
to_EUC_KR_E5_01_offsets[64] = {
     13, 13, 13,  0, 13, 13, 13,  1,      2,  3, 13, 13, 13, 13, 13,  4,
     13, 13, 13, 13, 13,  5, 13, 13,     13, 13,  6, 13,  7, 13, 13, 13,
     13, 13, 13, 13, 13,  8, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13,  9, 10, 11, 13,     12, 13, 13, 13, 13, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E5_01_infos[14] = {
          o2(0xE5,0xE7),      o2(0xCA,0xA3),
          o2(0xCC,0xA7),      o2(0xEA,0xC9),
          o2(0xF8,0xB6),      o2(0xFA,0xA5),
          o2(0xF1,0xAE),      o2(0xEF,0xCE),
          o2(0xCB,0xED),      o2(0xF6,0xB0),
          o2(0xEF,0xCF),      o2(0xE9,0xCF),
          o2(0xF7,0xDE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_01 = {
    to_EUC_KR_E5_01_offsets,
    to_EUC_KR_E5_01_infos
};

static const unsigned char
to_EUC_KR_E5_02_offsets[64] = {
      0, 13, 13, 13, 13,  1, 13, 13,     13, 13, 13, 13, 13,  2, 13, 13,
     13,  3, 13, 13, 13, 13, 13, 13,      4,  5, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,     13, 13, 13, 13,  6,  7, 13, 13,
     13, 13,  8,  9, 13, 10, 13, 11,     13, 13, 13, 13, 13, 13, 12, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E5_02_infos[14] = {
          o2(0xCE,0xD3),      o2(0xDC,0xF7),
          o2(0xDB,0xA8),      o2(0xCB,0xF8),
          o2(0xDF,0xA1),      o2(0xDD,0xE1),
          o2(0xF5,0xCA),      o2(0xE9,0xB6),
          o2(0xE7,0xEC),      o2(0xEE,0xEE),
          o2(0xF3,0xF0),      o2(0xDF,0xBF),
          o2(0xCC,0xCB),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_02 = {
    to_EUC_KR_E5_02_offsets,
    to_EUC_KR_E5_02_infos
};

static const unsigned char
to_EUC_KR_E5_03_offsets[64] = {
     15, 15, 15, 15, 15,  0, 15, 15,     15,  1,  2, 15, 15, 15, 15,  3,
     15,  4, 15, 15, 15,  5,  6, 15,     15, 15,  7, 15, 15, 15,  8, 15,
     15, 15, 15, 15, 15,  9, 15, 10,     15, 15, 15, 15, 15, 11, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 12, 15, 13, 15, 15, 15, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E5_03_infos[16] = {
          o2(0xD0,0xC1),      o2(0xF4,0xD2),
          o2(0xE0,0xBA),      o2(0xDF,0xC0),
          o2(0xCE,0xE0),      o2(0xDC,0xD2),
          o2(0xFD,0xEA),      o2(0xD6,0xF6),
          o2(0xEA,0xCA),      o2(0xE8,0xE9),
          o2(0xE3,0xAC),      o2(0xF3,0xD0),
          o2(0xCA,0xA4),      o2(0xDB,0xF8),
          o2(0xDE,0xC7),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_03 = {
    to_EUC_KR_E5_03_offsets,
    to_EUC_KR_E5_03_infos
};

static const unsigned char
to_EUC_KR_E5_04_offsets[64] = {
      0,  1, 13, 13,  2, 13,  3, 13,     13,  4, 13, 13, 13, 13, 13, 13,
     13, 13,  5, 13, 13, 13, 13, 13,     13, 13, 13, 13, 13, 13, 13,  6,
     13,  7, 13, 13, 13, 13, 13, 13,     13, 13,  8, 13, 13, 13, 13, 13,
     13, 13,  9, 13, 13, 13, 13, 10,     13, 13, 11, 13, 12, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E5_04_infos[14] = {
          o2(0xEB,0xF0),      o2(0xF1,0xD6),
          o2(0xE5,0xE2),      o2(0xCC,0xCC),
          o2(0xCB,0xFB),      o2(0xEA,0xE3),
          o2(0xDF,0xC1),      o2(0xD6,0xED),
          o2(0xE9,0xD0),      o2(0xEE,0xB9),
          o2(0xD5,0xE3),      o2(0xD1,0xD3),
          o2(0xE5,0xF0),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_04 = {
    to_EUC_KR_E5_04_offsets,
    to_EUC_KR_E5_04_infos
};

static const unsigned char
to_EUC_KR_E5_05_offsets[64] = {
      0,  1, 31,  2,  3,  4,  5,  6,      7,  8, 31,  9, 10, 11, 12, 31,
     31, 31, 13, 31, 31, 31, 31, 31,     31, 31, 31, 31, 14, 31, 31, 31,
     31, 31, 15, 31, 31, 16, 31, 17,     18, 19, 20, 21, 22, 23, 24, 31,
     31, 25, 31, 31, 31, 26, 27, 28,     29, 31, 31, 31, 30, 31, 31, 31,
};

static const struct byte_lookup* const
to_EUC_KR_E5_05_infos[32] = {
          o2(0xE8,0xB4),      o2(0xEB,0xC3),
          o2(0xEA,0xAA),      o2(0xFA,0xFC),
          o2(0xF5,0xF6),      o2(0xF0,0xBC),
          o2(0xFD,0xD4),      o2(0xE0,0xBB),
          o2(0xCE,0xC3),      o2(0xD0,0xBA),
          o2(0xF7,0xBA),      o2(0xD8,0xF3),
          o2(0xF7,0xCD),      o2(0xE4,0xAE),
          o2(0xD4,0xDF),      o2(0xD0,0xE7),
          o2(0xEC,0xFD),      o2(0xD2,0xAE),
          o2(0xEE,0xEF),      o2(0xD5,0xD7),
          o2(0xEA,0xE4),      o2(0xF8,0xA2),
          o2(0xCD,0xEB),      o2(0xD7,0xBF),
          o2(0xFB,0xB1),      o2(0xCD,0xEC),
          o2(0xDC,0xB2),      o2(0xD0,0xEC),
          o2(0xCE,0xFD),      o2(0xEE,0xF0),
          o2(0xCC,0xC2),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_05 = {
    to_EUC_KR_E5_05_offsets,
    to_EUC_KR_E5_05_infos
};

static const unsigned char
to_EUC_KR_E5_06_offsets[64] = {
      0, 14, 14, 14, 14, 14,  1, 14,     14, 14,  2, 14, 14,  3, 14, 14,
     14, 14,  4, 14, 14,  5, 14,  6,     14, 14, 14, 14, 14, 14, 14, 14,
      7, 14, 14, 14, 14,  8, 14, 14,     14, 14,  9, 14, 10, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 11, 12,     14, 14, 14, 14, 14, 13, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E5_06_infos[15] = {
          o2(0xD0,0xED),      o2(0xE5,0xF7),
          o2(0xF3,0xFC),      o2(0xEE,0xA2),
          o2(0xD9,0xB3),      o2(0xD8,0xF4),
          o2(0xE9,0xB7),      o2(0xCE,0xAE),
          o2(0xD9,0xA2),      o2(0xD8,0xF1),
          o2(0xD4,0xCF),      o2(0xE5,0xA7),
          o2(0xD5,0xD2),      o2(0xD6,0xA9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_06 = {
    to_EUC_KR_E5_06_offsets,
    to_EUC_KR_E5_06_infos
};

static const unsigned char
to_EUC_KR_E5_07_offsets[64] = {
     17, 17, 17, 17,  0, 17,  1, 17,     17,  2, 17,  3,  4,  5, 17, 17,
     17, 17, 17, 17, 17, 17, 17, 17,     17, 17, 17, 17,  6,  7,  8, 17,
     17,  9, 17, 17, 17, 17, 17, 17,     17, 17, 17, 17, 17, 17, 17, 17,
     10, 11, 17, 17, 17, 17, 12, 17,     13, 14, 15, 17, 17, 16, 17, 17,
};

static const struct byte_lookup* const
to_EUC_KR_E5_07_infos[18] = {
          o2(0xF4,0xA2),      o2(0xF1,0xD7),
          o2(0xD5,0xD8),      o2(0xF0,0xBD),
          o2(0xD7,0xD0),      o2(0xD4,0xD0),
          o2(0xD7,0xCF),      o2(0xEB,0xEA),
          o2(0xFD,0xEB),      o2(0xDB,0xED),
          o2(0xFC,0xC5),      o2(0xCB,0xC2),
          o2(0xFD,0xD5),      o2(0xF4,0xC8),
          o2(0xE8,0xEA),      o2(0xF5,0xF3),
          o2(0xF9,0xDE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_07 = {
    to_EUC_KR_E5_07_offsets,
    to_EUC_KR_E5_07_infos
};

static const unsigned char
to_EUC_KR_E5_08_offsets[64] = {
      0, 22, 22,  1, 22, 22,  2,  3,      4, 22,  5, 22, 22, 22,  6, 22,
     22,  7, 22, 22, 22, 22, 22,  8,     22, 22, 22, 22, 22,  9, 22, 22,
     22, 22, 22, 22, 10, 11, 22, 22,     22, 12, 13, 22, 22, 22, 14, 22,
     15, 22, 22, 22, 22, 22, 16, 17,     18, 19, 20, 21, 22, 22, 22, 22,
};

static const struct byte_lookup* const
to_EUC_KR_E5_08_infos[23] = {
          o2(0xD3,0xEF),      o2(0xEC,0xD3),
          o2(0xDD,0xC2),      o2(0xEF,0xB7),
          o2(0xE7,0xD4),      o2(0xCA,0xCA),
          o2(0xD9,0xFB),      o2(0xFA,0xFD),
          o2(0xD6,0xAA),      o2(0xF4,0xF8),
          o2(0xF7,0xF7),      o2(0xDC,0xAC),
          o2(0xD7,0xD7),      o2(0xDF,0xA2),
          o2(0xCE,0xBE),      o2(0xD3,0xF0),
          o2(0xF0,0xA4),      o2(0xE1,0xEC),
          o2(0xCF,0xE7),      o2(0xF3,0xCB),
          o2(0xED,0xA9),      o2(0xCA,0xBE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_08 = {
    to_EUC_KR_E5_08_offsets,
    to_EUC_KR_E5_08_infos
};

static const unsigned char
to_EUC_KR_E5_09_offsets[64] = {
     18, 18, 18,  0, 18, 18, 18,  1,     18, 18,  2,  3,  4,  5, 18, 18,
     18, 18, 18, 18,  6, 18,  7, 18,     18, 18, 18,  8, 18,  9, 18, 18,
     18, 10, 18, 18, 18, 18, 18, 18,     18, 11, 12, 18, 18, 18, 18, 13,
     18, 18, 14, 18, 18, 15, 18, 18,     18, 18, 18, 18, 18, 16, 18, 17,
};

static const struct byte_lookup* const
to_EUC_KR_E5_09_infos[19] = {
          o2(0xF4,0xEF),      o2(0xF6,0xCE),
          o2(0xDE,0xFB),      o2(0xD0,0xBB),
          o2(0xD5,0xB7),      o2(0xEE,0xF1),
          o2(0xF4,0xA8),      o2(0xDC,0xF8),
          o2(0xCB,0xA7),      o2(0xDA,0xCE),
          o2(0xE0,0xE6),      o2(0xED,0xA5),
          o2(0xEE,0xF2),      o2(0xDC,0xF9),
          o2(0xF9,0xDC),      o2(0xF3,0xDC),
          o2(0xF8,0xF2),      o2(0xF4,0xF9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_09 = {
    to_EUC_KR_E5_09_offsets,
    to_EUC_KR_E5_09_infos
};

static const unsigned char
to_EUC_KR_E5_0A_offsets[64] = {
     16, 16, 16,  0, 16, 16, 16,  1,      2,  3, 16, 16, 16,  4, 16, 16,
     16,  5,  6, 16, 16, 16, 16, 16,     16, 16, 16,  7, 16, 16, 16,  8,
      9, 16, 16, 10, 11, 16, 16, 16,     16, 12, 13, 14, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,     16, 16, 16, 16, 16, 16, 15, 16,
};

static const struct byte_lookup* const
to_EUC_KR_E5_0A_infos[17] = {
          o2(0xFC,0xF1),      o2(0xD0,0xBC),
          o2(0xDB,0xF9),      o2(0xD7,0xB1),
          o2(0xCB,0xFC),      o2(0xF0,0xA5),
          o2(0xCB,0xFD),      o2(0xD5,0xF4),
          o2(0xCD,0xED),      o2(0xCA,0xA5),
          o2(0xD6,0xAB),      o2(0xD0,0xC2),
          o2(0xF0,0xBE),      o2(0xD2,0xBD),
          o2(0xCC,0xA4),      o2(0xFA,0xB6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_0A = {
    to_EUC_KR_E5_0A_offsets,
    to_EUC_KR_E5_0A_infos
};

static const unsigned char
to_EUC_KR_E5_0B_offsets[64] = {
     25,  0, 25,  1, 25,  2, 25,  3,     25,  4, 25, 25, 25,  5, 25, 25,
     25, 25,  6, 25, 25,  7,  8, 25,      9, 10, 25, 11, 25, 12, 13, 14,
     25, 25, 15, 16, 17, 25, 25, 25,     25, 25, 25, 25, 25, 25, 25, 25,
     25, 25, 25, 18, 25, 19, 25, 25,     20, 25, 21, 22, 25, 25, 23, 24,
};

static const struct byte_lookup* const
to_EUC_KR_E5_0B_infos[26] = {
          o2(0xCC,0xCD),      o2(0xDA,0xFA),
          o2(0xF6,0xCF),      o2(0xE9,0xB8),
          o2(0xD8,0xF5),      o2(0xCC,0xCE),
          o2(0xD7,0xCD),      o2(0xD4,0xD1),
          o2(0xE9,0xED),      o2(0xCA,0xEB),
          o2(0xD9,0xE2),      o2(0xFD,0xB2),
          o2(0xE3,0xAD),      o2(0xD6,0xCC),
          o2(0xD9,0xB4),      o2(0xE1,0xA7),
          o2(0xEE,0xD3),      o2(0xD0,0xC3),
          o2(0xFD,0xB3),      o2(0xD5,0xE4),
          o2(0xCF,0xE8),      o2(0xED,0xC3),
          o2(0xD0,0xB2),      o2(0xCE,0xFE),
          o2(0xDA,0xA8),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_0B = {
    to_EUC_KR_E5_0B_offsets,
    to_EUC_KR_E5_0B_infos
};

static const unsigned char
to_EUC_KR_E5_0C_offsets[64] = {
     16, 16, 16, 16, 16,  0, 16, 16,      1, 16, 16, 16, 16,  2, 16,  3,
      4, 16, 16, 16, 16,  5,  6,  7,     16,  8, 16, 16, 16, 16, 16, 16,
      9, 10, 16, 11, 16, 16, 16, 16,     16, 16, 12, 16, 16, 16, 16, 13,
     16, 16, 16, 16, 16, 16, 16, 16,     16, 14, 16, 16, 16, 16, 16, 15,
};

static const struct byte_lookup* const
to_EUC_KR_E5_0C_infos[17] = {
          o2(0xF8,0xD0),      o2(0xFD,0xD6),
          o2(0xF8,0xD1),      o2(0xF8,0xD2),
          o2(0xDC,0xD3),      o2(0xDD,0xE2),
          o2(0xFB,0xF9),      o2(0xDD,0xC1),
          o2(0xE3,0xB5),      o2(0xED,0xDD),
          o2(0xCE,0xC4),      o2(0xCB,0xA1),
          o2(0xDD,0xE3),      o2(0xFC,0xDD),
          o2(0xF9,0xAF),      o2(0xD2,0xFB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_0C = {
    to_EUC_KR_E5_0C_offsets,
    to_EUC_KR_E5_0C_infos
};

static const unsigned char
to_EUC_KR_E5_0D_offsets[64] = {
      0,  1, 28,  2,  3, 28, 28,  4,      5,  6,  7, 28, 28,  8, 28, 28,
     28,  9, 10, 11, 12, 28, 28, 13,     28, 28, 14, 28, 15, 28, 16, 28,
     17, 28, 28, 28, 28, 28, 18, 28,     19, 28, 28, 28, 28, 28, 28, 20,
     21, 22, 28, 28, 23, 24, 28, 25,     28, 28, 28, 28, 28, 26, 28, 27,
};

static const struct byte_lookup* const
to_EUC_KR_E5_0D_infos[29] = {
          o2(0xCF,0xA1),      o2(0xE4,0xA8),
          o2(0xF4,0xB6),      o2(0xEC,0xFE),
          o2(0xE3,0xAE),      o2(0xE7,0xED),
          o2(0xFD,0xC1),      o2(0xDA,0xE2),
          o2(0xD8,0xB3),      o2(0xDD,0xE4),
          o2(0xF0,0xEF),      o2(0xF6,0xF1),
          o2(0xFA,0xF0),      o2(0xD1,0xF5),
          o2(0xDA,0xCF),      o2(0xDC,0xD4),
          o2(0xDC,0xA6),      o2(0xEF,0xBF),
          o2(0xCE,0xCF),      o2(0xE0,0xD9),
          o2(0xD9,0xD6),      o2(0xEC,0xD4),
          o2(0xEA,0xCB),      o2(0xCA,0xBF),
          o2(0xD5,0xB0),      o2(0xCF,0xE9),
          o2(0xF1,0xED),      o2(0xCC,0xCF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_0D = {
    to_EUC_KR_E5_0D_offsets,
    to_EUC_KR_E5_0D_infos
};

static const unsigned char
to_EUC_KR_E5_0E_offsets[64] = {
     10, 10, 10, 10,  0, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10,  1, 10, 10, 10, 10,      2, 10,  3, 10, 10, 10, 10,  4,
      5, 10, 10, 10, 10,  6,  7, 10,     10, 10, 10, 10, 10,  8, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10,  9, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E5_0E_infos[11] = {
          o2(0xE4,0xF8),      o2(0xE4,0xED),
          o2(0xD7,0xD8),      o2(0xFD,0xA7),
          o2(0xEA,0xAB),      o2(0xF6,0xB2),
          o2(0xCF,0xF0),      o2(0xF9,0xBD),
          o2(0xE6,0xF4),      o2(0xCB,0xDB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_0E = {
    to_EUC_KR_E5_0E_offsets,
    to_EUC_KR_E5_0E_infos
};

static const unsigned char
to_EUC_KR_E5_0F_offsets[64] = {
     26, 26, 26,  0, 26, 26, 26, 26,      1,  2,  3,  4, 26,  5, 26, 26,
     26, 26, 26, 26,  6, 26,  7,  8,     26, 26, 26,  9, 26, 26, 26, 26,
     26, 10, 11, 12, 13, 14, 26, 26,     26, 15, 16, 17, 18, 19, 26, 20,
     21, 22, 23, 24, 26, 26, 26, 26,     25, 26, 26, 26, 26, 26, 26, 26,
};

static const struct byte_lookup* const
to_EUC_KR_E5_0F_infos[27] = {
          o2(0xF3,0xD1),      o2(0xE9,0xD1),
          o2(0xF3,0xA9),      o2(0xD0,0xE0),
          o2(0xE9,0xD2),      o2(0xDA,0xE3),
          o2(0xE2,0xD2),      o2(0xF6,0xA2),
          o2(0xE1,0xF4),      o2(0xDA,0xE4),
          o2(0xE7,0xD5),      o2(0xF5,0xBF),
          o2(0xCF,0xA2),      o2(0xCD,0xAF),
          o2(0xCF,0xA3),      o2(0xCD,0xB0),
          o2(0xF1,0xFE),      o2(0xD0,0xA3),
          o2(0xE1,0xAF),      o2(0xF8,0xA3),
          o2(0xCA,0xA6),      o2(0xF7,0xBB),
          o2(0xF2,0xEA),      o2(0xDE,0xC8),
          o2(0xE9,0xD3),      o2(0xDE,0xC9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_0F = {
    to_EUC_KR_E5_0F_offsets,
    to_EUC_KR_E5_0F_infos
};

static const unsigned char
to_EUC_KR_E5_10_offsets[64] = {
     24, 24, 24,  0,  1, 24, 24, 24,      2,  3,  4, 24,  5,  6,  7,  8,
      9, 10, 24, 24, 24, 24, 24, 24,     24, 24, 24, 11, 24, 12, 24, 13,
     14, 24, 24, 24, 24, 24, 15, 24,     24, 16, 24, 17, 24, 24, 24, 24,
     24, 24, 24, 18, 24, 24, 24, 24,     19, 20, 24, 21, 22, 24, 23, 24,
};

static const struct byte_lookup* const
to_EUC_KR_E5_10_infos[25] = {
          o2(0xFD,0xDE),      o2(0xCA,0xC0),
          o2(0xF9,0xEA),      o2(0xD1,0xCE),
          o2(0xEE,0xD4),      o2(0xD4,0xD2),
          o2(0xD9,0xA3),      o2(0xFD,0xA8),
          o2(0xD7,0xD9),      o2(0xF7,0xCE),
          o2(0xFA,0xBE),      o2(0xCF,0xD6),
          o2(0xD7,0xF0),      o2(0xEB,0xE1),
          o2(0xF8,0xC5),      o2(0xDC,0xFA),
          o2(0xDD,0xC3),      o2(0xF9,0xDF),
          o2(0xE7,0xEF),      o2(0xFD,0xE5),
          o2(0xF6,0xA3),      o2(0xD9,0xFC),
          o2(0xFD,0xA9),      o2(0xE7,0xEE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_10 = {
    to_EUC_KR_E5_10_offsets,
    to_EUC_KR_E5_10_infos
};

static const unsigned char
to_EUC_KR_E5_11_offsets[64] = {
     12, 12,  0, 12, 12, 12, 12, 12,      1, 12,  2, 12, 12, 12, 12, 12,
     12,  3, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,      4, 12,  5, 12, 12, 12, 12, 12,
     12,  6, 12,  7, 12,  8, 12, 12,     12, 12, 12,  9, 10, 11, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_E5_11_infos[13] = {
          o2(0xD5,0xE5),      o2(0xEF,0xD0),
          o2(0xCD,0xB1),      o2(0xF7,0xA2),
          o2(0xF1,0xB2),      o2(0xF1,0xB1),
          o2(0xCD,0xB2),      o2(0xDA,0xAB),
          o2(0xCA,0xA7),      o2(0xE3,0xE2),
          o2(0xFB,0xBC),      o2(0xD9,0xA4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_11 = {
    to_EUC_KR_E5_11_offsets,
    to_EUC_KR_E5_11_infos
};

static const unsigned char
to_EUC_KR_E5_12_offsets[64] = {
      0, 12, 12, 12, 12, 12,  1, 12,     12, 12, 12, 12,  2, 12,  3, 12,
      4, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12,  5, 12, 12, 12,      6, 12, 12,  7,  8, 12, 12, 12,
     12, 12, 12,  9, 12, 12, 12, 12,     10, 12, 12, 12, 12, 11, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_E5_12_infos[13] = {
          o2(0xEE,0xBA),      o2(0xF8,0xD3),
          o2(0xFB,0xFA),      o2(0xCF,0xA4),
          o2(0xDC,0xFB),      o2(0xF6,0xE3),
          o2(0xED,0xAA),      o2(0xF2,0xA1),
          o2(0xCE,0xE1),      o2(0xFA,0xA6),
          o2(0xF9,0xE0),      o2(0xEC,0xD6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_12 = {
    to_EUC_KR_E5_12_offsets,
    to_EUC_KR_E5_12_infos
};

static const unsigned char
to_EUC_KR_E5_13_offsets[64] = {
      0,  1, 12, 12,  2, 12, 12, 12,      3,  4, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
     12,  5, 12, 12, 12,  6, 12, 12,      7, 12, 12, 12, 12,  8,  9, 12,
     12, 12, 10, 12, 12, 12, 12, 12,     12, 12, 11, 12, 12, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_E5_13_infos[13] = {
          o2(0xE4,0xEE),      o2(0xF9,0xA1),
          o2(0xFB,0xEF),      o2(0xF9,0xEB),
          o2(0xEE,0xA3),      o2(0xEA,0xAC),
          o2(0xCA,0xA8),      o2(0xF4,0xFA),
          o2(0xCD,0xD6),      o2(0xFC,0xF6),
          o2(0xF4,0xC9),      o2(0xF8,0xD4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_13 = {
    to_EUC_KR_E5_13_offsets,
    to_EUC_KR_E5_13_infos
};

static const unsigned char
to_EUC_KR_E5_14_offsets[64] = {
     10, 10, 10, 10,  0, 10,  1,  2,     10, 10, 10, 10, 10, 10,  3, 10,
      4, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10,  5, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10,  6,
     10,  7, 10, 10, 10,  8, 10, 10,     10, 10, 10, 10, 10, 10,  9, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E5_14_infos[11] = {
          o2(0xF8,0xA6),      o2(0xDE,0xCA),
          o2(0xF2,0xC6),      o2(0xD7,0xDA),
          o2(0xD3,0xD0),      o2(0xD8,0xC5),
          o2(0xEA,0xE6),      o2(0xF3,0xDD),
          o2(0xE4,0xDA),      o2(0xF6,0xE4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_14 = {
    to_EUC_KR_E5_14_offsets,
    to_EUC_KR_E5_14_infos
};

static const unsigned char
to_EUC_KR_E5_15_offsets[64] = {
      8,  8,  8,  8,  0,  8,  1,  8,      8,  8,  8,  8,  8,  8,  8,  2,
      8,  8,  8,  3,  8,  8,  4,  8,      8,  8,  8,  8,  8,  8,  5,  8,
      8,  8,  8,  6,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  7,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E5_15_infos[9] = {
          o2(0xF6,0xF2),      o2(0xDF,0xC2),
          o2(0xD9,0xFD),      o2(0xCC,0xF6),
          o2(0xD3,0xBA),      o2(0xE4,0xAF),
          o2(0xF9,0xE1),      o2(0xF0,0xA6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_15 = {
    to_EUC_KR_E5_15_offsets,
    to_EUC_KR_E5_15_infos
};

static const unsigned char
to_EUC_KR_E5_16_offsets[64] = {
      0, 17, 17, 17,  1, 17,  2,  3,     17,  4,  5, 17, 17, 17, 17, 17,
     17, 17, 17, 17, 17, 17, 17, 17,      6,  7,  8, 17,  9, 10, 17, 17,
     17, 17, 17, 17, 17, 17, 17, 11,     17, 12, 13, 14, 15, 17, 16, 17,
     17, 17, 17, 17, 17, 17, 17, 17,     17, 17, 17, 17, 17, 17, 17, 17,
};

static const struct byte_lookup* const
to_EUC_KR_E5_16_infos[18] = {
          o2(0xCB,0xD3),      o2(0xE0,0xBC),
          o2(0xF4,0xCA),      o2(0xD4,0xFA),
          o2(0xFD,0xAA),      o2(0xF9,0xE2),
          o2(0xF4,0xB7),      o2(0xFD,0xC2),
          o2(0xFC,0xB0),      o2(0xFD,0xEC),
          o2(0xCA,0xE2),      o2(0xFD,0xBD),
          o2(0xEA,0xE7),      o2(0xDF,0xC3),
          o2(0xD1,0xD2),      o2(0xCE,0xE2),
          o2(0xD3,0xA4),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_16 = {
    to_EUC_KR_E5_16_offsets,
    to_EUC_KR_E5_16_infos
};

static const unsigned char
to_EUC_KR_E5_17_offsets[64] = {
     10, 10, 10, 10, 10,  0, 10,  1,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10,  2, 10, 10, 10,     10, 10,  3, 10,  4, 10, 10,  5,
     10, 10, 10,  6,  7, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10,  8,  9, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E5_17_infos[11] = {
          o2(0xFD,0xAB),      o2(0xDF,0xE0),
          o2(0xF2,0xC7),      o2(0xE7,0xF0),
          o2(0xD0,0xEE),      o2(0xF3,0xAA),
          o2(0xDE,0xCB),      o2(0xF6,0xB8),
          o2(0xE1,0xF5),      o2(0xF1,0xB3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_17 = {
    to_EUC_KR_E5_17_offsets,
    to_EUC_KR_E5_17_infos
};

static const unsigned char
to_EUC_KR_E5_18_offsets[64] = {
      8,  8,  8,  8,  8,  8,  0,  8,      8,  1,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  2,  8,  8,  3,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  4,
      8,  8,  5,  8,  6,  8,  7,  8,      8,  8,  8,  8,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E5_18_infos[9] = {
          o2(0xF7,0xA3),      o2(0xCA,0xA9),
          o2(0xCF,0xA5),      o2(0xDF,0xC4),
          o2(0xE1,0xB0),      o2(0xF0,0xBF),
          o2(0xF6,0xA4),      o2(0xE3,0xB6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_18 = {
    to_EUC_KR_E5_18_offsets,
    to_EUC_KR_E5_18_infos
};

static const unsigned char
to_EUC_KR_E5_19_offsets[64] = {
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  0,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      1,  4,  4,  2,  4,  4,  4,  4,
      4,  4,  4,  4,  3,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
};

static const struct byte_lookup* const
to_EUC_KR_E5_19_infos[5] = {
          o2(0xFA,0xC6),      o2(0xD0,0xEF),
          o2(0xFD,0xED),      o2(0xDD,0xC4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_19 = {
    to_EUC_KR_E5_19_offsets,
    to_EUC_KR_E5_19_infos
};

static const unsigned char
to_EUC_KR_E5_1A_offsets[64] = {
      6,  6,  6,  6,  6,  6,  0,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  1,  6,  6,      6,  6,  6,  6,  2,  6,  3,  6,
      6,  6,  6,  6,  4,  6,  6,  6,      6,  6,  6,  6,  5,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_E5_1A_infos[7] = {
          o2(0xFC,0xF7),      o2(0xE6,0xBF),
          o2(0xDE,0xAD),      o2(0xFA,0xBF),
          o2(0xE5,0xF1),      o2(0xED,0xC4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_1A = {
    to_EUC_KR_E5_1A_offsets,
    to_EUC_KR_E5_1A_infos
};

static const unsigned char
to_EUC_KR_E5_1B_offsets[64] = {
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10,  0, 10, 10,  1, 10, 10,
     10,  2, 10, 10, 10, 10, 10, 10,     10, 10,  3,  4, 10, 10,  5, 10,
      6, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
      7, 10, 10, 10, 10, 10, 10, 10,     10,  8,  9, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E5_1B_infos[11] = {
          o2(0xD2,0xA5),      o2(0xFD,0xEE),
          o2(0xF5,0xB6),      o2(0xE1,0xF6),
          o2(0xDE,0xCC),      o2(0xFC,0xDE),
          o2(0xEC,0xD7),      o2(0xCD,0xDD),
          o2(0xD6,0xB7),      o2(0xCD,0xB3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_1B = {
    to_EUC_KR_E5_1B_offsets,
    to_EUC_KR_E5_1B_infos
};

static const unsigned char
to_EUC_KR_E5_1C_offsets[64] = {
     14, 14, 14,  0,  1, 14, 14, 14,      2, 14, 14,  3, 14,  4, 14, 14,
     14, 14,  5,  6, 14, 14,  7, 14,      8, 14, 14, 14, 14, 14, 14,  9,
     14, 14, 14, 14, 14, 14, 14, 14,     10, 14, 14, 14, 14, 11, 14, 14,
     12, 14, 14, 14, 14, 14, 14, 14,     14, 14, 14, 13, 14, 14, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E5_1C_infos[15] = {
          o2(0xF8,0xD5),      o2(0xE5,0xD8),
          o2(0xCF,0xEA),      o2(0xCF,0xD0),
          o2(0xEA,0xCC),      o2(0xEA,0xAE),
          o2(0xEA,0xAD),      o2(0xD3,0xF1),
          o2(0xD3,0xA5),      o2(0xF7,0xCF),
          o2(0xEE,0xA4),      o2(0xD0,0xA4),
          o2(0xF2,0xA2),      o2(0xD0,0xF0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_1C = {
    to_EUC_KR_E5_1C_offsets,
    to_EUC_KR_E5_1C_infos
};

static const unsigned char
to_EUC_KR_E5_1D_offsets[64] = {
      0, 16,  1, 16, 16, 16, 16,  2,     16, 16,  3, 16, 16,  4,  5, 16,
      6,  7, 16, 16, 16, 16, 16, 16,     16, 16, 16, 16, 16, 16, 16, 16,
     16,  8, 16, 16,  9, 16, 10, 16,     16, 16, 11, 16, 16, 16, 12, 16,
     13, 16, 16, 16, 16, 14, 16, 16,     16, 16, 16, 16, 15, 16, 16, 16,
};

static const struct byte_lookup* const
to_EUC_KR_E5_1D_infos[17] = {
          o2(0xF2,0xA3),      o2(0xF7,0xF8),
          o2(0xD0,0xB3),      o2(0xDB,0xA9),
          o2(0xD3,0xBB),      o2(0xCA,0xEC),
          o2(0xF1,0xA6),      o2(0xCB,0xD5),
          o2(0xF7,0xE7),      o2(0xCD,0xDE),
          o2(0xF7,0xA4),      o2(0xF8,0xC0),
          o2(0xD3,0xDD),      o2(0xCC,0xD0),
          o2(0xCF,0xA6),      o2(0xF6,0xF3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_1D = {
    to_EUC_KR_E5_1D_offsets,
    to_EUC_KR_E5_1D_infos
};

static const unsigned char
to_EUC_KR_E5_1E_offsets[64] = {
      7,  7,  0,  7,  7,  7,  7,  7,      1,  7,  7,  2,  7,  7,  7,  7,
      7,  7,  7,  3,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      4,  7,  5,  6,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_E5_1E_infos[8] = {
          o2(0xE1,0xF7),      o2(0xD3,0xDC),
          o2(0xFA,0xFE),      o2(0xFA,0xA7),
          o2(0xEB,0xD9),      o2(0xCF,0xA7),
          o2(0xEA,0xAF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_1E = {
    to_EUC_KR_E5_1E_offsets,
    to_EUC_KR_E5_1E_infos
};

static const unsigned char
to_EUC_KR_E5_1F_offsets[64] = {
     13, 13, 13,  0, 13, 13, 13,  1,      2, 13, 13,  3, 13, 13,  4, 13,
     13, 13, 13, 13, 13, 13, 13, 13,     13, 13, 13, 13, 13, 13, 13,  5,
      6, 13, 13, 13, 13, 13, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
      7, 13, 13, 13,  8, 13, 13,  9,     13, 10, 11, 13, 12, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E5_1F_infos[14] = {
          o2(0xE4,0xEF),      o2(0xE9,0xB9),
          o2(0xF1,0xD8),      o2(0xD8,0xD8),
          o2(0xE0,0xF2),      o2(0xE6,0xB4),
          o2(0xDC,0xFC),      o2(0xF3,0xF1),
          o2(0xE3,0xD0),      o2(0xF2,0xFB),
          o2(0xDB,0xC6),      o2(0xD0,0xF1),
          o2(0xD0,0xF2),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_1F = {
    to_EUC_KR_E5_1F_offsets,
    to_EUC_KR_E5_1F_infos
};

static const unsigned char
to_EUC_KR_E5_20_offsets[64] = {
      0, 18,  1, 18, 18,  2,  3, 18,      4,  5,  6, 18, 18, 18, 18, 18,
     18, 18, 18, 18, 18, 18, 18, 18,     18, 18, 18, 18, 18, 18,  7, 18,
     18,  8, 18, 18,  9, 18, 18, 10,     18, 18, 11, 18, 18, 18, 18, 12,
     13, 14, 18, 18, 15, 16, 18, 18,     18, 18, 17, 18, 18, 18, 18, 18,
};

static const struct byte_lookup* const
to_EUC_KR_E5_20_infos[19] = {
          o2(0xCF,0xDC),      o2(0xD3,0xD1),
          o2(0xCC,0xB1),      o2(0xF7,0xD8),
          o2(0xCB,0xA8),      o2(0xEB,0xBC),
          o2(0xE4,0xBE),      o2(0xF4,0xDC),
          o2(0xDC,0xC2),      o2(0xF0,0xA7),
          o2(0xE6,0xC0),      o2(0xCA,0xED),
          o2(0xE8,0xEB),      o2(0xE5,0xE8),
          o2(0xDC,0xC3),      o2(0xED,0xDE),
          o2(0xD3,0xF2),      o2(0xCC,0xF7),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_20 = {
    to_EUC_KR_E5_20_offsets,
    to_EUC_KR_E5_20_infos
};

static const unsigned char
to_EUC_KR_E5_21_offsets[64] = {
     16, 16, 16, 16, 16, 16, 16, 16,     16, 16,  0,  1, 16, 16, 16,  2,
     16,  3, 16, 16,  4, 16, 16,  5,      6, 16,  7, 16, 16, 16,  8, 16,
     16,  9, 10, 16, 11, 16, 16, 16,     16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 12, 16, 16,     16, 13, 16, 16, 14, 16, 15, 16,
};

static const struct byte_lookup* const
to_EUC_KR_E5_21_infos[17] = {
          o2(0xCE,0xD4),      o2(0xE7,0xAB),
          o2(0xCB,0xC3),      o2(0xE1,0xB1),
          o2(0xF7,0xB2),      o2(0xD3,0xF3),
          o2(0xD3,0xD2),      o2(0xF5,0xC0),
          o2(0xDF,0xDD),      o2(0xEE,0xF3),
          o2(0xE7,0xF1),      o2(0xFD,0xB4),
          o2(0xF2,0xC8),      o2(0xF3,0xD2),
          o2(0xEE,0xF4),      o2(0xE2,0xD3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_21 = {
    to_EUC_KR_E5_21_offsets,
    to_EUC_KR_E5_21_infos
};

static const unsigned char
to_EUC_KR_E5_22_offsets[64] = {
     14, 14, 14,  0, 14,  1, 14, 14,     14,  2, 14, 14, 14, 14, 14, 14,
     14, 14, 14,  3, 14, 14, 14, 14,     14, 14, 14, 14,  4, 14,  5,  6,
     14, 14, 14, 14, 14, 14, 14, 14,      7,  8, 14, 14, 14, 14,  9, 14,
     14, 14, 14, 10, 14, 14, 14, 14,     14, 14, 11, 12, 14, 14, 13, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E5_22_infos[15] = {
          o2(0xCC,0xD1),      o2(0xDF,0xEA),
          o2(0xE9,0xBA),      o2(0xD9,0xD7),
          o2(0xF5,0xCD),      o2(0xF1,0xF2),
          o2(0xFA,0xC7),      o2(0xD9,0xF8),
          o2(0xD4,0xC2),      o2(0xF6,0xE5),
          o2(0xDD,0xC5),      o2(0xE7,0xF2),
          o2(0xED,0xDF),      o2(0xCA,0xCB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_22 = {
    to_EUC_KR_E5_22_offsets,
    to_EUC_KR_E5_22_infos
};

static const unsigned char
to_EUC_KR_E5_23_offsets[64] = {
     19,  0, 19, 19, 19,  1, 19,  2,     19, 19, 19, 19, 19, 19,  3, 19,
     19,  4, 19,  5, 19,  6, 19, 19,      7,  8, 19, 19, 19, 19,  9, 10,
     19, 19, 19, 19, 11, 19, 19, 19,     19, 19, 19, 12, 13, 19, 19, 14,
     19, 19, 19, 19, 19, 19, 19, 19,     19, 15, 16, 17, 19, 18, 19, 19,
};

static const struct byte_lookup* const
to_EUC_KR_E5_23_infos[20] = {
          o2(0xDB,0xFA),      o2(0xE8,0xB5),
          o2(0xD3,0xA6),      o2(0xFD,0xB5),
          o2(0xF9,0xC9),      o2(0xE4,0xE2),
          o2(0xFB,0xBD),      o2(0xD7,0xA4),
          o2(0xCE,0xC5),      o2(0xCE,0xD5),
          o2(0xD6,0xE6),      o2(0xE5,0xBD),
          o2(0xDE,0xCD),      o2(0xEC,0xF3),
          o2(0xED,0xE0),      o2(0xEC,0xEC),
          o2(0xFB,0xBE),      o2(0xDF,0xEB),
          o2(0xE1,0xF8),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_23 = {
    to_EUC_KR_E5_23_offsets,
    to_EUC_KR_E5_23_infos
};

static const unsigned char
to_EUC_KR_E5_24_offsets[64] = {
     17, 17, 17, 17, 17, 17, 17, 17,     17, 17, 17, 17, 17, 17, 17,  0,
     17, 17, 17, 17,  1,  2,  3, 17,     17,  4,  5, 17,  6, 17, 17, 17,
     17, 17,  7, 17, 17, 17, 17,  8,     17,  9, 10, 11, 17, 12, 13, 17,
     17, 14, 17, 17, 17, 17, 17, 15,     17, 17, 17, 17, 17, 17, 16, 17,
};

static const struct byte_lookup* const
to_EUC_KR_E5_24_infos[18] = {
          o2(0xF9,0xBE),      o2(0xD0,0xF3),
          o2(0xE0,0xAA),      o2(0xE8,0xE2),
          o2(0xE2,0xD4),      o2(0xD2,0xFD),
          o2(0xE5,0xA8),      o2(0xD9,0xD3),
          o2(0xD3,0xDE),      o2(0xF4,0xB8),
          o2(0xF7,0xBC),      o2(0xDC,0xFD),
          o2(0xE8,0xEC),      o2(0xE4,0xE7),
          o2(0xE3,0xF7),      o2(0xEC,0xA8),
          o2(0xFA,0xF1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_24 = {
    to_EUC_KR_E5_24_offsets,
    to_EUC_KR_E5_24_infos
};

static const unsigned char
to_EUC_KR_E5_25_offsets[64] = {
     24, 24, 24, 24,  0, 24, 24,  1,      2,  3, 24, 24, 24, 24,  4,  5,
      6,  7, 24, 24,  8,  9, 24, 10,     24, 24, 11, 24, 24, 24, 24, 24,
     12, 24, 13, 24, 24, 24, 24, 14,     24, 24, 15, 16, 17, 18, 19, 24,
     24, 24, 24, 20, 21, 24, 24, 24,     22, 24, 24, 24, 24, 23, 24, 24,
};

static const struct byte_lookup* const
to_EUC_KR_E5_25_infos[25] = {
          o2(0xE5,0xF2),      o2(0xD0,0xF4),
          o2(0xD2,0xAF),      o2(0xDC,0xE5),
          o2(0xD0,0xA5),      o2(0xF1,0xB4),
          o2(0xFC,0xB1),      o2(0xCC,0xF8),
          o2(0xDD,0xC6),      o2(0xFA,0xD1),
          o2(0xF7,0xDF),      o2(0xFA,0xA8),
          o2(0xEE,0xF5),      o2(0xDE,0xCE),
          o2(0xE7,0xF3),      o2(0xF7,0xAC),
          o2(0xEB,0xC4),      o2(0xED,0xE1),
          o2(0xE0,0xAB),      o2(0xDD,0xC7),
          o2(0xD2,0xB3),      o2(0xD2,0xBF),
          o2(0xCA,0xCC),      o2(0xFB,0xBF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_25 = {
    to_EUC_KR_E5_25_offsets,
    to_EUC_KR_E5_25_infos
};

static const unsigned char
to_EUC_KR_E5_26_offsets[64] = {
     14, 14,  0,  1,  2, 14, 14, 14,     14, 14,  3, 14, 14, 14, 14, 14,
     14, 14, 14,  4, 14, 14,  5,  6,     14,  7, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14, 14,  8, 14, 14,      9, 14, 14, 14, 10, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,     14, 11, 14, 12, 14, 14, 13, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E5_26_infos[15] = {
          o2(0xE5,0xFD),      o2(0xDD,0xE5),
          o2(0xD8,0xCD),      o2(0xEC,0xF4),
          o2(0xD0,0xF5),      o2(0xE8,0xED),
          o2(0xD0,0xD2),      o2(0xD9,0xD8),
          o2(0xF6,0xE6),      o2(0xDB,0xAA),
          o2(0xF7,0xE0),      o2(0xD8,0xD9),
          o2(0xF4,0xA3),      o2(0xF4,0xDD),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_26 = {
    to_EUC_KR_E5_26_offsets,
    to_EUC_KR_E5_26_infos
};

static const unsigned char
to_EUC_KR_E5_27_offsets[64] = {
     20, 20, 20,  0, 20, 20,  1, 20,     20,  2, 20,  3, 20, 20, 20, 20,
      4,  5, 20,  6,  7, 20, 20, 20,     20,  8,  9, 20, 10, 11, 20, 20,
     20, 20, 20, 20, 20, 20, 12, 20,     13, 20, 14, 20, 15, 20, 16, 20,
     20, 20, 20, 20, 20, 20, 20, 20,     17, 20, 20, 18, 20, 20, 20, 19,
};

static const struct byte_lookup* const
to_EUC_KR_E5_27_infos[21] = {
          o2(0xEF,0xD1),      o2(0xD9,0xB5),
          o2(0xED,0xAB),      o2(0xE3,0xB7),
          o2(0xEE,0xBB),      o2(0xCD,0xB4),
          o2(0xE0,0xF3),      o2(0xEA,0xCD),
          o2(0xEC,0xF5),      o2(0xE8,0xEE),
          o2(0xCB,0xA9),      o2(0xF1,0xAF),
          o2(0xCA,0xCD),      o2(0xEC,0xA9),
          o2(0xF2,0xEB),      o2(0xFD,0xEF),
          o2(0xF9,0xF3),      o2(0xE6,0xC1),
          o2(0xEC,0xD8),      o2(0xED,0xAC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_27 = {
    to_EUC_KR_E5_27_offsets,
    to_EUC_KR_E5_27_infos
};

static const unsigned char
to_EUC_KR_E5_28_offsets[64] = {
     12,  0, 12,  1, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
     12,  2, 12, 12, 12, 12, 12, 12,      3, 12, 12,  4,  5, 12, 12,  6,
      7, 12, 12, 12, 12,  8, 12, 12,     12,  9, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 10, 12,     12, 12, 12, 12, 11, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_E5_28_infos[13] = {
          o2(0xEA,0xCE),      o2(0xE8,0xDF),
          o2(0xDE,0xCF),      o2(0xD2,0xA6),
          o2(0xE7,0xF4),      o2(0xD1,0xD6),
          o2(0xE6,0xC2),      o2(0xE3,0xE3),
          o2(0xE4,0xB0),      o2(0xD8,0xB4),
          o2(0xF6,0xA5),      o2(0xF3,0xDE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_28 = {
    to_EUC_KR_E5_28_offsets,
    to_EUC_KR_E5_28_infos
};

static const unsigned char
to_EUC_KR_E5_29_offsets[64] = {
      6,  0,  6,  6,  6,  6,  1,  6,      6,  2,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  3,  6,  6,  6,  6,  6,
      6,  6,  4,  6,  6,  6,  5,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_E5_29_infos[7] = {
          o2(0xD7,0xA5),      o2(0xF7,0xE8),
          o2(0xE8,0xC6),      o2(0xFB,0xE6),
          o2(0xDD,0xE6),      o2(0xDC,0xFE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_29 = {
    to_EUC_KR_E5_29_offsets,
    to_EUC_KR_E5_29_infos
};

static const unsigned char
to_EUC_KR_E5_2A_offsets[64] = {
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  0,  4,  4,  4,  4,  4,      4,  4,  1,  2,  4,  4,  4,  4,
      4,  4,  4,  4,  3,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
};

static const struct byte_lookup* const
to_EUC_KR_E5_2A_infos[5] = {
          o2(0xD8,0xDA),      o2(0xDA,0xAC),
          o2(0xEA,0xB0),      o2(0xE3,0xB8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_2A = {
    to_EUC_KR_E5_2A_offsets,
    to_EUC_KR_E5_2A_infos
};

static const unsigned char
to_EUC_KR_E5_2B_offsets[64] = {
      8,  0,  1,  8,  2,  8,  8,  8,      8,  3,  8,  8,  4,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  5,  8,  8,  8,  8,  6,  8,      8,  7,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E5_2B_infos[9] = {
          o2(0xCA,0xAA),      o2(0xE1,0xF9),
          o2(0xEA,0xB1),      o2(0xF2,0xEC),
          o2(0xFA,0xEE),      o2(0xEE,0xD5),
          o2(0xF9,0xF4),      o2(0xD2,0xEC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_2B = {
    to_EUC_KR_E5_2B_offsets,
    to_EUC_KR_E5_2B_infos
};

static const unsigned char
to_EUC_KR_E5_2C_offsets[64] = {
      6,  6,  6,  6,  6,  0,  6,  6,      6,  1,  6,  2,  3,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  4,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  5,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_E5_2C_infos[7] = {
          o2(0xFB,0xFB),      o2(0xFD,0xF0),
          o2(0xE0,0xBD),      o2(0xCE,0xE3),
          o2(0xF8,0xC6),      o2(0xDE,0xAE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_2C = {
    to_EUC_KR_E5_2C_offsets,
    to_EUC_KR_E5_2C_infos
};

static const unsigned char
to_EUC_KR_E5_2D_offsets[64] = {
      0, 22, 22,  1, 22, 22, 22, 22,     22, 22, 22, 22, 22, 22, 22, 22,
      2,  3, 22, 22,  4,  5, 22,  6,      7, 22,  8, 22,  9, 10, 22, 11,
     22, 22, 22, 12, 13, 22, 22, 22,     22, 14, 22, 15, 22, 22, 22, 22,
     16, 17, 22, 22, 22, 18, 22, 22,     19, 22, 20, 22, 21, 22, 22, 22,
};

static const struct byte_lookup* const
to_EUC_KR_E5_2D_infos[23] = {
          o2(0xDF,0xC5),      o2(0xE5,0xBE),
          o2(0xED,0xAD),      o2(0xFA,0xEA),
          o2(0xCD,0xEE),      o2(0xED,0xA6),
          o2(0xED,0xAE),      o2(0xF0,0xED),
          o2(0xDD,0xA1),      o2(0xED,0xAF),
          o2(0xFC,0xF8),      o2(0xD8,0xEB),
          o2(0xCC,0xF9),      o2(0xCD,0xB5),
          o2(0xFA,0xA9),      o2(0xE1,0xDD),
          o2(0xE2,0xD5),      o2(0xED,0xCF),
          o2(0xDD,0xA2),      o2(0xF9,0xCA),
          o2(0xEA,0xE8),      o2(0xE5,0xED),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_2D = {
    to_EUC_KR_E5_2D_offsets,
    to_EUC_KR_E5_2D_infos
};

static const unsigned char
to_EUC_KR_E5_2E_offsets[64] = {
     31, 31, 31, 31, 31,  0, 31,  1,      2,  3, 31,  4,  5, 31, 31,  6,
     31, 31, 31,  7, 31,  8,  9, 10,     11, 12, 13, 14, 15, 31, 31, 31,
     31, 31, 16, 17, 18, 19, 20, 31,     31, 31, 31, 31, 21, 31, 22, 31,
     23, 31, 31, 24, 25, 26, 27, 31,     28, 29, 31, 31, 31, 31, 31, 30,
};

static const struct byte_lookup* const
to_EUC_KR_E5_2E_infos[32] = {
          o2(0xD3,0xEB),      o2(0xE9,0xD4),
          o2(0xE1,0xFA),      o2(0xE4,0xCC),
          o2(0xE1,0xE4),      o2(0xE8,0xC7),
          o2(0xCE,0xDB),      o2(0xDC,0xD5),
          o2(0xF7,0xB5),      o2(0xFC,0xF3),
          o2(0xF0,0xF3),      o2(0xCE,0xAF),
          o2(0xF1,0xB5),      o2(0xEF,0xD2),
          o2(0xE8,0xC8),      o2(0xEB,0xF1),
          o2(0xCB,0xD4),      o2(0xE0,0xBE),
          o2(0xE3,0xF8),      o2(0xEA,0xE9),
          o2(0xFC,0xB2),      o2(0xE0,0xF4),
          o2(0xCF,0xE0),      o2(0xEE,0xA5),
          o2(0xFA,0xAA),      o2(0xE6,0xC3),
          o2(0xE1,0xB2),      o2(0xCA,0xAB),
          o2(0xE3,0xE4),      o2(0xE9,0xBB),
          o2(0xE2,0xD6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_2E = {
    to_EUC_KR_E5_2E_offsets,
    to_EUC_KR_E5_2E_infos
};

static const unsigned char
to_EUC_KR_E5_2F_offsets[64] = {
      0, 31,  1,  2,  3,  4,  5,  6,     31, 31, 31, 31,  7, 31, 31, 31,
      8, 31,  9, 10, 11, 31, 31, 12,     31, 31, 31, 31, 31, 31, 13, 14,
     31, 15, 16, 31, 17, 18, 19, 20,     21, 22, 31, 23, 24, 31, 25, 26,
     31, 31, 31, 31, 31, 27, 28, 31,     29, 31, 30, 31, 31, 31, 31, 31,
};

static const struct byte_lookup* const
to_EUC_KR_E5_2F_infos[32] = {
          o2(0xF3,0xF2),      o2(0xEE,0xD6),
          o2(0xEA,0xB2),      o2(0xD0,0xF6),
          o2(0xEC,0xD9),      o2(0xDA,0xCB),
          o2(0xCF,0xA8),      o2(0xDD,0xA3),
          o2(0xD8,0xDB),      o2(0xF9,0xCE),
          o2(0xE9,0xD5),      o2(0xE3,0xD1),
          o2(0xD2,0xBC),      o2(0xD8,0xAC),
          o2(0xF3,0xCC),      o2(0xCD,0xFB),
          o2(0xF6,0xD6),      o2(0xE7,0xF5),
          o2(0xE8,0xEF),      o2(0xE3,0xF9),
          o2(0xD2,0xBB),      o2(0xF3,0xF3),
          o2(0xE3,0xFB),      o2(0xDE,0xD0),
          o2(0xCE,0xB0),      o2(0xD6,0xF7),
          o2(0xF1,0xD9),      o2(0xF5,0xC1),
          o2(0xDC,0xC4),      o2(0xF5,0xBB),
          o2(0xDE,0xD1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_2F = {
    to_EUC_KR_E5_2F_offsets,
    to_EUC_KR_E5_2F_infos
};

static const unsigned char
to_EUC_KR_E5_30_offsets[64] = {
     23,  0, 23, 23,  1, 23, 23,  2,      3,  4,  5,  6, 23,  7,  8,  9,
     23, 10, 23, 23, 23, 23, 11, 23,     23, 12, 23, 23, 23, 23, 23, 23,
     23, 23, 23, 23, 13, 23, 23, 23,     14, 23, 23, 23, 23, 23, 23, 23,
     23, 15, 23, 23, 23, 23, 23, 23,     16, 17, 18, 19, 20, 23, 21, 22,
};

static const struct byte_lookup* const
to_EUC_KR_E5_30_infos[24] = {
          o2(0xDC,0xE6),      o2(0xDE,0xD2),
          o2(0xED,0xE2),      o2(0xEE,0xF6),
          o2(0xEA,0xCF),      o2(0xF0,0xEE),
          o2(0xE3,0xFC),      o2(0xD3,0xDF),
          o2(0xD3,0xF4),      o2(0xE1,0xB3),
          o2(0xE1,0xB4),      o2(0xF4,0xD3),
          o2(0xDF,0xC6),      o2(0xE9,0xD6),
          o2(0xDB,0xAB),      o2(0xF6,0xA6),
          o2(0xE3,0xB9),      o2(0xEB,0xC5),
          o2(0xF4,0xA9),      o2(0xCD,0xB6),
          o2(0xD2,0xF9),      o2(0xDA,0xAD),
          o2(0xD2,0xE3),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_30 = {
    to_EUC_KR_E5_30_offsets,
    to_EUC_KR_E5_30_infos
};

static const unsigned char
to_EUC_KR_E5_31_offsets[64] = {
      0, 18, 18, 18, 18,  1,  2, 18,      3, 18, 18,  4, 18,  5,  6, 18,
     18,  7, 18, 18, 18,  8, 18, 18,     18, 18, 18,  9, 18, 18, 18, 18,
     10, 18, 11, 18, 12, 13, 18, 18,     18, 18, 18, 18, 14, 18, 18, 15,
     18, 16, 18, 18, 18, 18, 18, 18,     18, 17, 18, 18, 18, 18, 18, 18,
};

static const struct byte_lookup* const
to_EUC_KR_E5_31_infos[19] = {
          o2(0xCF,0xD1),      o2(0xCB,0xDC),
          o2(0xCC,0xFA),      o2(0xCF,0xDD),
          o2(0xE8,0xA9),      o2(0xE3,0xBB),
          o2(0xE3,0xBA),      o2(0xE0,0xDA),
          o2(0xEE,0xF7),      o2(0xDC,0xB3),
          o2(0xD3,0xF5),      o2(0xD7,0xA6),
          o2(0xF6,0xB5),      o2(0xD7,0xDB),
          o2(0xE1,0xD5),      o2(0xD4,0xEA),
          o2(0xDF,0xA3),      o2(0xFD,0xDF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_31 = {
    to_EUC_KR_E5_31_offsets,
    to_EUC_KR_E5_31_infos
};

static const unsigned char
to_EUC_KR_E5_32_offsets[64] = {
     13, 13, 13, 13, 13, 13, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
      0,  1, 13, 13, 13, 13, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
     13,  2, 13, 13, 13, 13, 13, 13,     13,  3, 13,  4,  5, 13, 13, 13,
     13,  6, 13,  7, 13,  8, 13,  9,     10, 13, 11, 13, 13, 13, 12, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E5_32_infos[14] = {
          o2(0xD0,0xF7),      o2(0xED,0xD4),
          o2(0xCB,0xAA),      o2(0xE4,0xDB),
          o2(0xE1,0xFB),      o2(0xCB,0xA2),
          o2(0xD3,0xE0),      o2(0xE4,0xBF),
          o2(0xFB,0xC0),      o2(0xDA,0xBE),
          o2(0xE4,0xCD),      o2(0xD6,0xB9),
          o2(0xEF,0xC0),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_32 = {
    to_EUC_KR_E5_32_offsets,
    to_EUC_KR_E5_32_infos
};

static const unsigned char
to_EUC_KR_E5_33_offsets[64] = {
      0, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10,  1, 10, 10, 10, 10, 10, 10,
      2, 10, 10, 10, 10, 10, 10, 10,      3, 10, 10, 10, 10, 10, 10,  4,
      5, 10, 10, 10,  6, 10,  7, 10,     10, 10, 10,  8, 10,  9, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E5_33_infos[11] = {
          o2(0xE1,0xFC),      o2(0xF6,0xB9),
          o2(0xDF,0xC7),      o2(0xE4,0xB1),
          o2(0xDC,0xE7),      o2(0xDC,0xE8),
          o2(0xFA,0xD6),      o2(0xD3,0xF6),
          o2(0xF1,0xDA),      o2(0xFA,0xF2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_33 = {
    to_EUC_KR_E5_33_offsets,
    to_EUC_KR_E5_33_infos
};

static const unsigned char
to_EUC_KR_E5_34_offsets[64] = {
     10, 10, 10, 10, 10, 10, 10,  0,     10, 10, 10, 10, 10,  1,  2, 10,
     10,  3, 10, 10,  4, 10,  5,  6,     10,  7, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10,  8,     10,  9, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E5_34_infos[11] = {
          o2(0xE2,0xFD),      o2(0xD5,0xCF),
          o2(0xD0,0xF8),      o2(0xCD,0xDF),
          o2(0xF5,0xCB),      o2(0xE4,0xF0),
          o2(0xCB,0xAB),      o2(0xD7,0xC4),
          o2(0xE2,0xFE),      o2(0xDD,0xDA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_34 = {
    to_EUC_KR_E5_34_offsets,
    to_EUC_KR_E5_34_infos
};

static const unsigned char
to_EUC_KR_E5_35_offsets[64] = {
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  0,  1,  6,  6,  6,
      2,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  3,  6,  6,  4,  6,  6,  5,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_E5_35_infos[7] = {
          o2(0xDA,0xAE),      o2(0xCA,0xEE),
          o2(0xD5,0xB9),      o2(0xE3,0xA1),
          o2(0xE8,0xE3),      o2(0xF3,0xAB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_35 = {
    to_EUC_KR_E5_35_offsets,
    to_EUC_KR_E5_35_infos
};

static const unsigned char
to_EUC_KR_E5_36_offsets[64] = {
     10, 10, 10, 10, 10, 10, 10,  0,     10, 10, 10,  1, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10,  2, 10, 10,
      3, 10,  4, 10, 10, 10, 10, 10,     10, 10,  5, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,      6, 10,  7, 10,  8,  9, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E5_36_infos[11] = {
          o2(0xCF,0xA9),      o2(0xD3,0xF7),
          o2(0xD4,0xF1),      o2(0xCE,0xE4),
          o2(0xE8,0xF2),      o2(0xE5,0xF5),
          o2(0xE7,0xAE),      o2(0xD6,0xBA),
          o2(0xDF,0xEC),      o2(0xE4,0xC0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_36 = {
    to_EUC_KR_E5_36_offsets,
    to_EUC_KR_E5_36_infos
};

static const unsigned char
to_EUC_KR_E5_37_offsets[64] = {
     20, 20, 20, 20, 20, 20, 20, 20,     20, 20, 20, 20, 20,  0, 20, 20,
     20, 20,  1, 20, 20, 20,  2, 20,     20, 20, 20, 20, 20,  3,  4, 20,
     20,  5,  6, 20, 20,  7,  8,  9,     10, 20, 20, 11, 20, 20, 12, 20,
     20, 13, 14, 15, 16, 20, 20, 17,     20, 20, 20, 20, 20, 18, 19, 20,
};

static const struct byte_lookup* const
to_EUC_KR_E5_37_infos[21] = {
          o2(0xE8,0xE4),      o2(0xD8,0xB5),
          o2(0xE4,0xDC),      o2(0xF4,0xB9),
          o2(0xF1,0xB6),      o2(0xE2,0xDE),
          o2(0xE1,0xB5),      o2(0xCD,0xEF),
          o2(0xF1,0xA7),      o2(0xCE,0xE5),
          o2(0xCB,0xDD),      o2(0xD9,0xE3),
          o2(0xF3,0xAC),      o2(0xD0,0xF9),
          o2(0xEC,0xAB),      o2(0xDE,0xD3),
          o2(0xF7,0xE9),      o2(0xF9,0xF5),
          o2(0xE1,0xDE),      o2(0xCB,0xEE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_37 = {
    to_EUC_KR_E5_37_offsets,
    to_EUC_KR_E5_37_infos
};

static const unsigned char
to_EUC_KR_E5_38_offsets[64] = {
     17, 17,  0,  1, 17, 17,  2, 17,     17, 17, 17, 17,  3, 17, 17, 17,
     17,  4, 17, 17, 17, 17,  5, 17,     17,  6, 17,  7, 17,  8, 17, 17,
     17, 17, 17, 17, 17,  9, 17, 17,     17, 17, 17, 10, 17, 11, 17, 17,
     17, 17, 17, 12, 17, 17, 13, 17,     14, 17, 17, 17, 17, 15, 17, 16,
};

static const struct byte_lookup* const
to_EUC_KR_E5_38_infos[18] = {
          o2(0xE3,0xBC),      o2(0xF8,0xD6),
          o2(0xDB,0xEE),      o2(0xFD,0xF1),
          o2(0xF7,0xB6),      o2(0xF4,0xDE),
          o2(0xF2,0xED),      o2(0xDB,0xD9),
          o2(0xF0,0xA8),      o2(0xE1,0xFD),
          o2(0xDE,0xD4),      o2(0xE0,0xAC),
          o2(0xED,0xE3),      o2(0xD3,0xE1),
          o2(0xDF,0xC8),      o2(0xD9,0xB6),
          o2(0xFD,0xAC),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_38 = {
    to_EUC_KR_E5_38_offsets,
    to_EUC_KR_E5_38_infos
};

static const unsigned char
to_EUC_KR_E5_39_offsets[64] = {
      0, 20, 20, 20,  1,  2, 20,  3,     20, 20, 20, 20,  4, 20, 20, 20,
     20, 20, 20, 20, 20,  5, 20, 20,     20, 20, 20, 20, 20, 20, 20,  6,
     20,  7,  8,  9, 20, 20, 20, 20,     20, 20, 20, 20, 20, 20, 20, 20,
     20, 20, 10, 11, 12, 20, 20, 13,     14, 15, 20, 16, 17, 18, 19, 20,
};

static const struct byte_lookup* const
to_EUC_KR_E5_39_infos[21] = {
          o2(0xEF,0xD3),      o2(0xE4,0xC1),
          o2(0xF8,0xEB),      o2(0xDB,0xAC),
          o2(0xFC,0xC6),      o2(0xD8,0xAD),
          o2(0xF6,0xBA),      o2(0xDB,0xDF),
          o2(0xD3,0xD3),      o2(0xF8,0xC7),
          o2(0xCA,0xCE),      o2(0xF8,0xC1),
          o2(0xD2,0xB4),      o2(0xDC,0xB4),
          o2(0xFA,0xB9),      o2(0xCA,0xCF),
          o2(0xFC,0xB3),      o2(0xEA,0xEA),
          o2(0xEA,0xEB),      o2(0xD0,0xFA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_39 = {
    to_EUC_KR_E5_39_offsets,
    to_EUC_KR_E5_39_infos
};

static const unsigned char
to_EUC_KR_E5_3A_offsets[64] = {
     18, 18, 18, 18,  0, 18, 18,  1,     18, 18,  2, 18, 18, 18, 18,  3,
     18, 18, 18, 18, 18,  4, 18,  5,     18, 18,  6, 18,  7, 18, 18, 18,
      8, 18, 18, 18, 18, 18,  9, 10,     18, 18, 18, 11, 18, 12, 18, 18,
     18, 18, 18, 18, 18, 13, 14, 15,     16, 18, 18, 18, 18, 18, 17, 18,
};

static const struct byte_lookup* const
to_EUC_KR_E5_3A_infos[19] = {
          o2(0xED,0xE4),      o2(0xDD,0xE7),
          o2(0xDF,0xC9),      o2(0xDF,0xED),
          o2(0xEE,0xBC),      o2(0xEF,0xC1),
          o2(0xCC,0xD2),      o2(0xDD,0xA4),
          o2(0xDF,0xCA),      o2(0xD3,0xF8),
          o2(0xF1,0xA8),      o2(0xCD,0xB7),
          o2(0xEF,0xD4),      o2(0xE4,0xDD),
          o2(0xDF,0xEE),      o2(0xCB,0xAC),
          o2(0xE9,0xBC),      o2(0xEA,0xEC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_3A = {
    to_EUC_KR_E5_3A_offsets,
    to_EUC_KR_E5_3A_infos
};

static const unsigned char
to_EUC_KR_E5_3B_offsets[64] = {
     19, 19,  0, 19, 19, 19, 19, 19,      1,  2,  3, 19, 19, 19, 19, 19,
      4, 19, 19,  5, 19, 19,  6, 19,     19, 19,  7,  8, 19, 19, 19,  9,
     10, 19, 11, 12, 19, 19, 19, 19,     19, 19, 19, 19, 13, 19, 19, 19,
     19, 19, 19, 14, 19, 19, 15, 16,     19, 19, 17, 18, 19, 19, 19, 19,
};

static const struct byte_lookup* const
to_EUC_KR_E5_3B_infos[20] = {
          o2(0xDF,0xCB),      o2(0xF9,0xBF),
          o2(0xD6,0xAF),      o2(0xD5,0xC6),
          o2(0xCF,0xAA),      o2(0xCE,0xA9),
          o2(0xD6,0xF8),      o2(0xF1,0xB7),
          o2(0xEE,0xF8),      o2(0xD9,0xD9),
          o2(0xF3,0xDF),      o2(0xF8,0xC8),
          o2(0xCE,0xC6),      o2(0xD5,0xE6),
          o2(0xF4,0xE6),      o2(0xE6,0xC5),
          o2(0xEF,0xD5),      o2(0xCB,0xEF),
          o2(0xFC,0xDF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_3B = {
    to_EUC_KR_E5_3B_offsets,
    to_EUC_KR_E5_3B_infos
};

static const unsigned char
to_EUC_KR_E5_3C_offsets[64] = {
     19,  0, 19, 19,  1, 19, 19, 19,     19, 19,  2, 19, 19, 19, 19,  3,
     19,  4, 19,  5,  6,  7, 19,  8,      9, 19, 19, 10, 19, 19, 19, 11,
     19, 19, 19, 19, 19, 19, 12, 13,     19, 14, 19, 19, 19, 19, 19, 19,
     19, 15, 19, 19, 19, 16, 19, 19,     19, 19, 17, 19, 18, 19, 19, 19,
};

static const struct byte_lookup* const
to_EUC_KR_E5_3C_infos[20] = {
          o2(0xDC,0xA7),      o2(0xD6,0xE7),
          o2(0xF8,0xC9),      o2(0xE3,0xD2),
          o2(0xE3,0xBD),      o2(0xCF,0xE1),
          o2(0xF0,0xC0),      o2(0xEC,0xDA),
          o2(0xDD,0xD7),      o2(0xFB,0xF0),
          o2(0xEC,0xAC),      o2(0xF0,0xA9),
          o2(0xFA,0xD7),      o2(0xFB,0xC1),
          o2(0xD2,0xC0),      o2(0xE5,0xB0),
          o2(0xED,0xE5),      o2(0xCB,0xAD),
          o2(0xF9,0xB0),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_3C = {
    to_EUC_KR_E5_3C_offsets,
    to_EUC_KR_E5_3C_infos
};

static const unsigned char
to_EUC_KR_E5_3D_offsets[64] = {
     22, 22, 22, 22, 22, 22, 22, 22,      0, 22,  1, 22,  2, 22,  3, 22,
     22, 22, 22, 22, 22, 22,  4,  5,     22,  6, 22,  7, 22, 22, 22, 22,
     22, 22,  8, 22, 22, 22,  9, 10,     22, 11, 12, 13, 14, 15, 22, 22,
     16, 17, 22, 22, 22, 22, 22, 18,     22, 19, 22, 22, 20, 22, 22, 21,
};

static const struct byte_lookup* const
to_EUC_KR_E5_3D_infos[23] = {
          o2(0xF7,0xA5),      o2(0xCB,0xAE),
          o2(0xDA,0xAF),      o2(0xD8,0xB6),
          o2(0xD3,0xA7),      o2(0xFB,0xB2),
          o2(0xFD,0xC4),      o2(0xEC,0xAD),
          o2(0xFB,0xA1),      o2(0xE5,0xE9),
          o2(0xE9,0xEE),      o2(0xF3,0xF4),
          o2(0xF8,0xF3),      o2(0xF0,0xC1),
          o2(0xDE,0xAF),      o2(0xF8,0xB0),
          o2(0xF3,0xE0),      o2(0xE7,0xAF),
          o2(0xDB,0xAD),      o2(0xE6,0xB5),
          o2(0xF9,0xA8),      o2(0xDD,0xD8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_3D = {
    to_EUC_KR_E5_3D_offsets,
    to_EUC_KR_E5_3D_infos
};

static const unsigned char
to_EUC_KR_E5_3E_offsets[64] = {
      0,  1, 24, 24, 24,  2, 24,  3,     24, 24,  4,  5,  6, 24, 24, 24,
      7,  8,  9, 24, 24, 24, 24, 10,     11, 12, 24, 24, 24, 24, 13, 24,
     14, 15, 24, 24, 24, 24, 24, 24,     16, 17, 18, 24, 24, 24, 19, 24,
     24, 24, 24, 24, 24, 20, 24, 21,     24, 22, 24, 24, 24, 23, 24, 24,
};

static const struct byte_lookup* const
to_EUC_KR_E5_3E_infos[25] = {
          o2(0xE8,0xD9),      o2(0xEF,0xD6),
          o2(0xD3,0xE2),      o2(0xE2,0xDF),
          o2(0xFC,0xE0),      o2(0xD7,0xC8),
          o2(0xFD,0xAD),      o2(0xDF,0xEF),
          o2(0xCC,0xD3),      o2(0xD3,0xF9),
          o2(0xD4,0xF0),      o2(0xDB,0xC7),
          o2(0xDE,0xD5),      o2(0xF0,0xF4),
          o2(0xD5,0xD0),      o2(0xE5,0xD9),
          o2(0xFC,0xC7),      o2(0xDC,0xD6),
          o2(0xE2,0xE0),      o2(0xDA,0xB0),
          o2(0xF3,0xA3),      o2(0xD3,0xEC),
          o2(0xF4,0xCB),      o2(0xFD,0xC5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_3E = {
    to_EUC_KR_E5_3E_offsets,
    to_EUC_KR_E5_3E_infos
};

static const unsigned char
to_EUC_KR_E5_3F_offsets[64] = {
     13, 13, 13,  0, 13,  1, 13, 13,     13, 13, 13, 13,  2,  3, 13, 13,
     13, 13, 13, 13, 13, 13,  4,  5,      6,  7, 13, 13, 13, 13, 13, 13,
      8, 13, 13, 13, 13, 13, 13, 13,     13, 13, 13,  9, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 10, 13, 13,     13, 13, 13, 13, 13, 11, 13, 12,
};

static const struct byte_lookup* const
to_EUC_KR_E5_3F_infos[14] = {
          o2(0xE3,0xFD),      o2(0xF9,0xB1),
          o2(0xD0,0xFB),      o2(0xEC,0xDB),
          o2(0xF5,0xBC),      o2(0xF2,0xA4),
          o2(0xD8,0xCE),      o2(0xD8,0xCF),
          o2(0xF5,0xF7),      o2(0xF6,0xE1),
          o2(0xD2,0xB7),      o2(0xFB,0xEC),
          o2(0xDD,0xC8),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5_3F = {
    to_EUC_KR_E5_3F_offsets,
    to_EUC_KR_E5_3F_infos
};


static const struct byte_lookup* const
to_EUC_KR_E5_infos[65] = {
       &to_EUC_KR_E5_00,   &to_EUC_KR_E5_01,
       &to_EUC_KR_E5_02,   &to_EUC_KR_E5_03,
       &to_EUC_KR_E5_04,   &to_EUC_KR_E5_05,
       &to_EUC_KR_E5_06,   &to_EUC_KR_E5_07,
       &to_EUC_KR_E5_08,   &to_EUC_KR_E5_09,
       &to_EUC_KR_E5_0A,   &to_EUC_KR_E5_0B,
       &to_EUC_KR_E5_0C,   &to_EUC_KR_E5_0D,
       &to_EUC_KR_E5_0E,   &to_EUC_KR_E5_0F,
       &to_EUC_KR_E5_10,   &to_EUC_KR_E5_11,
       &to_EUC_KR_E5_12,   &to_EUC_KR_E5_13,
       &to_EUC_KR_E5_14,   &to_EUC_KR_E5_15,
       &to_EUC_KR_E5_16,   &to_EUC_KR_E5_17,
       &to_EUC_KR_E5_18,   &to_EUC_KR_E5_19,
       &to_EUC_KR_E5_1A,   &to_EUC_KR_E5_1B,
       &to_EUC_KR_E5_1C,   &to_EUC_KR_E5_1D,
       &to_EUC_KR_E5_1E,   &to_EUC_KR_E5_1F,
       &to_EUC_KR_E5_20,   &to_EUC_KR_E5_21,
       &to_EUC_KR_E5_22,   &to_EUC_KR_E5_23,
       &to_EUC_KR_E5_24,   &to_EUC_KR_E5_25,
       &to_EUC_KR_E5_26,   &to_EUC_KR_E5_27,
       &to_EUC_KR_E5_28,   &to_EUC_KR_E5_29,
       &to_EUC_KR_E5_2A,   &to_EUC_KR_E5_2B,
       &to_EUC_KR_E5_2C,   &to_EUC_KR_E5_2D,
       &to_EUC_KR_E5_2E,   &to_EUC_KR_E5_2F,
       &to_EUC_KR_E5_30,   &to_EUC_KR_E5_31,
       &to_EUC_KR_E5_32,   &to_EUC_KR_E5_33,
       &to_EUC_KR_E5_34,   &to_EUC_KR_E5_35,
       &to_EUC_KR_E5_36,   &to_EUC_KR_E5_37,
       &to_EUC_KR_E5_38,   &to_EUC_KR_E5_39,
       &to_EUC_KR_E5_3A,   &to_EUC_KR_E5_3B,
       &to_EUC_KR_E5_3C,   &to_EUC_KR_E5_3D,
       &to_EUC_KR_E5_3E,   &to_EUC_KR_E5_3F,
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E5 = {
    to_EUC_KR_E3_05_offsets,
    to_EUC_KR_E5_infos
};

static const unsigned char
to_EUC_KR_E6_00_offsets[64] = {
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12,  0,
     12, 12,  1, 12, 12, 12,  2, 12,     12, 12, 12, 12,  3,  4, 12, 12,
      5,  6, 12, 12, 12,  7, 12,  8,      9, 12, 10, 12, 12, 12, 12, 11,
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_E6_00_infos[13] = {
          o2(0xE4,0xE8),      o2(0xD2,0xC1),
          o2(0xF8,0xD7),      o2(0xD6,0xBB),
          o2(0xDE,0xD6),      o2(0xF7,0xBD),
          o2(0xEC,0xAE),      o2(0xD0,0xE1),
          o2(0xE0,0xF5),      o2(0xEA,0xB3),
          o2(0xCE,0xD6),      o2(0xCC,0xA5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_00 = {
    to_EUC_KR_E6_00_offsets,
    to_EUC_KR_E6_00_infos
};

static const unsigned char
to_EUC_KR_E6_01_offsets[64] = {
     20,  0,  1,  2, 20, 20, 20, 20,     20, 20, 20, 20, 20,  3, 20, 20,
      4, 20,  5, 20, 20,  6, 20, 20,     20,  7, 20, 20, 20,  8, 20, 20,
     20, 20,  9, 10, 11, 12, 20, 20,     13, 14, 15, 20, 16, 17, 20, 18,
     19, 20, 20, 20, 20, 20, 20, 20,     20, 20, 20, 20, 20, 20, 20, 20,
};

static const struct byte_lookup* const
to_EUC_KR_E6_01_infos[21] = {
          o2(0xEC,0xF6),      o2(0xE2,0xE1),
          o2(0xE3,0xBE),      o2(0xFC,0xC8),
          o2(0xCD,0xF0),      o2(0xF9,0xF6),
          o2(0xDF,0xF0),      o2(0xE5,0xBF),
          o2(0xCE,0xBF),      o2(0xFC,0xE1),
          o2(0xED,0xB0),      o2(0xFD,0xD1),
          o2(0xF6,0xBB),      o2(0xF9,0xCF),
          o2(0xEB,0xDA),      o2(0xCA,0xC1),
          o2(0xD2,0xB8),      o2(0xCD,0xF1),
          o2(0xE3,0xD3),      o2(0xFD,0xE6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_01 = {
    to_EUC_KR_E6_01_offsets,
    to_EUC_KR_E6_01_infos
};

static const unsigned char
to_EUC_KR_E6_02_offsets[64] = {
     21, 21, 21, 21, 21,  0, 21, 21,     21,  1, 21, 21,  2,  3, 21, 21,
     21, 21, 21, 21,  4, 21,  5, 21,     21, 21,  6,  7, 21, 21, 21,  8,
      9, 21, 21, 10, 11, 21, 21, 12,     21, 21, 21, 21, 21, 21, 21, 21,
     13, 21, 14, 15, 16, 21, 17, 21,     18, 21, 21, 21, 19, 20, 21, 21,
};

static const struct byte_lookup* const
to_EUC_KR_E6_02_infos[22] = {
          o2(0xE6,0xED),      o2(0xE3,0xFA),
          o2(0xF0,0xAA),      o2(0xF9,0xD0),
          o2(0xFC,0xE2),      o2(0xF8,0xA7),
          o2(0xE1,0xE5),      o2(0xEE,0xF9),
          o2(0xE7,0xF6),      o2(0xEA,0xED),
          o2(0xFC,0xB4),      o2(0xF5,0xC2),
          o2(0xD7,0xDC),      o2(0xF0,0xF5),
          o2(0xDD,0xE8),      o2(0xD3,0xED),
          o2(0xF5,0xFC),      o2(0xDA,0xBF),
          o2(0xCC,0xFB),      o2(0xD3,0xFA),
          o2(0xF4,0xA4),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_02 = {
    to_EUC_KR_E6_02_offsets,
    to_EUC_KR_E6_02_infos
};

static const unsigned char
to_EUC_KR_E6_03_offsets[64] = {
     15, 15, 15, 15, 15,  0, 15,  1,     15, 15, 15, 15, 15, 15, 15, 15,
     15,  2, 15, 15, 15, 15, 15, 15,     15, 15,  3, 15,  4, 15, 15,  5,
      6,  7, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
      8,  9, 15, 10, 15, 15, 11, 15,     15, 12, 13, 14, 15, 15, 15, 15,
};

static const struct byte_lookup* const
to_EUC_KR_E6_03_infos[16] = {
          o2(0xEF,0xD7),      o2(0xD4,0xC3),
          o2(0xFB,0xE3),      o2(0xFB,0xED),
          o2(0xE0,0xAD),      o2(0xEA,0xEE),
          o2(0xFB,0xB3),      o2(0xE4,0xC2),
          o2(0xF6,0xE7),      o2(0xD2,0xDD),
          o2(0xDF,0xCC),      o2(0xFC,0xC9),
          o2(0xE5,0xA9),      o2(0xE0,0xF6),
          o2(0xF6,0xB3),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_03 = {
    to_EUC_KR_E6_03_offsets,
    to_EUC_KR_E6_03_infos
};

static const unsigned char
to_EUC_KR_E6_04_offsets[64] = {
     18,  0, 18, 18, 18, 18,  1, 18,      2,  3, 18, 18, 18,  4,  5,  6,
     18, 18, 18, 18, 18,  7, 18, 18,     18, 18,  8,  9, 18, 18, 18, 10,
     18, 18, 18, 18, 18, 18, 18, 11,     18, 18, 18, 18, 18, 18, 18, 18,
     12, 18, 18, 18, 13, 18, 18, 14,     18, 18, 18, 18, 15, 18, 16, 17,
};

static const struct byte_lookup* const
to_EUC_KR_E6_04_infos[19] = {
          o2(0xE1,0xFE),      o2(0xCB,0xF0),
          o2(0xEA,0xEF),      o2(0xEA,0xF0),
          o2(0xDA,0xC0),      o2(0xF8,0xB4),
          o2(0xEB,0xF2),      o2(0xE4,0xC3),
          o2(0xE9,0xD7),      o2(0xE4,0xF1),
          o2(0xCA,0xEF),      o2(0xCE,0xD7),
          o2(0xFC,0xCA),      o2(0xF3,0xE1),
          o2(0xCB,0xC4),      o2(0xE3,0xE5),
          o2(0xCB,0xC5),      o2(0xEA,0xB4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_04 = {
    to_EUC_KR_E6_04_offsets,
    to_EUC_KR_E6_04_infos
};

static const unsigned char
to_EUC_KR_E6_05_offsets[64] = {
     25, 25,  0, 25,  1, 25, 25,  2,      3, 25,  4,  5,  6, 25, 25, 25,
     25, 25, 25,  7, 25,  8, 25, 25,      9, 10, 25, 25, 25, 11, 25, 12,
     25, 25, 13, 14, 15, 25, 25, 16,     17, 25, 25, 18, 25, 25, 19, 25,
     20, 25, 25, 25, 25, 25, 21, 22,     25, 25, 25, 25, 25, 23, 24, 25,
};

static const struct byte_lookup* const
to_EUC_KR_E6_05_infos[26] = {
          o2(0xE9,0xBD),      o2(0xD7,0xC9),
          o2(0xEB,0xDB),      o2(0xED,0xB1),
          o2(0xCC,0xC3),      o2(0xF7,0xBE),
          o2(0xFC,0xCB),      o2(0xF8,0xF4),
          o2(0xD9,0xB7),      o2(0xF3,0xD3),
          o2(0xF3,0xD4),      o2(0xF7,0xE4),
          o2(0xF7,0xD1),      o2(0xD8,0xB7),
          o2(0xCE,0xB1),      o2(0xCA,0xC2),
          o2(0xFB,0xB4),      o2(0xCB,0xC6),
          o2(0xF0,0xF6),      o2(0xD5,0xE7),
          o2(0xEA,0xD0),      o2(0xCC,0xD4),
          o2(0xCB,0xAF),      o2(0xF4,0xAA),
          o2(0xE9,0xAF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_05 = {
    to_EUC_KR_E6_05_offsets,
    to_EUC_KR_E6_05_infos
};

static const unsigned char
to_EUC_KR_E6_06_offsets[64] = {
     20,  0,  1, 20, 20, 20, 20, 20,     20, 20,  2, 20, 20, 20,  3, 20,
      4,  5, 20, 20,  6, 20, 20, 20,      7,  8,  9, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 10, 20, 20, 11,     20, 12, 20, 13, 14, 20, 15, 20,
     20, 20, 16, 20, 20, 20, 17, 20,     20, 20, 18, 20, 20, 20, 19, 20,
};

static const struct byte_lookup* const
to_EUC_KR_E6_06_infos[21] = {
          o2(0xF5,0xC3),      o2(0xE9,0xD8),
          o2(0xDD,0xE9),      o2(0xF1,0xF3),
          o2(0xD5,0xFB),      o2(0xDE,0xBB),
          o2(0xF4,0xFB),      o2(0xFD,0xF3),
          o2(0xFD,0xF2),      o2(0xF7,0xA6),
          o2(0xDD,0xC9),      o2(0xD4,0xD3),
          o2(0xCC,0xA8),      o2(0xDA,0xC1),
          o2(0xCC,0xD5),      o2(0xD9,0xE4),
          o2(0xFA,0xCA),      o2(0xE5,0xE3),
          o2(0xD3,0xBC),      o2(0xCA,0xF0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_06 = {
    to_EUC_KR_E6_06_offsets,
    to_EUC_KR_E6_06_infos
};

static const unsigned char
to_EUC_KR_E6_07_offsets[64] = {
     14, 14, 14,  0, 14, 14, 14,  1,      2,  3,  4,  5, 14, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,     14, 14, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14, 14, 14,  6, 14,     14, 14, 14, 14, 14, 14, 14, 14,
     14, 14,  7, 14, 14, 14,  8,  9,     10, 14, 11, 14, 12, 14, 14, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E6_07_infos[15] = {
          o2(0xD0,0xC4),      o2(0xCA,0xD0),
          o2(0xFA,0xAB),      o2(0xEB,0xEB),
          o2(0xE7,0xF8),      o2(0xD9,0xE5),
          o2(0xD1,0xD7),      o2(0xF3,0xA4),
          o2(0xD4,0xFB),      o2(0xFC,0xE3),
          o2(0xFA,0xD8),      o2(0xF3,0xD5),
          o2(0xCF,0xAB),      o2(0xEB,0xF3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_07 = {
    to_EUC_KR_E6_07_offsets,
    to_EUC_KR_E6_07_infos
};

static const unsigned char
to_EUC_KR_E6_08_offsets[64] = {
      0, 22, 22, 22, 22, 22, 22,  1,      2, 22,  3, 22,  4,  5,  6, 22,
      7,  8,  9, 22, 22, 22, 10, 22,     22, 22, 11, 22, 22, 22, 22, 12,
     22, 13, 22, 22, 22, 22, 22, 22,     22, 22, 14, 22, 22, 22, 15, 22,
     16, 17, 22, 22, 18, 22, 19, 22,     22, 22, 22, 22, 22, 22, 20, 21,
};

static const struct byte_lookup* const
to_EUC_KR_E6_08_infos[23] = {
          o2(0xD5,0xFC),      o2(0xD3,0xD4),
          o2(0xCD,0xFC),      o2(0xD9,0xE6),
          o2(0xE2,0xF9),      o2(0xE2,0xA1),
          o2(0xEB,0xD4),      o2(0xE0,0xF7),
          o2(0xE4,0xB2),      o2(0xCC,0xFC),
          o2(0xFB,0xE4),      o2(0xF4,0xAB),
          o2(0xD0,0xBD),      o2(0xCA,0xF1),
          o2(0xEF,0xB8),      o2(0xD7,0xC0),
          o2(0xEE,0xFA),      o2(0xFD,0xF4),
          o2(0xD3,0xE3),      o2(0xFB,0xC2),
          o2(0xD5,0xE8),      o2(0xDB,0xAE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_08 = {
    to_EUC_KR_E6_08_offsets,
    to_EUC_KR_E6_08_infos
};

static const unsigned char
to_EUC_KR_E6_09_offsets[64] = {
      0,  1, 15, 15, 15, 15, 15,  2,      3,  4, 15,  5, 15,  6, 15, 15,
     15, 15, 15,  7, 15, 15, 15, 15,      8, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15,  9, 15,
     15, 10, 15, 15, 15, 15, 11, 15,     15, 12, 15, 15, 13, 15, 15, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E6_09_infos[16] = {
          o2(0xE1,0xB6),      o2(0xF8,0xB7),
          o2(0xE0,0xBF),      o2(0xFB,0xC3),
          o2(0xDD,0xEA),      o2(0xE2,0xA2),
          o2(0xEE,0xA6),      o2(0xF6,0xE8),
          o2(0xF6,0xF5),      o2(0xDD,0xCA),
          o2(0xD0,0xE2),      o2(0xDD,0xA6),
          o2(0xDD,0xEB),      o2(0xE4,0xF9),
          o2(0xE3,0xAF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_09 = {
    to_EUC_KR_E6_09_offsets,
    to_EUC_KR_E6_09_infos
};

static const unsigned char
to_EUC_KR_E6_0A_offsets[64] = {
      0, 16, 16, 16,  1, 16, 16, 16,     16,  2,  3, 16, 16, 16, 16, 16,
     16,  4,  5, 16, 16,  6, 16,  7,      8, 16, 16,  9, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,     16, 16, 16, 10, 16, 16, 16, 16,
     16, 11, 16, 16, 16, 12, 16, 16,     16, 13, 16, 16, 14, 15, 16, 16,
};

static const struct byte_lookup* const
to_EUC_KR_E6_0A_infos[17] = {
          o2(0xD0,0xFC),      o2(0xF4,0xFC),
          o2(0xCC,0xBC),      o2(0xF7,0xEA),
          o2(0xE5,0xE4),      o2(0xDF,0xF1),
          o2(0xF7,0xE1),      o2(0xF9,0xF7),
          o2(0xEF,0xB9),      o2(0xF8,0xD8),
          o2(0xF9,0xA9),      o2(0xF8,0xD9),
          o2(0xEE,0xBD),      o2(0xD8,0xC6),
          o2(0xE4,0xE3),      o2(0xF5,0xCE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_0A = {
    to_EUC_KR_E6_0A_offsets,
    to_EUC_KR_E6_0A_infos
};

static const unsigned char
to_EUC_KR_E6_0B_offsets[64] = {
     26, 26,  0, 26, 26, 26, 26,  1,      2,  3, 26, 26,  4,  5, 26,  6,
      7, 26,  8,  9, 10, 26, 11, 12,     13, 14, 26, 15, 16, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26,     26, 26, 26, 26, 17, 18, 19, 20,
     26, 21, 26, 22, 26, 26, 26, 23,     26, 26, 26, 26, 26, 26, 24, 25,
};

static const struct byte_lookup* const
to_EUC_KR_E6_0B_infos[27] = {
          o2(0xDD,0xD9),      o2(0xD9,0xE7),
          o2(0xD2,0xB9),      o2(0xD5,0xC3),
          o2(0xDA,0xE5),      o2(0xDA,0xD0),
          o2(0xD1,0xD9),      o2(0xCE,0xD8),
          o2(0xCB,0xDE),      o2(0xF4,0xAC),
          o2(0xDA,0xFB),      o2(0xF6,0xE9),
          o2(0xE8,0xF3),      o2(0xCF,0xAC),
          o2(0xF0,0xF0),      o2(0xF4,0xFD),
          o2(0xDB,0xC8),      o2(0xCE,0xC0),
          o2(0xE3,0xD4),      o2(0xD1,0xCF),
          o2(0xF1,0xF5),      o2(0xCD,0xF2),
          o2(0xCF,0xEB),      o2(0xCD,0xB8),
          o2(0xE3,0xA6),      o2(0xD1,0xDA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_0B = {
    to_EUC_KR_E6_0B_offsets,
    to_EUC_KR_E6_0B_infos
};

static const unsigned char
to_EUC_KR_E6_0C_offsets[64] = {
     10,  0, 10, 10, 10, 10, 10,  1,     10,  2, 10, 10, 10, 10, 10, 10,
     10,  3, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10,  4, 10, 10, 10,  5,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10,  6,  7, 10,  8,  9, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E6_0C_infos[11] = {
          o2(0xF2,0xA5),      o2(0xF2,0xA6),
          o2(0xE4,0xCE),      o2(0xD3,0xFB),
          o2(0xF1,0xA9),      o2(0xF2,0xC9),
          o2(0xEF,0xD8),      o2(0xE6,0xC9),
          o2(0xD8,0xB8),      o2(0xFA,0xF3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_0C = {
    to_EUC_KR_E6_0C_offsets,
    to_EUC_KR_E6_0C_infos
};

static const unsigned char
to_EUC_KR_E6_0D_offsets[64] = {
     13, 13, 13, 13, 13, 13, 13, 13,     13,  0, 13, 13,  1, 13, 13,  2,
      3, 13, 13, 13, 13,  4, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13,  5,      6, 13, 13, 13, 13, 13,  7, 13,
     13, 13,  8, 13, 13, 13, 13,  9,     13, 13, 10, 11, 13, 13, 13, 12,
};

static const struct byte_lookup* const
to_EUC_KR_E6_0D_infos[14] = {
          o2(0xF3,0xB5),      o2(0xF8,0xA4),
          o2(0xD1,0xF3),      o2(0xE6,0xC8),
          o2(0xF8,0xDA),      o2(0xDC,0xE9),
          o2(0xDE,0xD7),      o2(0xCB,0xDF),
          o2(0xCF,0xEC),      o2(0xF4,0xDF),
          o2(0xD1,0xF4),      o2(0xD2,0xBA),
          o2(0xDF,0xF2),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_0D = {
    to_EUC_KR_E6_0D_offsets,
    to_EUC_KR_E6_0D_infos
};

static const unsigned char
to_EUC_KR_E6_0E_offsets[64] = {
     16, 16, 16,  0, 16, 16, 16, 16,      1,  2, 16, 16,  3, 16, 16, 16,
     16, 16,  4, 16, 16, 16,  5, 16,      6, 16, 16,  7, 16, 16, 16, 16,
      8,  9, 10, 16, 16, 11, 16, 12,     13, 14, 15, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,     16, 16, 16, 16, 16, 16, 16, 16,
};

static const struct byte_lookup* const
to_EUC_KR_E6_0E_infos[17] = {
          o2(0xE1,0xB7),      o2(0xE2,0xA3),
          o2(0xD3,0xFC),      o2(0xED,0xE6),
          o2(0xDB,0xC9),      o2(0xE4,0xFA),
          o2(0xCF,0xDE),      o2(0xCE,0xD0),
          o2(0xD5,0xD3),      o2(0xF3,0xF5),
          o2(0xF7,0xAE),      o2(0xEF,0xC8),
          o2(0xCD,0xF3),      o2(0xF5,0xCF),
          o2(0xE5,0xF3),      o2(0xF0,0xC2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_0E = {
    to_EUC_KR_E6_0E_offsets,
    to_EUC_KR_E6_0E_infos
};

static const unsigned char
to_EUC_KR_E6_0F_offsets[64] = {
      0, 14, 14, 14,  1, 14,  2, 14,     14, 14, 14, 14, 14, 14, 14,  3,
      4, 14, 14, 14, 14, 14,  5, 14,     14, 14,  6,  7, 14, 14, 14, 14,
     14,  8, 14, 14, 14, 14, 14, 14,     14, 14, 14, 14, 14,  9, 10, 14,
     14, 14, 14, 14, 11, 14, 12, 13,     14, 14, 14, 14, 14, 14, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E6_0F_infos[15] = {
          o2(0xCA,0xD1),      o2(0xEA,0xF1),
          o2(0xD0,0xA6),      o2(0xD9,0xDA),
          o2(0xF0,0xAB),      o2(0xEB,0xE7),
          o2(0xE5,0xC0),      o2(0xFC,0xB5),
          o2(0xE4,0xC4),      o2(0xCC,0xA9),
          o2(0xFD,0xC6),      o2(0xEA,0xB5),
          o2(0xE5,0xAA),      o2(0xDF,0xBA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_0F = {
    to_EUC_KR_E6_0F_offsets,
    to_EUC_KR_E6_0F_infos
};

static const unsigned char
to_EUC_KR_E6_10_offsets[64] = {
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11,  0, 11,  1,
     11, 11, 11, 11,  2, 11,  3,  4,     11, 11, 11, 11,  5, 11, 11, 11,
     11, 11,  6, 11, 11, 11, 11, 11,     11, 11, 11, 11,  7,  8, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11,  9, 11, 11, 11, 10, 11,
};

static const struct byte_lookup* const
to_EUC_KR_E6_10_infos[12] = {
          o2(0xE1,0xDF),      o2(0xDA,0xD1),
          o2(0xE1,0xB8),      o2(0xE8,0xF4),
          o2(0xD3,0xFD),      o2(0xE2,0xA4),
          o2(0xF2,0xCA),      o2(0xDA,0xE6),
          o2(0xF7,0xB3),      o2(0xFD,0xCD),
          o2(0xF3,0xB6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_10 = {
    to_EUC_KR_E6_10_offsets,
    to_EUC_KR_E6_10_infos
};

static const unsigned char
to_EUC_KR_E6_11_offsets[64] = {
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      0,  7,  7,  7,  7,  7,  7,  7,
      1,  7,  7,  7,  7,  7,  7,  7,      7,  2,  7,  7,  7,  7,  7,  3,
      7,  7,  7,  7,  7,  7,  7,  7,      4,  5,  6,  7,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_E6_11_infos[8] = {
          o2(0xEE,0xD7),      o2(0xF5,0xC4),
          o2(0xD8,0xA4),      o2(0xF2,0xA7),
          o2(0xD9,0xB8),      o2(0xD9,0xB9),
          o2(0xEF,0xC9),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_11 = {
    to_EUC_KR_E6_11_offsets,
    to_EUC_KR_E6_11_infos
};

static const unsigned char
to_EUC_KR_E6_12_offsets[64] = {
     14, 14, 14, 14, 14, 14, 14, 14,      0, 14, 14, 14, 14, 14, 14, 14,
     14,  1,  2,  3, 14, 14, 14, 14,     14, 14,  4, 14, 14, 14,  5, 14,
     14, 14, 14, 14,  6,  7, 14, 14,     14, 14, 14,  8, 14,  9, 10, 14,
     11, 14, 12, 14, 14, 14, 14, 14,     14, 14, 14, 13, 14, 14, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E6_12_infos[15] = {
          o2(0xD6,0xCE),      o2(0xF7,0xCB),
          o2(0xDF,0xAE),      o2(0xE8,0xF5),
          o2(0xD2,0xB5),      o2(0xD3,0xD5),
          o2(0xF4,0xCC),      o2(0xDA,0xFC),
          o2(0xD9,0xE8),      o2(0xF7,0xEB),
          o2(0xF5,0xC9),      o2(0xF3,0xBC),
          o2(0xDA,0xD2),      o2(0xD3,0xB5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_12 = {
    to_EUC_KR_E6_12_offsets,
    to_EUC_KR_E6_12_infos
};

static const unsigned char
to_EUC_KR_E6_13_offsets[64] = {
     21,  0, 21, 21,  1,  2, 21,  3,     21, 21,  4, 21, 21,  5,  6, 21,
     21, 21,  7, 21,  8, 21, 21, 21,      9, 21, 10, 21, 21, 21, 21, 21,
     21, 11, 12, 21, 21, 13, 14, 15,     21, 21, 21, 21, 16, 21, 21, 21,
     21, 21, 17, 21, 18, 21, 21, 21,     21, 21, 19, 21, 21, 21, 20, 21,
};

static const struct byte_lookup* const
to_EUC_KR_E6_13_infos[22] = {
          o2(0xE8,0xB6),      o2(0xD6,0xCF),
          o2(0xF4,0xBA),      o2(0xF7,0xC9),
          o2(0xCC,0xAA),      o2(0xF0,0xC3),
          o2(0xCC,0xD6),      o2(0xD0,0xD3),
          o2(0xD3,0xBD),      o2(0xDB,0xFB),
          o2(0xCB,0xE0),      o2(0xD3,0xE4),
          o2(0xF6,0xF7),      o2(0xD5,0xBA),
          o2(0xF3,0xCD),      o2(0xCB,0xE1),
          o2(0xEB,0xF4),      o2(0xF4,0xAD),
          o2(0xFC,0xAA),      o2(0xF7,0xEC),
          o2(0xE8,0xF6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_13 = {
    to_EUC_KR_E6_13_offsets,
    to_EUC_KR_E6_13_infos
};

static const unsigned char
to_EUC_KR_E6_14_offsets[64] = {
      0, 16, 16, 16,  1, 16, 16, 16,     16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,      2, 16, 16, 16, 16,  3, 16, 16,
     16, 16, 16,  4, 16, 16, 16, 16,     16, 16,  5,  6,  7, 16, 16,  8,
     16, 16, 16, 16, 16, 16,  9, 10,     11, 12, 16, 13, 16, 16, 14, 15,
};

static const struct byte_lookup* const
to_EUC_KR_E6_14_infos[17] = {
          o2(0xDA,0xE7),      o2(0xF7,0xCC),
          o2(0xE5,0xC1),      o2(0xE0,0xEE),
          o2(0xD5,0xFD),      o2(0xCE,0xE6),
          o2(0xFC,0xAB),      o2(0xD5,0xBB),
          o2(0xF2,0xA8),      o2(0xE2,0xA5),
          o2(0xCD,0xB9),      o2(0xEA,0xF2),
          o2(0xCB,0xC7),      o2(0xCD,0xF4),
          o2(0xDB,0xAF),      o2(0xEF,0xD9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_14 = {
    to_EUC_KR_E6_14_offsets,
    to_EUC_KR_E6_14_infos
};

static const unsigned char
to_EUC_KR_E6_15_offsets[64] = {
     20, 20, 20, 20, 20,  0, 20, 20,      1, 20, 20, 20, 20,  2,  3,  4,
     20,  5, 20, 20, 20, 20,  6,  7,     20, 20, 20, 20, 20, 20,  8, 20,
     20, 20,  9, 10, 20, 20, 11, 20,     20, 20, 20, 20, 12, 13, 20, 20,
     20, 20, 14, 20, 15, 16, 20, 17,     18, 20, 20, 20, 20, 20, 19, 20,
};

static const struct byte_lookup* const
to_EUC_KR_E6_15_infos[21] = {
          o2(0xCD,0xBA),      o2(0xFC,0xF9),
          o2(0xDF,0xF3),      o2(0xCE,0xE7),
          o2(0xDA,0xC2),      o2(0xCF,0xAD),
          o2(0xE7,0xF9),      o2(0xF8,0xA8),
          o2(0xF3,0xE2),      o2(0xCA,0xF2),
          o2(0xDF,0xA4),      o2(0xD4,0xC4),
          o2(0xCC,0xD7),      o2(0xE5,0xC2),
          o2(0xCD,0xBB),      o2(0xEF,0xDA),
          o2(0xEE,0xD8),      o2(0xDD,0xA7),
          o2(0xE2,0xA6),      o2(0xE0,0xC0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_15 = {
    to_EUC_KR_E6_15_offsets,
    to_EUC_KR_E6_15_infos
};

static const unsigned char
to_EUC_KR_E6_16_offsets[64] = {
     24, 24,  0,  1, 24,  2, 24,  3,     24, 24, 24, 24,  4, 24, 24, 24,
      5,  6, 24, 24, 24, 24, 24,  7,     24,  8, 24,  9, 10, 24, 24, 11,
     24, 12, 24, 24, 13, 14, 24, 15,     24, 24, 24, 16, 17, 24, 24, 18,
     19, 24, 24, 24, 24, 24, 24, 20,     24, 21, 24, 24, 22, 23, 24, 24,
};

static const struct byte_lookup* const
to_EUC_KR_E6_16_infos[25] = {
          o2(0xD6,0xB0),      o2(0xF8,0xCA),
          o2(0xFC,0xFA),      o2(0xD9,0xFE),
          o2(0xDE,0xB0),      o2(0xDD,0xEC),
          o2(0xDA,0xE8),      o2(0xD4,0xE0),
          o2(0xD6,0xF9),      o2(0xCD,0xD7),
          o2(0xDE,0xD8),      o2(0xF2,0xF8),
          o2(0xE4,0xD6),      o2(0xD0,0xC5),
          o2(0xF4,0xAE),      o2(0xDD,0xA8),
          o2(0xED,0xC5),      o2(0xF3,0xD6),
          o2(0xDE,0xD9),      o2(0xE3,0xE6),
          o2(0xD3,0xA8),      o2(0xDB,0xB0),
          o2(0xE5,0xDA),      o2(0xE3,0xBF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_16 = {
    to_EUC_KR_E6_16_offsets,
    to_EUC_KR_E6_16_infos
};

static const unsigned char
to_EUC_KR_E6_17_offsets[64] = {
     22,  0, 22, 22, 22,  1, 22, 22,     22, 22, 22,  2,  3, 22, 22,  4,
     22, 22,  5, 22, 22, 22, 22,  6,     22, 22, 22, 22, 22, 22, 22, 22,
      7, 22, 22,  8, 22,  9, 10, 22,     11, 12, 22, 22, 13, 14, 22, 22,
     22, 15, 22, 22, 16, 22, 22, 22,     22, 22, 17, 18, 19, 20, 22, 21,
};

static const struct byte_lookup* const
to_EUC_KR_E6_17_infos[23] = {
          o2(0xDB,0xB1),      o2(0xD5,0xE9),
          o2(0xE0,0xC1),      o2(0xEF,0xDB),
          o2(0xF0,0xE9),      o2(0xD7,0xB2),
          o2(0xD0,0xFD),      o2(0xD9,0xE9),
          o2(0xD0,0xFE),      o2(0xEC,0xED),
          o2(0xD3,0xA9),      o2(0xF2,0xA9),
          o2(0xF0,0xC4),      o2(0xE2,0xE2),
          o2(0xE9,0xEF),      o2(0xF9,0xD1),
          o2(0xE9,0xD9),      o2(0xE8,0xDA),
          o2(0xDA,0xC3),      o2(0xDA,0xC4),
          o2(0xD4,0xC5),      o2(0xE7,0xFA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_17 = {
    to_EUC_KR_E6_17_offsets,
    to_EUC_KR_E6_17_infos
};

static const unsigned char
to_EUC_KR_E6_18_offsets[64] = {
     26, 26, 26, 26, 26, 26,  0,  1,     26,  2,  3, 26,  4, 26,  5,  6,
      7,  8, 26,  9, 10, 11, 26, 26,     26, 26, 26, 26, 26, 26, 12, 13,
     14, 26, 26, 26, 26, 15, 26, 16,     17, 26, 26, 26, 26, 18, 26, 19,
     20, 21, 26, 26, 22, 26, 23, 26,     26, 26, 24, 25, 26, 26, 26, 26,
};

static const struct byte_lookup* const
to_EUC_KR_E6_18_infos[27] = {
          o2(0xCD,0xE0),      o2(0xE3,0xB0),
          o2(0xDB,0xB2),      o2(0xFB,0xC4),
          o2(0xF3,0xE3),      o2(0xD9,0xA5),
          o2(0xFB,0xE7),      o2(0xDD,0xCB),
          o2(0xD0,0xD4),      o2(0xE6,0xB6),
          o2(0xE0,0xAE),      o2(0xFD,0xDA),
          o2(0xDC,0xB5),      o2(0xE0,0xF8),
          o2(0xE7,0xB1),      o2(0xF5,0xF0),
          o2(0xD8,0xDC),      o2(0xED,0xC6),
          o2(0xE1,0xB9),      o2(0xE3,0xC0),
          o2(0xF9,0xC0),      o2(0xE9,0xF0),
          o2(0xD9,0xDB),      o2(0xF3,0xE4),
          o2(0xDC,0xB6),      o2(0xE4,0xE9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_18 = {
    to_EUC_KR_E6_18_offsets,
    to_EUC_KR_E6_18_infos
};

static const unsigned char
to_EUC_KR_E6_19_offsets[64] = {
     27,  0,  1,  2,  3, 27, 27, 27,     27,  4, 27,  5, 27, 27, 27,  6,
     27, 27, 27, 27, 27, 27, 27, 27,     27,  7, 27,  8, 27,  9, 10, 11,
     27, 27, 27, 27, 12, 13, 14, 15,     16, 17, 27, 18, 27, 27, 19, 20,
     27, 27, 27, 21, 22, 27, 23, 24,     25, 27, 26, 27, 27, 27, 27, 27,
};

static const struct byte_lookup* const
to_EUC_KR_E6_19_infos[28] = {
          o2(0xF0,0xC5),      o2(0xE3,0xC1),
          o2(0xFC,0xCC),      o2(0xFC,0xCD),
          o2(0xF2,0xCB),      o2(0xF2,0xCC),
          o2(0xE4,0xCF),      o2(0xF1,0xDB),
          o2(0xFA,0xD9),      o2(0xF1,0xB8),
          o2(0xFD,0xF5),      o2(0xE0,0xF9),
          o2(0xE7,0xFB),      o2(0xFC,0xB7),
          o2(0xFC,0xE4),      o2(0xFB,0xC5),
          o2(0xE3,0xE7),      o2(0xD8,0xB9),
          o2(0xF6,0xF8),      o2(0xDC,0xC5),
          o2(0xCC,0xD8),      o2(0xE0,0xAF),
          o2(0xF4,0xE7),      o2(0xEF,0xDC),
          o2(0xCF,0xFC),      o2(0xEF,0xDD),
          o2(0xF2,0xAA),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_19 = {
    to_EUC_KR_E6_19_offsets,
    to_EUC_KR_E6_19_infos
};

static const unsigned char
to_EUC_KR_E6_1A_offsets[64] = {
     21, 21, 21, 21,  0, 21, 21,  1,      2,  3, 21, 21, 21, 21,  4, 21,
      5,  6, 21, 21, 21, 21,  7,  8,      9, 21, 21, 21, 21, 10, 21, 21,
     11, 21, 12, 21, 21, 21, 21, 21,     21, 21, 21, 13, 21, 21, 14, 21,
     21, 21, 15, 16, 17, 21, 21, 21,     21, 18, 21, 19, 21, 21, 20, 21,
};

static const struct byte_lookup* const
to_EUC_KR_E6_1A_infos[22] = {
          o2(0xFD,0xBE),      o2(0xCA,0xAC),
          o2(0xFD,0xBB),      o2(0xFD,0xC7),
          o2(0xE7,0xB2),      o2(0xEA,0xD1),
          o2(0xDF,0xF4),      o2(0xD1,0xEC),
          o2(0xE4,0xDE),      o2(0xE5,0xC3),
          o2(0xD9,0xA6),      o2(0xCD,0xBC),
          o2(0xF3,0xE5),      o2(0xED,0xD5),
          o2(0xD9,0xBA),      o2(0xED,0xE7),
          o2(0xFB,0xB5),      o2(0xF8,0xEC),
          o2(0xE0,0xE7),      o2(0xCC,0xD9),
          o2(0xD4,0xC6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_1A = {
    to_EUC_KR_E6_1A_offsets,
    to_EUC_KR_E6_1A_infos
};

static const unsigned char
to_EUC_KR_E6_1B_offsets[64] = {
     21, 21, 21, 21,  0, 21,  1,  2,     21,  3, 21, 21, 21, 21, 21, 21,
     21, 21, 21, 21, 21, 21,  4, 21,     21,  5, 21, 21,  6,  7, 21, 21,
      8, 21, 21, 21, 21, 21,  9, 21,     21, 21, 21, 21, 21, 21, 21, 21,
     10, 21, 11, 12, 13, 21, 21, 14,     15, 16, 17, 21, 18, 21, 19, 20,
};

static const struct byte_lookup* const
to_EUC_KR_E6_1B_infos[22] = {
          o2(0xE7,0xA5),      o2(0xD5,0xF5),
          o2(0xD3,0xBE),      o2(0xFC,0xFB),
          o2(0xE4,0xF2),      o2(0xDF,0xF5),
          o2(0xE8,0xF8),      o2(0xF8,0xED),
          o2(0xCE,0xC7),      o2(0xFD,0xF6),
          o2(0xE8,0xD8),      o2(0xCD,0xD8),
          o2(0xE7,0xD6),      o2(0xCC,0xDA),
          o2(0xCA,0xE3),      o2(0xDF,0xF6),
          o2(0xF0,0xC7),      o2(0xF0,0xC6),
          o2(0xD8,0xBA),      o2(0xF1,0xF4),
          o2(0xF4,0xF0),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_1B = {
    to_EUC_KR_E6_1B_offsets,
    to_EUC_KR_E6_1B_infos
};

static const unsigned char
to_EUC_KR_E6_1C_offsets[64] = {
      0, 26, 26,  1, 26, 26, 26, 26,      2,  3, 26,  4, 26,  5, 26, 26,
     26, 26, 26, 26,  6,  7, 26,  8,     26, 26, 26,  9, 26, 10, 11, 12,
     26, 26, 26, 26, 26, 26, 13, 14,     15, 26, 16, 17, 18, 19, 20, 26,
     26, 21, 26, 26, 22, 26, 23, 26,     26, 26, 24, 26, 26, 25, 26, 26,
};

static const struct byte_lookup* const
to_EUC_KR_E6_1C_infos[27] = {
          o2(0xF5,0xCC),      o2(0xFC,0xE5),
          o2(0xEA,0xC5),      o2(0xEA,0xF3),
          o2(0xDD,0xDB),      o2(0xDC,0xD7),
          o2(0xDE,0xFD),      o2(0xF2,0xF9),
          o2(0xD5,0xC7),      o2(0xD8,0xD0),
          o2(0xF0,0xC8),      o2(0xD1,0xA1),
          o2(0xD1,0xA2),      o2(0xD9,0xD4),
          o2(0xD6,0xE8),      o2(0xD9,0xCA),
          o2(0xDA,0xB1),      o2(0xD8,0xC7),
          o2(0xDC,0xE2),      o2(0xF3,0xCE),
          o2(0xF5,0xF4),      o2(0xF1,0xB9),
          o2(0xDA,0xD3),      o2(0xF6,0xEA),
          o2(0xCF,0xF5),      o2(0xFD,0xAE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_1C = {
    to_EUC_KR_E6_1C_offsets,
    to_EUC_KR_E6_1C_infos
};

static const unsigned char
to_EUC_KR_E6_1D_offsets[64] = {
     21, 21, 21, 21, 21, 21,  0, 21,     21,  1, 21, 21, 21, 21,  2,  3,
      4,  5, 21,  6, 21, 21,  7, 21,     21, 21, 21, 21,  8, 21,  9, 10,
     21, 21, 21, 21, 21, 21, 21, 21,     21, 21, 21, 21, 21, 11, 21, 12,
     13, 14, 21, 15, 21, 16, 21, 17,     21, 21, 21, 18, 21, 21, 19, 20,
};

static const struct byte_lookup* const
to_EUC_KR_E6_1D_infos[22] = {
          o2(0xCA,0xD2),      o2(0xDF,0xB4),
          o2(0xD7,0xDD),      o2(0xFA,0xBA),
          o2(0xEE,0xA7),      o2(0xF5,0xBD),
          o2(0xF8,0xF5),      o2(0xED,0xE8),
          o2(0xD4,0xE1),      o2(0xD1,0xA3),
          o2(0xE1,0xD6),      o2(0xF9,0xF8),
          o2(0xDB,0xCA),      o2(0xCB,0xF9),
          o2(0xD4,0xD4),      o2(0xD9,0xDC),
          o2(0xEE,0xBE),      o2(0xF7,0xED),
          o2(0xD2,0xEE),      o2(0xE1,0xE6),
          o2(0xF7,0xF9),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_1D = {
    to_EUC_KR_E6_1D_offsets,
    to_EUC_KR_E6_1D_infos
};

static const unsigned char
to_EUC_KR_E6_1E_offsets[64] = {
     18, 18, 18, 18, 18, 18, 18,  0,     18,  1, 18,  2, 18, 18, 18,  3,
      4, 18, 18,  5, 18,  6, 18,  7,     18, 18,  8, 18,  9, 10, 18, 18,
     18, 18, 18, 18, 18, 18, 18, 18,     18, 18, 18, 18, 18, 18, 18, 11,
     12, 18, 18, 13, 18, 18, 14, 15,     16, 18, 18, 18, 18, 18, 17, 18,
};

static const struct byte_lookup* const
to_EUC_KR_E6_1E_infos[19] = {
          o2(0xDD,0xED),      o2(0xE8,0xDB),
          o2(0xDB,0xB3),      o2(0xD1,0xF7),
          o2(0xE0,0xB0),      o2(0xD4,0xE2),
          o2(0xF6,0xD7),      o2(0xD7,0xF9),
          o2(0xD8,0xDD),      o2(0xCD,0xFD),
          o2(0xF2,0xAB),      o2(0xCD,0xBD),
          o2(0xF8,0xC2),      o2(0xF2,0xAC),
          o2(0xCA,0xAD),      o2(0xCA,0xAE),
          o2(0xCF,0xAE),      o2(0xE3,0xC2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_1E = {
    to_EUC_KR_E6_1E_offsets,
    to_EUC_KR_E6_1E_infos
};

static const unsigned char
to_EUC_KR_E6_1F_offsets[64] = {
     20, 20, 20, 20,  0, 20, 20, 20,     20, 20, 20, 20, 20, 20, 20,  1,
      2,  3,  4,  5,  6, 20, 20, 20,     20, 20,  7, 20, 20,  8, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20,     20,  9, 20, 20, 10, 20, 20, 11,
     12, 13, 20, 14, 15, 16, 17, 20,     20, 20, 20, 18, 20, 20, 19, 20,
};

static const struct byte_lookup* const
to_EUC_KR_E6_1F_infos[21] = {
          o2(0xDC,0xB7),      o2(0xDB,0xDA),
          o2(0xD9,0xBB),      o2(0xCA,0xF3),
          o2(0xF6,0xD3),      o2(0xE6,0xF8),
          o2(0xEA,0xF5),      o2(0xEA,0xF6),
          o2(0xF6,0xF9),      o2(0xCF,0xAF),
          o2(0xCA,0xD3),      o2(0xCA,0xAF),
          o2(0xD2,0xB0),      o2(0xF1,0xBA),
          o2(0xD7,0xB3),      o2(0xE3,0xC3),
          o2(0xF3,0xFD),      o2(0xDE,0xDA),
          o2(0xDE,0xDB),      o2(0xEF,0xDE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_1F = {
    to_EUC_KR_E6_1F_offsets,
    to_EUC_KR_E6_1F_infos
};

static const unsigned char
to_EUC_KR_E6_20_offsets[64] = {
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
     12, 12,  0,  1, 12, 12,  2,  3,     12, 12, 12, 12, 12, 12, 12, 12,
     12,  4,  5, 12, 12, 12, 12, 12,     12, 12,  6, 12, 12, 12, 12,  7,
     12, 12, 12, 12, 12, 12, 12, 12,      8,  9, 12, 12, 10, 11, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_E6_20_infos[13] = {
          o2(0xE2,0xE3),      o2(0xEE,0xFB),
          o2(0xDF,0xF7),      o2(0xD7,0xCA),
          o2(0xCE,0xE8),      o2(0xDB,0xDB),
          o2(0xF1,0xBB),      o2(0xE9,0xF1),
          o2(0xFA,0xB7),      o2(0xD0,0xC6),
          o2(0xCC,0xAB),      o2(0xEE,0xA8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_20 = {
    to_EUC_KR_E6_20_offsets,
    to_EUC_KR_E6_20_infos
};

static const unsigned char
to_EUC_KR_E6_21_offsets[64] = {
      0,  1,  2,  3, 13, 13, 13, 13,      4, 13, 13, 13, 13, 13,  5, 13,
      6,  7, 13,  8,  9, 13, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,     13, 13, 13, 13, 13, 10, 13, 13,
     13, 13, 13, 13, 13, 13, 11, 13,     13, 13, 13, 13, 13, 13, 13, 12,
};

static const struct byte_lookup* const
to_EUC_KR_E6_21_infos[14] = {
          o2(0xCB,0xFA),      o2(0xF9,0xF9),
          o2(0xCC,0xFD),      o2(0xD3,0xFE),
          o2(0xE4,0xD0),      o2(0xF2,0xEE),
          o2(0xD4,0xD5),      o2(0xDF,0xCD),
          o2(0xFC,0xB8),      o2(0xD1,0xD0),
          o2(0xF2,0xCD),      o2(0xF7,0xD2),
          o2(0xCA,0xD4),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_21 = {
    to_EUC_KR_E6_21_offsets,
    to_EUC_KR_E6_21_infos
};

static const unsigned char
to_EUC_KR_E6_22_offsets[64] = {
     19,  0, 19, 19, 19,  1, 19, 19,     19, 19, 19, 19, 19, 19, 19,  2,
     19, 19, 19,  3,  4, 19, 19,  5,     19, 19, 19, 19, 19,  6, 19,  7,
     19,  8,  9, 19, 19, 19, 19, 10,     11, 19, 19, 19, 19, 12, 19, 13,
     14, 15, 19, 16, 19, 17, 18, 19,     19, 19, 19, 19, 19, 19, 19, 19,
};

static const struct byte_lookup* const
to_EUC_KR_E6_22_infos[20] = {
          o2(0xD5,0xD9),      o2(0xD8,0xDE),
          o2(0xCD,0xD9),      o2(0xEE,0xA9),
          o2(0xF6,0xBC),      o2(0xCC,0xDB),
          o2(0xF0,0xC9),      o2(0xFC,0xFC),
          o2(0xE8,0xC9),      o2(0xF4,0xFE),
          o2(0xE7,0xFC),      o2(0xD7,0xDE),
          o2(0xDE,0xDC),      o2(0xF0,0xAC),
          o2(0xCC,0xFE),      o2(0xCD,0xE1),
          o2(0xE1,0xBA),      o2(0xDB,0xEF),
          o2(0xDA,0xB2),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_22 = {
    to_EUC_KR_E6_22_offsets,
    to_EUC_KR_E6_22_infos
};

static const unsigned char
to_EUC_KR_E6_23_offsets[64] = {
     18, 18, 18, 18,  0,  1, 18, 18,     18,  2, 18,  3, 18,  4, 18, 18,
     18, 18,  5, 18, 18,  6, 18,  7,      8, 18,  9, 18, 18, 18, 18, 10,
     11, 18, 18, 18, 18, 18, 18, 12,     13, 18, 18, 18, 18, 18, 14, 18,
     18, 18, 15, 18, 18, 18, 18, 18,     18, 16, 17, 18, 18, 18, 18, 18,
};

static const struct byte_lookup* const
to_EUC_KR_E6_23_infos[19] = {
          o2(0xD1,0xA5),      o2(0xDC,0xB8),
          o2(0xD8,0xF6),      o2(0xD1,0xA4),
          o2(0xCD,0xE2),      o2(0xDC,0xEA),
          o2(0xF0,0xF7),      o2(0xF0,0xCA),
          o2(0xD0,0xBE),      o2(0xDD,0xDC),
          o2(0xD4,0xD6),      o2(0xD3,0xD6),
          o2(0xED,0xD0),      o2(0xCD,0xA1),
          o2(0xDF,0xB5),      o2(0xDF,0xF8),
          o2(0xD4,0xA1),      o2(0xCE,0xB2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_23 = {
    to_EUC_KR_E6_23_offsets,
    to_EUC_KR_E6_23_infos
};

static const unsigned char
to_EUC_KR_E6_24_offsets[64] = {
      0,  9,  9,  9,  9,  1,  9,  9,      9,  9,  9,  9,  9,  2,  3,  9,
      9,  9,  4,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  5,      9,  9,  9,  9,  9,  9,  9,  9,
      6,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  7,  9,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E6_24_infos[10] = {
          o2(0xE8,0xCA),      o2(0xEB,0xF5),
          o2(0xE3,0xD5),      o2(0xF5,0xD0),
          o2(0xF5,0xA1),      o2(0xD9,0xA7),
          o2(0xE5,0xAB),      o2(0xE6,0xCB),
          o2(0xF5,0xF1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_24 = {
    to_EUC_KR_E6_24_offsets,
    to_EUC_KR_E6_24_infos
};

static const unsigned char
to_EUC_KR_E6_25_offsets[64] = {
     21, 21, 21, 21, 21, 21, 21, 21,     21, 21,  0, 21, 21, 21, 21, 21,
     21, 21, 21,  1,  2,  3, 21,  4,     21,  5,  6, 21, 21, 21,  7, 21,
      8,  9, 10, 11, 21, 21, 21, 21,     12, 21, 21, 13, 21, 14, 15, 16,
     21, 21, 21, 21, 21, 17, 21, 18,     19, 20, 21, 21, 21, 21, 21, 21,
};

static const struct byte_lookup* const
to_EUC_KR_E6_25_infos[22] = {
          o2(0xE5,0xC5),      o2(0xF9,0xA3),
          o2(0xE0,0xDB),      o2(0xF6,0xEB),
          o2(0xCB,0xF1),      o2(0xD9,0xEA),
          o2(0xF5,0xA2),      o2(0xD7,0xD1),
          o2(0xD1,0xF8),      o2(0xEA,0xF8),
          o2(0xEA,0xF9),      o2(0xDA,0xB3),
          o2(0xEF,0xDF),      o2(0xF1,0xEF),
          o2(0xE5,0xF6),      o2(0xEE,0xBF),
          o2(0xE2,0xE4),      o2(0xD0,0xBF),
          o2(0xFA,0xAC),      o2(0xF5,0xD1),
          o2(0xE7,0xB3),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_25 = {
    to_EUC_KR_E6_25_offsets,
    to_EUC_KR_E6_25_infos
};

static const unsigned char
to_EUC_KR_E6_26_offsets[64] = {
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  0,  8,  8,      8,  8,  8,  1,  2,  8,  8,  8,
      8,  8,  8,  8,  8,  3,  8,  4,      8,  8,  8,  8,  8,  8,  5,  8,
      8,  8,  8,  8,  6,  8,  8,  8,      8,  8,  8,  7,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E6_26_infos[9] = {
          o2(0xE9,0xBE),      o2(0xF2,0xCE),
          o2(0xDB,0xB4),      o2(0xFC,0xCE),
          o2(0xDD,0xEE),      o2(0xE7,0xB4),
          o2(0xD7,0xB4),      o2(0xF7,0xB4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_26 = {
    to_EUC_KR_E6_26_offsets,
    to_EUC_KR_E6_26_infos
};

static const unsigned char
to_EUC_KR_E6_27_offsets[64] = {
     11,  0, 11,  1, 11, 11, 11, 11,     11, 11, 11,  2,  3,  4, 11, 11,
      5, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,      6, 11,  7, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11,  8, 11,  9, 11, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E6_27_infos[12] = {
          o2(0xCD,0xBE),      o2(0xDA,0xE9),
          o2(0xCF,0xB0),      o2(0xF7,0xD9),
          o2(0xF3,0xE6),      o2(0xCE,0xD9),
          o2(0xCE,0xAA),      o2(0xCB,0xC8),
          o2(0xD0,0xA7),      o2(0xF0,0xCB),
          o2(0xD0,0xC7),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_27 = {
    to_EUC_KR_E6_27_offsets,
    to_EUC_KR_E6_27_infos
};

static const unsigned char
to_EUC_KR_E6_28_offsets[64] = {
     15, 15,  0, 15, 15, 15, 15, 15,     15, 15,  1, 15, 15, 15, 15, 15,
     15,  2, 15,  3, 15, 15, 15,  4,     15,  5, 15, 15, 15, 15,  6,  7,
     15,  8, 15,  9, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 10, 15, 15,     11, 12, 13, 15, 15, 14, 15, 15,
};

static const struct byte_lookup* const
to_EUC_KR_E6_28_infos[16] = {
          o2(0xE4,0xC5),      o2(0xDB,0xE0),
          o2(0xD5,0xDA),      o2(0xD7,0xA7),
          o2(0xEE,0xC0),      o2(0xF8,0xF6),
          o2(0xF5,0xD2),      o2(0xED,0xE9),
          o2(0xD9,0xBC),      o2(0xE5,0xC6),
          o2(0xF5,0xA3),      o2(0xDA,0xD4),
          o2(0xE2,0xA7),      o2(0xFB,0xFC),
          o2(0xF1,0xDC),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_28 = {
    to_EUC_KR_E6_28_offsets,
    to_EUC_KR_E6_28_infos
};

static const unsigned char
to_EUC_KR_E6_29_offsets[64] = {
     10, 10, 10, 10,  0, 10, 10, 10,      1, 10, 10,  2, 10, 10, 10, 10,
     10, 10,  3,  4, 10, 10, 10, 10,      5,  6, 10, 10, 10, 10, 10,  7,
     10,  8, 10, 10, 10, 10, 10, 10,     10, 10, 10,  9, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E6_29_infos[11] = {
          o2(0xCA,0xF4),      o2(0xE8,0xFA),
          o2(0xCE,0xE9),      o2(0xE9,0xF8),
          o2(0xE2,0xE5),      o2(0xD0,0xB9),
          o2(0xD4,0xF2),      o2(0xD1,0xA6),
          o2(0xDF,0xCE),      o2(0xFC,0xF4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_29 = {
    to_EUC_KR_E6_29_offsets,
    to_EUC_KR_E6_29_infos
};

static const unsigned char
to_EUC_KR_E6_2A_offsets[64] = {
      0, 11, 11, 11,  1, 11, 11, 11,     11,  2, 11, 11, 11,  3,  4, 11,
     11, 11, 11, 11, 11, 11, 11,  5,     11, 11, 11, 11,  6, 11, 11, 11,
     11, 11,  7,  8, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11,  9, 11, 11, 11, 11,     11, 11, 11, 10, 11, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_E6_2A_infos[12] = {
          o2(0xD3,0xAA),      o2(0xCC,0xAC),
          o2(0xEF,0xE0),      o2(0xE5,0xE5),
          o2(0xD0,0xD5),      o2(0xDB,0xFC),
          o2(0xFC,0xE6),      o2(0xCB,0xFE),
          o2(0xED,0xEA),      o2(0xDE,0xB1),
          o2(0xF9,0xE3),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_2A = {
    to_EUC_KR_E6_2A_offsets,
    to_EUC_KR_E6_2A_infos
};

static const unsigned char
to_EUC_KR_E6_2B_offsets[64] = {
      7,  7,  0,  1,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  2,  7,  7,  7,  7,      7,  7,  3,  4,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  5,  7,      7,  7,  7,  6,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_E6_2B_infos[8] = {
          o2(0xD4,0xA2),      o2(0xCF,0xF6),
          o2(0xD6,0xD0),      o2(0xD5,0xEA),
          o2(0xF1,0xEE),      o2(0xFA,0xCB),
          o2(0xE5,0xA1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_2B = {
    to_EUC_KR_E6_2B_offsets,
    to_EUC_KR_E6_2B_infos
};

static const unsigned char
to_EUC_KR_E6_2C_offsets[64] = {
     12, 12, 12, 12,  0, 12, 12, 12,     12, 12,  1, 12,  2, 12, 12, 12,
     12, 12,  3, 12, 12, 12,  4, 12,     12, 12, 12, 12, 12, 12, 12, 12,
      5,  6, 12,  7, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
     12, 12,  8, 12, 12, 12, 12, 12,     12, 12,  9, 12, 12, 10, 11, 12,
};

static const struct byte_lookup* const
to_EUC_KR_E6_2C_infos[13] = {
          o2(0xD5,0xB1),      o2(0xCF,0xED),
          o2(0xED,0xEB),      o2(0xD5,0xB2),
          o2(0xD5,0xBC),      o2(0xFD,0xE2),
          o2(0xF3,0xAD),      o2(0xFD,0xDB),
          o2(0xE9,0xB0),      o2(0xD1,0xA7),
          o2(0xFD,0xE3),      o2(0xCE,0xB3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_2C = {
    to_EUC_KR_E6_2C_offsets,
    to_EUC_KR_E6_2C_infos
};

static const unsigned char
to_EUC_KR_E6_2D_offsets[64] = {
     18, 18, 18, 18, 18, 18,  0,  1,     18, 18, 18, 18,  2, 18,  3, 18,
      4, 18, 18, 18, 18, 18, 18, 18,     18, 18, 18, 18, 18, 18, 18,  5,
     18,  6,  7,  8,  9, 10, 11, 18,     18, 18, 12, 18, 18, 18, 18, 18,
     18, 18, 13, 18, 18, 18, 18, 14,     15, 18, 18, 16, 18, 18, 18, 17,
};

static const struct byte_lookup* const
to_EUC_KR_E6_2D_infos[19] = {
          o2(0xFD,0xE4),      o2(0xFA,0xCE),
          o2(0xCA,0xB0),      o2(0xF7,0xA7),
          o2(0xCF,0xB1),      o2(0xE6,0xA2),
          o2(0xFC,0xB6),      o2(0xF2,0xAD),
          o2(0xEF,0xE1),      o2(0xF3,0xAE),
          o2(0xDC,0xC6),      o2(0xD9,0xEB),
          o2(0xE8,0xE0),      o2(0xE1,0xA8),
          o2(0xD5,0xF6),      o2(0xCF,0xFD),
          o2(0xDE,0xDD),      o2(0xD9,0xD1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_2D = {
    to_EUC_KR_E6_2D_offsets,
    to_EUC_KR_E6_2D_infos
};

static const unsigned char
to_EUC_KR_E6_2E_offsets[64] = {
     16, 16, 16,  0,  1, 16,  2, 16,     16,  3,  4, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16,  5, 16,      6, 16, 16, 16, 16, 16,  7, 16,
     16, 16, 16, 16, 16, 16, 16, 16,     16, 16, 16, 16, 16, 16,  8,  9,
     16, 16, 10, 16, 16, 11, 16, 12,     16, 16, 13, 16, 14, 16, 16, 15,
};

static const struct byte_lookup* const
to_EUC_KR_E6_2E_infos[17] = {
          o2(0xE4,0xEA),      o2(0xF2,0xCF),
          o2(0xF7,0xBF),      o2(0xE2,0xE6),
          o2(0xE2,0xA8),      o2(0xE3,0xD6),
          o2(0xED,0xD1),      o2(0xE9,0xF9),
          o2(0xD6,0xB1),      o2(0xDE,0xB2),
          o2(0xE0,0xE8),      o2(0xD3,0xAB),
          o2(0xEB,0xDC),      o2(0xDF,0xAF),
          o2(0xCA,0xC3),      o2(0xEE,0xFC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_2E = {
    to_EUC_KR_E6_2E_offsets,
    to_EUC_KR_E6_2E_infos
};

static const unsigned char
to_EUC_KR_E6_2F_offsets[64] = {
     15,  0, 15, 15, 15,  1,  2, 15,     15, 15, 15,  3, 15,  4, 15,  5,
     15, 15,  6,  7,  8, 15,  9, 10,     11, 15, 15, 12, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 13, 14, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
};

static const struct byte_lookup* const
to_EUC_KR_E6_2F_infos[16] = {
          o2(0xFD,0xC3),      o2(0xEB,0xF6),
          o2(0xCF,0xB2),      o2(0xD9,0xEC),
          o2(0xD9,0xBD),      o2(0xD8,0xDF),
          o2(0xD4,0xB8),      o2(0xEB,0xBE),
          o2(0xDD,0xEF),      o2(0xDD,0xF0),
          o2(0xDD,0xF1),      o2(0xDD,0xF2),
          o2(0xD9,0xBE),      o2(0xFB,0xC6),
          o2(0xCF,0xB3),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_2F = {
    to_EUC_KR_E6_2F_offsets,
    to_EUC_KR_E6_2F_infos
};

static const unsigned char
to_EUC_KR_E6_30_offsets[64] = {
      9,  9,  9,  9,  9,  9,  9,  9,      0,  9,  9,  9,  9,  9,  9,  1,
      9,  2,  9,  3,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  4,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  5,  9,  9,  6,      7,  9,  9,  9,  9,  9,  8,  9,
};

static const struct byte_lookup* const
to_EUC_KR_E6_30_infos[10] = {
          o2(0xEE,0xFD),      o2(0xE4,0xAB),
          o2(0xDA,0xC5),      o2(0xD8,0xEC),
          o2(0xD1,0xA8),      o2(0xE2,0xA9),
          o2(0xDE,0xBC),      o2(0xE7,0xB5),
          o2(0xDB,0xF0),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_30 = {
    to_EUC_KR_E6_30_offsets,
    to_EUC_KR_E6_30_infos
};

static const unsigned char
to_EUC_KR_E6_31_offsets[64] = {
      0,  1,  2, 21, 21, 21, 21, 21,     21, 21, 21, 21, 21, 21,  3, 21,
      4, 21, 21, 21, 21,  5, 21,  6,     21, 21,  7, 21, 21,  8,  9, 10,
     11, 21, 21, 21, 21, 21, 21, 21,     12, 21, 13, 21, 21, 14, 21, 21,
     15, 21, 16, 21, 21, 21, 17, 21,     21, 21, 18, 21, 21, 19, 20, 21,
};

static const struct byte_lookup* const
to_EUC_KR_E6_31_infos[22] = {
          o2(0xEF,0xE2),      o2(0xF1,0xF0),
          o2(0xCF,0xB4),      o2(0xDB,0xF1),
          o2(0xE0,0xB1),      o2(0xDF,0xA5),
          o2(0xF9,0xD2),      o2(0xE7,0xFD),
          o2(0xE6,0xA3),      o2(0xFB,0xF1),
          o2(0xCB,0xB0),      o2(0xF2,0xAE),
          o2(0xCD,0xE7),      o2(0xE8,0xDC),
          o2(0xE7,0xD7),      o2(0xF7,0xC0),
          o2(0xD0,0xE3),      o2(0xDA,0xA1),
          o2(0xCC,0xBD),      o2(0xD1,0xA9),
          o2(0xDD,0xCC),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_31 = {
    to_EUC_KR_E6_31_offsets,
    to_EUC_KR_E6_31_infos
};

static const unsigned char
to_EUC_KR_E6_32_offsets[64] = {
     27,  0,  1,  2, 27,  3,  4,  5,      6, 27, 27, 27,  7, 27, 27, 27,
      8, 27,  9, 10, 11, 12, 13, 27,     27, 14, 15, 16, 27, 27, 27, 27,
     27, 27, 27, 27, 27, 27, 27, 27,     27, 27, 27, 17, 27, 27, 18, 27,
     27, 27, 27, 19, 27, 27, 27, 27,     20, 21, 27, 22, 23, 24, 25, 26,
};

static const struct byte_lookup* const
to_EUC_KR_E6_32_infos[28] = {
          o2(0xE3,0xFE),      o2(0xD1,0xAA),
          o2(0xE8,0xAA),      o2(0xEA,0xB6),
          o2(0xF9,0xFA),      o2(0xE6,0xCC),
          o2(0xF6,0xD8),      o2(0xD4,0xC7),
          o2(0xD9,0xCB),      o2(0xD9,0xD2),
          o2(0xD3,0xCB),      o2(0xD8,0xF7),
          o2(0xDA,0xA9),      o2(0xF5,0xF8),
          o2(0xDE,0xDE),      o2(0xF2,0xAF),
          o2(0xF8,0xA9),      o2(0xD8,0xC8),
          o2(0xEE,0xC1),      o2(0xF9,0xC1),
          o2(0xDD,0xF3),      o2(0xEA,0xFA),
          o2(0xF6,0xBD),      o2(0xE1,0xBB),
          o2(0xCD,0xBF),      o2(0xF4,0xD4),
          o2(0xE6,0xCD),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_32 = {
    to_EUC_KR_E6_32_offsets,
    to_EUC_KR_E6_32_infos
};

static const unsigned char
to_EUC_KR_E6_33_offsets[64] = {
     20,  0,  1, 20,  2, 20, 20, 20,     20,  3,  4, 20,  5, 20, 20, 20,
     20, 20, 20,  6, 20,  7, 20,  8,     20, 20, 20,  9, 20, 20, 20, 20,
     20, 10, 11, 12, 20, 13, 20, 20,     14, 20, 20, 15, 20, 20, 16, 17,
     18, 20, 20, 19, 20, 20, 20, 20,     20, 20, 20, 20, 20, 20, 20, 20,
};

static const struct byte_lookup* const
to_EUC_KR_E6_33_infos[21] = {
          o2(0xFC,0xCF),      o2(0xFB,0xA2),
          o2(0xE0,0xDC),      o2(0xF4,0xBB),
          o2(0xDA,0xD5),      o2(0xF9,0xB2),
          o2(0xFB,0xF2),      o2(0xDB,0xF6),
          o2(0xDE,0xDF),      o2(0xDB,0xF2),
          o2(0xF8,0xDC),      o2(0xF7,0xEE),
          o2(0xEB,0xE8),      o2(0xD2,0xFA),
          o2(0xF1,0xBC),      o2(0xFA,0xDA),
          o2(0xDA,0xEA),      o2(0xDA,0xC6),
          o2(0xF7,0xC1),      o2(0xE7,0xB6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_33 = {
    to_EUC_KR_E6_33_offsets,
    to_EUC_KR_E6_33_infos
};

static const unsigned char
to_EUC_KR_E6_34_offsets[64] = {
     19, 19, 19, 19, 19, 19, 19, 19,     19, 19, 19,  0,  1, 19, 19, 19,
     19,  2, 19, 19, 19, 19, 19,  3,     19,  4, 19,  5, 19, 19,  6, 19,
     19, 19, 19, 19, 19,  7, 19,  8,     19,  9, 10, 19, 19, 19, 19, 19,
     19, 19, 11, 19, 19, 12, 13, 19,     14, 15, 19, 16, 19, 17, 18, 19,
};

static const struct byte_lookup* const
to_EUC_KR_E6_34_infos[20] = {
          o2(0xE5,0xC7),      o2(0xD6,0xAC),
          o2(0xDC,0xC7),      o2(0xE1,0xA9),
          o2(0xE2,0xAA),      o2(0xD5,0xA6),
          o2(0xD4,0xD7),      o2(0xF2,0xD0),
          o2(0xEA,0xFB),      o2(0xE0,0xDD),
          o2(0xFB,0xF3),      o2(0xF1,0xBD),
          o2(0xE2,0xE7),      o2(0xFD,0xD7),
          o2(0xCE,0xC8),      o2(0xEA,0xB7),
          o2(0xFC,0xC0),      o2(0xFD,0xE7),
          o2(0xF7,0xEF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_34 = {
    to_EUC_KR_E6_34_offsets,
    to_EUC_KR_E6_34_infos
};

static const unsigned char
to_EUC_KR_E6_35_offsets[64] = {
     15,  0, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,     15,  1,  2, 15,  3, 15, 15, 15,
     15, 15, 15,  4, 15, 15,  5, 15,     15,  6,  7, 15,  8, 15,  9, 15,
     15, 15, 15, 15, 10, 15, 15, 11,     12, 13, 15, 15, 15, 15, 15, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E6_35_infos[16] = {
          o2(0xD7,0xB5),      o2(0xEF,0xBA),
          o2(0xF1,0xDD),      o2(0xDE,0xB3),
          o2(0xE8,0xCB),      o2(0xF8,0xDD),
          o2(0xFB,0xC7),      o2(0xD5,0xC8),
          o2(0xD7,0xDF),      o2(0xDD,0xA9),
          o2(0xE9,0xB1),      o2(0xFA,0xAD),
          o2(0xF6,0xD9),      o2(0xFA,0xF4),
          o2(0xF8,0xAA),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_35 = {
    to_EUC_KR_E6_35_offsets,
    to_EUC_KR_E6_35_infos
};

static const unsigned char
to_EUC_KR_E6_36_offsets[64] = {
     13, 13, 13, 13, 13,  0, 13,  1,      2,  3, 13, 13,  4,  5,  6, 13,
     13,  7, 13,  8, 13,  9, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,     13, 13, 13, 13, 13, 13, 13, 10,
     13, 13, 11, 13, 13, 12, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E6_36_infos[14] = {
          o2(0xE6,0xEE),      o2(0xCC,0xDC),
          o2(0xE1,0xBC),      o2(0xE0,0xEF),
          o2(0xE9,0xBF),      o2(0xFC,0xFD),
          o2(0xE6,0xCE),      o2(0xE1,0xD7),
          o2(0xE6,0xCF),      o2(0xF4,0xF1),
          o2(0xE4,0xF3),      o2(0xE4,0xFB),
          o2(0xF9,0xE4),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_36 = {
    to_EUC_KR_E6_36_offsets,
    to_EUC_KR_E6_36_infos
};

static const unsigned char
to_EUC_KR_E6_37_offsets[64] = {
      0, 26, 26,  1,  2,  3,  4,  5,     26, 26, 26,  6, 26, 26, 26,  7,
     26,  8, 26, 26, 26, 26, 26, 26,      9, 10, 11, 26, 26, 26, 12, 26,
     26, 13, 26, 26, 26, 26, 26, 26,     14, 26, 15, 16, 26, 26, 17, 26,
     26, 18, 26, 19, 26, 20, 26, 21,     22, 23, 24, 25, 26, 26, 26, 26,
};

static const struct byte_lookup* const
to_EUC_KR_E6_37_infos[27] = {
          o2(0xEF,0xE3),      o2(0xCF,0xEE),
          o2(0xF6,0xBE),      o2(0xE0,0xB2),
          o2(0xFC,0xFE),      o2(0xD1,0xAB),
          o2(0xD7,0xFA),      o2(0xFB,0xC8),
          o2(0xE2,0xD7),      o2(0xD4,0xA3),
          o2(0xF0,0xF8),      o2(0xD7,0xA8),
          o2(0xE1,0xE7),      o2(0xD3,0xBF),
          o2(0xEF,0xE4),      o2(0xD7,0xC5),
          o2(0xEB,0xE2),      o2(0xFC,0xE7),
          o2(0xE4,0xA2),      o2(0xE2,0xE8),
          o2(0xE6,0xD0),      o2(0xFB,0xE8),
          o2(0xF4,0xE8),      o2(0xE5,0xF4),
          o2(0xF4,0xBC),      o2(0xF4,0xD5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_37 = {
    to_EUC_KR_E6_37_offsets,
    to_EUC_KR_E6_37_infos
};

static const unsigned char
to_EUC_KR_E6_38_offsets[64] = {
     23, 23, 23, 23, 23, 23, 23, 23,     23, 23, 23, 23, 23, 23, 23, 23,
     23, 23, 23, 23, 23, 23, 23,  0,     23,  1,  2,  3, 23, 23, 23,  4,
      5,  6, 23,  7,  8,  9, 10, 23,     23, 23, 23, 11, 12, 13, 23, 14,
     23, 23, 15, 23, 16, 23, 17, 23,     18, 23, 19, 23, 20, 21, 22, 23,
};

static const struct byte_lookup* const
to_EUC_KR_E6_38_infos[24] = {
          o2(0xDF,0xB6),      o2(0xFC,0xB9),
          o2(0xEE,0xC2),      o2(0xCA,0xF5),
          o2(0xEF,0xE5),      o2(0xCB,0xE2),
          o2(0xD4,0xA4),      o2(0xDE,0xE0),
          o2(0xDA,0xFD),      o2(0xE4,0xC6),
          o2(0xE8,0xBE),      o2(0xE0,0xDE),
          o2(0xF6,0xB4),      o2(0xEA,0xD2),
          o2(0xF9,0xFB),      o2(0xE0,0xC2),
          o2(0xCA,0xE4),      o2(0xE7,0xB7),
          o2(0xEA,0xFD),      o2(0xD9,0xDD),
          o2(0xDA,0xB4),      o2(0xEE,0xAA),
          o2(0xFB,0xE9),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_38 = {
    to_EUC_KR_E6_38_offsets,
    to_EUC_KR_E6_38_infos
};

static const unsigned char
to_EUC_KR_E6_39_offsets[64] = {
     17, 17, 17,  0,  1, 17, 17, 17,     17, 17,  2, 17, 17,  3, 17, 17,
     17, 17, 17, 17, 17, 17,  4, 17,      5, 17, 17,  6,  7, 17,  8,  9,
     17, 17, 17, 17, 17, 17, 17, 10,     17, 17, 17, 11, 17, 17, 12, 13,
     17, 17, 14, 15, 17, 17, 17, 17,     17, 17, 16, 17, 17, 17, 17, 17,
};

static const struct byte_lookup* const
to_EUC_KR_E6_39_infos[18] = {
          o2(0xDB,0xCB),      o2(0xDA,0xB5),
          o2(0xF1,0xBE),      o2(0xD3,0xAC),
          o2(0xFB,0xC9),      o2(0xDF,0xCF),
          o2(0xD3,0xC0),      o2(0xE3,0xD7),
          o2(0xEF,0xE6),      o2(0xFC,0xD0),
          o2(0xE9,0xC0),      o2(0xF5,0xD3),
          o2(0xEC,0xDC),      o2(0xF7,0xB7),
          o2(0xEA,0xB8),      o2(0xD1,0xF9),
          o2(0xDC,0xC8),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_39 = {
    to_EUC_KR_E6_39_offsets,
    to_EUC_KR_E6_39_infos
};

static const unsigned char
to_EUC_KR_E6_3A_offsets[64] = {
     13, 13, 13, 13, 13, 13, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
      0, 13, 13, 13, 13, 13,  1, 13,     13, 13, 13, 13,  2,  3, 13,  4,
     13, 13,  5, 13, 13,  6, 13, 13,     13, 13,  7,  8, 13, 13, 13,  9,
     13, 10, 13, 13, 13, 13, 11, 13,     13, 13, 12, 13, 13, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E6_3A_infos[14] = {
          o2(0xEA,0xB9),      o2(0xF1,0xDE),
          o2(0xD7,0xB6),      o2(0xCF,0xB5),
          o2(0xD9,0xA8),      o2(0xEC,0xEE),
          o2(0xDD,0xAA),      o2(0xCD,0xA2),
          o2(0xE8,0xAE),      o2(0xE1,0xBD),
          o2(0xF2,0xD1),      o2(0xE9,0xC1),
          o2(0xD2,0xFC),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_3A = {
    to_EUC_KR_E6_3A_offsets,
    to_EUC_KR_E6_3A_infos
};

static const unsigned char
to_EUC_KR_E6_3B_offsets[64] = {
     15, 15,  0, 15,  1,  2, 15, 15,     15,  3, 15,  4,  5, 15,  6, 15,
     15,  7, 15,  8,  9, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 10,
     15, 15, 15, 15, 11, 15, 15, 15,     12, 15, 15, 15, 15, 15, 13, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E6_3B_infos[16] = {
          o2(0xDB,0xB5),      o2(0xF3,0xE7),
          o2(0xD8,0xFE),      o2(0xFC,0xD1),
          o2(0xED,0xB2),      o2(0xF4,0xAF),
          o2(0xFB,0xA3),      o2(0xFC,0xC1),
          o2(0xEE,0xAB),      o2(0xD4,0xA5),
          o2(0xF4,0xF2),      o2(0xEE,0xD9),
          o2(0xFB,0xCA),      o2(0xCD,0xE3),
          o2(0xD8,0xBB),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_3B = {
    to_EUC_KR_E6_3B_offsets,
    to_EUC_KR_E6_3B_infos
};

static const unsigned char
to_EUC_KR_E6_3C_offsets[64] = {
     16,  0,  1, 16, 16, 16,  2, 16,     16, 16, 16, 16, 16, 16, 16,  3,
     16,  4, 16, 16,  5,  6, 16, 16,     16, 16, 16, 16, 16, 16, 16, 16,
      7, 16,  8,  9, 16, 16, 16, 16,     16, 16, 16, 10, 11, 16, 16, 16,
     16, 12, 13, 16, 16, 16, 16, 16,     14, 16, 16, 16, 16, 16, 16, 15,
};

static const struct byte_lookup* const
to_EUC_KR_E6_3C_infos[17] = {
          o2(0xE5,0xDB),      o2(0xF8,0xF7),
          o2(0xF6,0xD4),      o2(0xD7,0xA9),
          o2(0xCB,0xC9),      o2(0xE6,0xD1),
          o2(0xF0,0xCC),      o2(0xD8,0xAE),
          o2(0xF9,0xD3),      o2(0xD5,0xFE),
          o2(0xD8,0xBC),      o2(0xF2,0xB0),
          o2(0xE2,0xAB),      o2(0xF3,0xE8),
          o2(0xEF,0xC2),      o2(0xED,0xEC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_3C = {
    to_EUC_KR_E6_3C_offsets,
    to_EUC_KR_E6_3C_infos
};

static const unsigned char
to_EUC_KR_E6_3D_offsets[64] = {
     18,  0, 18, 18, 18, 18, 18, 18,     18, 18, 18, 18, 18, 18, 18, 18,
     18,  1, 18, 18,  2, 18, 18,  3,      4, 18,  5,  6, 18, 18,  7,  8,
     18, 18,  9, 18, 10, 18, 18, 18,     18, 18, 18, 18, 18, 11, 12, 18,
     13, 18, 18, 18, 18, 18, 18, 18,     18, 18, 14, 18, 15, 16, 17, 18,
};

static const struct byte_lookup* const
to_EUC_KR_E6_3D_infos[19] = {
          o2(0xE7,0xB8),      o2(0xDA,0xFE),
          o2(0xCC,0xBE),      o2(0xF2,0xFC),
          o2(0xDA,0xEB),      o2(0xE2,0xD8),
          o2(0xED,0xD6),      o2(0xD6,0xD1),
          o2(0xE0,0xB3),      o2(0xFC,0xD2),
          o2(0xEB,0xC8),      o2(0xD3,0xC1),
          o2(0xF0,0xCD),      o2(0xCF,0xF7),
          o2(0xED,0xD2),      o2(0xD4,0xD8),
          o2(0xDC,0xC9),      o2(0xD7,0xF1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_3D = {
    to_EUC_KR_E6_3D_offsets,
    to_EUC_KR_E6_3D_infos
};

static const unsigned char
to_EUC_KR_E6_3E_offsets[64] = {
     17,  0, 17, 17,  1, 17, 17, 17,      2, 17, 17, 17, 17,  3,  4, 17,
      5, 17, 17, 17,  6, 17, 17,  7,     17, 17, 17, 17, 17, 17, 17, 17,
     17, 17, 17,  8,  9, 17, 17, 10,     17, 17, 17, 17, 17, 17, 11, 12,
     17, 13, 17, 14, 17, 17, 17, 17,     17, 15, 17, 17, 17, 17, 16, 17,
};

static const struct byte_lookup* const
to_EUC_KR_E6_3E_infos[18] = {
          o2(0xDF,0xBB),      o2(0xF3,0xA5),
          o2(0xF4,0xCD),      o2(0xF1,0xBF),
          o2(0xF8,0xB1),      o2(0xE9,0xFA),
          o2(0xFB,0xCB),      o2(0xCA,0xD5),
          o2(0xF9,0xD4),      o2(0xF7,0xCA),
          o2(0xD6,0xC8),      o2(0xFC,0xE8),
          o2(0xF3,0xBD),      o2(0xEE,0xFE),
          o2(0xE7,0xFE),      o2(0xD3,0xC2),
          o2(0xD3,0xB6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_3E = {
    to_EUC_KR_E6_3E_offsets,
    to_EUC_KR_E6_3E_infos
};

static const unsigned char
to_EUC_KR_E6_3F_offsets[64] = {
      0,  1,  2,  3, 17, 17, 17, 17,     17, 17,  4, 17, 17, 17, 17, 17,
     17, 17, 17, 17, 17,  5, 17, 17,     17, 17,  6, 17, 17, 17, 17,  7,
      8,  9, 17, 17, 10, 17, 17, 17,     17, 11, 17, 12, 13, 17, 17, 14,
     17, 15, 17, 17, 17, 17, 17, 17,     17, 17, 17, 17, 17, 17, 16, 17,
};

static const struct byte_lookup* const
to_EUC_KR_E6_3F_infos[18] = {
          o2(0xCC,0xAD),      o2(0xF6,0xFA),
          o2(0xD6,0xB2),      o2(0xD2,0xD8),
          o2(0xE7,0xD8),      o2(0xE3,0xA5),
          o2(0xE7,0xB9),      o2(0xF0,0xAD),
          o2(0xFB,0xCC),      o2(0xEB,0xA1),
          o2(0xD4,0xA6),      o2(0xFB,0xCD),
          o2(0xD5,0xBD),      o2(0xF1,0xDF),
          o2(0xF6,0xFB),      o2(0xDE,0xB4),
          o2(0xD5,0xEB),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6_3F = {
    to_EUC_KR_E6_3F_offsets,
    to_EUC_KR_E6_3F_infos
};


static const struct byte_lookup* const
to_EUC_KR_E6_infos[65] = {
       &to_EUC_KR_E6_00,   &to_EUC_KR_E6_01,
       &to_EUC_KR_E6_02,   &to_EUC_KR_E6_03,
       &to_EUC_KR_E6_04,   &to_EUC_KR_E6_05,
       &to_EUC_KR_E6_06,   &to_EUC_KR_E6_07,
       &to_EUC_KR_E6_08,   &to_EUC_KR_E6_09,
       &to_EUC_KR_E6_0A,   &to_EUC_KR_E6_0B,
       &to_EUC_KR_E6_0C,   &to_EUC_KR_E6_0D,
       &to_EUC_KR_E6_0E,   &to_EUC_KR_E6_0F,
       &to_EUC_KR_E6_10,   &to_EUC_KR_E6_11,
       &to_EUC_KR_E6_12,   &to_EUC_KR_E6_13,
       &to_EUC_KR_E6_14,   &to_EUC_KR_E6_15,
       &to_EUC_KR_E6_16,   &to_EUC_KR_E6_17,
       &to_EUC_KR_E6_18,   &to_EUC_KR_E6_19,
       &to_EUC_KR_E6_1A,   &to_EUC_KR_E6_1B,
       &to_EUC_KR_E6_1C,   &to_EUC_KR_E6_1D,
       &to_EUC_KR_E6_1E,   &to_EUC_KR_E6_1F,
       &to_EUC_KR_E6_20,   &to_EUC_KR_E6_21,
       &to_EUC_KR_E6_22,   &to_EUC_KR_E6_23,
       &to_EUC_KR_E6_24,   &to_EUC_KR_E6_25,
       &to_EUC_KR_E6_26,   &to_EUC_KR_E6_27,
       &to_EUC_KR_E6_28,   &to_EUC_KR_E6_29,
       &to_EUC_KR_E6_2A,   &to_EUC_KR_E6_2B,
       &to_EUC_KR_E6_2C,   &to_EUC_KR_E6_2D,
       &to_EUC_KR_E6_2E,   &to_EUC_KR_E6_2F,
       &to_EUC_KR_E6_30,   &to_EUC_KR_E6_31,
       &to_EUC_KR_E6_32,   &to_EUC_KR_E6_33,
       &to_EUC_KR_E6_34,   &to_EUC_KR_E6_35,
       &to_EUC_KR_E6_36,   &to_EUC_KR_E6_37,
       &to_EUC_KR_E6_38,   &to_EUC_KR_E6_39,
       &to_EUC_KR_E6_3A,   &to_EUC_KR_E6_3B,
       &to_EUC_KR_E6_3C,   &to_EUC_KR_E6_3D,
       &to_EUC_KR_E6_3E,   &to_EUC_KR_E6_3F,
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E6 = {
    to_EUC_KR_E3_05_offsets,
    to_EUC_KR_E6_infos
};

static const unsigned char
to_EUC_KR_E7_00_offsets[64] = {
     21,  0, 21, 21, 21,  1,  2, 21,     21,  3, 21,  4, 21, 21, 21,  5,
     21,  6, 21, 21, 21,  7, 21, 21,      8, 21,  9, 10, 11, 12, 13, 14,
     21, 21, 21, 15, 21, 21, 21, 16,     17, 21, 21, 21, 21, 21, 21, 18,
     21, 21, 21, 21, 21, 21, 21, 19,     21, 21, 21, 21, 21, 21, 20, 21,
};

static const struct byte_lookup* const
to_EUC_KR_E7_00_infos[22] = {
          o2(0xE5,0xC8),      o2(0xFB,0xA4),
          o2(0xD4,0xB9),      o2(0xDE,0xE1),
          o2(0xE4,0xA3),      o2(0xD7,0xB7),
          o2(0xF8,0xEE),      o2(0xDE,0xB5),
          o2(0xD6,0xD2),      o2(0xF9,0xD5),
          o2(0xE7,0xBA),      o2(0xEB,0xD5),
          o2(0xD5,0xF7),      o2(0xEF,0xE7),
          o2(0xE1,0xBE),      o2(0xFA,0xAE),
          o2(0xD6,0xE9),      o2(0xD6,0xEE),
          o2(0xE7,0xBB),      o2(0xEC,0xCB),
          o2(0xD5,0xB3),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_00 = {
    to_EUC_KR_E7_00_offsets,
    to_EUC_KR_E7_00_infos
};

static const unsigned char
to_EUC_KR_E7_01_offsets[64] = {
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11,  0, 11, 11, 11,
      1,  2, 11, 11, 11, 11, 11, 11,      3, 11, 11, 11, 11,  4, 11, 11,
     11, 11, 11,  5, 11, 11, 11, 11,     11, 11, 11,  6, 11, 11, 11, 11,
      7, 11, 11, 11, 11, 11, 11, 11,      8, 11, 11, 11,  9, 10, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_E7_01_infos[12] = {
          o2(0xCE,0xB4),      o2(0xFB,0xA5),
          o2(0xE1,0xEE),      o2(0xF7,0xA8),
          o2(0xFB,0xCE),      o2(0xD8,0xBD),
          o2(0xFB,0xFD),      o2(0xFC,0xE9),
          o2(0xCF,0xB6),      o2(0xED,0xC7),
          o2(0xEE,0xAC),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_01 = {
    to_EUC_KR_E7_01_offsets,
    to_EUC_KR_E7_01_infos
};

static const unsigned char
to_EUC_KR_E7_02_offsets[64] = {
     17, 17, 17, 17, 17,  0, 17, 17,     17, 17,  1, 17, 17, 17,  2, 17,
     17, 17,  3, 17, 17, 17, 17, 17,      4,  5,  6, 17, 17, 17, 17, 17,
     17,  7, 17, 17,  8, 17, 17, 17,     17, 17, 17,  9, 10, 11, 17, 12,
     17, 17, 17, 13, 17, 17, 17, 14,     15, 16, 17, 17, 17, 17, 17, 17,
};

static const struct byte_lookup* const
to_EUC_KR_E7_02_infos[18] = {
          o2(0xCC,0xDD),      o2(0xF6,0xA7),
          o2(0xE6,0xFA),      o2(0xF5,0xA4),
          o2(0xFD,0xDC),      o2(0xED,0xB3),
          o2(0xCE,0xC9),      o2(0xEF,0xE8),
          o2(0xE1,0xBF),      o2(0xFA,0xDB),
          o2(0xCB,0xE3),      o2(0xF7,0xA9),
          o2(0xFB,0xA6),      o2(0xDC,0xB9),
          o2(0xF1,0xC0),      o2(0xED,0xC8),
          o2(0xEF,0xC3),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_02 = {
    to_EUC_KR_E7_02_offsets,
    to_EUC_KR_E7_02_infos
};

static const unsigned char
to_EUC_KR_E7_03_offsets[64] = {
     10, 10, 10, 10, 10, 10, 10, 10,      0, 10, 10,  1, 10, 10, 10,  2,
     10, 10, 10, 10, 10, 10, 10, 10,      3,  4, 10, 10, 10,  5, 10,  6,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10,  7, 10, 10, 10, 10, 10, 10,     10,  8, 10, 10, 10,  9, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E7_03_infos[11] = {
          o2(0xD6,0xAD),      o2(0xFD,0xCE),
          o2(0xE8,0xA1),      o2(0xFB,0xF4),
          o2(0xD5,0xA7),      o2(0xF1,0xF6),
          o2(0xE6,0xD3),      o2(0xCC,0xDE),
          o2(0xF8,0xB2),      o2(0xDC,0xEB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_03 = {
    to_EUC_KR_E7_03_offsets,
    to_EUC_KR_E7_03_infos
};

static const unsigned char
to_EUC_KR_E7_04_offsets[64] = {
     10, 10, 10, 10,  0, 10, 10, 10,     10,  1, 10, 10,  2, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10,  3,  4, 10, 10, 10,  5, 10,
     10,  6, 10, 10, 10, 10,  7, 10,     10, 10, 10, 10, 10, 10, 10, 10,
      8, 10, 10, 10, 10, 10,  9, 10,     10, 10, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E7_04_infos[11] = {
          o2(0xFD,0xB6),      o2(0xE5,0xEA),
          o2(0xF1,0xE0),      o2(0xDB,0xCC),
          o2(0xDD,0xCD),      o2(0xD4,0xC8),
          o2(0xD9,0xED),      o2(0xF5,0xA5),
          o2(0xE6,0xFB),      o2(0xE6,0xD4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_04 = {
    to_EUC_KR_E7_04_offsets,
    to_EUC_KR_E7_04_infos
};

static const unsigned char
to_EUC_KR_E7_05_offsets[64] = {
     18, 18, 18, 18, 18, 18, 18,  0,     18,  1,  2, 18,  3, 18,  4, 18,
      5, 18, 18, 18, 18, 18,  6, 18,     18,  7, 18, 18,  8, 18,  9, 18,
     18, 18, 18, 18, 10, 11, 12, 13,     18, 14, 18, 18, 15, 18, 16, 18,
     18, 18, 18, 18, 18, 18, 18, 18,     18, 18, 18, 18, 18, 17, 18, 18,
};

static const struct byte_lookup* const
to_EUC_KR_E7_05_infos[19] = {
          o2(0xFD,0xC8),      o2(0xD6,0xA1),
          o2(0xFD,0xBF),      o2(0xFC,0xD3),
          o2(0xEF,0xA1),      o2(0xE7,0xBC),
          o2(0xD1,0xEE),      o2(0xE6,0xD5),
          o2(0xE9,0xF2),      o2(0xDF,0xB0),
          o2(0xD8,0xE0),      o2(0xFC,0xBA),
          o2(0xFD,0xAF),      o2(0xF0,0xCE),
          o2(0xDB,0xE1),      o2(0xE5,0xC9),
          o2(0xED,0xB4),      o2(0xE0,0xC3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_05 = {
    to_EUC_KR_E7_05_offsets,
    to_EUC_KR_E7_05_infos
};

static const unsigned char
to_EUC_KR_E7_06_offsets[64] = {
     14, 14, 14, 14,  0, 14, 14, 14,     14,  1,  2, 14, 14, 14, 14,  3,
     14, 14,  4, 14,  5, 14, 14, 14,     14,  6, 14, 14, 14, 14, 14,  7,
     14, 14,  8, 14, 14, 14, 14, 14,     14, 14, 14, 14,  9, 14, 14, 14,
     14, 10, 14, 14, 14, 14, 14, 14,     14, 11, 12, 14, 14, 14, 13, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E7_06_infos[15] = {
          o2(0xE3,0xD8),      o2(0xE9,0xFB),
          o2(0xEA,0xA8),      o2(0xFD,0xB7),
          o2(0xFB,0xA7),      o2(0xE9,0xC2),
          o2(0xFD,0xF7),      o2(0xE2,0xD9),
          o2(0xDC,0xEC),      o2(0xE8,0xA2),
          o2(0xE6,0xF0),      o2(0xFD,0xF8),
          o2(0xFD,0xF9),      o2(0xF6,0xBF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_06 = {
    to_EUC_KR_E7_06_offsets,
    to_EUC_KR_E7_06_infos
};

static const unsigned char
to_EUC_KR_E7_07_offsets[64] = {
     19,  0, 19,  1, 19, 19, 19, 19,      2,  3, 19, 19, 19, 19,  4, 19,
      5, 19,  6, 19,  7,  8, 19, 19,     19, 19, 19, 19, 19, 19, 19,  9,
     19, 19, 19, 19, 19, 10, 11, 12,     19, 19, 19, 19, 19, 13, 14, 19,
     19, 19, 19, 19, 19, 19, 19, 19,     19, 19, 19, 15, 16, 19, 17, 18,
};

static const struct byte_lookup* const
to_EUC_KR_E7_07_infos[20] = {
          o2(0xE7,0xA7),      o2(0xE6,0xD7),
          o2(0xD4,0xF3),      o2(0xD4,0xC9),
          o2(0xD6,0xFA),      o2(0xD7,0xF2),
          o2(0xE1,0xC0),      o2(0xDB,0xE2),
          o2(0xE6,0xD8),      o2(0xE7,0xBD),
          o2(0xF0,0xCF),      o2(0xF3,0xBE),
          o2(0xE2,0xAC),      o2(0xF5,0xB7),
          o2(0xE0,0xF0),      o2(0xFD,0xB8),
          o2(0xE3,0xE8),      o2(0xD4,0xA7),
          o2(0xE8,0xFC),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_07 = {
    to_EUC_KR_E7_07_offsets,
    to_EUC_KR_E7_07_infos
};

static const unsigned char
to_EUC_KR_E7_08_offsets[64] = {
      0, 15, 15, 15, 15, 15,  1, 15,     15, 15, 15, 15, 15, 15, 15, 15,
      2, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15,  3, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15,  4, 15,  5,  6, 15, 15,
      7, 15,  8, 15, 15,  9, 10, 15,     15, 15, 11, 12, 15, 13, 14, 15,
};

static const struct byte_lookup* const
to_EUC_KR_E7_08_infos[16] = {
          o2(0xFA,0xD2),      o2(0xF8,0xEF),
          o2(0xD6,0xD3),      o2(0xD5,0xB4),
          o2(0xF0,0xD0),      o2(0xF7,0xF0),
          o2(0xEE,0xB3),      o2(0xEA,0xBA),
          o2(0xEA,0xD3),      o2(0xED,0xC9),
          o2(0xDD,0xAB),      o2(0xE5,0xAC),
          o2(0xFD,0xA1),      o2(0xDF,0xD0),
          o2(0xEC,0xB3),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_08 = {
    to_EUC_KR_E7_08_offsets,
    to_EUC_KR_E7_08_infos
};

static const unsigned char
to_EUC_KR_E7_09_offsets[64] = {
      0, 18, 18, 18, 18, 18,  1,  2,      3, 18, 18, 18,  4, 18, 18, 18,
     18, 18,  5, 18, 18, 18, 18, 18,      6,  7, 18,  8, 18,  9, 18, 10,
     18, 11, 12, 18, 18, 18, 18, 13,     18, 14, 18, 18, 18, 18, 18, 18,
     18, 18, 15, 18, 18, 18, 18, 18,     18, 16, 18, 18, 18, 17, 18, 18,
};

static const struct byte_lookup* const
to_EUC_KR_E7_09_infos[19] = {
          o2(0xDF,0xD1),      o2(0xED,0xED),
          o2(0xF8,0xB8),      o2(0xF7,0xFA),
          o2(0xF8,0xAB),      o2(0xF4,0xE0),
          o2(0xD4,0xBA),      o2(0xE4,0xB3),
          o2(0xE9,0xDA),      o2(0xDE,0xB6),
          o2(0xD9,0xBF),      o2(0xD9,0xC0),
          o2(0xD6,0xEF),      o2(0xD9,0xCC),
          o2(0xDA,0xAA),      o2(0xDF,0xE5),
          o2(0xF7,0xE5),      o2(0xCC,0xB2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_09 = {
    to_EUC_KR_E7_09_offsets,
    to_EUC_KR_E7_09_infos
};

static const unsigned char
to_EUC_KR_E7_0A_offsets[64] = {
      0,  1,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  2,  6,  6,  6,  6,  3,      6,  6,  6,  6,  4,  6,  6,  5,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_E7_0A_infos[7] = {
          o2(0xDF,0xF9),      o2(0xD7,0xE0),
          o2(0xD4,0xBB),      o2(0xFD,0xFA),
          o2(0xCC,0xB3),      o2(0xDB,0xF3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_0A = {
    to_EUC_KR_E7_0A_offsets,
    to_EUC_KR_E7_0A_infos
};

static const unsigned char
to_EUC_KR_E7_0B_offsets[64] = {
      0, 13,  1, 13,  2, 13, 13, 13,     13, 13, 13, 13, 13, 13,  3, 13,
      4, 13, 13, 13, 13, 13, 13,  5,     13,  6, 13, 13, 13, 13, 13, 13,
     13,  7, 13, 13, 13, 13, 13, 13,     13,  8, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,      9, 10, 13, 13, 11, 12, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E7_0B_infos[14] = {
          o2(0xDF,0xD2),      o2(0xCE,0xCA),
          o2(0xEE,0xDA),      o2(0xE4,0xE4),
          o2(0xFB,0xCF),      o2(0xCF,0xB7),
          o2(0xEE,0xC3),      o2(0xCE,0xEA),
          o2(0xE2,0xAD),      o2(0xD7,0xE1),
          o2(0xFA,0xF5),      o2(0xD5,0xC9),
          o2(0xF8,0xAC),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_0B = {
    to_EUC_KR_E7_0B_offsets,
    to_EUC_KR_E7_0B_infos
};

static const unsigned char
to_EUC_KR_E7_0C_offsets[64] = {
     13, 13, 13, 13, 13, 13, 13, 13,     13, 13,  0, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13,  1, 13,     13, 13, 13,  2,  3,  4, 13, 13,
     13, 13, 13, 13, 13,  5, 13, 13,     13,  6,  7,  8, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13,  9, 10,     13, 13, 13, 13, 13, 13, 11, 12,
};

static const struct byte_lookup* const
to_EUC_KR_E7_0C_infos[14] = {
          o2(0xE7,0xD9),      o2(0xF3,0xE9),
          o2(0xD8,0xED),      o2(0xE3,0xC4),
          o2(0xF0,0xF1),      o2(0xE8,0xE5),
          o2(0xE0,0xFA),      o2(0xEE,0xC4),
          o2(0xD9,0xDE),      o2(0xEB,0xA2),
          o2(0xEB,0xA3),      o2(0xFC,0xC2),
          o2(0xEA,0xBB),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_0C = {
    to_EUC_KR_E7_0C_offsets,
    to_EUC_KR_E7_0C_infos
};

static const unsigned char
to_EUC_KR_E7_0D_offsets[64] = {
     13, 13, 13, 13,  0,  1, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
      2, 13,  3, 13, 13, 13, 13,  4,     13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,      5, 13,  6, 13, 13, 13, 13, 13,
      7, 13,  8, 13, 13,  9, 13, 13,     10, 13, 11, 12, 13, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E7_0D_infos[14] = {
          o2(0xE8,0xAB),      o2(0xDE,0xE2),
          o2(0xED,0xEF),      o2(0xE8,0xA3),
          o2(0xCF,0xF1),      o2(0xD4,0xBC),
          o2(0xFC,0xEA),      o2(0xE7,0xBE),
          o2(0xFC,0xF2),      o2(0xD6,0xB4),
          o2(0xE2,0xAE),      o2(0xD3,0xB7),
          o2(0xFA,0xCC),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_0D = {
    to_EUC_KR_E7_0D_offsets,
    to_EUC_KR_E7_0D_infos
};

static const unsigned char
to_EUC_KR_E7_0E_offsets[64] = {
     17, 17, 17, 17,  0, 17,  1,  2,     17,  3, 17,  4, 17, 17,  5, 17,
     17, 17, 17, 17,  6, 17,  7,  8,      9, 17, 17, 17, 17, 17, 17, 10,
     17, 17, 17, 17, 17, 17, 17, 11,     17, 12, 17, 17, 17, 13, 17, 17,
     17, 17, 14, 15, 17, 17, 17, 17,     17, 16, 17, 17, 17, 17, 17, 17,
};

static const struct byte_lookup* const
to_EUC_KR_E7_0E_infos[18] = {
          o2(0xFA,0xDC),      o2(0xED,0xB5),
          o2(0xE1,0xE3),      o2(0xE8,0xAC),
          o2(0xE8,0xDD),      o2(0xEF,0xE9),
          o2(0xF4,0xBD),      o2(0xCF,0xB8),
          o2(0xE9,0xDB),      o2(0xD1,0xAC),
          o2(0xDA,0xC7),      o2(0xEB,0xC9),
          o2(0xE8,0xCC),      o2(0xDE,0xB7),
          o2(0xD6,0xBC),      o2(0xD3,0xE5),
          o2(0xFA,0xDD),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_0E = {
    to_EUC_KR_E7_0E_offsets,
    to_EUC_KR_E7_0E_infos
};

static const unsigned char
to_EUC_KR_E7_0F_offsets[64] = {
      0, 23,  1, 23, 23, 23, 23, 23,     23,  2,  3, 23,  4,  5, 23,  6,
     23, 23, 23, 23, 23, 23,  7, 23,     23,  8, 23, 23, 23,  9, 10, 23,
     11, 23, 23, 12, 13, 14, 15, 23,     23, 16, 17, 23, 23, 18, 23, 23,
     23, 23, 23, 23, 23, 23, 23, 19,     23, 20, 23, 23, 23, 21, 22, 23,
};

static const struct byte_lookup* const
to_EUC_KR_E7_0F_infos[24] = {
          o2(0xDA,0xD6),      o2(0xCA,0xB1),
          o2(0xDA,0xC8),      o2(0xDF,0xA6),
          o2(0xF9,0xB3),      o2(0xF2,0xD2),
          o2(0xCA,0xC4),      o2(0xCE,0xCB),
          o2(0xCD,0xF5),      o2(0xFD,0xB0),
          o2(0xD5,0xA8),      o2(0xF1,0xC1),
          o2(0xE2,0xE9),      o2(0xDC,0xCA),
          o2(0xEC,0xB4),      o2(0xFA,0xC0),
          o2(0xFB,0xA8),      o2(0xD0,0xA8),
          o2(0xDA,0xEC),      o2(0xD9,0xEE),
          o2(0xE0,0xFB),      o2(0xEF,0xEA),
          o2(0xFA,0xDE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_0F = {
    to_EUC_KR_E7_0F_offsets,
    to_EUC_KR_E7_0F_infos
};

static const unsigned char
to_EUC_KR_E7_10_offsets[64] = {
     27,  0, 27,  1, 27,  2,  3,  4,     27,  5, 27, 27, 27, 27, 27, 27,
     27, 27, 27,  6, 27, 27, 27, 27,     27, 27, 27,  7, 27, 27, 27, 27,
      8,  9, 10, 27, 27, 11, 12, 27,     13, 27, 14, 15, 16, 27, 17, 18,
     19, 27, 27, 20, 21, 22, 23, 27,     24, 27, 25, 27, 27, 27, 27, 26,
};

static const struct byte_lookup* const
to_EUC_KR_E7_10_infos[28] = {
          o2(0xE0,0xC4),      o2(0xCF,0xB9),
          o2(0xD5,0xCA),      o2(0xD7,0xE2),
          o2(0xE2,0xAF),      o2(0xD7,0xB8),
          o2(0xE8,0xCD),      o2(0xF6,0xDA),
          o2(0xEF,0xA2),      o2(0xE2,0xDA),
          o2(0xF6,0xFC),      o2(0xFB,0xD0),
          o2(0xD1,0xAD),      o2(0xCD,0xE4),
          o2(0xD1,0xAE),      o2(0xDC,0xED),
          o2(0xE8,0xCE),      o2(0xF0,0xF9),
          o2(0xCE,0xB5),      o2(0xE6,0xFC),
          o2(0xD7,0xFB),      o2(0xD0,0xD6),
          o2(0xDD,0xF5),      o2(0xF7,0xF1),
          o2(0xF6,0xFD),      o2(0xDB,0xF7),
          o2(0xFB,0xEA),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_10 = {
    to_EUC_KR_E7_10_offsets,
    to_EUC_KR_E7_10_infos
};

static const unsigned char
to_EUC_KR_E7_11_offsets[64] = {
      0,  1, 22,  2,  3, 22, 22, 22,     22, 22, 22,  4, 22, 22, 22, 22,
     22, 22, 22, 22, 22,  5, 22,  6,     22,  7,  8,  9, 10, 22, 11, 12,
     13, 22, 14, 22, 15, 16, 22, 22,     17, 18, 19, 22, 22, 22, 22, 20,
     22, 22, 22, 22, 22, 22, 22, 22,     22, 22, 22, 22, 22, 22, 21, 22,
};

static const struct byte_lookup* const
to_EUC_KR_E7_11_infos[23] = {
          o2(0xE9,0xDC),      o2(0xD9,0xC1),
          o2(0xF5,0xF2),      o2(0xE0,0xC5),
          o2(0xEA,0xD4),      o2(0xF9,0xC2),
          o2(0xEA,0xBC),      o2(0xD2,0xC5),
          o2(0xFB,0xD1),      o2(0xE7,0xC0),
          o2(0xEB,0xA5),      o2(0xDF,0xFA),
          o2(0xE3,0xA2),      o2(0xD7,0xB9),
          o2(0xE9,0xC3),      o2(0xE8,0xFD),
          o2(0xE8,0xAF),      o2(0xF2,0xD3),
          o2(0xFB,0xA9),      o2(0xD8,0xA5),
          o2(0xD5,0xCB),      o2(0xD0,0xC8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_11 = {
    to_EUC_KR_E7_11_offsets,
    to_EUC_KR_E7_11_infos
};

static const unsigned char
to_EUC_KR_E7_12_offsets[64] = {
     21, 21,  0,  1, 21, 21, 21,  2,     21,  3, 21,  4, 21, 21, 21, 21,
     21, 21, 21, 21, 21, 21, 21, 21,      5, 21, 21, 21,  6, 21,  7,  8,
     21,  9, 21, 10, 21, 11, 21, 12,     13, 21, 14, 21, 21, 21, 21, 21,
     15, 21, 16, 21, 21, 17, 21, 21,     21, 18, 21, 21, 21, 19, 21, 20,
};

static const struct byte_lookup* const
to_EUC_KR_E7_12_infos[22] = {
          o2(0xD1,0xAF),      o2(0xD7,0xE3),
          o2(0xE0,0xC6),      o2(0xD6,0xA2),
          o2(0xED,0xF0),      o2(0xD7,0xF3),
          o2(0xFC,0xD4),      o2(0xDA,0xD7),
          o2(0xCC,0xDF),      o2(0xF2,0xD4),
          o2(0xD1,0xB0),      o2(0xCC,0xE0),
          o2(0xDB,0xFD),      o2(0xF3,0xBF),
          o2(0xF0,0xD1),      o2(0xFC,0xBB),
          o2(0xE2,0xB0),      o2(0xE6,0xA5),
          o2(0xE2,0xDB),      o2(0xDF,0xDE),
          o2(0xE0,0xC7),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_12 = {
    to_EUC_KR_E7_12_offsets,
    to_EUC_KR_E7_12_infos
};

static const unsigned char
to_EUC_KR_E7_13_offsets[64] = {
     13, 13, 13, 13, 13, 13,  0, 13,     13, 13,  1, 13, 13, 13, 13,  2,
     13, 13, 13, 13,  3, 13, 13, 13,      4, 13,  5, 13,  6, 13, 13, 13,
      7, 13,  8,  9, 13, 13, 10, 13,     13, 13, 13, 13, 13, 13, 11, 13,
     13, 13, 13, 13, 13, 13, 13, 12,     13, 13, 13, 13, 13, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E7_13_infos[14] = {
          o2(0xF2,0xEF),      o2(0xCC,0xE1),
          o2(0xD6,0xEA),      o2(0xE7,0xC2),
          o2(0xCE,0xB6),      o2(0xF3,0xC0),
          o2(0xCD,0xFE),      o2(0xFB,0xD2),
          o2(0xF8,0xF8),      o2(0xF7,0xFB),
          o2(0xE8,0xBF),      o2(0xE8,0xB7),
          o2(0xED,0xB6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_13 = {
    to_EUC_KR_E7_13_offsets,
    to_EUC_KR_E7_13_infos
};

static const unsigned char
to_EUC_KR_E7_14_offsets[64] = {
     21,  0, 21, 21,  1, 21, 21, 21,     21, 21, 21, 21, 21, 21, 21, 21,
     21,  2, 21, 21, 21,  3, 21, 21,      4, 21,  5,  6, 21, 21, 21,  7,
     21, 21, 21,  8, 21,  9, 10, 21,     11, 21, 21, 12, 13, 21, 21, 21,
     14, 15, 16, 17, 21, 21, 21, 18,     19, 21, 20, 21, 21, 21, 21, 21,
};

static const struct byte_lookup* const
to_EUC_KR_E7_14_infos[22] = {
          o2(0xDC,0xBA),      o2(0xCC,0xB4),
          o2(0xF1,0xF7),      o2(0xE8,0xB8),
          o2(0xCA,0xF6),      o2(0xE4,0xA4),
          o2(0xF4,0xD6),      o2(0xDF,0xE6),
          o2(0xDF,0xA7),      o2(0xDF,0xE7),
          o2(0xE1,0xC1),      o2(0xE9,0xC4),
          o2(0xDC,0xCB),      o2(0xE9,0xC5),
          o2(0xEF,0xA3),      o2(0xEB,0xA6),
          o2(0xCB,0xA3),      o2(0xE3,0xE9),
          o2(0xD1,0xFB),      o2(0xEF,0xA4),
          o2(0xEF,0xEB),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_14 = {
    to_EUC_KR_E7_14_offsets,
    to_EUC_KR_E7_14_infos
};

static const unsigned char
to_EUC_KR_E7_15_offsets[64] = {
     21, 21, 21, 21, 21, 21, 21,  0,     21, 21, 21, 21,  1, 21, 21,  2,
     21,  3, 21,  4,  5, 21, 21, 21,     21,  6, 21,  7,  8,  9, 21, 21,
     21, 21, 10, 21, 21, 11, 12, 21,     21, 21, 13, 21, 21, 21, 21, 14,
     15, 21, 21, 21, 21, 16, 17, 21,     18, 21, 19, 21, 21, 21, 21, 20,
};

static const struct byte_lookup* const
to_EUC_KR_E7_15_infos[22] = {
          o2(0xD0,0xB4),      o2(0xCD,0xA3),
          o2(0xE8,0xE6),      o2(0xEF,0xA5),
          o2(0xD3,0xCC),      o2(0xDA,0xED),
          o2(0xD7,0xBA),      o2(0xF2,0xD5),
          o2(0xF5,0xE5),      o2(0xD9,0xEF),
          o2(0xF9,0xB4),      o2(0xD5,0xD4),
          o2(0xFD,0xCF),      o2(0xDB,0xE3),
          o2(0xF1,0xE1),      o2(0xEC,0xB6),
          o2(0xFB,0xFE),      o2(0xD3,0xD7),
          o2(0xD1,0xB1),      o2(0xCB,0xB1),
          o2(0xD1,0xB2),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_15 = {
    to_EUC_KR_E7_15_offsets,
    to_EUC_KR_E7_15_infos
};

static const unsigned char
to_EUC_KR_E7_16_offsets[64] = {
     19, 19, 19, 19, 19, 19,  0,  1,     19, 19,  2,  3, 19, 19,  4,  5,
     19,  6, 19, 19, 19, 19, 19, 19,     19, 19, 19, 19, 19,  7, 19, 19,
     19, 19, 19, 19, 19,  8, 19, 19,     19, 19, 19,  9, 19, 19, 19, 19,
     19, 10, 11, 12, 19, 13, 19, 19,     14, 15, 19, 19, 16, 17, 18, 19,
};

static const struct byte_lookup* const
to_EUC_KR_E7_16_infos[20] = {
          o2(0xCB,0xB2),      o2(0xF1,0xC2),
          o2(0xF4,0xE1),      o2(0xF9,0xB5),
          o2(0xE1,0xC3),      o2(0xE1,0xC2),
          o2(0xEB,0xF7),      o2(0xDF,0xA8),
          o2(0xCB,0xCA),      o2(0xE6,0xB9),
          o2(0xF8,0xDE),      o2(0xF9,0xAA),
          o2(0xCA,0xF7),      o2(0xED,0xB7),
          o2(0xD3,0xB8),      o2(0xF2,0xD6),
          o2(0xD4,0xD9),      o2(0xEE,0xC5),
          o2(0xF2,0xF0),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_16 = {
    to_EUC_KR_E7_16_offsets,
    to_EUC_KR_E7_16_infos
};

static const unsigned char
to_EUC_KR_E7_17_offsets[64] = {
     16, 16,  0, 16, 16,  1, 16,  2,     16, 16, 16, 16, 16,  3, 16, 16,
     16, 16,  4, 16,  5,  6, 16, 16,      7,  8, 16,  9, 16, 16, 16, 16,
     16, 16, 10, 16, 16, 16, 16, 16,     16, 16, 16, 16, 16, 16, 16, 16,
     11, 16, 12, 16, 13, 16, 16, 16,     16, 16, 14, 16, 15, 16, 16, 16,
};

static const struct byte_lookup* const
to_EUC_KR_E7_17_infos[17] = {
          o2(0xCA,0xB2),      o2(0xDC,0xBB),
          o2(0xF1,0xF8),      o2(0xEC,0xB7),
          o2(0xE5,0xCA),      o2(0xF6,0xC0),
          o2(0xFD,0xDD),      o2(0xD4,0xE3),
          o2(0xCC,0xE2),      o2(0xF7,0xD4),
          o2(0xD7,0xE5),      o2(0xD3,0xC3),
          o2(0xD8,0xA6),      o2(0xF6,0xC1),
          o2(0xDD,0xF6),      o2(0xCD,0xC0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_17 = {
    to_EUC_KR_E7_17_offsets,
    to_EUC_KR_E7_17_infos
};

static const unsigned char
to_EUC_KR_E7_18_offsets[64] = {
      0, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10,  1, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10,  2, 10, 10, 10, 10, 10,  3,
      4,  5,  6, 10,  7, 10,  8, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10,  9, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E7_18_infos[11] = {
          o2(0xE5,0xDC),      o2(0xE5,0xCB),
          o2(0xE1,0xC4),      o2(0xE8,0xB0),
          o2(0xF4,0xB0),      o2(0xF3,0xEA),
          o2(0xDA,0xEE),      o2(0xD7,0xBB),
          o2(0xE2,0xB1),      o2(0xD7,0xAA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_18 = {
    to_EUC_KR_E7_18_offsets,
    to_EUC_KR_E7_18_infos
};

static const unsigned char
to_EUC_KR_E7_19_offsets[64] = {
     16, 16,  0, 16, 16, 16, 16, 16,     16, 16, 16, 16,  1, 16,  2, 16,
     16, 16,  3, 16, 16, 16,  4, 16,     16, 16, 16, 16, 16, 16, 16, 16,
     16,  5, 16, 16,  6, 16, 16, 16,     16,  7, 16, 16,  8, 16, 16, 16,
      9, 16, 10, 16, 16, 16, 16, 16,     11, 16, 16, 12, 13, 14, 15, 16,
};

static const struct byte_lookup* const
to_EUC_KR_E7_19_infos[17] = {
          o2(0xD6,0xFB),      o2(0xE4,0xDF),
          o2(0xCA,0xD6),      o2(0xEB,0xA8),
          o2(0xDB,0xFE),      o2(0xF6,0xC2),
          o2(0xEF,0xBB),      o2(0xD4,0xFD),
          o2(0xE0,0xC8),      o2(0xE8,0xB9),
          o2(0xEF,0xA6),      o2(0xCD,0xA4),
          o2(0xD4,0xF4),      o2(0xDB,0xA1),
          o2(0xDB,0xDC),      o2(0xDB,0xDD),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_19 = {
    to_EUC_KR_E7_19_offsets,
    to_EUC_KR_E7_19_infos
};

static const unsigned char
to_EUC_KR_E7_1A_offsets[64] = {
      9,  9,  9,  9,  0,  9,  1,  2,      9,  9,  9,  9,  9,  9,  3,  9,
      4,  9,  9,  5,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  6,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  7,  9,  9,  9,  9,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E7_1A_infos[10] = {
          o2(0xEE,0xDC),      o2(0xCB,0xCB),
          o2(0xFC,0xD5),      o2(0xCE,0xEB),
          o2(0xCD,0xC1),      o2(0xFB,0xD3),
          o2(0xF9,0xAB),      o2(0xF5,0xD4),
          o2(0xD9,0xA9),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_1A = {
    to_EUC_KR_E7_1A_offsets,
    to_EUC_KR_E7_1A_infos
};

static const unsigned char
to_EUC_KR_E7_1B_offsets[64] = {
     21, 21,  0,  1, 21, 21,  2, 21,      3, 21,  4, 21, 21, 21, 21, 21,
     21, 21,  5, 21, 21, 21,  6, 21,     21, 21, 21,  7,  8, 21,  9, 10,
     21, 11, 21, 12, 13, 21, 21, 14,     21, 21, 21, 21, 21, 21, 15, 21,
     21, 21, 16, 21, 17, 21, 21, 21,     18, 21, 21, 21, 19, 21, 20, 21,
};

static const struct byte_lookup* const
to_EUC_KR_E7_1B_infos[22] = {
          o2(0xE9,0xDD),      o2(0xDB,0xCD),
          o2(0xDD,0xCE),      o2(0xE7,0xC3),
          o2(0xEC,0xCC),      o2(0xF9,0xEC),
          o2(0xCB,0xCC),      o2(0xE0,0xFC),
          o2(0xD4,0xA8),      o2(0xED,0xD3),
          o2(0xD8,0xEF),      o2(0xF2,0xD7),
          o2(0xCA,0xF8),      o2(0xDA,0xEF),
          o2(0xD6,0xD4),      o2(0xD9,0xCD),
          o2(0xD8,0xEE),      o2(0xF2,0xC1),
          o2(0xDF,0xD3),      o2(0xDA,0xF0),
          o2(0xE2,0xEA),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_1B = {
    to_EUC_KR_E7_1B_offsets,
    to_EUC_KR_E7_1B_infos
};

static const unsigned char
to_EUC_KR_E7_1C_offsets[64] = {
     12,  0, 12, 12,  1, 12, 12, 12,      2,  3, 12,  4, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12,  5, 12,
      6, 12, 12, 12, 12, 12, 12, 12,     12,  7, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12,  8,      9, 12, 10, 12, 11, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_E7_1C_infos[13] = {
          o2(0xE0,0xFD),      o2(0xD8,0xF8),
          o2(0xF7,0xAF),      o2(0xDA,0xB6),
          o2(0xCA,0xD7),      o2(0xF2,0xD8),
          o2(0xD8,0xF9),      o2(0xFA,0xDF),
          o2(0xCF,0xEF),      o2(0xD9,0xC2),
          o2(0xF0,0xD2),      o2(0xE4,0xD1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_1C = {
    to_EUC_KR_E7_1C_offsets,
    to_EUC_KR_E7_1C_infos
};

static const unsigned char
to_EUC_KR_E7_1D_offsets[64] = {
      0, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10,  1, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10,  2, 10, 10, 10, 10,
     10,  3, 10,  4, 10, 10,  5, 10,     10, 10, 10,  6, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10,  7, 10, 10, 10, 10,  8,  9,
};

static const struct byte_lookup* const
to_EUC_KR_E7_1D_infos[11] = {
          o2(0xF3,0xB7),      o2(0xFA,0xE0),
          o2(0xEF,0xEC),      o2(0xE2,0xB2),
          o2(0xD4,0xBD),      o2(0xD9,0xCE),
          o2(0xF4,0xE2),      o2(0xD4,0xA9),
          o2(0xCD,0xC2),      o2(0xE7,0xDA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_1D = {
    to_EUC_KR_E7_1D_offsets,
    to_EUC_KR_E7_1D_infos
};

static const unsigned char
to_EUC_KR_E7_1E_offsets[64] = {
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11,  0, 11, 11, 11, 11,
     11,  1, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11,  2, 11,
     11, 11, 11, 11, 11,  3, 11, 11,     11, 11, 11, 11,  4,  5, 11, 11,
      6, 11, 11,  7, 11, 11, 11, 11,     11, 11, 11,  8,  9, 11, 11, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E7_1E_infos[12] = {
          o2(0xF2,0xD9),      o2(0xD9,0xAA),
          o2(0xD8,0xBE),      o2(0xDC,0xAD),
          o2(0xE2,0xEB),      o2(0xD6,0xFC),
          o2(0xCA,0xF9),      o2(0xD4,0xDA),
          o2(0xF4,0xD7),      o2(0xCC,0xA1),
          o2(0xCF,0xBA),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_1E = {
    to_EUC_KR_E7_1E_offsets,
    to_EUC_KR_E7_1E_infos
};

static const unsigned char
to_EUC_KR_E7_1F_offsets[64] = {
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11,  0,     11, 11, 11,  1,  2, 11, 11, 11,
     11, 11,  3,  4, 11,  5, 11, 11,     11,  6, 11, 11, 11,  7,  8,  9,
     11, 11, 11, 10, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_E7_1F_infos[12] = {
          o2(0xF5,0xB8),      o2(0xD9,0xC3),
          o2(0xD0,0xE8),      o2(0xE3,0xC5),
          o2(0xEB,0xF8),      o2(0xF2,0xB1),
          o2(0xCF,0xBB),      o2(0xD3,0xAD),
          o2(0xE8,0xE1),      o2(0xCE,0xEC),
          o2(0xE0,0xB4),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_1F = {
    to_EUC_KR_E7_1F_offsets,
    to_EUC_KR_E7_1F_infos
};

static const unsigned char
to_EUC_KR_E7_20_offsets[64] = {
      8,  8,  0,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  1,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  2,  3,  4,      8,  8,  8,  8,  5,  8,  8,  8,
      8,  8,  6,  8,  7,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E7_20_infos[9] = {
          o2(0xDE,0xE3),      o2(0xDD,0xF7),
          o2(0xF2,0xB2),      o2(0xF3,0xF6),
          o2(0xF6,0xDB),      o2(0xD7,0xFE),
          o2(0xF8,0xDF),      o2(0xF7,0xF2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_20 = {
    to_EUC_KR_E7_20_offsets,
    to_EUC_KR_E7_20_infos
};

static const unsigned char
to_EUC_KR_E7_21_offsets[64] = {
      7,  7,  7,  7,  7,  0,  7,  7,      7,  7,  7,  7,  7,  7,  7,  1,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  2,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  3,  4,  7,  7,  5,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  6,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_E7_21_infos[8] = {
          o2(0xD0,0xA9),      o2(0xE6,0xDA),
          o2(0xF5,0xA6),      o2(0xD7,0xBC),
          o2(0xCC,0xE3),      o2(0xE6,0xDB),
          o2(0xDD,0xDD),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_21 = {
    to_EUC_KR_E7_21_offsets,
    to_EUC_KR_E7_21_infos
};

static const unsigned char
to_EUC_KR_E7_22_offsets[64] = {
     13,  0, 13, 13, 13, 13, 13,  1,     13, 13, 13, 13,  2,  3,  4, 13,
     13,  5, 13, 13, 13, 13, 13,  6,     13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13,  7, 13, 13, 13,  8,     13,  9, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,     13, 13, 10, 11, 12, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E7_22_infos[14] = {
          o2(0xD1,0xB3),      o2(0xEF,0xED),
          o2(0xD6,0xDE),      o2(0xE4,0xF4),
          o2(0xE1,0xEF),      o2(0xDD,0xF8),
          o2(0xE8,0xCF),      o2(0xCA,0xE5),
          o2(0xDC,0xA1),      o2(0xE0,0xB5),
          o2(0xFC,0xAC),      o2(0xFC,0xAD),
          o2(0xD8,0xA7),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_22 = {
    to_EUC_KR_E7_22_offsets,
    to_EUC_KR_E7_22_infos
};

static const unsigned char
to_EUC_KR_E7_23_offsets[64] = {
     11,  0, 11, 11, 11,  1, 11, 11,     11, 11,  2,  3, 11, 11,  4, 11,
      5, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,      6, 11, 11, 11,  7, 11, 11,  8,
     11, 11, 11, 11, 11,  9, 11, 11,     11, 11, 11, 10, 11, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_E7_23_infos[12] = {
          o2(0xED,0xB8),      o2(0xDB,0xB6),
          o2(0xD6,0xF0),      o2(0xF3,0xAF),
          o2(0xCD,0xA5),      o2(0xDA,0xF1),
          o2(0xD8,0xA8),      o2(0xCC,0xE4),
          o2(0xD1,0xB4),      o2(0xCA,0xD8),
          o2(0xDA,0xF2),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_23 = {
    to_EUC_KR_E7_23_offsets,
    to_EUC_KR_E7_23_infos
};

static const unsigned char
to_EUC_KR_E7_24_offsets[64] = {
      8,  0,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  1,  8,
      8,  8,  8,  8,  8,  8,  2,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  3,  4,  5,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  6,  8,  8,  8,  7,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E7_24_infos[9] = {
          o2(0xF5,0xA7),      o2(0xF5,0xA8),
          o2(0xE6,0xA6),      o2(0xD5,0xEC),
          o2(0xD5,0xF8),      o2(0xDA,0xF3),
          o2(0xE3,0xC6),      o2(0xDE,0xE4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_24 = {
    to_EUC_KR_E7_24_offsets,
    to_EUC_KR_E7_24_infos
};

static const unsigned char
to_EUC_KR_E7_25_offsets[64] = {
      0,  1, 19, 19, 19, 19, 19,  2,      3,  4, 19, 19, 19, 19, 19, 19,
      5, 19, 19, 19, 19, 19,  6,  7,     19, 19,  8,  9, 10, 11, 12, 19,
     13, 19, 19, 19, 19, 14, 19, 19,     15, 19, 19, 19, 19, 16, 19, 19,
     19, 19, 19, 19, 19, 19, 19, 19,     19, 19, 17, 19, 19, 19, 19, 18,
};

static const struct byte_lookup* const
to_EUC_KR_E7_25_infos[20] = {
          o2(0xDE,0xE5),      o2(0xD1,0xB5),
          o2(0xD1,0xB6),      o2(0xD1,0xB7),
          o2(0xF2,0xB3),      o2(0xE9,0xDE),
          o2(0xF0,0xD3),      o2(0xF2,0xB4),
          o2(0xF0,0xD4),      o2(0xCB,0xE4),
          o2(0xFB,0xD4),      o2(0xF5,0xE6),
          o2(0xE3,0xEA),      o2(0xDE,0xE6),
          o2(0xDF,0xD4),      o2(0xF8,0xF9),
          o2(0xF0,0xAE),      o2(0xD1,0xB8),
          o2(0xD6,0xDF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_25 = {
    to_EUC_KR_E7_25_offsets,
    to_EUC_KR_E7_25_infos
};

static const unsigned char
to_EUC_KR_E7_26_offsets[64] = {
     15,  0, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15,  1,  2,  3,
     15,  4, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15,  5,  6,     15, 15,  7, 15, 15, 15,  8, 15,
     15,  9, 15, 10, 15, 15, 15, 15,     15, 11, 15, 15, 15, 12, 13, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E7_26_infos[16] = {
          o2(0xD0,0xD7),      o2(0xFC,0xA1),
          o2(0xEF,0xEE),      o2(0xDC,0xD8),
          o2(0xE9,0xDF),      o2(0xE5,0xDD),
          o2(0xFD,0xFB),      o2(0xE0,0xC9),
          o2(0xD6,0xC9),      o2(0xD4,0xAA),
          o2(0xE5,0xCC),      o2(0xE9,0xE0),
          o2(0xD0,0xD8),      o2(0xFC,0xA2),
          o2(0xD4,0xBE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_26 = {
    to_EUC_KR_E7_26_offsets,
    to_EUC_KR_E7_26_infos
};

static const unsigned char
to_EUC_KR_E7_27_offsets[64] = {
      0,  1, 15, 15, 15, 15, 15, 15,     15,  2,  3,  4, 15, 15, 15, 15,
     15,  5,  6, 15, 15,  7, 15, 15,      8, 15, 15, 15, 15, 15, 15,  9,
     15, 15, 15, 15, 10, 15, 11, 12,     15, 13, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 14, 15, 15, 15, 15,
};

static const struct byte_lookup* const
to_EUC_KR_E7_27_infos[16] = {
          o2(0xE2,0xB3),      o2(0xDE,0xE7),
          o2(0xDC,0xBC),      o2(0xD2,0xB6),
          o2(0xF5,0xD5),      o2(0xCE,0xA1),
          o2(0xF5,0xA9),      o2(0xDD,0xF9),
          o2(0xDD,0xFA),      o2(0xF0,0xD5),
          o2(0xF6,0xDF),      o2(0xF2,0xDA),
          o2(0xE4,0xEB),      o2(0xF2,0xF1),
          o2(0xEC,0xB9),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_27 = {
    to_EUC_KR_E7_27_offsets,
    to_EUC_KR_E7_27_infos
};

static const unsigned char
to_EUC_KR_E7_28_offsets[64] = {
      0, 20, 20, 20, 20,  1, 20, 20,      2, 20, 20,  3, 20,  4, 20, 20,
     20, 20, 20, 20,  5, 20, 20,  6,     20,  7,  8, 20,  9, 20, 20, 10,
     11, 20, 20, 20, 20, 20, 20, 20,     20, 20, 20, 20, 20, 20, 12, 20,
     20, 13, 20, 20, 20, 20, 14, 15,     20, 20, 20, 16, 17, 18, 20, 19,
};

static const struct byte_lookup* const
to_EUC_KR_E7_28_infos[21] = {
          o2(0xFD,0xFC),      o2(0xE1,0xAA),
          o2(0xCA,0xD9),      o2(0xEF,0xEF),
          o2(0xF5,0xAA),      o2(0xEC,0xF9),
          o2(0xF8,0xAD),      o2(0xF2,0xC2),
          o2(0xF6,0xC3),      o2(0xD7,0xD2),
          o2(0xF9,0xA2),      o2(0xF0,0xD6),
          o2(0xF0,0xFA),      o2(0xF6,0xE0),
          o2(0xE9,0xF3),      o2(0xF2,0xC3),
          o2(0xD4,0xAB),      o2(0xCA,0xB3),
          o2(0xCD,0xA6),      o2(0xCD,0xC3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_28 = {
    to_EUC_KR_E7_28_offsets,
    to_EUC_KR_E7_28_infos
};

static const unsigned char
to_EUC_KR_E7_29_offsets[64] = {
      0, 17, 17, 17, 17, 17,  1, 17,     17,  2, 17, 17, 17,  3,  4, 17,
     17, 17, 17, 17, 17, 17, 17,  5,     17, 17, 17, 17, 17, 17, 17, 17,
     17,  6,  7, 17, 17, 17, 17, 17,     17,  8, 17,  9, 17, 17, 17, 17,
     10, 17, 17, 17, 11, 17, 12, 17,     17, 13, 14, 17, 17, 15, 17, 16,
};

static const struct byte_lookup* const
to_EUC_KR_E7_29_infos[18] = {
          o2(0xCD,0xDA),      o2(0xD9,0xCF),
          o2(0xF6,0xC4),      o2(0xEE,0xDD),
          o2(0xE7,0xC4),      o2(0xE2,0xB4),
          o2(0xDF,0xE2),      o2(0xE7,0xDB),
          o2(0xE8,0xB1),      o2(0xFC,0xAE),
          o2(0xE5,0xCD),      o2(0xFA,0xEB),
          o2(0xCF,0xBC),      o2(0xCF,0xE2),
          o2(0xCD,0xF6),      o2(0xEF,0xF0),
          o2(0xF4,0xBE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_29 = {
    to_EUC_KR_E7_29_offsets,
    to_EUC_KR_E7_29_infos
};

static const unsigned char
to_EUC_KR_E7_2A_offsets[64] = {
     13,  0, 13, 13,  1, 13, 13, 13,      2, 13, 13, 13, 13, 13, 13, 13,
     13, 13,  3,  4, 13,  5, 13, 13,      6, 13, 13, 13, 13, 13, 13,  7,
     13, 13, 13, 13, 13, 13, 13, 13,     13,  8,  9, 13, 13, 13, 10, 11,
     13, 13, 13, 13, 13, 13, 13, 13,     13, 13, 12, 13, 13, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E7_2A_infos[14] = {
          o2(0xD4,0xCD),      o2(0xF3,0xB8),
          o2(0xE9,0xA1),      o2(0xF2,0xF2),
          o2(0xF3,0xEB),      o2(0xF0,0xD7),
          o2(0xCF,0xD7),      o2(0xCF,0xDF),
          o2(0xE8,0xC0),      o2(0xE8,0xC1),
          o2(0xCF,0xE3),      o2(0xE9,0xA2),
          o2(0xD0,0xAA),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_2A = {
    to_EUC_KR_E7_2A_offsets,
    to_EUC_KR_E7_2A_infos
};

static const unsigned char
to_EUC_KR_E7_2B_offsets[64] = {
     19, 19, 19, 19,  0,  1, 19,  2,     19, 19,  3,  4, 19, 19, 19, 19,
     19, 19, 19, 19, 19, 19, 19,  5,     19,  6, 19, 19, 19,  7, 19,  8,
      9, 19, 19, 10, 19, 11, 19, 19,     19, 19, 12, 19, 19, 13, 19, 14,
     19, 19, 19, 19, 19, 19, 15, 19,     19, 16, 17, 19, 19, 19, 19, 18,
};

static const struct byte_lookup* const
to_EUC_KR_E7_2B_infos[20] = {
          o2(0xF3,0xC1),      o2(0xD0,0xAB),
          o2(0xD4,0xE4),      o2(0xEF,0xBC),
          o2(0xD8,0xA1),      o2(0xD9,0xDF),
          o2(0xF3,0xD7),      o2(0xDC,0xBD),
          o2(0xCC,0xE5),      o2(0xED,0xF1),
          o2(0xF1,0xE2),      o2(0xD4,0xDB),
          o2(0xE2,0xB5),      o2(0xCA,0xE6),
          o2(0xD3,0xAE),      o2(0xCC,0xE6),
          o2(0xF1,0xD3),      o2(0xF5,0xE7),
          o2(0xCA,0xDA),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_2B = {
    to_EUC_KR_E7_2B_offsets,
    to_EUC_KR_E7_2B_infos
};

static const unsigned char
to_EUC_KR_E7_2C_offsets[64] = {
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10,  0,
     10,  1, 10, 10, 10, 10, 10, 10,     10,  2, 10,  3, 10, 10,  4, 10,
      5, 10, 10, 10, 10, 10,  6, 10,     10, 10, 10, 10,  7,  8, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10,  9, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E7_2C_infos[11] = {
          o2(0xFB,0xEE),      o2(0xE1,0xC5),
          o2(0xDF,0xE9),      o2(0xEE,0xDE),
          o2(0xF7,0xC2),      o2(0xD8,0xA2),
          o2(0xDD,0xAC),      o2(0xF0,0xAF),
          o2(0xD6,0xBD),      o2(0xE1,0xAB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_2C = {
    to_EUC_KR_E7_2C_offsets,
    to_EUC_KR_E7_2C_infos
};

static const unsigned char
to_EUC_KR_E7_2D_offsets[64] = {
     16, 16, 16, 16, 16, 16,  0, 16,     16,  1, 16,  2,  3,  4, 16,  5,
      6,  7,  8, 16,  9, 16, 10, 16,     16, 16, 16, 16, 16, 16, 16, 16,
     11, 16, 16, 16, 16, 16, 16, 16,     16, 16, 16, 16, 12, 16, 13, 16,
     16, 16, 16, 16, 16, 14, 16, 16,     16, 16, 16, 16, 16, 15, 16, 16,
};

static const struct byte_lookup* const
to_EUC_KR_E7_2D_infos[17] = {
          o2(0xF9,0xB6),      o2(0xD4,0xF5),
          o2(0xD0,0xC9),      o2(0xEF,0xA7),
          o2(0xE2,0xEC),      o2(0xDB,0xEA),
          o2(0xCE,0xCC),      o2(0xF5,0xE8),
          o2(0xF7,0xD5),      o2(0xD3,0xCD),
          o2(0xF3,0xFE),      o2(0xD0,0xB5),
          o2(0xE0,0xFE),      o2(0xDF,0xFB),
          o2(0xE6,0xDD),      o2(0xE8,0xA4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_2D = {
    to_EUC_KR_E7_2D_offsets,
    to_EUC_KR_E7_2D_infos
};

static const unsigned char
to_EUC_KR_E7_2E_offsets[64] = {
     13, 13, 13, 13, 13, 13, 13,  0,     13, 13, 13,  1, 13, 13, 13,  2,
     13, 13, 13, 13,  3,  4, 13,  5,     13, 13,  6, 13, 13,  7, 13, 13,
     13,  8, 13, 13, 13, 13, 13, 13,     13, 13, 13, 13, 13,  9, 13, 13,
     13, 10, 13, 13, 11, 13, 13, 13,     12, 13, 13, 13, 13, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E7_2E_infos[14] = {
          o2(0xCB,0xCD),      o2(0xEF,0xA8),
          o2(0xEE,0xB4),      o2(0xDA,0xD8),
          o2(0xD1,0xB9),      o2(0xDF,0xA9),
          o2(0xF3,0xB0),      o2(0xCC,0xC4),
          o2(0xCE,0xB7),      o2(0xEF,0xA9),
          o2(0xDF,0xD5),      o2(0xED,0xD7),
          o2(0xEE,0xC6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_2E = {
    to_EUC_KR_E7_2E_offsets,
    to_EUC_KR_E7_2E_infos
};

static const unsigned char
to_EUC_KR_E7_2F_offsets[64] = {
      0,  1, 10, 10,  2, 10,  3,  4,     10,  5, 10, 10, 10, 10, 10, 10,
     10, 10,  6, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
      7, 10, 10, 10,  8, 10, 10, 10,     10,  9, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E7_2F_infos[11] = {
          o2(0xEF,0xBD),      o2(0xFC,0xD6),
          o2(0xDB,0xF4),      o2(0xEF,0xAA),
          o2(0xF8,0xB9),      o2(0xF5,0xE9),
          o2(0xE3,0xD9),      o2(0xE1,0xC6),
          o2(0xD4,0xBF),      o2(0xDE,0xE8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_2F = {
    to_EUC_KR_E7_2F_offsets,
    to_EUC_KR_E7_2F_infos
};

static const unsigned char
to_EUC_KR_E7_30_offsets[64] = {
     10, 10, 10, 10, 10, 10, 10,  0,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10,  1, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10,  2, 10,
     10,  3, 10, 10, 10, 10, 10,  4,     10, 10,  5,  6, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10,  7,  8,  9,
};

static const struct byte_lookup* const
to_EUC_KR_E7_30_infos[11] = {
          o2(0xF0,0xEA),      o2(0xF3,0xC2),
          o2(0xD3,0xAF),      o2(0xCA,0xDB),
          o2(0xFC,0xD7),      o2(0xED,0xD8),
          o2(0xE1,0xC7),      o2(0xF4,0xD8),
          o2(0xD6,0xB3),      o2(0xDD,0xAD),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_30 = {
    to_EUC_KR_E7_30_offsets,
    to_EUC_KR_E7_30_infos
};

static const unsigned char
to_EUC_KR_E7_31_offsets[64] = {
      7,  7,  7,  0,  7,  7,  7,  7,      7,  7,  7,  7,  1,  2,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      3,  7,  7,  7,  4,  7,  7,  7,      7,  7,  7,  7,  5,  7,  7,  7,
      7,  7,  7,  6,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_E7_31_infos[8] = {
          o2(0xD5,0xBE),      o2(0xF1,0xC3),
          o2(0xEE,0xDF),      o2(0xD6,0xEB),
          o2(0xF4,0xD9),      o2(0xD7,0xE6),
          o2(0xDA,0xB7),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_31 = {
    to_EUC_KR_E7_31_offsets,
    to_EUC_KR_E7_31_infos
};

static const unsigned char
to_EUC_KR_E7_32_offsets[64] = {
     15, 15, 15,  0, 15, 15, 15, 15,     15,  1, 15, 15, 15, 15, 15, 15,
     15, 15,  2, 15, 15,  3, 15,  4,      5, 15, 15, 15, 15, 15, 15,  6,
     15, 15, 15, 15, 15,  7, 15,  8,     15, 15, 15, 15, 15, 15,  9, 15,
     15, 10, 11, 12, 15, 15, 15, 15,     15, 13, 15, 15, 15, 15, 14, 15,
};

static const struct byte_lookup* const
to_EUC_KR_E7_32_infos[16] = {
          o2(0xDD,0xFB),      o2(0xDD,0xCF),
          o2(0xD8,0xA3),      o2(0xDA,0xD9),
          o2(0xF0,0xD8),      o2(0xEF,0xC4),
          o2(0xE1,0xD8),      o2(0xF1,0xD4),
          o2(0xED,0xF2),      o2(0xD5,0xDB),
          o2(0xD5,0xDC),      o2(0xF3,0xC4),
          o2(0xCB,0xD7),      o2(0xE2,0xB6),
          o2(0xEF,0xF1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_32 = {
    to_EUC_KR_E7_32_offsets,
    to_EUC_KR_E7_32_infos
};

static const unsigned char
to_EUC_KR_E7_33_offsets[64] = {
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  0,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  1,  8,      8,  8,  8,  8,  8,  8,  2,  3,
      4,  8,  8,  8,  8,  8,  8,  5,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  6,  8,  8,  7,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E7_33_infos[9] = {
          o2(0xFB,0xD5),      o2(0xD3,0xD8),
          o2(0xDD,0xD0),      o2(0xF0,0xD9),
          o2(0xCB,0xB3),      o2(0xD5,0xDD),
          o2(0xCD,0xA7),      o2(0xD0,0xAC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_33 = {
    to_EUC_KR_E7_33_offsets,
    to_EUC_KR_E7_33_infos
};

static const unsigned char
to_EUC_KR_E7_34_offsets[64] = {
      0, 29,  1, 29,  2,  3,  4,  5,      6, 29,  7,  8, 29,  9, 29, 29,
     10, 29, 29, 29, 11, 29, 29, 12,     13, 14, 15, 16, 29, 29, 29, 29,
     17, 18, 19, 29, 29, 29, 29, 29,     29, 29, 29, 20, 21, 29, 22, 23,
     24, 29, 29, 25, 29, 26, 29, 29,     29, 27, 28, 29, 29, 29, 29, 29,
};

static const struct byte_lookup* const
to_EUC_KR_E7_34_infos[30] = {
          o2(0xD1,0xBA),      o2(0xF1,0xC4),
          o2(0xE5,0xB3),      o2(0xFB,0xF5),
          o2(0xE9,0xE1),      o2(0xFD,0xE0),
          o2(0xFC,0xBC),      o2(0xDA,0xA2),
          o2(0xDA,0xA3),      o2(0xD2,0xA1),
          o2(0xD2,0xEF),      o2(0xE2,0xED),
          o2(0xDE,0xE9),      o2(0xCE,0xDC),
          o2(0xF2,0xB5),      o2(0xD0,0xE4),
          o2(0xDD,0xD1),      o2(0xE1,0xC8),
          o2(0xDB,0xB7),      o2(0xDF,0xE3),
          o2(0xED,0xB9),      o2(0xF1,0xC5),
          o2(0xF3,0xCF),      o2(0xD7,0xAB),
          o2(0xE1,0xAC),      o2(0xE3,0xEB),
          o2(0xEE,0xC7),      o2(0xE1,0xC9),
          o2(0xCA,0xFA),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_34 = {
    to_EUC_KR_E7_34_offsets,
    to_EUC_KR_E7_34_infos
};

static const unsigned char
to_EUC_KR_E7_35_offsets[64] = {
     19, 19,  0,  1,  2,  3,  4, 19,     19, 19, 19, 19, 19, 19, 19, 19,
      5, 19, 19, 19, 19, 19, 19, 19,     19, 19, 19, 19, 19, 19,  6, 19,
     19,  7,  8, 19, 19, 19,  9, 19,     10, 19, 11, 19, 19, 19, 12, 19,
     19, 13, 14, 15, 19, 19, 16, 19,     19, 17, 19, 19, 19, 19, 19, 18,
};

static const struct byte_lookup* const
to_EUC_KR_E7_35_infos[20] = {
          o2(0xF0,0xFB),      o2(0xFA,0xE1),
          o2(0xF0,0xDA),      o2(0xCC,0xE7),
          o2(0xDA,0xF4),      o2(0xCC,0xBF),
          o2(0xCE,0xED),      o2(0xD5,0xA9),
          o2(0xFA,0xE2),      o2(0xD0,0xE5),
          o2(0xEB,0xD6),      o2(0xEC,0xDF),
          o2(0xDF,0xFC),      o2(0xF7,0xD6),
          o2(0xDE,0xEA),      o2(0xCB,0xB4),
          o2(0xEF,0xBE),      o2(0xCC,0xB5),
          o2(0xCF,0xBD),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_35 = {
    to_EUC_KR_E7_35_offsets,
    to_EUC_KR_E7_35_infos
};

static const unsigned char
to_EUC_KR_E7_36_offsets[64] = {
     18, 18, 18, 18, 18, 18, 18, 18,     18, 18, 18, 18, 18, 18,  0,  1,
     18, 18, 18,  2, 18, 18, 18, 18,     18, 18, 18, 18,  3, 18, 18, 18,
      4, 18,  5, 18, 18, 18, 18, 18,     18, 18, 18, 18,  6,  7, 18, 18,
     18,  8,  9, 18, 10, 11, 18, 18,     12, 18, 13, 14, 18, 15, 16, 17,
};

static const struct byte_lookup* const
to_EUC_KR_E7_36_infos[19] = {
          o2(0xEF,0xF2),      o2(0xE2,0xB7),
          o2(0xCC,0xE8),      o2(0xF0,0xFC),
          o2(0xD6,0xE0),      o2(0xF1,0xC6),
          o2(0xE2,0xB8),      o2(0xEB,0xAB),
          o2(0xCB,0xB5),      o2(0xD8,0xD1),
          o2(0xF4,0xCE),      o2(0xF3,0xF7),
          o2(0xD7,0xC6),      o2(0xD1,0xBB),
          o2(0xF7,0xAA),      o2(0xED,0xCA),
          o2(0xD7,0xD3),      o2(0xD8,0xFA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_36 = {
    to_EUC_KR_E7_36_offsets,
    to_EUC_KR_E7_36_infos
};

static const unsigned char
to_EUC_KR_E7_37_offsets[64] = {
     17, 17, 17, 17, 17, 17, 17,  0,     17, 17,  1,  2, 17, 17, 17, 17,
     17, 17, 17, 17, 17, 17,  3, 17,      4, 17,  5, 17, 17,  6,  7, 17,
      8,  9, 17, 10, 17, 17, 17, 17,     11, 12, 17, 17, 13, 17, 17, 14,
     17, 17, 17, 17, 15, 17, 17, 17,     17, 17, 17, 16, 17, 17, 17, 17,
};

static const struct byte_lookup* const
to_EUC_KR_E7_37_infos[18] = {
          o2(0xF6,0xC5),      o2(0xD1,0xCC),
          o2(0xDD,0xFC),      o2(0xDF,0xFD),
          o2(0xF9,0xE5),      o2(0xE0,0xCA),
          o2(0xF2,0xFD),      o2(0xD3,0xB0),
          o2(0xF4,0xF3),      o2(0xDA,0xC9),
          o2(0xE6,0xDE),      o2(0xF8,0xBA),
          o2(0xE8,0xD0),      o2(0xD8,0xFB),
          o2(0xEA,0xD5),      o2(0xD6,0xA3),
          o2(0xF6,0xC6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_37 = {
    to_EUC_KR_E7_37_offsets,
    to_EUC_KR_E7_37_infos
};

static const unsigned char
to_EUC_KR_E7_38_offsets[64] = {
     16, 16, 16, 16, 16, 16, 16, 16,     16,  0,  1, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16,  2, 16, 16,     16, 16, 16,  3, 16,  4,  5,  6,
     16,  7, 16,  8, 16, 16, 16, 16,     16, 16, 16,  9, 16, 16, 10, 11,
     16, 12, 16, 16, 16, 16, 16, 13,     16, 16, 16, 16, 16, 14, 15, 16,
};

static const struct byte_lookup* const
to_EUC_KR_E7_38_infos[17] = {
          o2(0xF2,0xDB),      o2(0xE4,0xFC),
          o2(0xE8,0xB2),      o2(0xDA,0xDA),
          o2(0xF2,0xDC),      o2(0xFB,0xD6),
          o2(0xE9,0xB2),      o2(0xEE,0xAD),
          o2(0xFA,0xE3),      o2(0xDC,0xEE),
          o2(0xF5,0xEA),      o2(0xE6,0xE0),
          o2(0xF0,0xFD),      o2(0xD7,0xAC),
          o2(0xF5,0xC5),      o2(0xEE,0xE0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_38 = {
    to_EUC_KR_E7_38_offsets,
    to_EUC_KR_E7_38_infos
};

static const unsigned char
to_EUC_KR_E7_39_offsets[64] = {
     16,  0, 16,  1, 16, 16,  2,  3,     16, 16, 16, 16, 16, 16, 16, 16,
     16, 16,  4, 16,  5,  6, 16, 16,     16, 16, 16, 16, 16, 16,  7, 16,
     16,  8, 16, 16, 16, 16, 16, 16,     16,  9, 10, 11, 16, 12, 16, 16,
     13, 16, 16, 16, 16, 16, 16, 16,     16, 14, 16, 16, 15, 16, 16, 16,
};

static const struct byte_lookup* const
to_EUC_KR_E7_39_infos[17] = {
          o2(0xDB,0xE5),      o2(0xDD,0xDE),
          o2(0xD9,0xF0),      o2(0xE9,0xA3),
          o2(0xF1,0xF9),      o2(0xF2,0xC4),
          o2(0xE0,0xCB),      o2(0xE9,0xA4),
          o2(0xE2,0xB9),      o2(0xE3,0xB1),
          o2(0xFC,0xEB),      o2(0xCD,0xA8),
          o2(0xCC,0xB6),      o2(0xF0,0xDB),
          o2(0xE6,0xBA),      o2(0xCD,0xA9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_39 = {
    to_EUC_KR_E7_39_offsets,
    to_EUC_KR_E7_39_infos
};

static const unsigned char
to_EUC_KR_E7_3A_offsets[64] = {
      8,  8,  0,  8,  8,  8,  8,  8,      8,  8,  8,  8,  1,  8,  8,  2,
      8,  8,  8,  3,  8,  8,  4,  8,      5,  8,  8,  6,  7,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E7_3A_infos[9] = {
          o2(0xF3,0xC3),      o2(0xE1,0xD9),
          o2(0xEF,0xAB),      o2(0xE7,0xC5),
          o2(0xE0,0xE9),      o2(0xF3,0xC5),
          o2(0xD4,0xC0),      o2(0xD5,0xBF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_3A = {
    to_EUC_KR_E7_3A_offsets,
    to_EUC_KR_E7_3A_infos
};

static const unsigned char
to_EUC_KR_E7_3C_offsets[64] = {
      3,  3,  3,  3,  3,  3,  3,  3,      3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,      3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,      3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  0,  3,      1,  3,  2,  3,  3,  3,  3,  3,
};

static const struct byte_lookup* const
to_EUC_KR_E7_3C_infos[4] = {
          o2(0xDD,0xAE),      o2(0xF9,0xFC),
          o2(0xCC,0xC0),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_3C = {
    to_EUC_KR_E7_3C_offsets,
    to_EUC_KR_E7_3C_infos
};

static const unsigned char
to_EUC_KR_E7_3D_offsets[64] = {
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12,  0, 12, 12, 12,
      1, 12, 12, 12,  2,  3, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12,  4,  5, 12, 12,  6, 12,
      7, 12,  8, 12, 12,  9, 12, 10,     12, 11, 12, 12, 12, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_E7_3D_infos[13] = {
          o2(0xE5,0xA2),      o2(0xCE,0xB8),
          o2(0xD8,0xD2),      o2(0xF9,0xD6),
          o2(0xF1,0xAA),      o2(0xCE,0xD1),
          o2(0xF6,0xC7),      o2(0xDB,0xEB),
          o2(0xDF,0xFE),      o2(0xD8,0xE1),
          o2(0xF7,0xF3),      o2(0xD7,0xE7),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_3D = {
    to_EUC_KR_E7_3D_offsets,
    to_EUC_KR_E7_3D_infos
};

static const unsigned char
to_EUC_KR_E7_3E_offsets[64] = {
     15, 15, 15, 15, 15,  0, 15, 15,      1, 15,  2, 15,  3, 15,  4, 15,
     15, 15, 15, 15,  5, 15, 15, 15,     15, 15,  6, 15, 15, 15,  7, 15,
     15, 15, 15, 15,  8, 15, 15, 15,      9, 10, 15, 15, 15, 15, 15, 15,
     15, 15, 11, 15, 15, 15, 15, 15,     12, 13, 15, 15, 15, 14, 15, 15,
};

static const struct byte_lookup* const
to_EUC_KR_E7_3E_infos[16] = {
          o2(0xD4,0xFE),      o2(0xD1,0xBC),
          o2(0xE5,0xCF),      o2(0xCB,0xB6),
          o2(0xDA,0xB8),      o2(0xCD,0xC4),
          o2(0xD6,0xBE),      o2(0xE2,0xBA),
          o2(0xCF,0xD8),      o2(0xE0,0xCC),
          o2(0xEB,0xF9),      o2(0xFD,0xFD),
          o2(0xD7,0xE8),      o2(0xCB,0xD8),
          o2(0xE9,0xE2),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_3E = {
    to_EUC_KR_E7_3E_offsets,
    to_EUC_KR_E7_3E_infos
};

static const unsigned char
to_EUC_KR_E7_3F_offsets[64] = {
     16,  0, 16, 16, 16,  1, 16, 16,     16, 16,  2, 16,  3, 16,  4, 16,
     16, 16,  5, 16,  6,  7, 16, 16,     16, 16, 16, 16, 16, 16, 16,  8,
      9, 10, 16, 16, 16, 16, 16, 16,     16, 11, 16, 12, 16, 16, 16, 16,
     13, 16, 16, 16, 16, 16, 16, 16,     16, 14, 16, 16, 15, 16, 16, 16,
};

static const struct byte_lookup* const
to_EUC_KR_E7_3F_infos[17] = {
          o2(0xE8,0xBA),      o2(0xE3,0xC7),
          o2(0xEC,0xCD),      o2(0xEC,0xCE),
          o2(0xD6,0xBF),      o2(0xE3,0xA7),
          o2(0xDF,0xD6),      o2(0xFD,0xE8),
          o2(0xEE,0xE1),      o2(0xF6,0xA8),
          o2(0xDD,0xFD),      o2(0xF8,0xBB),
          o2(0xE8,0xD1),      o2(0xF9,0xD7),
          o2(0xCE,0xEE),      o2(0xEC,0xCF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7_3F = {
    to_EUC_KR_E7_3F_offsets,
    to_EUC_KR_E7_3F_infos
};

static const unsigned char
to_EUC_KR_E7_offsets[64] = {
      0,  1,  2,  3,  4,  5,  6,  7,      8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,     24, 25, 26, 27, 28, 29, 30, 31,
     32, 33, 34, 35, 36, 37, 38, 39,     40, 41, 42, 43, 44, 45, 46, 47,
     48, 49, 50, 51, 52, 53, 54, 55,     56, 57, 58, 63, 59, 60, 61, 62,
};

static const struct byte_lookup* const
to_EUC_KR_E7_infos[64] = {
       &to_EUC_KR_E7_00,   &to_EUC_KR_E7_01,
       &to_EUC_KR_E7_02,   &to_EUC_KR_E7_03,
       &to_EUC_KR_E7_04,   &to_EUC_KR_E7_05,
       &to_EUC_KR_E7_06,   &to_EUC_KR_E7_07,
       &to_EUC_KR_E7_08,   &to_EUC_KR_E7_09,
       &to_EUC_KR_E7_0A,   &to_EUC_KR_E7_0B,
       &to_EUC_KR_E7_0C,   &to_EUC_KR_E7_0D,
       &to_EUC_KR_E7_0E,   &to_EUC_KR_E7_0F,
       &to_EUC_KR_E7_10,   &to_EUC_KR_E7_11,
       &to_EUC_KR_E7_12,   &to_EUC_KR_E7_13,
       &to_EUC_KR_E7_14,   &to_EUC_KR_E7_15,
       &to_EUC_KR_E7_16,   &to_EUC_KR_E7_17,
       &to_EUC_KR_E7_18,   &to_EUC_KR_E7_19,
       &to_EUC_KR_E7_1A,   &to_EUC_KR_E7_1B,
       &to_EUC_KR_E7_1C,   &to_EUC_KR_E7_1D,
       &to_EUC_KR_E7_1E,   &to_EUC_KR_E7_1F,
       &to_EUC_KR_E7_20,   &to_EUC_KR_E7_21,
       &to_EUC_KR_E7_22,   &to_EUC_KR_E7_23,
       &to_EUC_KR_E7_24,   &to_EUC_KR_E7_25,
       &to_EUC_KR_E7_26,   &to_EUC_KR_E7_27,
       &to_EUC_KR_E7_28,   &to_EUC_KR_E7_29,
       &to_EUC_KR_E7_2A,   &to_EUC_KR_E7_2B,
       &to_EUC_KR_E7_2C,   &to_EUC_KR_E7_2D,
       &to_EUC_KR_E7_2E,   &to_EUC_KR_E7_2F,
       &to_EUC_KR_E7_30,   &to_EUC_KR_E7_31,
       &to_EUC_KR_E7_32,   &to_EUC_KR_E7_33,
       &to_EUC_KR_E7_34,   &to_EUC_KR_E7_35,
       &to_EUC_KR_E7_36,   &to_EUC_KR_E7_37,
       &to_EUC_KR_E7_38,   &to_EUC_KR_E7_39,
       &to_EUC_KR_E7_3A,   &to_EUC_KR_E7_3C,
       &to_EUC_KR_E7_3D,   &to_EUC_KR_E7_3E,
       &to_EUC_KR_E7_3F,              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E7 = {
    to_EUC_KR_E7_offsets,
    to_EUC_KR_E7_infos
};

static const unsigned char
to_EUC_KR_E8_00_offsets[64] = {
      0,  1, 16,  2, 16,  3,  4, 16,     16,  5, 16, 16,  6, 16, 16, 16,
      7, 16, 16, 16, 16,  8, 16,  9,     10, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,     16, 16, 16, 16, 16, 11, 16, 16,
     16, 16, 16, 12, 16, 16, 13, 16,     16, 16, 16, 16, 16, 14, 16, 15,
};

static const struct byte_lookup* const
to_EUC_KR_E8_00_infos[17] = {
          o2(0xE9,0xA5),      o2(0xD6,0xD5),
          o2(0xCD,0xC5),      o2(0xED,0xBA),
          o2(0xD1,0xBD),      o2(0xCF,0xBE),
          o2(0xEC,0xBB),      o2(0xD2,0xB1),
          o2(0xCC,0xE9),      o2(0xD9,0xC4),
          o2(0xE9,0xFC),      o2(0xD1,0xBE),
          o2(0xEC,0xBC),      o2(0xE5,0xAD),
          o2(0xF7,0xB0),      o2(0xCC,0xEA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_00 = {
    to_EUC_KR_E8_00_offsets,
    to_EUC_KR_E8_00_infos
};

static const unsigned char
to_EUC_KR_E8_01_offsets[64] = {
     15, 15, 15,  0, 15, 15,  1, 15,     15, 15,  2, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15,  3, 15,      4, 15,  5, 15, 15, 15,  6, 15,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15,  7,
      8, 15,  9, 10, 15, 15, 15, 11,     15, 15, 15, 15, 15, 12, 13, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E8_01_infos[16] = {
          o2(0xD3,0xC4),      o2(0xD6,0xC0),
          o2(0xD6,0xFD),      o2(0xE1,0xA1),
          o2(0xDE,0xBD),      o2(0xF6,0xA9),
          o2(0xDA,0xA4),      o2(0xD6,0xA4),
          o2(0xF5,0xC6),      o2(0xE1,0xA2),
          o2(0xE9,0xC6),      o2(0xF2,0xC5),
          o2(0xF4,0xE9),      o2(0xD6,0xEC),
          o2(0xEB,0xD3),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_01 = {
    to_EUC_KR_E8_01_offsets,
    to_EUC_KR_E8_01_infos
};

static const unsigned char
to_EUC_KR_E8_02_offsets[64] = {
     20, 20, 20, 20,  0,  1,  2,  3,     20,  4, 20,  5,  6, 20, 20, 20,
     20, 20, 20, 20, 20, 20,  7, 20,     20, 20, 20,  8, 20,  9, 20, 20,
     20, 10, 11, 20, 20, 12, 20, 20,     20, 13, 14, 20, 20, 20, 20, 15,
     20, 16, 17, 20, 18, 20, 20, 20,     20, 20, 19, 20, 20, 20, 20, 20,
};

static const struct byte_lookup* const
to_EUC_KR_E8_02_infos[21] = {
          o2(0xEC,0xBD),      o2(0xE2,0xDC),
          o2(0xDE,0xEB),      o2(0xF0,0xDC),
          o2(0xEB,0xBF),      o2(0xD7,0xCE),
          o2(0xD1,0xBF),      o2(0xF5,0xAB),
          o2(0xF9,0xFD),      o2(0xCA,0xDC),
          o2(0xCD,0xC6),      o2(0xF2,0xB6),
          o2(0xDD,0xFE),      o2(0xCC,0xB7),
          o2(0xDB,0xB8),      o2(0xD0,0xE9),
          o2(0xCE,0xDD),      o2(0xEB,0xC0),
          o2(0xFD,0xA2),      o2(0xF8,0xCB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_02 = {
    to_EUC_KR_E8_02_offsets,
    to_EUC_KR_E8_02_infos
};

static const unsigned char
to_EUC_KR_E8_03_offsets[64] = {
     14, 14, 14,  0,  1, 14, 14, 14,     14, 14, 14, 14,  2, 14,  3, 14,
     14, 14, 14, 14, 14, 14, 14, 14,     14, 14,  4,  5, 14, 14,  6, 14,
     14,  7, 14, 14,  8,  9, 14, 14,     14, 14, 14, 14, 14, 14, 14, 14,
     14, 10, 14, 14, 11, 14, 14, 14,     12, 14, 14, 14, 14, 13, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E8_03_infos[15] = {
          o2(0xEA,0xD6),      o2(0xF1,0xB0),
          o2(0xDB,0xCE),      o2(0xF7,0xC3),
          o2(0xDB,0xCF),      o2(0xCB,0xA4),
          o2(0xF8,0xE0),      o2(0xFB,0xD7),
          o2(0xEB,0xCA),      o2(0xE0,0xA1),
          o2(0xCE,0xCD),      o2(0xD4,0xDC),
          o2(0xFD,0xD8),      o2(0xD2,0xF6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_03 = {
    to_EUC_KR_E8_03_offsets,
    to_EUC_KR_E8_03_infos
};

static const unsigned char
to_EUC_KR_E8_04_offsets[64] = {
     15, 15,  0, 15, 15,  1,  2,  3,      4, 15,  5, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,      6, 15,  7,  8, 15, 15, 15, 15,
     15, 15, 15,  9, 15, 15, 15, 15,     15, 10, 15, 11, 15, 15, 15, 12,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 13, 15, 15, 15, 15, 14, 15,
};

static const struct byte_lookup* const
to_EUC_KR_E8_04_infos[16] = {
          o2(0xF2,0xB7),      o2(0xFA,0xF6),
          o2(0xF6,0xAA),      o2(0xFA,0xF7),
          o2(0xD8,0xE6),      o2(0xF4,0xB1),
          o2(0xE8,0xD2),      o2(0xCA,0xC5),
          o2(0xCC,0xEB),      o2(0xE2,0xEE),
          o2(0xE2,0xBB),      o2(0xF7,0xAD),
          o2(0xF8,0xE1),      o2(0xF3,0xEC),
          o2(0xDE,0xA1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_04 = {
    to_EUC_KR_E8_04_offsets,
    to_EUC_KR_E8_04_infos
};

static const unsigned char
to_EUC_KR_E8_05_offsets[64] = {
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15,  0, 15, 15,  1, 15,
      2,  3, 15, 15,  4,  5, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15,  6,  7, 15,     15, 15, 15,  8, 15, 15, 15, 15,
      9, 10, 15, 15, 15, 15, 15, 15,     11, 12, 13, 15, 15, 15, 15, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E8_05_infos[16] = {
          o2(0xE4,0xFD),      o2(0xE3,0xEC),
          o2(0xDD,0xAF),      o2(0xDD,0xB0),
          o2(0xCB,0xB7),      o2(0xE8,0xD3),
          o2(0xE1,0xA3),      o2(0xD2,0xE0),
          o2(0xF0,0xFE),      o2(0xE9,0xA6),
          o2(0xCB,0xF2),      o2(0xED,0xF3),
          o2(0xDC,0xD9),      o2(0xE0,0xCD),
          o2(0xF7,0xDA),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_05 = {
    to_EUC_KR_E8_05_offsets,
    to_EUC_KR_E8_05_infos
};

static const unsigned char
to_EUC_KR_E8_06_offsets[64] = {
      0, 16, 16, 16, 16, 16, 16, 16,      1, 16,  2, 16, 16, 16, 16,  3,
     16, 16, 16, 16, 16, 16, 16, 16,     16, 16,  4, 16,  5,  6, 16, 16,
      7, 16, 16,  8, 16, 16, 16, 16,      9, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 10, 16, 11, 16, 16,     16, 16, 12, 16, 16, 13, 14, 15,
};

static const struct byte_lookup* const
to_EUC_KR_E8_06_infos[17] = {
          o2(0xDB,0xB9),      o2(0xCC,0xAE),
          o2(0xDA,0xDB),      o2(0xCD,0xC7),
          o2(0xDD,0xB1),      o2(0xD8,0xAF),
          o2(0xE3,0xA3),      o2(0xCE,0xEF),
          o2(0xF2,0xF3),      o2(0xF8,0xB3),
          o2(0xE0,0xCE),      o2(0xF5,0xFD),
          o2(0xEB,0xEC),      o2(0xD3,0xC5),
          o2(0xFC,0xEC),      o2(0xD2,0xDB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_06 = {
    to_EUC_KR_E8_06_offsets,
    to_EUC_KR_E8_06_infos
};

static const unsigned char
to_EUC_KR_E8_07_offsets[64] = {
      0, 18,  1, 18, 18, 18,  2, 18,     18, 18, 18, 18, 18,  3, 18, 18,
     18, 18, 18, 18, 18, 18, 18, 18,      4, 18, 18, 18, 18, 18, 18,  5,
     18, 18, 18,  6, 18,  7, 18,  8,      9, 18, 10, 18, 18, 11, 18, 18,
     18, 18, 18, 12, 13, 18, 18, 18,     18, 18, 14, 15, 16, 18, 17, 18,
};

static const struct byte_lookup* const
to_EUC_KR_E8_07_infos[19] = {
          o2(0xD4,0xEB),      o2(0xDE,0xA2),
          o2(0xE5,0xE6),      o2(0xF0,0xB0),
          o2(0xD5,0xC4),      o2(0xED,0xF4),
          o2(0xE3,0xED),      o2(0xE8,0xC2),
          o2(0xED,0xF5),      o2(0xD7,0xFC),
          o2(0xED,0xBB),      o2(0xF6,0xAB),
          o2(0xF2,0xB8),      o2(0xF6,0xC8),
          o2(0xD3,0xE6),      o2(0xF2,0xDD),
          o2(0xCF,0xBF),      o2(0xEB,0xAC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_07 = {
    to_EUC_KR_E8_07_offsets,
    to_EUC_KR_E8_07_infos
};

static const unsigned char
to_EUC_KR_E8_08_offsets[64] = {
     19, 19, 19, 19, 19,  0, 19,  1,      2, 19,  3, 19,  4,  5, 19, 19,
     19, 19,  6, 19, 19, 19, 19, 19,     19, 19, 19,  7,  8, 19,  9, 10,
     19, 11, 19, 19, 19, 19, 19, 19,     19, 19, 12, 13, 14, 19, 19, 19,
     19, 19, 19, 19, 19, 15, 16, 17,     19, 18, 19, 19, 19, 19, 19, 19,
};

static const struct byte_lookup* const
to_EUC_KR_E8_08_infos[20] = {
          o2(0xCF,0xC0),      o2(0xE6,0xA8),
          o2(0xFD,0xE9),      o2(0xCF,0xC1),
          o2(0xE0,0xDF),      o2(0xDE,0xEC),
          o2(0xE0,0xA2),      o2(0xF4,0xBF),
          o2(0xE2,0xEF),      o2(0xD9,0xF1),
          o2(0xF1,0xC7),      o2(0xCB,0xB8),
          o2(0xF9,0xFE),      o2(0xDB,0xBA),
          o2(0xDA,0xF5),      o2(0xF6,0xEC),
          o2(0xDA,0xDC),      o2(0xFA,0xE4),
          o2(0xE0,0xCF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_08 = {
    to_EUC_KR_E8_08_offsets,
    to_EUC_KR_E8_08_infos
};

static const unsigned char
to_EUC_KR_E8_09_offsets[64] = {
      0, 13, 13, 13, 13,  1, 13,  2,     13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,     13,  3, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13,  4, 13,  5, 13,     13, 13, 13, 13, 13, 13,  6,  7,
     13,  8,  9, 13, 13, 13, 10, 13,     11, 13, 13, 13, 13, 13, 12, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E8_09_infos[14] = {
          o2(0xDD,0xB2),      o2(0xE6,0xA9),
          o2(0xEF,0xF3),      o2(0xF3,0xED),
          o2(0xEB,0xFA),      o2(0xF9,0xE6),
          o2(0xCA,0xDD),      o2(0xD5,0xDE),
          o2(0xCA,0xDE),      o2(0xDF,0xE4),
          o2(0xE6,0xFD),      o2(0xF5,0xAC),
          o2(0xE4,0xF5),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_09 = {
    to_EUC_KR_E8_09_offsets,
    to_EUC_KR_E8_09_infos
};

static const unsigned char
to_EUC_KR_E8_0A_offsets[64] = {
     24, 24, 24, 24, 24, 24, 24, 24,     24, 24, 24,  0, 24,  1,  2, 24,
     24, 24,  3, 24, 24, 24, 24, 24,     24,  4,  5, 24, 24,  6, 24,  7,
     24, 24, 24, 24, 24,  8,  9, 24,     24, 10, 24, 24, 11, 12, 13, 14,
     24, 15, 24, 16, 24, 24, 24, 17,     18, 19, 24, 20, 21, 22, 24, 23,
};

static const struct byte_lookup* const
to_EUC_KR_E8_0A_infos[25] = {
          o2(0xE9,0xE3),      o2(0xED,0xCB),
          o2(0xCF,0xE4),      o2(0xD8,0xD3),
          o2(0xDD,0xB3),      o2(0xD4,0xEC),
          o2(0xF2,0xB9),      o2(0xDF,0xB7),
          o2(0xCB,0xCE),      o2(0xFB,0xD8),
          o2(0xD0,0xD9),      o2(0xDD,0xD2),
          o2(0xF7,0xF4),      o2(0xE7,0xDC),
          o2(0xE4,0xA5),      o2(0xFC,0xA3),
          o2(0xDB,0xBB),      o2(0xF2,0xBA),
          o2(0xE9,0xFD),      o2(0xD0,0xCA),
          o2(0xF5,0xD6),      o2(0xD9,0xC5),
          o2(0xE4,0xB4),      o2(0xED,0xA7),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_0A = {
    to_EUC_KR_E8_0A_offsets,
    to_EUC_KR_E8_0A_infos
};

static const unsigned char
to_EUC_KR_E8_0B_offsets[64] = {
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
     15,  0,  1, 15,  2,  3, 15,  4,     15, 15, 15,  5, 15, 15,  6,  7,
     15,  8, 15, 15, 15,  9, 10, 11,     15, 15, 15, 15, 15, 15, 15, 15,
     15, 12, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 13, 14, 15,
};

static const struct byte_lookup* const
to_EUC_KR_E8_0B_infos[16] = {
          o2(0xEA,0xBD),      o2(0xE6,0xFE),
          o2(0xF7,0xC4),      o2(0xF5,0xAD),
          o2(0xD9,0xE0),      o2(0xCA,0xB4),
          o2(0xF8,0xE2),      o2(0xCF,0xC2),
          o2(0xEC,0xBE),      o2(0xE5,0xB4),
          o2(0xCD,0xC8),      o2(0xEE,0xC8),
          o2(0xE7,0xC8),      o2(0xCD,0xC9),
          o2(0xF9,0xB7),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_0B = {
    to_EUC_KR_E8_0B_offsets,
    to_EUC_KR_E8_0B_infos
};

static const unsigned char
to_EUC_KR_E8_0C_offsets[64] = {
     16,  0,  1,  2,  3,  4, 16, 16,     16,  5, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16,  6,     16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,      7, 16, 16,  8, 16, 16, 16,  9,
     16, 10, 16, 16, 11, 12, 13, 16,     14, 15, 16, 16, 16, 16, 16, 16,
};

static const struct byte_lookup* const
to_EUC_KR_E8_0C_infos[17] = {
          o2(0xF1,0xE8),      o2(0xD9,0xF2),
          o2(0xDB,0xF5),      o2(0xCA,0xB5),
          o2(0xD9,0xC6),      o2(0xD8,0xC9),
          o2(0xD9,0xAB),      o2(0xED,0xBC),
          o2(0xD8,0xD4),      o2(0xDC,0xDA),
          o2(0xE2,0xBC),      o2(0xFC,0xED),
          o2(0xEC,0xE0),      o2(0xD2,0xFE),
          o2(0xE9,0xC7),      o2(0xE6,0xAA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_0C = {
    to_EUC_KR_E8_0C_offsets,
    to_EUC_KR_E8_0C_infos
};

static const unsigned char
to_EUC_KR_E8_0D_offsets[64] = {
      0, 10, 10, 10, 10, 10, 10,  1,     10,  2,  3, 10, 10, 10, 10,  4,
     10,  5,  6, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10,  7, 10, 10, 10,  8,     10, 10, 10,  9, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E8_0D_infos[11] = {
          o2(0xE2,0xF0),      o2(0xFA,0xBB),
          o2(0xF5,0xAE),      o2(0xFB,0xAA),
          o2(0xEC,0xFB),      o2(0xEC,0xBF),
          o2(0xFC,0xD8),      o2(0xD4,0xE5),
          o2(0xF9,0xC3),      o2(0xEE,0xE2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_0D = {
    to_EUC_KR_E8_0D_offsets,
    to_EUC_KR_E8_0D_infos
};

static const unsigned char
to_EUC_KR_E8_0E_offsets[64] = {
     11, 11, 11, 11, 11, 11, 11, 11,     11,  0,  1, 11, 11, 11,  2, 11,
     11, 11, 11, 11, 11, 11,  3, 11,      4, 11, 11, 11, 11, 11,  5, 11,
     11, 11,  6, 11, 11, 11, 11, 11,     11,  7,  8,  9, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 10, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_E8_0E_infos[12] = {
          o2(0xD7,0xE9),      o2(0xED,0xF6),
          o2(0xDE,0xED),      o2(0xCC,0xEC),
          o2(0xE3,0xEE),      o2(0xE8,0xD4),
          o2(0xFA,0xF8),      o2(0xDD,0xB4),
          o2(0xE4,0xB5),      o2(0xD8,0xB0),
          o2(0xD8,0xD5),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_0E = {
    to_EUC_KR_E8_0E_offsets,
    to_EUC_KR_E8_0E_infos
};

static const unsigned char
to_EUC_KR_E8_0F_offsets[64] = {
     17,  0, 17, 17, 17,  1, 17, 17,     17,  2,  3, 17,  4, 17, 17, 17,
     17, 17, 17,  5, 17, 17,  6, 17,     17, 17, 17, 17,  7, 17, 17, 17,
     17, 17, 17, 17, 17, 17, 17, 17,     17,  8, 17,  9, 17, 17, 17, 10,
     11, 12, 13, 17, 14, 17, 17, 17,     17, 15, 17, 17, 17, 16, 17, 17,
};

static const struct byte_lookup* const
to_EUC_KR_E8_0F_infos[18] = {
          o2(0xF4,0xEA),      o2(0xCE,0xB9),
          o2(0xD6,0xE1),      o2(0xCF,0xD2),
          o2(0xD0,0xB6),      o2(0xCE,0xA2),
          o2(0xF3,0xEE),      o2(0xF3,0xF8),
          o2(0xDC,0xCC),      o2(0xD0,0xCB),
          o2(0xFC,0xA4),      o2(0xCD,0xCA),
          o2(0xD7,0xD4),      o2(0xDE,0xA3),
          o2(0xE4,0xE0),      o2(0xEE,0xC9),
          o2(0xE2,0xDD),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_0F = {
    to_EUC_KR_E8_0F_offsets,
    to_EUC_KR_E8_0F_infos
};

static const unsigned char
to_EUC_KR_E8_10_offsets[64] = {
     11, 11, 11,  0,  1, 11, 11, 11,     11, 11,  2, 11,  3,  4,  5, 11,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,     11,  6, 11, 11,  7, 11, 11, 11,
     11,  8, 11, 11, 11, 11, 11, 11,      9, 11, 11, 11, 11, 10, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_E8_10_infos[12] = {
          o2(0xF5,0xFE),      o2(0xD4,0xAC),
          o2(0xD5,0xD1),      o2(0xD8,0xF0),
          o2(0xF8,0xC3),      o2(0xEA,0xD7),
          o2(0xF5,0xD7),      o2(0xD8,0xBF),
          o2(0xFD,0xC0),      o2(0xEB,0xAD),
          o2(0xD5,0xAA),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_10 = {
    to_EUC_KR_E8_10_offsets,
    to_EUC_KR_E8_10_infos
};

static const unsigned char
to_EUC_KR_E8_11_offsets[64] = {
     11, 11, 11, 11, 11, 11, 11, 11,     11,  0, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11,  1,     11, 11, 11,  2, 11, 11, 11, 11,
     11,  3, 11,  4, 11, 11,  5, 11,     11, 11, 11,  6,  7, 11, 11,  8,
     11, 11, 11, 11, 11,  9, 11, 11,     11, 11, 10, 11, 11, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_E8_11_infos[12] = {
          o2(0xE7,0xA8),      o2(0xEE,0xCA),
          o2(0xCA,0xE7),      o2(0xF8,0xE3),
          o2(0xD4,0xDD),      o2(0xEA,0xD8),
          o2(0xFB,0xD9),      o2(0xED,0xF7),
          o2(0xE5,0xB5),      o2(0xD0,0xAD),
          o2(0xF1,0xF1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_11 = {
    to_EUC_KR_E8_11_offsets,
    to_EUC_KR_E8_11_infos
};

static const unsigned char
to_EUC_KR_E8_12_offsets[64] = {
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
      0, 10, 10, 10,  1, 10, 10, 10,     10,  2, 10, 10,  3, 10, 10, 10,
     10,  4, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10,  5, 10, 10, 10, 10, 10,      6, 10, 10,  7,  8, 10, 10,  9,
};

static const struct byte_lookup* const
to_EUC_KR_E8_12_infos[11] = {
          o2(0xE2,0xBD),      o2(0xE3,0xC8),
          o2(0xD9,0xD5),      o2(0xDF,0xAA),
          o2(0xDB,0xBC),      o2(0xF8,0xE4),
          o2(0xF1,0xFA),      o2(0xE5,0xB6),
          o2(0xF3,0xEF),      o2(0xFB,0xDA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_12 = {
    to_EUC_KR_E8_12_offsets,
    to_EUC_KR_E8_12_infos
};

static const unsigned char
to_EUC_KR_E8_13_offsets[64] = {
      0, 13,  1, 13,  2, 13,  3, 13,     13,  4, 13,  5, 13,  6, 13, 13,
     13,  7, 13, 13, 13, 13, 13, 13,     13, 13,  8, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,     13, 13, 13, 13,  9, 13, 10, 13,
     13, 13, 13, 13, 11, 13, 13, 13,     13, 13, 13, 13, 12, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E8_13_infos[14] = {
          o2(0xE1,0xE0),      o2(0xD9,0xAC),
          o2(0xF5,0xEB),      o2(0xE0,0xB6),
          o2(0xE9,0xC8),      o2(0xCB,0xCF),
          o2(0xE3,0xC9),      o2(0xDE,0xEE),
          o2(0xE2,0xBE),      o2(0xDC,0xEF),
          o2(0xD6,0xA5),      o2(0xE2,0xF1),
          o2(0xD6,0xFE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_13 = {
    to_EUC_KR_E8_13_offsets,
    to_EUC_KR_E8_13_infos
};

static const unsigned char
to_EUC_KR_E8_14_offsets[64] = {
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
     15,  0, 15,  1,  2, 15, 15,  3,      4, 15,  5, 15, 15, 15,  6, 15,
     15,  7, 15,  8, 15,  9, 15, 15,     15, 15, 15, 15, 10, 11, 15, 12,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 13, 15, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E8_14_infos[16] = {
          o2(0xD9,0xA1),      o2(0xD8,0xC0),
          o2(0xDC,0xDB),      o2(0xED,0xBD),
          o2(0xDF,0xB8),      o2(0xEA,0xA5),
          o2(0xD7,0xAD),      o2(0xF3,0xF9),
          o2(0xED,0xF8),      o2(0xF5,0xC7),
          o2(0xE1,0xCA),      o2(0xEB,0xE3),
          o2(0xF2,0xDE),      o2(0xF8,0xCC),
          o2(0xEA,0xD9),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_14 = {
    to_EUC_KR_E8_14_offsets,
    to_EUC_KR_E8_14_infos
};

static const unsigned char
to_EUC_KR_E8_15_offsets[64] = {
     11,  0, 11,  1, 11, 11, 11, 11,     11,  2, 11, 11, 11, 11,  3, 11,
     11, 11, 11,  4, 11, 11, 11, 11,     11,  5, 11, 11, 11, 11, 11, 11,
     11, 11, 11,  6, 11, 11, 11, 11,      7,  8,  9, 11, 11, 10, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_E8_15_infos[12] = {
          o2(0xD3,0xC6),      o2(0xDB,0xE6),
          o2(0xF5,0xAF),      o2(0xCE,0xF0),
          o2(0xE9,0xFE),      o2(0xFB,0xB6),
          o2(0xE2,0xF2),      o2(0xCF,0xF2),
          o2(0xF7,0xB9),      o2(0xD9,0xF3),
          o2(0xE1,0xCB),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_15 = {
    to_EUC_KR_E8_15_offsets,
    to_EUC_KR_E8_15_infos
};

static const unsigned char
to_EUC_KR_E8_16_offsets[64] = {
     13, 13, 13, 13,  0, 13, 13,  1,     13, 13, 13, 13, 13, 13, 13,  2,
     13,  3, 13, 13,  4, 13, 13, 13,     13, 13, 13,  5, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13,  6, 13,      7,  8,  9, 13, 13, 13, 13, 10,
     11, 13, 13, 13, 13, 13, 13, 13,     13, 13, 12, 13, 13, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E8_16_infos[14] = {
          o2(0xDA,0xDD),      o2(0xDA,0xB9),
          o2(0xEB,0xFB),      o2(0xCB,0xB9),
          o2(0xED,0xF9),      o2(0xE0,0xE0),
          o2(0xF4,0xC0),      o2(0xFD,0xBC),
          o2(0xDF,0xB1),      o2(0xE3,0xEF),
          o2(0xE0,0xA3),      o2(0xFD,0xB9),
          o2(0xF0,0xB1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_16 = {
    to_EUC_KR_E8_16_offsets,
    to_EUC_KR_E8_16_infos
};

static const unsigned char
to_EUC_KR_E8_17_offsets[64] = {
     16,  0, 16, 16, 16, 16, 16, 16,     16,  1, 16, 16, 16,  2,  3,  4,
     16, 16, 16, 16, 16,  5, 16, 16,     16, 16, 16, 16,  6,  7, 16, 16,
     16, 16, 16, 16,  8,  9, 16, 16,     16, 10, 11, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 12,     16, 16, 13, 14, 16, 16, 16, 15,
};

static const struct byte_lookup* const
to_EUC_KR_E8_17_infos[17] = {
          o2(0xCD,0xCB),      o2(0xED,0xBE),
          o2(0xD5,0xC0),      o2(0xE3,0xF0),
          o2(0xED,0xFA),      o2(0xE9,0xE4),
          o2(0xD5,0xED),      o2(0xE7,0xDD),
          o2(0xD4,0xF6),      o2(0xE5,0xB7),
          o2(0xDB,0xE7),      o2(0xE2,0xBF),
          o2(0xEE,0xCB),      o2(0xD7,0xF4),
          o2(0xF0,0xDD),      o2(0xCE,0xAB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_17 = {
    to_EUC_KR_E8_17_offsets,
    to_EUC_KR_E8_17_infos
};

static const unsigned char
to_EUC_KR_E8_18_offsets[64] = {
      9,  9,  0,  9,  9,  9,  1,  2,      9,  9,  3,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  4,  5,      9,  9,  6,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  7,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E8_18_infos[10] = {
          o2(0xE7,0xDE),      o2(0xD6,0xD6),
          o2(0xE1,0xCC),      o2(0xE8,0xB3),
          o2(0xE5,0xEE),      o2(0xDC,0xA2),
          o2(0xE0,0xD0),      o2(0xD5,0xB5),
          o2(0xD5,0xA1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_18 = {
    to_EUC_KR_E8_18_offsets,
    to_EUC_KR_E8_18_infos
};

static const unsigned char
to_EUC_KR_E8_19_offsets[64] = {
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10,  0, 10,
      1, 10, 10, 10,  2,  3, 10, 10,     10, 10, 10,  4,  5, 10,  6,  7,
     10, 10, 10, 10, 10, 10, 10,  8,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10,  9, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E8_19_infos[11] = {
          o2(0xFB,0xDB),      o2(0xF9,0xCB),
          o2(0xCB,0xF3),      o2(0xF4,0xA5),
          o2(0xFA,0xC8),      o2(0xD6,0xD7),
          o2(0xE9,0xE5),      o2(0xFB,0xDC),
          o2(0xFD,0xD0),      o2(0xFB,0xF6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_19 = {
    to_EUC_KR_E8_19_offsets,
    to_EUC_KR_E8_19_infos
};

static const unsigned char
to_EUC_KR_E8_1A_offsets[64] = {
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  0,  6,  1,  6,  6,  6,
      6,  6,  6,  2,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  3,  4,  6,  6,  6,      6,  5,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_E8_1A_infos[7] = {
          o2(0xDA,0xA5),      o2(0xDB,0xBD),
          o2(0xEC,0xE2),      o2(0xCD,0xF7),
          o2(0xF0,0xDE),      o2(0xF6,0xC9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_1A = {
    to_EUC_KR_E8_1A_offsets,
    to_EUC_KR_E8_1A_infos
};

static const unsigned char
to_EUC_KR_E8_1B_offsets[64] = {
      9,  9,  9,  9,  9,  9,  9,  0,      9,  9,  9,  1,  9,  9,  9,  9,
      9,  9,  9,  9,  2,  9,  9,  9,      9,  3,  9,  4,  9,  9,  9,  5,
      9,  9,  9,  9,  6,  9,  9,  9,      9,  9,  9,  9,  9,  7,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  8,  9,
};

static const struct byte_lookup* const
to_EUC_KR_E8_1B_infos[10] = {
          o2(0xDE,0xEF),      o2(0xD3,0xB1),
          o2(0xFC,0xEE),      o2(0xE8,0xC3),
          o2(0xF1,0xC8),      o2(0xCE,0xF1),
          o2(0xF9,0xED),      o2(0xF2,0xF4),
          o2(0xE4,0xB6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_1B = {
    to_EUC_KR_E8_1B_offsets,
    to_EUC_KR_E8_1B_infos
};

static const unsigned char
to_EUC_KR_E8_1C_offsets[64] = {
      0,  7,  1,  2,  7,  7,  7,  7,      3,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      4,  7,  5,  7,  6,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_E8_1C_infos[8] = {
          o2(0xF5,0xB9),      o2(0xDC,0xF0),
          o2(0xE3,0xF1),      o2(0xE8,0xA5),
          o2(0xF2,0xBB),      o2(0xDE,0xA4),
          o2(0xDA,0xCC),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_1C = {
    to_EUC_KR_E8_1C_offsets,
    to_EUC_KR_E8_1C_infos
};

static const unsigned char
to_EUC_KR_E8_1D_offsets[64] = {
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  0,  9,
      9,  9,  9,  9,  9,  1,  9,  2,      9,  9,  9,  9,  9,  9,  9,  3,
      9,  9,  9,  9,  9,  9,  4,  9,      5,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  6,  9,  7,  9,      8,  9,  9,  9,  9,  9,  9,  9,
};

static const struct byte_lookup* const
to_EUC_KR_E8_1D_infos[10] = {
          o2(0xCA,0xE9),      o2(0xE3,0xDA),
          o2(0xFC,0xD9),      o2(0xEA,0xDA),
          o2(0xF9,0xC4),      o2(0xE3,0xA4),
          o2(0xFB,0xDD),      o2(0xEF,0xCA),
          o2(0xE8,0xC4),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_1D = {
    to_EUC_KR_E8_1D_offsets,
    to_EUC_KR_E8_1D_infos
};

static const unsigned char
to_EUC_KR_E8_1E_offsets[64] = {
      6,  6,  0,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  1,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  2,
      6,  6,  3,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  4,  6,  6,  6,  6,      6,  6,  5,  6,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_E8_1E_infos[7] = {
          o2(0xD5,0xCC),      o2(0xEB,0xD7),
          o2(0xD9,0xAD),      o2(0xFB,0xAB),
          o2(0xD3,0xD9),      o2(0xD5,0xA2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_1E = {
    to_EUC_KR_E8_1E_offsets,
    to_EUC_KR_E8_1E_infos
};

static const unsigned char
to_EUC_KR_E8_1F_offsets[64] = {
      8,  8,  8,  8,  0,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      1,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  2,  8,  8,  3,
      8,  8,  4,  8,  8,  8,  8,  8,      8,  5,  8,  6,  8,  8,  7,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E8_1F_infos[9] = {
          o2(0xF6,0xDE),      o2(0xDA,0xF6),
          o2(0xE0,0xD1),      o2(0xE9,0xA8),
          o2(0xF5,0xF9),      o2(0xFA,0xAF),
          o2(0xEB,0xFC),      o2(0xE0,0xEA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_1F = {
    to_EUC_KR_E8_1F_offsets,
    to_EUC_KR_E8_1F_infos
};

static const unsigned char
to_EUC_KR_E8_20_offsets[64] = {
      7,  7,  7,  7,  7,  0,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  1,
      7,  7,  2,  3,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  4,  7,  7,  7,  7,  5,  7,      7,  7,  7,  6,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_E8_20_infos[8] = {
          o2(0xE3,0xB2),      o2(0xD5,0xC5),
          o2(0xF1,0xE3),      o2(0xD5,0xEE),
          o2(0xCD,0xCC),      o2(0xED,0xD9),
          o2(0xD8,0xC1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_20 = {
    to_EUC_KR_E8_20_offsets,
    to_EUC_KR_E8_20_infos
};

static const unsigned char
to_EUC_KR_E8_21_offsets[64] = {
      0, 20, 20, 20, 20, 20,  1, 20,     20, 20, 20, 20,  2,  3, 20, 20,
     20, 20,  4,  5, 20, 20, 20,  6,     20,  7, 20,  8, 20,  9, 20, 20,
     20, 10, 11, 12, 20, 20, 20, 20,     13, 20, 20, 14, 20, 20, 20, 20,
     15, 20, 16, 20, 20, 20, 20, 17,     20, 20, 20, 20, 20, 20, 18, 19,
};

static const struct byte_lookup* const
to_EUC_KR_E8_21_infos[21] = {
          o2(0xFA,0xEC),      o2(0xF1,0xEB),
          o2(0xFA,0xBC),      o2(0xE6,0xE2),
          o2(0xFA,0xE5),      o2(0xE2,0xFA),
          o2(0xCA,0xB6),      o2(0xE4,0xB7),
          o2(0xEA,0xDB),      o2(0xF5,0xFA),
          o2(0xFB,0xAC),      o2(0xCF,0xC3),
          o2(0xEB,0xFD),      o2(0xF8,0xFA),
          o2(0xDF,0xB9),      o2(0xE1,0xF1),
          o2(0xD2,0xA4),      o2(0xF5,0xFB),
          o2(0xD0,0xDA),      o2(0xD0,0xDB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_21 = {
    to_EUC_KR_E8_21_offsets,
    to_EUC_KR_E8_21_infos
};

static const unsigned char
to_EUC_KR_E8_22_offsets[64] = {
     11,  0,  1, 11, 11, 11, 11, 11,      2, 11, 11,  3, 11,  4, 11, 11,
     11, 11,  5, 11, 11, 11,  6,  7,     11, 11, 11, 11, 11, 11,  8, 11,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11,  9, 11, 11, 11, 11,
     11, 11, 11, 11, 10, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_E8_22_infos[12] = {
          o2(0xEA,0xBE),      o2(0xD9,0xB1),
          o2(0xCA,0xB7),      o2(0xD3,0xE7),
          o2(0xF8,0xE5),      o2(0xD3,0xB2),
          o2(0xE2,0xC0),      o2(0xF2,0xDF),
          o2(0xCD,0xE5),      o2(0xF9,0xAC),
          o2(0xCD,0xCD),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_22 = {
    to_EUC_KR_E8_22_offsets,
    to_EUC_KR_E8_22_infos
};

static const unsigned char
to_EUC_KR_E8_23_offsets[64] = {
     16,  0,  1, 16, 16, 16, 16, 16,     16, 16, 16, 16, 16, 16, 16,  2,
     16, 16, 16, 16,  3,  4, 16, 16,     16,  5, 16, 16,  6,  7, 16,  8,
     16,  9, 16, 16, 16, 16, 16, 16,     10, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 11, 12, 13, 16, 16,     14, 16, 16, 16, 16, 15, 16, 16,
};

static const struct byte_lookup* const
to_EUC_KR_E8_23_infos[17] = {
          o2(0xEE,0xAE),      o2(0xD6,0xAE),
          o2(0xD7,0xEA),      o2(0xE7,0xE0),
          o2(0xEB,0xAE),      o2(0xCF,0xD9),
          o2(0xDC,0xCD),      o2(0xED,0xFB),
          o2(0xDE,0xF0),      o2(0xD7,0xEB),
          o2(0xDE,0xA5),      o2(0xDF,0xD7),
          o2(0xDB,0xD0),      o2(0xDB,0xD1),
          o2(0xD5,0xA3),      o2(0xF0,0xB2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_23 = {
    to_EUC_KR_E8_23_offsets,
    to_EUC_KR_E8_23_infos
};

static const unsigned char
to_EUC_KR_E8_24_offsets[64] = {
     11, 11, 11, 11, 11, 11, 11,  0,     11, 11, 11, 11, 11, 11, 11, 11,
      1, 11,  2,  3, 11, 11, 11, 11,      4,  5, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11,  6, 11, 11,     11, 11,  7, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11,  8, 11,      9, 11, 11, 10, 11, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_E8_24_infos[12] = {
          o2(0xDC,0xDC),      o2(0xCA,0xE8),
          o2(0xF8,0xE6),      o2(0xDC,0xCE),
          o2(0xEA,0xDC),      o2(0xDB,0xD2),
          o2(0xE9,0xB3),      o2(0xF7,0xDB),
          o2(0xE3,0xA8),      o2(0xD7,0xAE),
          o2(0xE0,0xE1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_24 = {
    to_EUC_KR_E8_24_offsets,
    to_EUC_KR_E8_24_infos
};

static const unsigned char
to_EUC_KR_E8_25_offsets[64] = {
      7,  0,  7,  7,  1,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  2,
      7,  7,  7,  7,  3,  7,  7,  7,      7,  7,  4,  7,  7,  7,  7,  7,
      7,  7,  5,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  6,
};

static const struct byte_lookup* const
to_EUC_KR_E8_25_infos[8] = {
          o2(0xCB,0xBA),      o2(0xE5,0xD1),
          o2(0xD0,0xDC),      o2(0xD5,0xC1),
          o2(0xD8,0xCA),      o2(0xE3,0xA9),
          o2(0xE0,0xA4),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_25 = {
    to_EUC_KR_E8_25_offsets,
    to_EUC_KR_E8_25_infos
};

static const unsigned char
to_EUC_KR_E8_26_offsets[64] = {
     14,  0, 14,  1, 14, 14,  2,  3,     14, 14, 14,  4, 14, 14, 14,  5,
     14, 14, 14,  6, 14, 14,  7, 14,     14, 14, 14, 14, 14, 14, 14, 14,
     14,  8, 14, 14, 14, 14, 14, 14,     14,  9, 10, 14, 14, 14, 14, 14,
     14, 14, 11, 14, 14, 14, 14, 14,     14, 14, 12, 14, 14, 13, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E8_26_infos[15] = {
          o2(0xE9,0xA9),      o2(0xD3,0xC7),
          o2(0xDC,0xDD),      o2(0xF8,0xAE),
          o2(0xCC,0xB8),      o2(0xD0,0xAE),
          o2(0xD8,0xF2),      o2(0xE3,0xCA),
          o2(0xCC,0xAF),      o2(0xD4,0xAD),
          o2(0xF6,0xD1),      o2(0xD0,0xCC),
          o2(0xCA,0xC6),      o2(0xD5,0xC2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_26 = {
    to_EUC_KR_E8_26_offsets,
    to_EUC_KR_E8_26_infos
};

static const unsigned char
to_EUC_KR_E8_27_offsets[64] = {
      0,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  1,  5,  5,  5,  5,  5,      5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  2,  5,  5,  5,  5,      5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  3,  5,  5,  5,      4,  5,  5,  5,  5,  5,  5,  5,
};

static const struct byte_lookup* const
to_EUC_KR_E8_27_infos[6] = {
          o2(0xCE,0xBA),      o2(0xCA,0xC7),
          o2(0xFA,0xB0),      o2(0xDF,0xD8),
          o2(0xF5,0xBA),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_27 = {
    to_EUC_KR_E8_27_offsets,
    to_EUC_KR_E8_27_infos
};

static const unsigned char
to_EUC_KR_E8_28_offsets[64] = {
      0, 23,  1,  2, 23, 23, 23, 23,      3, 23,  4, 23,  5, 23,  6, 23,
     23, 23, 23,  7, 23, 23,  8,  9,     10, 23, 23, 11, 23, 12, 23, 13,
     23, 23, 23, 14, 23, 15, 23, 23,     23, 23, 16, 23, 23, 17, 23, 23,
     23, 18, 23, 23, 19, 23, 20, 23,     23, 23, 21, 22, 23, 23, 23, 23,
};

static const struct byte_lookup* const
to_EUC_KR_E8_28_infos[24] = {
          o2(0xE5,0xEB),      o2(0xEF,0xF4),
          o2(0xDD,0xB5),      o2(0xCD,0xAA),
          o2(0xE3,0xF2),      o2(0xFB,0xF7),
          o2(0xF7,0xD0),      o2(0xFD,0xBA),
          o2(0xFD,0xE1),      o2(0xF6,0xFE),
          o2(0xD1,0xC0),      o2(0xE8,0xC5),
          o2(0xE4,0xB8),      o2(0xE1,0xE8),
          o2(0xCC,0xC1),      o2(0xD2,0xED),
          o2(0xDB,0xBE),      o2(0xE0,0xE2),
          o2(0xFA,0xC9),      o2(0xE1,0xCD),
          o2(0xCA,0xB8),      o2(0xF2,0xE0),
          o2(0xF1,0xC9),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_28 = {
    to_EUC_KR_E8_28_offsets,
    to_EUC_KR_E8_28_infos
};

static const unsigned char
to_EUC_KR_E8_29_offsets[64] = {
     18, 18, 18, 18, 18, 18, 18, 18,     18, 18, 18, 18, 18, 18, 18, 18,
      0, 18, 18, 18,  1,  2, 18, 18,     18, 18, 18,  3, 18, 18,  4, 18,
      5, 18,  6,  7, 18, 18,  8, 18,     18,  9, 18, 18, 18, 10, 11, 18,
     12, 13, 14, 15, 18, 16, 18, 18,     18, 17, 18, 18, 18, 18, 18, 18,
};

static const struct byte_lookup* const
to_EUC_KR_E8_29_infos[19] = {
          o2(0xDE,0xF1),      o2(0xF0,0xDF),
          o2(0xF8,0xC4),      o2(0xEE,0xCC),
          o2(0xDE,0xF2),      o2(0xE7,0xC9),
          o2(0xE2,0xF3),      o2(0xE7,0xE1),
          o2(0xE3,0xCB),      o2(0xE3,0xCC),
          o2(0xCF,0xF8),      o2(0xEF,0xAC),
          o2(0xFD,0xFE),      o2(0xFC,0xA5),
          o2(0xFA,0xB1),      o2(0xDF,0xD9),
          o2(0xE0,0xD2),      o2(0xF4,0xDA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_29 = {
    to_EUC_KR_E8_29_offsets,
    to_EUC_KR_E8_29_infos
};

static const unsigned char
to_EUC_KR_E8_2A_offsets[64] = {
     22, 22, 22, 22, 22,  0, 22,  1,     22, 22, 22, 22,  2,  3, 22, 22,
     22, 22, 22,  4, 22,  5, 22, 22,      6, 22, 22, 22, 22, 22,  7, 22,
      8,  9, 22, 10, 11, 12, 13, 22,     14, 22, 15, 22, 22, 22, 22, 22,
     16, 22, 17, 22, 22, 22, 22, 22,     22, 18, 22, 22, 19, 22, 20, 21,
};

static const struct byte_lookup* const
to_EUC_KR_E8_2A_infos[23] = {
          o2(0xF1,0xCA),      o2(0xCE,0xA3),
          o2(0xF2,0xBC),      o2(0xEC,0xE3),
          o2(0xE0,0xA5),      o2(0xF7,0xAB),
          o2(0xEB,0xAF),      o2(0xE5,0xDE),
          o2(0xE1,0xA4),      o2(0xCD,0xAB),
          o2(0xD9,0xF4),      o2(0xE8,0xA6),
          o2(0xCD,0xCE),      o2(0xE1,0xE9),
          o2(0xFC,0xEF),      o2(0xE0,0xE3),
          o2(0xE2,0xC1),      o2(0xCE,0xA4),
          o2(0xDE,0xA6),      o2(0xEB,0xFE),
          o2(0xEB,0xDD),      o2(0xF0,0xE0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_2A = {
    to_EUC_KR_E8_2A_offsets,
    to_EUC_KR_E8_2A_infos
};

static const unsigned char
to_EUC_KR_E8_2B_offsets[64] = {
     23, 23,  0, 23,  1, 23, 23,  2,     23, 23, 23,  3, 23,  4, 23,  5,
     23, 23,  6, 23, 23, 23,  7, 23,     23, 23, 23,  8,  9, 23, 23, 23,
     23, 10, 23, 23, 23, 23, 11, 12,     23, 23, 13, 14, 23, 15, 16, 23,
     23, 17, 23, 23, 23, 23, 18, 19,     20, 23, 21, 23, 23, 23, 22, 23,
};

static const struct byte_lookup* const
to_EUC_KR_E8_2B_infos[24] = {
          o2(0xF4,0xDB),      o2(0xE2,0xF4),
          o2(0xD3,0xC8),      o2(0xF4,0xEB),
          o2(0xEE,0xB5),      o2(0xF5,0xD8),
          o2(0xD5,0xDF),      o2(0xD6,0xE5),
          o2(0xEB,0xB0),      o2(0xF4,0xE3),
          o2(0xE3,0xCD),      o2(0xF4,0xF4),
          o2(0xFA,0xB2),      o2(0xEF,0xF5),
          o2(0xCA,0xDF),      o2(0xEB,0xB1),
          o2(0xED,0xBF),      o2(0xFD,0xC9),
          o2(0xE4,0xA6),      o2(0xF9,0xA4),
          o2(0xF0,0xB3),      o2(0xE5,0xEC),
          o2(0xD1,0xE7),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_2B = {
    to_EUC_KR_E8_2B_offsets,
    to_EUC_KR_E8_2B_infos
};

static const unsigned char
to_EUC_KR_E8_2C_offsets[64] = {
      0,  1,  2, 19,  3, 19, 19, 19,     19, 19, 19, 19, 19, 19,  4, 19,
      5, 19, 19, 19,  6, 19,  7,  8,     19,  9, 10, 11, 19, 12, 19, 19,
     13, 19, 19, 19, 19, 19, 19, 19,     14, 19, 19, 15, 16, 19, 19, 19,
     19, 19, 19, 17, 19, 19, 19, 19,     19, 18, 19, 19, 19, 19, 19, 19,
};

static const struct byte_lookup* const
to_EUC_KR_E8_2C_infos[20] = {
          o2(0xD9,0xC7),      o2(0xE4,0xD7),
          o2(0xEA,0xDD),      o2(0xD4,0xF7),
          o2(0xDA,0xBA),      o2(0xDA,0xCD),
          o2(0xF9,0xCC),      o2(0xE1,0xDA),
          o2(0xDB,0xBF),      o2(0xCC,0xC5),
          o2(0xEC,0xD0),      o2(0xCB,0xBB),
          o2(0xDE,0xF3),      o2(0xE9,0xAA),
          o2(0xD9,0xC8),      o2(0xEE,0xE3),
          o2(0xD7,0xBD),      o2(0xCF,0xC4),
          o2(0xD0,0xCD),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_2C = {
    to_EUC_KR_E8_2C_offsets,
    to_EUC_KR_E8_2C_infos
};

static const unsigned char
to_EUC_KR_E8_2D_offsets[64] = {
     14,  0, 14, 14, 14, 14, 14, 14,     14,  1, 14, 14, 14, 14,  2,  3,
     14, 14, 14, 14, 14, 14, 14, 14,      4, 14,  5, 14,  6, 14, 14, 14,
     14, 14, 14, 14, 14, 14,  7, 14,     14, 14, 14, 14,  8, 14, 14,  9,
     10, 14, 14, 14, 11, 14, 14, 12,     14, 14, 14, 14, 14, 13, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E8_2D_infos[15] = {
          o2(0xFC,0xA6),      o2(0xF1,0xFB),
          o2(0xFD,0xD2),      o2(0xD1,0xC1),
          o2(0xE3,0xDB),      o2(0xD3,0xC9),
          o2(0xDC,0xCF),      o2(0xCC,0xED),
          o2(0xDE,0xA7),      o2(0xE6,0xBB),
          o2(0xEC,0xA1),      o2(0xCC,0xB9),
          o2(0xFB,0xDE),      o2(0xE7,0xE2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_2D = {
    to_EUC_KR_E8_2D_offsets,
    to_EUC_KR_E8_2D_infos
};

static const unsigned char
to_EUC_KR_E8_2E_offsets[64] = {
      0,  7,  7,  7,  7,  7,  7,  7,      7,  7,  1,  7,  7,  7,  7,  7,
      2,  7,  3,  4,  7,  7,  5,  7,      7,  7,  6,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_E8_2E_infos[8] = {
          o2(0xD4,0xC1),      o2(0xDC,0xA8),
          o2(0xE2,0xC2),      o2(0xF3,0xD8),
          o2(0xE5,0xD3),      o2(0xF3,0xD9),
          o2(0xF3,0xC6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_2E = {
    to_EUC_KR_E8_2E_offsets,
    to_EUC_KR_E8_2E_infos
};

static const unsigned char
to_EUC_KR_E8_30_offsets[64] = {
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  0,      2,  2,  2,  2,  2,  2,  2,  1,
};

static const struct byte_lookup* const
to_EUC_KR_E8_30_infos[3] = {
          o2(0xCD,0xDB),      o2(0xCD,0xAC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_30 = {
    to_EUC_KR_E8_30_offsets,
    to_EUC_KR_E8_30_infos
};

static const unsigned char
to_EUC_KR_E8_31_offsets[64] = {
     12,  0, 12, 12, 12, 12,  1, 12,      2, 12,  3, 12,  4, 12, 12, 12,
     12, 12, 12, 12, 12,  5, 12, 12,     12, 12,  6, 12, 12, 12, 12, 12,
     12,  7, 12, 12, 12, 12, 12, 12,     12, 12,  8,  9, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,     12, 10, 11, 12, 12, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_E8_31_infos[13] = {
          o2(0xFC,0xC3),      o2(0xD4,0xE7),
          o2(0xD1,0xC2),      o2(0xF9,0xA5),
          o2(0xE8,0xD5),      o2(0xE3,0xCE),
          o2(0xD4,0xCA),      o2(0xDF,0xDA),
          o2(0xFB,0xDF),      o2(0xE7,0xE3),
          o2(0xF8,0xFB),      o2(0xE3,0xCF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_31 = {
    to_EUC_KR_E8_31_offsets,
    to_EUC_KR_E8_31_infos
};

static const unsigned char
to_EUC_KR_E8_32_offsets[64] = {
     25, 25,  0, 25, 25, 25, 25, 25,     25, 25,  1, 25,  2, 25, 25, 25,
     25, 25, 25, 25, 25, 25, 25, 25,     25, 25, 25, 25, 25,  3,  4, 25,
      5,  6,  7, 25, 25, 25, 25,  8,      9, 10, 11, 12, 13, 25, 25, 14,
     15, 25, 25, 16, 17, 25, 18, 19,     20, 25, 25, 21, 22, 23, 25, 24,
};

static const struct byte_lookup* const
to_EUC_KR_E8_32_infos[26] = {
          o2(0xF5,0xB0),      o2(0xD8,0xE7),
          o2(0xD9,0xC9),      o2(0xF8,0xAF),
          o2(0xEF,0xF6),      o2(0xDD,0xB6),
          o2(0xEE,0xAF),      o2(0xCD,0xF8),
          o2(0xDE,0xB8),      o2(0xFC,0xA7),
          o2(0xF7,0xFC),      o2(0xF7,0xB1),
          o2(0xCE,0xBB),      o2(0xF4,0xA1),
          o2(0xEE,0xCD),      o2(0xE1,0xAE),
          o2(0xEC,0xC3),      o2(0xCF,0xFE),
          o2(0xF8,0xBF),      o2(0xD8,0xE2),
          o2(0xD3,0xE8),      o2(0xDE,0xA8),
          o2(0xF4,0xE4),      o2(0xEC,0xC2),
          o2(0xD9,0xF5),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_32 = {
    to_EUC_KR_E8_32_offsets,
    to_EUC_KR_E8_32_infos
};

static const unsigned char
to_EUC_KR_E8_33_offsets[64] = {
      0,  1,  2,  3,  4, 24, 24,  5,      6, 24,  7, 24, 24, 24, 24, 24,
     24,  8, 24,  9, 24, 24, 24, 24,     24, 24, 10, 24, 11, 24, 12, 24,
     13, 24, 14, 15, 16, 24, 17, 24,     24, 24, 18, 24, 24, 19, 24, 24,
     24, 24, 24, 24, 20, 24, 24, 24,     24, 24, 24, 21, 22, 23, 24, 24,
};

static const struct byte_lookup* const
to_EUC_KR_E8_33_infos[25] = {
          o2(0xF9,0xC5),      o2(0xDD,0xD3),
          o2(0xD6,0xF1),      o2(0xEC,0xFC),
          o2(0xFC,0xF0),      o2(0xED,0xC0),
          o2(0xCA,0xB9),      o2(0xEE,0xE4),
          o2(0xF2,0xE1),      o2(0xDE,0xB9),
          o2(0xD6,0xF2),      o2(0xDE,0xF4),
          o2(0xDF,0xDB),      o2(0xDB,0xD3),
          o2(0xFA,0xE7),      o2(0xD8,0xE3),
          o2(0xF4,0xC1),      o2(0xDD,0xB7),
          o2(0xF2,0xF5),      o2(0xD4,0xAE),
          o2(0xD6,0xF3),      o2(0xDD,0xB8),
          o2(0xCF,0xC5),      o2(0xDF,0xDF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_33 = {
    to_EUC_KR_E8_33_offsets,
    to_EUC_KR_E8_33_infos
};

static const unsigned char
to_EUC_KR_E8_34_offsets[64] = {
      8,  8,  8,  8,  0,  1,  8,  2,      3,  8,  4,  8,  8,  5,  8,  8,
      8,  8,  8,  6,  8,  8,  7,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E8_34_infos[9] = {
          o2(0xF2,0xBE),      o2(0xF6,0xA1),
          o2(0xEB,0xCB),      o2(0xF1,0xFC),
          o2(0xF3,0xC7),      o2(0xE0,0xEB),
          o2(0xED,0xFC),      o2(0xE1,0xDB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_34 = {
    to_EUC_KR_E8_34_offsets,
    to_EUC_KR_E8_34_infos
};

static const unsigned char
to_EUC_KR_E8_35_offsets[64] = {
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  0,  7,  1,  7,      7,  7,  7,  2,  7,  7,  7,  7,
      3,  7,  7,  4,  5,  7,  7,  6,      7,  7,  7,  7,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_E8_35_infos[8] = {
          o2(0xEE,0xE5),      o2(0xDE,0xF5),
          o2(0xFA,0xD3),      o2(0xF1,0xCB),
          o2(0xD0,0xAF),      o2(0xDD,0xB9),
          o2(0xD1,0xC3),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_35 = {
    to_EUC_KR_E8_35_offsets,
    to_EUC_KR_E8_35_infos
};

static const unsigned char
to_EUC_KR_E8_36_offsets[64] = {
      8,  8,  8,  8,  8,  0,  8,  8,      8,  8,  1,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  2,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  3,  8,  8,  8,  8,      4,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  5,  8,  8,  8,  8,      8,  8,  6,  8,  8,  8,  7,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E8_36_infos[9] = {
          o2(0xF5,0xB1),      o2(0xEA,0xC6),
          o2(0xF0,0xE1),      o2(0xF6,0xAC),
          o2(0xF5,0xD9),      o2(0xF0,0xEB),
          o2(0xDD,0xBA),      o2(0xF2,0xBF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_36 = {
    to_EUC_KR_E8_36_offsets,
    to_EUC_KR_E8_36_infos
};

static const unsigned char
to_EUC_KR_E8_37_offsets[64] = {
     11, 11, 11, 11, 11, 11,  0, 11,     11, 11, 11,  1,  2, 11, 11,  3,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11,  4, 11,  5, 11, 11,
     11,  6, 11,  7, 11, 11, 11, 11,      8, 11, 11, 11, 11, 11, 11,  9,
     11, 11, 11, 10, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_E8_37_infos[12] = {
          o2(0xF7,0xC5),      o2(0xDB,0xA2),
          o2(0xF2,0xF6),      o2(0xCA,0xBA),
          o2(0xF7,0xF5),      o2(0xCB,0xE5),
          o2(0xEE,0xE6),      o2(0xE0,0xD3),
          o2(0xCE,0xA5),      o2(0xD6,0xD8),
          o2(0xD4,0xAF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_37 = {
    to_EUC_KR_E8_37_offsets,
    to_EUC_KR_E8_37_infos
};

static const unsigned char
to_EUC_KR_E8_38_offsets[64] = {
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  0,  7,  7,  7,  7,  1,
      2,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  3,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  4,  7,  7,  7,  7,  7,
      5,  7,  7,  7,  7,  6,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_E8_38_infos[8] = {
          o2(0xE9,0xC9),      o2(0xD3,0xCE),
          o2(0xF4,0xC2),      o2(0xCB,0xE6),
          o2(0xF1,0xA1),      o2(0xEB,0xB2),
          o2(0xF1,0xA2),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_38 = {
    to_EUC_KR_E8_38_offsets,
    to_EUC_KR_E8_38_infos
};

static const unsigned char
to_EUC_KR_E8_39_offsets[64] = {
     11, 11,  0, 11,  1, 11, 11,  2,      3,  4,  5, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,     11,  6, 11, 11, 11, 11, 11,  7,
      8, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11,  9, 11, 10, 11,     11, 11, 11, 11, 11, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_E8_39_infos[12] = {
          o2(0xEB,0xB3),      o2(0xF0,0xB4),
          o2(0xCB,0xF4),      o2(0xD4,0xB0),
          o2(0xF3,0xB2),      o2(0xFB,0xB7),
          o2(0xF5,0xEC),      o2(0xEE,0xE7),
          o2(0xF4,0xB2),      o2(0xF5,0xED),
          o2(0xCF,0xF3),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_39 = {
    to_EUC_KR_E8_39_offsets,
    to_EUC_KR_E8_39_infos
};

static const unsigned char
to_EUC_KR_E8_3A_offsets[64] = {
      7,  0,  7,  7,  7,  7,  7,  1,      7,  7,  2,  7,  7,  3,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  4,  5,  6,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_E8_3A_infos[8] = {
          o2(0xF0,0xE2),      o2(0xEE,0xCE),
          o2(0xF1,0xCC),      o2(0xE5,0xB8),
          o2(0xD7,0xF5),      o2(0xE3,0xF3),
          o2(0xCF,0xE5),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_3A = {
    to_EUC_KR_E8_3A_offsets,
    to_EUC_KR_E8_3A_infos
};

static const unsigned char
to_EUC_KR_E8_3B_offsets[64] = {
      0, 11, 11, 11, 11, 11, 11, 11,     11, 11,  1,  2,  3,  4, 11, 11,
     11, 11,  5, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11,  6,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11,  7, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,      8, 11, 11,  9, 11, 11, 10, 11,
};

static const struct byte_lookup* const
to_EUC_KR_E8_3B_infos[12] = {
          o2(0xCF,0xC6),      o2(0xF3,0xB3),
          o2(0xE4,0xD8),      o2(0xCF,0xF9),
          o2(0xCF,0xDA),      o2(0xFA,0xCD),
          o2(0xE6,0xE3),      o2(0xF2,0xE2),
          o2(0xF5,0xEE),      o2(0xCA,0xBB),
          o2(0xE3,0xDC),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_3B = {
    to_EUC_KR_E8_3B_offsets,
    to_EUC_KR_E8_3B_infos
};

static const unsigned char
to_EUC_KR_E8_3C_offsets[64] = {
     23, 23, 23,  0, 23,  1, 23, 23,     23,  2, 23, 23, 23, 23, 23, 23,
     23, 23,  3,  4,  5,  6, 23, 23,     23, 23, 23,  7,  8,  9, 10, 11,
     23, 23, 23, 23, 23, 23, 12, 13,     23, 14, 15, 23, 23, 23, 23, 16,
     23, 23, 23, 17, 23, 23, 23, 23,     18, 19, 23, 20, 23, 23, 21, 22,
};

static const struct byte_lookup* const
to_EUC_KR_E8_3C_infos[24] = {
          o2(0xCE,0xF2),      o2(0xD6,0xD9),
          o2(0xEE,0xB0),      o2(0xF4,0xE5),
          o2(0xD8,0xC2),      o2(0xDC,0xD0),
          o2(0xCC,0xEE),      o2(0xD5,0xE0),
          o2(0xF6,0xCA),      o2(0xFD,0xCA),
          o2(0xD8,0xD6),      o2(0xF4,0xCF),
          o2(0xD6,0xA6),      o2(0xDC,0xBE),
          o2(0xDB,0xD4),      o2(0xD7,0xC7),
          o2(0xF2,0xFE),      o2(0xF1,0xCD),
          o2(0xE2,0xC3),      o2(0xDC,0xDE),
          o2(0xDC,0xDF),      o2(0xEF,0xAD),
          o2(0xE6,0xAB),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_3C = {
    to_EUC_KR_E8_3C_offsets,
    to_EUC_KR_E8_3C_infos
};

static const unsigned char
to_EUC_KR_E8_3D_offsets[64] = {
      8,  8,  8,  8,  0,  1,  8,  8,      8,  2,  8,  8,  8,  3,  4,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  5,  8,  6,
      8,  8,  7,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E8_3D_infos[9] = {
          o2(0xF9,0xDD),      o2(0xEA,0xBF),
          o2(0xEF,0xAE),      o2(0xF4,0xD0),
          o2(0xCE,0xF3),      o2(0xE6,0xAC),
          o2(0xCE,0xDE),      o2(0xD5,0xF9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_3D = {
    to_EUC_KR_E8_3D_offsets,
    to_EUC_KR_E8_3D_infos
};

static const unsigned char
to_EUC_KR_E8_3E_offsets[64] = {
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10,  0,  1, 10, 10, 10,
     10, 10, 10,  2, 10, 10,  3, 10,      4, 10, 10, 10, 10,  5, 10,  6,
      7,  8,  9, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E8_3E_infos[11] = {
          o2(0xE3,0xF4),      o2(0xCD,0xD0),
          o2(0xD5,0xB8),      o2(0xF7,0xFD),
          o2(0xDC,0xA9),      o2(0xDE,0xF6),
          o2(0xDC,0xAA),      o2(0xF2,0xE3),
          o2(0xE9,0xB4),      o2(0xD2,0xDC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_3E = {
    to_EUC_KR_E8_3E_offsets,
    to_EUC_KR_E8_3E_infos
};

static const unsigned char
to_EUC_KR_E8_3F_offsets[64] = {
     14, 14,  0, 14, 14,  1, 14, 14,     14, 14, 14, 14, 14, 14,  2, 14,
     14,  3, 14, 14,  4, 14, 14, 14,     14, 14, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14, 14, 14,  5, 14,     14, 14,  6,  7, 14,  8, 14, 14,
      9, 14, 10, 14, 14, 14, 14, 11,     14, 12, 14, 14, 14, 13, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E8_3F_infos[15] = {
          o2(0xE9,0xE6),      o2(0xE3,0xF6),
          o2(0xE7,0xCA),      o2(0xD0,0xCE),
          o2(0xDA,0xF7),      o2(0xCA,0xBC),
          o2(0xEE,0xE8),      o2(0xDA,0xDE),
          o2(0xF2,0xF7),      o2(0xE2,0xFB),
          o2(0xCC,0xA6),      o2(0xDA,0xBB),
          o2(0xEE,0xE9),      o2(0xF5,0xDA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8_3F = {
    to_EUC_KR_E8_3F_offsets,
    to_EUC_KR_E8_3F_infos
};

static const unsigned char
to_EUC_KR_E8_offsets[64] = {
      0,  1,  2,  3,  4,  5,  6,  7,      8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,     24, 25, 26, 27, 28, 29, 30, 31,
     32, 33, 34, 35, 36, 37, 38, 39,     40, 41, 42, 43, 44, 45, 46, 63,
     47, 48, 49, 50, 51, 52, 53, 54,     55, 56, 57, 58, 59, 60, 61, 62,
};

static const struct byte_lookup* const
to_EUC_KR_E8_infos[64] = {
       &to_EUC_KR_E8_00,   &to_EUC_KR_E8_01,
       &to_EUC_KR_E8_02,   &to_EUC_KR_E8_03,
       &to_EUC_KR_E8_04,   &to_EUC_KR_E8_05,
       &to_EUC_KR_E8_06,   &to_EUC_KR_E8_07,
       &to_EUC_KR_E8_08,   &to_EUC_KR_E8_09,
       &to_EUC_KR_E8_0A,   &to_EUC_KR_E8_0B,
       &to_EUC_KR_E8_0C,   &to_EUC_KR_E8_0D,
       &to_EUC_KR_E8_0E,   &to_EUC_KR_E8_0F,
       &to_EUC_KR_E8_10,   &to_EUC_KR_E8_11,
       &to_EUC_KR_E8_12,   &to_EUC_KR_E8_13,
       &to_EUC_KR_E8_14,   &to_EUC_KR_E8_15,
       &to_EUC_KR_E8_16,   &to_EUC_KR_E8_17,
       &to_EUC_KR_E8_18,   &to_EUC_KR_E8_19,
       &to_EUC_KR_E8_1A,   &to_EUC_KR_E8_1B,
       &to_EUC_KR_E8_1C,   &to_EUC_KR_E8_1D,
       &to_EUC_KR_E8_1E,   &to_EUC_KR_E8_1F,
       &to_EUC_KR_E8_20,   &to_EUC_KR_E8_21,
       &to_EUC_KR_E8_22,   &to_EUC_KR_E8_23,
       &to_EUC_KR_E8_24,   &to_EUC_KR_E8_25,
       &to_EUC_KR_E8_26,   &to_EUC_KR_E8_27,
       &to_EUC_KR_E8_28,   &to_EUC_KR_E8_29,
       &to_EUC_KR_E8_2A,   &to_EUC_KR_E8_2B,
       &to_EUC_KR_E8_2C,   &to_EUC_KR_E8_2D,
       &to_EUC_KR_E8_2E,   &to_EUC_KR_E8_30,
       &to_EUC_KR_E8_31,   &to_EUC_KR_E8_32,
       &to_EUC_KR_E8_33,   &to_EUC_KR_E8_34,
       &to_EUC_KR_E8_35,   &to_EUC_KR_E8_36,
       &to_EUC_KR_E8_37,   &to_EUC_KR_E8_38,
       &to_EUC_KR_E8_39,   &to_EUC_KR_E8_3A,
       &to_EUC_KR_E8_3B,   &to_EUC_KR_E8_3C,
       &to_EUC_KR_E8_3D,   &to_EUC_KR_E8_3E,
       &to_EUC_KR_E8_3F,              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E8 = {
    to_EUC_KR_E8_offsets,
    to_EUC_KR_E8_infos
};

static const unsigned char
to_EUC_KR_E9_00_offsets[64] = {
      0,  1,  2,  3, 31,  4,  5, 31,      6, 31, 31,  7, 31,  8, 31,  9,
     10, 11, 31, 31, 12, 13, 31, 14,     31, 15, 16, 31, 31, 17, 18, 19,
     20, 21, 22, 23, 31, 31, 31, 31,     31, 31, 31, 31, 31, 31, 24, 31,
     31, 25, 26, 31, 31, 27, 31, 31,     28, 31, 31, 31, 29, 31, 30, 31,
};

static const struct byte_lookup* const
to_EUC_KR_E9_00_infos[32] = {
          o2(0xF7,0xDC),      o2(0xE1,0xEA),
          o2(0xCE,0xC1),      o2(0xD4,0xB1),
          o2(0xFD,0xB1),      o2(0xE6,0xBD),
          o2(0xFB,0xAD),      o2(0xF8,0xE7),
          o2(0xE1,0xCE),      o2(0xF7,0xE2),
          o2(0xF5,0xEF),      o2(0xCF,0xC7),
          o2(0xD4,0xB2),      o2(0xCC,0xEF),
          o2(0xD4,0xE8),      o2(0xEE,0xCF),
          o2(0xF7,0xD7),      o2(0xE0,0xA6),
          o2(0xD6,0xC1),      o2(0xE1,0xDC),
          o2(0xF0,0xE3),      o2(0xF1,0xE4),
          o2(0xDC,0xF1),      o2(0xD6,0xA7),
          o2(0xF4,0xF5),      o2(0xF1,0xCE),
          o2(0xF2,0xE4),      o2(0xD0,0xB0),
          o2(0xEC,0xEF),      o2(0xF9,0xBA),
          o2(0xEB,0xB5),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_00 = {
    to_EUC_KR_E9_00_offsets,
    to_EUC_KR_E9_00_infos
};

static const unsigned char
to_EUC_KR_E9_01_offsets[64] = {
     31,  0,  1, 31, 31, 31, 31,  2,     31, 31,  3,  4, 31,  5,  6, 31,
      7,  8, 31,  9, 10, 11, 31, 31,     31, 12, 31, 31, 13, 14, 15, 31,
     16, 17, 31, 18, 31, 31, 31, 31,     31, 19, 31, 31, 31, 20, 21, 22,
     31, 31, 23, 31, 31, 24, 31, 25,     26, 31, 27, 31, 28, 29, 31, 30,
};

static const struct byte_lookup* const
to_EUC_KR_E9_01_infos[32] = {
          o2(0xD4,0xED),      o2(0xE2,0xC4),
          o2(0xE9,0xE7),      o2(0xEB,0xB4),
          o2(0xEA,0xA1),      o2(0xF8,0xBC),
          o2(0xCE,0xA6),      o2(0xF9,0xC6),
          o2(0xFC,0xDA),      o2(0xD4,0xB3),
          o2(0xD3,0xB9),      o2(0xEA,0xDE),
          o2(0xE9,0xAB),      o2(0xE1,0xE1),
          o2(0xD3,0xCF),      o2(0xF4,0xF6),
          o2(0xEA,0xC0),      o2(0xE1,0xCF),
          o2(0xCC,0xBA),      o2(0xEE,0xEA),
          o2(0xF0,0xE4),      o2(0xF3,0xB4),
          o2(0xD4,0xEE),      o2(0xF2,0xC0),
          o2(0xF1,0xE5),      o2(0xF4,0xC3),
          o2(0xE0,0xD4),      o2(0xEB,0xB6),
          o2(0xD7,0xA1),      o2(0xCB,0xE8),
          o2(0xF9,0xAD),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_01 = {
    to_EUC_KR_E9_01_offsets,
    to_EUC_KR_E9_01_infos
};

static const unsigned char
to_EUC_KR_E9_02_offsets[64] = {
      0,  1,  2,  3,  4, 22, 22,  5,      6, 22,  7, 22, 22, 22, 22,  8,
     22,  9, 22, 22, 22, 10, 22, 22,     22, 11, 22, 22, 22, 22, 22, 22,
     22, 22, 12, 13, 22, 22, 14, 22,     15, 22, 16, 22, 22, 22, 22, 17,
     18, 19, 22, 22, 22, 20, 22, 22,     21, 22, 22, 22, 22, 22, 22, 22,
};

static const struct byte_lookup* const
to_EUC_KR_E9_02_infos[23] = {
          o2(0xE9,0xAD),      o2(0xD8,0xE4),
          o2(0xFA,0xB3),      o2(0xE2,0xC5),
          o2(0xFC,0xBD),      o2(0xEC,0xC4),
          o2(0xD8,0xB1),      o2(0xDC,0xAB),
          o2(0xD5,0xA4),      o2(0xEB,0xE9),
          o2(0xE8,0xBB),      o2(0xD8,0xD7),
          o2(0xFB,0xAE),      o2(0xD1,0xE1),
          o2(0xDB,0xC0),      o2(0xF5,0xBE),
          o2(0xDE,0xF7),      o2(0xCA,0xFB),
          o2(0xF7,0xC6),      o2(0xCF,0xC8),
          o2(0xE1,0xD0),      o2(0xEE,0xD0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_02 = {
    to_EUC_KR_E9_02_offsets,
    to_EUC_KR_E9_02_infos
};

static const unsigned char
to_EUC_KR_E9_03_offsets[64] = {
      8,  0,  8,  8,  8,  8,  8,  8,      8,  8,  1,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  2,  8,
      8,  3,  8,  8,  8,  8,  8,  8,      4,  8,  8,  8,  8,  5,  8,  8,
      8,  8,  8,  8,  8,  6,  8,  8,      8,  8,  8,  8,  8,  7,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E9_03_infos[9] = {
          o2(0xE9,0xF4),      o2(0xCE,0xF4),
          o2(0xD5,0xCD),      o2(0xCF,0xDB),
          o2(0xDD,0xBB),      o2(0xCE,0xAC),
          o2(0xE9,0xE8),      o2(0xD4,0xB4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_03 = {
    to_EUC_KR_E9_03_offsets,
    to_EUC_KR_E9_03_infos
};

static const unsigned char
to_EUC_KR_E9_04_offsets[64] = {
      7,  7,  0,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  1,  7,  7,  2,  7,  7,      7,  3,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  4,      7,  7,  7,  7,  7,  5,  7,  7,
      7,  7,  6,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_E9_04_infos[8] = {
          o2(0xE4,0xC7),      o2(0xF5,0xDB),
          o2(0xFA,0xC1),      o2(0xDE,0xA9),
          o2(0xD4,0xF8),      o2(0xEF,0xF7),
          o2(0xD3,0xB3),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_04 = {
    to_EUC_KR_E9_04_offsets,
    to_EUC_KR_E9_04_infos
};

static const unsigned char
to_EUC_KR_E9_05_offsets[64] = {
     14, 14, 14, 14, 14, 14, 14, 14,     14,  0,  1,  2,  3,  4,  5, 14,
     14, 14,  6, 14, 14, 14, 14, 14,     14, 14, 14, 14, 14, 14, 14, 14,
     14, 14,  7, 14, 14, 14, 14, 14,     14,  8,  9, 14, 10, 14, 14, 14,
     14, 14, 14, 14, 14, 11, 14, 12,     13, 14, 14, 14, 14, 14, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E9_05_infos[15] = {
          o2(0xEB,0xB7),      o2(0xEF,0xF8),
          o2(0xF5,0xDC),      o2(0xED,0xCC),
          o2(0xDB,0xD5),      o2(0xF1,0xCF),
          o2(0xF1,0xD0),      o2(0xF5,0xB2),
          o2(0xD9,0xAE),      o2(0xD5,0xAC),
          o2(0xE2,0xC6),      o2(0xFD,0xA3),
          o2(0xFB,0xE5),      o2(0xDF,0xAB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_05 = {
    to_EUC_KR_E9_05_offsets,
    to_EUC_KR_E9_05_infos
};

static const unsigned char
to_EUC_KR_E9_06_offsets[64] = {
     13, 13, 13, 13, 13, 13, 13,  0,     13,  1, 13,  2, 13,  3, 13, 13,
     13, 13,  4, 13, 13, 13, 13, 13,     13, 13, 13, 13,  5, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,     13, 13, 13,  6,  7, 13,  8,  9,
     13, 10, 13, 13, 11, 12, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E9_06_infos[14] = {
          o2(0xE2,0xF5),      o2(0xF6,0xAD),
          o2(0xF5,0xB3),      o2(0xF0,0xB5),
          o2(0xE1,0xA5),      o2(0xF5,0xDD),
          o2(0xEC,0xA2),      o2(0xED,0xFD),
          o2(0xF5,0xB4),      o2(0xFB,0xB8),
          o2(0xDB,0xA3),      o2(0xD6,0xCA),
          o2(0xCB,0xD9),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_06 = {
    to_EUC_KR_E9_06_offsets,
    to_EUC_KR_E9_06_infos
};

static const unsigned char
to_EUC_KR_E9_07_offsets[64] = {
      0, 18, 18, 18, 18, 18, 18,  1,     18,  2, 18,  3,  4,  5,  6,  7,
      8,  9, 18, 18, 18, 18, 18, 10,     11, 18, 18, 18, 12, 13, 18, 18,
     18, 18, 18, 14, 18, 18, 18, 15,     18, 18, 16, 18, 18, 18, 18, 18,
     18, 18, 18, 18, 18, 17, 18, 18,     18, 18, 18, 18, 18, 18, 18, 18,
};

static const struct byte_lookup* const
to_EUC_KR_E9_07_infos[19] = {
          o2(0xE5,0xD4),      o2(0xF3,0xFA),
          o2(0xEB,0xB8),      o2(0xE0,0xB7),
          o2(0xD7,0xEC),      o2(0xF1,0xEC),
          o2(0xE5,0xAF),      o2(0xD5,0xE1),
          o2(0xD7,0xED),      o2(0xD1,0xD1),
          o2(0xE1,0xF2),      o2(0xEF,0xF9),
          o2(0xDD,0xBC),      o2(0xF6,0xDC),
          o2(0xF0,0xE5),      o2(0xF4,0xC4),
          o2(0xE9,0xE9),      o2(0xF3,0xFB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_07 = {
    to_EUC_KR_E9_07_offsets,
    to_EUC_KR_E9_07_infos
};

static const unsigned char
to_EUC_KR_E9_08_offsets[64] = {
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  0,  9,  9,
      1,  2,  3,  9,  9,  9,  9,  4,      9,  9,  9,  9,  9,  9,  5,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  6,  9,  9,  9,      9,  9,  7,  9,  9,  9,  9,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E9_08_infos[10] = {
          o2(0xD4,0xEF),      o2(0xCC,0xA2),
          o2(0xF7,0xFE),      o2(0xDF,0xBC),
          o2(0xEB,0xCD),      o2(0xD0,0xB7),
          o2(0xD6,0xC2),      o2(0xE8,0xAD),
          o2(0xEF,0xAF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_08 = {
    to_EUC_KR_E9_08_offsets,
    to_EUC_KR_E9_08_infos
};

static const unsigned char
to_EUC_KR_E9_09_offsets[64] = {
      0, 10, 10, 10, 10,  1, 10, 10,     10,  2, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10,  3,     10, 10, 10,  4, 10, 10,  5, 10,
     10, 10,  6, 10,  7,  8,  9, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E9_09_infos[11] = {
          o2(0xCB,0xA5),      o2(0xCB,0xE9),
          o2(0xFA,0xE8),      o2(0xCC,0xC6),
          o2(0xE6,0xE7),      o2(0xEA,0xC7),
          o2(0xDB,0xA4),      o2(0xCF,0xC9),
          o2(0xE2,0xFC),      o2(0xEF,0xFA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_09 = {
    to_EUC_KR_E9_09_offsets,
    to_EUC_KR_E9_09_infos
};

static const unsigned char
to_EUC_KR_E9_0A_offsets[64] = {
      0, 12, 12,  1, 12,  2, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
     12,  3, 12,  4, 12, 12,  5, 12,      6, 12, 12, 12,  7, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12,  8, 12, 12,  9, 10,     12, 11, 12, 12, 12, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_E9_0A_infos[13] = {
          o2(0xEB,0xDE),      o2(0xF5,0xC8),
          o2(0xD4,0xDE),      o2(0xE0,0xD5),
          o2(0xEF,0xB0),      o2(0xE2,0xC7),
          o2(0xD9,0xAF),      o2(0xF9,0xE7),
          o2(0xE7,0xE5),      o2(0xCF,0xCA),
          o2(0xE1,0xD1),      o2(0xE2,0xC8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_0A = {
    to_EUC_KR_E9_0A_offsets,
    to_EUC_KR_E9_0A_infos
};

static const unsigned char
to_EUC_KR_E9_0B_offsets[64] = {
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  0,  7,  7,  1,
      7,  7,  2,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  3,  7,  7,  7,      7,  7,  4,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      5,  7,  7,  7,  6,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_E9_0B_infos[8] = {
          o2(0xEF,0xFB),      o2(0xFA,0xF9),
          o2(0xDC,0xF2),      o2(0xE0,0xA7),
          o2(0xF8,0xE8),      o2(0xCB,0xEA),
          o2(0xCB,0xBC),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_0B = {
    to_EUC_KR_E9_0B_offsets,
    to_EUC_KR_E9_0B_infos
};

static const unsigned char
to_EUC_KR_E9_0C_offsets[64] = {
     15, 15, 15, 15,  0, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
      1, 15, 15, 15, 15, 15, 15, 15,      2, 15,  3, 15, 15, 15,  4,  5,
      6,  7,  8, 15,  9, 15, 10, 15,     11, 15, 15, 12, 15, 15, 13, 14,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
};

static const struct byte_lookup* const
to_EUC_KR_E9_0C_infos[16] = {
          o2(0xD6,0xE2),      o2(0xF5,0xDE),
          o2(0xF5,0xDF),      o2(0xEE,0xB6),
          o2(0xE2,0xF6),      o2(0xD3,0xCA),
          o2(0xEF,0xFC),      o2(0xD1,0xC4),
          o2(0xEF,0xB1),      o2(0xD1,0xC5),
          o2(0xD0,0xDE),      o2(0xD9,0xE1),
          o2(0xE0,0xB8),      o2(0xCD,0xD1),
          o2(0xF3,0xB9),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_0C = {
    to_EUC_KR_E9_0C_offsets,
    to_EUC_KR_E9_0C_infos
};

static const unsigned char
to_EUC_KR_E9_0D_offsets[64] = {
     10, 10, 10, 10, 10, 10, 10, 10,      0, 10,  1,  2, 10,  3, 10, 10,
     10, 10, 10, 10,  4, 10, 10, 10,     10, 10, 10,  5, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10,  6, 10,
     10, 10, 10, 10, 10,  7, 10, 10,     10, 10, 10, 10,  8, 10,  9, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E9_0D_infos[11] = {
          o2(0xE7,0xCC),      o2(0xD6,0xA8),
          o2(0xCE,0xA7),      o2(0xD4,0xB5),
          o2(0xE4,0xC8),      o2(0xD3,0xB4),
          o2(0xEB,0xB9),      o2(0xCB,0xF5),
          o2(0xF6,0xDD),      o2(0xF1,0xA3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_0D = {
    to_EUC_KR_E9_0D_offsets,
    to_EUC_KR_E9_0D_infos
};

static const unsigned char
to_EUC_KR_E9_0E_offsets[64] = {
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  0,  9,  9,  9,
      9,  9,  9,  9,  1,  9,  2,  9,      9,  9,  3,  9,  9,  9,  9,  9,
      9,  9,  9,  4,  9,  9,  9,  5,      9,  9,  9,  9,  6,  7,  9,  9,
      8,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
};

static const struct byte_lookup* const
to_EUC_KR_E9_0E_infos[10] = {
          o2(0xCC,0xC7),      o2(0xE9,0xCA),
          o2(0xE1,0xF0),      o2(0xF5,0xE0),
          o2(0xFB,0xAF),      o2(0xCB,0xD1),
          o2(0xFB,0xE0),      o2(0xF2,0xE5),
          o2(0xEC,0xF0),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_0E = {
    to_EUC_KR_E9_0E_offsets,
    to_EUC_KR_E9_0E_infos
};

static const unsigned char
to_EUC_KR_E9_0F_offsets[64] = {
      6,  6,  6,  0,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  1,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  2,  6,
      6,  3,  6,  6,  4,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  5,  6,      6,  6,  6,  6,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_E9_0F_infos[7] = {
          o2(0xF0,0xEC),      o2(0xEE,0xEB),
          o2(0xE9,0xCB),      o2(0xCC,0xF0),
          o2(0xD7,0xAF),      o2(0xF3,0xA1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_0F = {
    to_EUC_KR_E9_0F_offsets,
    to_EUC_KR_E9_0F_infos
};

static const unsigned char
to_EUC_KR_E9_10_offsets[64] = {
      6,  6,  6,  6,  0,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      1,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  2,  6,  6,      6,  6,  6,  3,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  4,  6,  6,      5,  6,  6,  6,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_E9_10_infos[7] = {
          o2(0xFC,0xF5),      o2(0xF1,0xA4),
          o2(0xE0,0xD6),      o2(0xEF,0xB2),
          o2(0xF4,0xD1),      o2(0xF7,0xA1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_10 = {
    to_EUC_KR_E9_10_offsets,
    to_EUC_KR_E9_10_infos
};

static const unsigned char
to_EUC_KR_E9_11_offsets[64] = {
      6,  6,  6,  6,  0,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  1,  2,  6,  6,  6,  6,  6,      6,  6,  6,  3,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  4,  6,  5,
};

static const struct byte_lookup* const
to_EUC_KR_E9_11_infos[7] = {
          o2(0xF1,0xD1),      o2(0xCA,0xFC),
          o2(0xCA,0xFD),      o2(0xCE,0xCE),
          o2(0xF3,0xC8),      o2(0xF3,0xBA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_11 = {
    to_EUC_KR_E9_11_offsets,
    to_EUC_KR_E9_11_infos
};

static const unsigned char
to_EUC_KR_E9_15_offsets[64] = {
      1,  1,  1,  1,  1,  1,  1,  1,      1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,      1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,      1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  0,      1,  1,  1,  1,  1,  1,  1,  1,
};

static const struct byte_lookup* const
to_EUC_KR_E9_15_infos[2] = {
          o2(0xED,0xFE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_15 = {
    to_EUC_KR_E9_15_offsets,
    to_EUC_KR_E9_15_infos
};

static const unsigned char
to_EUC_KR_E9_16_offsets[64] = {
      0, 18, 18,  1, 18, 18, 18, 18,     18,  2, 18,  3, 18, 18, 18,  4,
     18,  5,  6,  7,  8, 18, 18, 18,      9, 18, 18, 18, 18, 18, 18, 18,
     18, 18, 18, 10, 11, 12, 18, 18,     13, 18, 18, 18, 18, 14, 18, 18,
     18, 15, 18, 18, 18, 18, 18, 18,     18, 18, 18, 16, 17, 18, 18, 18,
};

static const struct byte_lookup* const
to_EUC_KR_E9_16_infos[19] = {
          o2(0xDA,0xA6),      o2(0xE0,0xEC),
          o2(0xF8,0xCD),      o2(0xCB,0xD2),
          o2(0xEB,0xCE),      o2(0xF9,0xD8),
          o2(0xF9,0xD9),      o2(0xCA,0xE0),
          o2(0xDA,0xCA),      o2(0xCB,0xA6),
          o2(0xCA,0xC8),      o2(0xF9,0xEE),
          o2(0xDB,0xEC),      o2(0xD0,0xB1),
          o2(0xD5,0xEF),      o2(0xE6,0xF3),
          o2(0xE7,0xA2),      o2(0xE4,0xD9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_16 = {
    to_EUC_KR_E9_16_offsets,
    to_EUC_KR_E9_16_infos
};

static const unsigned char
to_EUC_KR_E9_17_offsets[64] = {
      8,  8,  8,  8,  8,  8,  8,  0,      8,  8,  1,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  2,  3,  4,  8,      8,  8,  8,  8,  5,  8,  8,  8,
      8,  6,  7,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_E9_17_infos[9] = {
          o2(0xE4,0xE1),      o2(0xFC,0xC4),
          o2(0xF9,0xEF),      o2(0xCF,0xF4),
          o2(0xF7,0xE6),      o2(0xCE,0xBC),
          o2(0xF4,0xC5),      o2(0xDC,0xA3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_17 = {
    to_EUC_KR_E9_17_offsets,
    to_EUC_KR_E9_17_infos
};

static const unsigned char
to_EUC_KR_E9_18_offsets[64] = {
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  0,  7,  7,  7,
      7,  1,  7,  7,  7,  7,  7,  7,      7,  7,  2,  7,  7,  7,  3,  7,
      7,  7,  4,  7,  7,  7,  7,  7,      7,  7,  7,  5,  7,  7,  7,  6,
};

static const struct byte_lookup* const
to_EUC_KR_E9_18_infos[8] = {
          o2(0xDD,0xBD),      o2(0xF4,0xC6),
          o2(0xF8,0xA1),      o2(0xE8,0xD6),
          o2(0xDB,0xC1),      o2(0xF0,0xE6),
          o2(0xE4,0xB9),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_18 = {
    to_EUC_KR_E9_18_offsets,
    to_EUC_KR_E9_18_infos
};

static const unsigned char
to_EUC_KR_E9_19_offsets[64] = {
      0, 23,  1, 23,  2, 23, 23, 23,     23, 23, 23,  3,  4,  5, 23, 23,
      6, 23, 23, 23, 23, 23, 23, 23,     23, 23, 23,  7,  8,  9, 10, 11,
     23, 23, 12, 13, 14, 23, 23, 23,     23, 23, 15, 23, 23, 23, 23, 23,
     16, 23, 23, 17, 23, 18, 19, 20,     21, 23, 23, 23, 23, 22, 23, 23,
};

static const struct byte_lookup* const
to_EUC_KR_E9_19_infos[24] = {
          o2(0xF6,0xED),      o2(0xF9,0xAE),
          o2(0xDD,0xBE),      o2(0xD7,0xB0),
          o2(0xD8,0xE8),      o2(0xCB,0xBD),
          o2(0xF9,0xDA),      o2(0xF8,0xCE),
          o2(0xF9,0xF0),      o2(0xE0,0xED),
          o2(0xE3,0xB3),      o2(0xF4,0xB3),
          o2(0xEA,0xC2),      o2(0xF2,0xE6),
          o2(0xF0,0xB6),      o2(0xDB,0xD6),
          o2(0xEB,0xE4),      o2(0xF2,0xE7),
          o2(0xD7,0xD5),      o2(0xD4,0xB6),
          o2(0xF9,0xE8),      o2(0xD7,0xC1),
          o2(0xE5,0xD5),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_19 = {
    to_EUC_KR_E9_19_offsets,
    to_EUC_KR_E9_19_infos
};

static const unsigned char
to_EUC_KR_E9_1A_offsets[64] = {
     19, 19, 19, 19, 19,  0,  1, 19,     19, 19,  2,  3, 19,  4,  5, 19,
     19, 19, 19, 19,  6,  7, 19, 19,      8,  9, 19, 10, 11, 19, 19, 19,
     19, 19, 19, 12, 19, 19, 19, 13,     14, 19, 15, 19, 19, 19, 19, 19,
     19, 16, 19, 19, 19, 19, 19, 17,     19, 19, 19, 18, 19, 19, 19, 19,
};

static const struct byte_lookup* const
to_EUC_KR_E9_1A_infos[20] = {
          o2(0xE9,0xEA),      o2(0xD7,0xCC),
          o2(0xD3,0xE9),      o2(0xE2,0xC9),
          o2(0xFC,0xDB),      o2(0xCD,0xAD),
          o2(0xCC,0xB0),      o2(0xEA,0xA2),
          o2(0xE4,0xF6),      o2(0xD0,0xC0),
          o2(0xF0,0xB7),      o2(0xEE,0xA1),
          o2(0xD7,0xF6),      o2(0xE2,0xCA),
          o2(0xE2,0xCB),      o2(0xFA,0xCF),
          o2(0xEB,0xDF),      o2(0xD6,0xCB),
          o2(0xF4,0xB4),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_1A = {
    to_EUC_KR_E9_1A_offsets,
    to_EUC_KR_E9_1A_infos
};

static const unsigned char
to_EUC_KR_E9_1B_offsets[64] = {
      0,  1, 28, 28,  2,  3,  4,  5,     28,  6, 28,  7,  8,  9, 10, 28,
     28, 28, 28, 28, 28, 11, 12, 28,     28, 13, 28, 14, 15, 28, 28, 28,
     28, 28, 16, 17, 28, 28, 28, 28,     18, 19, 20, 28, 28, 28, 28, 21,
     22, 28, 23, 28, 28, 28, 24, 25,     28, 26, 28, 27, 28, 28, 28, 28,
};

static const struct byte_lookup* const
to_EUC_KR_E9_1B_infos[29] = {
          o2(0xED,0xCD),      o2(0xE4,0xD2),
          o2(0xEA,0xA9),      o2(0xE4,0xBA),
          o2(0xF3,0xA2),      o2(0xCD,0xD2),
          o2(0xF6,0xCB),      o2(0xF1,0xE6),
          o2(0xED,0xC1),      o2(0xE8,0xBC),
          o2(0xEE,0xD1),      o2(0xF0,0xE7),
          o2(0xE2,0xCC),      o2(0xE4,0xAA),
          o2(0xF5,0xE1),      o2(0xED,0xDA),
          o2(0xD7,0xEE),      o2(0xD1,0xF1),
          o2(0xE9,0xEB),      o2(0xE9,0xEC),
          o2(0xE0,0xE4),      o2(0xDA,0xA7),
          o2(0xDD,0xD4),      o2(0xEA,0xA3),
          o2(0xD6,0xC3),      o2(0xD6,0xF4),
          o2(0xDA,0xDF),      o2(0xEF,0xB3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_1B = {
    to_EUC_KR_E9_1B_offsets,
    to_EUC_KR_E9_1B_infos
};

static const unsigned char
to_EUC_KR_E9_1C_offsets[64] = {
      0, 14, 14, 14, 14, 14,  1,  2,     14, 14, 14, 14, 14, 14, 14, 14,
     14,  3, 14,  4, 14, 14,  5, 14,     14,  6, 14, 14,  7, 14,  8, 14,
     14, 14, 14, 14, 14, 14, 14,  9,     14, 14, 14, 14, 14, 14, 14, 14,
     10, 14, 11, 14, 14, 14, 14, 14,     14, 12, 14, 14, 14, 13, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E9_1C_infos[15] = {
          o2(0xE2,0xCD),      o2(0xEF,0xFD),
          o2(0xF2,0xE8),      o2(0xEF,0xC5),
          o2(0xE7,0xE7),      o2(0xD7,0xFD),
          o2(0xE7,0xCE),      o2(0xDF,0xDC),
          o2(0xF9,0xC7),      o2(0xD9,0xF6),
          o2(0xDF,0xAC),      o2(0xD6,0xDA),
          o2(0xDC,0xA4),      o2(0xF0,0xB8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_1C = {
    to_EUC_KR_E9_1C_offsets,
    to_EUC_KR_E9_1C_infos
};

static const unsigned char
to_EUC_KR_E9_1D_offsets[64] = {
     14, 14,  0, 14,  1, 14, 14, 14,      2, 14, 14, 14, 14, 14, 14, 14,
     14,  3, 14, 14, 14, 14,  4, 14,     14, 14, 14, 14,  5, 14,  6, 14,
     14,  7,  8, 14, 14, 14, 14, 14,     14,  9, 14, 14, 14, 10, 14, 14,
     14, 14, 14, 14, 11, 14, 14, 12,     14, 14, 13, 14, 14, 14, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E9_1D_infos[15] = {
          o2(0xD5,0xFA),      o2(0xE4,0xF7),
          o2(0xD6,0xC4),      o2(0xF4,0xEC),
          o2(0xEF,0xFE),      o2(0xF0,0xA1),
          o2(0xDE,0xAA),      o2(0xDA,0xBC),
          o2(0xD8,0xFC),      o2(0xFA,0xD4),
          o2(0xEC,0xE5),      o2(0xFC,0xA8),
          o2(0xEC,0xE6),      o2(0xD8,0xCB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_1D = {
    to_EUC_KR_E9_1D_offsets,
    to_EUC_KR_E9_1D_infos
};

static const unsigned char
to_EUC_KR_E9_1E_offsets[64] = {
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  0,  7,  1,  7,  2,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      3,  7,  7,  7,  7,  7,  7,  7,      4,  7,  7,  5,  7,  6,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_E9_1E_infos[8] = {
          o2(0xFB,0xB9),      o2(0xE4,0xD3),
          o2(0xCD,0xF9),      o2(0xCF,0xD3),
          o2(0xCA,0xEA),      o2(0xCF,0xD4),
          o2(0xF8,0xBD),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_1E = {
    to_EUC_KR_E9_1E_offsets,
    to_EUC_KR_E9_1E_infos
};

static const unsigned char
to_EUC_KR_E9_1F_offsets[64] = {
      8,  8,  8,  8,  8,  8,  0,  8,      8,  8,  8,  1,  8,  8,  8,  8,
      8,  8,  8,  2,  8,  8,  8,  8,      8,  8,  8,  8,  3,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  4,  8,  8,  5,  8,      8,  8,  8,  6,  8,  8,  8,  7,
};

static const struct byte_lookup* const
to_EUC_KR_E9_1F_infos[9] = {
          o2(0xF4,0xC7),      o2(0xEA,0xDF),
          o2(0xF9,0xDB),      o2(0xD4,0xB7),
          o2(0xEB,0xE5),      o2(0xE1,0xD2),
          o2(0xEA,0xA4),      o2(0xFA,0xC2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_1F = {
    to_EUC_KR_E9_1F_offsets,
    to_EUC_KR_E9_1F_infos
};

static const unsigned char
to_EUC_KR_E9_20_offsets[64] = {
      0,  1,  2,  3, 20,  4,  5, 20,      6, 20,  7, 20,  8, 20, 20, 20,
      9, 10, 11, 12, 20, 20, 20, 13,     14, 20, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20,     20, 20, 20, 20, 20, 15, 20, 20,
     16, 20, 20, 20, 20, 20, 20, 20,     17, 18, 20, 19, 20, 20, 20, 20,
};

static const struct byte_lookup* const
to_EUC_KR_E9_20_infos[21] = {
          o2(0xFB,0xE1),      o2(0xFA,0xED),
          o2(0xF0,0xA2),      o2(0xCC,0xF1),
          o2(0xFA,0xA3),      o2(0xE2,0xF7),
          o2(0xE2,0xCE),      o2(0xE9,0xF5),
          o2(0xE1,0xEB),      o2(0xE7,0xE8),
          o2(0xE8,0xD7),      o2(0xDA,0xF8),
          o2(0xD4,0xCB),      o2(0xF7,0xF6),
          o2(0xD6,0xC5),      o2(0xD4,0xE9),
          o2(0xFA,0xFA),      o2(0xCC,0xF2),
          o2(0xF7,0xDD),      o2(0xDE,0xBA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_20 = {
    to_EUC_KR_E9_20_offsets,
    to_EUC_KR_E9_20_infos
};

static const unsigned char
to_EUC_KR_E9_21_offsets[64] = {
     12, 12, 12, 12, 12, 12,  0, 12,     12, 12, 12, 12,  1,  2,  3, 12,
     12, 12, 12, 12,  4, 12, 12, 12,      5, 12,  6, 12, 12, 12,  7, 12,
     12, 12, 12, 12, 12,  8, 12,  9,     12, 12, 12, 10, 12, 12, 12, 11,
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_E9_21_infos[13] = {
          o2(0xCE,0xA8),      o2(0xF0,0xB9),
          o2(0xE4,0xFE),      o2(0xE4,0xC9),
          o2(0xE4,0xD4),      o2(0xEA,0xC3),
          o2(0xEF,0xB4),      o2(0xD7,0xBE),
          o2(0xFB,0xE2),      o2(0xCD,0xD3),
          o2(0xEF,0xB5),      o2(0xFA,0xE9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_21 = {
    to_EUC_KR_E9_21_offsets,
    to_EUC_KR_E9_21_infos
};

static const unsigned char
to_EUC_KR_E9_22_offsets[64] = {
      3,  3,  3,  3,  3,  3,  3,  3,      3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,      3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,      0,  3,  3,  3,  3,  3,  3,  1,
      3,  2,  3,  3,  3,  3,  3,  3,      3,  3,  3,  3,  3,  3,  3,  3,
};

static const struct byte_lookup* const
to_EUC_KR_E9_22_infos[4] = {
          o2(0xF9,0xA6),      o2(0xDF,0xBD),
          o2(0xF7,0xC7),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_22 = {
    to_EUC_KR_E9_22_offsets,
    to_EUC_KR_E9_22_infos
};

static const unsigned char
to_EUC_KR_E9_23_offsets[64] = {
     14, 14, 14, 14,  0, 14, 14,  1,     14, 14, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,     14, 14, 14,  2,  3, 14, 14,  4,
     14,  5,  6, 14, 14, 14, 14, 14,     14, 14, 14, 14, 14,  7,  8,  9,
     14, 14, 14, 14, 10, 14, 14, 14,     14, 14, 14, 14, 11, 12, 13, 14,
};

static const struct byte_lookup* const
to_EUC_KR_E9_23_infos[15] = {
          o2(0xF8,0xFD),      o2(0xF8,0xFC),
          o2(0xDE,0xAB),      o2(0xDB,0xE8),
          o2(0xE3,0xDD),      o2(0xE1,0xE2),
          o2(0xD1,0xC6),      o2(0xF6,0xD0),
          o2(0xEB,0xE6),      o2(0xDA,0xF9),
          o2(0xEC,0xC7),      o2(0xDE,0xF8),
          o2(0xF8,0xE9),      o2(0xE3,0xDE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_23 = {
    to_EUC_KR_E9_23_offsets,
    to_EUC_KR_E9_23_infos
};

static const unsigned char
to_EUC_KR_E9_24_offsets[64] = {
     10, 10, 10,  0, 10, 10, 10, 10,     10,  1,  2, 10,  3, 10, 10, 10,
      4, 10, 10,  5, 10, 10, 10, 10,      6, 10, 10, 10, 10, 10,  7, 10,
      8, 10, 10, 10, 10, 10, 10, 10,      9, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E9_24_infos[11] = {
          o2(0xCE,0xF5),      o2(0xFA,0xC3),
          o2(0xE5,0xD7),      o2(0xEC,0xC8),
          o2(0xF3,0xC9),      o2(0xE4,0xBB),
          o2(0xE6,0xAE),      o2(0xEF,0xB6),
          o2(0xDC,0xBF),      o2(0xCE,0xBD),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_24 = {
    to_EUC_KR_E9_24_offsets,
    to_EUC_KR_E9_24_infos
};

static const unsigned char
to_EUC_KR_E9_25_offsets[64] = {
      9,  9,  9,  9,  9,  0,  9,  9,      9,  1,  9,  2,  3,  4,  9,  9,
      9,  5,  6,  9,  7,  9,  9,  8,      9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
};

static const struct byte_lookup* const
to_EUC_KR_E9_25_infos[10] = {
          o2(0xD8,0xC3),      o2(0xD0,0xCF),
          o2(0xCF,0xFA),      o2(0xF3,0xCA),
          o2(0xE0,0xD7),      o2(0xD1,0xC7),
          o2(0xE9,0xAE),      o2(0xE8,0xBD),
          o2(0xFA,0xC4),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_25 = {
    to_EUC_KR_E9_25_offsets,
    to_EUC_KR_E9_25_infos
};

static const unsigned char
to_EUC_KR_E9_26_offsets[64] = {
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12,  0, 12,     12,  1, 12, 12, 12,  2, 12, 12,
     12, 12, 12, 12, 12,  3, 12, 12,      4, 12, 12, 12,  5,  6,  7, 12,
     12,  8, 12,  9, 10, 12, 12, 12,     12, 11, 12, 12, 12, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_E9_26_infos[13] = {
          o2(0xE2,0xCF),      o2(0xFA,0xC5),
          o2(0xF9,0xB8),      o2(0xDC,0xE0),
          o2(0xFB,0xB0),      o2(0xD8,0xA9),
          o2(0xE5,0xDF),      o2(0xF9,0xA7),
          o2(0xF6,0xEE),      o2(0xF6,0xCC),
          o2(0xE2,0xF8),      o2(0xEC,0xF1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_26 = {
    to_EUC_KR_E9_26_offsets,
    to_EUC_KR_E9_26_infos
};

static const unsigned char
to_EUC_KR_E9_27_offsets[64] = {
     11,  0, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
      1,  2,  3, 11, 11,  4, 11, 11,     11,  5, 11, 11, 11,  6, 11,  7,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11,  8, 11, 11,
     11,  9, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E9_27_infos[12] = {
          o2(0xDA,0xE0),      o2(0xF1,0xD2),
          o2(0xD2,0xCC),      o2(0xCF,0xCB),
          o2(0xCA,0xBD),      o2(0xDD,0xBF),
          o2(0xF6,0xEF),      o2(0xDE,0xF9),
          o2(0xFA,0xB4),      o2(0xD5,0xAD),
          o2(0xF1,0xE7),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_27 = {
    to_EUC_KR_E9_27_offsets,
    to_EUC_KR_E9_27_infos
};

static const unsigned char
to_EUC_KR_E9_28_offsets[64] = {
      9,  0,  9,  9,  9,  9,  9,  9,      1,  9,  9,  9,  9,  9,  2,  3,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  4,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  5,  9,  9,  9,  9,
      6,  9,  9,  9,  9,  9,  7,  8,      9,  9,  9,  9,  9,  9,  9,  9,
};

static const struct byte_lookup* const
to_EUC_KR_E9_28_infos[10] = {
          o2(0xDE,0xBE),      o2(0xDC,0xC0),
          o2(0xD1,0xC8),      o2(0xD1,0xC9),
          o2(0xF8,0xBE),      o2(0xCB,0xF6),
          o2(0xD4,0xF9),      o2(0xF5,0xE2),
          o2(0xE1,0xD3),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_28 = {
    to_EUC_KR_E9_28_offsets,
    to_EUC_KR_E9_28_infos
};

static const unsigned char
to_EUC_KR_E9_29_offsets[64] = {
      0, 13, 13,  1, 13,  2, 13, 13,     13, 13, 13, 13, 13,  3, 13, 13,
     13, 13, 13, 13, 13,  4, 13,  5,     13, 13,  6,  7, 13, 13, 13,  8,
     13, 13,  9, 13, 13, 10, 13, 13,     13, 11, 12, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_E9_29_infos[14] = {
          o2(0xD8,0xE9),      o2(0xF8,0xFE),
          o2(0xCF,0xCC),      o2(0xFD,0xA4),
          o2(0xCE,0xF6),      o2(0xFA,0xD0),
          o2(0xCC,0xF3),      o2(0xE6,0xBE),
          o2(0xF6,0xAE),      o2(0xD5,0xF0),
          o2(0xD1,0xCA),      o2(0xFC,0xBE),
          o2(0xD5,0xF1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_29 = {
    to_EUC_KR_E9_29_offsets,
    to_EUC_KR_E9_29_infos
};

static const unsigned char
to_EUC_KR_E9_2A_offsets[64] = {
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,      0,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,      1,  2,  2,  2,  2,  2,  2,  2,
};

static const struct byte_lookup* const
to_EUC_KR_E9_2A_infos[3] = {
          o2(0xCD,0xE9),      o2(0xFA,0xB5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_2A = {
    to_EUC_KR_E9_2A_offsets,
    to_EUC_KR_E9_2A_infos
};

static const unsigned char
to_EUC_KR_E9_2B_offsets[64] = {
      5,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  0,  1,  5,  5,  5,      2,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  3,  5,  5,      5,  5,  5,  5,  5,  5,  4,  5,
      5,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  5,  5,  5,  5,
};

static const struct byte_lookup* const
to_EUC_KR_E9_2B_infos[6] = {
          o2(0xE2,0xD0),      o2(0xF4,0xF7),
          o2(0xCD,0xD4),      o2(0xE7,0xA3),
          o2(0xDB,0xA5),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_2B = {
    to_EUC_KR_E9_2B_offsets,
    to_EUC_KR_E9_2B_infos
};

static const unsigned char
to_EUC_KR_E9_2C_offsets[64] = {
      5,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,      5,  5,  0,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  1,      5,  5,  2,  5,  5,  5,  5,  5,
      5,  3,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  4,  5,  5,  5,
};

static const struct byte_lookup* const
to_EUC_KR_E9_2C_infos[6] = {
          o2(0xE2,0xD1),      o2(0xD7,0xA2),
          o2(0xF7,0xE3),      o2(0xEA,0xA6),
          o2(0xD0,0xA1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_2C = {
    to_EUC_KR_E9_2C_offsets,
    to_EUC_KR_E9_2C_infos
};

static const unsigned char
to_EUC_KR_E9_2D_offsets[64] = {
      9,  0,  1,  2,  3,  4,  9,  9,      9,  9,  9,  9,  9,  9,  9,  5,
      9,  9,  9,  9,  6,  9,  9,  9,      9,  9,  7,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  8,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
};

static const struct byte_lookup* const
to_EUC_KR_E9_2D_infos[10] = {
          o2(0xCE,0xDA),      o2(0xFB,0xEB),
          o2(0xDB,0xA6),      o2(0xDB,0xDE),
          o2(0xD8,0xE5),      o2(0xEA,0xE0),
          o2(0xD8,0xAA),      o2(0xE5,0xE0),
          o2(0xD6,0xDB),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_2D = {
    to_EUC_KR_E9_2D_offsets,
    to_EUC_KR_E9_2D_infos
};

static const unsigned char
to_EUC_KR_E9_2E_offsets[64] = {
      5,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  5,  5,  0,  5,
      5,  1,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  5,  5,  5,  2,
      5,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  3,  5,  5,  4,  5,
      5,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  5,  5,  5,  5,
};

static const struct byte_lookup* const
to_EUC_KR_E9_2E_infos[6] = {
          o2(0xEF,0xC6),      o2(0xF8,0xEA),
          o2(0xE4,0xD5),      o2(0xCE,0xF7),
          o2(0xE0,0xD8),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_2E = {
    to_EUC_KR_E9_2E_offsets,
    to_EUC_KR_E9_2E_infos
};

static const unsigned char
to_EUC_KR_E9_2F_offsets[64] = {
      4,  4,  4,  4,  4,  4,  4,  4,      4,  0,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  1,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  2,  4,  4,  4,      3,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
};

static const struct byte_lookup* const
to_EUC_KR_E9_2F_infos[5] = {
          o2(0xD7,0xEF),      o2(0xF4,0xED),
          o2(0xCD,0xE6),      o2(0xCC,0xF4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_2F = {
    to_EUC_KR_E9_2F_offsets,
    to_EUC_KR_E9_2F_infos
};

static const unsigned char
to_EUC_KR_E9_30_offsets[64] = {
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  0,  7,  7,
      1,  7,  2,  7,  7,  3,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  4,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  5,  7,  7,  7,  7,  7,      7,  7,  7,  6,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_E9_30_infos[8] = {
          o2(0xF5,0xE3),      o2(0xE4,0xCA),
          o2(0xDC,0xE1),      o2(0xF9,0xC8),
          o2(0xFC,0xBF),      o2(0xE8,0xA7),
          o2(0xD8,0xC4),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_30 = {
    to_EUC_KR_E9_30_offsets,
    to_EUC_KR_E9_30_infos
};

static const unsigned char
to_EUC_KR_E9_31_offsets[64] = {
      3,  3,  3,  3,  3,  3,  3,  0,      3,  1,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  2,      3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,      3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,      3,  3,  3,  3,  3,  3,  3,  3,
};

static const struct byte_lookup* const
to_EUC_KR_E9_31_infos[4] = {
          o2(0xCB,0xBE),      o2(0xDC,0xAE),
          o2(0xD7,0xF7),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_31 = {
    to_EUC_KR_E9_31_offsets,
    to_EUC_KR_E9_31_infos
};

static const unsigned char
to_EUC_KR_E9_33_offsets[64] = {
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  0,  6,  1,      6,  2,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  3,  4,  6,  5,  6,      6,  6,  6,  6,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_E9_33_infos[7] = {
          o2(0xF0,0xE8),      o2(0xDD,0xC0),
          o2(0xCF,0xCD),      o2(0xDC,0xF3),
          o2(0xD9,0xB0),      o2(0xE6,0xE9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_33 = {
    to_EUC_KR_E9_33_offsets,
    to_EUC_KR_E9_33_infos
};

static const unsigned char
to_EUC_KR_E9_34_offsets[64] = {
      5,  5,  5,  5,  5,  5,  5,  5,      5,  0,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  1,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  2,  5,      3,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  4,  5,  5,  5,  5,
};

static const struct byte_lookup* const
to_EUC_KR_E9_34_infos[6] = {
          o2(0xE4,0xBC),      o2(0xEA,0xC4),
          o2(0xE4,0xEC),      o2(0xE4,0xE5),
          o2(0xFB,0xF8),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_34 = {
    to_EUC_KR_E9_34_offsets,
    to_EUC_KR_E9_34_infos
};

static const unsigned char
to_EUC_KR_E9_35_offsets[64] = {
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  0,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  1,  6,  6,
      2,  3,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  4,  6,  6,  6,
      6,  6,  5,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_E9_35_infos[7] = {
          o2(0xCC,0xBB),      o2(0xE4,0xBD),
          o2(0xCD,0xDC),      o2(0xD9,0xF7),
          o2(0xDD,0xDF),      o2(0xED,0xCE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_35 = {
    to_EUC_KR_E9_35_offsets,
    to_EUC_KR_E9_35_infos
};

static const unsigned char
to_EUC_KR_E9_36_offsets[64] = {
      3,  3,  3,  3,  3,  3,  3,  3,      3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,      3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,      3,  0,  3,  3,  3,  3,  3,  1,
      3,  3,  3,  3,  2,  3,  3,  3,      3,  3,  3,  3,  3,  3,  3,  3,
};

static const struct byte_lookup* const
to_EUC_KR_E9_36_infos[4] = {
          o2(0xD9,0xD0),      o2(0xE5,0xA3),
          o2(0xF9,0xCD),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_36 = {
    to_EUC_KR_E9_36_offsets,
    to_EUC_KR_E9_36_infos
};

static const unsigned char
to_EUC_KR_E9_37_offsets[64] = {
      6,  6,  6,  6,  0,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  1,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  2,  6,  6,  6,  6,  6,      3,  4,  5,  6,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_E9_37_infos[7] = {
          o2(0xCD,0xAE),      o2(0xCF,0xCE),
          o2(0xF6,0xAF),      o2(0xFD,0xD3),
          o2(0xEB,0xED),      o2(0xD6,0xDC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_37 = {
    to_EUC_KR_E9_37_offsets,
    to_EUC_KR_E9_37_infos
};

static const unsigned char
to_EUC_KR_E9_38_offsets[64] = {
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  0,  2,  2,  2,  1,  2,
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
};

static const struct byte_lookup* const
to_EUC_KR_E9_38_infos[3] = {
          o2(0xE5,0xA4),      o2(0xD5,0xB6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_38 = {
    to_EUC_KR_E9_38_offsets,
    to_EUC_KR_E9_38_infos
};

static const unsigned char
to_EUC_KR_E9_39_offsets[64] = {
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  0,  4,  4,      4,  1,  4,  4,  4,  2,  4,  3,
};

static const struct byte_lookup* const
to_EUC_KR_E9_39_infos[5] = {
          o2(0xD6,0xDD),      o2(0xF9,0xE9),
          o2(0xE7,0xA4),      o2(0xD6,0xE3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_39 = {
    to_EUC_KR_E9_39_offsets,
    to_EUC_KR_E9_39_infos
};

static const unsigned char
to_EUC_KR_E9_3A_offsets[64] = {
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10,  0,  1, 10, 10, 10,  2,     10, 10, 10, 10, 10,  3, 10,  4,
     10, 10, 10, 10, 10,  5, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10,  6,  7, 10, 10,     10, 10, 10,  8, 10, 10,  9, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E9_3A_infos[11] = {
          o2(0xD1,0xCB),      o2(0xD6,0xE4),
          o2(0xD5,0xF2),      o2(0xDE,0xFA),
          o2(0xD7,0xF8),      o2(0xD8,0xEA),
          o2(0xCF,0xD5),      o2(0xD8,0xFD),
          o2(0xD8,0xAB),      o2(0xFD,0xCB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_3A = {
    to_EUC_KR_E9_3A_offsets,
    to_EUC_KR_E9_3A_infos
};

static const unsigned char
to_EUC_KR_E9_3B_offsets[64] = {
     11, 11, 11,  0, 11, 11, 11, 11,     11, 11, 11, 11, 11,  1,  2, 11,
     11,  3, 11, 11,  4, 11, 11, 11,      5, 11, 11,  6,  7, 11,  8, 11,
     11, 11, 11, 11, 11, 11, 11, 11,      9, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 10, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_E9_3B_infos[12] = {
          o2(0xFC,0xDC),      o2(0xE0,0xA8),
          o2(0xD5,0xF3),      o2(0xFD,0xD9),
          o2(0xCC,0xA3),      o2(0xD9,0xF9),
          o2(0xD3,0xEA),      o2(0xF5,0xF5),
          o2(0xEF,0xC7),      o2(0xD3,0xDA),
          o2(0xDA,0xBD),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_3B = {
    to_EUC_KR_E9_3B_offsets,
    to_EUC_KR_E9_3B_infos
};

static const unsigned char
to_EUC_KR_E9_3C_offsets[64] = {
      6,  6,  6,  6,  6,  6,  6,  0,      1,  6,  6,  6,  6,  6,  2,  6,
      6,  6,  6,  3,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      4,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  5,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_E9_3C_infos[7] = {
          o2(0xE8,0xA8),      o2(0xDC,0xAF),
          o2(0xF0,0xA3),      o2(0xCD,0xD5),
          o2(0xE0,0xA9),      o2(0xDE,0xAC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_3C = {
    to_EUC_KR_E9_3C_offsets,
    to_EUC_KR_E9_3C_infos
};

static const unsigned char
to_EUC_KR_E9_3D_offsets[64] = {
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10,  0,  1, 10, 10,  2, 10,
     10, 10,  3, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10,  4,
     10,  5, 10, 10, 10, 10, 10,  6,     10, 10,  7, 10,  8, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10,  9,     10, 10, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_E9_3D_infos[11] = {
          o2(0xF0,0xBA),      o2(0xEE,0xB1),
          o2(0xEE,0xB2),      o2(0xF6,0xCD),
          o2(0xEE,0xD2),      o2(0xD6,0xC6),
          o2(0xE0,0xE5),      o2(0xF3,0xBB),
          o2(0xE5,0xE1),      o2(0xE4,0xCB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_3D = {
    to_EUC_KR_E9_3D_offsets,
    to_EUC_KR_E9_3D_infos
};

static const unsigned char
to_EUC_KR_E9_3E_offsets[64] = {
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  0,  4,  4,
      1,  4,  4,  4,  4,  2,  4,  4,      4,  4,  4,  4,  3,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
};

static const struct byte_lookup* const
to_EUC_KR_E9_3E_infos[5] = {
          o2(0xD7,0xA3),      o2(0xDB,0xC2),
          o2(0xCA,0xFE),      o2(0xCF,0xCF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9_3E = {
    to_EUC_KR_E9_3E_offsets,
    to_EUC_KR_E9_3E_infos
};

static const unsigned char
to_EUC_KR_E9_offsets[64] = {
      0,  1,  2,  3,  4,  5,  6,  7,      8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 59, 59, 59, 18, 19, 20,     21, 22, 23, 24, 25, 26, 27, 28,
     29, 30, 31, 32, 33, 34, 35, 36,     37, 38, 39, 40, 41, 42, 43, 44,
     45, 46, 59, 47, 48, 49, 50, 51,     52, 53, 54, 55, 56, 57, 58, 59,
};

static const struct byte_lookup* const
to_EUC_KR_E9_infos[60] = {
       &to_EUC_KR_E9_00,   &to_EUC_KR_E9_01,
       &to_EUC_KR_E9_02,   &to_EUC_KR_E9_03,
       &to_EUC_KR_E9_04,   &to_EUC_KR_E9_05,
       &to_EUC_KR_E9_06,   &to_EUC_KR_E9_07,
       &to_EUC_KR_E9_08,   &to_EUC_KR_E9_09,
       &to_EUC_KR_E9_0A,   &to_EUC_KR_E9_0B,
       &to_EUC_KR_E9_0C,   &to_EUC_KR_E9_0D,
       &to_EUC_KR_E9_0E,   &to_EUC_KR_E9_0F,
       &to_EUC_KR_E9_10,   &to_EUC_KR_E9_11,
       &to_EUC_KR_E9_15,   &to_EUC_KR_E9_16,
       &to_EUC_KR_E9_17,   &to_EUC_KR_E9_18,
       &to_EUC_KR_E9_19,   &to_EUC_KR_E9_1A,
       &to_EUC_KR_E9_1B,   &to_EUC_KR_E9_1C,
       &to_EUC_KR_E9_1D,   &to_EUC_KR_E9_1E,
       &to_EUC_KR_E9_1F,   &to_EUC_KR_E9_20,
       &to_EUC_KR_E9_21,   &to_EUC_KR_E9_22,
       &to_EUC_KR_E9_23,   &to_EUC_KR_E9_24,
       &to_EUC_KR_E9_25,   &to_EUC_KR_E9_26,
       &to_EUC_KR_E9_27,   &to_EUC_KR_E9_28,
       &to_EUC_KR_E9_29,   &to_EUC_KR_E9_2A,
       &to_EUC_KR_E9_2B,   &to_EUC_KR_E9_2C,
       &to_EUC_KR_E9_2D,   &to_EUC_KR_E9_2E,
       &to_EUC_KR_E9_2F,   &to_EUC_KR_E9_30,
       &to_EUC_KR_E9_31,   &to_EUC_KR_E9_33,
       &to_EUC_KR_E9_34,   &to_EUC_KR_E9_35,
       &to_EUC_KR_E9_36,   &to_EUC_KR_E9_37,
       &to_EUC_KR_E9_38,   &to_EUC_KR_E9_39,
       &to_EUC_KR_E9_3A,   &to_EUC_KR_E9_3B,
       &to_EUC_KR_E9_3C,   &to_EUC_KR_E9_3D,
       &to_EUC_KR_E9_3E,              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_E9 = {
    to_EUC_KR_E9_offsets,
    to_EUC_KR_E9_infos
};

static const unsigned char
to_EUC_KR_EA_30_offsets[64] = {
      0,  1, 30, 30,  2, 30, 30,  3,      4,  5,  6, 30, 30, 30, 30, 30,
      7,  8,  9, 10, 11, 12, 13, 14,     30, 15, 16, 17, 18, 19, 30, 30,
     20, 30, 30, 30, 21, 30, 30, 30,     30, 30, 30, 30, 22, 23, 30, 24,
     25, 26, 30, 30, 30, 30, 30, 30,     27, 28, 30, 30, 29, 30, 30, 30,
};

static const struct byte_lookup* const
to_EUC_KR_EA_30_infos[31] = {
          o2(0xB0,0xA1),      o2(0xB0,0xA2),
          o2(0xB0,0xA3),      o2(0xB0,0xA4),
          o2(0xB0,0xA5),      o2(0xB0,0xA6),
          o2(0xB0,0xA7),      o2(0xB0,0xA8),
          o2(0xB0,0xA9),      o2(0xB0,0xAA),
          o2(0xB0,0xAB),      o2(0xB0,0xAC),
          o2(0xB0,0xAD),      o2(0xB0,0xAE),
          o2(0xB0,0xAF),      o2(0xB0,0xB0),
          o2(0xB0,0xB1),      o2(0xB0,0xB2),
          o2(0xB0,0xB3),      o2(0xB0,0xB4),
          o2(0xB0,0xB5),      o2(0xB0,0xB6),
          o2(0xB0,0xB7),      o2(0xB0,0xB8),
          o2(0xB0,0xB9),      o2(0xB0,0xBA),
          o2(0xB0,0xBB),      o2(0xB0,0xBC),
          o2(0xB0,0xBD),      o2(0xB0,0xBE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EA_30 = {
    to_EUC_KR_EA_30_offsets,
    to_EUC_KR_EA_30_infos
};

static const unsigned char
to_EUC_KR_EA_31_offsets[64] = {
      0, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12,  1, 12,  2, 12, 12,
     12, 12, 12, 12,  3, 12, 12, 12,      4, 12, 12, 12,  5, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
      6,  7, 12, 12,  8, 12, 12,  9,     10, 12, 11, 12, 12, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_EA_31_infos[13] = {
          o2(0xB0,0xBF),      o2(0xB0,0xC0),
          o2(0xB0,0xC1),      o2(0xB0,0xC2),
          o2(0xB0,0xC3),      o2(0xB0,0xC4),
          o2(0xB0,0xC5),      o2(0xB0,0xC6),
          o2(0xB0,0xC7),      o2(0xB0,0xC8),
          o2(0xB0,0xC9),      o2(0xB0,0xCA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EA_31 = {
    to_EUC_KR_EA_31_offsets,
    to_EUC_KR_EA_31_infos
};

static const unsigned char
to_EUC_KR_EA_32_offsets[64] = {
      0,  1, 28,  2,  3,  4,  5, 28,     28,  6,  7,  8,  9, 28, 28, 28,
     10, 28, 28, 28, 11, 28, 28, 28,     28, 28, 28, 28, 12, 13, 28, 14,
     15, 16, 28, 28, 28, 28, 28, 28,     17, 18, 19, 28, 20, 28, 28, 21,
     22, 28, 28, 28, 28, 28, 28, 28,     23, 24, 28, 25, 26, 27, 28, 28,
};

static const struct byte_lookup* const
to_EUC_KR_EA_32_infos[29] = {
          o2(0xB0,0xCB),      o2(0xB0,0xCC),
          o2(0xB0,0xCD),      o2(0xB0,0xCE),
          o2(0xB0,0xCF),      o2(0xB0,0xD0),
          o2(0xB0,0xD1),      o2(0xB0,0xD2),
          o2(0xB0,0xD3),      o2(0xB0,0xD4),
          o2(0xB0,0xD5),      o2(0xB0,0xD6),
          o2(0xB0,0xD7),      o2(0xB0,0xD8),
          o2(0xB0,0xD9),      o2(0xB0,0xDA),
          o2(0xB0,0xDB),      o2(0xB0,0xDC),
          o2(0xB0,0xDD),      o2(0xB0,0xDE),
          o2(0xB0,0xDF),      o2(0xB0,0xE0),
          o2(0xB0,0xE1),      o2(0xB0,0xE2),
          o2(0xB0,0xE3),      o2(0xB0,0xE4),
          o2(0xB0,0xE5),      o2(0xB0,0xE6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EA_32 = {
    to_EUC_KR_EA_32_offsets,
    to_EUC_KR_EA_32_infos
};

static const unsigned char
to_EUC_KR_EA_33_offsets[64] = {
     21,  0, 21, 21,  1, 21, 21, 21,      2, 21, 21, 21,  3, 21, 21, 21,
     21, 21, 21, 21, 21,  4, 21,  5,     21, 21, 21, 21, 21, 21, 21, 21,
      6,  7, 21, 21,  8, 21, 21,  9,     10, 21, 11, 21, 12, 21, 21, 13,
     14, 15, 21, 16, 21, 17, 18, 21,     21, 21, 21, 21, 19, 20, 21, 21,
};

static const struct byte_lookup* const
to_EUC_KR_EA_33_infos[22] = {
          o2(0xB0,0xE7),      o2(0xB0,0xE8),
          o2(0xB0,0xE9),      o2(0xB0,0xEA),
          o2(0xB0,0xEB),      o2(0xB0,0xEC),
          o2(0xB0,0xED),      o2(0xB0,0xEE),
          o2(0xB0,0xEF),      o2(0xB0,0xF0),
          o2(0xB0,0xF1),      o2(0xB0,0xF2),
          o2(0xB0,0xF3),      o2(0xB0,0xF4),
          o2(0xB0,0xF5),      o2(0xB0,0xF6),
          o2(0xB0,0xF7),      o2(0xB0,0xF8),
          o2(0xB0,0xF9),      o2(0xB0,0xFA),
          o2(0xB0,0xFB),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EA_33 = {
    to_EUC_KR_EA_33_offsets,
    to_EUC_KR_EA_33_infos
};

static const unsigned char
to_EUC_KR_EA_34_offsets[64] = {
      0, 17, 17, 17,  1, 17,  2, 17,     17, 17, 17, 17,  3,  4, 17,  5,
     17,  6, 17, 17, 17, 17, 17, 17,      7, 17, 17, 17,  8, 17, 17, 17,
      9, 17, 17, 17, 17, 17, 17, 17,     17, 10, 17, 17, 11, 12, 17, 17,
     17, 17, 17, 17, 13, 14, 17, 17,     15, 17, 17, 17, 16, 17, 17, 17,
};

static const struct byte_lookup* const
to_EUC_KR_EA_34_infos[18] = {
          o2(0xB0,0xFC),      o2(0xB0,0xFD),
          o2(0xB0,0xFE),      o2(0xB1,0xA1),
          o2(0xB1,0xA2),      o2(0xB1,0xA3),
          o2(0xB1,0xA4),      o2(0xB1,0xA5),
          o2(0xB1,0xA6),      o2(0xB1,0xA7),
          o2(0xB1,0xA8),      o2(0xB1,0xA9),
          o2(0xB1,0xAA),      o2(0xB1,0xAB),
          o2(0xB1,0xAC),      o2(0xB1,0xAD),
          o2(0xB1,0xAE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EA_34 = {
    to_EUC_KR_EA_34_offsets,
    to_EUC_KR_EA_34_infos
};

static const unsigned char
to_EUC_KR_EA_35_offsets[64] = {
     20, 20, 20, 20,  0,  1, 20,  2,     20,  3, 20, 20, 20, 20, 20, 20,
      4, 20, 20, 20,  5, 20, 20, 20,      6, 20, 20, 20, 20, 20, 20, 20,
     20,  7, 20,  8, 20, 20, 20, 20,     20, 20, 20, 20,  9, 10, 20, 20,
     11, 20, 20, 12, 13, 14, 15, 20,     20, 20, 20, 16, 17, 18, 20, 19,
};

static const struct byte_lookup* const
to_EUC_KR_EA_35_infos[21] = {
          o2(0xB1,0xAF),      o2(0xB1,0xB0),
          o2(0xB1,0xB1),      o2(0xB1,0xB2),
          o2(0xB1,0xB3),      o2(0xB1,0xB4),
          o2(0xB1,0xB5),      o2(0xB1,0xB6),
          o2(0xB1,0xB7),      o2(0xB1,0xB8),
          o2(0xB1,0xB9),      o2(0xB1,0xBA),
          o2(0xB1,0xBB),      o2(0xB1,0xBC),
          o2(0xB1,0xBD),      o2(0xB1,0xBE),
          o2(0xB1,0xBF),      o2(0xB1,0xC0),
          o2(0xB1,0xC1),      o2(0xB1,0xC2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EA_35 = {
    to_EUC_KR_EA_35_offsets,
    to_EUC_KR_EA_35_infos
};

static const unsigned char
to_EUC_KR_EA_36_offsets[64] = {
     10,  0,  1, 10, 10, 10, 10, 10,      2,  3, 10, 10,  4, 10, 10, 10,
      5, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10,  6,  7, 10, 10,
     10, 10, 10, 10,  8, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10,  9,     10, 10, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_EA_36_infos[11] = {
          o2(0xB1,0xC3),      o2(0xB1,0xC4),
          o2(0xB1,0xC5),      o2(0xB1,0xC6),
          o2(0xB1,0xC7),      o2(0xB1,0xC8),
          o2(0xB1,0xC9),      o2(0xB1,0xCA),
          o2(0xB1,0xCB),      o2(0xB1,0xCC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EA_36 = {
    to_EUC_KR_EA_36_offsets,
    to_EUC_KR_EA_36_infos
};

static const unsigned char
to_EUC_KR_EA_37_offsets[64] = {
      0,  1, 14, 14,  2, 14, 14, 14,      3, 14, 14, 14, 14, 14, 14, 14,
      4,  5, 14,  6, 14, 14, 14, 14,     14, 14, 14, 14,  7, 14, 14, 14,
      8, 14, 14, 14,  9, 14, 14, 14,     14, 14, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,     10, 11, 14, 14, 12, 14, 14, 13,
};

static const struct byte_lookup* const
to_EUC_KR_EA_37_infos[15] = {
          o2(0xB1,0xCD),      o2(0xB1,0xCE),
          o2(0xB1,0xCF),      o2(0xB1,0xD0),
          o2(0xB1,0xD1),      o2(0xB1,0xD2),
          o2(0xB1,0xD3),      o2(0xB1,0xD4),
          o2(0xB1,0xD5),      o2(0xB1,0xD6),
          o2(0xB1,0xD7),      o2(0xB1,0xD8),
          o2(0xB1,0xD9),      o2(0xB1,0xDA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EA_37 = {
    to_EUC_KR_EA_37_offsets,
    to_EUC_KR_EA_37_infos
};

static const unsigned char
to_EUC_KR_EA_38_offsets[64] = {
      0,  1, 13, 13, 13, 13, 13, 13,      2,  3, 13,  4, 13,  5, 13, 13,
     13, 13, 13, 13,  6, 13, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
      7,  8, 13, 13,  9, 13, 13, 10,     11, 13, 12, 13, 13, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_EA_38_infos[14] = {
          o2(0xB1,0xDB),      o2(0xB1,0xDC),
          o2(0xB1,0xDD),      o2(0xB1,0xDE),
          o2(0xB1,0xDF),      o2(0xB1,0xE0),
          o2(0xB1,0xE1),      o2(0xB1,0xE2),
          o2(0xB1,0xE3),      o2(0xB1,0xE4),
          o2(0xB1,0xE5),      o2(0xB1,0xE6),
          o2(0xB1,0xE7),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EA_38 = {
    to_EUC_KR_EA_38_offsets,
    to_EUC_KR_EA_38_infos
};

static const unsigned char
to_EUC_KR_EA_39_offsets[64] = {
      0,  1, 27,  2, 27,  3,  4, 27,     27, 27,  5, 27,  6,  7,  8, 27,
      9, 27, 27, 27, 10, 27, 11, 27,     27, 27, 27, 27, 12, 13, 27, 14,
     15, 16, 27, 27, 27, 17, 27, 27,     18, 19, 27, 27, 20, 27, 27, 27,
     21, 27, 27, 27, 27, 27, 27, 27,     22, 23, 27, 24, 25, 26, 27, 27,
};

static const struct byte_lookup* const
to_EUC_KR_EA_39_infos[28] = {
          o2(0xB1,0xE8),      o2(0xB1,0xE9),
          o2(0xB1,0xEA),      o2(0xB1,0xEB),
          o2(0xB1,0xEC),      o2(0xB1,0xED),
          o2(0xB1,0xEE),      o2(0xB1,0xEF),
          o2(0xB1,0xF0),      o2(0xB1,0xF1),
          o2(0xB1,0xF2),      o2(0xB1,0xF3),
          o2(0xB1,0xF4),      o2(0xB1,0xF5),
          o2(0xB1,0xF6),      o2(0xB1,0xF7),
          o2(0xB1,0xF8),      o2(0xB1,0xF9),
          o2(0xB1,0xFA),      o2(0xB1,0xFB),
          o2(0xB1,0xFC),      o2(0xB1,0xFD),
          o2(0xB1,0xFE),      o2(0xB2,0xA1),
          o2(0xB2,0xA2),      o2(0xB2,0xA3),
          o2(0xB2,0xA4),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EA_39 = {
    to_EUC_KR_EA_39_offsets,
    to_EUC_KR_EA_39_infos
};

static const unsigned char
to_EUC_KR_EA_3A_offsets[64] = {
      6,  6,  6,  6,  0,  1,  6,  6,      6,  6,  6,  6,  2,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  3,  4,  5,  6,
};

static const struct byte_lookup* const
to_EUC_KR_EA_3A_infos[7] = {
          o2(0xB2,0xA5),      o2(0xB2,0xA6),
          o2(0xB2,0xA7),      o2(0xB2,0xA8),
          o2(0xB2,0xA9),      o2(0xB2,0xAA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EA_3A = {
    to_EUC_KR_EA_3A_offsets,
    to_EUC_KR_EA_3A_infos
};

static const unsigned char
to_EUC_KR_EA_3B_offsets[64] = {
      0, 16, 16, 16,  1, 16, 16, 16,     16, 16, 16, 16,  2,  3, 16,  4,
      5,  6, 16, 16, 16, 16, 16, 16,      7,  8, 16, 16,  9, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,     10, 16, 16, 11, 16, 12, 16, 16,
     16, 16, 16, 16, 13, 16, 16, 16,     14, 16, 16, 16, 15, 16, 16, 16,
};

static const struct byte_lookup* const
to_EUC_KR_EA_3B_infos[17] = {
          o2(0xB2,0xAB),      o2(0xB2,0xAC),
          o2(0xB2,0xAD),      o2(0xB2,0xAE),
          o2(0xB2,0xAF),      o2(0xB2,0xB0),
          o2(0xB2,0xB1),      o2(0xB2,0xB2),
          o2(0xB2,0xB3),      o2(0xB2,0xB4),
          o2(0xB2,0xB5),      o2(0xB2,0xB6),
          o2(0xB2,0xB7),      o2(0xB2,0xB8),
          o2(0xB2,0xB9),      o2(0xB2,0xBA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EA_3B = {
    to_EUC_KR_EA_3B_offsets,
    to_EUC_KR_EA_3B_infos
};

static const unsigned char
to_EUC_KR_EA_3C_offsets[64] = {
     12, 12, 12, 12, 12, 12, 12,  0,      1, 12, 12, 12, 12,  2, 12, 12,
      3, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12,  4,  5, 12, 12,
      6, 12,  7, 12,  8, 12, 12, 12,     12, 12, 12, 12,  9, 10, 12, 11,
};

static const struct byte_lookup* const
to_EUC_KR_EA_3C_infos[13] = {
          o2(0xB2,0xBB),      o2(0xB2,0xBC),
          o2(0xB2,0xBD),      o2(0xB2,0xBE),
          o2(0xB2,0xBF),      o2(0xB2,0xC0),
          o2(0xB2,0xC1),      o2(0xB2,0xC2),
          o2(0xB2,0xC3),      o2(0xB2,0xC4),
          o2(0xB2,0xC5),      o2(0xB2,0xC6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EA_3C = {
    to_EUC_KR_EA_3C_offsets,
    to_EUC_KR_EA_3C_infos
};

static const unsigned char
to_EUC_KR_EA_3D_offsets[64] = {
     11,  0,  1,  2, 11, 11, 11, 11,      3,  4, 11, 11, 11, 11, 11, 11,
      5, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11,  6,  7, 11, 11,
     11, 11, 11, 11,  8,  9, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 10, 11, 11, 11, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_EA_3D_infos[12] = {
          o2(0xB2,0xC7),      o2(0xB2,0xC8),
          o2(0xB2,0xC9),      o2(0xB2,0xCA),
          o2(0xB2,0xCB),      o2(0xB2,0xCC),
          o2(0xB2,0xCD),      o2(0xB2,0xCE),
          o2(0xB2,0xCF),      o2(0xB2,0xD0),
          o2(0xB2,0xD1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EA_3D = {
    to_EUC_KR_EA_3D_offsets,
    to_EUC_KR_EA_3D_infos
};

static const unsigned char
to_EUC_KR_EA_3E_offsets[64] = {
      0, 10, 10, 10,  1, 10, 10, 10,      2, 10, 10, 10, 10, 10, 10, 10,
      3,  4, 10, 10, 10,  5, 10, 10,     10, 10, 10, 10,  6, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,      7,  8, 10, 10,  9, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_EA_3E_infos[11] = {
          o2(0xB2,0xD2),      o2(0xB2,0xD3),
          o2(0xB2,0xD4),      o2(0xB2,0xD5),
          o2(0xB2,0xD6),      o2(0xB2,0xD7),
          o2(0xB2,0xD8),      o2(0xB2,0xD9),
          o2(0xB2,0xDA),      o2(0xB2,0xDB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EA_3E = {
    to_EUC_KR_EA_3E_offsets,
    to_EUC_KR_EA_3E_infos
};

static const unsigned char
to_EUC_KR_EA_3F_offsets[64] = {
      0, 15, 15, 15, 15, 15, 15,  1,      2,  3, 15,  4, 15,  5,  6, 15,
     15, 15, 15, 15,  7, 15, 15, 15,     15, 15, 15, 15,  8, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,      9, 10, 15, 15, 15, 15, 15, 15,
     11, 12, 15, 15, 13, 15, 15, 15,     14, 15, 15, 15, 15, 15, 15, 15,
};

static const struct byte_lookup* const
to_EUC_KR_EA_3F_infos[16] = {
          o2(0xB2,0xDC),      o2(0xB2,0xDD),
          o2(0xB2,0xDE),      o2(0xB2,0xDF),
          o2(0xB2,0xE0),      o2(0xB2,0xE1),
          o2(0xB2,0xE2),      o2(0xB2,0xE3),
          o2(0xB2,0xE4),      o2(0xB2,0xE5),
          o2(0xB2,0xE6),      o2(0xB2,0xE7),
          o2(0xB2,0xE8),      o2(0xB2,0xE9),
          o2(0xB2,0xEA),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EA_3F = {
    to_EUC_KR_EA_3F_offsets,
    to_EUC_KR_EA_3F_infos
};

static const unsigned char
to_EUC_KR_EA_offsets[64] = {
     16, 16, 16, 16, 16, 16, 16, 16,     16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,     16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,     16, 16, 16, 16, 16, 16, 16, 16,
      0,  1,  2,  3,  4,  5,  6,  7,      8,  9, 10, 11, 12, 13, 14, 15,
};

static const struct byte_lookup* const
to_EUC_KR_EA_infos[17] = {
       &to_EUC_KR_EA_30,   &to_EUC_KR_EA_31,
       &to_EUC_KR_EA_32,   &to_EUC_KR_EA_33,
       &to_EUC_KR_EA_34,   &to_EUC_KR_EA_35,
       &to_EUC_KR_EA_36,   &to_EUC_KR_EA_37,
       &to_EUC_KR_EA_38,   &to_EUC_KR_EA_39,
       &to_EUC_KR_EA_3A,   &to_EUC_KR_EA_3B,
       &to_EUC_KR_EA_3C,   &to_EUC_KR_EA_3D,
       &to_EUC_KR_EA_3E,   &to_EUC_KR_EA_3F,
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EA = {
    to_EUC_KR_EA_offsets,
    to_EUC_KR_EA_infos
};

static const unsigned char
to_EUC_KR_EB_00_offsets[64] = {
      0,  1,  9,  9,  2,  9,  9,  9,      9,  9,  9,  9,  3,  9,  9,  9,
      4,  9,  9,  9,  5,  9,  9,  9,      9,  9,  9,  9,  6,  7,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      8,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
};

static const struct byte_lookup* const
to_EUC_KR_EB_00_infos[10] = {
          o2(0xB2,0xEB),      o2(0xB2,0xEC),
          o2(0xB2,0xED),      o2(0xB2,0xEE),
          o2(0xB2,0xEF),      o2(0xB2,0xF0),
          o2(0xB2,0xF1),      o2(0xB2,0xF2),
          o2(0xB2,0xF3),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_00 = {
    to_EUC_KR_EB_00_offsets,
    to_EUC_KR_EB_00_infos
};

static const unsigned char
to_EUC_KR_EB_01_offsets[64] = {
     14, 14, 14, 14,  0,  1, 14, 14,      2, 14,  3, 14,  4, 14,  5, 14,
     14, 14, 14,  6,  7,  8, 14,  9,     14, 10, 14, 14, 14, 11, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,     14, 14, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,     14, 14, 14, 14, 12, 13, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_EB_01_infos[15] = {
          o2(0xB2,0xF4),      o2(0xB2,0xF5),
          o2(0xB2,0xF6),      o2(0xB2,0xF7),
          o2(0xB2,0xF8),      o2(0xB2,0xF9),
          o2(0xB2,0xFA),      o2(0xB2,0xFB),
          o2(0xB2,0xFC),      o2(0xB2,0xFD),
          o2(0xB2,0xFE),      o2(0xB3,0xA1),
          o2(0xB3,0xA2),      o2(0xB3,0xA3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_01 = {
    to_EUC_KR_EB_01_offsets,
    to_EUC_KR_EB_01_infos
};

static const unsigned char
to_EUC_KR_EB_02_offsets[64] = {
      0, 27, 27, 27,  1, 27, 27, 27,     27, 27, 27, 27,  2,  3, 27,  4,
     27,  5, 27, 27, 27, 27, 27, 27,      6,  7,  8, 27,  9, 27, 27, 10,
     11, 12, 13, 27, 27, 27, 27, 27,     14, 15, 27, 16, 17, 18, 19, 20,
     27, 21, 27, 22, 23, 24, 27, 27,     25, 27, 27, 27, 26, 27, 27, 27,
};

static const struct byte_lookup* const
to_EUC_KR_EB_02_infos[28] = {
          o2(0xB3,0xA4),      o2(0xB3,0xA5),
          o2(0xB3,0xA6),      o2(0xB3,0xA7),
          o2(0xB3,0xA8),      o2(0xB3,0xA9),
          o2(0xB3,0xAA),      o2(0xB3,0xAB),
          o2(0xB3,0xAC),      o2(0xB3,0xAD),
          o2(0xB3,0xAE),      o2(0xB3,0xAF),
          o2(0xB3,0xB0),      o2(0xB3,0xB1),
          o2(0xB3,0xB2),      o2(0xB3,0xB3),
          o2(0xB3,0xB4),      o2(0xB3,0xB5),
          o2(0xB3,0xB6),      o2(0xB3,0xB7),
          o2(0xB3,0xB8),      o2(0xB3,0xB9),
          o2(0xB3,0xBA),      o2(0xB3,0xBB),
          o2(0xB3,0xBC),      o2(0xB3,0xBD),
          o2(0xB3,0xBE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_02 = {
    to_EUC_KR_EB_02_offsets,
    to_EUC_KR_EB_02_infos
};

static const unsigned char
to_EUC_KR_EB_03_offsets[64] = {
     11, 11, 11, 11,  0,  1, 11,  2,      3,  4, 11, 11, 11, 11, 11, 11,
      5,  6, 11, 11,  7, 11, 11, 11,      8, 11, 11, 11, 11, 11, 11, 11,
      9, 11, 11, 11, 11, 10, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_EB_03_infos[12] = {
          o2(0xB3,0xBF),      o2(0xB3,0xC0),
          o2(0xB3,0xC1),      o2(0xB3,0xC2),
          o2(0xB3,0xC3),      o2(0xB3,0xC4),
          o2(0xB3,0xC5),      o2(0xB3,0xC6),
          o2(0xB3,0xC7),      o2(0xB3,0xC8),
          o2(0xB3,0xC9),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_03 = {
    to_EUC_KR_EB_03_offsets,
    to_EUC_KR_EB_03_infos
};

static const unsigned char
to_EUC_KR_EB_04_offsets[64] = {
     22, 22, 22, 22, 22, 22, 22, 22,      0,  1, 22,  2,  3, 22, 22, 22,
      4, 22,  5,  6, 22, 22, 22, 22,      7,  8, 22,  9, 10, 11, 22, 22,
     22, 22, 22, 12, 13, 14, 22, 22,     15, 22, 22, 22, 16, 22, 22, 22,
     22, 22, 22, 22, 17, 18, 22, 19,     20, 21, 22, 22, 22, 22, 22, 22,
};

static const struct byte_lookup* const
to_EUC_KR_EB_04_infos[23] = {
          o2(0xB3,0xCA),      o2(0xB3,0xCB),
          o2(0xB3,0xCC),      o2(0xB3,0xCD),
          o2(0xB3,0xCE),      o2(0xB3,0xCF),
          o2(0xB3,0xD0),      o2(0xB3,0xD1),
          o2(0xB3,0xD2),      o2(0xB3,0xD3),
          o2(0xB3,0xD4),      o2(0xB3,0xD5),
          o2(0xB3,0xD6),      o2(0xB3,0xD7),
          o2(0xB3,0xD8),      o2(0xB3,0xD9),
          o2(0xB3,0xDA),      o2(0xB3,0xDB),
          o2(0xB3,0xDC),      o2(0xB3,0xDD),
          o2(0xB3,0xDE),      o2(0xB3,0xDF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_04 = {
    to_EUC_KR_EB_04_offsets,
    to_EUC_KR_EB_04_infos
};

static const unsigned char
to_EUC_KR_EB_05_offsets[64] = {
      0,  1, 14, 14,  2, 14, 14, 14,      3, 14, 14, 14, 14, 14, 14, 14,
      4,  5, 14, 14,  6,  7, 14, 14,      8, 14, 14, 14,  9, 14, 14, 14,
     10, 14, 14, 14, 14, 14, 14, 14,     14, 14, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,     11, 12, 14, 14, 13, 14, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_EB_05_infos[15] = {
          o2(0xB3,0xE0),      o2(0xB3,0xE1),
          o2(0xB3,0xE2),      o2(0xB3,0xE3),
          o2(0xB3,0xE4),      o2(0xB3,0xE5),
          o2(0xB3,0xE6),      o2(0xB3,0xE7),
          o2(0xB3,0xE8),      o2(0xB3,0xE9),
          o2(0xB3,0xEA),      o2(0xB3,0xEB),
          o2(0xB3,0xEC),      o2(0xB3,0xED),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_05 = {
    to_EUC_KR_EB_05_offsets,
    to_EUC_KR_EB_05_infos
};

static const unsigned char
to_EUC_KR_EB_06_offsets[64] = {
      0, 12,  1, 12, 12, 12, 12, 12,      2,  3, 12,  4, 12,  5, 12, 12,
     12, 12,  6,  7,  8, 12, 12, 12,      9, 12, 12, 12, 10, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,     11, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_EB_06_infos[13] = {
          o2(0xB3,0xEE),      o2(0xB3,0xEF),
          o2(0xB3,0xF0),      o2(0xB3,0xF1),
          o2(0xB3,0xF2),      o2(0xB3,0xF3),
          o2(0xB3,0xF4),      o2(0xB3,0xF5),
          o2(0xB3,0xF6),      o2(0xB3,0xF7),
          o2(0xB3,0xF8),      o2(0xB3,0xF9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_06 = {
    to_EUC_KR_EB_06_offsets,
    to_EUC_KR_EB_06_infos
};

static const unsigned char
to_EUC_KR_EB_07_offsets[64] = {
     13, 13, 13, 13, 13, 13, 13, 13,     13, 13, 13, 13,  0, 13, 13, 13,
      1, 13, 13, 13,  2, 13, 13, 13,     13, 13, 13, 13,  3,  4, 13,  5,
     13, 13, 13, 13, 13, 13, 13, 13,      6,  7, 13, 13,  8, 13, 13, 13,
      9, 13, 13, 13, 13, 13, 13, 13,     13, 10, 13, 11, 13, 12, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_EB_07_infos[14] = {
          o2(0xB3,0xFA),      o2(0xB3,0xFB),
          o2(0xB3,0xFC),      o2(0xB3,0xFD),
          o2(0xB3,0xFE),      o2(0xB4,0xA1),
          o2(0xB4,0xA2),      o2(0xB4,0xA3),
          o2(0xB4,0xA4),      o2(0xB4,0xA5),
          o2(0xB4,0xA6),      o2(0xB4,0xA7),
          o2(0xB4,0xA8),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_07 = {
    to_EUC_KR_EB_07_offsets,
    to_EUC_KR_EB_07_infos
};

static const unsigned char
to_EUC_KR_EB_08_offsets[64] = {
     12, 12, 12, 12,  0,  1, 12, 12,      2, 12, 12,  3,  4, 12, 12, 12,
     12, 12, 12, 12,  5,  6, 12,  7,     12,  8, 12, 12, 12, 12, 12, 12,
      9, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 10, 12, 12, 12,     12, 12, 12, 12, 11, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_EB_08_infos[13] = {
          o2(0xB4,0xA9),      o2(0xB4,0xAA),
          o2(0xB4,0xAB),      o2(0xB4,0xAC),
          o2(0xB4,0xAD),      o2(0xB4,0xAE),
          o2(0xB4,0xAF),      o2(0xB4,0xB0),
          o2(0xB4,0xB1),      o2(0xB4,0xB2),
          o2(0xB4,0xB3),      o2(0xB4,0xB4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_08 = {
    to_EUC_KR_EB_08_offsets,
    to_EUC_KR_EB_08_infos
};

static const unsigned char
to_EUC_KR_EB_09_offsets[64] = {
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      0,  8,  8,  8,  1,  8,  8,  8,
      2,  8,  8,  8,  8,  8,  8,  8,      3,  4,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  5,  6,  8,  8,      8,  8,  8,  8,  7,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_EB_09_infos[9] = {
          o2(0xB4,0xB5),      o2(0xB4,0xB6),
          o2(0xB4,0xB7),      o2(0xB4,0xB8),
          o2(0xB4,0xB9),      o2(0xB4,0xBA),
          o2(0xB4,0xBB),      o2(0xB4,0xBC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_09 = {
    to_EUC_KR_EB_09_offsets,
    to_EUC_KR_EB_09_infos
};

static const unsigned char
to_EUC_KR_EB_0A_offsets[64] = {
     18, 18, 18, 18,  0,  1, 18, 18,     18,  2, 18, 18, 18, 18, 18, 18,
      3,  4, 18, 18,  5, 18, 18, 18,      6,  7,  8, 18, 18, 18, 18, 18,
      9, 10, 18, 11, 18, 12, 13, 18,     18, 18, 14, 18, 15, 18, 18, 18,
     16, 18, 18, 18, 17, 18, 18, 18,     18, 18, 18, 18, 18, 18, 18, 18,
};

static const struct byte_lookup* const
to_EUC_KR_EB_0A_infos[19] = {
          o2(0xB4,0xBD),      o2(0xB4,0xBE),
          o2(0xB4,0xBF),      o2(0xB4,0xC0),
          o2(0xB4,0xC1),      o2(0xB4,0xC2),
          o2(0xB4,0xC3),      o2(0xB4,0xC4),
          o2(0xB4,0xC5),      o2(0xB4,0xC6),
          o2(0xB4,0xC7),      o2(0xB4,0xC8),
          o2(0xB4,0xC9),      o2(0xB4,0xCA),
          o2(0xB4,0xCB),      o2(0xB4,0xCC),
          o2(0xB4,0xCD),      o2(0xB4,0xCE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_0A = {
    to_EUC_KR_EB_0A_offsets,
    to_EUC_KR_EB_0A_infos
};

static const unsigned char
to_EUC_KR_EB_0B_offsets[64] = {
     28, 28, 28, 28, 28, 28, 28, 28,      0,  1, 28, 28,  2, 28, 28, 28,
      3, 28,  4, 28, 28, 28, 28, 28,      5,  6, 28,  7, 28,  8, 28, 28,
     28, 28,  9, 28, 10, 11, 12, 28,     13, 28, 28, 14, 15, 16, 17, 18,
     28, 28, 28, 19, 20, 21, 28, 22,     23, 24, 25, 26, 28, 28, 28, 27,
};

static const struct byte_lookup* const
to_EUC_KR_EB_0B_infos[29] = {
          o2(0xB4,0xCF),      o2(0xB4,0xD0),
          o2(0xB4,0xD1),      o2(0xB4,0xD2),
          o2(0xB4,0xD3),      o2(0xB4,0xD4),
          o2(0xB4,0xD5),      o2(0xB4,0xD6),
          o2(0xB4,0xD7),      o2(0xB4,0xD8),
          o2(0xB4,0xD9),      o2(0xB4,0xDA),
          o2(0xB4,0xDB),      o2(0xB4,0xDC),
          o2(0xB4,0xDD),      o2(0xB4,0xDE),
          o2(0xB4,0xDF),      o2(0xB4,0xE0),
          o2(0xB4,0xE1),      o2(0xB4,0xE2),
          o2(0xB4,0xE3),      o2(0xB4,0xE4),
          o2(0xB4,0xE5),      o2(0xB4,0xE6),
          o2(0xB4,0xE7),      o2(0xB4,0xE8),
          o2(0xB4,0xE9),      o2(0xB4,0xEA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_0B = {
    to_EUC_KR_EB_0B_offsets,
    to_EUC_KR_EB_0B_infos
};

static const unsigned char
to_EUC_KR_EB_0C_offsets[64] = {
      0,  1, 10, 10,  2, 10, 10, 10,      3, 10, 10, 10, 10, 10, 10, 10,
      4,  5, 10,  6,  7,  8, 10, 10,     10, 10, 10, 10,  9, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_EB_0C_infos[11] = {
          o2(0xB4,0xEB),      o2(0xB4,0xEC),
          o2(0xB4,0xED),      o2(0xB4,0xEE),
          o2(0xB4,0xEF),      o2(0xB4,0xF0),
          o2(0xB4,0xF1),      o2(0xB4,0xF2),
          o2(0xB4,0xF3),      o2(0xB4,0xF4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_0C = {
    to_EUC_KR_EB_0C_offsets,
    to_EUC_KR_EB_0C_infos
};

static const unsigned char
to_EUC_KR_EB_0D_offsets[64] = {
     18, 18, 18, 18, 18, 18, 18, 18,     18, 18, 18, 18, 18, 18, 18, 18,
     18, 18, 18, 18,  0,  1,  2, 18,      3, 18, 18,  4,  5, 18,  6,  7,
     18, 18, 18, 18,  8,  9, 18, 10,     18, 11, 18, 12, 18, 18, 13, 18,
     14, 15, 18, 18, 16, 18, 18, 18,     17, 18, 18, 18, 18, 18, 18, 18,
};

static const struct byte_lookup* const
to_EUC_KR_EB_0D_infos[19] = {
          o2(0xB4,0xF5),      o2(0xB4,0xF6),
          o2(0xB4,0xF7),      o2(0xB4,0xF8),
          o2(0xB4,0xF9),      o2(0xB4,0xFA),
          o2(0xB4,0xFB),      o2(0xB4,0xFC),
          o2(0xB4,0xFD),      o2(0xB4,0xFE),
          o2(0xB5,0xA1),      o2(0xB5,0xA2),
          o2(0xB5,0xA3),      o2(0xB5,0xA4),
          o2(0xB5,0xA5),      o2(0xB5,0xA6),
          o2(0xB5,0xA7),      o2(0xB5,0xA8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_0D = {
    to_EUC_KR_EB_0D_offsets,
    to_EUC_KR_EB_0D_infos
};

static const unsigned char
to_EUC_KR_EB_0E_offsets[64] = {
      0,  1, 12,  2,  3,  4, 12, 12,     12, 12, 12, 12,  5, 12, 12, 12,
      6, 12, 12, 12,  7, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
      8,  9, 12, 12, 12, 12, 12, 12,     10, 12, 12, 12, 11, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_EB_0E_infos[13] = {
          o2(0xB5,0xA9),      o2(0xB5,0xAA),
          o2(0xB5,0xAB),      o2(0xB5,0xAC),
          o2(0xB5,0xAD),      o2(0xB5,0xAE),
          o2(0xB5,0xAF),      o2(0xB5,0xB0),
          o2(0xB5,0xB1),      o2(0xB5,0xB2),
          o2(0xB5,0xB3),      o2(0xB5,0xB4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_0E = {
    to_EUC_KR_EB_0E_offsets,
    to_EUC_KR_EB_0E_infos
};

static const unsigned char
to_EUC_KR_EB_0F_offsets[64] = {
     17, 17, 17, 17,  0,  1, 17, 17,      2, 17, 17,  3,  4, 17,  5, 17,
      6, 17, 17, 17,  7,  8, 17,  9,     17, 10, 17, 11, 17, 12, 17, 17,
     13, 17, 17, 17, 14, 17, 17, 17,     15, 17, 17, 17, 17, 17, 17, 17,
     17, 17, 17, 17, 17, 17, 17, 17,     17, 17, 17, 17, 16, 17, 17, 17,
};

static const struct byte_lookup* const
to_EUC_KR_EB_0F_infos[18] = {
          o2(0xB5,0xB5),      o2(0xB5,0xB6),
          o2(0xB5,0xB7),      o2(0xB5,0xB8),
          o2(0xB5,0xB9),      o2(0xB5,0xBA),
          o2(0xB5,0xBB),      o2(0xB5,0xBC),
          o2(0xB5,0xBD),      o2(0xB5,0xBE),
          o2(0xB5,0xBF),      o2(0xB5,0xC0),
          o2(0xB5,0xC1),      o2(0xB5,0xC2),
          o2(0xB5,0xC3),      o2(0xB5,0xC4),
          o2(0xB5,0xC5),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_0F = {
    to_EUC_KR_EB_0F_offsets,
    to_EUC_KR_EB_0F_infos
};

static const unsigned char
to_EUC_KR_EB_10_offsets[64] = {
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      0,  8,  8,  8,  8,  8,  8,  8,      1,  8,  8,  8,  2,  8,  8,  8,
      3,  8,  8,  8,  8,  8,  8,  8,      4,  5,  8,  6,  8,  8,  8,  8,
      8,  8,  8,  8,  7,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_EB_10_infos[9] = {
          o2(0xB5,0xC6),      o2(0xB5,0xC7),
          o2(0xB5,0xC8),      o2(0xB5,0xC9),
          o2(0xB5,0xCA),      o2(0xB5,0xCB),
          o2(0xB5,0xCC),      o2(0xB5,0xCD),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_10 = {
    to_EUC_KR_EB_10_offsets,
    to_EUC_KR_EB_10_infos
};

static const unsigned char
to_EUC_KR_EB_11_offsets[64] = {
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
      0,  1,  9,  9,  2,  9,  9,  9,      3,  9,  9,  9,  9,  9,  9,  9,
      4,  5,  9,  6,  9,  7,  9,  9,      9,  9,  9,  9,  8,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
};

static const struct byte_lookup* const
to_EUC_KR_EB_11_infos[10] = {
          o2(0xB5,0xCE),      o2(0xB5,0xCF),
          o2(0xB5,0xD0),      o2(0xB5,0xD1),
          o2(0xB5,0xD2),      o2(0xB5,0xD3),
          o2(0xB5,0xD4),      o2(0xB5,0xD5),
          o2(0xB5,0xD6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_11 = {
    to_EUC_KR_EB_11_offsets,
    to_EUC_KR_EB_11_infos
};

static const unsigned char
to_EUC_KR_EB_12_offsets[64] = {
      0,  9,  9,  9,  9,  9,  9,  9,      1,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  2,  9,  9,
      9,  9,  9,  9,  3,  9,  9,  9,      4,  9,  9,  9,  5,  9,  9,  9,
      9,  9,  9,  9,  9,  6,  9,  7,      9,  8,  9,  9,  9,  9,  9,  9,
};

static const struct byte_lookup* const
to_EUC_KR_EB_12_infos[10] = {
          o2(0xB5,0xD7),      o2(0xB5,0xD8),
          o2(0xB5,0xD9),      o2(0xB5,0xDA),
          o2(0xB5,0xDB),      o2(0xB5,0xDC),
          o2(0xB5,0xDD),      o2(0xB5,0xDE),
          o2(0xB5,0xDF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_12 = {
    to_EUC_KR_EB_12_offsets,
    to_EUC_KR_EB_12_infos
};

static const unsigned char
to_EUC_KR_EB_13_offsets[64] = {
      0, 16, 16, 16,  1, 16, 16, 16,      2, 16, 16, 16, 16, 16, 16, 16,
      3, 16, 16, 16, 16,  4, 16, 16,     16, 16, 16, 16,  5,  6, 16, 16,
      7, 16, 16,  8,  9, 16, 10, 16,     16, 16, 16, 16, 11, 12, 16, 13,
     16, 14, 16, 16, 16, 16, 16, 16,     15, 16, 16, 16, 16, 16, 16, 16,
};

static const struct byte_lookup* const
to_EUC_KR_EB_13_infos[17] = {
          o2(0xB5,0xE0),      o2(0xB5,0xE1),
          o2(0xB5,0xE2),      o2(0xB5,0xE3),
          o2(0xB5,0xE4),      o2(0xB5,0xE5),
          o2(0xB5,0xE6),      o2(0xB5,0xE7),
          o2(0xB5,0xE8),      o2(0xB5,0xE9),
          o2(0xB5,0xEA),      o2(0xB5,0xEB),
          o2(0xB5,0xEC),      o2(0xB5,0xED),
          o2(0xB5,0xEE),      o2(0xB5,0xEF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_13 = {
    to_EUC_KR_EB_13_offsets,
    to_EUC_KR_EB_13_infos
};

static const unsigned char
to_EUC_KR_EB_14_offsets[64] = {
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15,  0,  1, 15, 15,      2, 15, 15,  3,  4, 15, 15, 15,
     15, 15, 15, 15,  5,  6, 15,  7,      8,  9, 10, 15, 15, 15, 15, 15,
     11, 12, 15, 15, 13, 15, 15, 15,     14, 15, 15, 15, 15, 15, 15, 15,
};

static const struct byte_lookup* const
to_EUC_KR_EB_14_infos[16] = {
          o2(0xB5,0xF0),      o2(0xB5,0xF1),
          o2(0xB5,0xF2),      o2(0xB5,0xF3),
          o2(0xB5,0xF4),      o2(0xB5,0xF5),
          o2(0xB5,0xF6),      o2(0xB5,0xF7),
          o2(0xB5,0xF8),      o2(0xB5,0xF9),
          o2(0xB5,0xFA),      o2(0xB5,0xFB),
          o2(0xB5,0xFC),      o2(0xB5,0xFD),
          o2(0xB5,0xFE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_14 = {
    to_EUC_KR_EB_14_offsets,
    to_EUC_KR_EB_14_infos
};

static const unsigned char
to_EUC_KR_EB_15_offsets[64] = {
      0,  1, 15,  2,  3,  4, 15, 15,     15, 15, 15,  5,  6,  7, 15, 15,
      8, 15, 15, 15,  9, 15, 15, 15,     15, 15, 15, 15, 10, 11, 15, 12,
     13, 14, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
};

static const struct byte_lookup* const
to_EUC_KR_EB_15_infos[16] = {
          o2(0xB6,0xA1),      o2(0xB6,0xA2),
          o2(0xB6,0xA3),      o2(0xB6,0xA4),
          o2(0xB6,0xA5),      o2(0xB6,0xA6),
          o2(0xB6,0xA7),      o2(0xB6,0xA8),
          o2(0xB6,0xA9),      o2(0xB6,0xAA),
          o2(0xB6,0xAB),      o2(0xB6,0xAC),
          o2(0xB6,0xAD),      o2(0xB6,0xAE),
          o2(0xB6,0xAF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_15 = {
    to_EUC_KR_EB_15_offsets,
    to_EUC_KR_EB_15_infos
};

static const unsigned char
to_EUC_KR_EB_16_offsets[64] = {
     14, 14, 14, 14, 14, 14, 14, 14,     14, 14, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,     14, 14, 14, 14, 14, 14, 14, 14,
      0,  1, 14, 14,  2, 14, 14, 14,      3, 14,  4,  5, 14, 14, 14, 14,
      6,  7, 14,  8,  9, 10, 14, 14,     14, 14, 14, 11, 12, 13, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_EB_16_infos[15] = {
          o2(0xB6,0xB0),      o2(0xB6,0xB1),
          o2(0xB6,0xB2),      o2(0xB6,0xB3),
          o2(0xB6,0xB4),      o2(0xB6,0xB5),
          o2(0xB6,0xB6),      o2(0xB6,0xB7),
          o2(0xB6,0xB8),      o2(0xB6,0xB9),
          o2(0xB6,0xBA),      o2(0xB6,0xBB),
          o2(0xB6,0xBC),      o2(0xB6,0xBD),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_16 = {
    to_EUC_KR_EB_16_offsets,
    to_EUC_KR_EB_16_infos
};

static const unsigned char
to_EUC_KR_EB_17_offsets[64] = {
      0,  9,  9,  9,  1,  9,  9,  9,      9,  9,  9,  9,  2,  3,  9,  4,
      5,  6,  9,  9,  9,  9,  9,  9,      7,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  8,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
};

static const struct byte_lookup* const
to_EUC_KR_EB_17_infos[10] = {
          o2(0xB6,0xBE),      o2(0xB6,0xBF),
          o2(0xB6,0xC0),      o2(0xB6,0xC1),
          o2(0xB6,0xC2),      o2(0xB6,0xC3),
          o2(0xB6,0xC4),      o2(0xB6,0xC5),
          o2(0xB6,0xC6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_17 = {
    to_EUC_KR_EB_17_offsets,
    to_EUC_KR_EB_17_infos
};

static const unsigned char
to_EUC_KR_EB_18_offsets[64] = {
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      0,  1,  7,  7,  2,  7,  7,  7,      3,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  4,  7,  7,      7,  7,  7,  7,  5,  7,  7,  7,
      7,  7,  7,  7,  6,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_EB_18_infos[8] = {
          o2(0xB6,0xC7),      o2(0xB6,0xC8),
          o2(0xB6,0xC9),      o2(0xB6,0xCA),
          o2(0xB6,0xCB),      o2(0xB6,0xCC),
          o2(0xB6,0xCD),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_18 = {
    to_EUC_KR_EB_18_offsets,
    to_EUC_KR_EB_18_infos
};

static const unsigned char
to_EUC_KR_EB_19_offsets[64] = {
      3,  3,  3,  3,  3,  3,  3,  3,      0,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,      3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  1,  3,  3,  3,      2,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,      3,  3,  3,  3,  3,  3,  3,  3,
};

static const struct byte_lookup* const
to_EUC_KR_EB_19_infos[4] = {
          o2(0xB6,0xCE),      o2(0xB6,0xCF),
          o2(0xB6,0xD0),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_19 = {
    to_EUC_KR_EB_19_offsets,
    to_EUC_KR_EB_19_infos
};

static const unsigned char
to_EUC_KR_EB_1A_offsets[64] = {
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  0,  1,  7,  7,
      2,  7,  7,  7,  3,  7,  7,  7,      7,  7,  7,  4,  5,  7,  7,  7,
      7,  6,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_EB_1A_infos[8] = {
          o2(0xB6,0xD1),      o2(0xB6,0xD2),
          o2(0xB6,0xD3),      o2(0xB6,0xD4),
          o2(0xB6,0xD5),      o2(0xB6,0xD6),
          o2(0xB6,0xD7),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_1A = {
    to_EUC_KR_EB_1A_offsets,
    to_EUC_KR_EB_1A_infos
};

static const unsigned char
to_EUC_KR_EB_1B_offsets[64] = {
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  0,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      1,  4,  4,  4,  2,  4,  4,  4,      3,  4,  4,  4,  4,  4,  4,  4,
};

static const struct byte_lookup* const
to_EUC_KR_EB_1B_infos[5] = {
          o2(0xB6,0xD8),      o2(0xB6,0xD9),
          o2(0xB6,0xDA),      o2(0xB6,0xDB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_1B = {
    to_EUC_KR_EB_1B_offsets,
    to_EUC_KR_EB_1B_infos
};

static const unsigned char
to_EUC_KR_EB_1C_offsets[64] = {
      0,  1, 11, 11, 11,  2, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,      3,  4, 11, 11,  5, 11, 11,  6,
      7, 11, 11, 11, 11, 11, 11, 11,      8,  9, 11, 10, 11, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_EB_1C_infos[12] = {
          o2(0xB6,0xDC),      o2(0xB6,0xDD),
          o2(0xB6,0xDE),      o2(0xB6,0xDF),
          o2(0xB6,0xE0),      o2(0xB6,0xE1),
          o2(0xB6,0xE2),      o2(0xB6,0xE3),
          o2(0xB6,0xE4),      o2(0xB6,0xE5),
          o2(0xB6,0xE6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_1C = {
    to_EUC_KR_EB_1C_offsets,
    to_EUC_KR_EB_1C_infos
};

static const unsigned char
to_EUC_KR_EB_1D_offsets[64] = {
     14, 14, 14, 14,  0, 14, 14, 14,      1, 14, 14, 14,  2, 14, 14, 14,
     14, 14, 14, 14,  3,  4, 14, 14,     14, 14, 14, 14, 14, 14, 14, 14,
      5, 14, 14, 14,  6, 14, 14, 14,      7, 14, 14, 14, 14, 14, 14, 14,
      8,  9, 14, 10, 14, 11, 14, 14,     14, 14, 14, 14, 12, 13, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_EB_1D_infos[15] = {
          o2(0xB6,0xE7),      o2(0xB6,0xE8),
          o2(0xB6,0xE9),      o2(0xB6,0xEA),
          o2(0xB6,0xEB),      o2(0xB6,0xEC),
          o2(0xB6,0xED),      o2(0xB6,0xEE),
          o2(0xB6,0xEF),      o2(0xB6,0xF0),
          o2(0xB6,0xF1),      o2(0xB6,0xF2),
          o2(0xB6,0xF3),      o2(0xB6,0xF4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_1D = {
    to_EUC_KR_EB_1D_offsets,
    to_EUC_KR_EB_1D_infos
};

static const unsigned char
to_EUC_KR_EB_1E_offsets[64] = {
      0, 22, 22, 22,  1, 22, 22, 22,     22, 22, 22, 22,  2,  3, 22,  4,
      5,  6,  7, 22, 22, 22,  8,  9,     10, 11, 22, 22, 12, 22, 22, 22,
     13, 22, 22, 22, 22, 22, 22, 22,     14, 15, 22, 16, 17, 18, 22, 22,
     22, 22, 22, 22, 19, 20, 22, 22,     21, 22, 22, 22, 22, 22, 22, 22,
};

static const struct byte_lookup* const
to_EUC_KR_EB_1E_infos[23] = {
          o2(0xB6,0xF5),      o2(0xB6,0xF6),
          o2(0xB6,0xF7),      o2(0xB6,0xF8),
          o2(0xB6,0xF9),      o2(0xB6,0xFA),
          o2(0xB6,0xFB),      o2(0xB6,0xFC),
          o2(0xB6,0xFD),      o2(0xB6,0xFE),
          o2(0xB7,0xA1),      o2(0xB7,0xA2),
          o2(0xB7,0xA3),      o2(0xB7,0xA4),
          o2(0xB7,0xA5),      o2(0xB7,0xA6),
          o2(0xB7,0xA7),      o2(0xB7,0xA8),
          o2(0xB7,0xA9),      o2(0xB7,0xAA),
          o2(0xB7,0xAB),      o2(0xB7,0xAC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_1E = {
    to_EUC_KR_EB_1E_offsets,
    to_EUC_KR_EB_1E_infos
};

static const unsigned char
to_EUC_KR_EB_1F_offsets[64] = {
      9,  9,  9,  9,  9,  9,  9,  0,      9,  1,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  2,  3,  9,  9,
      4,  9,  9,  9,  5,  9,  9,  9,      9,  9,  9,  9,  6,  7,  9,  8,
};

static const struct byte_lookup* const
to_EUC_KR_EB_1F_infos[10] = {
          o2(0xB7,0xAD),      o2(0xB7,0xAE),
          o2(0xB7,0xAF),      o2(0xB7,0xB0),
          o2(0xB7,0xB1),      o2(0xB7,0xB2),
          o2(0xB7,0xB3),      o2(0xB7,0xB4),
          o2(0xB7,0xB5),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_1F = {
    to_EUC_KR_EB_1F_offsets,
    to_EUC_KR_EB_1F_infos
};

static const unsigned char
to_EUC_KR_EB_20_offsets[64] = {
      0,  1, 20, 20, 20, 20, 20,  2,      3,  4, 20, 20,  5, 20, 20, 20,
      6, 20, 20, 20, 20, 20, 20, 20,      7,  8, 20,  9, 20, 10, 20, 20,
     20, 20, 20, 20, 11, 12, 20, 20,     13, 20, 20, 20, 14, 20, 20, 20,
     20, 20, 20, 20, 15, 16, 20, 17,     18, 19, 20, 20, 20, 20, 20, 20,
};

static const struct byte_lookup* const
to_EUC_KR_EB_20_infos[21] = {
          o2(0xB7,0xB6),      o2(0xB7,0xB7),
          o2(0xB7,0xB8),      o2(0xB7,0xB9),
          o2(0xB7,0xBA),      o2(0xB7,0xBB),
          o2(0xB7,0xBC),      o2(0xB7,0xBD),
          o2(0xB7,0xBE),      o2(0xB7,0xBF),
          o2(0xB7,0xC0),      o2(0xB7,0xC1),
          o2(0xB7,0xC2),      o2(0xB7,0xC3),
          o2(0xB7,0xC4),      o2(0xB7,0xC5),
          o2(0xB7,0xC6),      o2(0xB7,0xC7),
          o2(0xB7,0xC8),      o2(0xB7,0xC9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_20 = {
    to_EUC_KR_EB_20_offsets,
    to_EUC_KR_EB_20_infos
};

static const unsigned char
to_EUC_KR_EB_21_offsets[64] = {
      0, 14, 14, 14,  1, 14, 14, 14,     14, 14, 14, 14, 14, 14, 14, 14,
     14,  2, 14,  3, 14, 14, 14, 14,     14, 14, 14, 14,  4,  5, 14, 14,
      6, 14, 14, 14,  7, 14, 14, 14,     14, 14, 14, 14,  8,  9, 14, 10,
     14, 11, 14, 14, 14, 14, 14, 14,     12, 14, 14, 14, 13, 14, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_EB_21_infos[15] = {
          o2(0xB7,0xCA),      o2(0xB7,0xCB),
          o2(0xB7,0xCC),      o2(0xB7,0xCD),
          o2(0xB7,0xCE),      o2(0xB7,0xCF),
          o2(0xB7,0xD0),      o2(0xB7,0xD1),
          o2(0xB7,0xD2),      o2(0xB7,0xD3),
          o2(0xB7,0xD4),      o2(0xB7,0xD5),
          o2(0xB7,0xD6),      o2(0xB7,0xD7),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_21 = {
    to_EUC_KR_EB_21_offsets,
    to_EUC_KR_EB_21_infos
};

static const unsigned char
to_EUC_KR_EB_22_offsets[64] = {
      5,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  5,  0,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,      1,  5,  5,  5,  5,  5,  5,  5,
      2,  5,  5,  5,  3,  5,  5,  5,      4,  5,  5,  5,  5,  5,  5,  5,
};

static const struct byte_lookup* const
to_EUC_KR_EB_22_infos[6] = {
          o2(0xB7,0xD8),      o2(0xB7,0xD9),
          o2(0xB7,0xDA),      o2(0xB7,0xDB),
          o2(0xB7,0xDC),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_22 = {
    to_EUC_KR_EB_22_offsets,
    to_EUC_KR_EB_22_infos
};

static const unsigned char
to_EUC_KR_EB_23_offsets[64] = {
      0,  1, 18,  2, 18,  3, 18, 18,     18, 18, 18, 18,  4, 18, 18, 18,
      5, 18, 18, 18,  6, 18, 18, 18,     18, 18, 18, 18, 18,  7, 18,  8,
     18,  9, 18, 18, 18, 18, 18, 18,     10, 11, 18, 18, 12, 18, 18, 18,
     13, 18, 18, 18, 18, 18, 18, 18,     14, 15, 18, 16, 18, 17, 18, 18,
};

static const struct byte_lookup* const
to_EUC_KR_EB_23_infos[19] = {
          o2(0xB7,0xDD),      o2(0xB7,0xDE),
          o2(0xB7,0xDF),      o2(0xB7,0xE0),
          o2(0xB7,0xE1),      o2(0xB7,0xE2),
          o2(0xB7,0xE3),      o2(0xB7,0xE4),
          o2(0xB7,0xE5),      o2(0xB7,0xE6),
          o2(0xB7,0xE7),      o2(0xB7,0xE8),
          o2(0xB7,0xE9),      o2(0xB7,0xEA),
          o2(0xB7,0xEB),      o2(0xB7,0xEC),
          o2(0xB7,0xED),      o2(0xB7,0xEE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_23 = {
    to_EUC_KR_EB_23_offsets,
    to_EUC_KR_EB_23_infos
};

static const unsigned char
to_EUC_KR_EB_24_offsets[64] = {
      5,  5,  5,  5,  0,  5,  5,  5,      5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,      1,  5,  5,  5,  5,  5,  5,  5,
      2,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  3,  4,  5,  5,
};

static const struct byte_lookup* const
to_EUC_KR_EB_24_infos[6] = {
          o2(0xB7,0xEF),      o2(0xB7,0xF0),
          o2(0xB7,0xF1),      o2(0xB7,0xF2),
          o2(0xB7,0xF3),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_24 = {
    to_EUC_KR_EB_24_offsets,
    to_EUC_KR_EB_24_infos
};

static const unsigned char
to_EUC_KR_EB_25_offsets[64] = {
      0, 17, 17, 17,  1, 17, 17, 17,     17, 17, 17, 17,  2, 17, 17,  3,
     17,  4, 17, 17, 17, 17, 17, 17,      5,  6, 17, 17,  7, 17, 17, 17,
      8, 17, 17, 17, 17, 17, 17, 17,      9, 10, 17, 11, 17, 12, 17, 17,
     17, 17, 17, 17, 13, 14, 17, 17,     15, 17, 17, 17, 16, 17, 17, 17,
};

static const struct byte_lookup* const
to_EUC_KR_EB_25_infos[18] = {
          o2(0xB7,0xF4),      o2(0xB7,0xF5),
          o2(0xB7,0xF6),      o2(0xB7,0xF7),
          o2(0xB7,0xF8),      o2(0xB7,0xF9),
          o2(0xB7,0xFA),      o2(0xB7,0xFB),
          o2(0xB7,0xFC),      o2(0xB7,0xFD),
          o2(0xB7,0xFE),      o2(0xB8,0xA1),
          o2(0xB8,0xA2),      o2(0xB8,0xA3),
          o2(0xB8,0xA4),      o2(0xB8,0xA5),
          o2(0xB8,0xA6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_25 = {
    to_EUC_KR_EB_25_offsets,
    to_EUC_KR_EB_25_infos
};

static const unsigned char
to_EUC_KR_EB_26_offsets[64] = {
     14, 14, 14, 14,  0,  1, 14,  2,     14,  3,  4, 14, 14,  5,  6, 14,
     14, 14, 14, 14, 14, 14, 14, 14,     14, 14, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,     14, 14, 14, 14,  7,  8, 14, 14,
      9, 14, 14, 14, 10, 14, 14, 14,     14, 14, 14, 14, 11, 12, 14, 13,
};

static const struct byte_lookup* const
to_EUC_KR_EB_26_infos[15] = {
          o2(0xB8,0xA7),      o2(0xB8,0xA8),
          o2(0xB8,0xA9),      o2(0xB8,0xAA),
          o2(0xB8,0xAB),      o2(0xB8,0xAC),
          o2(0xB8,0xAD),      o2(0xB8,0xAE),
          o2(0xB8,0xAF),      o2(0xB8,0xB0),
          o2(0xB8,0xB1),      o2(0xB8,0xB2),
          o2(0xB8,0xB3),      o2(0xB8,0xB4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_26 = {
    to_EUC_KR_EB_26_offsets,
    to_EUC_KR_EB_26_infos
};

static const unsigned char
to_EUC_KR_EB_27_offsets[64] = {
     26,  0, 26, 26, 26, 26, 26, 26,      1,  2, 26, 26,  3, 26,  4,  5,
      6,  7,  8, 26, 26, 26, 26, 26,      9, 10, 26, 11, 26, 12, 13, 26,
     26, 14, 26, 15, 16, 17, 26, 26,     18, 26, 26, 26, 19, 26, 26, 26,
     26, 26, 26, 26, 20, 21, 26, 22,     23, 24, 25, 26, 26, 26, 26, 26,
};

static const struct byte_lookup* const
to_EUC_KR_EB_27_infos[27] = {
          o2(0xB8,0xB5),      o2(0xB8,0xB6),
          o2(0xB8,0xB7),      o2(0xB8,0xB8),
          o2(0xB8,0xB9),      o2(0xB8,0xBA),
          o2(0xB8,0xBB),      o2(0xB8,0xBC),
          o2(0xB8,0xBD),      o2(0xB8,0xBE),
          o2(0xB8,0xBF),      o2(0xB8,0xC0),
          o2(0xB8,0xC1),      o2(0xB8,0xC2),
          o2(0xB8,0xC3),      o2(0xB8,0xC4),
          o2(0xB8,0xC5),      o2(0xB8,0xC6),
          o2(0xB8,0xC7),      o2(0xB8,0xC8),
          o2(0xB8,0xC9),      o2(0xB8,0xCA),
          o2(0xB8,0xCB),      o2(0xB8,0xCC),
          o2(0xB8,0xCD),      o2(0xB8,0xCE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_27 = {
    to_EUC_KR_EB_27_offsets,
    to_EUC_KR_EB_27_infos
};

static const unsigned char
to_EUC_KR_EB_28_offsets[64] = {
      0,  1,  7,  7,  7,  7,  7,  7,      2,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  3,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      4,  5,  7,  7,  6,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_EB_28_infos[8] = {
          o2(0xB8,0xCF),      o2(0xB8,0xD0),
          o2(0xB8,0xD1),      o2(0xB8,0xD2),
          o2(0xB8,0xD3),      o2(0xB8,0xD4),
          o2(0xB8,0xD5),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_28 = {
    to_EUC_KR_EB_28_offsets,
    to_EUC_KR_EB_28_infos
};

static const unsigned char
to_EUC_KR_EB_29_offsets[64] = {
      0, 21,  1, 21, 21, 21, 21, 21,      2,  3, 21,  4, 21,  5,  6, 21,
     21, 21, 21,  7,  8,  9, 21, 21,     10, 21, 21, 21, 11, 21, 21, 21,
     21, 21, 21, 21, 12, 13, 21, 14,     15, 16, 21, 21, 21, 21, 21, 21,
     17, 18, 21, 21, 19, 21, 21, 21,     20, 21, 21, 21, 21, 21, 21, 21,
};

static const struct byte_lookup* const
to_EUC_KR_EB_29_infos[22] = {
          o2(0xB8,0xD6),      o2(0xB8,0xD7),
          o2(0xB8,0xD8),      o2(0xB8,0xD9),
          o2(0xB8,0xDA),      o2(0xB8,0xDB),
          o2(0xB8,0xDC),      o2(0xB8,0xDD),
          o2(0xB8,0xDE),      o2(0xB8,0xDF),
          o2(0xB8,0xE0),      o2(0xB8,0xE1),
          o2(0xB8,0xE2),      o2(0xB8,0xE3),
          o2(0xB8,0xE4),      o2(0xB8,0xE5),
          o2(0xB8,0xE6),      o2(0xB8,0xE7),
          o2(0xB8,0xE8),      o2(0xB8,0xE9),
          o2(0xB8,0xEA),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_29 = {
    to_EUC_KR_EB_29_offsets,
    to_EUC_KR_EB_29_infos
};

static const unsigned char
to_EUC_KR_EB_2A_offsets[64] = {
     15, 15, 15,  0,  1,  2, 15,  3,     15, 15, 15, 15,  4, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,      5,  6, 15,  7,  8, 15, 15, 15,
      9, 15, 10, 15, 15, 15, 15, 15,     11, 12, 15, 13, 15, 14, 15, 15,
};

static const struct byte_lookup* const
to_EUC_KR_EB_2A_infos[16] = {
          o2(0xB8,0xEB),      o2(0xB8,0xEC),
          o2(0xB8,0xED),      o2(0xB8,0xEE),
          o2(0xB8,0xEF),      o2(0xB8,0xF0),
          o2(0xB8,0xF1),      o2(0xB8,0xF2),
          o2(0xB8,0xF3),      o2(0xB8,0xF4),
          o2(0xB8,0xF5),      o2(0xB8,0xF6),
          o2(0xB8,0xF7),      o2(0xB8,0xF8),
          o2(0xB8,0xF9),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_2A = {
    to_EUC_KR_EB_2A_offsets,
    to_EUC_KR_EB_2A_infos
};

static const unsigned char
to_EUC_KR_EB_2B_offsets[64] = {
      5,  5,  5,  5,  0,  5,  5,  5,      1,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,      2,  3,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  4,  5,  5,  5,
};

static const struct byte_lookup* const
to_EUC_KR_EB_2B_infos[6] = {
          o2(0xB8,0xFA),      o2(0xB8,0xFB),
          o2(0xB8,0xFC),      o2(0xB8,0xFD),
          o2(0xB8,0xFE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_2B = {
    to_EUC_KR_EB_2B_offsets,
    to_EUC_KR_EB_2B_infos
};

static const unsigned char
to_EUC_KR_EB_2C_offsets[64] = {
      0, 18, 18, 18,  1, 18, 18, 18,     18, 18, 18, 18, 18,  2, 18,  3,
     18,  4, 18, 18, 18, 18, 18, 18,      5, 18, 18, 18,  6, 18, 18, 18,
      7, 18, 18, 18, 18, 18, 18, 18,     18,  8, 18,  9, 18, 18, 18, 18,
     18, 18, 18, 18, 10, 11, 12, 18,     13, 18, 18, 14, 15, 16, 17, 18,
};

static const struct byte_lookup* const
to_EUC_KR_EB_2C_infos[19] = {
          o2(0xB9,0xA1),      o2(0xB9,0xA2),
          o2(0xB9,0xA3),      o2(0xB9,0xA4),
          o2(0xB9,0xA5),      o2(0xB9,0xA6),
          o2(0xB9,0xA7),      o2(0xB9,0xA8),
          o2(0xB9,0xA9),      o2(0xB9,0xAA),
          o2(0xB9,0xAB),      o2(0xB9,0xAC),
          o2(0xB9,0xAD),      o2(0xB9,0xAE),
          o2(0xB9,0xAF),      o2(0xB9,0xB0),
          o2(0xB9,0xB1),      o2(0xB9,0xB2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_2C = {
    to_EUC_KR_EB_2C_offsets,
    to_EUC_KR_EB_2C_infos
};

static const unsigned char
to_EUC_KR_EB_2D_offsets[64] = {
     12, 12, 12, 12,  0,  1, 12,  2,     12,  3, 12, 12, 12,  4, 12,  5,
      6, 12, 12, 12,  7, 12, 12, 12,      8, 12, 12, 12, 12, 12, 12, 12,
     12,  9, 12, 10, 12, 12, 12, 12,     12, 12, 12, 12, 11, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_EB_2D_infos[13] = {
          o2(0xB9,0xB3),      o2(0xB9,0xB4),
          o2(0xB9,0xB5),      o2(0xB9,0xB6),
          o2(0xB9,0xB7),      o2(0xB9,0xB8),
          o2(0xB9,0xB9),      o2(0xB9,0xBA),
          o2(0xB9,0xBB),      o2(0xB9,0xBC),
          o2(0xB9,0xBD),      o2(0xB9,0xBE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_2D = {
    to_EUC_KR_EB_2D_offsets,
    to_EUC_KR_EB_2D_infos
};

static const unsigned char
to_EUC_KR_EB_2E_offsets[64] = {
      8,  8,  8,  8,  8,  8,  8,  8,      0,  8,  8,  8,  1,  8,  8,  8,
      2,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  3,  8,  8,  8,      4,  8,  8,  8,  5,  8,  8,  8,
      8,  8,  8,  8,  6,  8,  8,  7,      8,  8,  8,  8,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_EB_2E_infos[9] = {
          o2(0xB9,0xBF),      o2(0xB9,0xC0),
          o2(0xB9,0xC1),      o2(0xB9,0xC2),
          o2(0xB9,0xC3),      o2(0xB9,0xC4),
          o2(0xB9,0xC5),      o2(0xB9,0xC6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_2E = {
    to_EUC_KR_EB_2E_offsets,
    to_EUC_KR_EB_2E_infos
};

static const unsigned char
to_EUC_KR_EB_2F_offsets[64] = {
      0,  9,  9,  9,  1,  9,  9,  9,      2,  9,  9,  9,  9,  9,  9,  9,
      3,  9,  9,  4,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      5,  6,  9,  9,  7,  9,  9,  8,
};

static const struct byte_lookup* const
to_EUC_KR_EB_2F_infos[10] = {
          o2(0xB9,0xC7),      o2(0xB9,0xC8),
          o2(0xB9,0xC9),      o2(0xB9,0xCA),
          o2(0xB9,0xCB),      o2(0xB9,0xCC),
          o2(0xB9,0xCD),      o2(0xB9,0xCE),
          o2(0xB9,0xCF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_2F = {
    to_EUC_KR_EB_2F_offsets,
    to_EUC_KR_EB_2F_infos
};

static const unsigned char
to_EUC_KR_EB_30_offsets[64] = {
      0, 28,  1, 28, 28, 28, 28, 28,      2,  3, 28,  4,  5,  6, 28,  7,
     28,  8, 28, 28,  9, 10, 11, 12,     13, 28, 28, 14, 15, 16, 17, 18,
     28, 28, 28, 28, 19, 20, 28, 21,     28, 22, 28, 28, 28, 23, 28, 28,
     24, 25, 28, 28, 26, 28, 28, 28,     27, 28, 28, 28, 28, 28, 28, 28,
};

static const struct byte_lookup* const
to_EUC_KR_EB_30_infos[29] = {
          o2(0xB9,0xD0),      o2(0xB9,0xD1),
          o2(0xB9,0xD2),      o2(0xB9,0xD3),
          o2(0xB9,0xD4),      o2(0xB9,0xD5),
          o2(0xB9,0xD6),      o2(0xB9,0xD7),
          o2(0xB9,0xD8),      o2(0xB9,0xD9),
          o2(0xB9,0xDA),      o2(0xB9,0xDB),
          o2(0xB9,0xDC),      o2(0xB9,0xDD),
          o2(0xB9,0xDE),      o2(0xB9,0xDF),
          o2(0xB9,0xE0),      o2(0xB9,0xE1),
          o2(0xB9,0xE2),      o2(0xB9,0xE3),
          o2(0xB9,0xE4),      o2(0xB9,0xE5),
          o2(0xB9,0xE6),      o2(0xB9,0xE7),
          o2(0xB9,0xE8),      o2(0xB9,0xE9),
          o2(0xB9,0xEA),      o2(0xB9,0xEB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_30 = {
    to_EUC_KR_EB_30_offsets,
    to_EUC_KR_EB_30_infos
};

static const unsigned char
to_EUC_KR_EB_31_offsets[64] = {
      0,  1, 10,  2,  3,  4, 10, 10,     10,  5, 10, 10,  6,  7, 10, 10,
      8, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10,  9, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_EB_31_infos[11] = {
          o2(0xB9,0xEC),      o2(0xB9,0xED),
          o2(0xB9,0xEE),      o2(0xB9,0xEF),
          o2(0xB9,0xF0),      o2(0xB9,0xF1),
          o2(0xB9,0xF2),      o2(0xB9,0xF3),
          o2(0xB9,0xF4),      o2(0xB9,0xF5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_31 = {
    to_EUC_KR_EB_31_offsets,
    to_EUC_KR_EB_31_infos
};

static const unsigned char
to_EUC_KR_EB_32_offsets[64] = {
     23, 23, 23, 23,  0,  1, 23, 23,      2, 23, 23,  3,  4, 23,  5, 23,
     23, 23, 23, 23,  6,  7, 23,  8,     23,  9, 10, 23, 23, 23, 23, 23,
     11, 12, 23, 23, 13, 23, 23, 14,     15, 23, 23, 23, 23, 23, 23, 23,
     16, 17, 23, 18, 19, 20, 23, 23,     23, 23, 23, 23, 21, 22, 23, 23,
};

static const struct byte_lookup* const
to_EUC_KR_EB_32_infos[24] = {
          o2(0xB9,0xF6),      o2(0xB9,0xF7),
          o2(0xB9,0xF8),      o2(0xB9,0xF9),
          o2(0xB9,0xFA),      o2(0xB9,0xFB),
          o2(0xB9,0xFC),      o2(0xB9,0xFD),
          o2(0xB9,0xFE),      o2(0xBA,0xA1),
          o2(0xBA,0xA2),      o2(0xBA,0xA3),
          o2(0xBA,0xA4),      o2(0xBA,0xA5),
          o2(0xBA,0xA6),      o2(0xBA,0xA7),
          o2(0xBA,0xA8),      o2(0xBA,0xA9),
          o2(0xBA,0xAA),      o2(0xBA,0xAB),
          o2(0xBA,0xAC),      o2(0xBA,0xAD),
          o2(0xBA,0xAE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_32 = {
    to_EUC_KR_EB_32_offsets,
    to_EUC_KR_EB_32_infos
};

static const unsigned char
to_EUC_KR_EB_33_offsets[64] = {
      0, 14, 14, 14,  1, 14, 14, 14,     14, 14, 14, 14, 14,  2, 14,  3,
      4,  5, 14, 14, 14,  6, 14, 14,      7, 14, 14, 14,  8, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,     14, 14, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14,  9, 10, 11, 14,     12, 14, 14, 14, 13, 14, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_EB_33_infos[15] = {
          o2(0xBA,0xAF),      o2(0xBA,0xB0),
          o2(0xBA,0xB1),      o2(0xBA,0xB2),
          o2(0xBA,0xB3),      o2(0xBA,0xB4),
          o2(0xBA,0xB5),      o2(0xBA,0xB6),
          o2(0xBA,0xB7),      o2(0xBA,0xB8),
          o2(0xBA,0xB9),      o2(0xBA,0xBA),
          o2(0xBA,0xBB),      o2(0xBA,0xBC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_33 = {
    to_EUC_KR_EB_33_offsets,
    to_EUC_KR_EB_33_infos
};

static const unsigned char
to_EUC_KR_EB_34_offsets[64] = {
      8,  8,  8,  8,  0,  1,  8,  2,      8,  3,  8,  8,  8,  8,  8,  8,
      4,  8,  8,  8,  5,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  6,  8,  8,  8,      8,  8,  8,  8,  7,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_EB_34_infos[9] = {
          o2(0xBA,0xBD),      o2(0xBA,0xBE),
          o2(0xBA,0xBF),      o2(0xBA,0xC0),
          o2(0xBA,0xC1),      o2(0xBA,0xC2),
          o2(0xBA,0xC3),      o2(0xBA,0xC4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_34 = {
    to_EUC_KR_EB_34_offsets,
    to_EUC_KR_EB_34_infos
};

static const unsigned char
to_EUC_KR_EB_35_offsets[64] = {
      0,  9,  9,  9,  9,  9,  9,  9,      1,  2,  9,  9,  3,  9,  9,  9,
      4,  9,  9,  9,  9,  9,  9,  9,      5,  6,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  7,  9,  9,  9,      8,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
};

static const struct byte_lookup* const
to_EUC_KR_EB_35_infos[10] = {
          o2(0xBA,0xC5),      o2(0xBA,0xC6),
          o2(0xBA,0xC7),      o2(0xBA,0xC8),
          o2(0xBA,0xC9),      o2(0xBA,0xCA),
          o2(0xBA,0xCB),      o2(0xBA,0xCC),
          o2(0xBA,0xCD),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_35 = {
    to_EUC_KR_EB_35_offsets,
    to_EUC_KR_EB_35_infos
};

static const unsigned char
to_EUC_KR_EB_36_offsets[64] = {
      0,  1, 17, 17,  2, 17, 17,  3,      4,  5,  6, 17, 17, 17, 17, 17,
      7,  8, 17,  9, 17, 10, 17, 17,     17, 11, 12, 17, 13, 17, 17, 17,
     17, 17, 17, 17, 14, 17, 17, 17,     17, 17, 17, 17, 17, 17, 17, 17,
     15, 17, 17, 17, 17, 17, 17, 17,     16, 17, 17, 17, 17, 17, 17, 17,
};

static const struct byte_lookup* const
to_EUC_KR_EB_36_infos[18] = {
          o2(0xBA,0xCE),      o2(0xBA,0xCF),
          o2(0xBA,0xD0),      o2(0xBA,0xD1),
          o2(0xBA,0xD2),      o2(0xBA,0xD3),
          o2(0xBA,0xD4),      o2(0xBA,0xD5),
          o2(0xBA,0xD6),      o2(0xBA,0xD7),
          o2(0xBA,0xD8),      o2(0xBA,0xD9),
          o2(0xBA,0xDA),      o2(0xBA,0xDB),
          o2(0xBA,0xDC),      o2(0xBA,0xDD),
          o2(0xBA,0xDE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_36 = {
    to_EUC_KR_EB_36_offsets,
    to_EUC_KR_EB_36_infos
};

static const unsigned char
to_EUC_KR_EB_37_offsets[64] = {
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  0,  1,  8,  8,      2,  8,  8,  8,  3,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  4,  8,  8,  8,  8,  8,  8,
      5,  8,  8,  8,  6,  8,  8,  8,      7,  8,  8,  8,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_EB_37_infos[9] = {
          o2(0xBA,0xDF),      o2(0xBA,0xE0),
          o2(0xBA,0xE1),      o2(0xBA,0xE2),
          o2(0xBA,0xE3),      o2(0xBA,0xE4),
          o2(0xBA,0xE5),      o2(0xBA,0xE6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_37 = {
    to_EUC_KR_EB_37_offsets,
    to_EUC_KR_EB_37_infos
};

static const unsigned char
to_EUC_KR_EB_38_offsets[64] = {
      0, 10, 10,  1, 10,  2, 10, 10,     10, 10, 10, 10,  3,  4, 10, 10,
      5, 10, 10, 10,  6, 10, 10, 10,     10, 10, 10, 10,  7,  8, 10,  9,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_EB_38_infos[11] = {
          o2(0xBA,0xE7),      o2(0xBA,0xE8),
          o2(0xBA,0xE9),      o2(0xBA,0xEA),
          o2(0xBA,0xEB),      o2(0xBA,0xEC),
          o2(0xBA,0xED),      o2(0xBA,0xEE),
          o2(0xBA,0xEF),      o2(0xBA,0xF0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_38 = {
    to_EUC_KR_EB_38_offsets,
    to_EUC_KR_EB_38_infos
};

static const unsigned char
to_EUC_KR_EB_39_offsets[64] = {
     24, 24, 24, 24,  0,  1, 24, 24,      2, 24, 24, 24,  3, 24,  4, 24,
     24, 24, 24, 24,  5,  6, 24,  7,     24,  8,  9, 10, 24, 24, 24, 24,
     11, 12, 24, 24, 13, 24, 24, 24,     14, 24, 15, 24, 24, 24, 24, 24,
     16, 17, 24, 18, 19, 20, 24, 24,     24, 24, 24, 21, 22, 23, 24, 24,
};

static const struct byte_lookup* const
to_EUC_KR_EB_39_infos[25] = {
          o2(0xBA,0xF1),      o2(0xBA,0xF2),
          o2(0xBA,0xF3),      o2(0xBA,0xF4),
          o2(0xBA,0xF5),      o2(0xBA,0xF6),
          o2(0xBA,0xF7),      o2(0xBA,0xF8),
          o2(0xBA,0xF9),      o2(0xBA,0xFA),
          o2(0xBA,0xFB),      o2(0xBA,0xFC),
          o2(0xBA,0xFD),      o2(0xBA,0xFE),
          o2(0xBB,0xA1),      o2(0xBB,0xA2),
          o2(0xBB,0xA3),      o2(0xBB,0xA4),
          o2(0xBB,0xA5),      o2(0xBB,0xA6),
          o2(0xBB,0xA7),      o2(0xBB,0xA8),
          o2(0xBB,0xA9),      o2(0xBB,0xAA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_39 = {
    to_EUC_KR_EB_39_offsets,
    to_EUC_KR_EB_39_infos
};

static const unsigned char
to_EUC_KR_EB_3A_offsets[64] = {
      0, 10, 10, 10,  1, 10, 10, 10,     10, 10, 10, 10,  2,  3, 10,  4,
      5,  6, 10, 10, 10, 10, 10, 10,      7,  8, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,      9, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_EB_3A_infos[11] = {
          o2(0xBB,0xAB),      o2(0xBB,0xAC),
          o2(0xBB,0xAD),      o2(0xBB,0xAE),
          o2(0xBB,0xAF),      o2(0xBB,0xB0),
          o2(0xBB,0xB1),      o2(0xBB,0xB2),
          o2(0xBB,0xB3),      o2(0xBB,0xB4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_3A = {
    to_EUC_KR_EB_3A_offsets,
    to_EUC_KR_EB_3A_infos
};

static const unsigned char
to_EUC_KR_EB_3B_offsets[64] = {
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
      0,  1, 10, 10,  2, 10, 10,  3,      4, 10, 10, 10, 10, 10, 10, 10,
      5, 10, 10,  6,  7,  8, 10, 10,     10, 10, 10, 10,  9, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_EB_3B_infos[11] = {
          o2(0xBB,0xB5),      o2(0xBB,0xB6),
          o2(0xBB,0xB7),      o2(0xBB,0xB8),
          o2(0xBB,0xB9),      o2(0xBB,0xBA),
          o2(0xBB,0xBB),      o2(0xBB,0xBC),
          o2(0xBB,0xBD),      o2(0xBB,0xBE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_3B = {
    to_EUC_KR_EB_3B_offsets,
    to_EUC_KR_EB_3B_infos
};

static const unsigned char
to_EUC_KR_EB_3C_offsets[64] = {
      8,  0,  8,  8,  8,  8,  8,  8,      1,  2,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      3,  4,  8,  5,  6,  7,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_EB_3C_infos[9] = {
          o2(0xBB,0xBF),      o2(0xBB,0xC0),
          o2(0xBB,0xC1),      o2(0xBB,0xC2),
          o2(0xBB,0xC3),      o2(0xBB,0xC4),
          o2(0xBB,0xC5),      o2(0xBB,0xC6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_3C = {
    to_EUC_KR_EB_3C_offsets,
    to_EUC_KR_EB_3C_infos
};

static const unsigned char
to_EUC_KR_EB_3D_offsets[64] = {
      0,  1,  7,  7,  2,  7,  7,  7,      3,  7,  7,  7,  7,  7,  7,  7,
      4,  5,  7,  7,  7,  6,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_EB_3D_infos[8] = {
          o2(0xBB,0xC7),      o2(0xBB,0xC8),
          o2(0xBB,0xC9),      o2(0xBB,0xCA),
          o2(0xBB,0xCB),      o2(0xBB,0xCC),
          o2(0xBB,0xCD),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_3D = {
    to_EUC_KR_EB_3D_offsets,
    to_EUC_KR_EB_3D_infos
};

static const unsigned char
to_EUC_KR_EB_3E_offsets[64] = {
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  0,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
      1,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
};

static const struct byte_lookup* const
to_EUC_KR_EB_3E_infos[3] = {
          o2(0xBB,0xCE),      o2(0xBB,0xCF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_3E = {
    to_EUC_KR_EB_3E_offsets,
    to_EUC_KR_EB_3E_infos
};

static const unsigned char
to_EUC_KR_EB_3F_offsets[64] = {
      8,  8,  8,  8,  8,  0,  8,  8,      8,  8,  8,  8,  1,  2,  8,  8,
      3,  8,  8,  8,  4,  8,  8,  8,      8,  8,  8,  8,  5,  8,  8,  6,
      8,  7,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_EB_3F_infos[9] = {
          o2(0xBB,0xD0),      o2(0xBB,0xD1),
          o2(0xBB,0xD2),      o2(0xBB,0xD3),
          o2(0xBB,0xD4),      o2(0xBB,0xD5),
          o2(0xBB,0xD6),      o2(0xBB,0xD7),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB_3F = {
    to_EUC_KR_EB_3F_offsets,
    to_EUC_KR_EB_3F_infos
};


static const struct byte_lookup* const
to_EUC_KR_EB_infos[65] = {
       &to_EUC_KR_EB_00,   &to_EUC_KR_EB_01,
       &to_EUC_KR_EB_02,   &to_EUC_KR_EB_03,
       &to_EUC_KR_EB_04,   &to_EUC_KR_EB_05,
       &to_EUC_KR_EB_06,   &to_EUC_KR_EB_07,
       &to_EUC_KR_EB_08,   &to_EUC_KR_EB_09,
       &to_EUC_KR_EB_0A,   &to_EUC_KR_EB_0B,
       &to_EUC_KR_EB_0C,   &to_EUC_KR_EB_0D,
       &to_EUC_KR_EB_0E,   &to_EUC_KR_EB_0F,
       &to_EUC_KR_EB_10,   &to_EUC_KR_EB_11,
       &to_EUC_KR_EB_12,   &to_EUC_KR_EB_13,
       &to_EUC_KR_EB_14,   &to_EUC_KR_EB_15,
       &to_EUC_KR_EB_16,   &to_EUC_KR_EB_17,
       &to_EUC_KR_EB_18,   &to_EUC_KR_EB_19,
       &to_EUC_KR_EB_1A,   &to_EUC_KR_EB_1B,
       &to_EUC_KR_EB_1C,   &to_EUC_KR_EB_1D,
       &to_EUC_KR_EB_1E,   &to_EUC_KR_EB_1F,
       &to_EUC_KR_EB_20,   &to_EUC_KR_EB_21,
       &to_EUC_KR_EB_22,   &to_EUC_KR_EB_23,
       &to_EUC_KR_EB_24,   &to_EUC_KR_EB_25,
       &to_EUC_KR_EB_26,   &to_EUC_KR_EB_27,
       &to_EUC_KR_EB_28,   &to_EUC_KR_EB_29,
       &to_EUC_KR_EB_2A,   &to_EUC_KR_EB_2B,
       &to_EUC_KR_EB_2C,   &to_EUC_KR_EB_2D,
       &to_EUC_KR_EB_2E,   &to_EUC_KR_EB_2F,
       &to_EUC_KR_EB_30,   &to_EUC_KR_EB_31,
       &to_EUC_KR_EB_32,   &to_EUC_KR_EB_33,
       &to_EUC_KR_EB_34,   &to_EUC_KR_EB_35,
       &to_EUC_KR_EB_36,   &to_EUC_KR_EB_37,
       &to_EUC_KR_EB_38,   &to_EUC_KR_EB_39,
       &to_EUC_KR_EB_3A,   &to_EUC_KR_EB_3B,
       &to_EUC_KR_EB_3C,   &to_EUC_KR_EB_3D,
       &to_EUC_KR_EB_3E,   &to_EUC_KR_EB_3F,
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EB = {
    to_EUC_KR_E3_05_offsets,
    to_EUC_KR_EB_infos
};

static const unsigned char
to_EUC_KR_EC_00_offsets[64] = {
      1,  1,  1,  1,  1,  1,  1,  1,      1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,      1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,      1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,      1,  1,  1,  1,  0,  1,  1,  1,
};

static const struct byte_lookup* const
to_EUC_KR_EC_00_infos[2] = {
          o2(0xBB,0xD8),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_00 = {
    to_EUC_KR_EC_00_offsets,
    to_EUC_KR_EC_00_infos
};

static const unsigned char
to_EUC_KR_EC_01_offsets[64] = {
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  0,  6,  6,  6,  6,  6,  6,      1,  6,  6,  6,  2,  6,  6,  6,
      3,  6,  6,  6,  6,  6,  6,  6,      4,  5,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_EC_01_infos[7] = {
          o2(0xBB,0xD9),      o2(0xBB,0xDA),
          o2(0xBB,0xDB),      o2(0xBB,0xDC),
          o2(0xBB,0xDD),      o2(0xBB,0xDE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_01 = {
    to_EUC_KR_EC_01_offsets,
    to_EUC_KR_EC_01_infos
};

static const unsigned char
to_EUC_KR_EC_02_offsets[64] = {
     19, 19, 19, 19, 19, 19, 19, 19,     19, 19, 19, 19, 19, 19, 19, 19,
      0,  1, 19, 19,  2, 19, 19, 19,      3, 19, 19, 19, 19, 19, 19, 19,
      4,  5, 19,  6, 19,  7, 19, 19,     19, 19, 19, 19,  8,  9, 19, 10,
     11, 19, 19, 12, 13, 14, 15, 19,     19, 19, 19, 19, 16, 17, 19, 18,
};

static const struct byte_lookup* const
to_EUC_KR_EC_02_infos[20] = {
          o2(0xBB,0xDF),      o2(0xBB,0xE0),
          o2(0xBB,0xE1),      o2(0xBB,0xE2),
          o2(0xBB,0xE3),      o2(0xBB,0xE4),
          o2(0xBB,0xE5),      o2(0xBB,0xE6),
          o2(0xBB,0xE7),      o2(0xBB,0xE8),
          o2(0xBB,0xE9),      o2(0xBB,0xEA),
          o2(0xBB,0xEB),      o2(0xBB,0xEC),
          o2(0xBB,0xED),      o2(0xBB,0xEE),
          o2(0xBB,0xEF),      o2(0xBB,0xF0),
          o2(0xBB,0xF1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_02 = {
    to_EUC_KR_EC_02_offsets,
    to_EUC_KR_EC_02_infos
};

static const unsigned char
to_EUC_KR_EC_03_offsets[64] = {
      0,  1, 20, 20, 20,  2, 20, 20,      3,  4, 20, 20,  5, 20, 20, 20,
      6, 20, 20, 20, 20, 20, 20, 20,      7,  8, 20,  9, 10, 11, 20, 20,
     20, 20, 20, 20, 12, 13, 20, 20,     14, 20, 20, 20, 15, 20, 20, 20,
     20, 20, 20, 20, 16, 17, 20, 18,     20, 19, 20, 20, 20, 20, 20, 20,
};

static const struct byte_lookup* const
to_EUC_KR_EC_03_infos[21] = {
          o2(0xBB,0xF2),      o2(0xBB,0xF3),
          o2(0xBB,0xF4),      o2(0xBB,0xF5),
          o2(0xBB,0xF6),      o2(0xBB,0xF7),
          o2(0xBB,0xF8),      o2(0xBB,0xF9),
          o2(0xBB,0xFA),      o2(0xBB,0xFB),
          o2(0xBB,0xFC),      o2(0xBB,0xFD),
          o2(0xBB,0xFE),      o2(0xBC,0xA1),
          o2(0xBC,0xA2),      o2(0xBC,0xA3),
          o2(0xBC,0xA4),      o2(0xBC,0xA5),
          o2(0xBC,0xA6),      o2(0xBC,0xA7),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_03 = {
    to_EUC_KR_EC_03_offsets,
    to_EUC_KR_EC_03_infos
};

static const unsigned char
to_EUC_KR_EC_04_offsets[64] = {
      0, 23, 23, 23,  1, 23, 23, 23,      2, 23, 23, 23, 23, 23, 23, 23,
      3, 23, 23, 23, 23,  4, 23, 23,     23, 23, 23, 23,  5,  6,  7,  8,
      9, 23, 23, 10, 11, 23, 12, 13,     23, 23, 23, 23, 14, 15, 23, 16,
     17, 18, 23, 23, 23, 23, 19, 23,     20, 21, 23, 23, 22, 23, 23, 23,
};

static const struct byte_lookup* const
to_EUC_KR_EC_04_infos[24] = {
          o2(0xBC,0xA8),      o2(0xBC,0xA9),
          o2(0xBC,0xAA),      o2(0xBC,0xAB),
          o2(0xBC,0xAC),      o2(0xBC,0xAD),
          o2(0xBC,0xAE),      o2(0xBC,0xAF),
          o2(0xBC,0xB0),      o2(0xBC,0xB1),
          o2(0xBC,0xB2),      o2(0xBC,0xB3),
          o2(0xBC,0xB4),      o2(0xBC,0xB5),
          o2(0xBC,0xB6),      o2(0xBC,0xB7),
          o2(0xBC,0xB8),      o2(0xBC,0xB9),
          o2(0xBC,0xBA),      o2(0xBC,0xBB),
          o2(0xBC,0xBC),      o2(0xBC,0xBD),
          o2(0xBC,0xBE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_04 = {
    to_EUC_KR_EC_04_offsets,
    to_EUC_KR_EC_04_infos
};

static const unsigned char
to_EUC_KR_EC_05_offsets[64] = {
      0, 18, 18, 18, 18, 18, 18, 18,      1,  2, 18,  3,  4,  5, 18, 18,
     18, 18, 18, 18,  6,  7, 18, 18,      8, 18, 18, 18,  9, 18, 18, 18,
     18, 18, 18, 18, 10, 11, 18, 12,     13, 14, 18, 18, 18, 18, 18, 18,
     15, 18, 18, 18, 16, 18, 18, 18,     17, 18, 18, 18, 18, 18, 18, 18,
};

static const struct byte_lookup* const
to_EUC_KR_EC_05_infos[19] = {
          o2(0xBC,0xBF),      o2(0xBC,0xC0),
          o2(0xBC,0xC1),      o2(0xBC,0xC2),
          o2(0xBC,0xC3),      o2(0xBC,0xC4),
          o2(0xBC,0xC5),      o2(0xBC,0xC6),
          o2(0xBC,0xC7),      o2(0xBC,0xC8),
          o2(0xBC,0xC9),      o2(0xBC,0xCA),
          o2(0xBC,0xCB),      o2(0xBC,0xCC),
          o2(0xBC,0xCD),      o2(0xBC,0xCE),
          o2(0xBC,0xCF),      o2(0xBC,0xD0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_05 = {
    to_EUC_KR_EC_05_offsets,
    to_EUC_KR_EC_05_infos
};

static const unsigned char
to_EUC_KR_EC_06_offsets[64] = {
     17, 17, 17, 17, 17,  0, 17, 17,     17, 17, 17, 17,  1,  2,  3, 17,
      4, 17, 17, 17,  5, 17,  6, 17,     17, 17, 17, 17,  7,  8, 17,  9,
     17, 10, 17, 17, 17, 11, 17, 17,     12, 13, 17, 17, 14, 17, 17, 17,
     15, 17, 17, 17, 17, 17, 17, 17,     17, 17, 17, 17, 17, 16, 17, 17,
};

static const struct byte_lookup* const
to_EUC_KR_EC_06_infos[18] = {
          o2(0xBC,0xD1),      o2(0xBC,0xD2),
          o2(0xBC,0xD3),      o2(0xBC,0xD4),
          o2(0xBC,0xD5),      o2(0xBC,0xD6),
          o2(0xBC,0xD7),      o2(0xBC,0xD8),
          o2(0xBC,0xD9),      o2(0xBC,0xDA),
          o2(0xBC,0xDB),      o2(0xBC,0xDC),
          o2(0xBC,0xDD),      o2(0xBC,0xDE),
          o2(0xBC,0xDF),      o2(0xBC,0xE0),
          o2(0xBC,0xE1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_06 = {
    to_EUC_KR_EC_06_offsets,
    to_EUC_KR_EC_06_infos
};

static const unsigned char
to_EUC_KR_EC_07_offsets[64] = {
     14, 14, 14, 14,  0, 14, 14, 14,      1, 14, 14, 14,  2, 14, 14, 14,
     14, 14, 14, 14,  3, 14, 14,  4,      5, 14, 14, 14, 14, 14, 14, 14,
      6, 14, 14, 14,  7, 14, 14, 14,      8, 14, 14, 14, 14, 14, 14, 14,
      9, 10, 14, 11, 14, 14, 14, 14,     14, 14, 14, 14, 12, 13, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_EC_07_infos[15] = {
          o2(0xBC,0xE2),      o2(0xBC,0xE3),
          o2(0xBC,0xE4),      o2(0xBC,0xE5),
          o2(0xBC,0xE6),      o2(0xBC,0xE7),
          o2(0xBC,0xE8),      o2(0xBC,0xE9),
          o2(0xBC,0xEA),      o2(0xBC,0xEB),
          o2(0xBC,0xEC),      o2(0xBC,0xED),
          o2(0xBC,0xEE),      o2(0xBC,0xEF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_07 = {
    to_EUC_KR_EC_07_offsets,
    to_EUC_KR_EC_07_infos
};

static const unsigned char
to_EUC_KR_EC_08_offsets[64] = {
      0, 19, 19, 19,  1, 19, 19, 19,     19, 19, 19, 19,  2,  3, 19,  4,
     19,  5, 19, 19, 19, 19, 19, 19,      6,  7, 19, 19,  8, 19, 19,  9,
     10, 19, 19, 19, 19, 19, 19, 19,     11, 12, 19, 13, 19, 14, 19, 15,
     19, 16, 17, 19, 18, 19, 19, 19,     19, 19, 19, 19, 19, 19, 19, 19,
};

static const struct byte_lookup* const
to_EUC_KR_EC_08_infos[20] = {
          o2(0xBC,0xF0),      o2(0xBC,0xF1),
          o2(0xBC,0xF2),      o2(0xBC,0xF3),
          o2(0xBC,0xF4),      o2(0xBC,0xF5),
          o2(0xBC,0xF6),      o2(0xBC,0xF7),
          o2(0xBC,0xF8),      o2(0xBC,0xF9),
          o2(0xBC,0xFA),      o2(0xBC,0xFB),
          o2(0xBC,0xFC),      o2(0xBC,0xFD),
          o2(0xBC,0xFE),      o2(0xBD,0xA1),
          o2(0xBD,0xA2),      o2(0xBD,0xA3),
          o2(0xBD,0xA4),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_08 = {
    to_EUC_KR_EC_08_offsets,
    to_EUC_KR_EC_08_infos
};

static const unsigned char
to_EUC_KR_EC_09_offsets[64] = {
     14, 14, 14, 14, 14, 14, 14, 14,      0, 14, 14, 14, 14, 14, 14, 14,
      1,  2, 14, 14,  3, 14, 14, 14,      4, 14, 14, 14, 14, 14, 14, 14,
      5, 14, 14, 14, 14,  6, 14, 14,     14, 14, 14, 14,  7,  8, 14, 14,
      9, 14, 14, 14, 10, 14, 14, 14,     14, 14, 14, 14, 11, 12, 14, 13,
};

static const struct byte_lookup* const
to_EUC_KR_EC_09_infos[15] = {
          o2(0xBD,0xA5),      o2(0xBD,0xA6),
          o2(0xBD,0xA7),      o2(0xBD,0xA8),
          o2(0xBD,0xA9),      o2(0xBD,0xAA),
          o2(0xBD,0xAB),      o2(0xBD,0xAC),
          o2(0xBD,0xAD),      o2(0xBD,0xAE),
          o2(0xBD,0xAF),      o2(0xBD,0xB0),
          o2(0xBD,0xB1),      o2(0xBD,0xB2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_09 = {
    to_EUC_KR_EC_09_offsets,
    to_EUC_KR_EC_09_infos
};

static const unsigned char
to_EUC_KR_EC_0A_offsets[64] = {
     16,  0, 16, 16, 16, 16, 16, 16,      1,  2, 16, 16, 16, 16, 16, 16,
      3, 16, 16, 16, 16, 16, 16, 16,      4, 16, 16,  5, 16,  6, 16, 16,
     16, 16, 16, 16,  7,  8, 16, 16,      9, 16, 16, 16, 10, 11, 16, 16,
     16, 16, 16, 16, 12, 13, 16, 14,     16, 15, 16, 16, 16, 16, 16, 16,
};

static const struct byte_lookup* const
to_EUC_KR_EC_0A_infos[17] = {
          o2(0xBD,0xB3),      o2(0xBD,0xB4),
          o2(0xBD,0xB5),      o2(0xBD,0xB6),
          o2(0xBD,0xB7),      o2(0xBD,0xB8),
          o2(0xBD,0xB9),      o2(0xBD,0xBA),
          o2(0xBD,0xBB),      o2(0xBD,0xBC),
          o2(0xBD,0xBD),      o2(0xBD,0xBE),
          o2(0xBD,0xBF),      o2(0xBD,0xC0),
          o2(0xBD,0xC1),      o2(0xBD,0xC2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_0A = {
    to_EUC_KR_EC_0A_offsets,
    to_EUC_KR_EC_0A_infos
};

static const unsigned char
to_EUC_KR_EC_0B_offsets[64] = {
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15,  0,  1, 15, 15,
      2, 15, 15,  3,  4, 15, 15, 15,     15, 15, 15,  5,  6,  7, 15,  8,
     15,  9, 15, 15, 15, 15, 10, 15,     11, 12, 15, 13, 14, 15, 15, 15,
};

static const struct byte_lookup* const
to_EUC_KR_EC_0B_infos[16] = {
          o2(0xBD,0xC3),      o2(0xBD,0xC4),
          o2(0xBD,0xC5),      o2(0xBD,0xC6),
          o2(0xBD,0xC7),      o2(0xBD,0xC8),
          o2(0xBD,0xC9),      o2(0xBD,0xCA),
          o2(0xBD,0xCB),      o2(0xBD,0xCC),
          o2(0xBD,0xCD),      o2(0xBD,0xCE),
          o2(0xBD,0xCF),      o2(0xBD,0xD0),
          o2(0xBD,0xD1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_0B = {
    to_EUC_KR_EC_0B_offsets,
    to_EUC_KR_EC_0B_infos
};

static const unsigned char
to_EUC_KR_EC_0C_offsets[64] = {
      0, 14, 14, 14, 14, 14, 14, 14,      1,  2, 14, 14,  3,  4, 14, 14,
     14, 14, 14,  5,  6,  7, 14, 14,      8, 14, 14, 14,  9, 14, 14, 14,
     14, 14, 14, 14, 10, 11, 14, 14,     12, 13, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,     14, 14, 14, 14, 14, 14, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_EC_0C_infos[15] = {
          o2(0xBD,0xD2),      o2(0xBD,0xD3),
          o2(0xBD,0xD4),      o2(0xBD,0xD5),
          o2(0xBD,0xD6),      o2(0xBD,0xD7),
          o2(0xBD,0xD8),      o2(0xBD,0xD9),
          o2(0xBD,0xDA),      o2(0xBD,0xDB),
          o2(0xBD,0xDC),      o2(0xBD,0xDD),
          o2(0xBD,0xDE),      o2(0xBD,0xDF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_0C = {
    to_EUC_KR_EC_0C_offsets,
    to_EUC_KR_EC_0C_infos
};

static const unsigned char
to_EUC_KR_EC_0D_offsets[64] = {
     10, 10, 10, 10, 10,  0, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,      1,  2, 10, 10,  3, 10, 10, 10,
      4, 10,  5, 10, 10, 10, 10, 10,      6,  7, 10, 10,  8,  9, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_EC_0D_infos[11] = {
          o2(0xBD,0xE0),      o2(0xBD,0xE1),
          o2(0xBD,0xE2),      o2(0xBD,0xE3),
          o2(0xBD,0xE4),      o2(0xBD,0xE5),
          o2(0xBD,0xE6),      o2(0xBD,0xE7),
          o2(0xBD,0xE8),      o2(0xBD,0xE9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_0D = {
    to_EUC_KR_EC_0D_offsets,
    to_EUC_KR_EC_0D_infos
};

static const unsigned char
to_EUC_KR_EC_0E_offsets[64] = {
      3,  3,  3,  3,  0,  3,  3,  3,      1,  3,  3,  3,  2,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,      3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,      3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,      3,  3,  3,  3,  3,  3,  3,  3,
};

static const struct byte_lookup* const
to_EUC_KR_EC_0E_infos[4] = {
          o2(0xBD,0xEA),      o2(0xBD,0xEB),
          o2(0xBD,0xEC),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_0E = {
    to_EUC_KR_EC_0E_offsets,
    to_EUC_KR_EC_0E_infos
};

static const unsigned char
to_EUC_KR_EC_0F_offsets[64] = {
      0, 13, 13, 13, 13, 13, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,      1,  2, 13, 13,  3, 13, 13,  4,
      5, 13,  6, 13, 13, 13, 13, 13,      7,  8, 13, 13, 13,  9, 13, 13,
     13, 13, 13, 13, 10, 11, 13, 13,     12, 13, 13, 13, 13, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_EC_0F_infos[14] = {
          o2(0xBD,0xED),      o2(0xBD,0xEE),
          o2(0xBD,0xEF),      o2(0xBD,0xF0),
          o2(0xBD,0xF1),      o2(0xBD,0xF2),
          o2(0xBD,0xF3),      o2(0xBD,0xF4),
          o2(0xBD,0xF5),      o2(0xBD,0xF6),
          o2(0xBD,0xF7),      o2(0xBD,0xF8),
          o2(0xBD,0xF9),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_0F = {
    to_EUC_KR_EC_0F_offsets,
    to_EUC_KR_EC_0F_infos
};

static const unsigned char
to_EUC_KR_EC_10_offsets[64] = {
      8,  8,  8,  8,  8,  8,  8,  8,      0,  8,  8,  8,  8,  8,  8,  8,
      1,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  2,  8,  8,  8,      8,  8,  8,  8,  3,  8,  8,  8,
      4,  8,  8,  8,  5,  8,  8,  8,      8,  8,  8,  8,  6,  7,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_EC_10_infos[9] = {
          o2(0xBD,0xFA),      o2(0xBD,0xFB),
          o2(0xBD,0xFC),      o2(0xBD,0xFD),
          o2(0xBD,0xFE),      o2(0xBE,0xA1),
          o2(0xBE,0xA2),      o2(0xBE,0xA3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_10 = {
    to_EUC_KR_EC_10_offsets,
    to_EUC_KR_EC_10_infos
};

static const unsigned char
to_EUC_KR_EC_11_offsets[64] = {
      8,  8,  8,  8,  8,  8,  8,  8,      0,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  1,  2,  8,  8,      3,  8,  8,  8,  4,  8,  8,  8,
      8,  8,  8,  8,  5,  6,  8,  8,      8,  7,  8,  8,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_EC_11_infos[9] = {
          o2(0xBE,0xA4),      o2(0xBE,0xA5),
          o2(0xBE,0xA6),      o2(0xBE,0xA7),
          o2(0xBE,0xA8),      o2(0xBE,0xA9),
          o2(0xBE,0xAA),      o2(0xBE,0xAB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_11 = {
    to_EUC_KR_EC_11_offsets,
    to_EUC_KR_EC_11_infos
};

static const unsigned char
to_EUC_KR_EC_12_offsets[64] = {
      0,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  1,  5,  5,  5,      5,  5,  5,  5,  2,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,      3,  5,  5,  5,  4,  5,  5,  5,
};

static const struct byte_lookup* const
to_EUC_KR_EC_12_infos[6] = {
          o2(0xBE,0xAC),      o2(0xBE,0xAD),
          o2(0xBE,0xAE),      o2(0xBE,0xAF),
          o2(0xBE,0xB0),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_12 = {
    to_EUC_KR_EC_12_offsets,
    to_EUC_KR_EC_12_infos
};

static const unsigned char
to_EUC_KR_EC_13_offsets[64] = {
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  0,  7,  7,  7,  7,  7,  7,
      1,  2,  7,  7,  3,  7,  7,  7,      4,  7,  5,  7,  7,  7,  7,  6,
};

static const struct byte_lookup* const
to_EUC_KR_EC_13_infos[8] = {
          o2(0xBE,0xB1),      o2(0xBE,0xB2),
          o2(0xBE,0xB3),      o2(0xBE,0xB4),
          o2(0xBE,0xB5),      o2(0xBE,0xB6),
          o2(0xBE,0xB7),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_13 = {
    to_EUC_KR_EC_13_offsets,
    to_EUC_KR_EC_13_infos
};

static const unsigned char
to_EUC_KR_EC_14_offsets[64] = {
      0,  1, 14, 14, 14, 14, 14, 14,     14, 14, 14, 14,  2, 14, 14, 14,
      3, 14, 14, 14,  4, 14, 14, 14,     14, 14, 14, 14,  5, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,      6,  7, 14, 14,  8, 14, 14, 14,
      9, 14, 14, 14, 14, 14, 14, 14,     10, 11, 14, 12, 14, 13, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_EC_14_infos[15] = {
          o2(0xBE,0xB8),      o2(0xBE,0xB9),
          o2(0xBE,0xBA),      o2(0xBE,0xBB),
          o2(0xBE,0xBC),      o2(0xBE,0xBD),
          o2(0xBE,0xBE),      o2(0xBE,0xBF),
          o2(0xBE,0xC0),      o2(0xBE,0xC1),
          o2(0xBE,0xC2),      o2(0xBE,0xC3),
          o2(0xBE,0xC4),      o2(0xBE,0xC5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_14 = {
    to_EUC_KR_EC_14_offsets,
    to_EUC_KR_EC_14_infos
};

static const unsigned char
to_EUC_KR_EC_15_offsets[64] = {
     27, 27, 27, 27,  0,  1, 27, 27,      2,  3,  4, 27,  5,  6,  7, 27,
     27, 27, 27,  8,  9, 10, 27, 11,     12, 13, 27, 27, 27, 14, 15, 27,
     16, 17, 27, 27, 18, 27, 27, 27,     19, 27, 27, 27, 27, 27, 27, 27,
     20, 21, 27, 22, 23, 24, 27, 27,     27, 27, 27, 27, 25, 26, 27, 27,
};

static const struct byte_lookup* const
to_EUC_KR_EC_15_infos[28] = {
          o2(0xBE,0xC6),      o2(0xBE,0xC7),
          o2(0xBE,0xC8),      o2(0xBE,0xC9),
          o2(0xBE,0xCA),      o2(0xBE,0xCB),
          o2(0xBE,0xCC),      o2(0xBE,0xCD),
          o2(0xBE,0xCE),      o2(0xBE,0xCF),
          o2(0xBE,0xD0),      o2(0xBE,0xD1),
          o2(0xBE,0xD2),      o2(0xBE,0xD3),
          o2(0xBE,0xD4),      o2(0xBE,0xD5),
          o2(0xBE,0xD6),      o2(0xBE,0xD7),
          o2(0xBE,0xD8),      o2(0xBE,0xD9),
          o2(0xBE,0xDA),      o2(0xBE,0xDB),
          o2(0xBE,0xDC),      o2(0xBE,0xDD),
          o2(0xBE,0xDE),      o2(0xBE,0xDF),
          o2(0xBE,0xE0),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_15 = {
    to_EUC_KR_EC_15_offsets,
    to_EUC_KR_EC_15_infos
};

static const unsigned char
to_EUC_KR_EC_16_offsets[64] = {
      0, 21, 21, 21,  1, 21, 21,  2,     21, 21, 21, 21,  3,  4, 21,  5,
     21,  6, 21, 21, 21,  7, 21,  8,      9, 21, 21, 21, 10, 21, 21, 21,
     11, 21, 21, 21, 21, 21, 21, 21,     21, 12, 21, 21, 21, 21, 21, 21,
     21, 21, 21, 21, 13, 14, 21, 21,     15, 16, 21, 17, 18, 19, 20, 21,
};

static const struct byte_lookup* const
to_EUC_KR_EC_16_infos[22] = {
          o2(0xBE,0xE1),      o2(0xBE,0xE2),
          o2(0xBE,0xE3),      o2(0xBE,0xE4),
          o2(0xBE,0xE5),      o2(0xBE,0xE6),
          o2(0xBE,0xE7),      o2(0xBE,0xE8),
          o2(0xBE,0xE9),      o2(0xBE,0xEA),
          o2(0xBE,0xEB),      o2(0xBE,0xEC),
          o2(0xBE,0xED),      o2(0xBE,0xEE),
          o2(0xBE,0xEF),      o2(0xBE,0xF0),
          o2(0xBE,0xF1),      o2(0xBE,0xF2),
          o2(0xBE,0xF3),      o2(0xBE,0xF4),
          o2(0xBE,0xF5),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_16 = {
    to_EUC_KR_EC_16_offsets,
    to_EUC_KR_EC_16_infos
};

static const unsigned char
to_EUC_KR_EC_17_offsets[64] = {
     28, 28, 28, 28,  0,  1,  2,  3,      4,  5,  6, 28,  7, 28,  8, 28,
      9, 10, 28, 28, 11, 28, 28, 28,     12, 28, 28, 28, 28, 28, 28, 28,
     13, 14, 28, 15, 28, 16, 28, 28,     28, 28, 28, 28, 17, 18, 19, 28,
     20, 28, 28, 28, 21, 28, 22, 23,     28, 28, 28, 28, 24, 25, 26, 27,
};

static const struct byte_lookup* const
to_EUC_KR_EC_17_infos[29] = {
          o2(0xBE,0xF6),      o2(0xBE,0xF7),
          o2(0xBE,0xF8),      o2(0xBE,0xF9),
          o2(0xBE,0xFA),      o2(0xBE,0xFB),
          o2(0xBE,0xFC),      o2(0xBE,0xFD),
          o2(0xBE,0xFE),      o2(0xBF,0xA1),
          o2(0xBF,0xA2),      o2(0xBF,0xA3),
          o2(0xBF,0xA4),      o2(0xBF,0xA5),
          o2(0xBF,0xA6),      o2(0xBF,0xA7),
          o2(0xBF,0xA8),      o2(0xBF,0xA9),
          o2(0xBF,0xAA),      o2(0xBF,0xAB),
          o2(0xBF,0xAC),      o2(0xBF,0xAD),
          o2(0xBF,0xAE),      o2(0xBF,0xAF),
          o2(0xBF,0xB0),      o2(0xBF,0xB1),
          o2(0xBF,0xB2),      o2(0xBF,0xB3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_17 = {
    to_EUC_KR_EC_17_offsets,
    to_EUC_KR_EC_17_infos
};

static const unsigned char
to_EUC_KR_EC_18_offsets[64] = {
      0,  1, 25, 25, 25,  2,  3,  4,      5, 25, 25, 25,  6, 25, 25, 25,
      7, 25, 25, 25, 25, 25, 25, 25,      8,  9, 25, 10, 11, 25, 25, 25,
     25, 25, 25, 25, 12, 13, 25, 25,     14, 25, 25, 25, 15, 16, 17, 25,
     18, 25, 25, 19, 20, 21, 25, 22,     25, 23, 25, 24, 25, 25, 25, 25,
};

static const struct byte_lookup* const
to_EUC_KR_EC_18_infos[26] = {
          o2(0xBF,0xB4),      o2(0xBF,0xB5),
          o2(0xBF,0xB6),      o2(0xBF,0xB7),
          o2(0xBF,0xB8),      o2(0xBF,0xB9),
          o2(0xBF,0xBA),      o2(0xBF,0xBB),
          o2(0xBF,0xBC),      o2(0xBF,0xBD),
          o2(0xBF,0xBE),      o2(0xBF,0xBF),
          o2(0xBF,0xC0),      o2(0xBF,0xC1),
          o2(0xBF,0xC2),      o2(0xBF,0xC3),
          o2(0xBF,0xC4),      o2(0xBF,0xC5),
          o2(0xBF,0xC6),      o2(0xBF,0xC7),
          o2(0xBF,0xC8),      o2(0xBF,0xC9),
          o2(0xBF,0xCA),      o2(0xBF,0xCB),
          o2(0xBF,0xCC),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_18 = {
    to_EUC_KR_EC_18_offsets,
    to_EUC_KR_EC_18_infos
};

static const unsigned char
to_EUC_KR_EC_19_offsets[64] = {
      0,  1, 18, 18,  2, 18, 18, 18,      3, 18, 18, 18, 18, 18, 18, 18,
      4,  5, 18,  6,  7,  8, 18, 18,     18, 18, 18, 18,  9, 10, 18, 18,
     11, 18, 18, 18, 18, 18, 18, 18,     18, 18, 18, 18, 12, 18, 18, 13,
     18, 14, 18, 18, 18, 18, 18, 18,     15, 16, 18, 18, 17, 18, 18, 18,
};

static const struct byte_lookup* const
to_EUC_KR_EC_19_infos[19] = {
          o2(0xBF,0xCD),      o2(0xBF,0xCE),
          o2(0xBF,0xCF),      o2(0xBF,0xD0),
          o2(0xBF,0xD1),      o2(0xBF,0xD2),
          o2(0xBF,0xD3),      o2(0xBF,0xD4),
          o2(0xBF,0xD5),      o2(0xBF,0xD6),
          o2(0xBF,0xD7),      o2(0xBF,0xD8),
          o2(0xBF,0xD9),      o2(0xBF,0xDA),
          o2(0xBF,0xDB),      o2(0xBF,0xDC),
          o2(0xBF,0xDD),      o2(0xBF,0xDE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_19 = {
    to_EUC_KR_EC_19_offsets,
    to_EUC_KR_EC_19_infos
};

static const unsigned char
to_EUC_KR_EC_1A_offsets[64] = {
      0, 19, 19, 19, 19, 19, 19, 19,      1,  2, 19,  3, 19,  4, 19, 19,
     19, 19, 19, 19,  5,  6, 19, 19,      7, 19, 19, 19,  8, 19, 19, 19,
     19, 19, 19, 19,  9, 10, 19, 11,     19, 12, 19, 19, 19, 19, 19, 19,
     13, 14, 19, 19, 15, 19, 19, 19,     16, 17, 18, 19, 19, 19, 19, 19,
};

static const struct byte_lookup* const
to_EUC_KR_EC_1A_infos[20] = {
          o2(0xBF,0xDF),      o2(0xBF,0xE0),
          o2(0xBF,0xE1),      o2(0xBF,0xE2),
          o2(0xBF,0xE3),      o2(0xBF,0xE4),
          o2(0xBF,0xE5),      o2(0xBF,0xE6),
          o2(0xBF,0xE7),      o2(0xBF,0xE8),
          o2(0xBF,0xE9),      o2(0xBF,0xEA),
          o2(0xBF,0xEB),      o2(0xBF,0xEC),
          o2(0xBF,0xED),      o2(0xBF,0xEE),
          o2(0xBF,0xEF),      o2(0xBF,0xF0),
          o2(0xBF,0xF1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_1A = {
    to_EUC_KR_EC_1A_offsets,
    to_EUC_KR_EC_1A_infos
};

static const unsigned char
to_EUC_KR_EC_1B_offsets[64] = {
      0,  1, 19,  2, 19,  3, 19, 19,     19, 19, 19, 19,  4,  5, 19, 19,
      6, 19, 19, 19,  7, 19, 19, 19,     19, 19, 19, 19,  8,  9, 19, 19,
     10, 11, 19, 19, 19, 19, 19, 19,     12, 13, 19, 19, 14, 19, 19, 19,
     15, 19, 19, 19, 19, 19, 19, 19,     16, 17, 19, 19, 19, 18, 19, 19,
};

static const struct byte_lookup* const
to_EUC_KR_EC_1B_infos[20] = {
          o2(0xBF,0xF2),      o2(0xBF,0xF3),
          o2(0xBF,0xF4),      o2(0xBF,0xF5),
          o2(0xBF,0xF6),      o2(0xBF,0xF7),
          o2(0xBF,0xF8),      o2(0xBF,0xF9),
          o2(0xBF,0xFA),      o2(0xBF,0xFB),
          o2(0xBF,0xFC),      o2(0xBF,0xFD),
          o2(0xBF,0xFE),      o2(0xC0,0xA1),
          o2(0xC0,0xA2),      o2(0xC0,0xA3),
          o2(0xC0,0xA4),      o2(0xC0,0xA5),
          o2(0xC0,0xA6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_1B = {
    to_EUC_KR_EC_1B_offsets,
    to_EUC_KR_EC_1B_infos
};

static const unsigned char
to_EUC_KR_EC_1C_offsets[64] = {
     19, 19, 19, 19,  0,  1, 19, 19,      2, 19, 19, 19,  3, 19, 19, 19,
     19, 19, 19, 19,  4,  5, 19,  6,     19,  7, 19, 19, 19, 19, 19, 19,
      8,  9, 19, 19, 10, 19, 19, 19,     11, 19, 19, 19, 19, 19, 19, 19,
     12, 13, 19, 14, 19, 15, 19, 16,     19, 19, 19, 19, 17, 18, 19, 19,
};

static const struct byte_lookup* const
to_EUC_KR_EC_1C_infos[20] = {
          o2(0xC0,0xA7),      o2(0xC0,0xA8),
          o2(0xC0,0xA9),      o2(0xC0,0xAA),
          o2(0xC0,0xAB),      o2(0xC0,0xAC),
          o2(0xC0,0xAD),      o2(0xC0,0xAE),
          o2(0xC0,0xAF),      o2(0xC0,0xB0),
          o2(0xC0,0xB1),      o2(0xC0,0xB2),
          o2(0xC0,0xB3),      o2(0xC0,0xB4),
          o2(0xC0,0xB5),      o2(0xC0,0xB6),
          o2(0xC0,0xB7),      o2(0xC0,0xB8),
          o2(0xC0,0xB9),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_1C = {
    to_EUC_KR_EC_1C_offsets,
    to_EUC_KR_EC_1C_infos
};

static const unsigned char
to_EUC_KR_EC_1D_offsets[64] = {
      0, 24, 24, 24,  1, 24, 24, 24,     24, 24,  2, 24,  3,  4, 24,  5,
     24,  6,  7,  8,  9, 10, 11, 12,     13, 24, 24, 24, 14, 24, 24, 24,
     15, 24, 24, 24, 24, 24, 24, 24,     16, 24, 24, 17, 24, 24, 24, 24,
     24, 24, 24, 24, 18, 19, 24, 24,     20, 24, 24, 24, 21, 22, 23, 24,
};

static const struct byte_lookup* const
to_EUC_KR_EC_1D_infos[25] = {
          o2(0xC0,0xBA),      o2(0xC0,0xBB),
          o2(0xC0,0xBC),      o2(0xC0,0xBD),
          o2(0xC0,0xBE),      o2(0xC0,0xBF),
          o2(0xC0,0xC0),      o2(0xC0,0xC1),
          o2(0xC0,0xC2),      o2(0xC0,0xC3),
          o2(0xC0,0xC4),      o2(0xC0,0xC5),
          o2(0xC0,0xC6),      o2(0xC0,0xC7),
          o2(0xC0,0xC8),      o2(0xC0,0xC9),
          o2(0xC0,0xCA),      o2(0xC0,0xCB),
          o2(0xC0,0xCC),      o2(0xC0,0xCD),
          o2(0xC0,0xCE),      o2(0xC0,0xCF),
          o2(0xC0,0xD0),      o2(0xC0,0xD1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_1D = {
    to_EUC_KR_EC_1D_offsets,
    to_EUC_KR_EC_1D_infos
};

static const unsigned char
to_EUC_KR_EC_1E_offsets[64] = {
     28, 28, 28,  0,  1,  2, 28,  3,      4,  5,  6, 28, 28, 28,  7, 28,
      8,  9, 28, 28, 10, 28, 11, 12,     13, 28, 14, 28, 28, 28, 28, 28,
     15, 16, 28, 17, 18, 19, 20, 28,     28, 28, 28, 28, 21, 22, 28, 28,
     23, 28, 28, 28, 24, 28, 28, 28,     28, 28, 28, 28, 25, 26, 28, 27,
};

static const struct byte_lookup* const
to_EUC_KR_EC_1E_infos[29] = {
          o2(0xC0,0xD2),      o2(0xC0,0xD3),
          o2(0xC0,0xD4),      o2(0xC0,0xD5),
          o2(0xC0,0xD6),      o2(0xC0,0xD7),
          o2(0xC0,0xD8),      o2(0xC0,0xD9),
          o2(0xC0,0xDA),      o2(0xC0,0xDB),
          o2(0xC0,0xDC),      o2(0xC0,0xDD),
          o2(0xC0,0xDE),      o2(0xC0,0xDF),
          o2(0xC0,0xE0),      o2(0xC0,0xE1),
          o2(0xC0,0xE2),      o2(0xC0,0xE3),
          o2(0xC0,0xE4),      o2(0xC0,0xE5),
          o2(0xC0,0xE6),      o2(0xC0,0xE7),
          o2(0xC0,0xE8),      o2(0xC0,0xE9),
          o2(0xC0,0xEA),      o2(0xC0,0xEB),
          o2(0xC0,0xEC),      o2(0xC0,0xED),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_1E = {
    to_EUC_KR_EC_1E_offsets,
    to_EUC_KR_EC_1E_infos
};

static const unsigned char
to_EUC_KR_EC_1F_offsets[64] = {
      0,  1, 12, 12, 12, 12, 12, 12,      2,  3, 12, 12,  4, 12,  5, 12,
      6, 12, 12, 12, 12, 12, 12, 12,      7, 12, 12, 12, 12,  8, 12, 12,
     12, 12, 12, 12,  9, 12, 12, 12,     10, 12, 12, 12, 11, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_EC_1F_infos[13] = {
          o2(0xC0,0xEE),      o2(0xC0,0xEF),
          o2(0xC0,0xF0),      o2(0xC0,0xF1),
          o2(0xC0,0xF2),      o2(0xC0,0xF3),
          o2(0xC0,0xF4),      o2(0xC0,0xF5),
          o2(0xC0,0xF6),      o2(0xC0,0xF7),
          o2(0xC0,0xF8),      o2(0xC0,0xF9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_1F = {
    to_EUC_KR_EC_1F_offsets,
    to_EUC_KR_EC_1F_infos
};

static const unsigned char
to_EUC_KR_EC_20_offsets[64] = {
      0,  1, 20, 20,  2, 20, 20, 20,      3, 20,  4, 20, 20, 20, 20, 20,
      5,  6, 20,  7, 20,  8,  9, 20,     20, 20, 20, 20, 10, 11, 20, 20,
     12, 20, 20, 20, 13, 20, 20, 20,     20, 20, 20, 20, 14, 15, 20, 16,
     20, 17, 20, 20, 20, 20, 20, 20,     18, 20, 20, 20, 19, 20, 20, 20,
};

static const struct byte_lookup* const
to_EUC_KR_EC_20_infos[21] = {
          o2(0xC0,0xFA),      o2(0xC0,0xFB),
          o2(0xC0,0xFC),      o2(0xC0,0xFD),
          o2(0xC0,0xFE),      o2(0xC1,0xA1),
          o2(0xC1,0xA2),      o2(0xC1,0xA3),
          o2(0xC1,0xA4),      o2(0xC1,0xA5),
          o2(0xC1,0xA6),      o2(0xC1,0xA7),
          o2(0xC1,0xA8),      o2(0xC1,0xA9),
          o2(0xC1,0xAA),      o2(0xC1,0xAB),
          o2(0xC1,0xAC),      o2(0xC1,0xAD),
          o2(0xC1,0xAE),      o2(0xC1,0xAF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_20 = {
    to_EUC_KR_EC_20_offsets,
    to_EUC_KR_EC_20_infos
};

static const unsigned char
to_EUC_KR_EC_21_offsets[64] = {
      0, 11, 11, 11, 11, 11, 11, 11,      1,  2, 11, 11,  3,  4, 11, 11,
     11, 11, 11, 11,  5, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
      6,  7, 11, 11,  8, 11, 11, 11,      9, 11, 10, 11, 11, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_EC_21_infos[12] = {
          o2(0xC1,0xB0),      o2(0xC1,0xB1),
          o2(0xC1,0xB2),      o2(0xC1,0xB3),
          o2(0xC1,0xB4),      o2(0xC1,0xB5),
          o2(0xC1,0xB6),      o2(0xC1,0xB7),
          o2(0xC1,0xB8),      o2(0xC1,0xB9),
          o2(0xC1,0xBA),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_21 = {
    to_EUC_KR_EC_21_offsets,
    to_EUC_KR_EC_21_infos
};

static const unsigned char
to_EUC_KR_EC_22_offsets[64] = {
      0,  1, 16,  2, 16,  3,  4,  5,     16, 16, 16,  6,  7,  8, 16, 16,
     16, 16, 16, 16,  9, 16, 16, 16,     16, 16, 16, 16, 16, 10, 16, 11,
     16, 12, 16, 16, 16, 16, 16, 16,     13, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,     16, 16, 16, 16, 14, 15, 16, 16,
};

static const struct byte_lookup* const
to_EUC_KR_EC_22_infos[17] = {
          o2(0xC1,0xBB),      o2(0xC1,0xBC),
          o2(0xC1,0xBD),      o2(0xC1,0xBE),
          o2(0xC1,0xBF),      o2(0xC1,0xC0),
          o2(0xC1,0xC1),      o2(0xC1,0xC2),
          o2(0xC1,0xC3),      o2(0xC1,0xC4),
          o2(0xC1,0xC5),      o2(0xC1,0xC6),
          o2(0xC1,0xC7),      o2(0xC1,0xC8),
          o2(0xC1,0xC9),      o2(0xC1,0xCA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_22 = {
    to_EUC_KR_EC_22_offsets,
    to_EUC_KR_EC_22_infos
};

static const unsigned char
to_EUC_KR_EC_23_offsets[64] = {
     13, 13, 13, 13,  0, 13, 13, 13,      1, 13, 13, 13,  2, 13, 13, 13,
     13, 13, 13, 13,  3,  4, 13,  5,     13,  6, 13, 13, 13, 13, 13, 13,
      7,  8, 13, 13,  9, 13, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 10, 13, 13,     13, 13, 13, 13, 11, 12, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_EC_23_infos[14] = {
          o2(0xC1,0xCB),      o2(0xC1,0xCC),
          o2(0xC1,0xCD),      o2(0xC1,0xCE),
          o2(0xC1,0xCF),      o2(0xC1,0xD0),
          o2(0xC1,0xD1),      o2(0xC1,0xD2),
          o2(0xC1,0xD3),      o2(0xC1,0xD4),
          o2(0xC1,0xD5),      o2(0xC1,0xD6),
          o2(0xC1,0xD7),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_23 = {
    to_EUC_KR_EC_23_offsets,
    to_EUC_KR_EC_23_infos
};

static const unsigned char
to_EUC_KR_EC_24_offsets[64] = {
      0, 11, 11, 11,  1,  2,  3, 11,     11, 11, 11, 11,  4,  5, 11,  6,
     11,  7, 11, 11, 11, 11, 11, 11,      8, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11,  9, 11, 11, 11,
     11, 11, 11, 11, 10, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_EC_24_infos[12] = {
          o2(0xC1,0xD8),      o2(0xC1,0xD9),
          o2(0xC1,0xDA),      o2(0xC1,0xDB),
          o2(0xC1,0xDC),      o2(0xC1,0xDD),
          o2(0xC1,0xDE),      o2(0xC1,0xDF),
          o2(0xC1,0xE0),      o2(0xC1,0xE1),
          o2(0xC1,0xE2),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_24 = {
    to_EUC_KR_EC_24_offsets,
    to_EUC_KR_EC_24_infos
};

static const unsigned char
to_EUC_KR_EC_25_offsets[64] = {
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
      0,  1, 11, 11,  2, 11, 11, 11,      3, 11, 11, 11, 11, 11, 11, 11,
      4,  5, 11,  6, 11, 11, 11, 11,     11, 11, 11, 11,  7, 11, 11, 11,
      8, 11, 11, 11,  9, 11, 11, 11,     11, 11, 11, 11, 10, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_EC_25_infos[12] = {
          o2(0xC1,0xE3),      o2(0xC1,0xE4),
          o2(0xC1,0xE5),      o2(0xC1,0xE6),
          o2(0xC1,0xE7),      o2(0xC1,0xE8),
          o2(0xC1,0xE9),      o2(0xC1,0xEA),
          o2(0xC1,0xEB),      o2(0xC1,0xEC),
          o2(0xC1,0xED),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_25 = {
    to_EUC_KR_EC_25_offsets,
    to_EUC_KR_EC_25_infos
};

static const unsigned char
to_EUC_KR_EC_26_offsets[64] = {
      8,  8,  8,  8,  8,  8,  8,  8,      0,  1,  8,  8,  2,  8,  8,  8,
      3,  8,  8,  8,  8,  8,  8,  8,      4,  5,  8,  6,  8,  7,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_EC_26_infos[9] = {
          o2(0xC1,0xEE),      o2(0xC1,0xEF),
          o2(0xC1,0xF0),      o2(0xC1,0xF1),
          o2(0xC1,0xF2),      o2(0xC1,0xF3),
          o2(0xC1,0xF4),      o2(0xC1,0xF5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_26 = {
    to_EUC_KR_EC_26_offsets,
    to_EUC_KR_EC_26_infos
};

static const unsigned char
to_EUC_KR_EC_27_offsets[64] = {
      0,  1, 27, 27,  2, 27, 27,  3,      4, 27,  5, 27, 27, 27, 27, 27,
      6,  7, 27,  8, 27,  9, 10, 27,     27, 11, 12, 27, 13, 14, 27, 27,
     15, 27, 16, 27, 17, 27, 27, 18,     27, 27, 27, 27, 19, 20, 27, 21,
     22, 23, 27, 27, 27, 27, 27, 27,     24, 25, 27, 27, 26, 27, 27, 27,
};

static const struct byte_lookup* const
to_EUC_KR_EC_27_infos[28] = {
          o2(0xC1,0xF6),      o2(0xC1,0xF7),
          o2(0xC1,0xF8),      o2(0xC1,0xF9),
          o2(0xC1,0xFA),      o2(0xC1,0xFB),
          o2(0xC1,0xFC),      o2(0xC1,0xFD),
          o2(0xC1,0xFE),      o2(0xC2,0xA1),
          o2(0xC2,0xA2),      o2(0xC2,0xA3),
          o2(0xC2,0xA4),      o2(0xC2,0xA5),
          o2(0xC2,0xA6),      o2(0xC2,0xA7),
          o2(0xC2,0xA8),      o2(0xC2,0xA9),
          o2(0xC2,0xAA),      o2(0xC2,0xAB),
          o2(0xC2,0xAC),      o2(0xC2,0xAD),
          o2(0xC2,0xAE),      o2(0xC2,0xAF),
          o2(0xC2,0xB0),      o2(0xC2,0xB1),
          o2(0xC2,0xB2),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_27 = {
    to_EUC_KR_EC_27_offsets,
    to_EUC_KR_EC_27_infos
};

static const unsigned char
to_EUC_KR_EC_28_offsets[64] = {
      0,  9,  9,  9,  9,  9,  9,  9,      1,  2,  9,  3,  4,  5,  9,  9,
      9,  9,  9,  9,  6,  9,  9,  9,      7,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  8,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
};

static const struct byte_lookup* const
to_EUC_KR_EC_28_infos[10] = {
          o2(0xC2,0xB3),      o2(0xC2,0xB4),
          o2(0xC2,0xB5),      o2(0xC2,0xB6),
          o2(0xC2,0xB7),      o2(0xC2,0xB8),
          o2(0xC2,0xB9),      o2(0xC2,0xBA),
          o2(0xC2,0xBB),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_28 = {
    to_EUC_KR_EC_28_offsets,
    to_EUC_KR_EC_28_infos
};

static const unsigned char
to_EUC_KR_EC_29_offsets[64] = {
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11,  0,  1, 11, 11,
      2, 11, 11, 11,  3, 11, 11, 11,     11, 11, 11, 11,  4,  5, 11,  6,
      7,  8, 11, 11, 11, 11, 11, 11,      9, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 10, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_EC_29_infos[12] = {
          o2(0xC2,0xBC),      o2(0xC2,0xBD),
          o2(0xC2,0xBE),      o2(0xC2,0xBF),
          o2(0xC2,0xC0),      o2(0xC2,0xC1),
          o2(0xC2,0xC2),      o2(0xC2,0xC3),
          o2(0xC2,0xC4),      o2(0xC2,0xC5),
          o2(0xC2,0xC6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_29 = {
    to_EUC_KR_EC_29_offsets,
    to_EUC_KR_EC_29_infos
};

static const unsigned char
to_EUC_KR_EC_2A_offsets[64] = {
      4,  4,  4,  4,  0,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      1,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  2,  3,  4,  4,
};

static const struct byte_lookup* const
to_EUC_KR_EC_2A_infos[5] = {
          o2(0xC2,0xC7),      o2(0xC2,0xC8),
          o2(0xC2,0xC9),      o2(0xC2,0xCA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_2A = {
    to_EUC_KR_EC_2A_offsets,
    to_EUC_KR_EC_2A_infos
};

static const unsigned char
to_EUC_KR_EC_2B_offsets[64] = {
      0, 12, 12, 12,  1, 12, 12, 12,     12, 12, 12, 12,  2,  3, 12,  4,
     12,  5, 12,  6, 12, 12, 12, 12,      7,  8, 12, 12, 12, 12, 12, 12,
      9, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 10, 12, 12, 12,
     12, 12, 12, 12, 11, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_EC_2B_infos[13] = {
          o2(0xC2,0xCB),      o2(0xC2,0xCC),
          o2(0xC2,0xCD),      o2(0xC2,0xCE),
          o2(0xC2,0xCF),      o2(0xC2,0xD0),
          o2(0xC2,0xD1),      o2(0xC2,0xD2),
          o2(0xC2,0xD3),      o2(0xC2,0xD4),
          o2(0xC2,0xD5),      o2(0xC2,0xD6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_2B = {
    to_EUC_KR_EC_2B_offsets,
    to_EUC_KR_EC_2B_infos
};

static const unsigned char
to_EUC_KR_EC_2C_offsets[64] = {
      6,  6,  6,  6,  6,  6,  6,  6,      0,  6,  6,  6,  6,  6,  6,  6,
      1,  6,  6,  6,  2,  6,  6,  6,      3,  6,  6,  6,  6,  6,  6,  6,
      4,  5,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_EC_2C_infos[7] = {
          o2(0xC2,0xD7),      o2(0xC2,0xD8),
          o2(0xC2,0xD9),      o2(0xC2,0xDA),
          o2(0xC2,0xDB),      o2(0xC2,0xDC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_2C = {
    to_EUC_KR_EC_2C_offsets,
    to_EUC_KR_EC_2C_infos
};

static const unsigned char
to_EUC_KR_EC_2D_offsets[64] = {
     11,  0, 11, 11, 11, 11, 11, 11,      1,  2, 11, 11,  3, 11, 11, 11,
      4, 11, 11, 11, 11, 11, 11, 11,      5,  6, 11, 11, 11,  7, 11, 11,
     11, 11, 11, 11,  8, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,      9, 10, 11, 11, 11, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_EC_2D_infos[12] = {
          o2(0xC2,0xDD),      o2(0xC2,0xDE),
          o2(0xC2,0xDF),      o2(0xC2,0xE0),
          o2(0xC2,0xE1),      o2(0xC2,0xE2),
          o2(0xC2,0xE3),      o2(0xC2,0xE4),
          o2(0xC2,0xE5),      o2(0xC2,0xE6),
          o2(0xC2,0xE7),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_2D = {
    to_EUC_KR_EC_2D_offsets,
    to_EUC_KR_EC_2D_infos
};

static const unsigned char
to_EUC_KR_EC_2E_offsets[64] = {
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  0,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,      2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,      1,  2,  2,  2,  2,  2,  2,  2,
};

static const struct byte_lookup* const
to_EUC_KR_EC_2E_infos[3] = {
          o2(0xC2,0xE8),      o2(0xC2,0xE9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_2E = {
    to_EUC_KR_EC_2E_offsets,
    to_EUC_KR_EC_2E_infos
};

static const unsigned char
to_EUC_KR_EC_2F_offsets[64] = {
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  0,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  1,  4,  4,  2,      4,  3,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
};

static const struct byte_lookup* const
to_EUC_KR_EC_2F_infos[5] = {
          o2(0xC2,0xEA),      o2(0xC2,0xEB),
          o2(0xC2,0xEC),      o2(0xC2,0xED),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_2F = {
    to_EUC_KR_EC_2F_offsets,
    to_EUC_KR_EC_2F_infos
};

static const unsigned char
to_EUC_KR_EC_30_offsets[64] = {
     20, 20, 20, 20, 20, 20, 20, 20,     20, 20, 20, 20,  0,  1, 20, 20,
      2, 20, 20, 20,  3, 20, 20, 20,     20, 20, 20, 20,  4,  5, 20, 20,
     20,  6,  7, 20, 20, 20, 20,  8,      9, 10, 20, 20, 11, 20, 12, 20,
     13, 20, 20, 20, 20, 20, 20, 20,     14, 15, 20, 16, 17, 18, 19, 20,
};

static const struct byte_lookup* const
to_EUC_KR_EC_30_infos[21] = {
          o2(0xC2,0xEE),      o2(0xC2,0xEF),
          o2(0xC2,0xF0),      o2(0xC2,0xF1),
          o2(0xC2,0xF2),      o2(0xC2,0xF3),
          o2(0xC2,0xF4),      o2(0xC2,0xF5),
          o2(0xC2,0xF6),      o2(0xC2,0xF7),
          o2(0xC2,0xF8),      o2(0xC2,0xF9),
          o2(0xC2,0xFA),      o2(0xC2,0xFB),
          o2(0xC2,0xFC),      o2(0xC2,0xFD),
          o2(0xC2,0xFE),      o2(0xC3,0xA1),
          o2(0xC3,0xA2),      o2(0xC3,0xA3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_30 = {
    to_EUC_KR_EC_30_offsets,
    to_EUC_KR_EC_30_infos
};

static const unsigned char
to_EUC_KR_EC_31_offsets[64] = {
     15, 15, 15, 15,  0,  1, 15, 15,      2, 15, 15, 15,  3, 15, 15, 15,
     15, 15, 15, 15,  4,  5, 15,  6,      7,  8, 15, 15, 15, 15, 15, 15,
      9, 15, 15, 15, 10, 15, 11, 15,     12, 15, 15, 15, 15, 15, 15, 15,
     13, 15, 15, 15, 15, 14, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
};

static const struct byte_lookup* const
to_EUC_KR_EC_31_infos[16] = {
          o2(0xC3,0xA4),      o2(0xC3,0xA5),
          o2(0xC3,0xA6),      o2(0xC3,0xA7),
          o2(0xC3,0xA8),      o2(0xC3,0xA9),
          o2(0xC3,0xAA),      o2(0xC3,0xAB),
          o2(0xC3,0xAC),      o2(0xC3,0xAD),
          o2(0xC3,0xAE),      o2(0xC3,0xAF),
          o2(0xC3,0xB0),      o2(0xC3,0xB1),
          o2(0xC3,0xB2),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_31 = {
    to_EUC_KR_EC_31_offsets,
    to_EUC_KR_EC_31_infos
};

static const unsigned char
to_EUC_KR_EC_32_offsets[64] = {
     13, 13, 13, 13, 13, 13, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,      0,  1, 13, 13,  2, 13, 13, 13,
      3, 13, 13, 13, 13, 13, 13, 13,      4,  5, 13,  6,  7,  8, 13, 13,
     13, 13, 13, 13,  9, 10, 13, 13,     11, 13, 13, 13, 12, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_EC_32_infos[14] = {
          o2(0xC3,0xB3),      o2(0xC3,0xB4),
          o2(0xC3,0xB5),      o2(0xC3,0xB6),
          o2(0xC3,0xB7),      o2(0xC3,0xB8),
          o2(0xC3,0xB9),      o2(0xC3,0xBA),
          o2(0xC3,0xBB),      o2(0xC3,0xBC),
          o2(0xC3,0xBD),      o2(0xC3,0xBE),
          o2(0xC3,0xBF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_32 = {
    to_EUC_KR_EC_32_offsets,
    to_EUC_KR_EC_32_infos
};

static const unsigned char
to_EUC_KR_EC_33_offsets[64] = {
      9,  9,  9,  9,  0,  1,  9,  2,      9,  3,  9,  9,  9,  9,  9,  9,
      4,  9,  9,  9,  5,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  6,  9,  9,  9,      9,  9,  9,  9,  7,  9,  9,  9,
      8,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
};

static const struct byte_lookup* const
to_EUC_KR_EC_33_infos[10] = {
          o2(0xC3,0xC0),      o2(0xC3,0xC1),
          o2(0xC3,0xC2),      o2(0xC3,0xC3),
          o2(0xC3,0xC4),      o2(0xC3,0xC5),
          o2(0xC3,0xC6),      o2(0xC3,0xC7),
          o2(0xC3,0xC8),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_33 = {
    to_EUC_KR_EC_33_offsets,
    to_EUC_KR_EC_33_infos
};

static const unsigned char
to_EUC_KR_EC_34_offsets[64] = {
     13,  0, 13, 13, 13, 13, 13, 13,      1,  2, 13, 13,  3, 13, 13, 13,
      4, 13, 13, 13, 13, 13, 13, 13,      5,  6, 13,  7, 13,  8, 13, 13,
     13, 13, 13, 13,  9, 13, 13, 13,     10, 13, 13, 13, 11, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,     13, 12, 13, 13, 13, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_EC_34_infos[14] = {
          o2(0xC3,0xC9),      o2(0xC3,0xCA),
          o2(0xC3,0xCB),      o2(0xC3,0xCC),
          o2(0xC3,0xCD),      o2(0xC3,0xCE),
          o2(0xC3,0xCF),      o2(0xC3,0xD0),
          o2(0xC3,0xD1),      o2(0xC3,0xD2),
          o2(0xC3,0xD3),      o2(0xC3,0xD4),
          o2(0xC3,0xD5),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_34 = {
    to_EUC_KR_EC_34_offsets,
    to_EUC_KR_EC_34_infos
};

static const unsigned char
to_EUC_KR_EC_35_offsets[64] = {
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  0,  8,  8,  8,
      1,  8,  8,  8,  2,  8,  8,  8,      8,  8,  8,  8,  3,  4,  8,  5,
      8,  6,  8,  8,  8,  8,  8,  8,      7,  8,  8,  8,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_EC_35_infos[9] = {
          o2(0xC3,0xD6),      o2(0xC3,0xD7),
          o2(0xC3,0xD8),      o2(0xC3,0xD9),
          o2(0xC3,0xDA),      o2(0xC3,0xDB),
          o2(0xC3,0xDC),      o2(0xC3,0xDD),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_35 = {
    to_EUC_KR_EC_35_offsets,
    to_EUC_KR_EC_35_infos
};

static const unsigned char
to_EUC_KR_EC_36_offsets[64] = {
     10, 10, 10, 10, 10, 10, 10, 10,      0, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10,  1,  2, 10, 10,      3, 10, 10, 10,  4, 10, 10, 10,
     10, 10, 10, 10,  5,  6, 10,  7,     10,  8, 10, 10, 10, 10, 10, 10,
      9, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_EC_36_infos[11] = {
          o2(0xC3,0xDE),      o2(0xC3,0xDF),
          o2(0xC3,0xE0),      o2(0xC3,0xE1),
          o2(0xC3,0xE2),      o2(0xC3,0xE3),
          o2(0xC3,0xE4),      o2(0xC3,0xE5),
          o2(0xC3,0xE6),      o2(0xC3,0xE7),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_36 = {
    to_EUC_KR_EC_36_offsets,
    to_EUC_KR_EC_36_infos
};

static const unsigned char
to_EUC_KR_EC_37_offsets[64] = {
     10, 10, 10, 10,  0, 10, 10, 10,     10, 10, 10, 10,  1, 10, 10, 10,
      2, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,      3, 10, 10, 10,  4, 10, 10, 10,
      5, 10, 10, 10, 10, 10, 10, 10,      6,  7, 10,  8, 10,  9, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_EC_37_infos[11] = {
          o2(0xC3,0xE8),      o2(0xC3,0xE9),
          o2(0xC3,0xEA),      o2(0xC3,0xEB),
          o2(0xC3,0xEC),      o2(0xC3,0xED),
          o2(0xC3,0xEE),      o2(0xC3,0xEF),
          o2(0xC3,0xF0),      o2(0xC3,0xF1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_37 = {
    to_EUC_KR_EC_37_offsets,
    to_EUC_KR_EC_37_infos
};

static const unsigned char
to_EUC_KR_EC_38_offsets[64] = {
     13, 13, 13, 13,  0, 13, 13, 13,      1, 13, 13, 13,  2, 13, 13, 13,
     13, 13, 13, 13,  3, 13, 13, 13,     13,  4, 13, 13, 13, 13, 13, 13,
      5,  6, 13, 13,  7, 13, 13, 13,      8, 13, 13, 13, 13, 13, 13, 13,
      9, 10, 13, 11, 13, 12, 13, 13,     13, 13, 13, 13, 13, 13, 13, 13,
};

static const struct byte_lookup* const
to_EUC_KR_EC_38_infos[14] = {
          o2(0xC3,0xF2),      o2(0xC3,0xF3),
          o2(0xC3,0xF4),      o2(0xC3,0xF5),
          o2(0xC3,0xF6),      o2(0xC3,0xF7),
          o2(0xC3,0xF8),      o2(0xC3,0xF9),
          o2(0xC3,0xFA),      o2(0xC3,0xFB),
          o2(0xC3,0xFC),      o2(0xC3,0xFD),
          o2(0xC3,0xFE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_38 = {
    to_EUC_KR_EC_38_offsets,
    to_EUC_KR_EC_38_infos
};

static const unsigned char
to_EUC_KR_EC_39_offsets[64] = {
     14, 14, 14, 14, 14, 14, 14, 14,     14, 14, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,      0,  1, 14, 14,  2, 14, 14,  3,
      4,  5, 14, 14, 14, 14, 14, 14,      6,  7, 14,  8, 14,  9, 14, 14,
     14, 14, 14, 14, 10, 11, 14, 14,     12, 14, 14, 14, 13, 14, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_EC_39_infos[15] = {
          o2(0xC4,0xA1),      o2(0xC4,0xA2),
          o2(0xC4,0xA3),      o2(0xC4,0xA4),
          o2(0xC4,0xA5),      o2(0xC4,0xA6),
          o2(0xC4,0xA7),      o2(0xC4,0xA8),
          o2(0xC4,0xA9),      o2(0xC4,0xAA),
          o2(0xC4,0xAB),      o2(0xC4,0xAC),
          o2(0xC4,0xAD),      o2(0xC4,0xAE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_39 = {
    to_EUC_KR_EC_39_offsets,
    to_EUC_KR_EC_39_infos
};

static const unsigned char
to_EUC_KR_EC_3A_offsets[64] = {
     15, 15, 15, 15,  0,  1, 15,  2,     15,  3, 15, 15, 15, 15, 15, 15,
      4,  5, 15, 15,  6, 15, 15, 15,      7, 15, 15, 15, 15, 15, 15, 15,
      8,  9, 15, 10, 11, 12, 15, 15,     15, 15, 15, 15, 13, 14, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
};

static const struct byte_lookup* const
to_EUC_KR_EC_3A_infos[16] = {
          o2(0xC4,0xAF),      o2(0xC4,0xB0),
          o2(0xC4,0xB1),      o2(0xC4,0xB2),
          o2(0xC4,0xB3),      o2(0xC4,0xB4),
          o2(0xC4,0xB5),      o2(0xC4,0xB6),
          o2(0xC4,0xB7),      o2(0xC4,0xB8),
          o2(0xC4,0xB9),      o2(0xC4,0xBA),
          o2(0xC4,0xBB),      o2(0xC4,0xBC),
          o2(0xC4,0xBD),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_3A = {
    to_EUC_KR_EC_3A_offsets,
    to_EUC_KR_EC_3A_infos
};

static const unsigned char
to_EUC_KR_EC_3B_offsets[64] = {
     11,  0, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11,  1,  2, 11, 11,      3, 11, 11,  4,  5, 11, 11, 11,
     11, 11, 11, 11,  6,  7, 11,  8,      9, 10, 11, 11, 11, 11, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_EC_3B_infos[12] = {
          o2(0xC4,0xBE),      o2(0xC4,0xBF),
          o2(0xC4,0xC0),      o2(0xC4,0xC1),
          o2(0xC4,0xC2),      o2(0xC4,0xC3),
          o2(0xC4,0xC4),      o2(0xC4,0xC5),
          o2(0xC4,0xC6),      o2(0xC4,0xC7),
          o2(0xC4,0xC8),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_3B = {
    to_EUC_KR_EC_3B_offsets,
    to_EUC_KR_EC_3B_infos
};

static const unsigned char
to_EUC_KR_EC_3C_offsets[64] = {
      0,  1, 17, 17,  2, 17, 17, 17,      3, 17, 17, 17, 17, 17, 17, 17,
      4,  5, 17,  6, 17,  7, 17, 17,     17, 17, 17, 17,  8, 17, 17, 17,
      9, 17, 17, 17, 10, 17, 17, 17,     17, 17, 17, 17, 11, 12, 17, 13,
     14, 15, 17, 17, 17, 17, 17, 17,     16, 17, 17, 17, 17, 17, 17, 17,
};

static const struct byte_lookup* const
to_EUC_KR_EC_3C_infos[18] = {
          o2(0xC4,0xC9),      o2(0xC4,0xCA),
          o2(0xC4,0xCB),      o2(0xC4,0xCC),
          o2(0xC4,0xCD),      o2(0xC4,0xCE),
          o2(0xC4,0xCF),      o2(0xC4,0xD0),
          o2(0xC4,0xD1),      o2(0xC4,0xD2),
          o2(0xC4,0xD3),      o2(0xC4,0xD4),
          o2(0xC4,0xD5),      o2(0xC4,0xD6),
          o2(0xC4,0xD7),      o2(0xC4,0xD8),
          o2(0xC4,0xD9),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_3C = {
    to_EUC_KR_EC_3C_offsets,
    to_EUC_KR_EC_3C_infos
};

static const unsigned char
to_EUC_KR_EC_3D_offsets[64] = {
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12,  0,  1, 12, 12,      2, 12, 12, 12,  3, 12, 12, 12,
     12, 12, 12, 12,  4,  5, 12,  6,     12,  7, 12, 12, 12, 12, 12, 12,
      8,  9, 12, 12, 10, 12, 12, 12,     11, 12, 12, 12, 12, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_EC_3D_infos[13] = {
          o2(0xC4,0xDA),      o2(0xC4,0xDB),
          o2(0xC4,0xDC),      o2(0xC4,0xDD),
          o2(0xC4,0xDE),      o2(0xC4,0xDF),
          o2(0xC4,0xE0),      o2(0xC4,0xE1),
          o2(0xC4,0xE2),      o2(0xC4,0xE3),
          o2(0xC4,0xE4),      o2(0xC4,0xE5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_3D = {
    to_EUC_KR_EC_3D_offsets,
    to_EUC_KR_EC_3D_infos
};

static const unsigned char
to_EUC_KR_EC_3E_offsets[64] = {
      0,  6,  6,  6,  6,  1,  6,  6,      6,  6,  6,  6,  2,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  3,  6,  6,  6,  6,  6,  6,      4,  6,  6,  6,  6,  6,  6,  6,
      5,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_EC_3E_infos[7] = {
          o2(0xC4,0xE6),      o2(0xC4,0xE7),
          o2(0xC4,0xE8),      o2(0xC4,0xE9),
          o2(0xC4,0xEA),      o2(0xC4,0xEB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_3E = {
    to_EUC_KR_EC_3E_offsets,
    to_EUC_KR_EC_3E_infos
};

static const unsigned char
to_EUC_KR_EC_3F_offsets[64] = {
     10, 10, 10, 10,  0, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
      1,  2, 10, 10,  3, 10, 10, 10,      4, 10, 10, 10, 10, 10, 10, 10,
      5,  6, 10,  7, 10,  8, 10, 10,     10, 10, 10, 10,  9, 10, 10, 10,
};

static const struct byte_lookup* const
to_EUC_KR_EC_3F_infos[11] = {
          o2(0xC4,0xEC),      o2(0xC4,0xED),
          o2(0xC4,0xEE),      o2(0xC4,0xEF),
          o2(0xC4,0xF0),      o2(0xC4,0xF1),
          o2(0xC4,0xF2),      o2(0xC4,0xF3),
          o2(0xC4,0xF4),      o2(0xC4,0xF5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC_3F = {
    to_EUC_KR_EC_3F_offsets,
    to_EUC_KR_EC_3F_infos
};


static const struct byte_lookup* const
to_EUC_KR_EC_infos[65] = {
       &to_EUC_KR_EC_00,   &to_EUC_KR_EC_01,
       &to_EUC_KR_EC_02,   &to_EUC_KR_EC_03,
       &to_EUC_KR_EC_04,   &to_EUC_KR_EC_05,
       &to_EUC_KR_EC_06,   &to_EUC_KR_EC_07,
       &to_EUC_KR_EC_08,   &to_EUC_KR_EC_09,
       &to_EUC_KR_EC_0A,   &to_EUC_KR_EC_0B,
       &to_EUC_KR_EC_0C,   &to_EUC_KR_EC_0D,
       &to_EUC_KR_EC_0E,   &to_EUC_KR_EC_0F,
       &to_EUC_KR_EC_10,   &to_EUC_KR_EC_11,
       &to_EUC_KR_EC_12,   &to_EUC_KR_EC_13,
       &to_EUC_KR_EC_14,   &to_EUC_KR_EC_15,
       &to_EUC_KR_EC_16,   &to_EUC_KR_EC_17,
       &to_EUC_KR_EC_18,   &to_EUC_KR_EC_19,
       &to_EUC_KR_EC_1A,   &to_EUC_KR_EC_1B,
       &to_EUC_KR_EC_1C,   &to_EUC_KR_EC_1D,
       &to_EUC_KR_EC_1E,   &to_EUC_KR_EC_1F,
       &to_EUC_KR_EC_20,   &to_EUC_KR_EC_21,
       &to_EUC_KR_EC_22,   &to_EUC_KR_EC_23,
       &to_EUC_KR_EC_24,   &to_EUC_KR_EC_25,
       &to_EUC_KR_EC_26,   &to_EUC_KR_EC_27,
       &to_EUC_KR_EC_28,   &to_EUC_KR_EC_29,
       &to_EUC_KR_EC_2A,   &to_EUC_KR_EC_2B,
       &to_EUC_KR_EC_2C,   &to_EUC_KR_EC_2D,
       &to_EUC_KR_EC_2E,   &to_EUC_KR_EC_2F,
       &to_EUC_KR_EC_30,   &to_EUC_KR_EC_31,
       &to_EUC_KR_EC_32,   &to_EUC_KR_EC_33,
       &to_EUC_KR_EC_34,   &to_EUC_KR_EC_35,
       &to_EUC_KR_EC_36,   &to_EUC_KR_EC_37,
       &to_EUC_KR_EC_38,   &to_EUC_KR_EC_39,
       &to_EUC_KR_EC_3A,   &to_EUC_KR_EC_3B,
       &to_EUC_KR_EC_3C,   &to_EUC_KR_EC_3D,
       &to_EUC_KR_EC_3E,   &to_EUC_KR_EC_3F,
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EC = {
    to_EUC_KR_E3_05_offsets,
    to_EUC_KR_EC_infos
};

static const unsigned char
to_EUC_KR_ED_00_offsets[64] = {
      0,  9,  9,  9,  1,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
      9,  2,  9,  9,  9,  9,  9,  9,      3,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  4,  9,  9,
      9,  9,  9,  9,  5,  6,  9,  9,      7,  9,  9,  9,  8,  9,  9,  9,
};

static const struct byte_lookup* const
to_EUC_KR_ED_00_infos[10] = {
          o2(0xC4,0xF6),      o2(0xC4,0xF7),
          o2(0xC4,0xF8),      o2(0xC4,0xF9),
          o2(0xC4,0xFA),      o2(0xC4,0xFB),
          o2(0xC4,0xFC),      o2(0xC4,0xFD),
          o2(0xC4,0xFE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_00 = {
    to_EUC_KR_ED_00_offsets,
    to_EUC_KR_ED_00_infos
};

static const unsigned char
to_EUC_KR_ED_01_offsets[64] = {
     14, 14, 14, 14,  0,  1, 14,  2,     14,  3, 14, 14, 14, 14, 14, 14,
      4, 14, 14, 14,  5, 14, 14, 14,      6, 14, 14, 14, 14, 14, 14, 14,
      7, 14, 14, 14, 14, 14, 14, 14,     14, 14, 14, 14,  8,  9, 14, 14,
     10, 14, 14, 14, 11, 14, 14, 14,     14, 14, 14, 14, 12, 13, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_ED_01_infos[15] = {
          o2(0xC5,0xA1),      o2(0xC5,0xA2),
          o2(0xC5,0xA3),      o2(0xC5,0xA4),
          o2(0xC5,0xA5),      o2(0xC5,0xA6),
          o2(0xC5,0xA7),      o2(0xC5,0xA8),
          o2(0xC5,0xA9),      o2(0xC5,0xAA),
          o2(0xC5,0xAB),      o2(0xC5,0xAC),
          o2(0xC5,0xAD),      o2(0xC5,0xAE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_01 = {
    to_EUC_KR_ED_01_offsets,
    to_EUC_KR_ED_01_infos
};

static const unsigned char
to_EUC_KR_ED_02_offsets[64] = {
      9,  0,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  1,  2,  9,  9,      3,  9,  9,  9,  4,  9,  9,  9,
      9,  9,  9,  9,  5,  6,  9,  7,      9,  8,  9,  9,  9,  9,  9,  9,
};

static const struct byte_lookup* const
to_EUC_KR_ED_02_infos[10] = {
          o2(0xC5,0xAF),      o2(0xC5,0xB0),
          o2(0xC5,0xB1),      o2(0xC5,0xB2),
          o2(0xC5,0xB3),      o2(0xC5,0xB4),
          o2(0xC5,0xB5),      o2(0xC5,0xB6),
          o2(0xC5,0xB7),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_02 = {
    to_EUC_KR_ED_02_offsets,
    to_EUC_KR_ED_02_infos
};

static const unsigned char
to_EUC_KR_ED_03_offsets[64] = {
      0,  1, 20, 20,  2, 20, 20, 20,      3,  4, 20, 20, 20, 20, 20, 20,
      5,  6, 20,  7,  8,  9, 20, 20,     20, 20, 20, 20, 10, 11, 20, 20,
     12, 20, 20, 20, 13, 20, 20, 20,     20, 20, 20, 20, 14, 15, 20, 16,
     17, 18, 20, 20, 20, 20, 20, 20,     19, 20, 20, 20, 20, 20, 20, 20,
};

static const struct byte_lookup* const
to_EUC_KR_ED_03_infos[21] = {
          o2(0xC5,0xB8),      o2(0xC5,0xB9),
          o2(0xC5,0xBA),      o2(0xC5,0xBB),
          o2(0xC5,0xBC),      o2(0xC5,0xBD),
          o2(0xC5,0xBE),      o2(0xC5,0xBF),
          o2(0xC5,0xC0),      o2(0xC5,0xC1),
          o2(0xC5,0xC2),      o2(0xC5,0xC3),
          o2(0xC5,0xC4),      o2(0xC5,0xC5),
          o2(0xC5,0xC6),      o2(0xC5,0xC7),
          o2(0xC5,0xC8),      o2(0xC5,0xC9),
          o2(0xC5,0xCA),      o2(0xC5,0xCB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_03 = {
    to_EUC_KR_ED_03_offsets,
    to_EUC_KR_ED_03_infos
};

static const unsigned char
to_EUC_KR_ED_04_offsets[64] = {
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  0,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      1,  2,  6,  6,  3,  6,  6,  6,      4,  6,  5,  6,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_ED_04_infos[7] = {
          o2(0xC5,0xCC),      o2(0xC5,0xCD),
          o2(0xC5,0xCE),      o2(0xC5,0xCF),
          o2(0xC5,0xD0),      o2(0xC5,0xD1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_04 = {
    to_EUC_KR_ED_04_offsets,
    to_EUC_KR_ED_04_infos
};

static const unsigned char
to_EUC_KR_ED_05_offsets[64] = {
      0,  1, 16,  2,  3,  4, 16, 16,     16, 16, 16, 16,  5,  6, 16, 16,
      7, 16, 16, 16,  8, 16, 16, 16,     16, 16, 16, 16,  9, 10, 16, 11,
     16, 12, 16, 16, 16, 16, 16, 16,     13, 16, 16, 16, 14, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,     16, 16, 16, 16, 15, 16, 16, 16,
};

static const struct byte_lookup* const
to_EUC_KR_ED_05_infos[17] = {
          o2(0xC5,0xD2),      o2(0xC5,0xD3),
          o2(0xC5,0xD4),      o2(0xC5,0xD5),
          o2(0xC5,0xD6),      o2(0xC5,0xD7),
          o2(0xC5,0xD8),      o2(0xC5,0xD9),
          o2(0xC5,0xDA),      o2(0xC5,0xDB),
          o2(0xC5,0xDC),      o2(0xC5,0xDD),
          o2(0xC5,0xDE),      o2(0xC5,0xDF),
          o2(0xC5,0xE0),      o2(0xC5,0xE1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_05 = {
    to_EUC_KR_ED_05_offsets,
    to_EUC_KR_ED_05_infos
};

static const unsigned char
to_EUC_KR_ED_06_offsets[64] = {
     12, 12, 12, 12,  0, 12, 12, 12,      1, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,     12, 12, 12, 12, 12, 12, 12, 12,
      2,  3, 12, 12,  4, 12, 12, 12,      5, 12, 12, 12, 12, 12, 12, 12,
      6,  7, 12,  8, 12,  9, 12, 12,     12, 12, 10, 12, 11, 12, 12, 12,
};

static const struct byte_lookup* const
to_EUC_KR_ED_06_infos[13] = {
          o2(0xC5,0xE2),      o2(0xC5,0xE3),
          o2(0xC5,0xE4),      o2(0xC5,0xE5),
          o2(0xC5,0xE6),      o2(0xC5,0xE7),
          o2(0xC5,0xE8),      o2(0xC5,0xE9),
          o2(0xC5,0xEA),      o2(0xC5,0xEB),
          o2(0xC5,0xEC),      o2(0xC5,0xED),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_06 = {
    to_EUC_KR_ED_06_offsets,
    to_EUC_KR_ED_06_infos
};

static const unsigned char
to_EUC_KR_ED_07_offsets[64] = {
      0,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      1,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  2,  4,  4,  4,      3,  4,  4,  4,  4,  4,  4,  4,
};

static const struct byte_lookup* const
to_EUC_KR_ED_07_infos[5] = {
          o2(0xC5,0xEE),      o2(0xC5,0xEF),
          o2(0xC5,0xF0),      o2(0xC5,0xF1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_07 = {
    to_EUC_KR_ED_07_offsets,
    to_EUC_KR_ED_07_infos
};

static const unsigned char
to_EUC_KR_ED_08_offsets[64] = {
     10, 10, 10, 10, 10, 10, 10,  0,     10,  1, 10, 10, 10, 10, 10, 10,
      2, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,     10, 10, 10, 10,  3,  4, 10, 10,
      5, 10, 10, 10,  6, 10, 10, 10,     10, 10, 10, 10,  7,  8, 10,  9,
};

static const struct byte_lookup* const
to_EUC_KR_ED_08_infos[11] = {
          o2(0xC5,0xF2),      o2(0xC5,0xF3),
          o2(0xC5,0xF4),      o2(0xC5,0xF5),
          o2(0xC5,0xF6),      o2(0xC5,0xF7),
          o2(0xC5,0xF8),      o2(0xC5,0xF9),
          o2(0xC5,0xFA),      o2(0xC5,0xFB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_08 = {
    to_EUC_KR_ED_08_offsets,
    to_EUC_KR_ED_08_infos
};

static const unsigned char
to_EUC_KR_ED_09_offsets[64] = {
      4,  0,  4,  4,  4,  4,  4,  4,      1,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  2,  4,  4,  4,
      4,  4,  4,  4,  3,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
};

static const struct byte_lookup* const
to_EUC_KR_ED_09_infos[5] = {
          o2(0xC5,0xFC),      o2(0xC5,0xFD),
          o2(0xC5,0xFE),      o2(0xC6,0xA1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_09 = {
    to_EUC_KR_ED_09_offsets,
    to_EUC_KR_ED_09_infos
};

static const unsigned char
to_EUC_KR_ED_0A_offsets[64] = {
      0,  1, 16, 16,  2, 16, 16, 16,      3, 16, 16, 16, 16, 16, 16, 16,
      4,  5, 16, 16, 16,  6, 16, 16,     16, 16, 16, 16,  7, 16, 16, 16,
      8, 16, 16, 16,  9, 16, 16, 16,     16, 16, 16, 16, 10, 16, 16, 16,
     16, 11, 16, 16, 16, 16, 16, 16,     12, 13, 16, 16, 14, 16, 16, 15,
};

static const struct byte_lookup* const
to_EUC_KR_ED_0A_infos[17] = {
          o2(0xC6,0xA2),      o2(0xC6,0xA3),
          o2(0xC6,0xA4),      o2(0xC6,0xA5),
          o2(0xC6,0xA6),      o2(0xC6,0xA7),
          o2(0xC6,0xA8),      o2(0xC6,0xA9),
          o2(0xC6,0xAA),      o2(0xC6,0xAB),
          o2(0xC6,0xAC),      o2(0xC6,0xAD),
          o2(0xC6,0xAE),      o2(0xC6,0xAF),
          o2(0xC6,0xB0),      o2(0xC6,0xB1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_0A = {
    to_EUC_KR_ED_0A_offsets,
    to_EUC_KR_ED_0A_infos
};

static const unsigned char
to_EUC_KR_ED_0B_offsets[64] = {
      0, 14,  1, 14, 14, 14, 14, 14,      2,  3, 14,  4, 14, 14, 14, 14,
     14, 14, 14, 14,  5, 14, 14, 14,      6, 14, 14, 14,  7, 14, 14, 14,
     14, 14, 14, 14,  8,  9, 14, 14,     14, 14, 14, 14, 14, 14, 14, 14,
     10, 11, 14, 14, 12, 14, 14, 14,     13, 14, 14, 14, 14, 14, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_ED_0B_infos[15] = {
          o2(0xC6,0xB2),      o2(0xC6,0xB3),
          o2(0xC6,0xB4),      o2(0xC6,0xB5),
          o2(0xC6,0xB6),      o2(0xC6,0xB7),
          o2(0xC6,0xB8),      o2(0xC6,0xB9),
          o2(0xC6,0xBA),      o2(0xC6,0xBB),
          o2(0xC6,0xBC),      o2(0xC6,0xBD),
          o2(0xC6,0xBE),      o2(0xC6,0xBF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_0B = {
    to_EUC_KR_ED_0B_offsets,
    to_EUC_KR_ED_0B_infos
};

static const unsigned char
to_EUC_KR_ED_0C_offsets[64] = {
      0,  1, 25,  2, 25,  3, 25, 25,     25, 25, 25, 25,  4,  5,  6, 25,
      7, 25, 25, 25,  8, 25,  9, 25,     25, 25, 25, 25, 10, 11, 25, 12,
     13, 14, 25, 25, 25, 15, 25, 25,     16, 17, 25, 25, 18, 25, 25, 25,
     19, 25, 25, 25, 25, 25, 25, 25,     20, 21, 25, 22, 23, 24, 25, 25,
};

static const struct byte_lookup* const
to_EUC_KR_ED_0C_infos[26] = {
          o2(0xC6,0xC0),      o2(0xC6,0xC1),
          o2(0xC6,0xC2),      o2(0xC6,0xC3),
          o2(0xC6,0xC4),      o2(0xC6,0xC5),
          o2(0xC6,0xC6),      o2(0xC6,0xC7),
          o2(0xC6,0xC8),      o2(0xC6,0xC9),
          o2(0xC6,0xCA),      o2(0xC6,0xCB),
          o2(0xC6,0xCC),      o2(0xC6,0xCD),
          o2(0xC6,0xCE),      o2(0xC6,0xCF),
          o2(0xC6,0xD0),      o2(0xC6,0xD1),
          o2(0xC6,0xD2),      o2(0xC6,0xD3),
          o2(0xC6,0xD4),      o2(0xC6,0xD5),
          o2(0xC6,0xD6),      o2(0xC6,0xD7),
          o2(0xC6,0xD8),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_0C = {
    to_EUC_KR_ED_0C_offsets,
    to_EUC_KR_ED_0C_infos
};

static const unsigned char
to_EUC_KR_ED_0D_offsets[64] = {
      4,  4,  4,  4,  0,  1,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,      4,  4,  4,  4,  2,  3,  4,  4,
};

static const struct byte_lookup* const
to_EUC_KR_ED_0D_infos[5] = {
          o2(0xC6,0xD9),      o2(0xC6,0xDA),
          o2(0xC6,0xDB),      o2(0xC6,0xDC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_0D = {
    to_EUC_KR_ED_0D_offsets,
    to_EUC_KR_ED_0D_infos
};

static const unsigned char
to_EUC_KR_ED_0E_offsets[64] = {
      0, 18, 18, 18,  1, 18, 18, 18,     18, 18, 18, 18,  2,  3, 18,  4,
      5,  6, 18, 18, 18, 18, 18, 18,      7,  8, 18, 18,  9, 18, 18, 18,
     10, 18, 18, 18, 18, 18, 18, 18,     11, 12, 18, 13, 18, 14, 18, 18,
     18, 18, 18, 18, 15, 18, 18, 18,     16, 18, 18, 18, 17, 18, 18, 18,
};

static const struct byte_lookup* const
to_EUC_KR_ED_0E_infos[19] = {
          o2(0xC6,0xDD),      o2(0xC6,0xDE),
          o2(0xC6,0xDF),      o2(0xC6,0xE0),
          o2(0xC6,0xE1),      o2(0xC6,0xE2),
          o2(0xC6,0xE3),      o2(0xC6,0xE4),
          o2(0xC6,0xE5),      o2(0xC6,0xE6),
          o2(0xC6,0xE7),      o2(0xC6,0xE8),
          o2(0xC6,0xE9),      o2(0xC6,0xEA),
          o2(0xC6,0xEB),      o2(0xC6,0xEC),
          o2(0xC6,0xED),      o2(0xC6,0xEE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_0E = {
    to_EUC_KR_ED_0E_offsets,
    to_EUC_KR_ED_0E_infos
};

static const unsigned char
to_EUC_KR_ED_0F_offsets[64] = {
     15, 15, 15, 15,  0,  1, 15, 15,      2,  3, 15, 15, 15, 15, 15, 15,
      4, 15, 15, 15, 15, 15, 15, 15,      5, 15, 15, 15, 15, 15, 15, 15,
     15,  6, 15,  7, 15, 15, 15, 15,     15, 15, 15, 15,  8,  9, 15, 15,
     10, 15, 15, 15, 11, 15, 15, 15,     15, 15, 15, 15, 12, 13, 15, 14,
};

static const struct byte_lookup* const
to_EUC_KR_ED_0F_infos[16] = {
          o2(0xC6,0xEF),      o2(0xC6,0xF0),
          o2(0xC6,0xF1),      o2(0xC6,0xF2),
          o2(0xC6,0xF3),      o2(0xC6,0xF4),
          o2(0xC6,0xF5),      o2(0xC6,0xF6),
          o2(0xC6,0xF7),      o2(0xC6,0xF8),
          o2(0xC6,0xF9),      o2(0xC6,0xFA),
          o2(0xC6,0xFB),      o2(0xC6,0xFC),
          o2(0xC6,0xFD),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_0F = {
    to_EUC_KR_ED_0F_offsets,
    to_EUC_KR_ED_0F_infos
};

static const unsigned char
to_EUC_KR_ED_10_offsets[64] = {
      3,  0,  3,  3,  3,  3,  3,  3,      1,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,      3,  3,  3,  3,  3,  2,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,      3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,      3,  3,  3,  3,  3,  3,  3,  3,
};

static const struct byte_lookup* const
to_EUC_KR_ED_10_infos[4] = {
          o2(0xC6,0xFE),      o2(0xC7,0xA1),
          o2(0xC7,0xA2),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_10 = {
    to_EUC_KR_ED_10_offsets,
    to_EUC_KR_ED_10_infos
};

static const unsigned char
to_EUC_KR_ED_11_offsets[64] = {
      0, 11, 11, 11,  1, 11, 11, 11,     11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11,  2, 11, 11, 11,
      3, 11, 11, 11,  4, 11, 11, 11,     11, 11, 11, 11, 11,  5, 11,  6,
     11, 11, 11, 11, 11, 11, 11, 11,      7,  8, 11, 11,  9, 11, 11, 10,
};

static const struct byte_lookup* const
to_EUC_KR_ED_11_infos[12] = {
          o2(0xC7,0xA3),      o2(0xC7,0xA4),
          o2(0xC7,0xA5),      o2(0xC7,0xA6),
          o2(0xC7,0xA7),      o2(0xC7,0xA8),
          o2(0xC7,0xA9),      o2(0xC7,0xAA),
          o2(0xC7,0xAB),      o2(0xC7,0xAC),
          o2(0xC7,0xAD),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_11 = {
    to_EUC_KR_ED_11_offsets,
    to_EUC_KR_ED_11_infos
};

static const unsigned char
to_EUC_KR_ED_12_offsets[64] = {
      0,  8,  1,  8,  8,  8,  8,  8,      2,  3,  8,  4,  8,  5,  8,  8,
      8,  8,  8,  8,  6,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  7,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_ED_12_infos[9] = {
          o2(0xC7,0xAE),      o2(0xC7,0xAF),
          o2(0xC7,0xB0),      o2(0xC7,0xB1),
          o2(0xC7,0xB2),      o2(0xC7,0xB3),
          o2(0xC7,0xB4),      o2(0xC7,0xB5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_12 = {
    to_EUC_KR_ED_12_offsets,
    to_EUC_KR_ED_12_infos
};

static const unsigned char
to_EUC_KR_ED_13_offsets[64] = {
     11, 11, 11, 11, 11, 11, 11, 11,     11, 11, 11, 11,  0, 11, 11, 11,
      1, 11, 11, 11,  2, 11, 11, 11,     11, 11, 11, 11,  3, 11, 11,  4,
     11, 11, 11, 11, 11, 11, 11, 11,      5, 11, 11, 11,  6, 11, 11, 11,
      7, 11, 11, 11, 11, 11, 11, 11,      8, 11, 11,  9, 11, 10, 11, 11,
};

static const struct byte_lookup* const
to_EUC_KR_ED_13_infos[12] = {
          o2(0xC7,0xB6),      o2(0xC7,0xB7),
          o2(0xC7,0xB8),      o2(0xC7,0xB9),
          o2(0xC7,0xBA),      o2(0xC7,0xBB),
          o2(0xC7,0xBC),      o2(0xC7,0xBD),
          o2(0xC7,0xBE),      o2(0xC7,0xBF),
          o2(0xC7,0xC0),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_13 = {
    to_EUC_KR_ED_13_offsets,
    to_EUC_KR_ED_13_infos
};

static const unsigned char
to_EUC_KR_ED_14_offsets[64] = {
      8,  8,  8,  8,  0,  8,  8,  8,      1,  8,  8,  8,  2,  8,  8,  8,
      8,  8,  8,  8,  3,  4,  8,  5,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  6,  7,  8,  8,
};

static const struct byte_lookup* const
to_EUC_KR_ED_14_infos[9] = {
          o2(0xC7,0xC1),      o2(0xC7,0xC2),
          o2(0xC7,0xC3),      o2(0xC7,0xC4),
          o2(0xC7,0xC5),      o2(0xC7,0xC6),
          o2(0xC7,0xC7),      o2(0xC7,0xC8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_14 = {
    to_EUC_KR_ED_14_offsets,
    to_EUC_KR_ED_14_infos
};

static const unsigned char
to_EUC_KR_ED_15_offsets[64] = {
      0, 19, 19, 19,  1, 19, 19, 19,     19, 19, 19, 19,  2,  3, 19,  4,
     19,  5, 19, 19, 19, 19, 19, 19,      6,  7, 19, 19,  8, 19, 19, 19,
      9, 19, 19, 19, 19, 10, 19, 19,     11, 12, 19, 13, 19, 14, 19, 19,
     19, 19, 19, 19, 15, 16, 19, 19,     17, 19, 19, 19, 18, 19, 19, 19,
};

static const struct byte_lookup* const
to_EUC_KR_ED_15_infos[20] = {
          o2(0xC7,0xC9),      o2(0xC7,0xCA),
          o2(0xC7,0xCB),      o2(0xC7,0xCC),
          o2(0xC7,0xCD),      o2(0xC7,0xCE),
          o2(0xC7,0xCF),      o2(0xC7,0xD0),
          o2(0xC7,0xD1),      o2(0xC7,0xD2),
          o2(0xC7,0xD3),      o2(0xC7,0xD4),
          o2(0xC7,0xD5),      o2(0xC7,0xD6),
          o2(0xC7,0xD7),      o2(0xC7,0xD8),
          o2(0xC7,0xD9),      o2(0xC7,0xDA),
          o2(0xC7,0xDB),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_15 = {
    to_EUC_KR_ED_15_offsets,
    to_EUC_KR_ED_15_infos
};

static const unsigned char
to_EUC_KR_ED_16_offsets[64] = {
      7,  7,  7,  7,  0,  1,  7,  2,      3,  4,  7,  7,  7,  7,  7,  7,
      5,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  6,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,      7,  7,  7,  7,  7,  7,  7,  7,
};

static const struct byte_lookup* const
to_EUC_KR_ED_16_infos[8] = {
          o2(0xC7,0xDC),      o2(0xC7,0xDD),
          o2(0xC7,0xDE),      o2(0xC7,0xDF),
          o2(0xC7,0xE0),      o2(0xC7,0xE1),
          o2(0xC7,0xE2),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_16 = {
    to_EUC_KR_ED_16_offsets,
    to_EUC_KR_ED_16_infos
};

static const unsigned char
to_EUC_KR_ED_17_offsets[64] = {
     17, 17, 17, 17, 17, 17, 17, 17,      0,  1, 17, 17,  2, 17, 17, 17,
      3, 17,  4, 17, 17, 17, 17, 17,      5,  6, 17,  7, 17,  8, 17, 17,
     17, 17, 17, 17,  9, 10, 17, 17,     11, 17, 17, 17, 12, 17, 17, 17,
     17, 17, 17, 17, 13, 14, 17, 15,     17, 16, 17, 17, 17, 17, 17, 17,
};

static const struct byte_lookup* const
to_EUC_KR_ED_17_infos[18] = {
          o2(0xC7,0xE3),      o2(0xC7,0xE4),
          o2(0xC7,0xE5),      o2(0xC7,0xE6),
          o2(0xC7,0xE7),      o2(0xC7,0xE8),
          o2(0xC7,0xE9),      o2(0xC7,0xEA),
          o2(0xC7,0xEB),      o2(0xC7,0xEC),
          o2(0xC7,0xED),      o2(0xC7,0xEE),
          o2(0xC7,0xEF),      o2(0xC7,0xF0),
          o2(0xC7,0xF1),      o2(0xC7,0xF2),
          o2(0xC7,0xF3),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_17 = {
    to_EUC_KR_ED_17_offsets,
    to_EUC_KR_ED_17_infos
};

static const unsigned char
to_EUC_KR_ED_18_offsets[64] = {
      0,  1, 16, 16,  2, 16, 16, 16,      3, 16, 16, 16, 16, 16, 16, 16,
      4,  5, 16,  6,  7,  8, 16, 16,     16, 16, 16, 16,  9, 16, 16, 16,
     10, 16, 16, 16, 11, 16, 16, 16,     16, 16, 16, 16, 16, 12, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,     13, 14, 16, 16, 15, 16, 16, 16,
};

static const struct byte_lookup* const
to_EUC_KR_ED_18_infos[17] = {
          o2(0xC7,0xF4),      o2(0xC7,0xF5),
          o2(0xC7,0xF6),      o2(0xC7,0xF7),
          o2(0xC7,0xF8),      o2(0xC7,0xF9),
          o2(0xC7,0xFA),      o2(0xC7,0xFB),
          o2(0xC7,0xFC),      o2(0xC7,0xFD),
          o2(0xC7,0xFE),      o2(0xC8,0xA1),
          o2(0xC8,0xA2),      o2(0xC8,0xA3),
          o2(0xC8,0xA4),      o2(0xC8,0xA5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_18 = {
    to_EUC_KR_ED_18_offsets,
    to_EUC_KR_ED_18_infos
};

static const unsigned char
to_EUC_KR_ED_19_offsets[64] = {
      0, 16, 16, 16, 16,  1, 16, 16,      2,  3, 16,  4, 16,  5, 16, 16,
     16,  6, 16, 16,  7,  8, 16, 16,      9, 16, 16, 16, 10, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 11,     16, 12, 16, 16, 16, 16, 16, 16,
     13, 14, 16, 16, 15, 16, 16, 16,     16, 16, 16, 16, 16, 16, 16, 16,
};

static const struct byte_lookup* const
to_EUC_KR_ED_19_infos[17] = {
          o2(0xC8,0xA6),      o2(0xC8,0xA7),
          o2(0xC8,0xA8),      o2(0xC8,0xA9),
          o2(0xC8,0xAA),      o2(0xC8,0xAB),
          o2(0xC8,0xAC),      o2(0xC8,0xAD),
          o2(0xC8,0xAE),      o2(0xC8,0xAF),
          o2(0xC8,0xB0),      o2(0xC8,0xB1),
          o2(0xC8,0xB2),      o2(0xC8,0xB3),
          o2(0xC8,0xB4),      o2(0xC8,0xB5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_19 = {
    to_EUC_KR_ED_19_offsets,
    to_EUC_KR_ED_19_infos
};

static const unsigned char
to_EUC_KR_ED_1A_offsets[64] = {
     14, 14, 14,  0, 14,  1, 14, 14,     14, 14, 14, 14,  2,  3, 14, 14,
      4, 14, 14, 14,  5, 14, 14, 14,     14, 14, 14, 14, 14,  6, 14,  7,
     14,  8, 14, 14, 14, 14, 14, 14,      9, 14, 14, 14, 10, 14, 14, 14,
     11, 14, 14, 14, 14, 14, 14, 14,     14, 12, 14, 13, 14, 14, 14, 14,
};

static const struct byte_lookup* const
to_EUC_KR_ED_1A_infos[15] = {
          o2(0xC8,0xB6),      o2(0xC8,0xB7),
          o2(0xC8,0xB8),      o2(0xC8,0xB9),
          o2(0xC8,0xBA),      o2(0xC8,0xBB),
          o2(0xC8,0xBC),      o2(0xC8,0xBD),
          o2(0xC8,0xBE),      o2(0xC8,0xBF),
          o2(0xC8,0xC0),      o2(0xC8,0xC1),
          o2(0xC8,0xC2),      o2(0xC8,0xC3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_1A = {
    to_EUC_KR_ED_1A_offsets,
    to_EUC_KR_ED_1A_infos
};

static const unsigned char
to_EUC_KR_ED_1B_offsets[64] = {
     15, 15, 15, 15,  0,  1, 15, 15,      2, 15, 15, 15,  3, 15, 15, 15,
     15,  4, 15, 15,  5, 15, 15,  6,     15,  7, 15, 15, 15, 15, 15, 15,
      8, 15, 15, 15,  9, 15, 15, 15,     10, 15, 15, 15, 15, 15, 15, 15,
     11, 15, 15, 15, 15, 12, 15, 15,     15, 15, 15, 15, 13, 14, 15, 15,
};

static const struct byte_lookup* const
to_EUC_KR_ED_1B_infos[16] = {
          o2(0xC8,0xC4),      o2(0xC8,0xC5),
          o2(0xC8,0xC6),      o2(0xC8,0xC7),
          o2(0xC8,0xC8),      o2(0xC8,0xC9),
          o2(0xC8,0xCA),      o2(0xC8,0xCB),
          o2(0xC8,0xCC),      o2(0xC8,0xCD),
          o2(0xC8,0xCE),      o2(0xC8,0xCF),
          o2(0xC8,0xD0),      o2(0xC8,0xD1),
          o2(0xC8,0xD2),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_1B = {
    to_EUC_KR_ED_1B_offsets,
    to_EUC_KR_ED_1B_infos
};

static const unsigned char
to_EUC_KR_ED_1C_offsets[64] = {
      0, 15, 15, 15,  1, 15, 15, 15,     15, 15, 15, 15, 15, 15, 15, 15,
     15,  2, 15, 15, 15, 15, 15, 15,      3,  4, 15, 15,  5, 15, 15, 15,
      6, 15, 15, 15, 15, 15, 15, 15,      7,  8, 15,  9, 15, 10, 15, 15,
     15, 15, 15, 15, 11, 12, 15, 15,     13, 15, 15, 15, 14, 15, 15, 15,
};

static const struct byte_lookup* const
to_EUC_KR_ED_1C_infos[16] = {
          o2(0xC8,0xD3),      o2(0xC8,0xD4),
          o2(0xC8,0xD5),      o2(0xC8,0xD6),
          o2(0xC8,0xD7),      o2(0xC8,0xD8),
          o2(0xC8,0xD9),      o2(0xC8,0xDA),
          o2(0xC8,0xDB),      o2(0xC8,0xDC),
          o2(0xC8,0xDD),      o2(0xC8,0xDE),
          o2(0xC8,0xDF),      o2(0xC8,0xE0),
          o2(0xC8,0xE1),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_1C = {
    to_EUC_KR_ED_1C_offsets,
    to_EUC_KR_ED_1C_infos
};

static const unsigned char
to_EUC_KR_ED_1D_offsets[64] = {
     20, 20, 20, 20,  0, 20, 20,  1,     20,  2, 20, 20, 20, 20, 20, 20,
      3,  4, 20, 20,  5, 20,  6,  7,      8,  9, 20, 20, 20, 20, 20, 20,
     10, 11, 20, 12, 20, 13, 20, 20,     20, 14, 20, 20, 15, 20, 20, 20,
     16, 20, 20, 20, 17, 20, 20, 20,     20, 20, 20, 20, 18, 19, 20, 20,
};

static const struct byte_lookup* const
to_EUC_KR_ED_1D_infos[21] = {
          o2(0xC8,0xE2),      o2(0xC8,0xE3),
          o2(0xC8,0xE4),      o2(0xC8,0xE5),
          o2(0xC8,0xE6),      o2(0xC8,0xE7),
          o2(0xC8,0xE8),      o2(0xC8,0xE9),
          o2(0xC8,0xEA),      o2(0xC8,0xEB),
          o2(0xC8,0xEC),      o2(0xC8,0xED),
          o2(0xC8,0xEE),      o2(0xC8,0xEF),
          o2(0xC8,0xF0),      o2(0xC8,0xF1),
          o2(0xC8,0xF2),      o2(0xC8,0xF3),
          o2(0xC8,0xF4),      o2(0xC8,0xF5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_1D = {
    to_EUC_KR_ED_1D_offsets,
    to_EUC_KR_ED_1D_infos
};

static const unsigned char
to_EUC_KR_ED_1E_offsets[64] = {
      9,  0,  9,  9,  9,  9,  9,  9,      1,  2,  9,  9,  3,  9,  9,  9,
      4,  9,  9,  9,  9,  9,  9,  9,      5,  6,  9,  7,  9,  8,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,      9,  9,  9,  9,  9,  9,  9,  9,
};

static const struct byte_lookup* const
to_EUC_KR_ED_1E_infos[10] = {
          o2(0xC8,0xF6),      o2(0xC8,0xF7),
          o2(0xC8,0xF8),      o2(0xC8,0xF9),
          o2(0xC8,0xFA),      o2(0xC8,0xFB),
          o2(0xC8,0xFC),      o2(0xC8,0xFD),
          o2(0xC8,0xFE),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED_1E = {
    to_EUC_KR_ED_1E_offsets,
    to_EUC_KR_ED_1E_infos
};

static const unsigned char
to_EUC_KR_ED_offsets[64] = {
      0,  1,  2,  3,  4,  5,  6,  7,      8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,     24, 25, 26, 27, 28, 29, 30, 31,
     31, 31, 31, 31, 31, 31, 31, 31,     31, 31, 31, 31, 31, 31, 31, 31,
     31, 31, 31, 31, 31, 31, 31, 31,     31, 31, 31, 31, 31, 31, 31, 31,
};

static const struct byte_lookup* const
to_EUC_KR_ED_infos[32] = {
       &to_EUC_KR_ED_00,   &to_EUC_KR_ED_01,
       &to_EUC_KR_ED_02,   &to_EUC_KR_ED_03,
       &to_EUC_KR_ED_04,   &to_EUC_KR_ED_05,
       &to_EUC_KR_ED_06,   &to_EUC_KR_ED_07,
       &to_EUC_KR_ED_08,   &to_EUC_KR_ED_09,
       &to_EUC_KR_ED_0A,   &to_EUC_KR_ED_0B,
       &to_EUC_KR_ED_0C,   &to_EUC_KR_ED_0D,
       &to_EUC_KR_ED_0E,   &to_EUC_KR_ED_0F,
       &to_EUC_KR_ED_10,   &to_EUC_KR_ED_11,
       &to_EUC_KR_ED_12,   &to_EUC_KR_ED_13,
       &to_EUC_KR_ED_14,   &to_EUC_KR_ED_15,
       &to_EUC_KR_ED_16,   &to_EUC_KR_ED_17,
       &to_EUC_KR_ED_18,   &to_EUC_KR_ED_19,
       &to_EUC_KR_ED_1A,   &to_EUC_KR_ED_1B,
       &to_EUC_KR_ED_1C,   &to_EUC_KR_ED_1D,
       &to_EUC_KR_ED_1E,              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_ED = {
    to_EUC_KR_ED_offsets,
    to_EUC_KR_ED_infos
};


static const struct byte_lookup* const
to_EUC_KR_EF_24_infos[65] = {
          o2(0xCB,0xD0),      o2(0xCB,0xD6),
          o2(0xCB,0xE7),      o2(0xCD,0xCF),
          o2(0xCD,0xE8),      o2(0xCE,0xAD),
          o2(0xCF,0xFB),      o2(0xD0,0xA2),
          o2(0xD0,0xB8),      o2(0xD0,0xD0),
          o2(0xD0,0xDD),      o2(0xD1,0xD4),
          o2(0xD1,0xD5),      o2(0xD1,0xD8),
          o2(0xD1,0xDB),      o2(0xD1,0xDC),
          o2(0xD1,0xDD),      o2(0xD1,0xDE),
          o2(0xD1,0xDF),      o2(0xD1,0xE0),
          o2(0xD1,0xE2),      o2(0xD1,0xE3),
          o2(0xD1,0xE4),      o2(0xD1,0xE5),
          o2(0xD1,0xE6),      o2(0xD1,0xE8),
          o2(0xD1,0xE9),      o2(0xD1,0xEA),
          o2(0xD1,0xEB),      o2(0xD1,0xED),
          o2(0xD1,0xEF),      o2(0xD1,0xF0),
          o2(0xD1,0xF2),      o2(0xD1,0xF6),
          o2(0xD1,0xFA),      o2(0xD1,0xFC),
          o2(0xD1,0xFD),      o2(0xD1,0xFE),
          o2(0xD2,0xA2),      o2(0xD2,0xA3),
          o2(0xD2,0xA7),      o2(0xD2,0xA8),
          o2(0xD2,0xA9),      o2(0xD2,0xAA),
          o2(0xD2,0xAB),      o2(0xD2,0xAD),
          o2(0xD2,0xB2),      o2(0xD2,0xBE),
          o2(0xD2,0xC2),      o2(0xD2,0xC3),
          o2(0xD2,0xC4),      o2(0xD2,0xC6),
          o2(0xD2,0xC7),      o2(0xD2,0xC8),
          o2(0xD2,0xC9),      o2(0xD2,0xCA),
          o2(0xD2,0xCB),      o2(0xD2,0xCD),
          o2(0xD2,0xCE),      o2(0xD2,0xCF),
          o2(0xD2,0xD0),      o2(0xD2,0xD1),
          o2(0xD2,0xD2),      o2(0xD2,0xD3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EF_24 = {
    to_EUC_KR_E3_05_offsets,
    to_EUC_KR_EF_24_infos
};


static const struct byte_lookup* const
to_EUC_KR_EF_25_infos[65] = {
          o2(0xD2,0xD4),      o2(0xD2,0xD5),
          o2(0xD2,0xD6),      o2(0xD2,0xD7),
          o2(0xD2,0xD9),      o2(0xD2,0xDA),
          o2(0xD2,0xDE),      o2(0xD2,0xDF),
          o2(0xD2,0xE1),      o2(0xD2,0xE2),
          o2(0xD2,0xE4),      o2(0xD2,0xE5),
          o2(0xD2,0xE6),      o2(0xD2,0xE7),
          o2(0xD2,0xE8),      o2(0xD2,0xE9),
          o2(0xD2,0xEA),      o2(0xD2,0xEB),
          o2(0xD2,0xF0),      o2(0xD2,0xF1),
          o2(0xD2,0xF2),      o2(0xD2,0xF3),
          o2(0xD2,0xF4),      o2(0xD2,0xF5),
          o2(0xD2,0xF7),      o2(0xD2,0xF8),
          o2(0xD4,0xE6),      o2(0xD4,0xFC),
          o2(0xD5,0xA5),      o2(0xD5,0xAB),
          o2(0xD5,0xAE),      o2(0xD6,0xB8),
          o2(0xD6,0xCD),      o2(0xD7,0xCB),
          o2(0xD7,0xE4),      o2(0xDB,0xC5),
          o2(0xDB,0xE4),      o2(0xDC,0xA5),
          o2(0xDD,0xA5),      o2(0xDD,0xD5),
          o2(0xDD,0xF4),      o2(0xDE,0xFC),
          o2(0xDE,0xFE),      o2(0xDF,0xB3),
          o2(0xDF,0xE1),      o2(0xDF,0xE8),
          o2(0xE0,0xF1),      o2(0xE1,0xAD),
          o2(0xE1,0xED),      o2(0xE3,0xF5),
          o2(0xE4,0xA1),      o2(0xE4,0xA9),
          o2(0xE5,0xAE),      o2(0xE5,0xB1),
          o2(0xE5,0xB2),      o2(0xE5,0xB9),
          o2(0xE5,0xBB),      o2(0xE5,0xBC),
          o2(0xE5,0xC4),      o2(0xE5,0xCE),
          o2(0xE5,0xD0),      o2(0xE5,0xD2),
          o2(0xE5,0xD6),      o2(0xE5,0xFA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EF_25 = {
    to_EUC_KR_E3_05_offsets,
    to_EUC_KR_EF_25_infos
};


static const struct byte_lookup* const
to_EUC_KR_EF_26_infos[65] = {
          o2(0xE5,0xFB),      o2(0xE5,0xFC),
          o2(0xE5,0xFE),      o2(0xE6,0xA1),
          o2(0xE6,0xA4),      o2(0xE6,0xA7),
          o2(0xE6,0xAD),      o2(0xE6,0xAF),
          o2(0xE6,0xB0),      o2(0xE6,0xB1),
          o2(0xE6,0xB3),      o2(0xE6,0xB7),
          o2(0xE6,0xB8),      o2(0xE6,0xBC),
          o2(0xE6,0xC4),      o2(0xE6,0xC6),
          o2(0xE6,0xC7),      o2(0xE6,0xCA),
          o2(0xE6,0xD2),      o2(0xE6,0xD6),
          o2(0xE6,0xD9),      o2(0xE6,0xDC),
          o2(0xE6,0xDF),      o2(0xE6,0xE1),
          o2(0xE6,0xE4),      o2(0xE6,0xE5),
          o2(0xE6,0xE6),      o2(0xE6,0xE8),
          o2(0xE6,0xEA),      o2(0xE6,0xEB),
          o2(0xE6,0xEC),      o2(0xE6,0xEF),
          o2(0xE6,0xF1),      o2(0xE6,0xF2),
          o2(0xE6,0xF5),      o2(0xE6,0xF6),
          o2(0xE6,0xF7),      o2(0xE6,0xF9),
          o2(0xE7,0xA1),      o2(0xE7,0xA6),
          o2(0xE7,0xA9),      o2(0xE7,0xAA),
          o2(0xE7,0xAC),      o2(0xE7,0xAD),
          o2(0xE7,0xB0),      o2(0xE7,0xBF),
          o2(0xE7,0xC1),      o2(0xE7,0xC6),
          o2(0xE7,0xC7),      o2(0xE7,0xCB),
          o2(0xE7,0xCD),      o2(0xE7,0xCF),
          o2(0xE7,0xD0),      o2(0xE7,0xD3),
          o2(0xE7,0xDF),      o2(0xE7,0xE4),
          o2(0xE7,0xE6),      o2(0xE7,0xF7),
          o2(0xE8,0xE7),      o2(0xE8,0xE8),
          o2(0xE8,0xF0),      o2(0xE8,0xF1),
          o2(0xE8,0xF7),      o2(0xE8,0xF9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EF_26 = {
    to_EUC_KR_E3_05_offsets,
    to_EUC_KR_EF_26_infos
};


static const struct byte_lookup* const
to_EUC_KR_EF_27_infos[65] = {
          o2(0xE8,0xFB),      o2(0xE8,0xFE),
          o2(0xE9,0xA7),      o2(0xE9,0xAC),
          o2(0xE9,0xCC),      o2(0xE9,0xF7),
          o2(0xEA,0xC1),      o2(0xEA,0xE5),
          o2(0xEA,0xF4),      o2(0xEA,0xF7),
          o2(0xEA,0xFC),      o2(0xEA,0xFE),
          o2(0xEB,0xA4),      o2(0xEB,0xA7),
          o2(0xEB,0xA9),      o2(0xEB,0xAA),
          o2(0xEB,0xBA),      o2(0xEB,0xBB),
          o2(0xEB,0xBD),      o2(0xEB,0xC1),
          o2(0xEB,0xC2),      o2(0xEB,0xC6),
          o2(0xEB,0xC7),      o2(0xEB,0xCC),
          o2(0xEB,0xCF),      o2(0xEB,0xD0),
          o2(0xEB,0xD1),      o2(0xEB,0xD2),
          o2(0xEB,0xD8),      o2(0xEC,0xA6),
          o2(0xEC,0xA7),      o2(0xEC,0xAA),
          o2(0xEC,0xAF),      o2(0xEC,0xB0),
          o2(0xEC,0xB1),      o2(0xEC,0xB2),
          o2(0xEC,0xB5),      o2(0xEC,0xB8),
          o2(0xEC,0xBA),      o2(0xEC,0xC0),
          o2(0xEC,0xC1),      o2(0xEC,0xC5),
          o2(0xEC,0xC6),      o2(0xEC,0xC9),
          o2(0xEC,0xCA),      o2(0xEC,0xD5),
          o2(0xEC,0xDD),      o2(0xEC,0xDE),
          o2(0xEC,0xE1),      o2(0xEC,0xE4),
          o2(0xEC,0xE7),      o2(0xEC,0xE8),
          o2(0xEC,0xF7),      o2(0xEC,0xF8),
          o2(0xEC,0xFA),      o2(0xED,0xA1),
          o2(0xED,0xA2),      o2(0xED,0xA3),
          o2(0xED,0xEE),      o2(0xEE,0xDB),
          o2(0xF2,0xBD),      o2(0xF2,0xFA),
          o2(0xF3,0xB1),      o2(0xF4,0xA7),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EF_27 = {
    to_EUC_KR_E3_05_offsets,
    to_EUC_KR_EF_27_infos
};


static const struct byte_lookup* const
to_EUC_KR_EF_28_infos[13] = {
          o2(0xF4,0xEE),      o2(0xF6,0xF4),
          o2(0xF6,0xF6),      o2(0xF7,0xB8),
          o2(0xF7,0xC8),      o2(0xF7,0xD3),
          o2(0xF8,0xDB),      o2(0xF8,0xF0),
          o2(0xFA,0xA1),      o2(0xFA,0xA2),
          o2(0xFA,0xE6),      o2(0xFC,0xA9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EF_28 = {
    to_EUC_KR_E2_15_offsets,
    to_EUC_KR_EF_28_infos
};


static const struct byte_lookup* const
to_EUC_KR_EF_3C_infos[64] = {
          o2(0xA3,0xA1),      o2(0xA3,0xA2),
          o2(0xA3,0xA3),      o2(0xA3,0xA4),
          o2(0xA3,0xA5),      o2(0xA3,0xA6),
          o2(0xA3,0xA7),      o2(0xA3,0xA8),
          o2(0xA3,0xA9),      o2(0xA3,0xAA),
          o2(0xA3,0xAB),      o2(0xA3,0xAC),
          o2(0xA3,0xAD),      o2(0xA3,0xAE),
          o2(0xA3,0xAF),      o2(0xA3,0xB0),
          o2(0xA3,0xB1),      o2(0xA3,0xB2),
          o2(0xA3,0xB3),      o2(0xA3,0xB4),
          o2(0xA3,0xB5),      o2(0xA3,0xB6),
          o2(0xA3,0xB7),      o2(0xA3,0xB8),
          o2(0xA3,0xB9),      o2(0xA3,0xBA),
          o2(0xA3,0xBB),      o2(0xA3,0xBC),
          o2(0xA3,0xBD),      o2(0xA3,0xBE),
          o2(0xA3,0xBF),      o2(0xA3,0xC0),
          o2(0xA3,0xC1),      o2(0xA3,0xC2),
          o2(0xA3,0xC3),      o2(0xA3,0xC4),
          o2(0xA3,0xC5),      o2(0xA3,0xC6),
          o2(0xA3,0xC7),      o2(0xA3,0xC8),
          o2(0xA3,0xC9),      o2(0xA3,0xCA),
          o2(0xA3,0xCB),      o2(0xA3,0xCC),
          o2(0xA3,0xCD),      o2(0xA3,0xCE),
          o2(0xA3,0xCF),      o2(0xA3,0xD0),
          o2(0xA3,0xD1),      o2(0xA3,0xD2),
          o2(0xA3,0xD3),      o2(0xA3,0xD4),
          o2(0xA3,0xD5),      o2(0xA3,0xD6),
          o2(0xA3,0xD7),      o2(0xA3,0xD8),
          o2(0xA3,0xD9),      o2(0xA3,0xDA),
          o2(0xA3,0xDB),      o2(0xA1,0xAC),
          o2(0xA3,0xDD),      o2(0xA3,0xDE),
          o2(0xA3,0xDF),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EF_3C = {
    to_EUC_KR_E3_01_offsets,
    to_EUC_KR_EF_3C_infos
};


static const struct byte_lookup* const
to_EUC_KR_EF_3D_infos[32] = {
          o2(0xA3,0xE0),      o2(0xA3,0xE1),
          o2(0xA3,0xE2),      o2(0xA3,0xE3),
          o2(0xA3,0xE4),      o2(0xA3,0xE5),
          o2(0xA3,0xE6),      o2(0xA3,0xE7),
          o2(0xA3,0xE8),      o2(0xA3,0xE9),
          o2(0xA3,0xEA),      o2(0xA3,0xEB),
          o2(0xA3,0xEC),      o2(0xA3,0xED),
          o2(0xA3,0xEE),      o2(0xA3,0xEF),
          o2(0xA3,0xF0),      o2(0xA3,0xF1),
          o2(0xA3,0xF2),      o2(0xA3,0xF3),
          o2(0xA3,0xF4),      o2(0xA3,0xF5),
          o2(0xA3,0xF6),      o2(0xA3,0xF7),
          o2(0xA3,0xF8),      o2(0xA3,0xF9),
          o2(0xA3,0xFA),      o2(0xA3,0xFB),
          o2(0xA3,0xFC),      o2(0xA3,0xFD),
          o2(0xA2,0xA6),              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EF_3D = {
    to_EUC_KR_ED_offsets,
    to_EUC_KR_EF_3D_infos
};

static const unsigned char
to_EUC_KR_EF_3F_offsets[64] = {
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      0,  1,  2,  3,  6,  4,  5,  6,      6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,      6,  6,  6,  6,  6,  6,  6,  6,
};

static const struct byte_lookup* const
to_EUC_KR_EF_3F_infos[7] = {
          o2(0xA1,0xCB),      o2(0xA1,0xCC),
          o2(0xA1,0xFE),      o2(0xA3,0xFE),
          o2(0xA1,0xCD),      o2(0xA3,0xDC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EF_3F = {
    to_EUC_KR_EF_3F_offsets,
    to_EUC_KR_EF_3F_infos
};

static const unsigned char
to_EUC_KR_EF_offsets[64] = {
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  0,  1,  2,  3,      4,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,      8,  8,  8,  8,  5,  6,  8,  7,
};

static const struct byte_lookup* const
to_EUC_KR_EF_infos[9] = {
       &to_EUC_KR_EF_24,   &to_EUC_KR_EF_25,
       &to_EUC_KR_EF_26,   &to_EUC_KR_EF_27,
       &to_EUC_KR_EF_28,   &to_EUC_KR_EF_3C,
       &to_EUC_KR_EF_3D,   &to_EUC_KR_EF_3F,
                  UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR_EF = {
    to_EUC_KR_EF_offsets,
    to_EUC_KR_EF_infos
};

static const unsigned char
to_EUC_KR_offsets[256] = {
      0,  0,  0,  0,  0,  0,  0,  0,      0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,      0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,      0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,      0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,      0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,      0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,      0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,      0,  0,  0,  0,  0,  0,  0,  0,
     23, 23, 23, 23, 23, 23, 23, 23,     23, 23, 23, 23, 23, 23, 23, 23,
     23, 23, 23, 23, 23, 23, 23, 23,     23, 23, 23, 23, 23, 23, 23, 23,
     23, 23, 23, 23, 23, 23, 23, 23,     23, 23, 23, 23, 23, 23, 23, 23,
     23, 23, 23, 23, 23, 23, 23, 23,     23, 23, 23, 23, 23, 23, 23, 23,
     23, 23,  1,  2,  3,  4, 23, 23,     23, 23, 23,  5, 23, 23,  6,  7,
      8,  9, 23, 23, 23, 23, 23, 23,     23, 23, 23, 23, 23, 23, 23, 23,
     23, 23, 10, 11, 12, 13, 14, 15,     16, 17, 18, 19, 20, 21, 23, 22,
     23, 23, 23, 23, 23, 23, 23, 23,     23, 23, 23, 23, 23, 23, 23, 23,
};

static const struct byte_lookup* const
to_EUC_KR_infos[24] = {
                  NOMAP,      &to_EUC_KR_C2,
          &to_EUC_KR_C3,      &to_EUC_KR_C4,
          &to_EUC_KR_C5,      &to_EUC_KR_CB,
          &to_EUC_KR_CE,      &to_EUC_KR_CF,
          &to_EUC_KR_D0,      &to_EUC_KR_D1,
          &to_EUC_KR_E2,      &to_EUC_KR_E3,
          &to_EUC_KR_E4,      &to_EUC_KR_E5,
          &to_EUC_KR_E6,      &to_EUC_KR_E7,
          &to_EUC_KR_E8,      &to_EUC_KR_E9,
          &to_EUC_KR_EA,      &to_EUC_KR_EB,
          &to_EUC_KR_EC,      &to_EUC_KR_ED,
          &to_EUC_KR_EF,              UNDEF,
};

static const BYTE_LOOKUP
to_EUC_KR = {
    to_EUC_KR_offsets,
    to_EUC_KR_infos
};

static const unsigned char
from_EUC_KR_A1_offsets[256] = {
     94, 94, 94, 94, 94, 94, 94, 94,     94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,     94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,     94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,     94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,     94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,     94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,     94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,     94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,     94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,     94, 94, 94, 94, 94, 94, 94, 94,
     94,  0,  1,  2,  3,  4,  5,  6,      7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,     23, 24, 25, 26, 27, 28, 29, 30,
     31, 32, 33, 34, 35, 36, 37, 38,     39, 40, 41, 42, 43, 44, 45, 46,
     47, 48, 49, 50, 51, 52, 53, 54,     55, 56, 57, 58, 59, 60, 61, 62,
     63, 64, 65, 66, 67, 68, 69, 70,     71, 72, 73, 74, 75, 76, 77, 78,
     79, 80, 81, 82, 83, 84, 85, 86,     87, 88, 89, 90, 91, 92, 93, 94,
};

static const struct byte_lookup* const
from_EUC_KR_A1_infos[95] = {
     o3(0xE3,0x80,0x80), o3(0xE3,0x80,0x81),
     o3(0xE3,0x80,0x82),      o2(0xC2,0xB7),
     o3(0xE2,0x80,0xA5), o3(0xE2,0x80,0xA6),
          o2(0xC2,0xA8), o3(0xE3,0x80,0x83),
          o2(0xC2,0xAD), o3(0xE2,0x80,0x95),
     o3(0xE2,0x88,0xA5), o3(0xEF,0xBC,0xBC),
     o3(0xE2,0x88,0xBC), o3(0xE2,0x80,0x98),
     o3(0xE2,0x80,0x99), o3(0xE2,0x80,0x9C),
     o3(0xE2,0x80,0x9D), o3(0xE3,0x80,0x94),
     o3(0xE3,0x80,0x95), o3(0xE3,0x80,0x88),
     o3(0xE3,0x80,0x89), o3(0xE3,0x80,0x8A),
     o3(0xE3,0x80,0x8B), o3(0xE3,0x80,0x8C),
     o3(0xE3,0x80,0x8D), o3(0xE3,0x80,0x8E),
     o3(0xE3,0x80,0x8F), o3(0xE3,0x80,0x90),
     o3(0xE3,0x80,0x91),      o2(0xC2,0xB1),
          o2(0xC3,0x97),      o2(0xC3,0xB7),
     o3(0xE2,0x89,0xA0), o3(0xE2,0x89,0xA4),
     o3(0xE2,0x89,0xA5), o3(0xE2,0x88,0x9E),
     o3(0xE2,0x88,0xB4),      o2(0xC2,0xB0),
     o3(0xE2,0x80,0xB2), o3(0xE2,0x80,0xB3),
     o3(0xE2,0x84,0x83), o3(0xE2,0x84,0xAB),
     o3(0xEF,0xBF,0xA0), o3(0xEF,0xBF,0xA1),
     o3(0xEF,0xBF,0xA5), o3(0xE2,0x99,0x82),
     o3(0xE2,0x99,0x80), o3(0xE2,0x88,0xA0),
     o3(0xE2,0x8A,0xA5), o3(0xE2,0x8C,0x92),
     o3(0xE2,0x88,0x82), o3(0xE2,0x88,0x87),
     o3(0xE2,0x89,0xA1), o3(0xE2,0x89,0x92),
          o2(0xC2,0xA7), o3(0xE2,0x80,0xBB),
     o3(0xE2,0x98,0x86), o3(0xE2,0x98,0x85),
     o3(0xE2,0x97,0x8B), o3(0xE2,0x97,0x8F),
     o3(0xE2,0x97,0x8E), o3(0xE2,0x97,0x87),
     o3(0xE2,0x97,0x86), o3(0xE2,0x96,0xA1),
     o3(0xE2,0x96,0xA0), o3(0xE2,0x96,0xB3),
     o3(0xE2,0x96,0xB2), o3(0xE2,0x96,0xBD),
     o3(0xE2,0x96,0xBC), o3(0xE2,0x86,0x92),
     o3(0xE2,0x86,0x90), o3(0xE2,0x86,0x91),
     o3(0xE2,0x86,0x93), o3(0xE2,0x86,0x94),
     o3(0xE3,0x80,0x93), o3(0xE2,0x89,0xAA),
     o3(0xE2,0x89,0xAB), o3(0xE2,0x88,0x9A),
     o3(0xE2,0x88,0xBD), o3(0xE2,0x88,0x9D),
     o3(0xE2,0x88,0xB5), o3(0xE2,0x88,0xAB),
     o3(0xE2,0x88,0xAC), o3(0xE2,0x88,0x88),
     o3(0xE2,0x88,0x8B), o3(0xE2,0x8A,0x86),
     o3(0xE2,0x8A,0x87), o3(0xE2,0x8A,0x82),
     o3(0xE2,0x8A,0x83), o3(0xE2,0x88,0xAA),
     o3(0xE2,0x88,0xA9), o3(0xE2,0x88,0xA7),
     o3(0xE2,0x88,0xA8), o3(0xEF,0xBF,0xA2),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_A1 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_A1_infos
};

static const unsigned char
from_EUC_KR_A2_offsets[256] = {
     69, 69, 69, 69, 69, 69, 69, 69,     69, 69, 69, 69, 69, 69, 69, 69,
     69, 69, 69, 69, 69, 69, 69, 69,     69, 69, 69, 69, 69, 69, 69, 69,
     69, 69, 69, 69, 69, 69, 69, 69,     69, 69, 69, 69, 69, 69, 69, 69,
     69, 69, 69, 69, 69, 69, 69, 69,     69, 69, 69, 69, 69, 69, 69, 69,
     69, 69, 69, 69, 69, 69, 69, 69,     69, 69, 69, 69, 69, 69, 69, 69,
     69, 69, 69, 69, 69, 69, 69, 69,     69, 69, 69, 69, 69, 69, 69, 69,
     69, 69, 69, 69, 69, 69, 69, 69,     69, 69, 69, 69, 69, 69, 69, 69,
     69, 69, 69, 69, 69, 69, 69, 69,     69, 69, 69, 69, 69, 69, 69, 69,
     69, 69, 69, 69, 69, 69, 69, 69,     69, 69, 69, 69, 69, 69, 69, 69,
     69, 69, 69, 69, 69, 69, 69, 69,     69, 69, 69, 69, 69, 69, 69, 69,
     69,  0,  1,  2,  3,  4,  5,  6,      7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,     23, 24, 25, 26, 27, 28, 29, 30,
     31, 32, 33, 34, 35, 36, 37, 38,     39, 40, 41, 42, 43, 44, 45, 46,
     47, 48, 49, 50, 51, 52, 53, 54,     55, 56, 57, 58, 59, 60, 61, 62,
     63, 64, 65, 66, 67, 68, 69, 69,     69, 69, 69, 69, 69, 69, 69, 69,
     69, 69, 69, 69, 69, 69, 69, 69,     69, 69, 69, 69, 69, 69, 69, 69,
};

static const struct byte_lookup* const
from_EUC_KR_A2_infos[70] = {
     o3(0xE2,0x87,0x92), o3(0xE2,0x87,0x94),
     o3(0xE2,0x88,0x80), o3(0xE2,0x88,0x83),
          o2(0xC2,0xB4), o3(0xEF,0xBD,0x9E),
          o2(0xCB,0x87),      o2(0xCB,0x98),
          o2(0xCB,0x9D),      o2(0xCB,0x9A),
          o2(0xCB,0x99),      o2(0xC2,0xB8),
          o2(0xCB,0x9B),      o2(0xC2,0xA1),
          o2(0xC2,0xBF),      o2(0xCB,0x90),
     o3(0xE2,0x88,0xAE), o3(0xE2,0x88,0x91),
     o3(0xE2,0x88,0x8F),      o2(0xC2,0xA4),
     o3(0xE2,0x84,0x89), o3(0xE2,0x80,0xB0),
     o3(0xE2,0x97,0x81), o3(0xE2,0x97,0x80),
     o3(0xE2,0x96,0xB7), o3(0xE2,0x96,0xB6),
     o3(0xE2,0x99,0xA4), o3(0xE2,0x99,0xA0),
     o3(0xE2,0x99,0xA1), o3(0xE2,0x99,0xA5),
     o3(0xE2,0x99,0xA7), o3(0xE2,0x99,0xA3),
     o3(0xE2,0x8A,0x99), o3(0xE2,0x97,0x88),
     o3(0xE2,0x96,0xA3), o3(0xE2,0x97,0x90),
     o3(0xE2,0x97,0x91), o3(0xE2,0x96,0x92),
     o3(0xE2,0x96,0xA4), o3(0xE2,0x96,0xA5),
     o3(0xE2,0x96,0xA8), o3(0xE2,0x96,0xA7),
     o3(0xE2,0x96,0xA6), o3(0xE2,0x96,0xA9),
     o3(0xE2,0x99,0xA8), o3(0xE2,0x98,0x8F),
     o3(0xE2,0x98,0x8E), o3(0xE2,0x98,0x9C),
     o3(0xE2,0x98,0x9E),      o2(0xC2,0xB6),
     o3(0xE2,0x80,0xA0), o3(0xE2,0x80,0xA1),
     o3(0xE2,0x86,0x95), o3(0xE2,0x86,0x97),
     o3(0xE2,0x86,0x99), o3(0xE2,0x86,0x96),
     o3(0xE2,0x86,0x98), o3(0xE2,0x99,0xAD),
     o3(0xE2,0x99,0xA9), o3(0xE2,0x99,0xAA),
     o3(0xE2,0x99,0xAC), o3(0xE3,0x89,0xBF),
     o3(0xE3,0x88,0x9C), o3(0xE2,0x84,0x96),
     o3(0xE3,0x8F,0x87), o3(0xE2,0x84,0xA2),
     o3(0xE3,0x8F,0x82), o3(0xE3,0x8F,0x98),
     o3(0xE2,0x84,0xA1),              UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_A2 = {
    from_EUC_KR_A2_offsets,
    from_EUC_KR_A2_infos
};


static const struct byte_lookup* const
from_EUC_KR_A3_infos[95] = {
     o3(0xEF,0xBC,0x81), o3(0xEF,0xBC,0x82),
     o3(0xEF,0xBC,0x83), o3(0xEF,0xBC,0x84),
     o3(0xEF,0xBC,0x85), o3(0xEF,0xBC,0x86),
     o3(0xEF,0xBC,0x87), o3(0xEF,0xBC,0x88),
     o3(0xEF,0xBC,0x89), o3(0xEF,0xBC,0x8A),
     o3(0xEF,0xBC,0x8B), o3(0xEF,0xBC,0x8C),
     o3(0xEF,0xBC,0x8D), o3(0xEF,0xBC,0x8E),
     o3(0xEF,0xBC,0x8F), o3(0xEF,0xBC,0x90),
     o3(0xEF,0xBC,0x91), o3(0xEF,0xBC,0x92),
     o3(0xEF,0xBC,0x93), o3(0xEF,0xBC,0x94),
     o3(0xEF,0xBC,0x95), o3(0xEF,0xBC,0x96),
     o3(0xEF,0xBC,0x97), o3(0xEF,0xBC,0x98),
     o3(0xEF,0xBC,0x99), o3(0xEF,0xBC,0x9A),
     o3(0xEF,0xBC,0x9B), o3(0xEF,0xBC,0x9C),
     o3(0xEF,0xBC,0x9D), o3(0xEF,0xBC,0x9E),
     o3(0xEF,0xBC,0x9F), o3(0xEF,0xBC,0xA0),
     o3(0xEF,0xBC,0xA1), o3(0xEF,0xBC,0xA2),
     o3(0xEF,0xBC,0xA3), o3(0xEF,0xBC,0xA4),
     o3(0xEF,0xBC,0xA5), o3(0xEF,0xBC,0xA6),
     o3(0xEF,0xBC,0xA7), o3(0xEF,0xBC,0xA8),
     o3(0xEF,0xBC,0xA9), o3(0xEF,0xBC,0xAA),
     o3(0xEF,0xBC,0xAB), o3(0xEF,0xBC,0xAC),
     o3(0xEF,0xBC,0xAD), o3(0xEF,0xBC,0xAE),
     o3(0xEF,0xBC,0xAF), o3(0xEF,0xBC,0xB0),
     o3(0xEF,0xBC,0xB1), o3(0xEF,0xBC,0xB2),
     o3(0xEF,0xBC,0xB3), o3(0xEF,0xBC,0xB4),
     o3(0xEF,0xBC,0xB5), o3(0xEF,0xBC,0xB6),
     o3(0xEF,0xBC,0xB7), o3(0xEF,0xBC,0xB8),
     o3(0xEF,0xBC,0xB9), o3(0xEF,0xBC,0xBA),
     o3(0xEF,0xBC,0xBB), o3(0xEF,0xBF,0xA6),
     o3(0xEF,0xBC,0xBD), o3(0xEF,0xBC,0xBE),
     o3(0xEF,0xBC,0xBF), o3(0xEF,0xBD,0x80),
     o3(0xEF,0xBD,0x81), o3(0xEF,0xBD,0x82),
     o3(0xEF,0xBD,0x83), o3(0xEF,0xBD,0x84),
     o3(0xEF,0xBD,0x85), o3(0xEF,0xBD,0x86),
     o3(0xEF,0xBD,0x87), o3(0xEF,0xBD,0x88),
     o3(0xEF,0xBD,0x89), o3(0xEF,0xBD,0x8A),
     o3(0xEF,0xBD,0x8B), o3(0xEF,0xBD,0x8C),
     o3(0xEF,0xBD,0x8D), o3(0xEF,0xBD,0x8E),
     o3(0xEF,0xBD,0x8F), o3(0xEF,0xBD,0x90),
     o3(0xEF,0xBD,0x91), o3(0xEF,0xBD,0x92),
     o3(0xEF,0xBD,0x93), o3(0xEF,0xBD,0x94),
     o3(0xEF,0xBD,0x95), o3(0xEF,0xBD,0x96),
     o3(0xEF,0xBD,0x97), o3(0xEF,0xBD,0x98),
     o3(0xEF,0xBD,0x99), o3(0xEF,0xBD,0x9A),
     o3(0xEF,0xBD,0x9B), o3(0xEF,0xBD,0x9C),
     o3(0xEF,0xBD,0x9D), o3(0xEF,0xBF,0xA3),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_A3 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_A3_infos
};


static const struct byte_lookup* const
from_EUC_KR_A4_infos[95] = {
     o3(0xE3,0x84,0xB1), o3(0xE3,0x84,0xB2),
     o3(0xE3,0x84,0xB3), o3(0xE3,0x84,0xB4),
     o3(0xE3,0x84,0xB5), o3(0xE3,0x84,0xB6),
     o3(0xE3,0x84,0xB7), o3(0xE3,0x84,0xB8),
     o3(0xE3,0x84,0xB9), o3(0xE3,0x84,0xBA),
     o3(0xE3,0x84,0xBB), o3(0xE3,0x84,0xBC),
     o3(0xE3,0x84,0xBD), o3(0xE3,0x84,0xBE),
     o3(0xE3,0x84,0xBF), o3(0xE3,0x85,0x80),
     o3(0xE3,0x85,0x81), o3(0xE3,0x85,0x82),
     o3(0xE3,0x85,0x83), o3(0xE3,0x85,0x84),
     o3(0xE3,0x85,0x85), o3(0xE3,0x85,0x86),
     o3(0xE3,0x85,0x87), o3(0xE3,0x85,0x88),
     o3(0xE3,0x85,0x89), o3(0xE3,0x85,0x8A),
     o3(0xE3,0x85,0x8B), o3(0xE3,0x85,0x8C),
     o3(0xE3,0x85,0x8D), o3(0xE3,0x85,0x8E),
     o3(0xE3,0x85,0x8F), o3(0xE3,0x85,0x90),
     o3(0xE3,0x85,0x91), o3(0xE3,0x85,0x92),
     o3(0xE3,0x85,0x93), o3(0xE3,0x85,0x94),
     o3(0xE3,0x85,0x95), o3(0xE3,0x85,0x96),
     o3(0xE3,0x85,0x97), o3(0xE3,0x85,0x98),
     o3(0xE3,0x85,0x99), o3(0xE3,0x85,0x9A),
     o3(0xE3,0x85,0x9B), o3(0xE3,0x85,0x9C),
     o3(0xE3,0x85,0x9D), o3(0xE3,0x85,0x9E),
     o3(0xE3,0x85,0x9F), o3(0xE3,0x85,0xA0),
     o3(0xE3,0x85,0xA1), o3(0xE3,0x85,0xA2),
     o3(0xE3,0x85,0xA3), o3(0xE3,0x85,0xA4),
     o3(0xE3,0x85,0xA5), o3(0xE3,0x85,0xA6),
     o3(0xE3,0x85,0xA7), o3(0xE3,0x85,0xA8),
     o3(0xE3,0x85,0xA9), o3(0xE3,0x85,0xAA),
     o3(0xE3,0x85,0xAB), o3(0xE3,0x85,0xAC),
     o3(0xE3,0x85,0xAD), o3(0xE3,0x85,0xAE),
     o3(0xE3,0x85,0xAF), o3(0xE3,0x85,0xB0),
     o3(0xE3,0x85,0xB1), o3(0xE3,0x85,0xB2),
     o3(0xE3,0x85,0xB3), o3(0xE3,0x85,0xB4),
     o3(0xE3,0x85,0xB5), o3(0xE3,0x85,0xB6),
     o3(0xE3,0x85,0xB7), o3(0xE3,0x85,0xB8),
     o3(0xE3,0x85,0xB9), o3(0xE3,0x85,0xBA),
     o3(0xE3,0x85,0xBB), o3(0xE3,0x85,0xBC),
     o3(0xE3,0x85,0xBD), o3(0xE3,0x85,0xBE),
     o3(0xE3,0x85,0xBF), o3(0xE3,0x86,0x80),
     o3(0xE3,0x86,0x81), o3(0xE3,0x86,0x82),
     o3(0xE3,0x86,0x83), o3(0xE3,0x86,0x84),
     o3(0xE3,0x86,0x85), o3(0xE3,0x86,0x86),
     o3(0xE3,0x86,0x87), o3(0xE3,0x86,0x88),
     o3(0xE3,0x86,0x89), o3(0xE3,0x86,0x8A),
     o3(0xE3,0x86,0x8B), o3(0xE3,0x86,0x8C),
     o3(0xE3,0x86,0x8D), o3(0xE3,0x86,0x8E),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_A4 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_A4_infos
};

static const unsigned char
from_EUC_KR_A5_offsets[256] = {
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68,  0,  1,  2,  3,  4,  5,  6,      7,  8,  9, 68, 68, 68, 68, 68,
     10, 11, 12, 13, 14, 15, 16, 17,     18, 19, 68, 68, 68, 68, 68, 68,
     68, 20, 21, 22, 23, 24, 25, 26,     27, 28, 29, 30, 31, 32, 33, 34,
     35, 36, 37, 38, 39, 40, 41, 42,     43, 68, 68, 68, 68, 68, 68, 68,
     68, 44, 45, 46, 47, 48, 49, 50,     51, 52, 53, 54, 55, 56, 57, 58,
     59, 60, 61, 62, 63, 64, 65, 66,     67, 68, 68, 68, 68, 68, 68, 68,
};

static const struct byte_lookup* const
from_EUC_KR_A5_infos[69] = {
     o3(0xE2,0x85,0xB0), o3(0xE2,0x85,0xB1),
     o3(0xE2,0x85,0xB2), o3(0xE2,0x85,0xB3),
     o3(0xE2,0x85,0xB4), o3(0xE2,0x85,0xB5),
     o3(0xE2,0x85,0xB6), o3(0xE2,0x85,0xB7),
     o3(0xE2,0x85,0xB8), o3(0xE2,0x85,0xB9),
     o3(0xE2,0x85,0xA0), o3(0xE2,0x85,0xA1),
     o3(0xE2,0x85,0xA2), o3(0xE2,0x85,0xA3),
     o3(0xE2,0x85,0xA4), o3(0xE2,0x85,0xA5),
     o3(0xE2,0x85,0xA6), o3(0xE2,0x85,0xA7),
     o3(0xE2,0x85,0xA8), o3(0xE2,0x85,0xA9),
          o2(0xCE,0x91),      o2(0xCE,0x92),
          o2(0xCE,0x93),      o2(0xCE,0x94),
          o2(0xCE,0x95),      o2(0xCE,0x96),
          o2(0xCE,0x97),      o2(0xCE,0x98),
          o2(0xCE,0x99),      o2(0xCE,0x9A),
          o2(0xCE,0x9B),      o2(0xCE,0x9C),
          o2(0xCE,0x9D),      o2(0xCE,0x9E),
          o2(0xCE,0x9F),      o2(0xCE,0xA0),
          o2(0xCE,0xA1),      o2(0xCE,0xA3),
          o2(0xCE,0xA4),      o2(0xCE,0xA5),
          o2(0xCE,0xA6),      o2(0xCE,0xA7),
          o2(0xCE,0xA8),      o2(0xCE,0xA9),
          o2(0xCE,0xB1),      o2(0xCE,0xB2),
          o2(0xCE,0xB3),      o2(0xCE,0xB4),
          o2(0xCE,0xB5),      o2(0xCE,0xB6),
          o2(0xCE,0xB7),      o2(0xCE,0xB8),
          o2(0xCE,0xB9),      o2(0xCE,0xBA),
          o2(0xCE,0xBB),      o2(0xCE,0xBC),
          o2(0xCE,0xBD),      o2(0xCE,0xBE),
          o2(0xCE,0xBF),      o2(0xCF,0x80),
          o2(0xCF,0x81),      o2(0xCF,0x83),
          o2(0xCF,0x84),      o2(0xCF,0x85),
          o2(0xCF,0x86),      o2(0xCF,0x87),
          o2(0xCF,0x88),      o2(0xCF,0x89),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_A5 = {
    from_EUC_KR_A5_offsets,
    from_EUC_KR_A5_infos
};

static const unsigned char
from_EUC_KR_A6_offsets[256] = {
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68,  0,  1,  2,  3,  4,  5,  6,      7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,     23, 24, 25, 26, 27, 28, 29, 30,
     31, 32, 33, 34, 35, 36, 37, 38,     39, 40, 41, 42, 43, 44, 45, 46,
     47, 48, 49, 50, 51, 52, 53, 54,     55, 56, 57, 58, 59, 60, 61, 62,
     63, 64, 65, 66, 67, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
     68, 68, 68, 68, 68, 68, 68, 68,     68, 68, 68, 68, 68, 68, 68, 68,
};

static const struct byte_lookup* const
from_EUC_KR_A6_infos[69] = {
     o3(0xE2,0x94,0x80), o3(0xE2,0x94,0x82),
     o3(0xE2,0x94,0x8C), o3(0xE2,0x94,0x90),
     o3(0xE2,0x94,0x98), o3(0xE2,0x94,0x94),
     o3(0xE2,0x94,0x9C), o3(0xE2,0x94,0xAC),
     o3(0xE2,0x94,0xA4), o3(0xE2,0x94,0xB4),
     o3(0xE2,0x94,0xBC), o3(0xE2,0x94,0x81),
     o3(0xE2,0x94,0x83), o3(0xE2,0x94,0x8F),
     o3(0xE2,0x94,0x93), o3(0xE2,0x94,0x9B),
     o3(0xE2,0x94,0x97), o3(0xE2,0x94,0xA3),
     o3(0xE2,0x94,0xB3), o3(0xE2,0x94,0xAB),
     o3(0xE2,0x94,0xBB), o3(0xE2,0x95,0x8B),
     o3(0xE2,0x94,0xA0), o3(0xE2,0x94,0xAF),
     o3(0xE2,0x94,0xA8), o3(0xE2,0x94,0xB7),
     o3(0xE2,0x94,0xBF), o3(0xE2,0x94,0x9D),
     o3(0xE2,0x94,0xB0), o3(0xE2,0x94,0xA5),
     o3(0xE2,0x94,0xB8), o3(0xE2,0x95,0x82),
     o3(0xE2,0x94,0x92), o3(0xE2,0x94,0x91),
     o3(0xE2,0x94,0x9A), o3(0xE2,0x94,0x99),
     o3(0xE2,0x94,0x96), o3(0xE2,0x94,0x95),
     o3(0xE2,0x94,0x8E), o3(0xE2,0x94,0x8D),
     o3(0xE2,0x94,0x9E), o3(0xE2,0x94,0x9F),
     o3(0xE2,0x94,0xA1), o3(0xE2,0x94,0xA2),
     o3(0xE2,0x94,0xA6), o3(0xE2,0x94,0xA7),
     o3(0xE2,0x94,0xA9), o3(0xE2,0x94,0xAA),
     o3(0xE2,0x94,0xAD), o3(0xE2,0x94,0xAE),
     o3(0xE2,0x94,0xB1), o3(0xE2,0x94,0xB2),
     o3(0xE2,0x94,0xB5), o3(0xE2,0x94,0xB6),
     o3(0xE2,0x94,0xB9), o3(0xE2,0x94,0xBA),
     o3(0xE2,0x94,0xBD), o3(0xE2,0x94,0xBE),
     o3(0xE2,0x95,0x80), o3(0xE2,0x95,0x81),
     o3(0xE2,0x95,0x83), o3(0xE2,0x95,0x84),
     o3(0xE2,0x95,0x85), o3(0xE2,0x95,0x86),
     o3(0xE2,0x95,0x87), o3(0xE2,0x95,0x88),
     o3(0xE2,0x95,0x89), o3(0xE2,0x95,0x8A),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_A6 = {
    from_EUC_KR_A6_offsets,
    from_EUC_KR_A6_infos
};

static const unsigned char
from_EUC_KR_A7_offsets[256] = {
     79, 79, 79, 79, 79, 79, 79, 79,     79, 79, 79, 79, 79, 79, 79, 79,
     79, 79, 79, 79, 79, 79, 79, 79,     79, 79, 79, 79, 79, 79, 79, 79,
     79, 79, 79, 79, 79, 79, 79, 79,     79, 79, 79, 79, 79, 79, 79, 79,
     79, 79, 79, 79, 79, 79, 79, 79,     79, 79, 79, 79, 79, 79, 79, 79,
     79, 79, 79, 79, 79, 79, 79, 79,     79, 79, 79, 79, 79, 79, 79, 79,
     79, 79, 79, 79, 79, 79, 79, 79,     79, 79, 79, 79, 79, 79, 79, 79,
     79, 79, 79, 79, 79, 79, 79, 79,     79, 79, 79, 79, 79, 79, 79, 79,
     79, 79, 79, 79, 79, 79, 79, 79,     79, 79, 79, 79, 79, 79, 79, 79,
     79, 79, 79, 79, 79, 79, 79, 79,     79, 79, 79, 79, 79, 79, 79, 79,
     79, 79, 79, 79, 79, 79, 79, 79,     79, 79, 79, 79, 79, 79, 79, 79,
     79,  0,  1,  2,  3,  4,  5,  6,      7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,     23, 24, 25, 26, 27, 28, 29, 30,
     31, 32, 33, 34, 35, 36, 37, 38,     39, 40, 41, 42, 43, 44, 45, 46,
     47, 48, 49, 50, 51, 52, 53, 54,     55, 56, 57, 58, 59, 60, 61, 62,
     63, 64, 65, 66, 67, 68, 69, 70,     71, 72, 73, 74, 75, 76, 77, 78,
     79, 79, 79, 79, 79, 79, 79, 79,     79, 79, 79, 79, 79, 79, 79, 79,
};

static const struct byte_lookup* const
from_EUC_KR_A7_infos[80] = {
     o3(0xE3,0x8E,0x95), o3(0xE3,0x8E,0x96),
     o3(0xE3,0x8E,0x97), o3(0xE2,0x84,0x93),
     o3(0xE3,0x8E,0x98), o3(0xE3,0x8F,0x84),
     o3(0xE3,0x8E,0xA3), o3(0xE3,0x8E,0xA4),
     o3(0xE3,0x8E,0xA5), o3(0xE3,0x8E,0xA6),
     o3(0xE3,0x8E,0x99), o3(0xE3,0x8E,0x9A),
     o3(0xE3,0x8E,0x9B), o3(0xE3,0x8E,0x9C),
     o3(0xE3,0x8E,0x9D), o3(0xE3,0x8E,0x9E),
     o3(0xE3,0x8E,0x9F), o3(0xE3,0x8E,0xA0),
     o3(0xE3,0x8E,0xA1), o3(0xE3,0x8E,0xA2),
     o3(0xE3,0x8F,0x8A), o3(0xE3,0x8E,0x8D),
     o3(0xE3,0x8E,0x8E), o3(0xE3,0x8E,0x8F),
     o3(0xE3,0x8F,0x8F), o3(0xE3,0x8E,0x88),
     o3(0xE3,0x8E,0x89), o3(0xE3,0x8F,0x88),
     o3(0xE3,0x8E,0xA7), o3(0xE3,0x8E,0xA8),
     o3(0xE3,0x8E,0xB0), o3(0xE3,0x8E,0xB1),
     o3(0xE3,0x8E,0xB2), o3(0xE3,0x8E,0xB3),
     o3(0xE3,0x8E,0xB4), o3(0xE3,0x8E,0xB5),
     o3(0xE3,0x8E,0xB6), o3(0xE3,0x8E,0xB7),
     o3(0xE3,0x8E,0xB8), o3(0xE3,0x8E,0xB9),
     o3(0xE3,0x8E,0x80), o3(0xE3,0x8E,0x81),
     o3(0xE3,0x8E,0x82), o3(0xE3,0x8E,0x83),
     o3(0xE3,0x8E,0x84), o3(0xE3,0x8E,0xBA),
     o3(0xE3,0x8E,0xBB), o3(0xE3,0x8E,0xBC),
     o3(0xE3,0x8E,0xBD), o3(0xE3,0x8E,0xBE),
     o3(0xE3,0x8E,0xBF), o3(0xE3,0x8E,0x90),
     o3(0xE3,0x8E,0x91), o3(0xE3,0x8E,0x92),
     o3(0xE3,0x8E,0x93), o3(0xE3,0x8E,0x94),
     o3(0xE2,0x84,0xA6), o3(0xE3,0x8F,0x80),
     o3(0xE3,0x8F,0x81), o3(0xE3,0x8E,0x8A),
     o3(0xE3,0x8E,0x8B), o3(0xE3,0x8E,0x8C),
     o3(0xE3,0x8F,0x96), o3(0xE3,0x8F,0x85),
     o3(0xE3,0x8E,0xAD), o3(0xE3,0x8E,0xAE),
     o3(0xE3,0x8E,0xAF), o3(0xE3,0x8F,0x9B),
     o3(0xE3,0x8E,0xA9), o3(0xE3,0x8E,0xAA),
     o3(0xE3,0x8E,0xAB), o3(0xE3,0x8E,0xAC),
     o3(0xE3,0x8F,0x9D), o3(0xE3,0x8F,0x90),
     o3(0xE3,0x8F,0x93), o3(0xE3,0x8F,0x83),
     o3(0xE3,0x8F,0x89), o3(0xE3,0x8F,0x9C),
     o3(0xE3,0x8F,0x86),              UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_A7 = {
    from_EUC_KR_A7_offsets,
    from_EUC_KR_A7_infos
};

static const unsigned char
from_EUC_KR_A8_offsets[256] = {
     91, 91, 91, 91, 91, 91, 91, 91,     91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91,     91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91,     91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91,     91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91,     91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91,     91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91,     91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91,     91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91,     91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91,     91, 91, 91, 91, 91, 91, 91, 91,
     91,  0,  1,  2,  3, 91,  4, 91,      5,  6,  7,  8,  9, 10, 11, 12,
     91, 13, 14, 15, 16, 17, 18, 19,     20, 21, 22, 23, 24, 25, 26, 27,
     28, 29, 30, 31, 32, 33, 34, 35,     36, 37, 38, 39, 40, 41, 42, 43,
     44, 45, 46, 47, 48, 49, 50, 51,     52, 53, 54, 55, 56, 57, 58, 59,
     60, 61, 62, 63, 64, 65, 66, 67,     68, 69, 70, 71, 72, 73, 74, 75,
     76, 77, 78, 79, 80, 81, 82, 83,     84, 85, 86, 87, 88, 89, 90, 91,
};

static const struct byte_lookup* const
from_EUC_KR_A8_infos[92] = {
          o2(0xC3,0x86),      o2(0xC3,0x90),
          o2(0xC2,0xAA),      o2(0xC4,0xA6),
          o2(0xC4,0xB2),      o2(0xC4,0xBF),
          o2(0xC5,0x81),      o2(0xC3,0x98),
          o2(0xC5,0x92),      o2(0xC2,0xBA),
          o2(0xC3,0x9E),      o2(0xC5,0xA6),
          o2(0xC5,0x8A), o3(0xE3,0x89,0xA0),
     o3(0xE3,0x89,0xA1), o3(0xE3,0x89,0xA2),
     o3(0xE3,0x89,0xA3), o3(0xE3,0x89,0xA4),
     o3(0xE3,0x89,0xA5), o3(0xE3,0x89,0xA6),
     o3(0xE3,0x89,0xA7), o3(0xE3,0x89,0xA8),
     o3(0xE3,0x89,0xA9), o3(0xE3,0x89,0xAA),
     o3(0xE3,0x89,0xAB), o3(0xE3,0x89,0xAC),
     o3(0xE3,0x89,0xAD), o3(0xE3,0x89,0xAE),
     o3(0xE3,0x89,0xAF), o3(0xE3,0x89,0xB0),
     o3(0xE3,0x89,0xB1), o3(0xE3,0x89,0xB2),
     o3(0xE3,0x89,0xB3), o3(0xE3,0x89,0xB4),
     o3(0xE3,0x89,0xB5), o3(0xE3,0x89,0xB6),
     o3(0xE3,0x89,0xB7), o3(0xE3,0x89,0xB8),
     o3(0xE3,0x89,0xB9), o3(0xE3,0x89,0xBA),
     o3(0xE3,0x89,0xBB), o3(0xE2,0x93,0x90),
     o3(0xE2,0x93,0x91), o3(0xE2,0x93,0x92),
     o3(0xE2,0x93,0x93), o3(0xE2,0x93,0x94),
     o3(0xE2,0x93,0x95), o3(0xE2,0x93,0x96),
     o3(0xE2,0x93,0x97), o3(0xE2,0x93,0x98),
     o3(0xE2,0x93,0x99), o3(0xE2,0x93,0x9A),
     o3(0xE2,0x93,0x9B), o3(0xE2,0x93,0x9C),
     o3(0xE2,0x93,0x9D), o3(0xE2,0x93,0x9E),
     o3(0xE2,0x93,0x9F), o3(0xE2,0x93,0xA0),
     o3(0xE2,0x93,0xA1), o3(0xE2,0x93,0xA2),
     o3(0xE2,0x93,0xA3), o3(0xE2,0x93,0xA4),
     o3(0xE2,0x93,0xA5), o3(0xE2,0x93,0xA6),
     o3(0xE2,0x93,0xA7), o3(0xE2,0x93,0xA8),
     o3(0xE2,0x93,0xA9), o3(0xE2,0x91,0xA0),
     o3(0xE2,0x91,0xA1), o3(0xE2,0x91,0xA2),
     o3(0xE2,0x91,0xA3), o3(0xE2,0x91,0xA4),
     o3(0xE2,0x91,0xA5), o3(0xE2,0x91,0xA6),
     o3(0xE2,0x91,0xA7), o3(0xE2,0x91,0xA8),
     o3(0xE2,0x91,0xA9), o3(0xE2,0x91,0xAA),
     o3(0xE2,0x91,0xAB), o3(0xE2,0x91,0xAC),
     o3(0xE2,0x91,0xAD), o3(0xE2,0x91,0xAE),
          o2(0xC2,0xBD), o3(0xE2,0x85,0x93),
     o3(0xE2,0x85,0x94),      o2(0xC2,0xBC),
          o2(0xC2,0xBE), o3(0xE2,0x85,0x9B),
     o3(0xE2,0x85,0x9C), o3(0xE2,0x85,0x9D),
     o3(0xE2,0x85,0x9E),              UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_A8 = {
    from_EUC_KR_A8_offsets,
    from_EUC_KR_A8_infos
};


static const struct byte_lookup* const
from_EUC_KR_A9_infos[95] = {
          o2(0xC3,0xA6),      o2(0xC4,0x91),
          o2(0xC3,0xB0),      o2(0xC4,0xA7),
          o2(0xC4,0xB1),      o2(0xC4,0xB3),
          o2(0xC4,0xB8),      o2(0xC5,0x80),
          o2(0xC5,0x82),      o2(0xC3,0xB8),
          o2(0xC5,0x93),      o2(0xC3,0x9F),
          o2(0xC3,0xBE),      o2(0xC5,0xA7),
          o2(0xC5,0x8B),      o2(0xC5,0x89),
     o3(0xE3,0x88,0x80), o3(0xE3,0x88,0x81),
     o3(0xE3,0x88,0x82), o3(0xE3,0x88,0x83),
     o3(0xE3,0x88,0x84), o3(0xE3,0x88,0x85),
     o3(0xE3,0x88,0x86), o3(0xE3,0x88,0x87),
     o3(0xE3,0x88,0x88), o3(0xE3,0x88,0x89),
     o3(0xE3,0x88,0x8A), o3(0xE3,0x88,0x8B),
     o3(0xE3,0x88,0x8C), o3(0xE3,0x88,0x8D),
     o3(0xE3,0x88,0x8E), o3(0xE3,0x88,0x8F),
     o3(0xE3,0x88,0x90), o3(0xE3,0x88,0x91),
     o3(0xE3,0x88,0x92), o3(0xE3,0x88,0x93),
     o3(0xE3,0x88,0x94), o3(0xE3,0x88,0x95),
     o3(0xE3,0x88,0x96), o3(0xE3,0x88,0x97),
     o3(0xE3,0x88,0x98), o3(0xE3,0x88,0x99),
     o3(0xE3,0x88,0x9A), o3(0xE3,0x88,0x9B),
     o3(0xE2,0x92,0x9C), o3(0xE2,0x92,0x9D),
     o3(0xE2,0x92,0x9E), o3(0xE2,0x92,0x9F),
     o3(0xE2,0x92,0xA0), o3(0xE2,0x92,0xA1),
     o3(0xE2,0x92,0xA2), o3(0xE2,0x92,0xA3),
     o3(0xE2,0x92,0xA4), o3(0xE2,0x92,0xA5),
     o3(0xE2,0x92,0xA6), o3(0xE2,0x92,0xA7),
     o3(0xE2,0x92,0xA8), o3(0xE2,0x92,0xA9),
     o3(0xE2,0x92,0xAA), o3(0xE2,0x92,0xAB),
     o3(0xE2,0x92,0xAC), o3(0xE2,0x92,0xAD),
     o3(0xE2,0x92,0xAE), o3(0xE2,0x92,0xAF),
     o3(0xE2,0x92,0xB0), o3(0xE2,0x92,0xB1),
     o3(0xE2,0x92,0xB2), o3(0xE2,0x92,0xB3),
     o3(0xE2,0x92,0xB4), o3(0xE2,0x92,0xB5),
     o3(0xE2,0x91,0xB4), o3(0xE2,0x91,0xB5),
     o3(0xE2,0x91,0xB6), o3(0xE2,0x91,0xB7),
     o3(0xE2,0x91,0xB8), o3(0xE2,0x91,0xB9),
     o3(0xE2,0x91,0xBA), o3(0xE2,0x91,0xBB),
     o3(0xE2,0x91,0xBC), o3(0xE2,0x91,0xBD),
     o3(0xE2,0x91,0xBE), o3(0xE2,0x91,0xBF),
     o3(0xE2,0x92,0x80), o3(0xE2,0x92,0x81),
     o3(0xE2,0x92,0x82),      o2(0xC2,0xB9),
          o2(0xC2,0xB2),      o2(0xC2,0xB3),
     o3(0xE2,0x81,0xB4), o3(0xE2,0x81,0xBF),
     o3(0xE2,0x82,0x81), o3(0xE2,0x82,0x82),
     o3(0xE2,0x82,0x83), o3(0xE2,0x82,0x84),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_A9 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_A9_infos
};

static const unsigned char
from_EUC_KR_AA_offsets[256] = {
     83, 83, 83, 83, 83, 83, 83, 83,     83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,     83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,     83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,     83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,     83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,     83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,     83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,     83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,     83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,     83, 83, 83, 83, 83, 83, 83, 83,
     83,  0,  1,  2,  3,  4,  5,  6,      7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,     23, 24, 25, 26, 27, 28, 29, 30,
     31, 32, 33, 34, 35, 36, 37, 38,     39, 40, 41, 42, 43, 44, 45, 46,
     47, 48, 49, 50, 51, 52, 53, 54,     55, 56, 57, 58, 59, 60, 61, 62,
     63, 64, 65, 66, 67, 68, 69, 70,     71, 72, 73, 74, 75, 76, 77, 78,
     79, 80, 81, 82, 83, 83, 83, 83,     83, 83, 83, 83, 83, 83, 83, 83,
};

static const struct byte_lookup* const
from_EUC_KR_AA_infos[84] = {
     o3(0xE3,0x81,0x81), o3(0xE3,0x81,0x82),
     o3(0xE3,0x81,0x83), o3(0xE3,0x81,0x84),
     o3(0xE3,0x81,0x85), o3(0xE3,0x81,0x86),
     o3(0xE3,0x81,0x87), o3(0xE3,0x81,0x88),
     o3(0xE3,0x81,0x89), o3(0xE3,0x81,0x8A),
     o3(0xE3,0x81,0x8B), o3(0xE3,0x81,0x8C),
     o3(0xE3,0x81,0x8D), o3(0xE3,0x81,0x8E),
     o3(0xE3,0x81,0x8F), o3(0xE3,0x81,0x90),
     o3(0xE3,0x81,0x91), o3(0xE3,0x81,0x92),
     o3(0xE3,0x81,0x93), o3(0xE3,0x81,0x94),
     o3(0xE3,0x81,0x95), o3(0xE3,0x81,0x96),
     o3(0xE3,0x81,0x97), o3(0xE3,0x81,0x98),
     o3(0xE3,0x81,0x99), o3(0xE3,0x81,0x9A),
     o3(0xE3,0x81,0x9B), o3(0xE3,0x81,0x9C),
     o3(0xE3,0x81,0x9D), o3(0xE3,0x81,0x9E),
     o3(0xE3,0x81,0x9F), o3(0xE3,0x81,0xA0),
     o3(0xE3,0x81,0xA1), o3(0xE3,0x81,0xA2),
     o3(0xE3,0x81,0xA3), o3(0xE3,0x81,0xA4),
     o3(0xE3,0x81,0xA5), o3(0xE3,0x81,0xA6),
     o3(0xE3,0x81,0xA7), o3(0xE3,0x81,0xA8),
     o3(0xE3,0x81,0xA9), o3(0xE3,0x81,0xAA),
     o3(0xE3,0x81,0xAB), o3(0xE3,0x81,0xAC),
     o3(0xE3,0x81,0xAD), o3(0xE3,0x81,0xAE),
     o3(0xE3,0x81,0xAF), o3(0xE3,0x81,0xB0),
     o3(0xE3,0x81,0xB1), o3(0xE3,0x81,0xB2),
     o3(0xE3,0x81,0xB3), o3(0xE3,0x81,0xB4),
     o3(0xE3,0x81,0xB5), o3(0xE3,0x81,0xB6),
     o3(0xE3,0x81,0xB7), o3(0xE3,0x81,0xB8),
     o3(0xE3,0x81,0xB9), o3(0xE3,0x81,0xBA),
     o3(0xE3,0x81,0xBB), o3(0xE3,0x81,0xBC),
     o3(0xE3,0x81,0xBD), o3(0xE3,0x81,0xBE),
     o3(0xE3,0x81,0xBF), o3(0xE3,0x82,0x80),
     o3(0xE3,0x82,0x81), o3(0xE3,0x82,0x82),
     o3(0xE3,0x82,0x83), o3(0xE3,0x82,0x84),
     o3(0xE3,0x82,0x85), o3(0xE3,0x82,0x86),
     o3(0xE3,0x82,0x87), o3(0xE3,0x82,0x88),
     o3(0xE3,0x82,0x89), o3(0xE3,0x82,0x8A),
     o3(0xE3,0x82,0x8B), o3(0xE3,0x82,0x8C),
     o3(0xE3,0x82,0x8D), o3(0xE3,0x82,0x8E),
     o3(0xE3,0x82,0x8F), o3(0xE3,0x82,0x90),
     o3(0xE3,0x82,0x91), o3(0xE3,0x82,0x92),
     o3(0xE3,0x82,0x93),              UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_AA = {
    from_EUC_KR_AA_offsets,
    from_EUC_KR_AA_infos
};

static const unsigned char
from_EUC_KR_AB_offsets[256] = {
     86, 86, 86, 86, 86, 86, 86, 86,     86, 86, 86, 86, 86, 86, 86, 86,
     86, 86, 86, 86, 86, 86, 86, 86,     86, 86, 86, 86, 86, 86, 86, 86,
     86, 86, 86, 86, 86, 86, 86, 86,     86, 86, 86, 86, 86, 86, 86, 86,
     86, 86, 86, 86, 86, 86, 86, 86,     86, 86, 86, 86, 86, 86, 86, 86,
     86, 86, 86, 86, 86, 86, 86, 86,     86, 86, 86, 86, 86, 86, 86, 86,
     86, 86, 86, 86, 86, 86, 86, 86,     86, 86, 86, 86, 86, 86, 86, 86,
     86, 86, 86, 86, 86, 86, 86, 86,     86, 86, 86, 86, 86, 86, 86, 86,
     86, 86, 86, 86, 86, 86, 86, 86,     86, 86, 86, 86, 86, 86, 86, 86,
     86, 86, 86, 86, 86, 86, 86, 86,     86, 86, 86, 86, 86, 86, 86, 86,
     86, 86, 86, 86, 86, 86, 86, 86,     86, 86, 86, 86, 86, 86, 86, 86,
     86,  0,  1,  2,  3,  4,  5,  6,      7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,     23, 24, 25, 26, 27, 28, 29, 30,
     31, 32, 33, 34, 35, 36, 37, 38,     39, 40, 41, 42, 43, 44, 45, 46,
     47, 48, 49, 50, 51, 52, 53, 54,     55, 56, 57, 58, 59, 60, 61, 62,
     63, 64, 65, 66, 67, 68, 69, 70,     71, 72, 73, 74, 75, 76, 77, 78,
     79, 80, 81, 82, 83, 84, 85, 86,     86, 86, 86, 86, 86, 86, 86, 86,
};

static const struct byte_lookup* const
from_EUC_KR_AB_infos[87] = {
     o3(0xE3,0x82,0xA1), o3(0xE3,0x82,0xA2),
     o3(0xE3,0x82,0xA3), o3(0xE3,0x82,0xA4),
     o3(0xE3,0x82,0xA5), o3(0xE3,0x82,0xA6),
     o3(0xE3,0x82,0xA7), o3(0xE3,0x82,0xA8),
     o3(0xE3,0x82,0xA9), o3(0xE3,0x82,0xAA),
     o3(0xE3,0x82,0xAB), o3(0xE3,0x82,0xAC),
     o3(0xE3,0x82,0xAD), o3(0xE3,0x82,0xAE),
     o3(0xE3,0x82,0xAF), o3(0xE3,0x82,0xB0),
     o3(0xE3,0x82,0xB1), o3(0xE3,0x82,0xB2),
     o3(0xE3,0x82,0xB3), o3(0xE3,0x82,0xB4),
     o3(0xE3,0x82,0xB5), o3(0xE3,0x82,0xB6),
     o3(0xE3,0x82,0xB7), o3(0xE3,0x82,0xB8),
     o3(0xE3,0x82,0xB9), o3(0xE3,0x82,0xBA),
     o3(0xE3,0x82,0xBB), o3(0xE3,0x82,0xBC),
     o3(0xE3,0x82,0xBD), o3(0xE3,0x82,0xBE),
     o3(0xE3,0x82,0xBF), o3(0xE3,0x83,0x80),
     o3(0xE3,0x83,0x81), o3(0xE3,0x83,0x82),
     o3(0xE3,0x83,0x83), o3(0xE3,0x83,0x84),
     o3(0xE3,0x83,0x85), o3(0xE3,0x83,0x86),
     o3(0xE3,0x83,0x87), o3(0xE3,0x83,0x88),
     o3(0xE3,0x83,0x89), o3(0xE3,0x83,0x8A),
     o3(0xE3,0x83,0x8B), o3(0xE3,0x83,0x8C),
     o3(0xE3,0x83,0x8D), o3(0xE3,0x83,0x8E),
     o3(0xE3,0x83,0x8F), o3(0xE3,0x83,0x90),
     o3(0xE3,0x83,0x91), o3(0xE3,0x83,0x92),
     o3(0xE3,0x83,0x93), o3(0xE3,0x83,0x94),
     o3(0xE3,0x83,0x95), o3(0xE3,0x83,0x96),
     o3(0xE3,0x83,0x97), o3(0xE3,0x83,0x98),
     o3(0xE3,0x83,0x99), o3(0xE3,0x83,0x9A),
     o3(0xE3,0x83,0x9B), o3(0xE3,0x83,0x9C),
     o3(0xE3,0x83,0x9D), o3(0xE3,0x83,0x9E),
     o3(0xE3,0x83,0x9F), o3(0xE3,0x83,0xA0),
     o3(0xE3,0x83,0xA1), o3(0xE3,0x83,0xA2),
     o3(0xE3,0x83,0xA3), o3(0xE3,0x83,0xA4),
     o3(0xE3,0x83,0xA5), o3(0xE3,0x83,0xA6),
     o3(0xE3,0x83,0xA7), o3(0xE3,0x83,0xA8),
     o3(0xE3,0x83,0xA9), o3(0xE3,0x83,0xAA),
     o3(0xE3,0x83,0xAB), o3(0xE3,0x83,0xAC),
     o3(0xE3,0x83,0xAD), o3(0xE3,0x83,0xAE),
     o3(0xE3,0x83,0xAF), o3(0xE3,0x83,0xB0),
     o3(0xE3,0x83,0xB1), o3(0xE3,0x83,0xB2),
     o3(0xE3,0x83,0xB3), o3(0xE3,0x83,0xB4),
     o3(0xE3,0x83,0xB5), o3(0xE3,0x83,0xB6),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_AB = {
    from_EUC_KR_AB_offsets,
    from_EUC_KR_AB_infos
};

static const unsigned char
from_EUC_KR_AC_offsets[256] = {
     66, 66, 66, 66, 66, 66, 66, 66,     66, 66, 66, 66, 66, 66, 66, 66,
     66, 66, 66, 66, 66, 66, 66, 66,     66, 66, 66, 66, 66, 66, 66, 66,
     66, 66, 66, 66, 66, 66, 66, 66,     66, 66, 66, 66, 66, 66, 66, 66,
     66, 66, 66, 66, 66, 66, 66, 66,     66, 66, 66, 66, 66, 66, 66, 66,
     66, 66, 66, 66, 66, 66, 66, 66,     66, 66, 66, 66, 66, 66, 66, 66,
     66, 66, 66, 66, 66, 66, 66, 66,     66, 66, 66, 66, 66, 66, 66, 66,
     66, 66, 66, 66, 66, 66, 66, 66,     66, 66, 66, 66, 66, 66, 66, 66,
     66, 66, 66, 66, 66, 66, 66, 66,     66, 66, 66, 66, 66, 66, 66, 66,
     66, 66, 66, 66, 66, 66, 66, 66,     66, 66, 66, 66, 66, 66, 66, 66,
     66, 66, 66, 66, 66, 66, 66, 66,     66, 66, 66, 66, 66, 66, 66, 66,
     66,  0,  1,  2,  3,  4,  5,  6,      7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,     23, 24, 25, 26, 27, 28, 29, 30,
     31, 32, 66, 66, 66, 66, 66, 66,     66, 66, 66, 66, 66, 66, 66, 66,
     66, 33, 34, 35, 36, 37, 38, 39,     40, 41, 42, 43, 44, 45, 46, 47,
     48, 49, 50, 51, 52, 53, 54, 55,     56, 57, 58, 59, 60, 61, 62, 63,
     64, 65, 66, 66, 66, 66, 66, 66,     66, 66, 66, 66, 66, 66, 66, 66,
};

static const struct byte_lookup* const
from_EUC_KR_AC_infos[67] = {
          o2(0xD0,0x90),      o2(0xD0,0x91),
          o2(0xD0,0x92),      o2(0xD0,0x93),
          o2(0xD0,0x94),      o2(0xD0,0x95),
          o2(0xD0,0x81),      o2(0xD0,0x96),
          o2(0xD0,0x97),      o2(0xD0,0x98),
          o2(0xD0,0x99),      o2(0xD0,0x9A),
          o2(0xD0,0x9B),      o2(0xD0,0x9C),
          o2(0xD0,0x9D),      o2(0xD0,0x9E),
          o2(0xD0,0x9F),      o2(0xD0,0xA0),
          o2(0xD0,0xA1),      o2(0xD0,0xA2),
          o2(0xD0,0xA3),      o2(0xD0,0xA4),
          o2(0xD0,0xA5),      o2(0xD0,0xA6),
          o2(0xD0,0xA7),      o2(0xD0,0xA8),
          o2(0xD0,0xA9),      o2(0xD0,0xAA),
          o2(0xD0,0xAB),      o2(0xD0,0xAC),
          o2(0xD0,0xAD),      o2(0xD0,0xAE),
          o2(0xD0,0xAF),      o2(0xD0,0xB0),
          o2(0xD0,0xB1),      o2(0xD0,0xB2),
          o2(0xD0,0xB3),      o2(0xD0,0xB4),
          o2(0xD0,0xB5),      o2(0xD1,0x91),
          o2(0xD0,0xB6),      o2(0xD0,0xB7),
          o2(0xD0,0xB8),      o2(0xD0,0xB9),
          o2(0xD0,0xBA),      o2(0xD0,0xBB),
          o2(0xD0,0xBC),      o2(0xD0,0xBD),
          o2(0xD0,0xBE),      o2(0xD0,0xBF),
          o2(0xD1,0x80),      o2(0xD1,0x81),
          o2(0xD1,0x82),      o2(0xD1,0x83),
          o2(0xD1,0x84),      o2(0xD1,0x85),
          o2(0xD1,0x86),      o2(0xD1,0x87),
          o2(0xD1,0x88),      o2(0xD1,0x89),
          o2(0xD1,0x8A),      o2(0xD1,0x8B),
          o2(0xD1,0x8C),      o2(0xD1,0x8D),
          o2(0xD1,0x8E),      o2(0xD1,0x8F),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_AC = {
    from_EUC_KR_AC_offsets,
    from_EUC_KR_AC_infos
};


static const struct byte_lookup* const
from_EUC_KR_B0_infos[95] = {
     o3(0xEA,0xB0,0x80), o3(0xEA,0xB0,0x81),
     o3(0xEA,0xB0,0x84), o3(0xEA,0xB0,0x87),
     o3(0xEA,0xB0,0x88), o3(0xEA,0xB0,0x89),
     o3(0xEA,0xB0,0x8A), o3(0xEA,0xB0,0x90),
     o3(0xEA,0xB0,0x91), o3(0xEA,0xB0,0x92),
     o3(0xEA,0xB0,0x93), o3(0xEA,0xB0,0x94),
     o3(0xEA,0xB0,0x95), o3(0xEA,0xB0,0x96),
     o3(0xEA,0xB0,0x97), o3(0xEA,0xB0,0x99),
     o3(0xEA,0xB0,0x9A), o3(0xEA,0xB0,0x9B),
     o3(0xEA,0xB0,0x9C), o3(0xEA,0xB0,0x9D),
     o3(0xEA,0xB0,0xA0), o3(0xEA,0xB0,0xA4),
     o3(0xEA,0xB0,0xAC), o3(0xEA,0xB0,0xAD),
     o3(0xEA,0xB0,0xAF), o3(0xEA,0xB0,0xB0),
     o3(0xEA,0xB0,0xB1), o3(0xEA,0xB0,0xB8),
     o3(0xEA,0xB0,0xB9), o3(0xEA,0xB0,0xBC),
     o3(0xEA,0xB1,0x80), o3(0xEA,0xB1,0x8B),
     o3(0xEA,0xB1,0x8D), o3(0xEA,0xB1,0x94),
     o3(0xEA,0xB1,0x98), o3(0xEA,0xB1,0x9C),
     o3(0xEA,0xB1,0xB0), o3(0xEA,0xB1,0xB1),
     o3(0xEA,0xB1,0xB4), o3(0xEA,0xB1,0xB7),
     o3(0xEA,0xB1,0xB8), o3(0xEA,0xB1,0xBA),
     o3(0xEA,0xB2,0x80), o3(0xEA,0xB2,0x81),
     o3(0xEA,0xB2,0x83), o3(0xEA,0xB2,0x84),
     o3(0xEA,0xB2,0x85), o3(0xEA,0xB2,0x86),
     o3(0xEA,0xB2,0x89), o3(0xEA,0xB2,0x8A),
     o3(0xEA,0xB2,0x8B), o3(0xEA,0xB2,0x8C),
     o3(0xEA,0xB2,0x90), o3(0xEA,0xB2,0x94),
     o3(0xEA,0xB2,0x9C), o3(0xEA,0xB2,0x9D),
     o3(0xEA,0xB2,0x9F), o3(0xEA,0xB2,0xA0),
     o3(0xEA,0xB2,0xA1), o3(0xEA,0xB2,0xA8),
     o3(0xEA,0xB2,0xA9), o3(0xEA,0xB2,0xAA),
     o3(0xEA,0xB2,0xAC), o3(0xEA,0xB2,0xAF),
     o3(0xEA,0xB2,0xB0), o3(0xEA,0xB2,0xB8),
     o3(0xEA,0xB2,0xB9), o3(0xEA,0xB2,0xBB),
     o3(0xEA,0xB2,0xBC), o3(0xEA,0xB2,0xBD),
     o3(0xEA,0xB3,0x81), o3(0xEA,0xB3,0x84),
     o3(0xEA,0xB3,0x88), o3(0xEA,0xB3,0x8C),
     o3(0xEA,0xB3,0x95), o3(0xEA,0xB3,0x97),
     o3(0xEA,0xB3,0xA0), o3(0xEA,0xB3,0xA1),
     o3(0xEA,0xB3,0xA4), o3(0xEA,0xB3,0xA7),
     o3(0xEA,0xB3,0xA8), o3(0xEA,0xB3,0xAA),
     o3(0xEA,0xB3,0xAC), o3(0xEA,0xB3,0xAF),
     o3(0xEA,0xB3,0xB0), o3(0xEA,0xB3,0xB1),
     o3(0xEA,0xB3,0xB3), o3(0xEA,0xB3,0xB5),
     o3(0xEA,0xB3,0xB6), o3(0xEA,0xB3,0xBC),
     o3(0xEA,0xB3,0xBD), o3(0xEA,0xB4,0x80),
     o3(0xEA,0xB4,0x84), o3(0xEA,0xB4,0x86),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_B0 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_B0_infos
};


static const struct byte_lookup* const
from_EUC_KR_B1_infos[95] = {
     o3(0xEA,0xB4,0x8C), o3(0xEA,0xB4,0x8D),
     o3(0xEA,0xB4,0x8F), o3(0xEA,0xB4,0x91),
     o3(0xEA,0xB4,0x98), o3(0xEA,0xB4,0x9C),
     o3(0xEA,0xB4,0xA0), o3(0xEA,0xB4,0xA9),
     o3(0xEA,0xB4,0xAC), o3(0xEA,0xB4,0xAD),
     o3(0xEA,0xB4,0xB4), o3(0xEA,0xB4,0xB5),
     o3(0xEA,0xB4,0xB8), o3(0xEA,0xB4,0xBC),
     o3(0xEA,0xB5,0x84), o3(0xEA,0xB5,0x85),
     o3(0xEA,0xB5,0x87), o3(0xEA,0xB5,0x89),
     o3(0xEA,0xB5,0x90), o3(0xEA,0xB5,0x94),
     o3(0xEA,0xB5,0x98), o3(0xEA,0xB5,0xA1),
     o3(0xEA,0xB5,0xA3), o3(0xEA,0xB5,0xAC),
     o3(0xEA,0xB5,0xAD), o3(0xEA,0xB5,0xB0),
     o3(0xEA,0xB5,0xB3), o3(0xEA,0xB5,0xB4),
     o3(0xEA,0xB5,0xB5), o3(0xEA,0xB5,0xB6),
     o3(0xEA,0xB5,0xBB), o3(0xEA,0xB5,0xBC),
     o3(0xEA,0xB5,0xBD), o3(0xEA,0xB5,0xBF),
     o3(0xEA,0xB6,0x81), o3(0xEA,0xB6,0x82),
     o3(0xEA,0xB6,0x88), o3(0xEA,0xB6,0x89),
     o3(0xEA,0xB6,0x8C), o3(0xEA,0xB6,0x90),
     o3(0xEA,0xB6,0x9C), o3(0xEA,0xB6,0x9D),
     o3(0xEA,0xB6,0xA4), o3(0xEA,0xB6,0xB7),
     o3(0xEA,0xB7,0x80), o3(0xEA,0xB7,0x81),
     o3(0xEA,0xB7,0x84), o3(0xEA,0xB7,0x88),
     o3(0xEA,0xB7,0x90), o3(0xEA,0xB7,0x91),
     o3(0xEA,0xB7,0x93), o3(0xEA,0xB7,0x9C),
     o3(0xEA,0xB7,0xA0), o3(0xEA,0xB7,0xA4),
     o3(0xEA,0xB7,0xB8), o3(0xEA,0xB7,0xB9),
     o3(0xEA,0xB7,0xBC), o3(0xEA,0xB7,0xBF),
     o3(0xEA,0xB8,0x80), o3(0xEA,0xB8,0x81),
     o3(0xEA,0xB8,0x88), o3(0xEA,0xB8,0x89),
     o3(0xEA,0xB8,0x8B), o3(0xEA,0xB8,0x8D),
     o3(0xEA,0xB8,0x94), o3(0xEA,0xB8,0xB0),
     o3(0xEA,0xB8,0xB1), o3(0xEA,0xB8,0xB4),
     o3(0xEA,0xB8,0xB7), o3(0xEA,0xB8,0xB8),
     o3(0xEA,0xB8,0xBA), o3(0xEA,0xB9,0x80),
     o3(0xEA,0xB9,0x81), o3(0xEA,0xB9,0x83),
     o3(0xEA,0xB9,0x85), o3(0xEA,0xB9,0x86),
     o3(0xEA,0xB9,0x8A), o3(0xEA,0xB9,0x8C),
     o3(0xEA,0xB9,0x8D), o3(0xEA,0xB9,0x8E),
     o3(0xEA,0xB9,0x90), o3(0xEA,0xB9,0x94),
     o3(0xEA,0xB9,0x96), o3(0xEA,0xB9,0x9C),
     o3(0xEA,0xB9,0x9D), o3(0xEA,0xB9,0x9F),
     o3(0xEA,0xB9,0xA0), o3(0xEA,0xB9,0xA1),
     o3(0xEA,0xB9,0xA5), o3(0xEA,0xB9,0xA8),
     o3(0xEA,0xB9,0xA9), o3(0xEA,0xB9,0xAC),
     o3(0xEA,0xB9,0xB0), o3(0xEA,0xB9,0xB8),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_B1 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_B1_infos
};


static const struct byte_lookup* const
from_EUC_KR_B2_infos[95] = {
     o3(0xEA,0xB9,0xB9), o3(0xEA,0xB9,0xBB),
     o3(0xEA,0xB9,0xBC), o3(0xEA,0xB9,0xBD),
     o3(0xEA,0xBA,0x84), o3(0xEA,0xBA,0x85),
     o3(0xEA,0xBA,0x8C), o3(0xEA,0xBA,0xBC),
     o3(0xEA,0xBA,0xBD), o3(0xEA,0xBA,0xBE),
     o3(0xEA,0xBB,0x80), o3(0xEA,0xBB,0x84),
     o3(0xEA,0xBB,0x8C), o3(0xEA,0xBB,0x8D),
     o3(0xEA,0xBB,0x8F), o3(0xEA,0xBB,0x90),
     o3(0xEA,0xBB,0x91), o3(0xEA,0xBB,0x98),
     o3(0xEA,0xBB,0x99), o3(0xEA,0xBB,0x9C),
     o3(0xEA,0xBB,0xA8), o3(0xEA,0xBB,0xAB),
     o3(0xEA,0xBB,0xAD), o3(0xEA,0xBB,0xB4),
     o3(0xEA,0xBB,0xB8), o3(0xEA,0xBB,0xBC),
     o3(0xEA,0xBC,0x87), o3(0xEA,0xBC,0x88),
     o3(0xEA,0xBC,0x8D), o3(0xEA,0xBC,0x90),
     o3(0xEA,0xBC,0xAC), o3(0xEA,0xBC,0xAD),
     o3(0xEA,0xBC,0xB0), o3(0xEA,0xBC,0xB2),
     o3(0xEA,0xBC,0xB4), o3(0xEA,0xBC,0xBC),
     o3(0xEA,0xBC,0xBD), o3(0xEA,0xBC,0xBF),
     o3(0xEA,0xBD,0x81), o3(0xEA,0xBD,0x82),
     o3(0xEA,0xBD,0x83), o3(0xEA,0xBD,0x88),
     o3(0xEA,0xBD,0x89), o3(0xEA,0xBD,0x90),
     o3(0xEA,0xBD,0x9C), o3(0xEA,0xBD,0x9D),
     o3(0xEA,0xBD,0xA4), o3(0xEA,0xBD,0xA5),
     o3(0xEA,0xBD,0xB9), o3(0xEA,0xBE,0x80),
     o3(0xEA,0xBE,0x84), o3(0xEA,0xBE,0x88),
     o3(0xEA,0xBE,0x90), o3(0xEA,0xBE,0x91),
     o3(0xEA,0xBE,0x95), o3(0xEA,0xBE,0x9C),
     o3(0xEA,0xBE,0xB8), o3(0xEA,0xBE,0xB9),
     o3(0xEA,0xBE,0xBC), o3(0xEA,0xBF,0x80),
     o3(0xEA,0xBF,0x87), o3(0xEA,0xBF,0x88),
     o3(0xEA,0xBF,0x89), o3(0xEA,0xBF,0x8B),
     o3(0xEA,0xBF,0x8D), o3(0xEA,0xBF,0x8E),
     o3(0xEA,0xBF,0x94), o3(0xEA,0xBF,0x9C),
     o3(0xEA,0xBF,0xA8), o3(0xEA,0xBF,0xA9),
     o3(0xEA,0xBF,0xB0), o3(0xEA,0xBF,0xB1),
     o3(0xEA,0xBF,0xB4), o3(0xEA,0xBF,0xB8),
     o3(0xEB,0x80,0x80), o3(0xEB,0x80,0x81),
     o3(0xEB,0x80,0x84), o3(0xEB,0x80,0x8C),
     o3(0xEB,0x80,0x90), o3(0xEB,0x80,0x94),
     o3(0xEB,0x80,0x9C), o3(0xEB,0x80,0x9D),
     o3(0xEB,0x80,0xA8), o3(0xEB,0x81,0x84),
     o3(0xEB,0x81,0x85), o3(0xEB,0x81,0x88),
     o3(0xEB,0x81,0x8A), o3(0xEB,0x81,0x8C),
     o3(0xEB,0x81,0x8E), o3(0xEB,0x81,0x93),
     o3(0xEB,0x81,0x94), o3(0xEB,0x81,0x95),
     o3(0xEB,0x81,0x97), o3(0xEB,0x81,0x99),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_B2 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_B2_infos
};


static const struct byte_lookup* const
from_EUC_KR_B3_infos[95] = {
     o3(0xEB,0x81,0x9D), o3(0xEB,0x81,0xBC),
     o3(0xEB,0x81,0xBD), o3(0xEB,0x82,0x80),
     o3(0xEB,0x82,0x84), o3(0xEB,0x82,0x8C),
     o3(0xEB,0x82,0x8D), o3(0xEB,0x82,0x8F),
     o3(0xEB,0x82,0x91), o3(0xEB,0x82,0x98),
     o3(0xEB,0x82,0x99), o3(0xEB,0x82,0x9A),
     o3(0xEB,0x82,0x9C), o3(0xEB,0x82,0x9F),
     o3(0xEB,0x82,0xA0), o3(0xEB,0x82,0xA1),
     o3(0xEB,0x82,0xA2), o3(0xEB,0x82,0xA8),
     o3(0xEB,0x82,0xA9), o3(0xEB,0x82,0xAB),
     o3(0xEB,0x82,0xAC), o3(0xEB,0x82,0xAD),
     o3(0xEB,0x82,0xAE), o3(0xEB,0x82,0xAF),
     o3(0xEB,0x82,0xB1), o3(0xEB,0x82,0xB3),
     o3(0xEB,0x82,0xB4), o3(0xEB,0x82,0xB5),
     o3(0xEB,0x82,0xB8), o3(0xEB,0x82,0xBC),
     o3(0xEB,0x83,0x84), o3(0xEB,0x83,0x85),
     o3(0xEB,0x83,0x87), o3(0xEB,0x83,0x88),
     o3(0xEB,0x83,0x89), o3(0xEB,0x83,0x90),
     o3(0xEB,0x83,0x91), o3(0xEB,0x83,0x94),
     o3(0xEB,0x83,0x98), o3(0xEB,0x83,0xA0),
     o3(0xEB,0x83,0xA5), o3(0xEB,0x84,0x88),
     o3(0xEB,0x84,0x89), o3(0xEB,0x84,0x8B),
     o3(0xEB,0x84,0x8C), o3(0xEB,0x84,0x90),
     o3(0xEB,0x84,0x92), o3(0xEB,0x84,0x93),
     o3(0xEB,0x84,0x98), o3(0xEB,0x84,0x99),
     o3(0xEB,0x84,0x9B), o3(0xEB,0x84,0x9C),
     o3(0xEB,0x84,0x9D), o3(0xEB,0x84,0xA3),
     o3(0xEB,0x84,0xA4), o3(0xEB,0x84,0xA5),
     o3(0xEB,0x84,0xA8), o3(0xEB,0x84,0xAC),
     o3(0xEB,0x84,0xB4), o3(0xEB,0x84,0xB5),
     o3(0xEB,0x84,0xB7), o3(0xEB,0x84,0xB8),
     o3(0xEB,0x84,0xB9), o3(0xEB,0x85,0x80),
     o3(0xEB,0x85,0x81), o3(0xEB,0x85,0x84),
     o3(0xEB,0x85,0x88), o3(0xEB,0x85,0x90),
     o3(0xEB,0x85,0x91), o3(0xEB,0x85,0x94),
     o3(0xEB,0x85,0x95), o3(0xEB,0x85,0x98),
     o3(0xEB,0x85,0x9C), o3(0xEB,0x85,0xA0),
     o3(0xEB,0x85,0xB8), o3(0xEB,0x85,0xB9),
     o3(0xEB,0x85,0xBC), o3(0xEB,0x86,0x80),
     o3(0xEB,0x86,0x82), o3(0xEB,0x86,0x88),
     o3(0xEB,0x86,0x89), o3(0xEB,0x86,0x8B),
     o3(0xEB,0x86,0x8D), o3(0xEB,0x86,0x92),
     o3(0xEB,0x86,0x93), o3(0xEB,0x86,0x94),
     o3(0xEB,0x86,0x98), o3(0xEB,0x86,0x9C),
     o3(0xEB,0x86,0xA8), o3(0xEB,0x87,0x8C),
     o3(0xEB,0x87,0x90), o3(0xEB,0x87,0x94),
     o3(0xEB,0x87,0x9C), o3(0xEB,0x87,0x9D),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_B3 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_B3_infos
};


static const struct byte_lookup* const
from_EUC_KR_B4_infos[95] = {
     o3(0xEB,0x87,0x9F), o3(0xEB,0x87,0xA8),
     o3(0xEB,0x87,0xA9), o3(0xEB,0x87,0xAC),
     o3(0xEB,0x87,0xB0), o3(0xEB,0x87,0xB9),
     o3(0xEB,0x87,0xBB), o3(0xEB,0x87,0xBD),
     o3(0xEB,0x88,0x84), o3(0xEB,0x88,0x85),
     o3(0xEB,0x88,0x88), o3(0xEB,0x88,0x8B),
     o3(0xEB,0x88,0x8C), o3(0xEB,0x88,0x94),
     o3(0xEB,0x88,0x95), o3(0xEB,0x88,0x97),
     o3(0xEB,0x88,0x99), o3(0xEB,0x88,0xA0),
     o3(0xEB,0x88,0xB4), o3(0xEB,0x88,0xBC),
     o3(0xEB,0x89,0x98), o3(0xEB,0x89,0x9C),
     o3(0xEB,0x89,0xA0), o3(0xEB,0x89,0xA8),
     o3(0xEB,0x89,0xA9), o3(0xEB,0x89,0xB4),
     o3(0xEB,0x89,0xB5), o3(0xEB,0x89,0xBC),
     o3(0xEB,0x8A,0x84), o3(0xEB,0x8A,0x85),
     o3(0xEB,0x8A,0x89), o3(0xEB,0x8A,0x90),
     o3(0xEB,0x8A,0x91), o3(0xEB,0x8A,0x94),
     o3(0xEB,0x8A,0x98), o3(0xEB,0x8A,0x99),
     o3(0xEB,0x8A,0x9A), o3(0xEB,0x8A,0xA0),
     o3(0xEB,0x8A,0xA1), o3(0xEB,0x8A,0xA3),
     o3(0xEB,0x8A,0xA5), o3(0xEB,0x8A,0xA6),
     o3(0xEB,0x8A,0xAA), o3(0xEB,0x8A,0xAC),
     o3(0xEB,0x8A,0xB0), o3(0xEB,0x8A,0xB4),
     o3(0xEB,0x8B,0x88), o3(0xEB,0x8B,0x89),
     o3(0xEB,0x8B,0x8C), o3(0xEB,0x8B,0x90),
     o3(0xEB,0x8B,0x92), o3(0xEB,0x8B,0x98),
     o3(0xEB,0x8B,0x99), o3(0xEB,0x8B,0x9B),
     o3(0xEB,0x8B,0x9D), o3(0xEB,0x8B,0xA2),
     o3(0xEB,0x8B,0xA4), o3(0xEB,0x8B,0xA5),
     o3(0xEB,0x8B,0xA6), o3(0xEB,0x8B,0xA8),
     o3(0xEB,0x8B,0xAB), o3(0xEB,0x8B,0xAC),
     o3(0xEB,0x8B,0xAD), o3(0xEB,0x8B,0xAE),
     o3(0xEB,0x8B,0xAF), o3(0xEB,0x8B,0xB3),
     o3(0xEB,0x8B,0xB4), o3(0xEB,0x8B,0xB5),
     o3(0xEB,0x8B,0xB7), o3(0xEB,0x8B,0xB8),
     o3(0xEB,0x8B,0xB9), o3(0xEB,0x8B,0xBA),
     o3(0xEB,0x8B,0xBB), o3(0xEB,0x8B,0xBF),
     o3(0xEB,0x8C,0x80), o3(0xEB,0x8C,0x81),
     o3(0xEB,0x8C,0x84), o3(0xEB,0x8C,0x88),
     o3(0xEB,0x8C,0x90), o3(0xEB,0x8C,0x91),
     o3(0xEB,0x8C,0x93), o3(0xEB,0x8C,0x94),
     o3(0xEB,0x8C,0x95), o3(0xEB,0x8C,0x9C),
     o3(0xEB,0x8D,0x94), o3(0xEB,0x8D,0x95),
     o3(0xEB,0x8D,0x96), o3(0xEB,0x8D,0x98),
     o3(0xEB,0x8D,0x9B), o3(0xEB,0x8D,0x9C),
     o3(0xEB,0x8D,0x9E), o3(0xEB,0x8D,0x9F),
     o3(0xEB,0x8D,0xA4), o3(0xEB,0x8D,0xA5),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_B4 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_B4_infos
};


static const struct byte_lookup* const
from_EUC_KR_B5_infos[95] = {
     o3(0xEB,0x8D,0xA7), o3(0xEB,0x8D,0xA9),
     o3(0xEB,0x8D,0xAB), o3(0xEB,0x8D,0xAE),
     o3(0xEB,0x8D,0xB0), o3(0xEB,0x8D,0xB1),
     o3(0xEB,0x8D,0xB4), o3(0xEB,0x8D,0xB8),
     o3(0xEB,0x8E,0x80), o3(0xEB,0x8E,0x81),
     o3(0xEB,0x8E,0x83), o3(0xEB,0x8E,0x84),
     o3(0xEB,0x8E,0x85), o3(0xEB,0x8E,0x8C),
     o3(0xEB,0x8E,0x90), o3(0xEB,0x8E,0x94),
     o3(0xEB,0x8E,0xA0), o3(0xEB,0x8E,0xA1),
     o3(0xEB,0x8E,0xA8), o3(0xEB,0x8E,0xAC),
     o3(0xEB,0x8F,0x84), o3(0xEB,0x8F,0x85),
     o3(0xEB,0x8F,0x88), o3(0xEB,0x8F,0x8B),
     o3(0xEB,0x8F,0x8C), o3(0xEB,0x8F,0x8E),
     o3(0xEB,0x8F,0x90), o3(0xEB,0x8F,0x94),
     o3(0xEB,0x8F,0x95), o3(0xEB,0x8F,0x97),
     o3(0xEB,0x8F,0x99), o3(0xEB,0x8F,0x9B),
     o3(0xEB,0x8F,0x9D), o3(0xEB,0x8F,0xA0),
     o3(0xEB,0x8F,0xA4), o3(0xEB,0x8F,0xA8),
     o3(0xEB,0x8F,0xBC), o3(0xEB,0x90,0x90),
     o3(0xEB,0x90,0x98), o3(0xEB,0x90,0x9C),
     o3(0xEB,0x90,0xA0), o3(0xEB,0x90,0xA8),
     o3(0xEB,0x90,0xA9), o3(0xEB,0x90,0xAB),
     o3(0xEB,0x90,0xB4), o3(0xEB,0x91,0x90),
     o3(0xEB,0x91,0x91), o3(0xEB,0x91,0x94),
     o3(0xEB,0x91,0x98), o3(0xEB,0x91,0xA0),
     o3(0xEB,0x91,0xA1), o3(0xEB,0x91,0xA3),
     o3(0xEB,0x91,0xA5), o3(0xEB,0x91,0xAC),
     o3(0xEB,0x92,0x80), o3(0xEB,0x92,0x88),
     o3(0xEB,0x92,0x9D), o3(0xEB,0x92,0xA4),
     o3(0xEB,0x92,0xA8), o3(0xEB,0x92,0xAC),
     o3(0xEB,0x92,0xB5), o3(0xEB,0x92,0xB7),
     o3(0xEB,0x92,0xB9), o3(0xEB,0x93,0x80),
     o3(0xEB,0x93,0x84), o3(0xEB,0x93,0x88),
     o3(0xEB,0x93,0x90), o3(0xEB,0x93,0x95),
     o3(0xEB,0x93,0x9C), o3(0xEB,0x93,0x9D),
     o3(0xEB,0x93,0xA0), o3(0xEB,0x93,0xA3),
     o3(0xEB,0x93,0xA4), o3(0xEB,0x93,0xA6),
     o3(0xEB,0x93,0xAC), o3(0xEB,0x93,0xAD),
     o3(0xEB,0x93,0xAF), o3(0xEB,0x93,0xB1),
     o3(0xEB,0x93,0xB8), o3(0xEB,0x94,0x94),
     o3(0xEB,0x94,0x95), o3(0xEB,0x94,0x98),
     o3(0xEB,0x94,0x9B), o3(0xEB,0x94,0x9C),
     o3(0xEB,0x94,0xA4), o3(0xEB,0x94,0xA5),
     o3(0xEB,0x94,0xA7), o3(0xEB,0x94,0xA8),
     o3(0xEB,0x94,0xA9), o3(0xEB,0x94,0xAA),
     o3(0xEB,0x94,0xB0), o3(0xEB,0x94,0xB1),
     o3(0xEB,0x94,0xB4), o3(0xEB,0x94,0xB8),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_B5 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_B5_infos
};


static const struct byte_lookup* const
from_EUC_KR_B6_infos[95] = {
     o3(0xEB,0x95,0x80), o3(0xEB,0x95,0x81),
     o3(0xEB,0x95,0x83), o3(0xEB,0x95,0x84),
     o3(0xEB,0x95,0x85), o3(0xEB,0x95,0x8B),
     o3(0xEB,0x95,0x8C), o3(0xEB,0x95,0x8D),
     o3(0xEB,0x95,0x90), o3(0xEB,0x95,0x94),
     o3(0xEB,0x95,0x9C), o3(0xEB,0x95,0x9D),
     o3(0xEB,0x95,0x9F), o3(0xEB,0x95,0xA0),
     o3(0xEB,0x95,0xA1), o3(0xEB,0x96,0xA0),
     o3(0xEB,0x96,0xA1), o3(0xEB,0x96,0xA4),
     o3(0xEB,0x96,0xA8), o3(0xEB,0x96,0xAA),
     o3(0xEB,0x96,0xAB), o3(0xEB,0x96,0xB0),
     o3(0xEB,0x96,0xB1), o3(0xEB,0x96,0xB3),
     o3(0xEB,0x96,0xB4), o3(0xEB,0x96,0xB5),
     o3(0xEB,0x96,0xBB), o3(0xEB,0x96,0xBC),
     o3(0xEB,0x96,0xBD), o3(0xEB,0x97,0x80),
     o3(0xEB,0x97,0x84), o3(0xEB,0x97,0x8C),
     o3(0xEB,0x97,0x8D), o3(0xEB,0x97,0x8F),
     o3(0xEB,0x97,0x90), o3(0xEB,0x97,0x91),
     o3(0xEB,0x97,0x98), o3(0xEB,0x97,0xAC),
     o3(0xEB,0x98,0x90), o3(0xEB,0x98,0x91),
     o3(0xEB,0x98,0x94), o3(0xEB,0x98,0x98),
     o3(0xEB,0x98,0xA5), o3(0xEB,0x98,0xAC),
     o3(0xEB,0x98,0xB4), o3(0xEB,0x99,0x88),
     o3(0xEB,0x99,0xA4), o3(0xEB,0x99,0xA8),
     o3(0xEB,0x9A,0x9C), o3(0xEB,0x9A,0x9D),
     o3(0xEB,0x9A,0xA0), o3(0xEB,0x9A,0xA4),
     o3(0xEB,0x9A,0xAB), o3(0xEB,0x9A,0xAC),
     o3(0xEB,0x9A,0xB1), o3(0xEB,0x9B,0x94),
     o3(0xEB,0x9B,0xB0), o3(0xEB,0x9B,0xB4),
     o3(0xEB,0x9B,0xB8), o3(0xEB,0x9C,0x80),
     o3(0xEB,0x9C,0x81), o3(0xEB,0x9C,0x85),
     o3(0xEB,0x9C,0xA8), o3(0xEB,0x9C,0xA9),
     o3(0xEB,0x9C,0xAC), o3(0xEB,0x9C,0xAF),
     o3(0xEB,0x9C,0xB0), o3(0xEB,0x9C,0xB8),
     o3(0xEB,0x9C,0xB9), o3(0xEB,0x9C,0xBB),
     o3(0xEB,0x9D,0x84), o3(0xEB,0x9D,0x88),
     o3(0xEB,0x9D,0x8C), o3(0xEB,0x9D,0x94),
     o3(0xEB,0x9D,0x95), o3(0xEB,0x9D,0xA0),
     o3(0xEB,0x9D,0xA4), o3(0xEB,0x9D,0xA8),
     o3(0xEB,0x9D,0xB0), o3(0xEB,0x9D,0xB1),
     o3(0xEB,0x9D,0xB3), o3(0xEB,0x9D,0xB5),
     o3(0xEB,0x9D,0xBC), o3(0xEB,0x9D,0xBD),
     o3(0xEB,0x9E,0x80), o3(0xEB,0x9E,0x84),
     o3(0xEB,0x9E,0x8C), o3(0xEB,0x9E,0x8D),
     o3(0xEB,0x9E,0x8F), o3(0xEB,0x9E,0x90),
     o3(0xEB,0x9E,0x91), o3(0xEB,0x9E,0x92),
     o3(0xEB,0x9E,0x96), o3(0xEB,0x9E,0x97),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_B6 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_B6_infos
};


static const struct byte_lookup* const
from_EUC_KR_B7_infos[95] = {
     o3(0xEB,0x9E,0x98), o3(0xEB,0x9E,0x99),
     o3(0xEB,0x9E,0x9C), o3(0xEB,0x9E,0xA0),
     o3(0xEB,0x9E,0xA8), o3(0xEB,0x9E,0xA9),
     o3(0xEB,0x9E,0xAB), o3(0xEB,0x9E,0xAC),
     o3(0xEB,0x9E,0xAD), o3(0xEB,0x9E,0xB4),
     o3(0xEB,0x9E,0xB5), o3(0xEB,0x9E,0xB8),
     o3(0xEB,0x9F,0x87), o3(0xEB,0x9F,0x89),
     o3(0xEB,0x9F,0xAC), o3(0xEB,0x9F,0xAD),
     o3(0xEB,0x9F,0xB0), o3(0xEB,0x9F,0xB4),
     o3(0xEB,0x9F,0xBC), o3(0xEB,0x9F,0xBD),
     o3(0xEB,0x9F,0xBF), o3(0xEB,0xA0,0x80),
     o3(0xEB,0xA0,0x81), o3(0xEB,0xA0,0x87),
     o3(0xEB,0xA0,0x88), o3(0xEB,0xA0,0x89),
     o3(0xEB,0xA0,0x8C), o3(0xEB,0xA0,0x90),
     o3(0xEB,0xA0,0x98), o3(0xEB,0xA0,0x99),
     o3(0xEB,0xA0,0x9B), o3(0xEB,0xA0,0x9D),
     o3(0xEB,0xA0,0xA4), o3(0xEB,0xA0,0xA5),
     o3(0xEB,0xA0,0xA8), o3(0xEB,0xA0,0xAC),
     o3(0xEB,0xA0,0xB4), o3(0xEB,0xA0,0xB5),
     o3(0xEB,0xA0,0xB7), o3(0xEB,0xA0,0xB8),
     o3(0xEB,0xA0,0xB9), o3(0xEB,0xA1,0x80),
     o3(0xEB,0xA1,0x84), o3(0xEB,0xA1,0x91),
     o3(0xEB,0xA1,0x93), o3(0xEB,0xA1,0x9C),
     o3(0xEB,0xA1,0x9D), o3(0xEB,0xA1,0xA0),
     o3(0xEB,0xA1,0xA4), o3(0xEB,0xA1,0xAC),
     o3(0xEB,0xA1,0xAD), o3(0xEB,0xA1,0xAF),
     o3(0xEB,0xA1,0xB1), o3(0xEB,0xA1,0xB8),
     o3(0xEB,0xA1,0xBC), o3(0xEB,0xA2,0x8D),
     o3(0xEB,0xA2,0xA8), o3(0xEB,0xA2,0xB0),
     o3(0xEB,0xA2,0xB4), o3(0xEB,0xA2,0xB8),
     o3(0xEB,0xA3,0x80), o3(0xEB,0xA3,0x81),
     o3(0xEB,0xA3,0x83), o3(0xEB,0xA3,0x85),
     o3(0xEB,0xA3,0x8C), o3(0xEB,0xA3,0x90),
     o3(0xEB,0xA3,0x94), o3(0xEB,0xA3,0x9D),
     o3(0xEB,0xA3,0x9F), o3(0xEB,0xA3,0xA1),
     o3(0xEB,0xA3,0xA8), o3(0xEB,0xA3,0xA9),
     o3(0xEB,0xA3,0xAC), o3(0xEB,0xA3,0xB0),
     o3(0xEB,0xA3,0xB8), o3(0xEB,0xA3,0xB9),
     o3(0xEB,0xA3,0xBB), o3(0xEB,0xA3,0xBD),
     o3(0xEB,0xA4,0x84), o3(0xEB,0xA4,0x98),
     o3(0xEB,0xA4,0xA0), o3(0xEB,0xA4,0xBC),
     o3(0xEB,0xA4,0xBD), o3(0xEB,0xA5,0x80),
     o3(0xEB,0xA5,0x84), o3(0xEB,0xA5,0x8C),
     o3(0xEB,0xA5,0x8F), o3(0xEB,0xA5,0x91),
     o3(0xEB,0xA5,0x98), o3(0xEB,0xA5,0x99),
     o3(0xEB,0xA5,0x9C), o3(0xEB,0xA5,0xA0),
     o3(0xEB,0xA5,0xA8), o3(0xEB,0xA5,0xA9),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_B7 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_B7_infos
};


static const struct byte_lookup* const
from_EUC_KR_B8_infos[95] = {
     o3(0xEB,0xA5,0xAB), o3(0xEB,0xA5,0xAD),
     o3(0xEB,0xA5,0xB4), o3(0xEB,0xA5,0xB5),
     o3(0xEB,0xA5,0xB8), o3(0xEB,0xA5,0xBC),
     o3(0xEB,0xA6,0x84), o3(0xEB,0xA6,0x85),
     o3(0xEB,0xA6,0x87), o3(0xEB,0xA6,0x89),
     o3(0xEB,0xA6,0x8A), o3(0xEB,0xA6,0x8D),
     o3(0xEB,0xA6,0x8E), o3(0xEB,0xA6,0xAC),
     o3(0xEB,0xA6,0xAD), o3(0xEB,0xA6,0xB0),
     o3(0xEB,0xA6,0xB4), o3(0xEB,0xA6,0xBC),
     o3(0xEB,0xA6,0xBD), o3(0xEB,0xA6,0xBF),
     o3(0xEB,0xA7,0x81), o3(0xEB,0xA7,0x88),
     o3(0xEB,0xA7,0x89), o3(0xEB,0xA7,0x8C),
     o3(0xEB,0xA7,0x8E), o3(0xEB,0xA7,0x8F),
     o3(0xEB,0xA7,0x90), o3(0xEB,0xA7,0x91),
     o3(0xEB,0xA7,0x92), o3(0xEB,0xA7,0x98),
     o3(0xEB,0xA7,0x99), o3(0xEB,0xA7,0x9B),
     o3(0xEB,0xA7,0x9D), o3(0xEB,0xA7,0x9E),
     o3(0xEB,0xA7,0xA1), o3(0xEB,0xA7,0xA3),
     o3(0xEB,0xA7,0xA4), o3(0xEB,0xA7,0xA5),
     o3(0xEB,0xA7,0xA8), o3(0xEB,0xA7,0xAC),
     o3(0xEB,0xA7,0xB4), o3(0xEB,0xA7,0xB5),
     o3(0xEB,0xA7,0xB7), o3(0xEB,0xA7,0xB8),
     o3(0xEB,0xA7,0xB9), o3(0xEB,0xA7,0xBA),
     o3(0xEB,0xA8,0x80), o3(0xEB,0xA8,0x81),
     o3(0xEB,0xA8,0x88), o3(0xEB,0xA8,0x95),
     o3(0xEB,0xA8,0xB8), o3(0xEB,0xA8,0xB9),
     o3(0xEB,0xA8,0xBC), o3(0xEB,0xA9,0x80),
     o3(0xEB,0xA9,0x82), o3(0xEB,0xA9,0x88),
     o3(0xEB,0xA9,0x89), o3(0xEB,0xA9,0x8B),
     o3(0xEB,0xA9,0x8D), o3(0xEB,0xA9,0x8E),
     o3(0xEB,0xA9,0x93), o3(0xEB,0xA9,0x94),
     o3(0xEB,0xA9,0x95), o3(0xEB,0xA9,0x98),
     o3(0xEB,0xA9,0x9C), o3(0xEB,0xA9,0xA4),
     o3(0xEB,0xA9,0xA5), o3(0xEB,0xA9,0xA7),
     o3(0xEB,0xA9,0xA8), o3(0xEB,0xA9,0xA9),
     o3(0xEB,0xA9,0xB0), o3(0xEB,0xA9,0xB1),
     o3(0xEB,0xA9,0xB4), o3(0xEB,0xA9,0xB8),
     o3(0xEB,0xAA,0x83), o3(0xEB,0xAA,0x84),
     o3(0xEB,0xAA,0x85), o3(0xEB,0xAA,0x87),
     o3(0xEB,0xAA,0x8C), o3(0xEB,0xAA,0xA8),
     o3(0xEB,0xAA,0xA9), o3(0xEB,0xAA,0xAB),
     o3(0xEB,0xAA,0xAC), o3(0xEB,0xAA,0xB0),
     o3(0xEB,0xAA,0xB2), o3(0xEB,0xAA,0xB8),
     o3(0xEB,0xAA,0xB9), o3(0xEB,0xAA,0xBB),
     o3(0xEB,0xAA,0xBD), o3(0xEB,0xAB,0x84),
     o3(0xEB,0xAB,0x88), o3(0xEB,0xAB,0x98),
     o3(0xEB,0xAB,0x99), o3(0xEB,0xAB,0xBC),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_B8 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_B8_infos
};


static const struct byte_lookup* const
from_EUC_KR_B9_infos[95] = {
     o3(0xEB,0xAC,0x80), o3(0xEB,0xAC,0x84),
     o3(0xEB,0xAC,0x8D), o3(0xEB,0xAC,0x8F),
     o3(0xEB,0xAC,0x91), o3(0xEB,0xAC,0x98),
     o3(0xEB,0xAC,0x9C), o3(0xEB,0xAC,0xA0),
     o3(0xEB,0xAC,0xA9), o3(0xEB,0xAC,0xAB),
     o3(0xEB,0xAC,0xB4), o3(0xEB,0xAC,0xB5),
     o3(0xEB,0xAC,0xB6), o3(0xEB,0xAC,0xB8),
     o3(0xEB,0xAC,0xBB), o3(0xEB,0xAC,0xBC),
     o3(0xEB,0xAC,0xBD), o3(0xEB,0xAC,0xBE),
     o3(0xEB,0xAD,0x84), o3(0xEB,0xAD,0x85),
     o3(0xEB,0xAD,0x87), o3(0xEB,0xAD,0x89),
     o3(0xEB,0xAD,0x8D), o3(0xEB,0xAD,0x8F),
     o3(0xEB,0xAD,0x90), o3(0xEB,0xAD,0x94),
     o3(0xEB,0xAD,0x98), o3(0xEB,0xAD,0xA1),
     o3(0xEB,0xAD,0xA3), o3(0xEB,0xAD,0xAC),
     o3(0xEB,0xAE,0x88), o3(0xEB,0xAE,0x8C),
     o3(0xEB,0xAE,0x90), o3(0xEB,0xAE,0xA4),
     o3(0xEB,0xAE,0xA8), o3(0xEB,0xAE,0xAC),
     o3(0xEB,0xAE,0xB4), o3(0xEB,0xAE,0xB7),
     o3(0xEB,0xAF,0x80), o3(0xEB,0xAF,0x84),
     o3(0xEB,0xAF,0x88), o3(0xEB,0xAF,0x90),
     o3(0xEB,0xAF,0x93), o3(0xEB,0xAF,0xB8),
     o3(0xEB,0xAF,0xB9), o3(0xEB,0xAF,0xBC),
     o3(0xEB,0xAF,0xBF), o3(0xEB,0xB0,0x80),
     o3(0xEB,0xB0,0x82), o3(0xEB,0xB0,0x88),
     o3(0xEB,0xB0,0x89), o3(0xEB,0xB0,0x8B),
     o3(0xEB,0xB0,0x8C), o3(0xEB,0xB0,0x8D),
     o3(0xEB,0xB0,0x8F), o3(0xEB,0xB0,0x91),
     o3(0xEB,0xB0,0x94), o3(0xEB,0xB0,0x95),
     o3(0xEB,0xB0,0x96), o3(0xEB,0xB0,0x97),
     o3(0xEB,0xB0,0x98), o3(0xEB,0xB0,0x9B),
     o3(0xEB,0xB0,0x9C), o3(0xEB,0xB0,0x9D),
     o3(0xEB,0xB0,0x9E), o3(0xEB,0xB0,0x9F),
     o3(0xEB,0xB0,0xA4), o3(0xEB,0xB0,0xA5),
     o3(0xEB,0xB0,0xA7), o3(0xEB,0xB0,0xA9),
     o3(0xEB,0xB0,0xAD), o3(0xEB,0xB0,0xB0),
     o3(0xEB,0xB0,0xB1), o3(0xEB,0xB0,0xB4),
     o3(0xEB,0xB0,0xB8), o3(0xEB,0xB1,0x80),
     o3(0xEB,0xB1,0x81), o3(0xEB,0xB1,0x83),
     o3(0xEB,0xB1,0x84), o3(0xEB,0xB1,0x85),
     o3(0xEB,0xB1,0x89), o3(0xEB,0xB1,0x8C),
     o3(0xEB,0xB1,0x8D), o3(0xEB,0xB1,0x90),
     o3(0xEB,0xB1,0x9D), o3(0xEB,0xB2,0x84),
     o3(0xEB,0xB2,0x85), o3(0xEB,0xB2,0x88),
     o3(0xEB,0xB2,0x8B), o3(0xEB,0xB2,0x8C),
     o3(0xEB,0xB2,0x8E), o3(0xEB,0xB2,0x94),
     o3(0xEB,0xB2,0x95), o3(0xEB,0xB2,0x97),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_B9 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_B9_infos
};


static const struct byte_lookup* const
from_EUC_KR_BA_infos[95] = {
     o3(0xEB,0xB2,0x99), o3(0xEB,0xB2,0x9A),
     o3(0xEB,0xB2,0xA0), o3(0xEB,0xB2,0xA1),
     o3(0xEB,0xB2,0xA4), o3(0xEB,0xB2,0xA7),
     o3(0xEB,0xB2,0xA8), o3(0xEB,0xB2,0xB0),
     o3(0xEB,0xB2,0xB1), o3(0xEB,0xB2,0xB3),
     o3(0xEB,0xB2,0xB4), o3(0xEB,0xB2,0xB5),
     o3(0xEB,0xB2,0xBC), o3(0xEB,0xB2,0xBD),
     o3(0xEB,0xB3,0x80), o3(0xEB,0xB3,0x84),
     o3(0xEB,0xB3,0x8D), o3(0xEB,0xB3,0x8F),
     o3(0xEB,0xB3,0x90), o3(0xEB,0xB3,0x91),
     o3(0xEB,0xB3,0x95), o3(0xEB,0xB3,0x98),
     o3(0xEB,0xB3,0x9C), o3(0xEB,0xB3,0xB4),
     o3(0xEB,0xB3,0xB5), o3(0xEB,0xB3,0xB6),
     o3(0xEB,0xB3,0xB8), o3(0xEB,0xB3,0xBC),
     o3(0xEB,0xB4,0x84), o3(0xEB,0xB4,0x85),
     o3(0xEB,0xB4,0x87), o3(0xEB,0xB4,0x89),
     o3(0xEB,0xB4,0x90), o3(0xEB,0xB4,0x94),
     o3(0xEB,0xB4,0xA4), o3(0xEB,0xB4,0xAC),
     o3(0xEB,0xB5,0x80), o3(0xEB,0xB5,0x88),
     o3(0xEB,0xB5,0x89), o3(0xEB,0xB5,0x8C),
     o3(0xEB,0xB5,0x90), o3(0xEB,0xB5,0x98),
     o3(0xEB,0xB5,0x99), o3(0xEB,0xB5,0xA4),
     o3(0xEB,0xB5,0xA8), o3(0xEB,0xB6,0x80),
     o3(0xEB,0xB6,0x81), o3(0xEB,0xB6,0x84),
     o3(0xEB,0xB6,0x87), o3(0xEB,0xB6,0x88),
     o3(0xEB,0xB6,0x89), o3(0xEB,0xB6,0x8A),
     o3(0xEB,0xB6,0x90), o3(0xEB,0xB6,0x91),
     o3(0xEB,0xB6,0x93), o3(0xEB,0xB6,0x95),
     o3(0xEB,0xB6,0x99), o3(0xEB,0xB6,0x9A),
     o3(0xEB,0xB6,0x9C), o3(0xEB,0xB6,0xA4),
     o3(0xEB,0xB6,0xB0), o3(0xEB,0xB6,0xB8),
     o3(0xEB,0xB7,0x94), o3(0xEB,0xB7,0x95),
     o3(0xEB,0xB7,0x98), o3(0xEB,0xB7,0x9C),
     o3(0xEB,0xB7,0xA9), o3(0xEB,0xB7,0xB0),
     o3(0xEB,0xB7,0xB4), o3(0xEB,0xB7,0xB8),
     o3(0xEB,0xB8,0x80), o3(0xEB,0xB8,0x83),
     o3(0xEB,0xB8,0x85), o3(0xEB,0xB8,0x8C),
     o3(0xEB,0xB8,0x8D), o3(0xEB,0xB8,0x90),
     o3(0xEB,0xB8,0x94), o3(0xEB,0xB8,0x9C),
     o3(0xEB,0xB8,0x9D), o3(0xEB,0xB8,0x9F),
     o3(0xEB,0xB9,0x84), o3(0xEB,0xB9,0x85),
     o3(0xEB,0xB9,0x88), o3(0xEB,0xB9,0x8C),
     o3(0xEB,0xB9,0x8E), o3(0xEB,0xB9,0x94),
     o3(0xEB,0xB9,0x95), o3(0xEB,0xB9,0x97),
     o3(0xEB,0xB9,0x99), o3(0xEB,0xB9,0x9A),
     o3(0xEB,0xB9,0x9B), o3(0xEB,0xB9,0xA0),
     o3(0xEB,0xB9,0xA1), o3(0xEB,0xB9,0xA4),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_BA = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_BA_infos
};


static const struct byte_lookup* const
from_EUC_KR_BB_infos[95] = {
     o3(0xEB,0xB9,0xA8), o3(0xEB,0xB9,0xAA),
     o3(0xEB,0xB9,0xB0), o3(0xEB,0xB9,0xB1),
     o3(0xEB,0xB9,0xB3), o3(0xEB,0xB9,0xB4),
     o3(0xEB,0xB9,0xB5), o3(0xEB,0xB9,0xBB),
     o3(0xEB,0xB9,0xBC), o3(0xEB,0xB9,0xBD),
     o3(0xEB,0xBA,0x80), o3(0xEB,0xBA,0x84),
     o3(0xEB,0xBA,0x8C), o3(0xEB,0xBA,0x8D),
     o3(0xEB,0xBA,0x8F), o3(0xEB,0xBA,0x90),
     o3(0xEB,0xBA,0x91), o3(0xEB,0xBA,0x98),
     o3(0xEB,0xBA,0x99), o3(0xEB,0xBA,0xA8),
     o3(0xEB,0xBB,0x90), o3(0xEB,0xBB,0x91),
     o3(0xEB,0xBB,0x94), o3(0xEB,0xBB,0x97),
     o3(0xEB,0xBB,0x98), o3(0xEB,0xBB,0xA0),
     o3(0xEB,0xBB,0xA3), o3(0xEB,0xBB,0xA4),
     o3(0xEB,0xBB,0xA5), o3(0xEB,0xBB,0xAC),
     o3(0xEB,0xBC,0x81), o3(0xEB,0xBC,0x88),
     o3(0xEB,0xBC,0x89), o3(0xEB,0xBC,0x98),
     o3(0xEB,0xBC,0x99), o3(0xEB,0xBC,0x9B),
     o3(0xEB,0xBC,0x9C), o3(0xEB,0xBC,0x9D),
     o3(0xEB,0xBD,0x80), o3(0xEB,0xBD,0x81),
     o3(0xEB,0xBD,0x84), o3(0xEB,0xBD,0x88),
     o3(0xEB,0xBD,0x90), o3(0xEB,0xBD,0x91),
     o3(0xEB,0xBD,0x95), o3(0xEB,0xBE,0x94),
     o3(0xEB,0xBE,0xB0), o3(0xEB,0xBF,0x85),
     o3(0xEB,0xBF,0x8C), o3(0xEB,0xBF,0x8D),
     o3(0xEB,0xBF,0x90), o3(0xEB,0xBF,0x94),
     o3(0xEB,0xBF,0x9C), o3(0xEB,0xBF,0x9F),
     o3(0xEB,0xBF,0xA1), o3(0xEC,0x80,0xBC),
     o3(0xEC,0x81,0x91), o3(0xEC,0x81,0x98),
     o3(0xEC,0x81,0x9C), o3(0xEC,0x81,0xA0),
     o3(0xEC,0x81,0xA8), o3(0xEC,0x81,0xA9),
     o3(0xEC,0x82,0x90), o3(0xEC,0x82,0x91),
     o3(0xEC,0x82,0x94), o3(0xEC,0x82,0x98),
     o3(0xEC,0x82,0xA0), o3(0xEC,0x82,0xA1),
     o3(0xEC,0x82,0xA3), o3(0xEC,0x82,0xA5),
     o3(0xEC,0x82,0xAC), o3(0xEC,0x82,0xAD),
     o3(0xEC,0x82,0xAF), o3(0xEC,0x82,0xB0),
     o3(0xEC,0x82,0xB3), o3(0xEC,0x82,0xB4),
     o3(0xEC,0x82,0xB5), o3(0xEC,0x82,0xB6),
     o3(0xEC,0x82,0xBC), o3(0xEC,0x82,0xBD),
     o3(0xEC,0x82,0xBF), o3(0xEC,0x83,0x80),
     o3(0xEC,0x83,0x81), o3(0xEC,0x83,0x85),
     o3(0xEC,0x83,0x88), o3(0xEC,0x83,0x89),
     o3(0xEC,0x83,0x8C), o3(0xEC,0x83,0x90),
     o3(0xEC,0x83,0x98), o3(0xEC,0x83,0x99),
     o3(0xEC,0x83,0x9B), o3(0xEC,0x83,0x9C),
     o3(0xEC,0x83,0x9D), o3(0xEC,0x83,0xA4),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_BB = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_BB_infos
};


static const struct byte_lookup* const
from_EUC_KR_BC_infos[95] = {
     o3(0xEC,0x83,0xA5), o3(0xEC,0x83,0xA8),
     o3(0xEC,0x83,0xAC), o3(0xEC,0x83,0xB4),
     o3(0xEC,0x83,0xB5), o3(0xEC,0x83,0xB7),
     o3(0xEC,0x83,0xB9), o3(0xEC,0x84,0x80),
     o3(0xEC,0x84,0x84), o3(0xEC,0x84,0x88),
     o3(0xEC,0x84,0x90), o3(0xEC,0x84,0x95),
     o3(0xEC,0x84,0x9C), o3(0xEC,0x84,0x9D),
     o3(0xEC,0x84,0x9E), o3(0xEC,0x84,0x9F),
     o3(0xEC,0x84,0xA0), o3(0xEC,0x84,0xA3),
     o3(0xEC,0x84,0xA4), o3(0xEC,0x84,0xA6),
     o3(0xEC,0x84,0xA7), o3(0xEC,0x84,0xAC),
     o3(0xEC,0x84,0xAD), o3(0xEC,0x84,0xAF),
     o3(0xEC,0x84,0xB0), o3(0xEC,0x84,0xB1),
     o3(0xEC,0x84,0xB6), o3(0xEC,0x84,0xB8),
     o3(0xEC,0x84,0xB9), o3(0xEC,0x84,0xBC),
     o3(0xEC,0x85,0x80), o3(0xEC,0x85,0x88),
     o3(0xEC,0x85,0x89), o3(0xEC,0x85,0x8B),
     o3(0xEC,0x85,0x8C), o3(0xEC,0x85,0x8D),
     o3(0xEC,0x85,0x94), o3(0xEC,0x85,0x95),
     o3(0xEC,0x85,0x98), o3(0xEC,0x85,0x9C),
     o3(0xEC,0x85,0xA4), o3(0xEC,0x85,0xA5),
     o3(0xEC,0x85,0xA7), o3(0xEC,0x85,0xA8),
     o3(0xEC,0x85,0xA9), o3(0xEC,0x85,0xB0),
     o3(0xEC,0x85,0xB4), o3(0xEC,0x85,0xB8),
     o3(0xEC,0x86,0x85), o3(0xEC,0x86,0x8C),
     o3(0xEC,0x86,0x8D), o3(0xEC,0x86,0x8E),
     o3(0xEC,0x86,0x90), o3(0xEC,0x86,0x94),
     o3(0xEC,0x86,0x96), o3(0xEC,0x86,0x9C),
     o3(0xEC,0x86,0x9D), o3(0xEC,0x86,0x9F),
     o3(0xEC,0x86,0xA1), o3(0xEC,0x86,0xA5),
     o3(0xEC,0x86,0xA8), o3(0xEC,0x86,0xA9),
     o3(0xEC,0x86,0xAC), o3(0xEC,0x86,0xB0),
     o3(0xEC,0x86,0xBD), o3(0xEC,0x87,0x84),
     o3(0xEC,0x87,0x88), o3(0xEC,0x87,0x8C),
     o3(0xEC,0x87,0x94), o3(0xEC,0x87,0x97),
     o3(0xEC,0x87,0x98), o3(0xEC,0x87,0xA0),
     o3(0xEC,0x87,0xA4), o3(0xEC,0x87,0xA8),
     o3(0xEC,0x87,0xB0), o3(0xEC,0x87,0xB1),
     o3(0xEC,0x87,0xB3), o3(0xEC,0x87,0xBC),
     o3(0xEC,0x87,0xBD), o3(0xEC,0x88,0x80),
     o3(0xEC,0x88,0x84), o3(0xEC,0x88,0x8C),
     o3(0xEC,0x88,0x8D), o3(0xEC,0x88,0x8F),
     o3(0xEC,0x88,0x91), o3(0xEC,0x88,0x98),
     o3(0xEC,0x88,0x99), o3(0xEC,0x88,0x9C),
     o3(0xEC,0x88,0x9F), o3(0xEC,0x88,0xA0),
     o3(0xEC,0x88,0xA8), o3(0xEC,0x88,0xA9),
     o3(0xEC,0x88,0xAB), o3(0xEC,0x88,0xAD),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_BC = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_BC_infos
};


static const struct byte_lookup* const
from_EUC_KR_BD_infos[95] = {
     o3(0xEC,0x88,0xAF), o3(0xEC,0x88,0xB1),
     o3(0xEC,0x88,0xB2), o3(0xEC,0x88,0xB4),
     o3(0xEC,0x89,0x88), o3(0xEC,0x89,0x90),
     o3(0xEC,0x89,0x91), o3(0xEC,0x89,0x94),
     o3(0xEC,0x89,0x98), o3(0xEC,0x89,0xA0),
     o3(0xEC,0x89,0xA5), o3(0xEC,0x89,0xAC),
     o3(0xEC,0x89,0xAD), o3(0xEC,0x89,0xB0),
     o3(0xEC,0x89,0xB4), o3(0xEC,0x89,0xBC),
     o3(0xEC,0x89,0xBD), o3(0xEC,0x89,0xBF),
     o3(0xEC,0x8A,0x81), o3(0xEC,0x8A,0x88),
     o3(0xEC,0x8A,0x89), o3(0xEC,0x8A,0x90),
     o3(0xEC,0x8A,0x98), o3(0xEC,0x8A,0x9B),
     o3(0xEC,0x8A,0x9D), o3(0xEC,0x8A,0xA4),
     o3(0xEC,0x8A,0xA5), o3(0xEC,0x8A,0xA8),
     o3(0xEC,0x8A,0xAC), o3(0xEC,0x8A,0xAD),
     o3(0xEC,0x8A,0xB4), o3(0xEC,0x8A,0xB5),
     o3(0xEC,0x8A,0xB7), o3(0xEC,0x8A,0xB9),
     o3(0xEC,0x8B,0x9C), o3(0xEC,0x8B,0x9D),
     o3(0xEC,0x8B,0xA0), o3(0xEC,0x8B,0xA3),
     o3(0xEC,0x8B,0xA4), o3(0xEC,0x8B,0xAB),
     o3(0xEC,0x8B,0xAC), o3(0xEC,0x8B,0xAD),
     o3(0xEC,0x8B,0xAF), o3(0xEC,0x8B,0xB1),
     o3(0xEC,0x8B,0xB6), o3(0xEC,0x8B,0xB8),
     o3(0xEC,0x8B,0xB9), o3(0xEC,0x8B,0xBB),
     o3(0xEC,0x8B,0xBC), o3(0xEC,0x8C,0x80),
     o3(0xEC,0x8C,0x88), o3(0xEC,0x8C,0x89),
     o3(0xEC,0x8C,0x8C), o3(0xEC,0x8C,0x8D),
     o3(0xEC,0x8C,0x93), o3(0xEC,0x8C,0x94),
     o3(0xEC,0x8C,0x95), o3(0xEC,0x8C,0x98),
     o3(0xEC,0x8C,0x9C), o3(0xEC,0x8C,0xA4),
     o3(0xEC,0x8C,0xA5), o3(0xEC,0x8C,0xA8),
     o3(0xEC,0x8C,0xA9), o3(0xEC,0x8D,0x85),
     o3(0xEC,0x8D,0xA8), o3(0xEC,0x8D,0xA9),
     o3(0xEC,0x8D,0xAC), o3(0xEC,0x8D,0xB0),
     o3(0xEC,0x8D,0xB2), o3(0xEC,0x8D,0xB8),
     o3(0xEC,0x8D,0xB9), o3(0xEC,0x8D,0xBC),
     o3(0xEC,0x8D,0xBD), o3(0xEC,0x8E,0x84),
     o3(0xEC,0x8E,0x88), o3(0xEC,0x8E,0x8C),
     o3(0xEC,0x8F,0x80), o3(0xEC,0x8F,0x98),
     o3(0xEC,0x8F,0x99), o3(0xEC,0x8F,0x9C),
     o3(0xEC,0x8F,0x9F), o3(0xEC,0x8F,0xA0),
     o3(0xEC,0x8F,0xA2), o3(0xEC,0x8F,0xA8),
     o3(0xEC,0x8F,0xA9), o3(0xEC,0x8F,0xAD),
     o3(0xEC,0x8F,0xB4), o3(0xEC,0x8F,0xB5),
     o3(0xEC,0x8F,0xB8), o3(0xEC,0x90,0x88),
     o3(0xEC,0x90,0x90), o3(0xEC,0x90,0xA4),
     o3(0xEC,0x90,0xAC), o3(0xEC,0x90,0xB0),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_BD = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_BD_infos
};


static const struct byte_lookup* const
from_EUC_KR_BE_infos[95] = {
     o3(0xEC,0x90,0xB4), o3(0xEC,0x90,0xBC),
     o3(0xEC,0x90,0xBD), o3(0xEC,0x91,0x88),
     o3(0xEC,0x91,0xA4), o3(0xEC,0x91,0xA5),
     o3(0xEC,0x91,0xA8), o3(0xEC,0x91,0xAC),
     o3(0xEC,0x91,0xB4), o3(0xEC,0x91,0xB5),
     o3(0xEC,0x91,0xB9), o3(0xEC,0x92,0x80),
     o3(0xEC,0x92,0x94), o3(0xEC,0x92,0x9C),
     o3(0xEC,0x92,0xB8), o3(0xEC,0x92,0xBC),
     o3(0xEC,0x93,0xA9), o3(0xEC,0x93,0xB0),
     o3(0xEC,0x93,0xB1), o3(0xEC,0x93,0xB4),
     o3(0xEC,0x93,0xB8), o3(0xEC,0x93,0xBA),
     o3(0xEC,0x93,0xBF), o3(0xEC,0x94,0x80),
     o3(0xEC,0x94,0x81), o3(0xEC,0x94,0x8C),
     o3(0xEC,0x94,0x90), o3(0xEC,0x94,0x94),
     o3(0xEC,0x94,0x9C), o3(0xEC,0x94,0xA8),
     o3(0xEC,0x94,0xA9), o3(0xEC,0x94,0xAC),
     o3(0xEC,0x94,0xB0), o3(0xEC,0x94,0xB8),
     o3(0xEC,0x94,0xB9), o3(0xEC,0x94,0xBB),
     o3(0xEC,0x94,0xBD), o3(0xEC,0x95,0x84),
     o3(0xEC,0x95,0x85), o3(0xEC,0x95,0x88),
     o3(0xEC,0x95,0x89), o3(0xEC,0x95,0x8A),
     o3(0xEC,0x95,0x8C), o3(0xEC,0x95,0x8D),
     o3(0xEC,0x95,0x8E), o3(0xEC,0x95,0x93),
     o3(0xEC,0x95,0x94), o3(0xEC,0x95,0x95),
     o3(0xEC,0x95,0x97), o3(0xEC,0x95,0x98),
     o3(0xEC,0x95,0x99), o3(0xEC,0x95,0x9D),
     o3(0xEC,0x95,0x9E), o3(0xEC,0x95,0xA0),
     o3(0xEC,0x95,0xA1), o3(0xEC,0x95,0xA4),
     o3(0xEC,0x95,0xA8), o3(0xEC,0x95,0xB0),
     o3(0xEC,0x95,0xB1), o3(0xEC,0x95,0xB3),
     o3(0xEC,0x95,0xB4), o3(0xEC,0x95,0xB5),
     o3(0xEC,0x95,0xBC), o3(0xEC,0x95,0xBD),
     o3(0xEC,0x96,0x80), o3(0xEC,0x96,0x84),
     o3(0xEC,0x96,0x87), o3(0xEC,0x96,0x8C),
     o3(0xEC,0x96,0x8D), o3(0xEC,0x96,0x8F),
     o3(0xEC,0x96,0x91), o3(0xEC,0x96,0x95),
     o3(0xEC,0x96,0x97), o3(0xEC,0x96,0x98),
     o3(0xEC,0x96,0x9C), o3(0xEC,0x96,0xA0),
     o3(0xEC,0x96,0xA9), o3(0xEC,0x96,0xB4),
     o3(0xEC,0x96,0xB5), o3(0xEC,0x96,0xB8),
     o3(0xEC,0x96,0xB9), o3(0xEC,0x96,0xBB),
     o3(0xEC,0x96,0xBC), o3(0xEC,0x96,0xBD),
     o3(0xEC,0x96,0xBE), o3(0xEC,0x97,0x84),
     o3(0xEC,0x97,0x85), o3(0xEC,0x97,0x86),
     o3(0xEC,0x97,0x87), o3(0xEC,0x97,0x88),
     o3(0xEC,0x97,0x89), o3(0xEC,0x97,0x8A),
     o3(0xEC,0x97,0x8C), o3(0xEC,0x97,0x8E),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_BE = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_BE_infos
};


static const struct byte_lookup* const
from_EUC_KR_BF_infos[95] = {
     o3(0xEC,0x97,0x90), o3(0xEC,0x97,0x91),
     o3(0xEC,0x97,0x94), o3(0xEC,0x97,0x98),
     o3(0xEC,0x97,0xA0), o3(0xEC,0x97,0xA1),
     o3(0xEC,0x97,0xA3), o3(0xEC,0x97,0xA5),
     o3(0xEC,0x97,0xAC), o3(0xEC,0x97,0xAD),
     o3(0xEC,0x97,0xAE), o3(0xEC,0x97,0xB0),
     o3(0xEC,0x97,0xB4), o3(0xEC,0x97,0xB6),
     o3(0xEC,0x97,0xB7), o3(0xEC,0x97,0xBC),
     o3(0xEC,0x97,0xBD), o3(0xEC,0x97,0xBE),
     o3(0xEC,0x97,0xBF), o3(0xEC,0x98,0x80),
     o3(0xEC,0x98,0x81), o3(0xEC,0x98,0x85),
     o3(0xEC,0x98,0x86), o3(0xEC,0x98,0x87),
     o3(0xEC,0x98,0x88), o3(0xEC,0x98,0x8C),
     o3(0xEC,0x98,0x90), o3(0xEC,0x98,0x98),
     o3(0xEC,0x98,0x99), o3(0xEC,0x98,0x9B),
     o3(0xEC,0x98,0x9C), o3(0xEC,0x98,0xA4),
     o3(0xEC,0x98,0xA5), o3(0xEC,0x98,0xA8),
     o3(0xEC,0x98,0xAC), o3(0xEC,0x98,0xAD),
     o3(0xEC,0x98,0xAE), o3(0xEC,0x98,0xB0),
     o3(0xEC,0x98,0xB3), o3(0xEC,0x98,0xB4),
     o3(0xEC,0x98,0xB5), o3(0xEC,0x98,0xB7),
     o3(0xEC,0x98,0xB9), o3(0xEC,0x98,0xBB),
     o3(0xEC,0x99,0x80), o3(0xEC,0x99,0x81),
     o3(0xEC,0x99,0x84), o3(0xEC,0x99,0x88),
     o3(0xEC,0x99,0x90), o3(0xEC,0x99,0x91),
     o3(0xEC,0x99,0x93), o3(0xEC,0x99,0x94),
     o3(0xEC,0x99,0x95), o3(0xEC,0x99,0x9C),
     o3(0xEC,0x99,0x9D), o3(0xEC,0x99,0xA0),
     o3(0xEC,0x99,0xAC), o3(0xEC,0x99,0xAF),
     o3(0xEC,0x99,0xB1), o3(0xEC,0x99,0xB8),
     o3(0xEC,0x99,0xB9), o3(0xEC,0x99,0xBC),
     o3(0xEC,0x9A,0x80), o3(0xEC,0x9A,0x88),
     o3(0xEC,0x9A,0x89), o3(0xEC,0x9A,0x8B),
     o3(0xEC,0x9A,0x8D), o3(0xEC,0x9A,0x94),
     o3(0xEC,0x9A,0x95), o3(0xEC,0x9A,0x98),
     o3(0xEC,0x9A,0x9C), o3(0xEC,0x9A,0xA4),
     o3(0xEC,0x9A,0xA5), o3(0xEC,0x9A,0xA7),
     o3(0xEC,0x9A,0xA9), o3(0xEC,0x9A,0xB0),
     o3(0xEC,0x9A,0xB1), o3(0xEC,0x9A,0xB4),
     o3(0xEC,0x9A,0xB8), o3(0xEC,0x9A,0xB9),
     o3(0xEC,0x9A,0xBA), o3(0xEC,0x9B,0x80),
     o3(0xEC,0x9B,0x81), o3(0xEC,0x9B,0x83),
     o3(0xEC,0x9B,0x85), o3(0xEC,0x9B,0x8C),
     o3(0xEC,0x9B,0x8D), o3(0xEC,0x9B,0x90),
     o3(0xEC,0x9B,0x94), o3(0xEC,0x9B,0x9C),
     o3(0xEC,0x9B,0x9D), o3(0xEC,0x9B,0xA0),
     o3(0xEC,0x9B,0xA1), o3(0xEC,0x9B,0xA8),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_BF = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_BF_infos
};


static const struct byte_lookup* const
from_EUC_KR_C0_infos[95] = {
     o3(0xEC,0x9B,0xA9), o3(0xEC,0x9B,0xAC),
     o3(0xEC,0x9B,0xB0), o3(0xEC,0x9B,0xB8),
     o3(0xEC,0x9B,0xB9), o3(0xEC,0x9B,0xBD),
     o3(0xEC,0x9C,0x84), o3(0xEC,0x9C,0x85),
     o3(0xEC,0x9C,0x88), o3(0xEC,0x9C,0x8C),
     o3(0xEC,0x9C,0x94), o3(0xEC,0x9C,0x95),
     o3(0xEC,0x9C,0x97), o3(0xEC,0x9C,0x99),
     o3(0xEC,0x9C,0xA0), o3(0xEC,0x9C,0xA1),
     o3(0xEC,0x9C,0xA4), o3(0xEC,0x9C,0xA8),
     o3(0xEC,0x9C,0xB0), o3(0xEC,0x9C,0xB1),
     o3(0xEC,0x9C,0xB3), o3(0xEC,0x9C,0xB5),
     o3(0xEC,0x9C,0xB7), o3(0xEC,0x9C,0xBC),
     o3(0xEC,0x9C,0xBD), o3(0xEC,0x9D,0x80),
     o3(0xEC,0x9D,0x84), o3(0xEC,0x9D,0x8A),
     o3(0xEC,0x9D,0x8C), o3(0xEC,0x9D,0x8D),
     o3(0xEC,0x9D,0x8F), o3(0xEC,0x9D,0x91),
     o3(0xEC,0x9D,0x92), o3(0xEC,0x9D,0x93),
     o3(0xEC,0x9D,0x94), o3(0xEC,0x9D,0x95),
     o3(0xEC,0x9D,0x96), o3(0xEC,0x9D,0x97),
     o3(0xEC,0x9D,0x98), o3(0xEC,0x9D,0x9C),
     o3(0xEC,0x9D,0xA0), o3(0xEC,0x9D,0xA8),
     o3(0xEC,0x9D,0xAB), o3(0xEC,0x9D,0xB4),
     o3(0xEC,0x9D,0xB5), o3(0xEC,0x9D,0xB8),
     o3(0xEC,0x9D,0xBC), o3(0xEC,0x9D,0xBD),
     o3(0xEC,0x9D,0xBE), o3(0xEC,0x9E,0x83),
     o3(0xEC,0x9E,0x84), o3(0xEC,0x9E,0x85),
     o3(0xEC,0x9E,0x87), o3(0xEC,0x9E,0x88),
     o3(0xEC,0x9E,0x89), o3(0xEC,0x9E,0x8A),
     o3(0xEC,0x9E,0x8E), o3(0xEC,0x9E,0x90),
     o3(0xEC,0x9E,0x91), o3(0xEC,0x9E,0x94),
     o3(0xEC,0x9E,0x96), o3(0xEC,0x9E,0x97),
     o3(0xEC,0x9E,0x98), o3(0xEC,0x9E,0x9A),
     o3(0xEC,0x9E,0xA0), o3(0xEC,0x9E,0xA1),
     o3(0xEC,0x9E,0xA3), o3(0xEC,0x9E,0xA4),
     o3(0xEC,0x9E,0xA5), o3(0xEC,0x9E,0xA6),
     o3(0xEC,0x9E,0xAC), o3(0xEC,0x9E,0xAD),
     o3(0xEC,0x9E,0xB0), o3(0xEC,0x9E,0xB4),
     o3(0xEC,0x9E,0xBC), o3(0xEC,0x9E,0xBD),
     o3(0xEC,0x9E,0xBF), o3(0xEC,0x9F,0x80),
     o3(0xEC,0x9F,0x81), o3(0xEC,0x9F,0x88),
     o3(0xEC,0x9F,0x89), o3(0xEC,0x9F,0x8C),
     o3(0xEC,0x9F,0x8E), o3(0xEC,0x9F,0x90),
     o3(0xEC,0x9F,0x98), o3(0xEC,0x9F,0x9D),
     o3(0xEC,0x9F,0xA4), o3(0xEC,0x9F,0xA8),
     o3(0xEC,0x9F,0xAC), o3(0xEC,0xA0,0x80),
     o3(0xEC,0xA0,0x81), o3(0xEC,0xA0,0x84),
     o3(0xEC,0xA0,0x88), o3(0xEC,0xA0,0x8A),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_C0 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_C0_infos
};


static const struct byte_lookup* const
from_EUC_KR_C1_infos[95] = {
     o3(0xEC,0xA0,0x90), o3(0xEC,0xA0,0x91),
     o3(0xEC,0xA0,0x93), o3(0xEC,0xA0,0x95),
     o3(0xEC,0xA0,0x96), o3(0xEC,0xA0,0x9C),
     o3(0xEC,0xA0,0x9D), o3(0xEC,0xA0,0xA0),
     o3(0xEC,0xA0,0xA4), o3(0xEC,0xA0,0xAC),
     o3(0xEC,0xA0,0xAD), o3(0xEC,0xA0,0xAF),
     o3(0xEC,0xA0,0xB1), o3(0xEC,0xA0,0xB8),
     o3(0xEC,0xA0,0xBC), o3(0xEC,0xA1,0x80),
     o3(0xEC,0xA1,0x88), o3(0xEC,0xA1,0x89),
     o3(0xEC,0xA1,0x8C), o3(0xEC,0xA1,0x8D),
     o3(0xEC,0xA1,0x94), o3(0xEC,0xA1,0xB0),
     o3(0xEC,0xA1,0xB1), o3(0xEC,0xA1,0xB4),
     o3(0xEC,0xA1,0xB8), o3(0xEC,0xA1,0xBA),
     o3(0xEC,0xA2,0x80), o3(0xEC,0xA2,0x81),
     o3(0xEC,0xA2,0x83), o3(0xEC,0xA2,0x85),
     o3(0xEC,0xA2,0x86), o3(0xEC,0xA2,0x87),
     o3(0xEC,0xA2,0x8B), o3(0xEC,0xA2,0x8C),
     o3(0xEC,0xA2,0x8D), o3(0xEC,0xA2,0x94),
     o3(0xEC,0xA2,0x9D), o3(0xEC,0xA2,0x9F),
     o3(0xEC,0xA2,0xA1), o3(0xEC,0xA2,0xA8),
     o3(0xEC,0xA2,0xBC), o3(0xEC,0xA2,0xBD),
     o3(0xEC,0xA3,0x84), o3(0xEC,0xA3,0x88),
     o3(0xEC,0xA3,0x8C), o3(0xEC,0xA3,0x94),
     o3(0xEC,0xA3,0x95), o3(0xEC,0xA3,0x97),
     o3(0xEC,0xA3,0x99), o3(0xEC,0xA3,0xA0),
     o3(0xEC,0xA3,0xA1), o3(0xEC,0xA3,0xA4),
     o3(0xEC,0xA3,0xB5), o3(0xEC,0xA3,0xBC),
     o3(0xEC,0xA3,0xBD), o3(0xEC,0xA4,0x80),
     o3(0xEC,0xA4,0x84), o3(0xEC,0xA4,0x85),
     o3(0xEC,0xA4,0x86), o3(0xEC,0xA4,0x8C),
     o3(0xEC,0xA4,0x8D), o3(0xEC,0xA4,0x8F),
     o3(0xEC,0xA4,0x91), o3(0xEC,0xA4,0x98),
     o3(0xEC,0xA4,0xAC), o3(0xEC,0xA4,0xB4),
     o3(0xEC,0xA5,0x90), o3(0xEC,0xA5,0x91),
     o3(0xEC,0xA5,0x94), o3(0xEC,0xA5,0x98),
     o3(0xEC,0xA5,0xA0), o3(0xEC,0xA5,0xA1),
     o3(0xEC,0xA5,0xA3), o3(0xEC,0xA5,0xAC),
     o3(0xEC,0xA5,0xB0), o3(0xEC,0xA5,0xB4),
     o3(0xEC,0xA5,0xBC), o3(0xEC,0xA6,0x88),
     o3(0xEC,0xA6,0x89), o3(0xEC,0xA6,0x8C),
     o3(0xEC,0xA6,0x90), o3(0xEC,0xA6,0x98),
     o3(0xEC,0xA6,0x99), o3(0xEC,0xA6,0x9B),
     o3(0xEC,0xA6,0x9D), o3(0xEC,0xA7,0x80),
     o3(0xEC,0xA7,0x81), o3(0xEC,0xA7,0x84),
     o3(0xEC,0xA7,0x87), o3(0xEC,0xA7,0x88),
     o3(0xEC,0xA7,0x8A), o3(0xEC,0xA7,0x90),
     o3(0xEC,0xA7,0x91), o3(0xEC,0xA7,0x93),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_C1 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_C1_infos
};


static const struct byte_lookup* const
from_EUC_KR_C2_infos[95] = {
     o3(0xEC,0xA7,0x95), o3(0xEC,0xA7,0x96),
     o3(0xEC,0xA7,0x99), o3(0xEC,0xA7,0x9A),
     o3(0xEC,0xA7,0x9C), o3(0xEC,0xA7,0x9D),
     o3(0xEC,0xA7,0xA0), o3(0xEC,0xA7,0xA2),
     o3(0xEC,0xA7,0xA4), o3(0xEC,0xA7,0xA7),
     o3(0xEC,0xA7,0xAC), o3(0xEC,0xA7,0xAD),
     o3(0xEC,0xA7,0xAF), o3(0xEC,0xA7,0xB0),
     o3(0xEC,0xA7,0xB1), o3(0xEC,0xA7,0xB8),
     o3(0xEC,0xA7,0xB9), o3(0xEC,0xA7,0xBC),
     o3(0xEC,0xA8,0x80), o3(0xEC,0xA8,0x88),
     o3(0xEC,0xA8,0x89), o3(0xEC,0xA8,0x8B),
     o3(0xEC,0xA8,0x8C), o3(0xEC,0xA8,0x8D),
     o3(0xEC,0xA8,0x94), o3(0xEC,0xA8,0x98),
     o3(0xEC,0xA8,0xA9), o3(0xEC,0xA9,0x8C),
     o3(0xEC,0xA9,0x8D), o3(0xEC,0xA9,0x90),
     o3(0xEC,0xA9,0x94), o3(0xEC,0xA9,0x9C),
     o3(0xEC,0xA9,0x9D), o3(0xEC,0xA9,0x9F),
     o3(0xEC,0xA9,0xA0), o3(0xEC,0xA9,0xA1),
     o3(0xEC,0xA9,0xA8), o3(0xEC,0xA9,0xBD),
     o3(0xEC,0xAA,0x84), o3(0xEC,0xAA,0x98),
     o3(0xEC,0xAA,0xBC), o3(0xEC,0xAA,0xBD),
     o3(0xEC,0xAB,0x80), o3(0xEC,0xAB,0x84),
     o3(0xEC,0xAB,0x8C), o3(0xEC,0xAB,0x8D),
     o3(0xEC,0xAB,0x8F), o3(0xEC,0xAB,0x91),
     o3(0xEC,0xAB,0x93), o3(0xEC,0xAB,0x98),
     o3(0xEC,0xAB,0x99), o3(0xEC,0xAB,0xA0),
     o3(0xEC,0xAB,0xAC), o3(0xEC,0xAB,0xB4),
     o3(0xEC,0xAC,0x88), o3(0xEC,0xAC,0x90),
     o3(0xEC,0xAC,0x94), o3(0xEC,0xAC,0x98),
     o3(0xEC,0xAC,0xA0), o3(0xEC,0xAC,0xA1),
     o3(0xEC,0xAD,0x81), o3(0xEC,0xAD,0x88),
     o3(0xEC,0xAD,0x89), o3(0xEC,0xAD,0x8C),
     o3(0xEC,0xAD,0x90), o3(0xEC,0xAD,0x98),
     o3(0xEC,0xAD,0x99), o3(0xEC,0xAD,0x9D),
     o3(0xEC,0xAD,0xA4), o3(0xEC,0xAD,0xB8),
     o3(0xEC,0xAD,0xB9), o3(0xEC,0xAE,0x9C),
     o3(0xEC,0xAE,0xB8), o3(0xEC,0xAF,0x94),
     o3(0xEC,0xAF,0xA4), o3(0xEC,0xAF,0xA7),
     o3(0xEC,0xAF,0xA9), o3(0xEC,0xB0,0x8C),
     o3(0xEC,0xB0,0x8D), o3(0xEC,0xB0,0x90),
     o3(0xEC,0xB0,0x94), o3(0xEC,0xB0,0x9C),
     o3(0xEC,0xB0,0x9D), o3(0xEC,0xB0,0xA1),
     o3(0xEC,0xB0,0xA2), o3(0xEC,0xB0,0xA7),
     o3(0xEC,0xB0,0xA8), o3(0xEC,0xB0,0xA9),
     o3(0xEC,0xB0,0xAC), o3(0xEC,0xB0,0xAE),
     o3(0xEC,0xB0,0xB0), o3(0xEC,0xB0,0xB8),
     o3(0xEC,0xB0,0xB9), o3(0xEC,0xB0,0xBB),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_C2 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_C2_infos
};


static const struct byte_lookup* const
from_EUC_KR_C3_infos[95] = {
     o3(0xEC,0xB0,0xBC), o3(0xEC,0xB0,0xBD),
     o3(0xEC,0xB0,0xBE), o3(0xEC,0xB1,0x84),
     o3(0xEC,0xB1,0x85), o3(0xEC,0xB1,0x88),
     o3(0xEC,0xB1,0x8C), o3(0xEC,0xB1,0x94),
     o3(0xEC,0xB1,0x95), o3(0xEC,0xB1,0x97),
     o3(0xEC,0xB1,0x98), o3(0xEC,0xB1,0x99),
     o3(0xEC,0xB1,0xA0), o3(0xEC,0xB1,0xA4),
     o3(0xEC,0xB1,0xA6), o3(0xEC,0xB1,0xA8),
     o3(0xEC,0xB1,0xB0), o3(0xEC,0xB1,0xB5),
     o3(0xEC,0xB2,0x98), o3(0xEC,0xB2,0x99),
     o3(0xEC,0xB2,0x9C), o3(0xEC,0xB2,0xA0),
     o3(0xEC,0xB2,0xA8), o3(0xEC,0xB2,0xA9),
     o3(0xEC,0xB2,0xAB), o3(0xEC,0xB2,0xAC),
     o3(0xEC,0xB2,0xAD), o3(0xEC,0xB2,0xB4),
     o3(0xEC,0xB2,0xB5), o3(0xEC,0xB2,0xB8),
     o3(0xEC,0xB2,0xBC), o3(0xEC,0xB3,0x84),
     o3(0xEC,0xB3,0x85), o3(0xEC,0xB3,0x87),
     o3(0xEC,0xB3,0x89), o3(0xEC,0xB3,0x90),
     o3(0xEC,0xB3,0x94), o3(0xEC,0xB3,0xA4),
     o3(0xEC,0xB3,0xAC), o3(0xEC,0xB3,0xB0),
     o3(0xEC,0xB4,0x81), o3(0xEC,0xB4,0x88),
     o3(0xEC,0xB4,0x89), o3(0xEC,0xB4,0x8C),
     o3(0xEC,0xB4,0x90), o3(0xEC,0xB4,0x98),
     o3(0xEC,0xB4,0x99), o3(0xEC,0xB4,0x9B),
     o3(0xEC,0xB4,0x9D), o3(0xEC,0xB4,0xA4),
     o3(0xEC,0xB4,0xA8), o3(0xEC,0xB4,0xAC),
     o3(0xEC,0xB4,0xB9), o3(0xEC,0xB5,0x9C),
     o3(0xEC,0xB5,0xA0), o3(0xEC,0xB5,0xA4),
     o3(0xEC,0xB5,0xAC), o3(0xEC,0xB5,0xAD),
     o3(0xEC,0xB5,0xAF), o3(0xEC,0xB5,0xB1),
     o3(0xEC,0xB5,0xB8), o3(0xEC,0xB6,0x88),
     o3(0xEC,0xB6,0x94), o3(0xEC,0xB6,0x95),
     o3(0xEC,0xB6,0x98), o3(0xEC,0xB6,0x9C),
     o3(0xEC,0xB6,0xA4), o3(0xEC,0xB6,0xA5),
     o3(0xEC,0xB6,0xA7), o3(0xEC,0xB6,0xA9),
     o3(0xEC,0xB6,0xB0), o3(0xEC,0xB7,0x84),
     o3(0xEC,0xB7,0x8C), o3(0xEC,0xB7,0x90),
     o3(0xEC,0xB7,0xA8), o3(0xEC,0xB7,0xAC),
     o3(0xEC,0xB7,0xB0), o3(0xEC,0xB7,0xB8),
     o3(0xEC,0xB7,0xB9), o3(0xEC,0xB7,0xBB),
     o3(0xEC,0xB7,0xBD), o3(0xEC,0xB8,0x84),
     o3(0xEC,0xB8,0x88), o3(0xEC,0xB8,0x8C),
     o3(0xEC,0xB8,0x94), o3(0xEC,0xB8,0x99),
     o3(0xEC,0xB8,0xA0), o3(0xEC,0xB8,0xA1),
     o3(0xEC,0xB8,0xA4), o3(0xEC,0xB8,0xA8),
     o3(0xEC,0xB8,0xB0), o3(0xEC,0xB8,0xB1),
     o3(0xEC,0xB8,0xB3), o3(0xEC,0xB8,0xB5),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_C3 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_C3_infos
};


static const struct byte_lookup* const
from_EUC_KR_C4_infos[95] = {
     o3(0xEC,0xB9,0x98), o3(0xEC,0xB9,0x99),
     o3(0xEC,0xB9,0x9C), o3(0xEC,0xB9,0x9F),
     o3(0xEC,0xB9,0xA0), o3(0xEC,0xB9,0xA1),
     o3(0xEC,0xB9,0xA8), o3(0xEC,0xB9,0xA9),
     o3(0xEC,0xB9,0xAB), o3(0xEC,0xB9,0xAD),
     o3(0xEC,0xB9,0xB4), o3(0xEC,0xB9,0xB5),
     o3(0xEC,0xB9,0xB8), o3(0xEC,0xB9,0xBC),
     o3(0xEC,0xBA,0x84), o3(0xEC,0xBA,0x85),
     o3(0xEC,0xBA,0x87), o3(0xEC,0xBA,0x89),
     o3(0xEC,0xBA,0x90), o3(0xEC,0xBA,0x91),
     o3(0xEC,0xBA,0x94), o3(0xEC,0xBA,0x98),
     o3(0xEC,0xBA,0xA0), o3(0xEC,0xBA,0xA1),
     o3(0xEC,0xBA,0xA3), o3(0xEC,0xBA,0xA4),
     o3(0xEC,0xBA,0xA5), o3(0xEC,0xBA,0xAC),
     o3(0xEC,0xBA,0xAD), o3(0xEC,0xBB,0x81),
     o3(0xEC,0xBB,0xA4), o3(0xEC,0xBB,0xA5),
     o3(0xEC,0xBB,0xA8), o3(0xEC,0xBB,0xAB),
     o3(0xEC,0xBB,0xAC), o3(0xEC,0xBB,0xB4),
     o3(0xEC,0xBB,0xB5), o3(0xEC,0xBB,0xB7),
     o3(0xEC,0xBB,0xB8), o3(0xEC,0xBB,0xB9),
     o3(0xEC,0xBC,0x80), o3(0xEC,0xBC,0x81),
     o3(0xEC,0xBC,0x84), o3(0xEC,0xBC,0x88),
     o3(0xEC,0xBC,0x90), o3(0xEC,0xBC,0x91),
     o3(0xEC,0xBC,0x93), o3(0xEC,0xBC,0x95),
     o3(0xEC,0xBC,0x9C), o3(0xEC,0xBC,0xA0),
     o3(0xEC,0xBC,0xA4), o3(0xEC,0xBC,0xAC),
     o3(0xEC,0xBC,0xAD), o3(0xEC,0xBC,0xAF),
     o3(0xEC,0xBC,0xB0), o3(0xEC,0xBC,0xB1),
     o3(0xEC,0xBC,0xB8), o3(0xEC,0xBD,0x94),
     o3(0xEC,0xBD,0x95), o3(0xEC,0xBD,0x98),
     o3(0xEC,0xBD,0x9C), o3(0xEC,0xBD,0xA4),
     o3(0xEC,0xBD,0xA5), o3(0xEC,0xBD,0xA7),
     o3(0xEC,0xBD,0xA9), o3(0xEC,0xBD,0xB0),
     o3(0xEC,0xBD,0xB1), o3(0xEC,0xBD,0xB4),
     o3(0xEC,0xBD,0xB8), o3(0xEC,0xBE,0x80),
     o3(0xEC,0xBE,0x85), o3(0xEC,0xBE,0x8C),
     o3(0xEC,0xBE,0xA1), o3(0xEC,0xBE,0xA8),
     o3(0xEC,0xBE,0xB0), o3(0xEC,0xBF,0x84),
     o3(0xEC,0xBF,0xA0), o3(0xEC,0xBF,0xA1),
     o3(0xEC,0xBF,0xA4), o3(0xEC,0xBF,0xA8),
     o3(0xEC,0xBF,0xB0), o3(0xEC,0xBF,0xB1),
     o3(0xEC,0xBF,0xB3), o3(0xEC,0xBF,0xB5),
     o3(0xEC,0xBF,0xBC), o3(0xED,0x80,0x80),
     o3(0xED,0x80,0x84), o3(0xED,0x80,0x91),
     o3(0xED,0x80,0x98), o3(0xED,0x80,0xAD),
     o3(0xED,0x80,0xB4), o3(0xED,0x80,0xB5),
     o3(0xED,0x80,0xB8), o3(0xED,0x80,0xBC),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_C4 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_C4_infos
};


static const struct byte_lookup* const
from_EUC_KR_C5_infos[95] = {
     o3(0xED,0x81,0x84), o3(0xED,0x81,0x85),
     o3(0xED,0x81,0x87), o3(0xED,0x81,0x89),
     o3(0xED,0x81,0x90), o3(0xED,0x81,0x94),
     o3(0xED,0x81,0x98), o3(0xED,0x81,0xA0),
     o3(0xED,0x81,0xAC), o3(0xED,0x81,0xAD),
     o3(0xED,0x81,0xB0), o3(0xED,0x81,0xB4),
     o3(0xED,0x81,0xBC), o3(0xED,0x81,0xBD),
     o3(0xED,0x82,0x81), o3(0xED,0x82,0xA4),
     o3(0xED,0x82,0xA5), o3(0xED,0x82,0xA8),
     o3(0xED,0x82,0xAC), o3(0xED,0x82,0xB4),
     o3(0xED,0x82,0xB5), o3(0xED,0x82,0xB7),
     o3(0xED,0x82,0xB9), o3(0xED,0x83,0x80),
     o3(0xED,0x83,0x81), o3(0xED,0x83,0x84),
     o3(0xED,0x83,0x88), o3(0xED,0x83,0x89),
     o3(0xED,0x83,0x90), o3(0xED,0x83,0x91),
     o3(0xED,0x83,0x93), o3(0xED,0x83,0x94),
     o3(0xED,0x83,0x95), o3(0xED,0x83,0x9C),
     o3(0xED,0x83,0x9D), o3(0xED,0x83,0xA0),
     o3(0xED,0x83,0xA4), o3(0xED,0x83,0xAC),
     o3(0xED,0x83,0xAD), o3(0xED,0x83,0xAF),
     o3(0xED,0x83,0xB0), o3(0xED,0x83,0xB1),
     o3(0xED,0x83,0xB8), o3(0xED,0x84,0x8D),
     o3(0xED,0x84,0xB0), o3(0xED,0x84,0xB1),
     o3(0xED,0x84,0xB4), o3(0xED,0x84,0xB8),
     o3(0xED,0x84,0xBA), o3(0xED,0x85,0x80),
     o3(0xED,0x85,0x81), o3(0xED,0x85,0x83),
     o3(0xED,0x85,0x84), o3(0xED,0x85,0x85),
     o3(0xED,0x85,0x8C), o3(0xED,0x85,0x8D),
     o3(0xED,0x85,0x90), o3(0xED,0x85,0x94),
     o3(0xED,0x85,0x9C), o3(0xED,0x85,0x9D),
     o3(0xED,0x85,0x9F), o3(0xED,0x85,0xA1),
     o3(0xED,0x85,0xA8), o3(0xED,0x85,0xAC),
     o3(0xED,0x85,0xBC), o3(0xED,0x86,0x84),
     o3(0xED,0x86,0x88), o3(0xED,0x86,0xA0),
     o3(0xED,0x86,0xA1), o3(0xED,0x86,0xA4),
     o3(0xED,0x86,0xA8), o3(0xED,0x86,0xB0),
     o3(0xED,0x86,0xB1), o3(0xED,0x86,0xB3),
     o3(0xED,0x86,0xB5), o3(0xED,0x86,0xBA),
     o3(0xED,0x86,0xBC), o3(0xED,0x87,0x80),
     o3(0xED,0x87,0x98), o3(0xED,0x87,0xB4),
     o3(0xED,0x87,0xB8), o3(0xED,0x88,0x87),
     o3(0xED,0x88,0x89), o3(0xED,0x88,0x90),
     o3(0xED,0x88,0xAC), o3(0xED,0x88,0xAD),
     o3(0xED,0x88,0xB0), o3(0xED,0x88,0xB4),
     o3(0xED,0x88,0xBC), o3(0xED,0x88,0xBD),
     o3(0xED,0x88,0xBF), o3(0xED,0x89,0x81),
     o3(0xED,0x89,0x88), o3(0xED,0x89,0x9C),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_C5 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_C5_infos
};


static const struct byte_lookup* const
from_EUC_KR_C6_infos[95] = {
     o3(0xED,0x89,0xA4), o3(0xED,0x8A,0x80),
     o3(0xED,0x8A,0x81), o3(0xED,0x8A,0x84),
     o3(0xED,0x8A,0x88), o3(0xED,0x8A,0x90),
     o3(0xED,0x8A,0x91), o3(0xED,0x8A,0x95),
     o3(0xED,0x8A,0x9C), o3(0xED,0x8A,0xA0),
     o3(0xED,0x8A,0xA4), o3(0xED,0x8A,0xAC),
     o3(0xED,0x8A,0xB1), o3(0xED,0x8A,0xB8),
     o3(0xED,0x8A,0xB9), o3(0xED,0x8A,0xBC),
     o3(0xED,0x8A,0xBF), o3(0xED,0x8B,0x80),
     o3(0xED,0x8B,0x82), o3(0xED,0x8B,0x88),
     o3(0xED,0x8B,0x89), o3(0xED,0x8B,0x8B),
     o3(0xED,0x8B,0x94), o3(0xED,0x8B,0x98),
     o3(0xED,0x8B,0x9C), o3(0xED,0x8B,0xA4),
     o3(0xED,0x8B,0xA5), o3(0xED,0x8B,0xB0),
     o3(0xED,0x8B,0xB1), o3(0xED,0x8B,0xB4),
     o3(0xED,0x8B,0xB8), o3(0xED,0x8C,0x80),
     o3(0xED,0x8C,0x81), o3(0xED,0x8C,0x83),
     o3(0xED,0x8C,0x85), o3(0xED,0x8C,0x8C),
     o3(0xED,0x8C,0x8D), o3(0xED,0x8C,0x8E),
     o3(0xED,0x8C,0x90), o3(0xED,0x8C,0x94),
     o3(0xED,0x8C,0x96), o3(0xED,0x8C,0x9C),
     o3(0xED,0x8C,0x9D), o3(0xED,0x8C,0x9F),
     o3(0xED,0x8C,0xA0), o3(0xED,0x8C,0xA1),
     o3(0xED,0x8C,0xA5), o3(0xED,0x8C,0xA8),
     o3(0xED,0x8C,0xA9), o3(0xED,0x8C,0xAC),
     o3(0xED,0x8C,0xB0), o3(0xED,0x8C,0xB8),
     o3(0xED,0x8C,0xB9), o3(0xED,0x8C,0xBB),
     o3(0xED,0x8C,0xBC), o3(0xED,0x8C,0xBD),
     o3(0xED,0x8D,0x84), o3(0xED,0x8D,0x85),
     o3(0xED,0x8D,0xBC), o3(0xED,0x8D,0xBD),
     o3(0xED,0x8E,0x80), o3(0xED,0x8E,0x84),
     o3(0xED,0x8E,0x8C), o3(0xED,0x8E,0x8D),
     o3(0xED,0x8E,0x8F), o3(0xED,0x8E,0x90),
     o3(0xED,0x8E,0x91), o3(0xED,0x8E,0x98),
     o3(0xED,0x8E,0x99), o3(0xED,0x8E,0x9C),
     o3(0xED,0x8E,0xA0), o3(0xED,0x8E,0xA8),
     o3(0xED,0x8E,0xA9), o3(0xED,0x8E,0xAB),
     o3(0xED,0x8E,0xAD), o3(0xED,0x8E,0xB4),
     o3(0xED,0x8E,0xB8), o3(0xED,0x8E,0xBC),
     o3(0xED,0x8F,0x84), o3(0xED,0x8F,0x85),
     o3(0xED,0x8F,0x88), o3(0xED,0x8F,0x89),
     o3(0xED,0x8F,0x90), o3(0xED,0x8F,0x98),
     o3(0xED,0x8F,0xA1), o3(0xED,0x8F,0xA3),
     o3(0xED,0x8F,0xAC), o3(0xED,0x8F,0xAD),
     o3(0xED,0x8F,0xB0), o3(0xED,0x8F,0xB4),
     o3(0xED,0x8F,0xBC), o3(0xED,0x8F,0xBD),
     o3(0xED,0x8F,0xBF), o3(0xED,0x90,0x81),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_C6 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_C6_infos
};


static const struct byte_lookup* const
from_EUC_KR_C7_infos[95] = {
     o3(0xED,0x90,0x88), o3(0xED,0x90,0x9D),
     o3(0xED,0x91,0x80), o3(0xED,0x91,0x84),
     o3(0xED,0x91,0x9C), o3(0xED,0x91,0xA0),
     o3(0xED,0x91,0xA4), o3(0xED,0x91,0xAD),
     o3(0xED,0x91,0xAF), o3(0xED,0x91,0xB8),
     o3(0xED,0x91,0xB9), o3(0xED,0x91,0xBC),
     o3(0xED,0x91,0xBF), o3(0xED,0x92,0x80),
     o3(0xED,0x92,0x82), o3(0xED,0x92,0x88),
     o3(0xED,0x92,0x89), o3(0xED,0x92,0x8B),
     o3(0xED,0x92,0x8D), o3(0xED,0x92,0x94),
     o3(0xED,0x92,0xA9), o3(0xED,0x93,0x8C),
     o3(0xED,0x93,0x90), o3(0xED,0x93,0x94),
     o3(0xED,0x93,0x9C), o3(0xED,0x93,0x9F),
     o3(0xED,0x93,0xA8), o3(0xED,0x93,0xAC),
     o3(0xED,0x93,0xB0), o3(0xED,0x93,0xB8),
     o3(0xED,0x93,0xBB), o3(0xED,0x93,0xBD),
     o3(0xED,0x94,0x84), o3(0xED,0x94,0x88),
     o3(0xED,0x94,0x8C), o3(0xED,0x94,0x94),
     o3(0xED,0x94,0x95), o3(0xED,0x94,0x97),
     o3(0xED,0x94,0xBC), o3(0xED,0x94,0xBD),
     o3(0xED,0x95,0x80), o3(0xED,0x95,0x84),
     o3(0xED,0x95,0x8C), o3(0xED,0x95,0x8D),
     o3(0xED,0x95,0x8F), o3(0xED,0x95,0x91),
     o3(0xED,0x95,0x98), o3(0xED,0x95,0x99),
     o3(0xED,0x95,0x9C), o3(0xED,0x95,0xA0),
     o3(0xED,0x95,0xA5), o3(0xED,0x95,0xA8),
     o3(0xED,0x95,0xA9), o3(0xED,0x95,0xAB),
     o3(0xED,0x95,0xAD), o3(0xED,0x95,0xB4),
     o3(0xED,0x95,0xB5), o3(0xED,0x95,0xB8),
     o3(0xED,0x95,0xBC), o3(0xED,0x96,0x84),
     o3(0xED,0x96,0x85), o3(0xED,0x96,0x87),
     o3(0xED,0x96,0x88), o3(0xED,0x96,0x89),
     o3(0xED,0x96,0x90), o3(0xED,0x96,0xA5),
     o3(0xED,0x97,0x88), o3(0xED,0x97,0x89),
     o3(0xED,0x97,0x8C), o3(0xED,0x97,0x90),
     o3(0xED,0x97,0x92), o3(0xED,0x97,0x98),
     o3(0xED,0x97,0x99), o3(0xED,0x97,0x9B),
     o3(0xED,0x97,0x9D), o3(0xED,0x97,0xA4),
     o3(0xED,0x97,0xA5), o3(0xED,0x97,0xA8),
     o3(0xED,0x97,0xAC), o3(0xED,0x97,0xB4),
     o3(0xED,0x97,0xB5), o3(0xED,0x97,0xB7),
     o3(0xED,0x97,0xB9), o3(0xED,0x98,0x80),
     o3(0xED,0x98,0x81), o3(0xED,0x98,0x84),
     o3(0xED,0x98,0x88), o3(0xED,0x98,0x90),
     o3(0xED,0x98,0x91), o3(0xED,0x98,0x93),
     o3(0xED,0x98,0x94), o3(0xED,0x98,0x95),
     o3(0xED,0x98,0x9C), o3(0xED,0x98,0xA0),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_C7 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_C7_infos
};


static const struct byte_lookup* const
from_EUC_KR_C8_infos[95] = {
     o3(0xED,0x98,0xA4), o3(0xED,0x98,0xAD),
     o3(0xED,0x98,0xB8), o3(0xED,0x98,0xB9),
     o3(0xED,0x98,0xBC), o3(0xED,0x99,0x80),
     o3(0xED,0x99,0x85), o3(0xED,0x99,0x88),
     o3(0xED,0x99,0x89), o3(0xED,0x99,0x8B),
     o3(0xED,0x99,0x8D), o3(0xED,0x99,0x91),
     o3(0xED,0x99,0x94), o3(0xED,0x99,0x95),
     o3(0xED,0x99,0x98), o3(0xED,0x99,0x9C),
     o3(0xED,0x99,0xA7), o3(0xED,0x99,0xA9),
     o3(0xED,0x99,0xB0), o3(0xED,0x99,0xB1),
     o3(0xED,0x99,0xB4), o3(0xED,0x9A,0x83),
     o3(0xED,0x9A,0x85), o3(0xED,0x9A,0x8C),
     o3(0xED,0x9A,0x8D), o3(0xED,0x9A,0x90),
     o3(0xED,0x9A,0x94), o3(0xED,0x9A,0x9D),
     o3(0xED,0x9A,0x9F), o3(0xED,0x9A,0xA1),
     o3(0xED,0x9A,0xA8), o3(0xED,0x9A,0xAC),
     o3(0xED,0x9A,0xB0), o3(0xED,0x9A,0xB9),
     o3(0xED,0x9A,0xBB), o3(0xED,0x9B,0x84),
     o3(0xED,0x9B,0x85), o3(0xED,0x9B,0x88),
     o3(0xED,0x9B,0x8C), o3(0xED,0x9B,0x91),
     o3(0xED,0x9B,0x94), o3(0xED,0x9B,0x97),
     o3(0xED,0x9B,0x99), o3(0xED,0x9B,0xA0),
     o3(0xED,0x9B,0xA4), o3(0xED,0x9B,0xA8),
     o3(0xED,0x9B,0xB0), o3(0xED,0x9B,0xB5),
     o3(0xED,0x9B,0xBC), o3(0xED,0x9B,0xBD),
     o3(0xED,0x9C,0x80), o3(0xED,0x9C,0x84),
     o3(0xED,0x9C,0x91), o3(0xED,0x9C,0x98),
     o3(0xED,0x9C,0x99), o3(0xED,0x9C,0x9C),
     o3(0xED,0x9C,0xA0), o3(0xED,0x9C,0xA8),
     o3(0xED,0x9C,0xA9), o3(0xED,0x9C,0xAB),
     o3(0xED,0x9C,0xAD), o3(0xED,0x9C,0xB4),
     o3(0xED,0x9C,0xB5), o3(0xED,0x9C,0xB8),
     o3(0xED,0x9C,0xBC), o3(0xED,0x9D,0x84),
     o3(0xED,0x9D,0x87), o3(0xED,0x9D,0x89),
     o3(0xED,0x9D,0x90), o3(0xED,0x9D,0x91),
     o3(0xED,0x9D,0x94), o3(0xED,0x9D,0x96),
     o3(0xED,0x9D,0x97), o3(0xED,0x9D,0x98),
     o3(0xED,0x9D,0x99), o3(0xED,0x9D,0xA0),
     o3(0xED,0x9D,0xA1), o3(0xED,0x9D,0xA3),
     o3(0xED,0x9D,0xA5), o3(0xED,0x9D,0xA9),
     o3(0xED,0x9D,0xAC), o3(0xED,0x9D,0xB0),
     o3(0xED,0x9D,0xB4), o3(0xED,0x9D,0xBC),
     o3(0xED,0x9D,0xBD), o3(0xED,0x9E,0x81),
     o3(0xED,0x9E,0x88), o3(0xED,0x9E,0x89),
     o3(0xED,0x9E,0x8C), o3(0xED,0x9E,0x90),
     o3(0xED,0x9E,0x98), o3(0xED,0x9E,0x99),
     o3(0xED,0x9E,0x9B), o3(0xED,0x9E,0x9D),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_C8 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_C8_infos
};


static const struct byte_lookup* const
from_EUC_KR_CA_infos[95] = {
     o3(0xE4,0xBC,0xBD), o3(0xE4,0xBD,0xB3),
     o3(0xE5,0x81,0x87), o3(0xE5,0x83,0xB9),
     o3(0xE5,0x8A,0xA0), o3(0xE5,0x8F,0xAF),
     o3(0xE5,0x91,0xB5), o3(0xE5,0x93,0xA5),
     o3(0xE5,0x98,0x89), o3(0xE5,0xAB,0x81),
     o3(0xE5,0xAE,0xB6), o3(0xE6,0x9A,0x87),
     o3(0xE6,0x9E,0xB6), o3(0xE6,0x9E,0xB7),
     o3(0xE6,0x9F,0xAF), o3(0xE6,0xAD,0x8C),
     o3(0xE7,0x8F,0x82), o3(0xE7,0x97,0x82),
     o3(0xE7,0xA8,0xBC), o3(0xE8,0x8B,0x9B),
     o3(0xE8,0x8C,0x84), o3(0xE8,0xA1,0x97),
     o3(0xE8,0xA2,0x88), o3(0xE8,0xA8,0xB6),
     o3(0xE8,0xB3,0x88), o3(0xE8,0xB7,0x8F),
     o3(0xE8,0xBB,0xBB), o3(0xE8,0xBF,0xA6),
     o3(0xE9,0xA7,0x95), o3(0xE5,0x88,0xBB),
     o3(0xE5,0x8D,0xB4), o3(0xE5,0x90,0x84),
     o3(0xE6,0x81,0xAA), o3(0xE6,0x85,0xA4),
     o3(0xE6,0xAE,0xBC), o3(0xE7,0x8F,0x8F),
     o3(0xE8,0x84,0x9A), o3(0xE8,0xA6,0xBA),
     o3(0xE8,0xA7,0x92), o3(0xE9,0x96,0xA3),
     o3(0xE4,0xBE,0x83), o3(0xE5,0x88,0x8A),
     o3(0xE5,0xA2,0xBE), o3(0xE5,0xA5,0xB8),
     o3(0xE5,0xA7,0xA6), o3(0xE5,0xB9,0xB2),
     o3(0xE5,0xB9,0xB9), o3(0xE6,0x87,0x87),
     o3(0xE6,0x8F,0x80), o3(0xE6,0x9D,0x86),
     o3(0xE6,0x9F,0xAC), o3(0xE6,0xA1,0xBF),
     o3(0xE6,0xBE,0x97), o3(0xE7,0x99,0x8E),
     o3(0xE7,0x9C,0x8B), o3(0xE7,0xA3,0xB5),
     o3(0xE7,0xA8,0x88), o3(0xE7,0xAB,0xBF),
     o3(0xE7,0xB0,0xA1), o3(0xE8,0x82,0x9D),
     o3(0xE8,0x89,0xAE), o3(0xE8,0x89,0xB1),
     o3(0xE8,0xAB,0xAB), o3(0xE9,0x96,0x93),
     o3(0xE4,0xB9,0xAB), o3(0xE5,0x96,0x9D),
     o3(0xE6,0x9B,0xB7), o3(0xE6,0xB8,0xB4),
     o3(0xE7,0xA2,0xA3), o3(0xE7,0xAB,0xAD),
     o3(0xE8,0x91,0x9B), o3(0xE8,0xA4,0x90),
     o3(0xE8,0x9D,0x8E), o3(0xE9,0x9E,0xA8),
     o3(0xE5,0x8B,0x98), o3(0xE5,0x9D,0x8E),
     o3(0xE5,0xA0,0xAA), o3(0xE5,0xB5,0x8C),
     o3(0xE6,0x84,0x9F), o3(0xE6,0x86,0xBE),
     o3(0xE6,0x88,0xA1), o3(0xE6,0x95,0xA2),
     o3(0xE6,0x9F,0x91), o3(0xE6,0xA9,0x84),
     o3(0xE6,0xB8,0x9B), o3(0xE7,0x94,0x98),
     o3(0xE7,0x96,0xB3), o3(0xE7,0x9B,0xA3),
     o3(0xE7,0x9E,0xB0), o3(0xE7,0xB4,0xBA),
     o3(0xE9,0x82,0xAF), o3(0xE9,0x91,0x91),
     o3(0xE9,0x91,0x92), o3(0xE9,0xBE,0x95),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_CA = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_CA_infos
};


static const struct byte_lookup* const
from_EUC_KR_CB_infos[95] = {
     o3(0xE5,0x8C,0xA3), o3(0xE5,0xB2,0xAC),
     o3(0xE7,0x94,0xB2), o3(0xE8,0x83,0x9B),
     o3(0xE9,0x89,0x80), o3(0xE9,0x96,0x98),
     o3(0xE5,0x89,0x9B), o3(0xE5,0xA0,0x88),
     o3(0xE5,0xA7,0x9C), o3(0xE5,0xB2,0xA1),
     o3(0xE5,0xB4,0x97), o3(0xE5,0xBA,0xB7),
     o3(0xE5,0xBC,0xBA), o3(0xE5,0xBD,0x8A),
     o3(0xE6,0x85,0xB7), o3(0xE6,0xB1,0x9F),
     o3(0xE7,0x95,0xBA), o3(0xE7,0x96,0x86),
     o3(0xE7,0xB3,0xA0), o3(0xE7,0xB5,0xB3),
     o3(0xE7,0xB6,0xB1), o3(0xE7,0xBE,0x8C),
     o3(0xE8,0x85,0x94), o3(0xE8,0x88,0xA1),
     o3(0xE8,0x96,0x91), o3(0xE8,0xA5,0x81),
     o3(0xE8,0xAC,0x9B), o3(0xE9,0x8B,0xBC),
     o3(0xE9,0x99,0x8D), o3(0xE9,0xB1,0x87),
     o3(0xE4,0xBB,0x8B), o3(0xE4,0xBB,0xB7),
     o3(0xE5,0x80,0x8B), o3(0xE5,0x87,0xB1),
     o3(0xE5,0xA1,0x8F), o3(0xE6,0x84,0xB7),
     o3(0xE6,0x84,0xBE), o3(0xE6,0x85,0xA8),
     o3(0xE6,0x94,0xB9), o3(0xE6,0xA7,0xAA),
     o3(0xE6,0xBC,0x91), o3(0xE7,0x96,0xA5),
     o3(0xE7,0x9A,0x86), o3(0xE7,0x9B,0x96),
     o3(0xE7,0xAE,0x87), o3(0xE8,0x8A,0xA5),
     o3(0xE8,0x93,0x8B), o3(0xEF,0xA4,0x80),
     o3(0xE9,0x8E,0xA7), o3(0xE9,0x96,0x8B),
     o3(0xE5,0x96,0x80), o3(0xE5,0xAE,0xA2),
     o3(0xE5,0x9D,0x91), o3(0xEF,0xA4,0x81),
     o3(0xE7,0xB2,0xB3), o3(0xE7,0xBE,0xB9),
     o3(0xE9,0x86,0xB5), o3(0xE5,0x80,0xA8),
     o3(0xE5,0x8E,0xBB), o3(0xE5,0xB1,0x85),
     o3(0xE5,0xB7,0xA8), o3(0xE6,0x8B,0x92),
     o3(0xE6,0x8D,0xAE), o3(0xE6,0x93,0x9A),
     o3(0xE6,0x93,0xA7), o3(0xE6,0xB8,0xA0),
     o3(0xE7,0x82,0xAC), o3(0xE7,0xA5,0x9B),
     o3(0xE8,0xB7,0x9D), o3(0xE8,0xB8,0x9E),
     o3(0xEF,0xA4,0x82), o3(0xE9,0x81,0xBD),
     o3(0xE9,0x89,0x85), o3(0xE9,0x8B,0xB8),
     o3(0xE4,0xB9,0xBE), o3(0xE4,0xBB,0xB6),
     o3(0xE5,0x81,0xA5), o3(0xE5,0xB7,0xBE),
     o3(0xE5,0xBB,0xBA), o3(0xE6,0x84,0x86),
     o3(0xE6,0xA5,0x97), o3(0xE8,0x85,0xB1),
     o3(0xE8,0x99,0x94), o3(0xE8,0xB9,0x87),
     o3(0xE9,0x8D,0xB5), o3(0xE9,0xA8,0xAB),
     o3(0xE4,0xB9,0x9E), o3(0xE5,0x82,0x91),
     o3(0xE6,0x9D,0xB0), o3(0xE6,0xA1,0x80),
     o3(0xE5,0x84,0x89), o3(0xE5,0x8A,0x8D),
     o3(0xE5,0x8A,0x92), o3(0xE6,0xAA,0xA2),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_CB = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_CB_infos
};


static const struct byte_lookup* const
from_EUC_KR_CC_infos[95] = {
     o3(0xE7,0x9E,0xBC), o3(0xE9,0x88,0x90),
     o3(0xE9,0xBB,0x94), o3(0xE5,0x8A,0xAB),
     o3(0xE6,0x80,0xAF), o3(0xE8,0xBF,0xB2),
     o3(0xE5,0x81,0x88), o3(0xE6,0x86,0xA9),
     o3(0xE6,0x8F,0xAD), o3(0xE6,0x93,0x8A),
     o3(0xE6,0xA0,0xBC), o3(0xE6,0xAA,0x84),
     o3(0xE6,0xBF,0x80), o3(0xE8,0x86,0x88),
     o3(0xE8,0xA6,0xA1), o3(0xE9,0x9A,0x94),
     o3(0xE5,0xA0,0x85), o3(0xE7,0x89,0xBD),
     o3(0xE7,0x8A,0xAC), o3(0xE7,0x94,0x84),
     o3(0xE7,0xB5,0xB9), o3(0xE7,0xB9,0xAD),
     o3(0xE8,0x82,0xA9), o3(0xE8,0xA6,0x8B),
     o3(0xE8,0xAD,0xB4), o3(0xE9,0x81,0xA3),
     o3(0xE9,0xB5,0x91), o3(0xE6,0x8A,0x89),
     o3(0xE6,0xB1,0xBA), o3(0xE6,0xBD,0x94),
     o3(0xE7,0xB5,0x90), o3(0xE7,0xBC,0xBA),
     o3(0xE8,0xA8,0xA3), o3(0xE5,0x85,0xBC),
     o3(0xE6,0x85,0x8A), o3(0xE7,0xAE,0x9D),
     o3(0xE8,0xAC,0x99), o3(0xE9,0x89,0x97),
     o3(0xE9,0x8E,0x8C), o3(0xE4,0xBA,0xAC),
     o3(0xE4,0xBF,0x93), o3(0xE5,0x80,0x9E),
     o3(0xE5,0x82,0xBE), o3(0xE5,0x84,0x86),
     o3(0xE5,0x8B,0x81), o3(0xE5,0x8B,0x8D),
     o3(0xE5,0x8D,0xBF), o3(0xE5,0x9D,0xB0),
     o3(0xE5,0xA2,0x83), o3(0xE5,0xBA,0x9A),
     o3(0xE5,0xBE,0x91), o3(0xE6,0x85,0xB6),
     o3(0xE6,0x86,0xAC), o3(0xE6,0x93,0x8E),
     o3(0xE6,0x95,0xAC), o3(0xE6,0x99,0xAF),
     o3(0xE6,0x9A,0xBB), o3(0xE6,0x9B,0xB4),
     o3(0xE6,0xA2,0x97), o3(0xE6,0xB6,0x87),
     o3(0xE7,0x82,0x85), o3(0xE7,0x83,0xB1),
     o3(0xE7,0x92,0x9F), o3(0xE7,0x92,0xA5),
     o3(0xE7,0x93,0x8A), o3(0xE7,0x97,0x99),
     o3(0xE7,0xA1,0xAC), o3(0xE7,0xA3,0xAC),
     o3(0xE7,0xAB,0x9F), o3(0xE7,0xAB,0xB6),
     o3(0xE7,0xB5,0x85), o3(0xE7,0xB6,0x93),
     o3(0xE8,0x80,0x95), o3(0xE8,0x80,0xBF),
     o3(0xE8,0x84,0x9B), o3(0xE8,0x8E,0x96),
     o3(0xE8,0xAD,0xA6), o3(0xE8,0xBC,0x95),
     o3(0xE9,0x80,0x95), o3(0xE9,0x8F,0xA1),
     o3(0xE9,0xA0,0x83), o3(0xE9,0xA0,0xB8),
     o3(0xE9,0xA9,0x9A), o3(0xE9,0xAF,0xA8),
     o3(0xE4,0xBF,0x82), o3(0xE5,0x95,0x93),
     o3(0xE5,0xA0,0xBA), o3(0xE5,0xA5,0x91),
     o3(0xE5,0xAD,0xA3), o3(0xE5,0xB1,0x86),
     o3(0xE6,0x82,0xB8), o3(0xE6,0x88,0x92),
     o3(0xE6,0xA1,0x82), o3(0xE6,0xA2,0xB0),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_CC = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_CC_infos
};


static const struct byte_lookup* const
from_EUC_KR_CD_infos[95] = {
     o3(0xE6,0xA3,0xA8), o3(0xE6,0xBA,0xAA),
     o3(0xE7,0x95,0x8C), o3(0xE7,0x99,0xB8),
     o3(0xE7,0xA3,0x8E), o3(0xE7,0xA8,0xBD),
     o3(0xE7,0xB3,0xBB), o3(0xE7,0xB9,0xAB),
     o3(0xE7,0xB9,0xBC), o3(0xE8,0xA8,0x88),
     o3(0xE8,0xAA,0xA1), o3(0xE8,0xB0,0xBF),
     o3(0xE9,0x9A,0x8E), o3(0xE9,0xB7,0x84),
     o3(0xE5,0x8F,0xA4), o3(0xE5,0x8F,0xA9),
     o3(0xE5,0x91,0x8A), o3(0xE5,0x91,0xB1),
     o3(0xE5,0x9B,0xBA), o3(0xE5,0xA7,0x91),
     o3(0xE5,0xAD,0xA4), o3(0xE5,0xB0,0xBB),
     o3(0xE5,0xBA,0xAB), o3(0xE6,0x8B,0xB7),
     o3(0xE6,0x94,0xB7), o3(0xE6,0x95,0x85),
     o3(0xE6,0x95,0xB2), o3(0xE6,0x9A,0xA0),
     o3(0xE6,0x9E,0xAF), o3(0xE6,0xA7,0x81),
     o3(0xE6,0xB2,0xBD), o3(0xE7,0x97,0xBC),
     o3(0xE7,0x9A,0x90), o3(0xE7,0x9D,0xBE),
     o3(0xE7,0xA8,0xBF), o3(0xE7,0xBE,0x94),
     o3(0xE8,0x80,0x83), o3(0xE8,0x82,0xA1),
     o3(0xE8,0x86,0x8F), o3(0xE8,0x8B,0xA6),
     o3(0xE8,0x8B,0xBD), o3(0xE8,0x8F,0xB0),
     o3(0xE8,0x97,0x81), o3(0xE8,0xA0,0xB1),
     o3(0xE8,0xA2,0xB4), o3(0xE8,0xAA,0xA5),
     o3(0xEF,0xA4,0x83), o3(0xE8,0xBE,0x9C),
     o3(0xE9,0x8C,0xAE), o3(0xE9,0x9B,0x87),
     o3(0xE9,0xA1,0xA7), o3(0xE9,0xAB,0x98),
     o3(0xE9,0xBC,0x93), o3(0xE5,0x93,0xAD),
     o3(0xE6,0x96,0x9B), o3(0xE6,0x9B,0xB2),
     o3(0xE6,0xA2,0x8F), o3(0xE7,0xA9,0x80),
     o3(0xE8,0xB0,0xB7), o3(0xE9,0xB5,0xA0),
     o3(0xE5,0x9B,0xB0), o3(0xE5,0x9D,0xA4),
     o3(0xE5,0xB4,0x91), o3(0xE6,0x98,0x86),
     o3(0xE6,0xA2,0xB1), o3(0xE6,0xA3,0x8D),
     o3(0xE6,0xBB,0xBE), o3(0xE7,0x90,0xA8),
     o3(0xE8,0xA2,0x9E), o3(0xE9,0xAF,0xA4),
     o3(0xE6,0xB1,0xA8), o3(0xEF,0xA4,0x84),
     o3(0xE9,0xAA,0xA8), o3(0xE4,0xBE,0x9B),
     o3(0xE5,0x85,0xAC), o3(0xE5,0x85,0xB1),
     o3(0xE5,0x8A,0x9F), o3(0xE5,0xAD,0x94),
     o3(0xE5,0xB7,0xA5), o3(0xE6,0x81,0x90),
     o3(0xE6,0x81,0xAD), o3(0xE6,0x8B,0xB1),
     o3(0xE6,0x8E,0xA7), o3(0xE6,0x94,0xBB),
     o3(0xE7,0x8F,0x99), o3(0xE7,0xA9,0xBA),
     o3(0xE8,0x9A,0xA3), o3(0xE8,0xB2,0xA2),
     o3(0xE9,0x9E,0x8F), o3(0xE4,0xB8,0xB2),
     o3(0xE5,0xAF,0xA1), o3(0xE6,0x88,0x88),
     o3(0xE6,0x9E,0x9C), o3(0xE7,0x93,0x9C),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_CD = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_CD_infos
};


static const struct byte_lookup* const
from_EUC_KR_CE_infos[95] = {
     o3(0xE7,0xA7,0x91), o3(0xE8,0x8F,0x93),
     o3(0xE8,0xAA,0x87), o3(0xE8,0xAA,0xB2),
     o3(0xE8,0xB7,0xA8), o3(0xE9,0x81,0x8E),
     o3(0xE9,0x8D,0x8B), o3(0xE9,0xA1,0x86),
     o3(0xE5,0xBB,0x93), o3(0xE6,0xA7,0xA8),
     o3(0xE8,0x97,0xBF), o3(0xE9,0x83,0xAD),
     o3(0xEF,0xA4,0x85), o3(0xE5,0x86,0xA0),
     o3(0xE5,0xAE,0x98), o3(0xE5,0xAF,0xAC),
     o3(0xE6,0x85,0xA3), o3(0xE6,0xA3,0xBA),
     o3(0xE6,0xAC,0xBE), o3(0xE7,0x81,0x8C),
     o3(0xE7,0x90,0xAF), o3(0xE7,0x93,0x98),
     o3(0xE7,0xAE,0xA1), o3(0xE7,0xBD,0x90),
     o3(0xE8,0x8F,0x85), o3(0xE8,0xA7,0x80),
     o3(0xE8,0xB2,0xAB), o3(0xE9,0x97,0x9C),
     o3(0xE9,0xA4,0xA8), o3(0xE5,0x88,0xAE),
     o3(0xE6,0x81,0x9D), o3(0xE6,0x8B,0xAC),
     o3(0xE9,0x80,0x82), o3(0xE4,0xBE,0x8A),
     o3(0xE5,0x85,0x89), o3(0xE5,0x8C,0xA1),
     o3(0xE5,0xA3,0x99), o3(0xE5,0xBB,0xA3),
     o3(0xE6,0x9B,0xA0), o3(0xE6,0xB4,0xB8),
     o3(0xE7,0x82,0x9A), o3(0xE7,0x8B,0x82),
     o3(0xE7,0x8F,0x96), o3(0xE7,0xAD,0x90),
     o3(0xE8,0x83,0xB1), o3(0xE9,0x91,0x9B),
     o3(0xE5,0x8D,0xA6), o3(0xE6,0x8E,0x9B),
     o3(0xE7,0xBD,0xAB), o3(0xE4,0xB9,0x96),
     o3(0xE5,0x82,0x80), o3(0xE5,0xA1,0x8A),
     o3(0xE5,0xA3,0x9E), o3(0xE6,0x80,0xAA),
     o3(0xE6,0x84,0xA7), o3(0xE6,0x8B,0x90),
     o3(0xE6,0xA7,0x90), o3(0xE9,0xAD,0x81),
     o3(0xE5,0xAE,0x8F), o3(0xE7,0xB4,0x98),
     o3(0xE8,0x82,0xB1), o3(0xE8,0xBD,0x9F),
     o3(0xE4,0xBA,0xA4), o3(0xE5,0x83,0x91),
     o3(0xE5,0x92,0xAC), o3(0xE5,0x96,0xAC),
     o3(0xE5,0xAC,0x8C), o3(0xE5,0xB6,0xA0),
     o3(0xE5,0xB7,0xA7), o3(0xE6,0x94,0xAA),
     o3(0xE6,0x95,0x8E), o3(0xE6,0xA0,0xA1),
     o3(0xE6,0xA9,0x8B), o3(0xE7,0x8B,0xA1),
     o3(0xE7,0x9A,0x8E), o3(0xE7,0x9F,0xAF),
     o3(0xE7,0xB5,0x9E), o3(0xE7,0xBF,0xB9),
     o3(0xE8,0x86,0xA0), o3(0xE8,0x95,0x8E),
     o3(0xE8,0x9B,0x9F), o3(0xE8,0xBC,0x83),
     o3(0xE8,0xBD,0x8E), o3(0xE9,0x83,0x8A),
     o3(0xE9,0xA4,0x83), o3(0xE9,0xA9,0x95),
     o3(0xE9,0xAE,0xAB), o3(0xE4,0xB8,0x98),
     o3(0xE4,0xB9,0x85), o3(0xE4,0xB9,0x9D),
     o3(0xE4,0xBB,0x87), o3(0xE4,0xBF,0xB1),
     o3(0xE5,0x85,0xB7), o3(0xE5,0x8B,0xBE),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_CE = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_CE_infos
};


static const struct byte_lookup* const
from_EUC_KR_CF_infos[95] = {
     o3(0xE5,0x8D,0x80), o3(0xE5,0x8F,0xA3),
     o3(0xE5,0x8F,0xA5), o3(0xE5,0x92,0x8E),
     o3(0xE5,0x98,0x94), o3(0xE5,0x9D,0xB5),
     o3(0xE5,0x9E,0xA2), o3(0xE5,0xAF,0x87),
     o3(0xE5,0xB6,0x87), o3(0xE5,0xBB,0x90),
     o3(0xE6,0x87,0xBC), o3(0xE6,0x8B,0x98),
     o3(0xE6,0x95,0x91), o3(0xE6,0x9E,0xB8),
     o3(0xE6,0x9F,0xA9), o3(0xE6,0xA7,0x8B),
     o3(0xE6,0xAD,0x90), o3(0xE6,0xAF,0x86),
     o3(0xE6,0xAF,0xAC), o3(0xE6,0xB1,0x82),
     o3(0xE6,0xBA,0x9D), o3(0xE7,0x81,0xB8),
     o3(0xE7,0x8B,0x97), o3(0xE7,0x8E,0x96),
     o3(0xE7,0x90,0x83), o3(0xE7,0x9E,0xBF),
     o3(0xE7,0x9F,0xA9), o3(0xE7,0xA9,0xB6),
     o3(0xE7,0xB5,0xBF), o3(0xE8,0x80,0x89),
     o3(0xE8,0x87,0xBC), o3(0xE8,0x88,0x85),
     o3(0xE8,0x88,0x8A), o3(0xE8,0x8B,0x9F),
     o3(0xE8,0xA1,0xA2), o3(0xE8,0xAC,0xB3),
     o3(0xE8,0xB3,0xBC), o3(0xE8,0xBB,0x80),
     o3(0xE9,0x80,0x91), o3(0xE9,0x82,0xB1),
     o3(0xE9,0x89,0xA4), o3(0xE9,0x8A,0xB6),
     o3(0xE9,0xA7,0x92), o3(0xE9,0xA9,0x85),
     o3(0xE9,0xB3,0xA9), o3(0xE9,0xB7,0x97),
     o3(0xE9,0xBE,0x9C), o3(0xE5,0x9C,0x8B),
     o3(0xE5,0xB1,0x80), o3(0xE8,0x8F,0x8A),
     o3(0xE9,0x9E,0xA0), o3(0xE9,0x9E,0xAB),
     o3(0xE9,0xBA,0xB4), o3(0xE5,0x90,0x9B),
     o3(0xE7,0xAA,0x98), o3(0xE7,0xBE,0xA4),
     o3(0xE8,0xA3,0x99), o3(0xE8,0xBB,0x8D),
     o3(0xE9,0x83,0xA1), o3(0xE5,0xA0,0x80),
     o3(0xE5,0xB1,0x88), o3(0xE6,0x8E,0x98),
     o3(0xE7,0xAA,0x9F), o3(0xE5,0xAE,0xAE),
     o3(0xE5,0xBC,0x93), o3(0xE7,0xA9,0xB9),
     o3(0xE7,0xAA,0xAE), o3(0xE8,0x8A,0x8E),
     o3(0xE8,0xBA,0xAC), o3(0xE5,0x80,0xA6),
     o3(0xE5,0x88,0xB8), o3(0xE5,0x8B,0xB8),
     o3(0xE5,0x8D,0xB7), o3(0xE5,0x9C,0x88),
     o3(0xE6,0x8B,0xB3), o3(0xE6,0x8D,0xB2),
     o3(0xE6,0xAC,0x8A), o3(0xE6,0xB7,0x83),
     o3(0xE7,0x9C,0xB7), o3(0xE5,0x8E,0xA5),
     o3(0xE7,0x8D,0x97), o3(0xE8,0x95,0xA8),
     o3(0xE8,0xB9,0xB6), o3(0xE9,0x97,0x95),
     o3(0xE6,0x9C,0xBA), o3(0xE6,0xAB,0x83),
     o3(0xE6,0xBD,0xB0), o3(0xE8,0xA9,0xAD),
     o3(0xE8,0xBB,0x8C), o3(0xE9,0xA5,0x8B),
     o3(0xEF,0xA4,0x86), o3(0xE6,0x99,0xB7),
     o3(0xE6,0xAD,0xB8), o3(0xE8,0xB2,0xB4),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_CF = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_CF_infos
};


static const struct byte_lookup* const
from_EUC_KR_D0_infos[95] = {
     o3(0xE9,0xAC,0xBC), o3(0xEF,0xA4,0x87),
     o3(0xE5,0x8F,0xAB), o3(0xE5,0x9C,0xAD),
     o3(0xE5,0xA5,0x8E), o3(0xE6,0x8F,0x86),
     o3(0xE6,0xA7,0xBB), o3(0xE7,0x8F,0xAA),
     o3(0xE7,0xA1,0x85), o3(0xE7,0xAA,0xBA),
     o3(0xE7,0xAB,0x85), o3(0xE7,0xB3,0xBE),
     o3(0xE8,0x91,0xB5), o3(0xE8,0xA6,0x8F),
     o3(0xE8,0xB5,0xB3), o3(0xE9,0x80,0xB5),
     o3(0xE9,0x96,0xA8), o3(0xE5,0x8B,0xBB),
     o3(0xE5,0x9D,0x87), o3(0xE7,0x95,0x87),
     o3(0xE7,0xAD,0xA0), o3(0xE8,0x8F,0x8C),
     o3(0xE9,0x88,0x9E), o3(0xEF,0xA4,0x88),
     o3(0xE6,0xA9,0x98), o3(0xE5,0x85,0x8B),
     o3(0xE5,0x89,0x8B), o3(0xE5,0x8A,0x87),
     o3(0xE6,0x88,0x9F), o3(0xE6,0xA3,0x98),
     o3(0xE6,0xA5,0xB5), o3(0xE9,0x9A,0x99),
     o3(0xE5,0x83,0x85), o3(0xE5,0x8A,0xA4),
     o3(0xE5,0x8B,0xA4), o3(0xE6,0x87,0x83),
     o3(0xE6,0x96,0xA4), o3(0xE6,0xA0,0xB9),
     o3(0xE6,0xA7,0xBF), o3(0xE7,0x91,0xBE),
     o3(0xE7,0xAD,0x8B), o3(0xE8,0x8A,0xB9),
     o3(0xE8,0x8F,0xAB), o3(0xE8,0xA6,0xB2),
     o3(0xE8,0xAC,0xB9), o3(0xE8,0xBF,0x91),
     o3(0xE9,0xA5,0x89), o3(0xEF,0xA4,0x89),
     o3(0xE4,0xBB,0x8A), o3(0xE5,0xA6,0x97),
     o3(0xE6,0x93,0x92), o3(0xE6,0x98,0x91),
     o3(0xE6,0xAA,0x8E), o3(0xE7,0x90,0xB4),
     o3(0xE7,0xA6,0x81), o3(0xE7,0xA6,0xBD),
     o3(0xE8,0x8A,0xA9), o3(0xE8,0xA1,0xBE),
     o3(0xE8,0xA1,0xBF), o3(0xE8,0xA5,0x9F),
     o3(0xEF,0xA4,0x8A), o3(0xE9,0x8C,0xA6),
     o3(0xE4,0xBC,0x8B), o3(0xE5,0x8F,0x8A),
     o3(0xE6,0x80,0xA5), o3(0xE6,0x89,0xB1),
     o3(0xE6,0xB1,0xB2), o3(0xE7,0xB4,0x9A),
     o3(0xE7,0xB5,0xA6), o3(0xE4,0xBA,0x98),
     o3(0xE5,0x85,0xA2), o3(0xE7,0x9F,0x9C),
     o3(0xE8,0x82,0xAF), o3(0xE4,0xBC,0x81),
     o3(0xE4,0xBC,0x8E), o3(0xE5,0x85,0xB6),
     o3(0xE5,0x86,0x80), o3(0xE5,0x97,0x9C),
     o3(0xE5,0x99,0xA8), o3(0xE5,0x9C,0xBB),
     o3(0xE5,0x9F,0xBA), o3(0xE5,0x9F,0xBC),
     o3(0xE5,0xA4,0x94), o3(0xE5,0xA5,0x87),
     o3(0xE5,0xA6,0x93), o3(0xE5,0xAF,0x84),
     o3(0xE5,0xB2,0x90), o3(0xE5,0xB4,0x8E),
     o3(0xE5,0xB7,0xB1), o3(0xE5,0xB9,0xBE),
     o3(0xE5,0xBF,0x8C), o3(0xE6,0x8A,0x80),
     o3(0xE6,0x97,0x97), o3(0xE6,0x97,0xA3),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_D0 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_D0_infos
};


static const struct byte_lookup* const
from_EUC_KR_D1_infos[95] = {
     o3(0xE6,0x9C,0x9E), o3(0xE6,0x9C,0x9F),
     o3(0xE6,0x9D,0x9E), o3(0xE6,0xA3,0x8B),
     o3(0xE6,0xA3,0x84), o3(0xE6,0xA9,0x9F),
     o3(0xE6,0xAC,0xBA), o3(0xE6,0xB0,0xA3),
     o3(0xE6,0xB1,0xBD), o3(0xE6,0xB2,0x82),
     o3(0xE6,0xB7,0x87), o3(0xE7,0x8E,0x98),
     o3(0xE7,0x90,0xA6), o3(0xE7,0x90,0xAA),
     o3(0xE7,0x92,0x82), o3(0xE7,0x92,0xA3),
     o3(0xE7,0x95,0xB8), o3(0xE7,0x95,0xBF),
     o3(0xE7,0xA2,0x81), o3(0xE7,0xA3,0xAF),
     o3(0xE7,0xA5,0x81), o3(0xE7,0xA5,0x87),
     o3(0xE7,0xA5,0x88), o3(0xE7,0xA5,0xBA),
     o3(0xE7,0xAE,0x95), o3(0xE7,0xB4,0x80),
     o3(0xE7,0xB6,0xBA), o3(0xE7,0xBE,0x88),
     o3(0xE8,0x80,0x86), o3(0xE8,0x80,0xAD),
     o3(0xE8,0x82,0x8C), o3(0xE8,0xA8,0x98),
     o3(0xE8,0xAD,0x8F), o3(0xE8,0xB1,0x88),
     o3(0xE8,0xB5,0xB7), o3(0xE9,0x8C,0xA1),
     o3(0xE9,0x8C,0xA4), o3(0xE9,0xA3,0xA2),
     o3(0xE9,0xA5,0x91), o3(0xE9,0xA8,0x8E),
     o3(0xE9,0xA8,0x8F), o3(0xE9,0xA9,0xA5),
     o3(0xE9,0xBA,0x92), o3(0xE7,0xB7,0x8A),
     o3(0xE4,0xBD,0xB6), o3(0xE5,0x90,0x89),
     o3(0xE6,0x8B,0xAE), o3(0xE6,0xA1,0x94),
     o3(0xE9,0x87,0x91), o3(0xE5,0x96,0xAB),
     o3(0xE5,0x84,0xBA), o3(0xEF,0xA4,0x8B),
     o3(0xEF,0xA4,0x8C), o3(0xE5,0xA8,0x9C),
     o3(0xE6,0x87,0xA6), o3(0xEF,0xA4,0x8D),
     o3(0xE6,0x8B,0x8F), o3(0xE6,0x8B,0xBF),
     o3(0xEF,0xA4,0x8E), o3(0xEF,0xA4,0x8F),
     o3(0xEF,0xA4,0x90), o3(0xEF,0xA4,0x91),
     o3(0xEF,0xA4,0x92), o3(0xEF,0xA4,0x93),
     o3(0xE9,0x82,0xA3), o3(0xEF,0xA4,0x94),
     o3(0xEF,0xA4,0x95), o3(0xEF,0xA4,0x96),
     o3(0xEF,0xA4,0x97), o3(0xEF,0xA4,0x98),
     o3(0xE8,0xAB,0xBE), o3(0xEF,0xA4,0x99),
     o3(0xEF,0xA4,0x9A), o3(0xEF,0xA4,0x9B),
     o3(0xEF,0xA4,0x9C), o3(0xE6,0x9A,0x96),
     o3(0xEF,0xA4,0x9D), o3(0xE7,0x85,0x96),
     o3(0xEF,0xA4,0x9E), o3(0xEF,0xA4,0x9F),
     o3(0xE9,0x9B,0xA3), o3(0xEF,0xA4,0xA0),
     o3(0xE6,0x8D,0x8F), o3(0xE6,0x8D,0xBA),
     o3(0xE5,0x8D,0x97), o3(0xEF,0xA4,0xA1),
     o3(0xE6,0x9E,0x8F), o3(0xE6,0xA5,0xA0),
     o3(0xE6,0xB9,0xB3), o3(0xEF,0xA4,0xA2),
     o3(0xE7,0x94,0xB7), o3(0xEF,0xA4,0xA3),
     o3(0xEF,0xA4,0xA4), o3(0xEF,0xA4,0xA5),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_D1 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_D1_infos
};


static const struct byte_lookup* const
from_EUC_KR_D2_infos[95] = {
     o3(0xE7,0xB4,0x8D), o3(0xEF,0xA4,0xA6),
     o3(0xEF,0xA4,0xA7), o3(0xE8,0xA1,0xB2),
     o3(0xE5,0x9B,0x8A), o3(0xE5,0xA8,0x98),
     o3(0xEF,0xA4,0xA8), o3(0xEF,0xA4,0xA9),
     o3(0xEF,0xA4,0xAA), o3(0xEF,0xA4,0xAB),
     o3(0xEF,0xA4,0xAC), o3(0xE4,0xB9,0x83),
     o3(0xEF,0xA4,0xAD), o3(0xE5,0x85,0xA7),
     o3(0xE5,0xA5,0x88), o3(0xE6,0x9F,0xB0),
     o3(0xE8,0x80,0x90), o3(0xEF,0xA4,0xAE),
     o3(0xE5,0xA5,0xB3), o3(0xE5,0xB9,0xB4),
     o3(0xE6,0x92,0x9A), o3(0xE7,0xA7,0x8A),
     o3(0xE5,0xBF,0xB5), o3(0xE6,0x81,0xAC),
     o3(0xE6,0x8B,0x88), o3(0xE6,0x8D,0xBB),
     o3(0xE5,0xAF,0xA7), o3(0xE5,0xAF,0x97),
     o3(0xE5,0x8A,0xAA), o3(0xEF,0xA4,0xAF),
     o3(0xE5,0xA5,0xB4), o3(0xE5,0xBC,0xA9),
     o3(0xE6,0x80,0x92), o3(0xEF,0xA4,0xB0),
     o3(0xEF,0xA4,0xB1), o3(0xEF,0xA4,0xB2),
     o3(0xE7,0x91,0x99), o3(0xEF,0xA4,0xB3),
     o3(0xEF,0xA4,0xB4), o3(0xEF,0xA4,0xB5),
     o3(0xEF,0xA4,0xB6), o3(0xEF,0xA4,0xB7),
     o3(0xEF,0xA4,0xB8), o3(0xE9,0xA7,0x91),
     o3(0xEF,0xA4,0xB9), o3(0xEF,0xA4,0xBA),
     o3(0xEF,0xA4,0xBB), o3(0xEF,0xA4,0xBC),
     o3(0xEF,0xA4,0xBD), o3(0xEF,0xA4,0xBE),
     o3(0xEF,0xA4,0xBF), o3(0xEF,0xA5,0x80),
     o3(0xEF,0xA5,0x81), o3(0xEF,0xA5,0x82),
     o3(0xEF,0xA5,0x83), o3(0xE6,0xBF,0x83),
     o3(0xEF,0xA5,0x84), o3(0xEF,0xA5,0x85),
     o3(0xE8,0x86,0xBF), o3(0xE8,0xBE,0xB2),
     o3(0xE6,0x83,0xB1), o3(0xEF,0xA5,0x86),
     o3(0xEF,0xA5,0x87), o3(0xE8,0x85,0xA6),
     o3(0xEF,0xA5,0x88), o3(0xEF,0xA5,0x89),
     o3(0xE5,0xB0,0xBF), o3(0xEF,0xA5,0x8A),
     o3(0xEF,0xA5,0x8B), o3(0xEF,0xA5,0x8C),
     o3(0xEF,0xA5,0x8D), o3(0xEF,0xA5,0x8E),
     o3(0xEF,0xA5,0x8F), o3(0xEF,0xA5,0x90),
     o3(0xEF,0xA5,0x91), o3(0xE5,0xAB,0xA9),
     o3(0xE8,0xA8,0xA5), o3(0xE6,0x9D,0xBB),
     o3(0xE7,0xB4,0x90), o3(0xEF,0xA5,0x92),
     o3(0xEF,0xA5,0x93), o3(0xEF,0xA5,0x94),
     o3(0xEF,0xA5,0x95), o3(0xEF,0xA5,0x96),
     o3(0xEF,0xA5,0x97), o3(0xE8,0x83,0xBD),
     o3(0xEF,0xA5,0x98), o3(0xEF,0xA5,0x99),
     o3(0xE5,0xB0,0xBC), o3(0xE6,0xB3,0xA5),
     o3(0xE5,0x8C,0xBF), o3(0xE6,0xBA,0xBA),
     o3(0xE5,0xA4,0x9A), o3(0xE8,0x8C,0xB6),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_D2 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_D2_infos
};


static const struct byte_lookup* const
from_EUC_KR_D3_infos[95] = {
     o3(0xE4,0xB8,0xB9), o3(0xE4,0xBA,0xB6),
     o3(0xE4,0xBD,0x86), o3(0xE5,0x96,0xAE),
     o3(0xE5,0x9C,0x98), o3(0xE5,0xA3,0x87),
     o3(0xE5,0xBD,0x96), o3(0xE6,0x96,0xB7),
     o3(0xE6,0x97,0xA6), o3(0xE6,0xAA,0x80),
     o3(0xE6,0xAE,0xB5), o3(0xE6,0xB9,0x8D),
     o3(0xE7,0x9F,0xAD), o3(0xE7,0xAB,0xAF),
     o3(0xE7,0xB0,0x9E), o3(0xE7,0xB7,0x9E),
     o3(0xE8,0x9B,0x8B), o3(0xE8,0xA2,0x92),
     o3(0xE9,0x84,0xB2), o3(0xE9,0x8D,0x9B),
     o3(0xE6,0x92,0xBB), o3(0xE6,0xBE,0xBE),
     o3(0xE7,0x8D,0xBA), o3(0xE7,0x96,0xB8),
     o3(0xE9,0x81,0x94), o3(0xE5,0x95,0x96),
     o3(0xE5,0x9D,0x8D), o3(0xE6,0x86,0xBA),
     o3(0xE6,0x93,0x94), o3(0xE6,0x9B,0x87),
     o3(0xE6,0xB7,0xA1), o3(0xE6,0xB9,0x9B),
     o3(0xE6,0xBD,0xAD), o3(0xE6,0xBE,0xB9),
     o3(0xE7,0x97,0xB0), o3(0xE8,0x81,0x83),
     o3(0xE8,0x86,0xBD), o3(0xE8,0x95,0x81),
     o3(0xE8,0xA6,0x83), o3(0xE8,0xAB,0x87),
     o3(0xE8,0xAD,0x9A), o3(0xE9,0x8C,0x9F),
     o3(0xE6,0xB2,0x93), o3(0xE7,0x95,0x93),
     o3(0xE7,0xAD,0x94), o3(0xE8,0xB8,0x8F),
     o3(0xE9,0x81,0x9D), o3(0xE5,0x94,0x90),
     o3(0xE5,0xA0,0x82), o3(0xE5,0xA1,0x98),
     o3(0xE5,0xB9,0xA2), o3(0xE6,0x88,0x87),
     o3(0xE6,0x92,0x9E), o3(0xE6,0xA3,0xA0),
     o3(0xE7,0x95,0xB6), o3(0xE7,0xB3,0x96),
     o3(0xE8,0x9E,0xB3), o3(0xE9,0xBB,0xA8),
     o3(0xE4,0xBB,0xA3), o3(0xE5,0x9E,0x88),
     o3(0xE5,0x9D,0xAE), o3(0xE5,0xA4,0xA7),
     o3(0xE5,0xB0,0x8D), o3(0xE5,0xB2,0xB1),
     o3(0xE5,0xB8,0xB6), o3(0xE5,0xBE,0x85),
     o3(0xE6,0x88,0xB4), o3(0xE6,0x93,0xA1),
     o3(0xE7,0x8E,0xB3), o3(0xE8,0x87,0xBA),
     o3(0xE8,0xA2,0x8B), o3(0xE8,0xB2,0xB8),
     o3(0xE9,0x9A,0x8A), o3(0xE9,0xBB,0x9B),
     o3(0xE5,0xAE,0x85), o3(0xE5,0xBE,0xB7),
     o3(0xE6,0x82,0xB3), o3(0xE5,0x80,0x92),
     o3(0xE5,0x88,0x80), o3(0xE5,0x88,0xB0),
     o3(0xE5,0x9C,0x96), o3(0xE5,0xA0,0xB5),
     o3(0xE5,0xA1,0x97), o3(0xE5,0xB0,0x8E),
     o3(0xE5,0xB1,0xA0), o3(0xE5,0xB3,0xB6),
     o3(0xE5,0xB6,0x8B), o3(0xE5,0xBA,0xA6),
     o3(0xE5,0xBE,0x92), o3(0xE6,0x82,0xBC),
     o3(0xE6,0x8C,0x91), o3(0xE6,0x8E,0x89),
     o3(0xE6,0x90,0x97), o3(0xE6,0xA1,0x83),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_D3 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_D3_infos
};


static const struct byte_lookup* const
from_EUC_KR_D4_infos[95] = {
     o3(0xE6,0xA3,0xB9), o3(0xE6,0xAB,0x82),
     o3(0xE6,0xB7,0x98), o3(0xE6,0xB8,0xA1),
     o3(0xE6,0xBB,0x94), o3(0xE6,0xBF,0xA4),
     o3(0xE7,0x87,0xBE), o3(0xE7,0x9B,0x9C),
     o3(0xE7,0x9D,0xB9), o3(0xE7,0xA6,0xB1),
     o3(0xE7,0xA8,0xBB), o3(0xE8,0x90,0x84),
     o3(0xE8,0xA6,0xA9), o3(0xE8,0xB3,0xAD),
     o3(0xE8,0xB7,0xB3), o3(0xE8,0xB9,0x88),
     o3(0xE9,0x80,0x83), o3(0xE9,0x80,0x94),
     o3(0xE9,0x81,0x93), o3(0xE9,0x83,0xBD),
     o3(0xE9,0x8D,0x8D), o3(0xE9,0x99,0xB6),
     o3(0xE9,0x9F,0x9C), o3(0xE6,0xAF,0x92),
     o3(0xE7,0x80,0x86), o3(0xE7,0x89,0x98),
     o3(0xE7,0x8A,0xA2), o3(0xE7,0x8D,0xA8),
     o3(0xE7,0x9D,0xA3), o3(0xE7,0xA6,0xBF),
     o3(0xE7,0xAF,0xA4), o3(0xE7,0xBA,0x9B),
     o3(0xE8,0xAE,0x80), o3(0xE5,0xA2,0xA9),
     o3(0xE6,0x83,0x87), o3(0xE6,0x95,0xA6),
     o3(0xE6,0x97,0xBD), o3(0xE6,0x9A,0xBE),
     o3(0xE6,0xB2,0x8C), o3(0xE7,0x84,0x9E),
     o3(0xE7,0x87,0x89), o3(0xE8,0xB1,0x9A),
     o3(0xE9,0xA0,0x93), o3(0xE4,0xB9,0xAD),
     o3(0xE7,0xAA,0x81), o3(0xE4,0xBB,0x9D),
     o3(0xE5,0x86,0xAC), o3(0xE5,0x87,0x8D),
     o3(0xE5,0x8B,0x95), o3(0xE5,0x90,0x8C),
     o3(0xE6,0x86,0xA7), o3(0xE6,0x9D,0xB1),
     o3(0xE6,0xA1,0x90), o3(0xE6,0xA3,0x9F),
     o3(0xE6,0xB4,0x9E), o3(0xE6,0xBD,0xBC),
     o3(0xE7,0x96,0xBC), o3(0xE7,0x9E,0xB3),
     o3(0xE7,0xAB,0xA5), o3(0xE8,0x83,0xB4),
     o3(0xE8,0x91,0xA3), o3(0xE9,0x8A,0x85),
     o3(0xE5,0x85,0x9C), o3(0xE6,0x96,0x97),
     o3(0xE6,0x9D,0x9C), o3(0xE6,0x9E,0x93),
     o3(0xE7,0x97,0x98), o3(0xE7,0xAB,0x87),
     o3(0xE8,0x8D,0xB3), o3(0xEF,0xA5,0x9A),
     o3(0xE8,0xB1,0x86), o3(0xE9,0x80,0x97),
     o3(0xE9,0xA0,0xAD), o3(0xE5,0xB1,0xAF),
     o3(0xE8,0x87,0x80), o3(0xE8,0x8A,0x9A),
     o3(0xE9,0x81,0x81), o3(0xE9,0x81,0xAF),
     o3(0xE9,0x88,0x8D), o3(0xE5,0xBE,0x97),
     o3(0xE5,0xB6,0x9D), o3(0xE6,0xA9,0x99),
     o3(0xE7,0x87,0x88), o3(0xE7,0x99,0xBB),
     o3(0xE7,0xAD,0x89), o3(0xE8,0x97,0xA4),
     o3(0xE8,0xAC,0x84), o3(0xE9,0x84,0xA7),
     o3(0xE9,0xA8,0xB0), o3(0xE5,0x96,0x87),
     o3(0xE6,0x87,0xB6), o3(0xEF,0xA5,0x9B),
     o3(0xE7,0x99,0xA9), o3(0xE7,0xBE,0x85),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_D4 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_D4_infos
};


static const struct byte_lookup* const
from_EUC_KR_D5_infos[95] = {
     o3(0xE8,0x98,0xBF), o3(0xE8,0x9E,0xBA),
     o3(0xE8,0xA3,0xB8), o3(0xE9,0x82,0x8F),
     o3(0xEF,0xA5,0x9C), o3(0xE6,0xB4,0x9B),
     o3(0xE7,0x83,0x99), o3(0xE7,0x8F,0x9E),
     o3(0xE7,0xB5,0xA1), o3(0xE8,0x90,0xBD),
     o3(0xEF,0xA5,0x9D), o3(0xE9,0x85,0xAA),
     o3(0xE9,0xA7,0xB1), o3(0xEF,0xA5,0x9E),
     o3(0xE4,0xBA,0x82), o3(0xE5,0x8D,0xB5),
     o3(0xE6,0xAC,0x84), o3(0xE6,0xAC,0x92),
     o3(0xE7,0x80,0xBE), o3(0xE7,0x88,0x9B),
     o3(0xE8,0x98,0xAD), o3(0xE9,0xB8,0x9E),
     o3(0xE5,0x89,0x8C), o3(0xE8,0xBE,0xA3),
     o3(0xE5,0xB5,0x90), o3(0xE6,0x93,0xA5),
     o3(0xE6,0x94,0xAC), o3(0xE6,0xAC,0x96),
     o3(0xE6,0xBF,0xAB), o3(0xE7,0xB1,0x83),
     o3(0xE7,0xBA,0x9C), o3(0xE8,0x97,0x8D),
     o3(0xE8,0xA5,0xA4), o3(0xE8,0xA6,0xBD),
     o3(0xE6,0x8B,0x89), o3(0xE8,0x87,0x98),
     o3(0xE8,0xA0,0x9F), o3(0xE5,0xBB,0x8A),
     o3(0xE6,0x9C,0x97), o3(0xE6,0xB5,0xAA),
     o3(0xE7,0x8B,0xBC), o3(0xE7,0x90,0x85),
     o3(0xE7,0x91,0xAF), o3(0xE8,0x9E,0x82),
     o3(0xE9,0x83,0x9E), o3(0xE4,0xBE,0x86),
     o3(0xE5,0xB4,0x8D), o3(0xE5,0xBE,0xA0),
     o3(0xE8,0x90,0x8A), o3(0xE5,0x86,0xB7),
     o3(0xE6,0x8E,0xA0), o3(0xE7,0x95,0xA5),
     o3(0xE4,0xBA,0xAE), o3(0xE5,0x80,0x86),
     o3(0xE5,0x85,0xA9), o3(0xE5,0x87,0x89),
     o3(0xE6,0xA2,0x81), o3(0xE6,0xA8,0x91),
     o3(0xE7,0xB2,0xAE), o3(0xE7,0xB2,0xB1),
     o3(0xE7,0xB3,0xA7), o3(0xE8,0x89,0xAF),
     o3(0xE8,0xAB,0x92), o3(0xE8,0xBC,0x9B),
     o3(0xE9,0x87,0x8F), o3(0xE4,0xBE,0xB6),
     o3(0xE5,0x84,0xB7), o3(0xE5,0x8B,0xB5),
     o3(0xE5,0x91,0x82), o3(0xE5,0xBB,0xAC),
     o3(0xE6,0x85,0xAE), o3(0xE6,0x88,0xBE),
     o3(0xE6,0x97,0x85), o3(0xE6,0xAB,0x9A),
     o3(0xE6,0xBF,0xBE), o3(0xE7,0xA4,0xAA),
     o3(0xE8,0x97,0x9C), o3(0xE8,0xA0,0xA3),
     o3(0xE9,0x96,0xAD), o3(0xE9,0xA9,0xA2),
     o3(0xE9,0xA9,0xAA), o3(0xE9,0xBA,0x97),
     o3(0xE9,0xBB,0x8E), o3(0xE5,0x8A,0x9B),
     o3(0xE6,0x9B,0x86), o3(0xE6,0xAD,0xB7),
     o3(0xE7,0x80,0x9D), o3(0xE7,0xA4,0xAB),
     o3(0xE8,0xBD,0xA2), o3(0xE9,0x9D,0x82),
     o3(0xE6,0x86,0x90), o3(0xE6,0x88,0x80),
     o3(0xE6,0x94,0xA3), o3(0xE6,0xBC,0xA3),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_D5 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_D5_infos
};


static const struct byte_lookup* const
from_EUC_KR_D6_infos[95] = {
     o3(0xE7,0x85,0x89), o3(0xE7,0x92,0x89),
     o3(0xE7,0xB7,0xB4), o3(0xE8,0x81,0xAF),
     o3(0xE8,0x93,0xAE), o3(0xE8,0xBC,0xA6),
     o3(0xE9,0x80,0xA3), o3(0xE9,0x8D,0x8A),
     o3(0xE5,0x86,0xBD), o3(0xE5,0x88,0x97),
     o3(0xE5,0x8A,0xA3), o3(0xE6,0xB4,0x8C),
     o3(0xE7,0x83,0x88), o3(0xE8,0xA3,0x82),
     o3(0xE5,0xBB,0x89), o3(0xE6,0x96,0x82),
     o3(0xE6,0xAE,0xAE), o3(0xE6,0xBF,0x82),
     o3(0xE7,0xB0,0xBE), o3(0xE7,0x8D,0xB5),
     o3(0xE4,0xBB,0xA4), o3(0xE4,0xBC,0xB6),
     o3(0xE5,0x9B,0xB9), o3(0xEF,0xA5,0x9F),
     o3(0xE5,0xB2,0xBA), o3(0xE5,0xB6,0xBA),
     o3(0xE6,0x80,0x9C), o3(0xE7,0x8E,0xB2),
     o3(0xE7,0xAC,0xAD), o3(0xE7,0xBE,0x9A),
     o3(0xE7,0xBF,0x8E), o3(0xE8,0x81,0x86),
     o3(0xE9,0x80,0x9E), o3(0xE9,0x88,0xB4),
     o3(0xE9,0x9B,0xB6), o3(0xE9,0x9D,0x88),
     o3(0xE9,0xA0,0x98), o3(0xE9,0xBD,0xA1),
     o3(0xE4,0xBE,0x8B), o3(0xE6,0xBE,0xA7),
     o3(0xE7,0xA6,0xAE), o3(0xE9,0x86,0xB4),
     o3(0xE9,0x9A,0xB7), o3(0xE5,0x8B,0x9E),
     o3(0xEF,0xA5,0xA0), o3(0xE6,0x92,0x88),
     o3(0xE6,0x93,0x84), o3(0xE6,0xAB,0x93),
     o3(0xE6,0xBD,0x9E), o3(0xE7,0x80,0x98),
     o3(0xE7,0x88,0x90), o3(0xE7,0x9B,0xA7),
     o3(0xE8,0x80,0x81), o3(0xE8,0x98,0x86),
     o3(0xE8,0x99,0x9C), o3(0xE8,0xB7,0xAF),
     o3(0xE8,0xBC,0x85), o3(0xE9,0x9C,0xB2),
     o3(0xE9,0xAD,0xAF), o3(0xE9,0xB7,0xBA),
     o3(0xE9,0xB9,0xB5), o3(0xE7,0xA2,0x8C),
     o3(0xE7,0xA5,0xBF), o3(0xE7,0xB6,0xA0),
     o3(0xE8,0x8F,0x89), o3(0xE9,0x8C,0x84),
     o3(0xE9,0xB9,0xBF), o3(0xE9,0xBA,0x93),
     o3(0xE8,0xAB,0x96), o3(0xE5,0xA3,0x9F),
     o3(0xE5,0xBC,0x84), o3(0xE6,0x9C,0xA7),
     o3(0xE7,0x80,0xA7), o3(0xE7,0x93,0x8F),
     o3(0xE7,0xB1,0xA0), o3(0xE8,0x81,0xBE),
     o3(0xE5,0x84,0xA1), o3(0xE7,0x80,0xA8),
     o3(0xE7,0x89,0xA2), o3(0xE7,0xA3,0x8A),
     o3(0xE8,0xB3,0x82), o3(0xE8,0xB3,0x9A),
     o3(0xE8,0xB3,0xB4), o3(0xE9,0x9B,0xB7),
     o3(0xE4,0xBA,0x86), o3(0xE5,0x83,0x9A),
     o3(0xE5,0xAF,0xAE), o3(0xE5,0xBB,0x96),
     o3(0xE6,0x96,0x99), o3(0xE7,0x87,0x8E),
     o3(0xE7,0x99,0x82), o3(0xE7,0x9E,0xAD),
     o3(0xE8,0x81,0x8A), o3(0xE8,0x93,0xBC),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_D6 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_D6_infos
};


static const struct byte_lookup* const
from_EUC_KR_D7_infos[95] = {
     o3(0xE9,0x81,0xBC), o3(0xE9,0xAC,0xA7),
     o3(0xE9,0xBE,0x8D), o3(0xE5,0xA3,0x98),
     o3(0xE5,0xA9,0x81), o3(0xE5,0xB1,0xA2),
     o3(0xE6,0xA8,0x93), o3(0xE6,0xB7,0x9A),
     o3(0xE6,0xBC,0x8F), o3(0xE7,0x98,0xBB),
     o3(0xE7,0xB4,0xAF), o3(0xE7,0xB8,0xB7),
     o3(0xE8,0x94,0x9E), o3(0xE8,0xA4,0xB8),
     o3(0xE9,0x8F,0xA4), o3(0xE9,0x99,0x8B),
     o3(0xE5,0x8A,0x89), o3(0xE6,0x97,0x92),
     o3(0xE6,0x9F,0xB3), o3(0xE6,0xA6,0xB4),
     o3(0xE6,0xB5,0x81), o3(0xE6,0xBA,0x9C),
     o3(0xE7,0x80,0x8F), o3(0xE7,0x90,0x89),
     o3(0xE7,0x91,0xA0), o3(0xE7,0x95,0x99),
     o3(0xE7,0x98,0xA4), o3(0xE7,0xA1,0xAB),
     o3(0xE8,0xAC,0xAC), o3(0xE9,0xA1,0x9E),
     o3(0xE5,0x85,0xAD), o3(0xE6,0x88,0xAE),
     o3(0xE9,0x99,0xB8), o3(0xE4,0xBE,0x96),
     o3(0xE5,0x80,0xAB), o3(0xE5,0xB4,0x99),
     o3(0xE6,0xB7,0xAA), o3(0xE7,0xB6,0xB8),
     o3(0xE8,0xBC,0xAA), o3(0xE5,0xBE,0x8B),
     o3(0xE6,0x85,0x84), o3(0xE6,0xA0,0x97),
     o3(0xEF,0xA5,0xA1), o3(0xE9,0x9A,0x86),
     o3(0xE5,0x8B,0x92), o3(0xE8,0x82,0x8B),
     o3(0xE5,0x87,0x9C), o3(0xE5,0x87,0x8C),
     o3(0xE6,0xA5,0x9E), o3(0xE7,0xA8,0x9C),
     o3(0xE7,0xB6,0xBE), o3(0xE8,0x8F,0xB1),
     o3(0xE9,0x99,0xB5), o3(0xE4,0xBF,0x9A),
     o3(0xE5,0x88,0xA9), o3(0xE5,0x8E,0x98),
     o3(0xE5,0x90,0x8F), o3(0xE5,0x94,0x8E),
     o3(0xE5,0xB1,0xA5), o3(0xE6,0x82,0xA7),
     o3(0xE6,0x9D,0x8E), o3(0xE6,0xA2,0xA8),
     o3(0xE6,0xB5,0xAC), o3(0xE7,0x8A,0x81),
     o3(0xE7,0x8B,0xB8), o3(0xE7,0x90,0x86),
     o3(0xE7,0x92,0x83), o3(0xEF,0xA5,0xA2),
     o3(0xE7,0x97,0xA2), o3(0xE7,0xB1,0xAC),
     o3(0xE7,0xBD,0xB9), o3(0xE7,0xBE,0xB8),
     o3(0xE8,0x8E,0x89), o3(0xE8,0xA3,0x8F),
     o3(0xE8,0xA3,0xA1), o3(0xE9,0x87,0x8C),
     o3(0xE9,0x87,0x90), o3(0xE9,0x9B,0xA2),
     o3(0xE9,0xAF,0x89), o3(0xE5,0x90,0x9D),
     o3(0xE6,0xBD,0xBE), o3(0xE7,0x87,0x90),
     o3(0xE7,0x92,0x98), o3(0xE8,0x97,0xBA),
     o3(0xE8,0xBA,0xAA), o3(0xE9,0x9A,0xA3),
     o3(0xE9,0xB1,0x97), o3(0xE9,0xBA,0x9F),
     o3(0xE6,0x9E,0x97), o3(0xE6,0xB7,0x8B),
     o3(0xE7,0x90,0xB3), o3(0xE8,0x87,0xA8),
     o3(0xE9,0x9C,0x96), o3(0xE7,0xA0,0xAC),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_D7 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_D7_infos
};


static const struct byte_lookup* const
from_EUC_KR_D8_infos[95] = {
     o3(0xE7,0xAB,0x8B), o3(0xE7,0xAC,0xA0),
     o3(0xE7,0xB2,0x92), o3(0xE6,0x91,0xA9),
     o3(0xE7,0x91,0xAA), o3(0xE7,0x97,0xB2),
     o3(0xE7,0xA2,0xBC), o3(0xE7,0xA3,0xA8),
     o3(0xE9,0xA6,0xAC), o3(0xE9,0xAD,0x94),
     o3(0xE9,0xBA,0xBB), o3(0xE5,0xAF,0x9E),
     o3(0xE5,0xB9,0x95), o3(0xE6,0xBC,0xA0),
     o3(0xE8,0x86,0x9C), o3(0xE8,0x8E,0xAB),
     o3(0xE9,0x82,0x88), o3(0xE4,0xB8,0x87),
     o3(0xE5,0x8D,0x8D), o3(0xE5,0xA8,0xA9),
     o3(0xE5,0xB7,0x92), o3(0xE5,0xBD,0x8E),
     o3(0xE6,0x85,0xA2), o3(0xE6,0x8C,0xBD),
     o3(0xE6,0x99,0xA9), o3(0xE6,0x9B,0xBC),
     o3(0xE6,0xBB,0xBF), o3(0xE6,0xBC,0xAB),
     o3(0xE7,0x81,0xA3), o3(0xE7,0x9E,0x9E),
     o3(0xE8,0x90,0xAC), o3(0xE8,0x94,0x93),
     o3(0xE8,0xA0,0xBB), o3(0xE8,0xBC,0x93),
     o3(0xE9,0xA5,0x85), o3(0xE9,0xB0,0xBB),
     o3(0xE5,0x94,0x9C), o3(0xE6,0x8A,0xB9),
     o3(0xE6,0x9C,0xAB), o3(0xE6,0xB2,0xAB),
     o3(0xE8,0x8C,0x89), o3(0xE8,0xA5,0xAA),
     o3(0xE9,0x9D,0xBA), o3(0xE4,0xBA,0xA1),
     o3(0xE5,0xA6,0x84), o3(0xE5,0xBF,0x98),
     o3(0xE5,0xBF,0x99), o3(0xE6,0x9C,0x9B),
     o3(0xE7,0xB6,0xB2), o3(0xE7,0xBD,0x94),
     o3(0xE8,0x8A,0x92), o3(0xE8,0x8C,0xAB),
     o3(0xE8,0x8E,0xBD), o3(0xE8,0xBC,0x9E),
     o3(0xE9,0x82,0x99), o3(0xE5,0x9F,0x8B),
     o3(0xE5,0xA6,0xB9), o3(0xE5,0xAA,0x92),
     o3(0xE5,0xAF,0x90), o3(0xE6,0x98,0xA7),
     o3(0xE6,0x9E,0x9A), o3(0xE6,0xA2,0x85),
     o3(0xE6,0xAF,0x8F), o3(0xE7,0x85,0xA4),
     o3(0xE7,0xBD,0xB5), o3(0xE8,0xB2,0xB7),
     o3(0xE8,0xB3,0xA3), o3(0xE9,0x82,0x81),
     o3(0xE9,0xAD,0x85), o3(0xE8,0x84,0x88),
     o3(0xE8,0xB2,0x8A), o3(0xE9,0x99,0x8C),
     o3(0xE9,0xA9,0x80), o3(0xE9,0xBA,0xA5),
     o3(0xE5,0xAD,0x9F), o3(0xE6,0xB0,0x93),
     o3(0xE7,0x8C,0x9B), o3(0xE7,0x9B,0xB2),
     o3(0xE7,0x9B,0x9F), o3(0xE8,0x90,0x8C),
     o3(0xE5,0x86,0xAA), o3(0xE8,0xA6,0x93),
     o3(0xE5,0x85,0x8D), o3(0xE5,0x86,0x95),
     o3(0xE5,0x8B,0x89), o3(0xE6,0xA3,0x89),
     o3(0xE6,0xB2,0x94), o3(0xE7,0x9C,0x84),
     o3(0xE7,0x9C,0xA0), o3(0xE7,0xB6,0xBF),
     o3(0xE7,0xB7,0xAC), o3(0xE9,0x9D,0xA2),
     o3(0xE9,0xBA,0xB5), o3(0xE6,0xBB,0x85),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_D8 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_D8_infos
};


static const struct byte_lookup* const
from_EUC_KR_D9_infos[95] = {
     o3(0xE8,0x94,0x91), o3(0xE5,0x86,0xA5),
     o3(0xE5,0x90,0x8D), o3(0xE5,0x91,0xBD),
     o3(0xE6,0x98,0x8E), o3(0xE6,0x9A,0x9D),
     o3(0xE6,0xA4,0xA7), o3(0xE6,0xBA,0x9F),
     o3(0xE7,0x9A,0xBF), o3(0xE7,0x9E,0x91),
     o3(0xE8,0x8C,0x97), o3(0xE8,0x93,0x82),
     o3(0xE8,0x9E,0x9F), o3(0xE9,0x85,0xA9),
     o3(0xE9,0x8A,0x98), o3(0xE9,0xB3,0xB4),
     o3(0xE8,0xA2,0x82), o3(0xE4,0xBE,0xAE),
     o3(0xE5,0x86,0x92), o3(0xE5,0x8B,0x9F),
     o3(0xE5,0xA7,0x86), o3(0xE5,0xB8,0xBD),
     o3(0xE6,0x85,0x95), o3(0xE6,0x91,0xB8),
     o3(0xE6,0x91,0xB9), o3(0xE6,0x9A,0xAE),
     o3(0xE6,0x9F,0x90), o3(0xE6,0xA8,0xA1),
     o3(0xE6,0xAF,0x8D), o3(0xE6,0xAF,0x9B),
     o3(0xE7,0x89,0x9F), o3(0xE7,0x89,0xA1),
     o3(0xE7,0x91,0x81), o3(0xE7,0x9C,0xB8),
     o3(0xE7,0x9F,0x9B), o3(0xE8,0x80,0x97),
     o3(0xE8,0x8A,0xBC), o3(0xE8,0x8C,0x85),
     o3(0xE8,0xAC,0x80), o3(0xE8,0xAC,0xA8),
     o3(0xE8,0xB2,0x8C), o3(0xE6,0x9C,0xA8),
     o3(0xE6,0xB2,0x90), o3(0xE7,0x89,0xA7),
     o3(0xE7,0x9B,0xAE), o3(0xE7,0x9D,0xA6),
     o3(0xE7,0xA9,0x86), o3(0xE9,0xB6,0xA9),
     o3(0xE6,0xAD,0xBF), o3(0xE6,0xB2,0x92),
     o3(0xE5,0xA4,0xA2), o3(0xE6,0x9C,0xA6),
     o3(0xE8,0x92,0x99), o3(0xE5,0x8D,0xAF),
     o3(0xE5,0xA2,0x93), o3(0xE5,0xA6,0x99),
     o3(0xE5,0xBB,0x9F), o3(0xE6,0x8F,0x8F),
     o3(0xE6,0x98,0xB4), o3(0xE6,0x9D,0xB3),
     o3(0xE6,0xB8,0xBA), o3(0xE7,0x8C,0xAB),
     o3(0xE7,0xAB,0x97), o3(0xE8,0x8B,0x97),
     o3(0xE9,0x8C,0xA8), o3(0xE5,0x8B,0x99),
     o3(0xE5,0xB7,0xAB), o3(0xE6,0x86,0xAE),
     o3(0xE6,0x87,0x8B), o3(0xE6,0x88,0x8A),
     o3(0xE6,0x8B,0x87), o3(0xE6,0x92,0xAB),
     o3(0xE6,0x97,0xA0), o3(0xE6,0xA5,0x99),
     o3(0xE6,0xAD,0xA6), o3(0xE6,0xAF,0x8B),
     o3(0xE7,0x84,0xA1), o3(0xE7,0x8F,0xB7),
     o3(0xE7,0x95,0x9D), o3(0xE7,0xB9,0x86),
     o3(0xE8,0x88,0x9E), o3(0xE8,0x8C,0x82),
     o3(0xE8,0x95,0xAA), o3(0xE8,0xAA,0xA3),
     o3(0xE8,0xB2,0xBF), o3(0xE9,0x9C,0xA7),
     o3(0xE9,0xB5,0xA1), o3(0xE5,0xA2,0xA8),
     o3(0xE9,0xBB,0x98), o3(0xE5,0x80,0x91),
     o3(0xE5,0x88,0x8E), o3(0xE5,0x90,0xBB),
     o3(0xE5,0x95,0x8F), o3(0xE6,0x96,0x87),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_D9 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_D9_infos
};


static const struct byte_lookup* const
from_EUC_KR_DA_infos[95] = {
     o3(0xE6,0xB1,0xB6), o3(0xE7,0xB4,0x8A),
     o3(0xE7,0xB4,0x8B), o3(0xE8,0x81,0x9E),
     o3(0xE8,0x9A,0x8A), o3(0xE9,0x96,0x80),
     o3(0xE9,0x9B,0xAF), o3(0xE5,0x8B,0xBF),
     o3(0xE6,0xB2,0x95), o3(0xE7,0x89,0xA9),
     o3(0xE5,0x91,0xB3), o3(0xE5,0xAA,0x9A),
     o3(0xE5,0xB0,0xBE), o3(0xE5,0xB5,0x8B),
     o3(0xE5,0xBD,0x8C), o3(0xE5,0xBE,0xAE),
     o3(0xE6,0x9C,0xAA), o3(0xE6,0xA2,0xB6),
     o3(0xE6,0xA5,0xA3), o3(0xE6,0xB8,0xBC),
     o3(0xE6,0xB9,0x84), o3(0xE7,0x9C,0x89),
     o3(0xE7,0xB1,0xB3), o3(0xE7,0xBE,0x8E),
     o3(0xE8,0x96,0x87), o3(0xE8,0xAC,0x8E),
     o3(0xE8,0xBF,0xB7), o3(0xE9,0x9D,0xA1),
     o3(0xE9,0xBB,0xB4), o3(0xE5,0xB2,0xB7),
     o3(0xE6,0x82,0xB6), o3(0xE6,0x84,0x8D),
     o3(0xE6,0x86,0xAB), o3(0xE6,0x95,0x8F),
     o3(0xE6,0x97,0xBB), o3(0xE6,0x97,0xBC),
     o3(0xE6,0xB0,0x91), o3(0xE6,0xB3,0xAF),
     o3(0xE7,0x8E,0x9F), o3(0xE7,0x8F,0x89),
     o3(0xE7,0xB7,0xA1), o3(0xE9,0x96,0x94),
     o3(0xE5,0xAF,0x86), o3(0xE8,0x9C,0x9C),
     o3(0xE8,0xAC,0x90), o3(0xE5,0x89,0x9D),
     o3(0xE5,0x8D,0x9A), o3(0xE6,0x8B,0x8D),
     o3(0xE6,0x90,0x8F), o3(0xE6,0x92,0xB2),
     o3(0xE6,0x9C,0xB4), o3(0xE6,0xA8,0xB8),
     o3(0xE6,0xB3,0x8A), o3(0xE7,0x8F,0x80),
     o3(0xE7,0x92,0x9E), o3(0xE7,0xAE,0x94),
     o3(0xE7,0xB2,0x95), o3(0xE7,0xB8,0x9B),
     o3(0xE8,0x86,0x8A), o3(0xE8,0x88,0xB6),
     o3(0xE8,0x96,0x84), o3(0xE8,0xBF,0xAB),
     o3(0xE9,0x9B,0xB9), o3(0xE9,0xA7,0x81),
     o3(0xE4,0xBC,0xB4), o3(0xE5,0x8D,0x8A),
     o3(0xE5,0x8F,0x8D), o3(0xE5,0x8F,0x9B),
     o3(0xE6,0x8B,0x8C), o3(0xE6,0x90,0xAC),
     o3(0xE6,0x94,0x80), o3(0xE6,0x96,0x91),
     o3(0xE6,0xA7,0x83), o3(0xE6,0xB3,0xAE),
     o3(0xE6,0xBD,0x98), o3(0xE7,0x8F,0xAD),
     o3(0xE7,0x95,0x94), o3(0xE7,0x98,0xA2),
     o3(0xE7,0x9B,0xA4), o3(0xE7,0x9B,0xBC),
     o3(0xE7,0xA3,0x90), o3(0xE7,0xA3,0xBB),
     o3(0xE7,0xA4,0xAC), o3(0xE7,0xB5,0x86),
     o3(0xE8,0x88,0xAC), o3(0xE8,0x9F,0xA0),
     o3(0xE8,0xBF,0x94), o3(0xE9,0xA0,0x92),
     o3(0xE9,0xA3,0xAF), o3(0xE5,0x8B,0x83),
     o3(0xE6,0x8B,0x94), o3(0xE6,0x92,0xA5),
     o3(0xE6,0xB8,0xA4), o3(0xE6,0xBD,0x91),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_DA = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_DA_infos
};


static const struct byte_lookup* const
from_EUC_KR_DB_infos[95] = {
     o3(0xE7,0x99,0xBC), o3(0xE8,0xB7,0x8B),
     o3(0xE9,0x86,0xB1), o3(0xE9,0x89,0xA2),
     o3(0xE9,0xAB,0xAE), o3(0xE9,0xAD,0x83),
     o3(0xE5,0x80,0xA3), o3(0xE5,0x82,0x8D),
     o3(0xE5,0x9D,0x8A), o3(0xE5,0xA6,0xA8),
     o3(0xE5,0xB0,0xA8), o3(0xE5,0xB9,0x87),
     o3(0xE5,0xBD,0xB7), o3(0xE6,0x88,0xBF),
     o3(0xE6,0x94,0xBE), o3(0xE6,0x96,0xB9),
     o3(0xE6,0x97,0x81), o3(0xE6,0x98,0x89),
     o3(0xE6,0x9E,0x8B), o3(0xE6,0xA6,0x9C),
     o3(0xE6,0xBB,0x82), o3(0xE7,0xA3,0x85),
     o3(0xE7,0xB4,0xA1), o3(0xE8,0x82,0xAA),
     o3(0xE8,0x86,0x80), o3(0xE8,0x88,0xAB),
     o3(0xE8,0x8A,0xB3), o3(0xE8,0x92,0xA1),
     o3(0xE8,0x9A,0x8C), o3(0xE8,0xA8,0xAA),
     o3(0xE8,0xAC,0x97), o3(0xE9,0x82,0xA6),
     o3(0xE9,0x98,0xB2), o3(0xE9,0xBE,0x90),
     o3(0xE5,0x80,0x8D), o3(0xE4,0xBF,0xB3),
     o3(0xEF,0xA5,0xA3), o3(0xE5,0x9F,0xB9),
     o3(0xE5,0xBE,0x98), o3(0xE6,0x8B,0x9C),
     o3(0xE6,0x8E,0x92), o3(0xE6,0x9D,0xAF),
     o3(0xE6,0xB9,0x83), o3(0xE7,0x84,0x99),
     o3(0xE7,0x9B,0x83), o3(0xE8,0x83,0x8C),
     o3(0xE8,0x83,0x9A), o3(0xE8,0xA3,0xB4),
     o3(0xE8,0xA3,0xB5), o3(0xE8,0xA4,0x99),
     o3(0xE8,0xB3,0xA0), o3(0xE8,0xBC,0xA9),
     o3(0xE9,0x85,0x8D), o3(0xE9,0x99,0xAA),
     o3(0xE4,0xBC,0xAF), o3(0xE4,0xBD,0xB0),
     o3(0xE5,0xB8,0x9B), o3(0xE6,0x9F,0x8F),
     o3(0xE6,0xA0,0xA2), o3(0xE7,0x99,0xBD),
     o3(0xE7,0x99,0xBE), o3(0xE9,0xAD,0x84),
     o3(0xE5,0xB9,0xA1), o3(0xE6,0xA8,0x8A),
     o3(0xE7,0x85,0xA9), o3(0xE7,0x87,0x94),
     o3(0xE7,0x95,0xAA), o3(0xEF,0xA5,0xA4),
     o3(0xE7,0xB9,0x81), o3(0xE8,0x95,0x83),
     o3(0xE8,0x97,0xA9), o3(0xE9,0xA3,0x9C),
     o3(0xE4,0xBC,0x90), o3(0xE7,0xAD,0x8F),
     o3(0xE7,0xBD,0xB0), o3(0xE9,0x96,0xA5),
     o3(0xE5,0x87,0xA1), o3(0xE5,0xB8,0x86),
     o3(0xE6,0xA2,0xB5), o3(0xE6,0xB0,0xBE),
     o3(0xE6,0xB1,0x8E), o3(0xE6,0xB3,0x9B),
     o3(0xE7,0x8A,0xAF), o3(0xE7,0xAF,0x84),
     o3(0xE8,0x8C,0x83), o3(0xE6,0xB3,0x95),
     o3(0xE7,0x90,0xBA), o3(0xE5,0x83,0xBB),
     o3(0xE5,0x8A,0x88), o3(0xE5,0xA3,0x81),
     o3(0xE6,0x93,0x98), o3(0xE6,0xAA,0x97),
     o3(0xE7,0x92,0xA7), o3(0xE7,0x99,0x96),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_DB = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_DB_infos
};


static const struct byte_lookup* const
from_EUC_KR_DC_infos[95] = {
     o3(0xE7,0xA2,0xA7), o3(0xE8,0x98,0x97),
     o3(0xE9,0x97,0xA2), o3(0xE9,0x9C,0xB9),
     o3(0xEF,0xA5,0xA5), o3(0xE5,0x8D,0x9E),
     o3(0xE5,0xBC,0x81), o3(0xE8,0xAE,0x8A),
     o3(0xE8,0xBE,0xA8), o3(0xE8,0xBE,0xAF),
     o3(0xE9,0x82,0x8A), o3(0xE5,0x88,0xA5),
     o3(0xE7,0x9E,0xA5), o3(0xE9,0xB1,0x89),
     o3(0xE9,0xBC,0x88), o3(0xE4,0xB8,0x99),
     o3(0xE5,0x80,0x82), o3(0xE5,0x85,0xB5),
     o3(0xE5,0xB1,0x9B), o3(0xE5,0xB9,0xB7),
     o3(0xE6,0x98,0x9E), o3(0xE6,0x98,0xBA),
     o3(0xE6,0x9F,0x84), o3(0xE6,0xA3,0x85),
     o3(0xE7,0x82,0xB3), o3(0xE7,0x94,0x81),
     o3(0xE7,0x97,0x85), o3(0xE7,0xA7,0x89),
     o3(0xE7,0xAB,0x9D), o3(0xE8,0xBC,0xA7),
     o3(0xE9,0xA4,0xA0), o3(0xE9,0xA8,0x88),
     o3(0xE4,0xBF,0x9D), o3(0xE5,0xA0,0xA1),
     o3(0xE5,0xA0,0xB1), o3(0xE5,0xAF,0xB6),
     o3(0xE6,0x99,0xAE), o3(0xE6,0xAD,0xA5),
     o3(0xE6,0xB4,0x91), o3(0xE6,0xB9,0xBA),
     o3(0xE6,0xBD,0xBD), o3(0xE7,0x8F,0xA4),
     o3(0xE7,0x94,0xAB), o3(0xE8,0x8F,0xA9),
     o3(0xE8,0xA3,0x9C), o3(0xE8,0xA4,0x93),
     o3(0xE8,0xAD,0x9C), o3(0xE8,0xBC,0x94),
     o3(0xE4,0xBC,0x8F), o3(0xE5,0x83,0x95),
     o3(0xE5,0x8C,0x90), o3(0xE5,0x8D,0x9C),
     o3(0xE5,0xAE,0x93), o3(0xE5,0xBE,0xA9),
     o3(0xE6,0x9C,0x8D), o3(0xE7,0xA6,0x8F),
     o3(0xE8,0x85,0xB9), o3(0xE8,0x8C,0xAF),
     o3(0xE8,0x94,0x94), o3(0xE8,0xA4,0x87),
     o3(0xE8,0xA6,0x86), o3(0xE8,0xBC,0xB9),
     o3(0xE8,0xBC,0xBB), o3(0xE9,0xA6,0xA5),
     o3(0xE9,0xB0,0x92), o3(0xE6,0x9C,0xAC),
     o3(0xE4,0xB9,0xB6), o3(0xE4,0xBF,0xB8),
     o3(0xE5,0xA5,0x89), o3(0xE5,0xB0,0x81),
     o3(0xE5,0xB3,0xAF), o3(0xE5,0xB3,0xB0),
     o3(0xE6,0x8D,0xA7), o3(0xE6,0xA3,0x92),
     o3(0xE7,0x83,0xBD), o3(0xE7,0x86,0xA2),
     o3(0xE7,0x90,0xAB), o3(0xE7,0xB8,0xAB),
     o3(0xE8,0x93,0xAC), o3(0xE8,0x9C,0x82),
     o3(0xE9,0x80,0xA2), o3(0xE9,0x8B,0x92),
     o3(0xE9,0xB3,0xB3), o3(0xE4,0xB8,0x8D),
     o3(0xE4,0xBB,0x98), o3(0xE4,0xBF,0xAF),
     o3(0xE5,0x82,0x85), o3(0xE5,0x89,0x96),
     o3(0xE5,0x89,0xAF), o3(0xE5,0x90,0xA6),
     o3(0xE5,0x92,0x90), o3(0xE5,0x9F,0xA0),
     o3(0xE5,0xA4,0xAB), o3(0xE5,0xA9,0xA6),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_DC = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_DC_infos
};


static const struct byte_lookup* const
from_EUC_KR_DD_infos[95] = {
     o3(0xE5,0xAD,0x9A), o3(0xE5,0xAD,0xB5),
     o3(0xE5,0xAF,0x8C), o3(0xE5,0xBA,0x9C),
     o3(0xEF,0xA5,0xA6), o3(0xE6,0x89,0xB6),
     o3(0xE6,0x95,0xB7), o3(0xE6,0x96,0xA7),
     o3(0xE6,0xB5,0xAE), o3(0xE6,0xBA,0xA5),
     o3(0xE7,0x88,0xB6), o3(0xE7,0xAC,0xA6),
     o3(0xE7,0xB0,0xBF), o3(0xE7,0xBC,0xB6),
     o3(0xE8,0x85,0x90), o3(0xE8,0x85,0x91),
     o3(0xE8,0x86,0x9A), o3(0xE8,0x89,0x80),
     o3(0xE8,0x8A,0x99), o3(0xE8,0x8E,0xA9),
     o3(0xE8,0xA8,0x83), o3(0xE8,0xB2,0xA0),
     o3(0xE8,0xB3,0xA6), o3(0xE8,0xB3,0xBB),
     o3(0xE8,0xB5,0xB4), o3(0xE8,0xB6,0xBA),
     o3(0xE9,0x83,0xA8), o3(0xE9,0x87,0x9C),
     o3(0xE9,0x98,0x9C), o3(0xE9,0x99,0x84),
     o3(0xE9,0xA7,0x99), o3(0xE9,0xB3,0xA7),
     o3(0xE5,0x8C,0x97), o3(0xE5,0x88,0x86),
     o3(0xE5,0x90,0xA9), o3(0xE5,0x99,0xB4),
     o3(0xE5,0xA2,0xB3), o3(0xE5,0xA5,0x94),
     o3(0xE5,0xA5,0xAE), o3(0xE5,0xBF,0xBF),
     o3(0xE6,0x86,0xA4), o3(0xE6,0x89,0xAE),
     o3(0xE6,0x98,0x90), o3(0xE6,0xB1,0xBE),
     o3(0xE7,0x84,0x9A), o3(0xE7,0x9B,0x86),
     o3(0xE7,0xB2,0x89), o3(0xE7,0xB3,0x9E),
     o3(0xE7,0xB4,0x9B), o3(0xE8,0x8A,0xAC),
     o3(0xE8,0xB3,0x81), o3(0xE9,0x9B,0xB0),
     o3(0xEF,0xA5,0xA7), o3(0xE4,0xBD,0x9B),
     o3(0xE5,0xBC,0x97), o3(0xE5,0xBD,0xBF),
     o3(0xE6,0x8B,0x82), o3(0xE5,0xB4,0xA9),
     o3(0xE6,0x9C,0x8B), o3(0xE6,0xA3,0x9A),
     o3(0xE7,0xA1,0xBC), o3(0xE7,0xB9,0x83),
     o3(0xE9,0xB5,0xAC), o3(0xE4,0xB8,0x95),
     o3(0xE5,0x82,0x99), o3(0xE5,0x8C,0x95),
     o3(0xE5,0x8C,0xAA), o3(0xE5,0x8D,0x91),
     o3(0xE5,0xA6,0x83), o3(0xE5,0xA9,0xA2),
     o3(0xE5,0xBA,0x87), o3(0xE6,0x82,0xB2),
     o3(0xE6,0x86,0x8A), o3(0xE6,0x89,0x89),
     o3(0xE6,0x89,0xB9), o3(0xE6,0x96,0x90),
     o3(0xE6,0x9E,0x87), o3(0xE6,0xA6,0xA7),
     o3(0xE6,0xAF,0x94), o3(0xE6,0xAF,0x96),
     o3(0xE6,0xAF,0x97), o3(0xE6,0xAF,0x98),
     o3(0xE6,0xB2,0xB8), o3(0xEF,0xA5,0xA8),
     o3(0xE7,0x90,0xB5), o3(0xE7,0x97,0xBA),
     o3(0xE7,0xA0,0x92), o3(0xE7,0xA2,0x91),
     o3(0xE7,0xA7,0x95), o3(0xE7,0xA7,0x98),
     o3(0xE7,0xB2,0x83), o3(0xE7,0xB7,0x8B),
     o3(0xE7,0xBF,0xA1), o3(0xE8,0x82,0xA5),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_DD = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_DD_infos
};


static const struct byte_lookup* const
from_EUC_KR_DE_infos[95] = {
     o3(0xE8,0x84,0xBE), o3(0xE8,0x87,0x82),
     o3(0xE8,0x8F,0xB2), o3(0xE8,0x9C,0x9A),
     o3(0xE8,0xA3,0xA8), o3(0xE8,0xAA,0xB9),
     o3(0xE8,0xAD,0xAC), o3(0xE8,0xB2,0xBB),
     o3(0xE9,0x84,0x99), o3(0xE9,0x9D,0x9E),
     o3(0xE9,0xA3,0x9B), o3(0xE9,0xBC,0xBB),
     o3(0xE5,0x9A,0xAC), o3(0xE5,0xAC,0xAA),
     o3(0xE5,0xBD,0xAC), o3(0xE6,0x96,0x8C),
     o3(0xE6,0xAA,0xB3), o3(0xE6,0xAE,0xAF),
     o3(0xE6,0xB5,0x9C), o3(0xE6,0xBF,0xB1),
     o3(0xE7,0x80,0x95), o3(0xE7,0x89,0x9D),
     o3(0xE7,0x8E,0xAD), o3(0xE8,0xB2,0xA7),
     o3(0xE8,0xB3,0x93), o3(0xE9,0xA0,0xBB),
     o3(0xE6,0x86,0x91), o3(0xE6,0xB0,0xB7),
     o3(0xE8,0x81,0x98), o3(0xE9,0xA8,0x81),
     o3(0xE4,0xB9,0x8D), o3(0xE4,0xBA,0x8B),
     o3(0xE4,0xBA,0x9B), o3(0xE4,0xBB,0x95),
     o3(0xE4,0xBC,0xBA), o3(0xE4,0xBC,0xBC),
     o3(0xE4,0xBD,0xBF), o3(0xE4,0xBF,0x9F),
     o3(0xE5,0x83,0xBF), o3(0xE5,0x8F,0xB2),
     o3(0xE5,0x8F,0xB8), o3(0xE5,0x94,0x86),
     o3(0xE5,0x97,0xA3), o3(0xE5,0x9B,0x9B),
     o3(0xE5,0xA3,0xAB), o3(0xE5,0xA5,0xA2),
     o3(0xE5,0xA8,0x91), o3(0xE5,0xAF,0xAB),
     o3(0xE5,0xAF,0xBA), o3(0xE5,0xB0,0x84),
     o3(0xE5,0xB7,0xB3), o3(0xE5,0xB8,0xAB),
     o3(0xE5,0xBE,0x99), o3(0xE6,0x80,0x9D),
     o3(0xE6,0x8D,0xA8), o3(0xE6,0x96,0x9C),
     o3(0xE6,0x96,0xAF), o3(0xE6,0x9F,0xB6),
     o3(0xE6,0x9F,0xBB), o3(0xE6,0xA2,0xAD),
     o3(0xE6,0xAD,0xBB), o3(0xE6,0xB2,0x99),
     o3(0xE6,0xB3,0x97), o3(0xE6,0xB8,0xA3),
     o3(0xE7,0x80,0x89), o3(0xE7,0x8D,0x85),
     o3(0xE7,0xA0,0x82), o3(0xE7,0xA4,0xBE),
     o3(0xE7,0xA5,0x80), o3(0xE7,0xA5,0xA0),
     o3(0xE7,0xA7,0x81), o3(0xE7,0xAF,0xA9),
     o3(0xE7,0xB4,0x97), o3(0xE7,0xB5,0xB2),
     o3(0xE8,0x82,0x86), o3(0xE8,0x88,0x8D),
     o3(0xE8,0x8E,0x8E), o3(0xE8,0x93,0x91),
     o3(0xE8,0x9B,0x87), o3(0xE8,0xA3,0x9F),
     o3(0xE8,0xA9,0x90), o3(0xE8,0xA9,0x9E),
     o3(0xE8,0xAC,0x9D), o3(0xE8,0xB3,0x9C),
     o3(0xE8,0xB5,0xA6), o3(0xE8,0xBE,0xAD),
     o3(0xE9,0x82,0xAA), o3(0xE9,0xA3,0xBC),
     o3(0xE9,0xA7,0x9F), o3(0xE9,0xBA,0x9D),
     o3(0xE5,0x89,0x8A), o3(0xEF,0xA5,0xA9),
     o3(0xE6,0x9C,0x94), o3(0xEF,0xA5,0xAA),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_DE = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_DE_infos
};


static const struct byte_lookup* const
from_EUC_KR_DF_infos[95] = {
     o3(0xE5,0x82,0x98), o3(0xE5,0x88,0xAA),
     o3(0xE5,0xB1,0xB1), o3(0xE6,0x95,0xA3),
     o3(0xE6,0xB1,0x95), o3(0xE7,0x8F,0x8A),
     o3(0xE7,0x94,0xA3), o3(0xE7,0x96,0x9D),
     o3(0xE7,0xAE,0x97), o3(0xE8,0x92,0x9C),
     o3(0xE9,0x85,0xB8), o3(0xE9,0x9C,0xB0),
     o3(0xE4,0xB9,0xB7), o3(0xE6,0x92,0x92),
     o3(0xE6,0xAE,0xBA), o3(0xE7,0x85,0x9E),
     o3(0xE8,0x96,0xA9), o3(0xE4,0xB8,0x89),
     o3(0xEF,0xA5,0xAB), o3(0xE6,0x9D,0x89),
     o3(0xE6,0xA3,0xAE), o3(0xE6,0xB8,0x97),
     o3(0xE8,0x8A,0x9F), o3(0xE8,0x94,0x98),
     o3(0xE8,0xA1,0xAB), o3(0xE6,0x8F,0xB7),
     o3(0xE6,0xBE,0x81), o3(0xE9,0x88,0x92),
     o3(0xE9,0xA2,0xAF), o3(0xE4,0xB8,0x8A),
     o3(0xE5,0x82,0xB7), o3(0xE5,0x83,0x8F),
     o3(0xE5,0x84,0x9F), o3(0xE5,0x95,0x86),
     o3(0xE5,0x96,0xAA), o3(0xE5,0x98,0x97),
     o3(0xE5,0xAD,0x80), o3(0xE5,0xB0,0x99),
     o3(0xE5,0xB3,0xA0), o3(0xE5,0xB8,0xB8),
     o3(0xE5,0xBA,0x8A), o3(0xE5,0xBA,0xA0),
     o3(0xE5,0xBB,0x82), o3(0xE6,0x83,0xB3),
     o3(0xE6,0xA1,0x91), o3(0xE6,0xA9,0xA1),
     o3(0xE6,0xB9,0x98), o3(0xE7,0x88,0xBD),
     o3(0xE7,0x89,0x80), o3(0xE7,0x8B,0x80),
     o3(0xE7,0x9B,0xB8), o3(0xE7,0xA5,0xA5),
     o3(0xE7,0xAE,0xB1), o3(0xE7,0xBF,0x94),
     o3(0xE8,0xA3,0xB3), o3(0xE8,0xA7,0xB4),
     o3(0xE8,0xA9,0xB3), o3(0xE8,0xB1,0xA1),
     o3(0xE8,0xB3,0x9E), o3(0xE9,0x9C,0x9C),
     o3(0xE5,0xA1,0x9E), o3(0xE7,0x92,0xBD),
     o3(0xE8,0xB3,0xBD), o3(0xE5,0x97,0x87),
     o3(0xEF,0xA5,0xAC), o3(0xE7,0xA9,0xA1),
     o3(0xE7,0xB4,0xA2), o3(0xE8,0x89,0xB2),
     o3(0xE7,0x89,0xB2), o3(0xE7,0x94,0x9F),
     o3(0xE7,0x94,0xA5), o3(0xEF,0xA5,0xAD),
     o3(0xE7,0xAC,0x99), o3(0xE5,0xA2,0x85),
     o3(0xE5,0xA3,0xBB), o3(0xE5,0xB6,0xBC),
     o3(0xE5,0xBA,0x8F), o3(0xE5,0xBA,0xB6),
     o3(0xE5,0xBE,0x90), o3(0xE6,0x81,0x95),
     o3(0xE6,0x8A,0x92), o3(0xE6,0x8D,0xBF),
     o3(0xE6,0x95,0x8D), o3(0xE6,0x9A,0x91),
     o3(0xE6,0x9B,0x99), o3(0xE6,0x9B,0xB8),
     o3(0xE6,0xA0,0x96), o3(0xE6,0xA3,0xB2),
     o3(0xE7,0x8A,0x80), o3(0xE7,0x91,0x9E),
     o3(0xE7,0xAD,0xAE), o3(0xE7,0xB5,0xAE),
     o3(0xE7,0xB7,0x96), o3(0xE7,0xBD,0xB2),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_DF = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_DF_infos
};


static const struct byte_lookup* const
from_EUC_KR_E0_infos[95] = {
     o3(0xE8,0x83,0xA5), o3(0xE8,0x88,0x92),
     o3(0xE8,0x96,0xAF), o3(0xE8,0xA5,0xBF),
     o3(0xE8,0xAA,0x93), o3(0xE9,0x80,0x9D),
     o3(0xE9,0x8B,0xA4), o3(0xE9,0xBB,0x8D),
     o3(0xE9,0xBC,0xA0), o3(0xE5,0xA4,0x95),
     o3(0xE5,0xA5,0xAD), o3(0xE5,0xB8,0xAD),
     o3(0xE6,0x83,0x9C), o3(0xE6,0x98,0x94),
     o3(0xE6,0x99,0xB3), o3(0xE6,0x9E,0x90),
     o3(0xE6,0xB1,0x90), o3(0xE6,0xB7,0x85),
     o3(0xE6,0xBD,0x9F), o3(0xE7,0x9F,0xB3),
     o3(0xE7,0xA2,0xA9), o3(0xE8,0x93,0x86),
     o3(0xE9,0x87,0x8B), o3(0xE9,0x8C,0xAB),
     o3(0xE4,0xBB,0x99), o3(0xE5,0x83,0x8A),
     o3(0xE5,0x85,0x88), o3(0xE5,0x96,0x84),
     o3(0xE5,0xAC,0x8B), o3(0xE5,0xAE,0xA3),
     o3(0xE6,0x89,0x87), o3(0xE6,0x95,0xBE),
     o3(0xE6,0x97,0x8B), o3(0xE6,0xB8,0xB2),
     o3(0xE7,0x85,0xBD), o3(0xE7,0x90,0x81),
     o3(0xE7,0x91,0x84), o3(0xE7,0x92,0x87),
     o3(0xE7,0x92,0xBF), o3(0xE7,0x99,0xAC),
     o3(0xE7,0xA6,0xAA), o3(0xE7,0xB7,0x9A),
     o3(0xE7,0xB9,0x95), o3(0xE7,0xBE,0xA8),
     o3(0xE8,0x85,0xBA), o3(0xE8,0x86,0xB3),
     o3(0xE8,0x88,0xB9), o3(0xE8,0x98,0x9A),
     o3(0xE8,0x9F,0xAC), o3(0xE8,0xA9,0xB5),
     o3(0xE8,0xB7,0xA3), o3(0xE9,0x81,0xB8),
     o3(0xE9,0x8A,0x91), o3(0xE9,0x90,0xA5),
     o3(0xE9,0xA5,0x8D), o3(0xE9,0xAE,0xAE),
     o3(0xE5,0x8D,0xA8), o3(0xE5,0xB1,0x91),
     o3(0xE6,0xA5,0x94), o3(0xE6,0xB3,0x84),
     o3(0xE6,0xB4,0xA9), o3(0xE6,0xB8,0xAB),
     o3(0xE8,0x88,0x8C), o3(0xE8,0x96,0x9B),
     o3(0xE8,0xA4,0xBB), o3(0xE8,0xA8,0xAD),
     o3(0xE8,0xAA,0xAA), o3(0xE9,0x9B,0xAA),
     o3(0xE9,0xBD,0xA7), o3(0xE5,0x89,0xA1),
     o3(0xE6,0x9A,0xB9), o3(0xE6,0xAE,0xB2),
     o3(0xE7,0xBA,0x96), o3(0xE8,0x9F,0xBE),
     o3(0xE8,0xB4,0x8D), o3(0xE9,0x96,0x83),
     o3(0xE9,0x99,0x9D), o3(0xE6,0x94,0x9D),
     o3(0xE6,0xB6,0x89), o3(0xE7,0x87,0xAE),
     o3(0xEF,0xA5,0xAE), o3(0xE5,0x9F,0x8E),
     o3(0xE5,0xA7,0x93), o3(0xE5,0xAE,0xAC),
     o3(0xE6,0x80,0xA7), o3(0xE6,0x83,0xBA),
     o3(0xE6,0x88,0x90), o3(0xE6,0x98,0x9F),
     o3(0xE6,0x99,0x9F), o3(0xE7,0x8C,0xA9),
     o3(0xE7,0x8F,0xB9), o3(0xE7,0x9B,0x9B),
     o3(0xE7,0x9C,0x81), o3(0xE7,0xAD,0xAC),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_E0 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_E0_infos
};


static const struct byte_lookup* const
from_EUC_KR_E1_infos[95] = {
     o3(0xE8,0x81,0x96), o3(0xE8,0x81,0xB2),
     o3(0xE8,0x85,0xA5), o3(0xE8,0xAA,0xA0),
     o3(0xE9,0x86,0x92), o3(0xE4,0xB8,0x96),
     o3(0xE5,0x8B,0xA2), o3(0xE6,0xAD,0xB2),
     o3(0xE6,0xB4,0x97), o3(0xE7,0xA8,0x85),
     o3(0xE7,0xAC,0xB9), o3(0xE7,0xB4,0xB0),
     o3(0xEF,0xA5,0xAF), o3(0xE8,0xB2,0xB0),
     o3(0xE5,0x8F,0xAC), o3(0xE5,0x98,0xAF),
     o3(0xE5,0xA1,0x91), o3(0xE5,0xAE,0xB5),
     o3(0xE5,0xB0,0x8F), o3(0xE5,0xB0,0x91),
     o3(0xE5,0xB7,0xA2), o3(0xE6,0x89,0x80),
     o3(0xE6,0x8E,0x83), o3(0xE6,0x90,0x94),
     o3(0xE6,0x98,0xAD), o3(0xE6,0xA2,0xB3),
     o3(0xE6,0xB2,0xBC), o3(0xE6,0xB6,0x88),
     o3(0xE6,0xBA,0xAF), o3(0xE7,0x80,0x9F),
     o3(0xE7,0x82,0xA4), o3(0xE7,0x87,0x92),
     o3(0xE7,0x94,0xA6), o3(0xE7,0x96,0x8F),
     o3(0xE7,0x96,0x8E), o3(0xE7,0x98,0x99),
     o3(0xE7,0xAC,0x91), o3(0xE7,0xAF,0xA0),
     o3(0xE7,0xB0,0xAB), o3(0xE7,0xB4,0xA0),
     o3(0xE7,0xB4,0xB9), o3(0xE8,0x94,0xAC),
     o3(0xE8,0x95,0xAD), o3(0xE8,0x98,0x87),
     o3(0xE8,0xA8,0xB4), o3(0xE9,0x80,0x8D),
     o3(0xE9,0x81,0xA1), o3(0xE9,0x82,0xB5),
     o3(0xE9,0x8A,0xB7), o3(0xE9,0x9F,0xB6),
     o3(0xE9,0xA8,0xB7), o3(0xE4,0xBF,0x97),
     o3(0xE5,0xB1,0xAC), o3(0xE6,0x9D,0x9F),
     o3(0xE6,0xB6,0x91), o3(0xE7,0xB2,0x9F),
     o3(0xE7,0xBA,0x8C), o3(0xE8,0xAC,0x96),
     o3(0xE8,0xB4,0x96), o3(0xE9,0x80,0x9F),
     o3(0xE5,0xAD,0xAB), o3(0xE5,0xB7,0xBD),
     o3(0xE6,0x90,0x8D), o3(0xE8,0x93,0x80),
     o3(0xE9,0x81,0x9C), o3(0xE9,0xA3,0xA1),
     o3(0xE7,0x8E,0x87), o3(0xE5,0xAE,0x8B),
     o3(0xE6,0x82,0x9A), o3(0xE6,0x9D,0xBE),
     o3(0xE6,0xB7,0x9E), o3(0xE8,0xA8,0x9F),
     o3(0xE8,0xAA,0xA6), o3(0xE9,0x80,0x81),
     o3(0xE9,0xA0,0x8C), o3(0xE5,0x88,0xB7),
     o3(0xEF,0xA5,0xB0), o3(0xE7,0x81,0x91),
     o3(0xE7,0xA2,0x8E), o3(0xE9,0x8E,0x96),
     o3(0xE8,0xA1,0xB0), o3(0xE9,0x87,0x97),
     o3(0xE4,0xBF,0xAE), o3(0xE5,0x8F,0x97),
     o3(0xE5,0x97,0xBD), o3(0xE5,0x9B,0x9A),
     o3(0xE5,0x9E,0x82), o3(0xE5,0xA3,0xBD),
     o3(0xE5,0xAB,0x82), o3(0xE5,0xAE,0x88),
     o3(0xE5,0xB2,0xAB), o3(0xE5,0xB3,0x80),
     o3(0xE5,0xB8,0xA5), o3(0xE6,0x84,0x81),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_E1 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_E1_infos
};


static const struct byte_lookup* const
from_EUC_KR_E2_infos[95] = {
     o3(0xE6,0x88,0x8D), o3(0xE6,0x89,0x8B),
     o3(0xE6,0x8E,0x88), o3(0xE6,0x90,0x9C),
     o3(0xE6,0x94,0xB6), o3(0xE6,0x95,0xB8),
     o3(0xE6,0xA8,0xB9), o3(0xE6,0xAE,0x8A),
     o3(0xE6,0xB0,0xB4), o3(0xE6,0xB4,0x99),
     o3(0xE6,0xBC,0xB1), o3(0xE7,0x87,0xA7),
     o3(0xE7,0x8B,0xA9), o3(0xE7,0x8D,0xB8),
     o3(0xE7,0x90,0x87), o3(0xE7,0x92,0xB2),
     o3(0xE7,0x98,0xA6), o3(0xE7,0x9D,0xA1),
     o3(0xE7,0xA7,0x80), o3(0xE7,0xA9,0x97),
     o3(0xE7,0xAB,0xAA), o3(0xE7,0xB2,0xB9),
     o3(0xE7,0xB6,0x8F), o3(0xE7,0xB6,0xAC),
     o3(0xE7,0xB9,0xA1), o3(0xE7,0xBE,0x9E),
     o3(0xE8,0x84,0xA9), o3(0xE8,0x8C,0xB1),
     o3(0xE8,0x92,0x90), o3(0xE8,0x93,0x9A),
     o3(0xE8,0x97,0xAA), o3(0xE8,0xA2,0x96),
     o3(0xE8,0xAA,0xB0), o3(0xE8,0xAE,0x90),
     o3(0xE8,0xBC,0xB8), o3(0xE9,0x81,0x82),
     o3(0xE9,0x82,0x83), o3(0xE9,0x85,0xAC),
     o3(0xE9,0x8A,0x96), o3(0xE9,0x8A,0xB9),
     o3(0xE9,0x9A,0x8B), o3(0xE9,0x9A,0xA7),
     o3(0xE9,0x9A,0xA8), o3(0xE9,0x9B,0x96),
     o3(0xE9,0x9C,0x80), o3(0xE9,0xA0,0x88),
     o3(0xE9,0xA6,0x96), o3(0xE9,0xAB,0x93),
     o3(0xE9,0xAC,0x9A), o3(0xE5,0x8F,0x94),
     o3(0xE5,0xA1,0xBE), o3(0xE5,0xA4,0x99),
     o3(0xE5,0xAD,0xB0), o3(0xE5,0xAE,0xBF),
     o3(0xE6,0xB7,0x91), o3(0xE6,0xBD,0x9A),
     o3(0xE7,0x86,0x9F), o3(0xE7,0x90,0xA1),
     o3(0xE7,0x92,0xB9), o3(0xE8,0x82,0x85),
     o3(0xE8,0x8F,0xBD), o3(0xE5,0xB7,0xA1),
     o3(0xE5,0xBE,0x87), o3(0xE5,0xBE,0xAA),
     o3(0xE6,0x81,0x82), o3(0xE6,0x97,0xAC),
     o3(0xE6,0xA0,0x92), o3(0xE6,0xA5,0xAF),
     o3(0xE6,0xA9,0x93), o3(0xE6,0xAE,0x89),
     o3(0xE6,0xB4,0xB5), o3(0xE6,0xB7,0xB3),
     o3(0xE7,0x8F,0xA3), o3(0xE7,0x9B,0xBE),
     o3(0xE7,0x9E,0xAC), o3(0xE7,0xAD,0x8D),
     o3(0xE7,0xB4,0x94), o3(0xE8,0x84,0xA3),
     o3(0xE8,0x88,0x9C), o3(0xE8,0x8D,0x80),
     o3(0xE8,0x93,0xB4), o3(0xE8,0x95,0xA3),
     o3(0xE8,0xA9,0xA2), o3(0xE8,0xAB,0x84),
     o3(0xE9,0x86,0x87), o3(0xE9,0x8C,0x9E),
     o3(0xE9,0xA0,0x86), o3(0xE9,0xA6,0xB4),
     o3(0xE6,0x88,0x8C), o3(0xE8,0xA1,0x93),
     o3(0xE8,0xBF,0xB0), o3(0xE9,0x89,0xA5),
     o3(0xE5,0xB4,0x87), o3(0xE5,0xB4,0xA7),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_E2 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_E2_infos
};


static const struct byte_lookup* const
from_EUC_KR_E3_infos[95] = {
     o3(0xE5,0xB5,0xA9), o3(0xE7,0x91,0x9F),
     o3(0xE8,0x86,0x9D), o3(0xE8,0x9D,0xA8),
     o3(0xE6,0xBF,0x95), o3(0xE6,0x8B,0xBE),
     o3(0xE7,0xBF,0x92), o3(0xE8,0xA4,0xB6),
     o3(0xE8,0xA5,0xB2), o3(0xE4,0xB8,0x9E),
     o3(0xE4,0xB9,0x98), o3(0xE5,0x83,0xA7),
     o3(0xE5,0x8B,0x9D), o3(0xE5,0x8D,0x87),
     o3(0xE6,0x89,0xBF), o3(0xE6,0x98,0x87),
     o3(0xE7,0xB9,0xA9), o3(0xE8,0xA0,0x85),
     o3(0xE9,0x99,0x9E), o3(0xE4,0xBE,0x8D),
     o3(0xE5,0x8C,0x99), o3(0xE5,0x98,0xB6),
     o3(0xE5,0xA7,0x8B), o3(0xE5,0xAA,0xA4),
     o3(0xE5,0xB0,0xB8), o3(0xE5,0xB1,0x8E),
     o3(0xE5,0xB1,0x8D), o3(0xE5,0xB8,0x82),
     o3(0xE5,0xBC,0x91), o3(0xE6,0x81,0x83),
     o3(0xE6,0x96,0xBD), o3(0xE6,0x98,0xAF),
     o3(0xE6,0x99,0x82), o3(0xE6,0x9E,0xBE),
     o3(0xE6,0x9F,0xB4), o3(0xE7,0x8C,0x9C),
     o3(0xE7,0x9F,0xA2), o3(0xE7,0xA4,0xBA),
     o3(0xE7,0xBF,0x85), o3(0xE8,0x92,0x94),
     o3(0xE8,0x93,0x8D), o3(0xE8,0xA6,0x96),
     o3(0xE8,0xA9,0xA6), o3(0xE8,0xA9,0xA9),
     o3(0xE8,0xAB,0xA1), o3(0xE8,0xB1,0x95),
     o3(0xE8,0xB1,0xBA), o3(0xE5,0x9F,0xB4),
     o3(0xE5,0xAF,0x94), o3(0xE5,0xBC,0x8F),
     o3(0xE6,0x81,0xAF), o3(0xE6,0x8B,0xAD),
     o3(0xE6,0xA4,0x8D), o3(0xE6,0xAE,0x96),
     o3(0xE6,0xB9,0x9C), o3(0xE7,0x86,0x84),
     o3(0xE7,0xAF,0x92), o3(0xE8,0x9D,0x95),
     o3(0xE8,0xAD,0x98), o3(0xE8,0xBB,0xBE),
     o3(0xE9,0xA3,0x9F), o3(0xE9,0xA3,0xBE),
     o3(0xE4,0xBC,0xB8), o3(0xE4,0xBE,0x81),
     o3(0xE4,0xBF,0xA1), o3(0xE5,0x91,0xBB),
     o3(0xE5,0xA8,0xA0), o3(0xE5,0xAE,0xB8),
     o3(0xE6,0x84,0xBC), o3(0xE6,0x96,0xB0),
     o3(0xE6,0x99,0xA8), o3(0xE7,0x87,0xBC),
     o3(0xE7,0x94,0xB3), o3(0xE7,0xA5,0x9E),
     o3(0xE7,0xB4,0xB3), o3(0xE8,0x85,0x8E),
     o3(0xE8,0x87,0xA3), o3(0xE8,0x8E,0x98),
     o3(0xE8,0x96,0xAA), o3(0xE8,0x97,0x8E),
     o3(0xE8,0x9C,0x83), o3(0xE8,0xA8,0x8A),
     o3(0xE8,0xBA,0xAB), o3(0xE8,0xBE,0x9B),
     o3(0xEF,0xA5,0xB1), o3(0xE8,0xBF,0x85),
     o3(0xE5,0xA4,0xB1), o3(0xE5,0xAE,0xA4),
     o3(0xE5,0xAF,0xA6), o3(0xE6,0x82,0x89),
     o3(0xE5,0xAF,0xA9), o3(0xE5,0xB0,0x8B),
     o3(0xE5,0xBF,0x83), o3(0xE6,0xB2,0x81),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_E3 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_E3_infos
};


static const struct byte_lookup* const
from_EUC_KR_E4_infos[95] = {
     o3(0xEF,0xA5,0xB2), o3(0xE6,0xB7,0xB1),
     o3(0xE7,0x80,0x8B), o3(0xE7,0x94,0x9A),
     o3(0xE8,0x8A,0xAF), o3(0xE8,0xAB,0xB6),
     o3(0xE4,0xBB,0x80), o3(0xE5,0x8D,0x81),
     o3(0xEF,0xA5,0xB3), o3(0xE9,0x9B,0x99),
     o3(0xE6,0xB0,0x8F), o3(0xE4,0xBA,0x9E),
     o3(0xE4,0xBF,0x84), o3(0xE5,0x85,0x92),
     o3(0xE5,0x95,0x9E), o3(0xE5,0xA8,0xA5),
     o3(0xE5,0xB3,0xA8), o3(0xE6,0x88,0x91),
     o3(0xE7,0x89,0x99), o3(0xE8,0x8A,0xBD),
     o3(0xE8,0x8E,0xAA), o3(0xE8,0x9B,0xBE),
     o3(0xE8,0xA1,0x99), o3(0xE8,0xA8,0x9D),
     o3(0xE9,0x98,0xBF), o3(0xE9,0x9B,0x85),
     o3(0xE9,0xA4,0x93), o3(0xE9,0xB4,0x89),
     o3(0xE9,0xB5,0x9D), o3(0xE5,0xA0,0x8A),
     o3(0xE5,0xB2,0xB3), o3(0xE5,0xB6,0xBD),
     o3(0xE5,0xB9,0x84), o3(0xE6,0x83,0xA1),
     o3(0xE6,0x84,0x95), o3(0xE6,0x8F,0xA1),
     o3(0xE6,0xA8,0x82), o3(0xE6,0xB8,0xA5),
     o3(0xE9,0x84,0x82), o3(0xE9,0x8D,0x94),
     o3(0xE9,0xA1,0x8E), o3(0xE9,0xB0,0x90),
     o3(0xE9,0xBD,0xB7), o3(0xE5,0xAE,0x89),
     o3(0xE5,0xB2,0xB8), o3(0xE6,0x8C,0x89),
     o3(0xE6,0x99,0x8F), o3(0xE6,0xA1,0x88),
     o3(0xE7,0x9C,0xBC), o3(0xE9,0x9B,0x81),
     o3(0xE9,0x9E,0x8D), o3(0xE9,0xA1,0x94),
     o3(0xE9,0xAE,0x9F), o3(0xE6,0x96,0xA1),
     o3(0xE8,0xAC,0x81), o3(0xE8,0xBB,0x8B),
     o3(0xE9,0x96,0xBC), o3(0xE5,0x94,0xB5),
     o3(0xE5,0xB2,0xA9), o3(0xE5,0xB7,0x96),
     o3(0xE5,0xBA,0xB5), o3(0xE6,0x9A,0x97),
     o3(0xE7,0x99,0x8C), o3(0xE8,0x8F,0xB4),
     o3(0xE9,0x97,0x87), o3(0xE5,0xA3,0x93),
     o3(0xE6,0x8A,0xBC), o3(0xE7,0x8B,0x8E),
     o3(0xE9,0xB4,0xA8), o3(0xE4,0xBB,0xB0),
     o3(0xE5,0xA4,0xAE), o3(0xE6,0x80,0x8F),
     o3(0xE6,0x98,0xBB), o3(0xE6,0xAE,0x83),
     o3(0xE7,0xA7,0xA7), o3(0xE9,0xB4,0xA6),
     o3(0xE5,0x8E,0x93), o3(0xE5,0x93,0x80),
     o3(0xE5,0x9F,0x83), o3(0xE5,0xB4,0x96),
     o3(0xE6,0x84,0x9B), o3(0xE6,0x9B,0x96),
     o3(0xE6,0xB6,0xAF), o3(0xE7,0xA2,0x8D),
     o3(0xE8,0x89,0xBE), o3(0xE9,0x9A,0x98),
     o3(0xE9,0x9D,0x84), o3(0xE5,0x8E,0x84),
     o3(0xE6,0x89,0xBC), o3(0xE6,0x8E,0x96),
     o3(0xE6,0xB6,0xB2), o3(0xE7,0xB8,0x8A),
     o3(0xE8,0x85,0x8B), o3(0xE9,0xA1,0x8D),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_E4 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_E4_infos
};


static const struct byte_lookup* const
from_EUC_KR_E5_infos[95] = {
     o3(0xE6,0xAB,0xBB), o3(0xE7,0xBD,0x8C),
     o3(0xE9,0xB6,0xAF), o3(0xE9,0xB8,0x9A),
     o3(0xE4,0xB9,0x9F), o3(0xE5,0x80,0xBB),
     o3(0xE5,0x86,0xB6), o3(0xE5,0xA4,0x9C),
     o3(0xE6,0x83,0xB9), o3(0xE6,0x8F,0xB6),
     o3(0xE6,0xA4,0xB0), o3(0xE7,0x88,0xBA),
     o3(0xE8,0x80,0xB6), o3(0xEF,0xA5,0xB4),
     o3(0xE9,0x87,0x8E), o3(0xE5,0xBC,0xB1),
     o3(0xEF,0xA5,0xB5), o3(0xEF,0xA5,0xB6),
     o3(0xE7,0xB4,0x84), o3(0xE8,0x8B,0xA5),
     o3(0xE8,0x91,0xAF), o3(0xE8,0x92,0xBB),
     o3(0xE8,0x97,0xA5), o3(0xE8,0xBA,0x8D),
     o3(0xEF,0xA5,0xB7), o3(0xE4,0xBD,0xAF),
     o3(0xEF,0xA5,0xB8), o3(0xEF,0xA5,0xB9),
     o3(0xE5,0xA3,0xA4), o3(0xE5,0xAD,0x83),
     o3(0xE6,0x81,0x99), o3(0xE6,0x8F,0x9A),
     o3(0xE6,0x94,0x98), o3(0xE6,0x95,0xAD),
     o3(0xE6,0x9A,0x98), o3(0xEF,0xA5,0xBA),
     o3(0xE6,0xA5,0x8A), o3(0xE6,0xA8,0xA3),
     o3(0xE6,0xB4,0x8B), o3(0xE7,0x80,0x81),
     o3(0xE7,0x85,0xAC), o3(0xE7,0x97,0x92),
     o3(0xE7,0x98,0x8D), o3(0xE7,0xA6,0xB3),
     o3(0xE7,0xA9,0xB0), o3(0xEF,0xA5,0xBB),
     o3(0xE7,0xBE,0x8A), o3(0xEF,0xA5,0xBC),
     o3(0xE8,0xA5,0x84), o3(0xEF,0xA5,0xBD),
     o3(0xE8,0xAE,0x93), o3(0xE9,0x87,0x80),
     o3(0xE9,0x99,0xBD), o3(0xEF,0xA5,0xBE),
     o3(0xE9,0xA4,0x8A), o3(0xE5,0x9C,0x84),
     o3(0xE5,0xBE,0xA1), o3(0xE6,0x96,0xBC),
     o3(0xE6,0xBC,0x81), o3(0xE7,0x98,0x80),
     o3(0xE7,0xA6,0xA6), o3(0xE8,0xAA,0x9E),
     o3(0xE9,0xA6,0xAD), o3(0xE9,0xAD,0x9A),
     o3(0xE9,0xBD,0xAC), o3(0xE5,0x84,0x84),
     o3(0xE6,0x86,0xB6), o3(0xE6,0x8A,0x91),
     o3(0xE6,0xAA,0x8D), o3(0xE8,0x87,0x86),
     o3(0xE5,0x81,0x83), o3(0xE5,0xA0,0xB0),
     o3(0xE5,0xBD,0xA6), o3(0xE7,0x84,0x89),
     o3(0xE8,0xA8,0x80), o3(0xE8,0xAB,0xBA),
     o3(0xE5,0xAD,0xBC), o3(0xE8,0x98,0x96),
     o3(0xE4,0xBF,0xBA), o3(0xE5,0x84,0xBC),
     o3(0xE5,0x9A,0xB4), o3(0xE5,0xA5,0x84),
     o3(0xE6,0x8E,0xA9), o3(0xE6,0xB7,0xB9),
     o3(0xE5,0xB6,0xAA), o3(0xE6,0xA5,0xAD),
     o3(0xE5,0x86,0x86), o3(0xE4,0xBA,0x88),
     o3(0xE4,0xBD,0x99), o3(0xEF,0xA5,0xBF),
     o3(0xEF,0xA6,0x80), o3(0xEF,0xA6,0x81),
     o3(0xE5,0xA6,0x82), o3(0xEF,0xA6,0x82),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_E5 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_E5_infos
};


static const struct byte_lookup* const
from_EUC_KR_E6_infos[95] = {
     o3(0xEF,0xA6,0x83), o3(0xE6,0xAD,0x9F),
     o3(0xE6,0xB1,0x9D), o3(0xEF,0xA6,0x84),
     o3(0xE7,0x92,0xB5), o3(0xE7,0xA4,0x96),
     o3(0xEF,0xA6,0x85), o3(0xE8,0x88,0x87),
     o3(0xE8,0x89,0x85), o3(0xE8,0x8C,0xB9),
     o3(0xE8,0xBC,0xBF), o3(0xE8,0xBD,0x9D),
     o3(0xEF,0xA6,0x86), o3(0xE9,0xA4,0x98),
     o3(0xEF,0xA6,0x87), o3(0xEF,0xA6,0x88),
     o3(0xEF,0xA6,0x89), o3(0xE4,0xBA,0xA6),
     o3(0xEF,0xA6,0x8A), o3(0xE5,0x9F,0x9F),
     o3(0xE5,0xBD,0xB9), o3(0xE6,0x98,0x93),
     o3(0xEF,0xA6,0x8B), o3(0xEF,0xA6,0x8C),
     o3(0xE7,0x96,0xAB), o3(0xE7,0xB9,0xB9),
     o3(0xE8,0xAD,0xAF), o3(0xEF,0xA6,0x8D),
     o3(0xE9,0x80,0x86), o3(0xE9,0xA9,0x9B),
     o3(0xE5,0x9A,0xA5), o3(0xE5,0xA0,0xA7),
     o3(0xE5,0xA7,0xB8), o3(0xE5,0xA8,0x9F),
     o3(0xE5,0xAE,0xB4), o3(0xEF,0xA6,0x8E),
     o3(0xE5,0xBB,0xB6), o3(0xEF,0xA6,0x8F),
     o3(0xEF,0xA6,0x90), o3(0xE6,0x8D,0x90),
     o3(0xE6,0x8C,0xBB), o3(0xEF,0xA6,0x91),
     o3(0xE6,0xA4,0xBD), o3(0xE6,0xB2,0x87),
     o3(0xE6,0xB2,0xBF), o3(0xE6,0xB6,0x8E),
     o3(0xE6,0xB6,0x93), o3(0xE6,0xB7,0xB5),
     o3(0xE6,0xBC,0x94), o3(0xEF,0xA6,0x92),
     o3(0xE7,0x83,0x9F), o3(0xE7,0x84,0xB6),
     o3(0xE7,0x85,0x99), o3(0xEF,0xA6,0x93),
     o3(0xE7,0x87,0x83), o3(0xE7,0x87,0x95),
     o3(0xEF,0xA6,0x94), o3(0xE7,0xA1,0x8F),
     o3(0xE7,0xA1,0xAF), o3(0xEF,0xA6,0x95),
     o3(0xE7,0xAD,0xB5), o3(0xE7,0xB7,0xA3),
     o3(0xEF,0xA6,0x96), o3(0xE7,0xB8,0xAF),
     o3(0xEF,0xA6,0x97), o3(0xE8,0xA1,0x8D),
     o3(0xE8,0xBB,0x9F), o3(0xEF,0xA6,0x98),
     o3(0xEF,0xA6,0x99), o3(0xEF,0xA6,0x9A),
     o3(0xE9,0x89,0x9B), o3(0xEF,0xA6,0x9B),
     o3(0xE9,0xB3,0xB6), o3(0xEF,0xA6,0x9C),
     o3(0xEF,0xA6,0x9D), o3(0xEF,0xA6,0x9E),
     o3(0xE6,0x82,0x85), o3(0xE6,0xB6,0x85),
     o3(0xEF,0xA6,0x9F), o3(0xE7,0x86,0xB1),
     o3(0xEF,0xA6,0xA0), o3(0xEF,0xA6,0xA1),
     o3(0xE9,0x96,0xB1), o3(0xE5,0x8E,0xAD),
     o3(0xEF,0xA6,0xA2), o3(0xEF,0xA6,0xA3),
     o3(0xEF,0xA6,0xA4), o3(0xE6,0x9F,0x93),
     o3(0xEF,0xA6,0xA5), o3(0xE7,0x82,0x8E),
     o3(0xE7,0x84,0xB0), o3(0xE7,0x90,0xB0),
     o3(0xE8,0x89,0xB6), o3(0xE8,0x8B,0x92),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_E6 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_E6_infos
};


static const struct byte_lookup* const
from_EUC_KR_E7_infos[95] = {
     o3(0xEF,0xA6,0xA6), o3(0xE9,0x96,0xBB),
     o3(0xE9,0xAB,0xA5), o3(0xE9,0xB9,0xBD),
     o3(0xE6,0x9B,0x84), o3(0xEF,0xA6,0xA7),
     o3(0xE7,0x87,0x81), o3(0xE8,0x91,0x89),
     o3(0xEF,0xA6,0xA8), o3(0xEF,0xA6,0xA9),
     o3(0xE5,0xA1,0x8B), o3(0xEF,0xA6,0xAA),
     o3(0xEF,0xA6,0xAB), o3(0xE5,0xB6,0xB8),
     o3(0xE5,0xBD,0xB1), o3(0xEF,0xA6,0xAC),
     o3(0xE6,0x98,0xA0), o3(0xE6,0x9A,0x8E),
     o3(0xE6,0xA5,0xB9), o3(0xE6,0xA6,0xAE),
     o3(0xE6,0xB0,0xB8), o3(0xE6,0xB3,0xB3),
     o3(0xE6,0xB8,0xB6), o3(0xE6,0xBD,0x81),
     o3(0xE6,0xBF,0x9A), o3(0xE7,0x80,0x9B),
     o3(0xE7,0x80,0xAF), o3(0xE7,0x85,0x90),
     o3(0xE7,0x87,0x9F), o3(0xE7,0x8D,0xB0),
     o3(0xEF,0xA6,0xAD), o3(0xE7,0x91,0x9B),
     o3(0xEF,0xA6,0xAE), o3(0xE7,0x93,0x94),
     o3(0xE7,0x9B,0x88), o3(0xE7,0xA9,0x8E),
     o3(0xE7,0xBA,0x93), o3(0xEF,0xA6,0xAF),
     o3(0xEF,0xA6,0xB0), o3(0xE8,0x8B,0xB1),
     o3(0xE8,0xA9,0xA0), o3(0xE8,0xBF,0x8E),
     o3(0xEF,0xA6,0xB1), o3(0xE9,0x8D,0x88),
     o3(0xEF,0xA6,0xB2), o3(0xE9,0x9C,0x99),
     o3(0xEF,0xA6,0xB3), o3(0xEF,0xA6,0xB4),
     o3(0xE4,0xB9,0x82), o3(0xE5,0x80,0xAA),
     o3(0xEF,0xA6,0xB5), o3(0xE5,0x88,0x88),
     o3(0xE5,0x8F,0xA1), o3(0xE6,0x9B,0xB3),
     o3(0xE6,0xB1,0xAD), o3(0xE6,0xBF,0x8A),
     o3(0xE7,0x8C,0x8A), o3(0xE7,0x9D,0xBF),
     o3(0xE7,0xA9,0xA2), o3(0xE8,0x8A,0xAE),
     o3(0xE8,0x97,0x9D), o3(0xE8,0x98,0x82),
     o3(0xEF,0xA6,0xB6), o3(0xE8,0xA3,0x94),
     o3(0xE8,0xA9,0xA3), o3(0xE8,0xAD,0xBD),
     o3(0xE8,0xB1,0xAB), o3(0xEF,0xA6,0xB7),
     o3(0xE9,0x8A,0xB3), o3(0xEF,0xA6,0xB8),
     o3(0xE9,0x9C,0x93), o3(0xE9,0xA0,0x90),
     o3(0xE4,0xBA,0x94), o3(0xE4,0xBC,0x8D),
     o3(0xE4,0xBF,0x89), o3(0xE5,0x82,0xB2),
     o3(0xE5,0x8D,0x88), o3(0xE5,0x90,0xBE),
     o3(0xE5,0x90,0xB3), o3(0xE5,0x97,0x9A),
     o3(0xE5,0xA1,0xA2), o3(0xE5,0xA2,0xBA),
     o3(0xE5,0xA5,0xA7), o3(0xE5,0xA8,0x9B),
     o3(0xE5,0xAF,0xA4), o3(0xE6,0x82,0x9F),
     o3(0xEF,0xA6,0xB9), o3(0xE6,0x87,0x8A),
     o3(0xE6,0x95,0x96), o3(0xE6,0x97,0xBF),
     o3(0xE6,0x99,0xA4), o3(0xE6,0xA2,0xA7),
     o3(0xE6,0xB1,0x9A), o3(0xE6,0xBE,0xB3),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_E7 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_E7_infos
};


static const struct byte_lookup* const
from_EUC_KR_E8_infos[95] = {
     o3(0xE7,0x83,0x8F), o3(0xE7,0x86,0xAC),
     o3(0xE7,0x8D,0x92), o3(0xE7,0xAD,0xBD),
     o3(0xE8,0x9C,0x88), o3(0xE8,0xAA,0xA4),
     o3(0xE9,0xB0,0xB2), o3(0xE9,0xBC,0x87),
     o3(0xE5,0xB1,0x8B), o3(0xE6,0xB2,0x83),
     o3(0xE7,0x8D,0x84), o3(0xE7,0x8E,0x89),
     o3(0xE9,0x88,0xBA), o3(0xE6,0xBA,0xAB),
     o3(0xE7,0x91,0xA5), o3(0xE7,0x98,0x9F),
     o3(0xE7,0xA9,0xA9), o3(0xE7,0xB8,0x95),
     o3(0xE8,0x98,0x8A), o3(0xE5,0x85,0x80),
     o3(0xE5,0xA3,0x85), o3(0xE6,0x93,0x81),
     o3(0xE7,0x93,0xAE), o3(0xE7,0x94,0x95),
     o3(0xE7,0x99,0xB0), o3(0xE7,0xBF,0x81),
     o3(0xE9,0x82,0x95), o3(0xE9,0x9B,0x8D),
     o3(0xE9,0xA5,0x94), o3(0xE6,0xB8,0xA6),
     o3(0xE7,0x93,0xA6), o3(0xE7,0xAA,0xA9),
     o3(0xE7,0xAA,0xAA), o3(0xE8,0x87,0xA5),
     o3(0xE8,0x9B,0x99), o3(0xE8,0x9D,0xB8),
     o3(0xE8,0xA8,0x9B), o3(0xE5,0xA9,0x89),
     o3(0xE5,0xAE,0x8C), o3(0xE5,0xAE,0x9B),
     o3(0xE6,0xA2,0xA1), o3(0xE6,0xA4,0x80),
     o3(0xE6,0xB5,0xA3), o3(0xE7,0x8E,0xA9),
     o3(0xE7,0x90,0x93), o3(0xE7,0x90,0xAC),
     o3(0xE7,0xA2,0x97), o3(0xE7,0xB7,0xA9),
     o3(0xE7,0xBF,0xAB), o3(0xE8,0x84,0x98),
     o3(0xE8,0x85,0x95), o3(0xE8,0x8E,0x9E),
     o3(0xE8,0xB1,0x8C), o3(0xE9,0x98,0xAE),
     o3(0xE9,0xA0,0x91), o3(0xE6,0x9B,0xB0),
     o3(0xE5,0xBE,0x80), o3(0xE6,0x97,0xBA),
     o3(0xE6,0x9E,0x89), o3(0xE6,0xB1,0xAA),
     o3(0xE7,0x8E,0x8B), o3(0xE5,0x80,0xAD),
     o3(0xE5,0xA8,0x83), o3(0xE6,0xAD,0xAA),
     o3(0xE7,0x9F,0xAE), o3(0xE5,0xA4,0x96),
     o3(0xE5,0xB5,0xAC), o3(0xE5,0xB7,0x8D),
     o3(0xE7,0x8C,0xA5), o3(0xE7,0x95,0x8F),
     o3(0xEF,0xA6,0xBA), o3(0xEF,0xA6,0xBB),
     o3(0xE5,0x83,0xA5), o3(0xE5,0x87,0xB9),
     o3(0xE5,0xA0,0xAF), o3(0xE5,0xA4,0xAD),
     o3(0xE5,0xA6,0x96), o3(0xE5,0xA7,0x9A),
     o3(0xE5,0xAF,0xA5), o3(0xEF,0xA6,0xBC),
     o3(0xEF,0xA6,0xBD), o3(0xE5,0xB6,0xA2),
     o3(0xE6,0x8B,0x97), o3(0xE6,0x90,0x96),
     o3(0xE6,0x92,0x93), o3(0xE6,0x93,0xBE),
     o3(0xEF,0xA6,0xBE), o3(0xE6,0x9B,0x9C),
     o3(0xEF,0xA6,0xBF), o3(0xE6,0xA9,0x88),
     o3(0xEF,0xA7,0x80), o3(0xE7,0x87,0xBF),
     o3(0xE7,0x91,0xA4), o3(0xEF,0xA7,0x81),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_E8 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_E8_infos
};


static const struct byte_lookup* const
from_EUC_KR_E9_infos[95] = {
     o3(0xE7,0xAA,0x88), o3(0xE7,0xAA,0xAF),
     o3(0xE7,0xB9,0x87), o3(0xE7,0xB9,0x9E),
     o3(0xE8,0x80,0x80), o3(0xE8,0x85,0xB0),
     o3(0xEF,0xA7,0x82), o3(0xE8,0x9F,0xAF),
     o3(0xE8,0xA6,0x81), o3(0xE8,0xAC,0xA0),
     o3(0xE9,0x81,0x99), o3(0xEF,0xA7,0x83),
     o3(0xE9,0x82,0x80), o3(0xE9,0xA5,0x92),
     o3(0xE6,0x85,0xBE), o3(0xE6,0xAC,0xB2),
     o3(0xE6,0xB5,0xB4), o3(0xE7,0xB8,0x9F),
     o3(0xE8,0xA4,0xA5), o3(0xE8,0xBE,0xB1),
     o3(0xE4,0xBF,0x91), o3(0xE5,0x82,0xAD),
     o3(0xE5,0x86,0x97), o3(0xE5,0x8B,0x87),
     o3(0xE5,0x9F,0x87), o3(0xE5,0xA2,0x89),
     o3(0xE5,0xAE,0xB9), o3(0xE5,0xBA,0xB8),
     o3(0xE6,0x85,0x82), o3(0xE6,0xA6,0x95),
     o3(0xE6,0xB6,0x8C), o3(0xE6,0xB9,0xA7),
     o3(0xE6,0xBA,0xB6), o3(0xE7,0x86,0x94),
     o3(0xE7,0x91,0xA2), o3(0xE7,0x94,0xA8),
     o3(0xE7,0x94,0xAC), o3(0xE8,0x81,0xB3),
     o3(0xE8,0x8C,0xB8), o3(0xE8,0x93,0x89),
     o3(0xE8,0xB8,0x8A), o3(0xE9,0x8E,0x94),
     o3(0xE9,0x8F,0x9E), o3(0xEF,0xA7,0x84),
     o3(0xE4,0xBA,0x8E), o3(0xE4,0xBD,0x91),
     o3(0xE5,0x81,0xB6), o3(0xE5,0x84,0xAA),
     o3(0xE5,0x8F,0x88), o3(0xE5,0x8F,0x8B),
     o3(0xE5,0x8F,0xB3), o3(0xE5,0xAE,0x87),
     o3(0xE5,0xAF,0x93), o3(0xE5,0xB0,0xA4),
     o3(0xE6,0x84,0x9A), o3(0xE6,0x86,0x82),
     o3(0xE6,0x97,0xB4), o3(0xE7,0x89,0x9B),
     o3(0xE7,0x8E,0x97), o3(0xE7,0x91,0x80),
     o3(0xE7,0x9B,0x82), o3(0xE7,0xA5,0x90),
     o3(0xE7,0xA6,0x91), o3(0xE7,0xA6,0xB9),
     o3(0xE7,0xB4,0x86), o3(0xE7,0xBE,0xBD),
     o3(0xE8,0x8A,0x8B), o3(0xE8,0x97,0x95),
     o3(0xE8,0x99,0x9E), o3(0xE8,0xBF,0x82),
     o3(0xE9,0x81,0x87), o3(0xE9,0x83,0xB5),
     o3(0xE9,0x87,0xAA), o3(0xE9,0x9A,0x85),
     o3(0xE9,0x9B,0xA8), o3(0xE9,0x9B,0xA9),
     o3(0xE5,0x8B,0x96), o3(0xE5,0xBD,0xA7),
     o3(0xE6,0x97,0xAD), o3(0xE6,0x98,0xB1),
     o3(0xE6,0xA0,0xAF), o3(0xE7,0x85,0x9C),
     o3(0xE7,0xA8,0xB6), o3(0xE9,0x83,0x81),
     o3(0xE9,0xA0,0x8A), o3(0xE4,0xBA,0x91),
     o3(0xEF,0xA7,0x85), o3(0xE6,0xA9,0x92),
     o3(0xE6,0xAE,0x9E), o3(0xE6,0xBE,0x90),
     o3(0xE7,0x86,0x89), o3(0xE8,0x80,0x98),
     o3(0xE8,0x8A,0xB8), o3(0xE8,0x95,0x93),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_E9 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_E9_infos
};


static const struct byte_lookup* const
from_EUC_KR_EA_infos[95] = {
     o3(0xE9,0x81,0x8B), o3(0xE9,0x9A,0x95),
     o3(0xE9,0x9B,0xB2), o3(0xE9,0x9F,0xBB),
     o3(0xE8,0x94,0x9A), o3(0xE9,0xAC,0xB1),
     o3(0xE4,0xBA,0x90), o3(0xE7,0x86,0x8A),
     o3(0xE9,0x9B,0x84), o3(0xE5,0x85,0x83),
     o3(0xE5,0x8E,0x9F), o3(0xE5,0x93,0xA1),
     o3(0xE5,0x9C,0x93), o3(0xE5,0x9C,0x92),
     o3(0xE5,0x9E,0xA3), o3(0xE5,0xAA,0x9B),
     o3(0xE5,0xAB,0x84), o3(0xE5,0xAF,0x83),
     o3(0xE6,0x80,0xA8), o3(0xE6,0x84,0xBF),
     o3(0xE6,0x8F,0xB4), o3(0xE6,0xB2,0x85),
     o3(0xE6,0xB4,0xB9), o3(0xE6,0xB9,0xB2),
     o3(0xE6,0xBA,0x90), o3(0xE7,0x88,0xB0),
     o3(0xE7,0x8C,0xBF), o3(0xE7,0x91,0x97),
     o3(0xE8,0x8B,0x91), o3(0xE8,0xA2,0x81),
     o3(0xE8,0xBD,0x85), o3(0xE9,0x81,0xA0),
     o3(0xEF,0xA7,0x86), o3(0xE9,0x99,0xA2),
     o3(0xE9,0xA1,0x98), o3(0xE9,0xB4,0x9B),
     o3(0xE6,0x9C,0x88), o3(0xE8,0xB6,0x8A),
     o3(0xE9,0x89,0x9E), o3(0xE4,0xBD,0x8D),
     o3(0xE5,0x81,0x89), o3(0xE5,0x83,0x9E),
     o3(0xE5,0x8D,0xB1), o3(0xE5,0x9C,0x8D),
     o3(0xE5,0xA7,0x94), o3(0xE5,0xA8,0x81),
     o3(0xE5,0xB0,0x89), o3(0xE6,0x85,0xB0),
     o3(0xE6,0x9A,0x90), o3(0xE6,0xB8,0xAD),
     o3(0xE7,0x88,0xB2), o3(0xE7,0x91,0x8B),
     o3(0xE7,0xB7,0xAF), o3(0xE8,0x83,0x83),
     o3(0xE8,0x90,0x8E), o3(0xE8,0x91,0xA6),
     o3(0xE8,0x94,0xBF), o3(0xE8,0x9D,0x9F),
     o3(0xE8,0xA1,0x9B), o3(0xE8,0xA4,0x98),
     o3(0xE8,0xAC,0x82), o3(0xE9,0x81,0x95),
     o3(0xE9,0x9F,0x8B), o3(0xE9,0xAD,0x8F),
     o3(0xE4,0xB9,0xB3), o3(0xE4,0xBE,0x91),
     o3(0xE5,0x84,0x92), o3(0xE5,0x85,0xAA),
     o3(0xEF,0xA7,0x87), o3(0xE5,0x94,0xAF),
     o3(0xE5,0x96,0xA9), o3(0xE5,0xAD,0xBA),
     o3(0xE5,0xAE,0xA5), o3(0xE5,0xB9,0xBC),
     o3(0xE5,0xB9,0xBD), o3(0xE5,0xBA,0xBE),
     o3(0xE6,0x82,0xA0), o3(0xE6,0x83,0x9F),
     o3(0xE6,0x84,0x88), o3(0xE6,0x84,0x89),
     o3(0xE6,0x8F,0x84), o3(0xE6,0x94,0xB8),
     o3(0xE6,0x9C,0x89), o3(0xEF,0xA7,0x88),
     o3(0xE6,0x9F,0x94), o3(0xE6,0x9F,0x9A),
     o3(0xEF,0xA7,0x89), o3(0xE6,0xA5,0xA1),
     o3(0xE6,0xA5,0xA2), o3(0xE6,0xB2,0xB9),
     o3(0xE6,0xB4,0xA7), o3(0xEF,0xA7,0x8A),
     o3(0xE6,0xB8,0xB8), o3(0xEF,0xA7,0x8B),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_EA = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_EA_infos
};


static const struct byte_lookup* const
from_EUC_KR_EB_infos[95] = {
     o3(0xE6,0xBF,0xA1), o3(0xE7,0x8C,0xB6),
     o3(0xE7,0x8C,0xB7), o3(0xEF,0xA7,0x8C),
     o3(0xE7,0x91,0x9C), o3(0xE7,0x94,0xB1),
     o3(0xEF,0xA7,0x8D), o3(0xE7,0x99,0x92),
     o3(0xEF,0xA7,0x8E), o3(0xEF,0xA7,0x8F),
     o3(0xE7,0xB6,0xAD), o3(0xE8,0x87,0xBE),
     o3(0xE8,0x90,0xB8), o3(0xE8,0xA3,0x95),
     o3(0xE8,0xAA,0x98), o3(0xE8,0xAB,0x9B),
     o3(0xE8,0xAB,0xAD), o3(0xE8,0xB8,0xB0),
     o3(0xE8,0xB9,0x82), o3(0xE9,0x81,0x8A),
     o3(0xE9,0x80,0xBE), o3(0xE9,0x81,0xBA),
     o3(0xE9,0x85,0x89), o3(0xE9,0x87,0x89),
     o3(0xE9,0x8D,0xAE), o3(0xEF,0xA7,0x90),
     o3(0xEF,0xA7,0x91), o3(0xE5,0xA0,0x89),
     o3(0xEF,0xA7,0x92), o3(0xE6,0xAF,0x93),
     o3(0xE8,0x82,0x89), o3(0xE8,0x82,0xB2),
     o3(0xEF,0xA7,0x93), o3(0xEF,0xA7,0x94),
     o3(0xE5,0x85,0x81), o3(0xE5,0xA5,0xAB),
     o3(0xE5,0xB0,0xB9), o3(0xEF,0xA7,0x95),
     o3(0xEF,0xA7,0x96), o3(0xE6,0xBD,0xA4),
     o3(0xE7,0x8E,0xA7), o3(0xE8,0x83,0xA4),
     o3(0xE8,0xB4,0x87), o3(0xEF,0xA7,0x97),
     o3(0xE9,0x88,0x97), o3(0xE9,0x96,0x8F),
     o3(0xEF,0xA7,0x98), o3(0xEF,0xA7,0x99),
     o3(0xEF,0xA7,0x9A), o3(0xEF,0xA7,0x9B),
     o3(0xE8,0x81,0xBF), o3(0xE6,0x88,0x8E),
     o3(0xE7,0x80,0x9C), o3(0xE7,0xB5,0xA8),
     o3(0xE8,0x9E,0x8D), o3(0xEF,0xA7,0x9C),
     o3(0xE5,0x9E,0xA0), o3(0xE6,0x81,0xA9),
     o3(0xE6,0x85,0x87), o3(0xE6,0xAE,0xB7),
     o3(0xE8,0xAA,0xBE), o3(0xE9,0x8A,0x80),
     o3(0xE9,0x9A,0xB1), o3(0xE4,0xB9,0x99),
     o3(0xE5,0x90,0x9F), o3(0xE6,0xB7,0xAB),
     o3(0xE8,0x94,0xAD), o3(0xE9,0x99,0xB0),
     o3(0xE9,0x9F,0xB3), o3(0xE9,0xA3,0xAE),
     o3(0xE6,0x8F,0x96), o3(0xE6,0xB3,0xA3),
     o3(0xE9,0x82,0x91), o3(0xE5,0x87,0x9D),
     o3(0xE6,0x87,0x89), o3(0xE8,0x86,0xBA),
     o3(0xE9,0xB7,0xB9), o3(0xE4,0xBE,0x9D),
     o3(0xE5,0x80,0x9A), o3(0xE5,0x84,0x80),
     o3(0xE5,0xAE,0x9C), o3(0xE6,0x84,0x8F),
     o3(0xE6,0x87,0xBF), o3(0xE6,0x93,0xAC),
     o3(0xE6,0xA4,0x85), o3(0xE6,0xAF,0x85),
     o3(0xE7,0x96,0x91), o3(0xE7,0x9F,0xA3),
     o3(0xE7,0xBE,0xA9), o3(0xE8,0x89,0xA4),
     o3(0xE8,0x96,0x8F), o3(0xE8,0x9F,0xBB),
     o3(0xE8,0xA1,0xA3), o3(0xE8,0xAA,0xBC),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_EB = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_EB_infos
};


static const struct byte_lookup* const
from_EUC_KR_EC_infos[95] = {
     o3(0xE8,0xAD,0xB0), o3(0xE9,0x86,0xAB),
     o3(0xE4,0xBA,0x8C), o3(0xE4,0xBB,0xA5),
     o3(0xE4,0xBC,0x8A), o3(0xEF,0xA7,0x9D),
     o3(0xEF,0xA7,0x9E), o3(0xE5,0xA4,0xB7),
     o3(0xE5,0xA7,0xA8), o3(0xEF,0xA7,0x9F),
     o3(0xE5,0xB7,0xB2), o3(0xE5,0xBC,0x9B),
     o3(0xE5,0xBD,0x9B), o3(0xE6,0x80,0xA1),
     o3(0xEF,0xA7,0xA0), o3(0xEF,0xA7,0xA1),
     o3(0xEF,0xA7,0xA2), o3(0xEF,0xA7,0xA3),
     o3(0xE7,0x88,0xBE), o3(0xE7,0x8F,0xA5),
     o3(0xEF,0xA7,0xA4), o3(0xE7,0x95,0xB0),
     o3(0xE7,0x97,0x8D), o3(0xEF,0xA7,0xA5),
     o3(0xE7,0xA7,0xBB), o3(0xEF,0xA7,0xA6),
     o3(0xE8,0x80,0x8C), o3(0xE8,0x80,0xB3),
     o3(0xE8,0x82,0x84), o3(0xE8,0x8B,0xA1),
     o3(0xE8,0x8D,0x91), o3(0xEF,0xA7,0xA7),
     o3(0xEF,0xA7,0xA8), o3(0xE8,0xB2,0xBD),
     o3(0xE8,0xB2,0xB3), o3(0xE9,0x82,0x87),
     o3(0xEF,0xA7,0xA9), o3(0xEF,0xA7,0xAA),
     o3(0xE9,0xA3,0xB4), o3(0xE9,0xA4,0x8C),
     o3(0xEF,0xA7,0xAB), o3(0xEF,0xA7,0xAC),
     o3(0xE7,0x80,0xB7), o3(0xE7,0x9B,0x8A),
     o3(0xE7,0xBF,0x8A), o3(0xE7,0xBF,0x8C),
     o3(0xE7,0xBF,0xBC), o3(0xE8,0xAC,0x9A),
     o3(0xE4,0xBA,0xBA), o3(0xE4,0xBB,0x81),
     o3(0xE5,0x88,0x83), o3(0xE5,0x8D,0xB0),
     o3(0xEF,0xA7,0xAD), o3(0xE5,0x92,0xBD),
     o3(0xE5,0x9B,0xA0), o3(0xE5,0xA7,0xBB),
     o3(0xE5,0xAF,0x85), o3(0xE5,0xBC,0x95),
     o3(0xE5,0xBF,0x8D), o3(0xE6,0xB9,0xAE),
     o3(0xEF,0xA7,0xAE), o3(0xEF,0xA7,0xAF),
     o3(0xE7,0xB5,0xAA), o3(0xE8,0x8C,0xB5),
     o3(0xEF,0xA7,0xB0), o3(0xE8,0x9A,0x93),
     o3(0xE8,0xAA,0x8D), o3(0xEF,0xA7,0xB1),
     o3(0xE9,0x9D,0xAD), o3(0xE9,0x9D,0xB7),
     o3(0xEF,0xA7,0xB2), o3(0xEF,0xA7,0xB3),
     o3(0xE4,0xB8,0x80), o3(0xE4,0xBD,0x9A),
     o3(0xE4,0xBD,0xBE), o3(0xE5,0xA3,0xB9),
     o3(0xE6,0x97,0xA5), o3(0xE6,0xBA,0xA2),
     o3(0xE9,0x80,0xB8), o3(0xE9,0x8E,0xB0),
     o3(0xE9,0xA6,0xB9), o3(0xE4,0xBB,0xBB),
     o3(0xE5,0xA3,0xAC), o3(0xE5,0xA6,0x8A),
     o3(0xE5,0xA7,0x99), o3(0xE6,0x81,0x81),
     o3(0xEF,0xA7,0xB4), o3(0xEF,0xA7,0xB5),
     o3(0xE7,0xA8,0x94), o3(0xEF,0xA7,0xB6),
     o3(0xE8,0x8D,0x8F), o3(0xE8,0xB3,0x83),
     o3(0xE5,0x85,0xA5), o3(0xE5,0x8D,0x84),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_EC = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_EC_infos
};


static const struct byte_lookup* const
from_EUC_KR_ED_infos[95] = {
     o3(0xEF,0xA7,0xB7), o3(0xEF,0xA7,0xB8),
     o3(0xEF,0xA7,0xB9), o3(0xE4,0xBB,0x8D),
     o3(0xE5,0x89,0xA9), o3(0xE5,0xAD,0x95),
     o3(0xE8,0x8A,0xBF), o3(0xE4,0xBB,0x94),
     o3(0xE5,0x88,0xBA), o3(0xE5,0x92,0xA8),
     o3(0xE5,0xA7,0x89), o3(0xE5,0xA7,0xBF),
     o3(0xE5,0xAD,0x90), o3(0xE5,0xAD,0x97),
     o3(0xE5,0xAD,0x9C), o3(0xE6,0x81,0xA3),
     o3(0xE6,0x85,0x88), o3(0xE6,0xBB,0x8B),
     o3(0xE7,0x82,0x99), o3(0xE7,0x85,0xAE),
     o3(0xE7,0x8E,0x86), o3(0xE7,0x93,0xB7),
     o3(0xE7,0x96,0xB5), o3(0xE7,0xA3,0x81),
     o3(0xE7,0xB4,0xAB), o3(0xE8,0x80,0x85),
     o3(0xE8,0x87,0xAA), o3(0xE8,0x8C,0xA8),
     o3(0xE8,0x94,0x97), o3(0xE8,0x97,0x89),
     o3(0xE8,0xAB,0xAE), o3(0xE8,0xB3,0x87),
     o3(0xE9,0x9B,0x8C), o3(0xE4,0xBD,0x9C),
     o3(0xE5,0x8B,0xBA), o3(0xE5,0x9A,0xBC),
     o3(0xE6,0x96,0xAB), o3(0xE6,0x98,0xA8),
     o3(0xE7,0x81,0xBC), o3(0xE7,0x82,0xB8),
     o3(0xE7,0x88,0xB5), o3(0xE7,0xB6,0xBD),
     o3(0xE8,0x8A,0x8D), o3(0xE9,0x85,0x8C),
     o3(0xE9,0x9B,0x80), o3(0xE9,0xB5,0xB2),
     o3(0xE5,0xAD,0xB1), o3(0xE6,0xA3,0xA7),
     o3(0xE6,0xAE,0x98), o3(0xE6,0xBD,0xBA),
     o3(0xE7,0x9B,0x9E), o3(0xE5,0xB2,0x91),
     o3(0xE6,0x9A,0xAB), o3(0xE6,0xBD,0x9B),
     o3(0xE7,0xAE,0xB4), o3(0xE7,0xB0,0xAA),
     o3(0xE8,0xA0,0xB6), o3(0xE9,0x9B,0x9C),
     o3(0xE4,0xB8,0x88), o3(0xE4,0xBB,0x97),
     o3(0xE5,0x8C,0xA0), o3(0xE5,0xA0,0xB4),
     o3(0xE5,0xA2,0xBB), o3(0xE5,0xA3,0xAF),
     o3(0xE5,0xA5,0xAC), o3(0xE5,0xB0,0x87),
     o3(0xE5,0xB8,0xB3), o3(0xE5,0xBA,0x84),
     o3(0xE5,0xBC,0xB5), o3(0xE6,0x8E,0x8C),
     o3(0xE6,0x9A,0xB2), o3(0xE6,0x9D,0x96),
     o3(0xE6,0xA8,0x9F), o3(0xE6,0xAA,0xA3),
     o3(0xE6,0xAC,0x8C), o3(0xE6,0xBC,0xBF),
     o3(0xE7,0x89,0x86), o3(0xEF,0xA7,0xBA),
     o3(0xE7,0x8D,0x90), o3(0xE7,0x92,0x8B),
     o3(0xE7,0xAB,0xA0), o3(0xE7,0xB2,0xA7),
     o3(0xE8,0x85,0xB8), o3(0xE8,0x87,0x9F),
     o3(0xE8,0x87,0xA7), o3(0xE8,0x8E,0x8A),
     o3(0xE8,0x91,0xAC), o3(0xE8,0x94,0xA3),
     o3(0xE8,0x96,0x94), o3(0xE8,0x97,0x8F),
     o3(0xE8,0xA3,0x9D), o3(0xE8,0xB4,0x93),
     o3(0xE9,0x86,0xAC), o3(0xE9,0x95,0xB7),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_ED = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_ED_infos
};


static const struct byte_lookup* const
from_EUC_KR_EE_infos[95] = {
     o3(0xE9,0x9A,0x9C), o3(0xE5,0x86,0x8D),
     o3(0xE5,0x93,0x89), o3(0xE5,0x9C,0xA8),
     o3(0xE5,0xAE,0xB0), o3(0xE6,0x89,0x8D),
     o3(0xE6,0x9D,0x90), o3(0xE6,0xA0,0xBD),
     o3(0xE6,0xA2,0x93), o3(0xE6,0xB8,0xBD),
     o3(0xE6,0xBB,0x93), o3(0xE7,0x81,0xBD),
     o3(0xE7,0xB8,0xA1), o3(0xE8,0xA3,0x81),
     o3(0xE8,0xB2,0xA1), o3(0xE8,0xBC,0x89),
     o3(0xE9,0xBD,0x8B), o3(0xE9,0xBD,0x8E),
     o3(0xE7,0x88,0xAD), o3(0xE7,0xAE,0x8F),
     o3(0xE8,0xAB,0x8D), o3(0xE9,0x8C,0x9A),
     o3(0xE4,0xBD,0x87), o3(0xE4,0xBD,0x8E),
     o3(0xE5,0x84,0xB2), o3(0xE5,0x92,0x80),
     o3(0xE5,0xA7,0x90), o3(0xE5,0xBA,0x95),
     o3(0xE6,0x8A,0xB5), o3(0xE6,0x9D,0xB5),
     o3(0xE6,0xA5,0xAE), o3(0xE6,0xA8,0x97),
     o3(0xE6,0xB2,0xAE), o3(0xE6,0xB8,0x9A),
     o3(0xE7,0x8B,0x99), o3(0xE7,0x8C,0xAA),
     o3(0xE7,0x96,0xBD), o3(0xE7,0xAE,0xB8),
     o3(0xE7,0xB4,0xB5), o3(0xE8,0x8B,0xA7),
     o3(0xE8,0x8F,0xB9), o3(0xE8,0x91,0x97),
     o3(0xE8,0x97,0xB7), o3(0xE8,0xA9,0x9B),
     o3(0xE8,0xB2,0xAF), o3(0xE8,0xBA,0x87),
     o3(0xE9,0x80,0x99), o3(0xE9,0x82,0xB8),
     o3(0xE9,0x9B,0x8E), o3(0xE9,0xBD,0x9F),
     o3(0xE5,0x8B,0xA3), o3(0xE5,0x90,0x8A),
     o3(0xE5,0xAB,0xA1), o3(0xE5,0xAF,0x82),
     o3(0xE6,0x91,0x98), o3(0xE6,0x95,0xB5),
     o3(0xE6,0xBB,0xB4), o3(0xE7,0x8B,0x84),
     o3(0xEF,0xA7,0xBB), o3(0xE7,0x9A,0x84),
     o3(0xE7,0xA9,0x8D), o3(0xE7,0xAC,0x9B),
     o3(0xE7,0xB1,0x8D), o3(0xE7,0xB8,0xBE),
     o3(0xE7,0xBF,0x9F), o3(0xE8,0x8D,0xBB),
     o3(0xE8,0xAC,0xAB), o3(0xE8,0xB3,0x8A),
     o3(0xE8,0xB5,0xA4), o3(0xE8,0xB7,0xA1),
     o3(0xE8,0xB9,0x9F), o3(0xE8,0xBF,0xAA),
     o3(0xE8,0xBF,0xB9), o3(0xE9,0x81,0xA9),
     o3(0xE9,0x8F,0x91), o3(0xE4,0xBD,0x83),
     o3(0xE4,0xBD,0xBA), o3(0xE5,0x82,0xB3),
     o3(0xE5,0x85,0xA8), o3(0xE5,0x85,0xB8),
     o3(0xE5,0x89,0x8D), o3(0xE5,0x89,0xAA),
     o3(0xE5,0xA1,0xA1), o3(0xE5,0xA1,0xBC),
     o3(0xE5,0xA5,0xA0), o3(0xE5,0xB0,0x88),
     o3(0xE5,0xB1,0x95), o3(0xE5,0xBB,0x9B),
     o3(0xE6,0x82,0x9B), o3(0xE6,0x88,0xB0),
     o3(0xE6,0xA0,0x93), o3(0xE6,0xAE,0xBF),
     o3(0xE6,0xB0,0x88), o3(0xE6,0xBE,0xB1),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_EE = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_EE_infos
};


static const struct byte_lookup* const
from_EUC_KR_EF_infos[95] = {
     o3(0xE7,0x85,0x8E), o3(0xE7,0x90,0xA0),
     o3(0xE7,0x94,0xB0), o3(0xE7,0x94,0xB8),
     o3(0xE7,0x95,0x91), o3(0xE7,0x99,0xB2),
     o3(0xE7,0xAD,0x8C), o3(0xE7,0xAE,0x8B),
     o3(0xE7,0xAE,0xAD), o3(0xE7,0xAF,0x86),
     o3(0xE7,0xBA,0x8F), o3(0xE8,0xA9,0xAE),
     o3(0xE8,0xBC,0xBE), o3(0xE8,0xBD,0x89),
     o3(0xE9,0x88,0xBF), o3(0xE9,0x8A,0x93),
     o3(0xE9,0x8C,0xA2), o3(0xE9,0x90,0xAB),
     o3(0xE9,0x9B,0xBB), o3(0xE9,0xA1,0x9A),
     o3(0xE9,0xA1,0xAB), o3(0xE9,0xA4,0x9E),
     o3(0xE5,0x88,0x87), o3(0xE6,0x88,0xAA),
     o3(0xE6,0x8A,0x98), o3(0xE6,0xB5,0x99),
     o3(0xE7,0x99,0xA4), o3(0xE7,0xAB,0x8A),
     o3(0xE7,0xAF,0x80), o3(0xE7,0xB5,0xB6),
     o3(0xE5,0x8D,0xA0), o3(0xE5,0xB2,0xBE),
     o3(0xE5,0xBA,0x97), o3(0xE6,0xBC,0xB8),
     o3(0xE7,0x82,0xB9), o3(0xE7,0xB2,0x98),
     o3(0xE9,0x9C,0x91), o3(0xE9,0xAE,0x8E),
     o3(0xE9,0xBB,0x9E), o3(0xE6,0x8E,0xA5),
     o3(0xE6,0x91,0xBA), o3(0xE8,0x9D,0xB6),
     o3(0xE4,0xB8,0x81), o3(0xE4,0xBA,0x95),
     o3(0xE4,0xBA,0xAD), o3(0xE5,0x81,0x9C),
     o3(0xE5,0x81,0xB5), o3(0xE5,0x91,0x88),
     o3(0xE5,0xA7,0x83), o3(0xE5,0xAE,0x9A),
     o3(0xE5,0xB9,0x80), o3(0xE5,0xBA,0xAD),
     o3(0xE5,0xBB,0xB7), o3(0xE5,0xBE,0x81),
     o3(0xE6,0x83,0x85), o3(0xE6,0x8C,0xBA),
     o3(0xE6,0x94,0xBF), o3(0xE6,0x95,0xB4),
     o3(0xE6,0x97,0x8C), o3(0xE6,0x99,0xB6),
     o3(0xE6,0x99,0xB8), o3(0xE6,0x9F,0xBE),
     o3(0xE6,0xA5,0xA8), o3(0xE6,0xAA,0x89),
     o3(0xE6,0xAD,0xA3), o3(0xE6,0xB1,0x80),
     o3(0xE6,0xB7,0x80), o3(0xE6,0xB7,0xA8),
     o3(0xE6,0xB8,0x9F), o3(0xE6,0xB9,0x9E),
     o3(0xE7,0x80,0x9E), o3(0xE7,0x82,0xA1),
     o3(0xE7,0x8E,0x8E), o3(0xE7,0x8F,0xBD),
     o3(0xE7,0x94,0xBA), o3(0xE7,0x9D,0x9B),
     o3(0xE7,0xA2,0x87), o3(0xE7,0xA6,0x8E),
     o3(0xE7,0xA8,0x8B), o3(0xE7,0xA9,0xBD),
     o3(0xE7,0xB2,0xBE), o3(0xE7,0xB6,0x8E),
     o3(0xE8,0x89,0x87), o3(0xE8,0xA8,0x82),
     o3(0xE8,0xAB,0xAA), o3(0xE8,0xB2,0x9E),
     o3(0xE9,0x84,0xAD), o3(0xE9,0x85,0x8A),
     o3(0xE9,0x87,0x98), o3(0xE9,0x89,0xA6),
     o3(0xE9,0x8B,0x8C), o3(0xE9,0x8C,0xA0),
     o3(0xE9,0x9C,0x86), o3(0xE9,0x9D,0x96),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_EF = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_EF_infos
};


static const struct byte_lookup* const
from_EUC_KR_F0_infos[95] = {
     o3(0xE9,0x9D,0x9C), o3(0xE9,0xA0,0x82),
     o3(0xE9,0xBC,0x8E), o3(0xE5,0x88,0xB6),
     o3(0xE5,0x8A,0x91), o3(0xE5,0x95,0xBC),
     o3(0xE5,0xA0,0xA4), o3(0xE5,0xB8,0x9D),
     o3(0xE5,0xBC,0x9F), o3(0xE6,0x82,0x8C),
     o3(0xE6,0x8F,0x90), o3(0xE6,0xA2,0xAF),
     o3(0xE6,0xBF,0x9F), o3(0xE7,0xA5,0xAD),
     o3(0xE7,0xAC,0xAC), o3(0xE8,0x87,0x8D),
     o3(0xE8,0x96,0xBA), o3(0xE8,0xA3,0xBD),
     o3(0xE8,0xAB,0xB8), o3(0xE8,0xB9,0x84),
     o3(0xE9,0x86,0x8D), o3(0xE9,0x99,0xA4),
     o3(0xE9,0x9A,0x9B), o3(0xE9,0x9C,0xBD),
     o3(0xE9,0xA1,0x8C), o3(0xE9,0xBD,0x8A),
     o3(0xE4,0xBF,0x8E), o3(0xE5,0x85,0x86),
     o3(0xE5,0x87,0x8B), o3(0xE5,0x8A,0xA9),
     o3(0xE5,0x98,0xB2), o3(0xE5,0xBC,0x94),
     o3(0xE5,0xBD,0xAB), o3(0xE6,0x8E,0xAA),
     o3(0xE6,0x93,0x8D), o3(0xE6,0x97,0xA9),
     o3(0xE6,0x99,0x81), o3(0xE6,0x9B,0xBA),
     o3(0xE6,0x9B,0xB9), o3(0xE6,0x9C,0x9D),
     o3(0xE6,0xA2,0x9D), o3(0xE6,0xA3,0x97),
     o3(0xE6,0xA7,0xBD), o3(0xE6,0xBC,0x95),
     o3(0xE6,0xBD,0xAE), o3(0xE7,0x85,0xA7),
     o3(0xE7,0x87,0xA5), o3(0xE7,0x88,0xAA),
     o3(0xE7,0x92,0xAA), o3(0xE7,0x9C,0xBA),
     o3(0xE7,0xA5,0x96), o3(0xE7,0xA5,0x9A),
     o3(0xE7,0xA7,0x9F), o3(0xE7,0xA8,0xA0),
     o3(0xE7,0xAA,0x95), o3(0xE7,0xB2,0x97),
     o3(0xE7,0xB3,0x9F), o3(0xE7,0xB5,0x84),
     o3(0xE7,0xB9,0xB0), o3(0xE8,0x82,0x87),
     o3(0xE8,0x97,0xBB), o3(0xE8,0x9A,0xA4),
     o3(0xE8,0xA9,0x94), o3(0xE8,0xAA,0xBF),
     o3(0xE8,0xB6,0x99), o3(0xE8,0xBA,0x81),
     o3(0xE9,0x80,0xA0), o3(0xE9,0x81,0xAD),
     o3(0xE9,0x87,0xA3), o3(0xE9,0x98,0xBB),
     o3(0xE9,0x9B,0x95), o3(0xE9,0xB3,0xA5),
     o3(0xE6,0x97,0x8F), o3(0xE7,0xB0,0x87),
     o3(0xE8,0xB6,0xB3), o3(0xE9,0x8F,0x83),
     o3(0xE5,0xAD,0x98), o3(0xE5,0xB0,0x8A),
     o3(0xE5,0x8D,0x92), o3(0xE6,0x8B,0x99),
     o3(0xE7,0x8C,0x9D), o3(0xE5,0x80,0xA7),
     o3(0xE5,0xAE,0x97), o3(0xE5,0xBE,0x9E),
     o3(0xE6,0x82,0xB0), o3(0xE6,0x85,0xAB),
     o3(0xE6,0xA3,0x95), o3(0xE6,0xB7,0x99),
     o3(0xE7,0x90,0xAE), o3(0xE7,0xA8,0xAE),
     o3(0xE7,0xB5,0x82), o3(0xE7,0xB6,0x9C),
     o3(0xE7,0xB8,0xB1), o3(0xE8,0x85,0xAB),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_F0 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_F0_infos
};


static const struct byte_lookup* const
from_EUC_KR_F1_infos[95] = {
     o3(0xE8,0xB8,0xAA), o3(0xE8,0xB8,0xB5),
     o3(0xE9,0x8D,0xBE), o3(0xE9,0x90,0x98),
     o3(0xE4,0xBD,0x90), o3(0xE5,0x9D,0x90),
     o3(0xE5,0xB7,0xA6), o3(0xE5,0xBA,0xA7),
     o3(0xE6,0x8C,0xAB), o3(0xE7,0xBD,0xAA),
     o3(0xE4,0xB8,0xBB), o3(0xE4,0xBD,0x8F),
     o3(0xE4,0xBE,0x8F), o3(0xE5,0x81,0x9A),
     o3(0xE5,0xA7,0x9D), o3(0xE8,0x83,0x84),
     o3(0xE5,0x91,0xAA), o3(0xE5,0x91,0xA8),
     o3(0xE5,0x97,0xBE), o3(0xE5,0xA5,0x8F),
     o3(0xE5,0xAE,0x99), o3(0xE5,0xB7,0x9E),
     o3(0xE5,0xBB,0x9A), o3(0xE6,0x99,0x9D),
     o3(0xE6,0x9C,0xB1), o3(0xE6,0x9F,0xB1),
     o3(0xE6,0xA0,0xAA), o3(0xE6,0xB3,0xA8),
     o3(0xE6,0xB4,0xB2), o3(0xE6,0xB9,0x8A),
     o3(0xE6,0xBE,0x8D), o3(0xE7,0x82,0xB7),
     o3(0xE7,0x8F,0xA0), o3(0xE7,0x96,0x87),
     o3(0xE7,0xB1,0x8C), o3(0xE7,0xB4,0x82),
     o3(0xE7,0xB4,0xAC), o3(0xE7,0xB6,0xA2),
     o3(0xE8,0x88,0x9F), o3(0xE8,0x9B,0x9B),
     o3(0xE8,0xA8,0xBB), o3(0xE8,0xAA,0x85),
     o3(0xE8,0xB5,0xB0), o3(0xE8,0xBA,0x8A),
     o3(0xE8,0xBC,0xB3), o3(0xE9,0x80,0xB1),
     o3(0xE9,0x85,0x8E), o3(0xE9,0x85,0x92),
     o3(0xE9,0x91,0x84), o3(0xE9,0xA7,0x90),
     o3(0xE7,0xAB,0xB9), o3(0xE7,0xB2,0xA5),
     o3(0xE4,0xBF,0x8A), o3(0xE5,0x84,0x81),
     o3(0xE5,0x87,0x86), o3(0xE5,0x9F,0x88),
     o3(0xE5,0xAF,0xAF), o3(0xE5,0xB3,0xBB),
     o3(0xE6,0x99,0x99), o3(0xE6,0xA8,0xBD),
     o3(0xE6,0xB5,0x9A), o3(0xE6,0xBA,0x96),
     o3(0xE6,0xBF,0xAC), o3(0xE7,0x84,0x8C),
     o3(0xE7,0x95,0xAF), o3(0xE7,0xAB,0xA3),
     o3(0xE8,0xA0,0xA2), o3(0xE9,0x80,0xA1),
     o3(0xE9,0x81,0xB5), o3(0xE9,0x9B,0x8B),
     o3(0xE9,0xA7,0xBF), o3(0xE8,0x8C,0x81),
     o3(0xE4,0xB8,0xAD), o3(0xE4,0xBB,0xB2),
     o3(0xE8,0xA1,0x86), o3(0xE9,0x87,0x8D),
     o3(0xE5,0x8D,0xBD), o3(0xE6,0xAB,0x9B),
     o3(0xE6,0xA5,0xAB), o3(0xE6,0xB1,0x81),
     o3(0xE8,0x91,0xBA), o3(0xE5,0xA2,0x9E),
     o3(0xE6,0x86,0x8E), o3(0xE6,0x9B,0xBE),
     o3(0xE6,0x8B,0xAF), o3(0xE7,0x83,0x9D),
     o3(0xE7,0x94,0x91), o3(0xE7,0x97,0x87),
     o3(0xE7,0xB9,0x92), o3(0xE8,0x92,0xB8),
     o3(0xE8,0xAD,0x89), o3(0xE8,0xB4,0x88),
     o3(0xE4,0xB9,0x8B), o3(0xE5,0x8F,0xAA),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_F1 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_F1_infos
};


static const struct byte_lookup* const
from_EUC_KR_F2_infos[95] = {
     o3(0xE5,0x92,0xAB), o3(0xE5,0x9C,0xB0),
     o3(0xE5,0x9D,0x80), o3(0xE5,0xBF,0x97),
     o3(0xE6,0x8C,0x81), o3(0xE6,0x8C,0x87),
     o3(0xE6,0x91,0xAF), o3(0xE6,0x94,0xAF),
     o3(0xE6,0x97,0xA8), o3(0xE6,0x99,0xBA),
     o3(0xE6,0x9E,0x9D), o3(0xE6,0x9E,0xB3),
     o3(0xE6,0xAD,0xA2), o3(0xE6,0xB1,0xA0),
     o3(0xE6,0xB2,0x9A), o3(0xE6,0xBC,0xAC),
     o3(0xE7,0x9F,0xA5), o3(0xE7,0xA0,0xA5),
     o3(0xE7,0xA5,0x89), o3(0xE7,0xA5,0x97),
     o3(0xE7,0xB4,0x99), o3(0xE8,0x82,0xA2),
     o3(0xE8,0x84,0x82), o3(0xE8,0x87,0xB3),
     o3(0xE8,0x8A,0x9D), o3(0xE8,0x8A,0xB7),
     o3(0xE8,0x9C,0x98), o3(0xE8,0xAA,0x8C),
     o3(0xEF,0xA7,0xBC), o3(0xE8,0xB4,0x84),
     o3(0xE8,0xB6,0xBE), o3(0xE9,0x81,0xB2),
     o3(0xE7,0x9B,0xB4), o3(0xE7,0xA8,0x99),
     o3(0xE7,0xA8,0xB7), o3(0xE7,0xB9,0x94),
     o3(0xE8,0x81,0xB7), o3(0xE5,0x94,0x87),
     o3(0xE5,0x97,0x94), o3(0xE5,0xA1,0xB5),
     o3(0xE6,0x8C,0xAF), o3(0xE6,0x90,0xA2),
     o3(0xE6,0x99,0x89), o3(0xE6,0x99,0x8B),
     o3(0xE6,0xA1,0xAD), o3(0xE6,0xA6,0x9B),
     o3(0xE6,0xAE,0x84), o3(0xE6,0xB4,0xA5),
     o3(0xE6,0xBA,0xB1), o3(0xE7,0x8F,0x8D),
     o3(0xE7,0x91,0xA8), o3(0xE7,0x92,0xA1),
     o3(0xE7,0x95,0x9B), o3(0xE7,0x96,0xB9),
     o3(0xE7,0x9B,0xA1), o3(0xE7,0x9C,0x9E),
     o3(0xE7,0x9E,0x8B), o3(0xE7,0xA7,0xA6),
     o3(0xE7,0xB8,0x89), o3(0xE7,0xB8,0x9D),
     o3(0xE8,0x87,0xBB), o3(0xE8,0x94,0xAF),
     o3(0xE8,0xA2,0x97), o3(0xE8,0xA8,0xBA),
     o3(0xE8,0xB3,0x91), o3(0xE8,0xBB,0xAB),
     o3(0xE8,0xBE,0xB0), o3(0xE9,0x80,0xB2),
     o3(0xE9,0x8E,0xAD), o3(0xE9,0x99,0xA3),
     o3(0xE9,0x99,0xB3), o3(0xE9,0x9C,0x87),
     o3(0xE4,0xBE,0x84), o3(0xE5,0x8F,0xB1),
     o3(0xE5,0xA7,0xAA), o3(0xE5,0xAB,0x89),
     o3(0xE5,0xB8,0x99), o3(0xE6,0xA1,0x8E),
     o3(0xE7,0x93,0x86), o3(0xE7,0x96,0xBE),
     o3(0xE7,0xA7,0xA9), o3(0xE7,0xAA,0x92),
     o3(0xE8,0x86,0xA3), o3(0xE8,0x9B,0xAD),
     o3(0xE8,0xB3,0xAA), o3(0xE8,0xB7,0x8C),
     o3(0xE8,0xBF,0xAD), o3(0xE6,0x96,0x9F),
     o3(0xE6,0x9C,0x95), o3(0xEF,0xA7,0xBD),
     o3(0xE5,0x9F,0xB7), o3(0xE6,0xBD,0x97),
     o3(0xE7,0xB7,0x9D), o3(0xE8,0xBC,0xAF),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_F2 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_F2_infos
};


static const struct byte_lookup* const
from_EUC_KR_F3_infos[95] = {
     o3(0xE9,0x8F,0xB6), o3(0xE9,0x9B,0x86),
     o3(0xE5,0xBE,0xB5), o3(0xE6,0x87,0xB2),
     o3(0xE6,0xBE,0x84), o3(0xE4,0xB8,0x94),
     o3(0xE4,0xBE,0x98), o3(0xE5,0x80,0x9F),
     o3(0xE5,0x8F,0x89), o3(0xE5,0x97,0x9F),
     o3(0xE5,0xB5,0xAF), o3(0xE5,0xB7,0xAE),
     o3(0xE6,0xAC,0xA1), o3(0xE6,0xAD,0xA4),
     o3(0xE7,0xA3,0x8B), o3(0xE7,0xAE,0x9A),
     o3(0xEF,0xA7,0xBE), o3(0xE8,0xB9,0x89),
     o3(0xE8,0xBB,0x8A), o3(0xE9,0x81,0xAE),
     o3(0xE6,0x8D,0x89), o3(0xE6,0x90,0xBE),
     o3(0xE7,0x9D,0x80), o3(0xE7,0xAA,0x84),
     o3(0xE9,0x8C,0xAF), o3(0xE9,0x91,0xBF),
     o3(0xE9,0xBD,0xAA), o3(0xE6,0x92,0xB0),
     o3(0xE6,0xBE,0xAF), o3(0xE7,0x87,0xA6),
     o3(0xE7,0x92,0xA8), o3(0xE7,0x93,0x9A),
     o3(0xE7,0xAB,0x84), o3(0xE7,0xB0,0x92),
     o3(0xE7,0xBA,0x82), o3(0xE7,0xB2,0xB2),
     o3(0xE7,0xBA,0x98), o3(0xE8,0xAE,0x9A),
     o3(0xE8,0xB4,0x8A), o3(0xE9,0x91,0xBD),
     o3(0xE9,0xA4,0x90), o3(0xE9,0xA5,0x8C),
     o3(0xE5,0x88,0xB9), o3(0xE5,0xAF,0x9F),
     o3(0xE6,0x93,0xA6), o3(0xE6,0x9C,0xAD),
     o3(0xE7,0xB4,0xAE), o3(0xE5,0x83,0xAD),
     o3(0xE5,0x8F,0x83), o3(0xE5,0xA1,0xB9),
     o3(0xE6,0x85,0x98), o3(0xE6,0x85,0x99),
     o3(0xE6,0x87,0xBA), o3(0xE6,0x96,0xAC),
     o3(0xE7,0xAB,0x99), o3(0xE8,0xAE,0x92),
     o3(0xE8,0xAE,0x96), o3(0xE5,0x80,0x89),
     o3(0xE5,0x80,0xA1), o3(0xE5,0x89,0xB5),
     o3(0xE5,0x94,0xB1), o3(0xE5,0xA8,0xBC),
     o3(0xE5,0xBB,0xA0), o3(0xE5,0xBD,0xB0),
     o3(0xE6,0x84,0xB4), o3(0xE6,0x95,0x9E),
     o3(0xE6,0x98,0x8C), o3(0xE6,0x98,0xB6),
     o3(0xE6,0x9A,0xA2), o3(0xE6,0xA7,0x8D),
     o3(0xE6,0xBB,0x84), o3(0xE6,0xBC,0xB2),
     o3(0xE7,0x8C,0x96), o3(0xE7,0x98,0xA1),
     o3(0xE7,0xAA,0x93), o3(0xE8,0x84,0xB9),
     o3(0xE8,0x89,0x99), o3(0xE8,0x8F,0x96),
     o3(0xE8,0x92,0xBC), o3(0xE5,0x82,0xB5),
     o3(0xE5,0x9F,0xB0), o3(0xE5,0xAF,0x80),
     o3(0xE5,0xAF,0xA8), o3(0xE5,0xBD,0xA9),
     o3(0xE6,0x8E,0xA1), o3(0xE7,0xA0,0xA6),
     o3(0xE7,0xB6,0xB5), o3(0xE8,0x8F,0x9C),
     o3(0xE8,0x94,0xA1), o3(0xE9,0x87,0x87),
     o3(0xE9,0x87,0xB5), o3(0xE5,0x86,0x8A),
     o3(0xE6,0x9F,0xB5), o3(0xE7,0xAD,0x96),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_F3 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_F3_infos
};


static const struct byte_lookup* const
from_EUC_KR_F4_infos[95] = {
     o3(0xE8,0xB2,0xAC), o3(0xE5,0x87,0x84),
     o3(0xE5,0xA6,0xBB), o3(0xE6,0x82,0xBD),
     o3(0xE8,0x99,0x95), o3(0xE5,0x80,0x9C),
     o3(0xEF,0xA7,0xBF), o3(0xE5,0x89,0x94),
     o3(0xE5,0xB0,0xBA), o3(0xE6,0x85,0xBD),
     o3(0xE6,0x88,0x9A), o3(0xE6,0x8B,0x93),
     o3(0xE6,0x93,0xB2), o3(0xE6,0x96,0xA5),
     o3(0xE6,0xBB,0x8C), o3(0xE7,0x98,0xA0),
     o3(0xE8,0x84,0x8A), o3(0xE8,0xB9,0xA0),
     o3(0xE9,0x99,0x9F), o3(0xE9,0x9A,0xBB),
     o3(0xE4,0xBB,0x9F), o3(0xE5,0x8D,0x83),
     o3(0xE5,0x96,0x98), o3(0xE5,0xA4,0xA9),
     o3(0xE5,0xB7,0x9D), o3(0xE6,0x93,0x85),
     o3(0xE6,0xB3,0x89), o3(0xE6,0xB7,0xBA),
     o3(0xE7,0x8E,0x94), o3(0xE7,0xA9,0xBF),
     o3(0xE8,0x88,0x9B), o3(0xE8,0x96,0xA6),
     o3(0xE8,0xB3,0xA4), o3(0xE8,0xB8,0x90),
     o3(0xE9,0x81,0xB7), o3(0xE9,0x87,0xA7),
     o3(0xE9,0x97,0xA1), o3(0xE9,0x98,0xA1),
     o3(0xE9,0x9F,0x86), o3(0xE5,0x87,0xB8),
     o3(0xE5,0x93,0xB2), o3(0xE5,0x96,0x86),
     o3(0xE5,0xBE,0xB9), o3(0xE6,0x92,0xA4),
     o3(0xE6,0xBE,0x88), o3(0xE7,0xB6,0xB4),
     o3(0xE8,0xBC,0x9F), o3(0xE8,0xBD,0x8D),
     o3(0xE9,0x90,0xB5), o3(0xE5,0x83,0x89),
     o3(0xE5,0xB0,0x96), o3(0xE6,0xB2,0xBE),
     o3(0xE6,0xB7,0xBB), o3(0xE7,0x94,0x9B),
     o3(0xE7,0x9E,0xBB), o3(0xE7,0xB0,0xBD),
     o3(0xE7,0xB1,0xA4), o3(0xE8,0xA9,0xB9),
     o3(0xE8,0xAB,0x82), o3(0xE5,0xA0,0x9E),
     o3(0xE5,0xA6,0xBE), o3(0xE5,0xB8,0x96),
     o3(0xE6,0x8D,0xB7), o3(0xE7,0x89,0x92),
     o3(0xE7,0x96,0x8A), o3(0xE7,0x9D,0xAB),
     o3(0xE8,0xAB,0x9C), o3(0xE8,0xB2,0xBC),
     o3(0xE8,0xBC,0x92), o3(0xE5,0xBB,0xB3),
     o3(0xE6,0x99,0xB4), o3(0xE6,0xB7,0xB8),
     o3(0xE8,0x81,0xBD), o3(0xE8,0x8F,0x81),
     o3(0xE8,0xAB,0x8B), o3(0xE9,0x9D,0x91),
     o3(0xE9,0xAF,0x96), o3(0xEF,0xA8,0x80),
     o3(0xE5,0x89,0x83), o3(0xE6,0x9B,0xBF),
     o3(0xE6,0xB6,0x95), o3(0xE6,0xBB,0xAF),
     o3(0xE7,0xB7,0xA0), o3(0xE8,0xAB,0xA6),
     o3(0xE9,0x80,0xAE), o3(0xE9,0x81,0x9E),
     o3(0xE9,0xAB,0x94), o3(0xE5,0x88,0x9D),
     o3(0xE5,0x89,0xBF), o3(0xE5,0x93,0xA8),
     o3(0xE6,0x86,0x94), o3(0xE6,0x8A,0x84),
     o3(0xE6,0x8B,0x9B), o3(0xE6,0xA2,0xA2),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_F4 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_F4_infos
};


static const struct byte_lookup* const
from_EUC_KR_F5_infos[95] = {
     o3(0xE6,0xA4,0x92), o3(0xE6,0xA5,0x9A),
     o3(0xE6,0xA8,0xB5), o3(0xE7,0x82,0x92),
     o3(0xE7,0x84,0xA6), o3(0xE7,0xA1,0x9D),
     o3(0xE7,0xA4,0x81), o3(0xE7,0xA4,0x8E),
     o3(0xE7,0xA7,0x92), o3(0xE7,0xA8,0x8D),
     o3(0xE8,0x82,0x96), o3(0xE8,0x89,0xB8),
     o3(0xE8,0x8B,0x95), o3(0xE8,0x8D,0x89),
     o3(0xE8,0x95,0x89), o3(0xE8,0xB2,0x82),
     o3(0xE8,0xB6,0x85), o3(0xE9,0x85,0xA2),
     o3(0xE9,0x86,0x8B), o3(0xE9,0x86,0xAE),
     o3(0xE4,0xBF,0x83), o3(0xE5,0x9B,0x91),
     o3(0xE7,0x87,0xAD), o3(0xE7,0x9F,0x97),
     o3(0xE8,0x9C,0x80), o3(0xE8,0xA7,0xB8),
     o3(0xE5,0xAF,0xB8), o3(0xE5,0xBF,0x96),
     o3(0xE6,0x9D,0x91), o3(0xE9,0x82,0xA8),
     o3(0xE5,0x8F,0xA2), o3(0xE5,0xA1,0x9A),
     o3(0xE5,0xAF,0xB5), o3(0xE6,0x82,0xA4),
     o3(0xE6,0x86,0x81), o3(0xE6,0x91,0xA0),
     o3(0xE7,0xB8,0xBD), o3(0xE8,0x81,0xB0),
     o3(0xE8,0x94,0xA5), o3(0xE9,0x8A,0x83),
     o3(0xE6,0x92,0xAE), o3(0xE5,0x82,0xAC),
     o3(0xE5,0xB4,0x94), o3(0xE6,0x9C,0x80),
     o3(0xE5,0xA2,0x9C), o3(0xE6,0x8A,0xBD),
     o3(0xE6,0x8E,0xA8), o3(0xE6,0xA4,0x8E),
     o3(0xE6,0xA5,0xB8), o3(0xE6,0xA8,0x9E),
     o3(0xE6,0xB9,0xAB), o3(0xE7,0x9A,0xBA),
     o3(0xE7,0xA7,0x8B), o3(0xE8,0x8A,0xBB),
     o3(0xE8,0x90,0xA9), o3(0xE8,0xAB,0x8F),
     o3(0xE8,0xB6,0xA8), o3(0xE8,0xBF,0xBD),
     o3(0xE9,0x84,0x92), o3(0xE9,0x85,0x8B),
     o3(0xE9,0x86,0x9C), o3(0xE9,0x8C,0x90),
     o3(0xE9,0x8C,0x98), o3(0xE9,0x8E,0x9A),
     o3(0xE9,0x9B,0x9B), o3(0xE9,0xA8,0xB6),
     o3(0xE9,0xB0,0x8D), o3(0xE4,0xB8,0x91),
     o3(0xE7,0x95,0x9C), o3(0xE7,0xA5,0x9D),
     o3(0xE7,0xAB,0xBA), o3(0xE7,0xAD,0x91),
     o3(0xE7,0xAF,0x89), o3(0xE7,0xB8,0xAE),
     o3(0xE8,0x93,0x84), o3(0xE8,0xB9,0x99),
     o3(0xE8,0xB9,0xB4), o3(0xE8,0xBB,0xB8),
     o3(0xE9,0x80,0x90), o3(0xE6,0x98,0xA5),
     o3(0xE6,0xA4,0xBF), o3(0xE7,0x91,0x83),
     o3(0xE5,0x87,0xBA), o3(0xE6,0x9C,0xAE),
     o3(0xE9,0xBB,0x9C), o3(0xE5,0x85,0x85),
     o3(0xE5,0xBF,0xA0), o3(0xE6,0xB2,0x96),
     o3(0xE8,0x9F,0xB2), o3(0xE8,0xA1,0x9D),
     o3(0xE8,0xA1,0xB7), o3(0xE6,0x82,0xB4),
     o3(0xE8,0x86,0xB5), o3(0xE8,0x90,0x83),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_F5 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_F5_infos
};


static const struct byte_lookup* const
from_EUC_KR_F6_infos[95] = {
     o3(0xE8,0xB4,0x85), o3(0xE5,0x8F,0x96),
     o3(0xE5,0x90,0xB9), o3(0xE5,0x98,0xB4),
     o3(0xE5,0xA8,0xB6), o3(0xE5,0xB0,0xB1),
     o3(0xE7,0x82,0x8A), o3(0xE7,0xBF,0xA0),
     o3(0xE8,0x81,0x9A), o3(0xE8,0x84,0x86),
     o3(0xE8,0x87,0xAD), o3(0xE8,0xB6,0xA3),
     o3(0xE9,0x86,0x89), o3(0xE9,0xA9,0x9F),
     o3(0xE9,0xB7,0xB2), o3(0xE5,0x81,0xB4),
     o3(0xE4,0xBB,0x84), o3(0xE5,0x8E,0xA0),
     o3(0xE6,0x83,0xBB), o3(0xE6,0xB8,0xAC),
     o3(0xE5,0xB1,0xA4), o3(0xE4,0xBE,0x88),
     o3(0xE5,0x80,0xA4), o3(0xE5,0x97,0xA4),
     o3(0xE5,0xB3,0x99), o3(0xE5,0xB9,0x9F),
     o3(0xE6,0x81,0xA5), o3(0xE6,0xA2,0x94),
     o3(0xE6,0xB2,0xBB), o3(0xE6,0xB7,0x84),
     o3(0xE7,0x86,0xBE), o3(0xE7,0x97,0x94),
     o3(0xE7,0x97,0xB4), o3(0xE7,0x99,0xA1),
     o3(0xE7,0xA8,0x9A), o3(0xE7,0xA9,0x89),
     o3(0xE7,0xB7,0x87), o3(0xE7,0xB7,0xBB),
     o3(0xE7,0xBD,0xAE), o3(0xE8,0x87,0xB4),
     o3(0xE8,0x9A,0xA9), o3(0xE8,0xBC,0x9C),
     o3(0xE9,0x9B,0x89), o3(0xE9,0xA6,0xB3),
     o3(0xE9,0xBD,0x92), o3(0xE5,0x89,0x87),
     o3(0xE5,0x8B,0x85), o3(0xE9,0xA3,0xAD),
     o3(0xE8,0xA6,0xAA), o3(0xE4,0xB8,0x83),
     o3(0xE6,0x9F,0x92), o3(0xE6,0xBC,0x86),
     o3(0xE4,0xBE,0xB5), o3(0xE5,0xAF,0xA2),
     o3(0xE6,0x9E,0x95), o3(0xE6,0xB2,0x88),
     o3(0xE6,0xB5,0xB8), o3(0xE7,0x90,0x9B),
     o3(0xE7,0xA0,0xA7), o3(0xE9,0x87,0x9D),
     o3(0xE9,0x8D,0xBC), o3(0xE8,0x9F,0x84),
     o3(0xE7,0xA7,0xA4), o3(0xE7,0xA8,0xB1),
     o3(0xE5,0xBF,0xAB), o3(0xE4,0xBB,0x96),
     o3(0xE5,0x92,0xA4), o3(0xE5,0x94,0xBE),
     o3(0xE5,0xA2,0xAE), o3(0xE5,0xA6,0xA5),
     o3(0xE6,0x83,0xB0), o3(0xE6,0x89,0x93),
     o3(0xE6,0x8B,0x96), o3(0xE6,0x9C,0xB6),
     o3(0xE6,0xA5,0x95), o3(0xE8,0x88,0xB5),
     o3(0xE9,0x99,0x80), o3(0xE9,0xA6,0xB1),
     o3(0xE9,0xA7,0x9D), o3(0xE5,0x80,0xAC),
     o3(0xE5,0x8D,0x93), o3(0xE5,0x95,0x84),
     o3(0xE5,0x9D,0xBC), o3(0xEF,0xA8,0x81),
     o3(0xE6,0x89,0x98), o3(0xEF,0xA8,0x82),
     o3(0xE6,0x93,0xA2), o3(0xE6,0x99,0xAB),
     o3(0xE6,0x9F,0x9D), o3(0xE6,0xBF,0x81),
     o3(0xE6,0xBF,0xAF), o3(0xE7,0x90,0xA2),
     o3(0xE7,0x90,0xB8), o3(0xE8,0xA8,0x97),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_F6 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_F6_infos
};


static const struct byte_lookup* const
from_EUC_KR_F7_infos[95] = {
     o3(0xE9,0x90,0xB8), o3(0xE5,0x91,0x91),
     o3(0xE5,0x98,0x86), o3(0xE5,0x9D,0xA6),
     o3(0xE5,0xBD,0x88), o3(0xE6,0x86,0x9A),
     o3(0xE6,0xAD,0x8E), o3(0xE7,0x81,0x98),
     o3(0xE7,0x82,0xAD), o3(0xE7,0xB6,0xBB),
     o3(0xE8,0xAA,0x95), o3(0xE5,0xA5,0xAA),
     o3(0xE8,0x84,0xAB), o3(0xE6,0x8E,0xA2),
     o3(0xE7,0x9C,0x88), o3(0xE8,0x80,0xBD),
     o3(0xE8,0xB2,0xAA), o3(0xE5,0xA1,0x94),
     o3(0xE6,0x90,0xAD), o3(0xE6,0xA6,0xBB),
     o3(0xE5,0xAE,0x95), o3(0xE5,0xB8,0x91),
     o3(0xE6,0xB9,0xAF), o3(0xEF,0xA8,0x83),
     o3(0xE8,0x95,0xA9), o3(0xE5,0x85,0x8C),
     o3(0xE5,0x8F,0xB0), o3(0xE5,0xA4,0xAA),
     o3(0xE6,0x80,0xA0), o3(0xE6,0x85,0x8B),
     o3(0xE6,0xAE,0x86), o3(0xE6,0xB1,0xB0),
     o3(0xE6,0xB3,0xB0), o3(0xE7,0xAC,0x9E),
     o3(0xE8,0x83,0x8E), o3(0xE8,0x8B,0x94),
     o3(0xE8,0xB7,0x86), o3(0xE9,0x82,0xB0),
     o3(0xE9,0xA2,0xB1), o3(0xEF,0xA8,0x84),
     o3(0xE6,0x93,0x87), o3(0xE6,0xBE,0xA4),
     o3(0xE6,0x92,0x91), o3(0xE6,0x94,0x84),
     o3(0xE5,0x85,0x8E), o3(0xE5,0x90,0x90),
     o3(0xE5,0x9C,0x9F), o3(0xE8,0xA8,0x8E),
     o3(0xE6,0x85,0x9F), o3(0xE6,0xA1,0xB6),
     o3(0xEF,0xA8,0x85), o3(0xE7,0x97,0x9B),
     o3(0xE7,0xAD,0x92), o3(0xE7,0xB5,0xB1),
     o3(0xE9,0x80,0x9A), o3(0xE5,0xA0,0x86),
     o3(0xE6,0xA7,0x8C), o3(0xE8,0x85,0xBF),
     o3(0xE8,0xA4,0xAA), o3(0xE9,0x80,0x80),
     o3(0xE9,0xA0,0xB9), o3(0xE5,0x81,0xB8),
     o3(0xE5,0xA5,0x97), o3(0xE5,0xA6,0xAC),
     o3(0xE6,0x8A,0x95), o3(0xE9,0x80,0x8F),
     o3(0xE9,0xAC,0xAA), o3(0xE6,0x85,0x9D),
     o3(0xE7,0x89,0xB9), o3(0xE9,0x97,0x96),
     o3(0xE5,0x9D,0xA1), o3(0xE5,0xA9,0x86),
     o3(0xE5,0xB7,0xB4), o3(0xE6,0x8A,0x8A),
     o3(0xE6,0x92,0xAD), o3(0xE6,0x93,0xBA),
     o3(0xE6,0x9D,0xB7), o3(0xE6,0xB3,0xA2),
     o3(0xE6,0xB4,0xBE), o3(0xE7,0x88,0xAC),
     o3(0xE7,0x90,0xB6), o3(0xE7,0xA0,0xB4),
     o3(0xE7,0xBD,0xB7), o3(0xE8,0x8A,0xAD),
     o3(0xE8,0xB7,0x9B), o3(0xE9,0xA0,0x97),
     o3(0xE5,0x88,0xA4), o3(0xE5,0x9D,0x82),
     o3(0xE6,0x9D,0xBF), o3(0xE7,0x89,0x88),
     o3(0xE7,0x93,0xA3), o3(0xE8,0xB2,0xA9),
     o3(0xE8,0xBE,0xA6), o3(0xE9,0x88,0x91),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_F7 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_F7_infos
};


static const struct byte_lookup* const
from_EUC_KR_F8_infos[95] = {
     o3(0xE9,0x98,0xAA), o3(0xE5,0x85,0xAB),
     o3(0xE5,0x8F,0xAD), o3(0xE6,0x8D,0x8C),
     o3(0xE4,0xBD,0xA9), o3(0xE5,0x94,0x84),
     o3(0xE6,0x82,0x96), o3(0xE6,0x95,0x97),
     o3(0xE6,0xB2,0x9B), o3(0xE6,0xB5,0xBF),
     o3(0xE7,0x89,0x8C), o3(0xE7,0x8B,0xBD),
     o3(0xE7,0xA8,0x97), o3(0xE8,0xA6,0x87),
     o3(0xE8,0xB2,0x9D), o3(0xE5,0xBD,0xAD),
     o3(0xE6,0xBE,0x8E), o3(0xE7,0x83,0xB9),
     o3(0xE8,0x86,0xA8), o3(0xE6,0x84,0x8E),
     o3(0xE4,0xBE,0xBF), o3(0xE5,0x81,0x8F),
     o3(0xE6,0x89,0x81), o3(0xE7,0x89,0x87),
     o3(0xE7,0xAF,0x87), o3(0xE7,0xB7,0xA8),
     o3(0xE7,0xBF,0xA9), o3(0xE9,0x81,0x8D),
     o3(0xE9,0x9E,0xAD), o3(0xE9,0xA8,0x99),
     o3(0xE8,0xB2,0xB6), o3(0xE5,0x9D,0xAA),
     o3(0xE5,0xB9,0xB3), o3(0xE6,0x9E,0xB0),
     o3(0xE8,0x90,0x8D), o3(0xE8,0xA9,0x95),
     o3(0xE5,0x90,0xA0), o3(0xE5,0xAC,0x96),
     o3(0xE5,0xB9,0xA3), o3(0xE5,0xBB,0xA2),
     o3(0xE5,0xBC,0x8A), o3(0xE6,0x96,0x83),
     o3(0xE8,0x82,0xBA), o3(0xE8,0x94,0xBD),
     o3(0xE9,0x96,0x89), o3(0xE9,0x99,0x9B),
     o3(0xE4,0xBD,0x88), o3(0xE5,0x8C,0x85),
     o3(0xE5,0x8C,0x8D), o3(0xE5,0x8C,0x8F),
     o3(0xE5,0x92,0x86), o3(0xE5,0x93,0xBA),
     o3(0xE5,0x9C,0x83), o3(0xE5,0xB8,0x83),
     o3(0xE6,0x80,0x96), o3(0xE6,0x8A,0x9B),
     o3(0xE6,0x8A,0xB1), o3(0xE6,0x8D,0x95),
     o3(0xEF,0xA8,0x86), o3(0xE6,0xB3,0xA1),
     o3(0xE6,0xB5,0xA6), o3(0xE7,0x96,0xB1),
     o3(0xE7,0xA0,0xB2), o3(0xE8,0x83,0x9E),
     o3(0xE8,0x84,0xAF), o3(0xE8,0x8B,0x9E),
     o3(0xE8,0x91,0xA1), o3(0xE8,0x92,0xB2),
     o3(0xE8,0xA2,0x8D), o3(0xE8,0xA4,0x92),
     o3(0xE9,0x80,0x8B), o3(0xE9,0x8B,0xAA),
     o3(0xE9,0xA3,0xBD), o3(0xE9,0xAE,0x91),
     o3(0xE5,0xB9,0x85), o3(0xE6,0x9A,0xB4),
     o3(0xE6,0x9B,0x9D), o3(0xE7,0x80,0x91),
     o3(0xE7,0x88,0x86), o3(0xEF,0xA8,0x87),
     o3(0xE4,0xBF,0xB5), o3(0xE5,0x89,0xBD),
     o3(0xE5,0xBD,0xAA), o3(0xE6,0x85,0x93),
     o3(0xE6,0x9D,0x93), o3(0xE6,0xA8,0x99),
     o3(0xE6,0xBC,0x82), o3(0xE7,0x93,0xA2),
     o3(0xE7,0xA5,0xA8), o3(0xE8,0xA1,0xA8),
     o3(0xE8,0xB1,0xB9), o3(0xE9,0xA3,0x87),
     o3(0xE9,0xA3,0x84), o3(0xE9,0xA9,0x83),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_F8 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_F8_infos
};


static const struct byte_lookup* const
from_EUC_KR_F9_infos[95] = {
     o3(0xE5,0x93,0x81), o3(0xE7,0xA8,0x9F),
     o3(0xE6,0xA5,0x93), o3(0xE8,0xAB,0xB7),
     o3(0xE8,0xB1,0x8A), o3(0xE9,0xA2,0xA8),
     o3(0xE9,0xA6,0xAE), o3(0xE5,0xBD,0xBC),
     o3(0xE6,0x8A,0xAB), o3(0xE7,0x96,0xB2),
     o3(0xE7,0x9A,0xAE), o3(0xE8,0xA2,0xAB),
     o3(0xE9,0x81,0xBF), o3(0xE9,0x99,0x82),
     o3(0xE5,0x8C,0xB9), o3(0xE5,0xBC,0xBC),
     o3(0xE5,0xBF,0x85), o3(0xE6,0xB3,0x8C),
     o3(0xE7,0x8F,0x8C), o3(0xE7,0x95,0xA2),
     o3(0xE7,0x96,0x8B), o3(0xE7,0xAD,0x86),
     o3(0xE8,0x8B,0xBE), o3(0xE9,0xA6,0x9D),
     o3(0xE4,0xB9,0x8F), o3(0xE9,0x80,0xBC),
     o3(0xE4,0xB8,0x8B), o3(0xE4,0xBD,0x95),
     o3(0xE5,0x8E,0xA6), o3(0xE5,0xA4,0x8F),
     o3(0xE5,0xBB,0x88), o3(0xE6,0x98,0xB0),
     o3(0xE6,0xB2,0xB3), o3(0xE7,0x91,0x95),
     o3(0xE8,0x8D,0xB7), o3(0xE8,0x9D,0xA6),
     o3(0xE8,0xB3,0x80), o3(0xE9,0x81,0x90),
     o3(0xE9,0x9C,0x9E), o3(0xE9,0xB0,0x95),
     o3(0xE5,0xA3,0x91), o3(0xE5,0xAD,0xB8),
     o3(0xE8,0x99,0x90), o3(0xE8,0xAC,0x94),
     o3(0xE9,0xB6,0xB4), o3(0xE5,0xAF,0x92),
     o3(0xE6,0x81,0xA8), o3(0xE6,0x82,0x8D),
     o3(0xE6,0x97,0xB1), o3(0xE6,0xB1,0x97),
     o3(0xE6,0xBC,0xA2), o3(0xE6,0xBE,0xA3),
     o3(0xE7,0x80,0x9A), o3(0xE7,0xBD,0x95),
     o3(0xE7,0xBF,0xB0), o3(0xE9,0x96,0x91),
     o3(0xE9,0x96,0x92), o3(0xE9,0x99,0x90),
     o3(0xE9,0x9F,0x93), o3(0xE5,0x89,0xB2),
     o3(0xE8,0xBD,0x84), o3(0xE5,0x87,0xBD),
     o3(0xE5,0x90,0xAB), o3(0xE5,0x92,0xB8),
     o3(0xE5,0x95,0xA3), o3(0xE5,0x96,0x8A),
     o3(0xE6,0xAA,0xBB), o3(0xE6,0xB6,0xB5),
     o3(0xE7,0xB7,0x98), o3(0xE8,0x89,0xA6),
     o3(0xE9,0x8A,0x9C), o3(0xE9,0x99,0xB7),
     o3(0xE9,0xB9,0xB9), o3(0xE5,0x90,0x88),
     o3(0xE5,0x93,0x88), o3(0xE7,0x9B,0x92),
     o3(0xE8,0x9B,0xA4), o3(0xE9,0x96,0xA4),
     o3(0xE9,0x97,0x94), o3(0xE9,0x99,0x9C),
     o3(0xE4,0xBA,0xA2), o3(0xE4,0xBC,0x89),
     o3(0xE5,0xA7,0xAE), o3(0xE5,0xAB,0xA6),
     o3(0xE5,0xB7,0xB7), o3(0xE6,0x81,0x92),
     o3(0xE6,0x8A,0x97), o3(0xE6,0x9D,0xAD),
     o3(0xE6,0xA1,0x81), o3(0xE6,0xB2,0x86),
     o3(0xE6,0xB8,0xAF), o3(0xE7,0xBC,0xB8),
     o3(0xE8,0x82,0x9B), o3(0xE8,0x88,0xAA),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_F9 = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_F9_infos
};


static const struct byte_lookup* const
from_EUC_KR_FA_infos[95] = {
     o3(0xEF,0xA8,0x88), o3(0xEF,0xA8,0x89),
     o3(0xE9,0xA0,0x85), o3(0xE4,0xBA,0xA5),
     o3(0xE5,0x81,0x95), o3(0xE5,0x92,0xB3),
     o3(0xE5,0x9E,0x93), o3(0xE5,0xA5,0x9A),
     o3(0xE5,0xAD,0xA9), o3(0xE5,0xAE,0xB3),
     o3(0xE6,0x87,0x88), o3(0xE6,0xA5,0xB7),
     o3(0xE6,0xB5,0xB7), o3(0xE7,0x80,0xA3),
     o3(0xE8,0x9F,0xB9), o3(0xE8,0xA7,0xA3),
     o3(0xE8,0xA9,0xB2), o3(0xE8,0xAB,0xA7),
     o3(0xE9,0x82,0x82), o3(0xE9,0xA7,0xAD),
     o3(0xE9,0xAA,0xB8), o3(0xE5,0x8A,0xBE),
     o3(0xE6,0xA0,0xB8), o3(0xE5,0x80,0x96),
     o3(0xE5,0xB9,0xB8), o3(0xE6,0x9D,0x8F),
     o3(0xE8,0x8D,0x87), o3(0xE8,0xA1,0x8C),
     o3(0xE4,0xBA,0xAB), o3(0xE5,0x90,0x91),
     o3(0xE5,0x9A,0xAE), o3(0xE7,0x8F,0xA6),
     o3(0xE9,0x84,0x95), o3(0xE9,0x9F,0xBF),
     o3(0xE9,0xA4,0x89), o3(0xE9,0xA5,0x97),
     o3(0xE9,0xA6,0x99), o3(0xE5,0x99,0x93),
     o3(0xE5,0xA2,0x9F), o3(0xE8,0x99,0x9B),
     o3(0xE8,0xA8,0xB1), o3(0xE6,0x86,0xB2),
     o3(0xE6,0xAB,0xB6), o3(0xE7,0x8D,0xBB),
     o3(0xE8,0xBB,0x92), o3(0xE6,0xAD,0x87),
     o3(0xE9,0x9A,0xAA), o3(0xE9,0xA9,0x97),
     o3(0xE5,0xA5,0x95), o3(0xE7,0x88,0x80),
     o3(0xE8,0xB5,0xAB), o3(0xE9,0x9D,0xA9),
     o3(0xE4,0xBF,0x94), o3(0xE5,0xB3,0xB4),
     o3(0xE5,0xBC,0xA6), o3(0xE6,0x87,0xB8),
     o3(0xE6,0x99,0x9B), o3(0xE6,0xB3,0xAB),
     o3(0xE7,0x82,0xAB), o3(0xE7,0x8E,0x84),
     o3(0xE7,0x8E,0xB9), o3(0xE7,0x8F,0xBE),
     o3(0xE7,0x9C,0xA9), o3(0xE7,0x9D,0x8D),
     o3(0xE7,0xB5,0x83), o3(0xE7,0xB5,0xA2),
     o3(0xE7,0xB8,0xA3), o3(0xE8,0x88,0xB7),
     o3(0xE8,0xA1,0x92), o3(0xEF,0xA8,0x8A),
     o3(0xE8,0xB3,0xA2), o3(0xE9,0x89,0x89),
     o3(0xE9,0xA1,0xAF), o3(0xE5,0xAD,0x91),
     o3(0xE7,0xA9,0xB4), o3(0xE8,0xA1,0x80),
     o3(0xE9,0xA0,0x81), o3(0xE5,0xAB,0x8C),
     o3(0xE4,0xBF,0xA0), o3(0xE5,0x8D,0x94),
     o3(0xE5,0xA4,0xBE), o3(0xE5,0xB3,0xBD),
     o3(0xE6,0x8C,0xBE), o3(0xE6,0xB5,0xB9),
     o3(0xE7,0x8B,0xB9), o3(0xE8,0x84,0x85),
     o3(0xE8,0x84,0x87), o3(0xE8,0x8E,0xA2),
     o3(0xE9,0x8B,0x8F), o3(0xE9,0xA0,0xB0),
     o3(0xE4,0xBA,0xA8), o3(0xE5,0x85,0x84),
     o3(0xE5,0x88,0x91), o3(0xE5,0x9E,0x8B),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_FA = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_FA_infos
};


static const struct byte_lookup* const
from_EUC_KR_FB_infos[95] = {
     o3(0xE5,0xBD,0xA2), o3(0xE6,0xB3,0x82),
     o3(0xE6,0xBB,0x8E), o3(0xE7,0x80,0x85),
     o3(0xE7,0x81,0x90), o3(0xE7,0x82,0xAF),
     o3(0xE7,0x86,0x92), o3(0xE7,0x8F,0xA9),
     o3(0xE7,0x91,0xA9), o3(0xE8,0x8D,0x8A),
     o3(0xE8,0x9E,0xA2), o3(0xE8,0xA1,0xA1),
     o3(0xE9,0x80,0x88), o3(0xE9,0x82,0xA2),
     o3(0xE9,0x8E,0xA3), o3(0xE9,0xA6,0xA8),
     o3(0xE5,0x85,0xAE), o3(0xE5,0xBD,0x97),
     o3(0xE6,0x83,0xA0), o3(0xE6,0x85,0xA7),
     o3(0xE6,0x9A,0xB3), o3(0xE8,0x95,0x99),
     o3(0xE8,0xB9,0x8A), o3(0xE9,0x86,0xAF),
     o3(0xE9,0x9E,0x8B), o3(0xE4,0xB9,0x8E),
     o3(0xE4,0xBA,0x92), o3(0xE5,0x91,0xBC),
     o3(0xE5,0xA3,0x95), o3(0xE5,0xA3,0xBA),
     o3(0xE5,0xA5,0xBD), o3(0xE5,0xB2,0xB5),
     o3(0xE5,0xBC,0xA7), o3(0xE6,0x88,0xB6),
     o3(0xE6,0x89,0x88), o3(0xE6,0x98,0x8A),
     o3(0xE6,0x99,0xA7), o3(0xE6,0xAF,0xAB),
     o3(0xE6,0xB5,0xA9), o3(0xE6,0xB7,0x8F),
     o3(0xE6,0xB9,0x96), o3(0xE6,0xBB,0xB8),
     o3(0xE6,0xBE,0x94), o3(0xE6,0xBF,0xA0),
     o3(0xE6,0xBF,0xA9), o3(0xE7,0x81,0x9D),
     o3(0xE7,0x8B,0x90), o3(0xE7,0x90,0xA5),
     o3(0xE7,0x91,0x9A), o3(0xE7,0x93,0xA0),
     o3(0xE7,0x9A,0x93), o3(0xE7,0xA5,0x9C),
     o3(0xE7,0xB3,0x8A), o3(0xE7,0xB8,0x9E),
     o3(0xE8,0x83,0xA1), o3(0xE8,0x8A,0xA6),
     o3(0xE8,0x91,0xAB), o3(0xE8,0x92,0xBF),
     o3(0xE8,0x99,0x8E), o3(0xE8,0x99,0x9F),
     o3(0xE8,0x9D,0xB4), o3(0xE8,0xAD,0xB7),
     o3(0xE8,0xB1,0xAA), o3(0xE9,0x8E,0xAC),
     o3(0xE9,0xA0,0x80), o3(0xE9,0xA1,0xA5),
     o3(0xE6,0x83,0x91), o3(0xE6,0x88,0x96),
     o3(0xE9,0x85,0xB7), o3(0xE5,0xA9,0x9A),
     o3(0xE6,0x98,0x8F), o3(0xE6,0xB7,0xB7),
     o3(0xE6,0xB8,0xBE), o3(0xE7,0x90,0xBF),
     o3(0xE9,0xAD,0x82), o3(0xE5,0xBF,0xBD),
     o3(0xE6,0x83,0x9A), o3(0xE7,0xAC,0x8F),
     o3(0xE5,0x93,0x84), o3(0xE5,0xBC,0x98),
     o3(0xE6,0xB1,0x9E), o3(0xE6,0xB3,0x93),
     o3(0xE6,0xB4,0xAA), o3(0xE7,0x83,0x98),
     o3(0xE7,0xB4,0x85), o3(0xE8,0x99,0xB9),
     o3(0xE8,0xA8,0x8C), o3(0xE9,0xB4,0xBB),
     o3(0xE5,0x8C,0x96), o3(0xE5,0x92,0x8C),
     o3(0xE5,0xAC,0x85), o3(0xE6,0xA8,0xBA),
     o3(0xE7,0x81,0xAB), o3(0xE7,0x95,0xB5),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_FB = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_FB_infos
};


static const struct byte_lookup* const
from_EUC_KR_FC_infos[95] = {
     o3(0xE7,0xA6,0x8D), o3(0xE7,0xA6,0xBE),
     o3(0xE8,0x8A,0xB1), o3(0xE8,0x8F,0xAF),
     o3(0xE8,0xA9,0xB1), o3(0xE8,0xAD,0x81),
     o3(0xE8,0xB2,0xA8), o3(0xE9,0x9D,0xB4),
     o3(0xEF,0xA8,0x8B), o3(0xE6,0x93,0xB4),
     o3(0xE6,0x94,0xAB), o3(0xE7,0xA2,0xBA),
     o3(0xE7,0xA2,0xBB), o3(0xE7,0xA9,0xAB),
     o3(0xE4,0xB8,0xB8), o3(0xE5,0x96,0x9A),
     o3(0xE5,0xA5,0x90), o3(0xE5,0xAE,0xA6),
     o3(0xE5,0xB9,0xBB), o3(0xE6,0x82,0xA3),
     o3(0xE6,0x8F,0x9B), o3(0xE6,0xAD,0xA1),
     o3(0xE6,0x99,0xA5), o3(0xE6,0xA1,0x93),
     o3(0xE6,0xB8,0x99), o3(0xE7,0x85,0xA5),
     o3(0xE7,0x92,0xB0), o3(0xE7,0xB4,0x88),
     o3(0xE9,0x82,0x84), o3(0xE9,0xA9,0xA9),
     o3(0xE9,0xB0,0xA5), o3(0xE6,0xB4,0xBB),
     o3(0xE6,0xBB,0x91), o3(0xE7,0x8C,0xBE),
     o3(0xE8,0xB1,0x81), o3(0xE9,0x97,0x8A),
     o3(0xE5,0x87,0xB0), o3(0xE5,0xB9,0x8C),
     o3(0xE5,0xBE,0xA8), o3(0xE6,0x81,0x8D),
     o3(0xE6,0x83,0xB6), o3(0xE6,0x84,0xB0),
     o3(0xE6,0x85,0x8C), o3(0xE6,0x99,0x83),
     o3(0xE6,0x99,0x84), o3(0xE6,0xA6,0xA5),
     o3(0xE6,0xB3,0x81), o3(0xE6,0xB9,0x9F),
     o3(0xE6,0xBB,0x89), o3(0xE6,0xBD,0xA2),
     o3(0xE7,0x85,0x8C), o3(0xE7,0x92,0x9C),
     o3(0xE7,0x9A,0x87), o3(0xE7,0xAF,0x81),
     o3(0xE7,0xB0,0xA7), o3(0xE8,0x8D,0x92),
     o3(0xE8,0x9D,0x97), o3(0xE9,0x81,0x91),
     o3(0xE9,0x9A,0x8D), o3(0xE9,0xBB,0x83),
     o3(0xE5,0x8C,0xAF), o3(0xE5,0x9B,0x9E),
     o3(0xE5,0xBB,0xBB), o3(0xE5,0xBE,0x8A),
     o3(0xE6,0x81,0xA2), o3(0xE6,0x82,0x94),
     o3(0xE6,0x87,0xB7), o3(0xE6,0x99,0xA6),
     o3(0xE6,0x9C,0x83), o3(0xE6,0xAA,0x9C),
     o3(0xE6,0xB7,0xAE), o3(0xE6,0xBE,0xAE),
     o3(0xE7,0x81,0xB0), o3(0xE7,0x8D,0xAA),
     o3(0xE7,0xB9,0xAA), o3(0xE8,0x86,0xBE),
     o3(0xE8,0x8C,0xB4), o3(0xE8,0x9B,0x94),
     o3(0xE8,0xAA,0xA8), o3(0xE8,0xB3,0x84),
     o3(0xE5,0x8A,0x83), o3(0xE7,0x8D,0xB2),
     o3(0xE5,0xAE,0x96), o3(0xE6,0xA9,0xAB),
     o3(0xE9,0x90,0x84), o3(0xE5,0x93,0xAE),
     o3(0xE5,0x9A,0x86), o3(0xE5,0xAD,0x9D),
     o3(0xE6,0x95,0x88), o3(0xE6,0x96,0x85),
     o3(0xE6,0x9B,0x89), o3(0xE6,0xA2,0x9F),
     o3(0xE6,0xB6,0x8D), o3(0xE6,0xB7,0x86),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_FC = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_FC_infos
};


static const struct byte_lookup* const
from_EUC_KR_FD_infos[95] = {
     o3(0xE7,0x88,0xBB), o3(0xE8,0x82,0xB4),
     o3(0xE9,0x85,0xB5), o3(0xE9,0xA9,0x8D),
     o3(0xE4,0xBE,0xAF), o3(0xE5,0x80,0x99),
     o3(0xE5,0x8E,0x9A), o3(0xE5,0x90,0x8E),
     o3(0xE5,0x90,0xBC), o3(0xE5,0x96,0x89),
     o3(0xE5,0x97,0x85), o3(0xE5,0xB8,0xBF),
     o3(0xE5,0xBE,0x8C), o3(0xE6,0x9C,0xBD),
     o3(0xE7,0x85,0xA6), o3(0xE7,0x8F,0x9D),
     o3(0xE9,0x80,0x85), o3(0xE5,0x8B,0x9B),
     o3(0xE5,0x8B,0xB3), o3(0xE5,0xA1,0xA4),
     o3(0xE5,0xA3,0x8E), o3(0xE7,0x84,0x84),
     o3(0xE7,0x86,0x8F), o3(0xE7,0x87,0xBB),
     o3(0xE8,0x96,0xB0), o3(0xE8,0xA8,0x93),
     o3(0xE6,0x9A,0x88), o3(0xE8,0x96,0xA8),
     o3(0xE5,0x96,0xA7), o3(0xE6,0x9A,0x84),
     o3(0xE7,0x85,0x8A), o3(0xE8,0x90,0xB1),
     o3(0xE5,0x8D,0x89), o3(0xE5,0x96,0x99),
     o3(0xE6,0xAF,0x81), o3(0xE5,0xBD,0x99),
     o3(0xE5,0xBE,0xBD), o3(0xE6,0x8F,0xAE),
     o3(0xE6,0x9A,0x89), o3(0xE7,0x85,0x87),
     o3(0xE8,0xAB,0xB1), o3(0xE8,0xBC,0x9D),
     o3(0xE9,0xBA,0xBE), o3(0xE4,0xBC,0x91),
     o3(0xE6,0x90,0xBA), o3(0xE7,0x83,0x8B),
     o3(0xE7,0x95,0xA6), o3(0xE8,0x99,0xA7),
     o3(0xE6,0x81,0xA4), o3(0xE8,0xAD,0x8E),
     o3(0xE9,0xB7,0xB8), o3(0xE5,0x85,0x87),
     o3(0xE5,0x87,0xB6), o3(0xE5,0x8C,0x88),
     o3(0xE6,0xB4,0xB6), o3(0xE8,0x83,0xB8),
     o3(0xE9,0xBB,0x91), o3(0xE6,0x98,0x95),
     o3(0xE6,0xAC,0xA3), o3(0xE7,0x82,0x98),
     o3(0xE7,0x97,0x95), o3(0xE5,0x90,0x83),
     o3(0xE5,0xB1,0xB9), o3(0xE7,0xB4,0x87),
     o3(0xE8,0xA8,0x96), o3(0xE6,0xAC,0xA0),
     o3(0xE6,0xAC,0xBD), o3(0xE6,0xAD,0x86),
     o3(0xE5,0x90,0xB8), o3(0xE6,0x81,0xB0),
     o3(0xE6,0xB4,0xBD), o3(0xE7,0xBF,0x95),
     o3(0xE8,0x88,0x88), o3(0xE5,0x83,0x96),
     o3(0xE5,0x87,0x9E), o3(0xE5,0x96,0x9C),
     o3(0xE5,0x99,0xAB), o3(0xE5,0x9B,0x8D),
     o3(0xE5,0xA7,0xAC), o3(0xE5,0xAC,0x89),
     o3(0xE5,0xB8,0x8C), o3(0xE6,0x86,0x99),
     o3(0xE6,0x86,0x98), o3(0xE6,0x88,0xB1),
     o3(0xE6,0x99,0x9E), o3(0xE6,0x9B,0xA6),
     o3(0xE7,0x86,0x99), o3(0xE7,0x86,0xB9),
     o3(0xE7,0x86,0xBA), o3(0xE7,0x8A,0xA7),
     o3(0xE7,0xA6,0xA7), o3(0xE7,0xA8,0x80),
     o3(0xE7,0xBE,0xB2), o3(0xE8,0xA9,0xB0),
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR_FD = {
    from_EUC_KR_A1_offsets,
    from_EUC_KR_FD_infos
};

static const unsigned char
from_EUC_KR_offsets[256] = {
      0,  0,  0,  0,  0,  0,  0,  0,      0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,      0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,      0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,      0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,      0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,      0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,      0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,      0,  0,  0,  0,  0,  0,  0,  0,
     90, 90, 90, 90, 90, 90, 90, 90,     90, 90, 90, 90, 90, 90, 90, 90,
     90, 90, 90, 90, 90, 90, 90, 90,     90, 90, 90, 90, 90, 90, 90, 90,
     90,  1,  2,  3,  4,  5,  6,  7,      8,  9, 10, 11, 12, 90, 90, 90,
     13, 14, 15, 16, 17, 18, 19, 20,     21, 22, 23, 24, 25, 26, 27, 28,
     29, 30, 31, 32, 33, 34, 35, 36,     37, 90, 38, 39, 40, 41, 42, 43,
     44, 45, 46, 47, 48, 49, 50, 51,     52, 53, 54, 55, 56, 57, 58, 59,
     60, 61, 62, 63, 64, 65, 66, 67,     68, 69, 70, 71, 72, 73, 74, 75,
     76, 77, 78, 79, 80, 81, 82, 83,     84, 85, 86, 87, 88, 89, 90, 90,
};

static const struct byte_lookup* const
from_EUC_KR_infos[91] = {
                  NOMAP,    &from_EUC_KR_A1,
        &from_EUC_KR_A2,    &from_EUC_KR_A3,
        &from_EUC_KR_A4,    &from_EUC_KR_A5,
        &from_EUC_KR_A6,    &from_EUC_KR_A7,
        &from_EUC_KR_A8,    &from_EUC_KR_A9,
        &from_EUC_KR_AA,    &from_EUC_KR_AB,
        &from_EUC_KR_AC,    &from_EUC_KR_B0,
        &from_EUC_KR_B1,    &from_EUC_KR_B2,
        &from_EUC_KR_B3,    &from_EUC_KR_B4,
        &from_EUC_KR_B5,    &from_EUC_KR_B6,
        &from_EUC_KR_B7,    &from_EUC_KR_B8,
        &from_EUC_KR_B9,    &from_EUC_KR_BA,
        &from_EUC_KR_BB,    &from_EUC_KR_BC,
        &from_EUC_KR_BD,    &from_EUC_KR_BE,
        &from_EUC_KR_BF,    &from_EUC_KR_C0,
        &from_EUC_KR_C1,    &from_EUC_KR_C2,
        &from_EUC_KR_C3,    &from_EUC_KR_C4,
        &from_EUC_KR_C5,    &from_EUC_KR_C6,
        &from_EUC_KR_C7,    &from_EUC_KR_C8,
        &from_EUC_KR_CA,    &from_EUC_KR_CB,
        &from_EUC_KR_CC,    &from_EUC_KR_CD,
        &from_EUC_KR_CE,    &from_EUC_KR_CF,
        &from_EUC_KR_D0,    &from_EUC_KR_D1,
        &from_EUC_KR_D2,    &from_EUC_KR_D3,
        &from_EUC_KR_D4,    &from_EUC_KR_D5,
        &from_EUC_KR_D6,    &from_EUC_KR_D7,
        &from_EUC_KR_D8,    &from_EUC_KR_D9,
        &from_EUC_KR_DA,    &from_EUC_KR_DB,
        &from_EUC_KR_DC,    &from_EUC_KR_DD,
        &from_EUC_KR_DE,    &from_EUC_KR_DF,
        &from_EUC_KR_E0,    &from_EUC_KR_E1,
        &from_EUC_KR_E2,    &from_EUC_KR_E3,
        &from_EUC_KR_E4,    &from_EUC_KR_E5,
        &from_EUC_KR_E6,    &from_EUC_KR_E7,
        &from_EUC_KR_E8,    &from_EUC_KR_E9,
        &from_EUC_KR_EA,    &from_EUC_KR_EB,
        &from_EUC_KR_EC,    &from_EUC_KR_ED,
        &from_EUC_KR_EE,    &from_EUC_KR_EF,
        &from_EUC_KR_F0,    &from_EUC_KR_F1,
        &from_EUC_KR_F2,    &from_EUC_KR_F3,
        &from_EUC_KR_F4,    &from_EUC_KR_F5,
        &from_EUC_KR_F6,    &from_EUC_KR_F7,
        &from_EUC_KR_F8,    &from_EUC_KR_F9,
        &from_EUC_KR_FA,    &from_EUC_KR_FB,
        &from_EUC_KR_FC,    &from_EUC_KR_FD,
                  UNDEF,
};

static const BYTE_LOOKUP
from_EUC_KR = {
    from_EUC_KR_offsets,
    from_EUC_KR_infos
};

static const unsigned char
to_CP949_C2_offsets[64] = {
     21, 21, 21, 21, 21, 21, 21, 21,     21, 21, 21, 21, 21, 21, 21, 21,
     21, 21, 21, 21, 21, 21, 21, 21,     21, 21, 21, 21, 21, 21, 21, 21,
     21,  0, 21, 21,  1, 21, 21,  2,      3, 21,  4, 21, 21,  5,  6, 21,
      7,  8,  9, 10, 11, 21, 12, 13,     14, 15, 16, 21, 17, 18, 19, 20,
};

static const struct byte_lookup* const
to_CP949_C2_infos[22] = {
          o2(0xA2,0xAE),      o2(0xA2,0xB4),
          o2(0xA1,0xD7),      o2(0xA1,0xA7),
          o2(0xA8,0xA3),      o2(0xA1,0xA9),
          o2(0xA2,0xE7),      o2(0xA1,0xC6),
          o2(0xA1,0xBE),      o2(0xA9,0xF7),
          o2(0xA9,0xF8),      o2(0xA2,0xA5),
          o2(0xA2,0xD2),      o2(0xA1,0xA4),
          o2(0xA2,0xAC),      o2(0xA9,0xF6),
          o2(0xA8,0xAC),      o2(0xA8,0xF9),
          o2(0xA8,0xF6),      o2(0xA8,0xFA),
          o2(0xA2,0xAF),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_C2 = {
    to_CP949_C2_offsets,
    to_CP949_C2_infos
};


static const struct byte_lookup* const
to_CP949_C3_infos[12] = {
          o2(0xA8,0xA1),      o2(0xA8,0xA2),
          o2(0xA1,0xBF),      o2(0xA8,0xAA),
          o2(0xA8,0xAD),      o2(0xA9,0xAC),
          o2(0xA9,0xA1),      o2(0xA9,0xA3),
          o2(0xA1,0xC0),      o2(0xA9,0xAA),
          o2(0xA9,0xAD),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_C3 = {
    to_EUC_KR_C3_offsets,
    to_CP949_C3_infos
};


static const struct byte_lookup* const
to_CP949_C4_infos[9] = {
          o2(0xA9,0xA2),      o2(0xA8,0xA4),
          o2(0xA9,0xA4),      o2(0xA9,0xA5),
          o2(0xA8,0xA6),      o2(0xA9,0xA6),
          o2(0xA9,0xA7),      o2(0xA8,0xA8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_C4 = {
    to_EUC_KR_C4_offsets,
    to_CP949_C4_infos
};


static const struct byte_lookup* const
to_CP949_C5_infos[11] = {
          o2(0xA9,0xA8),      o2(0xA8,0xA9),
          o2(0xA9,0xA9),      o2(0xA9,0xB0),
          o2(0xA8,0xAF),      o2(0xA9,0xAF),
          o2(0xA8,0xAB),      o2(0xA9,0xAB),
          o2(0xA8,0xAE),      o2(0xA9,0xAE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_C5 = {
    to_EUC_KR_C5_offsets,
    to_CP949_C5_infos
};


static const struct byte_lookup* const
to_CP949_CB_infos[8] = {
          o2(0xA2,0xA7),      o2(0xA2,0xB0),
          o2(0xA2,0xA8),      o2(0xA2,0xAB),
          o2(0xA2,0xAA),      o2(0xA2,0xAD),
          o2(0xA2,0xA9),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_CB = {
    to_EUC_KR_CB_offsets,
    to_CP949_CB_infos
};


static const struct byte_lookup* const
to_CP949_CE_infos[40] = {
          o2(0xA5,0xC1),      o2(0xA5,0xC2),
          o2(0xA5,0xC3),      o2(0xA5,0xC4),
          o2(0xA5,0xC5),      o2(0xA5,0xC6),
          o2(0xA5,0xC7),      o2(0xA5,0xC8),
          o2(0xA5,0xC9),      o2(0xA5,0xCA),
          o2(0xA5,0xCB),      o2(0xA5,0xCC),
          o2(0xA5,0xCD),      o2(0xA5,0xCE),
          o2(0xA5,0xCF),      o2(0xA5,0xD0),
          o2(0xA5,0xD1),      o2(0xA5,0xD2),
          o2(0xA5,0xD3),      o2(0xA5,0xD4),
          o2(0xA5,0xD5),      o2(0xA5,0xD6),
          o2(0xA5,0xD7),      o2(0xA5,0xD8),
          o2(0xA5,0xE1),      o2(0xA5,0xE2),
          o2(0xA5,0xE3),      o2(0xA5,0xE4),
          o2(0xA5,0xE5),      o2(0xA5,0xE6),
          o2(0xA5,0xE7),      o2(0xA5,0xE8),
          o2(0xA5,0xE9),      o2(0xA5,0xEA),
          o2(0xA5,0xEB),      o2(0xA5,0xEC),
          o2(0xA5,0xED),      o2(0xA5,0xEE),
          o2(0xA5,0xEF),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_CE = {
    to_EUC_KR_CE_offsets,
    to_CP949_CE_infos
};


static const struct byte_lookup* const
to_CP949_CF_infos[10] = {
          o2(0xA5,0xF0),      o2(0xA5,0xF1),
          o2(0xA5,0xF2),      o2(0xA5,0xF3),
          o2(0xA5,0xF4),      o2(0xA5,0xF5),
          o2(0xA5,0xF6),      o2(0xA5,0xF7),
          o2(0xA5,0xF8),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_CF = {
    to_EUC_KR_CF_offsets,
    to_CP949_CF_infos
};


static const struct byte_lookup* const
to_CP949_D0_infos[50] = {
          o2(0xAC,0xA7),      o2(0xAC,0xA1),
          o2(0xAC,0xA2),      o2(0xAC,0xA3),
          o2(0xAC,0xA4),      o2(0xAC,0xA5),
          o2(0xAC,0xA6),      o2(0xAC,0xA8),
          o2(0xAC,0xA9),      o2(0xAC,0xAA),
          o2(0xAC,0xAB),      o2(0xAC,0xAC),
          o2(0xAC,0xAD),      o2(0xAC,0xAE),
          o2(0xAC,0xAF),      o2(0xAC,0xB0),
          o2(0xAC,0xB1),      o2(0xAC,0xB2),
          o2(0xAC,0xB3),      o2(0xAC,0xB4),
          o2(0xAC,0xB5),      o2(0xAC,0xB6),
          o2(0xAC,0xB7),      o2(0xAC,0xB8),
          o2(0xAC,0xB9),      o2(0xAC,0xBA),
          o2(0xAC,0xBB),      o2(0xAC,0xBC),
          o2(0xAC,0xBD),      o2(0xAC,0xBE),
          o2(0xAC,0xBF),      o2(0xAC,0xC0),
          o2(0xAC,0xC1),      o2(0xAC,0xD1),
          o2(0xAC,0xD2),      o2(0xAC,0xD3),
          o2(0xAC,0xD4),      o2(0xAC,0xD5),
          o2(0xAC,0xD6),      o2(0xAC,0xD8),
          o2(0xAC,0xD9),      o2(0xAC,0xDA),
          o2(0xAC,0xDB),      o2(0xAC,0xDC),
          o2(0xAC,0xDD),      o2(0xAC,0xDE),
          o2(0xAC,0xDF),      o2(0xAC,0xE0),
          o2(0xAC,0xE1),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_D0 = {
    to_EUC_KR_D0_offsets,
    to_CP949_D0_infos
};


static const struct byte_lookup* const
to_CP949_D1_infos[18] = {
          o2(0xAC,0xE2),      o2(0xAC,0xE3),
          o2(0xAC,0xE4),      o2(0xAC,0xE5),
          o2(0xAC,0xE6),      o2(0xAC,0xE7),
          o2(0xAC,0xE8),      o2(0xAC,0xE9),
          o2(0xAC,0xEA),      o2(0xAC,0xEB),
          o2(0xAC,0xEC),      o2(0xAC,0xED),
          o2(0xAC,0xEE),      o2(0xAC,0xEF),
          o2(0xAC,0xF0),      o2(0xAC,0xF1),
          o2(0xAC,0xD7),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_D1 = {
    to_EUC_KR_D1_offsets,
    to_CP949_D1_infos
};


static const struct byte_lookup* const
to_CP949_E2_00_infos[14] = {
          o2(0xA1,0xAA),      o2(0xA1,0xAE),
          o2(0xA1,0xAF),      o2(0xA1,0xB0),
          o2(0xA1,0xB1),      o2(0xA2,0xD3),
          o2(0xA2,0xD4),      o2(0xA1,0xA5),
          o2(0xA1,0xA6),      o2(0xA2,0xB6),
          o2(0xA1,0xC7),      o2(0xA1,0xC8),
          o2(0xA1,0xD8),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_00 = {
    to_EUC_KR_E2_00_offsets,
    to_CP949_E2_00_infos
};


static const struct byte_lookup* const
to_CP949_E2_01_infos[3] = {
          o2(0xA9,0xF9),      o2(0xA9,0xFA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_01 = {
    to_EUC_KR_E2_01_offsets,
    to_CP949_E2_01_infos
};

static const unsigned char
to_CP949_E2_02_offsets[64] = {
      5,  0,  1,  2,  3,  5,  5,  5,      5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  4,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,      5,  5,  5,  5,  5,  5,  5,  5,
};

static const struct byte_lookup* const
to_CP949_E2_02_infos[6] = {
          o2(0xA9,0xFB),      o2(0xA9,0xFC),
          o2(0xA9,0xFD),      o2(0xA9,0xFE),
          o2(0xA2,0xE6),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_02 = {
    to_CP949_E2_02_offsets,
    to_CP949_E2_02_infos
};


static const struct byte_lookup* const
to_CP949_E2_04_infos[9] = {
          o2(0xA1,0xC9),      o2(0xA2,0xB5),
          o2(0xA7,0xA4),      o2(0xA2,0xE0),
          o2(0xA2,0xE5),      o2(0xA2,0xE2),
          o2(0xA7,0xD9),      o2(0xA1,0xCA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_04 = {
    to_EUC_KR_E2_04_offsets,
    to_CP949_E2_04_infos
};


static const struct byte_lookup* const
to_CP949_E2_05_infos[27] = {
          o2(0xA8,0xF7),      o2(0xA8,0xF8),
          o2(0xA8,0xFB),      o2(0xA8,0xFC),
          o2(0xA8,0xFD),      o2(0xA8,0xFE),
          o2(0xA5,0xB0),      o2(0xA5,0xB1),
          o2(0xA5,0xB2),      o2(0xA5,0xB3),
          o2(0xA5,0xB4),      o2(0xA5,0xB5),
          o2(0xA5,0xB6),      o2(0xA5,0xB7),
          o2(0xA5,0xB8),      o2(0xA5,0xB9),
          o2(0xA5,0xA1),      o2(0xA5,0xA2),
          o2(0xA5,0xA3),      o2(0xA5,0xA4),
          o2(0xA5,0xA5),      o2(0xA5,0xA6),
          o2(0xA5,0xA7),      o2(0xA5,0xA8),
          o2(0xA5,0xA9),      o2(0xA5,0xAA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_05 = {
    to_EUC_KR_E2_05_offsets,
    to_CP949_E2_05_infos
};


static const struct byte_lookup* const
to_CP949_E2_06_infos[11] = {
          o2(0xA1,0xE7),      o2(0xA1,0xE8),
          o2(0xA1,0xE6),      o2(0xA1,0xE9),
          o2(0xA1,0xEA),      o2(0xA2,0xD5),
          o2(0xA2,0xD8),      o2(0xA2,0xD6),
          o2(0xA2,0xD9),      o2(0xA2,0xD7),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_06 = {
    to_EUC_KR_E2_06_offsets,
    to_CP949_E2_06_infos
};


static const struct byte_lookup* const
to_CP949_E2_07_infos[3] = {
          o2(0xA2,0xA1),      o2(0xA2,0xA2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_07 = {
    to_EUC_KR_E2_07_offsets,
    to_CP949_E2_07_infos
};


static const struct byte_lookup* const
to_CP949_E2_08_infos[25] = {
          o2(0xA2,0xA3),      o2(0xA1,0xD3),
          o2(0xA2,0xA4),      o2(0xA1,0xD4),
          o2(0xA1,0xF4),      o2(0xA1,0xF5),
          o2(0xA2,0xB3),      o2(0xA2,0xB2),
          o2(0xA1,0xEE),      o2(0xA1,0xF0),
          o2(0xA1,0xC4),      o2(0xA1,0xD0),
          o2(0xA1,0xAB),      o2(0xA1,0xFC),
          o2(0xA1,0xFD),      o2(0xA1,0xFB),
          o2(0xA1,0xFA),      o2(0xA1,0xF2),
          o2(0xA1,0xF3),      o2(0xA2,0xB1),
          o2(0xA1,0xC5),      o2(0xA1,0xF1),
          o2(0xA1,0xAD),      o2(0xA1,0xEF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_08 = {
    to_EUC_KR_E2_08_offsets,
    to_CP949_E2_08_infos
};


static const struct byte_lookup* const
to_CP949_E2_09_infos[8] = {
          o2(0xA1,0xD6),      o2(0xA1,0xC1),
          o2(0xA1,0xD5),      o2(0xA1,0xC2),
          o2(0xA1,0xC3),      o2(0xA1,0xEC),
          o2(0xA1,0xED),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_09 = {
    to_EUC_KR_E2_09_offsets,
    to_CP949_E2_09_infos
};


static const struct byte_lookup* const
to_CP949_E2_0A_infos[7] = {
          o2(0xA1,0xF8),      o2(0xA1,0xF9),
          o2(0xA1,0xF6),      o2(0xA1,0xF7),
          o2(0xA2,0xC1),      o2(0xA1,0xD1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_0A = {
    to_EUC_KR_E2_0A_offsets,
    to_CP949_E2_0A_infos
};


static const struct byte_lookup* const
to_CP949_E2_0C_infos[2] = {
          o2(0xA1,0xD2),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_0C = {
    to_EUC_KR_E2_0C_offsets,
    to_CP949_E2_0C_infos
};


static const struct byte_lookup* const
to_CP949_E2_11_infos[28] = {
          o2(0xA8,0xE7),      o2(0xA8,0xE8),
          o2(0xA8,0xE9),      o2(0xA8,0xEA),
          o2(0xA8,0xEB),      o2(0xA8,0xEC),
          o2(0xA8,0xED),      o2(0xA8,0xEE),
          o2(0xA8,0xEF),      o2(0xA8,0xF0),
          o2(0xA8,0xF1),      o2(0xA8,0xF2),
          o2(0xA8,0xF3),      o2(0xA8,0xF4),
          o2(0xA8,0xF5),      o2(0xA9,0xE7),
          o2(0xA9,0xE8),      o2(0xA9,0xE9),
          o2(0xA9,0xEA),      o2(0xA9,0xEB),
          o2(0xA9,0xEC),      o2(0xA9,0xED),
          o2(0xA9,0xEE),      o2(0xA9,0xEF),
          o2(0xA9,0xF0),      o2(0xA9,0xF1),
          o2(0xA9,0xF2),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_11 = {
    to_EUC_KR_E2_11_offsets,
    to_CP949_E2_11_infos
};


static const struct byte_lookup* const
to_CP949_E2_12_infos[30] = {
          o2(0xA9,0xF3),      o2(0xA9,0xF4),
          o2(0xA9,0xF5),      o2(0xA9,0xCD),
          o2(0xA9,0xCE),      o2(0xA9,0xCF),
          o2(0xA9,0xD0),      o2(0xA9,0xD1),
          o2(0xA9,0xD2),      o2(0xA9,0xD3),
          o2(0xA9,0xD4),      o2(0xA9,0xD5),
          o2(0xA9,0xD6),      o2(0xA9,0xD7),
          o2(0xA9,0xD8),      o2(0xA9,0xD9),
          o2(0xA9,0xDA),      o2(0xA9,0xDB),
          o2(0xA9,0xDC),      o2(0xA9,0xDD),
          o2(0xA9,0xDE),      o2(0xA9,0xDF),
          o2(0xA9,0xE0),      o2(0xA9,0xE1),
          o2(0xA9,0xE2),      o2(0xA9,0xE3),
          o2(0xA9,0xE4),      o2(0xA9,0xE5),
          o2(0xA9,0xE6),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_12 = {
    to_EUC_KR_E2_12_offsets,
    to_CP949_E2_12_infos
};


static const struct byte_lookup* const
to_CP949_E2_13_infos[27] = {
          o2(0xA8,0xCD),      o2(0xA8,0xCE),
          o2(0xA8,0xCF),      o2(0xA8,0xD0),
          o2(0xA8,0xD1),      o2(0xA8,0xD2),
          o2(0xA8,0xD3),      o2(0xA8,0xD4),
          o2(0xA8,0xD5),      o2(0xA8,0xD6),
          o2(0xA8,0xD7),      o2(0xA8,0xD8),
          o2(0xA8,0xD9),      o2(0xA8,0xDA),
          o2(0xA8,0xDB),      o2(0xA8,0xDC),
          o2(0xA8,0xDD),      o2(0xA8,0xDE),
          o2(0xA8,0xDF),      o2(0xA8,0xE0),
          o2(0xA8,0xE1),      o2(0xA8,0xE2),
          o2(0xA8,0xE3),      o2(0xA8,0xE4),
          o2(0xA8,0xE5),      o2(0xA8,0xE6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_13 = {
    to_EUC_KR_E2_13_offsets,
    to_CP949_E2_13_infos
};


static const struct byte_lookup* const
to_CP949_E2_14_infos[57] = {
          o2(0xA6,0xA1),      o2(0xA6,0xAC),
          o2(0xA6,0xA2),      o2(0xA6,0xAD),
          o2(0xA6,0xA3),      o2(0xA6,0xC8),
          o2(0xA6,0xC7),      o2(0xA6,0xAE),
          o2(0xA6,0xA4),      o2(0xA6,0xC2),
          o2(0xA6,0xC1),      o2(0xA6,0xAF),
          o2(0xA6,0xA6),      o2(0xA6,0xC6),
          o2(0xA6,0xC5),      o2(0xA6,0xB1),
          o2(0xA6,0xA5),      o2(0xA6,0xC4),
          o2(0xA6,0xC3),      o2(0xA6,0xB0),
          o2(0xA6,0xA7),      o2(0xA6,0xBC),
          o2(0xA6,0xC9),      o2(0xA6,0xCA),
          o2(0xA6,0xB7),      o2(0xA6,0xCB),
          o2(0xA6,0xCC),      o2(0xA6,0xB2),
          o2(0xA6,0xA9),      o2(0xA6,0xBE),
          o2(0xA6,0xCD),      o2(0xA6,0xCE),
          o2(0xA6,0xB9),      o2(0xA6,0xCF),
          o2(0xA6,0xD0),      o2(0xA6,0xB4),
          o2(0xA6,0xA8),      o2(0xA6,0xD1),
          o2(0xA6,0xD2),      o2(0xA6,0xB8),
          o2(0xA6,0xBD),      o2(0xA6,0xD3),
          o2(0xA6,0xD4),      o2(0xA6,0xB3),
          o2(0xA6,0xAA),      o2(0xA6,0xD5),
          o2(0xA6,0xD6),      o2(0xA6,0xBA),
          o2(0xA6,0xBF),      o2(0xA6,0xD7),
          o2(0xA6,0xD8),      o2(0xA6,0xB5),
          o2(0xA6,0xAB),      o2(0xA6,0xD9),
          o2(0xA6,0xDA),      o2(0xA6,0xBB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_14 = {
    to_EUC_KR_E2_14_offsets,
    to_CP949_E2_14_infos
};


static const struct byte_lookup* const
to_CP949_E2_15_infos[13] = {
          o2(0xA6,0xDB),      o2(0xA6,0xDC),
          o2(0xA6,0xC0),      o2(0xA6,0xDD),
          o2(0xA6,0xDE),      o2(0xA6,0xDF),
          o2(0xA6,0xE0),      o2(0xA6,0xE1),
          o2(0xA6,0xE2),      o2(0xA6,0xE3),
          o2(0xA6,0xE4),      o2(0xA6,0xB6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_15 = {
    to_EUC_KR_E2_15_offsets,
    to_CP949_E2_15_infos
};


static const struct byte_lookup* const
to_CP949_E2_16_infos[17] = {
          o2(0xA2,0xC6),      o2(0xA1,0xE1),
          o2(0xA1,0xE0),      o2(0xA2,0xC3),
          o2(0xA2,0xC7),      o2(0xA2,0xC8),
          o2(0xA2,0xCB),      o2(0xA2,0xCA),
          o2(0xA2,0xC9),      o2(0xA2,0xCC),
          o2(0xA1,0xE3),      o2(0xA1,0xE2),
          o2(0xA2,0xBA),      o2(0xA2,0xB9),
          o2(0xA1,0xE5),      o2(0xA1,0xE4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_16 = {
    to_EUC_KR_E2_16_offsets,
    to_CP949_E2_16_infos
};


static const struct byte_lookup* const
to_CP949_E2_17_infos[11] = {
          o2(0xA2,0xB8),      o2(0xA2,0xB7),
          o2(0xA1,0xDF),      o2(0xA1,0xDE),
          o2(0xA2,0xC2),      o2(0xA1,0xDB),
          o2(0xA1,0xDD),      o2(0xA1,0xDC),
          o2(0xA2,0xC4),      o2(0xA2,0xC5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_17 = {
    to_EUC_KR_E2_17_offsets,
    to_CP949_E2_17_infos
};


static const struct byte_lookup* const
to_CP949_E2_18_infos[7] = {
          o2(0xA1,0xDA),      o2(0xA1,0xD9),
          o2(0xA2,0xCF),      o2(0xA2,0xCE),
          o2(0xA2,0xD0),      o2(0xA2,0xD1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_18 = {
    to_EUC_KR_E2_18_offsets,
    to_CP949_E2_18_infos
};


static const struct byte_lookup* const
to_CP949_E2_19_infos[14] = {
          o2(0xA1,0xCF),      o2(0xA1,0xCE),
          o2(0xA2,0xBC),      o2(0xA2,0xBD),
          o2(0xA2,0xC0),      o2(0xA2,0xBB),
          o2(0xA2,0xBE),      o2(0xA2,0xBF),
          o2(0xA2,0xCD),      o2(0xA2,0xDB),
          o2(0xA2,0xDC),      o2(0xA2,0xDD),
          o2(0xA2,0xDA),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2_19 = {
    to_EUC_KR_E2_19_offsets,
    to_CP949_E2_19_infos
};


static const struct byte_lookup* const
to_CP949_E2_infos[21] = {
        &to_CP949_E2_00,    &to_CP949_E2_01,
        &to_CP949_E2_02,    &to_CP949_E2_04,
        &to_CP949_E2_05,    &to_CP949_E2_06,
        &to_CP949_E2_07,    &to_CP949_E2_08,
        &to_CP949_E2_09,    &to_CP949_E2_0A,
        &to_CP949_E2_0C,    &to_CP949_E2_11,
        &to_CP949_E2_12,    &to_CP949_E2_13,
        &to_CP949_E2_14,    &to_CP949_E2_15,
        &to_CP949_E2_16,    &to_CP949_E2_17,
        &to_CP949_E2_18,    &to_CP949_E2_19,
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E2 = {
    to_EUC_KR_E2_offsets,
    to_CP949_E2_infos
};


static const struct byte_lookup* const
to_CP949_E3_00_infos[18] = {
          o2(0xA1,0xA1),      o2(0xA1,0xA2),
          o2(0xA1,0xA3),      o2(0xA1,0xA8),
          o2(0xA1,0xB4),      o2(0xA1,0xB5),
          o2(0xA1,0xB6),      o2(0xA1,0xB7),
          o2(0xA1,0xB8),      o2(0xA1,0xB9),
          o2(0xA1,0xBA),      o2(0xA1,0xBB),
          o2(0xA1,0xBC),      o2(0xA1,0xBD),
          o2(0xA1,0xEB),      o2(0xA1,0xB2),
          o2(0xA1,0xB3),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E3_00 = {
    to_EUC_KR_E3_00_offsets,
    to_CP949_E3_00_infos
};


static const struct byte_lookup* const
to_CP949_E3_01_infos[64] = {
          o2(0xAA,0xA1),      o2(0xAA,0xA2),
          o2(0xAA,0xA3),      o2(0xAA,0xA4),
          o2(0xAA,0xA5),      o2(0xAA,0xA6),
          o2(0xAA,0xA7),      o2(0xAA,0xA8),
          o2(0xAA,0xA9),      o2(0xAA,0xAA),
          o2(0xAA,0xAB),      o2(0xAA,0xAC),
          o2(0xAA,0xAD),      o2(0xAA,0xAE),
          o2(0xAA,0xAF),      o2(0xAA,0xB0),
          o2(0xAA,0xB1),      o2(0xAA,0xB2),
          o2(0xAA,0xB3),      o2(0xAA,0xB4),
          o2(0xAA,0xB5),      o2(0xAA,0xB6),
          o2(0xAA,0xB7),      o2(0xAA,0xB8),
          o2(0xAA,0xB9),      o2(0xAA,0xBA),
          o2(0xAA,0xBB),      o2(0xAA,0xBC),
          o2(0xAA,0xBD),      o2(0xAA,0xBE),
          o2(0xAA,0xBF),      o2(0xAA,0xC0),
          o2(0xAA,0xC1),      o2(0xAA,0xC2),
          o2(0xAA,0xC3),      o2(0xAA,0xC4),
          o2(0xAA,0xC5),      o2(0xAA,0xC6),
          o2(0xAA,0xC7),      o2(0xAA,0xC8),
          o2(0xAA,0xC9),      o2(0xAA,0xCA),
          o2(0xAA,0xCB),      o2(0xAA,0xCC),
          o2(0xAA,0xCD),      o2(0xAA,0xCE),
          o2(0xAA,0xCF),      o2(0xAA,0xD0),
          o2(0xAA,0xD1),      o2(0xAA,0xD2),
          o2(0xAA,0xD3),      o2(0xAA,0xD4),
          o2(0xAA,0xD5),      o2(0xAA,0xD6),
          o2(0xAA,0xD7),      o2(0xAA,0xD8),
          o2(0xAA,0xD9),      o2(0xAA,0xDA),
          o2(0xAA,0xDB),      o2(0xAA,0xDC),
          o2(0xAA,0xDD),      o2(0xAA,0xDE),
          o2(0xAA,0xDF),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E3_01 = {
    to_EUC_KR_E3_01_offsets,
    to_CP949_E3_01_infos
};


static const struct byte_lookup* const
to_CP949_E3_02_infos[52] = {
          o2(0xAA,0xE0),      o2(0xAA,0xE1),
          o2(0xAA,0xE2),      o2(0xAA,0xE3),
          o2(0xAA,0xE4),      o2(0xAA,0xE5),
          o2(0xAA,0xE6),      o2(0xAA,0xE7),
          o2(0xAA,0xE8),      o2(0xAA,0xE9),
          o2(0xAA,0xEA),      o2(0xAA,0xEB),
          o2(0xAA,0xEC),      o2(0xAA,0xED),
          o2(0xAA,0xEE),      o2(0xAA,0xEF),
          o2(0xAA,0xF0),      o2(0xAA,0xF1),
          o2(0xAA,0xF2),      o2(0xAA,0xF3),
          o2(0xAB,0xA1),      o2(0xAB,0xA2),
          o2(0xAB,0xA3),      o2(0xAB,0xA4),
          o2(0xAB,0xA5),      o2(0xAB,0xA6),
          o2(0xAB,0xA7),      o2(0xAB,0xA8),
          o2(0xAB,0xA9),      o2(0xAB,0xAA),
          o2(0xAB,0xAB),      o2(0xAB,0xAC),
          o2(0xAB,0xAD),      o2(0xAB,0xAE),
          o2(0xAB,0xAF),      o2(0xAB,0xB0),
          o2(0xAB,0xB1),      o2(0xAB,0xB2),
          o2(0xAB,0xB3),      o2(0xAB,0xB4),
          o2(0xAB,0xB5),      o2(0xAB,0xB6),
          o2(0xAB,0xB7),      o2(0xAB,0xB8),
          o2(0xAB,0xB9),      o2(0xAB,0xBA),
          o2(0xAB,0xBB),      o2(0xAB,0xBC),
          o2(0xAB,0xBD),      o2(0xAB,0xBE),
          o2(0xAB,0xBF),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E3_02 = {
    to_EUC_KR_E3_02_offsets,
    to_CP949_E3_02_infos
};


static const struct byte_lookup* const
to_CP949_E3_03_infos[56] = {
          o2(0xAB,0xC0),      o2(0xAB,0xC1),
          o2(0xAB,0xC2),      o2(0xAB,0xC3),
          o2(0xAB,0xC4),      o2(0xAB,0xC5),
          o2(0xAB,0xC6),      o2(0xAB,0xC7),
          o2(0xAB,0xC8),      o2(0xAB,0xC9),
          o2(0xAB,0xCA),      o2(0xAB,0xCB),
          o2(0xAB,0xCC),      o2(0xAB,0xCD),
          o2(0xAB,0xCE),      o2(0xAB,0xCF),
          o2(0xAB,0xD0),      o2(0xAB,0xD1),
          o2(0xAB,0xD2),      o2(0xAB,0xD3),
          o2(0xAB,0xD4),      o2(0xAB,0xD5),
          o2(0xAB,0xD6),      o2(0xAB,0xD7),
          o2(0xAB,0xD8),      o2(0xAB,0xD9),
          o2(0xAB,0xDA),      o2(0xAB,0xDB),
          o2(0xAB,0xDC),      o2(0xAB,0xDD),
          o2(0xAB,0xDE),      o2(0xAB,0xDF),
          o2(0xAB,0xE0),      o2(0xAB,0xE1),
          o2(0xAB,0xE2),      o2(0xAB,0xE3),
          o2(0xAB,0xE4),      o2(0xAB,0xE5),
          o2(0xAB,0xE6),      o2(0xAB,0xE7),
          o2(0xAB,0xE8),      o2(0xAB,0xE9),
          o2(0xAB,0xEA),      o2(0xAB,0xEB),
          o2(0xAB,0xEC),      o2(0xAB,0xED),
          o2(0xAB,0xEE),      o2(0xAB,0xEF),
          o2(0xAB,0xF0),      o2(0xAB,0xF1),
          o2(0xAB,0xF2),      o2(0xAB,0xF3),
          o2(0xAB,0xF4),      o2(0xAB,0xF5),
          o2(0xAB,0xF6),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E3_03 = {
    to_EUC_KR_E3_03_offsets,
    to_CP949_E3_03_infos
};


static const struct byte_lookup* const
to_CP949_E3_04_infos[16] = {
          o2(0xA4,0xA1),      o2(0xA4,0xA2),
          o2(0xA4,0xA3),      o2(0xA4,0xA4),
          o2(0xA4,0xA5),      o2(0xA4,0xA6),
          o2(0xA4,0xA7),      o2(0xA4,0xA8),
          o2(0xA4,0xA9),      o2(0xA4,0xAA),
          o2(0xA4,0xAB),      o2(0xA4,0xAC),
          o2(0xA4,0xAD),      o2(0xA4,0xAE),
          o2(0xA4,0xAF),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E3_04 = {
    to_EUC_KR_E3_04_offsets,
    to_CP949_E3_04_infos
};


static const struct byte_lookup* const
to_CP949_E3_05_infos[65] = {
          o2(0xA4,0xB0),      o2(0xA4,0xB1),
          o2(0xA4,0xB2),      o2(0xA4,0xB3),
          o2(0xA4,0xB4),      o2(0xA4,0xB5),
          o2(0xA4,0xB6),      o2(0xA4,0xB7),
          o2(0xA4,0xB8),      o2(0xA4,0xB9),
          o2(0xA4,0xBA),      o2(0xA4,0xBB),
          o2(0xA4,0xBC),      o2(0xA4,0xBD),
          o2(0xA4,0xBE),      o2(0xA4,0xBF),
          o2(0xA4,0xC0),      o2(0xA4,0xC1),
          o2(0xA4,0xC2),      o2(0xA4,0xC3),
          o2(0xA4,0xC4),      o2(0xA4,0xC5),
          o2(0xA4,0xC6),      o2(0xA4,0xC7),
          o2(0xA4,0xC8),      o2(0xA4,0xC9),
          o2(0xA4,0xCA),      o2(0xA4,0xCB),
          o2(0xA4,0xCC),      o2(0xA4,0xCD),
          o2(0xA4,0xCE),      o2(0xA4,0xCF),
          o2(0xA4,0xD0),      o2(0xA4,0xD1),
          o2(0xA4,0xD2),      o2(0xA4,0xD3),
          o2(0xA4,0xD4),      o2(0xA4,0xD5),
          o2(0xA4,0xD6),      o2(0xA4,0xD7),
          o2(0xA4,0xD8),      o2(0xA4,0xD9),
          o2(0xA4,0xDA),      o2(0xA4,0xDB),
          o2(0xA4,0xDC),      o2(0xA4,0xDD),
          o2(0xA4,0xDE),      o2(0xA4,0xDF),
          o2(0xA4,0xE0),      o2(0xA4,0xE1),
          o2(0xA4,0xE2),      o2(0xA4,0xE3),
          o2(0xA4,0xE4),      o2(0xA4,0xE5),
          o2(0xA4,0xE6),      o2(0xA4,0xE7),
          o2(0xA4,0xE8),      o2(0xA4,0xE9),
          o2(0xA4,0xEA),      o2(0xA4,0xEB),
          o2(0xA4,0xEC),      o2(0xA4,0xED),
          o2(0xA4,0xEE),      o2(0xA4,0xEF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E3_05 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_E3_05_infos
};


static const struct byte_lookup* const
to_CP949_E3_06_infos[16] = {
          o2(0xA4,0xF0),      o2(0xA4,0xF1),
          o2(0xA4,0xF2),      o2(0xA4,0xF3),
          o2(0xA4,0xF4),      o2(0xA4,0xF5),
          o2(0xA4,0xF6),      o2(0xA4,0xF7),
          o2(0xA4,0xF8),      o2(0xA4,0xF9),
          o2(0xA4,0xFA),      o2(0xA4,0xFB),
          o2(0xA4,0xFC),      o2(0xA4,0xFD),
          o2(0xA4,0xFE),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E3_06 = {
    to_EUC_KR_E3_06_offsets,
    to_CP949_E3_06_infos
};


static const struct byte_lookup* const
to_CP949_E3_08_infos[30] = {
          o2(0xA9,0xB1),      o2(0xA9,0xB2),
          o2(0xA9,0xB3),      o2(0xA9,0xB4),
          o2(0xA9,0xB5),      o2(0xA9,0xB6),
          o2(0xA9,0xB7),      o2(0xA9,0xB8),
          o2(0xA9,0xB9),      o2(0xA9,0xBA),
          o2(0xA9,0xBB),      o2(0xA9,0xBC),
          o2(0xA9,0xBD),      o2(0xA9,0xBE),
          o2(0xA9,0xBF),      o2(0xA9,0xC0),
          o2(0xA9,0xC1),      o2(0xA9,0xC2),
          o2(0xA9,0xC3),      o2(0xA9,0xC4),
          o2(0xA9,0xC5),      o2(0xA9,0xC6),
          o2(0xA9,0xC7),      o2(0xA9,0xC8),
          o2(0xA9,0xC9),      o2(0xA9,0xCA),
          o2(0xA9,0xCB),      o2(0xA9,0xCC),
          o2(0xA2,0xDF),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E3_08 = {
    to_EUC_KR_E3_08_offsets,
    to_CP949_E3_08_infos
};


static const struct byte_lookup* const
to_CP949_E3_09_infos[30] = {
          o2(0xA8,0xB1),      o2(0xA8,0xB2),
          o2(0xA8,0xB3),      o2(0xA8,0xB4),
          o2(0xA8,0xB5),      o2(0xA8,0xB6),
          o2(0xA8,0xB7),      o2(0xA8,0xB8),
          o2(0xA8,0xB9),      o2(0xA8,0xBA),
          o2(0xA8,0xBB),      o2(0xA8,0xBC),
          o2(0xA8,0xBD),      o2(0xA8,0xBE),
          o2(0xA8,0xBF),      o2(0xA8,0xC0),
          o2(0xA8,0xC1),      o2(0xA8,0xC2),
          o2(0xA8,0xC3),      o2(0xA8,0xC4),
          o2(0xA8,0xC5),      o2(0xA8,0xC6),
          o2(0xA8,0xC7),      o2(0xA8,0xC8),
          o2(0xA8,0xC9),      o2(0xA8,0xCA),
          o2(0xA8,0xCB),      o2(0xA8,0xCC),
          o2(0xA2,0xDE),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E3_09 = {
    to_EUC_KR_E3_09_offsets,
    to_CP949_E3_09_infos
};


static const struct byte_lookup* const
to_CP949_E3_0E_infos[62] = {
          o2(0xA7,0xC9),      o2(0xA7,0xCA),
          o2(0xA7,0xCB),      o2(0xA7,0xCC),
          o2(0xA7,0xCD),      o2(0xA7,0xBA),
          o2(0xA7,0xBB),      o2(0xA7,0xDC),
          o2(0xA7,0xDD),      o2(0xA7,0xDE),
          o2(0xA7,0xB6),      o2(0xA7,0xB7),
          o2(0xA7,0xB8),      o2(0xA7,0xD4),
          o2(0xA7,0xD5),      o2(0xA7,0xD6),
          o2(0xA7,0xD7),      o2(0xA7,0xD8),
          o2(0xA7,0xA1),      o2(0xA7,0xA2),
          o2(0xA7,0xA3),      o2(0xA7,0xA5),
          o2(0xA7,0xAB),      o2(0xA7,0xAC),
          o2(0xA7,0xAD),      o2(0xA7,0xAE),
          o2(0xA7,0xAF),      o2(0xA7,0xB0),
          o2(0xA7,0xB1),      o2(0xA7,0xB2),
          o2(0xA7,0xB3),      o2(0xA7,0xB4),
          o2(0xA7,0xA7),      o2(0xA7,0xA8),
          o2(0xA7,0xA9),      o2(0xA7,0xAA),
          o2(0xA7,0xBD),      o2(0xA7,0xBE),
          o2(0xA7,0xE5),      o2(0xA7,0xE6),
          o2(0xA7,0xE7),      o2(0xA7,0xE8),
          o2(0xA7,0xE1),      o2(0xA7,0xE2),
          o2(0xA7,0xE3),      o2(0xA7,0xBF),
          o2(0xA7,0xC0),      o2(0xA7,0xC1),
          o2(0xA7,0xC2),      o2(0xA7,0xC3),
          o2(0xA7,0xC4),      o2(0xA7,0xC5),
          o2(0xA7,0xC6),      o2(0xA7,0xC7),
          o2(0xA7,0xC8),      o2(0xA7,0xCE),
          o2(0xA7,0xCF),      o2(0xA7,0xD0),
          o2(0xA7,0xD1),      o2(0xA7,0xD2),
          o2(0xA7,0xD3),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E3_0E = {
    to_EUC_KR_E3_0E_offsets,
    to_CP949_E3_0E_infos
};


static const struct byte_lookup* const
to_CP949_E3_0F_infos[20] = {
          o2(0xA7,0xDA),      o2(0xA7,0xDB),
          o2(0xA2,0xE3),      o2(0xA7,0xEC),
          o2(0xA7,0xA6),      o2(0xA7,0xE0),
          o2(0xA7,0xEF),      o2(0xA2,0xE1),
          o2(0xA7,0xBC),      o2(0xA7,0xED),
          o2(0xA7,0xB5),      o2(0xA7,0xB9),
          o2(0xA7,0xEA),      o2(0xA7,0xEB),
          o2(0xA7,0xDF),      o2(0xA2,0xE4),
          o2(0xA7,0xE4),      o2(0xA7,0xEE),
          o2(0xA7,0xE9),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E3_0F = {
    to_EUC_KR_E3_0F_offsets,
    to_CP949_E3_0F_infos
};


static const struct byte_lookup* const
to_CP949_E3_infos[12] = {
        &to_CP949_E3_00,    &to_CP949_E3_01,
        &to_CP949_E3_02,    &to_CP949_E3_03,
        &to_CP949_E3_04,    &to_CP949_E3_05,
        &to_CP949_E3_06,    &to_CP949_E3_08,
        &to_CP949_E3_09,    &to_CP949_E3_0E,
        &to_CP949_E3_0F,              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E3 = {
    to_EUC_KR_E3_offsets,
    to_CP949_E3_infos
};


static const struct byte_lookup* const
to_CP949_E4_38_infos[22] = {
          o2(0xEC,0xE9),      o2(0xEF,0xCB),
          o2(0xF6,0xD2),      o2(0xD8,0xB2),
          o2(0xED,0xDB),      o2(0xDF,0xB2),
          o2(0xDF,0xBE),      o2(0xF9,0xBB),
          o2(0xDC,0xF4),      o2(0xF5,0xE4),
          o2(0xF3,0xA6),      o2(0xDD,0xE0),
          o2(0xE1,0xA6),      o2(0xCE,0xF8),
          o2(0xDC,0xB0),      o2(0xE3,0xAA),
          o2(0xF1,0xE9),      o2(0xCD,0xFA),
          o2(0xFC,0xAF),      o2(0xD3,0xA1),
          o2(0xF1,0xAB),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E4_38 = {
    to_EUC_KR_E4_38_offsets,
    to_CP949_E4_38_infos
};


static const struct byte_lookup* const
to_CP949_E4_39_infos[20] = {
          o2(0xE7,0xD1),      o2(0xD2,0xAC),
          o2(0xCE,0xF9),      o2(0xF1,0xFD),
          o2(0xDE,0xBF),      o2(0xFB,0xBA),
          o2(0xF9,0xB9),      o2(0xCE,0xD2),
          o2(0xE3,0xAB),      o2(0xEB,0xE0),
          o2(0xCE,0xFA),      o2(0xCB,0xF7),
          o2(0xE5,0xA5),      o2(0xCA,0xE1),
          o2(0xD4,0xCC),      o2(0xEA,0xE1),
          o2(0xDC,0xE3),      o2(0xDF,0xAD),
          o2(0xCB,0xEB),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E4_39 = {
    to_EUC_KR_E4_39_offsets,
    to_CP949_E4_39_infos
};


static const struct byte_lookup* const
to_CP949_E4_3A_infos[27] = {
          o2(0xD5,0xAF),      o2(0xD6,0xF5),
          o2(0xE5,0xF8),      o2(0xDE,0xC0),
          o2(0xEC,0xA3),      o2(0xE9,0xCD),
          o2(0xEA,0xA7),      o2(0xE9,0xF6),
          o2(0xFB,0xBB),      o2(0xE7,0xE9),
          o2(0xEF,0xCC),      o2(0xD0,0xE6),
          o2(0xDE,0xC1),      o2(0xE4,0xAC),
          o2(0xD8,0xCC),      o2(0xF9,0xF1),
          o2(0xCE,0xDF),      o2(0xFA,0xA4),
          o2(0xE6,0xB2),      o2(0xFA,0xFB),
          o2(0xFA,0xBD),      o2(0xCC,0xC8),
          o2(0xEF,0xCD),      o2(0xD5,0xD5),
          o2(0xD3,0xA2),      o2(0xEC,0xD1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E4_3A = {
    to_EUC_KR_E4_3A_offsets,
    to_CP949_E4_3A_infos
};


static const struct byte_lookup* const
to_CP949_E4_3B_infos[24] = {
          o2(0xE4,0xA7),      o2(0xEC,0xD2),
          o2(0xF6,0xB1),      o2(0xCE,0xFB),
          o2(0xD0,0xD1),      o2(0xCB,0xBF),
          o2(0xED,0xA4),      o2(0xED,0xA8),
          o2(0xDE,0xC2),      o2(0xF6,0xE2),
          o2(0xED,0xDC),      o2(0xDC,0xF5),
          o2(0xE0,0xB9),      o2(0xD4,0xCE),
          o2(0xF4,0xB5),      o2(0xD3,0xDB),
          o2(0xD6,0xB5),      o2(0xEC,0xA4),
          o2(0xE4,0xE6),      o2(0xF1,0xEA),
          o2(0xCB,0xEC),      o2(0xCB,0xC0),
          o2(0xEC,0xF2),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E4_3B = {
    to_EUC_KR_E4_3B_offsets,
    to_CP949_E4_3B_infos
};


static const struct byte_lookup* const
to_CP949_E4_3C_infos[17] = {
          o2(0xD0,0xEA),      o2(0xF9,0xF2),
          o2(0xEC,0xA5),      o2(0xD0,0xDF),
          o2(0xE7,0xEA),      o2(0xD0,0xEB),
          o2(0xDC,0xD1),      o2(0xDB,0xE9),
          o2(0xFD,0xCC),      o2(0xDB,0xD7),
          o2(0xDA,0xE1),      o2(0xD6,0xB6),
          o2(0xE3,0xDF),      o2(0xDE,0xC3),
          o2(0xDE,0xC4),      o2(0xCA,0xA1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E4_3C = {
    to_EUC_KR_E4_3C_offsets,
    to_CP949_E4_3C_infos
};


static const struct byte_lookup* const
to_CP949_E4_3D_infos[23] = {
          o2(0xEE,0xEC),      o2(0xD3,0xA3),
          o2(0xEE,0xB7),      o2(0xF8,0xCF),
          o2(0xEA,0xC8),      o2(0xEE,0xB8),
          o2(0xF1,0xAC),      o2(0xF1,0xA5),
          o2(0xE9,0xCE),      o2(0xF9,0xBC),
          o2(0xE5,0xF9),      o2(0xEC,0xEA),
          o2(0xDD,0xD6),      o2(0xED,0xC2),
          o2(0xF8,0xA5),      o2(0xE5,0xBA),
          o2(0xDB,0xD8),      o2(0xCA,0xA2),
          o2(0xD1,0xCD),      o2(0xEE,0xED),
          o2(0xEC,0xEB),      o2(0xDE,0xC5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E4_3D = {
    to_EUC_KR_E4_3D_offsets,
    to_CP949_E4_3D_infos
};


static const struct byte_lookup* const
to_CP949_E4_3E_infos[20] = {
          o2(0xE3,0xE0),      o2(0xCA,0xC9),
          o2(0xF2,0xE9),      o2(0xD5,0xCE),
          o2(0xF6,0xB6),      o2(0xCE,0xC2),
          o2(0xD6,0xC7),      o2(0xE3,0xB4),
          o2(0xF1,0xAD),      o2(0xEA,0xE2),
          o2(0xD7,0xC2),      o2(0xF3,0xA7),
          o2(0xCD,0xEA),      o2(0xEB,0xEE),
          o2(0xD9,0xB2),      o2(0xFD,0xA5),
          o2(0xF6,0xD5),      o2(0xD5,0xE2),
          o2(0xF8,0xB5),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E4_3E = {
    to_EUC_KR_E4_3E_offsets,
    to_CP949_E4_3E_infos
};


static const struct byte_lookup* const
to_CP949_E4_3F_infos[23] = {
          o2(0xCC,0xF5),      o2(0xF5,0xB5),
          o2(0xE4,0xAD),      o2(0xE7,0xEB),
          o2(0xF1,0xD5),      o2(0xF0,0xBB),
          o2(0xE9,0xB5),      o2(0xCC,0xC9),
          o2(0xFA,0xD5),      o2(0xE1,0xD4),
          o2(0xD7,0xD6),      o2(0xDC,0xC1),
          o2(0xDE,0xC6),      o2(0xFA,0xEF),
          o2(0xE3,0xE1),      o2(0xE1,0xF3),
          o2(0xDC,0xF6),      o2(0xCE,0xFC),
          o2(0xDB,0xC4),      o2(0xF8,0xF1),
          o2(0xDC,0xE4),      o2(0xE5,0xEF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E4_3F = {
    to_EUC_KR_E4_3F_offsets,
    to_CP949_E4_3F_infos
};


static const struct byte_lookup* const
to_CP949_E4_infos[9] = {
        &to_CP949_E4_38,    &to_CP949_E4_39,
        &to_CP949_E4_3A,    &to_CP949_E4_3B,
        &to_CP949_E4_3C,    &to_CP949_E4_3D,
        &to_CP949_E4_3E,    &to_CP949_E4_3F,
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E4 = {
    to_EUC_KR_E4_offsets,
    to_CP949_E4_infos
};


static const struct byte_lookup* const
to_CP949_E5_00_infos[25] = {
          o2(0xDC,0xB1),      o2(0xD5,0xD6),
          o2(0xF3,0xDA),      o2(0xCB,0xC1),
          o2(0xDB,0xC3),      o2(0xD9,0xFA),
          o2(0xD3,0xEE),      o2(0xFA,0xB8),
          o2(0xFD,0xA6),      o2(0xEB,0xEF),
          o2(0xF4,0xA6),      o2(0xCC,0xCA),
          o2(0xF3,0xA8),      o2(0xF3,0xDB),
          o2(0xDB,0xA7),      o2(0xF6,0xB7),
          o2(0xCF,0xE6),      o2(0xF0,0xF2),
          o2(0xCB,0xDA),      o2(0xE7,0xD2),
          o2(0xD7,0xC3),      o2(0xF6,0xF0),
          o2(0xE8,0xDE),      o2(0xE5,0xA6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_00 = {
    to_EUC_KR_E5_00_offsets,
    to_CP949_E5_00_infos
};


static const struct byte_lookup* const
to_CP949_E5_01_infos[14] = {
          o2(0xE5,0xE7),      o2(0xCA,0xA3),
          o2(0xCC,0xA7),      o2(0xEA,0xC9),
          o2(0xF8,0xB6),      o2(0xFA,0xA5),
          o2(0xF1,0xAE),      o2(0xEF,0xCE),
          o2(0xCB,0xED),      o2(0xF6,0xB0),
          o2(0xEF,0xCF),      o2(0xE9,0xCF),
          o2(0xF7,0xDE),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_01 = {
    to_EUC_KR_E5_01_offsets,
    to_CP949_E5_01_infos
};


static const struct byte_lookup* const
to_CP949_E5_02_infos[14] = {
          o2(0xCE,0xD3),      o2(0xDC,0xF7),
          o2(0xDB,0xA8),      o2(0xCB,0xF8),
          o2(0xDF,0xA1),      o2(0xDD,0xE1),
          o2(0xF5,0xCA),      o2(0xE9,0xB6),
          o2(0xE7,0xEC),      o2(0xEE,0xEE),
          o2(0xF3,0xF0),      o2(0xDF,0xBF),
          o2(0xCC,0xCB),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_02 = {
    to_EUC_KR_E5_02_offsets,
    to_CP949_E5_02_infos
};


static const struct byte_lookup* const
to_CP949_E5_03_infos[16] = {
          o2(0xD0,0xC1),      o2(0xF4,0xD2),
          o2(0xE0,0xBA),      o2(0xDF,0xC0),
          o2(0xCE,0xE0),      o2(0xDC,0xD2),
          o2(0xFD,0xEA),      o2(0xD6,0xF6),
          o2(0xEA,0xCA),      o2(0xE8,0xE9),
          o2(0xE3,0xAC),      o2(0xF3,0xD0),
          o2(0xCA,0xA4),      o2(0xDB,0xF8),
          o2(0xDE,0xC7),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_03 = {
    to_EUC_KR_E5_03_offsets,
    to_CP949_E5_03_infos
};


static const struct byte_lookup* const
to_CP949_E5_04_infos[14] = {
          o2(0xEB,0xF0),      o2(0xF1,0xD6),
          o2(0xE5,0xE2),      o2(0xCC,0xCC),
          o2(0xCB,0xFB),      o2(0xEA,0xE3),
          o2(0xDF,0xC1),      o2(0xD6,0xED),
          o2(0xE9,0xD0),      o2(0xEE,0xB9),
          o2(0xD5,0xE3),      o2(0xD1,0xD3),
          o2(0xE5,0xF0),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_04 = {
    to_EUC_KR_E5_04_offsets,
    to_CP949_E5_04_infos
};


static const struct byte_lookup* const
to_CP949_E5_05_infos[32] = {
          o2(0xE8,0xB4),      o2(0xEB,0xC3),
          o2(0xEA,0xAA),      o2(0xFA,0xFC),
          o2(0xF5,0xF6),      o2(0xF0,0xBC),
          o2(0xFD,0xD4),      o2(0xE0,0xBB),
          o2(0xCE,0xC3),      o2(0xD0,0xBA),
          o2(0xF7,0xBA),      o2(0xD8,0xF3),
          o2(0xF7,0xCD),      o2(0xE4,0xAE),
          o2(0xD4,0xDF),      o2(0xD0,0xE7),
          o2(0xEC,0xFD),      o2(0xD2,0xAE),
          o2(0xEE,0xEF),      o2(0xD5,0xD7),
          o2(0xEA,0xE4),      o2(0xF8,0xA2),
          o2(0xCD,0xEB),      o2(0xD7,0xBF),
          o2(0xFB,0xB1),      o2(0xCD,0xEC),
          o2(0xDC,0xB2),      o2(0xD0,0xEC),
          o2(0xCE,0xFD),      o2(0xEE,0xF0),
          o2(0xCC,0xC2),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_05 = {
    to_EUC_KR_E5_05_offsets,
    to_CP949_E5_05_infos
};


static const struct byte_lookup* const
to_CP949_E5_06_infos[15] = {
          o2(0xD0,0xED),      o2(0xE5,0xF7),
          o2(0xF3,0xFC),      o2(0xEE,0xA2),
          o2(0xD9,0xB3),      o2(0xD8,0xF4),
          o2(0xE9,0xB7),      o2(0xCE,0xAE),
          o2(0xD9,0xA2),      o2(0xD8,0xF1),
          o2(0xD4,0xCF),      o2(0xE5,0xA7),
          o2(0xD5,0xD2),      o2(0xD6,0xA9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_06 = {
    to_EUC_KR_E5_06_offsets,
    to_CP949_E5_06_infos
};


static const struct byte_lookup* const
to_CP949_E5_07_infos[18] = {
          o2(0xF4,0xA2),      o2(0xF1,0xD7),
          o2(0xD5,0xD8),      o2(0xF0,0xBD),
          o2(0xD7,0xD0),      o2(0xD4,0xD0),
          o2(0xD7,0xCF),      o2(0xEB,0xEA),
          o2(0xFD,0xEB),      o2(0xDB,0xED),
          o2(0xFC,0xC5),      o2(0xCB,0xC2),
          o2(0xFD,0xD5),      o2(0xF4,0xC8),
          o2(0xE8,0xEA),      o2(0xF5,0xF3),
          o2(0xF9,0xDE),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_07 = {
    to_EUC_KR_E5_07_offsets,
    to_CP949_E5_07_infos
};


static const struct byte_lookup* const
to_CP949_E5_08_infos[23] = {
          o2(0xD3,0xEF),      o2(0xEC,0xD3),
          o2(0xDD,0xC2),      o2(0xEF,0xB7),
          o2(0xE7,0xD4),      o2(0xCA,0xCA),
          o2(0xD9,0xFB),      o2(0xFA,0xFD),
          o2(0xD6,0xAA),      o2(0xF4,0xF8),
          o2(0xF7,0xF7),      o2(0xDC,0xAC),
          o2(0xD7,0xD7),      o2(0xDF,0xA2),
          o2(0xCE,0xBE),      o2(0xD3,0xF0),
          o2(0xF0,0xA4),      o2(0xE1,0xEC),
          o2(0xCF,0xE7),      o2(0xF3,0xCB),
          o2(0xED,0xA9),      o2(0xCA,0xBE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_08 = {
    to_EUC_KR_E5_08_offsets,
    to_CP949_E5_08_infos
};


static const struct byte_lookup* const
to_CP949_E5_09_infos[19] = {
          o2(0xF4,0xEF),      o2(0xF6,0xCE),
          o2(0xDE,0xFB),      o2(0xD0,0xBB),
          o2(0xD5,0xB7),      o2(0xEE,0xF1),
          o2(0xF4,0xA8),      o2(0xDC,0xF8),
          o2(0xCB,0xA7),      o2(0xDA,0xCE),
          o2(0xE0,0xE6),      o2(0xED,0xA5),
          o2(0xEE,0xF2),      o2(0xDC,0xF9),
          o2(0xF9,0xDC),      o2(0xF3,0xDC),
          o2(0xF8,0xF2),      o2(0xF4,0xF9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_09 = {
    to_EUC_KR_E5_09_offsets,
    to_CP949_E5_09_infos
};


static const struct byte_lookup* const
to_CP949_E5_0A_infos[17] = {
          o2(0xFC,0xF1),      o2(0xD0,0xBC),
          o2(0xDB,0xF9),      o2(0xD7,0xB1),
          o2(0xCB,0xFC),      o2(0xF0,0xA5),
          o2(0xCB,0xFD),      o2(0xD5,0xF4),
          o2(0xCD,0xED),      o2(0xCA,0xA5),
          o2(0xD6,0xAB),      o2(0xD0,0xC2),
          o2(0xF0,0xBE),      o2(0xD2,0xBD),
          o2(0xCC,0xA4),      o2(0xFA,0xB6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_0A = {
    to_EUC_KR_E5_0A_offsets,
    to_CP949_E5_0A_infos
};


static const struct byte_lookup* const
to_CP949_E5_0B_infos[26] = {
          o2(0xCC,0xCD),      o2(0xDA,0xFA),
          o2(0xF6,0xCF),      o2(0xE9,0xB8),
          o2(0xD8,0xF5),      o2(0xCC,0xCE),
          o2(0xD7,0xCD),      o2(0xD4,0xD1),
          o2(0xE9,0xED),      o2(0xCA,0xEB),
          o2(0xD9,0xE2),      o2(0xFD,0xB2),
          o2(0xE3,0xAD),      o2(0xD6,0xCC),
          o2(0xD9,0xB4),      o2(0xE1,0xA7),
          o2(0xEE,0xD3),      o2(0xD0,0xC3),
          o2(0xFD,0xB3),      o2(0xD5,0xE4),
          o2(0xCF,0xE8),      o2(0xED,0xC3),
          o2(0xD0,0xB2),      o2(0xCE,0xFE),
          o2(0xDA,0xA8),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_0B = {
    to_EUC_KR_E5_0B_offsets,
    to_CP949_E5_0B_infos
};


static const struct byte_lookup* const
to_CP949_E5_0C_infos[17] = {
          o2(0xF8,0xD0),      o2(0xFD,0xD6),
          o2(0xF8,0xD1),      o2(0xF8,0xD2),
          o2(0xDC,0xD3),      o2(0xDD,0xE2),
          o2(0xFB,0xF9),      o2(0xDD,0xC1),
          o2(0xE3,0xB5),      o2(0xED,0xDD),
          o2(0xCE,0xC4),      o2(0xCB,0xA1),
          o2(0xDD,0xE3),      o2(0xFC,0xDD),
          o2(0xF9,0xAF),      o2(0xD2,0xFB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_0C = {
    to_EUC_KR_E5_0C_offsets,
    to_CP949_E5_0C_infos
};


static const struct byte_lookup* const
to_CP949_E5_0D_infos[29] = {
          o2(0xCF,0xA1),      o2(0xE4,0xA8),
          o2(0xF4,0xB6),      o2(0xEC,0xFE),
          o2(0xE3,0xAE),      o2(0xE7,0xED),
          o2(0xFD,0xC1),      o2(0xDA,0xE2),
          o2(0xD8,0xB3),      o2(0xDD,0xE4),
          o2(0xF0,0xEF),      o2(0xF6,0xF1),
          o2(0xFA,0xF0),      o2(0xD1,0xF5),
          o2(0xDA,0xCF),      o2(0xDC,0xD4),
          o2(0xDC,0xA6),      o2(0xEF,0xBF),
          o2(0xCE,0xCF),      o2(0xE0,0xD9),
          o2(0xD9,0xD6),      o2(0xEC,0xD4),
          o2(0xEA,0xCB),      o2(0xCA,0xBF),
          o2(0xD5,0xB0),      o2(0xCF,0xE9),
          o2(0xF1,0xED),      o2(0xCC,0xCF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_0D = {
    to_EUC_KR_E5_0D_offsets,
    to_CP949_E5_0D_infos
};


static const struct byte_lookup* const
to_CP949_E5_0E_infos[11] = {
          o2(0xE4,0xF8),      o2(0xE4,0xED),
          o2(0xD7,0xD8),      o2(0xFD,0xA7),
          o2(0xEA,0xAB),      o2(0xF6,0xB2),
          o2(0xCF,0xF0),      o2(0xF9,0xBD),
          o2(0xE6,0xF4),      o2(0xCB,0xDB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_0E = {
    to_EUC_KR_E5_0E_offsets,
    to_CP949_E5_0E_infos
};


static const struct byte_lookup* const
to_CP949_E5_0F_infos[27] = {
          o2(0xF3,0xD1),      o2(0xE9,0xD1),
          o2(0xF3,0xA9),      o2(0xD0,0xE0),
          o2(0xE9,0xD2),      o2(0xDA,0xE3),
          o2(0xE2,0xD2),      o2(0xF6,0xA2),
          o2(0xE1,0xF4),      o2(0xDA,0xE4),
          o2(0xE7,0xD5),      o2(0xF5,0xBF),
          o2(0xCF,0xA2),      o2(0xCD,0xAF),
          o2(0xCF,0xA3),      o2(0xCD,0xB0),
          o2(0xF1,0xFE),      o2(0xD0,0xA3),
          o2(0xE1,0xAF),      o2(0xF8,0xA3),
          o2(0xCA,0xA6),      o2(0xF7,0xBB),
          o2(0xF2,0xEA),      o2(0xDE,0xC8),
          o2(0xE9,0xD3),      o2(0xDE,0xC9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_0F = {
    to_EUC_KR_E5_0F_offsets,
    to_CP949_E5_0F_infos
};


static const struct byte_lookup* const
to_CP949_E5_10_infos[25] = {
          o2(0xFD,0xDE),      o2(0xCA,0xC0),
          o2(0xF9,0xEA),      o2(0xD1,0xCE),
          o2(0xEE,0xD4),      o2(0xD4,0xD2),
          o2(0xD9,0xA3),      o2(0xFD,0xA8),
          o2(0xD7,0xD9),      o2(0xF7,0xCE),
          o2(0xFA,0xBE),      o2(0xCF,0xD6),
          o2(0xD7,0xF0),      o2(0xEB,0xE1),
          o2(0xF8,0xC5),      o2(0xDC,0xFA),
          o2(0xDD,0xC3),      o2(0xF9,0xDF),
          o2(0xE7,0xEF),      o2(0xFD,0xE5),
          o2(0xF6,0xA3),      o2(0xD9,0xFC),
          o2(0xFD,0xA9),      o2(0xE7,0xEE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_10 = {
    to_EUC_KR_E5_10_offsets,
    to_CP949_E5_10_infos
};


static const struct byte_lookup* const
to_CP949_E5_11_infos[13] = {
          o2(0xD5,0xE5),      o2(0xEF,0xD0),
          o2(0xCD,0xB1),      o2(0xF7,0xA2),
          o2(0xF1,0xB2),      o2(0xF1,0xB1),
          o2(0xCD,0xB2),      o2(0xDA,0xAB),
          o2(0xCA,0xA7),      o2(0xE3,0xE2),
          o2(0xFB,0xBC),      o2(0xD9,0xA4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_11 = {
    to_EUC_KR_E5_11_offsets,
    to_CP949_E5_11_infos
};


static const struct byte_lookup* const
to_CP949_E5_12_infos[13] = {
          o2(0xEE,0xBA),      o2(0xF8,0xD3),
          o2(0xFB,0xFA),      o2(0xCF,0xA4),
          o2(0xDC,0xFB),      o2(0xF6,0xE3),
          o2(0xED,0xAA),      o2(0xF2,0xA1),
          o2(0xCE,0xE1),      o2(0xFA,0xA6),
          o2(0xF9,0xE0),      o2(0xEC,0xD6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_12 = {
    to_EUC_KR_E5_12_offsets,
    to_CP949_E5_12_infos
};


static const struct byte_lookup* const
to_CP949_E5_13_infos[13] = {
          o2(0xE4,0xEE),      o2(0xF9,0xA1),
          o2(0xFB,0xEF),      o2(0xF9,0xEB),
          o2(0xEE,0xA3),      o2(0xEA,0xAC),
          o2(0xCA,0xA8),      o2(0xF4,0xFA),
          o2(0xCD,0xD6),      o2(0xFC,0xF6),
          o2(0xF4,0xC9),      o2(0xF8,0xD4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_13 = {
    to_EUC_KR_E5_13_offsets,
    to_CP949_E5_13_infos
};


static const struct byte_lookup* const
to_CP949_E5_14_infos[11] = {
          o2(0xF8,0xA6),      o2(0xDE,0xCA),
          o2(0xF2,0xC6),      o2(0xD7,0xDA),
          o2(0xD3,0xD0),      o2(0xD8,0xC5),
          o2(0xEA,0xE6),      o2(0xF3,0xDD),
          o2(0xE4,0xDA),      o2(0xF6,0xE4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_14 = {
    to_EUC_KR_E5_14_offsets,
    to_CP949_E5_14_infos
};


static const struct byte_lookup* const
to_CP949_E5_15_infos[9] = {
          o2(0xF6,0xF2),      o2(0xDF,0xC2),
          o2(0xD9,0xFD),      o2(0xCC,0xF6),
          o2(0xD3,0xBA),      o2(0xE4,0xAF),
          o2(0xF9,0xE1),      o2(0xF0,0xA6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_15 = {
    to_EUC_KR_E5_15_offsets,
    to_CP949_E5_15_infos
};


static const struct byte_lookup* const
to_CP949_E5_16_infos[18] = {
          o2(0xCB,0xD3),      o2(0xE0,0xBC),
          o2(0xF4,0xCA),      o2(0xD4,0xFA),
          o2(0xFD,0xAA),      o2(0xF9,0xE2),
          o2(0xF4,0xB7),      o2(0xFD,0xC2),
          o2(0xFC,0xB0),      o2(0xFD,0xEC),
          o2(0xCA,0xE2),      o2(0xFD,0xBD),
          o2(0xEA,0xE7),      o2(0xDF,0xC3),
          o2(0xD1,0xD2),      o2(0xCE,0xE2),
          o2(0xD3,0xA4),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_16 = {
    to_EUC_KR_E5_16_offsets,
    to_CP949_E5_16_infos
};


static const struct byte_lookup* const
to_CP949_E5_17_infos[11] = {
          o2(0xFD,0xAB),      o2(0xDF,0xE0),
          o2(0xF2,0xC7),      o2(0xE7,0xF0),
          o2(0xD0,0xEE),      o2(0xF3,0xAA),
          o2(0xDE,0xCB),      o2(0xF6,0xB8),
          o2(0xE1,0xF5),      o2(0xF1,0xB3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_17 = {
    to_EUC_KR_E5_17_offsets,
    to_CP949_E5_17_infos
};


static const struct byte_lookup* const
to_CP949_E5_18_infos[9] = {
          o2(0xF7,0xA3),      o2(0xCA,0xA9),
          o2(0xCF,0xA5),      o2(0xDF,0xC4),
          o2(0xE1,0xB0),      o2(0xF0,0xBF),
          o2(0xF6,0xA4),      o2(0xE3,0xB6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_18 = {
    to_EUC_KR_E5_18_offsets,
    to_CP949_E5_18_infos
};


static const struct byte_lookup* const
to_CP949_E5_19_infos[5] = {
          o2(0xFA,0xC6),      o2(0xD0,0xEF),
          o2(0xFD,0xED),      o2(0xDD,0xC4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_19 = {
    to_EUC_KR_E5_19_offsets,
    to_CP949_E5_19_infos
};


static const struct byte_lookup* const
to_CP949_E5_1A_infos[7] = {
          o2(0xFC,0xF7),      o2(0xE6,0xBF),
          o2(0xDE,0xAD),      o2(0xFA,0xBF),
          o2(0xE5,0xF1),      o2(0xED,0xC4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_1A = {
    to_EUC_KR_E5_1A_offsets,
    to_CP949_E5_1A_infos
};


static const struct byte_lookup* const
to_CP949_E5_1B_infos[11] = {
          o2(0xD2,0xA5),      o2(0xFD,0xEE),
          o2(0xF5,0xB6),      o2(0xE1,0xF6),
          o2(0xDE,0xCC),      o2(0xFC,0xDE),
          o2(0xEC,0xD7),      o2(0xCD,0xDD),
          o2(0xD6,0xB7),      o2(0xCD,0xB3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_1B = {
    to_EUC_KR_E5_1B_offsets,
    to_CP949_E5_1B_infos
};


static const struct byte_lookup* const
to_CP949_E5_1C_infos[15] = {
          o2(0xF8,0xD5),      o2(0xE5,0xD8),
          o2(0xCF,0xEA),      o2(0xCF,0xD0),
          o2(0xEA,0xCC),      o2(0xEA,0xAE),
          o2(0xEA,0xAD),      o2(0xD3,0xF1),
          o2(0xD3,0xA5),      o2(0xF7,0xCF),
          o2(0xEE,0xA4),      o2(0xD0,0xA4),
          o2(0xF2,0xA2),      o2(0xD0,0xF0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_1C = {
    to_EUC_KR_E5_1C_offsets,
    to_CP949_E5_1C_infos
};


static const struct byte_lookup* const
to_CP949_E5_1D_infos[17] = {
          o2(0xF2,0xA3),      o2(0xF7,0xF8),
          o2(0xD0,0xB3),      o2(0xDB,0xA9),
          o2(0xD3,0xBB),      o2(0xCA,0xEC),
          o2(0xF1,0xA6),      o2(0xCB,0xD5),
          o2(0xF7,0xE7),      o2(0xCD,0xDE),
          o2(0xF7,0xA4),      o2(0xF8,0xC0),
          o2(0xD3,0xDD),      o2(0xCC,0xD0),
          o2(0xCF,0xA6),      o2(0xF6,0xF3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_1D = {
    to_EUC_KR_E5_1D_offsets,
    to_CP949_E5_1D_infos
};


static const struct byte_lookup* const
to_CP949_E5_1E_infos[8] = {
          o2(0xE1,0xF7),      o2(0xD3,0xDC),
          o2(0xFA,0xFE),      o2(0xFA,0xA7),
          o2(0xEB,0xD9),      o2(0xCF,0xA7),
          o2(0xEA,0xAF),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_1E = {
    to_EUC_KR_E5_1E_offsets,
    to_CP949_E5_1E_infos
};


static const struct byte_lookup* const
to_CP949_E5_1F_infos[14] = {
          o2(0xE4,0xEF),      o2(0xE9,0xB9),
          o2(0xF1,0xD8),      o2(0xD8,0xD8),
          o2(0xE0,0xF2),      o2(0xE6,0xB4),
          o2(0xDC,0xFC),      o2(0xF3,0xF1),
          o2(0xE3,0xD0),      o2(0xF2,0xFB),
          o2(0xDB,0xC6),      o2(0xD0,0xF1),
          o2(0xD0,0xF2),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_1F = {
    to_EUC_KR_E5_1F_offsets,
    to_CP949_E5_1F_infos
};


static const struct byte_lookup* const
to_CP949_E5_20_infos[19] = {
          o2(0xCF,0xDC),      o2(0xD3,0xD1),
          o2(0xCC,0xB1),      o2(0xF7,0xD8),
          o2(0xCB,0xA8),      o2(0xEB,0xBC),
          o2(0xE4,0xBE),      o2(0xF4,0xDC),
          o2(0xDC,0xC2),      o2(0xF0,0xA7),
          o2(0xE6,0xC0),      o2(0xCA,0xED),
          o2(0xE8,0xEB),      o2(0xE5,0xE8),
          o2(0xDC,0xC3),      o2(0xED,0xDE),
          o2(0xD3,0xF2),      o2(0xCC,0xF7),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_20 = {
    to_EUC_KR_E5_20_offsets,
    to_CP949_E5_20_infos
};


static const struct byte_lookup* const
to_CP949_E5_21_infos[17] = {
          o2(0xCE,0xD4),      o2(0xE7,0xAB),
          o2(0xCB,0xC3),      o2(0xE1,0xB1),
          o2(0xF7,0xB2),      o2(0xD3,0xF3),
          o2(0xD3,0xD2),      o2(0xF5,0xC0),
          o2(0xDF,0xDD),      o2(0xEE,0xF3),
          o2(0xE7,0xF1),      o2(0xFD,0xB4),
          o2(0xF2,0xC8),      o2(0xF3,0xD2),
          o2(0xEE,0xF4),      o2(0xE2,0xD3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_21 = {
    to_EUC_KR_E5_21_offsets,
    to_CP949_E5_21_infos
};


static const struct byte_lookup* const
to_CP949_E5_22_infos[15] = {
          o2(0xCC,0xD1),      o2(0xDF,0xEA),
          o2(0xE9,0xBA),      o2(0xD9,0xD7),
          o2(0xF5,0xCD),      o2(0xF1,0xF2),
          o2(0xFA,0xC7),      o2(0xD9,0xF8),
          o2(0xD4,0xC2),      o2(0xF6,0xE5),
          o2(0xDD,0xC5),      o2(0xE7,0xF2),
          o2(0xED,0xDF),      o2(0xCA,0xCB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_22 = {
    to_EUC_KR_E5_22_offsets,
    to_CP949_E5_22_infos
};


static const struct byte_lookup* const
to_CP949_E5_23_infos[20] = {
          o2(0xDB,0xFA),      o2(0xE8,0xB5),
          o2(0xD3,0xA6),      o2(0xFD,0xB5),
          o2(0xF9,0xC9),      o2(0xE4,0xE2),
          o2(0xFB,0xBD),      o2(0xD7,0xA4),
          o2(0xCE,0xC5),      o2(0xCE,0xD5),
          o2(0xD6,0xE6),      o2(0xE5,0xBD),
          o2(0xDE,0xCD),      o2(0xEC,0xF3),
          o2(0xED,0xE0),      o2(0xEC,0xEC),
          o2(0xFB,0xBE),      o2(0xDF,0xEB),
          o2(0xE1,0xF8),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_23 = {
    to_EUC_KR_E5_23_offsets,
    to_CP949_E5_23_infos
};


static const struct byte_lookup* const
to_CP949_E5_24_infos[18] = {
          o2(0xF9,0xBE),      o2(0xD0,0xF3),
          o2(0xE0,0xAA),      o2(0xE8,0xE2),
          o2(0xE2,0xD4),      o2(0xD2,0xFD),
          o2(0xE5,0xA8),      o2(0xD9,0xD3),
          o2(0xD3,0xDE),      o2(0xF4,0xB8),
          o2(0xF7,0xBC),      o2(0xDC,0xFD),
          o2(0xE8,0xEC),      o2(0xE4,0xE7),
          o2(0xE3,0xF7),      o2(0xEC,0xA8),
          o2(0xFA,0xF1),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_24 = {
    to_EUC_KR_E5_24_offsets,
    to_CP949_E5_24_infos
};


static const struct byte_lookup* const
to_CP949_E5_25_infos[25] = {
          o2(0xE5,0xF2),      o2(0xD0,0xF4),
          o2(0xD2,0xAF),      o2(0xDC,0xE5),
          o2(0xD0,0xA5),      o2(0xF1,0xB4),
          o2(0xFC,0xB1),      o2(0xCC,0xF8),
          o2(0xDD,0xC6),      o2(0xFA,0xD1),
          o2(0xF7,0xDF),      o2(0xFA,0xA8),
          o2(0xEE,0xF5),      o2(0xDE,0xCE),
          o2(0xE7,0xF3),      o2(0xF7,0xAC),
          o2(0xEB,0xC4),      o2(0xED,0xE1),
          o2(0xE0,0xAB),      o2(0xDD,0xC7),
          o2(0xD2,0xB3),      o2(0xD2,0xBF),
          o2(0xCA,0xCC),      o2(0xFB,0xBF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_25 = {
    to_EUC_KR_E5_25_offsets,
    to_CP949_E5_25_infos
};


static const struct byte_lookup* const
to_CP949_E5_26_infos[15] = {
          o2(0xE5,0xFD),      o2(0xDD,0xE5),
          o2(0xD8,0xCD),      o2(0xEC,0xF4),
          o2(0xD0,0xF5),      o2(0xE8,0xED),
          o2(0xD0,0xD2),      o2(0xD9,0xD8),
          o2(0xF6,0xE6),      o2(0xDB,0xAA),
          o2(0xF7,0xE0),      o2(0xD8,0xD9),
          o2(0xF4,0xA3),      o2(0xF4,0xDD),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_26 = {
    to_EUC_KR_E5_26_offsets,
    to_CP949_E5_26_infos
};


static const struct byte_lookup* const
to_CP949_E5_27_infos[21] = {
          o2(0xEF,0xD1),      o2(0xD9,0xB5),
          o2(0xED,0xAB),      o2(0xE3,0xB7),
          o2(0xEE,0xBB),      o2(0xCD,0xB4),
          o2(0xE0,0xF3),      o2(0xEA,0xCD),
          o2(0xEC,0xF5),      o2(0xE8,0xEE),
          o2(0xCB,0xA9),      o2(0xF1,0xAF),
          o2(0xCA,0xCD),      o2(0xEC,0xA9),
          o2(0xF2,0xEB),      o2(0xFD,0xEF),
          o2(0xF9,0xF3),      o2(0xE6,0xC1),
          o2(0xEC,0xD8),      o2(0xED,0xAC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_27 = {
    to_EUC_KR_E5_27_offsets,
    to_CP949_E5_27_infos
};


static const struct byte_lookup* const
to_CP949_E5_28_infos[13] = {
          o2(0xEA,0xCE),      o2(0xE8,0xDF),
          o2(0xDE,0xCF),      o2(0xD2,0xA6),
          o2(0xE7,0xF4),      o2(0xD1,0xD6),
          o2(0xE6,0xC2),      o2(0xE3,0xE3),
          o2(0xE4,0xB0),      o2(0xD8,0xB4),
          o2(0xF6,0xA5),      o2(0xF3,0xDE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_28 = {
    to_EUC_KR_E5_28_offsets,
    to_CP949_E5_28_infos
};


static const struct byte_lookup* const
to_CP949_E5_29_infos[7] = {
          o2(0xD7,0xA5),      o2(0xF7,0xE8),
          o2(0xE8,0xC6),      o2(0xFB,0xE6),
          o2(0xDD,0xE6),      o2(0xDC,0xFE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_29 = {
    to_EUC_KR_E5_29_offsets,
    to_CP949_E5_29_infos
};


static const struct byte_lookup* const
to_CP949_E5_2A_infos[5] = {
          o2(0xD8,0xDA),      o2(0xDA,0xAC),
          o2(0xEA,0xB0),      o2(0xE3,0xB8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_2A = {
    to_EUC_KR_E5_2A_offsets,
    to_CP949_E5_2A_infos
};


static const struct byte_lookup* const
to_CP949_E5_2B_infos[9] = {
          o2(0xCA,0xAA),      o2(0xE1,0xF9),
          o2(0xEA,0xB1),      o2(0xF2,0xEC),
          o2(0xFA,0xEE),      o2(0xEE,0xD5),
          o2(0xF9,0xF4),      o2(0xD2,0xEC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_2B = {
    to_EUC_KR_E5_2B_offsets,
    to_CP949_E5_2B_infos
};


static const struct byte_lookup* const
to_CP949_E5_2C_infos[7] = {
          o2(0xFB,0xFB),      o2(0xFD,0xF0),
          o2(0xE0,0xBD),      o2(0xCE,0xE3),
          o2(0xF8,0xC6),      o2(0xDE,0xAE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_2C = {
    to_EUC_KR_E5_2C_offsets,
    to_CP949_E5_2C_infos
};


static const struct byte_lookup* const
to_CP949_E5_2D_infos[23] = {
          o2(0xDF,0xC5),      o2(0xE5,0xBE),
          o2(0xED,0xAD),      o2(0xFA,0xEA),
          o2(0xCD,0xEE),      o2(0xED,0xA6),
          o2(0xED,0xAE),      o2(0xF0,0xED),
          o2(0xDD,0xA1),      o2(0xED,0xAF),
          o2(0xFC,0xF8),      o2(0xD8,0xEB),
          o2(0xCC,0xF9),      o2(0xCD,0xB5),
          o2(0xFA,0xA9),      o2(0xE1,0xDD),
          o2(0xE2,0xD5),      o2(0xED,0xCF),
          o2(0xDD,0xA2),      o2(0xF9,0xCA),
          o2(0xEA,0xE8),      o2(0xE5,0xED),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_2D = {
    to_EUC_KR_E5_2D_offsets,
    to_CP949_E5_2D_infos
};


static const struct byte_lookup* const
to_CP949_E5_2E_infos[32] = {
          o2(0xD3,0xEB),      o2(0xE9,0xD4),
          o2(0xE1,0xFA),      o2(0xE4,0xCC),
          o2(0xE1,0xE4),      o2(0xE8,0xC7),
          o2(0xCE,0xDB),      o2(0xDC,0xD5),
          o2(0xF7,0xB5),      o2(0xFC,0xF3),
          o2(0xF0,0xF3),      o2(0xCE,0xAF),
          o2(0xF1,0xB5),      o2(0xEF,0xD2),
          o2(0xE8,0xC8),      o2(0xEB,0xF1),
          o2(0xCB,0xD4),      o2(0xE0,0xBE),
          o2(0xE3,0xF8),      o2(0xEA,0xE9),
          o2(0xFC,0xB2),      o2(0xE0,0xF4),
          o2(0xCF,0xE0),      o2(0xEE,0xA5),
          o2(0xFA,0xAA),      o2(0xE6,0xC3),
          o2(0xE1,0xB2),      o2(0xCA,0xAB),
          o2(0xE3,0xE4),      o2(0xE9,0xBB),
          o2(0xE2,0xD6),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_2E = {
    to_EUC_KR_E5_2E_offsets,
    to_CP949_E5_2E_infos
};


static const struct byte_lookup* const
to_CP949_E5_2F_infos[32] = {
          o2(0xF3,0xF2),      o2(0xEE,0xD6),
          o2(0xEA,0xB2),      o2(0xD0,0xF6),
          o2(0xEC,0xD9),      o2(0xDA,0xCB),
          o2(0xCF,0xA8),      o2(0xDD,0xA3),
          o2(0xD8,0xDB),      o2(0xF9,0xCE),
          o2(0xE9,0xD5),      o2(0xE3,0xD1),
          o2(0xD2,0xBC),      o2(0xD8,0xAC),
          o2(0xF3,0xCC),      o2(0xCD,0xFB),
          o2(0xF6,0xD6),      o2(0xE7,0xF5),
          o2(0xE8,0xEF),      o2(0xE3,0xF9),
          o2(0xD2,0xBB),      o2(0xF3,0xF3),
          o2(0xE3,0xFB),      o2(0xDE,0xD0),
          o2(0xCE,0xB0),      o2(0xD6,0xF7),
          o2(0xF1,0xD9),      o2(0xF5,0xC1),
          o2(0xDC,0xC4),      o2(0xF5,0xBB),
          o2(0xDE,0xD1),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_2F = {
    to_EUC_KR_E5_2F_offsets,
    to_CP949_E5_2F_infos
};


static const struct byte_lookup* const
to_CP949_E5_30_infos[24] = {
          o2(0xDC,0xE6),      o2(0xDE,0xD2),
          o2(0xED,0xE2),      o2(0xEE,0xF6),
          o2(0xEA,0xCF),      o2(0xF0,0xEE),
          o2(0xE3,0xFC),      o2(0xD3,0xDF),
          o2(0xD3,0xF4),      o2(0xE1,0xB3),
          o2(0xE1,0xB4),      o2(0xF4,0xD3),
          o2(0xDF,0xC6),      o2(0xE9,0xD6),
          o2(0xDB,0xAB),      o2(0xF6,0xA6),
          o2(0xE3,0xB9),      o2(0xEB,0xC5),
          o2(0xF4,0xA9),      o2(0xCD,0xB6),
          o2(0xD2,0xF9),      o2(0xDA,0xAD),
          o2(0xD2,0xE3),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_30 = {
    to_EUC_KR_E5_30_offsets,
    to_CP949_E5_30_infos
};


static const struct byte_lookup* const
to_CP949_E5_31_infos[19] = {
          o2(0xCF,0xD1),      o2(0xCB,0xDC),
          o2(0xCC,0xFA),      o2(0xCF,0xDD),
          o2(0xE8,0xA9),      o2(0xE3,0xBB),
          o2(0xE3,0xBA),      o2(0xE0,0xDA),
          o2(0xEE,0xF7),      o2(0xDC,0xB3),
          o2(0xD3,0xF5),      o2(0xD7,0xA6),
          o2(0xF6,0xB5),      o2(0xD7,0xDB),
          o2(0xE1,0xD5),      o2(0xD4,0xEA),
          o2(0xDF,0xA3),      o2(0xFD,0xDF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_31 = {
    to_EUC_KR_E5_31_offsets,
    to_CP949_E5_31_infos
};


static const struct byte_lookup* const
to_CP949_E5_32_infos[14] = {
          o2(0xD0,0xF7),      o2(0xED,0xD4),
          o2(0xCB,0xAA),      o2(0xE4,0xDB),
          o2(0xE1,0xFB),      o2(0xCB,0xA2),
          o2(0xD3,0xE0),      o2(0xE4,0xBF),
          o2(0xFB,0xC0),      o2(0xDA,0xBE),
          o2(0xE4,0xCD),      o2(0xD6,0xB9),
          o2(0xEF,0xC0),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_32 = {
    to_EUC_KR_E5_32_offsets,
    to_CP949_E5_32_infos
};


static const struct byte_lookup* const
to_CP949_E5_33_infos[11] = {
          o2(0xE1,0xFC),      o2(0xF6,0xB9),
          o2(0xDF,0xC7),      o2(0xE4,0xB1),
          o2(0xDC,0xE7),      o2(0xDC,0xE8),
          o2(0xFA,0xD6),      o2(0xD3,0xF6),
          o2(0xF1,0xDA),      o2(0xFA,0xF2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_33 = {
    to_EUC_KR_E5_33_offsets,
    to_CP949_E5_33_infos
};


static const struct byte_lookup* const
to_CP949_E5_34_infos[11] = {
          o2(0xE2,0xFD),      o2(0xD5,0xCF),
          o2(0xD0,0xF8),      o2(0xCD,0xDF),
          o2(0xF5,0xCB),      o2(0xE4,0xF0),
          o2(0xCB,0xAB),      o2(0xD7,0xC4),
          o2(0xE2,0xFE),      o2(0xDD,0xDA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_34 = {
    to_EUC_KR_E5_34_offsets,
    to_CP949_E5_34_infos
};


static const struct byte_lookup* const
to_CP949_E5_35_infos[7] = {
          o2(0xDA,0xAE),      o2(0xCA,0xEE),
          o2(0xD5,0xB9),      o2(0xE3,0xA1),
          o2(0xE8,0xE3),      o2(0xF3,0xAB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_35 = {
    to_EUC_KR_E5_35_offsets,
    to_CP949_E5_35_infos
};


static const struct byte_lookup* const
to_CP949_E5_36_infos[11] = {
          o2(0xCF,0xA9),      o2(0xD3,0xF7),
          o2(0xD4,0xF1),      o2(0xCE,0xE4),
          o2(0xE8,0xF2),      o2(0xE5,0xF5),
          o2(0xE7,0xAE),      o2(0xD6,0xBA),
          o2(0xDF,0xEC),      o2(0xE4,0xC0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_36 = {
    to_EUC_KR_E5_36_offsets,
    to_CP949_E5_36_infos
};


static const struct byte_lookup* const
to_CP949_E5_37_infos[21] = {
          o2(0xE8,0xE4),      o2(0xD8,0xB5),
          o2(0xE4,0xDC),      o2(0xF4,0xB9),
          o2(0xF1,0xB6),      o2(0xE2,0xDE),
          o2(0xE1,0xB5),      o2(0xCD,0xEF),
          o2(0xF1,0xA7),      o2(0xCE,0xE5),
          o2(0xCB,0xDD),      o2(0xD9,0xE3),
          o2(0xF3,0xAC),      o2(0xD0,0xF9),
          o2(0xEC,0xAB),      o2(0xDE,0xD3),
          o2(0xF7,0xE9),      o2(0xF9,0xF5),
          o2(0xE1,0xDE),      o2(0xCB,0xEE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_37 = {
    to_EUC_KR_E5_37_offsets,
    to_CP949_E5_37_infos
};


static const struct byte_lookup* const
to_CP949_E5_38_infos[18] = {
          o2(0xE3,0xBC),      o2(0xF8,0xD6),
          o2(0xDB,0xEE),      o2(0xFD,0xF1),
          o2(0xF7,0xB6),      o2(0xF4,0xDE),
          o2(0xF2,0xED),      o2(0xDB,0xD9),
          o2(0xF0,0xA8),      o2(0xE1,0xFD),
          o2(0xDE,0xD4),      o2(0xE0,0xAC),
          o2(0xED,0xE3),      o2(0xD3,0xE1),
          o2(0xDF,0xC8),      o2(0xD9,0xB6),
          o2(0xFD,0xAC),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_38 = {
    to_EUC_KR_E5_38_offsets,
    to_CP949_E5_38_infos
};


static const struct byte_lookup* const
to_CP949_E5_39_infos[21] = {
          o2(0xEF,0xD3),      o2(0xE4,0xC1),
          o2(0xF8,0xEB),      o2(0xDB,0xAC),
          o2(0xFC,0xC6),      o2(0xD8,0xAD),
          o2(0xF6,0xBA),      o2(0xDB,0xDF),
          o2(0xD3,0xD3),      o2(0xF8,0xC7),
          o2(0xCA,0xCE),      o2(0xF8,0xC1),
          o2(0xD2,0xB4),      o2(0xDC,0xB4),
          o2(0xFA,0xB9),      o2(0xCA,0xCF),
          o2(0xFC,0xB3),      o2(0xEA,0xEA),
          o2(0xEA,0xEB),      o2(0xD0,0xFA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_39 = {
    to_EUC_KR_E5_39_offsets,
    to_CP949_E5_39_infos
};


static const struct byte_lookup* const
to_CP949_E5_3A_infos[19] = {
          o2(0xED,0xE4),      o2(0xDD,0xE7),
          o2(0xDF,0xC9),      o2(0xDF,0xED),
          o2(0xEE,0xBC),      o2(0xEF,0xC1),
          o2(0xCC,0xD2),      o2(0xDD,0xA4),
          o2(0xDF,0xCA),      o2(0xD3,0xF8),
          o2(0xF1,0xA8),      o2(0xCD,0xB7),
          o2(0xEF,0xD4),      o2(0xE4,0xDD),
          o2(0xDF,0xEE),      o2(0xCB,0xAC),
          o2(0xE9,0xBC),      o2(0xEA,0xEC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_3A = {
    to_EUC_KR_E5_3A_offsets,
    to_CP949_E5_3A_infos
};


static const struct byte_lookup* const
to_CP949_E5_3B_infos[20] = {
          o2(0xDF,0xCB),      o2(0xF9,0xBF),
          o2(0xD6,0xAF),      o2(0xD5,0xC6),
          o2(0xCF,0xAA),      o2(0xCE,0xA9),
          o2(0xD6,0xF8),      o2(0xF1,0xB7),
          o2(0xEE,0xF8),      o2(0xD9,0xD9),
          o2(0xF3,0xDF),      o2(0xF8,0xC8),
          o2(0xCE,0xC6),      o2(0xD5,0xE6),
          o2(0xF4,0xE6),      o2(0xE6,0xC5),
          o2(0xEF,0xD5),      o2(0xCB,0xEF),
          o2(0xFC,0xDF),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_3B = {
    to_EUC_KR_E5_3B_offsets,
    to_CP949_E5_3B_infos
};


static const struct byte_lookup* const
to_CP949_E5_3C_infos[20] = {
          o2(0xDC,0xA7),      o2(0xD6,0xE7),
          o2(0xF8,0xC9),      o2(0xE3,0xD2),
          o2(0xE3,0xBD),      o2(0xCF,0xE1),
          o2(0xF0,0xC0),      o2(0xEC,0xDA),
          o2(0xDD,0xD7),      o2(0xFB,0xF0),
          o2(0xEC,0xAC),      o2(0xF0,0xA9),
          o2(0xFA,0xD7),      o2(0xFB,0xC1),
          o2(0xD2,0xC0),      o2(0xE5,0xB0),
          o2(0xED,0xE5),      o2(0xCB,0xAD),
          o2(0xF9,0xB0),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_3C = {
    to_EUC_KR_E5_3C_offsets,
    to_CP949_E5_3C_infos
};


static const struct byte_lookup* const
to_CP949_E5_3D_infos[23] = {
          o2(0xF7,0xA5),      o2(0xCB,0xAE),
          o2(0xDA,0xAF),      o2(0xD8,0xB6),
          o2(0xD3,0xA7),      o2(0xFB,0xB2),
          o2(0xFD,0xC4),      o2(0xEC,0xAD),
          o2(0xFB,0xA1),      o2(0xE5,0xE9),
          o2(0xE9,0xEE),      o2(0xF3,0xF4),
          o2(0xF8,0xF3),      o2(0xF0,0xC1),
          o2(0xDE,0xAF),      o2(0xF8,0xB0),
          o2(0xF3,0xE0),      o2(0xE7,0xAF),
          o2(0xDB,0xAD),      o2(0xE6,0xB5),
          o2(0xF9,0xA8),      o2(0xDD,0xD8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_3D = {
    to_EUC_KR_E5_3D_offsets,
    to_CP949_E5_3D_infos
};


static const struct byte_lookup* const
to_CP949_E5_3E_infos[25] = {
          o2(0xE8,0xD9),      o2(0xEF,0xD6),
          o2(0xD3,0xE2),      o2(0xE2,0xDF),
          o2(0xFC,0xE0),      o2(0xD7,0xC8),
          o2(0xFD,0xAD),      o2(0xDF,0xEF),
          o2(0xCC,0xD3),      o2(0xD3,0xF9),
          o2(0xD4,0xF0),      o2(0xDB,0xC7),
          o2(0xDE,0xD5),      o2(0xF0,0xF4),
          o2(0xD5,0xD0),      o2(0xE5,0xD9),
          o2(0xFC,0xC7),      o2(0xDC,0xD6),
          o2(0xE2,0xE0),      o2(0xDA,0xB0),
          o2(0xF3,0xA3),      o2(0xD3,0xEC),
          o2(0xF4,0xCB),      o2(0xFD,0xC5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_3E = {
    to_EUC_KR_E5_3E_offsets,
    to_CP949_E5_3E_infos
};


static const struct byte_lookup* const
to_CP949_E5_3F_infos[14] = {
          o2(0xE3,0xFD),      o2(0xF9,0xB1),
          o2(0xD0,0xFB),      o2(0xEC,0xDB),
          o2(0xF5,0xBC),      o2(0xF2,0xA4),
          o2(0xD8,0xCE),      o2(0xD8,0xCF),
          o2(0xF5,0xF7),      o2(0xF6,0xE1),
          o2(0xD2,0xB7),      o2(0xFB,0xEC),
          o2(0xDD,0xC8),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5_3F = {
    to_EUC_KR_E5_3F_offsets,
    to_CP949_E5_3F_infos
};


static const struct byte_lookup* const
to_CP949_E5_infos[65] = {
        &to_CP949_E5_00,    &to_CP949_E5_01,
        &to_CP949_E5_02,    &to_CP949_E5_03,
        &to_CP949_E5_04,    &to_CP949_E5_05,
        &to_CP949_E5_06,    &to_CP949_E5_07,
        &to_CP949_E5_08,    &to_CP949_E5_09,
        &to_CP949_E5_0A,    &to_CP949_E5_0B,
        &to_CP949_E5_0C,    &to_CP949_E5_0D,
        &to_CP949_E5_0E,    &to_CP949_E5_0F,
        &to_CP949_E5_10,    &to_CP949_E5_11,
        &to_CP949_E5_12,    &to_CP949_E5_13,
        &to_CP949_E5_14,    &to_CP949_E5_15,
        &to_CP949_E5_16,    &to_CP949_E5_17,
        &to_CP949_E5_18,    &to_CP949_E5_19,
        &to_CP949_E5_1A,    &to_CP949_E5_1B,
        &to_CP949_E5_1C,    &to_CP949_E5_1D,
        &to_CP949_E5_1E,    &to_CP949_E5_1F,
        &to_CP949_E5_20,    &to_CP949_E5_21,
        &to_CP949_E5_22,    &to_CP949_E5_23,
        &to_CP949_E5_24,    &to_CP949_E5_25,
        &to_CP949_E5_26,    &to_CP949_E5_27,
        &to_CP949_E5_28,    &to_CP949_E5_29,
        &to_CP949_E5_2A,    &to_CP949_E5_2B,
        &to_CP949_E5_2C,    &to_CP949_E5_2D,
        &to_CP949_E5_2E,    &to_CP949_E5_2F,
        &to_CP949_E5_30,    &to_CP949_E5_31,
        &to_CP949_E5_32,    &to_CP949_E5_33,
        &to_CP949_E5_34,    &to_CP949_E5_35,
        &to_CP949_E5_36,    &to_CP949_E5_37,
        &to_CP949_E5_38,    &to_CP949_E5_39,
        &to_CP949_E5_3A,    &to_CP949_E5_3B,
        &to_CP949_E5_3C,    &to_CP949_E5_3D,
        &to_CP949_E5_3E,    &to_CP949_E5_3F,
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E5 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_E5_infos
};


static const struct byte_lookup* const
to_CP949_E6_00_infos[13] = {
          o2(0xE4,0xE8),      o2(0xD2,0xC1),
          o2(0xF8,0xD7),      o2(0xD6,0xBB),
          o2(0xDE,0xD6),      o2(0xF7,0xBD),
          o2(0xEC,0xAE),      o2(0xD0,0xE1),
          o2(0xE0,0xF5),      o2(0xEA,0xB3),
          o2(0xCE,0xD6),      o2(0xCC,0xA5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_00 = {
    to_EUC_KR_E6_00_offsets,
    to_CP949_E6_00_infos
};


static const struct byte_lookup* const
to_CP949_E6_01_infos[21] = {
          o2(0xEC,0xF6),      o2(0xE2,0xE1),
          o2(0xE3,0xBE),      o2(0xFC,0xC8),
          o2(0xCD,0xF0),      o2(0xF9,0xF6),
          o2(0xDF,0xF0),      o2(0xE5,0xBF),
          o2(0xCE,0xBF),      o2(0xFC,0xE1),
          o2(0xED,0xB0),      o2(0xFD,0xD1),
          o2(0xF6,0xBB),      o2(0xF9,0xCF),
          o2(0xEB,0xDA),      o2(0xCA,0xC1),
          o2(0xD2,0xB8),      o2(0xCD,0xF1),
          o2(0xE3,0xD3),      o2(0xFD,0xE6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_01 = {
    to_EUC_KR_E6_01_offsets,
    to_CP949_E6_01_infos
};


static const struct byte_lookup* const
to_CP949_E6_02_infos[22] = {
          o2(0xE6,0xED),      o2(0xE3,0xFA),
          o2(0xF0,0xAA),      o2(0xF9,0xD0),
          o2(0xFC,0xE2),      o2(0xF8,0xA7),
          o2(0xE1,0xE5),      o2(0xEE,0xF9),
          o2(0xE7,0xF6),      o2(0xEA,0xED),
          o2(0xFC,0xB4),      o2(0xF5,0xC2),
          o2(0xD7,0xDC),      o2(0xF0,0xF5),
          o2(0xDD,0xE8),      o2(0xD3,0xED),
          o2(0xF5,0xFC),      o2(0xDA,0xBF),
          o2(0xCC,0xFB),      o2(0xD3,0xFA),
          o2(0xF4,0xA4),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_02 = {
    to_EUC_KR_E6_02_offsets,
    to_CP949_E6_02_infos
};


static const struct byte_lookup* const
to_CP949_E6_03_infos[16] = {
          o2(0xEF,0xD7),      o2(0xD4,0xC3),
          o2(0xFB,0xE3),      o2(0xFB,0xED),
          o2(0xE0,0xAD),      o2(0xEA,0xEE),
          o2(0xFB,0xB3),      o2(0xE4,0xC2),
          o2(0xF6,0xE7),      o2(0xD2,0xDD),
          o2(0xDF,0xCC),      o2(0xFC,0xC9),
          o2(0xE5,0xA9),      o2(0xE0,0xF6),
          o2(0xF6,0xB3),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_03 = {
    to_EUC_KR_E6_03_offsets,
    to_CP949_E6_03_infos
};


static const struct byte_lookup* const
to_CP949_E6_04_infos[19] = {
          o2(0xE1,0xFE),      o2(0xCB,0xF0),
          o2(0xEA,0xEF),      o2(0xEA,0xF0),
          o2(0xDA,0xC0),      o2(0xF8,0xB4),
          o2(0xEB,0xF2),      o2(0xE4,0xC3),
          o2(0xE9,0xD7),      o2(0xE4,0xF1),
          o2(0xCA,0xEF),      o2(0xCE,0xD7),
          o2(0xFC,0xCA),      o2(0xF3,0xE1),
          o2(0xCB,0xC4),      o2(0xE3,0xE5),
          o2(0xCB,0xC5),      o2(0xEA,0xB4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_04 = {
    to_EUC_KR_E6_04_offsets,
    to_CP949_E6_04_infos
};


static const struct byte_lookup* const
to_CP949_E6_05_infos[26] = {
          o2(0xE9,0xBD),      o2(0xD7,0xC9),
          o2(0xEB,0xDB),      o2(0xED,0xB1),
          o2(0xCC,0xC3),      o2(0xF7,0xBE),
          o2(0xFC,0xCB),      o2(0xF8,0xF4),
          o2(0xD9,0xB7),      o2(0xF3,0xD3),
          o2(0xF3,0xD4),      o2(0xF7,0xE4),
          o2(0xF7,0xD1),      o2(0xD8,0xB7),
          o2(0xCE,0xB1),      o2(0xCA,0xC2),
          o2(0xFB,0xB4),      o2(0xCB,0xC6),
          o2(0xF0,0xF6),      o2(0xD5,0xE7),
          o2(0xEA,0xD0),      o2(0xCC,0xD4),
          o2(0xCB,0xAF),      o2(0xF4,0xAA),
          o2(0xE9,0xAF),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_05 = {
    to_EUC_KR_E6_05_offsets,
    to_CP949_E6_05_infos
};


static const struct byte_lookup* const
to_CP949_E6_06_infos[21] = {
          o2(0xF5,0xC3),      o2(0xE9,0xD8),
          o2(0xDD,0xE9),      o2(0xF1,0xF3),
          o2(0xD5,0xFB),      o2(0xDE,0xBB),
          o2(0xF4,0xFB),      o2(0xFD,0xF3),
          o2(0xFD,0xF2),      o2(0xF7,0xA6),
          o2(0xDD,0xC9),      o2(0xD4,0xD3),
          o2(0xCC,0xA8),      o2(0xDA,0xC1),
          o2(0xCC,0xD5),      o2(0xD9,0xE4),
          o2(0xFA,0xCA),      o2(0xE5,0xE3),
          o2(0xD3,0xBC),      o2(0xCA,0xF0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_06 = {
    to_EUC_KR_E6_06_offsets,
    to_CP949_E6_06_infos
};


static const struct byte_lookup* const
to_CP949_E6_07_infos[15] = {
          o2(0xD0,0xC4),      o2(0xCA,0xD0),
          o2(0xFA,0xAB),      o2(0xEB,0xEB),
          o2(0xE7,0xF8),      o2(0xD9,0xE5),
          o2(0xD1,0xD7),      o2(0xF3,0xA4),
          o2(0xD4,0xFB),      o2(0xFC,0xE3),
          o2(0xFA,0xD8),      o2(0xF3,0xD5),
          o2(0xCF,0xAB),      o2(0xEB,0xF3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_07 = {
    to_EUC_KR_E6_07_offsets,
    to_CP949_E6_07_infos
};


static const struct byte_lookup* const
to_CP949_E6_08_infos[23] = {
          o2(0xD5,0xFC),      o2(0xD3,0xD4),
          o2(0xCD,0xFC),      o2(0xD9,0xE6),
          o2(0xE2,0xF9),      o2(0xE2,0xA1),
          o2(0xEB,0xD4),      o2(0xE0,0xF7),
          o2(0xE4,0xB2),      o2(0xCC,0xFC),
          o2(0xFB,0xE4),      o2(0xF4,0xAB),
          o2(0xD0,0xBD),      o2(0xCA,0xF1),
          o2(0xEF,0xB8),      o2(0xD7,0xC0),
          o2(0xEE,0xFA),      o2(0xFD,0xF4),
          o2(0xD3,0xE3),      o2(0xFB,0xC2),
          o2(0xD5,0xE8),      o2(0xDB,0xAE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_08 = {
    to_EUC_KR_E6_08_offsets,
    to_CP949_E6_08_infos
};


static const struct byte_lookup* const
to_CP949_E6_09_infos[16] = {
          o2(0xE1,0xB6),      o2(0xF8,0xB7),
          o2(0xE0,0xBF),      o2(0xFB,0xC3),
          o2(0xDD,0xEA),      o2(0xE2,0xA2),
          o2(0xEE,0xA6),      o2(0xF6,0xE8),
          o2(0xF6,0xF5),      o2(0xDD,0xCA),
          o2(0xD0,0xE2),      o2(0xDD,0xA6),
          o2(0xDD,0xEB),      o2(0xE4,0xF9),
          o2(0xE3,0xAF),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_09 = {
    to_EUC_KR_E6_09_offsets,
    to_CP949_E6_09_infos
};


static const struct byte_lookup* const
to_CP949_E6_0A_infos[17] = {
          o2(0xD0,0xFC),      o2(0xF4,0xFC),
          o2(0xCC,0xBC),      o2(0xF7,0xEA),
          o2(0xE5,0xE4),      o2(0xDF,0xF1),
          o2(0xF7,0xE1),      o2(0xF9,0xF7),
          o2(0xEF,0xB9),      o2(0xF8,0xD8),
          o2(0xF9,0xA9),      o2(0xF8,0xD9),
          o2(0xEE,0xBD),      o2(0xD8,0xC6),
          o2(0xE4,0xE3),      o2(0xF5,0xCE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_0A = {
    to_EUC_KR_E6_0A_offsets,
    to_CP949_E6_0A_infos
};


static const struct byte_lookup* const
to_CP949_E6_0B_infos[27] = {
          o2(0xDD,0xD9),      o2(0xD9,0xE7),
          o2(0xD2,0xB9),      o2(0xD5,0xC3),
          o2(0xDA,0xE5),      o2(0xDA,0xD0),
          o2(0xD1,0xD9),      o2(0xCE,0xD8),
          o2(0xCB,0xDE),      o2(0xF4,0xAC),
          o2(0xDA,0xFB),      o2(0xF6,0xE9),
          o2(0xE8,0xF3),      o2(0xCF,0xAC),
          o2(0xF0,0xF0),      o2(0xF4,0xFD),
          o2(0xDB,0xC8),      o2(0xCE,0xC0),
          o2(0xE3,0xD4),      o2(0xD1,0xCF),
          o2(0xF1,0xF5),      o2(0xCD,0xF2),
          o2(0xCF,0xEB),      o2(0xCD,0xB8),
          o2(0xE3,0xA6),      o2(0xD1,0xDA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_0B = {
    to_EUC_KR_E6_0B_offsets,
    to_CP949_E6_0B_infos
};


static const struct byte_lookup* const
to_CP949_E6_0C_infos[11] = {
          o2(0xF2,0xA5),      o2(0xF2,0xA6),
          o2(0xE4,0xCE),      o2(0xD3,0xFB),
          o2(0xF1,0xA9),      o2(0xF2,0xC9),
          o2(0xEF,0xD8),      o2(0xE6,0xC9),
          o2(0xD8,0xB8),      o2(0xFA,0xF3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_0C = {
    to_EUC_KR_E6_0C_offsets,
    to_CP949_E6_0C_infos
};


static const struct byte_lookup* const
to_CP949_E6_0D_infos[14] = {
          o2(0xF3,0xB5),      o2(0xF8,0xA4),
          o2(0xD1,0xF3),      o2(0xE6,0xC8),
          o2(0xF8,0xDA),      o2(0xDC,0xE9),
          o2(0xDE,0xD7),      o2(0xCB,0xDF),
          o2(0xCF,0xEC),      o2(0xF4,0xDF),
          o2(0xD1,0xF4),      o2(0xD2,0xBA),
          o2(0xDF,0xF2),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_0D = {
    to_EUC_KR_E6_0D_offsets,
    to_CP949_E6_0D_infos
};


static const struct byte_lookup* const
to_CP949_E6_0E_infos[17] = {
          o2(0xE1,0xB7),      o2(0xE2,0xA3),
          o2(0xD3,0xFC),      o2(0xED,0xE6),
          o2(0xDB,0xC9),      o2(0xE4,0xFA),
          o2(0xCF,0xDE),      o2(0xCE,0xD0),
          o2(0xD5,0xD3),      o2(0xF3,0xF5),
          o2(0xF7,0xAE),      o2(0xEF,0xC8),
          o2(0xCD,0xF3),      o2(0xF5,0xCF),
          o2(0xE5,0xF3),      o2(0xF0,0xC2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_0E = {
    to_EUC_KR_E6_0E_offsets,
    to_CP949_E6_0E_infos
};


static const struct byte_lookup* const
to_CP949_E6_0F_infos[15] = {
          o2(0xCA,0xD1),      o2(0xEA,0xF1),
          o2(0xD0,0xA6),      o2(0xD9,0xDA),
          o2(0xF0,0xAB),      o2(0xEB,0xE7),
          o2(0xE5,0xC0),      o2(0xFC,0xB5),
          o2(0xE4,0xC4),      o2(0xCC,0xA9),
          o2(0xFD,0xC6),      o2(0xEA,0xB5),
          o2(0xE5,0xAA),      o2(0xDF,0xBA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_0F = {
    to_EUC_KR_E6_0F_offsets,
    to_CP949_E6_0F_infos
};


static const struct byte_lookup* const
to_CP949_E6_10_infos[12] = {
          o2(0xE1,0xDF),      o2(0xDA,0xD1),
          o2(0xE1,0xB8),      o2(0xE8,0xF4),
          o2(0xD3,0xFD),      o2(0xE2,0xA4),
          o2(0xF2,0xCA),      o2(0xDA,0xE6),
          o2(0xF7,0xB3),      o2(0xFD,0xCD),
          o2(0xF3,0xB6),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_10 = {
    to_EUC_KR_E6_10_offsets,
    to_CP949_E6_10_infos
};


static const struct byte_lookup* const
to_CP949_E6_11_infos[8] = {
          o2(0xEE,0xD7),      o2(0xF5,0xC4),
          o2(0xD8,0xA4),      o2(0xF2,0xA7),
          o2(0xD9,0xB8),      o2(0xD9,0xB9),
          o2(0xEF,0xC9),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_11 = {
    to_EUC_KR_E6_11_offsets,
    to_CP949_E6_11_infos
};


static const struct byte_lookup* const
to_CP949_E6_12_infos[15] = {
          o2(0xD6,0xCE),      o2(0xF7,0xCB),
          o2(0xDF,0xAE),      o2(0xE8,0xF5),
          o2(0xD2,0xB5),      o2(0xD3,0xD5),
          o2(0xF4,0xCC),      o2(0xDA,0xFC),
          o2(0xD9,0xE8),      o2(0xF7,0xEB),
          o2(0xF5,0xC9),      o2(0xF3,0xBC),
          o2(0xDA,0xD2),      o2(0xD3,0xB5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_12 = {
    to_EUC_KR_E6_12_offsets,
    to_CP949_E6_12_infos
};


static const struct byte_lookup* const
to_CP949_E6_13_infos[22] = {
          o2(0xE8,0xB6),      o2(0xD6,0xCF),
          o2(0xF4,0xBA),      o2(0xF7,0xC9),
          o2(0xCC,0xAA),      o2(0xF0,0xC3),
          o2(0xCC,0xD6),      o2(0xD0,0xD3),
          o2(0xD3,0xBD),      o2(0xDB,0xFB),
          o2(0xCB,0xE0),      o2(0xD3,0xE4),
          o2(0xF6,0xF7),      o2(0xD5,0xBA),
          o2(0xF3,0xCD),      o2(0xCB,0xE1),
          o2(0xEB,0xF4),      o2(0xF4,0xAD),
          o2(0xFC,0xAA),      o2(0xF7,0xEC),
          o2(0xE8,0xF6),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_13 = {
    to_EUC_KR_E6_13_offsets,
    to_CP949_E6_13_infos
};


static const struct byte_lookup* const
to_CP949_E6_14_infos[17] = {
          o2(0xDA,0xE7),      o2(0xF7,0xCC),
          o2(0xE5,0xC1),      o2(0xE0,0xEE),
          o2(0xD5,0xFD),      o2(0xCE,0xE6),
          o2(0xFC,0xAB),      o2(0xD5,0xBB),
          o2(0xF2,0xA8),      o2(0xE2,0xA5),
          o2(0xCD,0xB9),      o2(0xEA,0xF2),
          o2(0xCB,0xC7),      o2(0xCD,0xF4),
          o2(0xDB,0xAF),      o2(0xEF,0xD9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_14 = {
    to_EUC_KR_E6_14_offsets,
    to_CP949_E6_14_infos
};


static const struct byte_lookup* const
to_CP949_E6_15_infos[21] = {
          o2(0xCD,0xBA),      o2(0xFC,0xF9),
          o2(0xDF,0xF3),      o2(0xCE,0xE7),
          o2(0xDA,0xC2),      o2(0xCF,0xAD),
          o2(0xE7,0xF9),      o2(0xF8,0xA8),
          o2(0xF3,0xE2),      o2(0xCA,0xF2),
          o2(0xDF,0xA4),      o2(0xD4,0xC4),
          o2(0xCC,0xD7),      o2(0xE5,0xC2),
          o2(0xCD,0xBB),      o2(0xEF,0xDA),
          o2(0xEE,0xD8),      o2(0xDD,0xA7),
          o2(0xE2,0xA6),      o2(0xE0,0xC0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_15 = {
    to_EUC_KR_E6_15_offsets,
    to_CP949_E6_15_infos
};


static const struct byte_lookup* const
to_CP949_E6_16_infos[25] = {
          o2(0xD6,0xB0),      o2(0xF8,0xCA),
          o2(0xFC,0xFA),      o2(0xD9,0xFE),
          o2(0xDE,0xB0),      o2(0xDD,0xEC),
          o2(0xDA,0xE8),      o2(0xD4,0xE0),
          o2(0xD6,0xF9),      o2(0xCD,0xD7),
          o2(0xDE,0xD8),      o2(0xF2,0xF8),
          o2(0xE4,0xD6),      o2(0xD0,0xC5),
          o2(0xF4,0xAE),      o2(0xDD,0xA8),
          o2(0xED,0xC5),      o2(0xF3,0xD6),
          o2(0xDE,0xD9),      o2(0xE3,0xE6),
          o2(0xD3,0xA8),      o2(0xDB,0xB0),
          o2(0xE5,0xDA),      o2(0xE3,0xBF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_16 = {
    to_EUC_KR_E6_16_offsets,
    to_CP949_E6_16_infos
};


static const struct byte_lookup* const
to_CP949_E6_17_infos[23] = {
          o2(0xDB,0xB1),      o2(0xD5,0xE9),
          o2(0xE0,0xC1),      o2(0xEF,0xDB),
          o2(0xF0,0xE9),      o2(0xD7,0xB2),
          o2(0xD0,0xFD),      o2(0xD9,0xE9),
          o2(0xD0,0xFE),      o2(0xEC,0xED),
          o2(0xD3,0xA9),      o2(0xF2,0xA9),
          o2(0xF0,0xC4),      o2(0xE2,0xE2),
          o2(0xE9,0xEF),      o2(0xF9,0xD1),
          o2(0xE9,0xD9),      o2(0xE8,0xDA),
          o2(0xDA,0xC3),      o2(0xDA,0xC4),
          o2(0xD4,0xC5),      o2(0xE7,0xFA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_17 = {
    to_EUC_KR_E6_17_offsets,
    to_CP949_E6_17_infos
};


static const struct byte_lookup* const
to_CP949_E6_18_infos[27] = {
          o2(0xCD,0xE0),      o2(0xE3,0xB0),
          o2(0xDB,0xB2),      o2(0xFB,0xC4),
          o2(0xF3,0xE3),      o2(0xD9,0xA5),
          o2(0xFB,0xE7),      o2(0xDD,0xCB),
          o2(0xD0,0xD4),      o2(0xE6,0xB6),
          o2(0xE0,0xAE),      o2(0xFD,0xDA),
          o2(0xDC,0xB5),      o2(0xE0,0xF8),
          o2(0xE7,0xB1),      o2(0xF5,0xF0),
          o2(0xD8,0xDC),      o2(0xED,0xC6),
          o2(0xE1,0xB9),      o2(0xE3,0xC0),
          o2(0xF9,0xC0),      o2(0xE9,0xF0),
          o2(0xD9,0xDB),      o2(0xF3,0xE4),
          o2(0xDC,0xB6),      o2(0xE4,0xE9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_18 = {
    to_EUC_KR_E6_18_offsets,
    to_CP949_E6_18_infos
};


static const struct byte_lookup* const
to_CP949_E6_19_infos[28] = {
          o2(0xF0,0xC5),      o2(0xE3,0xC1),
          o2(0xFC,0xCC),      o2(0xFC,0xCD),
          o2(0xF2,0xCB),      o2(0xF2,0xCC),
          o2(0xE4,0xCF),      o2(0xF1,0xDB),
          o2(0xFA,0xD9),      o2(0xF1,0xB8),
          o2(0xFD,0xF5),      o2(0xE0,0xF9),
          o2(0xE7,0xFB),      o2(0xFC,0xB7),
          o2(0xFC,0xE4),      o2(0xFB,0xC5),
          o2(0xE3,0xE7),      o2(0xD8,0xB9),
          o2(0xF6,0xF8),      o2(0xDC,0xC5),
          o2(0xCC,0xD8),      o2(0xE0,0xAF),
          o2(0xF4,0xE7),      o2(0xEF,0xDC),
          o2(0xCF,0xFC),      o2(0xEF,0xDD),
          o2(0xF2,0xAA),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_19 = {
    to_EUC_KR_E6_19_offsets,
    to_CP949_E6_19_infos
};


static const struct byte_lookup* const
to_CP949_E6_1A_infos[22] = {
          o2(0xFD,0xBE),      o2(0xCA,0xAC),
          o2(0xFD,0xBB),      o2(0xFD,0xC7),
          o2(0xE7,0xB2),      o2(0xEA,0xD1),
          o2(0xDF,0xF4),      o2(0xD1,0xEC),
          o2(0xE4,0xDE),      o2(0xE5,0xC3),
          o2(0xD9,0xA6),      o2(0xCD,0xBC),
          o2(0xF3,0xE5),      o2(0xED,0xD5),
          o2(0xD9,0xBA),      o2(0xED,0xE7),
          o2(0xFB,0xB5),      o2(0xF8,0xEC),
          o2(0xE0,0xE7),      o2(0xCC,0xD9),
          o2(0xD4,0xC6),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_1A = {
    to_EUC_KR_E6_1A_offsets,
    to_CP949_E6_1A_infos
};


static const struct byte_lookup* const
to_CP949_E6_1B_infos[22] = {
          o2(0xE7,0xA5),      o2(0xD5,0xF5),
          o2(0xD3,0xBE),      o2(0xFC,0xFB),
          o2(0xE4,0xF2),      o2(0xDF,0xF5),
          o2(0xE8,0xF8),      o2(0xF8,0xED),
          o2(0xCE,0xC7),      o2(0xFD,0xF6),
          o2(0xE8,0xD8),      o2(0xCD,0xD8),
          o2(0xE7,0xD6),      o2(0xCC,0xDA),
          o2(0xCA,0xE3),      o2(0xDF,0xF6),
          o2(0xF0,0xC7),      o2(0xF0,0xC6),
          o2(0xD8,0xBA),      o2(0xF1,0xF4),
          o2(0xF4,0xF0),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_1B = {
    to_EUC_KR_E6_1B_offsets,
    to_CP949_E6_1B_infos
};


static const struct byte_lookup* const
to_CP949_E6_1C_infos[27] = {
          o2(0xF5,0xCC),      o2(0xFC,0xE5),
          o2(0xEA,0xC5),      o2(0xEA,0xF3),
          o2(0xDD,0xDB),      o2(0xDC,0xD7),
          o2(0xDE,0xFD),      o2(0xF2,0xF9),
          o2(0xD5,0xC7),      o2(0xD8,0xD0),
          o2(0xF0,0xC8),      o2(0xD1,0xA1),
          o2(0xD1,0xA2),      o2(0xD9,0xD4),
          o2(0xD6,0xE8),      o2(0xD9,0xCA),
          o2(0xDA,0xB1),      o2(0xD8,0xC7),
          o2(0xDC,0xE2),      o2(0xF3,0xCE),
          o2(0xF5,0xF4),      o2(0xF1,0xB9),
          o2(0xDA,0xD3),      o2(0xF6,0xEA),
          o2(0xCF,0xF5),      o2(0xFD,0xAE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_1C = {
    to_EUC_KR_E6_1C_offsets,
    to_CP949_E6_1C_infos
};


static const struct byte_lookup* const
to_CP949_E6_1D_infos[22] = {
          o2(0xCA,0xD2),      o2(0xDF,0xB4),
          o2(0xD7,0xDD),      o2(0xFA,0xBA),
          o2(0xEE,0xA7),      o2(0xF5,0xBD),
          o2(0xF8,0xF5),      o2(0xED,0xE8),
          o2(0xD4,0xE1),      o2(0xD1,0xA3),
          o2(0xE1,0xD6),      o2(0xF9,0xF8),
          o2(0xDB,0xCA),      o2(0xCB,0xF9),
          o2(0xD4,0xD4),      o2(0xD9,0xDC),
          o2(0xEE,0xBE),      o2(0xF7,0xED),
          o2(0xD2,0xEE),      o2(0xE1,0xE6),
          o2(0xF7,0xF9),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_1D = {
    to_EUC_KR_E6_1D_offsets,
    to_CP949_E6_1D_infos
};


static const struct byte_lookup* const
to_CP949_E6_1E_infos[19] = {
          o2(0xDD,0xED),      o2(0xE8,0xDB),
          o2(0xDB,0xB3),      o2(0xD1,0xF7),
          o2(0xE0,0xB0),      o2(0xD4,0xE2),
          o2(0xF6,0xD7),      o2(0xD7,0xF9),
          o2(0xD8,0xDD),      o2(0xCD,0xFD),
          o2(0xF2,0xAB),      o2(0xCD,0xBD),
          o2(0xF8,0xC2),      o2(0xF2,0xAC),
          o2(0xCA,0xAD),      o2(0xCA,0xAE),
          o2(0xCF,0xAE),      o2(0xE3,0xC2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_1E = {
    to_EUC_KR_E6_1E_offsets,
    to_CP949_E6_1E_infos
};


static const struct byte_lookup* const
to_CP949_E6_1F_infos[21] = {
          o2(0xDC,0xB7),      o2(0xDB,0xDA),
          o2(0xD9,0xBB),      o2(0xCA,0xF3),
          o2(0xF6,0xD3),      o2(0xE6,0xF8),
          o2(0xEA,0xF5),      o2(0xEA,0xF6),
          o2(0xF6,0xF9),      o2(0xCF,0xAF),
          o2(0xCA,0xD3),      o2(0xCA,0xAF),
          o2(0xD2,0xB0),      o2(0xF1,0xBA),
          o2(0xD7,0xB3),      o2(0xE3,0xC3),
          o2(0xF3,0xFD),      o2(0xDE,0xDA),
          o2(0xDE,0xDB),      o2(0xEF,0xDE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_1F = {
    to_EUC_KR_E6_1F_offsets,
    to_CP949_E6_1F_infos
};


static const struct byte_lookup* const
to_CP949_E6_20_infos[13] = {
          o2(0xE2,0xE3),      o2(0xEE,0xFB),
          o2(0xDF,0xF7),      o2(0xD7,0xCA),
          o2(0xCE,0xE8),      o2(0xDB,0xDB),
          o2(0xF1,0xBB),      o2(0xE9,0xF1),
          o2(0xFA,0xB7),      o2(0xD0,0xC6),
          o2(0xCC,0xAB),      o2(0xEE,0xA8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_20 = {
    to_EUC_KR_E6_20_offsets,
    to_CP949_E6_20_infos
};


static const struct byte_lookup* const
to_CP949_E6_21_infos[14] = {
          o2(0xCB,0xFA),      o2(0xF9,0xF9),
          o2(0xCC,0xFD),      o2(0xD3,0xFE),
          o2(0xE4,0xD0),      o2(0xF2,0xEE),
          o2(0xD4,0xD5),      o2(0xDF,0xCD),
          o2(0xFC,0xB8),      o2(0xD1,0xD0),
          o2(0xF2,0xCD),      o2(0xF7,0xD2),
          o2(0xCA,0xD4),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_21 = {
    to_EUC_KR_E6_21_offsets,
    to_CP949_E6_21_infos
};


static const struct byte_lookup* const
to_CP949_E6_22_infos[20] = {
          o2(0xD5,0xD9),      o2(0xD8,0xDE),
          o2(0xCD,0xD9),      o2(0xEE,0xA9),
          o2(0xF6,0xBC),      o2(0xCC,0xDB),
          o2(0xF0,0xC9),      o2(0xFC,0xFC),
          o2(0xE8,0xC9),      o2(0xF4,0xFE),
          o2(0xE7,0xFC),      o2(0xD7,0xDE),
          o2(0xDE,0xDC),      o2(0xF0,0xAC),
          o2(0xCC,0xFE),      o2(0xCD,0xE1),
          o2(0xE1,0xBA),      o2(0xDB,0xEF),
          o2(0xDA,0xB2),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_22 = {
    to_EUC_KR_E6_22_offsets,
    to_CP949_E6_22_infos
};


static const struct byte_lookup* const
to_CP949_E6_23_infos[19] = {
          o2(0xD1,0xA5),      o2(0xDC,0xB8),
          o2(0xD8,0xF6),      o2(0xD1,0xA4),
          o2(0xCD,0xE2),      o2(0xDC,0xEA),
          o2(0xF0,0xF7),      o2(0xF0,0xCA),
          o2(0xD0,0xBE),      o2(0xDD,0xDC),
          o2(0xD4,0xD6),      o2(0xD3,0xD6),
          o2(0xED,0xD0),      o2(0xCD,0xA1),
          o2(0xDF,0xB5),      o2(0xDF,0xF8),
          o2(0xD4,0xA1),      o2(0xCE,0xB2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_23 = {
    to_EUC_KR_E6_23_offsets,
    to_CP949_E6_23_infos
};


static const struct byte_lookup* const
to_CP949_E6_24_infos[10] = {
          o2(0xE8,0xCA),      o2(0xEB,0xF5),
          o2(0xE3,0xD5),      o2(0xF5,0xD0),
          o2(0xF5,0xA1),      o2(0xD9,0xA7),
          o2(0xE5,0xAB),      o2(0xE6,0xCB),
          o2(0xF5,0xF1),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_24 = {
    to_EUC_KR_E6_24_offsets,
    to_CP949_E6_24_infos
};


static const struct byte_lookup* const
to_CP949_E6_25_infos[22] = {
          o2(0xE5,0xC5),      o2(0xF9,0xA3),
          o2(0xE0,0xDB),      o2(0xF6,0xEB),
          o2(0xCB,0xF1),      o2(0xD9,0xEA),
          o2(0xF5,0xA2),      o2(0xD7,0xD1),
          o2(0xD1,0xF8),      o2(0xEA,0xF8),
          o2(0xEA,0xF9),      o2(0xDA,0xB3),
          o2(0xEF,0xDF),      o2(0xF1,0xEF),
          o2(0xE5,0xF6),      o2(0xEE,0xBF),
          o2(0xE2,0xE4),      o2(0xD0,0xBF),
          o2(0xFA,0xAC),      o2(0xF5,0xD1),
          o2(0xE7,0xB3),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_25 = {
    to_EUC_KR_E6_25_offsets,
    to_CP949_E6_25_infos
};


static const struct byte_lookup* const
to_CP949_E6_26_infos[9] = {
          o2(0xE9,0xBE),      o2(0xF2,0xCE),
          o2(0xDB,0xB4),      o2(0xFC,0xCE),
          o2(0xDD,0xEE),      o2(0xE7,0xB4),
          o2(0xD7,0xB4),      o2(0xF7,0xB4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_26 = {
    to_EUC_KR_E6_26_offsets,
    to_CP949_E6_26_infos
};


static const struct byte_lookup* const
to_CP949_E6_27_infos[12] = {
          o2(0xCD,0xBE),      o2(0xDA,0xE9),
          o2(0xCF,0xB0),      o2(0xF7,0xD9),
          o2(0xF3,0xE6),      o2(0xCE,0xD9),
          o2(0xCE,0xAA),      o2(0xCB,0xC8),
          o2(0xD0,0xA7),      o2(0xF0,0xCB),
          o2(0xD0,0xC7),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_27 = {
    to_EUC_KR_E6_27_offsets,
    to_CP949_E6_27_infos
};


static const struct byte_lookup* const
to_CP949_E6_28_infos[16] = {
          o2(0xE4,0xC5),      o2(0xDB,0xE0),
          o2(0xD5,0xDA),      o2(0xD7,0xA7),
          o2(0xEE,0xC0),      o2(0xF8,0xF6),
          o2(0xF5,0xD2),      o2(0xED,0xE9),
          o2(0xD9,0xBC),      o2(0xE5,0xC6),
          o2(0xF5,0xA3),      o2(0xDA,0xD4),
          o2(0xE2,0xA7),      o2(0xFB,0xFC),
          o2(0xF1,0xDC),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_28 = {
    to_EUC_KR_E6_28_offsets,
    to_CP949_E6_28_infos
};


static const struct byte_lookup* const
to_CP949_E6_29_infos[11] = {
          o2(0xCA,0xF4),      o2(0xE8,0xFA),
          o2(0xCE,0xE9),      o2(0xE9,0xF8),
          o2(0xE2,0xE5),      o2(0xD0,0xB9),
          o2(0xD4,0xF2),      o2(0xD1,0xA6),
          o2(0xDF,0xCE),      o2(0xFC,0xF4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_29 = {
    to_EUC_KR_E6_29_offsets,
    to_CP949_E6_29_infos
};


static const struct byte_lookup* const
to_CP949_E6_2A_infos[12] = {
          o2(0xD3,0xAA),      o2(0xCC,0xAC),
          o2(0xEF,0xE0),      o2(0xE5,0xE5),
          o2(0xD0,0xD5),      o2(0xDB,0xFC),
          o2(0xFC,0xE6),      o2(0xCB,0xFE),
          o2(0xED,0xEA),      o2(0xDE,0xB1),
          o2(0xF9,0xE3),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_2A = {
    to_EUC_KR_E6_2A_offsets,
    to_CP949_E6_2A_infos
};


static const struct byte_lookup* const
to_CP949_E6_2B_infos[8] = {
          o2(0xD4,0xA2),      o2(0xCF,0xF6),
          o2(0xD6,0xD0),      o2(0xD5,0xEA),
          o2(0xF1,0xEE),      o2(0xFA,0xCB),
          o2(0xE5,0xA1),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_2B = {
    to_EUC_KR_E6_2B_offsets,
    to_CP949_E6_2B_infos
};


static const struct byte_lookup* const
to_CP949_E6_2C_infos[13] = {
          o2(0xD5,0xB1),      o2(0xCF,0xED),
          o2(0xED,0xEB),      o2(0xD5,0xB2),
          o2(0xD5,0xBC),      o2(0xFD,0xE2),
          o2(0xF3,0xAD),      o2(0xFD,0xDB),
          o2(0xE9,0xB0),      o2(0xD1,0xA7),
          o2(0xFD,0xE3),      o2(0xCE,0xB3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_2C = {
    to_EUC_KR_E6_2C_offsets,
    to_CP949_E6_2C_infos
};


static const struct byte_lookup* const
to_CP949_E6_2D_infos[19] = {
          o2(0xFD,0xE4),      o2(0xFA,0xCE),
          o2(0xCA,0xB0),      o2(0xF7,0xA7),
          o2(0xCF,0xB1),      o2(0xE6,0xA2),
          o2(0xFC,0xB6),      o2(0xF2,0xAD),
          o2(0xEF,0xE1),      o2(0xF3,0xAE),
          o2(0xDC,0xC6),      o2(0xD9,0xEB),
          o2(0xE8,0xE0),      o2(0xE1,0xA8),
          o2(0xD5,0xF6),      o2(0xCF,0xFD),
          o2(0xDE,0xDD),      o2(0xD9,0xD1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_2D = {
    to_EUC_KR_E6_2D_offsets,
    to_CP949_E6_2D_infos
};


static const struct byte_lookup* const
to_CP949_E6_2E_infos[17] = {
          o2(0xE4,0xEA),      o2(0xF2,0xCF),
          o2(0xF7,0xBF),      o2(0xE2,0xE6),
          o2(0xE2,0xA8),      o2(0xE3,0xD6),
          o2(0xED,0xD1),      o2(0xE9,0xF9),
          o2(0xD6,0xB1),      o2(0xDE,0xB2),
          o2(0xE0,0xE8),      o2(0xD3,0xAB),
          o2(0xEB,0xDC),      o2(0xDF,0xAF),
          o2(0xCA,0xC3),      o2(0xEE,0xFC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_2E = {
    to_EUC_KR_E6_2E_offsets,
    to_CP949_E6_2E_infos
};


static const struct byte_lookup* const
to_CP949_E6_2F_infos[16] = {
          o2(0xFD,0xC3),      o2(0xEB,0xF6),
          o2(0xCF,0xB2),      o2(0xD9,0xEC),
          o2(0xD9,0xBD),      o2(0xD8,0xDF),
          o2(0xD4,0xB8),      o2(0xEB,0xBE),
          o2(0xDD,0xEF),      o2(0xDD,0xF0),
          o2(0xDD,0xF1),      o2(0xDD,0xF2),
          o2(0xD9,0xBE),      o2(0xFB,0xC6),
          o2(0xCF,0xB3),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_2F = {
    to_EUC_KR_E6_2F_offsets,
    to_CP949_E6_2F_infos
};


static const struct byte_lookup* const
to_CP949_E6_30_infos[10] = {
          o2(0xEE,0xFD),      o2(0xE4,0xAB),
          o2(0xDA,0xC5),      o2(0xD8,0xEC),
          o2(0xD1,0xA8),      o2(0xE2,0xA9),
          o2(0xDE,0xBC),      o2(0xE7,0xB5),
          o2(0xDB,0xF0),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_30 = {
    to_EUC_KR_E6_30_offsets,
    to_CP949_E6_30_infos
};


static const struct byte_lookup* const
to_CP949_E6_31_infos[22] = {
          o2(0xEF,0xE2),      o2(0xF1,0xF0),
          o2(0xCF,0xB4),      o2(0xDB,0xF1),
          o2(0xE0,0xB1),      o2(0xDF,0xA5),
          o2(0xF9,0xD2),      o2(0xE7,0xFD),
          o2(0xE6,0xA3),      o2(0xFB,0xF1),
          o2(0xCB,0xB0),      o2(0xF2,0xAE),
          o2(0xCD,0xE7),      o2(0xE8,0xDC),
          o2(0xE7,0xD7),      o2(0xF7,0xC0),
          o2(0xD0,0xE3),      o2(0xDA,0xA1),
          o2(0xCC,0xBD),      o2(0xD1,0xA9),
          o2(0xDD,0xCC),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_31 = {
    to_EUC_KR_E6_31_offsets,
    to_CP949_E6_31_infos
};


static const struct byte_lookup* const
to_CP949_E6_32_infos[28] = {
          o2(0xE3,0xFE),      o2(0xD1,0xAA),
          o2(0xE8,0xAA),      o2(0xEA,0xB6),
          o2(0xF9,0xFA),      o2(0xE6,0xCC),
          o2(0xF6,0xD8),      o2(0xD4,0xC7),
          o2(0xD9,0xCB),      o2(0xD9,0xD2),
          o2(0xD3,0xCB),      o2(0xD8,0xF7),
          o2(0xDA,0xA9),      o2(0xF5,0xF8),
          o2(0xDE,0xDE),      o2(0xF2,0xAF),
          o2(0xF8,0xA9),      o2(0xD8,0xC8),
          o2(0xEE,0xC1),      o2(0xF9,0xC1),
          o2(0xDD,0xF3),      o2(0xEA,0xFA),
          o2(0xF6,0xBD),      o2(0xE1,0xBB),
          o2(0xCD,0xBF),      o2(0xF4,0xD4),
          o2(0xE6,0xCD),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_32 = {
    to_EUC_KR_E6_32_offsets,
    to_CP949_E6_32_infos
};


static const struct byte_lookup* const
to_CP949_E6_33_infos[21] = {
          o2(0xFC,0xCF),      o2(0xFB,0xA2),
          o2(0xE0,0xDC),      o2(0xF4,0xBB),
          o2(0xDA,0xD5),      o2(0xF9,0xB2),
          o2(0xFB,0xF2),      o2(0xDB,0xF6),
          o2(0xDE,0xDF),      o2(0xDB,0xF2),
          o2(0xF8,0xDC),      o2(0xF7,0xEE),
          o2(0xEB,0xE8),      o2(0xD2,0xFA),
          o2(0xF1,0xBC),      o2(0xFA,0xDA),
          o2(0xDA,0xEA),      o2(0xDA,0xC6),
          o2(0xF7,0xC1),      o2(0xE7,0xB6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_33 = {
    to_EUC_KR_E6_33_offsets,
    to_CP949_E6_33_infos
};


static const struct byte_lookup* const
to_CP949_E6_34_infos[20] = {
          o2(0xE5,0xC7),      o2(0xD6,0xAC),
          o2(0xDC,0xC7),      o2(0xE1,0xA9),
          o2(0xE2,0xAA),      o2(0xD5,0xA6),
          o2(0xD4,0xD7),      o2(0xF2,0xD0),
          o2(0xEA,0xFB),      o2(0xE0,0xDD),
          o2(0xFB,0xF3),      o2(0xF1,0xBD),
          o2(0xE2,0xE7),      o2(0xFD,0xD7),
          o2(0xCE,0xC8),      o2(0xEA,0xB7),
          o2(0xFC,0xC0),      o2(0xFD,0xE7),
          o2(0xF7,0xEF),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_34 = {
    to_EUC_KR_E6_34_offsets,
    to_CP949_E6_34_infos
};


static const struct byte_lookup* const
to_CP949_E6_35_infos[16] = {
          o2(0xD7,0xB5),      o2(0xEF,0xBA),
          o2(0xF1,0xDD),      o2(0xDE,0xB3),
          o2(0xE8,0xCB),      o2(0xF8,0xDD),
          o2(0xFB,0xC7),      o2(0xD5,0xC8),
          o2(0xD7,0xDF),      o2(0xDD,0xA9),
          o2(0xE9,0xB1),      o2(0xFA,0xAD),
          o2(0xF6,0xD9),      o2(0xFA,0xF4),
          o2(0xF8,0xAA),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_35 = {
    to_EUC_KR_E6_35_offsets,
    to_CP949_E6_35_infos
};


static const struct byte_lookup* const
to_CP949_E6_36_infos[14] = {
          o2(0xE6,0xEE),      o2(0xCC,0xDC),
          o2(0xE1,0xBC),      o2(0xE0,0xEF),
          o2(0xE9,0xBF),      o2(0xFC,0xFD),
          o2(0xE6,0xCE),      o2(0xE1,0xD7),
          o2(0xE6,0xCF),      o2(0xF4,0xF1),
          o2(0xE4,0xF3),      o2(0xE4,0xFB),
          o2(0xF9,0xE4),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_36 = {
    to_EUC_KR_E6_36_offsets,
    to_CP949_E6_36_infos
};


static const struct byte_lookup* const
to_CP949_E6_37_infos[27] = {
          o2(0xEF,0xE3),      o2(0xCF,0xEE),
          o2(0xF6,0xBE),      o2(0xE0,0xB2),
          o2(0xFC,0xFE),      o2(0xD1,0xAB),
          o2(0xD7,0xFA),      o2(0xFB,0xC8),
          o2(0xE2,0xD7),      o2(0xD4,0xA3),
          o2(0xF0,0xF8),      o2(0xD7,0xA8),
          o2(0xE1,0xE7),      o2(0xD3,0xBF),
          o2(0xEF,0xE4),      o2(0xD7,0xC5),
          o2(0xEB,0xE2),      o2(0xFC,0xE7),
          o2(0xE4,0xA2),      o2(0xE2,0xE8),
          o2(0xE6,0xD0),      o2(0xFB,0xE8),
          o2(0xF4,0xE8),      o2(0xE5,0xF4),
          o2(0xF4,0xBC),      o2(0xF4,0xD5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_37 = {
    to_EUC_KR_E6_37_offsets,
    to_CP949_E6_37_infos
};


static const struct byte_lookup* const
to_CP949_E6_38_infos[24] = {
          o2(0xDF,0xB6),      o2(0xFC,0xB9),
          o2(0xEE,0xC2),      o2(0xCA,0xF5),
          o2(0xEF,0xE5),      o2(0xCB,0xE2),
          o2(0xD4,0xA4),      o2(0xDE,0xE0),
          o2(0xDA,0xFD),      o2(0xE4,0xC6),
          o2(0xE8,0xBE),      o2(0xE0,0xDE),
          o2(0xF6,0xB4),      o2(0xEA,0xD2),
          o2(0xF9,0xFB),      o2(0xE0,0xC2),
          o2(0xCA,0xE4),      o2(0xE7,0xB7),
          o2(0xEA,0xFD),      o2(0xD9,0xDD),
          o2(0xDA,0xB4),      o2(0xEE,0xAA),
          o2(0xFB,0xE9),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_38 = {
    to_EUC_KR_E6_38_offsets,
    to_CP949_E6_38_infos
};


static const struct byte_lookup* const
to_CP949_E6_39_infos[18] = {
          o2(0xDB,0xCB),      o2(0xDA,0xB5),
          o2(0xF1,0xBE),      o2(0xD3,0xAC),
          o2(0xFB,0xC9),      o2(0xDF,0xCF),
          o2(0xD3,0xC0),      o2(0xE3,0xD7),
          o2(0xEF,0xE6),      o2(0xFC,0xD0),
          o2(0xE9,0xC0),      o2(0xF5,0xD3),
          o2(0xEC,0xDC),      o2(0xF7,0xB7),
          o2(0xEA,0xB8),      o2(0xD1,0xF9),
          o2(0xDC,0xC8),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_39 = {
    to_EUC_KR_E6_39_offsets,
    to_CP949_E6_39_infos
};


static const struct byte_lookup* const
to_CP949_E6_3A_infos[14] = {
          o2(0xEA,0xB9),      o2(0xF1,0xDE),
          o2(0xD7,0xB6),      o2(0xCF,0xB5),
          o2(0xD9,0xA8),      o2(0xEC,0xEE),
          o2(0xDD,0xAA),      o2(0xCD,0xA2),
          o2(0xE8,0xAE),      o2(0xE1,0xBD),
          o2(0xF2,0xD1),      o2(0xE9,0xC1),
          o2(0xD2,0xFC),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_3A = {
    to_EUC_KR_E6_3A_offsets,
    to_CP949_E6_3A_infos
};


static const struct byte_lookup* const
to_CP949_E6_3B_infos[16] = {
          o2(0xDB,0xB5),      o2(0xF3,0xE7),
          o2(0xD8,0xFE),      o2(0xFC,0xD1),
          o2(0xED,0xB2),      o2(0xF4,0xAF),
          o2(0xFB,0xA3),      o2(0xFC,0xC1),
          o2(0xEE,0xAB),      o2(0xD4,0xA5),
          o2(0xF4,0xF2),      o2(0xEE,0xD9),
          o2(0xFB,0xCA),      o2(0xCD,0xE3),
          o2(0xD8,0xBB),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_3B = {
    to_EUC_KR_E6_3B_offsets,
    to_CP949_E6_3B_infos
};


static const struct byte_lookup* const
to_CP949_E6_3C_infos[17] = {
          o2(0xE5,0xDB),      o2(0xF8,0xF7),
          o2(0xF6,0xD4),      o2(0xD7,0xA9),
          o2(0xCB,0xC9),      o2(0xE6,0xD1),
          o2(0xF0,0xCC),      o2(0xD8,0xAE),
          o2(0xF9,0xD3),      o2(0xD5,0xFE),
          o2(0xD8,0xBC),      o2(0xF2,0xB0),
          o2(0xE2,0xAB),      o2(0xF3,0xE8),
          o2(0xEF,0xC2),      o2(0xED,0xEC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_3C = {
    to_EUC_KR_E6_3C_offsets,
    to_CP949_E6_3C_infos
};


static const struct byte_lookup* const
to_CP949_E6_3D_infos[19] = {
          o2(0xE7,0xB8),      o2(0xDA,0xFE),
          o2(0xCC,0xBE),      o2(0xF2,0xFC),
          o2(0xDA,0xEB),      o2(0xE2,0xD8),
          o2(0xED,0xD6),      o2(0xD6,0xD1),
          o2(0xE0,0xB3),      o2(0xFC,0xD2),
          o2(0xEB,0xC8),      o2(0xD3,0xC1),
          o2(0xF0,0xCD),      o2(0xCF,0xF7),
          o2(0xED,0xD2),      o2(0xD4,0xD8),
          o2(0xDC,0xC9),      o2(0xD7,0xF1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_3D = {
    to_EUC_KR_E6_3D_offsets,
    to_CP949_E6_3D_infos
};


static const struct byte_lookup* const
to_CP949_E6_3E_infos[18] = {
          o2(0xDF,0xBB),      o2(0xF3,0xA5),
          o2(0xF4,0xCD),      o2(0xF1,0xBF),
          o2(0xF8,0xB1),      o2(0xE9,0xFA),
          o2(0xFB,0xCB),      o2(0xCA,0xD5),
          o2(0xF9,0xD4),      o2(0xF7,0xCA),
          o2(0xD6,0xC8),      o2(0xFC,0xE8),
          o2(0xF3,0xBD),      o2(0xEE,0xFE),
          o2(0xE7,0xFE),      o2(0xD3,0xC2),
          o2(0xD3,0xB6),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_3E = {
    to_EUC_KR_E6_3E_offsets,
    to_CP949_E6_3E_infos
};


static const struct byte_lookup* const
to_CP949_E6_3F_infos[18] = {
          o2(0xCC,0xAD),      o2(0xF6,0xFA),
          o2(0xD6,0xB2),      o2(0xD2,0xD8),
          o2(0xE7,0xD8),      o2(0xE3,0xA5),
          o2(0xE7,0xB9),      o2(0xF0,0xAD),
          o2(0xFB,0xCC),      o2(0xEB,0xA1),
          o2(0xD4,0xA6),      o2(0xFB,0xCD),
          o2(0xD5,0xBD),      o2(0xF1,0xDF),
          o2(0xF6,0xFB),      o2(0xDE,0xB4),
          o2(0xD5,0xEB),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6_3F = {
    to_EUC_KR_E6_3F_offsets,
    to_CP949_E6_3F_infos
};


static const struct byte_lookup* const
to_CP949_E6_infos[65] = {
        &to_CP949_E6_00,    &to_CP949_E6_01,
        &to_CP949_E6_02,    &to_CP949_E6_03,
        &to_CP949_E6_04,    &to_CP949_E6_05,
        &to_CP949_E6_06,    &to_CP949_E6_07,
        &to_CP949_E6_08,    &to_CP949_E6_09,
        &to_CP949_E6_0A,    &to_CP949_E6_0B,
        &to_CP949_E6_0C,    &to_CP949_E6_0D,
        &to_CP949_E6_0E,    &to_CP949_E6_0F,
        &to_CP949_E6_10,    &to_CP949_E6_11,
        &to_CP949_E6_12,    &to_CP949_E6_13,
        &to_CP949_E6_14,    &to_CP949_E6_15,
        &to_CP949_E6_16,    &to_CP949_E6_17,
        &to_CP949_E6_18,    &to_CP949_E6_19,
        &to_CP949_E6_1A,    &to_CP949_E6_1B,
        &to_CP949_E6_1C,    &to_CP949_E6_1D,
        &to_CP949_E6_1E,    &to_CP949_E6_1F,
        &to_CP949_E6_20,    &to_CP949_E6_21,
        &to_CP949_E6_22,    &to_CP949_E6_23,
        &to_CP949_E6_24,    &to_CP949_E6_25,
        &to_CP949_E6_26,    &to_CP949_E6_27,
        &to_CP949_E6_28,    &to_CP949_E6_29,
        &to_CP949_E6_2A,    &to_CP949_E6_2B,
        &to_CP949_E6_2C,    &to_CP949_E6_2D,
        &to_CP949_E6_2E,    &to_CP949_E6_2F,
        &to_CP949_E6_30,    &to_CP949_E6_31,
        &to_CP949_E6_32,    &to_CP949_E6_33,
        &to_CP949_E6_34,    &to_CP949_E6_35,
        &to_CP949_E6_36,    &to_CP949_E6_37,
        &to_CP949_E6_38,    &to_CP949_E6_39,
        &to_CP949_E6_3A,    &to_CP949_E6_3B,
        &to_CP949_E6_3C,    &to_CP949_E6_3D,
        &to_CP949_E6_3E,    &to_CP949_E6_3F,
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E6 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_E6_infos
};


static const struct byte_lookup* const
to_CP949_E7_00_infos[22] = {
          o2(0xE5,0xC8),      o2(0xFB,0xA4),
          o2(0xD4,0xB9),      o2(0xDE,0xE1),
          o2(0xE4,0xA3),      o2(0xD7,0xB7),
          o2(0xF8,0xEE),      o2(0xDE,0xB5),
          o2(0xD6,0xD2),      o2(0xF9,0xD5),
          o2(0xE7,0xBA),      o2(0xEB,0xD5),
          o2(0xD5,0xF7),      o2(0xEF,0xE7),
          o2(0xE1,0xBE),      o2(0xFA,0xAE),
          o2(0xD6,0xE9),      o2(0xD6,0xEE),
          o2(0xE7,0xBB),      o2(0xEC,0xCB),
          o2(0xD5,0xB3),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_00 = {
    to_EUC_KR_E7_00_offsets,
    to_CP949_E7_00_infos
};


static const struct byte_lookup* const
to_CP949_E7_01_infos[12] = {
          o2(0xCE,0xB4),      o2(0xFB,0xA5),
          o2(0xE1,0xEE),      o2(0xF7,0xA8),
          o2(0xFB,0xCE),      o2(0xD8,0xBD),
          o2(0xFB,0xFD),      o2(0xFC,0xE9),
          o2(0xCF,0xB6),      o2(0xED,0xC7),
          o2(0xEE,0xAC),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_01 = {
    to_EUC_KR_E7_01_offsets,
    to_CP949_E7_01_infos
};


static const struct byte_lookup* const
to_CP949_E7_02_infos[18] = {
          o2(0xCC,0xDD),      o2(0xF6,0xA7),
          o2(0xE6,0xFA),      o2(0xF5,0xA4),
          o2(0xFD,0xDC),      o2(0xED,0xB3),
          o2(0xCE,0xC9),      o2(0xEF,0xE8),
          o2(0xE1,0xBF),      o2(0xFA,0xDB),
          o2(0xCB,0xE3),      o2(0xF7,0xA9),
          o2(0xFB,0xA6),      o2(0xDC,0xB9),
          o2(0xF1,0xC0),      o2(0xED,0xC8),
          o2(0xEF,0xC3),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_02 = {
    to_EUC_KR_E7_02_offsets,
    to_CP949_E7_02_infos
};


static const struct byte_lookup* const
to_CP949_E7_03_infos[11] = {
          o2(0xD6,0xAD),      o2(0xFD,0xCE),
          o2(0xE8,0xA1),      o2(0xFB,0xF4),
          o2(0xD5,0xA7),      o2(0xF1,0xF6),
          o2(0xE6,0xD3),      o2(0xCC,0xDE),
          o2(0xF8,0xB2),      o2(0xDC,0xEB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_03 = {
    to_EUC_KR_E7_03_offsets,
    to_CP949_E7_03_infos
};


static const struct byte_lookup* const
to_CP949_E7_04_infos[11] = {
          o2(0xFD,0xB6),      o2(0xE5,0xEA),
          o2(0xF1,0xE0),      o2(0xDB,0xCC),
          o2(0xDD,0xCD),      o2(0xD4,0xC8),
          o2(0xD9,0xED),      o2(0xF5,0xA5),
          o2(0xE6,0xFB),      o2(0xE6,0xD4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_04 = {
    to_EUC_KR_E7_04_offsets,
    to_CP949_E7_04_infos
};


static const struct byte_lookup* const
to_CP949_E7_05_infos[19] = {
          o2(0xFD,0xC8),      o2(0xD6,0xA1),
          o2(0xFD,0xBF),      o2(0xFC,0xD3),
          o2(0xEF,0xA1),      o2(0xE7,0xBC),
          o2(0xD1,0xEE),      o2(0xE6,0xD5),
          o2(0xE9,0xF2),      o2(0xDF,0xB0),
          o2(0xD8,0xE0),      o2(0xFC,0xBA),
          o2(0xFD,0xAF),      o2(0xF0,0xCE),
          o2(0xDB,0xE1),      o2(0xE5,0xC9),
          o2(0xED,0xB4),      o2(0xE0,0xC3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_05 = {
    to_EUC_KR_E7_05_offsets,
    to_CP949_E7_05_infos
};


static const struct byte_lookup* const
to_CP949_E7_06_infos[15] = {
          o2(0xE3,0xD8),      o2(0xE9,0xFB),
          o2(0xEA,0xA8),      o2(0xFD,0xB7),
          o2(0xFB,0xA7),      o2(0xE9,0xC2),
          o2(0xFD,0xF7),      o2(0xE2,0xD9),
          o2(0xDC,0xEC),      o2(0xE8,0xA2),
          o2(0xE6,0xF0),      o2(0xFD,0xF8),
          o2(0xFD,0xF9),      o2(0xF6,0xBF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_06 = {
    to_EUC_KR_E7_06_offsets,
    to_CP949_E7_06_infos
};


static const struct byte_lookup* const
to_CP949_E7_07_infos[20] = {
          o2(0xE7,0xA7),      o2(0xE6,0xD7),
          o2(0xD4,0xF3),      o2(0xD4,0xC9),
          o2(0xD6,0xFA),      o2(0xD7,0xF2),
          o2(0xE1,0xC0),      o2(0xDB,0xE2),
          o2(0xE6,0xD8),      o2(0xE7,0xBD),
          o2(0xF0,0xCF),      o2(0xF3,0xBE),
          o2(0xE2,0xAC),      o2(0xF5,0xB7),
          o2(0xE0,0xF0),      o2(0xFD,0xB8),
          o2(0xE3,0xE8),      o2(0xD4,0xA7),
          o2(0xE8,0xFC),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_07 = {
    to_EUC_KR_E7_07_offsets,
    to_CP949_E7_07_infos
};


static const struct byte_lookup* const
to_CP949_E7_08_infos[16] = {
          o2(0xFA,0xD2),      o2(0xF8,0xEF),
          o2(0xD6,0xD3),      o2(0xD5,0xB4),
          o2(0xF0,0xD0),      o2(0xF7,0xF0),
          o2(0xEE,0xB3),      o2(0xEA,0xBA),
          o2(0xEA,0xD3),      o2(0xED,0xC9),
          o2(0xDD,0xAB),      o2(0xE5,0xAC),
          o2(0xFD,0xA1),      o2(0xDF,0xD0),
          o2(0xEC,0xB3),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_08 = {
    to_EUC_KR_E7_08_offsets,
    to_CP949_E7_08_infos
};


static const struct byte_lookup* const
to_CP949_E7_09_infos[19] = {
          o2(0xDF,0xD1),      o2(0xED,0xED),
          o2(0xF8,0xB8),      o2(0xF7,0xFA),
          o2(0xF8,0xAB),      o2(0xF4,0xE0),
          o2(0xD4,0xBA),      o2(0xE4,0xB3),
          o2(0xE9,0xDA),      o2(0xDE,0xB6),
          o2(0xD9,0xBF),      o2(0xD9,0xC0),
          o2(0xD6,0xEF),      o2(0xD9,0xCC),
          o2(0xDA,0xAA),      o2(0xDF,0xE5),
          o2(0xF7,0xE5),      o2(0xCC,0xB2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_09 = {
    to_EUC_KR_E7_09_offsets,
    to_CP949_E7_09_infos
};


static const struct byte_lookup* const
to_CP949_E7_0A_infos[7] = {
          o2(0xDF,0xF9),      o2(0xD7,0xE0),
          o2(0xD4,0xBB),      o2(0xFD,0xFA),
          o2(0xCC,0xB3),      o2(0xDB,0xF3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_0A = {
    to_EUC_KR_E7_0A_offsets,
    to_CP949_E7_0A_infos
};


static const struct byte_lookup* const
to_CP949_E7_0B_infos[14] = {
          o2(0xDF,0xD2),      o2(0xCE,0xCA),
          o2(0xEE,0xDA),      o2(0xE4,0xE4),
          o2(0xFB,0xCF),      o2(0xCF,0xB7),
          o2(0xEE,0xC3),      o2(0xCE,0xEA),
          o2(0xE2,0xAD),      o2(0xD7,0xE1),
          o2(0xFA,0xF5),      o2(0xD5,0xC9),
          o2(0xF8,0xAC),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_0B = {
    to_EUC_KR_E7_0B_offsets,
    to_CP949_E7_0B_infos
};


static const struct byte_lookup* const
to_CP949_E7_0C_infos[14] = {
          o2(0xE7,0xD9),      o2(0xF3,0xE9),
          o2(0xD8,0xED),      o2(0xE3,0xC4),
          o2(0xF0,0xF1),      o2(0xE8,0xE5),
          o2(0xE0,0xFA),      o2(0xEE,0xC4),
          o2(0xD9,0xDE),      o2(0xEB,0xA2),
          o2(0xEB,0xA3),      o2(0xFC,0xC2),
          o2(0xEA,0xBB),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_0C = {
    to_EUC_KR_E7_0C_offsets,
    to_CP949_E7_0C_infos
};


static const struct byte_lookup* const
to_CP949_E7_0D_infos[14] = {
          o2(0xE8,0xAB),      o2(0xDE,0xE2),
          o2(0xED,0xEF),      o2(0xE8,0xA3),
          o2(0xCF,0xF1),      o2(0xD4,0xBC),
          o2(0xFC,0xEA),      o2(0xE7,0xBE),
          o2(0xFC,0xF2),      o2(0xD6,0xB4),
          o2(0xE2,0xAE),      o2(0xD3,0xB7),
          o2(0xFA,0xCC),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_0D = {
    to_EUC_KR_E7_0D_offsets,
    to_CP949_E7_0D_infos
};


static const struct byte_lookup* const
to_CP949_E7_0E_infos[18] = {
          o2(0xFA,0xDC),      o2(0xED,0xB5),
          o2(0xE1,0xE3),      o2(0xE8,0xAC),
          o2(0xE8,0xDD),      o2(0xEF,0xE9),
          o2(0xF4,0xBD),      o2(0xCF,0xB8),
          o2(0xE9,0xDB),      o2(0xD1,0xAC),
          o2(0xDA,0xC7),      o2(0xEB,0xC9),
          o2(0xE8,0xCC),      o2(0xDE,0xB7),
          o2(0xD6,0xBC),      o2(0xD3,0xE5),
          o2(0xFA,0xDD),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_0E = {
    to_EUC_KR_E7_0E_offsets,
    to_CP949_E7_0E_infos
};


static const struct byte_lookup* const
to_CP949_E7_0F_infos[24] = {
          o2(0xDA,0xD6),      o2(0xCA,0xB1),
          o2(0xDA,0xC8),      o2(0xDF,0xA6),
          o2(0xF9,0xB3),      o2(0xF2,0xD2),
          o2(0xCA,0xC4),      o2(0xCE,0xCB),
          o2(0xCD,0xF5),      o2(0xFD,0xB0),
          o2(0xD5,0xA8),      o2(0xF1,0xC1),
          o2(0xE2,0xE9),      o2(0xDC,0xCA),
          o2(0xEC,0xB4),      o2(0xFA,0xC0),
          o2(0xFB,0xA8),      o2(0xD0,0xA8),
          o2(0xDA,0xEC),      o2(0xD9,0xEE),
          o2(0xE0,0xFB),      o2(0xEF,0xEA),
          o2(0xFA,0xDE),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_0F = {
    to_EUC_KR_E7_0F_offsets,
    to_CP949_E7_0F_infos
};


static const struct byte_lookup* const
to_CP949_E7_10_infos[28] = {
          o2(0xE0,0xC4),      o2(0xCF,0xB9),
          o2(0xD5,0xCA),      o2(0xD7,0xE2),
          o2(0xE2,0xAF),      o2(0xD7,0xB8),
          o2(0xE8,0xCD),      o2(0xF6,0xDA),
          o2(0xEF,0xA2),      o2(0xE2,0xDA),
          o2(0xF6,0xFC),      o2(0xFB,0xD0),
          o2(0xD1,0xAD),      o2(0xCD,0xE4),
          o2(0xD1,0xAE),      o2(0xDC,0xED),
          o2(0xE8,0xCE),      o2(0xF0,0xF9),
          o2(0xCE,0xB5),      o2(0xE6,0xFC),
          o2(0xD7,0xFB),      o2(0xD0,0xD6),
          o2(0xDD,0xF5),      o2(0xF7,0xF1),
          o2(0xF6,0xFD),      o2(0xDB,0xF7),
          o2(0xFB,0xEA),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_10 = {
    to_EUC_KR_E7_10_offsets,
    to_CP949_E7_10_infos
};


static const struct byte_lookup* const
to_CP949_E7_11_infos[23] = {
          o2(0xE9,0xDC),      o2(0xD9,0xC1),
          o2(0xF5,0xF2),      o2(0xE0,0xC5),
          o2(0xEA,0xD4),      o2(0xF9,0xC2),
          o2(0xEA,0xBC),      o2(0xD2,0xC5),
          o2(0xFB,0xD1),      o2(0xE7,0xC0),
          o2(0xEB,0xA5),      o2(0xDF,0xFA),
          o2(0xE3,0xA2),      o2(0xD7,0xB9),
          o2(0xE9,0xC3),      o2(0xE8,0xFD),
          o2(0xE8,0xAF),      o2(0xF2,0xD3),
          o2(0xFB,0xA9),      o2(0xD8,0xA5),
          o2(0xD5,0xCB),      o2(0xD0,0xC8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_11 = {
    to_EUC_KR_E7_11_offsets,
    to_CP949_E7_11_infos
};


static const struct byte_lookup* const
to_CP949_E7_12_infos[22] = {
          o2(0xD1,0xAF),      o2(0xD7,0xE3),
          o2(0xE0,0xC6),      o2(0xD6,0xA2),
          o2(0xED,0xF0),      o2(0xD7,0xF3),
          o2(0xFC,0xD4),      o2(0xDA,0xD7),
          o2(0xCC,0xDF),      o2(0xF2,0xD4),
          o2(0xD1,0xB0),      o2(0xCC,0xE0),
          o2(0xDB,0xFD),      o2(0xF3,0xBF),
          o2(0xF0,0xD1),      o2(0xFC,0xBB),
          o2(0xE2,0xB0),      o2(0xE6,0xA5),
          o2(0xE2,0xDB),      o2(0xDF,0xDE),
          o2(0xE0,0xC7),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_12 = {
    to_EUC_KR_E7_12_offsets,
    to_CP949_E7_12_infos
};


static const struct byte_lookup* const
to_CP949_E7_13_infos[14] = {
          o2(0xF2,0xEF),      o2(0xCC,0xE1),
          o2(0xD6,0xEA),      o2(0xE7,0xC2),
          o2(0xCE,0xB6),      o2(0xF3,0xC0),
          o2(0xCD,0xFE),      o2(0xFB,0xD2),
          o2(0xF8,0xF8),      o2(0xF7,0xFB),
          o2(0xE8,0xBF),      o2(0xE8,0xB7),
          o2(0xED,0xB6),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_13 = {
    to_EUC_KR_E7_13_offsets,
    to_CP949_E7_13_infos
};


static const struct byte_lookup* const
to_CP949_E7_14_infos[22] = {
          o2(0xDC,0xBA),      o2(0xCC,0xB4),
          o2(0xF1,0xF7),      o2(0xE8,0xB8),
          o2(0xCA,0xF6),      o2(0xE4,0xA4),
          o2(0xF4,0xD6),      o2(0xDF,0xE6),
          o2(0xDF,0xA7),      o2(0xDF,0xE7),
          o2(0xE1,0xC1),      o2(0xE9,0xC4),
          o2(0xDC,0xCB),      o2(0xE9,0xC5),
          o2(0xEF,0xA3),      o2(0xEB,0xA6),
          o2(0xCB,0xA3),      o2(0xE3,0xE9),
          o2(0xD1,0xFB),      o2(0xEF,0xA4),
          o2(0xEF,0xEB),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_14 = {
    to_EUC_KR_E7_14_offsets,
    to_CP949_E7_14_infos
};


static const struct byte_lookup* const
to_CP949_E7_15_infos[22] = {
          o2(0xD0,0xB4),      o2(0xCD,0xA3),
          o2(0xE8,0xE6),      o2(0xEF,0xA5),
          o2(0xD3,0xCC),      o2(0xDA,0xED),
          o2(0xD7,0xBA),      o2(0xF2,0xD5),
          o2(0xF5,0xE5),      o2(0xD9,0xEF),
          o2(0xF9,0xB4),      o2(0xD5,0xD4),
          o2(0xFD,0xCF),      o2(0xDB,0xE3),
          o2(0xF1,0xE1),      o2(0xEC,0xB6),
          o2(0xFB,0xFE),      o2(0xD3,0xD7),
          o2(0xD1,0xB1),      o2(0xCB,0xB1),
          o2(0xD1,0xB2),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_15 = {
    to_EUC_KR_E7_15_offsets,
    to_CP949_E7_15_infos
};


static const struct byte_lookup* const
to_CP949_E7_16_infos[20] = {
          o2(0xCB,0xB2),      o2(0xF1,0xC2),
          o2(0xF4,0xE1),      o2(0xF9,0xB5),
          o2(0xE1,0xC3),      o2(0xE1,0xC2),
          o2(0xEB,0xF7),      o2(0xDF,0xA8),
          o2(0xCB,0xCA),      o2(0xE6,0xB9),
          o2(0xF8,0xDE),      o2(0xF9,0xAA),
          o2(0xCA,0xF7),      o2(0xED,0xB7),
          o2(0xD3,0xB8),      o2(0xF2,0xD6),
          o2(0xD4,0xD9),      o2(0xEE,0xC5),
          o2(0xF2,0xF0),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_16 = {
    to_EUC_KR_E7_16_offsets,
    to_CP949_E7_16_infos
};


static const struct byte_lookup* const
to_CP949_E7_17_infos[17] = {
          o2(0xCA,0xB2),      o2(0xDC,0xBB),
          o2(0xF1,0xF8),      o2(0xEC,0xB7),
          o2(0xE5,0xCA),      o2(0xF6,0xC0),
          o2(0xFD,0xDD),      o2(0xD4,0xE3),
          o2(0xCC,0xE2),      o2(0xF7,0xD4),
          o2(0xD7,0xE5),      o2(0xD3,0xC3),
          o2(0xD8,0xA6),      o2(0xF6,0xC1),
          o2(0xDD,0xF6),      o2(0xCD,0xC0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_17 = {
    to_EUC_KR_E7_17_offsets,
    to_CP949_E7_17_infos
};


static const struct byte_lookup* const
to_CP949_E7_18_infos[11] = {
          o2(0xE5,0xDC),      o2(0xE5,0xCB),
          o2(0xE1,0xC4),      o2(0xE8,0xB0),
          o2(0xF4,0xB0),      o2(0xF3,0xEA),
          o2(0xDA,0xEE),      o2(0xD7,0xBB),
          o2(0xE2,0xB1),      o2(0xD7,0xAA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_18 = {
    to_EUC_KR_E7_18_offsets,
    to_CP949_E7_18_infos
};


static const struct byte_lookup* const
to_CP949_E7_19_infos[17] = {
          o2(0xD6,0xFB),      o2(0xE4,0xDF),
          o2(0xCA,0xD6),      o2(0xEB,0xA8),
          o2(0xDB,0xFE),      o2(0xF6,0xC2),
          o2(0xEF,0xBB),      o2(0xD4,0xFD),
          o2(0xE0,0xC8),      o2(0xE8,0xB9),
          o2(0xEF,0xA6),      o2(0xCD,0xA4),
          o2(0xD4,0xF4),      o2(0xDB,0xA1),
          o2(0xDB,0xDC),      o2(0xDB,0xDD),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_19 = {
    to_EUC_KR_E7_19_offsets,
    to_CP949_E7_19_infos
};


static const struct byte_lookup* const
to_CP949_E7_1A_infos[10] = {
          o2(0xEE,0xDC),      o2(0xCB,0xCB),
          o2(0xFC,0xD5),      o2(0xCE,0xEB),
          o2(0xCD,0xC1),      o2(0xFB,0xD3),
          o2(0xF9,0xAB),      o2(0xF5,0xD4),
          o2(0xD9,0xA9),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_1A = {
    to_EUC_KR_E7_1A_offsets,
    to_CP949_E7_1A_infos
};


static const struct byte_lookup* const
to_CP949_E7_1B_infos[22] = {
          o2(0xE9,0xDD),      o2(0xDB,0xCD),
          o2(0xDD,0xCE),      o2(0xE7,0xC3),
          o2(0xEC,0xCC),      o2(0xF9,0xEC),
          o2(0xCB,0xCC),      o2(0xE0,0xFC),
          o2(0xD4,0xA8),      o2(0xED,0xD3),
          o2(0xD8,0xEF),      o2(0xF2,0xD7),
          o2(0xCA,0xF8),      o2(0xDA,0xEF),
          o2(0xD6,0xD4),      o2(0xD9,0xCD),
          o2(0xD8,0xEE),      o2(0xF2,0xC1),
          o2(0xDF,0xD3),      o2(0xDA,0xF0),
          o2(0xE2,0xEA),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_1B = {
    to_EUC_KR_E7_1B_offsets,
    to_CP949_E7_1B_infos
};


static const struct byte_lookup* const
to_CP949_E7_1C_infos[13] = {
          o2(0xE0,0xFD),      o2(0xD8,0xF8),
          o2(0xF7,0xAF),      o2(0xDA,0xB6),
          o2(0xCA,0xD7),      o2(0xF2,0xD8),
          o2(0xD8,0xF9),      o2(0xFA,0xDF),
          o2(0xCF,0xEF),      o2(0xD9,0xC2),
          o2(0xF0,0xD2),      o2(0xE4,0xD1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_1C = {
    to_EUC_KR_E7_1C_offsets,
    to_CP949_E7_1C_infos
};


static const struct byte_lookup* const
to_CP949_E7_1D_infos[11] = {
          o2(0xF3,0xB7),      o2(0xFA,0xE0),
          o2(0xEF,0xEC),      o2(0xE2,0xB2),
          o2(0xD4,0xBD),      o2(0xD9,0xCE),
          o2(0xF4,0xE2),      o2(0xD4,0xA9),
          o2(0xCD,0xC2),      o2(0xE7,0xDA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_1D = {
    to_EUC_KR_E7_1D_offsets,
    to_CP949_E7_1D_infos
};


static const struct byte_lookup* const
to_CP949_E7_1E_infos[12] = {
          o2(0xF2,0xD9),      o2(0xD9,0xAA),
          o2(0xD8,0xBE),      o2(0xDC,0xAD),
          o2(0xE2,0xEB),      o2(0xD6,0xFC),
          o2(0xCA,0xF9),      o2(0xD4,0xDA),
          o2(0xF4,0xD7),      o2(0xCC,0xA1),
          o2(0xCF,0xBA),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_1E = {
    to_EUC_KR_E7_1E_offsets,
    to_CP949_E7_1E_infos
};


static const struct byte_lookup* const
to_CP949_E7_1F_infos[12] = {
          o2(0xF5,0xB8),      o2(0xD9,0xC3),
          o2(0xD0,0xE8),      o2(0xE3,0xC5),
          o2(0xEB,0xF8),      o2(0xF2,0xB1),
          o2(0xCF,0xBB),      o2(0xD3,0xAD),
          o2(0xE8,0xE1),      o2(0xCE,0xEC),
          o2(0xE0,0xB4),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_1F = {
    to_EUC_KR_E7_1F_offsets,
    to_CP949_E7_1F_infos
};


static const struct byte_lookup* const
to_CP949_E7_20_infos[9] = {
          o2(0xDE,0xE3),      o2(0xDD,0xF7),
          o2(0xF2,0xB2),      o2(0xF3,0xF6),
          o2(0xF6,0xDB),      o2(0xD7,0xFE),
          o2(0xF8,0xDF),      o2(0xF7,0xF2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_20 = {
    to_EUC_KR_E7_20_offsets,
    to_CP949_E7_20_infos
};


static const struct byte_lookup* const
to_CP949_E7_21_infos[8] = {
          o2(0xD0,0xA9),      o2(0xE6,0xDA),
          o2(0xF5,0xA6),      o2(0xD7,0xBC),
          o2(0xCC,0xE3),      o2(0xE6,0xDB),
          o2(0xDD,0xDD),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_21 = {
    to_EUC_KR_E7_21_offsets,
    to_CP949_E7_21_infos
};


static const struct byte_lookup* const
to_CP949_E7_22_infos[14] = {
          o2(0xD1,0xB3),      o2(0xEF,0xED),
          o2(0xD6,0xDE),      o2(0xE4,0xF4),
          o2(0xE1,0xEF),      o2(0xDD,0xF8),
          o2(0xE8,0xCF),      o2(0xCA,0xE5),
          o2(0xDC,0xA1),      o2(0xE0,0xB5),
          o2(0xFC,0xAC),      o2(0xFC,0xAD),
          o2(0xD8,0xA7),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_22 = {
    to_EUC_KR_E7_22_offsets,
    to_CP949_E7_22_infos
};


static const struct byte_lookup* const
to_CP949_E7_23_infos[12] = {
          o2(0xED,0xB8),      o2(0xDB,0xB6),
          o2(0xD6,0xF0),      o2(0xF3,0xAF),
          o2(0xCD,0xA5),      o2(0xDA,0xF1),
          o2(0xD8,0xA8),      o2(0xCC,0xE4),
          o2(0xD1,0xB4),      o2(0xCA,0xD8),
          o2(0xDA,0xF2),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_23 = {
    to_EUC_KR_E7_23_offsets,
    to_CP949_E7_23_infos
};


static const struct byte_lookup* const
to_CP949_E7_24_infos[9] = {
          o2(0xF5,0xA7),      o2(0xF5,0xA8),
          o2(0xE6,0xA6),      o2(0xD5,0xEC),
          o2(0xD5,0xF8),      o2(0xDA,0xF3),
          o2(0xE3,0xC6),      o2(0xDE,0xE4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_24 = {
    to_EUC_KR_E7_24_offsets,
    to_CP949_E7_24_infos
};


static const struct byte_lookup* const
to_CP949_E7_25_infos[20] = {
          o2(0xDE,0xE5),      o2(0xD1,0xB5),
          o2(0xD1,0xB6),      o2(0xD1,0xB7),
          o2(0xF2,0xB3),      o2(0xE9,0xDE),
          o2(0xF0,0xD3),      o2(0xF2,0xB4),
          o2(0xF0,0xD4),      o2(0xCB,0xE4),
          o2(0xFB,0xD4),      o2(0xF5,0xE6),
          o2(0xE3,0xEA),      o2(0xDE,0xE6),
          o2(0xDF,0xD4),      o2(0xF8,0xF9),
          o2(0xF0,0xAE),      o2(0xD1,0xB8),
          o2(0xD6,0xDF),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_25 = {
    to_EUC_KR_E7_25_offsets,
    to_CP949_E7_25_infos
};


static const struct byte_lookup* const
to_CP949_E7_26_infos[16] = {
          o2(0xD0,0xD7),      o2(0xFC,0xA1),
          o2(0xEF,0xEE),      o2(0xDC,0xD8),
          o2(0xE9,0xDF),      o2(0xE5,0xDD),
          o2(0xFD,0xFB),      o2(0xE0,0xC9),
          o2(0xD6,0xC9),      o2(0xD4,0xAA),
          o2(0xE5,0xCC),      o2(0xE9,0xE0),
          o2(0xD0,0xD8),      o2(0xFC,0xA2),
          o2(0xD4,0xBE),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_26 = {
    to_EUC_KR_E7_26_offsets,
    to_CP949_E7_26_infos
};


static const struct byte_lookup* const
to_CP949_E7_27_infos[16] = {
          o2(0xE2,0xB3),      o2(0xDE,0xE7),
          o2(0xDC,0xBC),      o2(0xD2,0xB6),
          o2(0xF5,0xD5),      o2(0xCE,0xA1),
          o2(0xF5,0xA9),      o2(0xDD,0xF9),
          o2(0xDD,0xFA),      o2(0xF0,0xD5),
          o2(0xF6,0xDF),      o2(0xF2,0xDA),
          o2(0xE4,0xEB),      o2(0xF2,0xF1),
          o2(0xEC,0xB9),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_27 = {
    to_EUC_KR_E7_27_offsets,
    to_CP949_E7_27_infos
};


static const struct byte_lookup* const
to_CP949_E7_28_infos[21] = {
          o2(0xFD,0xFC),      o2(0xE1,0xAA),
          o2(0xCA,0xD9),      o2(0xEF,0xEF),
          o2(0xF5,0xAA),      o2(0xEC,0xF9),
          o2(0xF8,0xAD),      o2(0xF2,0xC2),
          o2(0xF6,0xC3),      o2(0xD7,0xD2),
          o2(0xF9,0xA2),      o2(0xF0,0xD6),
          o2(0xF0,0xFA),      o2(0xF6,0xE0),
          o2(0xE9,0xF3),      o2(0xF2,0xC3),
          o2(0xD4,0xAB),      o2(0xCA,0xB3),
          o2(0xCD,0xA6),      o2(0xCD,0xC3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_28 = {
    to_EUC_KR_E7_28_offsets,
    to_CP949_E7_28_infos
};


static const struct byte_lookup* const
to_CP949_E7_29_infos[18] = {
          o2(0xCD,0xDA),      o2(0xD9,0xCF),
          o2(0xF6,0xC4),      o2(0xEE,0xDD),
          o2(0xE7,0xC4),      o2(0xE2,0xB4),
          o2(0xDF,0xE2),      o2(0xE7,0xDB),
          o2(0xE8,0xB1),      o2(0xFC,0xAE),
          o2(0xE5,0xCD),      o2(0xFA,0xEB),
          o2(0xCF,0xBC),      o2(0xCF,0xE2),
          o2(0xCD,0xF6),      o2(0xEF,0xF0),
          o2(0xF4,0xBE),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_29 = {
    to_EUC_KR_E7_29_offsets,
    to_CP949_E7_29_infos
};


static const struct byte_lookup* const
to_CP949_E7_2A_infos[14] = {
          o2(0xD4,0xCD),      o2(0xF3,0xB8),
          o2(0xE9,0xA1),      o2(0xF2,0xF2),
          o2(0xF3,0xEB),      o2(0xF0,0xD7),
          o2(0xCF,0xD7),      o2(0xCF,0xDF),
          o2(0xE8,0xC0),      o2(0xE8,0xC1),
          o2(0xCF,0xE3),      o2(0xE9,0xA2),
          o2(0xD0,0xAA),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_2A = {
    to_EUC_KR_E7_2A_offsets,
    to_CP949_E7_2A_infos
};


static const struct byte_lookup* const
to_CP949_E7_2B_infos[20] = {
          o2(0xF3,0xC1),      o2(0xD0,0xAB),
          o2(0xD4,0xE4),      o2(0xEF,0xBC),
          o2(0xD8,0xA1),      o2(0xD9,0xDF),
          o2(0xF3,0xD7),      o2(0xDC,0xBD),
          o2(0xCC,0xE5),      o2(0xED,0xF1),
          o2(0xF1,0xE2),      o2(0xD4,0xDB),
          o2(0xE2,0xB5),      o2(0xCA,0xE6),
          o2(0xD3,0xAE),      o2(0xCC,0xE6),
          o2(0xF1,0xD3),      o2(0xF5,0xE7),
          o2(0xCA,0xDA),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_2B = {
    to_EUC_KR_E7_2B_offsets,
    to_CP949_E7_2B_infos
};


static const struct byte_lookup* const
to_CP949_E7_2C_infos[11] = {
          o2(0xFB,0xEE),      o2(0xE1,0xC5),
          o2(0xDF,0xE9),      o2(0xEE,0xDE),
          o2(0xF7,0xC2),      o2(0xD8,0xA2),
          o2(0xDD,0xAC),      o2(0xF0,0xAF),
          o2(0xD6,0xBD),      o2(0xE1,0xAB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_2C = {
    to_EUC_KR_E7_2C_offsets,
    to_CP949_E7_2C_infos
};


static const struct byte_lookup* const
to_CP949_E7_2D_infos[17] = {
          o2(0xF9,0xB6),      o2(0xD4,0xF5),
          o2(0xD0,0xC9),      o2(0xEF,0xA7),
          o2(0xE2,0xEC),      o2(0xDB,0xEA),
          o2(0xCE,0xCC),      o2(0xF5,0xE8),
          o2(0xF7,0xD5),      o2(0xD3,0xCD),
          o2(0xF3,0xFE),      o2(0xD0,0xB5),
          o2(0xE0,0xFE),      o2(0xDF,0xFB),
          o2(0xE6,0xDD),      o2(0xE8,0xA4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_2D = {
    to_EUC_KR_E7_2D_offsets,
    to_CP949_E7_2D_infos
};


static const struct byte_lookup* const
to_CP949_E7_2E_infos[14] = {
          o2(0xCB,0xCD),      o2(0xEF,0xA8),
          o2(0xEE,0xB4),      o2(0xDA,0xD8),
          o2(0xD1,0xB9),      o2(0xDF,0xA9),
          o2(0xF3,0xB0),      o2(0xCC,0xC4),
          o2(0xCE,0xB7),      o2(0xEF,0xA9),
          o2(0xDF,0xD5),      o2(0xED,0xD7),
          o2(0xEE,0xC6),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_2E = {
    to_EUC_KR_E7_2E_offsets,
    to_CP949_E7_2E_infos
};


static const struct byte_lookup* const
to_CP949_E7_2F_infos[11] = {
          o2(0xEF,0xBD),      o2(0xFC,0xD6),
          o2(0xDB,0xF4),      o2(0xEF,0xAA),
          o2(0xF8,0xB9),      o2(0xF5,0xE9),
          o2(0xE3,0xD9),      o2(0xE1,0xC6),
          o2(0xD4,0xBF),      o2(0xDE,0xE8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_2F = {
    to_EUC_KR_E7_2F_offsets,
    to_CP949_E7_2F_infos
};


static const struct byte_lookup* const
to_CP949_E7_30_infos[11] = {
          o2(0xF0,0xEA),      o2(0xF3,0xC2),
          o2(0xD3,0xAF),      o2(0xCA,0xDB),
          o2(0xFC,0xD7),      o2(0xED,0xD8),
          o2(0xE1,0xC7),      o2(0xF4,0xD8),
          o2(0xD6,0xB3),      o2(0xDD,0xAD),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_30 = {
    to_EUC_KR_E7_30_offsets,
    to_CP949_E7_30_infos
};


static const struct byte_lookup* const
to_CP949_E7_31_infos[8] = {
          o2(0xD5,0xBE),      o2(0xF1,0xC3),
          o2(0xEE,0xDF),      o2(0xD6,0xEB),
          o2(0xF4,0xD9),      o2(0xD7,0xE6),
          o2(0xDA,0xB7),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_31 = {
    to_EUC_KR_E7_31_offsets,
    to_CP949_E7_31_infos
};


static const struct byte_lookup* const
to_CP949_E7_32_infos[16] = {
          o2(0xDD,0xFB),      o2(0xDD,0xCF),
          o2(0xD8,0xA3),      o2(0xDA,0xD9),
          o2(0xF0,0xD8),      o2(0xEF,0xC4),
          o2(0xE1,0xD8),      o2(0xF1,0xD4),
          o2(0xED,0xF2),      o2(0xD5,0xDB),
          o2(0xD5,0xDC),      o2(0xF3,0xC4),
          o2(0xCB,0xD7),      o2(0xE2,0xB6),
          o2(0xEF,0xF1),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_32 = {
    to_EUC_KR_E7_32_offsets,
    to_CP949_E7_32_infos
};


static const struct byte_lookup* const
to_CP949_E7_33_infos[9] = {
          o2(0xFB,0xD5),      o2(0xD3,0xD8),
          o2(0xDD,0xD0),      o2(0xF0,0xD9),
          o2(0xCB,0xB3),      o2(0xD5,0xDD),
          o2(0xCD,0xA7),      o2(0xD0,0xAC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_33 = {
    to_EUC_KR_E7_33_offsets,
    to_CP949_E7_33_infos
};


static const struct byte_lookup* const
to_CP949_E7_34_infos[30] = {
          o2(0xD1,0xBA),      o2(0xF1,0xC4),
          o2(0xE5,0xB3),      o2(0xFB,0xF5),
          o2(0xE9,0xE1),      o2(0xFD,0xE0),
          o2(0xFC,0xBC),      o2(0xDA,0xA2),
          o2(0xDA,0xA3),      o2(0xD2,0xA1),
          o2(0xD2,0xEF),      o2(0xE2,0xED),
          o2(0xDE,0xE9),      o2(0xCE,0xDC),
          o2(0xF2,0xB5),      o2(0xD0,0xE4),
          o2(0xDD,0xD1),      o2(0xE1,0xC8),
          o2(0xDB,0xB7),      o2(0xDF,0xE3),
          o2(0xED,0xB9),      o2(0xF1,0xC5),
          o2(0xF3,0xCF),      o2(0xD7,0xAB),
          o2(0xE1,0xAC),      o2(0xE3,0xEB),
          o2(0xEE,0xC7),      o2(0xE1,0xC9),
          o2(0xCA,0xFA),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_34 = {
    to_EUC_KR_E7_34_offsets,
    to_CP949_E7_34_infos
};


static const struct byte_lookup* const
to_CP949_E7_35_infos[20] = {
          o2(0xF0,0xFB),      o2(0xFA,0xE1),
          o2(0xF0,0xDA),      o2(0xCC,0xE7),
          o2(0xDA,0xF4),      o2(0xCC,0xBF),
          o2(0xCE,0xED),      o2(0xD5,0xA9),
          o2(0xFA,0xE2),      o2(0xD0,0xE5),
          o2(0xEB,0xD6),      o2(0xEC,0xDF),
          o2(0xDF,0xFC),      o2(0xF7,0xD6),
          o2(0xDE,0xEA),      o2(0xCB,0xB4),
          o2(0xEF,0xBE),      o2(0xCC,0xB5),
          o2(0xCF,0xBD),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_35 = {
    to_EUC_KR_E7_35_offsets,
    to_CP949_E7_35_infos
};


static const struct byte_lookup* const
to_CP949_E7_36_infos[19] = {
          o2(0xEF,0xF2),      o2(0xE2,0xB7),
          o2(0xCC,0xE8),      o2(0xF0,0xFC),
          o2(0xD6,0xE0),      o2(0xF1,0xC6),
          o2(0xE2,0xB8),      o2(0xEB,0xAB),
          o2(0xCB,0xB5),      o2(0xD8,0xD1),
          o2(0xF4,0xCE),      o2(0xF3,0xF7),
          o2(0xD7,0xC6),      o2(0xD1,0xBB),
          o2(0xF7,0xAA),      o2(0xED,0xCA),
          o2(0xD7,0xD3),      o2(0xD8,0xFA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_36 = {
    to_EUC_KR_E7_36_offsets,
    to_CP949_E7_36_infos
};


static const struct byte_lookup* const
to_CP949_E7_37_infos[18] = {
          o2(0xF6,0xC5),      o2(0xD1,0xCC),
          o2(0xDD,0xFC),      o2(0xDF,0xFD),
          o2(0xF9,0xE5),      o2(0xE0,0xCA),
          o2(0xF2,0xFD),      o2(0xD3,0xB0),
          o2(0xF4,0xF3),      o2(0xDA,0xC9),
          o2(0xE6,0xDE),      o2(0xF8,0xBA),
          o2(0xE8,0xD0),      o2(0xD8,0xFB),
          o2(0xEA,0xD5),      o2(0xD6,0xA3),
          o2(0xF6,0xC6),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_37 = {
    to_EUC_KR_E7_37_offsets,
    to_CP949_E7_37_infos
};


static const struct byte_lookup* const
to_CP949_E7_38_infos[17] = {
          o2(0xF2,0xDB),      o2(0xE4,0xFC),
          o2(0xE8,0xB2),      o2(0xDA,0xDA),
          o2(0xF2,0xDC),      o2(0xFB,0xD6),
          o2(0xE9,0xB2),      o2(0xEE,0xAD),
          o2(0xFA,0xE3),      o2(0xDC,0xEE),
          o2(0xF5,0xEA),      o2(0xE6,0xE0),
          o2(0xF0,0xFD),      o2(0xD7,0xAC),
          o2(0xF5,0xC5),      o2(0xEE,0xE0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_38 = {
    to_EUC_KR_E7_38_offsets,
    to_CP949_E7_38_infos
};


static const struct byte_lookup* const
to_CP949_E7_39_infos[17] = {
          o2(0xDB,0xE5),      o2(0xDD,0xDE),
          o2(0xD9,0xF0),      o2(0xE9,0xA3),
          o2(0xF1,0xF9),      o2(0xF2,0xC4),
          o2(0xE0,0xCB),      o2(0xE9,0xA4),
          o2(0xE2,0xB9),      o2(0xE3,0xB1),
          o2(0xFC,0xEB),      o2(0xCD,0xA8),
          o2(0xCC,0xB6),      o2(0xF0,0xDB),
          o2(0xE6,0xBA),      o2(0xCD,0xA9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_39 = {
    to_EUC_KR_E7_39_offsets,
    to_CP949_E7_39_infos
};


static const struct byte_lookup* const
to_CP949_E7_3A_infos[9] = {
          o2(0xF3,0xC3),      o2(0xE1,0xD9),
          o2(0xEF,0xAB),      o2(0xE7,0xC5),
          o2(0xE0,0xE9),      o2(0xF3,0xC5),
          o2(0xD4,0xC0),      o2(0xD5,0xBF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_3A = {
    to_EUC_KR_E7_3A_offsets,
    to_CP949_E7_3A_infos
};


static const struct byte_lookup* const
to_CP949_E7_3C_infos[4] = {
          o2(0xDD,0xAE),      o2(0xF9,0xFC),
          o2(0xCC,0xC0),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_3C = {
    to_EUC_KR_E7_3C_offsets,
    to_CP949_E7_3C_infos
};


static const struct byte_lookup* const
to_CP949_E7_3D_infos[13] = {
          o2(0xE5,0xA2),      o2(0xCE,0xB8),
          o2(0xD8,0xD2),      o2(0xF9,0xD6),
          o2(0xF1,0xAA),      o2(0xCE,0xD1),
          o2(0xF6,0xC7),      o2(0xDB,0xEB),
          o2(0xDF,0xFE),      o2(0xD8,0xE1),
          o2(0xF7,0xF3),      o2(0xD7,0xE7),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_3D = {
    to_EUC_KR_E7_3D_offsets,
    to_CP949_E7_3D_infos
};


static const struct byte_lookup* const
to_CP949_E7_3E_infos[16] = {
          o2(0xD4,0xFE),      o2(0xD1,0xBC),
          o2(0xE5,0xCF),      o2(0xCB,0xB6),
          o2(0xDA,0xB8),      o2(0xCD,0xC4),
          o2(0xD6,0xBE),      o2(0xE2,0xBA),
          o2(0xCF,0xD8),      o2(0xE0,0xCC),
          o2(0xEB,0xF9),      o2(0xFD,0xFD),
          o2(0xD7,0xE8),      o2(0xCB,0xD8),
          o2(0xE9,0xE2),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_3E = {
    to_EUC_KR_E7_3E_offsets,
    to_CP949_E7_3E_infos
};


static const struct byte_lookup* const
to_CP949_E7_3F_infos[17] = {
          o2(0xE8,0xBA),      o2(0xE3,0xC7),
          o2(0xEC,0xCD),      o2(0xEC,0xCE),
          o2(0xD6,0xBF),      o2(0xE3,0xA7),
          o2(0xDF,0xD6),      o2(0xFD,0xE8),
          o2(0xEE,0xE1),      o2(0xF6,0xA8),
          o2(0xDD,0xFD),      o2(0xF8,0xBB),
          o2(0xE8,0xD1),      o2(0xF9,0xD7),
          o2(0xCE,0xEE),      o2(0xEC,0xCF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7_3F = {
    to_EUC_KR_E7_3F_offsets,
    to_CP949_E7_3F_infos
};


static const struct byte_lookup* const
to_CP949_E7_infos[64] = {
        &to_CP949_E7_00,    &to_CP949_E7_01,
        &to_CP949_E7_02,    &to_CP949_E7_03,
        &to_CP949_E7_04,    &to_CP949_E7_05,
        &to_CP949_E7_06,    &to_CP949_E7_07,
        &to_CP949_E7_08,    &to_CP949_E7_09,
        &to_CP949_E7_0A,    &to_CP949_E7_0B,
        &to_CP949_E7_0C,    &to_CP949_E7_0D,
        &to_CP949_E7_0E,    &to_CP949_E7_0F,
        &to_CP949_E7_10,    &to_CP949_E7_11,
        &to_CP949_E7_12,    &to_CP949_E7_13,
        &to_CP949_E7_14,    &to_CP949_E7_15,
        &to_CP949_E7_16,    &to_CP949_E7_17,
        &to_CP949_E7_18,    &to_CP949_E7_19,
        &to_CP949_E7_1A,    &to_CP949_E7_1B,
        &to_CP949_E7_1C,    &to_CP949_E7_1D,
        &to_CP949_E7_1E,    &to_CP949_E7_1F,
        &to_CP949_E7_20,    &to_CP949_E7_21,
        &to_CP949_E7_22,    &to_CP949_E7_23,
        &to_CP949_E7_24,    &to_CP949_E7_25,
        &to_CP949_E7_26,    &to_CP949_E7_27,
        &to_CP949_E7_28,    &to_CP949_E7_29,
        &to_CP949_E7_2A,    &to_CP949_E7_2B,
        &to_CP949_E7_2C,    &to_CP949_E7_2D,
        &to_CP949_E7_2E,    &to_CP949_E7_2F,
        &to_CP949_E7_30,    &to_CP949_E7_31,
        &to_CP949_E7_32,    &to_CP949_E7_33,
        &to_CP949_E7_34,    &to_CP949_E7_35,
        &to_CP949_E7_36,    &to_CP949_E7_37,
        &to_CP949_E7_38,    &to_CP949_E7_39,
        &to_CP949_E7_3A,    &to_CP949_E7_3C,
        &to_CP949_E7_3D,    &to_CP949_E7_3E,
        &to_CP949_E7_3F,              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E7 = {
    to_EUC_KR_E7_offsets,
    to_CP949_E7_infos
};


static const struct byte_lookup* const
to_CP949_E8_00_infos[17] = {
          o2(0xE9,0xA5),      o2(0xD6,0xD5),
          o2(0xCD,0xC5),      o2(0xED,0xBA),
          o2(0xD1,0xBD),      o2(0xCF,0xBE),
          o2(0xEC,0xBB),      o2(0xD2,0xB1),
          o2(0xCC,0xE9),      o2(0xD9,0xC4),
          o2(0xE9,0xFC),      o2(0xD1,0xBE),
          o2(0xEC,0xBC),      o2(0xE5,0xAD),
          o2(0xF7,0xB0),      o2(0xCC,0xEA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_00 = {
    to_EUC_KR_E8_00_offsets,
    to_CP949_E8_00_infos
};


static const struct byte_lookup* const
to_CP949_E8_01_infos[16] = {
          o2(0xD3,0xC4),      o2(0xD6,0xC0),
          o2(0xD6,0xFD),      o2(0xE1,0xA1),
          o2(0xDE,0xBD),      o2(0xF6,0xA9),
          o2(0xDA,0xA4),      o2(0xD6,0xA4),
          o2(0xF5,0xC6),      o2(0xE1,0xA2),
          o2(0xE9,0xC6),      o2(0xF2,0xC5),
          o2(0xF4,0xE9),      o2(0xD6,0xEC),
          o2(0xEB,0xD3),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_01 = {
    to_EUC_KR_E8_01_offsets,
    to_CP949_E8_01_infos
};


static const struct byte_lookup* const
to_CP949_E8_02_infos[21] = {
          o2(0xEC,0xBD),      o2(0xE2,0xDC),
          o2(0xDE,0xEB),      o2(0xF0,0xDC),
          o2(0xEB,0xBF),      o2(0xD7,0xCE),
          o2(0xD1,0xBF),      o2(0xF5,0xAB),
          o2(0xF9,0xFD),      o2(0xCA,0xDC),
          o2(0xCD,0xC6),      o2(0xF2,0xB6),
          o2(0xDD,0xFE),      o2(0xCC,0xB7),
          o2(0xDB,0xB8),      o2(0xD0,0xE9),
          o2(0xCE,0xDD),      o2(0xEB,0xC0),
          o2(0xFD,0xA2),      o2(0xF8,0xCB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_02 = {
    to_EUC_KR_E8_02_offsets,
    to_CP949_E8_02_infos
};


static const struct byte_lookup* const
to_CP949_E8_03_infos[15] = {
          o2(0xEA,0xD6),      o2(0xF1,0xB0),
          o2(0xDB,0xCE),      o2(0xF7,0xC3),
          o2(0xDB,0xCF),      o2(0xCB,0xA4),
          o2(0xF8,0xE0),      o2(0xFB,0xD7),
          o2(0xEB,0xCA),      o2(0xE0,0xA1),
          o2(0xCE,0xCD),      o2(0xD4,0xDC),
          o2(0xFD,0xD8),      o2(0xD2,0xF6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_03 = {
    to_EUC_KR_E8_03_offsets,
    to_CP949_E8_03_infos
};


static const struct byte_lookup* const
to_CP949_E8_04_infos[16] = {
          o2(0xF2,0xB7),      o2(0xFA,0xF6),
          o2(0xF6,0xAA),      o2(0xFA,0xF7),
          o2(0xD8,0xE6),      o2(0xF4,0xB1),
          o2(0xE8,0xD2),      o2(0xCA,0xC5),
          o2(0xCC,0xEB),      o2(0xE2,0xEE),
          o2(0xE2,0xBB),      o2(0xF7,0xAD),
          o2(0xF8,0xE1),      o2(0xF3,0xEC),
          o2(0xDE,0xA1),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_04 = {
    to_EUC_KR_E8_04_offsets,
    to_CP949_E8_04_infos
};


static const struct byte_lookup* const
to_CP949_E8_05_infos[16] = {
          o2(0xE4,0xFD),      o2(0xE3,0xEC),
          o2(0xDD,0xAF),      o2(0xDD,0xB0),
          o2(0xCB,0xB7),      o2(0xE8,0xD3),
          o2(0xE1,0xA3),      o2(0xD2,0xE0),
          o2(0xF0,0xFE),      o2(0xE9,0xA6),
          o2(0xCB,0xF2),      o2(0xED,0xF3),
          o2(0xDC,0xD9),      o2(0xE0,0xCD),
          o2(0xF7,0xDA),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_05 = {
    to_EUC_KR_E8_05_offsets,
    to_CP949_E8_05_infos
};


static const struct byte_lookup* const
to_CP949_E8_06_infos[17] = {
          o2(0xDB,0xB9),      o2(0xCC,0xAE),
          o2(0xDA,0xDB),      o2(0xCD,0xC7),
          o2(0xDD,0xB1),      o2(0xD8,0xAF),
          o2(0xE3,0xA3),      o2(0xCE,0xEF),
          o2(0xF2,0xF3),      o2(0xF8,0xB3),
          o2(0xE0,0xCE),      o2(0xF5,0xFD),
          o2(0xEB,0xEC),      o2(0xD3,0xC5),
          o2(0xFC,0xEC),      o2(0xD2,0xDB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_06 = {
    to_EUC_KR_E8_06_offsets,
    to_CP949_E8_06_infos
};


static const struct byte_lookup* const
to_CP949_E8_07_infos[19] = {
          o2(0xD4,0xEB),      o2(0xDE,0xA2),
          o2(0xE5,0xE6),      o2(0xF0,0xB0),
          o2(0xD5,0xC4),      o2(0xED,0xF4),
          o2(0xE3,0xED),      o2(0xE8,0xC2),
          o2(0xED,0xF5),      o2(0xD7,0xFC),
          o2(0xED,0xBB),      o2(0xF6,0xAB),
          o2(0xF2,0xB8),      o2(0xF6,0xC8),
          o2(0xD3,0xE6),      o2(0xF2,0xDD),
          o2(0xCF,0xBF),      o2(0xEB,0xAC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_07 = {
    to_EUC_KR_E8_07_offsets,
    to_CP949_E8_07_infos
};


static const struct byte_lookup* const
to_CP949_E8_08_infos[20] = {
          o2(0xCF,0xC0),      o2(0xE6,0xA8),
          o2(0xFD,0xE9),      o2(0xCF,0xC1),
          o2(0xE0,0xDF),      o2(0xDE,0xEC),
          o2(0xE0,0xA2),      o2(0xF4,0xBF),
          o2(0xE2,0xEF),      o2(0xD9,0xF1),
          o2(0xF1,0xC7),      o2(0xCB,0xB8),
          o2(0xF9,0xFE),      o2(0xDB,0xBA),
          o2(0xDA,0xF5),      o2(0xF6,0xEC),
          o2(0xDA,0xDC),      o2(0xFA,0xE4),
          o2(0xE0,0xCF),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_08 = {
    to_EUC_KR_E8_08_offsets,
    to_CP949_E8_08_infos
};


static const struct byte_lookup* const
to_CP949_E8_09_infos[14] = {
          o2(0xDD,0xB2),      o2(0xE6,0xA9),
          o2(0xEF,0xF3),      o2(0xF3,0xED),
          o2(0xEB,0xFA),      o2(0xF9,0xE6),
          o2(0xCA,0xDD),      o2(0xD5,0xDE),
          o2(0xCA,0xDE),      o2(0xDF,0xE4),
          o2(0xE6,0xFD),      o2(0xF5,0xAC),
          o2(0xE4,0xF5),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_09 = {
    to_EUC_KR_E8_09_offsets,
    to_CP949_E8_09_infos
};


static const struct byte_lookup* const
to_CP949_E8_0A_infos[25] = {
          o2(0xE9,0xE3),      o2(0xED,0xCB),
          o2(0xCF,0xE4),      o2(0xD8,0xD3),
          o2(0xDD,0xB3),      o2(0xD4,0xEC),
          o2(0xF2,0xB9),      o2(0xDF,0xB7),
          o2(0xCB,0xCE),      o2(0xFB,0xD8),
          o2(0xD0,0xD9),      o2(0xDD,0xD2),
          o2(0xF7,0xF4),      o2(0xE7,0xDC),
          o2(0xE4,0xA5),      o2(0xFC,0xA3),
          o2(0xDB,0xBB),      o2(0xF2,0xBA),
          o2(0xE9,0xFD),      o2(0xD0,0xCA),
          o2(0xF5,0xD6),      o2(0xD9,0xC5),
          o2(0xE4,0xB4),      o2(0xED,0xA7),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_0A = {
    to_EUC_KR_E8_0A_offsets,
    to_CP949_E8_0A_infos
};


static const struct byte_lookup* const
to_CP949_E8_0B_infos[16] = {
          o2(0xEA,0xBD),      o2(0xE6,0xFE),
          o2(0xF7,0xC4),      o2(0xF5,0xAD),
          o2(0xD9,0xE0),      o2(0xCA,0xB4),
          o2(0xF8,0xE2),      o2(0xCF,0xC2),
          o2(0xEC,0xBE),      o2(0xE5,0xB4),
          o2(0xCD,0xC8),      o2(0xEE,0xC8),
          o2(0xE7,0xC8),      o2(0xCD,0xC9),
          o2(0xF9,0xB7),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_0B = {
    to_EUC_KR_E8_0B_offsets,
    to_CP949_E8_0B_infos
};


static const struct byte_lookup* const
to_CP949_E8_0C_infos[17] = {
          o2(0xF1,0xE8),      o2(0xD9,0xF2),
          o2(0xDB,0xF5),      o2(0xCA,0xB5),
          o2(0xD9,0xC6),      o2(0xD8,0xC9),
          o2(0xD9,0xAB),      o2(0xED,0xBC),
          o2(0xD8,0xD4),      o2(0xDC,0xDA),
          o2(0xE2,0xBC),      o2(0xFC,0xED),
          o2(0xEC,0xE0),      o2(0xD2,0xFE),
          o2(0xE9,0xC7),      o2(0xE6,0xAA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_0C = {
    to_EUC_KR_E8_0C_offsets,
    to_CP949_E8_0C_infos
};


static const struct byte_lookup* const
to_CP949_E8_0D_infos[11] = {
          o2(0xE2,0xF0),      o2(0xFA,0xBB),
          o2(0xF5,0xAE),      o2(0xFB,0xAA),
          o2(0xEC,0xFB),      o2(0xEC,0xBF),
          o2(0xFC,0xD8),      o2(0xD4,0xE5),
          o2(0xF9,0xC3),      o2(0xEE,0xE2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_0D = {
    to_EUC_KR_E8_0D_offsets,
    to_CP949_E8_0D_infos
};


static const struct byte_lookup* const
to_CP949_E8_0E_infos[12] = {
          o2(0xD7,0xE9),      o2(0xED,0xF6),
          o2(0xDE,0xED),      o2(0xCC,0xEC),
          o2(0xE3,0xEE),      o2(0xE8,0xD4),
          o2(0xFA,0xF8),      o2(0xDD,0xB4),
          o2(0xE4,0xB5),      o2(0xD8,0xB0),
          o2(0xD8,0xD5),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_0E = {
    to_EUC_KR_E8_0E_offsets,
    to_CP949_E8_0E_infos
};


static const struct byte_lookup* const
to_CP949_E8_0F_infos[18] = {
          o2(0xF4,0xEA),      o2(0xCE,0xB9),
          o2(0xD6,0xE1),      o2(0xCF,0xD2),
          o2(0xD0,0xB6),      o2(0xCE,0xA2),
          o2(0xF3,0xEE),      o2(0xF3,0xF8),
          o2(0xDC,0xCC),      o2(0xD0,0xCB),
          o2(0xFC,0xA4),      o2(0xCD,0xCA),
          o2(0xD7,0xD4),      o2(0xDE,0xA3),
          o2(0xE4,0xE0),      o2(0xEE,0xC9),
          o2(0xE2,0xDD),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_0F = {
    to_EUC_KR_E8_0F_offsets,
    to_CP949_E8_0F_infos
};


static const struct byte_lookup* const
to_CP949_E8_10_infos[12] = {
          o2(0xF5,0xFE),      o2(0xD4,0xAC),
          o2(0xD5,0xD1),      o2(0xD8,0xF0),
          o2(0xF8,0xC3),      o2(0xEA,0xD7),
          o2(0xF5,0xD7),      o2(0xD8,0xBF),
          o2(0xFD,0xC0),      o2(0xEB,0xAD),
          o2(0xD5,0xAA),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_10 = {
    to_EUC_KR_E8_10_offsets,
    to_CP949_E8_10_infos
};


static const struct byte_lookup* const
to_CP949_E8_11_infos[12] = {
          o2(0xE7,0xA8),      o2(0xEE,0xCA),
          o2(0xCA,0xE7),      o2(0xF8,0xE3),
          o2(0xD4,0xDD),      o2(0xEA,0xD8),
          o2(0xFB,0xD9),      o2(0xED,0xF7),
          o2(0xE5,0xB5),      o2(0xD0,0xAD),
          o2(0xF1,0xF1),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_11 = {
    to_EUC_KR_E8_11_offsets,
    to_CP949_E8_11_infos
};


static const struct byte_lookup* const
to_CP949_E8_12_infos[11] = {
          o2(0xE2,0xBD),      o2(0xE3,0xC8),
          o2(0xD9,0xD5),      o2(0xDF,0xAA),
          o2(0xDB,0xBC),      o2(0xF8,0xE4),
          o2(0xF1,0xFA),      o2(0xE5,0xB6),
          o2(0xF3,0xEF),      o2(0xFB,0xDA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_12 = {
    to_EUC_KR_E8_12_offsets,
    to_CP949_E8_12_infos
};


static const struct byte_lookup* const
to_CP949_E8_13_infos[14] = {
          o2(0xE1,0xE0),      o2(0xD9,0xAC),
          o2(0xF5,0xEB),      o2(0xE0,0xB6),
          o2(0xE9,0xC8),      o2(0xCB,0xCF),
          o2(0xE3,0xC9),      o2(0xDE,0xEE),
          o2(0xE2,0xBE),      o2(0xDC,0xEF),
          o2(0xD6,0xA5),      o2(0xE2,0xF1),
          o2(0xD6,0xFE),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_13 = {
    to_EUC_KR_E8_13_offsets,
    to_CP949_E8_13_infos
};


static const struct byte_lookup* const
to_CP949_E8_14_infos[16] = {
          o2(0xD9,0xA1),      o2(0xD8,0xC0),
          o2(0xDC,0xDB),      o2(0xED,0xBD),
          o2(0xDF,0xB8),      o2(0xEA,0xA5),
          o2(0xD7,0xAD),      o2(0xF3,0xF9),
          o2(0xED,0xF8),      o2(0xF5,0xC7),
          o2(0xE1,0xCA),      o2(0xEB,0xE3),
          o2(0xF2,0xDE),      o2(0xF8,0xCC),
          o2(0xEA,0xD9),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_14 = {
    to_EUC_KR_E8_14_offsets,
    to_CP949_E8_14_infos
};


static const struct byte_lookup* const
to_CP949_E8_15_infos[12] = {
          o2(0xD3,0xC6),      o2(0xDB,0xE6),
          o2(0xF5,0xAF),      o2(0xCE,0xF0),
          o2(0xE9,0xFE),      o2(0xFB,0xB6),
          o2(0xE2,0xF2),      o2(0xCF,0xF2),
          o2(0xF7,0xB9),      o2(0xD9,0xF3),
          o2(0xE1,0xCB),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_15 = {
    to_EUC_KR_E8_15_offsets,
    to_CP949_E8_15_infos
};


static const struct byte_lookup* const
to_CP949_E8_16_infos[14] = {
          o2(0xDA,0xDD),      o2(0xDA,0xB9),
          o2(0xEB,0xFB),      o2(0xCB,0xB9),
          o2(0xED,0xF9),      o2(0xE0,0xE0),
          o2(0xF4,0xC0),      o2(0xFD,0xBC),
          o2(0xDF,0xB1),      o2(0xE3,0xEF),
          o2(0xE0,0xA3),      o2(0xFD,0xB9),
          o2(0xF0,0xB1),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_16 = {
    to_EUC_KR_E8_16_offsets,
    to_CP949_E8_16_infos
};


static const struct byte_lookup* const
to_CP949_E8_17_infos[17] = {
          o2(0xCD,0xCB),      o2(0xED,0xBE),
          o2(0xD5,0xC0),      o2(0xE3,0xF0),
          o2(0xED,0xFA),      o2(0xE9,0xE4),
          o2(0xD5,0xED),      o2(0xE7,0xDD),
          o2(0xD4,0xF6),      o2(0xE5,0xB7),
          o2(0xDB,0xE7),      o2(0xE2,0xBF),
          o2(0xEE,0xCB),      o2(0xD7,0xF4),
          o2(0xF0,0xDD),      o2(0xCE,0xAB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_17 = {
    to_EUC_KR_E8_17_offsets,
    to_CP949_E8_17_infos
};


static const struct byte_lookup* const
to_CP949_E8_18_infos[10] = {
          o2(0xE7,0xDE),      o2(0xD6,0xD6),
          o2(0xE1,0xCC),      o2(0xE8,0xB3),
          o2(0xE5,0xEE),      o2(0xDC,0xA2),
          o2(0xE0,0xD0),      o2(0xD5,0xB5),
          o2(0xD5,0xA1),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_18 = {
    to_EUC_KR_E8_18_offsets,
    to_CP949_E8_18_infos
};


static const struct byte_lookup* const
to_CP949_E8_19_infos[11] = {
          o2(0xFB,0xDB),      o2(0xF9,0xCB),
          o2(0xCB,0xF3),      o2(0xF4,0xA5),
          o2(0xFA,0xC8),      o2(0xD6,0xD7),
          o2(0xE9,0xE5),      o2(0xFB,0xDC),
          o2(0xFD,0xD0),      o2(0xFB,0xF6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_19 = {
    to_EUC_KR_E8_19_offsets,
    to_CP949_E8_19_infos
};


static const struct byte_lookup* const
to_CP949_E8_1A_infos[7] = {
          o2(0xDA,0xA5),      o2(0xDB,0xBD),
          o2(0xEC,0xE2),      o2(0xCD,0xF7),
          o2(0xF0,0xDE),      o2(0xF6,0xC9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_1A = {
    to_EUC_KR_E8_1A_offsets,
    to_CP949_E8_1A_infos
};


static const struct byte_lookup* const
to_CP949_E8_1B_infos[10] = {
          o2(0xDE,0xEF),      o2(0xD3,0xB1),
          o2(0xFC,0xEE),      o2(0xE8,0xC3),
          o2(0xF1,0xC8),      o2(0xCE,0xF1),
          o2(0xF9,0xED),      o2(0xF2,0xF4),
          o2(0xE4,0xB6),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_1B = {
    to_EUC_KR_E8_1B_offsets,
    to_CP949_E8_1B_infos
};


static const struct byte_lookup* const
to_CP949_E8_1C_infos[8] = {
          o2(0xF5,0xB9),      o2(0xDC,0xF0),
          o2(0xE3,0xF1),      o2(0xE8,0xA5),
          o2(0xF2,0xBB),      o2(0xDE,0xA4),
          o2(0xDA,0xCC),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_1C = {
    to_EUC_KR_E8_1C_offsets,
    to_CP949_E8_1C_infos
};


static const struct byte_lookup* const
to_CP949_E8_1D_infos[10] = {
          o2(0xCA,0xE9),      o2(0xE3,0xDA),
          o2(0xFC,0xD9),      o2(0xEA,0xDA),
          o2(0xF9,0xC4),      o2(0xE3,0xA4),
          o2(0xFB,0xDD),      o2(0xEF,0xCA),
          o2(0xE8,0xC4),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_1D = {
    to_EUC_KR_E8_1D_offsets,
    to_CP949_E8_1D_infos
};


static const struct byte_lookup* const
to_CP949_E8_1E_infos[7] = {
          o2(0xD5,0xCC),      o2(0xEB,0xD7),
          o2(0xD9,0xAD),      o2(0xFB,0xAB),
          o2(0xD3,0xD9),      o2(0xD5,0xA2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_1E = {
    to_EUC_KR_E8_1E_offsets,
    to_CP949_E8_1E_infos
};


static const struct byte_lookup* const
to_CP949_E8_1F_infos[9] = {
          o2(0xF6,0xDE),      o2(0xDA,0xF6),
          o2(0xE0,0xD1),      o2(0xE9,0xA8),
          o2(0xF5,0xF9),      o2(0xFA,0xAF),
          o2(0xEB,0xFC),      o2(0xE0,0xEA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_1F = {
    to_EUC_KR_E8_1F_offsets,
    to_CP949_E8_1F_infos
};


static const struct byte_lookup* const
to_CP949_E8_20_infos[8] = {
          o2(0xE3,0xB2),      o2(0xD5,0xC5),
          o2(0xF1,0xE3),      o2(0xD5,0xEE),
          o2(0xCD,0xCC),      o2(0xED,0xD9),
          o2(0xD8,0xC1),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_20 = {
    to_EUC_KR_E8_20_offsets,
    to_CP949_E8_20_infos
};


static const struct byte_lookup* const
to_CP949_E8_21_infos[21] = {
          o2(0xFA,0xEC),      o2(0xF1,0xEB),
          o2(0xFA,0xBC),      o2(0xE6,0xE2),
          o2(0xFA,0xE5),      o2(0xE2,0xFA),
          o2(0xCA,0xB6),      o2(0xE4,0xB7),
          o2(0xEA,0xDB),      o2(0xF5,0xFA),
          o2(0xFB,0xAC),      o2(0xCF,0xC3),
          o2(0xEB,0xFD),      o2(0xF8,0xFA),
          o2(0xDF,0xB9),      o2(0xE1,0xF1),
          o2(0xD2,0xA4),      o2(0xF5,0xFB),
          o2(0xD0,0xDA),      o2(0xD0,0xDB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_21 = {
    to_EUC_KR_E8_21_offsets,
    to_CP949_E8_21_infos
};


static const struct byte_lookup* const
to_CP949_E8_22_infos[12] = {
          o2(0xEA,0xBE),      o2(0xD9,0xB1),
          o2(0xCA,0xB7),      o2(0xD3,0xE7),
          o2(0xF8,0xE5),      o2(0xD3,0xB2),
          o2(0xE2,0xC0),      o2(0xF2,0xDF),
          o2(0xCD,0xE5),      o2(0xF9,0xAC),
          o2(0xCD,0xCD),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_22 = {
    to_EUC_KR_E8_22_offsets,
    to_CP949_E8_22_infos
};


static const struct byte_lookup* const
to_CP949_E8_23_infos[17] = {
          o2(0xEE,0xAE),      o2(0xD6,0xAE),
          o2(0xD7,0xEA),      o2(0xE7,0xE0),
          o2(0xEB,0xAE),      o2(0xCF,0xD9),
          o2(0xDC,0xCD),      o2(0xED,0xFB),
          o2(0xDE,0xF0),      o2(0xD7,0xEB),
          o2(0xDE,0xA5),      o2(0xDF,0xD7),
          o2(0xDB,0xD0),      o2(0xDB,0xD1),
          o2(0xD5,0xA3),      o2(0xF0,0xB2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_23 = {
    to_EUC_KR_E8_23_offsets,
    to_CP949_E8_23_infos
};


static const struct byte_lookup* const
to_CP949_E8_24_infos[12] = {
          o2(0xDC,0xDC),      o2(0xCA,0xE8),
          o2(0xF8,0xE6),      o2(0xDC,0xCE),
          o2(0xEA,0xDC),      o2(0xDB,0xD2),
          o2(0xE9,0xB3),      o2(0xF7,0xDB),
          o2(0xE3,0xA8),      o2(0xD7,0xAE),
          o2(0xE0,0xE1),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_24 = {
    to_EUC_KR_E8_24_offsets,
    to_CP949_E8_24_infos
};


static const struct byte_lookup* const
to_CP949_E8_25_infos[8] = {
          o2(0xCB,0xBA),      o2(0xE5,0xD1),
          o2(0xD0,0xDC),      o2(0xD5,0xC1),
          o2(0xD8,0xCA),      o2(0xE3,0xA9),
          o2(0xE0,0xA4),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_25 = {
    to_EUC_KR_E8_25_offsets,
    to_CP949_E8_25_infos
};


static const struct byte_lookup* const
to_CP949_E8_26_infos[15] = {
          o2(0xE9,0xA9),      o2(0xD3,0xC7),
          o2(0xDC,0xDD),      o2(0xF8,0xAE),
          o2(0xCC,0xB8),      o2(0xD0,0xAE),
          o2(0xD8,0xF2),      o2(0xE3,0xCA),
          o2(0xCC,0xAF),      o2(0xD4,0xAD),
          o2(0xF6,0xD1),      o2(0xD0,0xCC),
          o2(0xCA,0xC6),      o2(0xD5,0xC2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_26 = {
    to_EUC_KR_E8_26_offsets,
    to_CP949_E8_26_infos
};


static const struct byte_lookup* const
to_CP949_E8_27_infos[6] = {
          o2(0xCE,0xBA),      o2(0xCA,0xC7),
          o2(0xFA,0xB0),      o2(0xDF,0xD8),
          o2(0xF5,0xBA),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_27 = {
    to_EUC_KR_E8_27_offsets,
    to_CP949_E8_27_infos
};


static const struct byte_lookup* const
to_CP949_E8_28_infos[24] = {
          o2(0xE5,0xEB),      o2(0xEF,0xF4),
          o2(0xDD,0xB5),      o2(0xCD,0xAA),
          o2(0xE3,0xF2),      o2(0xFB,0xF7),
          o2(0xF7,0xD0),      o2(0xFD,0xBA),
          o2(0xFD,0xE1),      o2(0xF6,0xFE),
          o2(0xD1,0xC0),      o2(0xE8,0xC5),
          o2(0xE4,0xB8),      o2(0xE1,0xE8),
          o2(0xCC,0xC1),      o2(0xD2,0xED),
          o2(0xDB,0xBE),      o2(0xE0,0xE2),
          o2(0xFA,0xC9),      o2(0xE1,0xCD),
          o2(0xCA,0xB8),      o2(0xF2,0xE0),
          o2(0xF1,0xC9),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_28 = {
    to_EUC_KR_E8_28_offsets,
    to_CP949_E8_28_infos
};


static const struct byte_lookup* const
to_CP949_E8_29_infos[19] = {
          o2(0xDE,0xF1),      o2(0xF0,0xDF),
          o2(0xF8,0xC4),      o2(0xEE,0xCC),
          o2(0xDE,0xF2),      o2(0xE7,0xC9),
          o2(0xE2,0xF3),      o2(0xE7,0xE1),
          o2(0xE3,0xCB),      o2(0xE3,0xCC),
          o2(0xCF,0xF8),      o2(0xEF,0xAC),
          o2(0xFD,0xFE),      o2(0xFC,0xA5),
          o2(0xFA,0xB1),      o2(0xDF,0xD9),
          o2(0xE0,0xD2),      o2(0xF4,0xDA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_29 = {
    to_EUC_KR_E8_29_offsets,
    to_CP949_E8_29_infos
};


static const struct byte_lookup* const
to_CP949_E8_2A_infos[23] = {
          o2(0xF1,0xCA),      o2(0xCE,0xA3),
          o2(0xF2,0xBC),      o2(0xEC,0xE3),
          o2(0xE0,0xA5),      o2(0xF7,0xAB),
          o2(0xEB,0xAF),      o2(0xE5,0xDE),
          o2(0xE1,0xA4),      o2(0xCD,0xAB),
          o2(0xD9,0xF4),      o2(0xE8,0xA6),
          o2(0xCD,0xCE),      o2(0xE1,0xE9),
          o2(0xFC,0xEF),      o2(0xE0,0xE3),
          o2(0xE2,0xC1),      o2(0xCE,0xA4),
          o2(0xDE,0xA6),      o2(0xEB,0xFE),
          o2(0xEB,0xDD),      o2(0xF0,0xE0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_2A = {
    to_EUC_KR_E8_2A_offsets,
    to_CP949_E8_2A_infos
};


static const struct byte_lookup* const
to_CP949_E8_2B_infos[24] = {
          o2(0xF4,0xDB),      o2(0xE2,0xF4),
          o2(0xD3,0xC8),      o2(0xF4,0xEB),
          o2(0xEE,0xB5),      o2(0xF5,0xD8),
          o2(0xD5,0xDF),      o2(0xD6,0xE5),
          o2(0xEB,0xB0),      o2(0xF4,0xE3),
          o2(0xE3,0xCD),      o2(0xF4,0xF4),
          o2(0xFA,0xB2),      o2(0xEF,0xF5),
          o2(0xCA,0xDF),      o2(0xEB,0xB1),
          o2(0xED,0xBF),      o2(0xFD,0xC9),
          o2(0xE4,0xA6),      o2(0xF9,0xA4),
          o2(0xF0,0xB3),      o2(0xE5,0xEC),
          o2(0xD1,0xE7),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_2B = {
    to_EUC_KR_E8_2B_offsets,
    to_CP949_E8_2B_infos
};


static const struct byte_lookup* const
to_CP949_E8_2C_infos[20] = {
          o2(0xD9,0xC7),      o2(0xE4,0xD7),
          o2(0xEA,0xDD),      o2(0xD4,0xF7),
          o2(0xDA,0xBA),      o2(0xDA,0xCD),
          o2(0xF9,0xCC),      o2(0xE1,0xDA),
          o2(0xDB,0xBF),      o2(0xCC,0xC5),
          o2(0xEC,0xD0),      o2(0xCB,0xBB),
          o2(0xDE,0xF3),      o2(0xE9,0xAA),
          o2(0xD9,0xC8),      o2(0xEE,0xE3),
          o2(0xD7,0xBD),      o2(0xCF,0xC4),
          o2(0xD0,0xCD),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_2C = {
    to_EUC_KR_E8_2C_offsets,
    to_CP949_E8_2C_infos
};


static const struct byte_lookup* const
to_CP949_E8_2D_infos[15] = {
          o2(0xFC,0xA6),      o2(0xF1,0xFB),
          o2(0xFD,0xD2),      o2(0xD1,0xC1),
          o2(0xE3,0xDB),      o2(0xD3,0xC9),
          o2(0xDC,0xCF),      o2(0xCC,0xED),
          o2(0xDE,0xA7),      o2(0xE6,0xBB),
          o2(0xEC,0xA1),      o2(0xCC,0xB9),
          o2(0xFB,0xDE),      o2(0xE7,0xE2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_2D = {
    to_EUC_KR_E8_2D_offsets,
    to_CP949_E8_2D_infos
};


static const struct byte_lookup* const
to_CP949_E8_2E_infos[8] = {
          o2(0xD4,0xC1),      o2(0xDC,0xA8),
          o2(0xE2,0xC2),      o2(0xF3,0xD8),
          o2(0xE5,0xD3),      o2(0xF3,0xD9),
          o2(0xF3,0xC6),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_2E = {
    to_EUC_KR_E8_2E_offsets,
    to_CP949_E8_2E_infos
};


static const struct byte_lookup* const
to_CP949_E8_30_infos[3] = {
          o2(0xCD,0xDB),      o2(0xCD,0xAC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_30 = {
    to_EUC_KR_E8_30_offsets,
    to_CP949_E8_30_infos
};


static const struct byte_lookup* const
to_CP949_E8_31_infos[13] = {
          o2(0xFC,0xC3),      o2(0xD4,0xE7),
          o2(0xD1,0xC2),      o2(0xF9,0xA5),
          o2(0xE8,0xD5),      o2(0xE3,0xCE),
          o2(0xD4,0xCA),      o2(0xDF,0xDA),
          o2(0xFB,0xDF),      o2(0xE7,0xE3),
          o2(0xF8,0xFB),      o2(0xE3,0xCF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_31 = {
    to_EUC_KR_E8_31_offsets,
    to_CP949_E8_31_infos
};


static const struct byte_lookup* const
to_CP949_E8_32_infos[26] = {
          o2(0xF5,0xB0),      o2(0xD8,0xE7),
          o2(0xD9,0xC9),      o2(0xF8,0xAF),
          o2(0xEF,0xF6),      o2(0xDD,0xB6),
          o2(0xEE,0xAF),      o2(0xCD,0xF8),
          o2(0xDE,0xB8),      o2(0xFC,0xA7),
          o2(0xF7,0xFC),      o2(0xF7,0xB1),
          o2(0xCE,0xBB),      o2(0xF4,0xA1),
          o2(0xEE,0xCD),      o2(0xE1,0xAE),
          o2(0xEC,0xC3),      o2(0xCF,0xFE),
          o2(0xF8,0xBF),      o2(0xD8,0xE2),
          o2(0xD3,0xE8),      o2(0xDE,0xA8),
          o2(0xF4,0xE4),      o2(0xEC,0xC2),
          o2(0xD9,0xF5),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_32 = {
    to_EUC_KR_E8_32_offsets,
    to_CP949_E8_32_infos
};


static const struct byte_lookup* const
to_CP949_E8_33_infos[25] = {
          o2(0xF9,0xC5),      o2(0xDD,0xD3),
          o2(0xD6,0xF1),      o2(0xEC,0xFC),
          o2(0xFC,0xF0),      o2(0xED,0xC0),
          o2(0xCA,0xB9),      o2(0xEE,0xE4),
          o2(0xF2,0xE1),      o2(0xDE,0xB9),
          o2(0xD6,0xF2),      o2(0xDE,0xF4),
          o2(0xDF,0xDB),      o2(0xDB,0xD3),
          o2(0xFA,0xE7),      o2(0xD8,0xE3),
          o2(0xF4,0xC1),      o2(0xDD,0xB7),
          o2(0xF2,0xF5),      o2(0xD4,0xAE),
          o2(0xD6,0xF3),      o2(0xDD,0xB8),
          o2(0xCF,0xC5),      o2(0xDF,0xDF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_33 = {
    to_EUC_KR_E8_33_offsets,
    to_CP949_E8_33_infos
};


static const struct byte_lookup* const
to_CP949_E8_34_infos[9] = {
          o2(0xF2,0xBE),      o2(0xF6,0xA1),
          o2(0xEB,0xCB),      o2(0xF1,0xFC),
          o2(0xF3,0xC7),      o2(0xE0,0xEB),
          o2(0xED,0xFC),      o2(0xE1,0xDB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_34 = {
    to_EUC_KR_E8_34_offsets,
    to_CP949_E8_34_infos
};


static const struct byte_lookup* const
to_CP949_E8_35_infos[8] = {
          o2(0xEE,0xE5),      o2(0xDE,0xF5),
          o2(0xFA,0xD3),      o2(0xF1,0xCB),
          o2(0xD0,0xAF),      o2(0xDD,0xB9),
          o2(0xD1,0xC3),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_35 = {
    to_EUC_KR_E8_35_offsets,
    to_CP949_E8_35_infos
};


static const struct byte_lookup* const
to_CP949_E8_36_infos[9] = {
          o2(0xF5,0xB1),      o2(0xEA,0xC6),
          o2(0xF0,0xE1),      o2(0xF6,0xAC),
          o2(0xF5,0xD9),      o2(0xF0,0xEB),
          o2(0xDD,0xBA),      o2(0xF2,0xBF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_36 = {
    to_EUC_KR_E8_36_offsets,
    to_CP949_E8_36_infos
};


static const struct byte_lookup* const
to_CP949_E8_37_infos[12] = {
          o2(0xF7,0xC5),      o2(0xDB,0xA2),
          o2(0xF2,0xF6),      o2(0xCA,0xBA),
          o2(0xF7,0xF5),      o2(0xCB,0xE5),
          o2(0xEE,0xE6),      o2(0xE0,0xD3),
          o2(0xCE,0xA5),      o2(0xD6,0xD8),
          o2(0xD4,0xAF),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_37 = {
    to_EUC_KR_E8_37_offsets,
    to_CP949_E8_37_infos
};


static const struct byte_lookup* const
to_CP949_E8_38_infos[8] = {
          o2(0xE9,0xC9),      o2(0xD3,0xCE),
          o2(0xF4,0xC2),      o2(0xCB,0xE6),
          o2(0xF1,0xA1),      o2(0xEB,0xB2),
          o2(0xF1,0xA2),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_38 = {
    to_EUC_KR_E8_38_offsets,
    to_CP949_E8_38_infos
};


static const struct byte_lookup* const
to_CP949_E8_39_infos[12] = {
          o2(0xEB,0xB3),      o2(0xF0,0xB4),
          o2(0xCB,0xF4),      o2(0xD4,0xB0),
          o2(0xF3,0xB2),      o2(0xFB,0xB7),
          o2(0xF5,0xEC),      o2(0xEE,0xE7),
          o2(0xF4,0xB2),      o2(0xF5,0xED),
          o2(0xCF,0xF3),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_39 = {
    to_EUC_KR_E8_39_offsets,
    to_CP949_E8_39_infos
};


static const struct byte_lookup* const
to_CP949_E8_3A_infos[8] = {
          o2(0xF0,0xE2),      o2(0xEE,0xCE),
          o2(0xF1,0xCC),      o2(0xE5,0xB8),
          o2(0xD7,0xF5),      o2(0xE3,0xF3),
          o2(0xCF,0xE5),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_3A = {
    to_EUC_KR_E8_3A_offsets,
    to_CP949_E8_3A_infos
};


static const struct byte_lookup* const
to_CP949_E8_3B_infos[12] = {
          o2(0xCF,0xC6),      o2(0xF3,0xB3),
          o2(0xE4,0xD8),      o2(0xCF,0xF9),
          o2(0xCF,0xDA),      o2(0xFA,0xCD),
          o2(0xE6,0xE3),      o2(0xF2,0xE2),
          o2(0xF5,0xEE),      o2(0xCA,0xBB),
          o2(0xE3,0xDC),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_3B = {
    to_EUC_KR_E8_3B_offsets,
    to_CP949_E8_3B_infos
};


static const struct byte_lookup* const
to_CP949_E8_3C_infos[24] = {
          o2(0xCE,0xF2),      o2(0xD6,0xD9),
          o2(0xEE,0xB0),      o2(0xF4,0xE5),
          o2(0xD8,0xC2),      o2(0xDC,0xD0),
          o2(0xCC,0xEE),      o2(0xD5,0xE0),
          o2(0xF6,0xCA),      o2(0xFD,0xCA),
          o2(0xD8,0xD6),      o2(0xF4,0xCF),
          o2(0xD6,0xA6),      o2(0xDC,0xBE),
          o2(0xDB,0xD4),      o2(0xD7,0xC7),
          o2(0xF2,0xFE),      o2(0xF1,0xCD),
          o2(0xE2,0xC3),      o2(0xDC,0xDE),
          o2(0xDC,0xDF),      o2(0xEF,0xAD),
          o2(0xE6,0xAB),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_3C = {
    to_EUC_KR_E8_3C_offsets,
    to_CP949_E8_3C_infos
};


static const struct byte_lookup* const
to_CP949_E8_3D_infos[9] = {
          o2(0xF9,0xDD),      o2(0xEA,0xBF),
          o2(0xEF,0xAE),      o2(0xF4,0xD0),
          o2(0xCE,0xF3),      o2(0xE6,0xAC),
          o2(0xCE,0xDE),      o2(0xD5,0xF9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_3D = {
    to_EUC_KR_E8_3D_offsets,
    to_CP949_E8_3D_infos
};


static const struct byte_lookup* const
to_CP949_E8_3E_infos[11] = {
          o2(0xE3,0xF4),      o2(0xCD,0xD0),
          o2(0xD5,0xB8),      o2(0xF7,0xFD),
          o2(0xDC,0xA9),      o2(0xDE,0xF6),
          o2(0xDC,0xAA),      o2(0xF2,0xE3),
          o2(0xE9,0xB4),      o2(0xD2,0xDC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_3E = {
    to_EUC_KR_E8_3E_offsets,
    to_CP949_E8_3E_infos
};


static const struct byte_lookup* const
to_CP949_E8_3F_infos[15] = {
          o2(0xE9,0xE6),      o2(0xE3,0xF6),
          o2(0xE7,0xCA),      o2(0xD0,0xCE),
          o2(0xDA,0xF7),      o2(0xCA,0xBC),
          o2(0xEE,0xE8),      o2(0xDA,0xDE),
          o2(0xF2,0xF7),      o2(0xE2,0xFB),
          o2(0xCC,0xA6),      o2(0xDA,0xBB),
          o2(0xEE,0xE9),      o2(0xF5,0xDA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8_3F = {
    to_EUC_KR_E8_3F_offsets,
    to_CP949_E8_3F_infos
};


static const struct byte_lookup* const
to_CP949_E8_infos[64] = {
        &to_CP949_E8_00,    &to_CP949_E8_01,
        &to_CP949_E8_02,    &to_CP949_E8_03,
        &to_CP949_E8_04,    &to_CP949_E8_05,
        &to_CP949_E8_06,    &to_CP949_E8_07,
        &to_CP949_E8_08,    &to_CP949_E8_09,
        &to_CP949_E8_0A,    &to_CP949_E8_0B,
        &to_CP949_E8_0C,    &to_CP949_E8_0D,
        &to_CP949_E8_0E,    &to_CP949_E8_0F,
        &to_CP949_E8_10,    &to_CP949_E8_11,
        &to_CP949_E8_12,    &to_CP949_E8_13,
        &to_CP949_E8_14,    &to_CP949_E8_15,
        &to_CP949_E8_16,    &to_CP949_E8_17,
        &to_CP949_E8_18,    &to_CP949_E8_19,
        &to_CP949_E8_1A,    &to_CP949_E8_1B,
        &to_CP949_E8_1C,    &to_CP949_E8_1D,
        &to_CP949_E8_1E,    &to_CP949_E8_1F,
        &to_CP949_E8_20,    &to_CP949_E8_21,
        &to_CP949_E8_22,    &to_CP949_E8_23,
        &to_CP949_E8_24,    &to_CP949_E8_25,
        &to_CP949_E8_26,    &to_CP949_E8_27,
        &to_CP949_E8_28,    &to_CP949_E8_29,
        &to_CP949_E8_2A,    &to_CP949_E8_2B,
        &to_CP949_E8_2C,    &to_CP949_E8_2D,
        &to_CP949_E8_2E,    &to_CP949_E8_30,
        &to_CP949_E8_31,    &to_CP949_E8_32,
        &to_CP949_E8_33,    &to_CP949_E8_34,
        &to_CP949_E8_35,    &to_CP949_E8_36,
        &to_CP949_E8_37,    &to_CP949_E8_38,
        &to_CP949_E8_39,    &to_CP949_E8_3A,
        &to_CP949_E8_3B,    &to_CP949_E8_3C,
        &to_CP949_E8_3D,    &to_CP949_E8_3E,
        &to_CP949_E8_3F,              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E8 = {
    to_EUC_KR_E8_offsets,
    to_CP949_E8_infos
};


static const struct byte_lookup* const
to_CP949_E9_00_infos[32] = {
          o2(0xF7,0xDC),      o2(0xE1,0xEA),
          o2(0xCE,0xC1),      o2(0xD4,0xB1),
          o2(0xFD,0xB1),      o2(0xE6,0xBD),
          o2(0xFB,0xAD),      o2(0xF8,0xE7),
          o2(0xE1,0xCE),      o2(0xF7,0xE2),
          o2(0xF5,0xEF),      o2(0xCF,0xC7),
          o2(0xD4,0xB2),      o2(0xCC,0xEF),
          o2(0xD4,0xE8),      o2(0xEE,0xCF),
          o2(0xF7,0xD7),      o2(0xE0,0xA6),
          o2(0xD6,0xC1),      o2(0xE1,0xDC),
          o2(0xF0,0xE3),      o2(0xF1,0xE4),
          o2(0xDC,0xF1),      o2(0xD6,0xA7),
          o2(0xF4,0xF5),      o2(0xF1,0xCE),
          o2(0xF2,0xE4),      o2(0xD0,0xB0),
          o2(0xEC,0xEF),      o2(0xF9,0xBA),
          o2(0xEB,0xB5),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_00 = {
    to_EUC_KR_E9_00_offsets,
    to_CP949_E9_00_infos
};


static const struct byte_lookup* const
to_CP949_E9_01_infos[32] = {
          o2(0xD4,0xED),      o2(0xE2,0xC4),
          o2(0xE9,0xE7),      o2(0xEB,0xB4),
          o2(0xEA,0xA1),      o2(0xF8,0xBC),
          o2(0xCE,0xA6),      o2(0xF9,0xC6),
          o2(0xFC,0xDA),      o2(0xD4,0xB3),
          o2(0xD3,0xB9),      o2(0xEA,0xDE),
          o2(0xE9,0xAB),      o2(0xE1,0xE1),
          o2(0xD3,0xCF),      o2(0xF4,0xF6),
          o2(0xEA,0xC0),      o2(0xE1,0xCF),
          o2(0xCC,0xBA),      o2(0xEE,0xEA),
          o2(0xF0,0xE4),      o2(0xF3,0xB4),
          o2(0xD4,0xEE),      o2(0xF2,0xC0),
          o2(0xF1,0xE5),      o2(0xF4,0xC3),
          o2(0xE0,0xD4),      o2(0xEB,0xB6),
          o2(0xD7,0xA1),      o2(0xCB,0xE8),
          o2(0xF9,0xAD),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_01 = {
    to_EUC_KR_E9_01_offsets,
    to_CP949_E9_01_infos
};


static const struct byte_lookup* const
to_CP949_E9_02_infos[23] = {
          o2(0xE9,0xAD),      o2(0xD8,0xE4),
          o2(0xFA,0xB3),      o2(0xE2,0xC5),
          o2(0xFC,0xBD),      o2(0xEC,0xC4),
          o2(0xD8,0xB1),      o2(0xDC,0xAB),
          o2(0xD5,0xA4),      o2(0xEB,0xE9),
          o2(0xE8,0xBB),      o2(0xD8,0xD7),
          o2(0xFB,0xAE),      o2(0xD1,0xE1),
          o2(0xDB,0xC0),      o2(0xF5,0xBE),
          o2(0xDE,0xF7),      o2(0xCA,0xFB),
          o2(0xF7,0xC6),      o2(0xCF,0xC8),
          o2(0xE1,0xD0),      o2(0xEE,0xD0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_02 = {
    to_EUC_KR_E9_02_offsets,
    to_CP949_E9_02_infos
};


static const struct byte_lookup* const
to_CP949_E9_03_infos[9] = {
          o2(0xE9,0xF4),      o2(0xCE,0xF4),
          o2(0xD5,0xCD),      o2(0xCF,0xDB),
          o2(0xDD,0xBB),      o2(0xCE,0xAC),
          o2(0xE9,0xE8),      o2(0xD4,0xB4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_03 = {
    to_EUC_KR_E9_03_offsets,
    to_CP949_E9_03_infos
};


static const struct byte_lookup* const
to_CP949_E9_04_infos[8] = {
          o2(0xE4,0xC7),      o2(0xF5,0xDB),
          o2(0xFA,0xC1),      o2(0xDE,0xA9),
          o2(0xD4,0xF8),      o2(0xEF,0xF7),
          o2(0xD3,0xB3),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_04 = {
    to_EUC_KR_E9_04_offsets,
    to_CP949_E9_04_infos
};


static const struct byte_lookup* const
to_CP949_E9_05_infos[15] = {
          o2(0xEB,0xB7),      o2(0xEF,0xF8),
          o2(0xF5,0xDC),      o2(0xED,0xCC),
          o2(0xDB,0xD5),      o2(0xF1,0xCF),
          o2(0xF1,0xD0),      o2(0xF5,0xB2),
          o2(0xD9,0xAE),      o2(0xD5,0xAC),
          o2(0xE2,0xC6),      o2(0xFD,0xA3),
          o2(0xFB,0xE5),      o2(0xDF,0xAB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_05 = {
    to_EUC_KR_E9_05_offsets,
    to_CP949_E9_05_infos
};


static const struct byte_lookup* const
to_CP949_E9_06_infos[14] = {
          o2(0xE2,0xF5),      o2(0xF6,0xAD),
          o2(0xF5,0xB3),      o2(0xF0,0xB5),
          o2(0xE1,0xA5),      o2(0xF5,0xDD),
          o2(0xEC,0xA2),      o2(0xED,0xFD),
          o2(0xF5,0xB4),      o2(0xFB,0xB8),
          o2(0xDB,0xA3),      o2(0xD6,0xCA),
          o2(0xCB,0xD9),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_06 = {
    to_EUC_KR_E9_06_offsets,
    to_CP949_E9_06_infos
};


static const struct byte_lookup* const
to_CP949_E9_07_infos[19] = {
          o2(0xE5,0xD4),      o2(0xF3,0xFA),
          o2(0xEB,0xB8),      o2(0xE0,0xB7),
          o2(0xD7,0xEC),      o2(0xF1,0xEC),
          o2(0xE5,0xAF),      o2(0xD5,0xE1),
          o2(0xD7,0xED),      o2(0xD1,0xD1),
          o2(0xE1,0xF2),      o2(0xEF,0xF9),
          o2(0xDD,0xBC),      o2(0xF6,0xDC),
          o2(0xF0,0xE5),      o2(0xF4,0xC4),
          o2(0xE9,0xE9),      o2(0xF3,0xFB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_07 = {
    to_EUC_KR_E9_07_offsets,
    to_CP949_E9_07_infos
};


static const struct byte_lookup* const
to_CP949_E9_08_infos[10] = {
          o2(0xD4,0xEF),      o2(0xCC,0xA2),
          o2(0xF7,0xFE),      o2(0xDF,0xBC),
          o2(0xEB,0xCD),      o2(0xD0,0xB7),
          o2(0xD6,0xC2),      o2(0xE8,0xAD),
          o2(0xEF,0xAF),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_08 = {
    to_EUC_KR_E9_08_offsets,
    to_CP949_E9_08_infos
};


static const struct byte_lookup* const
to_CP949_E9_09_infos[11] = {
          o2(0xCB,0xA5),      o2(0xCB,0xE9),
          o2(0xFA,0xE8),      o2(0xCC,0xC6),
          o2(0xE6,0xE7),      o2(0xEA,0xC7),
          o2(0xDB,0xA4),      o2(0xCF,0xC9),
          o2(0xE2,0xFC),      o2(0xEF,0xFA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_09 = {
    to_EUC_KR_E9_09_offsets,
    to_CP949_E9_09_infos
};


static const struct byte_lookup* const
to_CP949_E9_0A_infos[13] = {
          o2(0xEB,0xDE),      o2(0xF5,0xC8),
          o2(0xD4,0xDE),      o2(0xE0,0xD5),
          o2(0xEF,0xB0),      o2(0xE2,0xC7),
          o2(0xD9,0xAF),      o2(0xF9,0xE7),
          o2(0xE7,0xE5),      o2(0xCF,0xCA),
          o2(0xE1,0xD1),      o2(0xE2,0xC8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_0A = {
    to_EUC_KR_E9_0A_offsets,
    to_CP949_E9_0A_infos
};


static const struct byte_lookup* const
to_CP949_E9_0B_infos[8] = {
          o2(0xEF,0xFB),      o2(0xFA,0xF9),
          o2(0xDC,0xF2),      o2(0xE0,0xA7),
          o2(0xF8,0xE8),      o2(0xCB,0xEA),
          o2(0xCB,0xBC),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_0B = {
    to_EUC_KR_E9_0B_offsets,
    to_CP949_E9_0B_infos
};


static const struct byte_lookup* const
to_CP949_E9_0C_infos[16] = {
          o2(0xD6,0xE2),      o2(0xF5,0xDE),
          o2(0xF5,0xDF),      o2(0xEE,0xB6),
          o2(0xE2,0xF6),      o2(0xD3,0xCA),
          o2(0xEF,0xFC),      o2(0xD1,0xC4),
          o2(0xEF,0xB1),      o2(0xD1,0xC5),
          o2(0xD0,0xDE),      o2(0xD9,0xE1),
          o2(0xE0,0xB8),      o2(0xCD,0xD1),
          o2(0xF3,0xB9),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_0C = {
    to_EUC_KR_E9_0C_offsets,
    to_CP949_E9_0C_infos
};


static const struct byte_lookup* const
to_CP949_E9_0D_infos[11] = {
          o2(0xE7,0xCC),      o2(0xD6,0xA8),
          o2(0xCE,0xA7),      o2(0xD4,0xB5),
          o2(0xE4,0xC8),      o2(0xD3,0xB4),
          o2(0xEB,0xB9),      o2(0xCB,0xF5),
          o2(0xF6,0xDD),      o2(0xF1,0xA3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_0D = {
    to_EUC_KR_E9_0D_offsets,
    to_CP949_E9_0D_infos
};


static const struct byte_lookup* const
to_CP949_E9_0E_infos[10] = {
          o2(0xCC,0xC7),      o2(0xE9,0xCA),
          o2(0xE1,0xF0),      o2(0xF5,0xE0),
          o2(0xFB,0xAF),      o2(0xCB,0xD1),
          o2(0xFB,0xE0),      o2(0xF2,0xE5),
          o2(0xEC,0xF0),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_0E = {
    to_EUC_KR_E9_0E_offsets,
    to_CP949_E9_0E_infos
};


static const struct byte_lookup* const
to_CP949_E9_0F_infos[7] = {
          o2(0xF0,0xEC),      o2(0xEE,0xEB),
          o2(0xE9,0xCB),      o2(0xCC,0xF0),
          o2(0xD7,0xAF),      o2(0xF3,0xA1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_0F = {
    to_EUC_KR_E9_0F_offsets,
    to_CP949_E9_0F_infos
};


static const struct byte_lookup* const
to_CP949_E9_10_infos[7] = {
          o2(0xFC,0xF5),      o2(0xF1,0xA4),
          o2(0xE0,0xD6),      o2(0xEF,0xB2),
          o2(0xF4,0xD1),      o2(0xF7,0xA1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_10 = {
    to_EUC_KR_E9_10_offsets,
    to_CP949_E9_10_infos
};


static const struct byte_lookup* const
to_CP949_E9_11_infos[7] = {
          o2(0xF1,0xD1),      o2(0xCA,0xFC),
          o2(0xCA,0xFD),      o2(0xCE,0xCE),
          o2(0xF3,0xC8),      o2(0xF3,0xBA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_11 = {
    to_EUC_KR_E9_11_offsets,
    to_CP949_E9_11_infos
};


static const struct byte_lookup* const
to_CP949_E9_15_infos[2] = {
          o2(0xED,0xFE),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_15 = {
    to_EUC_KR_E9_15_offsets,
    to_CP949_E9_15_infos
};


static const struct byte_lookup* const
to_CP949_E9_16_infos[19] = {
          o2(0xDA,0xA6),      o2(0xE0,0xEC),
          o2(0xF8,0xCD),      o2(0xCB,0xD2),
          o2(0xEB,0xCE),      o2(0xF9,0xD8),
          o2(0xF9,0xD9),      o2(0xCA,0xE0),
          o2(0xDA,0xCA),      o2(0xCB,0xA6),
          o2(0xCA,0xC8),      o2(0xF9,0xEE),
          o2(0xDB,0xEC),      o2(0xD0,0xB1),
          o2(0xD5,0xEF),      o2(0xE6,0xF3),
          o2(0xE7,0xA2),      o2(0xE4,0xD9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_16 = {
    to_EUC_KR_E9_16_offsets,
    to_CP949_E9_16_infos
};


static const struct byte_lookup* const
to_CP949_E9_17_infos[9] = {
          o2(0xE4,0xE1),      o2(0xFC,0xC4),
          o2(0xF9,0xEF),      o2(0xCF,0xF4),
          o2(0xF7,0xE6),      o2(0xCE,0xBC),
          o2(0xF4,0xC5),      o2(0xDC,0xA3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_17 = {
    to_EUC_KR_E9_17_offsets,
    to_CP949_E9_17_infos
};


static const struct byte_lookup* const
to_CP949_E9_18_infos[8] = {
          o2(0xDD,0xBD),      o2(0xF4,0xC6),
          o2(0xF8,0xA1),      o2(0xE8,0xD6),
          o2(0xDB,0xC1),      o2(0xF0,0xE6),
          o2(0xE4,0xB9),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_18 = {
    to_EUC_KR_E9_18_offsets,
    to_CP949_E9_18_infos
};


static const struct byte_lookup* const
to_CP949_E9_19_infos[24] = {
          o2(0xF6,0xED),      o2(0xF9,0xAE),
          o2(0xDD,0xBE),      o2(0xD7,0xB0),
          o2(0xD8,0xE8),      o2(0xCB,0xBD),
          o2(0xF9,0xDA),      o2(0xF8,0xCE),
          o2(0xF9,0xF0),      o2(0xE0,0xED),
          o2(0xE3,0xB3),      o2(0xF4,0xB3),
          o2(0xEA,0xC2),      o2(0xF2,0xE6),
          o2(0xF0,0xB6),      o2(0xDB,0xD6),
          o2(0xEB,0xE4),      o2(0xF2,0xE7),
          o2(0xD7,0xD5),      o2(0xD4,0xB6),
          o2(0xF9,0xE8),      o2(0xD7,0xC1),
          o2(0xE5,0xD5),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_19 = {
    to_EUC_KR_E9_19_offsets,
    to_CP949_E9_19_infos
};


static const struct byte_lookup* const
to_CP949_E9_1A_infos[20] = {
          o2(0xE9,0xEA),      o2(0xD7,0xCC),
          o2(0xD3,0xE9),      o2(0xE2,0xC9),
          o2(0xFC,0xDB),      o2(0xCD,0xAD),
          o2(0xCC,0xB0),      o2(0xEA,0xA2),
          o2(0xE4,0xF6),      o2(0xD0,0xC0),
          o2(0xF0,0xB7),      o2(0xEE,0xA1),
          o2(0xD7,0xF6),      o2(0xE2,0xCA),
          o2(0xE2,0xCB),      o2(0xFA,0xCF),
          o2(0xEB,0xDF),      o2(0xD6,0xCB),
          o2(0xF4,0xB4),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_1A = {
    to_EUC_KR_E9_1A_offsets,
    to_CP949_E9_1A_infos
};


static const struct byte_lookup* const
to_CP949_E9_1B_infos[29] = {
          o2(0xED,0xCD),      o2(0xE4,0xD2),
          o2(0xEA,0xA9),      o2(0xE4,0xBA),
          o2(0xF3,0xA2),      o2(0xCD,0xD2),
          o2(0xF6,0xCB),      o2(0xF1,0xE6),
          o2(0xED,0xC1),      o2(0xE8,0xBC),
          o2(0xEE,0xD1),      o2(0xF0,0xE7),
          o2(0xE2,0xCC),      o2(0xE4,0xAA),
          o2(0xF5,0xE1),      o2(0xED,0xDA),
          o2(0xD7,0xEE),      o2(0xD1,0xF1),
          o2(0xE9,0xEB),      o2(0xE9,0xEC),
          o2(0xE0,0xE4),      o2(0xDA,0xA7),
          o2(0xDD,0xD4),      o2(0xEA,0xA3),
          o2(0xD6,0xC3),      o2(0xD6,0xF4),
          o2(0xDA,0xDF),      o2(0xEF,0xB3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_1B = {
    to_EUC_KR_E9_1B_offsets,
    to_CP949_E9_1B_infos
};


static const struct byte_lookup* const
to_CP949_E9_1C_infos[15] = {
          o2(0xE2,0xCD),      o2(0xEF,0xFD),
          o2(0xF2,0xE8),      o2(0xEF,0xC5),
          o2(0xE7,0xE7),      o2(0xD7,0xFD),
          o2(0xE7,0xCE),      o2(0xDF,0xDC),
          o2(0xF9,0xC7),      o2(0xD9,0xF6),
          o2(0xDF,0xAC),      o2(0xD6,0xDA),
          o2(0xDC,0xA4),      o2(0xF0,0xB8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_1C = {
    to_EUC_KR_E9_1C_offsets,
    to_CP949_E9_1C_infos
};


static const struct byte_lookup* const
to_CP949_E9_1D_infos[15] = {
          o2(0xD5,0xFA),      o2(0xE4,0xF7),
          o2(0xD6,0xC4),      o2(0xF4,0xEC),
          o2(0xEF,0xFE),      o2(0xF0,0xA1),
          o2(0xDE,0xAA),      o2(0xDA,0xBC),
          o2(0xD8,0xFC),      o2(0xFA,0xD4),
          o2(0xEC,0xE5),      o2(0xFC,0xA8),
          o2(0xEC,0xE6),      o2(0xD8,0xCB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_1D = {
    to_EUC_KR_E9_1D_offsets,
    to_CP949_E9_1D_infos
};


static const struct byte_lookup* const
to_CP949_E9_1E_infos[8] = {
          o2(0xFB,0xB9),      o2(0xE4,0xD3),
          o2(0xCD,0xF9),      o2(0xCF,0xD3),
          o2(0xCA,0xEA),      o2(0xCF,0xD4),
          o2(0xF8,0xBD),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_1E = {
    to_EUC_KR_E9_1E_offsets,
    to_CP949_E9_1E_infos
};


static const struct byte_lookup* const
to_CP949_E9_1F_infos[9] = {
          o2(0xF4,0xC7),      o2(0xEA,0xDF),
          o2(0xF9,0xDB),      o2(0xD4,0xB7),
          o2(0xEB,0xE5),      o2(0xE1,0xD2),
          o2(0xEA,0xA4),      o2(0xFA,0xC2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_1F = {
    to_EUC_KR_E9_1F_offsets,
    to_CP949_E9_1F_infos
};


static const struct byte_lookup* const
to_CP949_E9_20_infos[21] = {
          o2(0xFB,0xE1),      o2(0xFA,0xED),
          o2(0xF0,0xA2),      o2(0xCC,0xF1),
          o2(0xFA,0xA3),      o2(0xE2,0xF7),
          o2(0xE2,0xCE),      o2(0xE9,0xF5),
          o2(0xE1,0xEB),      o2(0xE7,0xE8),
          o2(0xE8,0xD7),      o2(0xDA,0xF8),
          o2(0xD4,0xCB),      o2(0xF7,0xF6),
          o2(0xD6,0xC5),      o2(0xD4,0xE9),
          o2(0xFA,0xFA),      o2(0xCC,0xF2),
          o2(0xF7,0xDD),      o2(0xDE,0xBA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_20 = {
    to_EUC_KR_E9_20_offsets,
    to_CP949_E9_20_infos
};


static const struct byte_lookup* const
to_CP949_E9_21_infos[13] = {
          o2(0xCE,0xA8),      o2(0xF0,0xB9),
          o2(0xE4,0xFE),      o2(0xE4,0xC9),
          o2(0xE4,0xD4),      o2(0xEA,0xC3),
          o2(0xEF,0xB4),      o2(0xD7,0xBE),
          o2(0xFB,0xE2),      o2(0xCD,0xD3),
          o2(0xEF,0xB5),      o2(0xFA,0xE9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_21 = {
    to_EUC_KR_E9_21_offsets,
    to_CP949_E9_21_infos
};


static const struct byte_lookup* const
to_CP949_E9_22_infos[4] = {
          o2(0xF9,0xA6),      o2(0xDF,0xBD),
          o2(0xF7,0xC7),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_22 = {
    to_EUC_KR_E9_22_offsets,
    to_CP949_E9_22_infos
};


static const struct byte_lookup* const
to_CP949_E9_23_infos[15] = {
          o2(0xF8,0xFD),      o2(0xF8,0xFC),
          o2(0xDE,0xAB),      o2(0xDB,0xE8),
          o2(0xE3,0xDD),      o2(0xE1,0xE2),
          o2(0xD1,0xC6),      o2(0xF6,0xD0),
          o2(0xEB,0xE6),      o2(0xDA,0xF9),
          o2(0xEC,0xC7),      o2(0xDE,0xF8),
          o2(0xF8,0xE9),      o2(0xE3,0xDE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_23 = {
    to_EUC_KR_E9_23_offsets,
    to_CP949_E9_23_infos
};


static const struct byte_lookup* const
to_CP949_E9_24_infos[11] = {
          o2(0xCE,0xF5),      o2(0xFA,0xC3),
          o2(0xE5,0xD7),      o2(0xEC,0xC8),
          o2(0xF3,0xC9),      o2(0xE4,0xBB),
          o2(0xE6,0xAE),      o2(0xEF,0xB6),
          o2(0xDC,0xBF),      o2(0xCE,0xBD),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_24 = {
    to_EUC_KR_E9_24_offsets,
    to_CP949_E9_24_infos
};


static const struct byte_lookup* const
to_CP949_E9_25_infos[10] = {
          o2(0xD8,0xC3),      o2(0xD0,0xCF),
          o2(0xCF,0xFA),      o2(0xF3,0xCA),
          o2(0xE0,0xD7),      o2(0xD1,0xC7),
          o2(0xE9,0xAE),      o2(0xE8,0xBD),
          o2(0xFA,0xC4),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_25 = {
    to_EUC_KR_E9_25_offsets,
    to_CP949_E9_25_infos
};


static const struct byte_lookup* const
to_CP949_E9_26_infos[13] = {
          o2(0xE2,0xCF),      o2(0xFA,0xC5),
          o2(0xF9,0xB8),      o2(0xDC,0xE0),
          o2(0xFB,0xB0),      o2(0xD8,0xA9),
          o2(0xE5,0xDF),      o2(0xF9,0xA7),
          o2(0xF6,0xEE),      o2(0xF6,0xCC),
          o2(0xE2,0xF8),      o2(0xEC,0xF1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_26 = {
    to_EUC_KR_E9_26_offsets,
    to_CP949_E9_26_infos
};


static const struct byte_lookup* const
to_CP949_E9_27_infos[12] = {
          o2(0xDA,0xE0),      o2(0xF1,0xD2),
          o2(0xD2,0xCC),      o2(0xCF,0xCB),
          o2(0xCA,0xBD),      o2(0xDD,0xBF),
          o2(0xF6,0xEF),      o2(0xDE,0xF9),
          o2(0xFA,0xB4),      o2(0xD5,0xAD),
          o2(0xF1,0xE7),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_27 = {
    to_EUC_KR_E9_27_offsets,
    to_CP949_E9_27_infos
};


static const struct byte_lookup* const
to_CP949_E9_28_infos[10] = {
          o2(0xDE,0xBE),      o2(0xDC,0xC0),
          o2(0xD1,0xC8),      o2(0xD1,0xC9),
          o2(0xF8,0xBE),      o2(0xCB,0xF6),
          o2(0xD4,0xF9),      o2(0xF5,0xE2),
          o2(0xE1,0xD3),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_28 = {
    to_EUC_KR_E9_28_offsets,
    to_CP949_E9_28_infos
};


static const struct byte_lookup* const
to_CP949_E9_29_infos[14] = {
          o2(0xD8,0xE9),      o2(0xF8,0xFE),
          o2(0xCF,0xCC),      o2(0xFD,0xA4),
          o2(0xCE,0xF6),      o2(0xFA,0xD0),
          o2(0xCC,0xF3),      o2(0xE6,0xBE),
          o2(0xF6,0xAE),      o2(0xD5,0xF0),
          o2(0xD1,0xCA),      o2(0xFC,0xBE),
          o2(0xD5,0xF1),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_29 = {
    to_EUC_KR_E9_29_offsets,
    to_CP949_E9_29_infos
};


static const struct byte_lookup* const
to_CP949_E9_2A_infos[3] = {
          o2(0xCD,0xE9),      o2(0xFA,0xB5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_2A = {
    to_EUC_KR_E9_2A_offsets,
    to_CP949_E9_2A_infos
};


static const struct byte_lookup* const
to_CP949_E9_2B_infos[6] = {
          o2(0xE2,0xD0),      o2(0xF4,0xF7),
          o2(0xCD,0xD4),      o2(0xE7,0xA3),
          o2(0xDB,0xA5),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_2B = {
    to_EUC_KR_E9_2B_offsets,
    to_CP949_E9_2B_infos
};


static const struct byte_lookup* const
to_CP949_E9_2C_infos[6] = {
          o2(0xE2,0xD1),      o2(0xD7,0xA2),
          o2(0xF7,0xE3),      o2(0xEA,0xA6),
          o2(0xD0,0xA1),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_2C = {
    to_EUC_KR_E9_2C_offsets,
    to_CP949_E9_2C_infos
};


static const struct byte_lookup* const
to_CP949_E9_2D_infos[10] = {
          o2(0xCE,0xDA),      o2(0xFB,0xEB),
          o2(0xDB,0xA6),      o2(0xDB,0xDE),
          o2(0xD8,0xE5),      o2(0xEA,0xE0),
          o2(0xD8,0xAA),      o2(0xE5,0xE0),
          o2(0xD6,0xDB),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_2D = {
    to_EUC_KR_E9_2D_offsets,
    to_CP949_E9_2D_infos
};


static const struct byte_lookup* const
to_CP949_E9_2E_infos[6] = {
          o2(0xEF,0xC6),      o2(0xF8,0xEA),
          o2(0xE4,0xD5),      o2(0xCE,0xF7),
          o2(0xE0,0xD8),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_2E = {
    to_EUC_KR_E9_2E_offsets,
    to_CP949_E9_2E_infos
};


static const struct byte_lookup* const
to_CP949_E9_2F_infos[5] = {
          o2(0xD7,0xEF),      o2(0xF4,0xED),
          o2(0xCD,0xE6),      o2(0xCC,0xF4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_2F = {
    to_EUC_KR_E9_2F_offsets,
    to_CP949_E9_2F_infos
};


static const struct byte_lookup* const
to_CP949_E9_30_infos[8] = {
          o2(0xF5,0xE3),      o2(0xE4,0xCA),
          o2(0xDC,0xE1),      o2(0xF9,0xC8),
          o2(0xFC,0xBF),      o2(0xE8,0xA7),
          o2(0xD8,0xC4),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_30 = {
    to_EUC_KR_E9_30_offsets,
    to_CP949_E9_30_infos
};


static const struct byte_lookup* const
to_CP949_E9_31_infos[4] = {
          o2(0xCB,0xBE),      o2(0xDC,0xAE),
          o2(0xD7,0xF7),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_31 = {
    to_EUC_KR_E9_31_offsets,
    to_CP949_E9_31_infos
};


static const struct byte_lookup* const
to_CP949_E9_33_infos[7] = {
          o2(0xF0,0xE8),      o2(0xDD,0xC0),
          o2(0xCF,0xCD),      o2(0xDC,0xF3),
          o2(0xD9,0xB0),      o2(0xE6,0xE9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_33 = {
    to_EUC_KR_E9_33_offsets,
    to_CP949_E9_33_infos
};


static const struct byte_lookup* const
to_CP949_E9_34_infos[6] = {
          o2(0xE4,0xBC),      o2(0xEA,0xC4),
          o2(0xE4,0xEC),      o2(0xE4,0xE5),
          o2(0xFB,0xF8),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_34 = {
    to_EUC_KR_E9_34_offsets,
    to_CP949_E9_34_infos
};


static const struct byte_lookup* const
to_CP949_E9_35_infos[7] = {
          o2(0xCC,0xBB),      o2(0xE4,0xBD),
          o2(0xCD,0xDC),      o2(0xD9,0xF7),
          o2(0xDD,0xDF),      o2(0xED,0xCE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_35 = {
    to_EUC_KR_E9_35_offsets,
    to_CP949_E9_35_infos
};


static const struct byte_lookup* const
to_CP949_E9_36_infos[4] = {
          o2(0xD9,0xD0),      o2(0xE5,0xA3),
          o2(0xF9,0xCD),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_36 = {
    to_EUC_KR_E9_36_offsets,
    to_CP949_E9_36_infos
};


static const struct byte_lookup* const
to_CP949_E9_37_infos[7] = {
          o2(0xCD,0xAE),      o2(0xCF,0xCE),
          o2(0xF6,0xAF),      o2(0xFD,0xD3),
          o2(0xEB,0xED),      o2(0xD6,0xDC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_37 = {
    to_EUC_KR_E9_37_offsets,
    to_CP949_E9_37_infos
};


static const struct byte_lookup* const
to_CP949_E9_38_infos[3] = {
          o2(0xE5,0xA4),      o2(0xD5,0xB6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_38 = {
    to_EUC_KR_E9_38_offsets,
    to_CP949_E9_38_infos
};


static const struct byte_lookup* const
to_CP949_E9_39_infos[5] = {
          o2(0xD6,0xDD),      o2(0xF9,0xE9),
          o2(0xE7,0xA4),      o2(0xD6,0xE3),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_39 = {
    to_EUC_KR_E9_39_offsets,
    to_CP949_E9_39_infos
};


static const struct byte_lookup* const
to_CP949_E9_3A_infos[11] = {
          o2(0xD1,0xCB),      o2(0xD6,0xE4),
          o2(0xD5,0xF2),      o2(0xDE,0xFA),
          o2(0xD7,0xF8),      o2(0xD8,0xEA),
          o2(0xCF,0xD5),      o2(0xD8,0xFD),
          o2(0xD8,0xAB),      o2(0xFD,0xCB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_3A = {
    to_EUC_KR_E9_3A_offsets,
    to_CP949_E9_3A_infos
};


static const struct byte_lookup* const
to_CP949_E9_3B_infos[12] = {
          o2(0xFC,0xDC),      o2(0xE0,0xA8),
          o2(0xD5,0xF3),      o2(0xFD,0xD9),
          o2(0xCC,0xA3),      o2(0xD9,0xF9),
          o2(0xD3,0xEA),      o2(0xF5,0xF5),
          o2(0xEF,0xC7),      o2(0xD3,0xDA),
          o2(0xDA,0xBD),              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_3B = {
    to_EUC_KR_E9_3B_offsets,
    to_CP949_E9_3B_infos
};


static const struct byte_lookup* const
to_CP949_E9_3C_infos[7] = {
          o2(0xE8,0xA8),      o2(0xDC,0xAF),
          o2(0xF0,0xA3),      o2(0xCD,0xD5),
          o2(0xE0,0xA9),      o2(0xDE,0xAC),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_3C = {
    to_EUC_KR_E9_3C_offsets,
    to_CP949_E9_3C_infos
};


static const struct byte_lookup* const
to_CP949_E9_3D_infos[11] = {
          o2(0xF0,0xBA),      o2(0xEE,0xB1),
          o2(0xEE,0xB2),      o2(0xF6,0xCD),
          o2(0xEE,0xD2),      o2(0xD6,0xC6),
          o2(0xE0,0xE5),      o2(0xF3,0xBB),
          o2(0xE5,0xE1),      o2(0xE4,0xCB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_3D = {
    to_EUC_KR_E9_3D_offsets,
    to_CP949_E9_3D_infos
};


static const struct byte_lookup* const
to_CP949_E9_3E_infos[5] = {
          o2(0xD7,0xA3),      o2(0xDB,0xC2),
          o2(0xCA,0xFE),      o2(0xCF,0xCF),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9_3E = {
    to_EUC_KR_E9_3E_offsets,
    to_CP949_E9_3E_infos
};


static const struct byte_lookup* const
to_CP949_E9_infos[60] = {
        &to_CP949_E9_00,    &to_CP949_E9_01,
        &to_CP949_E9_02,    &to_CP949_E9_03,
        &to_CP949_E9_04,    &to_CP949_E9_05,
        &to_CP949_E9_06,    &to_CP949_E9_07,
        &to_CP949_E9_08,    &to_CP949_E9_09,
        &to_CP949_E9_0A,    &to_CP949_E9_0B,
        &to_CP949_E9_0C,    &to_CP949_E9_0D,
        &to_CP949_E9_0E,    &to_CP949_E9_0F,
        &to_CP949_E9_10,    &to_CP949_E9_11,
        &to_CP949_E9_15,    &to_CP949_E9_16,
        &to_CP949_E9_17,    &to_CP949_E9_18,
        &to_CP949_E9_19,    &to_CP949_E9_1A,
        &to_CP949_E9_1B,    &to_CP949_E9_1C,
        &to_CP949_E9_1D,    &to_CP949_E9_1E,
        &to_CP949_E9_1F,    &to_CP949_E9_20,
        &to_CP949_E9_21,    &to_CP949_E9_22,
        &to_CP949_E9_23,    &to_CP949_E9_24,
        &to_CP949_E9_25,    &to_CP949_E9_26,
        &to_CP949_E9_27,    &to_CP949_E9_28,
        &to_CP949_E9_29,    &to_CP949_E9_2A,
        &to_CP949_E9_2B,    &to_CP949_E9_2C,
        &to_CP949_E9_2D,    &to_CP949_E9_2E,
        &to_CP949_E9_2F,    &to_CP949_E9_30,
        &to_CP949_E9_31,    &to_CP949_E9_33,
        &to_CP949_E9_34,    &to_CP949_E9_35,
        &to_CP949_E9_36,    &to_CP949_E9_37,
        &to_CP949_E9_38,    &to_CP949_E9_39,
        &to_CP949_E9_3A,    &to_CP949_E9_3B,
        &to_CP949_E9_3C,    &to_CP949_E9_3D,
        &to_CP949_E9_3E,              UNDEF,
};

static const BYTE_LOOKUP
to_CP949_E9 = {
    to_EUC_KR_E9_offsets,
    to_CP949_E9_infos
};


static const struct byte_lookup* const
to_CP949_EA_30_infos[65] = {
          o2(0xB0,0xA1),      o2(0xB0,0xA2),
          o2(0x81,0x41),      o2(0x81,0x42),
          o2(0xB0,0xA3),      o2(0x81,0x43),
          o2(0x81,0x44),      o2(0xB0,0xA4),
          o2(0xB0,0xA5),      o2(0xB0,0xA6),
          o2(0xB0,0xA7),      o2(0x81,0x45),
          o2(0x81,0x46),      o2(0x81,0x47),
          o2(0x81,0x48),      o2(0x81,0x49),
          o2(0xB0,0xA8),      o2(0xB0,0xA9),
          o2(0xB0,0xAA),      o2(0xB0,0xAB),
          o2(0xB0,0xAC),      o2(0xB0,0xAD),
          o2(0xB0,0xAE),      o2(0xB0,0xAF),
          o2(0x81,0x4A),      o2(0xB0,0xB0),
          o2(0xB0,0xB1),      o2(0xB0,0xB2),
          o2(0xB0,0xB3),      o2(0xB0,0xB4),
          o2(0x81,0x4B),      o2(0x81,0x4C),
          o2(0xB0,0xB5),      o2(0x81,0x4D),
          o2(0x81,0x4E),      o2(0x81,0x4F),
          o2(0xB0,0xB6),      o2(0x81,0x50),
          o2(0x81,0x51),      o2(0x81,0x52),
          o2(0x81,0x53),      o2(0x81,0x54),
          o2(0x81,0x55),      o2(0x81,0x56),
          o2(0xB0,0xB7),      o2(0xB0,0xB8),
          o2(0x81,0x57),      o2(0xB0,0xB9),
          o2(0xB0,0xBA),      o2(0xB0,0xBB),
          o2(0x81,0x58),      o2(0x81,0x59),
          o2(0x81,0x5A),      o2(0x81,0x61),
          o2(0x81,0x62),      o2(0x81,0x63),
          o2(0xB0,0xBC),      o2(0xB0,0xBD),
          o2(0x81,0x64),      o2(0x81,0x65),
          o2(0xB0,0xBE),      o2(0x81,0x66),
          o2(0x81,0x67),      o2(0x81,0x68),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EA_30 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EA_30_infos
};


static const struct byte_lookup* const
to_CP949_EA_31_infos[65] = {
          o2(0xB0,0xBF),      o2(0x81,0x69),
          o2(0x81,0x6A),      o2(0x81,0x6B),
          o2(0x81,0x6C),      o2(0x81,0x6D),
          o2(0x81,0x6E),      o2(0x81,0x6F),
          o2(0x81,0x70),      o2(0x81,0x71),
          o2(0x81,0x72),      o2(0xB0,0xC0),
          o2(0x81,0x73),      o2(0xB0,0xC1),
          o2(0x81,0x74),      o2(0x81,0x75),
          o2(0x81,0x76),      o2(0x81,0x77),
          o2(0x81,0x78),      o2(0x81,0x79),
          o2(0xB0,0xC2),      o2(0x81,0x7A),
          o2(0x81,0x81),      o2(0x81,0x82),
          o2(0xB0,0xC3),      o2(0x81,0x83),
          o2(0x81,0x84),      o2(0x81,0x85),
          o2(0xB0,0xC4),      o2(0x81,0x86),
          o2(0x81,0x87),      o2(0x81,0x88),
          o2(0x81,0x89),      o2(0x81,0x8A),
          o2(0x81,0x8B),      o2(0x81,0x8C),
          o2(0x81,0x8D),      o2(0x81,0x8E),
          o2(0x81,0x8F),      o2(0x81,0x90),
          o2(0x81,0x91),      o2(0x81,0x92),
          o2(0x81,0x93),      o2(0x81,0x94),
          o2(0x81,0x95),      o2(0x81,0x96),
          o2(0x81,0x97),      o2(0x81,0x98),
          o2(0xB0,0xC5),      o2(0xB0,0xC6),
          o2(0x81,0x99),      o2(0x81,0x9A),
          o2(0xB0,0xC7),      o2(0x81,0x9B),
          o2(0x81,0x9C),      o2(0xB0,0xC8),
          o2(0xB0,0xC9),      o2(0x81,0x9D),
          o2(0xB0,0xCA),      o2(0x81,0x9E),
          o2(0x81,0x9F),      o2(0x81,0xA0),
          o2(0x81,0xA1),      o2(0x81,0xA2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EA_31 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EA_31_infos
};


static const struct byte_lookup* const
to_CP949_EA_32_infos[65] = {
          o2(0xB0,0xCB),      o2(0xB0,0xCC),
          o2(0x81,0xA3),      o2(0xB0,0xCD),
          o2(0xB0,0xCE),      o2(0xB0,0xCF),
          o2(0xB0,0xD0),      o2(0x81,0xA4),
          o2(0x81,0xA5),      o2(0xB0,0xD1),
          o2(0xB0,0xD2),      o2(0xB0,0xD3),
          o2(0xB0,0xD4),      o2(0x81,0xA6),
          o2(0x81,0xA7),      o2(0x81,0xA8),
          o2(0xB0,0xD5),      o2(0x81,0xA9),
          o2(0x81,0xAA),      o2(0x81,0xAB),
          o2(0xB0,0xD6),      o2(0x81,0xAC),
          o2(0x81,0xAD),      o2(0x81,0xAE),
          o2(0x81,0xAF),      o2(0x81,0xB0),
          o2(0x81,0xB1),      o2(0x81,0xB2),
          o2(0xB0,0xD7),      o2(0xB0,0xD8),
          o2(0x81,0xB3),      o2(0xB0,0xD9),
          o2(0xB0,0xDA),      o2(0xB0,0xDB),
          o2(0x81,0xB4),      o2(0x81,0xB5),
          o2(0x81,0xB6),      o2(0x81,0xB7),
          o2(0x81,0xB8),      o2(0x81,0xB9),
          o2(0xB0,0xDC),      o2(0xB0,0xDD),
          o2(0xB0,0xDE),      o2(0x81,0xBA),
          o2(0xB0,0xDF),      o2(0x81,0xBB),
          o2(0x81,0xBC),      o2(0xB0,0xE0),
          o2(0xB0,0xE1),      o2(0x81,0xBD),
          o2(0x81,0xBE),      o2(0x81,0xBF),
          o2(0x81,0xC0),      o2(0x81,0xC1),
          o2(0x81,0xC2),      o2(0x81,0xC3),
          o2(0xB0,0xE2),      o2(0xB0,0xE3),
          o2(0x81,0xC4),      o2(0xB0,0xE4),
          o2(0xB0,0xE5),      o2(0xB0,0xE6),
          o2(0x81,0xC5),      o2(0x81,0xC6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EA_32 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EA_32_infos
};


static const struct byte_lookup* const
to_CP949_EA_33_infos[65] = {
          o2(0x81,0xC7),      o2(0xB0,0xE7),
          o2(0x81,0xC8),      o2(0x81,0xC9),
          o2(0xB0,0xE8),      o2(0x81,0xCA),
          o2(0x81,0xCB),      o2(0x81,0xCC),
          o2(0xB0,0xE9),      o2(0x81,0xCD),
          o2(0x81,0xCE),      o2(0x81,0xCF),
          o2(0xB0,0xEA),      o2(0x81,0xD0),
          o2(0x81,0xD1),      o2(0x81,0xD2),
          o2(0x81,0xD3),      o2(0x81,0xD4),
          o2(0x81,0xD5),      o2(0x81,0xD6),
          o2(0x81,0xD7),      o2(0xB0,0xEB),
          o2(0x81,0xD8),      o2(0xB0,0xEC),
          o2(0x81,0xD9),      o2(0x81,0xDA),
          o2(0x81,0xDB),      o2(0x81,0xDC),
          o2(0x81,0xDD),      o2(0x81,0xDE),
          o2(0x81,0xDF),      o2(0x81,0xE0),
          o2(0xB0,0xED),      o2(0xB0,0xEE),
          o2(0x81,0xE1),      o2(0x81,0xE2),
          o2(0xB0,0xEF),      o2(0x81,0xE3),
          o2(0x81,0xE4),      o2(0xB0,0xF0),
          o2(0xB0,0xF1),      o2(0x81,0xE5),
          o2(0xB0,0xF2),      o2(0x81,0xE6),
          o2(0xB0,0xF3),      o2(0x81,0xE7),
          o2(0x81,0xE8),      o2(0xB0,0xF4),
          o2(0xB0,0xF5),      o2(0xB0,0xF6),
          o2(0x81,0xE9),      o2(0xB0,0xF7),
          o2(0x81,0xEA),      o2(0xB0,0xF8),
          o2(0xB0,0xF9),      o2(0x81,0xEB),
          o2(0x81,0xEC),      o2(0x81,0xED),
          o2(0x81,0xEE),      o2(0x81,0xEF),
          o2(0xB0,0xFA),      o2(0xB0,0xFB),
          o2(0x81,0xF0),      o2(0x81,0xF1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EA_33 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EA_33_infos
};


static const struct byte_lookup* const
to_CP949_EA_34_infos[65] = {
          o2(0xB0,0xFC),      o2(0x81,0xF2),
          o2(0x81,0xF3),      o2(0x81,0xF4),
          o2(0xB0,0xFD),      o2(0x81,0xF5),
          o2(0xB0,0xFE),      o2(0x81,0xF6),
          o2(0x81,0xF7),      o2(0x81,0xF8),
          o2(0x81,0xF9),      o2(0x81,0xFA),
          o2(0xB1,0xA1),      o2(0xB1,0xA2),
          o2(0x81,0xFB),      o2(0xB1,0xA3),
          o2(0x81,0xFC),      o2(0xB1,0xA4),
          o2(0x81,0xFD),      o2(0x81,0xFE),
          o2(0x82,0x41),      o2(0x82,0x42),
          o2(0x82,0x43),      o2(0x82,0x44),
          o2(0xB1,0xA5),      o2(0x82,0x45),
          o2(0x82,0x46),      o2(0x82,0x47),
          o2(0xB1,0xA6),      o2(0x82,0x48),
          o2(0x82,0x49),      o2(0x82,0x4A),
          o2(0xB1,0xA7),      o2(0x82,0x4B),
          o2(0x82,0x4C),      o2(0x82,0x4D),
          o2(0x82,0x4E),      o2(0x82,0x4F),
          o2(0x82,0x50),      o2(0x82,0x51),
          o2(0x82,0x52),      o2(0xB1,0xA8),
          o2(0x82,0x53),      o2(0x82,0x54),
          o2(0xB1,0xA9),      o2(0xB1,0xAA),
          o2(0x82,0x55),      o2(0x82,0x56),
          o2(0x82,0x57),      o2(0x82,0x58),
          o2(0x82,0x59),      o2(0x82,0x5A),
          o2(0xB1,0xAB),      o2(0xB1,0xAC),
          o2(0x82,0x61),      o2(0x82,0x62),
          o2(0xB1,0xAD),      o2(0x82,0x63),
          o2(0x82,0x64),      o2(0x82,0x65),
          o2(0xB1,0xAE),      o2(0x82,0x66),
          o2(0x82,0x67),      o2(0x82,0x68),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EA_34 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EA_34_infos
};


static const struct byte_lookup* const
to_CP949_EA_35_infos[65] = {
          o2(0x82,0x69),      o2(0x82,0x6A),
          o2(0x82,0x6B),      o2(0x82,0x6C),
          o2(0xB1,0xAF),      o2(0xB1,0xB0),
          o2(0x82,0x6D),      o2(0xB1,0xB1),
          o2(0x82,0x6E),      o2(0xB1,0xB2),
          o2(0x82,0x6F),      o2(0x82,0x70),
          o2(0x82,0x71),      o2(0x82,0x72),
          o2(0x82,0x73),      o2(0x82,0x74),
          o2(0xB1,0xB3),      o2(0x82,0x75),
          o2(0x82,0x76),      o2(0x82,0x77),
          o2(0xB1,0xB4),      o2(0x82,0x78),
          o2(0x82,0x79),      o2(0x82,0x7A),
          o2(0xB1,0xB5),      o2(0x82,0x81),
          o2(0x82,0x82),      o2(0x82,0x83),
          o2(0x82,0x84),      o2(0x82,0x85),
          o2(0x82,0x86),      o2(0x82,0x87),
          o2(0x82,0x88),      o2(0xB1,0xB6),
          o2(0x82,0x89),      o2(0xB1,0xB7),
          o2(0x82,0x8A),      o2(0x82,0x8B),
          o2(0x82,0x8C),      o2(0x82,0x8D),
          o2(0x82,0x8E),      o2(0x82,0x8F),
          o2(0x82,0x90),      o2(0x82,0x91),
          o2(0xB1,0xB8),      o2(0xB1,0xB9),
          o2(0x82,0x92),      o2(0x82,0x93),
          o2(0xB1,0xBA),      o2(0x82,0x94),
          o2(0x82,0x95),      o2(0xB1,0xBB),
          o2(0xB1,0xBC),      o2(0xB1,0xBD),
          o2(0xB1,0xBE),      o2(0x82,0x96),
          o2(0x82,0x97),      o2(0x82,0x98),
          o2(0x82,0x99),      o2(0xB1,0xBF),
          o2(0xB1,0xC0),      o2(0xB1,0xC1),
          o2(0x82,0x9A),      o2(0xB1,0xC2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EA_35 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EA_35_infos
};


static const struct byte_lookup* const
to_CP949_EA_36_infos[65] = {
          o2(0x82,0x9B),      o2(0xB1,0xC3),
          o2(0xB1,0xC4),      o2(0x82,0x9C),
          o2(0x82,0x9D),      o2(0x82,0x9E),
          o2(0x82,0x9F),      o2(0x82,0xA0),
          o2(0xB1,0xC5),      o2(0xB1,0xC6),
          o2(0x82,0xA1),      o2(0x82,0xA2),
          o2(0xB1,0xC7),      o2(0x82,0xA3),
          o2(0x82,0xA4),      o2(0x82,0xA5),
          o2(0xB1,0xC8),      o2(0x82,0xA6),
          o2(0x82,0xA7),      o2(0x82,0xA8),
          o2(0x82,0xA9),      o2(0x82,0xAA),
          o2(0x82,0xAB),      o2(0x82,0xAC),
          o2(0x82,0xAD),      o2(0x82,0xAE),
          o2(0x82,0xAF),      o2(0x82,0xB0),
          o2(0xB1,0xC9),      o2(0xB1,0xCA),
          o2(0x82,0xB1),      o2(0x82,0xB2),
          o2(0x82,0xB3),      o2(0x82,0xB4),
          o2(0x82,0xB5),      o2(0x82,0xB6),
          o2(0xB1,0xCB),      o2(0x82,0xB7),
          o2(0x82,0xB8),      o2(0x82,0xB9),
          o2(0x82,0xBA),      o2(0x82,0xBB),
          o2(0x82,0xBC),      o2(0x82,0xBD),
          o2(0x82,0xBE),      o2(0x82,0xBF),
          o2(0x82,0xC0),      o2(0x82,0xC1),
          o2(0x82,0xC2),      o2(0x82,0xC3),
          o2(0x82,0xC4),      o2(0x82,0xC5),
          o2(0x82,0xC6),      o2(0x82,0xC7),
          o2(0x82,0xC8),      o2(0xB1,0xCC),
          o2(0x82,0xC9),      o2(0x82,0xCA),
          o2(0x82,0xCB),      o2(0x82,0xCC),
          o2(0x82,0xCD),      o2(0x82,0xCE),
          o2(0x82,0xCF),      o2(0x82,0xD0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EA_36 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EA_36_infos
};


static const struct byte_lookup* const
to_CP949_EA_37_infos[65] = {
          o2(0xB1,0xCD),      o2(0xB1,0xCE),
          o2(0x82,0xD1),      o2(0x82,0xD2),
          o2(0xB1,0xCF),      o2(0x82,0xD3),
          o2(0x82,0xD4),      o2(0x82,0xD5),
          o2(0xB1,0xD0),      o2(0x82,0xD6),
          o2(0x82,0xD7),      o2(0x82,0xD8),
          o2(0x82,0xD9),      o2(0x82,0xDA),
          o2(0x82,0xDB),      o2(0x82,0xDC),
          o2(0xB1,0xD1),      o2(0xB1,0xD2),
          o2(0x82,0xDD),      o2(0xB1,0xD3),
          o2(0x82,0xDE),      o2(0x82,0xDF),
          o2(0x82,0xE0),      o2(0x82,0xE1),
          o2(0x82,0xE2),      o2(0x82,0xE3),
          o2(0x82,0xE4),      o2(0x82,0xE5),
          o2(0xB1,0xD4),      o2(0x82,0xE6),
          o2(0x82,0xE7),      o2(0x82,0xE8),
          o2(0xB1,0xD5),      o2(0x82,0xE9),
          o2(0x82,0xEA),      o2(0x82,0xEB),
          o2(0xB1,0xD6),      o2(0x82,0xEC),
          o2(0x82,0xED),      o2(0x82,0xEE),
          o2(0x82,0xEF),      o2(0x82,0xF0),
          o2(0x82,0xF1),      o2(0x82,0xF2),
          o2(0x82,0xF3),      o2(0x82,0xF4),
          o2(0x82,0xF5),      o2(0x82,0xF6),
          o2(0x82,0xF7),      o2(0x82,0xF8),
          o2(0x82,0xF9),      o2(0x82,0xFA),
          o2(0x82,0xFB),      o2(0x82,0xFC),
          o2(0x82,0xFD),      o2(0x82,0xFE),
          o2(0xB1,0xD7),      o2(0xB1,0xD8),
          o2(0x83,0x41),      o2(0x83,0x42),
          o2(0xB1,0xD9),      o2(0x83,0x43),
          o2(0x83,0x44),      o2(0xB1,0xDA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EA_37 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EA_37_infos
};


static const struct byte_lookup* const
to_CP949_EA_38_infos[65] = {
          o2(0xB1,0xDB),      o2(0xB1,0xDC),
          o2(0x83,0x45),      o2(0x83,0x46),
          o2(0x83,0x47),      o2(0x83,0x48),
          o2(0x83,0x49),      o2(0x83,0x4A),
          o2(0xB1,0xDD),      o2(0xB1,0xDE),
          o2(0x83,0x4B),      o2(0xB1,0xDF),
          o2(0x83,0x4C),      o2(0xB1,0xE0),
          o2(0x83,0x4D),      o2(0x83,0x4E),
          o2(0x83,0x4F),      o2(0x83,0x50),
          o2(0x83,0x51),      o2(0x83,0x52),
          o2(0xB1,0xE1),      o2(0x83,0x53),
          o2(0x83,0x54),      o2(0x83,0x55),
          o2(0x83,0x56),      o2(0x83,0x57),
          o2(0x83,0x58),      o2(0x83,0x59),
          o2(0x83,0x5A),      o2(0x83,0x61),
          o2(0x83,0x62),      o2(0x83,0x63),
          o2(0x83,0x64),      o2(0x83,0x65),
          o2(0x83,0x66),      o2(0x83,0x67),
          o2(0x83,0x68),      o2(0x83,0x69),
          o2(0x83,0x6A),      o2(0x83,0x6B),
          o2(0x83,0x6C),      o2(0x83,0x6D),
          o2(0x83,0x6E),      o2(0x83,0x6F),
          o2(0x83,0x70),      o2(0x83,0x71),
          o2(0x83,0x72),      o2(0x83,0x73),
          o2(0xB1,0xE2),      o2(0xB1,0xE3),
          o2(0x83,0x74),      o2(0x83,0x75),
          o2(0xB1,0xE4),      o2(0x83,0x76),
          o2(0x83,0x77),      o2(0xB1,0xE5),
          o2(0xB1,0xE6),      o2(0x83,0x78),
          o2(0xB1,0xE7),      o2(0x83,0x79),
          o2(0x83,0x7A),      o2(0x83,0x81),
          o2(0x83,0x82),      o2(0x83,0x83),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EA_38 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EA_38_infos
};


static const struct byte_lookup* const
to_CP949_EA_39_infos[65] = {
          o2(0xB1,0xE8),      o2(0xB1,0xE9),
          o2(0x83,0x84),      o2(0xB1,0xEA),
          o2(0x83,0x85),      o2(0xB1,0xEB),
          o2(0xB1,0xEC),      o2(0x83,0x86),
          o2(0x83,0x87),      o2(0x83,0x88),
          o2(0xB1,0xED),      o2(0x83,0x89),
          o2(0xB1,0xEE),      o2(0xB1,0xEF),
          o2(0xB1,0xF0),      o2(0x83,0x8A),
          o2(0xB1,0xF1),      o2(0x83,0x8B),
          o2(0x83,0x8C),      o2(0x83,0x8D),
          o2(0xB1,0xF2),      o2(0x83,0x8E),
          o2(0xB1,0xF3),      o2(0x83,0x8F),
          o2(0x83,0x90),      o2(0x83,0x91),
          o2(0x83,0x92),      o2(0x83,0x93),
          o2(0xB1,0xF4),      o2(0xB1,0xF5),
          o2(0x83,0x94),      o2(0xB1,0xF6),
          o2(0xB1,0xF7),      o2(0xB1,0xF8),
          o2(0x83,0x95),      o2(0x83,0x96),
          o2(0x83,0x97),      o2(0xB1,0xF9),
          o2(0x83,0x98),      o2(0x83,0x99),
          o2(0xB1,0xFA),      o2(0xB1,0xFB),
          o2(0x83,0x9A),      o2(0x83,0x9B),
          o2(0xB1,0xFC),      o2(0x83,0x9C),
          o2(0x83,0x9D),      o2(0x83,0x9E),
          o2(0xB1,0xFD),      o2(0x83,0x9F),
          o2(0x83,0xA0),      o2(0x83,0xA1),
          o2(0x83,0xA2),      o2(0x83,0xA3),
          o2(0x83,0xA4),      o2(0x83,0xA5),
          o2(0xB1,0xFE),      o2(0xB2,0xA1),
          o2(0x83,0xA6),      o2(0xB2,0xA2),
          o2(0xB2,0xA3),      o2(0xB2,0xA4),
          o2(0x83,0xA7),      o2(0x83,0xA8),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EA_39 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EA_39_infos
};


static const struct byte_lookup* const
to_CP949_EA_3A_infos[65] = {
          o2(0x83,0xA9),      o2(0x83,0xAA),
          o2(0x83,0xAB),      o2(0x83,0xAC),
          o2(0xB2,0xA5),      o2(0xB2,0xA6),
          o2(0x83,0xAD),      o2(0x83,0xAE),
          o2(0x83,0xAF),      o2(0x83,0xB0),
          o2(0x83,0xB1),      o2(0x83,0xB2),
          o2(0xB2,0xA7),      o2(0x83,0xB3),
          o2(0x83,0xB4),      o2(0x83,0xB5),
          o2(0x83,0xB6),      o2(0x83,0xB7),
          o2(0x83,0xB8),      o2(0x83,0xB9),
          o2(0x83,0xBA),      o2(0x83,0xBB),
          o2(0x83,0xBC),      o2(0x83,0xBD),
          o2(0x83,0xBE),      o2(0x83,0xBF),
          o2(0x83,0xC0),      o2(0x83,0xC1),
          o2(0x83,0xC2),      o2(0x83,0xC3),
          o2(0x83,0xC4),      o2(0x83,0xC5),
          o2(0x83,0xC6),      o2(0x83,0xC7),
          o2(0x83,0xC8),      o2(0x83,0xC9),
          o2(0x83,0xCA),      o2(0x83,0xCB),
          o2(0x83,0xCC),      o2(0x83,0xCD),
          o2(0x83,0xCE),      o2(0x83,0xCF),
          o2(0x83,0xD0),      o2(0x83,0xD1),
          o2(0x83,0xD2),      o2(0x83,0xD3),
          o2(0x83,0xD4),      o2(0x83,0xD5),
          o2(0x83,0xD6),      o2(0x83,0xD7),
          o2(0x83,0xD8),      o2(0x83,0xD9),
          o2(0x83,0xDA),      o2(0x83,0xDB),
          o2(0x83,0xDC),      o2(0x83,0xDD),
          o2(0x83,0xDE),      o2(0x83,0xDF),
          o2(0x83,0xE0),      o2(0x83,0xE1),
          o2(0xB2,0xA8),      o2(0xB2,0xA9),
          o2(0xB2,0xAA),      o2(0x83,0xE2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EA_3A = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EA_3A_infos
};


static const struct byte_lookup* const
to_CP949_EA_3B_infos[65] = {
          o2(0xB2,0xAB),      o2(0x83,0xE3),
          o2(0x83,0xE4),      o2(0x83,0xE5),
          o2(0xB2,0xAC),      o2(0x83,0xE6),
          o2(0x83,0xE7),      o2(0x83,0xE8),
          o2(0x83,0xE9),      o2(0x83,0xEA),
          o2(0x83,0xEB),      o2(0x83,0xEC),
          o2(0xB2,0xAD),      o2(0xB2,0xAE),
          o2(0x83,0xED),      o2(0xB2,0xAF),
          o2(0xB2,0xB0),      o2(0xB2,0xB1),
          o2(0x83,0xEE),      o2(0x83,0xEF),
          o2(0x83,0xF0),      o2(0x83,0xF1),
          o2(0x83,0xF2),      o2(0x83,0xF3),
          o2(0xB2,0xB2),      o2(0xB2,0xB3),
          o2(0x83,0xF4),      o2(0x83,0xF5),
          o2(0xB2,0xB4),      o2(0x83,0xF6),
          o2(0x83,0xF7),      o2(0x83,0xF8),
          o2(0x83,0xF9),      o2(0x83,0xFA),
          o2(0x83,0xFB),      o2(0x83,0xFC),
          o2(0x83,0xFD),      o2(0x83,0xFE),
          o2(0x84,0x41),      o2(0x84,0x42),
          o2(0xB2,0xB5),      o2(0x84,0x43),
          o2(0x84,0x44),      o2(0xB2,0xB6),
          o2(0x84,0x45),      o2(0xB2,0xB7),
          o2(0x84,0x46),      o2(0x84,0x47),
          o2(0x84,0x48),      o2(0x84,0x49),
          o2(0x84,0x4A),      o2(0x84,0x4B),
          o2(0xB2,0xB8),      o2(0x84,0x4C),
          o2(0x84,0x4D),      o2(0x84,0x4E),
          o2(0xB2,0xB9),      o2(0x84,0x4F),
          o2(0x84,0x50),      o2(0x84,0x51),
          o2(0xB2,0xBA),      o2(0x84,0x52),
          o2(0x84,0x53),      o2(0x84,0x54),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EA_3B = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EA_3B_infos
};


static const struct byte_lookup* const
to_CP949_EA_3C_infos[65] = {
          o2(0x84,0x55),      o2(0x84,0x56),
          o2(0x84,0x57),      o2(0x84,0x58),
          o2(0x84,0x59),      o2(0x84,0x5A),
          o2(0x84,0x61),      o2(0xB2,0xBB),
          o2(0xB2,0xBC),      o2(0x84,0x62),
          o2(0x84,0x63),      o2(0x84,0x64),
          o2(0x84,0x65),      o2(0xB2,0xBD),
          o2(0x84,0x66),      o2(0x84,0x67),
          o2(0xB2,0xBE),      o2(0x84,0x68),
          o2(0x84,0x69),      o2(0x84,0x6A),
          o2(0x84,0x6B),      o2(0x84,0x6C),
          o2(0x84,0x6D),      o2(0x84,0x6E),
          o2(0x84,0x6F),      o2(0x84,0x70),
          o2(0x84,0x71),      o2(0x84,0x72),
          o2(0x84,0x73),      o2(0x84,0x74),
          o2(0x84,0x75),      o2(0x84,0x76),
          o2(0x84,0x77),      o2(0x84,0x78),
          o2(0x84,0x79),      o2(0x84,0x7A),
          o2(0x84,0x81),      o2(0x84,0x82),
          o2(0x84,0x83),      o2(0x84,0x84),
          o2(0x84,0x85),      o2(0x84,0x86),
          o2(0x84,0x87),      o2(0x84,0x88),
          o2(0xB2,0xBF),      o2(0xB2,0xC0),
          o2(0x84,0x89),      o2(0x84,0x8A),
          o2(0xB2,0xC1),      o2(0x84,0x8B),
          o2(0xB2,0xC2),      o2(0x84,0x8C),
          o2(0xB2,0xC3),      o2(0x84,0x8D),
          o2(0x84,0x8E),      o2(0x84,0x8F),
          o2(0x84,0x90),      o2(0x84,0x91),
          o2(0x84,0x92),      o2(0x84,0x93),
          o2(0xB2,0xC4),      o2(0xB2,0xC5),
          o2(0x84,0x94),      o2(0xB2,0xC6),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EA_3C = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EA_3C_infos
};


static const struct byte_lookup* const
to_CP949_EA_3D_infos[65] = {
          o2(0x84,0x95),      o2(0xB2,0xC7),
          o2(0xB2,0xC8),      o2(0xB2,0xC9),
          o2(0x84,0x96),      o2(0x84,0x97),
          o2(0x84,0x98),      o2(0x84,0x99),
          o2(0xB2,0xCA),      o2(0xB2,0xCB),
          o2(0x84,0x9A),      o2(0x84,0x9B),
          o2(0x84,0x9C),      o2(0x84,0x9D),
          o2(0x84,0x9E),      o2(0x84,0x9F),
          o2(0xB2,0xCC),      o2(0x84,0xA0),
          o2(0x84,0xA1),      o2(0x84,0xA2),
          o2(0x84,0xA3),      o2(0x84,0xA4),
          o2(0x84,0xA5),      o2(0x84,0xA6),
          o2(0x84,0xA7),      o2(0x84,0xA8),
          o2(0x84,0xA9),      o2(0x84,0xAA),
          o2(0xB2,0xCD),      o2(0xB2,0xCE),
          o2(0x84,0xAB),      o2(0x84,0xAC),
          o2(0x84,0xAD),      o2(0x84,0xAE),
          o2(0x84,0xAF),      o2(0x84,0xB0),
          o2(0xB2,0xCF),      o2(0xB2,0xD0),
          o2(0x84,0xB1),      o2(0x84,0xB2),
          o2(0x84,0xB3),      o2(0x84,0xB4),
          o2(0x84,0xB5),      o2(0x84,0xB6),
          o2(0x84,0xB7),      o2(0x84,0xB8),
          o2(0x84,0xB9),      o2(0x84,0xBA),
          o2(0x84,0xBB),      o2(0x84,0xBC),
          o2(0x84,0xBD),      o2(0x84,0xBE),
          o2(0x84,0xBF),      o2(0x84,0xC0),
          o2(0x84,0xC1),      o2(0x84,0xC2),
          o2(0x84,0xC3),      o2(0xB2,0xD1),
          o2(0x84,0xC4),      o2(0x84,0xC5),
          o2(0x84,0xC6),      o2(0x84,0xC7),
          o2(0x84,0xC8),      o2(0x84,0xC9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EA_3D = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EA_3D_infos
};


static const struct byte_lookup* const
to_CP949_EA_3E_infos[65] = {
          o2(0xB2,0xD2),      o2(0x84,0xCA),
          o2(0x84,0xCB),      o2(0x84,0xCC),
          o2(0xB2,0xD3),      o2(0x84,0xCD),
          o2(0x84,0xCE),      o2(0x84,0xCF),
          o2(0xB2,0xD4),      o2(0x84,0xD0),
          o2(0x84,0xD1),      o2(0x84,0xD2),
          o2(0x84,0xD3),      o2(0x84,0xD4),
          o2(0x84,0xD5),      o2(0x84,0xD6),
          o2(0xB2,0xD5),      o2(0xB2,0xD6),
          o2(0x84,0xD7),      o2(0x84,0xD8),
          o2(0x84,0xD9),      o2(0xB2,0xD7),
          o2(0x84,0xDA),      o2(0x84,0xDB),
          o2(0x84,0xDC),      o2(0x84,0xDD),
          o2(0x84,0xDE),      o2(0x84,0xDF),
          o2(0xB2,0xD8),      o2(0x84,0xE0),
          o2(0x84,0xE1),      o2(0x84,0xE2),
          o2(0x84,0xE3),      o2(0x84,0xE4),
          o2(0x84,0xE5),      o2(0x84,0xE6),
          o2(0x84,0xE7),      o2(0x84,0xE8),
          o2(0x84,0xE9),      o2(0x84,0xEA),
          o2(0x84,0xEB),      o2(0x84,0xEC),
          o2(0x84,0xED),      o2(0x84,0xEE),
          o2(0x84,0xEF),      o2(0x84,0xF0),
          o2(0x84,0xF1),      o2(0x84,0xF2),
          o2(0x84,0xF3),      o2(0x84,0xF4),
          o2(0x84,0xF5),      o2(0x84,0xF6),
          o2(0x84,0xF7),      o2(0x84,0xF8),
          o2(0x84,0xF9),      o2(0x84,0xFA),
          o2(0xB2,0xD9),      o2(0xB2,0xDA),
          o2(0x84,0xFB),      o2(0x84,0xFC),
          o2(0xB2,0xDB),      o2(0x84,0xFD),
          o2(0x84,0xFE),      o2(0x85,0x41),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EA_3E = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EA_3E_infos
};


static const struct byte_lookup* const
to_CP949_EA_3F_infos[65] = {
          o2(0xB2,0xDC),      o2(0x85,0x42),
          o2(0x85,0x43),      o2(0x85,0x44),
          o2(0x85,0x45),      o2(0x85,0x46),
          o2(0x85,0x47),      o2(0xB2,0xDD),
          o2(0xB2,0xDE),      o2(0xB2,0xDF),
          o2(0x85,0x48),      o2(0xB2,0xE0),
          o2(0x85,0x49),      o2(0xB2,0xE1),
          o2(0xB2,0xE2),      o2(0x85,0x4A),
          o2(0x85,0x4B),      o2(0x85,0x4C),
          o2(0x85,0x4D),      o2(0x85,0x4E),
          o2(0xB2,0xE3),      o2(0x85,0x4F),
          o2(0x85,0x50),      o2(0x85,0x51),
          o2(0x85,0x52),      o2(0x85,0x53),
          o2(0x85,0x54),      o2(0x85,0x55),
          o2(0xB2,0xE4),      o2(0x85,0x56),
          o2(0x85,0x57),      o2(0x85,0x58),
          o2(0x85,0x59),      o2(0x85,0x5A),
          o2(0x85,0x61),      o2(0x85,0x62),
          o2(0x85,0x63),      o2(0x85,0x64),
          o2(0x85,0x65),      o2(0x85,0x66),
          o2(0xB2,0xE5),      o2(0xB2,0xE6),
          o2(0x85,0x67),      o2(0x85,0x68),
          o2(0x85,0x69),      o2(0x85,0x6A),
          o2(0x85,0x6B),      o2(0x85,0x6C),
          o2(0xB2,0xE7),      o2(0xB2,0xE8),
          o2(0x85,0x6D),      o2(0x85,0x6E),
          o2(0xB2,0xE9),      o2(0x85,0x6F),
          o2(0x85,0x70),      o2(0x85,0x71),
          o2(0xB2,0xEA),      o2(0x85,0x72),
          o2(0x85,0x73),      o2(0x85,0x74),
          o2(0x85,0x75),      o2(0x85,0x76),
          o2(0x85,0x77),      o2(0x85,0x78),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EA_3F = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EA_3F_infos
};


static const struct byte_lookup* const
to_CP949_EA_infos[17] = {
        &to_CP949_EA_30,    &to_CP949_EA_31,
        &to_CP949_EA_32,    &to_CP949_EA_33,
        &to_CP949_EA_34,    &to_CP949_EA_35,
        &to_CP949_EA_36,    &to_CP949_EA_37,
        &to_CP949_EA_38,    &to_CP949_EA_39,
        &to_CP949_EA_3A,    &to_CP949_EA_3B,
        &to_CP949_EA_3C,    &to_CP949_EA_3D,
        &to_CP949_EA_3E,    &to_CP949_EA_3F,
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EA = {
    to_EUC_KR_EA_offsets,
    to_CP949_EA_infos
};


static const struct byte_lookup* const
to_CP949_EB_00_infos[65] = {
          o2(0xB2,0xEB),      o2(0xB2,0xEC),
          o2(0x85,0x79),      o2(0x85,0x7A),
          o2(0xB2,0xED),      o2(0x85,0x81),
          o2(0x85,0x82),      o2(0x85,0x83),
          o2(0x85,0x84),      o2(0x85,0x85),
          o2(0x85,0x86),      o2(0x85,0x87),
          o2(0xB2,0xEE),      o2(0x85,0x88),
          o2(0x85,0x89),      o2(0x85,0x8A),
          o2(0xB2,0xEF),      o2(0x85,0x8B),
          o2(0x85,0x8C),      o2(0x85,0x8D),
          o2(0xB2,0xF0),      o2(0x85,0x8E),
          o2(0x85,0x8F),      o2(0x85,0x90),
          o2(0x85,0x91),      o2(0x85,0x92),
          o2(0x85,0x93),      o2(0x85,0x94),
          o2(0xB2,0xF1),      o2(0xB2,0xF2),
          o2(0x85,0x95),      o2(0x85,0x96),
          o2(0x85,0x97),      o2(0x85,0x98),
          o2(0x85,0x99),      o2(0x85,0x9A),
          o2(0x85,0x9B),      o2(0x85,0x9C),
          o2(0x85,0x9D),      o2(0x85,0x9E),
          o2(0xB2,0xF3),      o2(0x85,0x9F),
          o2(0x85,0xA0),      o2(0x85,0xA1),
          o2(0x85,0xA2),      o2(0x85,0xA3),
          o2(0x85,0xA4),      o2(0x85,0xA5),
          o2(0x85,0xA6),      o2(0x85,0xA7),
          o2(0x85,0xA8),      o2(0x85,0xA9),
          o2(0x85,0xAA),      o2(0x85,0xAB),
          o2(0x85,0xAC),      o2(0x85,0xAD),
          o2(0x85,0xAE),      o2(0x85,0xAF),
          o2(0x85,0xB0),      o2(0x85,0xB1),
          o2(0x85,0xB2),      o2(0x85,0xB3),
          o2(0x85,0xB4),      o2(0x85,0xB5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_00 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_00_infos
};


static const struct byte_lookup* const
to_CP949_EB_01_infos[65] = {
          o2(0x85,0xB6),      o2(0x85,0xB7),
          o2(0x85,0xB8),      o2(0x85,0xB9),
          o2(0xB2,0xF4),      o2(0xB2,0xF5),
          o2(0x85,0xBA),      o2(0x85,0xBB),
          o2(0xB2,0xF6),      o2(0x85,0xBC),
          o2(0xB2,0xF7),      o2(0x85,0xBD),
          o2(0xB2,0xF8),      o2(0x85,0xBE),
          o2(0xB2,0xF9),      o2(0x85,0xBF),
          o2(0x85,0xC0),      o2(0x85,0xC1),
          o2(0x85,0xC2),      o2(0xB2,0xFA),
          o2(0xB2,0xFB),      o2(0xB2,0xFC),
          o2(0x85,0xC3),      o2(0xB2,0xFD),
          o2(0x85,0xC4),      o2(0xB2,0xFE),
          o2(0x85,0xC5),      o2(0x85,0xC6),
          o2(0x85,0xC7),      o2(0xB3,0xA1),
          o2(0x85,0xC8),      o2(0x85,0xC9),
          o2(0x85,0xCA),      o2(0x85,0xCB),
          o2(0x85,0xCC),      o2(0x85,0xCD),
          o2(0x85,0xCE),      o2(0x85,0xCF),
          o2(0x85,0xD0),      o2(0x85,0xD1),
          o2(0x85,0xD2),      o2(0x85,0xD3),
          o2(0x85,0xD4),      o2(0x85,0xD5),
          o2(0x85,0xD6),      o2(0x85,0xD7),
          o2(0x85,0xD8),      o2(0x85,0xD9),
          o2(0x85,0xDA),      o2(0x85,0xDB),
          o2(0x85,0xDC),      o2(0x85,0xDD),
          o2(0x85,0xDE),      o2(0x85,0xDF),
          o2(0x85,0xE0),      o2(0x85,0xE1),
          o2(0x85,0xE2),      o2(0x85,0xE3),
          o2(0x85,0xE4),      o2(0x85,0xE5),
          o2(0xB3,0xA2),      o2(0xB3,0xA3),
          o2(0x85,0xE6),      o2(0x85,0xE7),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_01 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_01_infos
};


static const struct byte_lookup* const
to_CP949_EB_02_infos[65] = {
          o2(0xB3,0xA4),      o2(0x85,0xE8),
          o2(0x85,0xE9),      o2(0x85,0xEA),
          o2(0xB3,0xA5),      o2(0x85,0xEB),
          o2(0x85,0xEC),      o2(0x85,0xED),
          o2(0x85,0xEE),      o2(0x85,0xEF),
          o2(0x85,0xF0),      o2(0x85,0xF1),
          o2(0xB3,0xA6),      o2(0xB3,0xA7),
          o2(0x85,0xF2),      o2(0xB3,0xA8),
          o2(0x85,0xF3),      o2(0xB3,0xA9),
          o2(0x85,0xF4),      o2(0x85,0xF5),
          o2(0x85,0xF6),      o2(0x85,0xF7),
          o2(0x85,0xF8),      o2(0x85,0xF9),
          o2(0xB3,0xAA),      o2(0xB3,0xAB),
          o2(0xB3,0xAC),      o2(0x85,0xFA),
          o2(0xB3,0xAD),      o2(0x85,0xFB),
          o2(0x85,0xFC),      o2(0xB3,0xAE),
          o2(0xB3,0xAF),      o2(0xB3,0xB0),
          o2(0xB3,0xB1),      o2(0x85,0xFD),
          o2(0x85,0xFE),      o2(0x86,0x41),
          o2(0x86,0x42),      o2(0x86,0x43),
          o2(0xB3,0xB2),      o2(0xB3,0xB3),
          o2(0x86,0x44),      o2(0xB3,0xB4),
          o2(0xB3,0xB5),      o2(0xB3,0xB6),
          o2(0xB3,0xB7),      o2(0xB3,0xB8),
          o2(0x86,0x45),      o2(0xB3,0xB9),
          o2(0x86,0x46),      o2(0xB3,0xBA),
          o2(0xB3,0xBB),      o2(0xB3,0xBC),
          o2(0x86,0x47),      o2(0x86,0x48),
          o2(0xB3,0xBD),      o2(0x86,0x49),
          o2(0x86,0x4A),      o2(0x86,0x4B),
          o2(0xB3,0xBE),      o2(0x86,0x4C),
          o2(0x86,0x4D),      o2(0x86,0x4E),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_02 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_02_infos
};


static const struct byte_lookup* const
to_CP949_EB_03_infos[65] = {
          o2(0x86,0x4F),      o2(0x86,0x50),
          o2(0x86,0x51),      o2(0x86,0x52),
          o2(0xB3,0xBF),      o2(0xB3,0xC0),
          o2(0x86,0x53),      o2(0xB3,0xC1),
          o2(0xB3,0xC2),      o2(0xB3,0xC3),
          o2(0x86,0x54),      o2(0x86,0x55),
          o2(0x86,0x56),      o2(0x86,0x57),
          o2(0x86,0x58),      o2(0x86,0x59),
          o2(0xB3,0xC4),      o2(0xB3,0xC5),
          o2(0x86,0x5A),      o2(0x86,0x61),
          o2(0xB3,0xC6),      o2(0x86,0x62),
          o2(0x86,0x63),      o2(0x86,0x64),
          o2(0xB3,0xC7),      o2(0x86,0x65),
          o2(0x86,0x66),      o2(0x86,0x67),
          o2(0x86,0x68),      o2(0x86,0x69),
          o2(0x86,0x6A),      o2(0x86,0x6B),
          o2(0xB3,0xC8),      o2(0x86,0x6C),
          o2(0x86,0x6D),      o2(0x86,0x6E),
          o2(0x86,0x6F),      o2(0xB3,0xC9),
          o2(0x86,0x70),      o2(0x86,0x71),
          o2(0x86,0x72),      o2(0x86,0x73),
          o2(0x86,0x74),      o2(0x86,0x75),
          o2(0x86,0x76),      o2(0x86,0x77),
          o2(0x86,0x78),      o2(0x86,0x79),
          o2(0x86,0x7A),      o2(0x86,0x81),
          o2(0x86,0x82),      o2(0x86,0x83),
          o2(0x86,0x84),      o2(0x86,0x85),
          o2(0x86,0x86),      o2(0x86,0x87),
          o2(0x86,0x88),      o2(0x86,0x89),
          o2(0x86,0x8A),      o2(0x86,0x8B),
          o2(0x86,0x8C),      o2(0x86,0x8D),
          o2(0x86,0x8E),      o2(0x86,0x8F),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_03 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_03_infos
};


static const struct byte_lookup* const
to_CP949_EB_04_infos[65] = {
          o2(0x86,0x90),      o2(0x86,0x91),
          o2(0x86,0x92),      o2(0x86,0x93),
          o2(0x86,0x94),      o2(0x86,0x95),
          o2(0x86,0x96),      o2(0x86,0x97),
          o2(0xB3,0xCA),      o2(0xB3,0xCB),
          o2(0x86,0x98),      o2(0xB3,0xCC),
          o2(0xB3,0xCD),      o2(0x86,0x99),
          o2(0x86,0x9A),      o2(0x86,0x9B),
          o2(0xB3,0xCE),      o2(0x86,0x9C),
          o2(0xB3,0xCF),      o2(0xB3,0xD0),
          o2(0x86,0x9D),      o2(0x86,0x9E),
          o2(0x86,0x9F),      o2(0x86,0xA0),
          o2(0xB3,0xD1),      o2(0xB3,0xD2),
          o2(0x86,0xA1),      o2(0xB3,0xD3),
          o2(0xB3,0xD4),      o2(0xB3,0xD5),
          o2(0x86,0xA2),      o2(0x86,0xA3),
          o2(0x86,0xA4),      o2(0x86,0xA5),
          o2(0x86,0xA6),      o2(0xB3,0xD6),
          o2(0xB3,0xD7),      o2(0xB3,0xD8),
          o2(0x86,0xA7),      o2(0x86,0xA8),
          o2(0xB3,0xD9),      o2(0x86,0xA9),
          o2(0x86,0xAA),      o2(0x86,0xAB),
          o2(0xB3,0xDA),      o2(0x86,0xAC),
          o2(0x86,0xAD),      o2(0x86,0xAE),
          o2(0x86,0xAF),      o2(0x86,0xB0),
          o2(0x86,0xB1),      o2(0x86,0xB2),
          o2(0xB3,0xDB),      o2(0xB3,0xDC),
          o2(0x86,0xB3),      o2(0xB3,0xDD),
          o2(0xB3,0xDE),      o2(0xB3,0xDF),
          o2(0x86,0xB4),      o2(0x86,0xB5),
          o2(0x86,0xB6),      o2(0x86,0xB7),
          o2(0x86,0xB8),      o2(0x86,0xB9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_04 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_04_infos
};


static const struct byte_lookup* const
to_CP949_EB_05_infos[65] = {
          o2(0xB3,0xE0),      o2(0xB3,0xE1),
          o2(0x86,0xBA),      o2(0x86,0xBB),
          o2(0xB3,0xE2),      o2(0x86,0xBC),
          o2(0x86,0xBD),      o2(0x86,0xBE),
          o2(0xB3,0xE3),      o2(0x86,0xBF),
          o2(0x86,0xC0),      o2(0x86,0xC1),
          o2(0x86,0xC2),      o2(0x86,0xC3),
          o2(0x86,0xC4),      o2(0x86,0xC5),
          o2(0xB3,0xE4),      o2(0xB3,0xE5),
          o2(0x86,0xC6),      o2(0x86,0xC7),
          o2(0xB3,0xE6),      o2(0xB3,0xE7),
          o2(0x86,0xC8),      o2(0x86,0xC9),
          o2(0xB3,0xE8),      o2(0x86,0xCA),
          o2(0x86,0xCB),      o2(0x86,0xCC),
          o2(0xB3,0xE9),      o2(0x86,0xCD),
          o2(0x86,0xCE),      o2(0x86,0xCF),
          o2(0xB3,0xEA),      o2(0x86,0xD0),
          o2(0x86,0xD1),      o2(0x86,0xD2),
          o2(0x86,0xD3),      o2(0x86,0xD4),
          o2(0x86,0xD5),      o2(0x86,0xD6),
          o2(0x86,0xD7),      o2(0x86,0xD8),
          o2(0x86,0xD9),      o2(0x86,0xDA),
          o2(0x86,0xDB),      o2(0x86,0xDC),
          o2(0x86,0xDD),      o2(0x86,0xDE),
          o2(0x86,0xDF),      o2(0x86,0xE0),
          o2(0x86,0xE1),      o2(0x86,0xE2),
          o2(0x86,0xE3),      o2(0x86,0xE4),
          o2(0x86,0xE5),      o2(0x86,0xE6),
          o2(0xB3,0xEB),      o2(0xB3,0xEC),
          o2(0x86,0xE7),      o2(0x86,0xE8),
          o2(0xB3,0xED),      o2(0x86,0xE9),
          o2(0x86,0xEA),      o2(0x86,0xEB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_05 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_05_infos
};


static const struct byte_lookup* const
to_CP949_EB_06_infos[65] = {
          o2(0xB3,0xEE),      o2(0x86,0xEC),
          o2(0xB3,0xEF),      o2(0x86,0xED),
          o2(0x86,0xEE),      o2(0x86,0xEF),
          o2(0x86,0xF0),      o2(0x86,0xF1),
          o2(0xB3,0xF0),      o2(0xB3,0xF1),
          o2(0x86,0xF2),      o2(0xB3,0xF2),
          o2(0x86,0xF3),      o2(0xB3,0xF3),
          o2(0x86,0xF4),      o2(0x86,0xF5),
          o2(0x86,0xF6),      o2(0x86,0xF7),
          o2(0xB3,0xF4),      o2(0xB3,0xF5),
          o2(0xB3,0xF6),      o2(0x86,0xF8),
          o2(0x86,0xF9),      o2(0x86,0xFA),
          o2(0xB3,0xF7),      o2(0x86,0xFB),
          o2(0x86,0xFC),      o2(0x86,0xFD),
          o2(0xB3,0xF8),      o2(0x86,0xFE),
          o2(0x87,0x41),      o2(0x87,0x42),
          o2(0x87,0x43),      o2(0x87,0x44),
          o2(0x87,0x45),      o2(0x87,0x46),
          o2(0x87,0x47),      o2(0x87,0x48),
          o2(0x87,0x49),      o2(0x87,0x4A),
          o2(0xB3,0xF9),      o2(0x87,0x4B),
          o2(0x87,0x4C),      o2(0x87,0x4D),
          o2(0x87,0x4E),      o2(0x87,0x4F),
          o2(0x87,0x50),      o2(0x87,0x51),
          o2(0x87,0x52),      o2(0x87,0x53),
          o2(0x87,0x54),      o2(0x87,0x55),
          o2(0x87,0x56),      o2(0x87,0x57),
          o2(0x87,0x58),      o2(0x87,0x59),
          o2(0x87,0x5A),      o2(0x87,0x61),
          o2(0x87,0x62),      o2(0x87,0x63),
          o2(0x87,0x64),      o2(0x87,0x65),
          o2(0x87,0x66),      o2(0x87,0x67),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_06 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_06_infos
};


static const struct byte_lookup* const
to_CP949_EB_07_infos[65] = {
          o2(0x87,0x68),      o2(0x87,0x69),
          o2(0x87,0x6A),      o2(0x87,0x6B),
          o2(0x87,0x6C),      o2(0x87,0x6D),
          o2(0x87,0x6E),      o2(0x87,0x6F),
          o2(0x87,0x70),      o2(0x87,0x71),
          o2(0x87,0x72),      o2(0x87,0x73),
          o2(0xB3,0xFA),      o2(0x87,0x74),
          o2(0x87,0x75),      o2(0x87,0x76),
          o2(0xB3,0xFB),      o2(0x87,0x77),
          o2(0x87,0x78),      o2(0x87,0x79),
          o2(0xB3,0xFC),      o2(0x87,0x7A),
          o2(0x87,0x81),      o2(0x87,0x82),
          o2(0x87,0x83),      o2(0x87,0x84),
          o2(0x87,0x85),      o2(0x87,0x86),
          o2(0xB3,0xFD),      o2(0xB3,0xFE),
          o2(0x87,0x87),      o2(0xB4,0xA1),
          o2(0x87,0x88),      o2(0x87,0x89),
          o2(0x87,0x8A),      o2(0x87,0x8B),
          o2(0x87,0x8C),      o2(0x87,0x8D),
          o2(0x87,0x8E),      o2(0x87,0x8F),
          o2(0xB4,0xA2),      o2(0xB4,0xA3),
          o2(0x87,0x90),      o2(0x87,0x91),
          o2(0xB4,0xA4),      o2(0x87,0x92),
          o2(0x87,0x93),      o2(0x87,0x94),
          o2(0xB4,0xA5),      o2(0x87,0x95),
          o2(0x87,0x96),      o2(0x87,0x97),
          o2(0x87,0x98),      o2(0x87,0x99),
          o2(0x87,0x9A),      o2(0x87,0x9B),
          o2(0x87,0x9C),      o2(0xB4,0xA6),
          o2(0x87,0x9D),      o2(0xB4,0xA7),
          o2(0x87,0x9E),      o2(0xB4,0xA8),
          o2(0x87,0x9F),      o2(0x87,0xA0),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_07 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_07_infos
};


static const struct byte_lookup* const
to_CP949_EB_08_infos[65] = {
          o2(0x87,0xA1),      o2(0x87,0xA2),
          o2(0x87,0xA3),      o2(0x87,0xA4),
          o2(0xB4,0xA9),      o2(0xB4,0xAA),
          o2(0x87,0xA5),      o2(0x87,0xA6),
          o2(0xB4,0xAB),      o2(0x87,0xA7),
          o2(0x87,0xA8),      o2(0xB4,0xAC),
          o2(0xB4,0xAD),      o2(0x87,0xA9),
          o2(0x87,0xAA),      o2(0x87,0xAB),
          o2(0x87,0xAC),      o2(0x87,0xAD),
          o2(0x87,0xAE),      o2(0x87,0xAF),
          o2(0xB4,0xAE),      o2(0xB4,0xAF),
          o2(0x87,0xB0),      o2(0xB4,0xB0),
          o2(0x87,0xB1),      o2(0xB4,0xB1),
          o2(0x87,0xB2),      o2(0x87,0xB3),
          o2(0x87,0xB4),      o2(0x87,0xB5),
          o2(0x87,0xB6),      o2(0x87,0xB7),
          o2(0xB4,0xB2),      o2(0x87,0xB8),
          o2(0x87,0xB9),      o2(0x87,0xBA),
          o2(0x87,0xBB),      o2(0x87,0xBC),
          o2(0x87,0xBD),      o2(0x87,0xBE),
          o2(0x87,0xBF),      o2(0x87,0xC0),
          o2(0x87,0xC1),      o2(0x87,0xC2),
          o2(0x87,0xC3),      o2(0x87,0xC4),
          o2(0x87,0xC5),      o2(0x87,0xC6),
          o2(0x87,0xC7),      o2(0x87,0xC8),
          o2(0x87,0xC9),      o2(0x87,0xCA),
          o2(0xB4,0xB3),      o2(0x87,0xCB),
          o2(0x87,0xCC),      o2(0x87,0xCD),
          o2(0x87,0xCE),      o2(0x87,0xCF),
          o2(0x87,0xD0),      o2(0x87,0xD1),
          o2(0xB4,0xB4),      o2(0x87,0xD2),
          o2(0x87,0xD3),      o2(0x87,0xD4),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_08 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_08_infos
};


static const struct byte_lookup* const
to_CP949_EB_09_infos[65] = {
          o2(0x87,0xD5),      o2(0x87,0xD6),
          o2(0x87,0xD7),      o2(0x87,0xD8),
          o2(0x87,0xD9),      o2(0x87,0xDA),
          o2(0x87,0xDB),      o2(0x87,0xDC),
          o2(0x87,0xDD),      o2(0x87,0xDE),
          o2(0x87,0xDF),      o2(0x87,0xE0),
          o2(0x87,0xE1),      o2(0x87,0xE2),
          o2(0x87,0xE3),      o2(0x87,0xE4),
          o2(0x87,0xE5),      o2(0x87,0xE6),
          o2(0x87,0xE7),      o2(0x87,0xE8),
          o2(0x87,0xE9),      o2(0x87,0xEA),
          o2(0x87,0xEB),      o2(0x87,0xEC),
          o2(0xB4,0xB5),      o2(0x87,0xED),
          o2(0x87,0xEE),      o2(0x87,0xEF),
          o2(0xB4,0xB6),      o2(0x87,0xF0),
          o2(0x87,0xF1),      o2(0x87,0xF2),
          o2(0xB4,0xB7),      o2(0x87,0xF3),
          o2(0x87,0xF4),      o2(0x87,0xF5),
          o2(0x87,0xF6),      o2(0x87,0xF7),
          o2(0x87,0xF8),      o2(0x87,0xF9),
          o2(0xB4,0xB8),      o2(0xB4,0xB9),
          o2(0x87,0xFA),      o2(0x87,0xFB),
          o2(0x87,0xFC),      o2(0x87,0xFD),
          o2(0x87,0xFE),      o2(0x88,0x41),
          o2(0x88,0x42),      o2(0x88,0x43),
          o2(0x88,0x44),      o2(0x88,0x45),
          o2(0xB4,0xBA),      o2(0xB4,0xBB),
          o2(0x88,0x46),      o2(0x88,0x47),
          o2(0x88,0x48),      o2(0x88,0x49),
          o2(0x88,0x4A),      o2(0x88,0x4B),
          o2(0xB4,0xBC),      o2(0x88,0x4C),
          o2(0x88,0x4D),      o2(0x88,0x4E),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_09 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_09_infos
};


static const struct byte_lookup* const
to_CP949_EB_0A_infos[65] = {
          o2(0x88,0x4F),      o2(0x88,0x50),
          o2(0x88,0x51),      o2(0x88,0x52),
          o2(0xB4,0xBD),      o2(0xB4,0xBE),
          o2(0x88,0x53),      o2(0x88,0x54),
          o2(0x88,0x55),      o2(0xB4,0xBF),
          o2(0x88,0x56),      o2(0x88,0x57),
          o2(0x88,0x58),      o2(0x88,0x59),
          o2(0x88,0x5A),      o2(0x88,0x61),
          o2(0xB4,0xC0),      o2(0xB4,0xC1),
          o2(0x88,0x62),      o2(0x88,0x63),
          o2(0xB4,0xC2),      o2(0x88,0x64),
          o2(0x88,0x65),      o2(0x88,0x66),
          o2(0xB4,0xC3),      o2(0xB4,0xC4),
          o2(0xB4,0xC5),      o2(0x88,0x67),
          o2(0x88,0x68),      o2(0x88,0x69),
          o2(0x88,0x6A),      o2(0x88,0x6B),
          o2(0xB4,0xC6),      o2(0xB4,0xC7),
          o2(0x88,0x6C),      o2(0xB4,0xC8),
          o2(0x88,0x6D),      o2(0xB4,0xC9),
          o2(0xB4,0xCA),      o2(0x88,0x6E),
          o2(0x88,0x6F),      o2(0x88,0x70),
          o2(0xB4,0xCB),      o2(0x88,0x71),
          o2(0xB4,0xCC),      o2(0x88,0x72),
          o2(0x88,0x73),      o2(0x88,0x74),
          o2(0xB4,0xCD),      o2(0x88,0x75),
          o2(0x88,0x76),      o2(0x88,0x77),
          o2(0xB4,0xCE),      o2(0x88,0x78),
          o2(0x88,0x79),      o2(0x88,0x7A),
          o2(0x88,0x81),      o2(0x88,0x82),
          o2(0x88,0x83),      o2(0x88,0x84),
          o2(0x88,0x85),      o2(0x88,0x86),
          o2(0x88,0x87),      o2(0x88,0x88),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_0A = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_0A_infos
};


static const struct byte_lookup* const
to_CP949_EB_0B_infos[65] = {
          o2(0x88,0x89),      o2(0x88,0x8A),
          o2(0x88,0x8B),      o2(0x88,0x8C),
          o2(0x88,0x8D),      o2(0x88,0x8E),
          o2(0x88,0x8F),      o2(0x88,0x90),
          o2(0xB4,0xCF),      o2(0xB4,0xD0),
          o2(0x88,0x91),      o2(0x88,0x92),
          o2(0xB4,0xD1),      o2(0x88,0x93),
          o2(0x88,0x94),      o2(0x88,0x95),
          o2(0xB4,0xD2),      o2(0x88,0x96),
          o2(0xB4,0xD3),      o2(0x88,0x97),
          o2(0x88,0x98),      o2(0x88,0x99),
          o2(0x88,0x9A),      o2(0x88,0x9B),
          o2(0xB4,0xD4),      o2(0xB4,0xD5),
          o2(0x88,0x9C),      o2(0xB4,0xD6),
          o2(0x88,0x9D),      o2(0xB4,0xD7),
          o2(0x88,0x9E),      o2(0x88,0x9F),
          o2(0x88,0xA0),      o2(0x88,0xA1),
          o2(0xB4,0xD8),      o2(0x88,0xA2),
          o2(0xB4,0xD9),      o2(0xB4,0xDA),
          o2(0xB4,0xDB),      o2(0x88,0xA3),
          o2(0xB4,0xDC),      o2(0x88,0xA4),
          o2(0x88,0xA5),      o2(0xB4,0xDD),
          o2(0xB4,0xDE),      o2(0xB4,0xDF),
          o2(0xB4,0xE0),      o2(0xB4,0xE1),
          o2(0x88,0xA6),      o2(0x88,0xA7),
          o2(0x88,0xA8),      o2(0xB4,0xE2),
          o2(0xB4,0xE3),      o2(0xB4,0xE4),
          o2(0x88,0xA9),      o2(0xB4,0xE5),
          o2(0xB4,0xE6),      o2(0xB4,0xE7),
          o2(0xB4,0xE8),      o2(0xB4,0xE9),
          o2(0x88,0xAA),      o2(0x88,0xAB),
          o2(0x88,0xAC),      o2(0xB4,0xEA),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_0B = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_0B_infos
};


static const struct byte_lookup* const
to_CP949_EB_0C_infos[65] = {
          o2(0xB4,0xEB),      o2(0xB4,0xEC),
          o2(0x88,0xAD),      o2(0x88,0xAE),
          o2(0xB4,0xED),      o2(0x88,0xAF),
          o2(0x88,0xB0),      o2(0x88,0xB1),
          o2(0xB4,0xEE),      o2(0x88,0xB2),
          o2(0x88,0xB3),      o2(0x88,0xB4),
          o2(0x88,0xB5),      o2(0x88,0xB6),
          o2(0x88,0xB7),      o2(0x88,0xB8),
          o2(0xB4,0xEF),      o2(0xB4,0xF0),
          o2(0x88,0xB9),      o2(0xB4,0xF1),
          o2(0xB4,0xF2),      o2(0xB4,0xF3),
          o2(0x88,0xBA),      o2(0x88,0xBB),
          o2(0x88,0xBC),      o2(0x88,0xBD),
          o2(0x88,0xBE),      o2(0x88,0xBF),
          o2(0xB4,0xF4),      o2(0x88,0xC0),
          o2(0x88,0xC1),      o2(0x88,0xC2),
          o2(0x88,0xC3),      o2(0x88,0xC4),
          o2(0x88,0xC5),      o2(0x88,0xC6),
          o2(0x88,0xC7),      o2(0x88,0xC8),
          o2(0x88,0xC9),      o2(0x88,0xCA),
          o2(0x88,0xCB),      o2(0x88,0xCC),
          o2(0x88,0xCD),      o2(0x88,0xCE),
          o2(0x88,0xCF),      o2(0x88,0xD0),
          o2(0x88,0xD1),      o2(0x88,0xD2),
          o2(0x88,0xD3),      o2(0x88,0xD4),
          o2(0x88,0xD5),      o2(0x88,0xD6),
          o2(0x88,0xD7),      o2(0x88,0xD8),
          o2(0x88,0xD9),      o2(0x88,0xDA),
          o2(0x88,0xDB),      o2(0x88,0xDC),
          o2(0x88,0xDD),      o2(0x88,0xDE),
          o2(0x88,0xDF),      o2(0x88,0xE0),
          o2(0x88,0xE1),      o2(0x88,0xE2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_0C = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_0C_infos
};


static const struct byte_lookup* const
to_CP949_EB_0D_infos[65] = {
          o2(0x88,0xE3),      o2(0x88,0xE4),
          o2(0x88,0xE5),      o2(0x88,0xE6),
          o2(0x88,0xE7),      o2(0x88,0xE8),
          o2(0x88,0xE9),      o2(0x88,0xEA),
          o2(0x88,0xEB),      o2(0x88,0xEC),
          o2(0x88,0xED),      o2(0x88,0xEE),
          o2(0x88,0xEF),      o2(0x88,0xF0),
          o2(0x88,0xF1),      o2(0x88,0xF2),
          o2(0x88,0xF3),      o2(0x88,0xF4),
          o2(0x88,0xF5),      o2(0x88,0xF6),
          o2(0xB4,0xF5),      o2(0xB4,0xF6),
          o2(0xB4,0xF7),      o2(0x88,0xF7),
          o2(0xB4,0xF8),      o2(0x88,0xF8),
          o2(0x88,0xF9),      o2(0xB4,0xF9),
          o2(0xB4,0xFA),      o2(0x88,0xFA),
          o2(0xB4,0xFB),      o2(0xB4,0xFC),
          o2(0x88,0xFB),      o2(0x88,0xFC),
          o2(0x88,0xFD),      o2(0x88,0xFE),
          o2(0xB4,0xFD),      o2(0xB4,0xFE),
          o2(0x89,0x41),      o2(0xB5,0xA1),
          o2(0x89,0x42),      o2(0xB5,0xA2),
          o2(0x89,0x43),      o2(0xB5,0xA3),
          o2(0x89,0x44),      o2(0x89,0x45),
          o2(0xB5,0xA4),      o2(0x89,0x46),
          o2(0xB5,0xA5),      o2(0xB5,0xA6),
          o2(0x89,0x47),      o2(0x89,0x48),
          o2(0xB5,0xA7),      o2(0x89,0x49),
          o2(0x89,0x4A),      o2(0x89,0x4B),
          o2(0xB5,0xA8),      o2(0x89,0x4C),
          o2(0x89,0x4D),      o2(0x89,0x4E),
          o2(0x89,0x4F),      o2(0x89,0x50),
          o2(0x89,0x51),      o2(0x89,0x52),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_0D = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_0D_infos
};


static const struct byte_lookup* const
to_CP949_EB_0E_infos[65] = {
          o2(0xB5,0xA9),      o2(0xB5,0xAA),
          o2(0x89,0x53),      o2(0xB5,0xAB),
          o2(0xB5,0xAC),      o2(0xB5,0xAD),
          o2(0x89,0x54),      o2(0x89,0x55),
          o2(0x89,0x56),      o2(0x89,0x57),
          o2(0x89,0x58),      o2(0x89,0x59),
          o2(0xB5,0xAE),      o2(0x89,0x5A),
          o2(0x89,0x61),      o2(0x89,0x62),
          o2(0xB5,0xAF),      o2(0x89,0x63),
          o2(0x89,0x64),      o2(0x89,0x65),
          o2(0xB5,0xB0),      o2(0x89,0x66),
          o2(0x89,0x67),      o2(0x89,0x68),
          o2(0x89,0x69),      o2(0x89,0x6A),
          o2(0x89,0x6B),      o2(0x89,0x6C),
          o2(0x89,0x6D),      o2(0x89,0x6E),
          o2(0x89,0x6F),      o2(0x89,0x70),
          o2(0xB5,0xB1),      o2(0xB5,0xB2),
          o2(0x89,0x71),      o2(0x89,0x72),
          o2(0x89,0x73),      o2(0x89,0x74),
          o2(0x89,0x75),      o2(0x89,0x76),
          o2(0xB5,0xB3),      o2(0x89,0x77),
          o2(0x89,0x78),      o2(0x89,0x79),
          o2(0xB5,0xB4),      o2(0x89,0x7A),
          o2(0x89,0x81),      o2(0x89,0x82),
          o2(0x89,0x83),      o2(0x89,0x84),
          o2(0x89,0x85),      o2(0x89,0x86),
          o2(0x89,0x87),      o2(0x89,0x88),
          o2(0x89,0x89),      o2(0x89,0x8A),
          o2(0x89,0x8B),      o2(0x89,0x8C),
          o2(0x89,0x8D),      o2(0x89,0x8E),
          o2(0x89,0x8F),      o2(0x89,0x90),
          o2(0x89,0x91),      o2(0x89,0x92),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_0E = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_0E_infos
};


static const struct byte_lookup* const
to_CP949_EB_0F_infos[65] = {
          o2(0x89,0x93),      o2(0x89,0x94),
          o2(0x89,0x95),      o2(0x89,0x96),
          o2(0xB5,0xB5),      o2(0xB5,0xB6),
          o2(0x89,0x97),      o2(0x89,0x98),
          o2(0xB5,0xB7),      o2(0x89,0x99),
          o2(0x89,0x9A),      o2(0xB5,0xB8),
          o2(0xB5,0xB9),      o2(0x89,0x9B),
          o2(0xB5,0xBA),      o2(0x89,0x9C),
          o2(0xB5,0xBB),      o2(0x89,0x9D),
          o2(0x89,0x9E),      o2(0x89,0x9F),
          o2(0xB5,0xBC),      o2(0xB5,0xBD),
          o2(0x89,0xA0),      o2(0xB5,0xBE),
          o2(0x89,0xA1),      o2(0xB5,0xBF),
          o2(0x89,0xA2),      o2(0xB5,0xC0),
          o2(0x89,0xA3),      o2(0xB5,0xC1),
          o2(0x89,0xA4),      o2(0x89,0xA5),
          o2(0xB5,0xC2),      o2(0x89,0xA6),
          o2(0x89,0xA7),      o2(0x89,0xA8),
          o2(0xB5,0xC3),      o2(0x89,0xA9),
          o2(0x89,0xAA),      o2(0x89,0xAB),
          o2(0xB5,0xC4),      o2(0x89,0xAC),
          o2(0x89,0xAD),      o2(0x89,0xAE),
          o2(0x89,0xAF),      o2(0x89,0xB0),
          o2(0x89,0xB1),      o2(0x89,0xB2),
          o2(0x89,0xB3),      o2(0x89,0xB4),
          o2(0x89,0xB5),      o2(0x89,0xB6),
          o2(0x89,0xB7),      o2(0x89,0xB8),
          o2(0x89,0xB9),      o2(0x89,0xBA),
          o2(0x89,0xBB),      o2(0x89,0xBC),
          o2(0x89,0xBD),      o2(0x89,0xBE),
          o2(0xB5,0xC5),      o2(0x89,0xBF),
          o2(0x89,0xC0),      o2(0x89,0xC1),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_0F = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_0F_infos
};


static const struct byte_lookup* const
to_CP949_EB_10_infos[65] = {
          o2(0x89,0xC2),      o2(0x89,0xC3),
          o2(0x89,0xC4),      o2(0x89,0xC5),
          o2(0x89,0xC6),      o2(0x89,0xC7),
          o2(0x89,0xC8),      o2(0x89,0xC9),
          o2(0x89,0xCA),      o2(0x89,0xCB),
          o2(0x89,0xCC),      o2(0x89,0xCD),
          o2(0x89,0xCE),      o2(0x89,0xCF),
          o2(0x89,0xD0),      o2(0x89,0xD1),
          o2(0xB5,0xC6),      o2(0x89,0xD2),
          o2(0x89,0xD3),      o2(0x89,0xD4),
          o2(0x89,0xD5),      o2(0x89,0xD6),
          o2(0x89,0xD7),      o2(0x89,0xD8),
          o2(0xB5,0xC7),      o2(0x89,0xD9),
          o2(0x89,0xDA),      o2(0x89,0xDB),
          o2(0xB5,0xC8),      o2(0x89,0xDC),
          o2(0x89,0xDD),      o2(0x89,0xDE),
          o2(0xB5,0xC9),      o2(0x89,0xDF),
          o2(0x89,0xE0),      o2(0x89,0xE1),
          o2(0x89,0xE2),      o2(0x89,0xE3),
          o2(0x89,0xE4),      o2(0x89,0xE5),
          o2(0xB5,0xCA),      o2(0xB5,0xCB),
          o2(0x89,0xE6),      o2(0xB5,0xCC),
          o2(0x89,0xE7),      o2(0x89,0xE8),
          o2(0x89,0xE9),      o2(0x89,0xEA),
          o2(0x89,0xEB),      o2(0x89,0xEC),
          o2(0x89,0xED),      o2(0x89,0xEE),
          o2(0xB5,0xCD),      o2(0x89,0xEF),
          o2(0x89,0xF0),      o2(0x89,0xF1),
          o2(0x89,0xF2),      o2(0x89,0xF3),
          o2(0x89,0xF4),      o2(0x89,0xF5),
          o2(0x89,0xF6),      o2(0x89,0xF7),
          o2(0x89,0xF8),      o2(0x89,0xF9),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_10 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_10_infos
};


static const struct byte_lookup* const
to_CP949_EB_11_infos[65] = {
          o2(0x89,0xFA),      o2(0x89,0xFB),
          o2(0x89,0xFC),      o2(0x89,0xFD),
          o2(0x89,0xFE),      o2(0x8A,0x41),
          o2(0x8A,0x42),      o2(0x8A,0x43),
          o2(0x8A,0x44),      o2(0x8A,0x45),
          o2(0x8A,0x46),      o2(0x8A,0x47),
          o2(0x8A,0x48),      o2(0x8A,0x49),
          o2(0x8A,0x4A),      o2(0x8A,0x4B),
          o2(0xB5,0xCE),      o2(0xB5,0xCF),
          o2(0x8A,0x4C),      o2(0x8A,0x4D),
          o2(0xB5,0xD0),      o2(0x8A,0x4E),
          o2(0x8A,0x4F),      o2(0x8A,0x50),
          o2(0xB5,0xD1),      o2(0x8A,0x51),
          o2(0x8A,0x52),      o2(0x8A,0x53),
          o2(0x8A,0x54),      o2(0x8A,0x55),
          o2(0x8A,0x56),      o2(0x8A,0x57),
          o2(0xB5,0xD2),      o2(0xB5,0xD3),
          o2(0x8A,0x58),      o2(0xB5,0xD4),
          o2(0x8A,0x59),      o2(0xB5,0xD5),
          o2(0x8A,0x5A),      o2(0x8A,0x61),
          o2(0x8A,0x62),      o2(0x8A,0x63),
          o2(0x8A,0x64),      o2(0x8A,0x65),
          o2(0xB5,0xD6),      o2(0x8A,0x66),
          o2(0x8A,0x67),      o2(0x8A,0x68),
          o2(0x8A,0x69),      o2(0x8A,0x6A),
          o2(0x8A,0x6B),      o2(0x8A,0x6C),
          o2(0x8A,0x6D),      o2(0x8A,0x6E),
          o2(0x8A,0x6F),      o2(0x8A,0x70),
          o2(0x8A,0x71),      o2(0x8A,0x72),
          o2(0x8A,0x73),      o2(0x8A,0x74),
          o2(0x8A,0x75),      o2(0x8A,0x76),
          o2(0x8A,0x77),      o2(0x8A,0x78),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_11 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_11_infos
};


static const struct byte_lookup* const
to_CP949_EB_12_infos[65] = {
          o2(0xB5,0xD7),      o2(0x8A,0x79),
          o2(0x8A,0x7A),      o2(0x8A,0x81),
          o2(0x8A,0x82),      o2(0x8A,0x83),
          o2(0x8A,0x84),      o2(0x8A,0x85),
          o2(0xB5,0xD8),      o2(0x8A,0x86),
          o2(0x8A,0x87),      o2(0x8A,0x88),
          o2(0x8A,0x89),      o2(0x8A,0x8A),
          o2(0x8A,0x8B),      o2(0x8A,0x8C),
          o2(0x8A,0x8D),      o2(0x8A,0x8E),
          o2(0x8A,0x8F),      o2(0x8A,0x90),
          o2(0x8A,0x91),      o2(0x8A,0x92),
          o2(0x8A,0x93),      o2(0x8A,0x94),
          o2(0x8A,0x95),      o2(0x8A,0x96),
          o2(0x8A,0x97),      o2(0x8A,0x98),
          o2(0x8A,0x99),      o2(0xB5,0xD9),
          o2(0x8A,0x9A),      o2(0x8A,0x9B),
          o2(0x8A,0x9C),      o2(0x8A,0x9D),
          o2(0x8A,0x9E),      o2(0x8A,0x9F),
          o2(0xB5,0xDA),      o2(0x8A,0xA0),
          o2(0x8A,0xA1),      o2(0x8A,0xA2),
          o2(0xB5,0xDB),      o2(0x8A,0xA3),
          o2(0x8A,0xA4),      o2(0x8A,0xA5),
          o2(0xB5,0xDC),      o2(0x8A,0xA6),
          o2(0x8A,0xA7),      o2(0x8A,0xA8),
          o2(0x8A,0xA9),      o2(0x8A,0xAA),
          o2(0x8A,0xAB),      o2(0x8A,0xAC),
          o2(0x8A,0xAD),      o2(0xB5,0xDD),
          o2(0x8A,0xAE),      o2(0xB5,0xDE),
          o2(0x8A,0xAF),      o2(0xB5,0xDF),
          o2(0x8A,0xB0),      o2(0x8A,0xB1),
          o2(0x8A,0xB2),      o2(0x8A,0xB3),
          o2(0x8A,0xB4),      o2(0x8A,0xB5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_12 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_12_infos
};


static const struct byte_lookup* const
to_CP949_EB_13_infos[65] = {
          o2(0xB5,0xE0),      o2(0x8A,0xB6),
          o2(0x8A,0xB7),      o2(0x8A,0xB8),
          o2(0xB5,0xE1),      o2(0x8A,0xB9),
          o2(0x8A,0xBA),      o2(0x8A,0xBB),
          o2(0xB5,0xE2),      o2(0x8A,0xBC),
          o2(0x8A,0xBD),      o2(0x8A,0xBE),
          o2(0x8A,0xBF),      o2(0x8A,0xC0),
          o2(0x8A,0xC1),      o2(0x8A,0xC2),
          o2(0xB5,0xE3),      o2(0x8A,0xC3),
          o2(0x8A,0xC4),      o2(0x8A,0xC5),
          o2(0x8A,0xC6),      o2(0xB5,0xE4),
          o2(0x8A,0xC7),      o2(0x8A,0xC8),
          o2(0x8A,0xC9),      o2(0x8A,0xCA),
          o2(0x8A,0xCB),      o2(0x8A,0xCC),
          o2(0xB5,0xE5),      o2(0xB5,0xE6),
          o2(0x8A,0xCD),      o2(0x8A,0xCE),
          o2(0xB5,0xE7),      o2(0x8A,0xCF),
          o2(0x8A,0xD0),      o2(0xB5,0xE8),
          o2(0xB5,0xE9),      o2(0x8A,0xD1),
          o2(0xB5,0xEA),      o2(0x8A,0xD2),
          o2(0x8A,0xD3),      o2(0x8A,0xD4),
          o2(0x8A,0xD5),      o2(0x8A,0xD6),
          o2(0xB5,0xEB),      o2(0xB5,0xEC),
          o2(0x8A,0xD7),      o2(0xB5,0xED),
          o2(0x8A,0xD8),      o2(0xB5,0xEE),
          o2(0x8A,0xD9),      o2(0x8A,0xDA),
          o2(0x8A,0xDB),      o2(0x8A,0xDC),
          o2(0x8A,0xDD),      o2(0x8A,0xDE),
          o2(0xB5,0xEF),      o2(0x8A,0xDF),
          o2(0x8A,0xE0),      o2(0x8A,0xE1),
          o2(0x8A,0xE2),      o2(0x8A,0xE3),
          o2(0x8A,0xE4),      o2(0x8A,0xE5),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_13 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_13_infos
};


static const struct byte_lookup* const
to_CP949_EB_14_infos[65] = {
          o2(0x8A,0xE6),      o2(0x8A,0xE7),
          o2(0x8A,0xE8),      o2(0x8A,0xE9),
          o2(0x8A,0xEA),      o2(0x8A,0xEB),
          o2(0x8A,0xEC),      o2(0x8A,0xED),
          o2(0x8A,0xEE),      o2(0x8A,0xEF),
          o2(0x8A,0xF0),      o2(0x8A,0xF1),
          o2(0x8A,0xF2),      o2(0x8A,0xF3),
          o2(0x8A,0xF4),      o2(0x8A,0xF5),
          o2(0x8A,0xF6),      o2(0x8A,0xF7),
          o2(0x8A,0xF8),      o2(0x8A,0xF9),
          o2(0xB5,0xF0),      o2(0xB5,0xF1),
          o2(0x8A,0xFA),      o2(0x8A,0xFB),
          o2(0xB5,0xF2),      o2(0x8A,0xFC),
          o2(0x8A,0xFD),      o2(0xB5,0xF3),
          o2(0xB5,0xF4),      o2(0x8A,0xFE),
          o2(0x8B,0x41),      o2(0x8B,0x42),
          o2(0x8B,0x43),      o2(0x8B,0x44),
          o2(0x8B,0x45),      o2(0x8B,0x46),
          o2(0xB5,0xF5),      o2(0xB5,0xF6),
          o2(0x8B,0x47),      o2(0xB5,0xF7),
          o2(0xB5,0xF8),      o2(0xB5,0xF9),
          o2(0xB5,0xFA),      o2(0x8B,0x48),
          o2(0x8B,0x49),      o2(0x8B,0x4A),
          o2(0x8B,0x4B),      o2(0x8B,0x4C),
          o2(0xB5,0xFB),      o2(0xB5,0xFC),
          o2(0x8B,0x4D),      o2(0x8B,0x4E),
          o2(0xB5,0xFD),      o2(0x8B,0x4F),
          o2(0x8B,0x50),      o2(0x8B,0x51),
          o2(0xB5,0xFE),      o2(0x8B,0x52),
          o2(0x8B,0x53),      o2(0x8B,0x54),
          o2(0x8B,0x55),      o2(0x8B,0x56),
          o2(0x8B,0x57),      o2(0x8B,0x58),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_14 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_14_infos
};


static const struct byte_lookup* const
to_CP949_EB_15_infos[65] = {
          o2(0xB6,0xA1),      o2(0xB6,0xA2),
          o2(0x8B,0x59),      o2(0xB6,0xA3),
          o2(0xB6,0xA4),      o2(0xB6,0xA5),
          o2(0x8B,0x5A),      o2(0x8B,0x61),
          o2(0x8B,0x62),      o2(0x8B,0x63),
          o2(0x8B,0x64),      o2(0xB6,0xA6),
          o2(0xB6,0xA7),      o2(0xB6,0xA8),
          o2(0x8B,0x65),      o2(0x8B,0x66),
          o2(0xB6,0xA9),      o2(0x8B,0x67),
          o2(0x8B,0x68),      o2(0x8B,0x69),
          o2(0xB6,0xAA),      o2(0x8B,0x6A),
          o2(0x8B,0x6B),      o2(0x8B,0x6C),
          o2(0x8B,0x6D),      o2(0x8B,0x6E),
          o2(0x8B,0x6F),      o2(0x8B,0x70),
          o2(0xB6,0xAB),      o2(0xB6,0xAC),
          o2(0x8B,0x71),      o2(0xB6,0xAD),
          o2(0xB6,0xAE),      o2(0xB6,0xAF),
          o2(0x8B,0x72),      o2(0x8B,0x73),
          o2(0x8B,0x74),      o2(0x8B,0x75),
          o2(0x8B,0x76),      o2(0x8B,0x77),
          o2(0x8B,0x78),      o2(0x8B,0x79),
          o2(0x8B,0x7A),      o2(0x8B,0x81),
          o2(0x8B,0x82),      o2(0x8B,0x83),
          o2(0x8B,0x84),      o2(0x8B,0x85),
          o2(0x8B,0x86),      o2(0x8B,0x87),
          o2(0x8B,0x88),      o2(0x8B,0x89),
          o2(0x8B,0x8A),      o2(0x8B,0x8B),
          o2(0x8B,0x8C),      o2(0x8B,0x8D),
          o2(0x8B,0x8E),      o2(0x8B,0x8F),
          o2(0x8B,0x90),      o2(0x8B,0x91),
          o2(0x8B,0x92),      o2(0x8B,0x93),
          o2(0x8B,0x94),      o2(0x8B,0x95),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_15 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_15_infos
};


static const struct byte_lookup* const
to_CP949_EB_16_infos[65] = {
          o2(0x8B,0x96),      o2(0x8B,0x97),
          o2(0x8B,0x98),      o2(0x8B,0x99),
          o2(0x8B,0x9A),      o2(0x8B,0x9B),
          o2(0x8B,0x9C),      o2(0x8B,0x9D),
          o2(0x8B,0x9E),      o2(0x8B,0x9F),
          o2(0x8B,0xA0),      o2(0x8B,0xA1),
          o2(0x8B,0xA2),      o2(0x8B,0xA3),
          o2(0x8B,0xA4),      o2(0x8B,0xA5),
          o2(0x8B,0xA6),      o2(0x8B,0xA7),
          o2(0x8B,0xA8),      o2(0x8B,0xA9),
          o2(0x8B,0xAA),      o2(0x8B,0xAB),
          o2(0x8B,0xAC),      o2(0x8B,0xAD),
          o2(0x8B,0xAE),      o2(0x8B,0xAF),
          o2(0x8B,0xB0),      o2(0x8B,0xB1),
          o2(0x8B,0xB2),      o2(0x8B,0xB3),
          o2(0x8B,0xB4),      o2(0x8B,0xB5),
          o2(0xB6,0xB0),      o2(0xB6,0xB1),
          o2(0x8B,0xB6),      o2(0x8B,0xB7),
          o2(0xB6,0xB2),      o2(0x8B,0xB8),
          o2(0x8B,0xB9),      o2(0x8B,0xBA),
          o2(0xB6,0xB3),      o2(0x8B,0xBB),
          o2(0xB6,0xB4),      o2(0xB6,0xB5),
          o2(0x8B,0xBC),      o2(0x8B,0xBD),
          o2(0x8B,0xBE),      o2(0x8B,0xBF),
          o2(0xB6,0xB6),      o2(0xB6,0xB7),
          o2(0x8B,0xC0),      o2(0xB6,0xB8),
          o2(0xB6,0xB9),      o2(0xB6,0xBA),
          o2(0x8B,0xC1),      o2(0x8B,0xC2),
          o2(0x8B,0xC3),      o2(0x8B,0xC4),
          o2(0x8B,0xC5),      o2(0xB6,0xBB),
          o2(0xB6,0xBC),      o2(0xB6,0xBD),
          o2(0x8B,0xC6),      o2(0x8B,0xC7),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_16 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_16_infos
};


static const struct byte_lookup* const
to_CP949_EB_17_infos[65] = {
          o2(0xB6,0xBE),      o2(0x8B,0xC8),
          o2(0x8B,0xC9),      o2(0x8B,0xCA),
          o2(0xB6,0xBF),      o2(0x8B,0xCB),
          o2(0x8B,0xCC),      o2(0x8B,0xCD),
          o2(0x8B,0xCE),      o2(0x8B,0xCF),
          o2(0x8B,0xD0),      o2(0x8B,0xD1),
          o2(0xB6,0xC0),      o2(0xB6,0xC1),
          o2(0x8B,0xD2),      o2(0xB6,0xC2),
          o2(0xB6,0xC3),      o2(0xB6,0xC4),
          o2(0x8B,0xD3),      o2(0x8B,0xD4),
          o2(0x8B,0xD5),      o2(0x8B,0xD6),
          o2(0x8B,0xD7),      o2(0x8B,0xD8),
          o2(0xB6,0xC5),      o2(0x8B,0xD9),
          o2(0x8B,0xDA),      o2(0x8B,0xDB),
          o2(0x8B,0xDC),      o2(0x8B,0xDD),
          o2(0x8B,0xDE),      o2(0x8B,0xDF),
          o2(0x8B,0xE0),      o2(0x8B,0xE1),
          o2(0x8B,0xE2),      o2(0x8B,0xE3),
          o2(0x8B,0xE4),      o2(0x8B,0xE5),
          o2(0x8B,0xE6),      o2(0x8B,0xE7),
          o2(0x8B,0xE8),      o2(0x8B,0xE9),
          o2(0x8B,0xEA),      o2(0x8B,0xEB),
          o2(0xB6,0xC6),      o2(0x8B,0xEC),
          o2(0x8B,0xED),      o2(0x8B,0xEE),
          o2(0x8B,0xEF),      o2(0x8B,0xF0),
          o2(0x8B,0xF1),      o2(0x8B,0xF2),
          o2(0x8B,0xF3),      o2(0x8B,0xF4),
          o2(0x8B,0xF5),      o2(0x8B,0xF6),
          o2(0x8B,0xF7),      o2(0x8B,0xF8),
          o2(0x8B,0xF9),      o2(0x8B,0xFA),
          o2(0x8B,0xFB),      o2(0x8B,0xFC),
          o2(0x8B,0xFD),      o2(0x8B,0xFE),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_17 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_17_infos
};


static const struct byte_lookup* const
to_CP949_EB_18_infos[65] = {
          o2(0x8C,0x41),      o2(0x8C,0x42),
          o2(0x8C,0x43),      o2(0x8C,0x44),
          o2(0x8C,0x45),      o2(0x8C,0x46),
          o2(0x8C,0x47),      o2(0x8C,0x48),
          o2(0x8C,0x49),      o2(0x8C,0x4A),
          o2(0x8C,0x4B),      o2(0x8C,0x4C),
          o2(0x8C,0x4D),      o2(0x8C,0x4E),
          o2(0x8C,0x4F),      o2(0x8C,0x50),
          o2(0xB6,0xC7),      o2(0xB6,0xC8),
          o2(0x8C,0x51),      o2(0x8C,0x52),
          o2(0xB6,0xC9),      o2(0x8C,0x53),
          o2(0x8C,0x54),      o2(0x8C,0x55),
          o2(0xB6,0xCA),      o2(0x8C,0x56),
          o2(0x8C,0x57),      o2(0x8C,0x58),
          o2(0x8C,0x59),      o2(0x8C,0x5A),
          o2(0x8C,0x61),      o2(0x8C,0x62),
          o2(0x8C,0x63),      o2(0x8C,0x64),
          o2(0x8C,0x65),      o2(0x8C,0x66),
          o2(0x8C,0x67),      o2(0xB6,0xCB),
          o2(0x8C,0x68),      o2(0x8C,0x69),
          o2(0x8C,0x6A),      o2(0x8C,0x6B),
          o2(0x8C,0x6C),      o2(0x8C,0x6D),
          o2(0xB6,0xCC),      o2(0x8C,0x6E),
          o2(0x8C,0x6F),      o2(0x8C,0x70),
          o2(0x8C,0x71),      o2(0x8C,0x72),
          o2(0x8C,0x73),      o2(0x8C,0x74),
          o2(0xB6,0xCD),      o2(0x8C,0x75),
          o2(0x8C,0x76),      o2(0x8C,0x77),
          o2(0x8C,0x78),      o2(0x8C,0x79),
          o2(0x8C,0x7A),      o2(0x8C,0x81),
          o2(0x8C,0x82),      o2(0x8C,0x83),
          o2(0x8C,0x84),      o2(0x8C,0x85),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_18 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_18_infos
};


static const struct byte_lookup* const
to_CP949_EB_19_infos[65] = {
          o2(0x8C,0x86),      o2(0x8C,0x87),
          o2(0x8C,0x88),      o2(0x8C,0x89),
          o2(0x8C,0x8A),      o2(0x8C,0x8B),
          o2(0x8C,0x8C),      o2(0x8C,0x8D),
          o2(0xB6,0xCE),      o2(0x8C,0x8E),
          o2(0x8C,0x8F),      o2(0x8C,0x90),
          o2(0x8C,0x91),      o2(0x8C,0x92),
          o2(0x8C,0x93),      o2(0x8C,0x94),
          o2(0x8C,0x95),      o2(0x8C,0x96),
          o2(0x8C,0x97),      o2(0x8C,0x98),
          o2(0x8C,0x99),      o2(0x8C,0x9A),
          o2(0x8C,0x9B),      o2(0x8C,0x9C),
          o2(0x8C,0x9D),      o2(0x8C,0x9E),
          o2(0x8C,0x9F),      o2(0x8C,0xA0),
          o2(0x8C,0xA1),      o2(0x8C,0xA2),
          o2(0x8C,0xA3),      o2(0x8C,0xA4),
          o2(0x8C,0xA5),      o2(0x8C,0xA6),
          o2(0x8C,0xA7),      o2(0x8C,0xA8),
          o2(0xB6,0xCF),      o2(0x8C,0xA9),
          o2(0x8C,0xAA),      o2(0x8C,0xAB),
          o2(0xB6,0xD0),      o2(0x8C,0xAC),
          o2(0x8C,0xAD),      o2(0x8C,0xAE),
          o2(0x8C,0xAF),      o2(0x8C,0xB0),
          o2(0x8C,0xB1),      o2(0x8C,0xB2),
          o2(0x8C,0xB3),      o2(0x8C,0xB4),
          o2(0x8C,0xB5),      o2(0x8C,0xB6),
          o2(0x8C,0xB7),      o2(0x8C,0xB8),
          o2(0x8C,0xB9),      o2(0x8C,0xBA),
          o2(0x8C,0xBB),      o2(0x8C,0xBC),
          o2(0x8C,0xBD),      o2(0x8C,0xBE),
          o2(0x8C,0xBF),      o2(0x8C,0xC0),
          o2(0x8C,0xC1),      o2(0x8C,0xC2),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_19 = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_19_infos
};


static const struct byte_lookup* const
to_CP949_EB_1A_infos[65] = {
          o2(0x8C,0xC3),      o2(0x8C,0xC4),
          o2(0x8C,0xC5),      o2(0x8C,0xC6),
          o2(0x8C,0xC7),      o2(0x8C,0xC8),
          o2(0x8C,0xC9),      o2(0x8C,0xCA),
          o2(0x8C,0xCB),      o2(0x8C,0xCC),
          o2(0x8C,0xCD),      o2(0x8C,0xCE),
          o2(0x8C,0xCF),      o2(0x8C,0xD0),
          o2(0x8C,0xD1),      o2(0x8C,0xD2),
          o2(0x8C,0xD3),      o2(0x8C,0xD4),
          o2(0x8C,0xD5),      o2(0x8C,0xD6),
          o2(0x8C,0xD7),      o2(0x8C,0xD8),
          o2(0x8C,0xD9),      o2(0x8C,0xDA),
          o2(0x8C,0xDB),      o2(0x8C,0xDC),
          o2(0x8C,0xDD),      o2(0x8C,0xDE),
          o2(0xB6,0xD1),      o2(0xB6,0xD2),
          o2(0x8C,0xDF),      o2(0x8C,0xE0),
          o2(0xB6,0xD3),      o2(0x8C,0xE1),
          o2(0x8C,0xE2),      o2(0x8C,0xE3),
          o2(0xB6,0xD4),      o2(0x8C,0xE4),
          o2(0x8C,0xE5),      o2(0x8C,0xE6),
          o2(0x8C,0xE7),      o2(0x8C,0xE8),
          o2(0x8C,0xE9),      o2(0xB6,0xD5),
          o2(0xB6,0xD6),      o2(0x8C,0xEA),
          o2(0x8C,0xEB),      o2(0x8C,0xEC),
          o2(0x8C,0xED),      o2(0xB6,0xD7),
          o2(0x8C,0xEE),      o2(0x8C,0xEF),
          o2(0x8C,0xF0),      o2(0x8C,0xF1),
          o2(0x8C,0xF2),      o2(0x8C,0xF3),
          o2(0x8C,0xF4),      o2(0x8C,0xF5),
          o2(0x8C,0xF6),      o2(0x8C,0xF7),
          o2(0x8C,0xF8),      o2(0x8C,0xF9),
          o2(0x8C,0xFA),      o2(0x8C,0xFB),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_1A = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_1A_infos
};


static const struct byte_lookup* const
to_CP949_EB_1B_infos[65] = {
          o2(0x8C,0xFC),      o2(0x8C,0xFD),
          o2(0x8C,0xFE),      o2(0x8D,0x41),
          o2(0x8D,0x42),      o2(0x8D,0x43),
          o2(0x8D,0x44),      o2(0x8D,0x45),
          o2(0x8D,0x46),      o2(0x8D,0x47),
          o2(0x8D,0x48),      o2(0x8D,0x49),
          o2(0x8D,0x4A),      o2(0x8D,0x4B),
          o2(0x8D,0x4C),      o2(0x8D,0x4D),
          o2(0x8D,0x4E),      o2(0x8D,0x4F),
          o2(0x8D,0x50),      o2(0x8D,0x51),
          o2(0xB6,0xD8),      o2(0x8D,0x52),
          o2(0x8D,0x53),      o2(0x8D,0x54),
          o2(0x8D,0x55),      o2(0x8D,0x56),
          o2(0x8D,0x57),      o2(0x8D,0x58),
          o2(0x8D,0x59),      o2(0x8D,0x5A),
          o2(0x8D,0x61),      o2(0x8D,0x62),
          o2(0x8D,0x63),      o2(0x8D,0x64),
          o2(0x8D,0x65),      o2(0x8D,0x66),
          o2(0x8D,0x67),      o2(0x8D,0x68),
          o2(0x8D,0x69),      o2(0x8D,0x6A),
          o2(0x8D,0x6B),      o2(0x8D,0x6C),
          o2(0x8D,0x6D),      o2(0x8D,0x6E),
          o2(0x8D,0x6F),      o2(0x8D,0x70),
          o2(0x8D,0x71),      o2(0x8D,0x72),
          o2(0xB6,0xD9),      o2(0x8D,0x73),
          o2(0x8D,0x74),      o2(0x8D,0x75),
          o2(0xB6,0xDA),      o2(0x8D,0x76),
          o2(0x8D,0x77),      o2(0x8D,0x78),
          o2(0xB6,0xDB),      o2(0x8D,0x79),
          o2(0x8D,0x7A),      o2(0x8D,0x81),
          o2(0x8D,0x82),      o2(0x8D,0x83),
          o2(0x8D,0x84),      o2(0x8D,0x85),
                  UNDEF,
};

static const BYTE_LOOKUP
to_CP949_EB_1B = {
    to_EUC_KR_E3_05_offsets,
    to_CP949_EB_1B_infos
};


static const struct byte_lookup* const
to_CP949_EB_1C_infos[65] = {
          o2(0xB6,0xDC),      o2(0xB6,0xDD),
          o2(