#include "sncon.h"
/*
 *  $Id$
 * sn_initscr(void) initializes ncurses interface for sncon
 */
int             HAS_COLORS;

WINDOW         *balarm_win;
WINDOW         *bnode_win;
WINDOW         *alarm_win;
WINDOW	       *alarmmsg_win;
WINDOW         *node_win;

winparam  alarmparam;
winparam  balarmparam;
winparam   nodeparam;
winparam  bnodeparam;
winparam  alarmmsgparam;



void 
sn_initscr(void)
{
	initscr();
	cbreak();
	noecho();
	nonl();
	nodelay(stdscr,TRUE);
	clear();
	if (has_colors() == TRUE) {
		HAS_COLORS = 1;
		start_color();
		init_pair(COLOR_MAIN, COLOR_GREEN, COLOR_BLACK);
		init_pair(COLOR_NODE, COLOR_CYAN, COLOR_BLACK);
		init_pair(COLOR_ALARM, COLOR_GREEN, COLOR_BLUE);
		init_pair(COLOR_ALARMMSG, COLOR_WHITE, COLOR_RED);
	} else
		HAS_COLORS = 0;
	//box(stdscr, ACS_VLINE, ACS_HLINE);
	bnodeparam.lines=(LINES - 1)/4 - 1;
	bnodeparam.cols = COLS;
	nodeparam.lines=(LINES - 1)/4 - 2;
	nodeparam.cols = COLS - 2;


	balarmparam.lines=3*(LINES - 1)/4 - 1;
	balarmparam.cols = COLS;
	alarmparam.lines=3*(LINES - 1)/4 - 3;
	alarmparam.cols = 56;
	
        alarmmsgparam.lines = 3*(LINES - 1)/4 - 3;
	alarmmsgparam.cols = COLS - 59;
	
	bnode_win = newwin(bnodeparam.lines, bnodeparam.cols , 1, 0);
	balarm_win = newwin(balarmparam.lines, balarmparam.cols,(LINES-1)/4, 0);
	node_win = newwin(nodeparam.lines, nodeparam.cols, 2, 1);
	alarm_win = newwin(alarmparam.lines, alarmparam.cols, (LINES-1)/4+1, 1);
	alarmmsg_win = newwin(alarmmsgparam.lines, alarmmsgparam.cols,
		(LINES - 1)/4+1, 58);

	if (node_win == NULL || alarm_win == NULL) {
		fprintf(stderr, "Could not create windows\n");
		exit(1);
	}
	if (HAS_COLORS) {
		attrset(COLOR_PAIR(COLOR_MAIN));
		wattrset(bnode_win, COLOR_PAIR(COLOR_NODE));
		wattrset(balarm_win, COLOR_PAIR(COLOR_ALARM));
		//wattrset(alarmmsg_win, COLOR_PAIR(COLOR_NODE));
		wbkgd(alarmmsg_win,COLOR_PAIR(COLOR_ALARMMSG));
	}
	wclear(node_win);
	wclear(alarm_win);
	wclear(alarmmsg_win);
	box(balarm_win, ACS_VLINE, ACS_HLINE);
	mvaddstr(0, COLS / 2 - strlen(SNBANNER) / 2, SNBANNER);
	move(2, 1);
	wsetscrreg(node_win, 0, nodeparam.lines - 1);
	wsetscrreg(alarm_win, 0, alarmparam.lines -1);
	scrollok(node_win, TRUE);
	scrollok(alarm_win, TRUE);
	/*
	 * for (i=0;i<LINES-3;i++) { wmove(node_win,i,0); whline(node_win,'
	 * ',COLS/4-2); wmove(alarm_win,i,0); whline(alarm_win,'
	 * ',3*COLS/4-3);
	 */
	wmove(node_win, 0, 0);
	wmove(alarm_win, 0, 0);
	wmove(alarmmsg_win, 0, 0);
	sn_connected_status(0, 0);
	mvwaddstr(balarm_win, 0, 1," SENSOR IP ");
	mvwaddstr(balarm_win, 0, 14," PROTO ");
	mvwaddstr(balarm_win, 0, 25," SOURCE ");
	mvwaddstr(balarm_win, 0, 41," DEST ");
	wnoutrefresh(stdscr);
	wnoutrefresh(node_win);
	wnoutrefresh(alarm_win);
	wnoutrefresh(bnode_win);
	wnoutrefresh(balarm_win);
	doupdate();
}
/*
 * sn_endscr(void) deinitializes ncurses interface for sncon
 */
void 
sn_endscr(void)
{
	werase(stdscr);
	clear();
	wrefresh(stdscr);
	endwin();
}


void sn_connected_status(int connected, int total) {

	//box(bnode_win, ACS_VLINE, ACS_HLINE);
	mvwaddstr(bnode_win, 0, 1, "CONNECTED NODES");
	mvwprintw(bnode_win, 0, COLS-30, "Connected:% 6i Total:% 6i",connected,
			total);
	
}
