-- Copyright (C) 2000 Carnegie Mellon University
--
-- Author: Roman Danyliw <roman@danyliw.com>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- - Purpose:
--   Creates the PostgreSQL tables in the Snort database neccessary to support
--   ACID.
--  
--   TABLE acid_ag: stores the description of an Alert Group (AG)
-- 
--   TABLE acid_ag_alert: stores the IDs of the alerts in an Alert Group (AG)
--
--   TABLE acid_ip_cache: caches DNS and whois information

CREATE TABLE acid_ag      ( ag_id               SERIAL NOT NULL,
                            ag_name             TEXT,
                            ag_desc             TEXT, 
                            ag_ctime            DATETIME,
                            ag_ltime            DATETIME,

                            PRIMARY KEY         (ag_id) );

CREATE TABLE acid_ag_alert( ag_id               INT8 NOT NULL,
                            ag_sid              INT4 NOT NULL,
                            ag_cid              INT8 NOT NULL, 

                            PRIMARY KEY         (ag_id, ag_sid, ag_cid) );

CREATE INDEX acid_ag_alert_id_idx ON acid_ag_alert (ag_sid, ag_cid);

CREATE TABLE acid_ip_cache( ipc_ip                  INT8 NOT NULL,
                            ipc_fqdn                TEXT,
                            ipc_dns_timestamp       DATETIME,
                            ipc_whois               TEXT,
                            ipc_whois_timestamp     DATETIME,

                            PRIMARY KEY         (ipc_ip) );

CREATE INDEX acid_ipc_ip_idx ON acid_ip_cache (ipc_ip);
CREATE INDEX acid_ipc_fqdn_idx ON acid_ip_cache (ipc_fqdn);
