/* Identities */

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  9, X'3045310B300906035504061302434831193017060355040A13104C696E7578207374726F6E675377616E311B3019060355040313127374726F6E675377616E20526F6F74204341'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'5da7dd700651327ee7b66db3b5e5e060ea2e4def'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'ae096b87b44886d3b820978623dabd0eae22ebbc'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* venus.strongswan.org */
  2, X'76656e75732e7374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* sun.strongswan.org */
  2, X'73756e2e7374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, CN=venus.strongswan.org' */
  11, X'8ab59d2d99cb02fc9b00358b3b16cd7ce7ce8d0c'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* %any */
  0, '%any'
);

/* Certificates */

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  1, 1, X'308203b8308202a0a003020102020100300d06092a864886f70d01010b05003045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341301e170d3034303931303130303131385a170d3139303930373130303131385a3045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f7420434130820122300d06092a864886f70d01010105000382010f003082010a0282010100bff25f62ea3d566e58b3c87a49caf3ac61cfa96377734d842db3f8fd6ea023f7b0132e66265012317386729c6d7c427a8d9f167be138e8ebae2b12b95933baef36a315c3ddf224cee4bb9bd578135d0467382629621ff96b8d45f6e002e5083662dce181805c140b3f2ce93f83aee3c861cff610a39f0189cb3a3c7cb9bf7e2a09544e2170efaa18fdd4ff20fa94be176d7fecff821f68d17152041d9b46f0cfcfc1e4cf43de5d3f3a587763afe9267f53b11699b3264fc55c5189f5682871166cb98307950569641fa30ffb50de134fed2f973cef1a392827862bc4ddaa97bbb01442e293c41070d07224d4be47ae2753eb2bed4bc1da91c68ec780c4620f0f0203010001a381b23081af30120603551d130101ff040830060101ff020101300b0603551d0f040403020106301d0603551d0e041604145da7dd700651327ee7b66db3b5e5e060ea2e4def306d0603551d230466306480145da7dd700651327ee7b66db3b5e5e060ea2e4defa149a4473045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341820100300d06092a864886f70d01010b0500038201010023929aa101b412d1f5a577532088f209b34798a72ed7bd6945d74beaa2b3a1768764ad7f8b0df8d97a1a3ed1102e92a5f107e3059dc2250be49d02261ca83a342e0e5de7d43c37744e3fcea3197720ca1184d4ef94e6beeb0d241746b0b92b7fb1004c08e88bf9eb4ce60f3e149466f3e9fc3f98bce449f448f9d465e52b59f0101e6203cfad0d89e23509fa043d4c12021e8f32be7db8b2edbada641d64aa1a04af64a2ee5b814a753dd76b30e3de04f3c6b61166e632f8364d51cf3730a9564a4d93b9227c28b09b0f5595d92a632f72fe509a129ca9ee54df2b0edc6c3d38564f10256efcd8be82b2ec64977e3a6f5ef098eaa7f00662a6cded16cb80637c'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=venus.strongswan.org */
  1, 1, X'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'
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 1
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 2
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 3
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 4
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 6
);

/* Private Keys */

INSERT INTO private_keys (
   type, data
) VALUES ( /* key of 'C=CH, O=Linux strongSwan, CN=venus.strongswan.org' */
  1, X'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'
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 4
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 6
);

/* Configurations */

INSERT INTO ike_configs (
  local, remote
) VALUES (
  'PH_IP_VENUS', 'PH_IP_SUN'
);

INSERT INTO ike_configs (
  local, remote
) VALUES (
  '%any', '%any'
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id, virtual
) VALUES (
  'nat-t', 1, 4, 5, '0.0.0.0'
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id, auth_method
) VALUES (
  'shunts', 2, 7, 7, 0
);

INSERT INTO child_configs (
  name
) VALUES (
  'nat-t'
);

INSERT INTO child_configs (
  name, mode, start_action
) VALUES (
  'local-net', 4, 1
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 1
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  2, 2
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES ( /* 10.1.0.0/16 */
  7, X'0a010000', X'0a01ffff'
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES ( /* 0.0.0.0/0 */
  7, X'00000000', X'ffffffff'
);

INSERT INTO traffic_selectors (
  type
) VALUES ( /* dynamic/32 */
  7
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  1, 2, 1
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  1, 3, 2
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  2, 1, 0
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  2, 1, 1
);
