//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "biblecsmgr.h"
#include "swdisprtfchap.h"
//---------------------------------------------------------------------------
static inline SWDispRTFChap *ValidCtrCheck()
{
	return new SWDispRTFChap(NULL);
}
//---------------------------------------------------------------------------
__fastcall SWDispRTFChap::SWDispRTFChap(TComponent* Owner)
	: SWDispRTF(Owner)
{
	FCurVersePos = true;
	FCurVerseMrk = true;
	FMarkCurrentVerse = true;
	FAutoPosition     = true;

        OSVERSIONINFO osvi;
        memset(&osvi, 0, sizeof(OSVERSIONINFO));
        osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
        GetVersionEx(&osvi);
        platformID = osvi.dwPlatformId;        
}

__fastcall SWDispRTFChap::~SWDispRTFChap()
{
}


void __fastcall SWDispRTFChap::Loaded(void)
{
	SWDispRTF::Loaded();
}


char SWDispRTFChap::Display(SWModule &Module)
{
	int testmt, book, chap, verse, versepos;
	System::AnsiString newtext, tmptext;
	VerseKey *key = (VerseKey *)(SWKey *)Module;
	testmt = key->Testament();
	chap   = key->Chapter();
	book   = key->Book();
	verse  = key->Verse();
	key->Verse(1);
	newtext = RTFHeader;
	newtext = newtext + RTFChapterMarkPre + IntToStr(chap) + RTFChapterMarkPost;
        newtext = newtext + "\\pard\\f0\\nowidctlpar\\cf7 ";
        if (Module.Direction() == DIRECTION_RTL) {
                        newtext = newtext + "\\qr ";
        }
        if (Module.Direction() == DIRECTION_RTL && (platformID == WINNT && (!strnicmp(Module.Lang(), "he", 2) || !strnicmp(Module.Lang(), "ar", 2)))) {
                        newtext = newtext + "\\rtlpar ";
        }

	Module.Error(); // clear error;
	while ((key->Book() == book) && (key->Chapter() == chap) && (Module.Error() == 0)) {
                newtext = newtext + "{";
		if (key->Verse() == verse && MarkCurrentVerse == true)
			newtext = newtext + "\\cf2 "; // \cf2 = second color in color table

		tmptext = "";
		for (const char *loop = (const char *)Module; *loop; loop++) {
			if (*loop == '\n')
				tmptext += "\\par ";
			else	tmptext += *loop;
		}
		if (tmptext.Length() > 3) {	// make sure we have an entry
                        if (Module.Direction() == DIRECTION_RTL && (platformID == WIN9X || (Module.Lang() && strnicmp(Module.Lang(), "he", 2) && strnicmp(Module.Lang(), "ar", 2)))) {
        			newtext = newtext + RTFVersePre + tmptext + RTFVersePost;
	        		newtext = newtext + RTFVerseMarkPre + IntToStr(key->Verse()) + RTFVerseMarkPost;
                                newtext = newtext + "\\par ";
                        } else {
	        		newtext = newtext + RTFVerseMarkPre + IntToStr(key->Verse()) + RTFVerseMarkPost;
        			newtext = newtext + RTFVersePre + tmptext + RTFVersePost;
                        }
		}
		if ((key->Verse() == verse) && (AutoPosition == true)) {
			tmptext = newtext + RTFTrailer;
			RTFStream->Clear();
			RTFStream->WriteBuffer(tmptext.c_str(), tmptext.Length());
			RTFStream->Position = 0;
//			FMarkCurrentVerse = true;
			Lines->LoadFromStream(RTFStream);
			PlainText = true;
			versepos = GetTextLen(); //RTFStream.Position;
			PlainText = false;
		}
                newtext = newtext + "}";                
		Module++;
	}
	newtext = newtext + RTFTrailer;
	key->Verse(1); //{ When setting chapter: if (verse <> new chapter range) don't autonormalize. (we could've just turned the autonormalize option off then back on, but this is cooler) }
	key->Chapter(1);
	key->Book(1);
	key->Testament(testmt);
	key->Book(book);
	key->Chapter(chap);
	key->Verse(verse);
	RTFStream->Clear();
	RTFStream->WriteBuffer(newtext.c_str(), newtext.Length());
	RTFStream->Position = 0;
	Lines->LoadFromStream(RTFStream);

	//{ Position control text at current verse }
     this->SetFocus();
	if (AutoPosition == true) {
		SelStart = versepos;
		SendMessage(Handle, EM_SCROLLCARET, 0, 0);
	}
	return 0;
}


//---------------------------------------------------------------------------
namespace Swdisprtfchap
{
	void __fastcall Register()
	{
		TComponentClass classes[1] = {__classid(SWDispRTFChap)};
		RegisterComponents("SWORD", classes, 0);
	}
}
//---------------------------------------------------------------------------
 