/*
 * buflog.h - buffer-based DataLog base classes
 * $Id: buflog.h,v 1.2 2004/06/05 15:15:17 rdenisc Exp $
 */

/***********************************************************************
 *  Copyright (C) 2002-2003 Remi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Public License  *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifndef __TCPREEN_BUFLOG_H

# define __TCPREEN_BUFLOG_H
# include "log.h"

# ifndef __cplusplus
#  error This is a C++ only header!
# else
/*
 * Base class for (on-demand) line-bufferized log format
 *
 * NOTES:
 *  - Out-of-Band data is not buffered,
 *  when buffering is enabled:
 *  - data might be lost if shutdown occurs in the middle of a line,
 *  - Carriage Return ('\r') are ignored,
 *  - line feeds ('\n') are replaced with '\0',
 *  - data sent to WriteServerLine() or WriteClientLine() is always
 *    nul-terminated.
 */
class LineBufDataLog : public DataLog
{
	private:
		typedef struct
		{
			char *buf;
			size_t tsize, usize; // total size, useful size
		} LineBuf;
		LineBuf clb, svb;

		virtual int WriteServerLine (const char *data, int length,
						int oob = 0) = 0;
		virtual int WriteClientLine (const char *data, int length,
						int oob = 0) = 0;

		int Write (int isout, const char *data, int length, int oob);
		static void SetBuffer (LineBuf *st, char *buf = NULL,
					size_t len = 0);

		int WriteData (LineBuf* st, const void *data, int len,
				int oob);


	public:
		LineBufDataLog (void) : DataLog ()
		{
			SetBuffer (&clb);
			SetBuffer (&svb);
		}

		// sets up buffer to hold data sent by the server
		void SetServerBuffer (char *ptr = NULL, size_t size = 0)
		{
			SetBuffer (&svb, ptr, size);
		}

		// same for the client
		void SetClientBuffer (char *ptr = NULL, size_t size = 0)
		{
			SetBuffer (&clb, ptr, size);
		}

		virtual int WriteServerData (const void *data, int length,
						int oob);
		virtual int WriteClientData (const void *data, int length,
						int oob);
};
# endif /* ifdef __cplusplus */
#endif /* ifndef __TCPREEN_BUFLOG_H */
