<?php
/*
 * Copyright 1999 - 2003 by Gero Kohnert
 * well, copyright? Inspired by Gero,
 * shamelessly copied and mutulated by J. Baten
 * This should turn out to be a salesforecast report
 * Multiply price * probability = balanced sales amount
 * if chances are estimated correctly this should give you
 * a good impression of future sales.
 * version 1.1 d.d. 01032002 J. Baten initial version. far from finished.
 * version 1.2 d.d. 02032002 J. Baten, fixed the totals at the bottom
 * still todo
 * -subdivide output in separate months
 * -make graph of report (using jpgraph)
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'timetrack.pinc';
 include_once 'bug.pinc';
 include_once 'product.pinc';
 include_once 'task.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("prodct","forecast");
 loadlayout();

 /**
  * sales forecast
  */
 class product_forecast extends layout {
   /**
    * Display table with product/project info. This is the normal report.
    * version: 1.0 date 03022002 J. Baten Seems to be find now.
    */
   Function info() {
     global $lang,$tutos;

     $result = $this->dbconn->Exec($this->q);
     $plist = array();
     $n = $result->numrows();
     if ( 0 == $n) {
       echo $this->error($lang['Err0048']);
       $result->free();
       return;
     }
	 if ($this->format == "stat" ) {
       $this->statinfo($result);
       $result->free();
       return;
	 }
     if ( $this->format == "image" ) {
       $this->image($result);
       return;
     }
     foreach($tutos[currencies] as $c) {
       $sum[1][$c] = 0;
       $sum[2][$c] = 0;
     }
     $sum[1][""] = 0;
     $sum[2][""] = 0;

     $flds = 0;

     # Make a big array of all visible products
     $x = 0;
     while ( $x < $n ) {
       $p = new product($this->dbconn);
       $p->read_result($result,$x);
       $x++;
       if ( ! $p->see_ok() ) {
         unset($p);
         continue;
       }
       $sum[1][$p->currency] += $p->price;
       $sum[2][$p->currency] += $p->getBalanced();
       $plist[] = &$p;
       unset($p);
     }
     $n = count($plist);
     if ( 0 == $n) {
       echo $this->error($lang['Err0048']);
       $result->free();
       return;
     }

     # start the header for the results
     echo $this->OverviewTableStart();
     echo "<thead>\n";
     echo "<tr>\n";

     foreach ($tutos[prodfields] as $c) {
       if ( ($c == "name") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdName'],"");
         $flds++;
       }
       if ( ($c == "version") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdVersion'],"");
         $flds++;
       }
       if ( ($c == "seller") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdRole'][4],"");
         $flds++;
       }
       if ( ($c == "manager") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdRole'][1],"");
         $flds++;
       }
       if ( ($c == "customer") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdRole'][6],"");
         $flds++;
       }
       if ( ($c == "supplier") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdRole'][7],"");
         $flds++;
       }
       if ( ($c == "reseller") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdRole'][8],"");
         $flds++;
       }
       if ( ($c == "partner") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdRole'][9],"");
         $flds++;
       }
       if ( ($c == "desc") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdDesc'],"");
         $flds++;
       }
       if ( ($c == "desc1") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdDesc1'],"");
         $flds++;
       }
       if ( ($c == "desc2") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdDesc2'],"");
         $flds++;
       }
       if ( ($c == "cl1") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdClass1'],"");
         $flds++;
       }
       if ( ($c == "cl2") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdClass2'],"");
         $flds++;
       }
       if ( ($c == "state") && $this->pshow[$c] ) {
         echo$this-> orderHeader("",$lang['ProdState'],"");
         $flds++;
       }
       if ( ($c == "probability") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdProb'],"");
         $flds++;
       }
       if ( ($c == "price") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdPrice'],"");
         $flds++;
         $pf = $flds;
       }
       if ( ($c == "cost") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdCost'],"");
         $flds++;
         $cf = $flds;
       }
       if ( ($c == "creator") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdCreator'],$this->link2);
         $flds++;
       }
       if ( ($c == "creation") && $this->pshow[$c] ) {
         echo $this->orderHeader("creation",$lang['ProdCreationS'],$this->link2);
         $flds++;
       }
       if ( ($c == "p_start") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdStart'],"");
         $flds++;
       }
       if ( ($c == "p_end") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdEnd'],"");
         $flds++;
       }
       if ( ($c == "balanced") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['SalesBalanced'],"");
         $flds++;
       }
       if ( $this->user->feature_ok(usebugtracking,PERM_SEE) ) {
         if ( ($c == "pbugs") && $this->pshow[$c] ) {
           echo $this->orderHeader("",$lang['Bugs'],"");
           $flds++;
         }
       }
     }
     echo "</tr>\n";
     echo "</thead>\n";

     $a = 0;
     $end = $n;
     $line = 0;

     $sumPeriod = array();
     $oldperiod = "";
     $notthefirst=false;
     # start the main body with the results
     echo "<tbody>\n";
     while ( ($a < $n) && ($a < $end) ) {
       $p = &$plist[$a];
       $p->readroles();

       # here we select the period to display
       $period=$p->p_end->month."/".$p->p_end->year;
       if ( $period == "-1/-1" ) {
         $period=$lang["UndefinedEndDate"];
       } 
       # a new timeperiod has started. Let's make a row.
       # and if it is not the first header then print a subtotal
       if ( $oldperiod != $period ) {
         if ( $notthefirst == true ) {
           $periodtotal=$sumPeriod[$oldperiod];
           echo "<tr><td colspan='". ($flds - 1) ."'>&nbsp;</td><td nowrap align='right'><i><b>";
           foreach($periodtotal as $i => $f) {
             echo number_format($f,2,$lang['DecPoint'],$lang['ThousandPoint']) ." ". htmlspecialchars($i) ."<br>\n";
           }
           echo "</b></i></td></tr>";
         }
         $sumPeriod[$period] = array();
         echo "<tr><td colspan='". $flds ."' align='left'><h2>".$period."</h2></td></tr>";
         $notthefirst=true;
       }
       $oldperiod=$period; 
       if (!isset($sumPeriod[$period][$p->currency])) {
         $sumPeriod[$period][$p->currency] = 0;
       } 
       $sumPeriod[$period][$p->currency] += $p->getBalanced();
       #
       echo $this->OverviewRowStart($line);
       foreach ($tutos[prodfields] as $c) {
         # projectname
         if ( ($c == "name") && $this->pshow[$c] ) {
           $b = myentities($p->name);
           if ( $this->filter['name'] != "" ) {
             $b = eregi_replace("(". $this->filter['name'] .")","<span class=\"found\">\\1</span>",$b);
           }
           echo "  <td valign=\"top\">&nbsp;". makelink($p->getUrl(),$b) ."</td>\n";
         }
         if ( ($c == "version") && $this->pshow[$c] ) {
           $b = myentities($p->version);
           if ( $this->filter['name'] != "" ) {
             $b = eregi_replace("(". $this->filter['name'] .")","<span class=\"found\">\\1</span>",$b);
           }
           echo "  <td valign=\"top\">&nbsp;". $b ."</td>\n";
         }

         # Customer
         if ( ($c == "customer") && $this->pshow[$c] ) {
           echo "  <td valign=\"top\">\n &nbsp;";
           if (isset($p->role[6]) && (count($p->role[6]) > 0) ) {
             @reset ($p->role[6]) ;
             $x = 0;
             while ( list ($i,$r) = @each ($p->role[6]) ) {
               if ( $x > 0 ) {
                 echo "<br>\n &nbsp;";
               }
               echo  $r->getLink();
               $x++;
             }
           }
           echo "  </td>\n";
         }

         # someone forget to say 'description' here :-)
         if ( ($c == "desc") && $this->pshow[$c] ) {
           $b = myentities($p->description);
           if ( $this->filter['name'] != "" ) {
             $b = eregi_replace("(". $this->filter['name'] .")","<span class=\"found\">\\1</span>",$b);
           }
           echo "  <td valign=\"top\">&nbsp;". $b ."</td>\n";
         }

         # state
         if ( ($c == "state") && $this->pshow[$c] ) {
           echo "  <td valign=\"top\">&nbsp;". $lang['ProdStates'][$p->state] ."</td>\n";
         }
         # probability (mucho importante)
         if ( ($c == "probability") && $this->pshow[$c] ) {
           echo "  <td valign=\"top\">&nbsp;". $p->probability ."%</td>\n";
         }
         # price (also mucho importante)
         if ( ($c == "price") && $this->pshow[$c] ) {
           echo "  <td valign=\"top\" align=\"right\">&nbsp;". number_format($p->price,2,$lang['DecPoint'],$lang['ThousandPoint']) ." ". htmlspecialchars($p->currency) ."</td>\n";
         }
         # price (also mucho importante)
         if ( ($c == "cost") && $this->pshow[$c] ) {
           echo "  <td valign=\"top\" align=\"right\">&nbsp;". number_format($p->cost,2,$lang['DecPoint'],$lang['ThousandPoint']) ." ". htmlspecialchars($p->currency) ."</td>\n";
         }
         # balanced result
         if ( ($c == "balanced") && $this->pshow[$c] ) {
           echo "  <td valign=\"top\" align=\"right\">&nbsp;". number_format($p->getBalanced(),2,$lang['DecPoint'],$lang['ThousandPoint']) ." ". htmlspecialchars($p->currency) ."</td>\n";
         }
         # start date
         if ( ($c == "p_start") && $this->pshow[$c] ) {
           echo "  <td valign=\"top\">&nbsp;". $p->p_start->getLinkDate() ."</td>\n";
         }
         # end date
         if ( ($c == "p_end") && $this->pshow[$c] ) {
           echo "  <td valign=\"top\">&nbsp;". $p->p_end->getLinkDate() ."</td>\n";
         }
       }
       echo $this->OverviewRowEnd($line++);
       unset($plist[$a]);
       unset($p);
       $a++;
     }
     echo "</tbody>\n";

     echo "<tfoot>\n";
     echo $this->list_navigation($this->link1,$flds,$this->start,$a,$n);

     # Sums of amounts
     if ( ($this->pshow['price'] == 1) || ($this->pshow['balanced'] == 1) ) {
     echo "<tr>\n";
     $fill = 0;
     foreach ($tutos[prodfields] as $c) {
       if (  $this->pshow[$c] == 0 ) {
         continue;
       }
       # display total sum of price
       if ( $c == "price" ) {
         if ( $fill > 0 ) {
           echo " <td colspan=\"". $fill ."\">&nbsp;</td>\n";
           $fill = 0;
         }
         echo " <td nowrap align=\"right\">\n";
         @reset($sum[1]);
         $pre = "";
         while( list ($i1,$f1) = @each ($sum[1])) {
           if ( $f1 ) {
             echo $pre . number_format($f1,2,$lang['DecPoint'],$lang['ThousandPoint']) ." ". $i1;
             $pre = "<br>\n";
           }
         }
         echo " </td>\n";
       } else if ( $c == "balanced" ) {
         # display total sum of balanced
         if ( $fill > 0 ) {
           echo " <td colspan=\"". $fill ."\">&nbsp;</td>\n";
           $fill = 0;
         }
         echo " <td nowrap align=\"right\">\n";
         @reset($sum[2]);
         $pre = "";
         while( list ($i1,$f1) = @each ($sum[2])) {
           if ( $f1 ) {
             echo $pre . number_format($f1,2,$lang['DecPoint'],$lang['ThousandPoint']) ." ". $i1;
             $pre = "<br>\n";
           }
         }
         echo " </td>\n";
       } else {
         $fill++;
       }
     }
     if ( $fill > 0 ) {
       echo " <td colspan=\"". $fill ."\">&nbsp;</td>\n";
     }
     echo "</tr>\n";
   }

   echo "</tfoot>\n";
   echo $this->OverviewTableEnd();
 }
 /**
  * version 1.0 date 03032002 initial version
  * This procedure makes a graphic display of the information.
  * since I can't use jpgrapg to make an inline graphic, I just
  * call myself as an image... :-) cute no?
  */
 Function statinfo() {
   global $lang,$tutos;
   $src = "sales_forecast.php?format=image";
   $src = addSessionKey($src);
   if (file_exists($tutos[jpgraph]."/jpgraph.php")  ) {
     echo "<img border=\"0\" src=\"".$src."\">";
   } else if (file_exists ($tutos[jpgraph]."/src/jpgraph.php") ) {
     echo "<img border=\"0\" src=\"".$src."\">";
   } else {
     echo $this->error("no jpgraph");
   }
 }

 # this function is used by the above mentioned function
   Function image(&$result) {
     global $lang,$tutos;

     if (file_exists($tutos[jpgraph]."/jpgraph.php")  ) {
       include ($tutos[jpgraph]."/jpgraph.php");
       include ($tutos[jpgraph]."/jpgraph_bar.php");
     } else {
       include ($tutos[jpgraph]."/src/jpgraph.php");
       include ($tutos[jpgraph]."/src/jpgraph_bar.php");
     }
     #add a temporary field
     # now where can I put the above extension?
 
     $n = $result->numrows();
     $a = 0;
     $cnt = 0;
     $notthefirst=false;
     $sumperiodtotal=0;
     $datax=array();
     $datay1=array();
     $datay2=array();
     $sumPeriod = array();
     $oldperiod = "";
     while ( $a < $n ) {
       $p = new product($this->dbconn);
       $p->read_result($result,$a);
       #$p->readroles();
       $cnt++;
       # here we select the period to display
       $m=$p->p_end->month;
       $y=$p->p_end->year;
       $period= $m."/".$y;
       if ( $period == "-1/-1" ) {
         $period=$lang["UndefinedEndDate"];
       } 
       # a new timeperiod has started. Let's make a row.
       # and if it is not the first header then print a subtotal
       if ( $oldperiod != $period ) {
         if ( $notthefirst == true ) {
           array_push($datax,$oldperiod);

           $periodtotal=$sumPeriod[$oldperiod];
           array_push($datay1,$periodtotal);

           $sumperiodtotal+=$periodtotal;
           array_push($datay2,$sumperiodtotal);

           $sumPeriod[$period]=0;
         }
         $notthefirst=true;
       }
       $oldperiod=$period; 
       if (isset($sumPeriod[$period])) {
         $sumPeriod[$period]+=$p->getBalanced();
       } else {
         $sumPeriod[$period]= $p->getBalanced();
       } 
       #unset($p);
       $a++;
     }
     # let's get the last values...
     array_push($datax,$oldperiod);

     $periodtotal=$sumPeriod[$oldperiod];
     array_push($datay1,$periodtotal);

     $sumperiodtotal+=$periodtotal;
     array_push($datay2,$sumperiodtotal);

     $graph = new Graph(600,400,"auto");
     $graph->img->SetMargin(90,40,40,40);
     $graph->SetScale("textlin");
#    $graph->SetShadow();
     $graph->title->Set($lang['SalesForecastRep']);
     $graph->title->SetFont(FF_FONT1,FS_BOLD);

     $graph->xaxis->title->Set($lang["Period"]);
     $graph->xaxis->SetTickLabels($datax);  
     $graph->xaxis->title->SetFont(FF_FONT1,FS_BOLD);

     $graph->yaxis->title->Set($lang["Est_revenue"]);
     $graph->yaxis->title->SetFont(FF_FONT1,FS_BOLD);
     $graph->yaxis->SetTitleMargin(65);

     $p1 = new BarPlot($datay2);
     $p1->SetFillColor("orange");
     $p1->SetLegend($lang["AccumulatedRevenue"]);

     $p2 = new BarPlot($datay1);
     $p2->SetFillColor("blue");
     $p2->SetWidth(1.0);
#     $p2->SetValueFormat("%0d");
#     $p2->ShowValue();
     $p2->SetLegend($lang["PeriodRevenue"]);

     // Create the grouped bar plot
     $plot = new AccBarPlot(array($p1,$p2));
     $plot->SetShadow();

     $graph->Add($plot);
     $graph->Stroke();
   }

   /**
    * navigate
    */
   Function navigate() {
     global $lang,$tutos;

     echo "<tr><td>\n";
     $m = product::getSelectLink($this->user,$lang['Search']);
     echo menulink($m[url],$m[text],$m[info]) ."<br>\n";

     echo  menulink("product_new.php",$lang['NewEntry'],$lang['ProdCreateInfo']) ."<br>";
     echo "</td></tr>\n";
     echo "<tr><td>\n";
     $ll = addUrlParameter($this->link1,"format=paper");
     echo menulink($ll,$lang['Printable'],$lang['PrintableInfo']);

     if ( $this->format != "stat" ) {
       echo "<br>";
       $ll = addUrlParameter($this->link1,"format=stat");
       echo menulink($ll,$lang['Graph'],$lang['GraphInfo']);
     }
     echo "</td></tr>\n";
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$tutos,$lang;

     $this->name = $lang['SalesForecastRep'];
     $this->link1 = "sales_forecast.php";
     $this->filter = array();
     $this->filter['name'] = "";
     $this->pshow = array();
     $tutos[prodfields][] = "balanced";
     foreach ($tutos[prodfields] as $c) {
       $this->pshow[$c] = 0;
     }
     $this->pshow['name']         = 1;
     $this->pshow['customer']     = 1;
     $this->pshow['desc']         = 1;
     $this->pshow['cost']         = 1;
     $this->pshow['price']        = 1;
     $this->pshow['probability']  = 1;
     $this->pshow['balanced']     = 1;
     $this->pshow['state']        = 1;
     $this->pshow['p_start']      = 1;
     $this->pshow['p_end']        = 1;
     $this->pshow['balanced']     = 1;

     $this->flds['name']         = 'ProdName';
     $this->flds['version']      = 'ProdVersion';
     $this->flds['customer']     = 'ProdRole6';
     $this->flds['desc']         = 'ProdDesc';
     $this->flds['cost']         = 'ProdCost';
     $this->flds['price']        = 'ProdPrice';
     $this->flds['probability']  = 'ProdProb';
     $this->flds['balanced']     = 'balanced';
     $this->flds['state']        = 'ProdState';
     $this->flds['p_start']      = 'ProdStart';
     $this->flds['p_end']        = 'ProdEnd';
     $p = new product($this->dbconn);
     for ( $cl = 1;$cl <= $p->classes; $cl++) {
       $x = sprintf("cl%d",$cl);
       $this->flds['cl'.$cl]     = 'ProdClass'.$cl;
     }

     $this->q = "SELECT * FROM ". $this->dbconn->prefix ."products where state in (0,1,4)";
     $pre = " WHERE ";
     $this->q .= " ORDER by p_end ASC";
   }
 }


 # functions to do when we have a lot of info BUT BEFORE any output!
 # is the file calles with an argument 'function'?


 $l = new product_forecast($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: sales_forecast.php,v 1.22 2003/03/01 23:04:27 gokohnert Exp $
    $Author: gokohnert $
-->
