<?php
/**
 * Zend Framework
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://framework.zend.com/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@zend.com so we can send you a copy immediately.
 *
 * @category   Zend
 * @package    Zend_Markup
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2005-2012 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 * @version    $Id$
 */

if (!defined('PHPUnit_MAIN_METHOD')) {
    define('PHPUnit_MAIN_METHOD', 'Zend_Markup_AllTests::main');
}

require_once 'Zend/Markup/BbcodeAndHtmlTest.php';
require_once 'Zend/Markup/TextileAndHtmlTest.php';
require_once 'Zend/Markup/ParserIntegrityTest.php';
require_once 'Zend/Markup/FactoryTest.php';

/**
 * @category   Zend
 * @package    Zend_Markup
 * @subpackage UnitTests
 * @group      Zend_Markup
 * @copyright  Copyright (c) 2005-2012 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 */
class Zend_Markup_AllTests
{
    public static function main()
    {
        $parameters = array();

        if (TESTS_GENERATE_REPORT && extension_loaded('xdebug')) {
            $parameters['reportDirectory'] = TESTS_GENERATE_REPORT_TARGET;
        }

        PHPUnit_TextUI_TestRunner::run(self::suite(), $parameters);
    }

    public static function suite()
    {
        $suite = new PHPUnit_Framework_TestSuite('Zend Framework - Zend_Markup');

        $suite->addTestSuite('Zend_Markup_BbcodeAndHtmlTest');
        $suite->addTestSuite('Zend_Markup_TextileAndHtmlTest');
        $suite->addTestSuite('Zend_Markup_ParserIntegrityTest');
        $suite->addTestSuite('Zend_Markup_FactoryTest');

        return $suite;
    }
}

if (PHPUnit_MAIN_METHOD == 'Zend_Markup_AllTests::main') {
    Zend_Markup_AllTests::main();
}
