.TH tkXBlast 1 "Release 2.2 (December 14th 1996)"
.SH NAME
tkXBlast - tcl/tk based setup tool for XBlast
.PP
.SH SYNOPSIS
.B tkXBlast 
.SH DESCRIPTION
.PP
\fItkXBlast\fP is an interactive setup tool for \fIXBlast\fP based
on \fItcl/tk\fP. It supports game setup, level selection and resource
setup. It is compatible with \fIXBlast 2.0\fP and \fI2.2\fP.
.PP
.SH UPPER BUTTON BAR
The upper button bar of \fItkXBlast\fP is use to select one of the five
\fItkXBlast\fP screens. It is available for all screens.
.TP
.B Launch
This button activates the \fBLaunch\fP screen. On this screen the
game options can be modified and the game itself can be launched. The
game setup can also be loaded and saved from this screen.
.TP
.B Levels
This button activates the \fBLevels\fP screen. On this screen the
levels to be played can be selected.
.TP
.B Statistics
This buttons activates the \fBStatistics\fP screen. On this screen
game statistics for each player and level can be reviewed.
.TP 
.B Player Colors
This button activates the \fBPlayer Colors\fP screen. On this screen
the player color resources can be set. This screen is not available
on black and white displays. 
.TP
.B Player Resources
This button activates the \fPPlayer Resources\fP screen. On this screen
the player messages and control keybindings can be defined.
.PP
.SH LAUNCH SCREEN
On this screen the
game options can be modified and the game itself can be launched. The
game setup can also be loaded and saved from this screen. On the lower
part of the screen are the following buttons:
.TP
.B Start XBlast
Pressing this button starts \fIXBlast\fP with the selected game
parameters. If any level selection was made on the \fBLevels\fP
screen, this will be used too. This button will also be invoked, when
you press \fIReturn\fP key.
.TP
.B Load Setup
Loads a previously saved setup from the file ~/.xblast.
.TP
.B Save Setup
Save the current setup to the file ~/.xblast. 
.TP
.B Exit
Press this button to exit \fItkXBlast\fP or press the
\fIEscape\fP key.
.PP
The \fILaunch\fP screen it self consists of several subwindows:
.TP
.B Player X
There are 6 player windows, one for each player. An active player
window shows the xblast sprite in winner pose. If the window
is inactive the sprite has turned his back to you. Enter the player's
name in the entry above the \fB\@\fP-sign and the display's name in
the entry below.
.TP 
.B Game Options
In this window you can setup any game option available to
\fIXBlast\fP:
.br
* \fINumber of Players\fP
.br 
* \fITeam Mode\fP
.br
* \fINumber of Lives\fP
.br
* \fINumber of Victories\fP
.br 
* \fIRandom Player Positions\fP
.br
* \fIRandom Level Order\fP
.br
* \fIAllow Color Mode\fP 
.br
* \fIOverride Window Manager\fP 
.br
* \fIFrame Rate\fP
.br
* \fIBell Sound\fP
.br 
* \fIFork XBlast\fP
.br 
* \fIGame Statistics\fP
.PP
.SH LEVELS SCREEN
On this screen you can select the levels you want to play. The lower
part contains the following buttons:
.TP
.B Start XBlast
Pressing this button starts \fIXBlast\fP with the selected game
parameters. If any level selection was made on the \fBLevels\fP
screen, this will be used too. This button will also be invoked, when
you press \fIReturn\fP key.
.TP
.B All
Pressing this button select all levels for playing.
.TP
.B None
Pressing this button deselects all levels for playing. Please
note, that you must selects at least one level for playing.
.TP
.B Toggle
Pressing this button toggles the state of all levels. 
.TP
.B Exit
Press this button to exit \fItkXBlast\fP or press the
\fIEscape\fP key.
.PP
The \fILevels\fP screen it self contains four level selection windows.
They list all levels available in XBlast. Click on any level to toggle
its selection (selected levels are marked in red).
.PP
.SH STATISTICS SCREEN
On this screen you can review the game statistics for \fIXBlast\fP.
In order to use this feature you must enable the game statistics
feature on the \fILaunch\fP screen. The statistics data will be stored
in the file ~/.xblast_stat. The lowe part contains the following
buttons:
.TP
.B Show Statistics
Pressing this button will show the statistics for any selected player
or level. This button will also be invoked, when
you press \fIReturn\fP key.
.TP
.B Update Statistics
Update the data currently displayed (from the statistics file).
.TP
.B Exit
Press this button to exit \fItkXBlast\fP or press the
\fIEscape\fP key.
.PP
The screen itself contains three subwindows
.TP
.B Select Level
This listbox contains all levels in the statistics database.
Press on any level to select it.
.TP
.B Select Player
This listbox contains all players in the statistics database.
Press on any player to select him/her.
.TP
.B Statistics for ...
In this window the results of your queries are shown. They are sorted
by highest value for percentage.
.PP
.SH PLAYER COLORS SCREEN
On this screen you customize the colors of your player. This changes
the colors on your display and on any other display. The lower part
contains the following buttons:
.TP
.B Apply
Pressing this buttons applies the selected player colors to your display,
by invoking \fIxrdb\fP. They will be lost when you finish you X-session.
This button will also be invoked, when you press \fIReturn\fP key..PP
.PP
.TP
.B Query
Pressing this button queries the current player colors from your
display, via \fIxrdb\fP.
.TP
.B Link to Defaults
Pressing this button modifies your ~/.Xresources file to include
the file ~/.xblast-player_colors, when being parsed.
.TP
.B Load
Pressing this button loads the color setup from the file
~/.xblast-player_colors. 
.TP
.B Save
Pressing this button saves the current color setup to the file
~/.xblast-player_colors. 
.TP
.B Exit
Press this button to exit \fItkXBlast\fP or press the
\fIEscape\fP key.
.PP
The screen itself contains the following subwindows:
.TP
.B Single/Right Player
In this window you can set the following color resource for
your player:
.br 
* \fIHelmet Color\fP
.br
* \fIFace Color\fP
.br
* \fIBody Color\fP
.br
* \fIHands & Feet Color\fP
.br
* \fIArms & Legs Color\fP
.br
* \fIBackpack Color\fP
.br
The buttons labeled \fI1 to 6\fP reset the colors to the default
value of \fIXBlast\fP. Enabling the \fISingle Player\fP option
uses this colors also with a single player.
.TP
.B Left Player
This window can be used to set the color option for the second player
on your display (if any). Enabling the \fISingle Player\fP option
uses this colors for the single player
.TP
.B Select Color
This window is a browser for named colors available at your system.
On its very first invocation, it will parse the local rgb.txt file for
color names. It will create a color database of its own stored in the
file ~/.xblast-rgb. You can change the color very easily, using the
\fISelect Color\fP window:
.br
1. Click on the color entry in the \fIPlayer\fP window you want to
change. 
.br
2. Click on the color in the \fISelect Color\fP window you want to
use.
.br
The buttons \fI<<, <, >, >>\fP are used to move forward and backward 
in the color list.
.PP
.SH PLAYER RESOURCES SCREEN
On this screen you can customize the name, messages and the
keybindings for your player. The changes will be used your display as
well as on any other display. The lower part contains the following
buttons:
.TP
.B Apply
Pressing this buttons applies the selected player colors to your display,
by invoking \fIxrdb\fP. They will be lost when you finish you X-session.
This button will also be invoked, when you press \fIReturn\fP key..PP
.PP
.TP
.B Query
Pressing this button queries the current player colors from your
display, via \fIxrdb\fP.
.TP
.B Link to Defaults
Pressing this button modifies your ~/.Xresources file to include
the file ~/.xblast-player_colors, when being parsed.
.TP
.B Load
Pressing this button loads the color setup from the file
~/.xblast-player_colors. 
.TP
.B Save
Pressing this button saves the current color setup to the file
~/.xblast-player_colors. 
.TP
.B Exit
Press this button to exit \fItkXBlast\fP or press the
\fIEscape\fP key.
.PP
The actual screen contains several subwindows:
.TP
.B Key Bindings
The following key bindings can be cutsomized foreach player:
.br
* \fIGo up\fP
.br
* \fIGo left\fP
.br
* \fIGo right\fP
.br
* \fIGo down\fP
.br
* \fIStop\fP
.br
* \fIDrop bomb\fP
.br
* \fISpecial action\fP
.br
* \fIRequest abort\fP
.br
* \fICancel abort\fP
.br
Each action can be bound to two different keys. Click on the key entry
and then press the key you want to bind the action to.
.TP
.B Single/Right Player
In this window you can set the default name for your player.
.TP
.B Left Player
In this window you can set the default name for any second player on
your display.
.TP
.B Messages
In this window you can set the following messages for your player:
.br
* Welcome Message
.br
* Gloat Message
.br 
* Lose Life Message
.br
* Lose Level Message
.br
* Win Level Message
.br
* Win Game Message
.br
* Abort Request Message
.br
* Abort Cancel Message
.PP
.SH SEE ALSO
.I xblast(1), wish(1), xrdb(1)
.PP
.SH BUGS
.br
The level selection cannot be saved
.br
\fItkXBlast\fP hangs up, when you enter an invalid color name into one
of the color entries.
.PP
.SH COPYRIGHT
Copyright (C) 1993-1996, Oliver Vogel (\fIvogel@ikp.uni-koeln.de\fP).
.PP
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public Licences as published
by the Free Software Foundation; either version 2; or (at your option)
any later version
.PP
This program is distributed in the hope that it will be entertaining,
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
Public License for more details.
.PP
You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.
675 Mass Ave, Cambridge, MA 02139, USA.
.PP
.SH AUTHOR
Oliver Vogel 
\fI(vogel@ikp.uni-koeln.de)\fP
.PP