// -*- C++ -*-
/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor
* 	 
*	    Copyright (C) 1995 Matthias Ettrich
*
*======================================================*/

#ifndef _LAYOUT_H
#define _LAYOUT_H

#include "lyxlex.h"

/* the different margin types */
enum LYX_MARGIN_TYPE {
MARGIN_MANUAL,
MARGIN_FIRST_DYNAMIC,
MARGIN_DYNAMIC,
MARGIN_STATIC,
MARGIN_RIGHT_ADDRESS_BOX
};

/* the different LaTeX-Types */
enum LYX_LATEX_TYPES {
LATEX_PARAGRAPH,
LATEX_COMMAND,
LATEX_ENVIRONMENT,
LATEX_ITEM_ENVIRONMENT,
LATEX_LIST_ENVIRONMENT
};

/* the different label types */
enum LYX_LABEL_TYPES {
LABEL_NO_LABEL,
LABEL_MANUAL,
LABEL_TOP_ENVIRONMENT,
LABEL_CENTERED_TOP_ENVIRONMENT,


/* the flushright labels following now must start with LABEL_STATIC */ 
LABEL_STATIC,		       
LABEL_SENSITIVE,
LABEL_COUNTER_CHAPTER,
LABEL_COUNTER_SECTION,
LABEL_COUNTER_SUBSECTION,
LABEL_COUNTER_SUBSUBSECTION,
LABEL_COUNTER_PARAGRAPH,
LABEL_COUNTER_SUBPARAGRAPH,
LABEL_COUNTER_ENUMI,
LABEL_COUNTER_ENUMII,
LABEL_COUNTER_ENUMIII,
LABEL_COUNTER_ENUMIV
};

#define LABEL_FIRST_COUNTER LABEL_COUNTER_CHAPTER

/* fix labels are printed flushright, manual labels flushleft. 
* MARGIN_MANUAL and MARGIN_FIRST_DYNAMIC are *only* for LABEL_MANUAL,
* MARGIN_DYNAMIC and MARGIN_STATIC are *not* for LABEL_MANUAL. 
* This seems a funny restriction, but I think other combinations are
* not needed, so I will not change it yet. 
* Correcton: MARGIN_FIRST_DYNAMIC also usable with LABEL_STATIC */


/* there is a parindent and a parskip. Which one is used depends on the 
* paragraph_separataion-flag of the text-object. 
* BUT: parindent is only thrown away, if a parskip is defined! So if you
* want a space betweend the paragraphs and a parindent at the same time, 
* you should set parskip to zero and use topsep, parsep and bottomsep.
* 
* The standard layout is an exception: its parindent is only set, if the 
* previous paragraph is standard too. Well, this is LateX and it is good! */ 


class LyXLayout {
public:
	LyXLayout ();
	~LyXLayout ();
	void Copy (LyXLayout &l);
	int Read (LyXLexClass);

	char type;
	char *name;
   
	LyXFont font;
	LyXFont labelfont;
	char *leftmargin;
	char *rightmargin;
   
	char *labelsep;
	char *labelindent;
	char *parindent;
	float parskip;
	float itemsep;
   
	float topsep;
	float bottomsep;
	float labelbottomsep;
	float parsep;

	char *labelstring;
	
	char align;
	char alignpossible;
	char labeltype;
	char margintype;
	
	float baselinestretch;
	
	char fill_top;
	char fill_bottom;
  
	char latextype;
	char *latexname;
  
	char newline_allowed;
   
	char nextnoindent;
	char free_spacing;
};


class LyXTextClass  {
public:
	LyXTextClass ();
	~LyXTextClass();
	void Copy (LyXTextClass &l);
	int Read (char *filename);
	char *name;
	char* latexname;
	LyXLayout* style;
	char number_of_defined_layouts;
	char *options;
	char columns;
	char sides;
	char pagestyle;
	char maxcounter;
  char defaultfamily;
  char defaultseries;
  char defaultshape;
  char defaultsize;
};

 
class LyXLayoutList {
public:
	LyXLayoutList();
	~LyXLayoutList();
	void Add (LyXLayout *l);
	LyXLayout * ToAr();
	int GetNum();
	void Clean(); 
private:
	struct LyXLayoutL {
		LyXLayout* layout;
		LyXLayoutL *next;
	};
	LyXLayoutL * l;
	LyXLayoutL *eol;
	int num_layouts;
};


class LyXTextClassList {
public:
	LyXTextClassList();
	~LyXTextClassList();
	void Add (LyXTextClass *l);
	void ToAr();
	int GetNum();
	LyXLayout *Style(char textclass, char layout);
	char NumberOfLayout(char textclass, const char* name);
	char* NameOfLayout(char textclass, char layout);
	char NumberOfClass(const char* textclass);
	char* NameOfClass(char number);
	char* LatexnameOfClass(char number);
	LyXTextClass * TextClass(char textclass);
	int Read (const char *path);
private:
	struct LyXTextClassL {
		LyXTextClass * textclass;
		LyXTextClassL * next;
	}; 
	LyXTextClassL * l;
	LyXTextClassL *eol;
	int num_textclass;
	LyXTextClass * ar;
	LyXTextClass * dummy_textclass;
};


extern LyXTextClassList lyxstyle;
 
#endif
