.\" Man page for LyX.
.\" Use the following command to generate viewable man page
.\"
.\"   tbl lyx.5 | {nt}roff -man
.\"
.\"   ul | more -fsk to view
.\"
.\"
.TH LYX 1 "September 1996" "Version 0.10 BETA" "LyX 0.10 BETA"
.SH NAME
LyX \- A graphical frontend for LaTeX 
.\"
.\" setup
.de Cr
.ie n (c)
.el \(co
..
.SH SYNOPSIS
.B lyx
[
.I command-line switches
] [
.I files.lyx ...
] 
.br
.SH DESCRIPTION
.B LyX
is too complex to be described in the "man" page format.
Ask your system administrator for the location of the full Documentation
either in native LyX or in PostScript format.
.B LyX 
is a frontend for 
.B LaTeX. 
It combines the comfortable usage of a word
processor with the high quality of LaTeX's typesetting. For that reason LyX
proposes an almost 
.B WYSIWYG-view 
on the document. "Almost" means that the
line- and page breaks are not displayed exactly as they will be in the
printed document. But that isn't really necessary, since LyX helps you to
write portable documents with the generic markup concept. With this concept,
the typesetter (here: LaTeX) has enough information to break your text in a
very nice manner. So line- and page breaks aren't your problem anymore. That
means you don't have to care about the rest of the document, when you
do changes at the beginning. Neither do you need to do low-level formatting
like "large bold italic modern font and a little space above and below", but
simply choose a so-called "layout" for each paragraph. Of course you can
also do some low-level formatting, but the usual way with LyX is to tell the
text what it is, not what it should look like. For that reason I call LyX a
.B High Level Word Processor.

.B LyX 
uses the XFORMS library as toolkit. It should run everywhere, where
XFORMS runs. This is on all major Unix platforms as well as PC platforms,
including Sun, SGI, HP, DEC Alpha/OSF, IBM RS6000, Convex, Cray, i386/Linux,
Alpha/Linux, i386/FreeBSD, i386/NetBSD, DecSystem(mips)/Ultrix and others.

.SH OPTIONS
In addition to the options supported by the
.B Forms Library
.B LyX 
supports the following command-line switches:
.TP 6
.BI \-width x
the width of the main window in LyX.
.TP
.BI \-height x
the height of the main window in LyX.
.TP
.BI \-dbg debug-level
where debug-level is a sum of debugging options:
.br
1 generic info when running LyX
.br
2 init
.br
4 keys
.br
8 toolbar
.br
16 lyxlex parser
.br
32 lyxrc
.br
65535 all of the above
.TP
.BI \-Reverse
swaps foreground and background colors.
.TP
.BI \-Mono
.TP
.BI \-MathColor
.TP
.BI \-MathFramColor
.TP
.BI \-FootColor
.TP
.BI \-FillColor
.TP
.BI \-OnOFFLineColor
.TP
.BI \-LatexColor
.TP
.BI \-InsetColor
.TP
.BI \-LightedColor
.TP 10
All programs written using the
.B Forms Library
recognize the following command line options
.TP 6
.BI \-display " host:dpy"
specifies the server to connect to.
.TP
.BI \-bw " borderwidth"
specifies the border width to use to built-in objects. 
.TP
.BI \-visual " visualName"
requests a visual by name such as TrueColor etc. By default the
.B Forms Library
always selects the visual that has the most depth.
.TP
.BI \-depth " depth"
requests a specific depth.
.TP
.BI \-debug " level"
generates some info about the state of the
.B XForms. 
where 
.I level
is an integer between 1-5 and controls the amount of
information to output. Depending on the options used
when the
.B Forms Library
was built, a level more than 3 might not be available.
.TP
.B \-sync
runs the application in synchronous mode with debug level set to 4. 
.TP
.B \-private
requests a private colormap for the application.
.TP
.B \-shared
requests a shared colormap even if the application needs more
colors than available. For those colors that can't be allocated
in the shared colormap, substitutions are made so the closest
matching color is used.
.TP
.B \-stdcmap
requests a standard colormap.
.TP
.B \-name " newname"
specifies the application name under which resources are to be
obtained, rather than the default executable file name. 
.B
.SH BUGS
There is probably still some bugs in LyX, please report them to:
lyx@via.ecp.fr

.SH SEE ALSO
latex(1) xforms(5)

Full documentation in either native LyX or PostScript format.

.SH AUTHOR
Copyright
.Cr
1995, 1996 by Matthias Ettrich (ettrich@informatik.uni-tuebingen.de)
and the rest of the LyX Team (See CREDITS)
