.TH REF 1
.SH NAME
ref - Display a C function header
.SH SYNOPSIS
.B ref
.RB [ -t ][ -x ][ -c
.IR class ]...
.RB [ -f
.IR file ]...
.I tag
.SH DESCRIPTION
.I ref
quickly locates and displays the header of a function.
To do this,
.I ref
looks in the "tags" file for the line that describes the function, and then 
scans the source file for the function.
When it locates the function, it displays an introductory comment
(if there is one), the function's declaration, and the declarations of all
arguments.
.SH "SEARCH METHOD"
.PP
.I ref
uses a fairly sophisticated tag look-up algorithm. 
If you supply a file name via
.BI -f file,
then elvis first scans
the tags file for a static tag from that file.
This search is limited to the tags file in the current directory.
.PP
If you supply a class name via
.BI -c class,
then elvis searches for a tag from that class.
This search is not limited to the current directory;
You can supply a list of directories in the environment variable
.I TAGPATH,
and
.I ref
will search through the "tags" file in each directory until it finds
a tag in the desired class.
.PP
If that fails,
.I ref
will then try to look up an ordinary global tag.
This search checks all of the directories listed in
.I TAGPATH,
too.
.PP
If you've given the
.B -t\fR
flag, then
.I ref
will simply output the tag line that it found, and then exit.
Without
.B -t,
though,
.I ref
will search for the tag line.
It will try to open the source file, which should be in the same directory
as the tags file where the tag was discovered.
If the source file doesn't exist, or is unreadable, then
.I ref
will try to open a file called "refs" in that directory.
Either way,
.I ref
will try to locate the tag, and display whatever it finds.
.SH "INTERACTION WITH ELVIS"
.PP
.I ref
is used by
.I elvis'
shift-K command.
If the cursor is located on a word such as "splat", in the file "foo.c",
then
.I elvis
will invoke
.I ref
with the command "ref -f foo.c splat".
.SH OPTIONS
.IP \fB-t\fR
Output tag info, instead of the function header.
.IP \fB-x\fR
Require the tag name to match exactly; don't try to make any clever guesses
about what colons in the tag name might mean.
.IP "\fB-f\fR \fIfile\fR"
The tag might be a static function in \fIfile\fR.
You can use several -f flags to have
.I ref
consider static tags from more than one file.
.IP "\fB-c\fR \fIclass\fR"
The tag might be a member of class \fIclass\fR.
You can use several -c flags to have \fIref\fR consider tags from more than one class.
.SH FILES
.IP \fBtags\fR
List of function names and their locations, generated by
.I ctags.
.IP \fBrefs\fR
Function headers extracted from source files (optional).
.SH ENVIRONMENT
.IP \fBTAGPATH\fR
List of directories to be searched.
The elements in the list are separated by either
semicolons (for MS-DOS, Atari TOS, and AmigaDos), or
by colons (every other operating system).
For each operating system,
.I ref
has a built-in default which is probably adequate.
.SH NOTES
.PP
You might want to generate a "tags" file the directory that contains the
source code for standard C library on your system.
If licensing restrictions prevent you from making the library source readable
by everybody, then you can have
.I ctags
generate a "refs" file, and make "refs" readable by everybody.
.PP
If your system doesn't come with the library source code, then perhaps you
can produce something workable from the
.BR lint (1)
libraries.
.SH "SEE ALSO"
elvis(1), ctags(1), lint(1)
.SH AUTHOR
.nf
Steve Kirkendall
kirkenda@cs.pdx.edu
.fi
