/*--------------------------------*-C-*---------------------------------*
 * file:	rxvtkeys.h
 *
 * Compile-time selection of key values.
 * Please leave the top (default) section intact and then undef/define
 * below as you like.
 * ----------------------------------------------------------------------
 * Copyright 1995 mj olesen <olesen@me.queensu.ca> Queen's Univ at Kingston
 *
 * You can do what you like with this source code provided you don't make
 * money from it and you include an unaltered copy of this message
 * (including the copyright).  As usual, the author accepts no
 * responsibility for anything, nor does he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#ifndef _RXVTKEYS_H
#define _RXVTKEYS_H

/* key-strings */
#define KS_FIND		"\033[1~"	/* Find */
#define KS_INSERT	"\033[2~"	/* Insert */
#define KS_EXECUTE	"\033[3~"	/* Execute */
#define KS_SELECT	"\033[4~"	/* Select */
#define KS_PRIOR	"\033[5~"	/* Page Up */
#define KS_NEXT		"\033[6~"	/* Page Down */
#define KS_HOME		"\033[7~"	/* Home */
#define KS_END		"\033[8~"	/* End */

#define KS_DELETE	""		/* Delete */

/* what trailing character to use for shift/ctrl-up/down/right/left */
/* key-characters */
#define KC_SHIFT_UP	'a'		/* Shift-Up	*/
#define KC_CTRL_UP	'\001'		/* Ctrl-Up	*/
#define KC_SHIFT_DOWN	'b'		/* Shift-Down	*/
#define KC_CTRL_DOWN	'\002'		/* Ctrl-Down	*/
#define KC_SHIFT_RIGHT	'c'		/* Shift-Right	*/
#define KC_CTRL_RIGHT	'\003'		/* Ctrl-Right	*/
#define KC_SHIFT_LEFT	'd'		/* Shift-Left	*/
#define KC_CTRL_LEFT	'\004'		/* Ctrl-Left	*/

/*----------------------------------------------------------------------*
 * user modifiable section
 */

/* choose one of these three as the Hotkey
 * If you choose `shift', you'l want better bindings for
 * mapAlert and Secure
 */
#define HOTKEY meta
/*#define HOTKEY ctrl*/
/*#define HOTKEY shift*/

/* to have the backspace key transmit ^? instead of default ^H */
/*#define BACKSPACE_AS_DELETE*/

/* undef and define new key-string values, as desired */

#endif	/* whole file */
/*----------------------- end-of-file (C header) -----------------------*/
