/*
 * lftp and utils
 *
 * Copyright (c) 1998 by Alexander V. Lukyanov (lav@yars.free.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>
#include "ListInfo.h"
#include "FileSet.h"

ListInfo::ListInfo()
{
   result=0;
   done=false;
   error_text=0;

   rxc_exclude=0;
   rxc_include=0;
   path=0;
}

ListInfo::~ListInfo()
{
   if(result)
      delete result;
   xfree(error_text);
}

void ListInfo::SetExclude(const char *p,regex_t *x,regex_t *i)
{
   rxc_exclude=x;
   rxc_include=i;
   path=p;
}

void ListInfo::SetError(const char *e)
{
   xfree(error_text);
   error_text=xstrdup(e);
   done=true;
}
