/*
 * Copyright (c) 1990,1993 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#ifndef AUTH_H
#define AUTH_H

#include <limits.h>

#ifdef USE_PAM
#include <security/pam_appl.h>
extern pam_handle_t *pamh;
#endif

struct afp_versions {
    char	*av_name;
    int		av_number;
};

struct afp_uams {
    char	*au_name;
    int         au_number;
    int		(*au_login)();
    int		(*au_logincont)();
    int		au_flags;
};

#define AU_NONE	       (0)
#define AU_AFSKRB      (1 << 0)
#define AU_KRBIV       (1 << 1)
#define AU_CLRTXT      (1 << 2)
#define AU_GUEST       (1 << 3)
#define AU_RANDNUM     (1 << 4)
#define AU_2WAYRANDNUM (1 << 5)
#define AU_ALL     (AU_AFSKRB | AU_KRBIV | AU_CLRTXT | AU_GUEST)

extern int	noauth_login();
#ifdef KRB
extern int	krb4_login();
extern int	krb4_logincont();
#endif KRB
extern int	clrtxt_login();
extern int      randnum_login();
extern int      randnum_logincont();
extern int      rand2num_logincont();
#ifdef UAM_AFSKRB
extern int	afskrb_login();
extern int	afskrb_logincont();
#endif UAM_AFSKRB

extern uid_t	uuid;
#if defined( __svr4__ ) && !defined( NGROUPS )
#define NGROUPS	NGROUPS_MAX
#endif __svr4__ NGROUPS
#if defined( sun ) && !defined( __svr4__ ) || defined( ultrix )
extern int	groups[ NGROUPS ];
#else sun __svr4__ ultrix
extern gid_t	groups[ NGROUPS ];
#endif sun __svr4__ ultrix
extern int	ngroups;

#endif /* auth.h */
