/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifndef STATUS_STRUCTURE_H
#define STATUS_STRUCTURE_H
struct status_type {
   unsigned _STANDARD_INPUT_: 1; /* standard input */
   unsigned _SET_STDIN_BUF_: 1; /* standard input buffer */
   unsigned _RECURS_: 1;
   unsigned OVERWRITE: 2;
   unsigned lol: 1;
#ifdef USE_POSIX_THREAD
   unsigned free: 1;
   unsigned RECEIVING: 1;
#endif
   short _SKIP_;    /* skip all existing files */
   short _OPTIONS_; /* number of options */
   size_t _STDIN_BUFSIZ_; /* size of stdin buffer */
   char *_STDIN_BUFFER_; /* buffers stdin data */
   char *REMOTEHOSTNAME; /* name of current remote client host */
   char *_HOSTNAME_;
   short usefilter; /* flag for option '-f' */
   int ns; /* client/server port */
   int size;
   FILE *fp;
   int pid;
#ifdef USE_POSIX_THREAD
   double start;
   int output;
#endif
};

#define MEM_CHECK(ALLOC_MEM) \
        if (!ALLOC_MEM) { \
           fprintf(stderr, "** calloc: Cannot allocate enough memory.\n"); \
           exit(1); \
        }
#endif /* STATUS_STRUCTURE_H */
