/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef HP_UX
#include <sys/termio.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#include <sys/ioctl_compat.h>
#endif
#include <sys/ioctl.h>
#include <signal.h>
#include "main.h"

#ifndef TCGETA
   #define TCGETA TIOCGETP
   #define TCSETA TIOCSETP
#else
   #define SYSV
#endif

#ifdef SYSV
#include <termios.h>
#endif

#define DEFAULTROWS 24 /* defaul number of rows, if window size is unknown */
#define DEFAULTCOLS 80 /* defaul number of columns, if window size is unknown */

void free_memory(void);

void set_tty(int i)
{
#ifndef SYSV
   static struct sgttyb tori;
   struct sgttyb tnew;
#else
   static struct termio tori;
   struct termio tnew;
#endif
   volatile struct winsize ws;

   if (i) {
      /*
       * Get window size.
       */
      if (i==3) {
         ioctl(2, TIOCGWINSZ, &ws);
         _WINROWS_= ws.ws_row ? ws.ws_row : DEFAULTROWS;
         _WINCOLS_= ws.ws_col ? ws.ws_col : DEFAULTCOLS;

         /*
          * Get current tty settings.
          */
         if (ioctl(2, TCGETA, &tori) < 0) {
            fprintf(stderr, "** ioctl: %s\n", _PFTP_ERROR_ARRAY_);
            exit(1);
         }
         return;
      }

      /*
       * Change terminal modes.
       */
      tnew = tori;
#ifndef SYSV
      tnew.sg_flags |= CBREAK;
      if (i==2) tnew.sg_flags &= ~ECHO;
#else
      if (i==2) tnew.c_lflag &= ~ECHO;
      tnew.c_lflag &= ~ICANON;
      tnew.c_lflag &= ~ISIG;
      tnew.c_cc[VMIN] = 1;
      tnew.c_cc[VTIME] = 0;
#endif

      /*
       * Set new tty modes.
       */
      if (ioctl(2, TCSETA, &tnew) < 0) {
         fprintf(stderr, "** ioctl: %s\n", _PFTP_ERROR_ARRAY_);
         exit(1);
      }
   }
   else {
      /*
       * Set new tty modes.
       */
      if (ioctl(2, TCSETA, &tori) < 0) {
         fprintf(stderr, "** ioctl: %s\n", _PFTP_ERROR_ARRAY_);
         exit(1);
      }
   }
}

/*
 * handler--handler signals.
 */
void handler(int sig)
{
   FILE *fe=stderr;

   signal(SIGPIPE, SIG_IGN);
   signal(SIGINT, SIG_IGN);

   if (sig == SIGPIPE) {
      fprintf(stderr, "\n** Connection closed by foreign host.\n");
      if (pftplog) {
         if ((fe = fopen(pftplog, "a")) != NULL) {
            fprintf(fe, "\n** Connection closed by foreign host.\n");
            fclose(fe);
         }
      }
      exit(1);
   }
#ifdef USE_POSIX_THREAD
   else if (sig == SIGINT && CHILDNUM > 0) {
      fprintf(stderr, "\n** Connection was aborded.");
      fprintf(stderr, " There %s %d pending connection%s\n", \
      CHILDNUM==1? "was": "were", CHILDNUM, CHILDNUM==1? ".":"s.");
      if (pftplog) {
         if ((fe = fopen(pftplog, "a")) != NULL) {
            fprintf(fe, "\n** Connection was aborded.");
            fprintf(fe, " There %s %d pending connection%s\n", \
            CHILDNUM==1? "was": "were", CHILDNUM, CHILDNUM==1? ".":"s.");
            fclose(fe);
         }
      }
      free_memory();
      exit(1);
   }
   else if (sig == SIGINT && CHILDNUM < 0) {
      fprintf(stderr, "\n** Connection was aborded.\n");
      if (pftplog) {
         if ((fe = fopen(pftplog, "a")) != NULL) {
            fprintf(fe, "\n** Connection was aborded.");
            fclose(fe);
         }
      }
      exit(1);
   }
   else if (sig == SIGINT) {
#ifndef SYSV
      fprintf(stderr, "\b\b  \n*** Socket closed. No further connection request detected.\n");
#else
      fprintf(stderr, "\n*** Socket closed. No further connection request detected.\n");
#endif
      free_memory();
      exit(0);
   }
#else
   else if (sig == SIGINT) {
#ifndef SYSV
      fprintf(stderr, "\b\b  \n*** Socket closed.\n");
#else
      fprintf(stderr, "\n*** Socket closed.\n");
#endif
      free_memory();
      exit(0);
   }
#endif
}

void free_memory(void)
{
   if (*_CLIENTHOSTNAME_) {
      int cl;

      for (cl=0; _CLIENTHOSTNAME_[cl]; cl++) free(_CLIENTHOSTNAME_[cl]);
      *_CLIENTHOSTNAME_ = NULL;
   }
   if (*filter) {
      int j;
      for (j=0; *(filter+j); j++) free(*(filter+j));
      *filter = NULL;
   }
   if ((*statstr)->_STDIN_BUFFER_) free((*statstr)->_STDIN_BUFFER_);
   if (_STDOUT_BUFFER_) free(_STDOUT_BUFFER_);
}
