package biss.calendar;

import biss.DateLib;
import biss.awt.Button;
import biss.awt.Layouter;
import biss.awt.List;
import biss.awt.TopWindow;
import java.util.Date;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

class AlarmProcessor
  extends TopWindow
  implements Observer
{
	List DatePane = new List();
	Button ProcBtn = new Button( StringDict.at("tEdit"));
	Button ExitBtn = new Button( StringDict.at("tExit"));
	static AlarmProcessor AInst = null;
	DateWatchdog Master;

AlarmProcessor ( DateWatchdog doggy) {
	super( "Watchdog " + StringDict.at("alarmDates"));

	Master = doggy;

	Layouter lo = new Layouter( this);
	lo.add( DatePane, 0, 0, 600, 1000, true, 50, 50, 0, -50, 0);
	lo.add( ProcBtn,  650, 0, 950, 0, true,  50, 50, 0, 250, 0);
	lo.add( ExitBtn,  650, 0, 950, 0, true,  50, 300,0, 500, 0);

	DatePane.OsDrawObject.addObserver( this);
	DatePane.OsProcess.addObserver( this);
	ProcBtn.OsAction.addObserver( this);
	ExitBtn.OsAction.addObserver( this);
	OsClose.addObserver( this);

	Master.WatchList.OsListChanged.addObserver( this);

	openIn( 100, 100, 300, 120);

	DatePane.setContents( Master.ADates);

	AInst = this;
}

boolean openBrowser () {
	DateEntry de = (DateEntry)DatePane.getSelection();
	if ( de == null)
		return false;
	new DateBrowser( Master.WatchList, de.SDate);
	return true;
}

public static void showAlarmDates( DateWatchdog doggy ) {
	if ( AInst == null)
		AInst = new AlarmProcessor( doggy);
	else
		AInst.DatePane.updateContents();
}

public void update ( Observable obs, Object arg) {
	if ( obs == DatePane.OsDrawObject)
		DrawSupport.drawDateEntry( DatePane);
	else if ( obs == DatePane.OsProcess)
		openBrowser();
	else if ( obs == ProcBtn.OsAction)
		openBrowser();
	else if ( obs == ExitBtn.OsAction)
		dispose();
	else if ( obs == Master.WatchList.OsListChanged){
		Master.collectAlarmDates();
		DatePane.updateContents();
	}
	else if ( obs == OsClose){
		Master.WatchList.OsListChanged.deleteObserver( this);
		AInst = null;
	}
	else
		super.update( obs, arg);
}
}

/**
 * Zyklische berwachung einer Terminliste. Das Intervall ( in Minuten) wird ber
 * die Initialisierungvaraible calendar.WatchDelay im property file
 * ~\.java\calendar eingestellt ( default 5 Minuten).
 * Werden ein oder mehrere Termine festgestellt deren Alarmzeit erreicht ist,
 * wird ein AlarmProcessor Dialog mit den entsprechenden Terminen zur
 * Bearbeitung geffnet.
 */
public class DateWatchdog
  extends Thread
{
	DateList WatchList = null;
	Vector ADates = new Vector();

DateWatchdog (String pathName) {
	if ( pathName == null)
		WatchList = DateList.getDefaultList();
	else
		WatchList = DateList.getDateList( pathName);
	setDaemon( true);
	start();
}

void collectAlarmDates () {

	Date curDate = new Date();
	ADates.removeAllElements();

	for ( Enumeration e = WatchList.Dates.elements(); e.hasMoreElements(); ) {
		DateEntry de = (DateEntry)e.nextElement();
		if ( de.ADate != null) {
			if ( ! curDate.before( de.ADate)){
				ADates.addElement( de); 
			}
		}
	}
}

public static void main( String[] args ) {
	DateWatchdog dw;
	if ( args.length > 0)
		dw = new DateWatchdog( args[0]);
	else
		dw = new DateWatchdog( null);
	new WatchControlView( dw);
}

public void run () {

	while ( true) {
		try {
			collectAlarmDates();
			if ( ADates.size() > 0)
				AlarmProcessor.showAlarmDates( this);
			Thread.sleep( Calendar.WatchDelay * 60000);
		}
		catch ( Exception e) {
			e.printStackTrace();
			return;
		}
	}

}
}

class WatchControlView
  extends TopWindow
  implements Observer
{
	Button BtnEdit = new Button( StringDict.at("tEdit"));
	Button BtnExit = new Button( StringDict.at("tExit"));
	DateWatchdog Master;

public WatchControlView ( DateWatchdog master) {
	super( "DateController");

	Master = master;
	Layouter lo = new Layouter( this);

	lo.add( BtnEdit, 0,   0, 500,  1000, false, 0, 0, 0, 0, 0);
	lo.add( BtnExit, 500, 0, 1000, 1000, false, 0, 0, 0, 0, 0);

	BtnEdit.OsAction.addObserver( this);
	BtnExit.OsAction.addObserver( this);

	openIn( 0, 0, 170, 55);
}

public void update ( Observable obs, Object arg ) {
	if ( obs == BtnExit.OsAction)
		System.exit( 0);
	else if ( obs == BtnEdit.OsAction)
		new DateBrowser( Master.WatchList.PathName);
	else super.update( obs, arg);
}
}
