/*
 * defines for the dmalloc-leap routines.
 *
 * Copyright 1995 by Gray Watson
 *
 * This file is part of the dmalloc package.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * NON-COMMERCIAL purpose and without fee is hereby granted, provided
 * that the above copyright notice and this permission notice appear
 * in all copies, and that the name of Gray Watson not be used in
 * advertising or publicity pertaining to distribution of the document
 * or software without specific, written prior permission.
 *
 * Please see the PERMISSIONS file or contact the author for information
 * about commercial licenses.
 *
 * Gray Watson makes no representations about the suitability of the
 * software described herein for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * The author may be contacted at gray.watson@letters.com
 *
 * $Id: dmalloc_lp.h,v 1.26 1997/12/22 00:24:39 gray Exp $
 */

#ifndef __DMALLOC_LP_H__
#define __DMALLOC_LP_H__

#define DEBUG_PRE_NONE		(-1)	/* no pre debug call */

/*<<<<<<<<<<  The below prototypes are auto-generated by fillproto */

/* to inform the dmalloc library from which file the call comes from */
extern
char		*_dmalloc_file;

/* to inform the library from which line-number the call comes from */
extern
unsigned int	_dmalloc_line;

/* pre-set dmalloc_debug() value before the library is setup */
extern
int		_dmalloc_debug_preset;

/* pointers to shutdown function to allow calls without linked routine */
extern
void		(*_dmalloc_shutdown_func)();

/* pointers to log_heap_map function to allow calls without linked routine */
extern
void		(*_dmalloc_log_heap_map_func)();

/* pointers to log_stats function to allow calls without linked routine */
extern
void		(*_dmalloc_log_stats_func)();

/* pointers to log_unfreed function to allow calls without linked routine */
extern
void		(*_dmalloc_log_unfreed_func)();

/* pointers to verify function to allow calls without linked routine */
extern
int		(*_dmalloc_verify_func)();

/* pointers to verify function to allow calls without linked routine */
extern
int		(*_malloc_verify_func)();

/* pointers to debug function to allow calls without linked routine */
extern
void		(*_dmalloc_debug_func)();

/* pointers to debug_current function to allow calls without linked routine */
extern
int		(*_dmalloc_debug_current_func)();

/* pointers to examine function to allow calls without linked routine */
extern
int		(*_dmalloc_examine_func)();

/* pointers to strerror function to allow calls without linked routine */
extern
const char	*(*_dmalloc_strerror_func)(const int error_num);

/*
 * leap routine to malloc
 */
extern
DMALLOC_PNT	_malloc_leap(const char *file, const int line,
			     DMALLOC_SIZE size);

/*
 * leap routine to calloc
 */
extern
DMALLOC_PNT	_calloc_leap(const char *file, const int line,
			     DMALLOC_SIZE ele_n, DMALLOC_SIZE size);

/*
 * leap routine to realloc
 */
extern
DMALLOC_PNT	_realloc_leap(const char *file, const int line,
			      DMALLOC_PNT old_p, DMALLOC_SIZE new_size);

/*
 * leap routine to free
 */
extern
DMALLOC_FREE_RET	_free_leap(const char *file, const int line,
				   DMALLOC_PNT pnt);

/*
 * leap routine to calloc with error checking
 */
extern
DMALLOC_PNT	_xcalloc_leap(const char *file, const int line,
			      DMALLOC_SIZE ele_n, DMALLOC_SIZE size);

/*
 * leap routine to free
 */
extern
DMALLOC_FREE_RET	_xfree_leap(const char *file, const int line,
				    DMALLOC_PNT pnt);

/*
 * leap routine to malloc with error checking
 */
extern
DMALLOC_PNT	_xmalloc_leap(const char *file, const int line,
			      DMALLOC_SIZE size);

/*
 * leap routine to realloc with error checking
 */
extern
DMALLOC_PNT	_xrealloc_leap(const char *file, const int line,
			       DMALLOC_PNT old_p, DMALLOC_SIZE new_size);

/*
 * leap routine for strdup with error checking
 */
extern
char 	*_xstrdup_leap(const char *file, const int line,
		       const char *str);

/*
 * routine to call dmalloc_shutdown when linked in
 */
extern
void	dmalloc_shutdown(void);

/*
 * routine to call dmalloc_log_unfreed when linked in
 */
extern
void	dmalloc_log_unfreed(void);

/*
 * routine to call dmalloc_log_stats when linked in
 */
extern
void	dmalloc_log_stats(void);

/*
 * routine to call dmalloc_log_heap_map when linked in
 */
extern
void	dmalloc_log_heap_map(void);

/*
 * routine to call dmalloc_verify when linked in
 */
extern
int	dmalloc_verify(const DMALLOC_PNT pnt);

/*
 * routine to call malloc_verify when linked in
 */
extern
int	malloc_verify(const DMALLOC_PNT pnt);

/*
 * routine to call dmalloc_debug when linked in
 */
extern
void	dmalloc_debug(const int flags);

/*
 * routine to call dmalloc_debug_current when linked in
 */
extern
int	dmalloc_debug_current(void);

/*
 * routine to call dmalloc_examine when linked in
 */
extern
int	dmalloc_examine(const DMALLOC_PNT pnt, DMALLOC_SIZE *size_p,
			char **file_p, unsigned int *line_p,
			DMALLOC_PNT *ret_attr_p);

/*
 * routine to call dmalloc_strerror when linked in
 */
extern
const char	*dmalloc_strerror(const int error_num);

/*<<<<<<<<<<   This is end of the auto-generated output from fillproto. */

#endif /* ! __DMALLOC_LP_H__ */
