/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
# if !defined(BOOL_H)

# define BOOL_H

# ifndef FALSE
# define FALSE 0
# endif

# ifndef TRUE
# define TRUE (! FALSE)
# endif

extern /*@observer@*/ cstring bool_unparse (bool p_b) /*@*/ ;
extern /*@observer@*/ cstring bool_dump (bool p_b) /*@*/ ;
extern /*@unused@*/ bool bool_not (bool p_b) /*@*/ ;
extern bool bool_equal (bool p_b1, bool p_b2) /*@*/ ;
extern int bool_compare (bool p_b1, bool p_b2) /*@*/ ;
extern bool bool_fromInt (int p_i) /*@*/ ;
extern int bool_toInt (bool p_b) /*@*/ ;

/*@access bool@*/

# define bool_unparse(b)   (cstring_makeLiteralTemp ((b) ? "true" : "false" ))
# define bool_dump(b)      (cstring_makeLiteralTemp ((b) ? "1" : "0" ))
# define bool_not(b)       ((b) ? FALSE : TRUE)
# define bool_equal(a,b)   ((a) ? (b) : !(b))
# define bool_compare(a,b) ((a) ? ((b) ? 0 : 1) : ((b) ? -1 : 0))
# define bool_fromInt(i)   (((i) != 0) ? TRUE : FALSE)
# define bool_toInt(b)     ((b) ? 1 : 0)

# else
# error "Multiple include"
# endif




