/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** ekind.c
*/

# include "lclintMacros.nf"
# include "basic.h"

ekind
ekind_fromInt (int i)
{
  if /*@+enumint@*/ (i < KINVALID || i > KELAST) /*@=enumint@*/
    {
      llcontbug (message ("ekind_fromInt: invalid: %d", i));
      return KINVALID; 
    }

  return (ekind)i;
}

cstring ekind_unparse (ekind k)
{
  switch (k)
    {
    case KENUMCONST:   return cstring_makeLiteralTemp ("ect");
    case KCONST:       return cstring_makeLiteralTemp ("cst");
    case KVAR:         return cstring_makeLiteralTemp ("var");
    case KITER:        return cstring_makeLiteralTemp ("itr");
    case KENDITER:     return cstring_makeLiteralTemp ("etr");
    case KDATATYPE:    return cstring_makeLiteralTemp ("dtp");
    case KFCN:         return cstring_makeLiteralTemp ("fcn");
    case KSTRUCTTAG:   return cstring_makeLiteralTemp ("stg");
    case KUNIONTAG:    return cstring_makeLiteralTemp ("utg");
    case KENUMTAG:     return cstring_makeLiteralTemp ("etg");
    case KELIPSMARKER: return cstring_makeLiteralTemp ("eps");
    case KINVALID:     return cstring_makeLiteralTemp ("[invalid]");
    }

  BADEXIT;
}

cstring ekind_unparseLong (ekind k)
{
  switch (k)
    {
    case KCONST:       return cstring_makeLiteralTemp ("constant");
    case KENUMCONST:   return cstring_makeLiteralTemp ("enum member");
    case KVAR:         return cstring_makeLiteralTemp ("variable");
    case KITER:        return cstring_makeLiteralTemp ("iterator");
    case KENDITER:     return cstring_makeLiteralTemp ("iterator finalizer");
    case KDATATYPE:    return cstring_makeLiteralTemp ("datatype");
    case KFCN:         return cstring_makeLiteralTemp ("function");
    case KSTRUCTTAG:   return cstring_makeLiteralTemp ("struct tag");
    case KUNIONTAG:    return cstring_makeLiteralTemp ("union tag");
    case KENUMTAG:     return cstring_makeLiteralTemp ("enum tag");
    case KELIPSMARKER: return cstring_makeLiteralTemp ("...");
    case KINVALID:     return cstring_makeLiteralTemp ("[invalid]");
    }

  BADEXIT;
}

cstring
ekind_capName (ekind k)
{
  switch (k)
    {
    case KCONST:       return cstring_makeLiteralTemp ("Constant");
    case KENUMCONST:   return cstring_makeLiteralTemp ("Enum member");
    case KVAR:         return cstring_makeLiteralTemp ("Variable");
    case KITER:        return cstring_makeLiteralTemp ("Iterator");
    case KENDITER:     return cstring_makeLiteralTemp ("Iterator finalizer");
    case KDATATYPE:    return cstring_makeLiteralTemp ("Datatype");
    case KFCN:         return cstring_makeLiteralTemp ("Function");
    case KSTRUCTTAG:   return cstring_makeLiteralTemp ("Struct tag");
    case KUNIONTAG:    return cstring_makeLiteralTemp ("Union tag");
    case KENUMTAG:     return cstring_makeLiteralTemp ("Enum tag");
    case KELIPSMARKER: return cstring_makeLiteralTemp ("...");
    case KINVALID:     return cstring_makeLiteralTemp ("[invalid]");
    }

  BADEXIT;
}

