#include <tcl.h>
#include <tk.h>
#include <caml/mlvalues.h>
#include "camltk.h"

/*
 * File descriptor callbacks
 */

void FileProc(clientdata, mask)
     ClientData clientdata;
     int mask;
{
  callback2(handler_code,Val_int(clientdata),Val_int(0));
}

value camltk_add_file_input(fd, cbid)    /* ML */
     value fd;
     value cbid;
{
  Tcl_CreateFileHandler(Tcl_GetFile(Int_val(fd), TCL_UNIX_FD), TCL_READABLE, 
		       FileProc, (ClientData)(Int_val(cbid)));
  return Val_unit;
}

/* We have to free the Tcl handle when we are finished using it (Tcl
 * asks us to, and moreover it is probably dangerous to keep the same
 * handle over two allocations of the same fd by the kernel). 
 * But we don't know when we are finished with the fd, so we free it
 * in rem_file (it doesn't close the fd anyway). For fds for which we
 * repeatedly add/rem, this will cause some overhead.
 */
value camltk_rem_file_input(fd) /* ML */
     value fd;
{
  Tcl_File fh = Tcl_GetFile(Int_val(fd), TCL_UNIX_FD);
  Tcl_DeleteFileHandler(fh);
  Tcl_FreeFile(fh);
  return Val_unit;
}

value camltk_add_file_output(fd, cbid)    /* ML */
     value fd;
     value cbid;
{
  Tcl_CreateFileHandler(Tcl_GetFile(Int_val(fd), TCL_UNIX_FD), TCL_WRITABLE, 
		       FileProc, (ClientData) (Int_val(cbid)));
  return Val_unit;
}

value camltk_rem_file_output(fd) /* ML */
     value fd;
{
  Tcl_File fh = Tcl_GetFile(Int_val(fd), TCL_UNIX_FD);
  Tcl_DeleteFileHandler(fh);
  Tcl_FreeFile(fh);
  return Val_unit;
}

