//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef CARTRIDGEE0_HXX
#define CARTRIDGEE0_HXX

class CartridgeE0;

#include "machine.hxx"
#include "Cart.hxx"

/**
  The 8K cartridge class for Parker Brothers' cartridges.  There
  are 4 1K slices under indepenant control.  There are 8 1K blocks that
  you can use.

  @author  Bradford W. Mott
  @version $Id: CartE0.hxx,v 1.2 1997/05/17 19:00:03 bwmott Exp $
*/
class CartridgeE0 : public Cartridge
{
  public:
    /// Constructor
    CartridgeE0(System& system, uByte* image);
 
    /// Destructor
    virtual ~CartridgeE0();

    /// Reset to power on state
    void reset();

    /// Answer the byte at the given address
    virtual uByte peek(uWord addr);

    /// Store value in the given address
    virtual void poke(uWord addr, uByte value);

  private:
    // Addressing offsets for each of the 4 1K slices in the ROM image
    uWord myImageOffset[4];

    // 8k ROM Image of the cartridge
    uByte myImage[8192];
};
#endif

