/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995, 1996, 1997
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Ian Collier, Des Herriott
 *          Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef _XZX_RESOURCE_H
#define _XZX_RESOURCE_H
/* $Id: resource.h,v 3.15 1997/09/13 17:19:35 erik Rel $ */
#include <X11/Xlib.h>
#ifdef XZX_IF1
#include "if1.h"
#endif

typedef struct _config {

	char *libDir;
	int quiet;

	char *geometry;
#ifndef EXCLUDE_PIXMAP
	int pixmaps;
#endif
	int mono;
	int private;
#ifdef MITSHM
	int mitshm;
#endif

#ifdef DEBUG
	unsigned int debug;
#endif
	int machine;
	int cycles;
	int ms;
	int fast;
#ifdef SLOWDOWN
	int slowdown;
	KeySym slowdownKeys[2];
#endif

	int scale;
	int flashing;
	int border;
#ifdef MITSHM
	int rrShm;
#endif
	int rrNoShm;

	int pause;

#ifdef JOY
	int useJoy;
	char *joyDevice;
	int joyTolerance;
#endif
	KeySym joyKeys[5];

#if defined(AUDIO)
	int useSound;
#if defined(SUN_AUDIO) || defined(AYCHIP_AUDIO)
	char *audioDev;
#endif
#if defined(SUN_AUDIO) || defined(XBELL_AUDIO)
	int volume;
#endif
#endif

	char *rom48;
	int issue;
	char *kbdlayout;

	char *rom128_0;
	char *rom128_1;

#ifdef XZX_PLUS3
	char *rompl3_0;
	char *rompl3_1;
	char *rompl3_2;
	char *rompl3_3;
	char *disks[2];
#endif

#ifdef XZX_IF1
	int if1_active;
	char *if1_rom;
	int translate_nl;
	int strip_nl;
	char *cartfiles[MAX_DRIVES];

#endif

#ifdef XZX_MF128
	int	mf128_active;
	char *mf128_rom;
#endif
} Config;
#define GETCFG(x)			Conf.x
#define SETCFG(x,y)			Conf.x = y

#ifdef SLOWDOWN
#define slowdownKey			slowdownKeys[0]
#define speedupKey			slowdownKeys[1]
#endif
#define joyUp				joyKeys[0]
#define joyDown				joyKeys[1]
#define joyLeft				joyKeys[2]
#define joyRight			joyKeys[3]
#define joyFire				joyKeys[4]

extern Display *GetResources(int *, char **);
extern Config Conf;
#endif

