static char usleep_c_rcsid[] = "$Id: usleep.c,v 1.1 1998/09/18 13:29:37 kerce Exp $";

/**********************************************************
 * usleep.c - provides for delays in qmon
 *
 * Written By: Jeff Snyder
 * Date: 8/7/91
 *
 * Copyright 1991
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 * $Log: usleep.c,v $
 * Revision 1.1  1998/09/18 13:29:37  kerce
 * Put qidle back into the XSRC hierarchy.
 *
 * Revision 1.1.1.1  1994/06/18  19:44:37  kerce
 * DQS X Distribution
 *
 * Revision 1.1  1993/02/10  20:33:37  dan
 * Initial revision
 *
 **********************************************************/

#include <sys/time.h>

int usleep(usec)
unsigned long usec;
{
    struct timeval timeout;
    timeout.tv_usec = usec % (unsigned long) 1000000;
    timeout.tv_sec = usec / (unsigned long) 1000000;
    select(0, (void *) 0, (void *) 0, (void *) 0, &timeout);
}
