static char qrerun_rcsid[]="qrerun.c,v 1.2 1994/11/28 16:55:53 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  qrerun.c,v
 * Revision 1.2  1994/11/28  16:55:53  kerce
 * *** empty log message ***
 *
 * Revision 1.3  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.2  1994/08/21  02:59:18  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 *
 **********************************************************/
#include "globals.h"

static Widget           qrerun_popup;
static Widget           widget_qrerunrc;
static Widget           widget_qrerunlabel;
static Widget           widget_qrerunframe;
static Widget           widget_qrerunmenu;
static Widget           widget_qrerunmain;
static Widget           widget_qrerunexec;
static Widget           widget_qrerunclear;
static Widget           widget_qrerunclose;
static Widget           widget_qrerunseparator;
static Widget           widget_qrerunopt;

struct optionstruct qrerunmenu[]={
  0,"Help       ","-help",FLAGTYPE,"False",NULL,
  0,"Verify     ","-verify",FLAGTYPE,"False",NULL,
  0,"Job ID List",NULL,INPUTTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};


/***********************************************************
 * pb_qrerunexec - Activate callback for exec
 */
XtCallbackProc pb_qrerunexec(Widget w, caddr_t client_data, caddr_t call_data)
{
  buildcommand(QRERUN_BINARY,qrerunmenu,0);
  sleep(1);
  UnMapIconWin ();
  refreshicons();
  MapIconWin ();
}


/***********************************************************
 * pb_qrerunclear - Activate callback for clear
 */
XtCallbackProc pb_qrerunclear(Widget w, caddr_t client_data, caddr_t call_data)
{
  clearsubmenu(qrerunmenu);
}


/***********************************************************
 * pb_qrerunclose - Activate callback for close
 */

XtCallbackProc pb_qrerunclose(Widget w, caddr_t client_data, caddr_t call_data)
{
  closemainmenuwin();
}


/***********************************************************
 * create_qrerun_dialog - Create widgets used for the qrerun menu
 */
int create_qrerun_dialog(Widget w,XtPointer client_data, XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        qrerun_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  qrerun_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  qrerun_form = XtCreateManagedWidget("form", formWidgetClass, qrerun_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_qrerunlabel=
	XtCreateManagedWidget("Qrerun",labelWidgetClass,qrerun_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_qrerunlabel); ii++;
  widget_qrerunmain=XtCreateManagedWidget("box",formWidgetClass,qrerun_form,
                                        args,ii);
  exec=QmonAddButtonN(widget_qrerunmain,NULL,"Exec",(XtCallbackProc)pb_qrerunexec,NULL);
  clear=QmonAddButtonN(widget_qrerunmain,exec,"Clear",(XtCallbackProc)pb_qrerunclear,NULL);
  close=QmonAddButtonN(widget_qrerunmain,clear,"Close",(XtCallbackProc)pb_qrerunclose,NULL);

  widget_qrerunopt=createmenuoptions(qrerun_form,widget_qrerunmain,qrerunmenu,(XtCallbackProc)NULL);
  
}


/***********************************************************
 * openwidget_qrerun - Open the qrerun menu
 */
int openwidget_qrerun()
{
  XtPopup(qrerun_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_qrerun - Close the qrerun menu
 */
int closewidget_qrerun()
{
  XtPopdown(qrerun_popup);
}
