package biss;


/**
 * class to be used for implementing XOR sets for arbitrary object
 * collections. Elements have to be instances implementing the
 * XorSetElement interface. 
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class XorSet
{
	Object Selection;

public Object getSelection () {
	return Selection;
}

public void remember ( Object element ) {
	Selection = element;
}

public void setSelection ( Object newSelection ) {
	if ( Selection != null && Selection instanceof XorSetElement )
		((XorSetElement)Selection).xorUnselect();

	Selection = newSelection;
	if ( Selection != null && Selection instanceof XorSetElement )
		((XorSetElement)Selection).xorSelect();	
}

public void setSelfSelected ( Object myself ) {
	if ( Selection != null && Selection != myself && Selection instanceof XorSetElement )
		((XorSetElement)Selection).xorUnselect();

	Selection = myself;
}
}
