package biss.awt;

import biss.DateLib;
import java.util.Date;

/**
 * Label to display current time ( per second update)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class ClockView
  extends Label
  implements Runnable
{
	Thread Actor = null;
	Date CurDate = new Date();
	StringBuffer TBuf = new StringBuffer( "11:11:11");
	String Dim;

public ClockView () {
	this( null);
}

public ClockView (String dim) {

	if( dim != null)
		TBuf.append( " " + dim);

	FBorder.setBorder( Border.BS_INSET);
	Actor = new Thread( this);
	Actor.setDaemon( true);
	Actor.setPriority( Thread.MIN_PRIORITY);
	Actor.start();
}

public void run () {
	while ( true) {
		CurDate.setTime( System.currentTimeMillis() );
		setContents( DateLib.toHMSString( CurDate, TBuf));
		sync();	//NT thread draw workaround
		try { Thread.sleep( 1000); }
		catch ( Exception e) { return; }
	}
}
}
