package biss.awt;

import biss.DateLib;
import biss.ObserverSocket;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Date;

/**
 * high level widget to display month overview
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class DatePane
  extends Compound
{
	Date CurDate;
	public ObserverSocket OsDateChanged = new ObserverSocket( this);
	DecoGroup Box = new DecoGroup();
	DayTable Table = new DayTable( this);

public DatePane ( ) {
	this( DateLib.today());
}

public DatePane ( Date d) {
	Lo.add( Box, 0, 0, 1000, 1000, true, 0, 0, 0, 0, 0);
	Lo.add( Table, 0, 0, 1000, 1000, true, 20, 120, -20, -20, 0);

	//	Box.setCarved( true);
	//	Box.setBorder( Border.BS_OUTSET);
	setContents( d);
}

public DatePane ( String edfDate) {
	this( DateLib.dateFromEDF( edfDate));
}

public DatePane ( int day, int month, int year) {
	this( new Date( year, month, day));
}

public Date getCurrentDate () {
	return CurDate;
}

void newMonth(){
	String pre = DateLib.MonthShorts[CurDate.getMonth()]+" "+
	Integer.toString( 1900+CurDate.getYear());
	Box.setName( pre);
	if ( isShowing() ){
		Table.blank();
		Table.redraw();
	}
}

/**
 * triggered by selecting a day from the DayTable
 * parameter: current date
 */
public void notifyChanged(){
	OsDateChanged.notifyObservers( CurDate);
}

public void redraw( Graphics g){
	g.setColor( getBackground() );
	g.fillRect( 0, 0, Width, Height);
}

public void setContents ( Date dt) {
	CurDate = new Date( dt.getTime() );
	DateLib.trim( CurDate);
	Table.newDayTable();
}

public void setContents ( int day, int month, int year) {
	setContents( new Date( year-1900, month-1, day));
}

public void setFont ( Font fnt) {
	Table.setFont( fnt);
}
}

class DayTable
  extends Control
  implements HotKeyProcessor
{
	int[][] DayArray;
	FontMetrics Fm;
	DatePane Master;
	static FontMetrics DefFm;

static {
	DefFm = Awt.getFontMetrics( Awt.ButtonFont);
}

public DayTable ( DatePane master) {
	Master = master;
	setFont( null);
	addHotKey( 'n', HotKey.Control, this, "next");
	addHotKey( 'p', HotKey.Control, this, "prev");
}

public void mouse1Down (Event evt) {

	int cw  = 2*Fm.charWidth( '0');
	int cd  = (Width-7*cw)/8;
	int rh  = Fm.getHeight();
	int rd  = (Height-7*rh)/8;
	int xIdx = Math.min( evt.x/(cw+cd), 6);
	int yIdx = Math.min( (evt.y-rh-rd)/(rh+rd), 5 );
	int dn;

	if ( (dn=DayArray[xIdx][yIdx])!=0) {
		Master.CurDate.setDate( dn);
		Master.notifyChanged();
		redraw();
	} 
}

void newDayTable(){
	DayArray = DateLib.getDayArray( Master.CurDate.getMonth()+1,
	                                Master.CurDate.getYear() );
	Master.newMonth();
}

public void paint( Graphics g) {
	blank( g);
	redraw( g);
}

public void processKey (Object sel) {
	Date d = Master.CurDate;
	int mn = d.getMonth();

	if ( sel.equals( "next"))
		Master.CurDate = DateLib.nextDay( d);
	else if ( sel.equals( "prev"))
		Master.CurDate = DateLib.prevDay( d);

	if ( mn!=Master.CurDate.getMonth() )
		newDayTable();
	else
		redraw();

	Master.notifyChanged();
}

public void redraw ( Graphics g) {

	int zw  = Fm.charWidth( '0');
	int cw  = 2*zw;
	int cd  = (Width-7*cw)/8;
	int dc  = Fm.getDescent();
	int rh  = Fm.getHeight();
	int rd  = (Height-7*rh)/8;
	int dn, dof, dim = DateLib.dayInMonth( Master.CurDate);

	g.setColor( Color.blue);
	for ( int dy=0; dy<7; dy++)
		g.drawString( DateLib.DayShorts[dy], cd+dy*(cw+cd), rd+rh-dc);

	for ( int dy=0; dy<7; dy++) {
		for ( int wk=0; wk<6; wk++) {
			if ( (dn=DayArray[dy][wk])!=0){
				if ( dn<10) dof=zw;
				else        dof = 0;
				if (dn==dim) g.setColor( Color.green);
				else if ( dy==6) g.setColor( Color.red);
				else g.setColor( Color.black);
				g.drawString( Integer.toString(dn), dof+cd+dy*(cd+cw), (wk+2)*(rd+rh)-dc );
			}
		}
	}
}

public void setFont ( Font fnt) {
	Font uf = ( fnt != null) ? fnt : Awt.ButtonFont;
	super.setFont( uf);

	if ( uf.equals( Awt.ButtonFont))
		Fm = DefFm;
	else
		Fm = Awt.getFontMetrics( uf);

	if ( isShowing() )
		redraw();
}
}
