package biss.awt;

import biss.awt.Control;
import biss.awt.LineBuffer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.util.Vector;

/**
 * static text widget replacing java.awt.Label
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class Label
  extends Control
  implements LabelPeer
{
	protected FontMetrics Fm;
	protected int HAlign;
	protected boolean WrapMode = false;
	protected String Text;
	protected Vector Tokens = new Vector(2);
	protected int Type;
	protected int VAlign;
	public static int DefaultBorderStyle = Border.BS_INSET;
	final public static int FT_CARVED = 1;
	final public static int FT_PLAIN = 0;
	final public static int HA_CENTER = java.awt.Label.CENTER;
	final public static int HA_LEFT = java.awt.Label.LEFT;
	final public static int HA_RIGHT = java.awt.Label.RIGHT;
	final public static int VA_BOTTOM = 3;
	final public static int VA_CENTER = 2;
	final public static int VA_TOP = 1;
	protected boolean Carved;
	public static boolean DefaultCarved = true;
	static FontMetrics DefFm;

static {
	DefFm = Awt.getFontMetrics( Awt.StaticFont);
}

public Label () {
	this( "", -1, -1, Awt.StaticForeClr, null, null, DefaultCarved);
}

public Label ( String text ) {
	this( text, -1, -1, Awt.StaticForeClr, null, null, DefaultCarved);
}

public Label ( String text, int hAlign, int vAlign, Color cf,
        Color cb, Font fnt, boolean carved){
	Text   = text;
	HAlign = ((hAlign > 0) && (hAlign < 4)) ? hAlign : HA_LEFT;
	VAlign = ((vAlign > 0) && (vAlign < 4)) ? vAlign : VA_CENTER;
	Carved    = carved;

	setFont( fnt);
	FBorder.setBorder( DefaultBorderStyle);

	setForeground( cf);
	if ( cb != null)
		setBackground( cb);

}

public Label( java.awt.Label peerTarget){
	// create peer object for java.awt.Label
	this( peerTarget.getText() );
	setPeerTarget( peerTarget);
	setAlignment( peerTarget.getAlignment() );
	addNotify();
}

public boolean canGetFocus(){
	return false;
}

public void dontWrapContents () {
	setWrapMode( false);
}

public String getContents () {
	return Text;
}

public int lines(){
	return Tokens.size();
}

public int minHeight( int width){
	Width = width;
	tokenize();
	return (Tokens.size() * Fm.getHeight() );
}

protected void posChanged(){
	tokenize();
	redraw();
}

public Dimension preferredSize(){
	int i, n = Tokens.size();
	int h = n * Fm.getHeight();
	int w = 0;

	for ( i=0; i<n; i++ )
		w = Math.max( w, Fm.stringWidth( (String)Tokens.elementAt( i) ));

	return new Dimension( w, h);
}

public void redraw( Graphics g){
	int x = 0;
	int y = 0;
	String ln;
	int    fh, fd;

	if ( ! isShowing() )
		return;

	fh = Fm.getHeight();
	fd = Fm.getDescent();

	blank( g);
	clip( g);

	for ( int idx = 0; idx < Tokens.size(); idx++){
		ln = (String)Tokens.elementAt( idx);

		switch ( VAlign){
		case VA_TOP:
			y = (idx + 1) * fh - fd;
			break;
		case VA_CENTER:
			y = ((Height - Tokens.size() * fh) / 2) + ((idx + 1) * fh) - fd;
			break;
		case VA_BOTTOM:
			y = Height - ((Tokens.size() -idx - 1) * fh) - fd;
			break;
		}

		switch ( HAlign){
		case HA_LEFT:
			x = 2;
			if ( FBorder.Style != 0 )
				x += Awt.BorderWidth;
			break;
		case HA_CENTER:
			x = ( Width - Fm.stringWidth( ln)) / 2;
			break;
		case HA_RIGHT:
			x = Width - Fm.stringWidth( ln) - 2;
			if ( FBorder.Style != 0)
				x -= Awt.BorderWidth;
			break;
		}

		GraphicsLib.drawString( g, ln, x, y, getForeground(), Carved);

	}
}

public void setAlignment( int alignment){
	//java.awt.peer.LabelPeer interface
	setAlignment( alignment, VAlign);
}

public void setAlignment( int hAlign, int vAlign ) {
	HAlign = ((hAlign > 0) && (hAlign < 4)) ? hAlign : HA_CENTER;
	VAlign = ((vAlign > 0) && (vAlign < 4)) ? vAlign : VA_CENTER;
}

public void setCarved (boolean c) {
	Carved = c;
	if ( isShowing() )
		redraw();
}

public void setContents ( String text ) {
	Text = text;
	tokenize();
	if ( isShowing() )
		redraw();
}

public static void setDefaultBorderStyle ( int style ) {
	DefaultBorderStyle = style;
}

public static void setDefaultCarved ( boolean c ) {
	DefaultCarved = c;
}

public synchronized void setFont( Font fnt) {
	Font uf = ( fnt != null) ? fnt : Awt.StaticFont;

	super.setFont( uf);

	if ( uf.equals( Awt.StaticFont))
		Fm = DefFm;
	else
		Fm = Awt.getFontMetrics( uf);

	if ( Text != null ) {
		tokenize();
		redraw();
	}
}

public void setText( String label){
	//java.awt.peer.LabelPeer interface
	setContents( label);
}

void setWrapMode ( boolean state ){
	if ( WrapMode != state) {
		WrapMode = state;
		if ( isShowing() ){
			tokenize();
			redraw();
		}
	}
}

protected void tokenize(){
	LineBuffer lb = new LineBuffer( Fm);
	int    lep = 0;

	Tokens.removeAllElements();

	if ( Text == null || Text.length() == 0 )
		return;

	if ( !WrapMode) {
		Tokens.addElement( Text);
		return;
	}

	for ( int i= 0; i<Text.length(); i++){
		char c = Text.charAt( i);
		if ( c == '\n'){
			Tokens.addElement( lb.asString());
			lb.free();
			lep = 0;
		}
		else {
			if ( c == ' ')
				lep = lb.Len;
			lb.append( c);
			if ( lb.posFor( lb.Len) > Width){
				i -= lb.Len - lep - 1;
				lb.setLen( lep);
				Tokens.addElement( lb.asString() );
				lb.free();
				lep = 0;
			}
		}
	}

	if ( lb.Len > 0)
		Tokens.addElement( lb.asString());

}

public void wrapContents () {
	setWrapMode( true);
}
}
