package biss.awt;

import java.util.Observable;

/**
 * logical view for generic String propmting dialogs
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class PromptViewer
  extends DialogWindow
{
	TextField Entry = new TextField();
	Label TP = new Label();

public PromptViewer( String title, String text, String cont, TopWindow owner){
	super( title, owner);

	Lo.add( TP,    0, 0,    1000, 1000, true, 20, 20,   -20, -200, 0);
	Lo.add( Entry, 0, 1000, 1000, 1000, true, 20, -180, -20, -20,  0);

	Entry.setContents( cont);
	Entry.FBorder.setBorder( Border.BS_STEP);

	TP.setContents( text);
	TP.wrapContents();
	TP.setCarved( false);
	TP.setBorder( Border.BS_NONE);
	TP.setAlignment( Label.HA_CENTER, Label.VA_CENTER);

	DefComponent = Entry;

	openCentered();

	Entry.OsEnter.addObserver( this);
	Entry.OsReset.addObserver( this);
}

public String getContents(){
	return Entry.getContents();
}

public static void main ( String args[]) {
	new PromptViewer( "My Prompter", "Bitte jetzt irgendwas eingeben", "ok", null);
}

public void openCentered(){
	int tw = 19 * Awt.DlgXUnit; 
	int ww = 20 * Awt.DlgXUnit;
	int mh = TP.minHeight( tw );

	packClient( ww, mh + 3*Awt.DlgYUnit);
	super.openCentered();
}

public void update( Observable o, Object arg){
	if ( o == Entry.OsEnter ) {
		process();
	}
	else if ( o == Entry.OsReset ) {
		dispose();
	}

	super.update( o, arg);
}
}
