# [.mk]beforedir.mms

INCDIR = include
IDLDIR = idl
MAKEDIR = mk
BINDIR = bin.$(platform)
LIBDIR = lib.$(platform)
CORBA_STUB_DIR = $(top)stub]
CORBA_IDL_DIR = $(top)idl]

.ifdef DEBUG
DebugSuffix=D
.endif

ShareableImageSuffix=_rt$(DebugSuffix)

.include $(top)mk.platforms]$(platform).mms

OMNIORB2_LC_LIB = omnilib:omniLC$(DebugSuffix).olb

# define logicals used for abolute paths for #include statements, etc.

FIRSTACTIONS = @$(TOP)mk]firstactions.dcl "$(TOP)" "$(CURRENT)" \
"$(EXPORT_TREE)" "$(IMPORT_TREES)" "$(BINDIR)" "$(PLATFORM)" "$(LIBDIR)"

.ifdef DIR_FIRSTACTIONS

.first
	@ $(FIRSTACTIONS)
	$(DIR_FIRSTACTIONS)

.else

.first
	@ $(FIRSTACTIONS)

.endif

.default
	@ ! allow rules with no action lines

.suffixes : .cc .CC .obj .OBJ .olb .OLB .exe .EXE

.CC.OBJ :
	@ write sys$output "Compiling $(MMS$SOURCE)..."
	$(CXX) $(CXXFLAGS) $(MMS$SOURCE) $(OMNIORB2_CPPFLAGS)$(DIR_CPPFLAGS)
	@ If "''F$Search("$(MMS$TARGET_NAME).DIA")'" .NES. "" Then -
		delete $(MMS$TARGET_NAME).DIA;*
	@ If "''F$Search("$(MMS$TARGET_NAME).OBJ")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).OBJ
	@ If "''F$Search("$(MMS$TARGET_NAME).LIS")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).LIS
	
.OBJ.OLB :
	@ If "''F$Search("$(MMS$TARGET)")'" .EQS. "" Then $(LIBR)/Create $(MMS$TARGET)
	@ $(LIBR)$(LIBRFLAGS) $(MMS$TARGET) $(MMS$SOURCE)
	@ ! assume mms/skip:  once an object has been stored in a library it can
	@ !be removed.
	@ object = f$parse("$(MMS$SOURCE)","","","NAME") + ".OBJ"
	@ if f$search(object) .nes. "" then delete 'object';*

.IFDEF INITIALIZE_MMS
# MMS has no .ifndef statement.
.ELSE

.IFDEF CORBA_INTERFACES
.INCLUDE CORBA_INTERFACES.MMS
.ENDIF

.ENDIF
