.suffixes
# dir.mms for omniLC shared library
#
# Build a shared library in this directory
# **** DO NOT forget to update the $(VERSION) number.
#

# The Version number is constructed as follows:
#    <major version no.>.<minor version no.>.<micro version no.>
#
# The <minor version no.> changes when:
#   1. Public interfaces have been extended but remains backward compatible
#      with earlier minor version.
#   2. Internal interfaces have been changed.
#
# The <micro version no.> changes when the implementation has been changed
# but both the public and internal interfaces remain the same. This usually
# corresponds to a pure bug fix release.
#
# (Note that this is backwards from dir.mk since MMS has no $(word...).

major_version = 2
minor_version = 8
micro_version = 0

VERSION = $(major_version).$(minor_version).$(micro_version)

# assume that the parent directory is built and that therefore
# $(libpath)omniLC$(DebugSuffix).olb exists.

staticlib=[-]omniLC$(DebugSuffix).olb
shareableimage=omniLC$(ShareableImageSuffix).exe
exportshareableimage=$(libpath)$(shareableimage)

OBJ_LIBS = \
omnilib:omni_share$(DebugSuffix).olb/include=(\
omnithread$(ShareableImageSuffix),\
omniORB2$(ShareableImageSuffix),\
omniDynamic2$(ShareableImageSuffix))

OBJ_LIBS_DEPEND = \
$(libpath)omni_share$(DebugSuffix).olb(omnithread$(ShareableImageSuffix)) \
$(libpath)omni_share$(DebugSuffix).olb(omniORB2$(ShareableImageSuffix)) \
$(libpath)omni_share$(DebugSuffix).olb(omniDynamic2$(ShareableImageSuffix))

all :: $(shareableimage)

$(shareableimage) : $(staticlib) $(OBJ_LIBS_DEPEND)
	$(CxxShareableImage)

export :: all
export :: $(exportshareableimage)

$(exportshareableimage) : $(shareableimage)
	$(ExportShareable)

veryclean ::
	@- $(RM) $(shareableimage)
	@- $(RM) *.opt *.dat
