// -*- c++ -*-
#ifndef __CTHUGHA_DISPLAY_H
#define __CTHUGHA_DISPLAY_H

#include "CoreOption.h"

// must be initialized AFTER displayDevice

extern xy draw_size;
extern OptionInt zoom;
extern OptionInt maxFramesPerSecond;

extern int display_frames;			/* counter for speed-tests */
extern double displayStart;



class CthughaDisplay {
protected:
    unsigned char * buffer0;
    
    double lastTime;

    void mirrorHorizontally();
    void mirrorVertically();
    int clearBorder();
    void zoom2Screen(unsigned char *, int);
    virtual void expandPalette(int) {}
    void checkFPS();
    void checkZoom();

public:
    unsigned char * buffer;
    int bufferWidth;

    unsigned char * expandedBuffer;
    int expandedBufferWidth;

    int needsClear;				// border must be cleard

    CthughaDisplay();

    virtual void operator()() {}

    double fps;

    const char * status();

    friend int save_display();
};


//
// a special CthughaDisplay for X11
//
class CthughaDisplayX11 : public CthughaDisplay {
    unsigned char * expandedBuffer0;
    virtual void expandPalette(int);
public:
    CthughaDisplayX11();
    virtual void operator()();
};

//
// SVGA is a little bit easier
//
class CthughaDisplaySVGA : public CthughaDisplay {
    void expandPalette(int);
public:
    CthughaDisplaySVGA();
    virtual void operator()();
};

//
// OpenGL is different
//
class CthughaDisplayGL : public CthughaDisplay {
public:
    virtual void operator()();
};


class ScreenEntry : public  CoreOptionEntry {
public:
    int (*screen)();
    xy size;

    ScreenEntry(int (*f)(), const char * name, const char * desc, xy s, int inUse=1) :
	CoreOptionEntry(name, desc, inUse), screen(f), size(s) {
    }
    
    int operator()() {
	return (*screen)();
    }
};


extern CthughaDisplay * cthughaDisplay;

void newCthughaDisplay();

#endif
