#include "cthugha.h"
#include "DisplayDevice.h"
#include "SoundAnalyze.h"
#include "AutoChanger.h"
#include "cth_buffer.h"
#include "CthughaBuffer.h"
#include "interface.h"
#include "keys.h"
#include "SoundServer.h"
#include "CDPlayer.h"
#include "CthughaDisplay.h"

#include <signal.h>

#include <GL/glut.h>


#ifndef GL_EXT_paletted_texture
#error GL_EXT_paletted_texture not available. 
#endif



xy screenSizes[] = {
    xy(320,200),    xy(640,480),    xy(800,600),
    xy(1024,768),   xy(1152,900),   xy(1200,1024)
};
int nScreenSizes = sizeof(screenSizes) / sizeof(xy);
xy bufferSizes[] = {
    xy(64,64),      xy(128,128),    xy(256,256),
    xy(256,256),    xy(512,512),    xy(512,512)
};
int nBufferSizes = sizeof(bufferSizes) / sizeof(xy);


int GLkey = 0;

int cth_init(int * argc, char * argv[]) {
    glutInit(argc, argv);

    ncurses_use = DisplayDevice::text_on_term;

    CthughaBuffer::maxNBuffers = 3;

    return 0;
}



//
// display using OpenGL
//
class DisplayDeviceGL : public DisplayDevice  {
protected:
    GLuint Window;

    int setGlobalPalette() {
	return DisplayDevice::setGlobalPalette();
    }


    static void keyCB(unsigned char k, int , int ) {
	switch(k) {
	case 27:		GLkey = CK_ESC;		break;
	case 10: case 13:	GLkey = CK_ENTER;	break;
	default:		GLkey = k;
	} 
    }
    static void specialKeyCB(int k, int, int) {
	switch(k) {
	case 27:		GLkey = CK_ESC;		break;
	case GLUT_KEY_F1:	GLkey = CK_FKT(1);	break;
	case GLUT_KEY_F2:	GLkey = CK_FKT(2);	break;
	case GLUT_KEY_F3:	GLkey = CK_FKT(3);	break;
	case GLUT_KEY_F4:	GLkey = CK_FKT(4);	break;
	case GLUT_KEY_F5:	GLkey = CK_FKT(5);	break;
	case GLUT_KEY_F6:	GLkey = CK_FKT(6);	break;
	case GLUT_KEY_F7:	GLkey = CK_FKT(7);	break;
	case GLUT_KEY_F8:	GLkey = CK_FKT(8);	break;
	case GLUT_KEY_F9:	GLkey = CK_FKT(9);	break;
	case GLUT_KEY_F10:	GLkey = CK_FKT(10);	break;
	case GLUT_KEY_F11:	GLkey = CK_FKT(11);	break;
	case GLUT_KEY_F12:	GLkey = CK_FKT(12);	break;
	    
	case GLUT_KEY_LEFT:	GLkey = CK_LEFT;	break;
	case GLUT_KEY_UP:	GLkey = CK_UP;		break;
	case GLUT_KEY_RIGHT:	GLkey = CK_RIGHT;	break;
	case GLUT_KEY_DOWN:	GLkey = CK_DOWN;	break;
	case GLUT_KEY_PAGE_UP:	GLkey = CK_PGUP;	break;
	case GLUT_KEY_PAGE_DOWN: GLkey = CK_PGDN;	break;
	case GLUT_KEY_HOME:	GLkey = CK_HOME;	break;
	case GLUT_KEY_END:	GLkey = CK_END;		break;
	    
	default:		GLkey = CK_NONE;
	} 
    }

    static void reshapeCB(int width, int height) {
	disp_size.x = width;
	disp_size.y = height;

	glViewport(0,0, (GLint)width, (GLint)height);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(60, double(width)/double(height), 0.1, 40.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
    }
    
    static void idleCB() {
	(*soundDevice)();
	soundAnalyze();
	(*autoChanger)();
	if(soundServer) (*soundServer)();
	CthughaBuffer::run();
	
	(*cdPlayer)();
	
	Interface::current->run();
	
	// this is here to be sure not to interrupt a graphics operation. 
	if(cthugha_pause) {
	    cthugha_pause = 0;
	    
	    exit_sound();				/* and sound */
	    
	    raise(SIGTSTP);				/* default action */
	}
	
	if(cthugha_close) 
	    exit(0);
	
	glutPostRedisplay();
    }

    static void drawCB() {

	glEnable(GL_TEXTURE_2D);
//	glEnable(GL_ALPHA_TEST);
	glEnable(GL_DEPTH_TEST);
//	glEnable(GL_FOG);

	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	
	(*cthughaDisplay)();
	
	// display text
	displayDevice->prePrint();
	Interface::current->display();		// print the text of the current interface
	errors.display();			// and the error messages
	displayDevice->postPrint();
	
	displayDevice->postDraw();
	
	glutSwapBuffers();
	display_frames ++;
    }

public:
    DisplayDeviceGL() : Window(0) {
	printfv(1, "Initializing OpenGL display...\n");

	//
	// set up display size
	//
	if ( display_mode != -1) {
	    /* use one of the default resolutions */
	    if ( (display_mode >= nScreenSizes) || (display_mode < 0))
		display_mode = 0;
	    
	    disp_size = screenSizes[display_mode];
	}
	
	//
	// make main window
	//
	glutInitWindowPosition(0,0);
	glutInitWindowSize(disp_size.x, disp_size.y);
	glutInitDisplayMode(GLUT_RGB | GLUT_DEPTH | GLUT_DOUBLE);
	
	if( (Window = glutCreateWindow("GLCthugha")) == 0) {
	    printfe("Can not create GLUT window.\n");
	    exit(0);
	}
 	
	glutSetCursor(GLUT_CURSOR_NONE);

	// check if paletted texture is available
	if (!glutExtensionSupported("GL_EXT_paletted_texture")) {
	    printfe("Sorry, GL_EXT_paletted_texture is not available.\n");
	    exit(0);
	}
	

	// 
	// some GL init
	//
	glDisable(GL_DITHER);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	glHint(GL_POLYGON_SMOOTH_HINT, GL_NICEST);
//	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);
//	glHint(GL_POLYGON_SMOOTH_HINT, GL_FASTEST);
    

	glutReshapeFunc(reshapeCB);
	glutIdleFunc(idleCB);
	glutDisplayFunc(drawCB);
	glutKeyboardFunc(keyCB);
	glutSpecialFunc(specialKeyCB);


	fontSize.x = 11;
	fontSize.y = 15;
    }

    virtual void printstring(void * font, const char * string, int len) {
	while( (*string != '\0') && (len > 0)) {
	    glutStrokeCharacter(font, *string);
	    string ++;
	    len --;
	}
    }

    virtual void prePrint() {
	DisplayDevice::prePrint();
	
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_ALPHA_TEST);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_FOG);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0.0, disp_size.x * 10.0,
		0.0, disp_size.y * 10.0, 
		-1.0, 1.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
    }

    virtual void printString(int x, int y, const char * text, int color, int len, int ) {

	glColor4f(double(textColorRGB[color][0])/255.0,
		  double(textColorRGB[color][1])/255.0,
		  double(textColorRGB[color][2])/255.0,
		  0.0);

	glPushMatrix();

	glTranslatef(10 * x, 10 * (disp_size.y - 15 - y), 0);

	printstring(GLUT_STROKE_MONO_ROMAN, text, len);

	glPopMatrix();
    }

    virtual void postPrint() {
	reshapeCB(disp_size.x, disp_size.y);
    }



    void mainLoop() {
	glutMainLoop();
    }
};




void newDisplayDevice() {
    displayDevice = new DisplayDeviceGL();
}

