/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void FIpreem (double a, float *Fmem, const float x[], float y[], int Nout)

Purpose:
  Preemphasize a signal using a first difference filter

Description:
  The procedure processes an input signal using a first difference filter.  The
  output is formed as follows.
    y[n] = x[n] - a * x[n-1] .
  The preemphasis factor pre is zero for no filtering and equal to one for a
  full first difference.  The filter memory Fmem is used to store the previous
  input value.  Before processing any data, it is typically set to zero.  On
  return, Fmem is equal to the last input data element processed.  For block
  processing of a signal, the value of Fmem from one call is suitable as input
  to the next call.

Parameters:
   -> double a
      Preemphasis factor
  <-> float *Fmem
      Filter memory value. Fmem should be set to the value of the data sample
      immediately preceding the data in the array x.  On return it is set to
      the last input value processed (x[Nout-1]).  For block processing of a
      signal, the value returned from one invocation is suitable as input for
      the next invocation.
   -> const float x[]
      Input array of Nout data values.
  <-  float y[]
      Output array of Nout values.  This array can share storage with x.
   -> int Nout
      Number of output samples to be calculated

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.5 $  $Date: 1995/06/08 05:45:41 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: FIpreem.c 1.5 1995/06/08 libtsp-v3r0 $";

#include <libtsp.h>

void
FIpreem (a, Fmem, x, y, Nout)

     double a;
     float *Fmem;
     const float x[];
     float y[];
     int Nout;

{
  int i;
  float c;
  float temp;
  float Fm;

  /* Loop over the samples */
  c = a;
  Fm = *Fmem;
  for (i = 0; i < Nout; ++i) {
    temp = x[i];
    y[i] = temp - c * Fm;
    Fm = temp;
  }

  /* New filter memory value */
  *Fmem = Fm;
}
