.TH logm 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
logm - square matrix logarithm
.SH CALLING SEQUENCE
.nf
y=logm(x)
.fi
.SH PARAMETERS
.TP 10
x
: square matrix
.SH DESCRIPTION
 \fVlogm(x)\fR is the matrix logarithm of \fVx\fR.
The result is complex if \fVx\fR is not positive or definite positive.
If \fVx\fR is a  symmetric matrix, then calculation is made by
schur form. Otherwise, \fVx\fR is assumed diagonalizable. One has
\fVexpm(logm(x))=x\fR 
.SH EXAMPLE
.nf
A=[1,2;3,4];
logm(A)
expm(logm(A))
A1=A*A';
logm(A1)
expm(logm(A1))
A1(1,1)=%i;
expm(logm(A1))
.fi 
.SH SEE ALSO
expm, log

