.TH gen_net 1 "September 1996" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
gen_net - generation of a network
.SH CALLING SEQUENCE
.nf
g = gen_net(name,directed,v)
g = gen_net()
.fi
.SH PARAMETERS
.TP 5
name
: string, the name of the graph
.TP 9
directed
:  integer, 0 (undirected graph) or 1 (directed graph)
.TP 3
v
: row vector with 12 values for defining the network
.TP 2
g
: graph list
.SH DESCRIPTION
\fVgen_net\fR generates a network \fVg\fR.
The arguments are the name of the graph, a flag equal to 0
(undirected graph) or  to 1 (directed graph) and a vector describing
the network (see below).

If no argument are given, a dialog box for the definition
of all the arguments is opened.

\fVv\fR must be a row vector with 12 values.
The meaning of the values are:

Seed for random: used for initialization of random generation

Number of nodes

Number of sources

Number of sinks

Minimum cost

Maximum cost

Input supply

Output supply

Minimum capacity

Maximum capacity

Percentage of edges with costs: between 0 and 100

Percentage of edges with capacities: between 0 and 100

The cost of edges without cost are put to minimum cost.
The maximum capacity of edges without capacity are put to maximum upply

The result is a network \fVg\fR built on a planar connected graph, by using a
triangulation method. Moreover, computations are made in order to have
a coherent network. Values of costs and maximum capacities are
put on the edges. Minimum capacities are reduced to 0.
.SH EXAMPLE
.nf
v=[1,10,2,1,0,10,100,100,0,100,50,50];
g=gen_net('foo',1,v);
show_graph(g)
// generating using dialogs
g=gen_net();
show_graph(g)
.fi
.SH SEE ALSO
mesh2d
