.TH invr 8 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
invr - inversion of (rational) matrix
.SH CALLING SEQUENCE
.nf
F = invr(H)
.fi
.SH PARAMETERS
.TP
H
: polynomial or rational matrix
.TP
F
: polynomial or rational matrix
.SH DESCRIPTION
If \fVH\fR is a polynomial or rational function matrix, \fVinvr\fR
computes \fVH^(-1)\fR using Leverrier's algorithm (see function code)
.SH EXAMPLE
.nf
s=poly(0,'s')
H=[s,s*s+2;1-s,1+s]; invr(H)
[Num,den]=coffg(H);Num/den
H=[1/s,(s+1);1/(s+2),(s+3)/s];invr(H)
.fi
.SH SEE ALSO
glever, coffg, inv
