
/*
 * LIB/MSGID.C
 *
 * (c)Copyright 1997, Matthew Dillon, All Rights Reserved.  Refer to
 *    the COPYRIGHT file in the base directory of this distribution 
 *    for specific rights granted.
 */

#include "defs.h"

Prototype const char *MsgId(const char *s);

/*
 * MsgId() - The message id must begin with a '<', end with a '>', 
 *	     and not contain any embedded '<', space, or TAB.
 *
 *	     Additionally, we require either nul or whitespace terminator
 *	     after the logical end of the message-id.
 *
 *	     WARNING!  Returned storage only good until next MsgId() call!
 */

const char *
MsgId(const char *s)
{
    int i;
    static char *LMsgId;
    const char *badId = "<>";

    if (LMsgId) {
	zfree(&SysMemPool, LMsgId, strlen(LMsgId) + 1);
	LMsgId = NULL;
    }

    if (s == NULL)
	return(badId);

    /*
     * Locate beginning of of message-id
     */
    while (*s && (*s == ' ' || *s == '\t'))
	++s;
    if (*s != '<')
	return(badId);

    /*
     * Locate end of message-id
     */

    for (i = 1; s[i] && s[i] != '>'; ++i) {
	if (s[i] == '<' || s[i] == '\t' || s[i] == ' ')
	    return(badId);
    }

    if (s[i] != '>')
	return(badId);

    /*
     * check length, check for garbage (note: whitespace after msgid 
     * is ok and may indicate a tagged-on comment).
     */

    ++i;
    if (i >= MAXMSGIDLEN)
	return(badId);
    if (s[i] && s[i] != ' ' && s[i] != '\t' && s[i] != '\r' && s[i] != '\n')
	return(badId);

    LMsgId = zalloc(&SysMemPool, i + 1);
    bcopy(s, LMsgId, i);
    LMsgId[i] = 0;
    return(LMsgId);
}

