/******************************************/
/*  WaveGuide Flute ala Karjalainen,      */
/*  Smith, Waryznyk, etc.                 */
/*  with polynomial Jet ala Cook          */
/*  by Perry Cook, 1995-96                */
/*  Recoded for Csound by John ffitch     */
/*  November 1997                         */
/*                                        */
/*  This is a waveguide model, and thus   */
/*  relates to various Stanford Univ.     */
/*  and possibly Yamaha and other patents.*/
/*                                        */
/******************************************/

#if !defined(__Flute_h)
#define __Flute_h

#include "physutil.h"

/**********************************************/
/* Jet Table Object by Perry R. Cook, 1995-96 */
/* Consult Fletcher and Rossing, Karjalainen, */
/*       Cook, more, for information.         */
/* This, as with many other of my "tables",   */
/* is not a table, but is computed by poly-   */
/* nomial calculation.                        */
/**********************************************/

float JetTabl_lookup(float);

typedef struct FLUTE {
    OPDS	h;
    float	*ar;                  /* Output */
    float	*amp, *frequency;
    float	*jetRatio, *attack, *dettack, *noiseGain, *vibFreq;
    float	*vibAmt, *ifn, *lowestFreq; 
    float	*jetRefl;       /* Optional 0.5 */
    float	*endRefl;       /* Optional 0.5 */

    FUNC	*vibr;
    float	v_rate;         /* Parameters for vibrato */
    float	v_time;
/*     float	v_phaseOffset; */
    DLineL	jetDelay;
    DLineL	boreDelay;
    OnePole	filter;
    DCBlock	dcBlock;
    Noise	noise;
    ADSR	adsr;
    float	lastFreq;
    float	lastJet;
    float	maxPress;
    float	vibrGain;
    float	outputGain;
    float	kloop;
    float       lastamp;
} FLUTE;

#endif
