	/*	Envelope follower by Paris Smaragdis	*/
	/*	Berklee College of Music Csound development team */
	/*	Copyright (c) August 1994.  All rights reserve */
	/*	Improvements 1999 John ffitch */

#include "cs.h"
#include <math.h>
#include "follow.h"

void flwset(FOL *p)
{
    p->wgh = p->max = 0.0f;
    p->length = (long)(*p->len * esr);
    if (p->length<=0) {           /* RWD's suggestion */
      initerror("\nError: follow - zero length!\n");
      p->length = (long)esr;
    }
    p->count = p->length;
}

                                /* Use absolute value rather than max/min */
void follow(FOL *p)
{
    long	n = ksmps;
    float	*in = p->in, *out = p->out;
    float	max = p->max;
    long        count = p->count;
    do {
      float sig = *++in;
      if (sig > max) max = sig;
      else if (sig < -max) max = -sig;
      if (--count == 0L)	{
	p->wgh = max;
	max = 0.0f;
	count = p->length;
      }
      *out++ = p->wgh;
    } while (--n);
    p->max = max;
    p->count = count;
}
