/*******************************************/
/*  Marimba SubClass of Modal4 Instrument, */
/*  by Perry R. Cook, 1995-96              */ 
/*                                         */
/*   Controls:               stickHardness */
/*                           strikePosition*/
/*		             vibFreq       */
/*		             vibAmt        */
/*******************************************/

#if !defined(__Marimba_h)
#define __Marimba_h
#include "modal4.h"

typedef struct Marimba {
    OPDS	h;
    float	*ar;                  /* Output */
    float	*amplitude, *frequency;
    float	*hardness, *spos, *ifn;
    float	*vibFreq, *vibAmt, *ivfn, *dettack;

/* Modal4 */
    Modal4	m4;
    int		multiStrike;  
    float	strikePosition;
    float 	stickHardness;
    int		kloop;
} MARIMBA;

/* void marimbaset(MARIMBA*); */
/* void marimba(MARIMBA*); */

#endif
