/*
 * $Id: version.h,v 1.48 1999/04/30 14:15:59 nicb Exp $
 *
 * Csound Linux source version.h replacement
 *
 * Since quite a lot of things (including configuration processes, etc.)
 * rely on the format of this file to run properly, we have replaced
 * the standard version.h (which was sitting in the canonical directory)
 * with this one (future patches should be easy, anyway, and we will have
 * better control on what happens in this file)
 * 					[nicb@axnet.it]
 */
#if !defined(_new_src_version_h_)
#	define _new_src_version_h_

/*
 * Please do *not* put parenthesis around the numbers (yes, I know it's
 * common practice to avoid unwanted precedence assignements on mathematical
 * operators, but here it breaks the delicate stringing mechanism of the
 * version numbering	
 * 					[nicb@axnet.it]
 */

/*
 * the first two numbers are defined by the canonical source version
 * numbering
 */

# define VERSION 3
# define SUBVER  "53.0"

/*
 * the third value (*MUST* be a string) is the current Linux patchlevel for
 * the canonical version. At the moment, this is unique to this distribution.
 */

# define LINUX_PATCHLEVEL "1d"

/*
 * Do not touch the preprocessor code below here unless you know what you're
 * doing - it's a fairly delicate piece of hack (which probably means it's
 * also fairly ugly, but I have no other ideas) and it breaks easily. Mind
 * you, it respects cpp ansi standards (including collating adjacent strings
 * in C code) - if it does not work for you, it means you don't have an
 * ansi-compliant C compiler (would'nt you give gcc a try?)...
 * 					[nicb@axnet.it]
 */

# define VERSION_STRINGED_VARIABLE(a)	#a
# define VERSIONSTRING_COLLATE(M,m,lp) \
	" v" ## VERSION_STRINGED_VARIABLE(M) ## "." ## m ## "." ## lp
# define VERSIONSTRING   VERSIONSTRING_COLLATE(VERSION,SUBVER,LINUX_PATCHLEVEL)

#endif /* !defined(_new_src_version_h_) */
